/**
 * Created by Dave on 11/05/2014.
 */

;
(function ($) {
    $.fn.isOnScreen = function () {

        if (!this.is(":visible")) {
            return false;
        }

        var win = $(window);

        var viewport = {
            top: win.scrollTop(),
            left: win.scrollLeft()
        };
        viewport.right = viewport.left + win.width();
        viewport.bottom = viewport.top + win.height();

        var bounds = this.offset();
        bounds.right = bounds.left + this.outerWidth();
        bounds.bottom = bounds.top + this.outerHeight();

        return (!(viewport.right < bounds.left || viewport.left > bounds.right || viewport.bottom < bounds.top || viewport.top > bounds.bottom));

    };
}(jQuery));

;
(function ($) {
    $.fn.refresh = function () {
        return $(this.selector);
    };
}(jQuery));

;
(function ($) {
    $.fn.dpToast = function () {
        var container;
        if ($("#dp-toasts").length < 1) {
            $("body").append("<div id='dp-toasts'></div>");
            container = $("#dp-toasts");
            container[0].count = 0;
            container.css({
                position: "fixed",
                display: "inline-block",
                bottom: "2vh",
                left: "0px",
                width: "100vw",
                textAlign: "center",
                zIndex: 99999,
                margin: "0 auto"
            });
        } else {
            container = $("#dp-toasts");
        }
        var toastNumber = container[0].count + 1;
        var message = "Error: No Toast Message";
        var timeout = 3000;
        for (var i = 0; i < arguments.length; i++) {
            if (typeof(arguments[i]) == "string" && arguments[i].length > 0) message = arguments[i];
            else if (typeof(arguments[i]) == "number") timeout = arguments[i];
        }
        container.prepend("<div class='dp-toast dp-toast-" + toastNumber + "'>" + message + "</div><div class='dp-toast-" + toastNumber + "-br'></div>");
        var toast = $(".dp-toast-" + toastNumber);
        toast.css({
            display: "inline-block",
            backgroundColor: "rgba(0,0,0,0.9)",
            color: "white",
            padding: "10px 16px",
            borderRadius: "3px",
            margin: "100px auto",
            boxShadow: "0 0 5px rgba(0,0,0,0.5), 0 0 2px rgba(0,0,0,0.5)"
        });
        toast.hide().fadeIn();
        window.setTimeout(function () {
            toast.fadeOut(function () {
                toast.add(".toast-" + toastNumber + "-br").remove();
                if (container.children().size() == 0) container.remove();
            });
        }, timeout);
        container[0].count = toastNumber;
    }
}(jQuery));
