/*

DHTML lemmings(tm)

GNU Copyright (C) 2004 crisp - freesoftware@xs4all.nl

*/

// preload all lemmings
// format: animation type, b = 2 directions s = 1 direction,
//         number of sprites, description, non-selectable indicator
var lem = [];
load_lem('walk', 'b', 8, 'Walker', 0);
load_lem('fall', 'b', 4, 'Faller', 0);
load_lem('climb', 'b', 8, 'Climber', 0);
load_lem('climbtop', 'b', 8, 'Climber', 0);
load_lem('floatstart', 'b', 6, 'Floater', 0);
load_lem('float', 'b', 8, 'Floater', 0);
load_lem('block', 'b', 16, 'Blocker', 0);
load_lem('build', 'b', 16, 'Builder', 0);
load_lem('confused', 'b', 8, 'Builder', 0);
load_lem('bash', 'b', 32, 'Basher', 0);
load_lem('mine', 'b', 24, 'Miner', 0);
load_lem('dig', 'b', 16, 'Digger', 0);
load_lem('explode', 's', 16, 'Flapper', 1);
load_lem('home', 's', 8, 'Homer', 1);
load_lem('splut', 's', 16, 'Splatter', 1);
load_lem('drown', 's', 16, 'Drowner', 1);
load_lem('frie', 's', 14, 'Goner', 1);

// what the different types can do in the grid and for references
// note: 10-19 and 20-29 are for blockers
var lemming_do = new Array();
lemming_do['bash_r']    = [0,1,1,0,0,0,0,0,0,0, 0,1,1,0,0,0,0,0,0,0, 0,1,1,0,0,0,0,0,0,0];
lemming_do['bash_l']    = [0,1,0,1,0,0,0,0,0,0, 0,1,0,1,0,0,0,0,0,0, 0,1,0,1,0,0,0,0,0,0];
lemming_do['build']     = [1,0,0,0,0,0,0,0,0,0, 1,0,0,0,0,0,0,0,0,0, 1,0,0,0,0,0,0,0,0,0];
lemming_do['climb']     = [1,0,0,0,0,0,0,0,0,0, 1,0,0,0,0,0,0,0,0,0, 1,0,0,0,0,0,0,0,0,0];
lemming_do['dig']       = [0,1,1,1,0,0,0,0,0,0, 0,1,1,1,0,0,0,0,0,0, 0,1,1,1,0,0,0,0,0,0];
lemming_do['fall']      = [1,0,0,0,0,1,1,1,1,1, 1,0,0,0,0,1,1,1,1,1, 1,0,0,0,0,1,1,1,1,1];
lemming_do['mine_r']    = [0,1,1,0,0,0,0,0,0,0, 0,1,1,0,0,0,0,0,0,0, 0,1,1,0,0,0,0,0,0,0];
lemming_do['mine_l']    = [0,1,0,1,0,0,0,0,0,0, 0,1,0,1,0,0,0,0,0,0, 0,1,0,1,0,0,0,0,0,0];
lemming_do['walk']      = [1,0,0,0,0,1,1,1,1,1, 1,0,0,0,0,1,1,1,1,1, 1,0,0,0,0,1,1,1,1,1];
lemming_do['drown']     = [0,0,0,0,0,1,0,0,0,0, 0,0,0,0,0,1,0,0,0,0, 0,0,0,0,0,1,0,0,0,0];
lemming_do['frie']      = [0,0,0,0,0,0,1,0,0,0, 0,0,0,0,0,0,1,0,0,0, 0,0,0,0,0,0,1,0,0,0];
lemming_do['block_r']   = [0,0,0,0,0,0,0,0,0,0, 1,1,1,1,1,1,1,1,1,1, 0,0,0,0,0,0,0,0,0,0];
lemming_do['block_l']   = [0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 1,1,1,1,1,1,1,1,1,1];
lemming_do['hole']      = [0,1,1,1,0,0,0,0,0,0, 0,1,1,1,0,0,0,0,0,0, 0,1,1,1,0,0,0,0,0,0];
lemming_do['trap']      = [0,0,0,0,0,0,0,1,0,0, 0,0,0,0,0,0,0,1,0,0, 0,0,0,0,0,0,0,1,0,0];
lemming_do['home']      = [0,0,0,0,0,0,0,0,1,0, 0,0,0,0,0,0,0,0,1,0, 0,0,0,0,0,0,0,0,1,0];
lemming_do['slice']     = [0,0,0,0,0,0,0,0,0,1, 0,0,0,0,0,0,0,0,0,1, 0,0,0,0,0,0,0,0,0,1];
lemming_do['special']   = [0,0,0,0,0,1,1,1,1,1, 1,1,1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,1,1];

var holes = [];
holes['basher_l'] = [
  [7,2],[7,3],[7,4],[7,5],[7,6],[7,7],[7,8],[7,9],[7,10],
  [8,1],[8,2],[8,3],[8,4],[8,5],[8,6],[8,7],[8,8],[8,9],[8,10],
  [9,0],[9,1],[9,2],[9,3],[9,4],[9,5],[9,6],[9,7],[9,8],[9,9],[9,10],
  [10,0],[10,1],[10,2],[10,3],[10,4],[10,5],[10,6],[10,7],[10,8],[10,9],[10,10],
  [11,0],[11,1],[11,2],[11,3],[11,4],[11,5],[11,6],[11,7],[11,8],[11,9],[11,10],
  [12,0],[12,1],[12,2],[12,3],[12,4],[12,5],[12,6],[12,7],[12,8],[12,9],[12,10],
  [13,0],[13,1],[13,2],[13,3],[13,4],[13,5],[13,6],[13,7],[13,8],[13,9],[13,10],
  [14,0],[14,1],[14,2],[14,3],[14,4],[14,5],[14,6],[14,7],[14,8],[14,9],[14,10],
  [15,1],[15,2],[15,3],[15,4],[15,5],[15,6],[15,7],[15,8],[15,9],[15,10]
];
holes['basher_r'] = [
  [7,5],[7,6],[7,7],[7,8],[7,9],[7,10],[7,11],[7,12],[7,13],
  [8,5],[8,6],[8,7],[8,8],[8,9],[8,10],[8,11],[8,12],[8,13],[8,14],
  [9,5],[9,6],[9,7],[9,8],[9,9],[9,10],[9,11],[9,12],[9,13],[9,14],[9,15],
  [10,5],[10,6],[10,7],[10,8],[10,9],[10,10],[10,11],[10,12],[10,13],[10,14],[10,15],
  [11,5],[11,6],[11,7],[11,8],[11,9],[11,10],[11,11],[11,12],[11,13],[11,14],[11,15],
  [12,5],[12,6],[12,7],[12,8],[12,9],[12,10],[12,11],[12,12],[12,13],[12,14],[12,15],
  [13,5],[13,6],[13,7],[13,8],[13,9],[13,10],[13,11],[13,12],[13,13],[13,14],[13,15],
  [14,5],[14,6],[14,7],[14,8],[14,9],[14,10],[14,11],[14,12],[14,13],[14,14],[14,15],
  [15,5],[15,6],[15,7],[15,8],[15,9],[15,10],[15,11],[15,12],[15,13],[15,14]
];
holes['digger'] = [
  [14,3],[14,4],[14,5],[14,6],[14,7],[14,8],[14,9],[14,10]
];
holes['exploder'] = [
  [0,5],[0,6],[0,7],[0,8],[0,9],[0,10],
  [1,4],[1,5],[1,6],[1,7],[1,8],[1,9],[1,10],[1,11],
  [2,3],[2,4],[2,5],[2,6],[2,7],[2,8],[2,9],[2,10],[2,11],[2,12],
  [3,3],[3,4],[3,5],[3,6],[3,7],[3,8],[3,9],[3,10],[3,11],[3,12],
  [4,2],[4,3],[4,4],[4,5],[4,6],[4,7],[4,8],[4,9],[4,10],[4,11],[4,12],[4,13],
  [5,2],[5,3],[5,4],[5,5],[5,6],[5,7],[5,8],[5,9],[5,10],[5,11],[5,12],[5,13],
  [6,1],[6,2],[6,3],[6,4],[6,5],[6,6],[6,7],[6,8],[6,9],[6,10],[6,11],[6,12],[6,13],[6,14],
  [7,1],[7,2],[7,3],[7,4],[7,5],[7,6],[7,7],[7,8],[7,9],[7,10],[7,11],[7,12],[7,13],[7,14],
  [8,1],[8,2],[8,3],[8,4],[8,5],[8,6],[8,7],[8,8],[8,9],[8,10],[8,11],[8,12],[8,13],[8,14],
  [9,1],[9,2],[9,3],[9,4],[9,5],[9,6],[9,7],[9,8],[9,9],[9,10],[9,11],[9,12],[9,13],[9,14],
  [10,0],[10,1],[10,2],[10,3],[10,4],[10,5],[10,6],[10,7],[10,8],[10,9],[10,10],[10,11],[10,12],[10,13],[10,14],[10,15],
  [11,0],[11,1],[11,2],[11,3],[11,4],[11,5],[11,6],[11,7],[11,8],[11,9],[11,10],[11,11],[11,12],[11,13],[11,14],[11,15],
  [12,0],[12,1],[12,2],[12,3],[12,4],[12,5],[12,6],[12,7],[12,8],[12,9],[12,10],[12,11],[12,12],[12,13],[12,14],[12,15],
  [13,0],[13,1],[13,2],[13,3],[13,4],[13,5],[13,6],[13,7],[13,8],[13,9],[13,10],[13,11],[13,12],[13,13],[13,14],[13,15],
  [14,0],[14,1],[14,2],[14,3],[14,4],[14,5],[14,6],[14,7],[14,8],[14,9],[14,10],[14,11],[14,12],[14,13],[14,14],[14,15],
  [15,0],[15,1],[15,2],[15,3],[15,4],[15,5],[15,6],[15,7],[15,8],[15,9],[15,10],[15,11],[15,12],[15,13],[15,14],[15,15],
  [16,1],[16,2],[16,3],[16,4],[16,5],[16,6],[16,7],[16,8],[16,9],[16,10],[16,11],[16,12],[16,13],[16,14],
  [17,1],[17,2],[17,3],[17,4],[17,5],[17,6],[17,7],[17,8],[17,9],[17,10],[17,11],[17,12],[17,13],[17,14],
  [18,1],[18,2],[18,3],[18,4],[18,5],[18,6],[18,7],[18,8],[18,9],[18,10],[18,11],[18,12],[18,13],[18,14],
  [19,2],[19,3],[19,4],[19,5],[19,6],[19,7],[19,8],[19,9],[19,10],[19,11],[19,12],[19,13],
  [20,3],[20,4],[20,5],[20,6],[20,7],[20,8],[20,9],[20,10],[20,11],[20,12],
  [21,5],[21,6],[21,7],[21,8],[21,9],[21,10]
];
holes['miner_l'] = [
  [4,4],[4,5],[4,6],[4,7],[4,8],[4,9],[4,10],[4,11],[4,12],
  [5,3],[5,4],[5,5],[5,6],[5,7],[5,8],[5,9],[5,10],[5,11],[5,12],
  [6,2],[6,3],[6,4],[6,5],[6,6],[6,7],[6,8],[6,9],[6,10],[6,11],[6,12],
  [7,2],[7,3],[7,4],[7,5],[7,6],[7,7],[7,8],[7,9],[7,10],[7,11],[7,12],
  [8,2],[8,3],[8,4],[8,5],[8,6],[8,7],[8,8],[8,9],[8,10],[8,11],[8,12],
  [9,2],[9,3],[9,4],[9,5],[9,6],[9,7],[9,8],[9,9],[9,10],[9,11],[9,12],
  [10,2],[10,3],[10,4],[10,5],[10,6],[10,7],[10,8],[10,9],[10,10],[10,11],[10,12],
  [11,2],[11,3],[11,4],[11,5],[11,6],[11,7],[11,8],[11,9],[11,10],[11,11],[11,12],
  [12,2],[12,3],[12,4],[12,5],[12,6],[12,7],[12,8],[12,9],[12,10],[12,11],[12,12],
  [13,2],[13,3],[13,4],[13,5],[13,6],[13,7],[13,8],[13,9],[13,10],[13,11],[13,12],
  [14,3],[14,4],[14,5],[14,6],[14,7],[14,8],[14,9],
  [15,4],[15,5],[15,6],[15,7],[15,8],[15,9]
];
holes['miner_r'] = [
  [4,3],[4,4],[4,5],[4,6],[4,7],[4,8],[4,9],[4,10],[4,11],
  [5,3],[5,4],[5,5],[5,6],[5,7],[5,8],[5,9],[5,10],[5,11],[5,12],
  [6,3],[6,4],[6,5],[6,6],[6,7],[6,8],[6,9],[6,10],[6,11],[6,12],[6,13],
  [7,3],[7,4],[7,5],[7,6],[7,7],[7,8],[7,9],[7,10],[7,11],[7,12],[7,13],
  [8,3],[8,4],[8,5],[8,6],[8,7],[8,8],[8,9],[8,10],[8,11],[8,12],[8,13],
  [9,3],[9,4],[9,5],[9,6],[9,7],[9,8],[9,9],[9,10],[9,11],[9,12],[9,13],
  [10,3],[10,4],[10,5],[10,6],[10,7],[10,8],[10,9],[10,10],[10,11],[10,12],[10,13],
  [11,3],[11,4],[11,5],[11,6],[11,7],[11,8],[11,9],[11,10],[11,11],[11,12],[11,13],
  [12,3],[12,4],[12,5],[12,6],[12,7],[12,8],[12,9],[12,10],[12,11],[12,12],[12,13],
  [13,3],[13,4],[13,5],[13,6],[13,7],[13,8],[13,9],[13,10],[13,11],[13,12],[13,13],
  [14,6],[14,7],[14,8],[14,9],[14,10],[14,11],[14,12],
  [15,6],[15,7],[15,8],[15,9],[15,10],[15,11]
];

function Lemming(i,top,left) {

  this.countdown = -1;
  this.anicounter = 0;
  this.counter = null;
  this.top = top;
  this.left = left;
  this.curleft = 32;
  this.dir = 'r';
  this.dx = 2;
  this.ani = 'fall';
  this.maxleft = lem['fall']['num'];
  this.floater = 0;
  this.climber = 0;

  var l = document.createElement('div');
  l.number = i;
  l.className = 'lemming';
  l.style.top = top+'px';
  l.style.left = left+'px';
  if (ie) {
    var p = document.createElement('img');
    p.className = 'lemming';
    p.src = lem['fall']['r'].src;
    p.style.width = -lem['fall']['num']+32+'px';
    l.appendChild(p);
    this.img = p;
    this.imgpos = p.style;
  } else {
    l.style.backgroundImage = lem['fall']['r'];
  }
  l.onmouseover = lemming_target_on;
  l.onmouseout = lemming_target_off;
  l.onmousedown = lemming_target_sel;

  this.container = l;
  this.pos = l.style;

  playground.appendChild(l);

}

Lemming.prototype.changeAnimation = function(ani) {

  this.ani = ani;
  this.curleft = 32;
  this.anicounter = 0;
  if (ie) {
    this.img.src = lem[ani][this.dir].src;
    this.imgpos.left = '0px';
    this.imgpos.width = -lem[ani]['num']+32+'px';
  } else {
    this.pos.backgroundImage = lem[ani][this.dir];
    this.pos.backgroundPosition = '0px';
  }
  this.maxleft = lem[ani]['num'];

}

Lemming.prototype.changeDirection = function() {

  this.dir = this.dir == 'r'? 'l':'r';
  this.dx = -this.dx;
  if (ie) {
    this.img.src = lem[this.ani][this.dir].src;
  } else {
    this.pos.backgroundImage = lem[this.ani][this.dir];
  }

}

Lemming.prototype.remove = function() {

  var i = this.container.number;
  if (lemming_targetted == i) {
    lemming_targetted = -1;
    target.style.visibility = 'hidden';
    status_message(0);
  }
  this.removecounter();
  playground.removeChild(this.container);  
  delete lemmings[i];

}

Lemming.prototype.startcountdown = function() {

  var c = document.createElement('div');
  c.className = 'countdown';
  c.style.top = (this.top-4) + 'px';
  c.style.left = (this.left+14) + 'px';
  var textNode = document.createTextNode('5');
  c.appendChild(textNode);
  playground.appendChild(c);
  this.counter = c;
  this.cpos = c.style;
  this.countdown = 125;

}

Lemming.prototype.removecounter = function() {

  this.countdown = -1;
  if (this.counter !== null) {
    playground.removeChild(this.counter);  
    delete this.cpos
    this.counter = null;
  }

}