<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dz="http://dict.leo.org" version="1.0"><xsl:output indent="yes" method="html"/><xsl:variable name="_l_from" select="'Englisch'"/><xsl:param name="_from" select="'en'"/><xsl:variable name="_l_to" select="'Deutsch'"/><xsl:param name="_to" select="'de'"/><xsl:param name="mode" select="''"/><xsl:param name="side" select="1"/><xsl:param name="size" select="0"/><xsl:param name="jsObject" select="''"/><xsl:param name="search" select="0"/><xsl:param name="ajax" select="1"/><xsl:param name="value" select="''"/><xsl:param name="delete" select="0"/><xsl:param name="debug" select="1"/><xsl:param name="jsDebug" select="0"/><xsl:param name="cssDebug" select="0"/><xsl:param name="translate" select="0"/><xsl:param name="__max" select="8"/><xsl:param name="__add" select="4"/><xsl:decimal-format name="es" decimal-separator="," grouping-separator="."/><xsl:variable name="numberFormat">#.###,00</xsl:variable><xsl:strip-space elements="*"/><xsl:preserve-space elements="repr i small b sup small"/><xsl:variable name="browserEngine" select="unknown"/><xsl:variable name="servername">spda</xsl:variable><xsl:template match="info">
				<xsl:if test="@leorendertarget=1">
					<xsl:apply-templates select="." mode="index"/>
				</xsl:if>
				<xsl:if test="not(@leorendertarget=1)">
					<xsl:if test="$mode='tab' or $mode='tab-expand' or $mode='tab-content' or $mode='table' or $mode='table-expand' or $mode='table-content' or $mode='plot' or $mode='plot-expand' or $mode='plot-content' or $mode='treeview' or $mode='treeview-content' or $mode='tree' or $mode='treeview-expand' or $mode='tree-content' or $mode='select' or $mode='folder' or $mode='folder-content' or $mode='folder-expand' or $mode='select-content' or $mode='list-content' or $mode='view' or $mode='edit' or $mode='inputAppend' or $mode='edit-content' or $mode='search_select' or $mode='search_checkbox' or $mode='listview' or $mode='listview-expand' or $mode='listview-content'  or $mode='removelist-content'  or $mode='drilling-expand' or $mode='addlist-content' or $mode='drilling' or $mode='drilling-content' or $mode='simple' or $mode='checkboxlist' or $mode='checkboxlist-content' or $mode='multiselect' or $mode='multiselect-content' ">
						
						<xsl:apply-templates select="//*[@leorendertarget=1]"/>
					</xsl:if>
					<xsl:if test="not($mode='tab' or $mode='tab-expand' or $mode='tab-content' or $mode='table' or $mode='table-expand' or $mode='table-content' or $mode='plot' or $mode='plot-expand' or $mode='plot-content' or $mode='treeview' or $mode='treeview-content' or $mode='tree' or $mode='treeview-expand' or $mode='tree-content' or $mode='select' or $mode='folder' or $mode='folder-content' or $mode='select-content' or $mode='list-content' or $mode='inputAppend' or $mode='view' or $mode='edit-content' or $mode='search_select' or $mode='search_checkbox'  or $mode='listview-expand' or $mode='listview' or $mode='listview-content'  or $mode='drilling'  or $mode='drilling-expand' or $mode='drilling-content' or $mode='edit' or $mode='simple' or $mode='checkboxlist' or $mode='checkboxlist-content' or $mode='multiselect' or $mode='multiselect-content' )">
						
						<xsl:apply-templates select="//*[@leorendertarget='1']" mode="index"/>
					</xsl:if>
				</xsl:if>
			</xsl:template><xsl:template match="/additionalInfo">
		<div xmlns:xsl="http://www.w3.org/1999/XSL/Transform" data-dz-role="result">
			<div class="addInfo">
				
				<div class="section ui-helper-clearfix">
					<table class="tblf2">
						<colgroup>
							<col style="width:auto"/>
							<col style="width:auto"/>
						</colgroup>
						<thead class="h3 bg-darkyellow">
							<tr>
								<th colspan="2">
									<xsl:text>Rückverlinkung</xsl:text>
								</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td data-dz-attr="relink" class="tblf1-text">
									
									<xsl:variable name="sizeA" select="count(./side[position() = '1']/search/word)"/>
									<xsl:for-each select="./side[position() = '1']/search/word">
										<xsl:call-template name="word">
											<xsl:with-param name="wordValue" select="."/>
										</xsl:call-template>
										<xsl:if test="position() &lt; $sizeA">
											<xsl:text>, </xsl:text>
										</xsl:if>
									</xsl:for-each>
									
									<xsl:text> </xsl:text>
								</td>
								<td data-dz-attr="relink" class="tblf1-text">
									
									<xsl:variable name="sizeB" select="count(./side[position() = '2']/search/word)"/>
									<xsl:for-each select="./side[position() = '2']/search/word">
										<xsl:call-template name="word">
											<xsl:with-param name="wordValue" select="."/>
										</xsl:call-template>
										<xsl:if test="position() &lt; $sizeB">
											<xsl:text>, </xsl:text>
										</xsl:if>
									</xsl:for-each>
									
									<xsl:text> </xsl:text>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				
				
				<div class="section ui-helper-clearfix">
					<table class="tblf2">
						<colgroup>
							<col style="width:150px"/>
							<col style="width:auto"/>
						</colgroup>
						<thead class="h3 bg-darkyellow">
							<tr>
								<th colspan="2">
									<xsl:call-template name="flags">
										<xsl:with-param name="size" select="22"/>
										<xsl:with-param name="lang" select="side[position() = 1]/@lang"/>
									</xsl:call-template>
									<xsl:text>Informationen zu "</xsl:text>
									<xsl:if test="side[position() = 1]/words/word/cc">
										<xsl:value-of select="side[position() = 1]/words/word/cc/pn"/>
										<xsl:text> </xsl:text>
										<xsl:value-of select="side[position() = 1]/words/word/cc/cs"/>
										<xsl:text> [</xsl:text>
										<xsl:value-of select="side[position() = 1]/words/word/cc/ct"/>
										<xsl:text>]</xsl:text>
									</xsl:if>
									<xsl:if test="not(side[position() = 1]/words/word/cc)">
										<xsl:value-of select="side[position() = 1]/words/word"/>
									</xsl:if>
									<xsl:text>"</xsl:text>
								</th>
							</tr>
						</thead>
						<tbody>
							
							<xsl:apply-templates select="side[position() = 1]/info[not(@content='merk')]" mode="table-list-item"/>
						</tbody>
					</table>
					<table class="tblf2">
						<colgroup>
							<col style="width:150px"/>
							<col style="width:auto"/>
						</colgroup>
						<thead class="h3 bg-darkyellow">
							<tr>
								<th colspan="2">
									<xsl:call-template name="flags">
										<xsl:with-param name="size" select="22"/>
										<xsl:with-param name="lang" select="side[position() = 2]/@lang"/>
									</xsl:call-template>
									<xsl:text>Informationen zu "</xsl:text>
									<xsl:value-of select="side[position() = 2]/words/word"/>
									<xsl:text>"</xsl:text>
								</th>
							</tr>
						</thead>
						<tbody>
							
							<xsl:apply-templates select="side[position() = 2]/info[not(@content='merk') and not(@content='ltec')]" mode="table-list-item"/>
						</tbody>
					</table>
				</div>

				
				<xsl:apply-templates select="side/info" mode="addinfo-extraboxes"/>

				
				<xsl:if test="editorialForumArticles/forumRef/link">
					<div class="section forumResults">
						<xsl:apply-templates select="editorialForumArticles/forumRef" mode="table-head">
							<xsl:with-param name="scope">editorial</xsl:with-param>
						</xsl:apply-templates>
					</div>
				</xsl:if>

				
				<xsl:apply-templates select="//contextSearch/sectionlist/section" mode="section">
					<xsl:with-param name="includeIds" select="0"/>
				</xsl:apply-templates>

				
				<xsl:if test="forumArticles/forumRef/link">
					<div class="section forumResults">
						<xsl:apply-templates select="forumArticles/forumRef" mode="table-head"/>
					</div>
				</xsl:if>
			</div>
		</div>
	</xsl:template><xsl:template name="infobox-content-link">
		
		<xsl:param name="internal" select="0"/>
		<xsl:if test="./@href">
			<a>
				<xsl:attribute name="href"><xsl:value-of select="./@href"/></xsl:attribute>
				<xsl:if test="$internal = 0">
					<xsl:attribute name="target"><xsl:text>_blank</xsl:text></xsl:attribute>
				</xsl:if>
				<xsl:value-of select="."/>
			</a>
		</xsl:if>
		<xsl:if test="not(./@href)">
			<xsl:value-of select="."/>
		</xsl:if>
		<xsl:if test="following-sibling::content or ../following-sibling::contentGroup/content">
			<xsl:text>, </xsl:text>
		</xsl:if>
	</xsl:template><xsl:template name="infobox-content-audiobutton">
		
		<span class="sp spdict s_121139705 icon no-minify" title="Aussprache anhören"> </span>
		<xsl:value-of select="."/>
	</xsl:template><xsl:template match="info[@content='audio']//content" mode="content">
		
		<a href="#" data-dz-rel-audio="{./@href}">
			<xsl:call-template name="infobox-content-audiobutton"/>
		</a>
	</xsl:template><xsl:template match="info[@content='ext']//content" mode="content">
		
		<xsl:call-template name="infobox-content-link">
			<xsl:with-param name="internal" select="0"/>
		</xsl:call-template>
	</xsl:template><xsl:template match="info[@content='flex']//content" mode="content">
		
		<a href="#" data-dz-rel-flect="{./@href}">
			<span class="sp spdict s_2558022912 icon no-minify" title="Flexionstabelle anzeigen"> </span>
			<xsl:value-of select="."/>
		</a>
	</xsl:template><xsl:template match="info[@content='int']//content" mode="content">
		
		<xsl:call-template name="infobox-content-link">
			<xsl:with-param name="internal" select="1"/>
		</xsl:call-template>
	</xsl:template><xsl:template match="info[@content='ltec']//content" mode="content">
		
		<a href="#" data-dz-rel-ltec="{string(.)}">
			<xsl:call-template name="infobox-content-audiobutton"/>
		</a>
	</xsl:template><xsl:template match="info[@content='stroke']//content" mode="content">
		<xsl:if test="./@href">
			<a href="#" data-dz-rel-stroke="{./@href}">
				<xsl:value-of select="."/>
			</a>
		</xsl:if>
		<xsl:if test="not(./@href)">
			<xsl:value-of select="."/>
		</xsl:if>
	</xsl:template><xsl:template match="info[@content='text']//content" mode="content">
		
		<xsl:value-of select="."/>
		<xsl:if test="following-sibling::content or ../following-sibling::contentGroup/content">
			<br/>
		</xsl:if>
	</xsl:template><xsl:template match="info[@source='canoo']" mode="source">
			<a href="http://www.canoo.net/" target="_blank">
				<img src="/img/partners/canoo.gif" width="130" height="30" alt="Canoo" class="no-minify"/>
			</a>
	</xsl:template><xsl:template match="info[@source='cnrtl']" mode="source">
		<a href="http://www.cnrtl.fr/" target="_blank">
			<img src="/img/partners/cnrtl.png" width="130" height="30" alt="Centre National de Ressources Textuelles et Lexicales" class="no-minify"/>
		</a>
	</xsl:template><xsl:template match="info[@source='dwds']" mode="source">
		<a href="http://www.dwds.de/" target="_blank">
			<img src="/img/partners/dwds.png" width="130" height="30" alt="DWDS" class="no-minify"/>
		</a>
	</xsl:template><xsl:template match="info[@source='enpg']" mode="source">
		<a href="http://www.englishpage.com/" target="_blank">
			<img src="/img/partners/epages_logo.jpg" width="45" height="45" alt="EnglishPage" class="no-minify"/>
		</a>
	</xsl:template><xsl:template match="info[@source='etym']" mode="source">
		<a href="http://www.etymonline.com/" target="_blank">
			<img src="/img/partners/oed.gif" width="130" height="30" alt="Online Etymology Dictionary" class="no-minify"/>
		</a>
	</xsl:template><xsl:template match="info[@source='gabler']" mode="source">
			<a href="http://wirtschaftslexikon.gabler.de/" target="_blank">
				<img src="/img/partners/wilex.gif" width="130" height="30" alt="Gablers Wirtschaftslexikon" class="no-minify"/>
			</a>
	</xsl:template><xsl:template match="info[@source='leo']" mode="source">
		<img src="/img/leo-schriftzug-160x60.png" width="80" height="30" alt="LEO" class="no-minify"/>
	</xsl:template><xsl:template match="info[@source='ltec']" mode="source">
		<a href="http://www.linguatec.net/" target="_blank">
			<img src="/img/partners/linguatec.png" width="87" height="30" alt="Vorlesen" class="no-minify"/>
		</a>
	</xsl:template><xsl:template match="info[@source='macm']" mode="source">
		<a href="http://www.macmillandictionary.com/" target="_blank">
			<img src="/img/partners/macmillan.jpg" width="130" height="30" alt="Macmillan Dictionary" class="no-minify"/>
		</a>
	</xsl:template><xsl:template match="info[@source='merk']" mode="source">
		<a href="http://www2.uni-siegen.de/~merk/" target="_blank">
			<img src="/img/partners/finanz.jpg" width="130" height="30" alt="Finanzlexikon" class="no-minify"/>
		</a>
	</xsl:template><xsl:template match="info[@source='mw']" mode="source">
		<a href="http://www.merriam-webster.com/" target="_blank">
			<img src="/img/partners/mw.png" width="45" height="45" alt="Merriam Webster" class="no-minify"/>
		</a>
	</xsl:template><xsl:template match="info[@source='rae']" mode="source">
		<a href="http://www.rae.es/" target="_blank">
			<img src="/img/partners/rae.png" width="130" height="30" alt="Real Academia Española" class="no-minify"/>
		</a>
	</xsl:template><xsl:template match="info[@source='trecc']" mode="source">
		<a href="http://www.treccani.it/" target="_blank">
			<img src="/img/partners/treccani.jpg" width="130" height="45" alt="Treccani, il portale del sapere" class="no-minify"/>
		</a>
	</xsl:template><xsl:template match="info[@label='astroke']" mode="label">
		<xsl:text>Animierte Strichfolgen:</xsl:text>
	</xsl:template><xsl:template match="info[@label='defin']" mode="label">
		<xsl:text>Definition:</xsl:text>
	</xsl:template><xsl:template match="info[@label='defin_ae']" mode="label">
		<xsl:text>Definition (amerikanisch)</xsl:text>
	</xsl:template><xsl:template match="info[@label='defin_be']" mode="label">
		<xsl:text>Definition (britisch)</xsl:text>
	</xsl:template><xsl:template match="info[@label='estroke']" mode="label">
		<xsl:text>Expandierte Strichfolgen:</xsl:text>
	</xsl:template><xsl:template match="info[@label='etym']" mode="label">
		<xsl:text>Etymology</xsl:text>
	</xsl:template><xsl:template match="info[@label='flex']" mode="label">
		<xsl:text>Flexionstabelle</xsl:text>
		<xsl:text> - </xsl:text>
		<xsl:if test="./@stemType = 'verb'">
			<xsl:text>Verb</xsl:text>
		</xsl:if>
		<xsl:if test="./@stemType = 'noun'">
			<xsl:text>Substantiv</xsl:text>
		</xsl:if>
		<xsl:if test="./@stemType = 'adj'">
			<xsl:text>Adjektiv</xsl:text>
		</xsl:if>
	</xsl:template><xsl:template match="info[@label='fingloss']" mode="label">
		<xsl:text>Finanzglossar</xsl:text>
	</xsl:template><xsl:template match="info[@label='idiom']" mode="label">
		<xsl:text>Idiomatisches Franz.</xsl:text>
	</xsl:template><xsl:template match="info[@label='konj_decl']" mode="label">
		<xsl:text>Konjugation / Deklination:</xsl:text>
	</xsl:template><xsl:template match="info[@label='meaning']" mode="label">
		<xsl:text>Bedeutung:</xsl:text>
	</xsl:template><xsl:template match="info[@label='ortho_nde']" mode="label">
		<xsl:text>Neue Deutsche Rechtschreibung:</xsl:text>
	</xsl:template><xsl:template match="info[@label='phrasal']" mode="label">
		<xsl:text>Phrasal Verbs</xsl:text>
	</xsl:template><xsl:template match="info[@label='pron']" mode="label">
		<xsl:text>Pronunciación</xsl:text>
	</xsl:template><xsl:template match="info[@label='syn']" mode="label">
		<xsl:text>Synonyme:</xsl:text>
	</xsl:template><xsl:template match="info[@label='thes_syn_an']" mode="label">
		<xsl:text>Thesaurus, Synonyme, Antonyme</xsl:text>
	</xsl:template><xsl:template match="info[@label='verbs']" mode="label">
		<xsl:text>Verbformen:</xsl:text>
	</xsl:template><xsl:template match="info[@label='vocab']" mode="label">
		<xsl:text>Wortschatz:</xsl:text>
	</xsl:template><xsl:template match="info" mode="repr-left">
		<td class="center">
			<xsl:apply-templates select="." mode="source"/>
		</td>
		<td>
			<h4><xsl:apply-templates select="." mode="label"/></h4>
			<xsl:apply-templates select="." mode="content"/>
		</td>
	</xsl:template><xsl:template match="info" mode="repr-right">
		<td>
			<h4><xsl:apply-templates select="." mode="label"/></h4>
			<xsl:apply-templates select="." mode="content"/>
		</td>
		<td class="center">
			<xsl:apply-templates select="." mode="source"/>
		</td>
	</xsl:template><xsl:template name="addinfo-linktable-nextrow">
		<xsl:param name="leftinfos"/>
		<xsl:param name="rightinfos"/>
		<xsl:if test="count($leftinfos) != 0 or count($rightinfos) != 0">
			
			<tr>
				
				<xsl:choose>
					<xsl:when test="count($leftinfos) != 0">
						<xsl:apply-templates select="$leftinfos[1]" mode="repr-left"/>
					</xsl:when>
					<xsl:otherwise>
						<td class="center"/>
						<td/>
					</xsl:otherwise>
				</xsl:choose>
				
				<xsl:choose>
					<xsl:when test="count($rightinfos) != 0">
						<xsl:apply-templates select="$rightinfos[1]" mode="repr-right"/>
					</xsl:when>
					<xsl:otherwise>
						<td/>
						<td class="center"/>
					</xsl:otherwise>
				</xsl:choose>
			</tr>
			
			<xsl:call-template name="addinfo-linktable-nextrow">
				<xsl:with-param name="leftinfos" select="$leftinfos [position() &gt; 1]"/>
				<xsl:with-param name="rightinfos" select="$rightinfos[position() &gt; 1]"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template><xsl:template match="info" mode="table-list-item">
		<tr>
			<th colspan="2" class="h4 bg-gray">
				<xsl:apply-templates select="." mode="label"/>
			</th>
		</tr>
		<tr>
			<td>
				<xsl:apply-templates select="." mode="content"/>
			</td>
			<td class="center">
				<xsl:apply-templates select="." mode="source"/>
			</td>
		</tr>
	</xsl:template><xsl:template name="addinfo-linktable-rows">
		<xsl:call-template name="addinfo-linktable-nextrow">
			
			<xsl:with-param name="leftinfos" select="side[position() = 1]/info[not(@content='merk')]"/>
			<xsl:with-param name="rightinfos" select="side[position() = 2]/info[not(@content='merk')]"/>
		</xsl:call-template>
	</xsl:template><xsl:template match="info" mode="addinfo-extraboxes"/><xsl:template match="info[@content='merk']" mode="addinfo-extraboxes">
		<div class="section ui-helper-clearfix">
			<h3 class="h3 bg-darkyellow"><xsl:apply-templates select="." mode="label"/></h3>
			<div class="addInfoMerkBox bg-yellow">...</div>
		</div>
	</xsl:template><xsl:template match="section" mode="contextSection">
		<tbody>
			<tr>
				<th colspan="8" class="nonResult">
					<xsl:value-of select="@sctTitle"/>
				</th>
			</tr>
		</tbody>
		<tbody>
			<xsl:apply-templates select="entry" mode="table-row"/>
		</tbody>
	</xsl:template><xsl:template match="side[position() = 1]" mode="repr">
		<xsl:if test="info">
			<xsl:apply-templates select="info" mode="structure"/>

			
			<xsl:for-each select="following-sibling::side[position() = 1]/info">
				<xsl:if test="position() &gt; count(../preceding-sibling::side[position() = 1]/info)">
					<tr>
						<td class="center"> </td>
						<td> </td>
						<xsl:apply-templates select="." mode="reprRight"/>
					</tr>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>

		<xsl:if test="not(info)">
			
			
			<xsl:for-each select="following-sibling::side[position()=1]/info">
				<tr>
					<td class="center"> </td>
					<td> </td>
					<xsl:apply-templates select="." mode="reprRight"/>
				</tr>
			</xsl:for-each>
		</xsl:if>
	</xsl:template><xsl:template match="side[position() = 2]" mode="repr"/><xsl:template name="flags">
		<xsl:param name="lang"/>
		<xsl:param name="size"/>
		<xsl:param name="class" select="'icon'"/>
		<xsl:if test="$size = 16">
			<xsl:if test="$lang = 'de'">
				<span class="sp spdict s_3393883089 {$class}" title="de"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'en'">
				<span class="sp spdict s_2962019588 {$class}" title="en"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'fr'">
				<span class="sp spdict s_3796955134 {$class}" title="fr"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'es'">
				<span class="sp spdict s_1135023008 {$class}" title="es"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'it'">
				<span class="sp spdict s_337741013 {$class}" title="it"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'ch'">
				<span class="sp spdict s_542081603 {$class}" title="zh"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'ru'">
				<span class="sp spdict s_3762117329 {$class}" title="ru"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'pt'">
				<span class="sp spdict s_3703916537 {$class}" title="pt"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'pl'">
				<span class="sp spdict s_851522126 {$class}" title="pl"> </span>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$size = 22">
			<xsl:if test="$lang = 'de'">
				<span class="sp spdict s_3281943631 {$class}" title="de"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'en'">
				<span class="sp spdict s_3109560986 {$class}" title="en"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'fr'">
				<span class="sp spdict s_3951302752 {$class}" title="fr"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'es'">
				<span class="sp spdict s_1249109054 {$class}" title="es"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'it'">
				<span class="sp spdict s_502625099 {$class}" title="it"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'ch'">
				<span class="sp spdict s_698054109 {$class}" title="zh"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'ru'">
				<span class="sp spdict s_3924405583 {$class}" title="ru"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'pt'">
				<span class="sp spdict s_3574706279 {$class}" title="pt"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'pl'">
				<span class="sp spdict s_991282640 {$class}" title="pl"> </span>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$size = 32">
			<xsl:if test="$lang = 'de'">
				<span class="sp spdict s_3295194996 {$class}" title="de"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'en'">
				<span class="sp spdict s_3199136161 {$class}" title="en"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'fr'">
				<span class="sp spdict s_3966946139 {$class}" title="fr"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'es'">
				<span class="sp spdict s_1300576005 {$class}" title="es"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'it'">
				<span class="sp spdict s_436445296 {$class}" title="it"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'ch'">
				<span class="sp spdict s_778938086 {$class}" title="zh"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'ru'">
				<span class="sp spdict s_3995041396 {$class}" title="ru"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'pt'">
				<span class="sp spdict s_3538379612 {$class}" title="pt"> </span>
			</xsl:if>
			<xsl:if test="$lang = 'pl'">
				<span class="sp spdict s_1021515499 {$class}" title="pl"> </span>
			</xsl:if>
		</xsl:if>
	</xsl:template><xsl:template match="entry" mode="table-row-info-common">
		<td>
			<xsl:if test="@usr">
				<span class="sp spdict s_2576326102 " title=""><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="onclick">dict.showUserInfo(<xsl:value-of select="@usr"/>, event);</xsl:attribute><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="title"><xsl:text>Details zum Benutzer</xsl:text></xsl:attribute> </span>
			</xsl:if>
			<xsl:if test="not(@usr)">
				<span class="sp spdict s_2924637882 " title=""><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="title"><xsl:text>Mehr Informationen</xsl:text></xsl:attribute> </span>
			</xsl:if>
		</td>
	</xsl:template><xsl:template match="side" mode="table-row-info">
		<xsl:param name="class"/>
		
		<xsl:variable name="lang" select="@lang"/>
		<xsl:variable name="ibox" select="ibox"/>
		<xsl:variable name="flecttab" select="$ibox/flecttab"/>
		
		<td class="{$class}">
			<xsl:if test="$flecttab">
				<span class="sp spdict s_2558022912 " title="F"><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="title">
						<xsl:choose>
							<xsl:when test="$flecttab/@stemType = 'verb'">
								<xsl:text>Verbtabelle öffnen</xsl:text>
							</xsl:when>
							<xsl:when test="$flecttab/@stemType = 'noun'">
								<xsl:text>Nomentabelle öffnen</xsl:text>
							</xsl:when>
							<xsl:when test="$flecttab/@stemType = 'adj'">
								<xsl:text>Adjektivtabelle öffnen</xsl:text>
							</xsl:when>
						</xsl:choose>
					</xsl:attribute> </span>
			</xsl:if>
		</td>
		<td class="{$class}">
			<xsl:if test="$ibox/pron">
				<span class="sp spdict s_121139705 " title="P"><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="title"><xsl:text>Aussprache anhören</xsl:text></xsl:attribute> </span>
			</xsl:if>
			<xsl:if test="$ibox/linguatec">
				<span class="sp spdict s_121139705 " title=""><xsl:variable xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="word" select="words/word[1]"/><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="data-dz-rel-ltec">
						<xsl:choose>
							<xsl:when test="$lang='ch'">
								<xsl:value-of select="$word/cc/cs"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$word"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="title"><xsl:text>Aussprache anhören</xsl:text></xsl:attribute> </span>
			</xsl:if>
		</td>
	</xsl:template><xsl:template match="side" mode="table-row-lion">
		<xsl:param name="position"/>
		<xsl:variable name="lang" select="@lang"/>
		<td>
			<img width="16" height="16">
				<xsl:attribute name="src">
					<xsl:text>/img/16x16/lion-use-</xsl:text>
					<xsl:value-of select="$position"/>
					<xsl:text>-entry.png</xsl:text>
				</xsl:attribute>
				<xsl:attribute name="data-dz-rel-lion">
					<xsl:choose>
						<xsl:when test="$lang='ch'">
							<xsl:value-of select="words/word[1]/cc/cs"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="words/word[1]"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:attribute name="title"><xsl:text>Mit Lion übernehmen</xsl:text></xsl:attribute>
			</img>
		</td>
	</xsl:template><xsl:template match="entry" mode="info-common">
		<xsl:param name="size"/>
		<xsl:if test="@usr">
			<span class="sp spdict s_2544744819 " title=""><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="onclick">dict.showUserInfo(<xsl:value-of select="@usr"/>, event);</xsl:attribute><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="title"><xsl:text>Details zum Benutzer</xsl:text></xsl:attribute> </span>
		</xsl:if>
		<xsl:if test="./side[position() = 1]/ibox/@ajaxid">
			<span class="sp spdict s_2691713567 " title=""><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="title"><xsl:text>Mehr Informationen</xsl:text></xsl:attribute> </span>
		</xsl:if>
	</xsl:template><xsl:template match="entry" mode="info">
		<xsl:param name="size"/>
		<xsl:param name="lang"/>

		<xsl:if test="side[@lang=$lang]/ibox/flecttab">
			<span class="sp spdict s_2522509733 " title="t"><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="onclick">dict.loadFlect("<xsl:value-of select="side[@lang=$lang]/ibox/flecttab/@url"/>", event);</xsl:attribute><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="title">
					<xsl:if test="side[@lang=$lang]/ibox/flecttab/@stemType = 'adj'">
						<xsl:text>Adjektivtabelle öffnen</xsl:text>
					</xsl:if>
					<xsl:if test="side[@lang=$lang]/ibox/flecttab/@stemType = 'noun'">
						<xsl:text>Nomentabelle öffnen</xsl:text>
					</xsl:if>
					<xsl:if test="side[@lang=$lang]/ibox/flecttab/@stemType = 'verb'">
						<xsl:text>Verbtabelle öffnen</xsl:text>
					</xsl:if>
				</xsl:attribute> </span>
		</xsl:if>
		<xsl:if test="side[@lang=$lang]/ibox/pron">

			<xsl:if test="side[@lang=$lang]/ibox/pron">
				<span class="sp spdict s_152720732 " title=""><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="title"><xsl:text>Aussprache anhören</xsl:text></xsl:attribute> </span>
			</xsl:if>
			<xsl:if test="side[@lang=$lang]/ibox/linguatec">
				<span class="sp spdict s_152720732 " title=""><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="data-dz-rel-ltec">
						<xsl:choose>
							<xsl:when test="$lang='ch'">
								<xsl:value-of select="side[@lang=$lang]/words/word/cc/cs"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="side[@lang=$lang]/words/word"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="title"><xsl:text>Aussprache anhören</xsl:text></xsl:attribute> </span>
			</xsl:if>
		</xsl:if>
	</xsl:template><xsl:template match="entry" mode="table-row">
		<xsl:variable xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="debuginfo" select="/*/@insertDebugInfo='on'"/>
		<tr xmlns:xsl="http://www.w3.org/1999/XSL/Transform" data-dz-rel-info="{@uid}">
			<td class="tblf1-text">
				<xsl:attribute name="lang"><xsl:value-of select="./side[position()='1']/@lang"/></xsl:attribute>
				<xsl:apply-templates select="side[position()='1']/repr" mode="repr"/>
			</td>
			
			<td class="tblf1-text">
				<xsl:attribute name="lang"><xsl:value-of select="./side[position()='2']/@lang"/></xsl:attribute>
				<xsl:apply-templates select="side[position()='2']/repr" mode="repr"/>
			</td>
		</tr>
	</xsl:template><xsl:template match="entry" mode="listview-list-item">
		<li>
			<xsl:attribute name="class"><xsl:value-of select="info/realmgroup/@type"/></xsl:attribute>
			<xsl:if test="@userid or string-length(@uid) &gt; 12">
				<xsl:attribute name="class"><xsl:value-of select="info/realmgroup/@type"/> user</xsl:attribute>
			</xsl:if>
			
			<xsl:apply-templates select="." mode="line"/>
		</li>
	</xsl:template><xsl:template match="entry" mode="line">
		
		<span class="text">
			<span><xsl:apply-templates select="side[position()='1']/repr" mode="repr"/></span>
		</span>

		
		<span class="text">
			<span><xsl:apply-templates select="side[position()='2']/repr" mode="repr"/></span>
		</span>
	</xsl:template><xsl:template match="entry" mode="two-lines">
		
		<span class="text">
			<span><xsl:apply-templates select="side[position()='1']/repr" mode="repr"/></span>
		</span>
		<br/>
		
		<span class="text">
			<span><xsl:apply-templates select="side[position()='2']/repr" mode="repr"/></span>
		</span>
	</xsl:template><xsl:template match="entry" mode="votd">
		
		<div class="votd">
			<span><xsl:apply-templates select="side[position()='1']/words/word[position() = 1]" mode="repr"/></span>
		</div>
		
		<div class="votd">
			<span><xsl:apply-templates select="side[position()='2']/words/word[position() = 1]" mode="repr"/></span>
		</div>
	</xsl:template><xsl:template match="entry" mode="list">
		<li><xsl:value-of select="side[position()=$side]/repr"/></li>
	</xsl:template><xsl:template match="entry" mode="name">
		<xsl:copy-of select="languagea"/> - <xsl:copy-of select="languageb"/>
	</xsl:template><xsl:template match="entry" mode="table-list-item">
		<xsl:param name="jsObject"/>

		<tr>
			<td>
				<xsl:attribute name="onclick"><xsl:apply-templates select="." mode="jsName"/>.edit();</xsl:attribute>
				<xsl:copy-of select="languagea"/>
				<xsl:copy-of select="side[@lang='en']/repr"/>
			</td>
			<td>
				<xsl:attribute name="onclick"><xsl:apply-templates select="." mode="jsName"/>.edit();</xsl:attribute>
				<xsl:copy-of select="languageb"/>
				<xsl:copy-of select="side[@lang='de']/repr"/>
			</td>
			<td>
				<xsl:if test="string(error)">
					<xsl:value-of select="error"/>
				</xsl:if>
				
			</td>
			<td>
				<span class="sp spdict s_2769259262 " title=""><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="onclick"><xsl:apply-templates select="." mode="jsName"/>.remove();</xsl:attribute><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="title"><xsl:text>Titel</xsl:text></xsl:attribute> </span>
			</td>
		</tr>
	</xsl:template><xsl:template match="/html">
		<div data-dz-role="result">
			<xsl:if test="body/adjtab">
				<xsl:apply-templates select="body/adjtab" mode="repr"/>
			</xsl:if>

			<xsl:if test="body/nountab">
				<xsl:apply-templates select="body/nountab" mode="repr"/>
			</xsl:if>

			<xsl:if test="body/verbtab">
				<xsl:apply-templates select="body/verbtab" mode="repr"/>
			</xsl:if>
		</div>
	</xsl:template><xsl:template match="mood" mode="breadcrumb">
		<span>
			<xsl:attribute name="onclick">$("#flectResult").scrollTo("#mood-<xsl:value-of select="position()"/>");</xsl:attribute>
			<xsl:value-of select="./@title"/>
		</span>
		<span><xsl:text> :: </xsl:text></span>
	</xsl:template><xsl:template name="gender">
		<xsl:param name="abbr"/>
		<xsl:if test="string($abbr) = 'sm'"><xsl:text>Singular Maskulin</xsl:text></xsl:if>
		<xsl:if test="string($abbr) = 'sf'"><xsl:text>Singular Feminin</xsl:text></xsl:if>
		<xsl:if test="string($abbr) = 'sn'"><xsl:text>Singular Neutrum</xsl:text></xsl:if>
		<xsl:if test="string($abbr) = 'sc'"><xsl:text>Singular Höflichkeitsform</xsl:text></xsl:if>
		<xsl:if test="string($abbr) = 'pm'"><xsl:text>Plural Maskulin</xsl:text></xsl:if>
		<xsl:if test="string($abbr) = 'pf'"><xsl:text>Plural Feminin</xsl:text></xsl:if>
		<xsl:if test="string($abbr) = 'pn'"><xsl:text>Plural Neutrum</xsl:text></xsl:if>
		<xsl:if test="string($abbr) = 'pc'"><xsl:text>Plural Höflichkeitsform</xsl:text></xsl:if>
	</xsl:template><xsl:template match="*" mode="adjective">
		<xsl:value-of select="."/><xsl:text> </xsl:text>
	</xsl:template><xsl:template match="adjtab" mode="repr">
		<div class="addInfo">
			<div class="tf1 tf1-indent center bg-yellow">
				<xsl:if test="not(./mood/@title = '')">
					<xsl:attribute name="class">tf1 tf1-indent center bg-darkyellow</xsl:attribute>
				</xsl:if>
				<h2 class="h2"><xsl:text>Adjektivtabelle für: </xsl:text><xsl:value-of select="./@title"/></h2>
			</div>
			<xsl:if test="not(./mood/@title = '')">
				

				<div itemprop="breadcrumb" class="breadcrumb tf1 bg-yellow">
					<span class="h3"><xsl:text>Modi</xsl:text></span>
					<xsl:apply-templates select="./mood" mode="breadcrumb"/>
				</div>
			</xsl:if>

			<xsl:apply-templates select="mood" mode="adjrepr"/>
		</div>
	</xsl:template><xsl:template match="mood" mode="adjrepr">
		<div xmlns:xsl="http://www.w3.org/1999/XSL/Transform" class="section">
			<xsl:attribute name="id">mood-<xsl:value-of select="position()"/></xsl:attribute>
			<table class="tblf2 tblf-alternate">
				<colgroup>
					<col width="20%"/>
					<col width="80%"/>
				</colgroup>
				<thead>
					<tr>
						<th class="h4 bg-darkyellow" colspan="2"><xsl:value-of select="./@title"/></th>
					</tr>
				</thead>
				<tbody>
					<xsl:apply-templates select="./variant" mode="mobile"/>
				</tbody>
			</table>
		</div>
	</xsl:template><xsl:template match="adj" mode="repr">
		<xsl:apply-templates select="./ending[not(@o)]" mode="adj"/>
	</xsl:template><xsl:template match="art" mode="adj"/><xsl:template match="case" mode="adj">
		<xsl:apply-templates xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="./adj" mode="repr"/>
	</xsl:template><xsl:template match="case" mode="adjFirstColumn">
		<xsl:param name="casePosition"/>
		<xsl:if test="./@cn and not(./@cn = 'NA') and not(./@cn = '')">
			<td><xsl:value-of select="./@cn"/></td>
		</xsl:if>
		<xsl:apply-templates select="." mode="adj"/>
	</xsl:template><xsl:template match="case" mode="mobile">
		<xsl:param name="title"/>
		<xsl:variable name="current" select="position()"/>
		<tr aria-level="2" role="heading">
			<td class="h4 bg-gray" colspan="2">
				<xsl:value-of select="$title"/>
				<xsl:if test="./@cn and not(./@cn = 'NA') and not(./@cn = '')">
					<xsl:text>, </xsl:text>
					<xsl:value-of select="./@cn"/>
				</xsl:if>
				<xsl:text> </xsl:text>
			</td>
		</tr>
		<xsl:apply-templates select="." mode="adj"/>
	</xsl:template><xsl:template match="case" mode="structureAdjThreeVariants">
		<xsl:variable name="current" select="position()"/>
		<tr>
			<xsl:apply-templates select="." mode="adjFirstColumn"/>
			<xsl:apply-templates select="../following-sibling::*[position() = 1]/case[position() = $current]" mode="adj"/>
			<xsl:apply-templates select="../following-sibling::*[position() = 2]/case[position() = $current]" mode="adj"/>
		</tr>
	</xsl:template><xsl:template match="case" mode="structureAdjTwoVariants">
		<xsl:variable name="current" select="position()"/>
		<tr>
			<xsl:apply-templates select="." mode="adjFirstColumn"/>
			<xsl:apply-templates select="../following-sibling::*[position() = 1]/case[position() = $current]" mode="adj"/>
		</tr>
	</xsl:template><xsl:template match="ending" mode="adj">
		<xsl:variable xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="current" select="position()"/>
		<tr xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
			<td>
				<span class="h5">
					<xsl:if test="./@g = 'sm'">
						<xsl:text>Männlich</xsl:text>
					</xsl:if>
					<xsl:if test="./@g = 'sf'">
						<xsl:text>Weiblich</xsl:text>
					</xsl:if>
					<xsl:if test="./@g = 'sn' = 3">
						<xsl:text>Sächlich</xsl:text>
					</xsl:if>
				</span>
				<xsl:text> </xsl:text>
			</td>
			<td>
				<xsl:if test="preceding-sibling::art[position() = 1]">
					<xsl:value-of select="preceding-sibling::art[position() = 1]"/>
					<xsl:text> </xsl:text>
				</xsl:if>
				<xsl:if test="../part">
					<xsl:value-of select="../part"/>
					<xsl:text> </xsl:text>
				</xsl:if>

				
				<xsl:if test="@pc">
					<xsl:value-of select="@pc"/>
				</xsl:if>
				<xsl:if test="not(@pc)">
					<xsl:if test="not(count(preceding-sibling::ending) &gt; 0)">
						<xsl:text> </xsl:text>
					</xsl:if>
				</xsl:if>

				
				<xsl:if test="not(./@nr)">
					<xsl:value-of select="../../radical"/>
				</xsl:if>
				<span class="ending">
					<xsl:value-of select="."/>
				</span>

				
				<xsl:if test="following-sibling::ending[position() = 1]/@o">
					<xsl:text> (</xsl:text>
					<xsl:value-of select="../../radical"/>
					<span class="ending">
						<xsl:value-of select="following-sibling::ending[position() = 1]"/>
					</span>
					<xsl:text>)</xsl:text>
				</xsl:if>
			</td>
		</tr>
	</xsl:template><xsl:template match="part" mode="adj"/><xsl:template match="variant" mode="mobile">
		<xsl:if test="not(case/@cn = 'NA')">
			<xsl:apply-templates select="case" mode="mobile">
				<xsl:with-param name="title" select="./@title"/>
			</xsl:apply-templates>
		</xsl:if>
	</xsl:template><xsl:template match="*" mode="noun">
		<xsl:value-of select="."/><xsl:text> </xsl:text>
	</xsl:template><xsl:template match="nountab" mode="repr">
		<div class="addInfo">
			<div class="tf1 tf1-indent center bg-yellow">
				<xsl:if test="not(./mood/@title = '')">
					<xsl:attribute name="class">tf1 tf1-indent center bg-darkyellow</xsl:attribute>
				</xsl:if>
				<h2 class="h2"><xsl:text>Substantivtabelle für: </xsl:text><xsl:value-of select="./@title"/></h2>
			</div>

			<xsl:apply-templates select="mood" mode="noun"/>
		</div>
	</xsl:template><xsl:template match="case" mode="structureNoun">
		<xsl:variable name="current" select="position()"/>
		<tr>
			<td>
				<xsl:apply-templates select="." mode="noun"/>
			</td>
			<td>
				<xsl:apply-templates select="../following-sibling::*[position() = 1]/case[position() = $current]" mode="noun"/>
			</td>
			<td>
				<xsl:apply-templates select="../following-sibling::*[position() = 2]/case[position() = $current]" mode="noun"/>
			</td>
		</tr>
	</xsl:template><xsl:template match="case" mode="noun">
		<xsl:if test="./noun">
			<xsl:apply-templates select="./noun" mode="repr"/>
		</xsl:if>
		
		<xsl:if test="not(./noun)">
			<xsl:if test="./comment">
				<xsl:value-of select="./comment"/>
			</xsl:if>
			<xsl:if test="not(./comment)">–</xsl:if>
		</xsl:if>
	</xsl:template><xsl:template match="ending" mode="noun">
		<span>
			<xsl:if test="../article != ''">
				<xsl:value-of select="../article"/>
				<xsl:text> </xsl:text>
			</xsl:if>

			
			<xsl:if test="@o">
				
				<xsl:if test="count(preceding-sibling::ending) &gt; 0">/​</xsl:if>
			</xsl:if>

			
			<xsl:if test="@pc">
				<xsl:value-of select="@pc"/>
			</xsl:if>
			<xsl:if test="not(@pc)">
				<xsl:if test="not(count(preceding-sibling::ending) &gt; 0)">
					<xsl:text> </xsl:text>
				</xsl:if>
			</xsl:if>

			
			<xsl:value-of select="../../radical"/>
			<span class="ending">
				<xsl:value-of select="."/>
			</span>
		</span>
	</xsl:template><xsl:template match="mood" mode="noun">
		<div class="section">
			<table class="tbfl2 tbfl-alternate">
				<colgroup>
					<col style="width:33%"/>
					<col style="width:33%"/>
					<col style="width:33%"/>
				</colgroup>
				<thead>
					<tr>
						<th class="h4 bg-darkyellow">
							<xsl:if test="./@title">
								<xsl:value-of select="./@title"/>
							</xsl:if>
							<xsl:if test="not(./@title)">
								<xsl:text> </xsl:text>
							</xsl:if>
						</th>
						<th class="h3 bg-darkyellow"><xsl:text>Singular</xsl:text></th>
						<th class="h3 bg-darkyellow"><xsl:text>Plural</xsl:text></th>
					</tr>
				</thead>
				<tbody>
					<xsl:apply-templates select="variant[position() = 1]/case" mode="structureNoun"/>
				</tbody>
			</table>
		</div>
	</xsl:template><xsl:template match="noun" mode="repr">
		<xsl:apply-templates mode="noun"/>
	</xsl:template><xsl:template match="*" mode="repr">
		<xsl:value-of select="."/><xsl:text> </xsl:text>
	</xsl:template><xsl:template match="verbtab" mode="repr">
		<div class="addInfo">
			<div class="tf1 tf1-indent tf-center bg-yellow">
				<xsl:if test="not(./mood/@title = '')">
					<xsl:attribute name="class">tf1 tf1-indent tf-center bg-darkyellow</xsl:attribute>
				</xsl:if>
				<h2 class="h2"><xsl:text>Verbtabelle für: </xsl:text><xsl:value-of select="./@title"/></h2>
				<p><xsl:apply-templates select="aux" mode="main"/></p>
			</div>
			<xsl:if test="not(./mood/@title = '')">
				

				<div itemprop="breadcrumb" class="breadcrumb tf1 bg-yellow">
					<span class="h3"><xsl:text>Modi</xsl:text></span>
					<xsl:apply-templates select="./mood" mode="breadcrumb"/>
				</div>
			</xsl:if>

			<xsl:apply-templates select="mood" mode="repr"/>
		</div>
	</xsl:template><xsl:template match="aux" mode="main">
		<xsl:value-of select="comment"/><xsl:value-of select="auxiliary"/>
	</xsl:template><xsl:template match="aux" mode="repr">
		<xsl:if test="(/html/body/verbtab/aux/@a = '') or (local-name(preceding-sibling::*[1]) = 'ending')">
			
			<xsl:if test="@pc">
				<xsl:value-of select="@pc"/>
			</xsl:if>
			<xsl:if test="not(@pc)">
				<xsl:if test="not(local-name(preceding-sibling::*[1]) = 'aux')">
					<xsl:text> </xsl:text>
				</xsl:if>
			</xsl:if>

			
			<xsl:if test="local-name(preceding-sibling::*[1]) = 'aux'">/​</xsl:if>
			<xsl:value-of select="."/>
			<xsl:if test="not(local-name(following-sibling::*[1]) = 'aux') and not(local-name(following-sibling::*[1]) = 'rpron')">
				<xsl:text> </xsl:text>
			</xsl:if>
		</xsl:if>
	</xsl:template><xsl:template match="case" mode="caseDisplay0001">
		<tr>
			<td colspan="3"> </td>
 			<td>
 				<xsl:apply-templates select="." mode="repr"/>
 			</td>
 		</tr>
	</xsl:template><xsl:template match="case" mode="caseDisplay0011">
		<xsl:variable name="position" select="position()"/>
		<tr>
			<td colspan="2"> </td>
 			<td>
 				<xsl:apply-templates select="." mode="repr"/>
 			</td>
 			<td>
 				<xsl:apply-templates select="../following-sibling::variant[position() = 1]/case[position() = $position]" mode="repr"/>
 			</td>
 		</tr>
	</xsl:template><xsl:template match="case" mode="caseDisplay01">
		<xsl:param name="node"/>
		<tr>
			<td colspan="2"> </td>
 			<td colspan="2">
 				<xsl:apply-templates select="." mode="repr"/>
 			</td>
 		</tr>
	</xsl:template><xsl:template match="case" mode="caseDisplay0111">
		<xsl:variable name="position" select="position()"/>
		<tr>
			<td> </td>
			<td>
				<xsl:apply-templates select="." mode="repr"/>
			</td>
			<td>
				<xsl:apply-templates select="../../following-sibling::tense[position() = 1]/variant[position() = 1]/case[position() = $position]" mode="repr"/>
			</td>
			<td>
				<xsl:apply-templates select="../../following-sibling::tense[position() = 1]/variant[position() = 2]/case[position() = $position]" mode="repr"/>
			</td>
		</tr>
	</xsl:template><xsl:template match="case" mode="caseDisplay11">
		<xsl:variable name="position" select="position()"/>
		<tr>
			<td colspan="2">
				<xsl:apply-templates select="." mode="repr"/>
			</td>
			<td colspan="2">
				<xsl:apply-templates select="../following-sibling::*[position() = 1]/case[position() = $position]" mode="repr"/>
			</td>
		</tr>
	</xsl:template><xsl:template match="case" mode="caseDisplay1">
		<tr>
 			<td>
 				<xsl:apply-templates select="." mode="repr"/>
 			</td>
 		</tr>
	</xsl:template><xsl:template match="case" mode="caseDisplay1111">
		<xsl:variable name="position" select="position()"/>
		<tr>
			<td>
				<xsl:apply-templates select="." mode="repr"/>
			</td>
			<td>
				<xsl:apply-templates select="../following-sibling::variant[position() = 1]/case[position() = $position]" mode="repr"/>
			</td>
			<td>
				<xsl:apply-templates select="../../following-sibling::tense[position() = 1]/variant[position() = 1]/case[position() = $position]" mode="repr"/>
			</td>
			<td>
				<xsl:apply-templates select="../../following-sibling::tense[position() = 1]/variant[position() = 2]/case[position() = $position]" mode="repr"/>
			</td>
		</tr>
	</xsl:template><xsl:template match="case" mode="repr">
		<xsl:if test="./verb">
			<xsl:apply-templates select="verb" mode="repr"/>
		</xsl:if>
		
		<xsl:if test="not(./verb)">–</xsl:if>
	</xsl:template><xsl:template match="conj" mode="repr">
		
		<xsl:if test="@pc">
			<xsl:value-of select="@pc"/>
		</xsl:if>
		<xsl:if test="not(@pc)">
			<xsl:text> </xsl:text>
		</xsl:if>

		<xsl:if test="./@opt = 'true'">
			<xsl:text>(</xsl:text>
		</xsl:if>
		<xsl:value-of select="."/>
		<xsl:if test="./@opt = 'true'">
			<xsl:text>)</xsl:text>
		</xsl:if>
	</xsl:template><xsl:template match="ending" mode="repr">
		<span>
			<xsl:if test="@g">
				<xsl:attribute name="title">
					<xsl:call-template name="gender">
						<xsl:with-param name="abbr" select="@g"/>
					</xsl:call-template>
				</xsl:attribute>

				
				<xsl:if test="preceding-sibling::ending">/​</xsl:if>
			</xsl:if>
			<xsl:if test="not(@g) and ../../preceding-sibling::comment[position() = 1]">
				<xsl:attribute name="title">
					<xsl:value-of select="../../preceding-sibling::comment[position() = 1]"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="@o">
				<xsl:if test="count(preceding-sibling::ending) &gt; 0"> | </xsl:if>
			</xsl:if>

			
			<xsl:if test="@pc">
				<xsl:value-of select="@pc"/>
			</xsl:if>
			<xsl:if test="not(@pc)">
				<xsl:if test="not(count(preceding-sibling::ending) &gt; 0)">
					<xsl:text> </xsl:text>
				</xsl:if>
			</xsl:if>

			
			<xsl:value-of select="../../radical"/>
			<span class="ending">
				<xsl:value-of select="."/>
			</span>
		</span>
	</xsl:template><xsl:template match="mood" mode="repr">
		<div xmlns:xsl="http://www.w3.org/1999/XSL/Transform" class="section">
			<xsl:attribute name="id">mood-<xsl:value-of select="position()"/></xsl:attribute>
			<table class="tblf2 tblf-alternate">
				<thead>
					<tr>
						<th class="h3 bg-darkyellow">
							<xsl:value-of select="./@title"/>
						</th>
					</tr>
				</thead>
				<xsl:apply-templates select="tense" mode="repr"/>
			</table>
		</div>
	</xsl:template><xsl:template match="mood" mode="toc">
		<li>
			<xsl:attribute name="onclick">
				$("#flectResult").scrollTo("#mood-<xsl:value-of select="position()"/>");
			</xsl:attribute>
			<xsl:value-of select="./@title"/>
		</li>
	</xsl:template><xsl:template match="part" mode="repr">
		<span>
			<xsl:if test="@l">
				<xsl:attribute name="title">
					<xsl:if test="@l">
						<xsl:if test="@g"><xsl:text>, </xsl:text></xsl:if>
						<xsl:text>Langform: </xsl:text><xsl:value-of select="@l"/>
					</xsl:if>
				</xsl:attribute>
			</xsl:if>

			<xsl:if test="@pc">
				<xsl:value-of select="@pc"/>
			</xsl:if>
			<xsl:value-of select="."/>
			
			
		</span>
	</xsl:template><xsl:template match="pref" mode="repr">
		
		<xsl:if test="@pc">
			<xsl:value-of select="@pc"/>
		</xsl:if>
		<xsl:if test="not(@pc)">
			<xsl:text> </xsl:text>
		</xsl:if>

		<xsl:if test="@o">
			<xsl:if test="count(preceding-sibling::pref) &gt; 0"> / </xsl:if>
		</xsl:if>
		<xsl:value-of select="."/>
		<xsl:if test="@o">
			<xsl:if test="count(following-sibling::pref) = 0 and count(following-sibling::ending) = 0"><xsl:text> </xsl:text></xsl:if>
		</xsl:if>
	</xsl:template><xsl:template match="ppron" mode="repr">
		<span>
			<xsl:if test="@g or @l or @opt">
				<xsl:attribute name="title">
					<xsl:if test="@g">
						<xsl:call-template name="gender">
							<xsl:with-param name="abbr" select="@g"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="@l">
						<xsl:if test="@g"><xsl:text>, </xsl:text></xsl:if>
						<xsl:text>Langform: </xsl:text><xsl:value-of select="@l"/>
					</xsl:if>
					<xsl:if test="string(@opt) = 'true'">
						<xsl:if test="@g or @l"><xsl:text>, </xsl:text></xsl:if>
						<xsl:text>Optional</xsl:text>
					</xsl:if>
				</xsl:attribute>
			</xsl:if>

			
			<xsl:if test="local-name(preceding-sibling::*[1]) = 'ppron'">/​</xsl:if>

			
			<xsl:if test="@pc">
				<xsl:value-of select="@pc"/>
			</xsl:if>
			<xsl:if test="not(@pc)">
				<xsl:if test="not(local-name(preceding-sibling::*[1]) = 'ppron')">
					<xsl:text> </xsl:text>
				</xsl:if>
			</xsl:if>

			
			<xsl:if test="string(@opt) = 'true' and not(local-name(preceding-sibling::*[1]) = 'ppron')">(</xsl:if>
			<xsl:value-of select="."/>
			
			<xsl:if test="(string(.) = string(@l) and not(@opt) and not(@g))"><xsl:text> </xsl:text></xsl:if>
			
			<xsl:if test="string(@opt) = 'true' and not(local-name(following-sibling::*[1]) = 'ppron')"><xsl:text>) </xsl:text></xsl:if>
		</span>
	</xsl:template><xsl:template match="ipron" mode="repr">
		
		<xsl:if test="@pc">
			<xsl:value-of select="@pc"/>
		</xsl:if>
		<xsl:if test="not(@pc)">
			<xsl:text> </xsl:text>
		</xsl:if>
		<xsl:value-of select="."/>
	</xsl:template><xsl:template match="object" mode="repr">
		<xsl:value-of select="."/>
	</xsl:template><xsl:template match="raux" mode="repr">
		<xsl:if test="/html/body/verbtab/aux/@a = 'r'">
			
			<xsl:if test="@pc">
				<xsl:value-of select="@pc"/>
			</xsl:if>
			<xsl:if test="not(@pc)">
				<xsl:if test="not(local-name(preceding-sibling::*[1]) = 'raux')">
					<xsl:text> </xsl:text>
				</xsl:if>
			</xsl:if>

			<xsl:if test="local-name(preceding-sibling::*[1]) = 'raux'">/ </xsl:if>
			<xsl:value-of select="."/>
			<xsl:if test="not(local-name(following-sibling::*[1]) = 'raux') and not(local-name(following-sibling::*[1]) = 'rpron')">
				<xsl:text> </xsl:text>
			</xsl:if>
		</xsl:if>
	</xsl:template><xsl:template match="rpron" mode="repr">
		
		<xsl:if test="@pc">
			<xsl:value-of select="@pc"/>
		</xsl:if>
		<xsl:if test="not(@pc)">
			<xsl:text> </xsl:text>
		</xsl:if>
		<xsl:value-of select="."/>
	</xsl:template><xsl:template match="spref" mode="repr">
		
		<xsl:if test="@pc">
			<xsl:value-of select="@pc"/>
		</xsl:if>
		<xsl:if test="not(@pc)">
			<xsl:text> </xsl:text>
		</xsl:if>
		<xsl:value-of select="."/>
	</xsl:template><xsl:template match="tense" mode="repr">
		<tbody xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
			<tr aria-level="2" role="heading">
				<td class="h4 bg-gray">
					<xsl:value-of select="./@title"/>
				</td>
			</tr>
			<xsl:if test="./variant">
				<tr>
					<xsl:apply-templates select="variant[position() = 1]" mode="title"/>
				</tr>
			</xsl:if>
			<xsl:if test="./variant/case">
				<xsl:apply-templates select="./variant/case" mode="caseDisplay1"/>
			</xsl:if>
			<xsl:if test="./case">
				<xsl:apply-templates select="./case" mode="caseDisplay1"/>
			</xsl:if>
		</tbody>
	</xsl:template><xsl:template match="variant" mode="title">
		<td class="h5 bg-lightgray">
			<xsl:value-of select="./@title"/>
		</td>
	</xsl:template><xsl:template match="verb" mode="repr">
		<xsl:apply-templates mode="repr"/>
	</xsl:template><xsl:template match="forum" mode="section"/><xsl:template match="forumRef" mode="breadcrumb">
		<xsl:if test="./link">
			<a onclick="$(document).scrollTo('#forumResults', 150);">
				<xsl:text>Diskussionen</xsl:text>
			</a>
			<span>::</span>
		</xsl:if>
	</xsl:template><xsl:template match="forumRef" mode="section">
		<div id="forumResults" class="dzC section forumResults">
			<div>
				<xsl:if test="./link">
					<xsl:apply-templates select="." mode="table-head"/>
				</xsl:if>
				<xsl:if test="not(./link)">
					<table>
						<thead>
							<tr>
								<th>
									<xsl:text>Aún nadie ha preguntado en el foro por </xsl:text>
									<i><xsl:value-of select="//search/@original"/></i>
									<xsl:text>.</xsl:text>
								</th>
							</tr>
						</thead>
					</table>
				</xsl:if>
			</div>
		</div>
	</xsl:template><xsl:template match="forumRef" mode="table-head">	
		<xsl:param xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="scope"/>
		<table xmlns:xsl="http://www.w3.org/1999/XSL/Transform" class="tblf1">
			<colgroup>
				<col style="width: 70%;"/>
				<col style="width: 30%;"/>
			</colgroup>
			<thead>
				<tr>
					<th colspan="2" class="h4 bg-darkyellow">
						<xsl:if test="not($scope = 'editorial')">
							<xsl:text>Discusiones del foro que contienen la palabra buscada</xsl:text>
						</xsl:if>
						<xsl:if test="$scope = 'editorial'">
							<xsl:text>Dieser Eintrag basiert auf:</xsl:text>
						</xsl:if>
					</th>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="./link[position() &lt; 14]" mode="forumResult">
					<xsl:with-param name="scope" select="$scope"/>
				</xsl:apply-templates>
			</tbody>
		</table>
	</xsl:template><xsl:template match="link" mode="forumResult">
		<xsl:param xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="scope"/>
		<tr xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
			<td colspan="2">
				<a rel="nofollow">
				<xsl:attribute name="href">
					<xsl:value-of select="@href"/>
					
					<xsl:text>&amp;lang=</xsl:text>
					<xsl:if test="not($scope = 'editorial')">
						<xsl:value-of select="//search/@lang"/>
					</xsl:if>
					<xsl:if test="$scope = 'editorial'">
						<xsl:value-of select="//additionalInfo/@lang"/>
					</xsl:if>
					<xsl:text>&amp;lp=</xsl:text>
					<xsl:if test="not($scope = 'editorial')">
						<xsl:value-of select="//search/@lp"/>
					</xsl:if>
					<xsl:if test="$scope = 'editorial'">
						<xsl:value-of select="//additionalInfo/@lp"/>
					</xsl:if>
				</xsl:attribute>
					<b>
					<xsl:value-of select="./subject"/>
					</b>
					<xsl:if test="./@domain != ''">
					<xsl:text> [</xsl:text>
					<xsl:value-of select="./@domain"/>
					<xsl:text>]</xsl:text>
					</xsl:if>
				</a>
			</td>
		</tr>
		<tr xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
			<td colspan="2">
				
				<xsl:variable name="teaser" select="string(./teaser)"/>
				<xsl:if test="string-length($teaser) &gt; 95">
						<xsl:value-of select="substring($teaser,0,92)"/>
						<xsl:text>...</xsl:text>
				</xsl:if>
				<xsl:if test="not(string-length($teaser) &gt; 95)">
						<xsl:copy-of select="$teaser"/>
				</xsl:if>
			</td>
		</tr>
		<tr xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
			<td>
				<small>
					<xsl:text>Último comentario: </xsl:text>
					<xsl:text> </xsl:text>
					<xsl:variable name="ticks">
					<xsl:call-template name="localtime">
						<xsl:with-param name="ticks" select="./@lastChangeDate"/>
					</xsl:call-template>
					</xsl:variable>

					<xsl:call-template name="timestamp">
						<xsl:with-param name="format" select="'nice'"/>
						<xsl:with-param name="ticks" select="$ticks"/>
					</xsl:call-template>
				</small>
			</td>
 			
			<td style="text-align:right;">
				<small>
					<xsl:variable name="followupCnt" select="string(./@followupCnt)"/>
					<xsl:if test="not($followupCnt = '')">
						<xsl:value-of select="$followupCnt"/>
					</xsl:if>
					<xsl:if test="$followupCnt = ''">
						<xsl:text>0</xsl:text>
					</xsl:if>
					<xsl:text> </xsl:text>
					<xsl:text>comentario(s)</xsl:text>
				</small>
			</td>
		</tr>
	</xsl:template><xsl:template name="section-colgroup">
		<colgroup>
			<col style="width:auto"/>
			<col style="width:auto"/>
		</colgroup>
	</xsl:template><xsl:template name="section-colgroup-twocols">
		<colgroup>
			<col style="width:auto"/>
			<col style="width:auto"/>
		</colgroup>
	</xsl:template><xsl:template match="section" mode="breadcrumb">
		<a>
			
			<xsl:attribute name="onclick">$(document).scrollTo("#section-<xsl:value-of select="@sctName"/>", 150);</xsl:attribute>
			<xsl:apply-templates select="." mode="shortname"/>
		</a>
		<span>::</span>
	</xsl:template><xsl:template match="section" mode="name">
		<xsl:if test="@sctName = 'subst'">
			<xsl:text>Sustantivos</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'verb'">
			<xsl:text>Verbos</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'adjadv'">
			<xsl:text>Adjetivos / Adverbios</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'praep'">
			<xsl:text>Preposiciones / Pronombres / Determinantes / Conjunciones</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'definition'">
			<xsl:text>Definiciones</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'abbrev'">
			<xsl:text>Abreviaturas / Símbolos</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'phrase'">
			<xsl:text>Locuciones / Refranes / Interjecciones</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'example'">
			<xsl:text>Ejemplos</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'flect'">
			<xsl:text>Formas flexivas</xsl:text>
		</xsl:if>
	</xsl:template><xsl:template match="section" mode="shortname">
		<xsl:if test="@sctName = 'subst'">
			<xsl:text>Sustantivos</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'verb'">
			<xsl:text>Verbos</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'adjadv'">
			<xsl:text>Adjetivos</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'praep'">
			<xsl:text>Preposiciones</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'definition'">
			<xsl:text>Definiciones</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'abbrev'">
			<xsl:text>Abreviaturas / Símbolos</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'phrase'">
			<xsl:text>Locuciones / Refranes / Interjecciones</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'example'">
			<xsl:text>Ejemplos</xsl:text>
		</xsl:if>
		<xsl:if test="@sctName = 'flect'">
			<xsl:text>Formas flexivas</xsl:text>
		</xsl:if>
	</xsl:template><xsl:template match="section" mode="section">
		
		
		<xsl:call-template xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="section-section">
			<xsl:with-param name="includeIds" select="1"/>
			<xsl:with-param name="columns" select="2"/>
		</xsl:call-template>
	</xsl:template><xsl:template name="section-section">
		<xsl:param name="includeIds"/>
		<xsl:param name="columns"/>

		<div class="section wgt">
			<xsl:attribute name="data-dz-name"><xsl:value-of select="@sctName"/></xsl:attribute>
			<xsl:if test="$includeIds = 1">
				<xsl:attribute name="id">section-<xsl:value-of select="@sctName"/></xsl:attribute>
			</xsl:if>
			
				
				<table class="tblf1 tblf-alternate">
					<xsl:call-template name="section-colgroup"/>
					<thead>
						<tr>
							<th>
								<xsl:if test="/*/@lion">
									<xsl:attribute name="colspan">10</xsl:attribute>
								</xsl:if>
								<xsl:if test="not(/*/@lion)">
									<xsl:attribute name="colspan"><xsl:value-of select="$columns"/></xsl:attribute>
								</xsl:if>
								
								<h1 class="h4 bg-darkyellow">
									<xsl:apply-templates select="." mode="name"/>
								</h1>
							</th>
						</tr>
					</thead>
					
					<tbody>
						<xsl:apply-templates select="./entry" mode="table-row"/>
					</tbody>
				</table>
			<xsl:if test="./minprio">
				
				<footer class="more wgt-footer">
					<span class="js-hideMoreEntries" style="display: none;" data-dz-button-role="less">
						
						
						<xsl:if test="@sctName = 'subst'">
							<xsl:text>mostrar menos sustantivos</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'verb'">
							<xsl:text>mostrar menos verbos</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'adjadv'">
							<xsl:text>mostrar menos adjetivos / adverbios</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'praep'">
							<xsl:text>volver a lista reducida</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'definition'">
							<xsl:text>weitere Definitionen verbergen</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'abbrev'">
							<xsl:text>weitere Abkürzungen verbergen</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'phrase'">
							<xsl:text>mostrar menos locuciones / expresiones</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'example'">
							<xsl:text>weitere Beispiele verbergen</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'flect'">
							<xsl:text>weitere Flexionen verbergen</xsl:text>
						</xsl:if>
						<span class="sp spdict s_3320116095 " title=""><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="title"><xsl:text>Weitere Treffer verbergen</xsl:text></xsl:attribute> </span>
					</span>
					<span class="js-showMoreEntries" data-dz-button-role="more">
						
						
						<xsl:if test="@sctName = 'subst'">
							<xsl:text>mostrar más sustantivos</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'verb'">
							<xsl:text>mostrar más verbos</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'adjadv'">
							<xsl:text>mostrar más adjetivos / adverbios</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'praep'">
							<xsl:text>mostrar más resultados</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'definition'">
							<xsl:text>weitere Definitionen anzeigen</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'abbrev'">
							<xsl:text>weitere Abkürzungen anzeigen</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'phrase'">
							<xsl:text>mostrar más locuciones / expresiones</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'example'">
							<xsl:text>weitere Beispiele anzeigen</xsl:text>
						</xsl:if>
						<xsl:if test="@sctName = 'flect'">
							<xsl:text>weitere Flexionen anzeigen</xsl:text>
						</xsl:if>
						<span class="js-moreEntriesCount">
							<xsl:text> (</xsl:text>
							<xsl:value-of select="(./@sctCount - 1)"/>
							<xsl:text> / </xsl:text>
							<xsl:value-of select="./@sctTotalCnt"/>
							<xsl:text>)</xsl:text>
						</span>
						<span class="sp spdict s_2765670405 icon" title=""><xsl:attribute xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="title"><xsl:text>Weitere Treffer anzeigen</xsl:text></xsl:attribute> </span>
					</span>
				</footer>
			</xsl:if>
		</div>
	</xsl:template><xsl:template match="section" mode="index">
		<table>
			<tbody title="expanded no direct" data-dz-role="result">
				<xsl:apply-templates select="./entry" mode="table-row"/>
			</tbody>
		</table>
	</xsl:template><xsl:template match="word" mode="table-row">
		<td>
			 
		</td>
		<td>
			 
		</td>
		<td data-dz-attr="relink" class="tblf1-text">
			<span><xsl:value-of select="."/></span>
		</td>
	</xsl:template><xsl:template match="link" mode="table-row">
		<tr>
			<td data-dz-attr="relink" class="tblf1-text">
				<a>
					<xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
					<xsl:value-of select="."/>
				</a>
			</td>
		</tr>
	</xsl:template><public-xsl:template xmlns:public-xsl="http://www.w3.org/1999/XSL/Transform" match="link" mode="link">
		<span class="spirit s_info_l">
			<public-xsl:attribute name="onclick">getMoreInfo(event,'<public-xsl:value-of select="."/>');</public-xsl:attribute>
		</span>
	</public-xsl:template><xsl:template match="base" mode="entry">
		
		<td>
			<xsl:if test="@flectionurl != ''">
				<span class="sp spdict s_2558022912 " title="Flexionstabelle anzeigen"> </span>
			</xsl:if>
		</td>
		<td>
			 
		</td>
		<td data-dz-attr="relink" class="tblf1-text">
			<span><xsl:value-of select="."/></span>
			<xsl:if test="//baselist[@index='1']">
				 <i>von <xsl:value-of select="../@word"/></i>
			</xsl:if>
		</td>
	</xsl:template><xsl:template match="realmgroup">
		<button>
			<xsl:attribute name="onclick">filterRealm('<xsl:value-of select="@type"/>', this);</xsl:attribute>
			<xsl:value-of select="@type"/>
		</button> <br/>
	</xsl:template><xsl:template match="part">
		<xsl:if test="section">
			<xsl:apply-templates select="./section" mode="section"/>
		</xsl:if>
	</xsl:template><xsl:template match="repr" mode="repr">
		<xsl:apply-templates mode="repr"/>
	</xsl:template><xsl:template match="cc" mode="repr">
		<span lang="zh-Hans" xml:lang="zh-Hans"><xsl:copy-of select="cs"/></span>
		<xsl:text> [</xsl:text><span lang="zh-Hant" xml:lang="zh-Hant"><xsl:copy-of select="ct"/></span><xsl:text>]</xsl:text>
		<xsl:text> </xsl:text><xsl:copy-of select="pn"/>
	</xsl:template><xsl:template match="similar|ffsynlist" mode="entries">
		<tbody>
			<tr>
				<td data-dz-attr="relink" class="tblf1-text">
					
					<xsl:variable name="sizeA" select="count(./side[position() = '1']/word)"/>
					<xsl:for-each select="./side[position() = '1']/word">
						<xsl:call-template name="word">
							<xsl:with-param name="wordValue" select="."/>
						</xsl:call-template>
						<xsl:if test="position() &lt; $sizeA">
							<xsl:text>, </xsl:text>
						</xsl:if>
					</xsl:for-each>
					
					<xsl:text> </xsl:text>
				</td>
				<td data-dz-attr="relink" class="tblf1-text">
					
					<xsl:variable name="sizeB" select="count(./side[position() = '2']/word)"/>
					<xsl:for-each select="./side[position() = '2']/word">
						<xsl:call-template name="word">
							<xsl:with-param name="wordValue" select="."/>
						</xsl:call-template>
						<xsl:if test="position() &lt; $sizeB">
							<xsl:text>, </xsl:text>
						</xsl:if>
					</xsl:for-each>
					
					<xsl:text> </xsl:text>
				</td>
			</tr>
		</tbody>
	</xsl:template><xsl:template match="*" mode="repr">
		<xsl:copy><xsl:apply-templates mode="repr"/></xsl:copy>
	</xsl:template><xsl:template name="word">
		<xsl:param name="wordValue"/>
		<xsl:if test="./@vocab = 1 and /*/@dictQueryXSLT='2' and /*/search/@lp='ende'">
			
			
			<a class="landing">
				<xsl:attribute name="href">
					<xsl:text>/englisch-deutsch/</xsl:text>
					<xsl:value-of select="$wordValue"/>
					<xsl:text>.html</xsl:text>
				</xsl:attribute>
				<xsl:value-of select="$wordValue"/>
			</a>
		</xsl:if>
		<xsl:if test="not(./@vocab = 1 and /*/@dictQueryXSLT='2' and /*/search/@lp='ende')">
			<span><xsl:value-of select="$wordValue"/></span>
		</xsl:if>
	</xsl:template><xsl:template match="date" mode="xsl">
		<xsl:variable name="ticks">
			<xsl:call-template name="localtime">
				<xsl:with-param name="ticks" select="number(.)"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="timestamp">
			<xsl:with-param name="ticks" select="$ticks"/>
		</xsl:call-template>
	</xsl:template><xsl:template match="*" mode="weekday">
		<xsl:variable name="ticks">
			<xsl:call-template name="localtime">
				<xsl:with-param name="ticks" select="number(.)"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="weekday">
			<xsl:with-param name="ticks" select="$ticks"/>
		</xsl:call-template>
	</xsl:template><xsl:template match="*" mode="timestamp">
		<xsl:param name="format"/>
		<xsl:variable name="ticks">
			<xsl:call-template name="localtime">
				<xsl:with-param name="ticks" select="number(.)"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="timestamp">
			<xsl:with-param name="ticks" select="$ticks"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template><xsl:template match="*" mode="date">
		<xsl:param name="format"/>
		<xsl:variable name="ticks">
			<xsl:call-template name="localtime">
				<xsl:with-param name="ticks" select="number(.)"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="date">
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="ticks" select="$ticks"/>
		</xsl:call-template>
	</xsl:template><xsl:template match="*" mode="time">
		<xsl:variable name="ticks">
			<xsl:call-template name="localtime">
				<xsl:with-param name="ticks" select="number(.)"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="time">
			<xsl:with-param name="ticks" select="$ticks"/>
		</xsl:call-template>
	</xsl:template><xsl:template match="*" mode="iso8601-date">
		<xsl:variable name="ticks">
			<xsl:call-template name="localtime">
				<xsl:with-param name="ticks" select="number(.)"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="iso8601-date">
			<xsl:with-param name="ticks" select="$ticks"/>
		</xsl:call-template>
	</xsl:template><xsl:template name="date">
		<xsl:param name="format"/>
		<xsl:param name="ticks"/>
		<xsl:variable name="yearLeap" select="floor(1+ (number($ticks)-3*31536000) div (31536000*4 + 86400))"/>
		<xsl:variable name="year" select="1970 + floor((number($ticks)-$yearLeap*86400) div 31536000)"/>
		<xsl:variable name="yday" select="floor((number($ticks) - ($year - 1970)*31536000 - floor(($year - 1972) div 4)*86400) div 86400)"/>

		<xsl:variable name="dayLeap">
			<xsl:if test="$yday &gt;= 59 or $year mod 4 != 0">
				<xsl:value-of select="$yday"/>
			</xsl:if>
			<xsl:if test="not($yday &gt;= 59 or $year mod 4 != 0)">
				<xsl:value-of select="$yday + 1"/>
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="month">
			<xsl:call-template name="month">
				<xsl:with-param name="dayLeap" select="$dayLeap"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:variable name="day">
			<xsl:if test="$yday != 59 or $year mod 4 != 0">
				<xsl:value-of select="$dayLeap - substring('000031059090120151181212243273304334', 3 * $month - 2, 3)"/>
			</xsl:if>
			<xsl:if test="not($yday != 59 or $year mod 4 != 0)">
				29
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="monthString">
			<xsl:call-template name="monthString">
				<xsl:with-param name="dayLeap" select="$dayLeap"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:if test="$format = 'nice'">
			<xsl:value-of select="concat(format-number($day, '00'), '. ', $monthString, '. ', $year)"/>
		</xsl:if>

		<xsl:if test="not($format = 'nice')">
			<xsl:value-of select="concat(format-number($day, '00'), '.', $monthString, '.', substring($year,3,2))"/>
		</xsl:if>
	</xsl:template><xsl:template name="iso8601-date">
		<xsl:param name="ticks"/>
		<xsl:variable name="yearLeap" select="floor(1+ (number($ticks)-3*31536000) div (31536000*4 + 86400))"/>
		<xsl:variable name="year" select="1970 + floor((number($ticks)-$yearLeap*86400) div 31536000)"/>
		<xsl:variable name="yday" select="floor((number($ticks) - ($year - 1970)*31536000 - floor(($year - 1972) div 4)*86400) div 86400)"/>

		<xsl:variable name="dayLeap">
			<xsl:if test="$yday &gt;= 59 or $year mod 4 != 0">
				<xsl:value-of select="$yday"/>
			</xsl:if>
			<xsl:if test="not($yday &gt;= 59 or $year mod 4 != 0)">
				<xsl:value-of select="$yday + 1"/>
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="month">
			<xsl:call-template name="month">
				<xsl:with-param name="dayLeap" select="$dayLeap"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:variable name="day">
			<xsl:if test="$yday != 59 or $year mod 4 != 0">
				<xsl:value-of select="$dayLeap - substring('000031059090120151181212243273304334', 3 * $month - 2, 3)"/>
			</xsl:if>
			<xsl:if test="not($yday != 59 or $year mod 4 != 0)">
				29
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="monthString">
			<xsl:call-template name="monthString">
				<xsl:with-param name="dayLeap" select="$dayLeap"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:value-of select="concat($year , '-', $monthString, '-', format-number($day, '00'))"/>
	</xsl:template><xsl:template name="monthString">
		<xsl:param name="dayLeap"/>
		<xsl:param name="format"/>

		<xsl:if test="$format = 'nice'">
			<xsl:choose>
				<xsl:when test="$dayLeap  &lt;= 31"><xsl:text>Jan</xsl:text></xsl:when>
				<xsl:when test="$dayLeap  &lt;= 59"><xsl:text>Feb</xsl:text></xsl:when>
				<xsl:when test="$dayLeap  &lt;= 90"><xsl:text>Mar</xsl:text></xsl:when>
				<xsl:when test="$dayLeap  &lt;= 120"><xsl:text>Apr</xsl:text></xsl:when>
				<xsl:when test="$dayLeap  &lt;= 151"><xsl:text>Mai</xsl:text></xsl:when>
				<xsl:when test="$dayLeap  &lt;= 181"><xsl:text>Jun</xsl:text></xsl:when>
				<xsl:when test="$dayLeap  &lt;= 212"><xsl:text>Jul</xsl:text></xsl:when>
				<xsl:when test="$dayLeap  &lt;= 243"><xsl:text>Aug</xsl:text></xsl:when>
				<xsl:when test="$dayLeap  &lt;= 273"><xsl:text>Sep</xsl:text></xsl:when>
				<xsl:when test="$dayLeap  &lt;= 304"><xsl:text>Oct</xsl:text></xsl:when>
				<xsl:when test="$dayLeap  &lt;= 334"><xsl:text>Nov</xsl:text></xsl:when>
				<xsl:otherwise><xsl:text>Dec</xsl:text></xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="not($format = 'nice')">
			<xsl:choose>
				<xsl:when test="$dayLeap  &lt;= 31">01</xsl:when>
				<xsl:when test="$dayLeap  &lt;= 59">02</xsl:when>
				<xsl:when test="$dayLeap  &lt;= 90">03</xsl:when>
				<xsl:when test="$dayLeap  &lt;= 120">04</xsl:when>
				<xsl:when test="$dayLeap  &lt;= 151">05</xsl:when>
				<xsl:when test="$dayLeap  &lt;= 181">06</xsl:when>
				<xsl:when test="$dayLeap  &lt;= 212">07</xsl:when>
				<xsl:when test="$dayLeap  &lt;= 243">08</xsl:when>
				<xsl:when test="$dayLeap  &lt;= 273">09</xsl:when>
				<xsl:when test="$dayLeap  &lt;= 304">10</xsl:when>
				<xsl:when test="$dayLeap  &lt;= 334">11</xsl:when>
				<xsl:otherwise>12</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template><xsl:template name="time">
		<xsl:param name="ticks"/>
		<xsl:variable name="hour" select="floor((number($ticks) mod 86400) div 3600)"/>
		<xsl:variable name="minute" select="floor((number($ticks) mod 3600) div 60)"/>

		<xsl:value-of select="concat(format-number($hour, '00'), ':', format-number($minute, '00'))"/>
	</xsl:template><xsl:template name="timestamp">
		<xsl:param name="ticks"/>
		<xsl:param name="format"/>
		<xsl:variable name="yearLeap" select="floor(1+ (number($ticks)-3*31536000) div (31536000*4 + 86400))"/>
		<xsl:variable name="year" select="1970 + floor((number($ticks)-$yearLeap*86400) div 31536000)"/>
		
		<xsl:variable name="hour" select="floor((number($ticks) mod 86400) div 3600)"/>
		<xsl:variable name="minute" select="floor((number($ticks) mod 3600) div 60)"/>
		<xsl:variable name="second" select="number($ticks) mod 60"/>
		<xsl:variable name="yday" select="floor((number($ticks) - ($year - 1970)*31536000 - floor(($year - 1972) div 4)*86400) div 86400)"/>

		<xsl:variable name="dayLeap">
			<xsl:if test="$yday &gt;= 59 or $year mod 4 != 0">
				<xsl:value-of select="$yday"/>
			</xsl:if>
			<xsl:if test="not($yday &gt;= 59 or $year mod 4 != 0)">
				<xsl:value-of select="$yday + 1"/>
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="month">
			<xsl:call-template name="month">
				<xsl:with-param name="dayLeap" select="$dayLeap"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:variable name="day">
			<xsl:if test="$yday != 59 or $year mod 4 != 0">
				<xsl:value-of select="$dayLeap - substring('000031059090120151181212243273304334', 3 * $month - 2, 3)"/>
			</xsl:if>
			<xsl:if test="not($yday != 59 or $year mod 4 != 0)">
				29
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="monthString">
			<xsl:call-template name="monthString">
				<xsl:with-param name="dayLeap" select="$dayLeap"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:variable name="result">
			<xsl:if test="$format = 'nice'">
				<xsl:value-of select="concat(format-number($day, '00'), ' ', $monthString, ' ', substring($year,3,2), ', ' , format-number($hour, '00'), ':', format-number($minute, '00'))"/>
			</xsl:if>
			<xsl:if test="not($format = 'nice')">
				<xsl:value-of select="concat(format-number($day, '00'), '.', $monthString, '.', substring($year,3,2), '   ' , format-number($hour, '00'), ':', format-number($minute, '00'))"/>
			</xsl:if>
		</xsl:variable>
		<xsl:value-of select="$result"/>
	</xsl:template><xsl:template name="timespan">
		<xsl:param name="ticks"/>
		<xsl:variable name="hour" select="floor(number($ticks) div 3600)"/>
		<xsl:variable name="minute" select="floor((number($ticks) mod 3600) div 60)"/>
		<xsl:variable name="second" select="number($ticks) mod 60"/>

		<xsl:value-of select="concat(format-number($hour, '00'), ':', format-number($minute, '00'))"/>
	</xsl:template><xsl:template name="month">
		<xsl:param name="dayLeap"/>
		<xsl:choose>
			<xsl:when test="$dayLeap  &lt;= 31">1</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 59">2</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 90">3</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 120">4</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 151">5</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 181">6</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 212">7</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 243">8</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 273">9</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 304">10</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 334">11</xsl:when>
			<xsl:otherwise>12</xsl:otherwise>
		</xsl:choose>
	</xsl:template><xsl:template name="mmonth">
		<xsl:param name="dayLeap"/>
		<xsl:choose>
			<xsl:when test="$dayLeap  &lt;= 31">0</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 59">3</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 90">3</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 120">6</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 151">1</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 181">4</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 212">6</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 243">2</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 273">5</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 304">0</xsl:when>
			<xsl:when test="$dayLeap  &lt;= 334">3</xsl:when>
			<xsl:otherwise>5</xsl:otherwise>
		</xsl:choose>
	</xsl:template><xsl:template name="weekday">
		<xsl:param name="ticks"/>
		<xsl:variable name="year" select="1970 + floor(number($ticks) div 31536000)"/>
		<xsl:variable name="myear" select="(($year mod 100) + floor(($year mod 100) div 4)) mod 7"/>
		<xsl:variable name="mcentury" select="(3 - (floor($year div 100)) mod 4) * 2"/>
		<xsl:variable name="yday" select="floor((number($ticks) - ($year - 1970)*31536000 - floor(($year - 1972) div 4)*86400) div 86400)"/>

		<xsl:variable name="dayLeap">
			<xsl:if test="$yday &gt;= 59 or $year mod 4 != 0">
				<xsl:value-of select="$yday"/>
			</xsl:if>
			<xsl:if test="not($yday &gt;= 59 or $year mod 4 != 0)">
				<xsl:value-of select="$yday + 1"/>
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="month">
			<xsl:call-template name="month">
				<xsl:with-param name="dayLeap" select="$dayLeap"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:variable name="mmonth">
			<xsl:call-template name="mmonth">
				<xsl:with-param name="dayLeap" select="$dayLeap"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:variable name="day">
			<xsl:if test="$yday != 59 or $year mod 4 != 0">
				<xsl:value-of select="$dayLeap - substring('000031059090120151181212243273304334', 3 * $month - 2, 3)"/>
			</xsl:if>
			<xsl:if test="not($yday != 59 or $year mod 4 != 0)">
				29
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="mday" select="(number($day) mod 7 + number($mmonth) + $myear + $mcentury) mod 7"/>

		<xsl:call-template name="weekday-string">
			<xsl:with-param name="mday" select="$mday"/>
		</xsl:call-template>
	</xsl:template><xsl:template name="weekday-string">
		<xsl:param name="mday"/>
		<xsl:variable name="weekday">
			<xsl:choose>
				<xsl:when test="$mday= 0">So</xsl:when>
				<xsl:when test="$mday= 1">Mo</xsl:when>
				<xsl:when test="$mday= 2">Di</xsl:when>
				<xsl:when test="$mday= 3">Mi</xsl:when>
				<xsl:when test="$mday= 4">Do</xsl:when>
				<xsl:when test="$mday= 5">Fr</xsl:when>
				<xsl:when test="$mday= 6">Sa</xsl:when>
				<xsl:otherwise>So</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:value-of select="$weekday"/>
	</xsl:template><xsl:template name="localtime">
		<xsl:param name="ticks"/>
		<xsl:choose>
			
			<xsl:when test="not(number($ticks) &gt; 1206838800)"><xsl:value-of select="number($ticks) + (3600 * 1)"/></xsl:when>
			<xsl:when test="not(number($ticks) &gt; 1224982800) and number($ticks) &gt;= 1206838800"><xsl:value-of select="number($ticks) + (3600 * 2)"/></xsl:when>
			
			
			<xsl:when test="not(number($ticks) &gt; 1238288400) and number($ticks) &gt;= 1224982800"><xsl:value-of select="number($ticks) + (3600 * 1)"/></xsl:when>
			<xsl:when test="not(number($ticks) &gt; 1256432400) and number($ticks) &gt;= 1238288400"><xsl:value-of select="number($ticks) + (3600 * 2)"/></xsl:when>
			
			
			<xsl:when test="not(number($ticks) &gt; 1269738000) and number($ticks) &gt;= 1256432400"><xsl:value-of select="number($ticks) + (3600 * 1)"/></xsl:when>
			<xsl:when test="not(number($ticks) &gt; 1288486800) and number($ticks) &gt;= 1269738000"><xsl:value-of select="number($ticks) + (3600 * 2)"/></xsl:when>
			
			
			<xsl:when test="not(number($ticks) &gt; 1301187600) and number($ticks) &gt;= 1288486800"><xsl:value-of select="number($ticks) + (3600 * 1)"/></xsl:when>
			<xsl:when test="not(number($ticks) &gt; 1319936400) and number($ticks) &gt;= 1301187600"><xsl:value-of select="number($ticks) + (3600 * 2)"/></xsl:when>
			
			
			<xsl:when test="not(number($ticks) &gt; 1332550800) and number($ticks) &gt;= 1319936400"><xsl:value-of select="number($ticks) + (3600 * 1)"/></xsl:when>
			<xsl:when test="not(number($ticks) &gt; 1351378800) and number($ticks) &gt;= 1332550800"><xsl:value-of select="number($ticks) + (3600 * 2)"/></xsl:when>
			
			
            		<xsl:when test="not(number($ticks) &gt; 1364691600) and number($ticks) &gt;= 1351378800"><xsl:value-of select="number($ticks) + (3600 * 1)"/></xsl:when>
            		<xsl:when test="not(number($ticks) &gt; 1382835600) and number($ticks) &gt;= 1364691600"><xsl:value-of select="number($ticks) + (3600 * 2)"/></xsl:when>
            
			<xsl:otherwise>
				<xsl:value-of select="number($ticks) + (3600 * 1)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template><xsl:template name="toc">
		<xsl:param name="id">
			
		</xsl:param>
		<xsl:param name="heading"/>
		<xsl:param name="nodes"/>
		<xsl:param name="content"/>

		<div class="toc smartNumbering">
			<xsl:if test="$id != ''">
				<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$heading">
				<heading class="h3"><xsl:copy-of select="$heading"/></heading>
			</xsl:if>
			<xsl:if test="not($heading)">
				<heading class="h3"><xsl:text>Índice</xsl:text></heading>
			</xsl:if>
			<ol>
				<xsl:if test="$content">
					<xsl:copy-of select="$content"/>
				</xsl:if>
				<xsl:if test="($nodes)">
					<xsl:apply-templates select="$nodes" mode="toc"/> 
				</xsl:if>
			</ol>
		</div>
	</xsl:template><xsl:template name="js-string">
		<xsl:param name="s"/>

		<xsl:text>'</xsl:text>
		<xsl:call-template name="js-string-escape-content">
			<xsl:with-param name="s" select="$s"/>
		</xsl:call-template>
		<xsl:text>'</xsl:text>
	</xsl:template><xsl:template name="js-string-escape-content">
		<xsl:param name="s"/>

		<xsl:choose>
			<xsl:when test="$s = ''"/>
			<xsl:otherwise>
				<xsl:call-template name="js-string-escape-content-char">
					<xsl:with-param name="c" select="substring($s, 0, 1)"/>
				</xsl:call-template>
				<xsl:call-template name="js-string-escape-content">
					<xsl:with-param name="s" select="substring($s, 1)"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template><xsl:template name="js-string-escape-content-char">
		<xsl:param name="c"/>
		<xsl:choose>
			<xsl:when test="$c = '\'">
				<xsl:text>\\</xsl:text>
			</xsl:when>
			<xsl:when test="$c = &quot;'&quot;">
				<xsl:text>\'</xsl:text>
			</xsl:when>
			<xsl:when test="$c = '&#10;'">
				<xsl:text>\n</xsl:text>
			</xsl:when>
			<xsl:when test="$c = '&#13;'">
				<xsl:text>\r</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>X</xsl:text>
				
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template></xsl:stylesheet>
