
(function (N) {
	"use strict";

//#require "base.js"

/* Einfache Benachrichtigungen.
 * Listener werden mit .add(f) hinzugefügt, wenn .notify(p) aufgerufen wird,
 * werden alle diese Listener mit f(p) aufgerufen.
 *
 * >>> nEvent = new Notifier();
 * >>> nEvent.add(callback1);
 * >>> nEvent.add(callback2);
 * >>> nEvent.notify(123);
 */
function Notifier() {
	this.listeners = [];
}
N.Notifier = Notifier;

// log if |this.debuglog| is true
Notifier.prototype.log = Fun.noaction;

/**Eine Funktion hinzufügen, die benachrichtigt werden soll.
 * Gibt den Index des neuen Elements zurück (aber der ist nicht besonders 
 * nützlich)
 */
Notifier.prototype.add = function(fun) {
	this.listeners.push(fun);
	this.log("added listener, now "+this.listeners.length+" listeners");
	return this.listeners.length - 1;
};

Notifier.prototype.clear = function() {
	this.listeners = [];
};

//Notifier.prototype.remove = function(idx) {
// // Funktioniert nicht da sich die Indizes der folgenden Elemente dadurch ändern
//	this.listeners.splice(idx, 1);
//}

/* INTERNAL
 * Zum Überschreiben, Benachrichtigung eines einzelnen callbacks
 */
Notifier.prototype.notifyOne = function(f, args) {
	// Wenn |f| |this| benutzt, sollte das schon mit f.bind(this) festgesetzt
	// worden sein
	f.apply(null, args);
};

Notifier.prototype.notify = function() {
	this.log("notifying "+this.listeners.length+" listeners");
	var args = jQuery.makeArray(arguments);
	var i, l;
	for (i = 0, l = this.listeners.length; i < l; ++i) {
		this.notifyOne(this.listeners[i], args);
	}
};


/*
testSuite.add(function() {
	// Grundsätzliche Funktionalität
	var n = new Notifier();
	var np = null, nq = null;
	function func(p, q) {
		np = p;
		nq = q;
	}
	n.add(func);
	n.notify(1, 2);
	assert(np == 1);
	assert(nq == 2);

	// Aufruf von gebundenen Objektmethoden
   function C(i) {this.i = i;}
	C.prototype.f = function(p,q) {
		np += p+this.i;
		nq += q+this.i;
	}
	var c1 = new C(1);
	var c2 = new C(2);
	
	np = 0; nq = 0;
	n = new Notifier();
	n.add(c1.f.bind(c1));
	n.notify(1,2);
	assert(np == 2);
	assert(nq == 3);

	// Zweite Benachrichtigung
	np = 0; nq = 0;
	n.add(c2.f.bind(c2));
	n.notify(1,2);
	assert(np == 5);
	assert(nq == 7);
})
*/


/**Einmalige Benachrichtigung über ein Ereignis. Listener können auch noch
 * hinzugefügt werden, nachdem das Ereignis schon eingetreten ist, sie werden
 * dann sofort benachrichtigt.
 */
var DeferredNotifier = function DeferredNotifier() {
	Notifier.call(this);
	this.notified = false;
	this.ignoredouble = false;
};
N.DeferredNotifier = DeferredNotifier;
DeferredNotifier.prototype = new Notifier();

// Exceptionklasse
function EDoubleNotification() { Error.apply(this, arguments); }
EDoubleNotification.prototype = new Error();

// |doubleok| kann problemlos |undefined| sein
// TODO: passt nicht mit dm späteren |arguments| zusammen
DeferredNotifier.prototype.notify = function(doubleok) {
	if (this.notified) {
		if (doubleok || this.ignoredouble) {
			// Keine Exception
			return;
		}
		else {
			throw new EDoubleNotification("Notification already called");
		}
	}
	this.notified = true;
	this.args = jQuery.makeArray(arguments);
	Notifier.prototype.notify.apply(this, this.args);
};

DeferredNotifier.prototype.add = function(fun) {
	Notifier.prototype.add.call(this, fun);
	if (this.notified) {
		this.notifyOne(fun, this.args);
	}
};

/* Löschen einer gespeicherten Benachrichtigung. Nach diesem Aufruf kann 
 * .notify() wieder neu aufgerufen werden
 */
DeferredNotifier.prototype.clearNotification = function() {
	if (this.notified) {
		this.notified = false;
		delete this.args;
	}
};

/*
testSuite.add(function() {
	// Grundsätzliche Funktionalität
	var n = new DeferredNotifier();
	var np = null, nq = null;
	function func(p, q) {
		np = p;
		nq = q;
	}
	n.add(func);
	n.notify(1, 2);
	assert(np == 1);
	assert(nq == 2);

	// Aufruf von gebundenen Objektmethoden
   function C(i) {this.i = i;}
	C.prototype.f = function(p,q) {
		np += p+this.i;
		nq += q+this.i;
	}
	var c1 = new C(1);
	var c2 = new C(2);
	
	np = 0; nq = 0;
	n = new DeferredNotifier();
	n.add(c1.f.bind(c1));
	n.notify(1,2);
	assert(np == 2);
	assert(nq == 3);

	// Zweite Benachrichtigung
	n.add(c2.f.bind(c2));
	assert(np == 5);
	assert(nq == 7);

	// Nochmal, direkt
	n.clearNotification();
	np = 0; nq = 0;
	n.notify(2,1);
	assert(np = 7);
	assert(nq = 5);
})
*/

})(window);


(function (N) {
	"use strict";

//#require "base.js"
//#require "notify.js"
//#require "xmlutils.js"

/* Notification mit Zusatzbedingungen
 * Braucht |XPath|.
 */

/**|Notification| ist das Gegenstück zu |Notifier|, hier wird also eine
 * *empfangene* Benachrichtigung manipuliert.
 * 
 * Überprüft auf eine XPath-expression, bevor benachrichtigt wird
 *
 * |xpexpr|: XPath-Expression auf die überprüft wird
 * |fun|: Funktion die aufgerufen wird
 * |multi|: Erwartet (möglicherweise) mehrere Treffer des XPath und übergibt
 * dann ein Array mit allen Matches
 */
function XPathNotification(xpexpr, fun, multi) {
	this.fun = fun;
	this.xpexpr = xpexpr;
	this.multi = multi;
}

// Vielleicht nicht gut, da sehr viele davon zu haben, daher "statisch"...
XPathNotification.xpath = new XPath();

XPathNotification.prototype.log = Fun.noaction;

/**Benachrichtigung, falls die XPath-Expression auf das xml passt
 *
 * |xml| Zugrundeliegendes Xmldokument
 * |curnode| s. Notifier
 */
XPathNotification.prototype.notify = function(/*xml, curnode, [...]*/) {
	var args = jQuery.makeArray(arguments);
	var xml = args.shift();
	var curnode = args.shift();
	if (!xml) {
		throw new Error("xml expected");
	}

	//var xpath = XPathNotification.xpath;
	var xpath = new XPath();
	var xpmatch = null;

	xpath.evaluate(this.xpexpr, xml, curnode);
	if (this.multi) {
		xpmatch = [];
		var match;
		while ((match = xpath.iterateNext())) {
			xpmatch.append(match);
		}
		if (xpmatch.empty)
			xpmatch = null;
	}
	else {
		xpmatch = xpath.iterateNext();
		if (xpath.iterateNext()) {
			log.error("Additional data after request result");
		}
	}
	this.log((xpmatch !== null)+": ?? xml matches xpath<"+this.xpexpr+">");
	if (xpmatch !== null) {
		// Hinzufügen von |xml| und dem/den getroffenen Knoten zu den Argumenten
		// der zu benachrichtigenden Funktion
		args.unshift(xml, xpmatch);
		return this.fun.apply(null, args);
	}
};

/* Utility function
 * Gibt eine Funktion zurück, die sich direkt an einen Notifier übergeben lässt
 * (falls der geeignete Parameter produziert)
 */
N.xpathNotification = function(xpexpr, fun, multi) {
	var xpn = new XPathNotification(xpexpr, fun, multi);
	return xpn.notify.bind(xpn);
};

/* TODO:
this.nCommand.addOnXPath = function(xpexpr, fun) {
	this.add(xpathNotification(xpexpr, fun));
}
*/																	

/*
testSuite.add(function() {
	var n = new Notifier();
	n.addOnXPath = function() {
		this.add(xpathNotification.apply(null, arguments));
	}

	var oarg = 123;
	n.addOnXPath("/html/body/div[@id='xpathnotifytest']", function(xpmatch, arg) {
		assert(xpmatch.firstChild.nodeValue == "testval");
		assert(arg == oarg);
	});

	n.addOnXPath("/html/nonexistant", function() {
		assert(false);
	});

	n.notify(document, null, oarg);
});
*/

})(window);


(function (N) {
	"use strict";

// Disable for IE debugging:
N.handle_ajax_exceptions = true;

//#require "base.js"
//#require "notify.js"

/* AjaxManager und Hilfsklassen
 * Hauptklassen zur allgemeinen Benutzung:
 *   |Ajax| am Ende, Grundgerüst für verschiedenartige Ajax-Aufrufe
 */

/* Utility-Funktion um addOnXPath zu Notifiers hinzuzufügen, die
 * ein Request-objekt als Parameter bekommen
 */
function addOnXPath_req(xpexpr, fun, multi) {
	//log.debug("registering ajax event handler for " + xpexpr);
	// TODO: entfernen und direkt mit den richtigen Parametern aufrufen
	var xpn = xpathNotification(xpexpr, fun, multi);
	this.add(function(req) {
		var xml = req.xmlHttp.responseXML;
		if (!xml) {
			throw new Error("XML response from server expected",
					req.xmlHttp.responseText);
		}
		return xpn(xml, null, req);
	});
}

/* Klasse für individuelle Ajax Requests. Von einer |Ajax| Klasse erzeugt um
 * einen Request dem AjaxManager zu übergeben.
 * Dieses Requestobjekt sollte alle *veränderlichen* Informationen enthalten,#
 * die nötig sind um den Request auszuführen. Für die eigentliche Arbeit werden
 * aber Funktionen des entsprechenden |creator|s aufgerufen, üblicherweise eine
 * von |Ajax| abgeleitetet Klasse. Dadurch befindet sich aller Programmcode
 * der eine bestimmte Ajax-Aktion betrifft in der entsprechenden |Ajax| Klasse
 * Und die Funktionen, die die das XmlHttp-Objekt initialisieren haben direkt
 * Zugriff auf möglicherweise zusätzlich vorhandene Informationen in der |Ajax|-
 * Klasse.
 * Da dies aber erst später geschieht, wenn der Request vom AjaxManager 
 * ausgeführt wird, können zwischenzeitlich z.B. schon weitere parallele 
 * Requests von der gleichen |Ajax|-Klasse gestartet worden sein. Informationen,
 * die sich also von Request zu Request ändern (z.B. der Querystring), müssen
 * daher im jeweiligen |AjaxRequest| gespeichert werden, unveränderliche
 * Informationen müssen aber nicht von |Ajax| in |AjaxRequest| übertragen 
 * werden.
 * Um zusätzliche Informationen im AjaxRequest zu speichern, weist man am 
 * einfachsten dynamisch neue Property-Felder zu, anstatt eine neue Klasse
 * abzuleiten.
 *
 * >>> var ar = new AjaxRequest(this, ajaxManager, true);
 * >>> ar.somemetadata = 'asdadadasd';
 * >>> ar.runManaged();
 *
 * |asynchron| muss immer übergeben werden, da es für das Scheduling des
 * Managers wichtig ist.
 */
function AjaxRequest(creator, manager, asynchron) {
	this.creator = creator;
	this.manager = manager;
	this.asynchron = asynchron;

	this.dnDataReady = new DeferredNotifier();
	this.dnDataReady.addOnXPath = addOnXPath_req;
	// .add(function(req))
	// .addOnXPath(xpexpr, function(xmlDoc, xmlNode, req))

	this.dnAjaxError = new DeferredNotifier();
	// .add(function(req, error)

	this.dnRequestCompleted = new DeferredNotifier();
	this.dnRequestCompleted.ignoredouble = true;

	if (this.manager !== undefined) {
		// Sollte nur während prototyping |undefined| sein
		this.xmlHttp = this.manager.makeXmlHttp();
		this.xmlHttp.onreadystatechange = this.readyStateChangeCB.bind(this);
		if (!is_ie) {
			this.xmlHttp.onerror = this.errorCB.bind(this);
		}
		this.requestId = AjaxRequest.nextRequestId++;
	}
	if (typeof this.init != 'undefined') {
		this.init();
	}
}
N.ajaxRequest = AjaxRequest;
AjaxRequest.nextRequestId = 0;

AjaxRequest.prototype.log = Fun.noaction;

/* PUBLIC
 * Fügt den Request dem zugehörigen AjaxManager zu
 */
AjaxRequest.prototype.runManaged = function() {
	this.manager.addRequest(this);
};


AjaxRequest.prototype.abortRequest = function() {
	this.manager.abortRequest(this);
};

/* PRIVATE
 * Callback vom XmlHttp, benachrichtigt ggf. |dnDataReady|
 */
AjaxRequest.prototype.readyStateChangeCB = function() {
	function doNotify() {
		if (this.xmlHttp.responseXML === null) {
			// vielleicht besser einfach throw, dnAjaxError entfernen
			this.dnAjaxError.notify(this,
					new Error("Server returned no xml: " +
							this.xmlHttp.responseText));
		}
		else {
			this.dnDataReady.notify(this);
		}
	}

	function safeRunNotify() {
		try {
			try {
				doNotify.call(this);
			}
			finally {
				this.dnRequestCompleted.notify(this);
			}
		}
		catch(e) {
			log.exception(e, "Unhandled Exception in AjaxRequest.dnDataReady handler",
					"in handler for request #" + this.requestId);
		}
	}

	function unsafeRunNotify() {
		doNotify.call(this);
		this.dnRequestCompleted.notify(this);
	}

	if (this.xmlHttp.readyState != 4)
		return;
	this.log("request #"+this.requestId+' got readyState==4');

	if (N.handle_ajax_exceptions)
		safeRunNotify.call(this);
	else
		unsafeRunNotify.call(this);
};

/* PRIVATE
 * Errorcallback vom XmlHttp, benachrichtigt |onAjaxError|
 */
AjaxRequest.prototype.errorCB = function(err) {
	try {
		this.log("request #"+this.requestId+" XmlHttp called error-callback");
		try {
			this.dnAjaxError.notify(this, err);
		}
		finally {
			this.dnRequestCompleted.notify(this);
		}
	}
	catch (e) {
		// Würde alles vom aufrufenden XmlHttpRequest stillschweigend ignoriert
		log.exception(e, "Unhandled Exception in XmlHttpRequest.onerror handler",
				"in handler for request #" + this.requestId);
	}
};

/* INTERNAL
 * Wird vom AjaxManager/Thread aufgerufen, wenn der Request tatsächlich ausgeführt werden soll
 */
AjaxRequest.prototype.process = function() {
	this.log("request #"+this.requestId+' processing...');
	try {

		this.startRequest();
		// scheint auch für synchron die entsprechenden on...-Funktionen
		// aufzurufen
		if (!this.asynchron) {
			// TODO: Wurde schon aufgerufen, nicht nochmal machen. (Untersuchen)
			this.dnRequestCompleted.notify(this);
		}
	}
	catch (e) {
		// Initialisierung fehlgeschlagen
		log.exception(e, "Starting request #"+this.requestId+" failed");
		this.dnRequestCompleted.notify(this);
	}
	finally {
	}
	/*
	finally {
		// Egal was passiert, im synchronen Fall ist der Request zu Ende
		// TODO: Die verschiedenen synchron/asynchron Fälle noahc besser untersuchen,
		// welche Handler da wann schon automatisch aufgerufen werden
		if (!this.asynchron) {
			try {
				this.dnRequestCompleted.notify(this);
			}
			//catch (e if (e instanceof EDoubleNotification))
			catch (e) {
				if (e instanceof EDoubleNotification) {
					// tritt auf, falls dnRequestCompleted schon aufgerufen wurde
					// Kann evt. vorkommen, ist hier aber ok. Es muss nur sichergestellt
					// sein, dass es tatsächlich einmal aufgerufen wird.
					// Kann aber auch sein, dass es *immer* schon vorher aufgerufen wurde,
					// dann ist das hier überflüssig.
					// TODO: Im asynchronen Fall muss das auch bei allen möglichen
					// Aktionen sichergestellt sein.
				}
				else {
					throw e;
				}
			}
		}
	}
	*/
};

/* PRIVATE
 * Wird durch Aufruf von setGetRequest() oder setPostRequest() mit der entsprechenden
 * Methode für GET/POST überschrieben
 */
AjaxRequest.prototype.startRequest = function() {
	alert('error: AjaxRequest: Request type not set (GET/POST).\nUse setGetRequest() or setPostRequest()');
};

/* PRIVATE
 * Starte GET Request (callback -> creator)
 */
AjaxRequest.prototype.startGetRequest = function() {
	this.creator.initGetRequest(this);
};

/* PUBLIC
 * Requesttyp auf GET setzen
 */
AjaxRequest.prototype.setGetRequest = function() {
	this.startRequest = this.startGetRequest;
};

/* PRIVATE
 * Starte POST Request (callback -> creator)
 */
AjaxRequest.prototype.startPostRequest = function() {
	this.creator.initPostRequest(this);
};

/* PUBLIC
 * Requesttyp auf POST setzen
 */
AjaxRequest.prototype.setPostRequest = function() {
	this.startRequest = this.startPostRequest;
};

/* PRIVATE
 * Kein XmlHttp verfügbar (callback -> creator)
 */
AjaxRequest.prototype.noXmlHttpFallback = function() {
	this.creator.noXmlHttpFallback(this);
};


// Wahrscheinlich unnütz
/*
function AjaxGetRequest(creator, querystring) {
	AjaxRequest.call(creator, querystring);
	this.startRequest = this.startGetRequest;
}
AjaxGetRequest.prototype = new AjaxRequest();

function AjaxPostRequest() {
	AjaxRequest.call(creator, querystring);
	this.startRequest = this.startPostRequest;
}
AjaxPostRequest.prototype = new AjaxRequest();
*/


// Basic Factory für Ajax-Requests

function XMLHttpRequestFactory() {
	return new XMLHttpRequest({ mozSystem: true });
}

function ActiveXXMLHTTPFactory() {
	var ActiveX_XMLHTTP = "MSXML2.XMLHTTP";
	return new ActiveXObject(ActiveX_XMLHTTP);
}

function NoXmlHttpFactory() {
	log.error(new Error("No XmlHttpRequest class available"));
	return null;
}

function getXmlHttpFactory() {
	var xmlHttp = null;
	if (typeof XMLHttpRequest != 'undefined') {
		return XMLHttpRequestFactory;
	}
	else if (typeof ActiveXObject != 'undefined') {
		try {
			var tmp = ActiveXXMLHTTPFactory();
			return ActiveXXMLHTTPFactory;
		}
		catch (e) {
			return NoXmlHttpFactory;
		}
	}
}


/* PUBLIC
 * Manager für Ajax Requests
 * Üblicherweise nur eine globale Instanz, allgemeiner am besten eine Instanz
 * pro Domain.
 */
function AjaxManager(max) {
	this.max = max;
	this.current = 0;
	this.queue = [];

	this.makeXmlHttp = getXmlHttpFactory();
	this.hasXmlHttp = (this.makeXmlHttp() !== null);
}

AjaxManager.prototype.log = Fun.noaction;
//AjaxManager.prototype.log = taggedLogging('[AJAX:Manager]', log);

/* PUBLIC
 * |AjaxRequest| hinzufügen
 * Üblicherweise indirekt aufgerufen:
 * >>> ar = new AjaxRequest(this, manager, asc);
 * >>> ar.runManaged();
 */
AjaxManager.prototype.addRequest = function(req) {
	if (!this.hasXmlHttp) {
		req.noXmlHttpFallback();
		return;
	}

	if ((!req.asynchron) || (this.current < this.max)) {
		this.processRequest(req);
	}
	else {
		this.log("queueing request #"+req.requestId+
				" (now "+this.current+" running)");
		this.queue.push(req);
	}
};

AjaxManager.prototype.abortRequest = function(req) {
	var i;
	// check if request is in queue
	for (i=0; i<this.queue.length; i++) {
		if (this.queue[i] === req) {
			this.queue.splice(i, 1);
			return;
		}
	}

	// Was not in queue, is already running.
	this.current--;
	// Remove event handlers.
	req.dnDataReady.clear();
	req.dnAjaxError.clear();
	// abort request, if possible
	if (req.xmlHttp.abort) {
		req.xmlHttp.abort();
		req.dnRequestCompleted.notify();
	}
};

AjaxManager.prototype.processRequest = function(req) {
	this.current++;
	//try {
	this.log("process request #"+req.requestId+(req.asynchron ? "" : "[sync]")+
			"  (now "+this.current+" running)");

		req.dnRequestCompleted.add(this.requestDone.bind(this));
		// already handled in req.process

		req.process();
	//}
	//catch (e) {
		//this.current--;
		//throw e;
	//}
	//catch (e) {
		// AjaxManager sollte immer überleben, egal was der aufrufende Code macht
		//log.exception(e, "AjaxManager: Unhandled Exception processing AjaxRequest #"+
				//req.requestId);
		//this.current--;
	//}
};

AjaxManager.prototype.requestDone = function(req) {
	this.current--;
	this.log("completed request #"+req.requestId+
			" (now "+this.current+" running)");

	while (this.current < this.max && this.queue.length > 0) {
		this.processRequest(this.queue.shift());
	}
};

// Globaler AjaxManager
var ajaxManager = new AjaxManager(2);
//if (is_ie) {
//	ajaxManager.log = taggedLogging('AJAX:Manager', log.debug);
//}
//AjaxRequest.prototype.log = taggedLogging('AJAX:Request', logDebug);


function LoadingScreen(show, hide) {
	// Quick-and-dirty Funktionen überschreiben, falls zu faul zum expliziten Ableiten
	if (isdefined(show))
		this.show = show;
	if (isdefined(hide))
		this.hide = hide;
}
N.LoadingScreen = LoadingScreen;
LoadingScreen.prototype.show = function() {};
LoadingScreen.prototype.hide = function() {};


/* Klasse für Ajax-Aktionen, produziert einzelne Requests, die dann vom AjaxManager
 * weiterverarbeitet werden.
 * 
 * Zum Ausführen wird aufgerufen:
 *   startGetRequest, startPostRequest
 * Subklassen überschreiben am ehesten:
 *   makeRequest, initGetRequest, initPostRequest, noXmlHttpFallback
 */
function Ajax(manager, RequestType) {
	// Default parameter values
	if (manager === undefined)
		manager = ajaxManager;
	if (RequestType === undefined)
		RequestType = AjaxRequest;

	this.manager = manager;
	this.RequestType = RequestType;
	this.loadingScreen = undefined;
	this.nDataReady = new Notifier();
	this.nDataReady.addOnXPath = addOnXPath_req;
	this.nAjaxError = new Notifier();
	// .add(function(req))
	// .addOnXPath(xpexpr, function(xmlDoc, xmlNode, req))
	this.nRequestCompleted = new Notifier();

	this.asynchron = true;
	// TODO entfernen?
	this.progressHtml = "<table style='width: 100%; height:100%;'><tr><td valign='middle' align='center'><img src='/img/32x32/ajax_loader.gif' alt='loading ...'/></td></tr></table>";
}
N.Ajax = Ajax;
Ajax.prototype.log = Fun.noaction;


/* Ähnlich bisheriger |update|-Funktion, aber: bekommt |AjaxRequest| als Parameter
 * und wird nur bei readystate=4 aufgerufen
 */
Ajax.prototype.onDataReady = function(req) {
	this.nDataReady.notify(req);
};

Ajax.prototype.onAjaxError = function(req, e) {
	log.exception(e, "Ajax request #"+req.requestId+" failed.");
	this.nAjaxError.notify(req);
};

Ajax.prototype.onRequestCompleted = function(req, e) {
	this.nRequestCompleted.notify(req);
};

/* INTERNAL
 * Erstelle Request und setze evt. zusätzliche Variablen.
 * Dies erzeugt das |AjaxRequest|-Objekt, dass dann dem AjaxManager übergeben
 * wird.
 * Danach wird nur noch GET/POST festgelegt
 */
Ajax.prototype.makeRequest = function(url, querystring, loadingScreen) {
	requireArgs(arguments, 1, 3);
	if (typeof(url) == "object") {
		loadingScreen = querystring;
		querystring = url.querystring();
		url = url.scriptUrl;
	}
	if (!isdefined(loadingScreen))
		loadingScreen = this.loadingScreen;
	if (loadingScreen) {
		loadingScreen.show();
	}
	var req = new (this.RequestType)(this, this.manager, this.asynchron);
	req.url = url;
	req.querystring = querystring;
	if (loadingScreen) {
		req.dnRequestCompleted.add(loadingScreen.hide.bind(loadingScreen));
	}
	req.resultObject = this.resultObject;
	if (this.resultObject && !is_ie) {
		this.resultObject.innerHTML = this.progressHtml;
	}
	req.dnDataReady.add(this.onDataReady.bind(this));
	req.dnAjaxError.add(this.onAjaxError.bind(this));
	req.dnRequestCompleted.add(this.onRequestCompleted.bind(this));
	return req;
};


/* PUBLIC
 * Starte einen GET Request
 * |loadingScreen| ist optional
 */
Ajax.prototype.startGetRequest = function(url, querystring, loadingScreen) {
	var req = this.makeRequest(url, querystring, loadingScreen);
	//req.url = url;
	req.setGetRequest();
	req.runManaged();
	return req;
};

/* INTERNAL
 * Starte den XmlHttp GET Request (Callback vom AjaxManager)
 * Hier wird der entsprechende Request |req| tatsächlich initiiert und der 
 * Aufruf über req.xmlHttp ausgelöst.
 */
Ajax.prototype.initGetRequest = function(req) {
	var url =  req.url;
	if (req.querystring !== "") {
		if (url.search(/\?/) != -1) {
			url += "&";
		}
		url += req.querystring;
	}
	req.xmlHttp.open("GET", url, req.asynchron);
	// warum true und nicht req.asynchron? kein synchrones GET mgl.?
	req.xmlHttp.send(null);
};

/* PUBLIC
 * Starte einen POST Request
 * Gibt den Request zurück. ABER: ggf. schon gestartet, nur nützlich, um
 * zusätzliche Funktionen als Listeners auf dnDataReady, dnAjaxError oder so
 * hinzuzufügen.
 */
Ajax.prototype.startPostRequest = function(url, querystring, loadingScreen) {
	var req = this.makeRequest(url, querystring, loadingScreen);
	req.setPostRequest();
	req.runManaged();
	return req;
};

/* INTERNAL
 * Starte den XmlHttp POST Request (Callback vom AjaxManager)
 * Hier wird der entsprechende Request |req| tatsächlich initiiert und der Aufruf
 * über req.xmlHttp ausgelöst.
 */
Ajax.prototype.initPostRequest = function(req) {
	req.xmlHttp.open("POST", req.url, req.asynchron);
	req.xmlHttp.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
	// Der querystring wird encodeURI() erwartet und ist in UTF8
	req.xmlHttp.send(req.querystring);
};

/* INTERNAL
 * Kein XmlHttp verfügbar (Callback vom AjaxManager)
 */
Ajax.prototype.noXmlHttpFallback = function(req) {
	//document.open(this.url +  "&" + querystring + "&lang=" + document.dict.lang.value + "&lp=" + document.dict.lp.value + "&ajax=false", "PopUpInfo", "width=500,height=400,left=0,top=0, menubar=yes, resizable=yes, scrollbars=yes, location=yes, toolbar=yes, status=yes");
};

// Globales Standard-Ajax
N.ajax = new Ajax();

// IE xslt workaround
N.xsltAjax = new Ajax();
N.xsltAjax.asynchron = false;

//AjaxRequest.prototype.log = taggedLogging('Ajax:Request', logDebug);
//Notifier.prototype.log = taggedLogging('Notifier', logDebug);

// Tests
/*
testSuite.add(function() {
	var am = new AjaxManager(2);
	am.log = taggedLogging('AJAX:Manager', logDebug);
	var ajax = new Ajax(am);
	ajax.url = 'http://localhost/car2map/customer/index.xml?';

	ajax.onDataReady = function(req) {
		alert('Erfolg.' + req.xmlHttp.responseText);
	}
	ajax.onAjaxError = function(req, err) {
		alert('Fehler: '+err);
		assert(false);
	}

	ajax.asynchron = true;
	var req = ajax.startPostRequest('some=value');
	var req = ajax.startPostRequest('some=value');
	var req = ajax.startPostRequest('some=value');
	ajax.asynchron = false;
	var req = ajax.startPostRequest('some=value');
});
*/

})(window);


(function (N) {
	"use strict";

//#require "base.js"
//#require "advnotify.js"
//#require "xmlutils.js"
//#require "ajaxmanager.js"

/* Erwartet als Ergebnis eine XML-Datei, in der jedes Tag einem Kommando entspricht.
 * Für die wird dann jeweils |nCommand| benachrichtigt.
 */
function AjaxCommandReceiver() {
	Ajax.apply(this, arguments);
	this.nCommand = new Notifier();
	// .add(function(xmlDoc, xmlNode, req))

	this.nCommand.addOnXPath = function(xpexpr, fun) {
		this.add(xpathNotification(xpexpr, fun));
	};
	// .addOnXPath(xpexpr, function(xmlDoc, xmlNode, req))
}
AjaxCommandReceiver.prototype = new Ajax();

/* OVERWRITE
 * |nCommand| für die einzelnen Elemente des Dokuments aufrufen.
 */
AjaxCommandReceiver.prototype.onDataReady = function(req) {
	Ajax.prototype.onDataReady.call(this, req);
	var xml = req.xmlHttp.responseXML;
	if (!xml) {
		throw new Error("XML response from server expected",
				req.xmlHttp.responseText);
	}
	var node = xml.documentElement.firstChild;
	while (node) {
		if (node.nodeType === Dom.ELEMENT_NODE) {
			this.nCommand.notify(xml, node, req);
		}
		node = node.nextSibling;
	}
	/*

	var xp = new XPath();
	xp.evaluate('/form/*', xml);
	var node;
	while (node = xp.iterateNext()) {
		this.nCommand.notify(xml, node, req);
	}
	*/
};


/* Funktionen für verschiedene über Ajax ausgelöste Aktionen */
Ajax.Action = {};

Ajax.Action.url = function(xml, node, req) {
	//req.creator.url = node.firstChild.nodeValue + "?ajax=form";
	var urlNode = XPath.getSingleNode("./child::text()", xml, node);
	if (!urlNode) {
		log.exception(new Error(), "Parse error in server response");
		return;
	}
	req.creator.url = urlNode.nodeValue + "&ajax=form"; // ?
};

Ajax.Action.eval = function(xml, node, req) {
	var evalNode = XPath.getSingleNode("./child::text()", xml, node);
	if (!evalNode) {
		log.exception(new Error(), "Parse error in server response");
		return;
	}
	jQuery.globalEval(evalNode.nodeValue);
};

Ajax.Action.error = function(xml, node, req) {
	var msgNode = XPath.getSingleNode("./child::text()", xml, node);
	if (!msgNode) {
		log.exception(new Error(), "Parse error in server response");
		return;
	}
	log.error("Server returned error for ajax-request #"+req.requestId+": "+
			msgNode.nodeValue);
};

Ajax.Action.remove = function(xml, node, req) {
	var targetIdNode = XPath.getSingleNode("./child::text()", xml, node);
	if (!targetIdNode) {
		log.exception(new Error(), "Parse error in server response");
		return;
	}
	var targetId = targetIdNode.nodeValue;

	var targetNode = document.getElementById(targetId);
	if (!targetNode) {
		log.exception(new Error("Couldn't find node #"+targetId+" (to remove)"));
		return;
	}

	if (targetNode.parentNode && targetNode.parentNode.removeChild) {
		targetNode.parentNode.removeChild(targetNode);
	}
	else {
		log.exception(new Error("Can't use parent of node #"+targetId));
		return;
	}
};

Ajax.Action.append = function(xml, node, req) {
	//var targetId = $(node).children('target').text();
	var targetIdNode = XPath.getSingleNode('./target/child::text()', xml, node);
	if (!targetIdNode) {
		log.exception(new Error(), "Parse error in server response");
		return;
	}
	var targetId = targetIdNode.nodeValue;

	var newDataNode = XPath.getSingleNode('./content/child::text()', xml, node);
	if (!newDataNode) {
		log.exception(new Error(), "Parse error in server response");
		return;
	}
	var newData = newDataNode.nodeValue;

	var targetBase = $('#'+targetId);
	targetBase.find("div[class='content']")
			.single("Coudn't find content node in #"+targetId+ " (to append new content)")
			.html(newData);
	
	if (targetBase.hasClass('dialog')) {
		targetBase.dialog({
			height: 600,
			width: 800
		});
	}
	else {
		targetBase.style.display = 'block';
	}
};

Ajax.Action.replace = function(xml, node, req) {
	var targetIdNode = XPath.getSingleNode('./target/child::text()', xml, node);
	if (!targetIdNode) {
		log.exception(new Error(), "Parse error in server response");
		return;
	}
	var targetId = targetIdNode.nodeValue;

	var newDataNode = XPath.getSingleNode('./content', xml, node);
	if (!newDataNode) {
		log.exception(new Error(), "Parse error in server response");
		return;
	}
	var newData = newDataNode.textContent;

	var targetNode = document.getElementById(targetId);
	if (!targetNode) {
		log.exception(new Error("Couldn't find node #"+targetId+" (to replace)"));
		return;
	}

	// TODO: Fügt zusätzliches DIV ein, das dann bei "remove" etc. nicht mehr
	// entfernt wird, da es das Element mit der entsprechenden ID nur enthält (?)
	var newNode = document.createElement("div");
	newNode.innerHTML = newData;
	targetNode.parentNode.replaceChild(newNode.firstChild, targetNode);
};


/*
* Form soll ausgetauscht werden
*/
function AjaxSubmitForm() {
	AjaxCommandReceiver.apply(this, arguments);
	this.resultObject = null;

	this.url = "?ajax=form";

	// Aktionen
	this.nCommand.addOnXPath("./self::url", Ajax.Action.url);
	this.nCommand.addOnXPath("./self::eval", Ajax.Action.eval);
	this.nCommand.addOnXPath("./self::error", Ajax.Action.error);
	this.nCommand.addOnXPath("./self::remove", Ajax.Action.remove);
	this.nCommand.addOnXPath("./self::append", Ajax.Action.append);
	this.nCommand.addOnXPath("./self::replace", Ajax.Action.replace);

	this.loadingScreen = null; //new LoadingScreen();
	// sample/debug:
	/*
	this.loadingScreen.show = function() {
		logDebug("show loading screen");
	}
	this.loadingScreen.hide = function() {
		logDebug("hide loading screen");
	}
	*/
}
AjaxSubmitForm.prototype = new AjaxCommandReceiver();
N.ajaxSubmitForm = new AjaxSubmitForm();


/*
 * Add a special |targetNode| property to the request, used later
 * to handle replace/....
 */
AjaxSubmitForm.prototype.makeRequest = function(querystring, loadingScreen) {
	var req = AjaxCommandReceiver.prototype.makeRequest.call(this, this.url, querystring, new LoadingScreen());
	//req.targetNode = null;
	return req;
};

/* PUBLIC
 * Standardrequest
 */
AjaxSubmitForm.prototype.request = function(event, formName) {
	this.startPostRequest(postBackString(event, formName));
};

})(window);


(function (N) {
	"use strict";

function Tree(node) {
	if (!node) {
		return;
	}
	
	this.node = node;
	
	
	// Animation muss neu erstellt werden
	var xPath = new XPath();
	
	var tree = node.nextSibling;
	while (tree) {
		if (tree.className && tree.className.search(/tree/) != -1 ) {
			break;
		}
		tree = tree.nextSibling;
	}	
	/*xPath.evaluate("parent::div[@class='tree']", document, node);
	var tree = xPath.iterateNext();*/
	
	
	// Höhe wird bestimmt
	var height = 5;
	var child = tree.firstChild;
	while (child) {
		if (child.nodeType != 3 && child.offsetHeight) {
			height+= child.offsetHeight;
		}
		child = child.nextSibling;
	}
	
	// Animationen werden erzeugt
	var anim = new Animator();
	anim.addSubject(new CSSStyleSubject(
		tree,
		"height: 0px;",
		"height: " + height +"px"));
	
	node.className = "open";
	/*anim.addSubject(new CSSStyleSubject(
				node,
				node.className, node.className + " open"));
	/*anim.addSubject(new DiscreteStyleSubject(
			tree,
			"display", "none", "inline-block", 0.5));*/
	/*var img;
	xPath.evaluate("./img[@class='closed']", document, node);
	if (!(img = xPath.iterateNext())) {
		anim.addSubject(new DiscreteStyleSubject(
				img,
				"display", "inline-block", "none", 0.5));
		
		xPath.evaluate("./img[@class='open']", document, node);
		img = xPath.iterateNext();
		anim.addSubject(new DiscreteStyleSubject(
			img,
			"display", "none", "inline-block", 0.5));
	*/
		
	this.anim = anim;
}
N.Tree = Tree;


Tree.prototype.toggle = function() {
	if (this.node.className.search(/closed/) != -1) {
		this.node.className = this.node.className.replace(/closed/, "open");
	}
	else {
		this.node.className = this.node.className.replace(/open/, "closed");
	}
	this.anim.toggle();
};

Tree.prototype.open = function() {
	this.anim.play();
};

})(window);

function Panel(node, anim) {
	this.node = node;
	this.anim = anim;
	this.display = false;
	this.trees = [];
}

Panel.prototype.show = function(node) {
	this.display = true;
	this.anim.play();
	//this.node.style.backgroundColor = "#000000";
};

Panel.prototype.hide = function(node) {
	this.display = false;
	this.anim.reverse();
	//this.node.style.backgroundColor = "transparent";
};

Panel.prototype.openTree = function(i, node) {
	if (this.trees[i]) {
		this.trees[i].toggle();
	}
	else {
		this.trees[i] = new Tree(node);
		this.trees[i].open();
	}
};

$().ready(function() {
	if ($(".panels > .content").length > 0) {
		$(".panels > .content").splitter({
			sizeLeft: 250,
			minLeft: 100,
			dock: "left",
			dockSpeed: 200,
			outline: true
		});
		/*$("#test").splitter({
			type: "v",
			outline: true,
			sizeLeft: 150,
			minLeft: 100,
			minRight: 100,
			resizeToWidth: true,
			dock: "right",
			dockSpeed: 200,
			dockKey: 'Z', // Alt-Shift-Z in FF/IE
			accessKey: 'I' // Alt-Shift-I in FF/IE
		}); */
	// 	$(".vsplitbar").dblclick(function(){
	// 		$(this).prev().toggle();
	// 	});
	}
});


/*$(".panels > .content").splitter({
			minAsize: 150,
			maxAsize: 400,
			splitVertical: true,
			A: $('#manageFolderPanel'),
			B: $('#manageFolderContent'),
			closeableto: 0
});*/
// $().ready(function() {
// 	$( ".panels .content div:first-child").resizable({handles: "e"});
// });
function switchTab(node) {
	var siblings = $(node.parentNode).children("li");
	// index wird bestimmt
	var i;
	for (i = 0; i < siblings.length; i++) {
		if (siblings[i] == node) {
			break;
		}
	}

	// tabs werden aktualisiert
	siblings.removeClass("active");
	$(node).addClass("active");

	// inhalt wird actualisiert
	$(node).closest("div.tab, div.drilling").children("div.wgt-content").children("ul").children("li").fadeOut(0);
	$(node).closest("div.tab, div.drilling").children("div.wgt-content").children("ul").children("li:eq("+i+")").fadeIn(0);
}

(function($) {
	"use strict";

	Names.defaults("Dz.Settings", {
		use_jquery_address_tabs: false
	});

	// 1 level nach oben
	// TODO im Moment wird nur der Homescreen wieder eingeblendet
	$.fn.openPage = function(i) {
		var siblings = this.closest("*[data-dz-nav-role='container']").find("*[data-dz-nav-role='head']").children("li");
		var node = siblings.eq(i);

		// tabs werden aktualisiert
		siblings.removeClass("ui-priority-primary");
		node.addClass("ui-priority-primary");

		// inhalt wird actualisiert
		var content = this.closest("*[data-dz-nav-role='container']").children("*[data-dz-nav-role='content']");
		content.children("li").fadeOut(0);
		content.children("li:eq("+i+")").fadeIn(0);

		// TODO prev/next ausblenden
		if (i === 0) {
			$(this).closest("*[data-dz-nav-role='container']").find("*[data-dz-nav-role='previous']").css("visibility", "hidden");
		}
		else {
			$(this).closest("*[data-dz-nav-role='container']").find("*[data-dz-nav-role='previous']").css("visibility", "visible");
		}

		// siblings is 0 based and contains "next" and "previous" links - thus subtract 3:
		if (i == siblings.length - 3) {
			$(this).closest("*[data-dz-nav-role='container']").find("*[data-dz-nav-role='next']").css("visibility", "hidden");
		}
		else {
			$(this).closest("*[data-dz-nav-role='container']").find("*[data-dz-nav-role='next']").css("visibility", "visible");
		}
		return content.children("li:eq("+i+")");
	};

	$.fn.gotoPage = function(i) {
		var siblings = $(this).closest("*[data-dz-nav-role='container']").find("*[data-dz-nav-role='head']").children("li");
		var node = this[0];

		if (typeof(i) == "undefined") {
			// index wird bestimmt
			for (i = 0; i < siblings.length; i++) {
				if (siblings[i] == node) {
					break;
				}
			}
		}
		else {
			// Paging Knoten wird bestimmt
			node = $(this).closest("*[data-dz-nav-role='container']").children("*[data-dz-nav-role='head']").children("li:eq("+i+")");
		}

		if (Dz.Settings.use_jquery_address_tabs) {
			$.address.value("/page=" + (i+1));
			return;
		}

		this.openPage(i);
	};


	$.fn.nextPage = function() {
		var siblings = $(this).closest("*[data-dz-nav-role='container']").find("*[data-dz-nav-role='head']").children("li");
		var node = $(this).closest("*[data-dz-nav-role='container']").find("*[data-dz-nav-role='head']").children("li.ui-priority-primary")[0];
		// index wird bestimmt
		var i;
		for (i = 0; i < siblings.length; i++) {
			if (siblings[i] == node) {
				break;
			}
		}
		// TODO Test ob die seite existiert?
		return this.gotoPage(i + 1);
	};

	$.fn.previousPage = function() {
		var siblings = $(this).closest("*[data-dz-nav-role='container']").find("*[data-dz-nav-role='head']").children("li");
		var node = $(this).closest("*[data-dz-nav-role='container']").find("*[data-dz-nav-role='head']").children("li.ui-priority-primary")[0];
		// index wird bestimmt
		var i;
		for (i = 0; i < siblings.length; i++) {
			if (siblings[i] == node) {
				break;
			}
		}
		// TODO Test ob die seite existiert?
		return this.gotoPage(i - 1);
	};

})(jQuery);
/**
 * Mehrstufige Breadcrumbnavigation
 *
 */
(function($) {
	"use strict";

	// Nach oben
	// Erwartet dass im breadcrumb gedrück worden ist
	$.fn.drillUp = function() {
		// Alle Unterbenen werden ausgeblendet
		$(this).nextAll("li").each(function() {
			var targetId = $(this).attr("aria-controls");
			$("#" + targetId).fadeOut(0);
			$("#" + targetId).parent().fadeOut(0);
			$(this).remove();
		});
		
		// Menu einfaden
		var targetId = $(this).attr("aria-controls");
		$("#" + targetId).fadeIn(0);
		$("#" + targetId).find("div[role='menu']").first().fadeIn(0);
		
		// TODO ? Backbutton aktualisieren
		/*var header = $(this).closest("div[role='tree']").children("header");
		$(header).children("span").fadeIn();
		$(header).children("span").attr("aria-controls", targetId);*/
		return this;
	};
	$.fn.drillDown = function() {
		var targetId = $(this).attr("aria-controls");
		// Menu mit dem folderlisting ausfaden
		$(this).closest("div[role='menu']").fadeOut(0);
		// Subtree anzeigen
		$("#" + targetId).parent().fadeIn(0);
		$("#" + targetId).fadeIn(0);
		
		// Navigation updaten
		var header = $(this).closest("div[role='tree']").children("header");
		var title = $(this).attr("title");
		$(header).children("ol").append("<li onclick='$(this).drillUp();' aria-controls='"+targetId+"'>" + title + "</li>");
		
		// TODO ? Backbutton
		//$(header).children("span").fadeIn();
		//$(header).children("span").attr("aria-controls", targetId);
		return this;
	};
})(jQuery);
/*
* Löscht die Werte aller Inputfelder eines Formularteils
*/
function clearSubForm(node)
{
	console.log("veraltet: jQuery Extension verwenden, clearForm");
	return;
	/*
	if ((node.tagName.toLowerCase() == "input" && node.getAttribute("type").toLowerCase() == "text") || node.tagName.toLowerCase() == "textarea")
	{
		node.value = "";
	}
	if (node.tagName.toLowerCase() == "option")
	{
		node.selected = false;
	}

	// Child-Nodes werden aktualisiert
	if (node.hasChildNodes())
	{
		node = node.firstChild;
		while (node != null)
		{
			clearSubForm(node);
			node = node.nextSibling;
		}
	}
	*/
}

/**
 * Löscht einen Teil eines Formular
 * Das letztes Subform, wird nur ausgeblendet
 */
function removeSubForm(node) {
	console.log("veraltet: todo durch eine jQuery extension ersetzen");
	return;
	/*
	var forms = $(node).closest("div").children("span");
	
	if (forms.length > 1) {
		// wird ausgeblendet und dann gelöscht
		$(node).parent().fadeOut(function(node){
			$(node).parent().remove();
		});
	}
	else {
		// Letztes Subform, wird nur ausgeblendet
		$(node).parent().fadeOut();
		$(node).closest("div").children("img").fadeIn();
	}
	*/
}

function duplicate(hnode, xnode) {
	console.log("veraltet: todo durch eine jQuery extension ersetzen");
	return;
	/*
	// Neue ID wird bestimmt
	var id = $(hnode).prev("ul.newobject").children("li").last().attr("rel");
	id++;
	xnode = xnode.getNewNode({id: id});
	$(hnode).prev("ul.newobject").append("<li class=\"container " + xnode.crId + "\" rel=\"" + id + "\"/>");
	//var newNode = $(hnode).prev("ul.newobject").children("li").last();
	xnode.renderComplete({renderMode: "inputAppend"});
	//newNode.attr("rel", id);
	return xnode;
	*/
}

/*
* Ein Teil einer Form wird dupliziert und mit neuen Namen versehen
*/
function duplicateSubForm(node) {
	console.log("veraltet: todo durch eine jQuery extension ersetzen");
	return;
	/*
	var newNode = $(node).prev("ul.newobject").children("li").last().clone();
	var fields = $(newNode).find("[name]");
	// neue ID wird betsimmt
	var name = fields[0].getAttribute("name").match(/\[\d*\]\[\w+\]\[\d*\]$/);
	name = name[0];
	var id = name.substr(1, name.search(/\]/) - 1);
	id++;
	for (var i = 0; i < fields.length; i++) {
		var name =  fields[i].getAttribute("name").replace(/\[\d*\](\[\w+\]\[\d*\])$/, "["+ id + "]$1");
		fields[i].setAttribute("name",name);
	}
	// TODO DropDown und radio/checkboxen löschen?
	// Inhalte werden geköscht
	$(newNode).find("input[type='text']").val("");
	// Neues Subform wird eingefügt
	$(node).prev("ul.newobject").append(newNode);
	*/
}

/*
* Alle Attribute des Nodes und aller Children werden geupdated
*/
function updateName(obj, oldName, newName, n)
{
	alert("updateName");
	// Bennenung der Attribute des Objects wird aktualisiert
	if (obj.attributes)
	{
		for (i = 0; i < obj.attributes.length; i++)
		{
			if (obj.attributes[i].name.toLowerCase() == "href" && obj.attributes[i].value.search(/fxEffect/) != -1)
			{
				// Es wird eine Ersetzung für einen fx Event aufruf vorgenommen
				//alert(n);
				obj.attributes[i].nodeValue = obj.attributes[i].nodeValue.replace(/\d\./gi,n+".");
				//alert(obj.attributes[i].nodeValue);
				// Neuer Effekt wird zur initialisiert (nicht sehr allgemein gehalten) vorgemerkt
				evalStr +='fxEffectCorrection'+n+' = new fx.Height(document.getElementById("table'+newName+'") , {duration: 400, onComplete: function() { toggle("atable'+newName+'");}});';
			}
			else
			{
				// Der IE hat Probleme mit .attributes
				try
				{
					if (obj.attributes[i].nodeValue && obj.attributes[i].nodeValue !== "")
					{
						obj.attributes[i].nodeValue = obj.attributes[i].nodeValue.replace(oldName, newName);
					}
				}
				catch(e)
				{
					// IE Steigt aus da er alle möglichen Attribute durchläuft
				}
			}
		}
	}

	// Child-Nodes werden aktualisiert
	if (obj.hasChildNodes())
	{
		obj = obj.firstChild;
		while (obj !== null)
		{
			updateName(obj, oldName, newName, n);
			obj = obj.nextSibling;
		}
	}
}
/*
* Globale vorinitialisierte Variablen
*/
var row = 0;
var direction = 1;
var evalStr = "";

/*
* Ein - und Ausblenden von einem HTML Elment
*/
function show(obj)
{
	warnDeprecate("function show()", "use jQuery instead");
	if (document.getElementById(obj).style.display == "none" || !document.getElementById(obj).style.display)
	{
		document.getElementById("a"+obj).firstChild.data = "<<";
		document.getElementById(obj).style.display = "block";
	}
	else
	{
		document.getElementById("a"+obj).firstChild.data = ">>";
		document.getElementById(obj).style.display = "none";
	}
}

/*
* Ein - und Ausblendepfeile werden vertauscht
*/
function toggle(obj)
{
	warnDeprecate("function toggle()", "use jQuery instead");
	if (document.getElementById(obj).firstChild.data == ">>")
	{
		document.getElementById(obj).firstChild.data = "<<";
	}
	else
	{
		document.getElementById(obj).firstChild.data = ">>";
	}
}



// Ein String wird an der Stelle des Cursors eingefügt
function insertString(str, textarea)
{
	warnDeprecate("function insertString()", "use jQuery instead");
	if (typeof(textarea.selectionStart) != "undefined")
	{
		var begin = textarea.value.substr(0, textarea.selectionStart);
		var end = textarea.value.substr(textarea.selectionStart);
		textarea.value = begin + str + end;
		textarea.setSelectionRange(begin.length + 1, begin.length + 1);
	}
	else
	{
		if (typeof(textarea.caretPos) != "undefined")
		{
			var begin = textarea.value.substr(0, textarea.caretPos);
			var end = textarea.value.substr(textarea.caretPos);
			textarea.value = begin + str + end;
			textarea.caretPos.select();
		}
	}
	
	textarea.focus();
}


// Linguatec
AC_FL_RunContent = 0;
/*addScript("/trainer/js/linguatec.js");
addScript("/trainer/js/animator.js");
addScript("/trainer/js/Lang/de.js");
addScript("/trainer/js/Lang/en.js");*/

/*
* Fügt einem Object ein Event hinzu
*/
function addEvent( obj, type, fn ) {
	warnDeprecate("function addEvent()", "use jQuery instead");
	if ( obj.attachEvent ) {
		obj['e'+type+fn] = fn;
		obj[type+fn] = function(){obj['e'+type+fn]( window.event );};
		obj.attachEvent( 'on'+type, obj[type+fn] );
	} else
		obj.addEventListener( type, fn, false );
	}
function removeEvent( obj, type, fn ) {
	warnDeprecate("function removeEvent()", "use jQuery instead");
	if ( obj.detachEvent ) {
		obj.detachEvent( 'on'+type, obj[type+fn] );
		obj[type+fn] = null;
	} else
		obj.removeEventListener( type, fn, false );
}


function showContent(node, id) {
	warnDeprecate("function getElementsByClass()", "no way this should be in framework");
	var openFolder = openTree(node);
	if (openFolder) {
		document.getElementById("learningcontent0").style.display = "none";
		document.getElementById("learningcontent"+id).style.display = "block";
	}
	else {
		document.getElementById("learningcontent"+id).style.display = "none";
		document.getElementById("learningcontent0").style.display = "block";
	}
}

/**
* Sucht alle Elemente mit einer Klasse
*/
function getElementsByClass(searchClass,node,tag) {
	warnDeprecate("function getElementsByClass()", "use jQuery instead");
	var classElements = new Array();
	if ( node == null )
		node = document;
	if ( tag == null )
		tag = '*';
	var els = node.getElementsByTagName(tag);
	var elsLen = els.length;
	var pattern = new RegExp("(^|\\s)"+searchClass+"(\\s|$)");
	for (i = 0, j = 0; i < elsLen; i++) {
		if ( pattern.test(els[i].className) ) {
			classElements[j] = els[i];
			j++;
		}
	}
	return classElements;
}


function showMore(node) {
	warnDeprecate("function showMore()", "use jQuery instead");
	var obj = node.nextSibling;
	var offset = obj.innerHeight;
	obj.style.height = "0px";
	obj.style.display = "block";
	
	var anim = new Animator();
	anim.addSubject(new CSSStyleSubject(
		obj,
		"height: 0px;",
		"height: 300px"));
	anim.play();
}


function Page() {
	this.page = 1;
	this.name = "page";
	this.lastPage = 1;
}

Page.prototype.nextPage = function() {
	document.getElementById(this.name + this.page).style.display = "none";
	if (document.getElementById(this.name + "-thumb-" + this.page)) {
		document.getElementById(this.name + "-thumb-" + this.page).className = "inactive";
	}
	this.page++;
	document.getElementById(this.name + this.page).style.display = "block";
	if (this.page == this.lastPage) {
		document.getElementById(this.name + "-next").style.display = "none";
	}
	document.getElementById(this.name + "-prev").style.display = "block";
	
	if (document.getElementById(this.name + "-thumb-" + this.page)) {
		document.getElementById(this.name + "-thumb-" + this.page).className = "active";
	}
};

Page.prototype.prevPage = function() {
	document.getElementById(this.name + this.page).style.display = "none";
	if (document.getElementById(this.name + "-thumb-" + this.page)) {
		document.getElementById(this.name + "-thumb-" + this.page).className = "inactive";
	}
	this.page--;
	document.getElementById(this.name + this.page).style.display = "block";
	if (this.page == 1) {
		document.getElementById(this.name + "-prev").style.display = "none";
	}
	document.getElementById(this.name + "-next").style.display = "block";
	if (document.getElementById(this.name + "-thumb-" + this.page)) {
		document.getElementById(this.name + "-thumb-" + this.page).className = "active";
	}
};

Page.prototype.gotoPage = function(i) {
	document.getElementById(this.name + this.page).style.display = "none";
	if (document.getElementById(this.name + "-thumb-" + this.page)) {
		if (document.getElementById(this.name + "-thumb-" + this.page).className.search(/active/) >= 0) {
			var className = document.getElementById(this.name + "-thumb-" + this.page).className.replace(/(\s|^)active/g," inactive");
			document.getElementById(this.name + "-thumb-" + this.page).className = className;
		}
		else {
			document.getElementById(this.name + "-thumb-" + this.page).className = "inactive";
		}
	}
	this.page = i;
	document.getElementById(this.name + this.page).style.display = "block";
	if (this.page == 1 && document.getElementById(this.name + "-prev")) {
		document.getElementById(this.name + "-prev").style.display = "none";
	}
	if (document.getElementById(this.name + "-next")) {
		document.getElementById(this.name + "-next").style.display = "block";
	}
	if (document.getElementById(this.name + "-thumb-" + this.page)) {
		if (document.getElementById(this.name + "-thumb-" + this.page).className.search(/active/) >= 0) {
			var className = document.getElementById(this.name + "-thumb-" + this.page).className.replace(/(\s|^)inactive/g," active");
			document.getElementById(this.name + "-thumb-" + this.page).className = className;
		}
		else {
			document.getElementById(this.name + "-thumb-" + this.page).className = "active";
		}
	}
	if (this.page != 1 && document.getElementById(this.name + "-prev")) {
		document.getElementById(this.name + "-prev").style.display = "block";
	}
	if (this.page == 1 && document.getElementById(this.name + "-prev")) {
		document.getElementById(this.name + "-prev").style.display = "none";
	}
	if (this.page != this.lastPage && document.getElementById(this.name + "-next")) {
		document.getElementById(this.name + "-next").style.display = "block";
	}
	if (this.page == this.lastPage  && document.getElementById(this.name + "-next")) {
		document.getElementById(this.name + "-next").style.display = "none";
	}
};

//function corrects stupid IE and gives it min-width and max-width which
//could be easy with CSS...
function minMaxWidth(minWidth,maxWidth) {
	var newWidth = "auto",currentWidth = (document.body.clientWidth + 1) ;
	if ( currentWidth > maxWidth ) {
			newWidth = maxWidth + "px";
	}
	currentWidth = currentWidth - 2;
	if ( currentWidth < minWidth ) {
			newWidth = minWidth + "px";
	}
	return newWidth;
}


/*
* Generiert einen QueryString aus dem angegebenen Formular und dem geklickten Button
*/
function postBackString(event, formName) {
	var value = null;
	if (event) {
		if (event.target) {
			value = event.target.value;
		}
		else {
			value = event.srcElement.value;
		}
	}
	
	var fields = [];
	if(formName)
	{
		//loop through form elements and retrieve field NAMEs and Values
		for (var x = 0; x < document[formName].elements.length; x++)
		{
			// join them into a string.
			var type = document[formName].elements[x].type;
			var name = document[formName].elements[x].name;
			if (type == 'submit' || type == "button")
			{
				if (document[formName].elements[x].value == value)
				{
					fields.push(encodeURIComponent(document[formName].elements[x].name)+'='+encodeURIComponent(document[formName].elements[x].value));
				}
			}
			else
			{
				if (type == "checkbox")
				{
					if (document.forms[formName].elements[x].checked == true)
					{
						fields.push(encodeURIComponent(document[formName].elements[x].name)+'='+encodeURIComponent(document[formName].elements[x].value));
					}
				}
				else if (type == "radio")
				{
					if (document.forms[formName].elements[x].checked == true)
					{
						fields.push(encodeURIComponent(document[formName].elements[x].name)+'='+encodeURIComponent(document[formName].elements[x].value));
					}
				}
				else {
					if (!(typeof(CKEDITOR) != "undefined" && CKEDITOR.instances[name])) {
						fields.push(encodeURIComponent(document[formName].elements[x].name)+'='+encodeURIComponent(document[formName].elements[x].value));
					}
					//üeval("fields.push(document."+formName+	".elements[x].name+'='+document."+formName+".elements[x].value);");
				}
			}
		}
		
		// CKEDITOR wird ausgewertet
		if (typeof(CKEDITOR) != "undefined") {
			for (var editor in CKEDITOR.instances) {
				// das bereits existierende 
				fields.push(editor + "=" + encodeURIComponent(CKEDITOR.instances[editor].getData()));
			}
		}
		// RichTextAreas werden erfasst
		var iframes = document[formName].getElementsByTagName('IFRAME');
		for (var i = 0; i < iframes.length; i++)
		{
			if (iframes[i].contentDocument && iframes[i].contentDocument.designMode == 'on') 
			{
				if (is_safari)
				{
					// Der Safari verwendet immer CSS zum auszeichnen
					var html = iframes[i].contentDocument.body;
					convertCssToHtml(html, iframes[i].contentDocument);
					//alert(html.innerHTML);
					fields.push(encodeURIComponent(iframes[i].id)+'='+encodeURIComponent(html.innerHTML));
					
				}
				else
				{
					fields.push(encodeURIComponent(iframes[i].id)+'='+encodeURIComponent(iframes[i].contentDocument.body.innerHTML));
				}
				
			}
			else if(iframes[i].document && iframes[i].contentWindow.document.body.contentEditable)
			{
				// IE Hack
				fields.push(encodeURIComponent(iframes[i].id)+'='+encodeURIComponent(iframes[i].contentWindow.document.body.innerHTML));
			}
		}

	}
	return fields.join('&');
}

(function (Dz) {
	"use strict";

Dz.Validator = Class(Object,
/** @lends Validator.prototype */
{
	/** @class Javascript abstract validator for form fields
	* available for a HTML node
	*
	*/
	isValid:
	function(htmlNode) {
		var valid = this.__isValid(htmlNode);
		if (!valid) {
			$(htmlNode).css('background-color', 'red');
		}
		else {
			$(htmlNode).parent().css('background-color', '');
		}
		return valid;
	},
	__isValid:
	function(htmlNode) {
		return false;
	}
});

Dz.NumberValidator = Class(Validator,
/** @lends NumberValidator.prototype */
{
	/** @class Javascript validator for float form fields
	* available for a HTML node
	*/
	
	/*
	 * Test for float
	 *  @param {DomNode} htmlNode: Form field to test
	 */
	__isValid:
	function(htmlNode) {
		// TODO Kann noch mit min, max, step erweitert werden
		// German decimal Separator is replaced
		htmlNode.value =  htmlNode.value.replace(/,/g,'.');
		return htmlNode.value == htmlNode.value.replace(/[^0-9\.]/g,'');
	}

});

//window.Dz.Validators = new Array();
window.Dz.Validators = {
	"number": new Dz.NumberValidator()
};

})(this);


(function (N) {
	"use strict";

N.wordStartsWith = function wordStartsWith(str, search) {
	var words = str.split(' ');
	var i, l;
	for (i = 0, l = words.length; i < l; ++i) {
		if (Str.startsWith(words[i], search))
			return true;
	}
	return false;
};

N.search_TagStart = function search_TagStart(tagname) {
	return function(xnode, searchterm) {
		var snodes = $(xnode).children(tagname);
		if (snodes.length != 1)
			log.warning("found " + snodes.length + " search nodes " + xnode.tagName + "[" + tagname + "] (expected 1)");
		return Str.startsWith($(xnode).children(tagname).text().toLowerCase(), searchterm);
	};
};

N.search_TagSubstr = function search_TagSubstr(tagname) {
	return function(xnode, searchterm) {
		return $(xnode).children(tagname).text().toLowerCase().indexOf(searchterm) !== -1;
	};
};

N.search_TextSubstr = function search_TextSubstr(xnode, searchterm) {
	return $(xnode).text().toLowerCase().indexOf(searchterm) !== -1;
};


})(window);


(function(Dz) {
	"use strict";

/** The state of data that is currently in the progress of 
 * loading via ajax.
 * Contains the request options and the ajax request.
 */
Dz.DataLoadState = Class({
__init__:
function(options) {
	requireArgs(arguments, 1);
	this.options = options;
	this.ajaxRequest = null;
},

/** Cancel the request */
cancel:
function() {
	requireArgs(arguments, 0);
	if (this.ajaxRequest !== null) {
		log.debug("aborting incomplete request");
		this.ajaxRequest.abortRequest();
		this.ajaxRequest = null;
	}
}

});

})(this);


(function (Dz) {
	"use strict";

/** @private
	Generates the generic serverpath part of a raw XML node, relative to it's parent
	@param {XmlNode} xnode The XML node to generate an id for
	@returns {String}
 */
Dz.genericSpIdPart = function genericSpIdPart(xnode) {
	var xid = xnode.getAttribute("id");
	if (xid === null)
		return '[' + xnode.tagName + '][]';
	else
		return '[' + xnode.tagName + '][' + xid + ']';
};


/** @private
 * Erzeugt den einen Teil einer |serverpath| id, die das aktuelle Objekt
 * relativ zu seinem Parent beschreibt. Z.B. "[foo][5]"
 * @param {XmlNode} xnode Node for which the spId part should be generated
 * @returns {String}
*/
Dz.makeSpIdPart = function makeSpIdPart(xnode) {
	requireArgs(arguments, 1);
	if (xnode.parentNode && xnode.parentNode.tagName == "newobject") {
		// oder nur in objectrepr?
		return "[newobject][0][" + xnode.tagName + ']';
	}
	else  {
		return genericSpIdPart(xnode);
	}
};

// ==========================================================================
// XmlRepr

/** Create the local internal relative Id of a node, like foo_1 or barlisting_2 */
Dz.makeCrId = function makeCrId(xnode) {
	var xid = xnode.getAttribute("id");
	if (xid === null) {
		// TODO: Add warning
		return xnode.tagName;
	}
	else
		return xnode.tagName + '_' + xid;
};


/** Find all direct children with the given node name
 * @param {DOMNode} node
 * @param {String} tag name
 * @returns {Array.<DOMNode>} found child nodes
 */
Dz.getChildrenByTagName = function getChildrenByTagName(node, name) {
	requireArgs(arguments, 2);

	var result = [];
	var subnode;
	for (subnode = node.firstChild; subnode; subnode = subnode.nextSibling) {
		if (subnode.tagName == name) {
			result.push(subnode);
		}
	}
	return result;
};


Dz.XmlRepr = Class(Object,
/** @lends XmlRepr.prototype */
{
/** @class Javascript object managing the HTML representation  and the actions
 * available for a XML node.
 *
 * @constructs
 * @param {XmlRepr|Manager} parent The owning object where this one is
 * contiained in.
 * @param {XMLNode} xmlNode Der node im XML der durch dieses
 * Objekt verwaltet wird.
 * @param options
 * @param options.newobject ???
 * @param options.objects ???
 */
__init__:
function(parent, xmlNode, options) {
	requireArgs(arguments, 2, 3);
	options = defaultOpts(options, {});

	this.parent = parent;
	this.manager = parent.manager;

	this.currentProgress_ = [];

	this.xId = xmlNode.getAttribute("id");
	this.spId = this.makeSpId(xmlNode);
	this.crId = makeCrId(xmlNode);

	this.loadmanager = new LoadStateManager(this);

	this.displays = {};
	this.validators = null;
	this.renderHandlers = [];

	this.persistCount = 0;

	this.adaptXml(xmlNode);
},

dispose:
function() {
	this.loadmanager.dispose();
	var name;
	for (name in this.displays) {
		if (this.displays[name] && this.displays[name].dispose)
			this.displays[name].dispose();
	}
	this.xmlNode = null;
	this.parent = null;
	this.manager = null;
},

persistInc:
function() {
	this.persistCount++;
	if (this.persistCount == 1)
		this.parent.persistInc();
},

persistDec:
function() {
	this.persistCount--;
	if (this.persistCount == 0)
		this.parent.persistDec();
},

requestDisplay:
function(spec) {
	requireArgs(arguments, 1);
	this.loadmanager.requestDisplay(spec);
},

displayRequestAborted:
function(spec) {
},

displayRequestFailed:
function(spec) {
},

displayRequestReady:
function(spec) {
},

dataRequestStart:
function(spec) {
	throw new Error("not implemented: derived classes should override this method");
},

_getAttr:
function(name, value, optional) {
	requireArgs(arguments, 3);
	var avalue = $(this.xmlNode).attr(name);
	if (avalue !== undefined) {
		return avalue;
	}
	else {
		if (!optional)
			throw new Error("no attribute '" + name + "' found for node " + Dom.path(this.xmlNode));
		return value;
	}
},

getAttr:
function(name, value) {
	requireArgs(arguments, 1, 2);
	return this._getAttr(name, value, isdefined(value));
},

setAttr:
function(name, value) {
	requireArgs(arguments, 2);
	this.xmlNode.setAttribute(name, value.toString());
},

/**
 * Get an xml property as a boolean value.
 * A non-exising property is considered "false".
 * If the property exists it must either be "true" or "false".
 * @param {String} name name of property
 */
getBoolAttr:
function(name) {
	requireArgs(arguments, 1);
	var value = this._getAttr(name, null, true);
	if (value === null || value == "false")
		return false;
	if (value === "true")
		return true;
	throw new Error("'" + value + "' is no valid truth value");
},

setBoolAttr:
function(name, value) {
	requireArgs(arguments, 2);
	if (value)
		this.setAttr(name, value);
	else
		this.xmlNode.removeAttribute(name);
},

// ---------------------------------------------------------------------------
// Ids verschiedener Arten

/**
 * Generiert die komplette globale Id des Objektes, so wie sie der Server verwendet,
 * beispielsweise "value[foolisting][0][foo][5]".
 *
 * Dieser Wert wird in der member variable "spId" gespeichert
*/
makeSpId:
function(xnode) {
	requireArgs(arguments, 1);
	// Work around problem that we need [newobject][0][item] but [newobject][0][item][0][subobject]
	if (this.parent.spId && Str.startsWith(makeSpIdPart(this.parent.xmlNode), "[newobject]")) {
		// parent is a newobject. So is uses incomplete ids by default. But subobjects need full ids.
		return this.parent.parent.spId + "[newobject][0]" + genericSpIdPart(this.parent.xmlNode) + makeSpIdPart(xnode);
	}
	else {
		return this.parent.spId + makeSpIdPart(xnode);
	}
},

/**
	Determines the render mode used to display the object.
	The function checks the associated container HTML node {hnodeContainer}
	(if any) for a suitable CSS-class. If none is found, the parents render mode
	is used.
	@throws {Error} If no render mode could be found at all.
*/
getRenderMode:
function(displayname) {
	requireArgs(arguments, 1);

	if (this.displays[displayname].renderMode !== null) {
		// render mode already known
		return;
	}

	// check for CSS class on current container, specifying render mode
	if (this.displays[displayname].hnode !== null)
		this.displays[displayname].renderMode = containerRenderMode(this.displays[displayname].hnode);
	// otherwise use parents render mode
	if (this.displays[displayname].renderMode === null) {
		if (this.parent.displays && this.parent.displays[displayname]) {
			this.displays[displayname].renderMode = this.parent.displays[displayname].renderMode;
		}
		else {
			this.displays[displayname].renderMode = this.manager.renderMode;
		}
	}

	if (this.displays[displayname].renderMode === null)
		throw new Error("no render mode found for " + displayname + ">" + Dom.path(this.xmlNode));
},


// ---------------------------------------------------------------------------
// Manage associated Xml

/** Replace the managed Xml with the supplied node.
 *
 */
replaceXml:
function(xnode) {
	requireArgs(arguments, 1);
	xnode = xmltools.replaceNode(this.xmlNode, xnode);
	this.adaptXml(xnode);
},

/** Called when the Xml-Node associated with the Repr object changes.
 *
 * This function replaces the |xmlNode|, for derived classes this should
 * trigger further actions that need to be executed when the managed XML
 * node changes.
 */
adaptXml:
function(xnode) {
	requireArgs(arguments, 1);
	this.xmlNode = xnode;
	if (xnode === null) {
		// No xml -> no displays
		// TODO: passt das so generell? Oder vielleicht anders für Tracks/map?
		this.detachDisplays();
		disposeMembers(this.displays);
		this.displays = {};
	}
},

adaptXmlReprs_:
function (oldreprs, xmlnodes) {
	requireArgs(arguments, 2);

	var name, repr;

	var newreprs = {};
	if (xmlnodes === null) {
		// Keep only reprs that are marked persistent
		for (name in oldreprs) {
			repr = oldreprs[name];
			if (repr.persistCount) {
				// Keep and adapt.
				newreprs[name] = repr;
				repr.adaptXml(null);
			}
			else {
				// Remove
				repr.dispose();
			}
		}
	}
	else {
		// Create/keep reprs for all the new xml nodes
		xmlnodes.forEach(function (xnode) {
			// Only create reprs for nodes with ids
			if ($(xnode).attr('id') === undefined)
				return;

			/*
			if (/.*listing$/.test(lnode.nodeName)) {
				log.warning("non-listing subobject: " + Dom.xmlPath(lnode));
				continue;
			}
			*/
			var cr = makeCrId(xnode);
			if (cr in oldreprs) {
				// We have a fitting existing repr
				repr = oldreprs[cr];
				repr.adaptXml(xnode);
				newreprs[cr] = repr;
			}
			else {
				// No existing repr object, create one
				repr = this.manager.representations.getInstance(xnode.tagName, this, xnode);
				this.propagateDisplaysTo(repr);
				newreprs[cr] = repr;
			}
		}, this);

		// Any other reprs that are now missing in the xml get removed
		for (name in oldreprs) {
			if (!(name in newreprs)) {
				oldreprs[name].dispose();
			}
		}
	}
	return newreprs;
},

// ---------------------------------------------------------------------------
// Manage displays/viewports/associated HTML

addDisplay:
function(display) {
	requireArgs(arguments, 1);
	if (this.displays[display.name])
		throw new Error("display '" + display.name + "' already exists");
	this.displays[display.name] = display;
},

getDisplay:
function(displayname) {
	requireArgs(arguments, 1);
	var display = this.displays[displayname];
	if (!display)
		throw new Error("No display '" + displayname + "'");
	return display;
},

spawnDisplay:
function(viewport) {
	requireArgs(arguments, 1);
	if (!this.displays[viewport.name]) {
		this.addDisplay(new (DisplayClasses.get([viewport, this]))(viewport));
	}
	return this.getDisplay(viewport.name);
},

detachDisplay:
function (displayname) {
	var display = this.displays[displayname];
	var viewport = display.viewport;
	viewport._RD_Clear(this);
},

detachDisplays:
function () {
	var name;
	for (name in this.displays) {
		if (this.displays[name]) {
			this.detachDisplay(name);
		}
	}
},

propagateDisplaysTo:
function(subrepr) {
	var name;
	for (name in this.displays) {
		if (this.displays[name]) {
			this.displays[name].propagateToNode(subrepr);
		}
	}
},

getProgressItems:
function () {
	var progs = [];
	Obj.forEach(this.displays, function (display) {
		if (!display)
			return;
		var viewport = display.viewport;
		if (viewport.progress) {
			progs.push(viewport.progress);
		}
	}, this);
	return progs;
},

showProgress:
function () {
	this.currentProgress_ = this.getProgressItems();
	this.currentProgress_.forEach(function (prog) {
		prog.show();
	});
},

hideProgress:
function () {
	this.currentProgress_.forEach(function (prog) {
		prog.hide();
	});
	this.currentProgress_ = [];
},

_renderComplete:
function(display, options) {
	this.manager.viewports[display.name].renderComplete(this, display, options);
},

_renderContent:
function(display, options) {
	this.manager.viewports[display.name].renderContent(
			this, display, options);
},

/** Renders the complete container for all active displays */
renderComplete:
function(options) {
	requireArgs(arguments, 0, 1);
	var rendered = false;
	var displayname;
	for (displayname in this.displays) {
		if (this.displays[displayname]) {
			rendered = true;
			this._renderComplete(this.displays[displayname]);
		}
	}
	if (!rendered) {
		debug_message("renderComplete() called but no displays found that could be updated for " + Dom.path(this.xmlNode),
				[this]);
		this.traceDisplays();
	}
},

/** Renders just the content area of the given display */
renderDisplayContent:
function(displayname, options) {
	requireArgs(arguments, 1, 2);
	this._renderContent(this.displays[displayname], options);
},

/** Renders the content for all active displays */
renderContent:
function(options) {
	requireArgs(arguments, 0, 1);
	var displayname;
	var rendered = false;
	for (displayname in this.displays) {
		if (this.displays[displayname]) {
			rendered = true;
			this._renderContent(this.displays[displayname], options);
		}
	}
	if (!rendered) {
		debug_message("no displays found that could be updated for " + Dom.path(this.xmlNode),
				[this]);
		this.traceDisplays();
	}
},

toViewport:
function(viewport, defaultname) {
	requireArgs(arguments, 1, 2);
	
	viewport = defaulting(viewport, defaultname);

	if (viewport instanceof Viewport) {
		// It is a viewport object
		return viewport;
	}

	if ($.type(viewport) === 'string') {
		var obj = this.manager.viewports[viewport];
		if (!obj) {
			throw new Error("no viewport '" + viewport + "' defined");
		}
		return obj;
	}

	// else: DomNode
	return $(viewport).dz('viewport');
},

toDisplay:
function(display, defaultname) {
	requireArgs(arguments, 1, 2);

	display = defaulting(display, defaultname);

	if (display instanceof Display) {
		// It is a display object
		return display;
	}

	var obj = this.displays[display];
	if (!obj) {
		throw new Error("no display '" + display + "' defined");
	}
	return obj;
},

/** Render the object as the new toplevel object for the given viewport.
 * This renders the complete object
 */
renderViewport:
function(viewport, options) {
	requireArgs(arguments, 1, 2);
	viewport = this.toViewport(viewport);
	viewport.renderRepr(this, options);
	viewport.show();
},

/*
closeViewport:
function(viewportname) {
	this.manager.viewports[viewportname].close();
},
*/


/** Called whenever the content got rendered */
onRender:
function(displaynode, mode, display) {
	requireArgs(arguments, 3);
	this.renderHandlers.forEach(function (rh) {
		rh.call(this, displaynode, this, mode, display);
	}, this);
},


// ---------------------------------------------------------------------------
// Genration of query strings

/** Generate a query string with the current context */
query:
function(options) {
	requireArgs(arguments, 0, 1);
	return this.parent.query();
},

/** Generate a query string referrencing the current object */
objectQuery:
function(options) {
	requireArgs(arguments, 0, 1);
	return this.query(options).appending('object', 'select'+this.spId);
},

objectFormQuery:
function(form) {
	var qu = this.objectQuery();
	qu = qu.appendingRaw(form.serialize());
	this.queryAppendSelectedObjects(qu);
	return qu;
},

displayForm:
function (display) {
	return this.toDisplay(display).hnode.closest('form');
},

// ==========================================================================
// Interactions common between Listings and ObjectReprs

/** (Helper) Determine a form fields id */
fieldSpId:
function(xnode) {
	requireArgs(arguments, 1);
	// TODO hacky. Ids should be consistent so that there is no need for this mess here:
	var fid = this.spId;
	if (this.xmlNode.parentNode && this.xmlNode.parentNode.tagName == "objects") {
		// need additional "[objects]" in id
		var mo = /^(.*)(\[[^[]*\[[^[]*)$/.exec(fid);
		fid = mo[1] + "[objects]" + mo[2];
	}
	return fid + genericSpIdPart(xnode);
},

/** Validate form fields */
/// TODO: Won't work for lists
// TODO: use viewport
validate:
function() {
	requireArgs(arguments, 0);

	//log.debug("Check validators at " + this.crId + ": " + this.validators);
	//if (!this.validators)
	//	return true;

	var self = this;
	var valid = true;

	// check all contained fields
	$(self.xmlNode).children().each(function (i, xn) {
		// get validator
		var validator;
		var hnodeid = "value" + self.fieldSpId(xn);
		var hnode = document.getElementById(hnodeid);
		if (hnode === null) {
			// Müssen nicht im HTML auftauchen
			//log.warning("Couldn't find form element to validate for " + Dom.path(xn) +
			//	" (id=" + hnodeid + ")");
			return;
		}
		if (!self.validators || !(validator = self.validators[makeCrId(xn)])) {
			// No special validator set for this field
			var type = $(hnode).attr("type");
			if (type && typeof(window.Dz.Validators[type]) != "undefined") {
				valid = valid && window.Dz.Validators[type].isValid(hnode);
			}
		}
		else {
			//log.debug("Check validator for " + makeCrId(xn));
			
			// get html form field
			//log.debug("spId: " + makeSpId(self, xn));
			
			if (!validator(hnode)) {
				$(hnode).parent().css('color', 'red');
				valid = false;
			}
			else {
				$(hnode).parent().css('color', '');
			}
		}
	});

	return valid;
},

/**
 * Refresh the object data.
 *
 * Sends action=refresh to the server, which should return data with
 * action=update if something needs to be updated.
 */
refresh:
function () {
	this.manager.ajax.startPostRequest(
			this.objectQuery().appending("action", "refresh")
			//.appendingRaw(this.displays[viewport.name].hnode.closest('form').serialize())
		);
},

/** Save an edited object */
save:
function(hnode) {
	// A node or a (legacy) viewport name, or nothing
	var viewport = this.toViewport(hnode, 'workspace');

	//requireArgs(arguments, 1);
	// TODO: event?

	// First try to validate
	if (!this.validate())
		return;

	// Hacky spinner for workspace viewport
	var spinNode = $(document.createElement("div"));
	spinNode.addClass("spin-container");
	spinNode.height(viewport.hcnode.height());
	spinNode.width(viewport.hcnode.width());
	viewport.hcnode.append(spinNode);
	spinNode.spin();
	viewport.progress = spinNode;

	// Post result
	if (this.uploadFile) {
		this.uploadFile.submit();
	}
	else {
		this.manager.ajax.startPostRequest(
				this.objectQuery().appending("action", "update").
				appendingRaw(this.displays[viewport.name].hnode.closest('form').serialize())
				//appendingRaw(this.displays.workspace.hnode.serialize()),
				//appendingRaw(postBackString(event, this.manager.formName.toLowerCase())),
			);
	}
},

saveSelected:
function() {
	requireArgs(arguments, 0);
	var qu = this.objectFormQuery($("form[name='" + this.manager.formName.toLowerCase()+"']"))
			.appending("action", "save");
			// in startQuery wird list verwendet. Vmtl kann das immer unterschiedlich sein?
			//appendingRaw(this.displays.workspace.hnode.closest('form').serialize())
			//appendingRaw($("form[name='" + this.manager.formName.toLowerCase()+"']").serialize())
	//this.manager.ajax.startPostRequest(qu);
	document.location = qu.toString().replace(/ajax=info/,''); // TODO: ???
},

// (Helper)
actionQuery:
function(event, action) {
	//requireArgs(arguments, 1);
	// TODO: event?
	this.manager.ajax.startPostRequest(
			this.objectQuery().appending("action", action)
		);
},

deprecateHnode:
function(hnode) {
	if (hnode === undefined)
		return;
	if (deprecateHnode.caller && deprecateHnode.caller.name)
		log.info("'hnode' parameter for " + deprecateHnode.caller.name + " is not used anymore and should be removed from call");
},

/** Show information about know viewports and what parents of this repr
 * are rendered in them.
 */
traceDisplays:
function () {
	var reprpath = [];
	var repr = this;
	while (repr.displays) {
		reprpath.unshift(repr);
		repr = repr.parent;
	}

	var name;
	for (name in this.manager.viewports) {
		var viewport = this.manager.viewports[name];
		if (!viewport.inUse()) {
			log.debug('viewport ' + name + ': not in use');
		}
		else {
			// Find root
			var i, l;
			for (i = 0, l = reprpath.length; i < l; ++i) {
				if (reprpath[i] === viewport.content)
					break;
			}
			if (i == l) {
				log.debug('viewport ' + name + ': renders unrelated node ' + viewport.content.spId);
			}
			else {
				var rbase = reprpath[i].spId;
				var rpath = [];
				for ( ; i < l; i++) {
					if ((name in reprpath[i].displays) && (reprpath[i].displays[name]))
						rpath.push(reprpath[i].crId);
					else
						break;
				}
				var mpath = [];
				for ( ; i < l; i++) {
					mpath.push(reprpath[i].crId);
				}
				log.debug('viewport ' + name + ': renders ' + rbase + ' containing ' + rpath.join('>') + ' without ' + mpath.join('>'));
			}
		}
	}
},

isNewNode:
function() {
	requireArgs(arguments, 0);

	return (this.xmlNode.parentNode && (this.xmlNode.parentNode.tagName == "newobject"));
},

/**
 * Functions for traversing the structure
 */
closest:
function(nodeName) {
	var node = this;
	while (node) {
		if (node.xmlNode.nodeName == nodeName) {
			return node;
		}
		node = node.parent
	}
}

});

})(window);


(function (N) {
	"use strict";

N.TypeDispatch = Class({

__init__:
function(order) {
	requireArgs(arguments, 0, 1);
	this.order = defaulting(order, 1);
	this.dispatch = [];
},

_ArraySet:
function(arr, types, value) {
	var type = types[0];

	var elem = null;
	var i;
	for (i = 0; i < arr.length; ++i) {
		if (arr[i][0] === type) {
			// Already existing
			elem = arr[i];
			break;
		}
		else if (type.prototype instanceof arr[i][0]) {
			elem = [type, []];
			arr.splice(i, 0, elem);
			break;
		}
	}
	if (elem === null) {
		elem = [type, []];
		arr.push(elem);
	}

	if (types.length == 1) {
		elem[1] = value;
	}
	else {
		this._ArraySet(elem[1], types.slice(1), value);
	}
},

/**
 * Takes an array of types and associates a value with them
 */
set:
function(types, value) {
	requireArgs(arguments, 2);
	if (types.length !== this.order)
		logic_error("expected key tuple of order " + this.order + ", not " + types.length);

	this._ArraySet(this.dispatch, types, value);
},

_ArrayGet:
function(arr, types) {
	var type = types[0];
	var i;
	var value, result;
	for (i = 0; i < arr.length; ++i) {
		// |type| can be an object or a type
		if (type instanceof arr[i][0] ||
				type === arr[i][0] || type.prototype instanceof arr[i][0]) {
			value = arr[i][1];
			if (types.length === 1) {
				return value;
			}
			else {
				result = this._ArrayGet(value, types.slice(1));
				if (isdefined(result))
					return result;
			}
		}
	}
	return undefined;
},

/**
 * Takes an array of types or objects and finds the best matching
 * value for it.
 * Returns |undefined| if no matching value is found.
 */
get:
function(types) {
	requireArgs(arguments, 1);
	if (types.length !== this.order)
		logic_error("expected key tuple of order " + this.order + ", not " + types.length);
	return this._ArrayGet(this.dispatch, types);
}

});


})(window);


(function(Dz) {
	"use strict";

Dz.Display = Class({

__init__:
function(viewport) {
	this.name = viewport.name;
	this.viewport = viewport;
},

dispose:
function() {
	this.viewport = null;
},

isExpandable:
function() {
	return false;
},

detachHtml:
function(repr) {
}

});


Dz.IViewport = {
propagateToNode: function(noderepr) {}
};


Dz.Viewport = Class({

__init__:
function(name, options) {
	requireArgs(arguments, 1, 2);
	options = defaultOpts(options, {
			initialRender: false,
			showhide: Show.noAction,
			progress: null
		});

	this.name = name;
	this.initialRender = options.initialRender;
	this.content = null;

	this.showhide = options.showhide;
	if (this.showhide.setup) {
		this.showhide.setup(this);
	}

	this.progress = options.progress;
},

dispose:
function() {
	if (this.showhide.destroy) {
		this.showhide.destroy(this);
	}
	this.content = null;
},

/** Main function to stop using a viewport */
close:
function() {
	requireArgs(arguments, 0);
	if (this.content) {
		this.removeRepr();
	}
	this.hide();
},

show:
function() {
	this.showhide.show(this);
},

hide:
function() {
	this.showhide.hide(this);
},

cancelEdit:
function() {
	this.showhide.cancelEdit(this);
},

inUse:
function() {
	requireArgs(arguments, 0);
	return (this.content !==  null);
},

/*
setRepr:
function(node) {
	requireArgs(arguments, 1);
	if (this.content !== null) {
		this.removeRepr();
	}
	this.content = node;
	// TODO: move to xslt renderer
	var rootdisp = new this.DisplayClass(this);
	this.content.setDisplay(this.name, new this.DisplayClass(this));

	this.content.setDisplay(this.name, new DisplayLocation(this.name, this.hcnode, this.renderMode));
},
*/

removeRepr:
function() {
	requireArgs(arguments, 0);
	this.content.displays[this.name] = null;
	this.content = null;
},

_RD_Options:
function(repr) {
	requireArgs(arguments, 1);
	if (isdefined(repr.optReprs)) {
		//Obj.values(repr.optReprs).forEach(function (subrepr) {
		//	this._RD_clear(subrepr);
		//}, this);
		var key;
		for (key in repr.optReprs) {
			var subrepr = repr.optReprs[key];
			this._RD_Clear(subrepr);
		}
	}
},

_RD_Listings:
function(repr) {
	requireArgs(arguments, 1);
	if (isdefined(repr.listings)) {
		var key;
		for (key in repr.listings) {
			var subrepr = repr.listings[key];
			this._RD_Clear(subrepr);
		}
	}
},

_RD_Nodes:
function(repr) {
	requireArgs(arguments, 1);
	if (isdefined(repr.nodeReprs)) {
		var key;
		for (key in repr.nodeReprs) {
			var subrepr = repr.nodeReprs[key];
			this._RD_Clear(subrepr);
		}
	}
},

_RD_All: function(repr) {
	requireArgs(arguments, 1);
	this._RD_Options(repr);
	this._RD_Listings(repr);
	this._RD_Nodes(repr);
},

_RD_Clear: function(repr) {
	requireArgs(arguments, 1);
	var display = repr.displays[this.name];
	if (display) {
		this._RD_All(repr);
		display.detachHtml(repr);
		display.dispose();
		repr.displays[this.name] = null;
	}
}


});


/** @namespace */
Dz.Show = {};

/** Default class that is used when nothing else is specified: Don't do anything on show()/hide(). */
Dz.Show.noAction = {
	type: 'simple',
	show: function(viewport) {},
	hide: function(viewport) {},
	cancelEdit: function (viewport) {}
};


Dz.DisplayClasses = new TypeDispatch(2);

})(window);


(function () {
	"use strict";

	var N = window;

	N.progressMap = {};

	N.Progress = Class({
		__init__: function () {
			requireArgs(arguments, 0);
			this.hnode = null;
		},

		init: function (hnode) {
			this.hnode = hnode;
		},

		show: function () {
		},

		hide: function () {
		}
	});
	
	N.ProgressGroup = Class({
		__init__: function (items) {
			requireArgs(arguments, 1);
			this.items = items;
		},

		show: function () {
			requireArgs(arguments, 0);
			this.items.forEach(function (it) {
				it.show();
			});
		},

		hide: function () {
			requireArgs(arguments, 0);
			this.items.forEach(function (it) {
				it.hide();
			});
		}
	});

	N.SpinProgress = Class(N.Progress, {
		show: function () {
			requireArgs(arguments, 0);

			var opts = {speed: 2.5};
			//$.extend(opts, this.opts);

			if (opts.maxtop) {
				if (this.hnode.height() > 2*opts.maxtop) {
					opts.top = opts.maxtop;
					delete opts.maxtop;
				}
				else {
					opts.top = 'auto';
				}
			}
			this.__show(opts);
		},
		
		__show:
		function(opts) {
			requireArgs(arguments, 1);
			
			var spinNode = $(document.createElement("div"));
			spinNode.addClass("spin-container");
			spinNode.height(this.hnode.height());
			spinNode.width(this.hnode.width());
			var position = this.hnode.position();
			this.hnode.append(spinNode);
			
			
			// spinner wird angezeigt
			spinNode.show();
			spinNode.spin(opts);
			this.spinNode = spinNode;
		},
		hide: function () {
			requireArgs(arguments, 0);
			if (this.spinNode) {
				this.spinNode.stop();
				this.spinNode.remove();
				this.spinNode = null;
			}
		}
	});
	
	N.FullContainerSpinProgress = Class(N.SpinProgress, {
		__show: function (opts) {
			requireArgs(arguments, 1);
			
			var spinNode = $(document.createElement("div"));
			spinNode.addClass("spin-container");
			spinNode.css("height", "100%");
			spinNode.css("width", "100%");
			
			var contentNode = $(document.createElement("div"));
			contentNode.addClass("spin-content");
			spinNode.append(contentNode);
			
			this.hnode.append(spinNode);
			
			
			// spinner wird angezeigt
			contentNode.show();
			contentNode.spin(opts);
			
			this.spinNode = spinNode;
			
			/*var sp = new Spinner(opts);
			sp.spin(this.hnode[0]);
			this.running.push(sp);*/
		}
	});

	N.AbsoluteSpinProgress = Class(N.SpinProgress, {
		__show: function(opts) {
			requireArgs(arguments, 1);
			
			// Spinning Node wird erzeugt
			var spinNode = $(document.createElement("div"));
			spinNode.addClass("spin-container");
			spinNode.height(this.hnode.height());
			spinNode.width(this.hnode.width());
			spinNode.offset(this.hnode.offset());
			document.append(spinNode);
			
			
			// spinner wird angezeigt
			spinNode.show();
			spinNode.spin(opts);
			
			this.running.push(spinNode);
		}
	});
	N.NotyProgress = Class(N.Progress, {
		__init__:
		function(params) {
			this.params = defaultOpts(params, {
				type: "info",
				timeout: false,
				force: true,
				layout: "bottomRight",
				modal: false,
				text: "Loading ..."
			});
			this.params.text = "<img src='/img/16x16/spinner.gif' width='16' height='16' alt='*'/> " + this.params.text;
		},
		init: function(hnode) {
		},
		show: 
		function() {
			requireArgs(arguments, 0);
			var p = Obj.extend({}, this.params);
			this.noty = noty(p);
		},
		hide:
		function() {
			if (this.noty) {
				this.noty.close();
				this.noty = null;
			}
		}
	});

})();


(function(Dz) {
	"use strict";

Dz.checkRole = function(hnode, role, msg) {
	if (hnode.attr('data-dz-role') != role) {
		if (msg instanceof Function)
			msg = msg();
		logic_warning(msg + " without data-dz-role=" + role, [hnode[0]]);
	}
};

Dz.checkName = function(hnode, name, msg, required) {
	requireArgs(arguments, 4);
	var dzname = hnode.attr('data-dz-name');
	if (!dzname && !required) {
		// Only continue if name was required
		return;
	}
	if (dzname != name) {
		if (msg instanceof Function)
			msg = msg();
		logic_warning(msg + " without data-dz-name=" + name, [hnode[0]]);
	}
};


Dz.HtmlDisplay = Class(Dz.Display, {

__init__:
function() {
	Display.prototype.__init__.apply(this, arguments);
	this.hnode = null;
	this.cur = {};
},

dispose:
function() {
	var i, l;
	this.viewport.extensions.forEach(function (ext) {
		if (ext.disposeDisplay)
			ext.disposeDisplay(this);
	}, this);
	Display.prototype.dispose.call(this);
	this.hnode = null;
},

attachedHtml:
function(repr, hnode, options) {
	requireArgs(arguments, 2, 3);
	var i, l;
	var ext;
	for (i = 0, l = this.viewport.extensions.length; i < l; ++i) {
		ext = this.viewport.extensions[i];
		if (ext.attachedHtml)
			ext.attachedHtml(this, repr, hnode, options);
	}
},

detachHtml:
function(repr, hnode, options) {
	requireArgs(arguments, 1, 3);
	hnode = hnode || this.hnode;
	var i, l;
	var ext;
	for (i = 0, l = this.viewport.extensions.length; i < l; ++i) {
		ext = this.viewport.extensions[i];
		if (ext.detachHtml)
			ext.detachHtml(this, repr, hnode);
	}
},

propagateToNode:
function(noderepr, options) {
	var self = this;
	var hpart = null;

	if (noderepr.isNewNode()) {
		hpart = this.hnode
			.subpart('newobject').single(function () {
					return {
						msg: "role=newobject node that could contain " + self.name + ">" + Dom.path(noderepr.xmlNode),
						context: [self.hnode[0]]
					};
				}, {fatal: false, required: false});
	}
	else {
		hpart = this.hnode
			.subpart('content').single(function () {
					return {
						msg: "role=content node that could contain " + self.name + ">" + Dom.path(noderepr.xmlNode),
						context: [self.hnode[0]]
					};
				}, {fatal: false, required: false});
	}
	var hcontainer = hpart
		.innerContainer(noderepr.crId).single(function() {
				return {
					msg: "container for " + self.name + ">" + Dom.path(noderepr.xmlNode),
					context: hpart[0]
				};
			}, {fatal: false, required: false});
	if (hcontainer.length !== 0) {
		var display = new (DisplayClasses.get([this.viewport, noderepr]))(this.viewport);
		display.hnode = hcontainer.first();
		display.attachedHtml(noderepr, display.hnode, options);
		noderepr.addDisplay(display);
		this.viewport._AD_All(noderepr, options);
	}
},

isExpandable:
function() {
	// If there is a content node that can be expanded
	return (this.hnode.subpart('content').length !== 0);
}

});


Dz.HtmlViewport = Class(Dz.Viewport, {

__init__:
function(name, options) {
	requireArgs(arguments, 1, 2);
	options = defaulting(options, {});
	var loptions = splitOpts(options, {
			node: __required__,
			tracked: true,
			resetContent: true,
			extensions: []
		});

	if (!isdefined(options.progress)) {
		options.progress = new SpinProgress();
	}

	this.hnode = $(loptions.node).single("root node for viewport '" + name + "'");
	this.hnode[0].dzViewport = this;

	this.tracked = loptions.tracked;
	this.extensions = [];

	var i, l;
	for (i = 0, l = Dz.HtmlViewport.Extensions.length; i < l; ++i) {
		this.extensions.push(new Dz.HtmlViewport.Extensions[i](options));
	}
	for (i = 0, l = loptions.extensions.length; i < l; ++i) {
		this.extensions.push(new loptions.extensions[i](options));
	}
	Viewport.prototype.__init__.call(this, name, options);

	this.hnode = $(loptions.node).single("root node for viewport '" + name + "'");
	this.hnode.data('dzViewport', this);
	if (this.showhide.name) {
		this.hnode.attr('data-dz-type', this.showhide.type);
	}
	if (this.progress) {
		this.progress.init(this.hnode);
	}

	this.hcnode = this.hnode.container().single({
			msg: "root container in viewport '" + name + "'",
			context: this.hnode[0]
		});

	this.hcnode_default = null;
	if (loptions.resetContent) {
		this.hcnode_default = this.hcnode.clone();
	}

	if (this.showhide.setupHtml) {
		var that = this;
		$(document).ready(function() {
			that.showhide.setupHtml(that);
		});
	}
},

dispose:
function() {
	Viewport.prototype.dispose.call(this);
	this.hnode = null;
	this.hcnode = null;
},

enableHtml:
function(hnode) {
	this.extensions.forEach(function(ext) {
		if (ext.enableHtml)
			ext.enableHtml(hnode);
	});
},

disableHtml:
function(hnode) {
	this.extensions.forEach(function(ext) {
		if (ext.disableHtml)
			ext.disableHtml(hnode);
	});
},

removeRepr:
function() {
	requireArgs(arguments, 0);
	this._RD_Clear(this.content);
	this.disableHtml(this.hcnode);
	Viewport.prototype.removeRepr.call(this);
},

hide:
function() {
	requireArgs(arguments, 0);
	if (this.hcnode_default !== null) {
		this.hcnode.mergeNode(this.hcnode_default.clone());
	}
	Viewport.prototype.hide.call(this);	
},

// Ersetzt den hnode
replaceHNode:
function(node) {
	this.hnode = node;
	this.hcnode = this.hnode.container().single({
		msg: "root container in viewport '" + name + "'",
		context: [this.hnode[0]]
	});
},


// Remove display helpers

_CheckMissingContainers:
function(xnode, used, available) {
	var unmatched = available.not(used);
	if (unmatched.length) {
		logic_warning("unmatched containers in " + this.name + ">" + Dom.path(xnode), unmatched);
	}
},

_AD_Subpart: function (repr, subpart, subreprs, options, checkmissing) {
	requireArgs(arguments, 5);
	var hbase = repr.displays[this.name].hnode;

	var hsubbase;
	if (subpart) {
		hsubbase = hbase.subpart(subpart);
		if (subreprs) {
			hsubbase = hsubbase.single(function() {
					return {
						msg: "role="+subpart+" node that could contain " + Dom.path(subreprs[0].xmlNode),
						context: [hbase[0]]
					};
				}, {fatal: false, required: false});
		}
	}
	else {
		hsubbase = hbase;
	}

	var used = $();
	subreprs.forEach(function(subrepr) {
		var hcontainer = hsubbase.innerContainer(subrepr.crId).single(function() {
					return {
						msg: "container for " + Dom.path(subrepr.xmlNode),
						context: [hsubbase[0]]
					};
				}, {fatal: false, required: false});
		if (hcontainer.length !== 0) {
			var display = new (DisplayClasses.get([this, subrepr]))(this);
			display.hnode = hcontainer.first();
			display.attachedHtml(subrepr, display.hnode, options);
			subrepr.addDisplay(display);
			this._AD_All(subrepr, options);
		}
		used = used.add(hcontainer);
	}, this);

	if (checkmissing) {
		this._CheckMissingContainers(repr.xmlNode, used, hsubbase.innerContainer());
	}
},

_AD_Listings:
function(repr, options) {
	requireArgs(arguments, 1, 2);
	if (isdefined(repr.listings)) {
		this._AD_Subpart(repr, null, Obj.values(repr.listings), options, true);
	}
},

_AD_Options:
function(repr, options) {
	requireArgs(arguments, 1, 2);
	if (isdefined(repr.optReprs)) {
		this._AD_Subpart(repr, 'options', Obj.values(repr.optReprs), options, true);
	}
},

_AD_Nodes:
function(repr, options) {
	requireArgs(arguments, 1, 2);
	if (isdefined(repr.nodeReprs)) {
		this._AD_Subpart(repr, 'content', Obj.values(repr.nodeReprs), options, !repr.lazyInit);
	}
},

_AD_All:
function(repr, options) {
	requireArgs(arguments, 1, 2);
	this._AD_Listings(repr, options);
	this._AD_Options(repr, options);
	this._AD_Nodes(repr, options);
}

});

Dz.HtmlViewport.Extensions = [];


/** Viewport that uses fadeIn()/fadeOut() when it is shown/hidden */
Dz.Show.fadeHtml = {
	type: 'fade',
	setupHtml:
	function (viewport) {
		// Attach close handler
		viewport.hnode.find("[data-dz-role='close']").on('click', function (eventObject) {
				viewport.close();
				return false;
			});
	},

	show:
	function(viewport) {
		viewport.hnode.fadeIn();
	},
	autoclose: true,

	hide:
	function(viewport) {
		viewport.hnode.fadeOut();
	},

	cancelEdit:
	function(viewport) {
		viewport.content.view(viewport);
	}
};

/** Viewport that uses a JQuery dialog */
Dz.Show.JQueryDialog = Class({
	type: 'dialog',

	__init__:
	withParams(__anyopts__,
	function(options) {
		Obj.extend(options, {autoOpen: false});
		this.settings = options;
	}),

	autoclose: true,

	/** 
	 * <form> wird eingefügt.
	 * da forms nicht nested sein können kann dies nicht im xsl oder im html passieren
	 */
	setupHtml:
	function(viewport) {
		requireArgs(arguments, 1);
		viewport.hnode.detach();
		viewport.hnode.removeClass("popup");
		// TODO onsubmit könnte auch save aufgerufen werden falls vorhanden
		var title = viewport.hnode.attr('title');
		if (!title)
			title = "";
		viewport.hnode.wrap('<form title="' + title + '" onsubmit="return false"></form>');
		viewport.hnode.removeData('dzViewport')
		viewport.hnode = viewport.hnode.closest('form');
		viewport.hnode.data('dzViewport', viewport);
		
		//this.settings.close = function( event, ui ) {
		//	viewport.hide();
		//}
		//viewport.hnode.find("input[type='checkbox']").on('click', function() { return false; });
		this.diag = viewport.hnode.dialog(this.settings);
	},

	show:
	function(viewport) {
		requireArgs(arguments, 1);
		viewport.hnode.dialog('open');
	},

	hide:
	function(viewport) {
		requireArgs(arguments, 1);
		viewport.hnode.dialog('close');
	},

	destroy:
	function(viewport) {
		requireArgs(arguments, 1);
		viewport.hnode.dialog('destroy');
	},

	cancelEdit:
	function(viewport) {
		viewport.content.view(viewport);
	}
});

Dz.Show.JQueryEditDialog = Class(Dz.Show.JQueryDialog, {
	cancelEdit:
	function (viewport) {
		viewport.hide();
	}
});

/** Viewport that uses a lightbox */
Dz.Show.Lightbox = Class(Dz.Show.fadeHtml, {
	type: 'lightbox',

	__init__:
	withParams(__anyopts__,
	function(options) {
		Obj.extend(options, {renderAttrs: {
				sizehint: "dzCFixedsize"
			}}
		);
		this.settings = options;
	}),
	autoclose: false,

	/** 
	 * <form> wird eingefügt.
	 * da forms nicht nested sein können kann dies nicht im xsl oder im html passieren
	 */
	setupHtml:
	function(viewport) {
		viewport.hnode.detach();
		viewport.hnode.removeClass("lightbox");
		viewport.hnode.wrap('<form onsubmit="return false" class="lightbox"></form>');
		viewport.hnode.removeData('dzViewport')
		viewport.hnode = viewport.hnode.closest('form');
		viewport.hnode.data('dzViewport', viewport);
		viewport.hnode.prepend("<img src='/img/22x22/dialog-close.png' alt='close' data-dz-role='close' role='button' class='topRight'/>");
		$('body').append(viewport.hnode);
		Dz.Show.fadeHtml.setupHtml.apply(this, arguments);
	},

	cancelEdit:
	function(viewport) {
		viewport.close();
	}
});

})(this);


(function(Dz) {
	"use strict";

/** Find the render mode attached with a container (if any)
 * @param {HtmlNode} hnode The HTML node to look at
 * @returns {String} The render mode if found, or |null|
 */
function containerRenderMode(hnode) {
	requireArgs(arguments, 1);
	var rm = hnode.attr('data-dz-mode');
	if (!rm)
		return null;
	return rm;
}

Dz.XsltDisplay = Class(Dz.HtmlDisplay, {
__init__:
function(viewport) {
	HtmlDisplay.prototype.__init__.call(this, viewport);
	this.renderMode = null;
},

attachedHtml:
function(repr, hnode, options) {
	HtmlDisplay.prototype.attachedHtml.apply(this, arguments);
	if (this.hnode) {
		// complete display
		if (this.renderMode === null) {
			this.renderMode = containerRenderMode(this.hnode);
		}
		if (this.renderMode === null) {
			// inherit from parent
			if (repr.parent.displays[this.name]) {
				this.renderMode = repr.parent.displays[this.name].renderMode;
			}
		}
	}
}

});


Dz.XsltViewport = Class(Dz.HtmlViewport, {

__init__:
function(name, options) {
	requireArgs(arguments, 1, 2);
	var opts = splitOpts(options, {
			mode: null,
			external: false,
			renderAttrs: {}
		});
	Dz.HtmlViewport.prototype.__init__.call(this, name, options);
	this.renderMode = opts.mode;
	this.external = opts.external;
	this.renderAttrs = opts.renderAttrs;
},


/** Internal function rendering a prepared display.
 * options
 * */
_render:
function(repr, display, options) {
	requireArgs(arguments, 3);
	// TODO: Move "search" option into a XML property (?)
	options = defaultOpts(options, {
			xnode: __required__,
			hnode: __required__,
			renderMode: __required__,
			setAttrs: false,
			search: false
		});

	function renderId() {
		return display.name + ">" + Dom.path(options.xnode) + "@" + options.renderMode + (options.search ? ':search' : '');
	}

	if (!options.xnode) {
		logic_error("No XML node set to render");
	}
	if (!options.hnode) {
		logic_error("No HTML target node set to render " + display.name + ">" + Dom.path(options.xnode));
	}
	if (!options.renderMode) {
		logic_error("No render mode set for " + display.name + ">" + Dom.path(options.xnode));
	}

	$(options.xnode).checkOwner(function () {
			return "source node when rendering " + renderId();
		});

	if (!this.external) {
		$(options.hnode).checkOwner(function () {
				return "target node when rendering " + renderId();
			});
	}


	// ----- Start rendering

	var that = this;
	function doRender() {
		var rendertime, displaytime;
		
		if (debug) {
			if (debugDetails) {
				log.groupCollapsed("input node");
				log.dirxml(options.xnode);
				log.groupEnd();
			}
			else {
				log.debug('input node:', options.xnode);
			}
		}

		if (debugDetails)
			rendertime = new Runtime();
		// display
		repr.manager.xslt.setParameter("mode", options.renderMode);
		if (options.search) {
			repr.manager.xslt.setParameter("search", "1");
		}

		var result = repr.manager.xslt.transformToDocument(options.xnode);

		repr.manager.xslt.setParameter("mode", "");
		if (options.search) {
			repr.manager.xslt.setParameter("search", "0");
		}
		
		if (debugDetails) {
			rendertime.stop();
		}

		if (debug) {
			if (debugDetails) {
				log.groupCollapsed("result");
				log.dirxml(result);
				log.groupEnd();
				log.debug("Xslt render time: " + rendertime.intervall + "ms");
			}
			else {
				log.debug('result:', result);
			}
		}

		// Nodeinhalt wird dargestellt
		if (debugDetails)
			displaytime = new Runtime();
		options.hnode.mergeXslt(result);
		if (debugDetails)
			displaytime.stop();

		if (debug) {
			log.debug('target node:', options.hnode[0]);
			if (debugDetails) {
				log.debug("Html insert time: " + displaytime.intervall + "ms");
			}
		}
	}

	log.groupCollapsed('rendering ' + renderId());
	try {
		if (options.setAttrs) {
			var name;
			for (name in this.renderAttrs) {
				options.xnode.setAttribute(name, this.renderAttrs[name]);
			}
		}
		doRender();
	}
	finally {
		log.groupEnd();
		if (options.setAttrs) {
			var name;
			for (name in this.renderAttrs) {
				options.xnode.removeAttribute(name);
			}
		}
	}

/*
	var rendertime, displaytime;
	if (debugDetails)
		rendertime = new Runtime();
	// display
	repr.manager.xslt.setParameter("mode", options.renderMode);
	if (options.search) {
		repr.manager.xslt.setParameter("search", "1");
	}
	// TODO: eigentlich braucht jedes Listing und so seine eigene Xml-Transformation?
	var result = repr.manager.xslt.transformToDocument(options.xnode);
	repr.manager.xslt.setParameter("mode", "");
	if (options.search) {
		repr.manager.xslt.setParameter("search", "0");
	}
	if (debugDetails)
		rendertime.stop();

	if (debug) {
		log.groupCollapsed('rendered ' + renderId() + '"' + (options.search ? ' (search)' : ''));
		if (debugDetails) {
			log.groupCollapsed("input node");
			log.dirxml(options.xnode);
			log.groupEnd();
			log.groupCollapsed("result");
			log.dirxml(result);
			log.groupEnd();
		}
		else {
			log.debug('input node:', options.xnode)
			log.debug('result:', result)
			log.debug('target node:', options.hnode[0])
		}
	}

	// Nodeinhalt wird dargestellt
	if (debugDetails)
		displaytime = new Runtime();
	substituteXSLTResult(options.hnode, result);
	if (debugDetails)
		displaytime.stop();

	if (debug) {
		if (debugDetails) {
			log.debug("Xslt render time: " + rendertime.intervall + "ms");
			log.debug("Html insert time: " + displaytime.intervall + "ms");
		}
		log.groupEnd();
	}
*/
	// ----- End rendering
},

renderContent:
function(repr, display, options) {
	requireArgs(arguments, 2, 3);
	options = defaultOpts(options, {
			renderMode: display.renderMode,
			variant: 'content',
			search: false
		});
	if (!options.renderMode) {
		throw new Error("no render mode set");
	}
	options.xnode = repr.xmlNode;
	options.hnode = display.hnode.subpart("content").single(function() {
			return {
				msg: "role=content node for " + display.name + ">" + Dom.path(repr.xmlNode),
				context: [display.hnode[0]]
			};
		});
	options.renderMode = display.renderMode + '-' + options.variant;
	delete options.variant;

	this._RD_Nodes(repr);
	this._RD_Listings(repr);
	this.disableHtml(options.hnode);

	this._render(repr, display, options);
	checkRole(options.hnode, 'content', function() {
			return "rendered node for " + display.name + '>' + Dom.path(repr.xmlNode) + '@' + options.renderMode;
		});

	this.enableHtml(options.hnode);
	this._AD_Listings(repr, options);
	this._AD_Nodes(repr, options);

	repr.onRender(display.hnode, display.renderMode, display);
},

renderComplete:
function(repr, display, options) {
	requireArgs(arguments, 2, 3);
	options = defaultOpts(options, {
			initial: false
		});

	if (!options.initial) {
		this._RD_All(repr);
		display.detachHtml(repr, display.hnode, options);
		this.disableHtml(options.hnode);
	}
	this._render(repr, display, {xnode: repr.xmlNode, hnode: display.hnode, renderMode: display.renderMode, setAttrs: true});

	if (this.tracked) {
		// Not relevant if untracked
		checkRole(display.hnode, 'container', function() {
				return "rendered node for " + display.name + '>' + Dom.path(repr.xmlNode) + '@' + display.renderMode;
			});
		checkName(display.hnode, repr.crId, function() {
				return "rendered node for " + display.name + '>' + Dom.path(repr.xmlNode) + '@' + display.renderMode;
			}, !display.toplevel);
	}

	this.enableHtml(display.hnode);
	display.attachedHtml(repr, display.hnode, options);
	if (this.tracked) {
		this._AD_All(repr, options);
	}

	//repr.resetDisplay(display.name, "complete");
	repr.onRender(display.hnode, display.renderMode, display);
},


renderPaging:
function(repr, display, options) {
	requireArgs(arguments, 2, 3);
	options = defaultOpts(options, {
			search: false // TODO: Determine automatically accorting to object state
		});

	options.xnode = repr.getXmlOptionsNode();
	options.renderMode = display.renderMode;

	var paging;
	paging = display.hnode
			.subpart('head').single(function () {
				return {
					msg: "role=head node for " + display.name + ">" + Dom.path(repr.xmlNode),
					context: [display.hnode[0]]
				};
			}, {required: false, fatal: false})
			.subpart('paging').single(function() {
				return {
					msg: "role=paging node in head for " + display.name + ">" + Dom.path(repr.xmlNode),
					context: [display.hnode[0]]
				};
			}, {required: false});
	if (paging.length != 0) {
		options.hnode = paging;
		this._render(repr, display, options);
		checkRole(options.hnode, 'paging', function() {
			return "rendered paging node for " + display.name + '>' + Dom.path(options.xnode) + '@' + options.renderMode;
		});
	}

	paging = display.hnode
			.subpart('tail').single(function () {
				return "role=tail node for " + display.name + ">" + Dom.path(repr.xmlNode);
			}, {required: false, fatal: false})
			.subpart('paging').single(function () {
				return "role=paging node in tail for " + display.name + ">" + Dom.path(repr.xmlNode);
			}, {required: false});
	if (paging.length != 0) {
		options.hnode = paging;
		this._render(repr, display, options);
		checkRole(options.hnode, 'paging', function() {
			return "rendered paging node for " + display.name + '>' + Dom.path(options.xnode) + '@' + options.renderMode;
		});
	}

	// TODO:
	//repr.resetDisplay(display.name, "options");
	// invalidate 
},

clear:
function(hnode) {
	requireArgs(arguments, 1);
},

renderRepr:
function(repr, options) {
	requireArgs(arguments, 1, 2);
	options = defaultOpts(options, {
			renderMode: this.renderMode
		});
	
	if (this.content !== null) {
		this.removeRepr();
	}
	this.content = repr;

	var display = new XsltDisplay(this, repr);
	display.toplevel = true;
	display.hnode = this.hcnode;
	display.renderMode = options.renderMode;
	if (display.renderMode === null) {
		display.renderMode = containerRenderMode(display.hnode);
	}
	if (display.renderMode === null) {
		display.renderMode = this.renderMode;
	}
	if (this.tracked) {
		repr.addDisplay(display);
	}

	this.renderComplete(repr, display, {initial: true});
},

reRender:
function() {
	//this.renderRepr(this.content);
	this.renderComplete(this.content, this.content.displays[this.name]);
}

});

Dz.ViewportDefinition = deprecateClass("ViewportDefinition", "Renamed to XsltViewport",
		XsltViewport);


Dz.DisplayClasses.set([Dz.XsltViewport, Dz.XmlRepr], Dz.XsltDisplay);


Dz.FadeViewport = Class(Dz.XsltViewport, {
__init__:
function(name, options) {
	options.showhide = Show.fadeHtml;
	XsltViewport.prototype.__init__.call(this, name, options);
}
});


Dz.DialogViewport = Class(Dz.XsltViewport, {
__init__:
function(name, options) {
	options = defaulting(options, {});
	options = Obj.extend({}, options);
	var dopt = splitOpts(options, {
			dialog: {
				width: 'auto',
				height: 'auto'
			}
		});
	options.showhide = new Show.JQueryDialog(dopt.dialog);
	XsltViewport.prototype.__init__.call(this, name, options);
}
});

Dz.EditDialogViewport = Class(Dz.DialogViewport, {
	__init__:
	function(name, options) {
		options = defaulting(options, {});
		options = Obj.extend({}, options);
		var dopt = splitOpts(options, {
				dialog: {
					width: 'auto',
					height: 'auto'
				}
			});
		options.showhide = new Show.JQueryEditDialog(dopt.dialog);
		XsltViewport.prototype.__init__.call(this, name, options);
	}
});

Dz.LightboxViewport = Class(Dz.XsltViewport, {
__init__:
function(name, options) {
	options = defaulting(options, {});
	var dopt = splitOpts(options, {
			lightbox: {}
		});
	options.showhide = new Show.Lightbox(dopt.lightbox);
	XsltViewport.prototype.__init__.call(this, name, options);
}
});

Dz.ClearViewport = deprecateClass("ClearViewport", "Same as the base class XsltViewport",
Class(Dz.XsltViewport, {
__init__:
function(name, options) {
	Dz.XsltViewport.prototype.__init__.call(this, name, options);
}

}));

})(this);


(function(Dz) {
	"use strict";

/** Information about the rendered Html associated with some Xml */
Dz.DisplayLocation = Class({
__init__:
function(name, hnode, renderMode) {
	requireArgs(arguments, 1, 3);
	this.name = name;
	this.hnode = defaulting(hnode, null);
	this.renderMode = defaulting(renderMode, null);
}

});

})(this);


(function (N) {
	"use strict";

/** @namespace
 * Useful functions to work with XML documents */
N.xmltools = {

xPath: new XPath(),

/** Get a single Xml node */
getSubNode:
function(xnodeBase, xpath, options) {
	requireArgs(arguments, 2, 3);
	options = defaultOpts(options, {
			required: true,
			unique: true
		});

	this.xPath.evaluate(xpath, xnodeBase.ownerDocument, xnodeBase);
	var result = this.xPath.iterateNext();
	if (options.required && !result) {
		throw new Error("couldn't find node for '" + xpath + "' in " + Dom.path(xnodeBase));
	}
	if (options.unique && this.xPath.iterateNext()) {
		//throw new Error("found more than one node for '" + xpath + "' in " + Dom.path(xnodeBase));
		log.warning("found more than one node for '" + xpath + "' in " + Dom.path(xnodeBase));
	}
	if (result)
		return result;
	else
		return null;
},

/** Get an array of Xml nodes */
getSubNodes:
function(xnodeBase, xpath) {
	requireArgs(arguments, 2);
	this.xPath.evaluate(xpath, xnodeBase.ownerDocument, xnodeBase);
	var nodes = [];
	var node;
	while ((node = this.xPath.iterateNext()))
		nodes.push(node);
	return nodes;
},

importNode:
function(xdoc, xnode, childNodes) {
	requireArgs(arguments, 2, 3);
	childNodes = defaulting(childNodes, true);
	try {
		return xdoc.importNode(xnode, childNodes);
	}
	catch (e) {
		// Da gibt's wohl Browser die kein importNode können?
		return xnode;
	}
},

/** Replace a node in the managed xml */
replaceNode:
function(oldnode, newnode) {
	requireArgs(arguments, 2);
	if (newnode.ownerDocument != oldnode.ownerDocument) {
		newnode = this.importNode(oldnode.ownerDocument, newnode, true);
	}
	oldnode.parentNode.replaceChild(newnode, oldnode);
	return newnode;
}
};


})(window);


(function(Dz) {
	"use strict";

/**
 * Registry for different types of XML representation classes
 * @constructor
 * @param {ReprenentationRegistry} parent Can contain a different
 * |RepresentationRegistry| object that is used as a fallback when
 * looking up listing classes / ...
 */
function RepresentationRegistry(parent) {
	requireArgs(arguments, 0, 1);
	this.parent = parent;
	this.classes = {};
	this.searchfunctions = {};
	this.renderhandlers = {};
	this.displayhandlers = {};
	this.validators = {};
}
RepresentationRegistry.prototype = {};

RepresentationRegistry.prototype.dispose = function() {
	this.parent = null;
};

/** Registers a special listing class can be registered for a listing name
 * @param {string} name
 * @param {function(XmlRepr, XmlNode, object=)} cls
 */
RepresentationRegistry.prototype.setReprClass = function(name, cls) {
	requireArgs(arguments, 2);
	this.classes[name] = cls;
};

/** Registers a search function for a listing name
 * @param {string} name
 * @param {function(XmlNode, string):boolean} fun
 */
RepresentationRegistry.prototype.setSearchFunction = function(name, fun) {
	requireArgs(arguments, 2);
	this.searchfunctions[name] = fun;
};

RepresentationRegistry.prototype.addDisplayHandler = function(name, dh) {
	requireArgs(arguments, 2);
	if (!(name in this.displayhandlers))
		this.displayhandlers[name] = [];
	this.displayhandlers[name].push(dh);
};

/** Registers a render handler for a listing name
 * @param {string} name
 * @param {function()} fun
 */
RepresentationRegistry.prototype.setRenderHandler = function(name, fun) {
	requireArgs(arguments, 2);
	if (!(name in this.renderhandlers))
		this.renderhandlers[name] = [];
	this.renderhandlers[name].push(fun);
};

/** Set validators for form field values when editing a |name| object
 * @param {string} name
 * @param {Array.<function(DomNode):boolean>} validators
 */
RepresentationRegistry.prototype.setValidators = function(name, validators) {
	requireArgs(arguments, 2);
	this.validators[name] = validators;
};

/** Recives a listing object for a name, using the registered classes and
 * search functions */
RepresentationRegistry.prototype.getInstance = function(name, parent, xnode, opts) {
	requireArgs(arguments, 3, 4);
	var instance = null;

	//log.debug("get instance for " + name);
	if (this.classes[name])
		instance = new (this.classes[name])(parent, xnode, opts);
	else if (this.parent)
		instance = this.parent.getInstance(name, parent, xnode, opts);
	else if (/listing$/.test(name))
		instance = new ListingRepr(parent, xnode, opts);
	else
		instance = new ObjectRepr(parent, xnode, opts);

	if (this.searchfunctions[name])
		instance.checkSearchHit = this.searchfunctions[name];
	if (this.renderhandlers[name])
		instance.renderHandlers = this.renderhandlers[name];
	if (this.validators[name])
		instance.validators = this.validators[name];

	return instance;
};

Dz.RepresentationRegistry = RepresentationRegistry;
/** A global registry of special listings, used by all managers and listings */
Dz.globalRepresentations = new RepresentationRegistry();

})(this);


(function(Dz) {
	"use strict";

Dz.LoadSpec = Class({
__init__:
function(displayspec) {
	requireArgs(arguments, 1, 2);
	this.display = displayspec;
	this.data = displayspec.requiredData();
	this.req = null;
	this.result = new $.Deferred();
}
});

})(this);


(function(Dz) {
	"use strict";

Dz.DisplayState = Class({
	__init__:
	function(progress) {
		requireArgs(arguments, 0, 1);
		if (progress) {
			this.progress = new Dz.ProgressGroup(progress);
		}
	}
});

Dz.SimpleDataState = Class({
__init__:
function (settings) {
	this.settings = settings;
},

isSupersetOf:
function (other) {
	return false;
}
});

Dz.SimpleDisplayState = Class(Dz.DisplayState, {
__init__:
function (settings, progress) {
	Dz.DisplayState.prototype.__init__.call(this, progress);
	this.settings = settings;
},

requiredData:
function () {
	return new Dz.SimpleDataState(this.settings);
},

adjustToData:
function () {
	logic_error("shouldn't need to adjust since not superset");
}
});

Dz.LoadStateManager = Class({
__init__:
function(owner) {
	requireArgs(arguments, 1);
	this.owner = owner;
	this.loaded = {
		data: null,
		display: null
	};
	this.loading = null;
},

dispose:
function() {
	this.owner = null;
},

resetData:
function() {
	requireArgs(arguments, 0);

	// Abort any pending requests
	if (this.loading) {
		this._abortDataRequest();
	}

	// Forget about current data state
	this.loaded.data = null;
},

requestDisplay:
function(displayspec) {
	requireArgs(arguments, 1);

	var loadspec = new Dz.LoadSpec(displayspec);

	// check if currently loaded data is ok
	if (this.loaded.data) {
		if (this.loaded.data.isSupersetOf(loadspec.data)) {
			// The currently loaded data is ok. Abort any pending loads.
			this._abortDataRequest();
			loadspec.display.adjustToData(this.loaded.data);
			// TODO: Don't re-render if unchanged?
			this.loaded.display = loadspec.display;
			loadspec.result.resolve(loadspec);
			this.owner.displayRequestReady(loadspec.display);
			return;
		}
		// else the currently loaded data is not compatible
	}

	// check if we are actually loading compatible data
	if (this.loading) {
		// we are loading
		if (this.loading.data.isSupersetOf(loadspec.data)) {
			// That data currently getting requested can be used for our request
			loadspec.req = this.loading.req;
			this.loading.req = null;

			this._abortDataRequest();

			this.loading = loadspec;
			this._startProgress();
			return;
		}
		// Data currently loading is not compatible
		this._abortDataRequest();
	}

	// Need a new request
	this.loading = loadspec;
	this._startProgress();
	this.loading.req = this.owner.dataRequestStart(loadspec.data);
	if (!loadspec.req) {
		throw new Error("dataRequestStart() didn't return ajax object");
	}
},

_startProgress:
function() {
	if (this.loading.display.progress) {
		this.loading.display.progress.show();
	}
},

_stopProgress:
function() {
	if (this.loading.display.progress) {
		this.loading.display.progress.hide();
	}
},

_abortDataRequest:
function() {
	requireArgs(arguments, 0);

	if (this.loading) {
		this._stopProgress();
		if (this.loading.req) {
			this.loading.req.abortRequest();
		}
		this.loading.result.reject(this.loading.display, false);
		this.owner.displayRequestAborted(this.loading.display);
	}
	this.loading = null;
},

cb_loadCompleted:
function(req, node, xml) {
	requireArgs(arguments, 3);

	if (!this.loading) {
		throw new Error("|loadCompleted| while not in loading state");
	}

	this.loaded.data = this.loading.data;
	this.loaded.display = this.loading.display;
	this._stopProgress();
	this.loading = null;
	this.owner.dataRequestReady(this.loaded.data, node);
	this.owner.displayRequestReady(this.loaded.display);
},

cb_loadFailed:
function() {
	if (this.loading) {
		noty({
			text: "Leider ist ein Fehler aufgetreten. Bitte versuchen Sie es später erneut.",
			type: "error",
			layout: "center",
			modal: true
		});

		this.loading.req = null;
		this._abortDataRequest();
	}
},

registerAjaxXPath:
function(ajax, xpath) {
	requireArgs(arguments, 2);
	ajax.nDataReady.addOnXPath(xpath, Obj.bindname(this, "cb_loadCompleted"));
	// Also gets triggered on unrelated ajax requests
	ajax.nAjaxError.add(Obj.bindname(this, "cb_loadFailed"));
}

});

})(this);


(function (Dz) {
	"use strict";

// ==========================================================================
// ObjectDataState

/** Tracks the state of an objects loaded xml */
Dz.ObjectDataState = Class({
LEVELS: {
	persisted: -1,
	stub: 0,
	view: 1,
	edit: 2
},

__init__:
function(level) {
	requireArgs(arguments, 1);
	if (!(level in this.LEVELS))
		logic_error("unknown data level");
	this.level = this.LEVELS[level];
},

isSupersetOf:
function(other) {
	requireArgs(arguments, 1);
	if (other.level === undefined || other.level === null)
		return false;
	return (other.level <= this.level);
}

});


// ==========================================================================
// ObjectDisplayState

/** Tracks the state of an objects display level */
Dz.ObjectDisplayState = Class(DisplayState, {
__init__:
withParams(1, {datalevel: null, target: null, progress: undefined, render_options: undefined},
function(mode, options) {
	requireArgs(arguments, 2, 4);
	DisplayState.prototype.__init__.call(this, options.progress);
	this.mode = mode;
	this.datalevel = options.datalevel || mode;
	this.target = options.target;
	this.render_options = options.render_options;
}),

requiredData:
function() {
	requireArgs(arguments, 0);
	return new ObjectDataState(this.datalevel);
},

adjustToData:
function() {
}

});


// ==========================================================================
// ObjectRepr

/** @class Representation of an XML object with properties that can
 * viewed/edited/...
 * @extends XmlRepr
 *
 * @param arguments Die Argumente werden and den XmlRepr Konstruktor
 * weitergegeben
 */
Dz.ObjectRepr = Class(Dz.XmlRepr,
/** @lends ObjectRepr.prototype */
{
/** Initialisiert ein neues Objekt */
__init__:
function(parent, xmlNode, options) {
	requireArgs(arguments, 2, 3);

	this.selected = false;
	this.listings = {};

	XmlRepr.prototype.__init__.call(this, parent, xmlNode, options);
	this.rId = xmlNode.getAttribute('id');

	// If global ajax is used there is no way to clean up event the xpath event
	// listeners once the node object gets destroyed
	this.localAjax = new Ajax();
	this.loadmanager.registerAjaxXPath(this.localAjax, "/info/*");
},

// overrides base class method
adaptXml:
function(/*...*/) {
	XmlRepr.prototype.adaptXml.apply(this, arguments);

	// Adapt subobjects
	if (this.xmlNode === null)
		this.adaptXml_empty_();
	else
		this.adaptXml_node_();
},

/** A new Xml node was set */
adaptXml_node_:
function () {
	this.listings = this.adaptXmlReprs_(this.listings, xmltools.getSubNodes(this.xmlNode, './*'));

																															/*
	// Create/keep listings for all the new xml nodes
	xmltools.getSubNodes(this.xmlNode, './*').each(function (lnode) {
		if (/.*listing$/.test(lnode.nodeName)) {
			log.warning("non-listing subobject: " + Dom.xmlPath(lnode));
			continue;
		}
		var lcr = makeCrId(lnode);
		var listing;
		if (lcr in this.listings) {
			// We have a fitting existing listing
			listing = this.listings[lcr];
			listing.adaptXml(lnode);
			newlistings[lcr] = listing;
		}
		else {
			// No existing listing object, create one
			listing = this.manager.representations.getInstance(xnode.tagName, this, xnode);
			this.propagateDisplaysTo(listing);
			newlistings[lcr] = listing;
		}
	}, this);

	// Any other listings that are now missing in the xml get removed
	for (name in this.listings) {
		if (!(name in newlistings)) {
			this.listings[name].dispose();
		}
	}

	this.listings = newlistings;
	*/

	// Manage "selected" flags
	if (this.selected) {
		this.setFlag('selected', this.selected);
	}
	this.selected = this.getFlag('selected');

	// Determine new load state
	if (this.xmlNode.getAttribute("input") == 'true') {
		this.loadmanager.loaded.data = new ObjectDataState('edit');
	}
	else if (this.xmlNode.getAttribute("expanded") == 'true') {
		this.loadmanager.loaded.data = new ObjectDataState('view');
	}
	else {
		this.loadmanager.loaded.data = new ObjectDataState('stub');
	}
},

/** An empty Xml node was set */
adaptXml_empty_:
function () {
	this.listings = this.adaptXmlReprs_(this.listings, null);

	/*
	var name, listing;
	// There is no new Xml
	// Keep only listings that are marked persistent
	var keeplistings = {};
	for (name in this.listings) {
		listing = this.listings[name]);
		if (listing.persistCount) {
			newlistings[name] = listing;
			listing.adaptXml(null);
		}
		else {
			listing.dispose();
		}
	}
	this.listings = keeplistings;
	*/

	// reset data state
	this.loadmanager.loaded.data = new ObjectDataState('persisted');
},


// TODO: maybe separate |replaceContentXml|?

/* Functions fopr easy access to asociated XML */

has:
function(name) {
	var subnodes = getChildrenByTagName(this.xmlNode, name);
	return (subnodes.length !== 0);
},

_get:
function(name, value, optional) {
	requireArgs(arguments, 3);
	var subnode = this.__getNode(name, value, optional);
	if (subnode) {
		return $(subnode).text();
	}
	if (!optional) {
		log.warning("no property '" + name + "' found for node " + Dom.path(this.xmlNode));
	}
	return value;
},

__getNode:
function(name, value, optional) {
	requireArgs(arguments, 3);
	
	var subnodes = getChildrenByTagName(this.xmlNode, name);
	if (subnodes.length === 0) {
		if (!optional) {
			log.warning("no node '" + name + "' found for node " + Dom.path(this.xmlNode));
		}
		return null;
	}
	if (subnodes.length > 1) {
		log.warning("multiple nodes '" + name + "' found for node " + Dom.path(this.xmlNode));
	}
	return subnodes[0];
},

/**
	Gets the text content of a child node in the associated XML node by name
	@param {String} Tag name of child node to access
	@returns {String} Text content of child tag
*/
get:
function(name, value) {
	requireArgs(arguments, 1, 2);
	return this._get(name, value, isdefined(value));
},

getInt:
function(name, value) {
	requireArgs(arguments, 1, 2);
	var s = this._get(name, null, isdefined(value));
	if (s === null)
		return value;
	else
		return parseInt(s, 10);
},

getFloat:
function(name, value) {
	requireArgs(arguments, 1, 2);
	var s = this._get(name, null, isdefined(value));
	if (s === null || s === '')
		return value;
	else
		return parseFloat(s);
},

getId:
function(name, value) {
	requireArgs(arguments, 1, 2);
	return this.__getNode(name, value, isdefined(value)).getAttribute("id");
},

getObject:
function (name) {
	requireArgs(arguments, 1, 2);
	var xnode = $(this.xmlNode).children(name).single("xml object node " + name);
	return this.manager.representations.getInstance(xnode[0].tagName, this, xnode[0]);
},

/**
	Sets the text content of a child node in the associated XML node by name
	@param {String} name Tag name of child node to access
	@param {String} value New text content that will be saved in XML
	@returns {String} That text that was assigned
*/
set:
function(name, value) {
	requireArgs(arguments, 2);

	var subnodes = getChildrenByTagName(this.xmlNode, name);
	if (subnodes.length === 0) {
		// TODO: Vielleicht möchte man den subnode dann einfach Erzeugen?
		log.warning("no property '" + name + "' found for node " + Dom.path(this.xmlNode));
		return null;
	}
	if (subnodes.length > 1) {
		log.warning("multiple properties '" + name + "' found for node " + Dom.path(this.xmlNode));
	}
	if (subnodes[0].children.length > 1) {
		log.warning("property '" + name + "' for node " + Dom.path(this.xmlNode) + " has multiple child nodes");
	}
	var node = subnodes[0];
	if (node.firstChild) {
		return ((node.firstChild.data = value));
	}
	else {
		return ((node.appendChild(node.ownerDocument.createTextNode(value))));
	}
},

_getAttr:
function(name, value, optional) {
	requireArgs(arguments, 3);
	var avalue = $(this.xmlNode).attr(name);
	if (avalue !== undefined) {
		return avalue;
	}
	else {
		if (!optional)
			throw new Error("no attribute '" + name + "' found for node " + Dom.path(this.xmlNode));
		return value;
	}
},

getAttr:
function(name, value) {
	requireArgs(arguments, 1, 2);
	return this._getAttr(name, value, isdefined(value));
},

setAttr:
function(name, value) {
	requireArgs(arguments, 2);
	this.xmlNode.setAttribute(name, value.toString());
},

setFlag:
function(name, value) {
	requireArgs(arguments, 2);
	if (value)
		this.xmlNode.setAttribute(name, name);
	else
		this.xmlNode.removeAttribute(name);
},

getFlag:
function(name) {
	requireArgs(arguments, 1);
	return this.xmlNode.getAttribute(name) != null;
},

// Managing loading of data and display state

dataRequestStart:
function(spec) {
	requireArgs(arguments, 1);

	if (spec.level == spec.LEVELS.view) {
		return this.localAjax.startPostRequest(
				this.objectQuery().appending("action", "view"));
	}
	else if (spec.level == spec.LEVELS.edit) {
		return this.localAjax.startPostRequest(
				this.objectQuery().appending("action", "edit"));
	}
	else {
		throw new Error("invalid data load spec");
	}
},

dataRequestReady:
function(spec, newnode) {
	if (newnode.getAttribute('id') !== this.xmlNode.getAttribute('id')) {
		throw new Error('got data for wrong node id (' +
				newnode.getAttribute('id') + '!==' + this.xmlNode.getAttribute('id') + ')');
	}
	this.replaceXml(newnode);
},

displayRequestReady:
function(spec) {
	requireArgs(arguments, 1);

	if (spec.mode == "view") {
		this.renderView(spec.target, spec.render_options);
		//this.renderExpand();
	}
	else if (spec.mode == "edit") {
		this.renderEdit(spec.target, spec.render_options);
	}
	else if (spec.mode == "expand") {
		this.renderExpand(spec.target);
	}
	else {
		throw new Error("invalid display mode '" + spec.mode + "'");
	}

	//XmlRepr.prototype.displayRequestReady.call(this, spec);
},


// Loading and displaying data 

/** Loads data necessary for 'view' and then calles |renderView| to render */
view:
function(viewportname, render_options) {
	requireArgs(arguments, 0, 2);
	viewportname = defaulting(viewportname, 'workspace');

	/*
	var spinners = [];
	spinners.push({hnode: this.manager.viewports[viewportname].hcnode});
	var name;
	for (name in this.displays) {
		if (name != viewportname && this.displays[name] && this.displays[name].hnode) {
			spinners.push({
				hnode: this.displays[name].hnode,
				opts: {radius:3, length: 4, width: 2, left: 0}});
		}
	}
	*/

	this.requestDisplay(new ObjectDisplayState("view", {
				target: viewportname,
				progress: this.getProgressItems(),
				render_options: render_options
			}
		));
},

/** Called when data for "view" is ready and can be rendered */
renderView:
function(viewportname, options) {
	requireArgs(arguments, 1, 2);
	options = defaultOpts(options, {
			mode: 'view',
			toggle: false
		});
	this.renderViewport(viewportname, {renderMode: options.mode});
	if (options.toggle) {
		var displayname, display;
		for (displayname in this.displays) {
			// TODO: This is a bit a hack. We'd need a better way to determine
			// which displays can be expanded
			if (displayname == viewportname)
				continue;
			display = this.displays[displayname];
			if (display && display.isExpandable()) {
				if (display.expanded) {
					display.hnode.subpart('content').slideToggle();
				}
				else {
					this.renderDisplayContent(displayname, {
							variant: 'expand'
						});
					display.expanded = true;
					//display.hnode.slideDown();
				}
			}
		}
	}
},

/** Edit the object by making sure it's loaded in edit mode and then rendering it
 * to the managers workspace
 */
// TODO: How is this supposed to work for lists? What about inline editing?
edit:
function(viewport) {
	requireArgs(arguments, 0, 1);
	viewport = this.toViewport(viewport, 'workspace');
	/*
	//var spinners = [this.inlineSpin(), this.manager.viewportSpin('workspace')];
	var spinners = [{hnode: viewport.hcnode}];
	// c&p von view():
	var name;
	for (name in this.displays) {
		if (name != viewport.name && this.displays[name] && this.displays[name].hnode) {
			spinners.push({
				hnode: this.displays[name].hnode,
				opts: {radius:3, length: 4, width: 2, left: 0, top: 0}});
		}
	}
	*/

	this.requestDisplay(new ObjectDisplayState("edit", {
				target: viewport.name,
				progress: this.getProgressItems()
			}
		));
},

/** Called when data is ready for "edit" and can be rendered */
renderEdit:
function(viewportname, options) {
	requireArgs(arguments, 1, 2);
	this.renderViewport(viewportname, {renderMode: 'edit'});
},

/** Display content in inline "content" area */
expand:
function(options) {
	requireArgs(arguments, 0, 1);
	options = defaultOpts(options, {
			target: undefined
		});
	Obj.extend(options, {datalevel: 'view'});
	this.requestDisplay(new ObjectDisplayState("expand", options));
},

// NOT used by viewAndToggle
renderExpand:
function(target) {
	requireArgs(arguments, 0, 1);
	var displayname, display;
	for (displayname in this.displays) {
		display = this.displays[displayname];
		if (display && display.isExpandable()) {
			// Rendert ein Objekt inkusive von Unterlistings.
			// Ohne -expand würde nur das Objekt selbst gerendert.
			this.renderDisplayContent(displayname, {
					variant: 'expand'
				});
			display.hnode.slideDown();
			display.expanded = true;
		}
	}
},

viewAndToggle:
function () {
	this.view('workspace', {toggle: true});
},

confirm_erase: function () {
	return confirm("Wirklich löschen?");
},

erase:
function(force) {
	requireArgs(arguments, 0, 1);

	if (force || this.confirm_erase()) {
		this.manager.ajax.startPostRequest(
				this.objectQuery().appending("action", "delete")
			);
	}
},

delete_:
renamedFunction('delete_', 'erase'),

move:
function (targetid) {
	this.manager.ajax.startPostRequest(
			this.query().appending("from", "select" + this.spId).appending("action", "move").appending("to", "select" + targetid)
			//this.objectQuery().appending("action", "move").appending("to", "select" + targetid)
		);
},

callDisplayChildren:
function(childfn, part) {
	requireArgs(arguments, 1, 2);
	part = defaulting(part, null);
	var key;
	if (!part || part == "content") {
		for (key in this.listings) {
			childfn.call(this.listings[key]);
		}
	}
},

setSelected:
function(selected) {
	requireArgs(arguments, 1);
	if (selected == this.selected)
		return;
	if (this.xmlNode) {
		this.setFlag("selected", selected);
	}
	this.selected = selected;
	if (selected)
		this.persistInc();
	else
		this.persistDec();
},

select:
function(selected) {
	requireArgs(arguments, 1);
	this.setSelected(selected);
	// Andere views updaten. Wäre nicht nötig, wenn es nur eine View gäbe:
	//this.parent.renderContent();
},

// TODO:
selectSingle:
function() {
	requireArgs(arguments, 0);
	this.parent.selectSingleNode(this.xId, true);
},

queryAppendSelectedObjects:
function(qu) {
	requireArgs(arguments, 1);

	if (this.selected) {
		qu.appending('select' + this.spId, 'true');
	}

	// add selected objects in contained listings
	var name;
	for (name in this.listings) {
		this.listings[name].queryAppendSelectedObjects(qu);
	}
	return qu;
},

clearSelection:
function (options) {
	options = defaultOpts(options, {recursive: false});
	this.setSelected(false);
	if (options.recursive) {
		var name;
		for (name in this.listings) {
			this.listings[name].clearSelection(options);
		}
	}
}

});

})(window);


(function (Dz) {
	"use strict";

Dz.ListingDataProperties = Class({
__init__:
function() {
	this.serverlimit = null;
	this.clientlimit = null;
	this.localpages = null; // derived from serverlimit, clientlimit
	this.serverpage = null;
	this.totalnodes = null;
	this.serversearch = null;

	this.loadednodes = null;
	this.complete = null;

	//this.clientpage = null;
},

/** (Helper) Extract settings from XML */
update:
function(lst) {
	requireArgs(arguments, 1);
	// TODO: Knnen sich die options ndern, nachdem sie einmal initialisiert sind?
	var opts = lst.getXmlOptionsNode();

	this.serverlimit = parseInt(opts.getAttribute('serverlimit'), 10);
	if (isNaN(this.serverlimit))
		throw new Error("'serverlimit' attribute not set for " + Dom.path(lst.xmlNode));

	this.clientlimit = parseInt(opts.getAttribute('clientlimit'), 10);
	if (isNaN(this.clientlimit))
		throw new Error("'clientlimit' attribute not set for " + Dom.path(lst.xmlNode));

	this.serverpage = parseInt(opts.getAttribute('serverpage'), 10);
	if (isNaN(this.serverpage))
		throw new Error("'serverpage' attribute not set for " + Dom.path(lst.xmlNode));

	this.serversearch = opts.getAttribute('serversearch') || false;

	if (!this.serversearch)
		this.serversearch = false;

	if (this.serverlimit % this.clientlimit !== 0) {
		log.warning("paging broken for " + Dom.path(lst.xmlNode) + ": " +
				"serverlimit (" + this.serverlimit + ") not a multiple of clientlimit (" + this.clientlimit + ")");
	}
	this.localpages = Math.div(this.serverlimit, this.clientlimit);

	this.totalnodes = parseInt(opts.getAttribute('size'), 10);

	this.loadednodes = lst.getXmlObjectNodes().length;

	if (this.loadednodes > this.serverlimit) {
		log.warning("got more (" + this.loadednodes + ") than serverlimit (" + this.serverlimit + ") results on single serverpage for " +
				Dom.path(lst.xmlNode));
	}
	var fullpage = (this.loadednodes >= this.serverlimit);
	var fetchcount = this.fromServerPage(this.serverpage) + this.loadednodes;

	if (!isNaN(this.totalnodes)) {
		// We know the total number of possible items
		if (fetchcount > this.totalnodes) {
			logic_warning("got more nodes (" +fetchcount + ") than the server reports as existing (" + this.totalnodes + ") for " +
					Dom.path(lst.xmlNode),
					[lst.getXmlObjectsNode()]
				);
		}
		if (!fullpage && (fetchcount < this.totalnodes)) {
			logic_warning("got fewer nodes than expected " +
					"(serverpage: " + this.loadednodes + " < " + this.serverlimit + ", " +
					"total " + fetchcount + " < " + this.totalnodes + ") for " +
					Dom.path(lst.xmlNode),
					[lst.getXmlObjectsNode()]
				);
		}

		if (fetchcount == this.totalnodes) {
			this.complete = true;
		}
		else {
			// There are more nodes
			this.complete = false;
			if (!fullpage) {
				// TODO: disabled because search results give "incomplete" pages
				//log.warning("Didn't get full serverpage of nodes while there should be more for " + Dom.path(lst.xmlNode));
				this.complete = true;
			}
		}
	}
	else {
		// We don't know the total number of nodes
		// We assume we are on the last page if it's not competely filled anymore
		this.complete = !fullpage;
	}
},

/** Der Server schickt blicherweise eine grere Anzahl von Elementen, als
 * auf einer Seite angezeigt werden. In diesen Daten kann dann lokal
 * geblttert werden. Die Blcke, in die der Server die Daten einteilt,
 * werden Serverseiten genannt. Seiten die am Cleint angezeigt werden,
 * heien Anzeigeseiten.
 *
 * displayoffset: (0-basierend)
 *   Der Index eines Elements im gesamten Datenbestand. dessen Seite
 *   angezeigt werden soll
 * displaypage: (1-basierend)
 *   Der Index einer Anzeigeseite im gesamten Datenbestand. Dies
 *   entspricht der Zahl, die dem Nutzer als Seitennummer angezeigt wird.
 * serverpage: (1-basierend)
 *   Der Index des Datenblockes, der vom Server geschickt wurde, im
 *   gesamten Datenbestand (Also der Index der Serverseite)
 * clientpage: (1-basierend)
 *   Der Index der Anzeigeseite, in den lokal am Client vorhandenen Daten,
 *   also in der geladenen Serverseite.
 */

/** Die displaypage ist der Index der Seite im globalen Datenbestand, der
 * zu dem |displayoffset| gehrt.
 */
displayPage:
function(displayoffset) {
	requireArgs(arguments, 1);
	return Math.div(displayoffset, this.clientlimit) + 1;
},

/** Die clientpage ist der Index der Seite im lokalen Datenbestand, der zu dem
 * |displayoffset| gehrt
 */
clientPage:
function(displayoffset) {
	requireArgs(arguments, 1);
	return Math.div(displayoffset - (this.serverpage-1)*this.serverlimit, this.clientlimit) + 1;
},

serverPage:
function(displayoffset) {
	requireArgs(arguments, 1);
	return Math.div(displayoffset, this.serverlimit) + 1;
},

/** Creates a displayoffset fitting for the display page */
fromDisplayPage:
function(displaypage) {
	requireArgs(arguments, 1);
	return (displaypage-1) * this.clientlimit;
},

/** Creates a displayoffset fitting for the server page */
fromServerPage:
function(serverpage) {
	requireArgs(arguments, 0, 1);
	serverpage = defaulting(serverpage, this.serverpage);
	return (serverpage-1) * this.serverlimit;
},

baseDisplayOffset:
function() {
	return this.fromServerPage(this.serverpage);
},

roundToDisplayPage:
function(displayoffset) {
	return this.fromDisplayPage(this.displayPage(displayoffset));
},

roundToServerPage:
function(displayoffset) {
	return this.fromServerPage(this.serverPage(displayoffset));
},

searchLocally:
function() {
	requireArgs(arguments, 0);
	if (this.serversearch)
		return false;
	// Can only search locally if data is completely available
	return this.complete;
}

});


})(window);


(function (Dz) {
	"use strict";

var debug_xml_parent = false;

// ==========================================================================
// Small helper classes to manage state of data

var ListingDataState = Dz.ListingDataState = Class({
__init__:
withParams(4,
function(searchterm, serverpage, refinable, restrictions) {
	this.searchterm = searchterm;
	this.serverpage = serverpage;
	this.refinable = refinable;
	this.restrictions = restrictions;
	this.flaggedsearch = false;
}),

/** Checks if another state is contained in this one
 * @param {ListingDataState} other State to compare
 */
isSupersetOf:
withParams(1,
function(other) {
	if (this.restrictions != other.restrictions)
		return false;
	if (this.serverpage != other.serverpage)
		return false;
	if (this.searchterm == other.searchterm) {
		// idential
		return true;
	}
	if (!this.refinable) {
		// Don't even have to look for a refined search
		return false;
	}
	if (Str.startsWith(other.searchterm, this.searchterm)) {
		// Other is refined search
		return true;
	}
	// Other isn't refined search
	return false;
})

});


var ListingDisplayState = Dz.ListingDisplayState = Class(DisplayState, {
__init__:
function(searchterm, displayoffset, xmlopts, restrictions, progress) {
	requireArgs(arguments, 4, 5);
	DisplayState.prototype.__init__.call(this, progress);

	this.searchterm = searchterm;
	this.displayoffset = displayoffset;
	// This causes all searches to go through local flagging
	// (even those loaded from server)
	this.flagsearch = (this.searchterm !== "");
	// This would cause only local searches to go through flagging:
	//this.flagsearch = false;

	this._serverpage = xmlopts.serverPage(displayoffset);
	this.restrictions = restrictions;
},

/** Determine the required data state
 * @returns {ListingDataState}
 */
requiredData:
function() {
	requireArgs(arguments, 0);
	// By default a search is not refinable, since we don't know
	// yet what the server will return. Once we get a result from the
	// server, we update |refinable| appropriately.
	// This doesn't stop *this* state to be interpreted as a refinement
	// of a *previous* state, since that depens on the other state's
	// |refinable|.
	return new ListingDataState(this.searchterm, this._serverpage, false, this.restrictions);
},

adjustToData:
function(dataspec) {
	// Optimization:
	// Could compare against previously active displaystate to see
	// if you *really* need reflagging or if this searchterm is identical
	// to previously displayed one
	requireArgs(arguments, 1);
	if (dataspec.flaggedsearch) {
		// If there are already search flags in the Xml we have to update them
		this.flagsearch = true;
	}
	else {
		// If the search terms we use differ from the existing ones
		// we have to update the flags.
		// Generally this should be just a search refinement.
		this.flagsearch = (this.searchterm != dataspec.searchterm);
	}
}

});


// ==========================================================================
// Listing class

/** @class
 * Verwaltet ein Listing von Objekten. Dazu werden die lokal geladenen Daten
 * verwaltet und ihre Relation zum gesammten auf dem Server vorhandenen
 * Datenbestand. Suchbegriffe und Filtereinstellungen werden ebenfalls verwaltet.
 *
 * @param {XmlNode}xmlNode Node im XML-Dokument der zu diesem Listing gehÃ¶rt
 * @param {String} mode: Anzeigemodus fÃ¼r dieses Listing
 */
var ListingRepr = Dz.ListingRepr = Class(XmlRepr,
/** @lends ListingRepr# */
{
__init__:
withParams(2, {
			autoCollapse: false,
			lazyInit: true
		},
function(parent, xmlNode, options) {
	this.lazyInit = options.lazyInit;

	this.dataProperties = new ListingDataProperties();

	// subreprs
	this.nodeReprs = {};
	this.optReprs = {};
	// compatibility hack:
	this.optlistings = {
		listings: this.optReprs
	};

	// base class constructor
	XmlRepr.prototype.__init__.call(this, parent, xmlNode);

	this.panels = [];

	// Xml properties
	// max number of nodes on one page loaded from server
	// max number of nodes on one displayed page

	// search
	this.loadingdata = null; // T

	this.autoCollapse = options.autoCollapse;

	this.resetRestrictions();

	this.option = new Option();
	this.filters = [];

	this.loadmanager.loaded.data = new ListingDataState(
			"",
			this.dataProperties.serverpage,
			this.dataProperties.searchLocally(),
			""
		);
	this.loadmanager.loaded.display = new ListingDisplayState(
			"",
			this.dataProperties.baseDisplayOffset(),
			this.dataProperties,
			""
		);
	this.localAjax = new Ajax();
	this.loadmanager.registerAjaxXPath(this.localAjax, "/info/*");

	if (!options.lazyInit) {
		// Forces creation of all subobject nodes
		this.getServerPageNodes();
	}

	// Using |bindname| instead of |bind| causes the actual function to be
	// resolved when the function is actually called, not when the
	// event handler is created here. This is relevant if the handler
	// is changed after this setup, like it happens with the QUnit testing
	// setup. There the new, changed handler needs to be run to execute the
	// appropriate tests.
	// This only works if the event handler doesn't save the function object
	// itself (as it happens with |tie|), but references the function by name
	// instead (what is doen by |bindname|).

	// listing loaded
	this.manager.ajax.nDataReady.addOnXPath(
			"/info[@action='load']/" + this.xmlNode.tagName,
			Obj.bindname(this, "cb_loaded"));

	// listing updated
	this.manager.ajax.nDataReady.addOnXPath(
			"/info[@action='update']/" + this.xmlNode.tagName,
			Obj.bindname(this, "cb_updated"));



	var itemname = this.xmlNode.tagName.substr(0, this.xmlNode.tagName.length - "listing".length);
	this.registerNodeCallbacks(itemname);
}),

/** Register callbacks for changes of the contained nodes
 * @parma {String} nodename Name of the nodes to listen for
 */
registerNodeCallbacks:
function(nodename) {
	// node inserted
	this.manager.ajax.nDataReady.addOnXPath(
			"/info[@action='insert']/" + nodename,
			Obj.bindname(this, "cb_nodeInserted"));
	// node updated
	this.manager.ajax.nDataReady.addOnXPath(
			"/info[@action='update']/" + nodename,
			Obj.bindname(this, "cb_nodeUpdated"));
	this.manager.ajax.nDataReady.addOnXPath(
			"/info[@action='incomplete']/" + nodename,
			Obj.bindname(this, "cb_nodeIncomplete"));
	// node deleted
	this.manager.ajax.nDataReady.addOnXPath(
			"/info[@action='delete']/" + nodename,
			Obj.bindname(this, "cb_nodeDeleted"));

	// node moved
	this.manager.ajax.nDataReady.addOnXPath(
			"/info[@action='move' and @from='" + this.xId + "']/" + nodename,
			Obj.bindname(this, "cb_nodeDeleted"));
	this.manager.ajax.nDataReady.addOnXPath(
			"/info[@action='move' and @to='" + this.xId + "']/" + nodename,
			Obj.bindname(this, "cb_nodeInserted"));
},


// General Xml functions

/** Get the options node */
getXmlOptionsNode:
function() {
	requireArgs(arguments, 0);
	return xmltools.getSubNode(this.xmlNode, "./options");
},

/** Get a specific object node */
getXmlObjectNode:
function(id) {
	requireArgs(arguments, 1);
	if (!this.xmlNode)
		return null;
	return xmltools.getSubNode(this.xmlNode, "./objects/*[@id='" + id + "']", {required: false});
},

/** Get all object nodes */
getXmlObjectNodes:
function() {
	requireArgs(arguments, 0);
	return this.getXmlObjectsNode().childNodes;
},

/** Get the "new object" node */
getXmlNewObjectNode:
function(newnodeid) {
	requireArgs(arguments, 0, 1);
	newnodeid = defaulting(newnodeid, null);
	if (newnodeid === null) {
		return xmltools.getSubNode(this.xmlNode, "./newobject/*");
	}
	else {
		throw new Error("separate XML for new nodes not supported");
		//return xmltools.getSubNode(this.xmlNode, "./newobject/*[@id='" + newnodeid + "']");
	}
},

callDisplayChildren:
function(childfn, part) {
	requireArgs(arguments, 1, 2);
	part = defaulting(part, null);

	var key;
	if (!part || part == "options") {
		for (key in this.optReprs) {
			childfn.call(this.optReprs[key]);
		}
	}

	var nid;
	if (!part || part == "content") {
		// TODO: Better option than to apply to all cached nodes?
		for (nid in this.nodeReprs) {
			childfn.call(this.nodeReprs[nid]);
		}
	}
},

/// (Override) Replace the managed Xml node
replaceXml:
function(xnode) {
	requireArgs(arguments, 1);

	// Don't replace the whole node like in the base class
	// - <newobject>:
	//   The contents aren't resent on browse()/search() results.
	//   If there is need for a <newobject>, it should be present right
	//   from the beginning
	//   -> don't replace the existing newobject
	// - <options>:
	//   Contained objects aren't resent on browse()/search() results.
	//   Those should not be updated. For other search options it remains to
	//   be seen if those can change, and what should happen then (TODO).
	//   -> for now don't replace <options>, maybe later adjust the existing
	//      XML when updates come in as needed
	//   There are also sublistings for choice lists/... in the options
	//   (this.optReprs). Those refer to <...listing> tags in <options> node
	//   in the associated XML and would need to be adjusted if these nodes are
	//   changed

	// replace the <objects> node
	this.replaceObjectsXml(xmltools.getSubNode(xnode, "./objects"));

	// Replace the ./options node, but keep the existing ./options/objects
	this.replaceOptionsXml(xmltools.getSubNode(xnode, "./options"));
},

adaptXml:
function(xnode) {
	// Whole xml got set
	XmlRepr.prototype.adaptXml.apply(this, arguments);

	this.adaptObjectsXml();
	this.adaptOptionsXml();
},

/** Replace just the objects in the managed Xml node.
 * @param {XmlNode} xnode The new 'objects' Xml node
 */
replaceObjectsXml:
function(xnode) {
	requireArgs(arguments, 1);
	xnode = xmltools.replaceNode(this.getXmlObjectsNode(), xnode);
	this.adaptObjectsXml();
},

/** Adjust the repr object to a changed 'objects' xml node */
adaptObjectsXml:
function() {
	var name, repr, xnode, nodeid;

	// Check/adapt all cached nodes
	var newreprs = {};
	for (name in this.nodeReprs) {
		repr = this.nodeReprs[name];
		nodeid = Str.stripPrefix(name, 'node_');
		if (nodeid !== null) {
			xnode = this.getXmlObjectNode(nodeid);
			// Keep if it has new XML or is persistent
			if (xnode !== null || repr.persistCount) {
				repr.adaptXml(xnode);
				newreprs[name] = repr;
			}
			else {
				repr.detachDisplays();
				repr.dispose();
			}
		}
		else {
			// newnode repr
			if (this.xmlNode) {
				// Keep if we still have associated XML
				newreprs[name] = repr;
			}
			else {
				repr.dispose();
			}
		}
	}
	this.nodeReprs = newreprs;
},

/** Replace just the options in the managed Xml node.
 * @param {XmlNode} xnode The new 'options' Xml node
 */
replaceOptionsXml:
function(xnode) {
	// save ./options/objects
	var optobjs = xmltools.getSubNode(this.xmlNode, "./options/objects");
	// replace ./options
	xnode = xmltools.replaceNode(this.getXmlOptionsNode(), xnode);
	// restore ./options/objects
	xmltools.replaceNode(
			xmltools.getSubNode(this.xmlNode, "./options/objects"),
			optobjs
		);

	this.adaptOptionsXml(xnode);
},

/** Adjust the repr object to a changed 'options' xml node */
adaptOptionsXml:
function() {
	// Adjust settings to new XML options
	if (this.xmlNode === null) {
		this.optReprs = this.adaptXmlReprs_(this.optReprs, null);
	}
	else {
		this.dataProperties.update(this);
		this.optReprs = this.adaptXmlReprs_(this.optReprs, xmltools.getSubNodes(this.xmlNode, './options/objects/*'));
	}
	// compatibility hack
	this.optlistings = {
		listings: this.optReprs
	};
},

// Management of loaded data

dataRequestStart:
function(dataspec) {
	var qu = this.objectQuery({
			serverpage: dataspec.serverpage,
			searchterm: dataspec.searchterm,
			restrictStr: dataspec.restrictions
		}).appending('action', 'load');
	return this.localAjax.startPostRequest(qu);
},

dataRequestReady:
function(dataspec, newnode) {
	requireArgs(arguments, 2);
	if (this.crId != makeCrId(newnode)) {
		log.error("Received invalid node. Expected " + this.crId + ", got " + makeCrId(newnode));
	}
	this.replaceXml(newnode);
	dataspec.refinable = this.dataProperties.searchLocally();
	if (dataspec.serverpage != this.dataProperties.serverpage) {
		log.error("received wrong server page" +
				" (requested " + dataspec.serverpage + ", got " + this.dataProperties.serverpage);
	}
},

displayRequestReady:
function(displayspec) {
	requireArgs(arguments, 1);

	if (displayspec.flagsearch) {
		this.updateSearchFlags(displayspec.searchterm);
	}
	this.getXmlOptionsNode().setAttribute(
			"clientpage",
			this.dataProperties.clientPage(displayspec.displayoffset)
		);
	// Optimization:
	// Could check if flagging lead to any different results that previously
	// rendered search, and only re-render if necessary.
	// Comparing hit count should be enough if search is a refinement of 
	// previously displayed one. Would need to keep track of last rendered
	// search to compare with newly requested displays. On Backspace not even
	// re-flagging would be necessary as log as searchterm is still a refinement
	// of last render.
	//
	// TODO: Make flagging for "search" more flexible without having to pass through
	// all the render functions?
	// Maybe just set/unset |search| parameter for xslt here?
	this.renderContent({search: (displayspec.searchterm !== "")});
	// Paging would only need re-render if hit count changes.
	// Currently doesn't render search specific hit count anyway.
	this.renderPaging();
	XmlRepr.prototype.displayRequestReady.call(this, displayspec);

	if (displayspec.readyCallback) {
		displayspec.readyCallback();
	}
},

/** Errechnen der Serverseite aud einer Anzeigeseite.
 * Der Server schickt Ã¼blicherweise eine grÃ¶Ãere Anzahl von Elementen, als
 * auf einer Seite angezeigt werden. In diesen Daten kann dann lokal
 * geblÃ¤ttert werden. Die BlÃ¶cke, in die der Server die Daten einteilt,
 * werden Serverseiten genannt. Die BÃ¶cke, in denne die Daten angezeigt
 * werden heiÃen "Anzeigeseiten".
 * Server- sowie Anzeigeseiten sind 1-basierende Indizes.
 * Diese Funktion berechnet, in welcher Serverseite eine bestimmte
 * Anzeigeseite liegt.
 */



// ---------------------------------------------------------------------------
// Funktionen zum Arbeiten mit einzelnen Nodes

/** Erstellt einen neuen temporÃ¤ren newNode mit der angegebenen Id */
createNewNode:
function(newnodeid) {
	requireArgs(arguments, 1);
	var xnode = this.getXmlNewObjectNode().cloneNode(true);
	xnode.setAttribute('id', newnodeid);
	this.getXmlNewObjectNode().appendChild(xnode);
	//this.getXmlTempObjectsNode().appendChild(xnode);
},

/// Gets a node for newobject. Fakes different new objects in xml by setting the xml
/// id attribute to the desired value before returning
getNewNode:
function (options) {
	requireArgs(arguments, 0, 1);
	options = defaultOpts(options, {
		name: null,
		id: null
	});

	var key = 'newnode';
	var xp;
	if (options.name !== null)
		key += '_' + options.name;
	if (options.key !== null)
		key += '_' + options.key;
	if (!(key in this.nodeReprs)) {
		var xnode;
		if (options.name !== null)
			xnode = xmltools.getSubNode(this.xmlNode, './newobject/' + name);
		else
			xnode = xmltools.getSubNode(this.xmlNode, './newobject/*');

		if (options.id !== null)
			xnode.setAttribute("id", options.id);

		//log.debug("creating subobject repr for new node " + Dom.path(xnode));
		this.nodeReprs[key] = this.manager.representations.getInstance(xnode.tagName, this, xnode);
	}
	return this.nodeReprs[key];
},

getNode:
function(id) {
	requireArgs(arguments, 1);
	if (!isdefined(id) || id === null) {
		return this.getNewNode();
	}
	var key = 'node_' + id;
	if (!(key in this.nodeReprs)) {
		var xnode = this.getXmlObjectNode(id);
		if (xnode === null)
			return null;
		//log.debug("creating subobject repr for " + Dom.path(xnode));
		this.nodeReprs[key] = this.manager.representations.getInstance(xnode.tagName, this, xnode);
		this.propagateDisplaysTo(this.nodeReprs[key]);
	}
	return this.nodeReprs[key];
},

node:
function() {
	this.getNode.apply(this, arguments);
},

newNode:
function() {
	this.getNewNode.apply(this, arguments);
},

/** calls getNode(id).view() */
viewNode:
deprecateFunction('viewNode', 'use getNode(id).view() instead',
function(id) {
	requireArgs(arguments, 1);
	this.getNode(id).view();
}),

/** calls getNode(id).expand() */
expandNode:
deprecateFunction('expandNode', 'use getNode(id).expand() instead',
function(id, hnode) {
	requireArgs(arguments, 2);
	this.getNode(id).expand();
}),

/** calls getNode(id).collapse() */
collapseNode:
deprecateFunction('collapseNode', 'use getNode(id).collapse() instead',
function(id) {
	requireArgs(arguments, 1);
	this.getNode(id).collapse();
}),


/** calls getNode(id).edit() */
editNode:
function(id) {
	requireArgs(arguments, 1);
	this.getNode(id).edit();
},

/** calls getNode(id).save() */
saveNode:
deprecateFunction("saveNode", "use getNode(id).save() instead",
function(id) {
	requireArgs(arguments, 1);
	this.getNode(id).save();
}),

/** Updates the local data to remove the node with the given node
 * @param {String} nodeid Id of node to remove */
localEraseNode:
function(nodeid) {
	requireArgs(arguments, 1);

	// Remove repr
	var key = 'node_' + nodeid;
	if (key in this.nodeReprs) {
		// If the node is currently redered in a viewport,
		// remove the node and close that viewport
		this.manager.closeReprViewports(this.nodeReprs[key]);
		this.nodeReprs[key].dispose();
		delete this.nodeReprs[key];
	}

	// Update Xml
	var node = this.getXmlObjectNode(nodeid);
	node.parentNode.removeChild(node);
	this.getXmlOptionsNode().setAttribute('size', this.dataProperties.size-1);
	this.dataProperties.update(this);
	//this.dataProperties.loadednodes -= 1;

	// Update display
	this.renderContent();
},

/** Deletes a node on the server
 * calls getNode(nodeid).erase();
 * @param {String} nodeid Id of node to be deleted
 */
eraseNode:
function(nodeid) {
	requireArgs(arguments, 1);
	this.getNode(nodeid).erase();
},

deleteNode:
renamedFunction('deleteNode', 'eraseNode'),

// ---------------------------------------------------------------------------
// Funktionen zum Arbeiten mit der kompletten Liste

load:
function() {
	// TODO: probably never called and identical to |reload|
	this.manager.ajax.startPostRequest(
		this.objectQuery().appending("action", "load")
	);
},

/** reload the assiciated xml */
// TODO: move to XmLRepresentation
reload:
function(hNode) {
	requireArgs(arguments, 0, 1);

	// reset load manager to forget about cached data
	this.loadmanager.resetData();

	// Browse to current page
	// TODO: BlÃ¤ttert immer eine Seite zurÃ¼ck
	var curpage = this.dataProperties.displayPage(this.loadmanager.loaded.display.displayoffset);
	this.browse(curpage);
},

reset:
function (callback) {
	requireArgs(arguments, 0, 1);
	this.resetRestrictions();
	var displayspec = new ListingDisplayState(
			"",
			0,
			this.dataProperties,
			this.getRestrictionsSpec()
			//new SpinnerLoadScreen(this.htmlContents())
		);
	displayspec.readyCallback = callback;
	this.requestDisplay(displayspec);
},

/** Starts request to load a specific node
 * @param {String} nodeid Id of desired node
 */
loadNode:
function(nodeid, callback) {
	requireArgs(arguments, 1, 2);
	this.showProgress();
	callback = defaulting(callback, null);
	var req = this.manager.ajax.startPostRequest(
			this.objectQuery().appending("action", "get").appending("id", nodeid)
		);
	var self = this;
	req.dnDataReady.add(function () {
		self.hideProgress();
		if (callback) {
			callback.apply(this, arguments);
		}
	});
},

// ajax callback
cb_loaded:
function(xml, xnode, req) {
	//this.replaceObjectsXml(xnode);
	this.replaceXml(xnode);
	this.renderContent();
	this.renderPaging();
},

/** Ajax callback
 * Called when the listing was edited and the new updated XML was received
 * Replaces Xml and renders Displays
 */
cb_updated:
function(xml, xnode, req) {
	this.replaceXml(xnode);
	this.renderContent();
	this.renderPaging();
},

// --- search ----------------------------------------------------------------

/** Search */
search: loggingErrors("search handler",
function(event, hnode) {
	requireArgs(arguments, 2);
	cancelEvent(event);

	var searchterm = hnode.value;
	this.requestDisplay(new ListingDisplayState(
			searchterm,
			0,
			this.dataProperties,
			this.getRestrictionsSpec(),
			this.getProgressItems()
			//new SpinnerLoadScreen(this.htmlContents(), {maxtop: 40})
		));
}),

searchServer:
deprecateFunction('searchServer', "use normal 'search()' and set 'serversearch' property in Xml instead",
function(event, hnode) {
	this.dataProperties.serversearch = true;
	this.search(event, hnode);
}),

/** Gets called to test if a node is a match for a search term.
 * The default checks the "name" property.
 */
checkSearchHit: search_TagStart('name'),

/** Updates state of loadmanger and search flags im Xml
 *	Ein leerer/null Suchbegriff bedeutet, dass es sich nicht
 *	tatsÃ¤chlich um eine Suche handelt.
 * @param {String?} searchterm Suchbegriff
 */
updateSearchFlags:
function(searchterm) {
	requireArgs(arguments, 1);
	if (searchterm) {
		if (this.dataProperties.serversearch) {
			this._setSearchFlagsAll();
		}
		else {
			this._setSearchFlags(searchterm);
		}
		this.loadmanager.loaded.data.flaggedsearch = true;
	}
	else {
		this._removeSearchFlags();
		this.loadmanager.loaded.data.flaggedsearch = false;
	}
},

/** @private Probably better use updateSearchFlags */
_setSearchFlags:
function(searchterm) {
	requireArgs(arguments, 1);

	// TODO: use "objects" node instead of firstChild
	//var items = this.xmlNode.firstChild.childNodes;
	searchterm = searchterm.toLowerCase();

	// mark those matching |searchterm|
	var hits = 0;
	var items = this.getXmlObjectNodes();
	var i, l;
	for (i = 0, l = items.length; i < l; ++i) {
		var item = items[i];
		if (this.checkSearchHit(item, searchterm)) {
			item.setAttribute("search", "1");
			hits++;
		}
		else {
			item.removeAttribute("search");
		}
	}
	//log.debug("search found " + hits + " hits");
},

_setSearchFlagsAll:
function() {
	requireArgs(arguments, 0);

	// mark those matching |searchterm|
	var items = this.getXmlObjectNodes();
	var i, l;
	for (i = 0, l = items.length; i < l; ++i) {
		items[i].setAttribute("search", "1");
	}
},

/** @private Probably better use updateSearchFlags */
_removeSearchFlags:
function() {
	requireArgs(arguments, 0);
	var items = this.getXmlObjectNodes();
	var i, l;
	for (i = 0, l = items.length; i < l; ++i) {
		items[i].removeAttribute("search");
	}
},


// --- select ----------------------------------------------------------------

/** Selects the passed node, deselecting any previously selected node.
 * If |null| is passed, only the currently selected node is deselected.
 * @param {String} nodeid Id of the node to be selected
 */
selectSingleNode:
function(nodeid) {
	requireArgs(arguments, 1);

	// Deselect everything currently selected
	this.getSelectedNodes().forEach(function (node) {
		node.setSelected(false);
	});

	if (nodeid !== null) {
		this.getNode(nodeid).setSelected(true);
	}

	//this.renderComplete({renderMode: "select"});
	this.renderComplete();
},

getSelectedNode:
function() {
	var nodeids = this.getSelectedNodeIds();
	if (nodeids.length > 1) {
		logic_warning("multiple selected nodes when only one expected", [this]);
	}

	if (nodeids.length === 0)
		return null;
	else
		return this.getNode(nodeids[0]);
},

/** Setzt einen Knoten auf "selected"/"unselected"
 * @param {String} nodeid Id des Knotens.
 * @param {bool} selected Gibt an ob der Knoten jetzt selektiert oder nicht
 * selektiert sein soll
 */
selectNode:
function(nodeid, selected) {
	requireArgs(arguments, 2);
	if (nodeid === null) {
		logic_error("cannot select null node");
	}

	this.getNode(nodeid).setSelected(selected);

	// Hmmm:
	//this.renderContent({renderMode: "select"});
},

queryAppendSelectedObjects:
function(qu) {
	requireArgs(arguments, 1);

	// add selected objects in nodes
	var key;
	for (key in this.nodeReprs) {
		this.nodeReprs[key].queryAppendSelectedObjects(qu);
	}
	return qu;
},

clearSelection:
function (options) {
	options = defaultOpts(options, {recursive: false});
	var key;
	for (key in this.nodeReprs) {
		this.nodeReprs[key].clearSelection(options);
	}
},

/**
 * Taste im Selectfeld ist gedrÃ¼ckt worden
 * scheint mit dem Suchen Probleme zu machen
 */
/*Listing.prototype.onKeyUp = function(event, node) {
	// TODO Funktionen fÃ¼r up, down, ESC hinterlegen
	cancelEvent(event);
}*/


// --- Listing: blÃ¤ttern ----------------------------------------------

/** BlÃ¤ttern im angezeigten Listing
 * Falls auf eine Seite geblÃ¤ttert werden soll die noch nicht geladen ist
 * wird diese vom Server nachgeladen, ansonsten wird direkt die entsprechende
 * page gerendert.
 */
browse:
function(displaypage/*, sNode*/) {
	requireArgs(arguments, 1, 2);

	var displayoffset = this.dataProperties.fromDisplayPage(displaypage);

	this.requestDisplay(new ListingDisplayState(
			this.loadmanager.loaded.display.searchterm,
			displayoffset,
			this.dataProperties,
			this.getRestrictionsSpec(),
			this.getProgressItems()
			//new SpinnerLoadScreen(this.htmlContents())
		));
},


// Listing: edit

edit:
function(hNode) {
	requireArgs(arguments, 1);
	XmlRepr.prototype.edit.call(this);
},

/*
 * Zeigt eins der Panels an (options, filter)
 */
toggle:
function(node, name) {
	if (actOptions && actOptions != this) {
		actOptions.hideOthers(null);
	}
	
	// Animation wird neu erstellt
	if (!this.panels[name]) {
		var xPath = new XPath();
		xPath.evaluate("../div[@class='panel']", document, node);
		var panel = xPath.iterateNext();
		
		node = node.parentNode;
		
		panel.style.left = (node.offsetLeft) + "px";
		panel.style.top = (node.offsetTop + 24) + "px";
		
		var anim = new Animator().addSubject(new CSSStyleSubject(
			panel,
			"height: 0px; display: none;",
			"height: 266px; display: block;"));
		this.panels[name] = new Panel(node, anim);
	}
	// andere Panels ausblenden
	this.hideOthers(this.panels[name]);
	
	// Panel ein/ausblenden
	if (!this.panels[name].display) {
		this.panels[name].show();
	}
	else {
		this.panels[name].hide();
	}
	actOptions = this;
}.deprecated('toggle'),

/**
 * Goto-Panel ein-/ausblenden
 * die anderen Panels werden NICHT ausgeblendet
 */
toggleGotoPage:
function(node) {
	var xPath = new XPath();
	xPath.evaluate("ancestor::div[@class='paging']/div[@class='panel']", document, node);
	var panel = xPath.iterateNext();
	
	if (!is_ie){
		panel.style.left = (node.offsetLeft - 102) + "px";
	}
	else {
		panel.style.right = "0px";
	}
	panel.style.top = (node.offsetTop + 20) + "px";
	
	var anim = new Animator().addSubject(new CSSStyleSubject(
		panel,
		"height: 0px; display: none;",
		"height: 80px; display: block;"));
	
	if (panel.style.display != "block") {
		anim.play();
		node.parentNode.style.backgroundColor = "#6181FF";
	}
	else {
		anim.reverse();
		node.parentNode.style.backgroundColor = "transparent";
	}
}.deprecated('toggleGotoPage'),

/**
 * Die anderen Panels fÃ¼r das Control werden versteckt
 */
hideOthers:
function(panel) {
	for (var name in this.panels) {
		if (panel != this.panels[name] && this.panels[name].display) {
			this.panels[name].hide();
		}
	}
}.deprecated('hideOthers'),

applyFilters:
function(page, pagingNode) {
}.deprecated('applyFilters'),

/**
 * Die Optionen werden gesetzt
 * SeitengrÃ¶Ãe und Sortierkriterium
 */
setOptions: function(node) {
	var xPath = new XPath();
	xPath.evaluate("../div[@class='content']/select", document, node);
	while ((obj = xPath.iterateNext())) {
		if (obj.id.search(/orderbylisting/) != -1) {
			this.orderBy = obj.value;
		}
	}
}.deprecated('setOptions'),

/**
 * Sortierreihenfolge wird gesetzt
 */
setSortField: function(field) {
	if (this.orderBy == field + " desc") {
		this.orderBy = field + " asc";
	}
	else {
		this.orderBy = field + " desc";
	}
}.deprecated('setSortField'),

resetRestrictions:
function() {
	this.restrictions = {
		date: null,
		filters: null
	};
},

getRestrictionsSpec:
function() {
	var ser = "";
	if (this.restrictions.date)
		ser += '&date=' + this.restrictions.date;
	if (this.restrictions.filters)
		ser += '&filters=' + this.restrictions.filters;
	return ser;
},

setDate:
function(date) {
	requireArgs(arguments, 1);
	this.restrictions.date = date;
	this.browse(1);
},

resetDate:
function() {
	this.restrictions.date = null;
},

/** Applies filters as they are set in the UI, displaying the filtered data */
setFilters:
function(node) {
	requireArgs(arguments, 1);
	this.restrictions.filters = $(node).find("input[type='checkbox'], input[type='radio']").serialize();
	this.browse(1);
},

/** Clears filters (UI only, doesn't re-display data) */
resetFilters:
function(node) {
	$(node).find("input[type='checkbox']").attr('checked', true);
},


/** Builds a query string */
query:
function(options) {
	var qu = XmlRepr.prototype.query.call(this);
	return qu;
},

/** Builds a query string referencing the managed object */
objectQuery:
function(options) {
	requireArgs(arguments, 0, 1);
	// TODO: use loadmanager.loaded.data instead of options?

	// Don't access this.loadmanager.loaded.data if not necessary, it might be null
	options = defaulting(options, {});
	if (!isdefined(options.serverpage)) {
		options.serverpage = this.loadmanager.loaded.data.serverpage;
	}
	if (!isdefined(options.searchterm)) {
		options.searchterm = this.loadmanager.loaded.data.searchterm;
	}

	var qu = XmlRepr.prototype.objectQuery.apply(this, arguments);
	if (options.serverpage !== undefined) {
		qu.appending('select'+this.spId+"[options][serverpage]", options.serverpage);
	}
	if (options.searchterm) {
		qu.appending('select'+this.spId+"[options][search]", options.searchterm);
	}
	if (this.restrictions.filters) {
		qu.appendingRaw(this.restrictions.filters);
	}
	if (this.restrictions.date) {
		qu.appending('select'+this.spId+'[options][date]', this.restrictions.date);
	}
	return qu;
},

filterstring:
function() {
	var str = "";
	for (var typ in this.filters) {
		if (typeof this.filters[typ] == "object") {
			for (var i = 0; i < this.filters[typ].length; i++) {
				str += "&select["+this.listingNode.tagName+"][0]["+typ+"listing][0]["+typ+"]["+this.filters[typ][i]+"]="+this.filters[typ][i];
			}
		}
	}
	return str;
}.deprecated('filterstring'),

/** Tests if the "parent" parameter of a rexeived Xml matches the managed Object
 * This is used to restrict certain node updates/... to specific listings
 */
isXNodeParent:
function(node) {
	var pid =  node.getAttribute('parent');
	if (pid === null) {
		//if (debug_xml_parent)
		log_warning("no parent set in xml for " + Dom.path(node), [node]);
		return true;
	}
	var result = (pid == this.spId);
	if (debug_xml_parent) {
		if (result)
			log.debug("parent matched: " + this.spId);
		else
			log.debug("parent not matched since " + pid + " !== " + this.spId);
	}
	// TODO: check returned structure
	// TODO: check oldid == newid
	return result;
},

/** Closes viewports rendering the given node */
closeNodeViewports_:
function (node) {
	if (node === null)
		return;

	var name;
	for (name in node.displays) {
		if (node.displays[name] && this.manager.viewports[name]) {
			if (this.manager.viewports[name].content == node)
				if (this.manager.viewports[name].progress) {
					this.manager.viewports[name].progress.hide();
					this.manager.viewports[name].progress = null;
				}
				if (this.manager.viewports[name].showhide.autoclose)
					this.manager.viewports[name].close();
		}
	}
},

/** Ajax callback: Neuer Node wurde eingefügt
 * Xml wird angepasst; Displays werden neu gerendert
 */
cb_nodeInserted:
function(xml, node, req) {
	// Filter by parent
	if (!this.isXNodeParent(node))
		return;

	// Only insert if id not already present
	var newid = node.getAttribute('id');
	if (newid) {
		var existing = Dom.getXPath(this.getXmlObjectsNode(), "./*[@id='" + newid + "']", {required: false});
		if (existing) {
			log.debug('Not inserting duplicate id node');
			return;
		}
	}

	// modify xml
	this.getXmlObjectsNode().appendChild(xmltools.importNode(this.manager.xmlDocument, node, true));

	// TODO: Generally we can't assume that *we* were the one editing the node */
	// update display
	//this.manager.disconnectWorkspace();	
	this.renderContent();

	// Probably the inserted node was open in some workspace to edit.
	// If it was, we probably want to close that workspace, now that
	// the new node was saved.
	//
	// We close any workspaces that render our newNode.
	//
	// Some listings don't have a newnode in xml, so ignore it if we an't access it.
	// We assume there isn't a newnode rendererd anywhere in this case.
	var newnode;
	try {
		newnode = this.getNewNode();
	}
	catch (e) {
		newnode = null;
	}

	if (newnode !== null) {
		this.closeNodeViewports_(newnode);
	}
},

/** Ajax callback: Node wurde aktualisiert
 * Xml wird anpasst; Display werden neu gerendert
 */
cb_nodeUpdated:
function(xml, node, req) {
	// Filter by parent
	if (!this.isXNodeParent(node))
		return;

	// update xml
	var nodeid = node.getAttribute('id');
	if (nodeid === null) {
		throw new Error("No node id found in xml for updated node");
	}
	this.getNode(nodeid).replaceXml(node);
	//xmltools.replaceNode(this.getXmlObjectNode(nodeid), node);

	// Probably the inserted node was open in some workspace to edit.
	// If it was, we probably want to close that workspace, now that
	// the new node was saved.
	//
	// We close any workspace that renders the given child node
	var editnode = this.getNode(nodeid);
	this.closeNodeViewports_(editnode);

	//this.manager.disconnectWorkspace();	
	this.renderContent();
	// TODO: Check if still necessary
	// Hacky progress for 'save()':
	//this.manager.hideWorkspace();
},

/** Ajax callback (extern): Zu einem Knoten gehÃ¶rende Datei wurde gespeichert.
 *
 * Dieser callback wird von einem externen (jQuery) Ajaxrequest aufgerufen, nicht
 * Ã¼ber unseren AjaxManager.
 *
 * Damit das Ergebnis-Xml trotzdem normal verarbeitet wird, wird das Xml in die
 * normale Ergebnisbehandlung des Ajaxmanagers eingespeist.
 * @param {Object} data JQuery Ajax Ergebnisobjekt
 */
cb_nodeFileSaved:
function(data) {
	// Build something that looks like one of our response objects
	// and pass it to the ajaxmanager data handler for further processing
	// of the response.
	var req = {
		disclaimer: 'fake request object created by file upload, used to trigger default handlers',
		xmlHttp: {
			responseXML: data.result,
			responseText: "fake request object created by file upload"
		}
	};
	this.manager.ajax.onDataReady(req);
},

/** Ajax callback: Formular war unvostÃ¤ndig ausgefÃ¼llt.
 * Fehler werden im Html markiert.
 */
cb_nodeIncomplete:
function(xml, node, req) {
	// Filter by parent
	if (!this.isXNodeParent(node))
		return;

	//this.getNode(nodeid).replaceXml(node);
	//xmltools.replaceNode(this.getXmlObjectNode(nodeid), node);

	if (isdefined(window.noty)) {
		noty({
				text: "Bitte fÃ¼llen Sie die benÃ¶tigten Felder korrekt aus",
				type: "error",
				layout: "center",
				modal: true
			});
	}

	/*
	// TODO: Check if still necessary
	if (this.manager.viewports.workspace.progress) {
		this.manager.viewports.workspace.progress.hide();
		this.manager.viewports.workspace.progress = null;
		//this.manager.viewports.workspace.repr.renderViewport('workspace', view);
	}
	*/

	// update display
	//this.renderContent();
	//this.manager.hnodeWorkspace.fadeOut();
	this.manager.viewports.workspace.hcnode.find('div.required:not(:has(input[value!=""])):has(input[type="text"]) label').css('color', 'red');
	this.manager.viewports.workspace.hcnode.find('div.required:not(:has(select[value!=""])):has(select) label').css('color', 'red');
	this.manager.viewports.workspace.hcnode.find('div.required:not(:has(radio[value!=""])):has(radio) label').css('color', 'red');

	// Advanced select:
	this.manager.viewports.workspace.hcnode.find('div.required:not(:has(input[value!=""])):has(div[class="dropdownlist"]) label').css('color', 'red');
},

/** Ajax callback: Node gelÃ¶scht
 * Xml wird angepasst, Displays werden neu gerendert
 */
cb_nodeDeleted:
function(xml, node, req) {
	// Filter by parent
	if (!this.isXNodeParent(node))
		return;

	// update xml
	var nodeid = node.getAttribute('id');
	if (nodeid === null) {
		throw new Error("No node id found in xml for deleted node");
	}

	this.localEraseNode(nodeid);
},

/** Renders the paging for the specified display
 * @param {Display} display
 * @param {Object=} options
 */
_renderPaging:
function(display, options) {
	this.manager.viewports[display.name].renderPaging(this, display, options);
},

/** Renders the paging for the specified display
 * @param {String} displayname Name of the display
 * @param {Object=} options Render options
 * */
renderDisplayPaging:
function(displayname, options) {
	requireArgs(arguments, 1, 2);
	this._renderPaging(this.displays[displayname], options);
},

/** Renders the paging for all active displays
 * @param {Object=} options Render options
 */
renderPaging:
function(options) {
	requireArgs(arguments, 0, 1);
	var viewportname;
	for (viewportname in this.displays) {
		if (this.displays[viewportname]) {
			this._renderPaging(this.displays[viewportname], options);
		}
	}
},

/* 
 * Neuanzeigen des Panels, in der Standarddarstellung
 */
displayPanel:
function() {
	// TODO: sort out panel/content/... nodes/contents
	this.displayHtml({hnode: this.hnodePanel});
	//this.manager.xslt.setParameter("mode", "tree");
	//var result = this.xmanager.slt.transformToDocument(this.listingNode);
	//this.xmanager.slt.setParameter("mode", "");
	//
	//this.panel.innerHTML = "";
	//appendXSLTResult(this.panel, result);
}.deprecated('displayPanel'),

knownNodes:
function() {
	var nodes = [];
	var key;
	for (key in this.nodeReprs) {
		if (Str.startsWith(key, 'node_')) {
			nodes.push(this.nodeReprs[key]);
		}
	}
	return nodes;
},

getNodes:
function(nodeids) {
	requireArgs(arguments, 1);
	var nodes = [];
	var i, l;
	for (i = 0, l = nodeids.length; i < l; ++i) {
		nodes.push(this.getNode(nodeids[i]));
	}
	return nodes;
},

serverPageNodeIds:
function() {
	var ids = [];
	var xnodes = this.getXmlObjectNodes();
	var i;
	for (i = 0; i < xnodes.length; ++i) {
		ids.push(xnodes[i].getAttribute('id'));
	}

	return ids;
},

getServerPageNodes:
function() {
	return this.getNodes(this.serverPageNodeIds());
},

displayPageNodeIds:
function() {
	var ofs = this.loadmanager.loaded.display.displayoffset;
	var cpage = this.dataProperties.clientPage(ofs);

	var begin = (cpage-1) * this.dataProperties.clientlimit;
	var end = cpage * this.dataProperties.clientlimit;

	var xnodes = this.getXmlObjectNodes();
	end = Math.min(end, xnodes.length);

	var ids = [];
	var i;
	for (i = begin; i < end; ++i) {
		ids.push(xnodes[i].getAttribute('id'));
	}
	return ids;
},

getDisplayPageNodes:
function() {
	return this.getNodes(this.displayPageNodeIds());
},

getSelectedNodeIds:
function() {
	var xnodes = this.getXmlObjectNodes();

	var ids = [];
	var i;
	for (i = 0; i < xnodes.length; ++i) {
		if (xnodes[i].getAttribute('selected') == 'selected')
			ids.push(xnodes[i].getAttribute('id'));
	}

	this.knownNodes().forEach(function (node) {
		if ((node.xmlNode === null) && (node.selected)) {
			ids.push(node.xId);
		}
	});

	return ids;
},

// TODO: functioniert nicht mit persist nodes
getSelectedNodes:
function() {
	return this.getNodes(this.getSelectedNodeIds());
},

getXmlObjectsNode:
function() {
	return xmltools.getSubNode(this.xmlNode, './objects');
},

/* Funktionen zum Plotten */
getPlotPoints:
function() {
	return this.getServerPageNodes().map(function (node) {
		return node.getPlotPoint();
	});
},

getCategories:
function() {
	var i;
	var points = [];
	
	var xnodes = this.getXmlObjectNodes();
	for (i = 0; i < xnodes.length; ++i) {
		points.push(this.getNode(xnodes[i].getAttribute('id')).get("name"));
	}
	/*
	var nodeids = this.displayPageNodeIds();
	for (i = 0; i < nodeids.length; ++i) {
		points.push(this.getNode(nodeids[i]).get("name"));
	}*/
	return points;
}

});

/*
var MetaListingRepr = Dz.MetaListingRepr = Class(ListingRepr, {
	__init__:
	withParams(2, {
				autoCollapse: false,
				lazyInit: false
			},
	function(parent, xmlNode, options) {
		ListingRepr.prototype.__init__.apply(this, arguments);
	})
});

Dz.globalRepresentations.setReprClass('metalisting', MetaListingRepr);
*/

})(window);


(function (Dz) {
	"use strict";
window.dzManagers = [];
var debug_repr_autodetection = true;

Dz.XmlManager = Class(Object, {
__init__:
function(scriptName, renderMode, spidRoot) {
	requireArgs(arguments, 1, 3);
	// Hook für firebug ext
	dzManagers.push(this);
	this._disposed = false;

	var names = null;
	if (typeof scriptName === "string") {
		names = {
			scriptName: scriptName,
			xslName: path + 'Xsl/AJAX/' + scriptName + '.php'
		};
	}
	else {
		names = scriptName;
	}

	renderMode = defaulting(renderMode, null);
	if (renderMode !== null) {
		log.warning("renderMode constructor parameter no longer supported. Instead set the mode when calling init()");
	}

	spidRoot = defaulting(spidRoot, "");

	// names
	this.spId = spidRoot;
	this.scriptName = names.scriptName;
	this.scriptUrl = server + path + names.scriptName + '.php';
	this.formName = names.scriptName;

	// tools
	this.initCompleteA_ = new Async();
	this.initCompleteF = this.initCompleteA_.future;
	this.xPath = new XPath();
	this.xslt = new Xslt();
	this.ajax = new Ajax();
	this.xslt = null;
	this.setupXslt();

	// data
	this.xmlDocument = null;
	this.viewports = {};
	this.renderMode = renderMode;
	//this.displays.main = new DisplayLocation(null, renderMode);

	this.manager = this;

	// Listing names registered locally to this manager and its listings
	this.representations = new RepresentationRegistry(globalRepresentations);

	// events
	this.readyDisplay = this.preselectViewNode(null); //TODO: unsinning?

	// content
	this.listings = null;
	this.repr = null;
},

/** Sets the managers Html nodes and starts loading its Xml
 * @param {String|DOMNode} options.list: node or selector that should be used to insert listing container
 * @param {String|DOMNode} options.workspace: node or selector that should be used to insert workspace
 * container, if any.
 */
init:
function(options) {
	requireArgs(arguments, 0, 1);

	this.initViewports(options);
	this.initProgress();

	// load xmlDocument
	if (this.xmlDocument !== null)
		throw new Error("XML already loaded");

	this.ajax.nDataReady.addOnXPath(
			"/info[@action='init']/.",
			Obj.bindname(this, "cb_xmlLoaded"));

	// errors
	this.ajax.nAjaxError.add(Obj.bindname(this, "cb_error"));

	// Load xml
	this.ajax.startPostRequest(this.xmlQuery_());
},

cb_error:
function(err) {
	noty({
		text: "Leider ist ein Fehler aufgetreten. Bitte versuchen Sie es später erneut.",
		type: "error",
		layout: "center",
		modal: true
	});
	if (this.initCompleteA_) {
		this.progress.hide();
		this.initCompleteA_.resolve('success');
		this.initCompleteA_ = null;
	}
},

initProgress:
function () {
	var progs = [];
	var name;
	for (name in this.viewports) {
		if (this.viewports[name]) {
			var viewport = this.viewports[name];
			if (viewport.initialRender && viewport.progress) {
				progs.push(viewport.progress);
			}
		}
	}

	this.progress = new ProgressGroup(progs);
	this.progress.show();
},

xmlQuery_:
function () {
	return this.query().appending("object", "select"+this.spId+"").appending("action", "init");
},

close:
function() {
	requireArgs(arguments, 0);
	// remove Viewports
	for (var name in this.viewports) {
		// remove viewports
		if (this.viewports[name].inUse())
			this.viewports[name].close();
	}
},

dispose:
function() {
	// close any active viewports
	this.close();

	var name;

	// delete repr
	if (this.repr) {
		delete this.listings[this.repr.crId];
		this.repr.dispose();
	}

	for (name in this.viewports) {
		if (this.viewports[name]) {
			this.viewports[name].dispose();
		}
	}

	this.representations.dispose();
	this.readyDisplay = null;

	//this.ajax.dispose();
	this.xPath = null;
	this.xslt = null;
	this.ajax = null;
	this.xmlDocument = null;

	// self.ref
	this.manager = null;

	this._disposed = true;
},

isDisposed:
function() {
	return this._disposed;
},

persistInc:
function() {
},
persistDec:
function() {
},

initViewports:
function(options) {
	requireArgs(arguments, 0, 1);

	options = defaultOpts(options, {
			main: null,
			workspace: null
		});

	// set html nodes
	if (options.main !== null) {
		Obj.extend(options.main, {initialRender: true});
		this.setViewport(new XsltViewport('main', options.main));
	}
	if (options.workspace !== null) {
		this.setViewport(new FadeViewport('workspace', options.workspace));
	}
},

reInit:
function(options) {
	requireArgs(arguments, 0, 1);
	this.initViewports(options);
	this.showInitialData();
},

/** Adds a new viewport definition */
addViewport:
function(viewport) {
	requireArgs(arguments, 1);
	if (this.viewports[viewport.name]) {
		throw new Error("viewport " + viewport.name + " already exists");
	}
	this.viewports[viewport.name] = viewport;
},

/** Removes an exising viewport definition */
removeViewport:
function(name) {
	requireArgs(arguments, 1);
	if (!this.viewports[name]) {
		throw new Error("unknown viewport " + name);
	}
	if (this.viewports[name].inUse()) {
		this.viewports[name].removeRepr();
		//throw new Error("viewport " + name + " is in use");
	}
	delete this.viewports[name];
},

/** Adds a viewport, overwriting any existing definitions */
setViewport:
function(viewport) {
	requireArgs(arguments, 1);
	if (this.viewports[viewport.name]) {
		this.removeViewport(viewport.name);
	}
	this.addViewport(viewport);
},

closeReprViewports:
function(repr) {
	requireArgs(arguments, 1);
	var name;
	for (name in this.viewports) {
		if (this.viewports[name]) {
			var viewport = this.viewports[name];
			if (this.viewports[name].content === repr)
				viewport.close();
		}
	}
},

showInitialData:
function() {
	// render main display(s)
	var viewport;
	for (viewport in this.viewports) {
		if (this.viewports[viewport].initialRender) {
			this.repr.renderViewport(viewport);
		}
	}

	// execute display actions
	if (this.readyDisplay) {
		this.readyDisplay();
	}
},

// Ajax callback
cb_xmlLoaded:
function(xml, node, req) {
	requireArgs(arguments, 1, 3);

	if (this.xmlDocument)
		throw new Error("Xml already present");
	if (xml === null)
		throw new Error("Xml is null");
	this.xmlDocument = xml;

	var xnodeObj = this.xmlDocument.documentElement.firstChild;
	if (xnodeObj === null)
		throw new Error("No child nodes found in managed Xml");
	if (xnodeObj.nextSibling !== null) {
		log.warning("Additional Xml content following " + Dom.path(xnodeObj) + ": " +
				"<" + xnodeObj.nextSibling.tagName + "> (ignored)");
	}

	// Build representation
	this.repr = this.representations.getInstance(xnodeObj.tagName, this, xnodeObj);

	// legacy names
	this.listings = {};
	this.listings[this.repr.crId] = this.repr;

	this.checkInitComplete_();
},

loadXslt:
function () {
	this.xslt = null;

	var that = this;
	var xslt = new Xslt();
	var ajaxsettings = {
		type: 'GET',
		data: {
			lang: lang,
			lp: lp
		}
	};
	return xslt.initAsync(server + path + "Xsl/AJAX/" + this.scriptName + '.php', ajaxsettings).react({
		success: function () {
			that.xslt = xslt;
		}
	});
},

setupXslt: function () {
	var that = this;
	this.loadXslt().react({
		success: function () {
			that.checkInitComplete_();
		},
		error: function (msg) {
			log.error("loading xslt failed: " + msg);
		}
	});
},

cb_xslLoaded: // Unused: ???
function (xtxt, state, xhr) {
	// not used by initXslAsync
	if (this.xslt)
		throw new Error("Xml already present");
	this.xslt = new Xslt();
	if ('initXml' in this.xslt) {
		this.xslt.initXml(xhr.responseXML);
	}
	else {
		this.xslt.initTxt(xtxt);
	}

	this.checkInitComplete_();
},

handleInitComplete:
function () {
	this.showInitialData();
	this.progress.hide();
	this.initCompleteA_.resolve('success');
	this.initCompleteA_ = null;
},

checkInitComplete_:
function () {
	if (this.xmlDocument && this.xslt) {
		//alert("handleinit");
		this.handleInitComplete();
		//alert("done");
	}
},

query:
function() {
	requireArgs(arguments, 0);
	// TODO: Move lp/lang to Dz.Conf.AjaxParams = { lp: ..., lang: ...}
	return makeQueryUrl(this.scriptUrl).appending("ajax", "info").appending("postback", this.formName.toLowerCase())
		.appending("lp", lp).appending("lang", lang);
},

requireSingleNode:
function(node, name) {
	return node.single(name + " for " + this.scriptName + "/" + this.spId);
},

//XmlManager.prototype.adjustNewListing = function(listing) {
//	return listing;
//}

makeListing:
function(xnode) {
	return this.representations.getInstance(xnode.tagName, this, xnode);
	//return this.adjustNewListing(new Listing(this, xnode));
},


// ===== Aktionen auf den Daten =====

/*
 * Liste der Objekte die verwaltet werden können ist geladen worden
 * Die Liste wird im Panel dargestellt
 */
preselectViewNode:
function(listingid, nodeid) {
	//requireArgs(arguments, 2);
	var mng = this;
	this.readyDisplay = function() {
		return mng.listings[listingid].getNode(nodeid).view();
	};
},

preselectEditNode:
function(listingid, nodeid) {
	//requireArgs(arguments, 2);
	var mng = this;
	this.readyDisplay = function() {
		return mng.listings[listingid].getNode(nodeid).edit();
	};
},


	/** Find the viewport surrounding thwe given node
	 *
	 * Returns null if there isn't any viewport.
	 *
	 * @param {DOMNode} hnode: Node for which the viewport should be determined
	 * @returns {Viewport?}
	 */
	findViewport: function (hnode) {
		requireArgs(arguments, 1);

		// make sure hnode is a raw html node
		hnode = $(hnode)[0];

		var name;
		for (name in this.viewports) {
			if ($.contains(this.viewports[name].hnode, hnode)) {
				return this.viewports[name];
			}
		}
		return null;
	},

	/** Save the item shown in the viewport surrounding the given node.
	 * Should be usable as |manage.saveViewport(this);| in event handlers.
	 *
	 * Throws an exception if there isn't any viewport.
	 *
	 * @param {DOMNode} hnode: Node for which the surrounding viewports contents
	 *    should be saved.
	 */
	saveViewport: function (hnode) {
		requireArgs(arguments, 1);
		var viewport = this.findViewport(hnode);
		if (viewport === null)
			logic_error("cannot find viewport");
		if (viewport.content === null)
			logic_error("nothing rendered in viewport, cannot save");
		viewport.content.save(viewport.name);
	},

	refreshXsltViewports: function () {
		var name;
		for (name in this.viewports) {
			var viewport = this.viewports[name];
			if ((viewport instanceof XsltViewport) && viewport.inUse()) {
				viewport.reRender();
			}
		}
	},

	findRepr: function (hnode) {
		// TODO: Obsolet durch $.dz('repr') oder so?
		requireArgs(arguments, 1);

		// find associated viewport
		var viewport = this.findViewport(hnode);
		if (viewport === null)
			return null;

		// find nodes with data-dz-role in tree
		var roles = [];
		var vnode = viewport.hcnode[0];
		var pnode = $(hnode)[0];
		while (pnode != vnode) {
			var role = $(pnode).attr('data-dz-role');
			if (role !== undefined) {
				roles.push({ role: role, name: $(pnode).attr('data-dz-name') });
			}
			pnode = pnode.parentNode;
		}
		roles.reverse();

		if (debug_repr_autodetection) {
			log.debug(
					"repr autodetect path",
					roles.map(function (it) {
						var label = it.role;
						if (it.name)
							label += "." + it.name;
						return label;
					}).join('>')
				);
		}

		// Get reprs corresponding to container tree 
		var repr = viewport.content;
		var i, l, rinfo, rkind = 'direct';
		for (i = 0, l = roles.length; i < l; ++i) {
			rinfo = roles[i];
			if (rinfo.role == 'container') {
				if (rkind === 'direct') {
					repr = repr.listings[rinfo.name];
				}
				else if (rkind == 'options') {
					repr = repr.optReprs[rinfo.name];
				}
				else if (rkind == 'content') {
					// getNode takes simple id, not full crId
					repr = repr.getNode(rinfo.name.rsplit('_')[1]);
				}
				else {
					throw new Error("unexpected case");
				}
				rkind = 'direct';
			}
			else {
				// Check for roles that signify object kind
				if (Arr.contains(['head', 'tail'], rinfo.role)) {
					rkind = 'options';
				}
				else if (rinfo.role == 'content') {
					rkind = 'content';
				}
			}
		}

		return repr;
	}
});

Dz.XmlManagerListPopup = Class(Dz.XmlManager, {

initViewports:
function(options) {
	requireArgs(arguments, 1);
	options = defaultOpts(options, {
			'list': __required__,
			'workspace': __required__
		});

	Obj.extend(options.list, {initialRender: true});
	//if (!$(options.workspace.node).hasClass('popup')) {
	//	log.warning("The workspace node given to XmlManageListPopup should be the one with the 'popup' class");
	//	options.workspace.node = $(options.workspace.node).closest('.popup');
	//}
	this.setViewport(new XsltViewport('list', options.list));
	this.setViewport(new DialogViewport('workspace', options.workspace));
}

});

Dz.XmlManagerListEditPopup = Class(Dz.XmlManager, {

initViewports:
function(options) {
	requireArgs(arguments, 1);
	options = defaultOpts(options, {
			'list': __required__,
			'workspace': __required__
		});

	Obj.extend(options.list, {initialRender: true});
	//if (!$(options.workspace.node).hasClass('popup')) {
	//	log.warning("The workspace node given to XmlManageListPopup should be the one with the 'popup' class");
	//	options.workspace.node = $(options.workspace.node).closest('.popup');
	//}
	this.setViewport(new XsltViewport('list', options.list));
	this.setViewport(new EditDialogViewport('workspace', options.workspace));
}

});

Dz.XmlManagerListPanel = Class(Dz.XmlManager, {

initViewports:
withParams({list: __required__, workspace: __required__},
function(options) {
	Obj.extend(options.list, {initialRender: true});
	this.setViewport(new XsltViewport('list', options.list));
	this.setViewport(new XsltViewport('workspace', options.workspace));
})

});


Dz.XmlManagerListLightbox = Class(Dz.XmlManager, {

initViewports:
withParams({list: __required__, workspace: __required__},
function(options) {
	Obj.extend(options.list, {initialRender: true});
	this.setViewport(new XsltViewport('list', options.list));
	this.setViewport(new LightboxViewport('workspace', options.workspace));
	this.viewports.workspace.showhide.autoclose = true;
})

});


Dz.ManageListing = deprecateClass(
		"ManageListing",
		"Use new XmlManager classes instead",
		Dz.XmlManager
	);
Dz.ManageCatalog = deprecateClass(
		"ManageCatalog",
		"Use new XmlManager classes instead",
		Dz.XmlManager
	);

})(window);


(function (Dz) {
	"use strict";

Dz.CkEditorRenderer = Class({
__init__: function(options) {
	requireArgs(arguments, 1);
	var opts = splitOpts(options, {
			ckeditor: {}
		});
	this.ckeditor_options = opts.ckeditor;
},

jqFindEditors_: function (hnode) {
	return $(hnode).find("textarea[data-dz-role='ckedit']");
},

enableHtml:
function(hnode) {
	requireArgs(arguments, 1);

	var self = this;
	// Es werden alle Textareas in CKEDITOR Instanzen gewandelt
	this.jqFindEditors_(hnode).each(function() {
		var options = {
			toolbar: []
		};
		$.extend(options, CkEditorRenderer.ckeditor_options, self.ckeditor_options /*, repr.ckeditor_options */);

		options.toolbar.push({ name: 'clipboard', items : [ 'Cut','Copy','Paste','PasteText','PasteFromWord','-','Undo','Redo' ] });
		options.toolbar.push({ name: 'editing', items : [ 'Find','Replace','-','SelectAll','-','-' ] });
	
		if ($(this).hasClass("_paragraph")) {
			options.toolbar.push({ name: 'paragraph', items : [ 'NumberedList','BulletedList','-','Outdent','Indent','-','Blockquote','JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock','BidiLtr','BidiRtl' ] });
		}
		
		if ($(this).hasClass("_basicstyle")) {
			options.toolbar.push({ name: 'basicstyles', items : [ 'Bold','Italic','Underline','Strike','-','RemoveFormat' ] });
		}
		
		// Text kann Links enthalten
		if ($(this).hasClass("_link")) {
			options.toolbar.push({ name: 'links', items : [ 'Link','Unlink','Anchor' ] });
		}
		
		// Text kann Bilder enthalten
		if ($(this).hasClass("_img")) {
			options.toolbar.push({ name: 'insert', items : [ 'Image']});
		}
		
		options.toolbar.push({ name: 'document', items : [ 'Source']});

		var that = this;
		$(this).ckeditor(function(ev) {
				// Autoword cleanup
				$(that).ckeditorGet().on('paste', function(evt) {    
					evt.data.html = '<!--class="Mso"-->'+evt.data.html;
				}, null, null, 9);
			},
			options
		);
		
	});
},

disableHtml:
function(hnode) {
	requireArgs(arguments, 1);
	this.jqFindEditors_(hnode).each(function() {
		$(this).ckeditorGet().destroy();
	});
}

});

// Add to globally enabled extensions
Dz.HtmlViewport.Extensions.push(Dz.CkEditorRenderer);

})(this);

/**
 * A Javascript object to encode and/or decode html characters using HTML or Numeric entities that handles double or partial encoding
 * Author: R Reid
 * source: http://www.strictly-software.com/htmlencode
 * Licences: GPL, The MIT License (MIT)
 * Copyright: (c) 2011 Robert Reid - Strictly-Software.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * Revision:
 *  2011-07-14, Jacques-Yves Bleau: 
 *       - fixed conversion error with capitalized accentuated characters
 *       + converted arr1 and arr2 to object property to remove redundancy
 */

Encoder = {

	// When encoding do we convert characters into html or numerical entities
	EncodeType : "entity",  // entity OR numerical

	isEmpty : function(val){
		if(val){
			return ((val===null) || val.length==0 || /^\s+$/.test(val));
		}else{
			return true;
		}
	},
	arr1: new Array('&nbsp;','&iexcl;','&cent;','&pound;','&curren;','&yen;','&brvbar;','&sect;','&uml;','&copy;','&ordf;','&laquo;','&not;','&shy;','&reg;','&macr;','&deg;','&plusmn;','&sup2;','&sup3;','&acute;','&micro;','&para;','&middot;','&cedil;','&sup1;','&ordm;','&raquo;','&frac14;','&frac12;','&frac34;','&iquest;','&Agrave;','&Aacute;','&Acirc;','&Atilde;','&Auml;','&Aring;','&Aelig;','&Ccedil;','&Egrave;','&Eacute;','&Ecirc;','&Euml;','&Igrave;','&Iacute;','&Icirc;','&Iuml;','&ETH;','&Ntilde;','&Ograve;','&Oacute;','&Ocirc;','&Otilde;','&Ouml;','&times;','&Oslash;','&Ugrave;','&Uacute;','&Ucirc;','&Uuml;','&Yacute;','&THORN;','&szlig;','&agrave;','&aacute;','&acirc;','&atilde;','&auml;','&aring;','&aelig;','&ccedil;','&egrave;','&eacute;','&ecirc;','&euml;','&igrave;','&iacute;','&icirc;','&iuml;','&eth;','&ntilde;','&ograve;','&oacute;','&ocirc;','&otilde;','&ouml;','&divide;','&Oslash;','&ugrave;','&uacute;','&ucirc;','&uuml;','&yacute;','&thorn;','&yuml;','&quot;','&amp;','&lt;','&gt;','&oelig;','&oelig;','&scaron;','&scaron;','&yuml;','&circ;','&tilde;','&ensp;','&emsp;','&thinsp;','&zwnj;','&zwj;','&lrm;','&rlm;','&ndash;','&mdash;','&lsquo;','&rsquo;','&sbquo;','&ldquo;','&rdquo;','&bdquo;','&dagger;','&dagger;','&permil;','&lsaquo;','&rsaquo;','&euro;','&fnof;','&alpha;','&beta;','&gamma;','&delta;','&epsilon;','&zeta;','&eta;','&theta;','&iota;','&kappa;','&lambda;','&mu;','&nu;','&xi;','&omicron;','&pi;','&rho;','&sigma;','&tau;','&upsilon;','&phi;','&chi;','&psi;','&omega;','&alpha;','&beta;','&gamma;','&delta;','&epsilon;','&zeta;','&eta;','&theta;','&iota;','&kappa;','&lambda;','&mu;','&nu;','&xi;','&omicron;','&pi;','&rho;','&sigmaf;','&sigma;','&tau;','&upsilon;','&phi;','&chi;','&psi;','&omega;','&thetasym;','&upsih;','&piv;','&bull;','&hellip;','&prime;','&prime;','&oline;','&frasl;','&weierp;','&image;','&real;','&trade;','&alefsym;','&larr;','&uarr;','&rarr;','&darr;','&harr;','&crarr;','&larr;','&uarr;','&rarr;','&darr;','&harr;','&forall;','&part;','&exist;','&empty;','&nabla;','&isin;','&notin;','&ni;','&prod;','&sum;','&minus;','&lowast;','&radic;','&prop;','&infin;','&ang;','&and;','&or;','&cap;','&cup;','&int;','&there4;','&sim;','&cong;','&asymp;','&ne;','&equiv;','&le;','&ge;','&sub;','&sup;','&nsub;','&sube;','&supe;','&oplus;','&otimes;','&perp;','&sdot;','&lceil;','&rceil;','&lfloor;','&rfloor;','&lang;','&rang;','&loz;','&spades;','&clubs;','&hearts;','&diams;'),
	arr2: new Array('&#160;','&#161;','&#162;','&#163;','&#164;','&#165;','&#166;','&#167;','&#168;','&#169;','&#170;','&#171;','&#172;','&#173;','&#174;','&#175;','&#176;','&#177;','&#178;','&#179;','&#180;','&#181;','&#182;','&#183;','&#184;','&#185;','&#186;','&#187;','&#188;','&#189;','&#190;','&#191;','&#192;','&#193;','&#194;','&#195;','&#196;','&#197;','&#198;','&#199;','&#200;','&#201;','&#202;','&#203;','&#204;','&#205;','&#206;','&#207;','&#208;','&#209;','&#210;','&#211;','&#212;','&#213;','&#214;','&#215;','&#216;','&#217;','&#218;','&#219;','&#220;','&#221;','&#222;','&#223;','&#224;','&#225;','&#226;','&#227;','&#228;','&#229;','&#230;','&#231;','&#232;','&#233;','&#234;','&#235;','&#236;','&#237;','&#238;','&#239;','&#240;','&#241;','&#242;','&#243;','&#244;','&#245;','&#246;','&#247;','&#248;','&#249;','&#250;','&#251;','&#252;','&#253;','&#254;','&#255;','&#34;','&#38;','&#60;','&#62;','&#338;','&#339;','&#352;','&#353;','&#376;','&#710;','&#732;','&#8194;','&#8195;','&#8201;','&#8204;','&#8205;','&#8206;','&#8207;','&#8211;','&#8212;','&#8216;','&#8217;','&#8218;','&#8220;','&#8221;','&#8222;','&#8224;','&#8225;','&#8240;','&#8249;','&#8250;','&#8364;','&#402;','&#913;','&#914;','&#915;','&#916;','&#917;','&#918;','&#919;','&#920;','&#921;','&#922;','&#923;','&#924;','&#925;','&#926;','&#927;','&#928;','&#929;','&#931;','&#932;','&#933;','&#934;','&#935;','&#936;','&#937;','&#945;','&#946;','&#947;','&#948;','&#949;','&#950;','&#951;','&#952;','&#953;','&#954;','&#955;','&#956;','&#957;','&#958;','&#959;','&#960;','&#961;','&#962;','&#963;','&#964;','&#965;','&#966;','&#967;','&#968;','&#969;','&#977;','&#978;','&#982;','&#8226;','&#8230;','&#8242;','&#8243;','&#8254;','&#8260;','&#8472;','&#8465;','&#8476;','&#8482;','&#8501;','&#8592;','&#8593;','&#8594;','&#8595;','&#8596;','&#8629;','&#8656;','&#8657;','&#8658;','&#8659;','&#8660;','&#8704;','&#8706;','&#8707;','&#8709;','&#8711;','&#8712;','&#8713;','&#8715;','&#8719;','&#8721;','&#8722;','&#8727;','&#8730;','&#8733;','&#8734;','&#8736;','&#8743;','&#8744;','&#8745;','&#8746;','&#8747;','&#8756;','&#8764;','&#8773;','&#8776;','&#8800;','&#8801;','&#8804;','&#8805;','&#8834;','&#8835;','&#8836;','&#8838;','&#8839;','&#8853;','&#8855;','&#8869;','&#8901;','&#8968;','&#8969;','&#8970;','&#8971;','&#9001;','&#9002;','&#9674;','&#9824;','&#9827;','&#9829;','&#9830;'),
		
	// Convert HTML entities into numerical entities
	HTML2Numerical : function(s){
		return this.swapArrayVals(s,this.arr1,this.arr2);
	},	

	// Convert Numerical entities into HTML entities
	NumericalToHTML : function(s){
		return this.swapArrayVals(s,this.arr2,this.arr1);
	},


	// Numerically encodes all unicode characters
	numEncode : function(s){
		
		if(this.isEmpty(s)) return "";

		var e = "";
		for (var i = 0; i < s.length; i++)
		{
			var c = s.charAt(i);
			if (c < " " || c > "~")
			{
				c = "&#" + c.charCodeAt() + ";";
			}
			e += c;
		}
		return e;
	},
	
	// HTML Decode numerical and HTML entities back to original values
	htmlDecode : function(s){

		var c,m,d = s;
		
		if(this.isEmpty(d)) return "";

		// convert HTML entites back to numerical entites first
		d = this.HTML2Numerical(d);
		
		// look for numerical entities &#34;
		arr=d.match(/&#[0-9]{1,5};/g);
		
		// if no matches found in string then skip
		if(arr!=null){
			for(var x=0;x<arr.length;x++){
				m = arr[x];
				c = m.substring(2,m.length-1); //get numeric part which is refernce to unicode character
				// if its a valid number we can decode
				if(c >= -32768 && c <= 65535){
					// decode every single match within string
					d = d.replace(m, String.fromCharCode(c));
				}else{
					d = d.replace(m, ""); //invalid so replace with nada
				}
			}			
		}

		return d;
	},		

	// encode an input string into either numerical or HTML entities
	htmlEncode : function(s,dbl){
			
		if(this.isEmpty(s)) return "";

		// do we allow double encoding? E.g will &amp; be turned into &amp;amp;
		dbl = dbl || false; //default to prevent double encoding
		
		// if allowing double encoding we do ampersands first
		if(dbl){
			if(this.EncodeType=="numerical"){
				s = s.replace(/&/g, "&#38;");
			}else{
				s = s.replace(/&/g, "&amp;");
			}
		}

		// convert the xss chars to numerical entities ' " < >
		s = this.XSSEncode(s,false);
		
		if(this.EncodeType=="numerical" || !dbl){
			// Now call function that will convert any HTML entities to numerical codes
			s = this.HTML2Numerical(s);
		}

		// Now encode all chars above 127 e.g unicode
		s = this.numEncode(s);

		// now we know anything that needs to be encoded has been converted to numerical entities we
		// can encode any ampersands & that are not part of encoded entities
		// to handle the fact that I need to do a negative check and handle multiple ampersands &&&
		// I am going to use a placeholder

		// if we don't want double encoded entities we ignore the & in existing entities
		if(!dbl){
			s = s.replace(/&#/g,"##AMPHASH##");
		
			if(this.EncodeType=="numerical"){
				s = s.replace(/&/g, "&#38;");
			}else{
				s = s.replace(/&/g, "&amp;");
			}

			s = s.replace(/##AMPHASH##/g,"&#");
		}
		
		// replace any malformed entities
		s = s.replace(/&#\d*([^\d;]|$)/g, "$1");

		if(!dbl){
			// safety check to correct any double encoded &amp;
			s = this.correctEncoding(s);
		}

		// now do we need to convert our numerical encoded string into entities
		if(this.EncodeType=="entity"){
			s = this.NumericalToHTML(s);
		}

		return s;					
	},

	// Encodes the basic 4 characters used to malform HTML in XSS hacks
	XSSEncode : function(s,en){
		if(!this.isEmpty(s)){
			en = en || true;
			// do we convert to numerical or html entity?
			if(en){
				s = s.replace(/\'/g,"&#39;"); //no HTML equivalent as &apos is not cross browser supported
				s = s.replace(/\"/g,"&quot;");
				s = s.replace(/</g,"&lt;");
				s = s.replace(/>/g,"&gt;");
			}else{
				s = s.replace(/\'/g,"&#39;"); //no HTML equivalent as &apos is not cross browser supported
				s = s.replace(/\"/g,"&#34;");
				s = s.replace(/</g,"&#60;");
				s = s.replace(/>/g,"&#62;");
			}
			return s;
		}else{
			return "";
		}
	},

	// returns true if a string contains html or numerical encoded entities
	hasEncoded : function(s){
		if(/&#[0-9]{1,5};/g.test(s)){
			return true;
		}else if(/&[A-Z]{2,6};/gi.test(s)){
			return true;
		}else{
			return false;
		}
	},

	// will remove any unicode characters
	stripUnicode : function(s){
		return s.replace(/[^\x20-\x7E]/g,"");
		
	},

	// corrects any double encoded &amp; entities e.g &amp;amp;
	correctEncoding : function(s){
		return s.replace(/(&amp;)(amp;)+/,"$1");
	},


	// Function to loop through an array swaping each item with the value from another array e.g swap HTML entities with Numericals
	swapArrayVals : function(s,arr1,arr2){
		if(this.isEmpty(s)) return "";
		var re;
		if(arr1 && arr2){
			//ShowDebug("in swapArrayVals arr1.length = " + arr1.length + " arr2.length = " + arr2.length)
			// array lengths must match
			if(arr1.length == arr2.length){
				for(var x=0,i=arr1.length;x<i;x++){
					re = new RegExp(arr1[x], 'g');
					s = s.replace(re,arr2[x]); //swap arr1 item with matching item from arr2	
				}
			}
		}
		return s;
	},

	inArray : function( item, arr ) {
		for ( var i = 0, x = arr.length; i < x; i++ ){
			if ( arr[i] === item ){
				return i;
			}
		}
		return -1;
	}

};
/**
 * Dialog
 * 
 * Darstellung ändert sich je nach Größe des Bilschirms
 * - Popup
 * - Fullscreen
 */

$.widget( "dz.inline", {
	_create: function(options) {
		// TODO: Soll das da irgendwas tun?:
		var that = this;
		var settings = $.extend({
				// These are the defaults.
				width: 800,
				height: 600,
				autoOpen: false
			}, options );
	},
	open: function() {
		// TODO: Verursacht unschönes Gescrolle bei back/forward
		$.scrollTo("#topMenu",{duration: 300});

		// TODO: Verschieben der Elemente macht Funktionalität kaputt,
		// da JS das auf die Elemente/... im Dialog zuzugreifen will
		// ins Leere läuft. Die angezeigten Elemente sind dann gar nicht
		// mehr im Dialog, sondern sind hier nach #centerColumn verschoben
		// werden.
		//$("#centerColumn").html(this.element.children());
	},
	close: function() {
		// TODO BACK
		// Vermutlich kann man hier einfach nichts tun. Der Inhalt sollte
		// dann vom neuen Inhalt überschrieben werden.
		$("#centerColumn").html("");
	},
	destroy: function() {
		// TODO
	}
	
});

(function($) {
	"use strict";

 	/** @lends $.fn
	 * 
	 */
	var methods = {
		init : 
		function( options ) {
			var widget;
			var settings = $.extend({
				// These are the defaults.
				width: 800,
				height: 600,
				autoOpen: false
			}, options );
			
			// Switching between different UIs
			if ( $(window).width() < settings.resp.width[0] ) {
				// Darstellung inline
				$(this).data("widget", "inline");
				if (settings.resp && settings.resp.layer) {
					settings = $.extend(settings, settings.resp.layer);
				}
				$(this).addClass("inline");
				$(this).inline(settings);
				return $('#centerColumn');
			}
			else {
				$(this).data("widget", "dialog");
				if (settings.resp && settings.resp.dialog) {
					settings = $.extend(settings, settings.resp.dialog);
				}
				return $(this).dialog(settings);
			}
		}
	}
	
	$.fn.respDialog = function(method) {
		if ($(this).length == 0 ) {
			return;
		}
		// Initialisierung
		if ( typeof method === 'object' || ! method ) {
			return methods.init.apply( this, arguments );
		}
		else {
			// Aufruf wird an das widget weitergeleitet
			var widget = $(this).data("widget");
			switch (widget) {
				case "inline":
					return $(this).inline(method);
				break;
				case "dialog":
					return $(this).dialog(method);
				break;
			}
		}
	};

})(jQuery);

/*!
 * jQuery UI Mouse 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/mouse/
 *
 * Depends:
 *	jquery.ui.widget.js
 */
(function( $, undefined ) {

var mouseHandled = false;
$( document ).mouseup( function() {
	mouseHandled = false;
});

$.widget("ui.mouse", {
	version: "1.10.3",
	options: {
		cancel: "input,textarea,button,select,option",
		distance: 1,
		delay: 0
	},
	_mouseInit: function() {
		var that = this;

		this.element
			.bind("mousedown."+this.widgetName, function(event) {
				return that._mouseDown(event);
			})
			.bind("click."+this.widgetName, function(event) {
				if (true === $.data(event.target, that.widgetName + ".preventClickEvent")) {
					$.removeData(event.target, that.widgetName + ".preventClickEvent");
					event.stopImmediatePropagation();
					return false;
				}
			});

		this.started = false;
	},

	// TODO: make sure destroying one instance of mouse doesn't mess with
	// other instances of mouse
	_mouseDestroy: function() {
		this.element.unbind("."+this.widgetName);
		if ( this._mouseMoveDelegate ) {
			$(document)
				.unbind("mousemove."+this.widgetName, this._mouseMoveDelegate)
				.unbind("mouseup."+this.widgetName, this._mouseUpDelegate);
		}
	},

	_mouseDown: function(event) {
		// don't let more than one widget handle mouseStart
		if( mouseHandled ) { return; }

		// we may have missed mouseup (out of window)
		(this._mouseStarted && this._mouseUp(event));

		this._mouseDownEvent = event;

		var that = this,
			btnIsLeft = (event.which === 1),
			// event.target.nodeName works around a bug in IE 8 with
			// disabled inputs (#7620)
			elIsCancel = (typeof this.options.cancel === "string" && event.target.nodeName ? $(event.target).closest(this.options.cancel).length : false);
		if (!btnIsLeft || elIsCancel || !this._mouseCapture(event)) {
			return true;
		}

		this.mouseDelayMet = !this.options.delay;
		if (!this.mouseDelayMet) {
			this._mouseDelayTimer = setTimeout(function() {
				that.mouseDelayMet = true;
			}, this.options.delay);
		}

		if (this._mouseDistanceMet(event) && this._mouseDelayMet(event)) {
			this._mouseStarted = (this._mouseStart(event) !== false);
			if (!this._mouseStarted) {
				event.preventDefault();
				return true;
			}
		}

		// Click event may never have fired (Gecko & Opera)
		if (true === $.data(event.target, this.widgetName + ".preventClickEvent")) {
			$.removeData(event.target, this.widgetName + ".preventClickEvent");
		}

		// these delegates are required to keep context
		this._mouseMoveDelegate = function(event) {
			return that._mouseMove(event);
		};
		this._mouseUpDelegate = function(event) {
			return that._mouseUp(event);
		};
		$(document)
			.bind("mousemove."+this.widgetName, this._mouseMoveDelegate)
			.bind("mouseup."+this.widgetName, this._mouseUpDelegate);

		event.preventDefault();

		mouseHandled = true;
		return true;
	},

	_mouseMove: function(event) {
		// IE mouseup check - mouseup happened when mouse was out of window
		if ($.ui.ie && ( !document.documentMode || document.documentMode < 9 ) && !event.button) {
			return this._mouseUp(event);
		}

		if (this._mouseStarted) {
			this._mouseDrag(event);
			return event.preventDefault();
		}

		if (this._mouseDistanceMet(event) && this._mouseDelayMet(event)) {
			this._mouseStarted =
				(this._mouseStart(this._mouseDownEvent, event) !== false);
			(this._mouseStarted ? this._mouseDrag(event) : this._mouseUp(event));
		}

		return !this._mouseStarted;
	},

	_mouseUp: function(event) {
		$(document)
			.unbind("mousemove."+this.widgetName, this._mouseMoveDelegate)
			.unbind("mouseup."+this.widgetName, this._mouseUpDelegate);

		if (this._mouseStarted) {
			this._mouseStarted = false;

			if (event.target === this._mouseDownEvent.target) {
				$.data(event.target, this.widgetName + ".preventClickEvent", true);
			}

			this._mouseStop(event);
		}

		return false;
	},

	_mouseDistanceMet: function(event) {
		return (Math.max(
				Math.abs(this._mouseDownEvent.pageX - event.pageX),
				Math.abs(this._mouseDownEvent.pageY - event.pageY)
			) >= this.options.distance
		);
	},

	_mouseDelayMet: function(/* event */) {
		return this.mouseDelayMet;
	},

	// These are placeholder methods, to be overriden by extending plugin
	_mouseStart: function(/* event */) {},
	_mouseDrag: function(/* event */) {},
	_mouseStop: function(/* event */) {},
	_mouseCapture: function(/* event */) { return true; }
});

})(jQuery);
/*!
 * jQuery UI Draggable 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/draggable/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 */
(function( $, undefined ) {

$.widget("ui.draggable", $.ui.mouse, {
	version: "1.10.3",
	widgetEventPrefix: "drag",
	options: {
		addClasses: true,
		appendTo: "parent",
		axis: false,
		connectToSortable: false,
		containment: false,
		cursor: "auto",
		cursorAt: false,
		grid: false,
		handle: false,
		helper: "original",
		iframeFix: false,
		opacity: false,
		refreshPositions: false,
		revert: false,
		revertDuration: 500,
		scope: "default",
		scroll: true,
		scrollSensitivity: 20,
		scrollSpeed: 20,
		snap: false,
		snapMode: "both",
		snapTolerance: 20,
		stack: false,
		zIndex: false,

		// callbacks
		drag: null,
		start: null,
		stop: null
	},
	_create: function() {

		if (this.options.helper === "original" && !(/^(?:r|a|f)/).test(this.element.css("position"))) {
			this.element[0].style.position = "relative";
		}
		if (this.options.addClasses){
			this.element.addClass("ui-draggable");
		}
		if (this.options.disabled){
			this.element.addClass("ui-draggable-disabled");
		}

		this._mouseInit();

	},

	_destroy: function() {
		this.element.removeClass( "ui-draggable ui-draggable-dragging ui-draggable-disabled" );
		this._mouseDestroy();
	},

	_mouseCapture: function(event) {

		var o = this.options;

		// among others, prevent a drag on a resizable-handle
		if (this.helper || o.disabled || $(event.target).closest(".ui-resizable-handle").length > 0) {
			return false;
		}

		//Quit if we're not on a valid handle
		this.handle = this._getHandle(event);
		if (!this.handle) {
			return false;
		}

		$(o.iframeFix === true ? "iframe" : o.iframeFix).each(function() {
			$("<div class='ui-draggable-iframeFix' style='background: #fff;'></div>")
			.css({
				width: this.offsetWidth+"px", height: this.offsetHeight+"px",
				position: "absolute", opacity: "0.001", zIndex: 1000
			})
			.css($(this).offset())
			.appendTo("body");
		});

		return true;

	},

	_mouseStart: function(event) {

		var o = this.options;

		//Create and append the visible helper
		this.helper = this._createHelper(event);

		this.helper.addClass("ui-draggable-dragging");

		//Cache the helper size
		this._cacheHelperProportions();

		//If ddmanager is used for droppables, set the global draggable
		if($.ui.ddmanager) {
			$.ui.ddmanager.current = this;
		}

		/*
		 * - Position generation -
		 * This block generates everything position related - it's the core of draggables.
		 */

		//Cache the margins of the original element
		this._cacheMargins();

		//Store the helper's css position
		this.cssPosition = this.helper.css( "position" );
		this.scrollParent = this.helper.scrollParent();
		this.offsetParent = this.helper.offsetParent();
		this.offsetParentCssPosition = this.offsetParent.css( "position" );

		//The element's absolute position on the page minus margins
		this.offset = this.positionAbs = this.element.offset();
		this.offset = {
			top: this.offset.top - this.margins.top,
			left: this.offset.left - this.margins.left
		};

		//Reset scroll cache
		this.offset.scroll = false;

		$.extend(this.offset, {
			click: { //Where the click happened, relative to the element
				left: event.pageX - this.offset.left,
				top: event.pageY - this.offset.top
			},
			parent: this._getParentOffset(),
			relative: this._getRelativeOffset() //This is a relative to absolute position minus the actual position calculation - only used for relative positioned helper
		});

		//Generate the original position
		this.originalPosition = this.position = this._generatePosition(event);
		this.originalPageX = event.pageX;
		this.originalPageY = event.pageY;

		//Adjust the mouse offset relative to the helper if "cursorAt" is supplied
		(o.cursorAt && this._adjustOffsetFromHelper(o.cursorAt));

		//Set a containment if given in the options
		this._setContainment();

		//Trigger event + callbacks
		if(this._trigger("start", event) === false) {
			this._clear();
			return false;
		}

		//Recache the helper size
		this._cacheHelperProportions();

		//Prepare the droppable offsets
		if ($.ui.ddmanager && !o.dropBehaviour) {
			$.ui.ddmanager.prepareOffsets(this, event);
		}


		this._mouseDrag(event, true); //Execute the drag once - this causes the helper not to be visible before getting its correct position

		//If the ddmanager is used for droppables, inform the manager that dragging has started (see #5003)
		if ( $.ui.ddmanager ) {
			$.ui.ddmanager.dragStart(this, event);
		}

		return true;
	},

	_mouseDrag: function(event, noPropagation) {
		// reset any necessary cached properties (see #5009)
		if ( this.offsetParentCssPosition === "fixed" ) {
			this.offset.parent = this._getParentOffset();
		}

		//Compute the helpers position
		this.position = this._generatePosition(event);
		this.positionAbs = this._convertPositionTo("absolute");

		//Call plugins and callbacks and use the resulting position if something is returned
		if (!noPropagation) {
			var ui = this._uiHash();
			if(this._trigger("drag", event, ui) === false) {
				this._mouseUp({});
				return false;
			}
			this.position = ui.position;
		}

		if(!this.options.axis || this.options.axis !== "y") {
			this.helper[0].style.left = this.position.left+"px";
		}
		if(!this.options.axis || this.options.axis !== "x") {
			this.helper[0].style.top = this.position.top+"px";
		}
		if($.ui.ddmanager) {
			$.ui.ddmanager.drag(this, event);
		}

		return false;
	},

	_mouseStop: function(event) {

		//If we are using droppables, inform the manager about the drop
		var that = this,
			dropped = false;
		if ($.ui.ddmanager && !this.options.dropBehaviour) {
			dropped = $.ui.ddmanager.drop(this, event);
		}

		//if a drop comes from outside (a sortable)
		if(this.dropped) {
			dropped = this.dropped;
			this.dropped = false;
		}

		//if the original element is no longer in the DOM don't bother to continue (see #8269)
		if ( this.options.helper === "original" && !$.contains( this.element[ 0 ].ownerDocument, this.element[ 0 ] ) ) {
			return false;
		}

		if((this.options.revert === "invalid" && !dropped) || (this.options.revert === "valid" && dropped) || this.options.revert === true || ($.isFunction(this.options.revert) && this.options.revert.call(this.element, dropped))) {
			$(this.helper).animate(this.originalPosition, parseInt(this.options.revertDuration, 10), function() {
				if(that._trigger("stop", event) !== false) {
					that._clear();
				}
			});
		} else {
			if(this._trigger("stop", event) !== false) {
				this._clear();
			}
		}

		return false;
	},

	_mouseUp: function(event) {
		//Remove frame helpers
		$("div.ui-draggable-iframeFix").each(function() {
			this.parentNode.removeChild(this);
		});

		//If the ddmanager is used for droppables, inform the manager that dragging has stopped (see #5003)
		if( $.ui.ddmanager ) {
			$.ui.ddmanager.dragStop(this, event);
		}

		return $.ui.mouse.prototype._mouseUp.call(this, event);
	},

	cancel: function() {

		if(this.helper.is(".ui-draggable-dragging")) {
			this._mouseUp({});
		} else {
			this._clear();
		}

		return this;

	},

	_getHandle: function(event) {
		return this.options.handle ?
			!!$( event.target ).closest( this.element.find( this.options.handle ) ).length :
			true;
	},

	_createHelper: function(event) {

		var o = this.options,
			helper = $.isFunction(o.helper) ? $(o.helper.apply(this.element[0], [event])) : (o.helper === "clone" ? this.element.clone().removeAttr("id") : this.element);

		if(!helper.parents("body").length) {
			helper.appendTo((o.appendTo === "parent" ? this.element[0].parentNode : o.appendTo));
		}

		if(helper[0] !== this.element[0] && !(/(fixed|absolute)/).test(helper.css("position"))) {
			helper.css("position", "absolute");
		}

		return helper;

	},

	_adjustOffsetFromHelper: function(obj) {
		if (typeof obj === "string") {
			obj = obj.split(" ");
		}
		if ($.isArray(obj)) {
			obj = {left: +obj[0], top: +obj[1] || 0};
		}
		if ("left" in obj) {
			this.offset.click.left = obj.left + this.margins.left;
		}
		if ("right" in obj) {
			this.offset.click.left = this.helperProportions.width - obj.right + this.margins.left;
		}
		if ("top" in obj) {
			this.offset.click.top = obj.top + this.margins.top;
		}
		if ("bottom" in obj) {
			this.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top;
		}
	},

	_getParentOffset: function() {

		//Get the offsetParent and cache its position
		var po = this.offsetParent.offset();

		// This is a special case where we need to modify a offset calculated on start, since the following happened:
		// 1. The position of the helper is absolute, so it's position is calculated based on the next positioned parent
		// 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't the document, which means that
		//    the scroll is included in the initial calculation of the offset of the parent, and never recalculated upon drag
		if(this.cssPosition === "absolute" && this.scrollParent[0] !== document && $.contains(this.scrollParent[0], this.offsetParent[0])) {
			po.left += this.scrollParent.scrollLeft();
			po.top += this.scrollParent.scrollTop();
		}

		//This needs to be actually done for all browsers, since pageX/pageY includes this information
		//Ugly IE fix
		if((this.offsetParent[0] === document.body) ||
			(this.offsetParent[0].tagName && this.offsetParent[0].tagName.toLowerCase() === "html" && $.ui.ie)) {
			po = { top: 0, left: 0 };
		}

		return {
			top: po.top + (parseInt(this.offsetParent.css("borderTopWidth"),10) || 0),
			left: po.left + (parseInt(this.offsetParent.css("borderLeftWidth"),10) || 0)
		};

	},

	_getRelativeOffset: function() {

		if(this.cssPosition === "relative") {
			var p = this.element.position();
			return {
				top: p.top - (parseInt(this.helper.css("top"),10) || 0) + this.scrollParent.scrollTop(),
				left: p.left - (parseInt(this.helper.css("left"),10) || 0) + this.scrollParent.scrollLeft()
			};
		} else {
			return { top: 0, left: 0 };
		}

	},

	_cacheMargins: function() {
		this.margins = {
			left: (parseInt(this.element.css("marginLeft"),10) || 0),
			top: (parseInt(this.element.css("marginTop"),10) || 0),
			right: (parseInt(this.element.css("marginRight"),10) || 0),
			bottom: (parseInt(this.element.css("marginBottom"),10) || 0)
		};
	},

	_cacheHelperProportions: function() {
		this.helperProportions = {
			width: this.helper.outerWidth(),
			height: this.helper.outerHeight()
		};
	},

	_setContainment: function() {

		var over, c, ce,
			o = this.options;

		if ( !o.containment ) {
			this.containment = null;
			return;
		}

		if ( o.containment === "window" ) {
			this.containment = [
				$( window ).scrollLeft() - this.offset.relative.left - this.offset.parent.left,
				$( window ).scrollTop() - this.offset.relative.top - this.offset.parent.top,
				$( window ).scrollLeft() + $( window ).width() - this.helperProportions.width - this.margins.left,
				$( window ).scrollTop() + ( $( window ).height() || document.body.parentNode.scrollHeight ) - this.helperProportions.height - this.margins.top
			];
			return;
		}

		if ( o.containment === "document") {
			this.containment = [
				0,
				0,
				$( document ).width() - this.helperProportions.width - this.margins.left,
				( $( document ).height() || document.body.parentNode.scrollHeight ) - this.helperProportions.height - this.margins.top
			];
			return;
		}

		if ( o.containment.constructor === Array ) {
			this.containment = o.containment;
			return;
		}

		if ( o.containment === "parent" ) {
			o.containment = this.helper[ 0 ].parentNode;
		}

		c = $( o.containment );
		ce = c[ 0 ];

		if( !ce ) {
			return;
		}

		over = c.css( "overflow" ) !== "hidden";

		this.containment = [
			( parseInt( c.css( "borderLeftWidth" ), 10 ) || 0 ) + ( parseInt( c.css( "paddingLeft" ), 10 ) || 0 ),
			( parseInt( c.css( "borderTopWidth" ), 10 ) || 0 ) + ( parseInt( c.css( "paddingTop" ), 10 ) || 0 ) ,
			( over ? Math.max( ce.scrollWidth, ce.offsetWidth ) : ce.offsetWidth ) - ( parseInt( c.css( "borderRightWidth" ), 10 ) || 0 ) - ( parseInt( c.css( "paddingRight" ), 10 ) || 0 ) - this.helperProportions.width - this.margins.left - this.margins.right,
			( over ? Math.max( ce.scrollHeight, ce.offsetHeight ) : ce.offsetHeight ) - ( parseInt( c.css( "borderBottomWidth" ), 10 ) || 0 ) - ( parseInt( c.css( "paddingBottom" ), 10 ) || 0 ) - this.helperProportions.height - this.margins.top  - this.margins.bottom
		];
		this.relative_container = c;
	},

	_convertPositionTo: function(d, pos) {

		if(!pos) {
			pos = this.position;
		}

		var mod = d === "absolute" ? 1 : -1,
			scroll = this.cssPosition === "absolute" && !( this.scrollParent[ 0 ] !== document && $.contains( this.scrollParent[ 0 ], this.offsetParent[ 0 ] ) ) ? this.offsetParent : this.scrollParent;

		//Cache the scroll
		if (!this.offset.scroll) {
			this.offset.scroll = {top : scroll.scrollTop(), left : scroll.scrollLeft()};
		}

		return {
			top: (
				pos.top	+																// The absolute mouse position
				this.offset.relative.top * mod +										// Only for relative positioned nodes: Relative offset from element to offset parent
				this.offset.parent.top * mod -										// The offsetParent's offset without borders (offset + border)
				( ( this.cssPosition === "fixed" ? -this.scrollParent.scrollTop() : this.offset.scroll.top ) * mod )
			),
			left: (
				pos.left +																// The absolute mouse position
				this.offset.relative.left * mod +										// Only for relative positioned nodes: Relative offset from element to offset parent
				this.offset.parent.left * mod	-										// The offsetParent's offset without borders (offset + border)
				( ( this.cssPosition === "fixed" ? -this.scrollParent.scrollLeft() : this.offset.scroll.left ) * mod )
			)
		};

	},

	_generatePosition: function(event) {

		var containment, co, top, left,
			o = this.options,
			scroll = this.cssPosition === "absolute" && !( this.scrollParent[ 0 ] !== document && $.contains( this.scrollParent[ 0 ], this.offsetParent[ 0 ] ) ) ? this.offsetParent : this.scrollParent,
			pageX = event.pageX,
			pageY = event.pageY;

		//Cache the scroll
		if (!this.offset.scroll) {
			this.offset.scroll = {top : scroll.scrollTop(), left : scroll.scrollLeft()};
		}

		/*
		 * - Position constraining -
		 * Constrain the position to a mix of grid, containment.
		 */

		// If we are not dragging yet, we won't check for options
		if ( this.originalPosition ) {
			if ( this.containment ) {
				if ( this.relative_container ){
					co = this.relative_container.offset();
					containment = [
						this.containment[ 0 ] + co.left,
						this.containment[ 1 ] + co.top,
						this.containment[ 2 ] + co.left,
						this.containment[ 3 ] + co.top
					];
				}
				else {
					containment = this.containment;
				}

				if(event.pageX - this.offset.click.left < containment[0]) {
					pageX = containment[0] + this.offset.click.left;
				}
				if(event.pageY - this.offset.click.top < containment[1]) {
					pageY = containment[1] + this.offset.click.top;
				}
				if(event.pageX - this.offset.click.left > containment[2]) {
					pageX = containment[2] + this.offset.click.left;
				}
				if(event.pageY - this.offset.click.top > containment[3]) {
					pageY = containment[3] + this.offset.click.top;
				}
			}

			if(o.grid) {
				//Check for grid elements set to 0 to prevent divide by 0 error causing invalid argument errors in IE (see ticket #6950)
				top = o.grid[1] ? this.originalPageY + Math.round((pageY - this.originalPageY) / o.grid[1]) * o.grid[1] : this.originalPageY;
				pageY = containment ? ((top - this.offset.click.top >= containment[1] || top - this.offset.click.top > containment[3]) ? top : ((top - this.offset.click.top >= containment[1]) ? top - o.grid[1] : top + o.grid[1])) : top;

				left = o.grid[0] ? this.originalPageX + Math.round((pageX - this.originalPageX) / o.grid[0]) * o.grid[0] : this.originalPageX;
				pageX = containment ? ((left - this.offset.click.left >= containment[0] || left - this.offset.click.left > containment[2]) ? left : ((left - this.offset.click.left >= containment[0]) ? left - o.grid[0] : left + o.grid[0])) : left;
			}

		}

		return {
			top: (
				pageY -																	// The absolute mouse position
				this.offset.click.top	-												// Click offset (relative to the element)
				this.offset.relative.top -												// Only for relative positioned nodes: Relative offset from element to offset parent
				this.offset.parent.top +												// The offsetParent's offset without borders (offset + border)
				( this.cssPosition === "fixed" ? -this.scrollParent.scrollTop() : this.offset.scroll.top )
			),
			left: (
				pageX -																	// The absolute mouse position
				this.offset.click.left -												// Click offset (relative to the element)
				this.offset.relative.left -												// Only for relative positioned nodes: Relative offset from element to offset parent
				this.offset.parent.left +												// The offsetParent's offset without borders (offset + border)
				( this.cssPosition === "fixed" ? -this.scrollParent.scrollLeft() : this.offset.scroll.left )
			)
		};

	},

	_clear: function() {
		this.helper.removeClass("ui-draggable-dragging");
		if(this.helper[0] !== this.element[0] && !this.cancelHelperRemoval) {
			this.helper.remove();
		}
		this.helper = null;
		this.cancelHelperRemoval = false;
	},

	// From now on bulk stuff - mainly helpers

	_trigger: function(type, event, ui) {
		ui = ui || this._uiHash();
		$.ui.plugin.call(this, type, [event, ui]);
		//The absolute position has to be recalculated after plugins
		if(type === "drag") {
			this.positionAbs = this._convertPositionTo("absolute");
		}
		return $.Widget.prototype._trigger.call(this, type, event, ui);
	},

	plugins: {},

	_uiHash: function() {
		return {
			helper: this.helper,
			position: this.position,
			originalPosition: this.originalPosition,
			offset: this.positionAbs
		};
	}

});

$.ui.plugin.add("draggable", "connectToSortable", {
	start: function(event, ui) {

		var inst = $(this).data("ui-draggable"), o = inst.options,
			uiSortable = $.extend({}, ui, { item: inst.element });
		inst.sortables = [];
		$(o.connectToSortable).each(function() {
			var sortable = $.data(this, "ui-sortable");
			if (sortable && !sortable.options.disabled) {
				inst.sortables.push({
					instance: sortable,
					shouldRevert: sortable.options.revert
				});
				sortable.refreshPositions();	// Call the sortable's refreshPositions at drag start to refresh the containerCache since the sortable container cache is used in drag and needs to be up to date (this will ensure it's initialised as well as being kept in step with any changes that might have happened on the page).
				sortable._trigger("activate", event, uiSortable);
			}
		});

	},
	stop: function(event, ui) {

		//If we are still over the sortable, we fake the stop event of the sortable, but also remove helper
		var inst = $(this).data("ui-draggable"),
			uiSortable = $.extend({}, ui, { item: inst.element });

		$.each(inst.sortables, function() {
			if(this.instance.isOver) {

				this.instance.isOver = 0;

				inst.cancelHelperRemoval = true; //Don't remove the helper in the draggable instance
				this.instance.cancelHelperRemoval = false; //Remove it in the sortable instance (so sortable plugins like revert still work)

				//The sortable revert is supported, and we have to set a temporary dropped variable on the draggable to support revert: "valid/invalid"
				if(this.shouldRevert) {
					this.instance.options.revert = this.shouldRevert;
				}

				//Trigger the stop of the sortable
				this.instance._mouseStop(event);

				this.instance.options.helper = this.instance.options._helper;

				//If the helper has been the original item, restore properties in the sortable
				if(inst.options.helper === "original") {
					this.instance.currentItem.css({ top: "auto", left: "auto" });
				}

			} else {
				this.instance.cancelHelperRemoval = false; //Remove the helper in the sortable instance
				this.instance._trigger("deactivate", event, uiSortable);
			}

		});

	},
	drag: function(event, ui) {

		var inst = $(this).data("ui-draggable"), that = this;

		$.each(inst.sortables, function() {

			var innermostIntersecting = false,
				thisSortable = this;

			//Copy over some variables to allow calling the sortable's native _intersectsWith
			this.instance.positionAbs = inst.positionAbs;
			this.instance.helperProportions = inst.helperProportions;
			this.instance.offset.click = inst.offset.click;

			if(this.instance._intersectsWith(this.instance.containerCache)) {
				innermostIntersecting = true;
				$.each(inst.sortables, function () {
					this.instance.positionAbs = inst.positionAbs;
					this.instance.helperProportions = inst.helperProportions;
					this.instance.offset.click = inst.offset.click;
					if (this !== thisSortable &&
						this.instance._intersectsWith(this.instance.containerCache) &&
						$.contains(thisSortable.instance.element[0], this.instance.element[0])
					) {
						innermostIntersecting = false;
					}
					return innermostIntersecting;
				});
			}


			if(innermostIntersecting) {
				//If it intersects, we use a little isOver variable and set it once, so our move-in stuff gets fired only once
				if(!this.instance.isOver) {

					this.instance.isOver = 1;
					//Now we fake the start of dragging for the sortable instance,
					//by cloning the list group item, appending it to the sortable and using it as inst.currentItem
					//We can then fire the start event of the sortable with our passed browser event, and our own helper (so it doesn't create a new one)
					this.instance.currentItem = $(that).clone().removeAttr("id").appendTo(this.instance.element).data("ui-sortable-item", true);
					this.instance.options._helper = this.instance.options.helper; //Store helper option to later restore it
					this.instance.options.helper = function() { return ui.helper[0]; };

					event.target = this.instance.currentItem[0];
					this.instance._mouseCapture(event, true);
					this.instance._mouseStart(event, true, true);

					//Because the browser event is way off the new appended portlet, we modify a couple of variables to reflect the changes
					this.instance.offset.click.top = inst.offset.click.top;
					this.instance.offset.click.left = inst.offset.click.left;
					this.instance.offset.parent.left -= inst.offset.parent.left - this.instance.offset.parent.left;
					this.instance.offset.parent.top -= inst.offset.parent.top - this.instance.offset.parent.top;

					inst._trigger("toSortable", event);
					inst.dropped = this.instance.element; //draggable revert needs that
					//hack so receive/update callbacks work (mostly)
					inst.currentItem = inst.element;
					this.instance.fromOutside = inst;

				}

				//Provided we did all the previous steps, we can fire the drag event of the sortable on every draggable drag, when it intersects with the sortable
				if(this.instance.currentItem) {
					this.instance._mouseDrag(event);
				}

			} else {

				//If it doesn't intersect with the sortable, and it intersected before,
				//we fake the drag stop of the sortable, but make sure it doesn't remove the helper by using cancelHelperRemoval
				if(this.instance.isOver) {

					this.instance.isOver = 0;
					this.instance.cancelHelperRemoval = true;

					//Prevent reverting on this forced stop
					this.instance.options.revert = false;

					// The out event needs to be triggered independently
					this.instance._trigger("out", event, this.instance._uiHash(this.instance));

					this.instance._mouseStop(event, true);
					this.instance.options.helper = this.instance.options._helper;

					//Now we remove our currentItem, the list group clone again, and the placeholder, and animate the helper back to it's original size
					this.instance.currentItem.remove();
					if(this.instance.placeholder) {
						this.instance.placeholder.remove();
					}

					inst._trigger("fromSortable", event);
					inst.dropped = false; //draggable revert needs that
				}

			}

		});

	}
});

$.ui.plugin.add("draggable", "cursor", {
	start: function() {
		var t = $("body"), o = $(this).data("ui-draggable").options;
		if (t.css("cursor")) {
			o._cursor = t.css("cursor");
		}
		t.css("cursor", o.cursor);
	},
	stop: function() {
		var o = $(this).data("ui-draggable").options;
		if (o._cursor) {
			$("body").css("cursor", o._cursor);
		}
	}
});

$.ui.plugin.add("draggable", "opacity", {
	start: function(event, ui) {
		var t = $(ui.helper), o = $(this).data("ui-draggable").options;
		if(t.css("opacity")) {
			o._opacity = t.css("opacity");
		}
		t.css("opacity", o.opacity);
	},
	stop: function(event, ui) {
		var o = $(this).data("ui-draggable").options;
		if(o._opacity) {
			$(ui.helper).css("opacity", o._opacity);
		}
	}
});

$.ui.plugin.add("draggable", "scroll", {
	start: function() {
		var i = $(this).data("ui-draggable");
		if(i.scrollParent[0] !== document && i.scrollParent[0].tagName !== "HTML") {
			i.overflowOffset = i.scrollParent.offset();
		}
	},
	drag: function( event ) {

		var i = $(this).data("ui-draggable"), o = i.options, scrolled = false;

		if(i.scrollParent[0] !== document && i.scrollParent[0].tagName !== "HTML") {

			if(!o.axis || o.axis !== "x") {
				if((i.overflowOffset.top + i.scrollParent[0].offsetHeight) - event.pageY < o.scrollSensitivity) {
					i.scrollParent[0].scrollTop = scrolled = i.scrollParent[0].scrollTop + o.scrollSpeed;
				} else if(event.pageY - i.overflowOffset.top < o.scrollSensitivity) {
					i.scrollParent[0].scrollTop = scrolled = i.scrollParent[0].scrollTop - o.scrollSpeed;
				}
			}

			if(!o.axis || o.axis !== "y") {
				if((i.overflowOffset.left + i.scrollParent[0].offsetWidth) - event.pageX < o.scrollSensitivity) {
					i.scrollParent[0].scrollLeft = scrolled = i.scrollParent[0].scrollLeft + o.scrollSpeed;
				} else if(event.pageX - i.overflowOffset.left < o.scrollSensitivity) {
					i.scrollParent[0].scrollLeft = scrolled = i.scrollParent[0].scrollLeft - o.scrollSpeed;
				}
			}

		} else {

			if(!o.axis || o.axis !== "x") {
				if(event.pageY - $(document).scrollTop() < o.scrollSensitivity) {
					scrolled = $(document).scrollTop($(document).scrollTop() - o.scrollSpeed);
				} else if($(window).height() - (event.pageY - $(document).scrollTop()) < o.scrollSensitivity) {
					scrolled = $(document).scrollTop($(document).scrollTop() + o.scrollSpeed);
				}
			}

			if(!o.axis || o.axis !== "y") {
				if(event.pageX - $(document).scrollLeft() < o.scrollSensitivity) {
					scrolled = $(document).scrollLeft($(document).scrollLeft() - o.scrollSpeed);
				} else if($(window).width() - (event.pageX - $(document).scrollLeft()) < o.scrollSensitivity) {
					scrolled = $(document).scrollLeft($(document).scrollLeft() + o.scrollSpeed);
				}
			}

		}

		if(scrolled !== false && $.ui.ddmanager && !o.dropBehaviour) {
			$.ui.ddmanager.prepareOffsets(i, event);
		}

	}
});

$.ui.plugin.add("draggable", "snap", {
	start: function() {

		var i = $(this).data("ui-draggable"),
			o = i.options;

		i.snapElements = [];

		$(o.snap.constructor !== String ? ( o.snap.items || ":data(ui-draggable)" ) : o.snap).each(function() {
			var $t = $(this),
				$o = $t.offset();
			if(this !== i.element[0]) {
				i.snapElements.push({
					item: this,
					width: $t.outerWidth(), height: $t.outerHeight(),
					top: $o.top, left: $o.left
				});
			}
		});

	},
	drag: function(event, ui) {

		var ts, bs, ls, rs, l, r, t, b, i, first,
			inst = $(this).data("ui-draggable"),
			o = inst.options,
			d = o.snapTolerance,
			x1 = ui.offset.left, x2 = x1 + inst.helperProportions.width,
			y1 = ui.offset.top, y2 = y1 + inst.helperProportions.height;

		for (i = inst.snapElements.length - 1; i >= 0; i--){

			l = inst.snapElements[i].left;
			r = l + inst.snapElements[i].width;
			t = inst.snapElements[i].top;
			b = t + inst.snapElements[i].height;

			if ( x2 < l - d || x1 > r + d || y2 < t - d || y1 > b + d || !$.contains( inst.snapElements[ i ].item.ownerDocument, inst.snapElements[ i ].item ) ) {
				if(inst.snapElements[i].snapping) {
					(inst.options.snap.release && inst.options.snap.release.call(inst.element, event, $.extend(inst._uiHash(), { snapItem: inst.snapElements[i].item })));
				}
				inst.snapElements[i].snapping = false;
				continue;
			}

			if(o.snapMode !== "inner") {
				ts = Math.abs(t - y2) <= d;
				bs = Math.abs(b - y1) <= d;
				ls = Math.abs(l - x2) <= d;
				rs = Math.abs(r - x1) <= d;
				if(ts) {
					ui.position.top = inst._convertPositionTo("relative", { top: t - inst.helperProportions.height, left: 0 }).top - inst.margins.top;
				}
				if(bs) {
					ui.position.top = inst._convertPositionTo("relative", { top: b, left: 0 }).top - inst.margins.top;
				}
				if(ls) {
					ui.position.left = inst._convertPositionTo("relative", { top: 0, left: l - inst.helperProportions.width }).left - inst.margins.left;
				}
				if(rs) {
					ui.position.left = inst._convertPositionTo("relative", { top: 0, left: r }).left - inst.margins.left;
				}
			}

			first = (ts || bs || ls || rs);

			if(o.snapMode !== "outer") {
				ts = Math.abs(t - y1) <= d;
				bs = Math.abs(b - y2) <= d;
				ls = Math.abs(l - x1) <= d;
				rs = Math.abs(r - x2) <= d;
				if(ts) {
					ui.position.top = inst._convertPositionTo("relative", { top: t, left: 0 }).top - inst.margins.top;
				}
				if(bs) {
					ui.position.top = inst._convertPositionTo("relative", { top: b - inst.helperProportions.height, left: 0 }).top - inst.margins.top;
				}
				if(ls) {
					ui.position.left = inst._convertPositionTo("relative", { top: 0, left: l }).left - inst.margins.left;
				}
				if(rs) {
					ui.position.left = inst._convertPositionTo("relative", { top: 0, left: r - inst.helperProportions.width }).left - inst.margins.left;
				}
			}

			if(!inst.snapElements[i].snapping && (ts || bs || ls || rs || first)) {
				(inst.options.snap.snap && inst.options.snap.snap.call(inst.element, event, $.extend(inst._uiHash(), { snapItem: inst.snapElements[i].item })));
			}
			inst.snapElements[i].snapping = (ts || bs || ls || rs || first);

		}

	}
});

$.ui.plugin.add("draggable", "stack", {
	start: function() {
		var min,
			o = this.data("ui-draggable").options,
			group = $.makeArray($(o.stack)).sort(function(a,b) {
				return (parseInt($(a).css("zIndex"),10) || 0) - (parseInt($(b).css("zIndex"),10) || 0);
			});

		if (!group.length) { return; }

		min = parseInt($(group[0]).css("zIndex"), 10) || 0;
		$(group).each(function(i) {
			$(this).css("zIndex", min + i);
		});
		this.css("zIndex", (min + group.length));
	}
});

$.ui.plugin.add("draggable", "zIndex", {
	start: function(event, ui) {
		var t = $(ui.helper), o = $(this).data("ui-draggable").options;
		if(t.css("zIndex")) {
			o._zIndex = t.css("zIndex");
		}
		t.css("zIndex", o.zIndex);
	},
	stop: function(event, ui) {
		var o = $(this).data("ui-draggable").options;
		if(o._zIndex) {
			$(ui.helper).css("zIndex", o._zIndex);
		}
	}
});

})(jQuery);
/*!
 * jQuery UI Droppable 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/droppable/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 *	jquery.ui.mouse.js
 *	jquery.ui.draggable.js
 */
(function( $, undefined ) {

function isOverAxis( x, reference, size ) {
	return ( x > reference ) && ( x < ( reference + size ) );
}

$.widget("ui.droppable", {
	version: "1.10.3",
	widgetEventPrefix: "drop",
	options: {
		accept: "*",
		activeClass: false,
		addClasses: true,
		greedy: false,
		hoverClass: false,
		scope: "default",
		tolerance: "intersect",

		// callbacks
		activate: null,
		deactivate: null,
		drop: null,
		out: null,
		over: null
	},
	_create: function() {

		var o = this.options,
			accept = o.accept;

		this.isover = false;
		this.isout = true;

		this.accept = $.isFunction(accept) ? accept : function(d) {
			return d.is(accept);
		};

		//Store the droppable's proportions
		this.proportions = { width: this.element[0].offsetWidth, height: this.element[0].offsetHeight };

		// Add the reference and positions to the manager
		$.ui.ddmanager.droppables[o.scope] = $.ui.ddmanager.droppables[o.scope] || [];
		$.ui.ddmanager.droppables[o.scope].push(this);

		(o.addClasses && this.element.addClass("ui-droppable"));

	},

	_destroy: function() {
		var i = 0,
			drop = $.ui.ddmanager.droppables[this.options.scope];

		for ( ; i < drop.length; i++ ) {
			if ( drop[i] === this ) {
				drop.splice(i, 1);
			}
		}

		this.element.removeClass("ui-droppable ui-droppable-disabled");
	},

	_setOption: function(key, value) {

		if(key === "accept") {
			this.accept = $.isFunction(value) ? value : function(d) {
				return d.is(value);
			};
		}
		$.Widget.prototype._setOption.apply(this, arguments);
	},

	_activate: function(event) {
		var draggable = $.ui.ddmanager.current;
		if(this.options.activeClass) {
			this.element.addClass(this.options.activeClass);
		}
		if(draggable){
			this._trigger("activate", event, this.ui(draggable));
		}
	},

	_deactivate: function(event) {
		var draggable = $.ui.ddmanager.current;
		if(this.options.activeClass) {
			this.element.removeClass(this.options.activeClass);
		}
		if(draggable){
			this._trigger("deactivate", event, this.ui(draggable));
		}
	},

	_over: function(event) {

		var draggable = $.ui.ddmanager.current;

		// Bail if draggable and droppable are same element
		if (!draggable || (draggable.currentItem || draggable.element)[0] === this.element[0]) {
			return;
		}

		if (this.accept.call(this.element[0],(draggable.currentItem || draggable.element))) {
			if(this.options.hoverClass) {
				this.element.addClass(this.options.hoverClass);
			}
			this._trigger("over", event, this.ui(draggable));
		}

	},

	_out: function(event) {

		var draggable = $.ui.ddmanager.current;

		// Bail if draggable and droppable are same element
		if (!draggable || (draggable.currentItem || draggable.element)[0] === this.element[0]) {
			return;
		}

		if (this.accept.call(this.element[0],(draggable.currentItem || draggable.element))) {
			if(this.options.hoverClass) {
				this.element.removeClass(this.options.hoverClass);
			}
			this._trigger("out", event, this.ui(draggable));
		}

	},

	_drop: function(event,custom) {

		var draggable = custom || $.ui.ddmanager.current,
			childrenIntersection = false;

		// Bail if draggable and droppable are same element
		if (!draggable || (draggable.currentItem || draggable.element)[0] === this.element[0]) {
			return false;
		}

		this.element.find(":data(ui-droppable)").not(".ui-draggable-dragging").each(function() {
			var inst = $.data(this, "ui-droppable");
			if(
				inst.options.greedy &&
				!inst.options.disabled &&
				inst.options.scope === draggable.options.scope &&
				inst.accept.call(inst.element[0], (draggable.currentItem || draggable.element)) &&
				$.ui.intersect(draggable, $.extend(inst, { offset: inst.element.offset() }), inst.options.tolerance)
			) { childrenIntersection = true; return false; }
		});
		if(childrenIntersection) {
			return false;
		}

		if(this.accept.call(this.element[0],(draggable.currentItem || draggable.element))) {
			if(this.options.activeClass) {
				this.element.removeClass(this.options.activeClass);
			}
			if(this.options.hoverClass) {
				this.element.removeClass(this.options.hoverClass);
			}
			this._trigger("drop", event, this.ui(draggable));
			return this.element;
		}

		return false;

	},

	ui: function(c) {
		return {
			draggable: (c.currentItem || c.element),
			helper: c.helper,
			position: c.position,
			offset: c.positionAbs
		};
	}

});

$.ui.intersect = function(draggable, droppable, toleranceMode) {

	if (!droppable.offset) {
		return false;
	}

	var draggableLeft, draggableTop,
		x1 = (draggable.positionAbs || draggable.position.absolute).left, x2 = x1 + draggable.helperProportions.width,
		y1 = (draggable.positionAbs || draggable.position.absolute).top, y2 = y1 + draggable.helperProportions.height,
		l = droppable.offset.left, r = l + droppable.proportions.width,
		t = droppable.offset.top, b = t + droppable.proportions.height;

	switch (toleranceMode) {
		case "fit":
			return (l <= x1 && x2 <= r && t <= y1 && y2 <= b);
		case "intersect":
			return (l < x1 + (draggable.helperProportions.width / 2) && // Right Half
				x2 - (draggable.helperProportions.width / 2) < r && // Left Half
				t < y1 + (draggable.helperProportions.height / 2) && // Bottom Half
				y2 - (draggable.helperProportions.height / 2) < b ); // Top Half
		case "pointer":
			draggableLeft = ((draggable.positionAbs || draggable.position.absolute).left + (draggable.clickOffset || draggable.offset.click).left);
			draggableTop = ((draggable.positionAbs || draggable.position.absolute).top + (draggable.clickOffset || draggable.offset.click).top);
			return isOverAxis( draggableTop, t, droppable.proportions.height ) && isOverAxis( draggableLeft, l, droppable.proportions.width );
		case "touch":
			return (
				(y1 >= t && y1 <= b) ||	// Top edge touching
				(y2 >= t && y2 <= b) ||	// Bottom edge touching
				(y1 < t && y2 > b)		// Surrounded vertically
			) && (
				(x1 >= l && x1 <= r) ||	// Left edge touching
				(x2 >= l && x2 <= r) ||	// Right edge touching
				(x1 < l && x2 > r)		// Surrounded horizontally
			);
		default:
			return false;
		}

};

/*
	This manager tracks offsets of draggables and droppables
*/
$.ui.ddmanager = {
	current: null,
	droppables: { "default": [] },
	prepareOffsets: function(t, event) {

		var i, j,
			m = $.ui.ddmanager.droppables[t.options.scope] || [],
			type = event ? event.type : null, // workaround for #2317
			list = (t.currentItem || t.element).find(":data(ui-droppable)").addBack();

		droppablesLoop: for (i = 0; i < m.length; i++) {

			//No disabled and non-accepted
			if(m[i].options.disabled || (t && !m[i].accept.call(m[i].element[0],(t.currentItem || t.element)))) {
				continue;
			}

			// Filter out elements in the current dragged item
			for (j=0; j < list.length; j++) {
				if(list[j] === m[i].element[0]) {
					m[i].proportions.height = 0;
					continue droppablesLoop;
				}
			}

			m[i].visible = m[i].element.css("display") !== "none";
			if(!m[i].visible) {
				continue;
			}

			//Activate the droppable if used directly from draggables
			if(type === "mousedown") {
				m[i]._activate.call(m[i], event);
			}

			m[i].offset = m[i].element.offset();
			m[i].proportions = { width: m[i].element[0].offsetWidth, height: m[i].element[0].offsetHeight };

		}

	},
	drop: function(draggable, event) {

		var dropped = false;
		// Create a copy of the droppables in case the list changes during the drop (#9116)
		$.each(($.ui.ddmanager.droppables[draggable.options.scope] || []).slice(), function() {

			if(!this.options) {
				return;
			}
			if (!this.options.disabled && this.visible && $.ui.intersect(draggable, this, this.options.tolerance)) {
				dropped = this._drop.call(this, event) || dropped;
			}

			if (!this.options.disabled && this.visible && this.accept.call(this.element[0],(draggable.currentItem || draggable.element))) {
				this.isout = true;
				this.isover = false;
				this._deactivate.call(this, event);
			}

		});
		return dropped;

	},
	dragStart: function( draggable, event ) {
		//Listen for scrolling so that if the dragging causes scrolling the position of the droppables can be recalculated (see #5003)
		draggable.element.parentsUntil( "body" ).bind( "scroll.droppable", function() {
			if( !draggable.options.refreshPositions ) {
				$.ui.ddmanager.prepareOffsets( draggable, event );
			}
		});
	},
	drag: function(draggable, event) {

		//If you have a highly dynamic page, you might try this option. It renders positions every time you move the mouse.
		if(draggable.options.refreshPositions) {
			$.ui.ddmanager.prepareOffsets(draggable, event);
		}

		//Run through all droppables and check their positions based on specific tolerance options
		$.each($.ui.ddmanager.droppables[draggable.options.scope] || [], function() {

			if(this.options.disabled || this.greedyChild || !this.visible) {
				return;
			}

			var parentInstance, scope, parent,
				intersects = $.ui.intersect(draggable, this, this.options.tolerance),
				c = !intersects && this.isover ? "isout" : (intersects && !this.isover ? "isover" : null);
			if(!c) {
				return;
			}

			if (this.options.greedy) {
				// find droppable parents with same scope
				scope = this.options.scope;
				parent = this.element.parents(":data(ui-droppable)").filter(function () {
					return $.data(this, "ui-droppable").options.scope === scope;
				});

				if (parent.length) {
					parentInstance = $.data(parent[0], "ui-droppable");
					parentInstance.greedyChild = (c === "isover");
				}
			}

			// we just moved into a greedy child
			if (parentInstance && c === "isover") {
				parentInstance.isover = false;
				parentInstance.isout = true;
				parentInstance._out.call(parentInstance, event);
			}

			this[c] = true;
			this[c === "isout" ? "isover" : "isout"] = false;
			this[c === "isover" ? "_over" : "_out"].call(this, event);

			// we just moved out of a greedy child
			if (parentInstance && c === "isout") {
				parentInstance.isout = false;
				parentInstance.isover = true;
				parentInstance._over.call(parentInstance, event);
			}
		});

	},
	dragStop: function( draggable, event ) {
		draggable.element.parentsUntil( "body" ).unbind( "scroll.droppable" );
		//Call prepareOffsets one final time since IE does not fire return scroll events when overflow was caused by drag (see #5003)
		if( !draggable.options.refreshPositions ) {
			$.ui.ddmanager.prepareOffsets( draggable, event );
		}
	}
};

})(jQuery);
/*!
 * jQuery UI Resizable 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/resizable/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 */
(function( $, undefined ) {

function num(v) {
	return parseInt(v, 10) || 0;
}

function isNumber(value) {
	return !isNaN(parseInt(value, 10));
}

$.widget("ui.resizable", $.ui.mouse, {
	version: "1.10.3",
	widgetEventPrefix: "resize",
	options: {
		alsoResize: false,
		animate: false,
		animateDuration: "slow",
		animateEasing: "swing",
		aspectRatio: false,
		autoHide: false,
		containment: false,
		ghost: false,
		grid: false,
		handles: "e,s,se",
		helper: false,
		maxHeight: null,
		maxWidth: null,
		minHeight: 10,
		minWidth: 10,
		// See #7960
		zIndex: 90,

		// callbacks
		resize: null,
		start: null,
		stop: null
	},
	_create: function() {

		var n, i, handle, axis, hname,
			that = this,
			o = this.options;
		this.element.addClass("ui-resizable");

		$.extend(this, {
			_aspectRatio: !!(o.aspectRatio),
			aspectRatio: o.aspectRatio,
			originalElement: this.element,
			_proportionallyResizeElements: [],
			_helper: o.helper || o.ghost || o.animate ? o.helper || "ui-resizable-helper" : null
		});

		//Wrap the element if it cannot hold child nodes
		if(this.element[0].nodeName.match(/canvas|textarea|input|select|button|img/i)) {

			//Create a wrapper element and set the wrapper to the new current internal element
			this.element.wrap(
				$("<div class='ui-wrapper' style='overflow: hidden;'></div>").css({
					position: this.element.css("position"),
					width: this.element.outerWidth(),
					height: this.element.outerHeight(),
					top: this.element.css("top"),
					left: this.element.css("left")
				})
			);

			//Overwrite the original this.element
			this.element = this.element.parent().data(
				"ui-resizable", this.element.data("ui-resizable")
			);

			this.elementIsWrapper = true;

			//Move margins to the wrapper
			this.element.css({ marginLeft: this.originalElement.css("marginLeft"), marginTop: this.originalElement.css("marginTop"), marginRight: this.originalElement.css("marginRight"), marginBottom: this.originalElement.css("marginBottom") });
			this.originalElement.css({ marginLeft: 0, marginTop: 0, marginRight: 0, marginBottom: 0});

			//Prevent Safari textarea resize
			this.originalResizeStyle = this.originalElement.css("resize");
			this.originalElement.css("resize", "none");

			//Push the actual element to our proportionallyResize internal array
			this._proportionallyResizeElements.push(this.originalElement.css({ position: "static", zoom: 1, display: "block" }));

			// avoid IE jump (hard set the margin)
			this.originalElement.css({ margin: this.originalElement.css("margin") });

			// fix handlers offset
			this._proportionallyResize();

		}

		this.handles = o.handles || (!$(".ui-resizable-handle", this.element).length ? "e,s,se" : { n: ".ui-resizable-n", e: ".ui-resizable-e", s: ".ui-resizable-s", w: ".ui-resizable-w", se: ".ui-resizable-se", sw: ".ui-resizable-sw", ne: ".ui-resizable-ne", nw: ".ui-resizable-nw" });
		if(this.handles.constructor === String) {

			if ( this.handles === "all") {
				this.handles = "n,e,s,w,se,sw,ne,nw";
			}

			n = this.handles.split(",");
			this.handles = {};

			for(i = 0; i < n.length; i++) {

				handle = $.trim(n[i]);
				hname = "ui-resizable-"+handle;
				axis = $("<div class='ui-resizable-handle " + hname + "'></div>");

				// Apply zIndex to all handles - see #7960
				axis.css({ zIndex: o.zIndex });

				//TODO : What's going on here?
				if ("se" === handle) {
					axis.addClass("ui-icon ui-icon-gripsmall-diagonal-se");
				}

				//Insert into internal handles object and append to element
				this.handles[handle] = ".ui-resizable-"+handle;
				this.element.append(axis);
			}

		}

		this._renderAxis = function(target) {

			var i, axis, padPos, padWrapper;

			target = target || this.element;

			for(i in this.handles) {

				if(this.handles[i].constructor === String) {
					this.handles[i] = $(this.handles[i], this.element).show();
				}

				//Apply pad to wrapper element, needed to fix axis position (textarea, inputs, scrolls)
				if (this.elementIsWrapper && this.originalElement[0].nodeName.match(/textarea|input|select|button/i)) {

					axis = $(this.handles[i], this.element);

					//Checking the correct pad and border
					padWrapper = /sw|ne|nw|se|n|s/.test(i) ? axis.outerHeight() : axis.outerWidth();

					//The padding type i have to apply...
					padPos = [ "padding",
						/ne|nw|n/.test(i) ? "Top" :
						/se|sw|s/.test(i) ? "Bottom" :
						/^e$/.test(i) ? "Right" : "Left" ].join("");

					target.css(padPos, padWrapper);

					this._proportionallyResize();

				}

				//TODO: What's that good for? There's not anything to be executed left
				if(!$(this.handles[i]).length) {
					continue;
				}
			}
		};

		//TODO: make renderAxis a prototype function
		this._renderAxis(this.element);

		this._handles = $(".ui-resizable-handle", this.element)
			.disableSelection();

		//Matching axis name
		this._handles.mouseover(function() {
			if (!that.resizing) {
				if (this.className) {
					axis = this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i);
				}
				//Axis, default = se
				that.axis = axis && axis[1] ? axis[1] : "se";
			}
		});

		//If we want to auto hide the elements
		if (o.autoHide) {
			this._handles.hide();
			$(this.element)
				.addClass("ui-resizable-autohide")
				.mouseenter(function() {
					if (o.disabled) {
						return;
					}
					$(this).removeClass("ui-resizable-autohide");
					that._handles.show();
				})
				.mouseleave(function(){
					if (o.disabled) {
						return;
					}
					if (!that.resizing) {
						$(this).addClass("ui-resizable-autohide");
						that._handles.hide();
					}
				});
		}

		//Initialize the mouse interaction
		this._mouseInit();

	},

	_destroy: function() {

		this._mouseDestroy();

		var wrapper,
			_destroy = function(exp) {
				$(exp).removeClass("ui-resizable ui-resizable-disabled ui-resizable-resizing")
					.removeData("resizable").removeData("ui-resizable").unbind(".resizable").find(".ui-resizable-handle").remove();
			};

		//TODO: Unwrap at same DOM position
		if (this.elementIsWrapper) {
			_destroy(this.element);
			wrapper = this.element;
			this.originalElement.css({
				position: wrapper.css("position"),
				width: wrapper.outerWidth(),
				height: wrapper.outerHeight(),
				top: wrapper.css("top"),
				left: wrapper.css("left")
			}).insertAfter( wrapper );
			wrapper.remove();
		}

		this.originalElement.css("resize", this.originalResizeStyle);
		_destroy(this.originalElement);

		return this;
	},

	_mouseCapture: function(event) {
		var i, handle,
			capture = false;

		for (i in this.handles) {
			handle = $(this.handles[i])[0];
			if (handle === event.target || $.contains(handle, event.target)) {
				capture = true;
			}
		}

		return !this.options.disabled && capture;
	},

	_mouseStart: function(event) {

		var curleft, curtop, cursor,
			o = this.options,
			iniPos = this.element.position(),
			el = this.element;

		this.resizing = true;

		// bugfix for http://dev.jquery.com/ticket/1749
		if ( (/absolute/).test( el.css("position") ) ) {
			el.css({ position: "absolute", top: el.css("top"), left: el.css("left") });
		} else if (el.is(".ui-draggable")) {
			el.css({ position: "absolute", top: iniPos.top, left: iniPos.left });
		}

		this._renderProxy();

		curleft = num(this.helper.css("left"));
		curtop = num(this.helper.css("top"));

		if (o.containment) {
			curleft += $(o.containment).scrollLeft() || 0;
			curtop += $(o.containment).scrollTop() || 0;
		}

		//Store needed variables
		this.offset = this.helper.offset();
		this.position = { left: curleft, top: curtop };
		this.size = this._helper ? { width: el.outerWidth(), height: el.outerHeight() } : { width: el.width(), height: el.height() };
		this.originalSize = this._helper ? { width: el.outerWidth(), height: el.outerHeight() } : { width: el.width(), height: el.height() };
		this.originalPosition = { left: curleft, top: curtop };
		this.sizeDiff = { width: el.outerWidth() - el.width(), height: el.outerHeight() - el.height() };
		this.originalMousePosition = { left: event.pageX, top: event.pageY };

		//Aspect Ratio
		this.aspectRatio = (typeof o.aspectRatio === "number") ? o.aspectRatio : ((this.originalSize.width / this.originalSize.height) || 1);

		cursor = $(".ui-resizable-" + this.axis).css("cursor");
		$("body").css("cursor", cursor === "auto" ? this.axis + "-resize" : cursor);

		el.addClass("ui-resizable-resizing");
		this._propagate("start", event);
		return true;
	},

	_mouseDrag: function(event) {

		//Increase performance, avoid regex
		var data,
			el = this.helper, props = {},
			smp = this.originalMousePosition,
			a = this.axis,
			prevTop = this.position.top,
			prevLeft = this.position.left,
			prevWidth = this.size.width,
			prevHeight = this.size.height,
			dx = (event.pageX-smp.left)||0,
			dy = (event.pageY-smp.top)||0,
			trigger = this._change[a];

		if (!trigger) {
			return false;
		}

		// Calculate the attrs that will be change
		data = trigger.apply(this, [event, dx, dy]);

		// Put this in the mouseDrag handler since the user can start pressing shift while resizing
		this._updateVirtualBoundaries(event.shiftKey);
		if (this._aspectRatio || event.shiftKey) {
			data = this._updateRatio(data, event);
		}

		data = this._respectSize(data, event);

		this._updateCache(data);

		// plugins callbacks need to be called first
		this._propagate("resize", event);

		if (this.position.top !== prevTop) {
			props.top = this.position.top + "px";
		}
		if (this.position.left !== prevLeft) {
			props.left = this.position.left + "px";
		}
		if (this.size.width !== prevWidth) {
			props.width = this.size.width + "px";
		}
		if (this.size.height !== prevHeight) {
			props.height = this.size.height + "px";
		}
		el.css(props);

		if (!this._helper && this._proportionallyResizeElements.length) {
			this._proportionallyResize();
		}

		// Call the user callback if the element was resized
		if ( ! $.isEmptyObject(props) ) {
			this._trigger("resize", event, this.ui());
		}

		return false;
	},

	_mouseStop: function(event) {

		this.resizing = false;
		var pr, ista, soffseth, soffsetw, s, left, top,
			o = this.options, that = this;

		if(this._helper) {

			pr = this._proportionallyResizeElements;
			ista = pr.length && (/textarea/i).test(pr[0].nodeName);
			soffseth = ista && $.ui.hasScroll(pr[0], "left") /* TODO - jump height */ ? 0 : that.sizeDiff.height;
			soffsetw = ista ? 0 : that.sizeDiff.width;

			s = { width: (that.helper.width()  - soffsetw), height: (that.helper.height() - soffseth) };
			left = (parseInt(that.element.css("left"), 10) + (that.position.left - that.originalPosition.left)) || null;
			top = (parseInt(that.element.css("top"), 10) + (that.position.top - that.originalPosition.top)) || null;

			if (!o.animate) {
				this.element.css($.extend(s, { top: top, left: left }));
			}

			that.helper.height(that.size.height);
			that.helper.width(that.size.width);

			if (this._helper && !o.animate) {
				this._proportionallyResize();
			}
		}

		$("body").css("cursor", "auto");

		this.element.removeClass("ui-resizable-resizing");

		this._propagate("stop", event);

		if (this._helper) {
			this.helper.remove();
		}

		return false;

	},

	_updateVirtualBoundaries: function(forceAspectRatio) {
		var pMinWidth, pMaxWidth, pMinHeight, pMaxHeight, b,
			o = this.options;

		b = {
			minWidth: isNumber(o.minWidth) ? o.minWidth : 0,
			maxWidth: isNumber(o.maxWidth) ? o.maxWidth : Infinity,
			minHeight: isNumber(o.minHeight) ? o.minHeight : 0,
			maxHeight: isNumber(o.maxHeight) ? o.maxHeight : Infinity
		};

		if(this._aspectRatio || forceAspectRatio) {
			// We want to create an enclosing box whose aspect ration is the requested one
			// First, compute the "projected" size for each dimension based on the aspect ratio and other dimension
			pMinWidth = b.minHeight * this.aspectRatio;
			pMinHeight = b.minWidth / this.aspectRatio;
			pMaxWidth = b.maxHeight * this.aspectRatio;
			pMaxHeight = b.maxWidth / this.aspectRatio;

			if(pMinWidth > b.minWidth) {
				b.minWidth = pMinWidth;
			}
			if(pMinHeight > b.minHeight) {
				b.minHeight = pMinHeight;
			}
			if(pMaxWidth < b.maxWidth) {
				b.maxWidth = pMaxWidth;
			}
			if(pMaxHeight < b.maxHeight) {
				b.maxHeight = pMaxHeight;
			}
		}
		this._vBoundaries = b;
	},

	_updateCache: function(data) {
		this.offset = this.helper.offset();
		if (isNumber(data.left)) {
			this.position.left = data.left;
		}
		if (isNumber(data.top)) {
			this.position.top = data.top;
		}
		if (isNumber(data.height)) {
			this.size.height = data.height;
		}
		if (isNumber(data.width)) {
			this.size.width = data.width;
		}
	},

	_updateRatio: function( data ) {

		var cpos = this.position,
			csize = this.size,
			a = this.axis;

		if (isNumber(data.height)) {
			data.width = (data.height * this.aspectRatio);
		} else if (isNumber(data.width)) {
			data.height = (data.width / this.aspectRatio);
		}

		if (a === "sw") {
			data.left = cpos.left + (csize.width - data.width);
			data.top = null;
		}
		if (a === "nw") {
			data.top = cpos.top + (csize.height - data.height);
			data.left = cpos.left + (csize.width - data.width);
		}

		return data;
	},

	_respectSize: function( data ) {

		var o = this._vBoundaries,
			a = this.axis,
			ismaxw = isNumber(data.width) && o.maxWidth && (o.maxWidth < data.width), ismaxh = isNumber(data.height) && o.maxHeight && (o.maxHeight < data.height),
			isminw = isNumber(data.width) && o.minWidth && (o.minWidth > data.width), isminh = isNumber(data.height) && o.minHeight && (o.minHeight > data.height),
			dw = this.originalPosition.left + this.originalSize.width,
			dh = this.position.top + this.size.height,
			cw = /sw|nw|w/.test(a), ch = /nw|ne|n/.test(a);
		if (isminw) {
			data.width = o.minWidth;
		}
		if (isminh) {
			data.height = o.minHeight;
		}
		if (ismaxw) {
			data.width = o.maxWidth;
		}
		if (ismaxh) {
			data.height = o.maxHeight;
		}

		if (isminw && cw) {
			data.left = dw - o.minWidth;
		}
		if (ismaxw && cw) {
			data.left = dw - o.maxWidth;
		}
		if (isminh && ch) {
			data.top = dh - o.minHeight;
		}
		if (ismaxh && ch) {
			data.top = dh - o.maxHeight;
		}

		// fixing jump error on top/left - bug #2330
		if (!data.width && !data.height && !data.left && data.top) {
			data.top = null;
		} else if (!data.width && !data.height && !data.top && data.left) {
			data.left = null;
		}

		return data;
	},

	_proportionallyResize: function() {

		if (!this._proportionallyResizeElements.length) {
			return;
		}

		var i, j, borders, paddings, prel,
			element = this.helper || this.element;

		for ( i=0; i < this._proportionallyResizeElements.length; i++) {

			prel = this._proportionallyResizeElements[i];

			if (!this.borderDif) {
				this.borderDif = [];
				borders = [prel.css("borderTopWidth"), prel.css("borderRightWidth"), prel.css("borderBottomWidth"), prel.css("borderLeftWidth")];
				paddings = [prel.css("paddingTop"), prel.css("paddingRight"), prel.css("paddingBottom"), prel.css("paddingLeft")];

				for ( j = 0; j < borders.length; j++ ) {
					this.borderDif[ j ] = ( parseInt( borders[ j ], 10 ) || 0 ) + ( parseInt( paddings[ j ], 10 ) || 0 );
				}
			}

			prel.css({
				height: (element.height() - this.borderDif[0] - this.borderDif[2]) || 0,
				width: (element.width() - this.borderDif[1] - this.borderDif[3]) || 0
			});

		}

	},

	_renderProxy: function() {

		var el = this.element, o = this.options;
		this.elementOffset = el.offset();

		if(this._helper) {

			this.helper = this.helper || $("<div style='overflow:hidden;'></div>");

			this.helper.addClass(this._helper).css({
				width: this.element.outerWidth() - 1,
				height: this.element.outerHeight() - 1,
				position: "absolute",
				left: this.elementOffset.left +"px",
				top: this.elementOffset.top +"px",
				zIndex: ++o.zIndex //TODO: Don't modify option
			});

			this.helper
				.appendTo("body")
				.disableSelection();

		} else {
			this.helper = this.element;
		}

	},

	_change: {
		e: function(event, dx) {
			return { width: this.originalSize.width + dx };
		},
		w: function(event, dx) {
			var cs = this.originalSize, sp = this.originalPosition;
			return { left: sp.left + dx, width: cs.width - dx };
		},
		n: function(event, dx, dy) {
			var cs = this.originalSize, sp = this.originalPosition;
			return { top: sp.top + dy, height: cs.height - dy };
		},
		s: function(event, dx, dy) {
			return { height: this.originalSize.height + dy };
		},
		se: function(event, dx, dy) {
			return $.extend(this._change.s.apply(this, arguments), this._change.e.apply(this, [event, dx, dy]));
		},
		sw: function(event, dx, dy) {
			return $.extend(this._change.s.apply(this, arguments), this._change.w.apply(this, [event, dx, dy]));
		},
		ne: function(event, dx, dy) {
			return $.extend(this._change.n.apply(this, arguments), this._change.e.apply(this, [event, dx, dy]));
		},
		nw: function(event, dx, dy) {
			return $.extend(this._change.n.apply(this, arguments), this._change.w.apply(this, [event, dx, dy]));
		}
	},

	_propagate: function(n, event) {
		$.ui.plugin.call(this, n, [event, this.ui()]);
		(n !== "resize" && this._trigger(n, event, this.ui()));
	},

	plugins: {},

	ui: function() {
		return {
			originalElement: this.originalElement,
			element: this.element,
			helper: this.helper,
			position: this.position,
			size: this.size,
			originalSize: this.originalSize,
			originalPosition: this.originalPosition
		};
	}

});

/*
 * Resizable Extensions
 */

$.ui.plugin.add("resizable", "animate", {

	stop: function( event ) {
		var that = $(this).data("ui-resizable"),
			o = that.options,
			pr = that._proportionallyResizeElements,
			ista = pr.length && (/textarea/i).test(pr[0].nodeName),
			soffseth = ista && $.ui.hasScroll(pr[0], "left") /* TODO - jump height */ ? 0 : that.sizeDiff.height,
			soffsetw = ista ? 0 : that.sizeDiff.width,
			style = { width: (that.size.width - soffsetw), height: (that.size.height - soffseth) },
			left = (parseInt(that.element.css("left"), 10) + (that.position.left - that.originalPosition.left)) || null,
			top = (parseInt(that.element.css("top"), 10) + (that.position.top - that.originalPosition.top)) || null;

		that.element.animate(
			$.extend(style, top && left ? { top: top, left: left } : {}), {
				duration: o.animateDuration,
				easing: o.animateEasing,
				step: function() {

					var data = {
						width: parseInt(that.element.css("width"), 10),
						height: parseInt(that.element.css("height"), 10),
						top: parseInt(that.element.css("top"), 10),
						left: parseInt(that.element.css("left"), 10)
					};

					if (pr && pr.length) {
						$(pr[0]).css({ width: data.width, height: data.height });
					}

					// propagating resize, and updating values for each animation step
					that._updateCache(data);
					that._propagate("resize", event);

				}
			}
		);
	}

});

$.ui.plugin.add("resizable", "containment", {

	start: function() {
		var element, p, co, ch, cw, width, height,
			that = $(this).data("ui-resizable"),
			o = that.options,
			el = that.element,
			oc = o.containment,
			ce = (oc instanceof $) ? oc.get(0) : (/parent/.test(oc)) ? el.parent().get(0) : oc;

		if (!ce) {
			return;
		}

		that.containerElement = $(ce);

		if (/document/.test(oc) || oc === document) {
			that.containerOffset = { left: 0, top: 0 };
			that.containerPosition = { left: 0, top: 0 };

			that.parentData = {
				element: $(document), left: 0, top: 0,
				width: $(document).width(), height: $(document).height() || document.body.parentNode.scrollHeight
			};
		}

		// i'm a node, so compute top, left, right, bottom
		else {
			element = $(ce);
			p = [];
			$([ "Top", "Right", "Left", "Bottom" ]).each(function(i, name) { p[i] = num(element.css("padding" + name)); });

			that.containerOffset = element.offset();
			that.containerPosition = element.position();
			that.containerSize = { height: (element.innerHeight() - p[3]), width: (element.innerWidth() - p[1]) };

			co = that.containerOffset;
			ch = that.containerSize.height;
			cw = that.containerSize.width;
			width = ($.ui.hasScroll(ce, "left") ? ce.scrollWidth : cw );
			height = ($.ui.hasScroll(ce) ? ce.scrollHeight : ch);

			that.parentData = {
				element: ce, left: co.left, top: co.top, width: width, height: height
			};
		}
	},

	resize: function( event ) {
		var woset, hoset, isParent, isOffsetRelative,
			that = $(this).data("ui-resizable"),
			o = that.options,
			co = that.containerOffset, cp = that.position,
			pRatio = that._aspectRatio || event.shiftKey,
			cop = { top:0, left:0 }, ce = that.containerElement;

		if (ce[0] !== document && (/static/).test(ce.css("position"))) {
			cop = co;
		}

		if (cp.left < (that._helper ? co.left : 0)) {
			that.size.width = that.size.width + (that._helper ? (that.position.left - co.left) : (that.position.left - cop.left));
			if (pRatio) {
				that.size.height = that.size.width / that.aspectRatio;
			}
			that.position.left = o.helper ? co.left : 0;
		}

		if (cp.top < (that._helper ? co.top : 0)) {
			that.size.height = that.size.height + (that._helper ? (that.position.top - co.top) : that.position.top);
			if (pRatio) {
				that.size.width = that.size.height * that.aspectRatio;
			}
			that.position.top = that._helper ? co.top : 0;
		}

		that.offset.left = that.parentData.left+that.position.left;
		that.offset.top = that.parentData.top+that.position.top;

		woset = Math.abs( (that._helper ? that.offset.left - cop.left : (that.offset.left - cop.left)) + that.sizeDiff.width );
		hoset = Math.abs( (that._helper ? that.offset.top - cop.top : (that.offset.top - co.top)) + that.sizeDiff.height );

		isParent = that.containerElement.get(0) === that.element.parent().get(0);
		isOffsetRelative = /relative|absolute/.test(that.containerElement.css("position"));

		if(isParent && isOffsetRelative) {
			woset -= that.parentData.left;
		}

		if (woset + that.size.width >= that.parentData.width) {
			that.size.width = that.parentData.width - woset;
			if (pRatio) {
				that.size.height = that.size.width / that.aspectRatio;
			}
		}

		if (hoset + that.size.height >= that.parentData.height) {
			that.size.height = that.parentData.height - hoset;
			if (pRatio) {
				that.size.width = that.size.height * that.aspectRatio;
			}
		}
	},

	stop: function(){
		var that = $(this).data("ui-resizable"),
			o = that.options,
			co = that.containerOffset,
			cop = that.containerPosition,
			ce = that.containerElement,
			helper = $(that.helper),
			ho = helper.offset(),
			w = helper.outerWidth() - that.sizeDiff.width,
			h = helper.outerHeight() - that.sizeDiff.height;

		if (that._helper && !o.animate && (/relative/).test(ce.css("position"))) {
			$(this).css({ left: ho.left - cop.left - co.left, width: w, height: h });
		}

		if (that._helper && !o.animate && (/static/).test(ce.css("position"))) {
			$(this).css({ left: ho.left - cop.left - co.left, width: w, height: h });
		}

	}
});

$.ui.plugin.add("resizable", "alsoResize", {

	start: function () {
		var that = $(this).data("ui-resizable"),
			o = that.options,
			_store = function (exp) {
				$(exp).each(function() {
					var el = $(this);
					el.data("ui-resizable-alsoresize", {
						width: parseInt(el.width(), 10), height: parseInt(el.height(), 10),
						left: parseInt(el.css("left"), 10), top: parseInt(el.css("top"), 10)
					});
				});
			};

		if (typeof(o.alsoResize) === "object" && !o.alsoResize.parentNode) {
			if (o.alsoResize.length) { o.alsoResize = o.alsoResize[0]; _store(o.alsoResize); }
			else { $.each(o.alsoResize, function (exp) { _store(exp); }); }
		}else{
			_store(o.alsoResize);
		}
	},

	resize: function (event, ui) {
		var that = $(this).data("ui-resizable"),
			o = that.options,
			os = that.originalSize,
			op = that.originalPosition,
			delta = {
				height: (that.size.height - os.height) || 0, width: (that.size.width - os.width) || 0,
				top: (that.position.top - op.top) || 0, left: (that.position.left - op.left) || 0
			},

			_alsoResize = function (exp, c) {
				$(exp).each(function() {
					var el = $(this), start = $(this).data("ui-resizable-alsoresize"), style = {},
						css = c && c.length ? c : el.parents(ui.originalElement[0]).length ? ["width", "height"] : ["width", "height", "top", "left"];

					$.each(css, function (i, prop) {
						var sum = (start[prop]||0) + (delta[prop]||0);
						if (sum && sum >= 0) {
							style[prop] = sum || null;
						}
					});

					el.css(style);
				});
			};

		if (typeof(o.alsoResize) === "object" && !o.alsoResize.nodeType) {
			$.each(o.alsoResize, function (exp, c) { _alsoResize(exp, c); });
		}else{
			_alsoResize(o.alsoResize);
		}
	},

	stop: function () {
		$(this).removeData("resizable-alsoresize");
	}
});

$.ui.plugin.add("resizable", "ghost", {

	start: function() {

		var that = $(this).data("ui-resizable"), o = that.options, cs = that.size;

		that.ghost = that.originalElement.clone();
		that.ghost
			.css({ opacity: 0.25, display: "block", position: "relative", height: cs.height, width: cs.width, margin: 0, left: 0, top: 0 })
			.addClass("ui-resizable-ghost")
			.addClass(typeof o.ghost === "string" ? o.ghost : "");

		that.ghost.appendTo(that.helper);

	},

	resize: function(){
		var that = $(this).data("ui-resizable");
		if (that.ghost) {
			that.ghost.css({ position: "relative", height: that.size.height, width: that.size.width });
		}
	},

	stop: function() {
		var that = $(this).data("ui-resizable");
		if (that.ghost && that.helper) {
			that.helper.get(0).removeChild(that.ghost.get(0));
		}
	}

});

$.ui.plugin.add("resizable", "grid", {

	resize: function() {
		var that = $(this).data("ui-resizable"),
			o = that.options,
			cs = that.size,
			os = that.originalSize,
			op = that.originalPosition,
			a = that.axis,
			grid = typeof o.grid === "number" ? [o.grid, o.grid] : o.grid,
			gridX = (grid[0]||1),
			gridY = (grid[1]||1),
			ox = Math.round((cs.width - os.width) / gridX) * gridX,
			oy = Math.round((cs.height - os.height) / gridY) * gridY,
			newWidth = os.width + ox,
			newHeight = os.height + oy,
			isMaxWidth = o.maxWidth && (o.maxWidth < newWidth),
			isMaxHeight = o.maxHeight && (o.maxHeight < newHeight),
			isMinWidth = o.minWidth && (o.minWidth > newWidth),
			isMinHeight = o.minHeight && (o.minHeight > newHeight);

		o.grid = grid;

		if (isMinWidth) {
			newWidth = newWidth + gridX;
		}
		if (isMinHeight) {
			newHeight = newHeight + gridY;
		}
		if (isMaxWidth) {
			newWidth = newWidth - gridX;
		}
		if (isMaxHeight) {
			newHeight = newHeight - gridY;
		}

		if (/^(se|s|e)$/.test(a)) {
			that.size.width = newWidth;
			that.size.height = newHeight;
		} else if (/^(ne)$/.test(a)) {
			that.size.width = newWidth;
			that.size.height = newHeight;
			that.position.top = op.top - oy;
		} else if (/^(sw)$/.test(a)) {
			that.size.width = newWidth;
			that.size.height = newHeight;
			that.position.left = op.left - ox;
		} else {
			that.size.width = newWidth;
			that.size.height = newHeight;
			that.position.top = op.top - oy;
			that.position.left = op.left - ox;
		}
	}

});

})(jQuery);
/*!
 * jQuery UI Selectable 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/selectable/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 */
(function( $, undefined ) {

$.widget("ui.selectable", $.ui.mouse, {
	version: "1.10.3",
	options: {
		appendTo: "body",
		autoRefresh: true,
		distance: 0,
		filter: "*",
		tolerance: "touch",

		// callbacks
		selected: null,
		selecting: null,
		start: null,
		stop: null,
		unselected: null,
		unselecting: null
	},
	_create: function() {
		var selectees,
			that = this;

		this.element.addClass("ui-selectable");

		this.dragged = false;

		// cache selectee children based on filter
		this.refresh = function() {
			selectees = $(that.options.filter, that.element[0]);
			selectees.addClass("ui-selectee");
			selectees.each(function() {
				var $this = $(this),
					pos = $this.offset();
				$.data(this, "selectable-item", {
					element: this,
					$element: $this,
					left: pos.left,
					top: pos.top,
					right: pos.left + $this.outerWidth(),
					bottom: pos.top + $this.outerHeight(),
					startselected: false,
					selected: $this.hasClass("ui-selected"),
					selecting: $this.hasClass("ui-selecting"),
					unselecting: $this.hasClass("ui-unselecting")
				});
			});
		};
		this.refresh();

		this.selectees = selectees.addClass("ui-selectee");

		this._mouseInit();

		this.helper = $("<div class='ui-selectable-helper'></div>");
	},

	_destroy: function() {
		this.selectees
			.removeClass("ui-selectee")
			.removeData("selectable-item");
		this.element
			.removeClass("ui-selectable ui-selectable-disabled");
		this._mouseDestroy();
	},

	_mouseStart: function(event) {
		var that = this,
			options = this.options;

		this.opos = [event.pageX, event.pageY];

		if (this.options.disabled) {
			return;
		}

		this.selectees = $(options.filter, this.element[0]);

		this._trigger("start", event);

		$(options.appendTo).append(this.helper);
		// position helper (lasso)
		this.helper.css({
			"left": event.pageX,
			"top": event.pageY,
			"width": 0,
			"height": 0
		});

		if (options.autoRefresh) {
			this.refresh();
		}

		this.selectees.filter(".ui-selected").each(function() {
			var selectee = $.data(this, "selectable-item");
			selectee.startselected = true;
			if (!event.metaKey && !event.ctrlKey) {
				selectee.$element.removeClass("ui-selected");
				selectee.selected = false;
				selectee.$element.addClass("ui-unselecting");
				selectee.unselecting = true;
				// selectable UNSELECTING callback
				that._trigger("unselecting", event, {
					unselecting: selectee.element
				});
			}
		});

		$(event.target).parents().addBack().each(function() {
			var doSelect,
				selectee = $.data(this, "selectable-item");
			if (selectee) {
				doSelect = (!event.metaKey && !event.ctrlKey) || !selectee.$element.hasClass("ui-selected");
				selectee.$element
					.removeClass(doSelect ? "ui-unselecting" : "ui-selected")
					.addClass(doSelect ? "ui-selecting" : "ui-unselecting");
				selectee.unselecting = !doSelect;
				selectee.selecting = doSelect;
				selectee.selected = doSelect;
				// selectable (UN)SELECTING callback
				if (doSelect) {
					that._trigger("selecting", event, {
						selecting: selectee.element
					});
				} else {
					that._trigger("unselecting", event, {
						unselecting: selectee.element
					});
				}
				return false;
			}
		});

	},

	_mouseDrag: function(event) {

		this.dragged = true;

		if (this.options.disabled) {
			return;
		}

		var tmp,
			that = this,
			options = this.options,
			x1 = this.opos[0],
			y1 = this.opos[1],
			x2 = event.pageX,
			y2 = event.pageY;

		if (x1 > x2) { tmp = x2; x2 = x1; x1 = tmp; }
		if (y1 > y2) { tmp = y2; y2 = y1; y1 = tmp; }
		this.helper.css({left: x1, top: y1, width: x2-x1, height: y2-y1});

		this.selectees.each(function() {
			var selectee = $.data(this, "selectable-item"),
				hit = false;

			//prevent helper from being selected if appendTo: selectable
			if (!selectee || selectee.element === that.element[0]) {
				return;
			}

			if (options.tolerance === "touch") {
				hit = ( !(selectee.left > x2 || selectee.right < x1 || selectee.top > y2 || selectee.bottom < y1) );
			} else if (options.tolerance === "fit") {
				hit = (selectee.left > x1 && selectee.right < x2 && selectee.top > y1 && selectee.bottom < y2);
			}

			if (hit) {
				// SELECT
				if (selectee.selected) {
					selectee.$element.removeClass("ui-selected");
					selectee.selected = false;
				}
				if (selectee.unselecting) {
					selectee.$element.removeClass("ui-unselecting");
					selectee.unselecting = false;
				}
				if (!selectee.selecting) {
					selectee.$element.addClass("ui-selecting");
					selectee.selecting = true;
					// selectable SELECTING callback
					that._trigger("selecting", event, {
						selecting: selectee.element
					});
				}
			} else {
				// UNSELECT
				if (selectee.selecting) {
					if ((event.metaKey || event.ctrlKey) && selectee.startselected) {
						selectee.$element.removeClass("ui-selecting");
						selectee.selecting = false;
						selectee.$element.addClass("ui-selected");
						selectee.selected = true;
					} else {
						selectee.$element.removeClass("ui-selecting");
						selectee.selecting = false;
						if (selectee.startselected) {
							selectee.$element.addClass("ui-unselecting");
							selectee.unselecting = true;
						}
						// selectable UNSELECTING callback
						that._trigger("unselecting", event, {
							unselecting: selectee.element
						});
					}
				}
				if (selectee.selected) {
					if (!event.metaKey && !event.ctrlKey && !selectee.startselected) {
						selectee.$element.removeClass("ui-selected");
						selectee.selected = false;

						selectee.$element.addClass("ui-unselecting");
						selectee.unselecting = true;
						// selectable UNSELECTING callback
						that._trigger("unselecting", event, {
							unselecting: selectee.element
						});
					}
				}
			}
		});

		return false;
	},

	_mouseStop: function(event) {
		var that = this;

		this.dragged = false;

		$(".ui-unselecting", this.element[0]).each(function() {
			var selectee = $.data(this, "selectable-item");
			selectee.$element.removeClass("ui-unselecting");
			selectee.unselecting = false;
			selectee.startselected = false;
			that._trigger("unselected", event, {
				unselected: selectee.element
			});
		});
		$(".ui-selecting", this.element[0]).each(function() {
			var selectee = $.data(this, "selectable-item");
			selectee.$element.removeClass("ui-selecting").addClass("ui-selected");
			selectee.selecting = false;
			selectee.selected = true;
			selectee.startselected = true;
			that._trigger("selected", event, {
				selected: selectee.element
			});
		});
		this._trigger("stop", event);

		this.helper.remove();

		return false;
	}

});

})(jQuery);
/*!
 * jQuery UI Sortable 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/sortable/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 */
(function( $, undefined ) {

/*jshint loopfunc: true */

function isOverAxis( x, reference, size ) {
	return ( x > reference ) && ( x < ( reference + size ) );
}

function isFloating(item) {
	return (/left|right/).test(item.css("float")) || (/inline|table-cell/).test(item.css("display"));
}

$.widget("ui.sortable", $.ui.mouse, {
	version: "1.10.3",
	widgetEventPrefix: "sort",
	ready: false,
	options: {
		appendTo: "parent",
		axis: false,
		connectWith: false,
		containment: false,
		cursor: "auto",
		cursorAt: false,
		dropOnEmpty: true,
		forcePlaceholderSize: false,
		forceHelperSize: false,
		grid: false,
		handle: false,
		helper: "original",
		items: "> *",
		opacity: false,
		placeholder: false,
		revert: false,
		scroll: true,
		scrollSensitivity: 20,
		scrollSpeed: 20,
		scope: "default",
		tolerance: "intersect",
		zIndex: 1000,

		// callbacks
		activate: null,
		beforeStop: null,
		change: null,
		deactivate: null,
		out: null,
		over: null,
		receive: null,
		remove: null,
		sort: null,
		start: null,
		stop: null,
		update: null
	},
	_create: function() {

		var o = this.options;
		this.containerCache = {};
		this.element.addClass("ui-sortable");

		//Get the items
		this.refresh();

		//Let's determine if the items are being displayed horizontally
		this.floating = this.items.length ? o.axis === "x" || isFloating(this.items[0].item) : false;

		//Let's determine the parent's offset
		this.offset = this.element.offset();

		//Initialize mouse events for interaction
		this._mouseInit();

		//We're ready to go
		this.ready = true;

	},

	_destroy: function() {
		this.element
			.removeClass("ui-sortable ui-sortable-disabled");
		this._mouseDestroy();

		for ( var i = this.items.length - 1; i >= 0; i-- ) {
			this.items[i].item.removeData(this.widgetName + "-item");
		}

		return this;
	},

	_setOption: function(key, value){
		if ( key === "disabled" ) {
			this.options[ key ] = value;

			this.widget().toggleClass( "ui-sortable-disabled", !!value );
		} else {
			// Don't call widget base _setOption for disable as it adds ui-state-disabled class
			$.Widget.prototype._setOption.apply(this, arguments);
		}
	},

	_mouseCapture: function(event, overrideHandle) {
		var currentItem = null,
			validHandle = false,
			that = this;

		if (this.reverting) {
			return false;
		}

		if(this.options.disabled || this.options.type === "static") {
			return false;
		}

		//We have to refresh the items data once first
		this._refreshItems(event);

		//Find out if the clicked node (or one of its parents) is a actual item in this.items
		$(event.target).parents().each(function() {
			if($.data(this, that.widgetName + "-item") === that) {
				currentItem = $(this);
				return false;
			}
		});
		if($.data(event.target, that.widgetName + "-item") === that) {
			currentItem = $(event.target);
		}

		if(!currentItem) {
			return false;
		}
		if(this.options.handle && !overrideHandle) {
			$(this.options.handle, currentItem).find("*").addBack().each(function() {
				if(this === event.target) {
					validHandle = true;
				}
			});
			if(!validHandle) {
				return false;
			}
		}

		this.currentItem = currentItem;
		this._removeCurrentsFromItems();
		return true;

	},

	_mouseStart: function(event, overrideHandle, noActivation) {

		var i, body,
			o = this.options;

		this.currentContainer = this;

		//We only need to call refreshPositions, because the refreshItems call has been moved to mouseCapture
		this.refreshPositions();

		//Create and append the visible helper
		this.helper = this._createHelper(event);

		//Cache the helper size
		this._cacheHelperProportions();

		/*
		 * - Position generation -
		 * This block generates everything position related - it's the core of draggables.
		 */

		//Cache the margins of the original element
		this._cacheMargins();

		//Get the next scrolling parent
		this.scrollParent = this.helper.scrollParent();

		//The element's absolute position on the page minus margins
		this.offset = this.currentItem.offset();
		this.offset = {
			top: this.offset.top - this.margins.top,
			left: this.offset.left - this.margins.left
		};

		$.extend(this.offset, {
			click: { //Where the click happened, relative to the element
				left: event.pageX - this.offset.left,
				top: event.pageY - this.offset.top
			},
			parent: this._getParentOffset(),
			relative: this._getRelativeOffset() //This is a relative to absolute position minus the actual position calculation - only used for relative positioned helper
		});

		// Only after we got the offset, we can change the helper's position to absolute
		// TODO: Still need to figure out a way to make relative sorting possible
		this.helper.css("position", "absolute");
		this.cssPosition = this.helper.css("position");

		//Generate the original position
		this.originalPosition = this._generatePosition(event);
		this.originalPageX = event.pageX;
		this.originalPageY = event.pageY;

		//Adjust the mouse offset relative to the helper if "cursorAt" is supplied
		(o.cursorAt && this._adjustOffsetFromHelper(o.cursorAt));

		//Cache the former DOM position
		this.domPosition = { prev: this.currentItem.prev()[0], parent: this.currentItem.parent()[0] };

		//If the helper is not the original, hide the original so it's not playing any role during the drag, won't cause anything bad this way
		if(this.helper[0] !== this.currentItem[0]) {
			this.currentItem.hide();
		}

		//Create the placeholder
		this._createPlaceholder();

		//Set a containment if given in the options
		if(o.containment) {
			this._setContainment();
		}

		if( o.cursor && o.cursor !== "auto" ) { // cursor option
			body = this.document.find( "body" );

			// support: IE
			this.storedCursor = body.css( "cursor" );
			body.css( "cursor", o.cursor );

			this.storedStylesheet = $( "<style>*{ cursor: "+o.cursor+" !important; }</style>" ).appendTo( body );
		}

		if(o.opacity) { // opacity option
			if (this.helper.css("opacity")) {
				this._storedOpacity = this.helper.css("opacity");
			}
			this.helper.css("opacity", o.opacity);
		}

		if(o.zIndex) { // zIndex option
			if (this.helper.css("zIndex")) {
				this._storedZIndex = this.helper.css("zIndex");
			}
			this.helper.css("zIndex", o.zIndex);
		}

		//Prepare scrolling
		if(this.scrollParent[0] !== document && this.scrollParent[0].tagName !== "HTML") {
			this.overflowOffset = this.scrollParent.offset();
		}

		//Call callbacks
		this._trigger("start", event, this._uiHash());

		//Recache the helper size
		if(!this._preserveHelperProportions) {
			this._cacheHelperProportions();
		}


		//Post "activate" events to possible containers
		if( !noActivation ) {
			for ( i = this.containers.length - 1; i >= 0; i-- ) {
				this.containers[ i ]._trigger( "activate", event, this._uiHash( this ) );
			}
		}

		//Prepare possible droppables
		if($.ui.ddmanager) {
			$.ui.ddmanager.current = this;
		}

		if ($.ui.ddmanager && !o.dropBehaviour) {
			$.ui.ddmanager.prepareOffsets(this, event);
		}

		this.dragging = true;

		this.helper.addClass("ui-sortable-helper");
		this._mouseDrag(event); //Execute the drag once - this causes the helper not to be visible before getting its correct position
		return true;

	},

	_mouseDrag: function(event) {
		var i, item, itemElement, intersection,
			o = this.options,
			scrolled = false;

		//Compute the helpers position
		this.position = this._generatePosition(event);
		this.positionAbs = this._convertPositionTo("absolute");

		if (!this.lastPositionAbs) {
			this.lastPositionAbs = this.positionAbs;
		}

		//Do scrolling
		if(this.options.scroll) {
			if(this.scrollParent[0] !== document && this.scrollParent[0].tagName !== "HTML") {

				if((this.overflowOffset.top + this.scrollParent[0].offsetHeight) - event.pageY < o.scrollSensitivity) {
					this.scrollParent[0].scrollTop = scrolled = this.scrollParent[0].scrollTop + o.scrollSpeed;
				} else if(event.pageY - this.overflowOffset.top < o.scrollSensitivity) {
					this.scrollParent[0].scrollTop = scrolled = this.scrollParent[0].scrollTop - o.scrollSpeed;
				}

				if((this.overflowOffset.left + this.scrollParent[0].offsetWidth) - event.pageX < o.scrollSensitivity) {
					this.scrollParent[0].scrollLeft = scrolled = this.scrollParent[0].scrollLeft + o.scrollSpeed;
				} else if(event.pageX - this.overflowOffset.left < o.scrollSensitivity) {
					this.scrollParent[0].scrollLeft = scrolled = this.scrollParent[0].scrollLeft - o.scrollSpeed;
				}

			} else {

				if(event.pageY - $(document).scrollTop() < o.scrollSensitivity) {
					scrolled = $(document).scrollTop($(document).scrollTop() - o.scrollSpeed);
				} else if($(window).height() - (event.pageY - $(document).scrollTop()) < o.scrollSensitivity) {
					scrolled = $(document).scrollTop($(document).scrollTop() + o.scrollSpeed);
				}

				if(event.pageX - $(document).scrollLeft() < o.scrollSensitivity) {
					scrolled = $(document).scrollLeft($(document).scrollLeft() - o.scrollSpeed);
				} else if($(window).width() - (event.pageX - $(document).scrollLeft()) < o.scrollSensitivity) {
					scrolled = $(document).scrollLeft($(document).scrollLeft() + o.scrollSpeed);
				}

			}

			if(scrolled !== false && $.ui.ddmanager && !o.dropBehaviour) {
				$.ui.ddmanager.prepareOffsets(this, event);
			}
		}

		//Regenerate the absolute position used for position checks
		this.positionAbs = this._convertPositionTo("absolute");

		//Set the helper position
		if(!this.options.axis || this.options.axis !== "y") {
			this.helper[0].style.left = this.position.left+"px";
		}
		if(!this.options.axis || this.options.axis !== "x") {
			this.helper[0].style.top = this.position.top+"px";
		}

		//Rearrange
		for (i = this.items.length - 1; i >= 0; i--) {

			//Cache variables and intersection, continue if no intersection
			item = this.items[i];
			itemElement = item.item[0];
			intersection = this._intersectsWithPointer(item);
			if (!intersection) {
				continue;
			}

			// Only put the placeholder inside the current Container, skip all
			// items form other containers. This works because when moving
			// an item from one container to another the
			// currentContainer is switched before the placeholder is moved.
			//
			// Without this moving items in "sub-sortables" can cause the placeholder to jitter
			// beetween the outer and inner container.
			if (item.instance !== this.currentContainer) {
				continue;
			}

			// cannot intersect with itself
			// no useless actions that have been done before
			// no action if the item moved is the parent of the item checked
			if (itemElement !== this.currentItem[0] &&
				this.placeholder[intersection === 1 ? "next" : "prev"]()[0] !== itemElement &&
				!$.contains(this.placeholder[0], itemElement) &&
				(this.options.type === "semi-dynamic" ? !$.contains(this.element[0], itemElement) : true)
			) {

				this.direction = intersection === 1 ? "down" : "up";

				if (this.options.tolerance === "pointer" || this._intersectsWithSides(item)) {
					this._rearrange(event, item);
				} else {
					break;
				}

				this._trigger("change", event, this._uiHash());
				break;
			}
		}

		//Post events to containers
		this._contactContainers(event);

		//Interconnect with droppables
		if($.ui.ddmanager) {
			$.ui.ddmanager.drag(this, event);
		}

		//Call callbacks
		this._trigger("sort", event, this._uiHash());

		this.lastPositionAbs = this.positionAbs;
		return false;

	},

	_mouseStop: function(event, noPropagation) {

		if(!event) {
			return;
		}

		//If we are using droppables, inform the manager about the drop
		if ($.ui.ddmanager && !this.options.dropBehaviour) {
			$.ui.ddmanager.drop(this, event);
		}

		if(this.options.revert) {
			var that = this,
				cur = this.placeholder.offset(),
				axis = this.options.axis,
				animation = {};

			if ( !axis || axis === "x" ) {
				animation.left = cur.left - this.offset.parent.left - this.margins.left + (this.offsetParent[0] === document.body ? 0 : this.offsetParent[0].scrollLeft);
			}
			if ( !axis || axis === "y" ) {
				animation.top = cur.top - this.offset.parent.top - this.margins.top + (this.offsetParent[0] === document.body ? 0 : this.offsetParent[0].scrollTop);
			}
			this.reverting = true;
			$(this.helper).animate( animation, parseInt(this.options.revert, 10) || 500, function() {
				that._clear(event);
			});
		} else {
			this._clear(event, noPropagation);
		}

		return false;

	},

	cancel: function() {

		if(this.dragging) {

			this._mouseUp({ target: null });

			if(this.options.helper === "original") {
				this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper");
			} else {
				this.currentItem.show();
			}

			//Post deactivating events to containers
			for (var i = this.containers.length - 1; i >= 0; i--){
				this.containers[i]._trigger("deactivate", null, this._uiHash(this));
				if(this.containers[i].containerCache.over) {
					this.containers[i]._trigger("out", null, this._uiHash(this));
					this.containers[i].containerCache.over = 0;
				}
			}

		}

		if (this.placeholder) {
			//$(this.placeholder[0]).remove(); would have been the jQuery way - unfortunately, it unbinds ALL events from the original node!
			if(this.placeholder[0].parentNode) {
				this.placeholder[0].parentNode.removeChild(this.placeholder[0]);
			}
			if(this.options.helper !== "original" && this.helper && this.helper[0].parentNode) {
				this.helper.remove();
			}

			$.extend(this, {
				helper: null,
				dragging: false,
				reverting: false,
				_noFinalSort: null
			});

			if(this.domPosition.prev) {
				$(this.domPosition.prev).after(this.currentItem);
			} else {
				$(this.domPosition.parent).prepend(this.currentItem);
			}
		}

		return this;

	},

	serialize: function(o) {

		var items = this._getItemsAsjQuery(o && o.connected),
			str = [];
		o = o || {};

		$(items).each(function() {
			var res = ($(o.item || this).attr(o.attribute || "id") || "").match(o.expression || (/(.+)[\-=_](.+)/));
			if (res) {
				str.push((o.key || res[1]+"[]")+"="+(o.key && o.expression ? res[1] : res[2]));
			}
		});

		if(!str.length && o.key) {
			str.push(o.key + "=");
		}

		return str.join("&");

	},

	toArray: function(o) {

		var items = this._getItemsAsjQuery(o && o.connected),
			ret = [];

		o = o || {};

		items.each(function() { ret.push($(o.item || this).attr(o.attribute || "id") || ""); });
		return ret;

	},

	/* Be careful with the following core functions */
	_intersectsWith: function(item) {

		var x1 = this.positionAbs.left,
			x2 = x1 + this.helperProportions.width,
			y1 = this.positionAbs.top,
			y2 = y1 + this.helperProportions.height,
			l = item.left,
			r = l + item.width,
			t = item.top,
			b = t + item.height,
			dyClick = this.offset.click.top,
			dxClick = this.offset.click.left,
			isOverElementHeight = ( this.options.axis === "x" ) || ( ( y1 + dyClick ) > t && ( y1 + dyClick ) < b ),
			isOverElementWidth = ( this.options.axis === "y" ) || ( ( x1 + dxClick ) > l && ( x1 + dxClick ) < r ),
			isOverElement = isOverElementHeight && isOverElementWidth;

		if ( this.options.tolerance === "pointer" ||
			this.options.forcePointerForContainers ||
			(this.options.tolerance !== "pointer" && this.helperProportions[this.floating ? "width" : "height"] > item[this.floating ? "width" : "height"])
		) {
			return isOverElement;
		} else {

			return (l < x1 + (this.helperProportions.width / 2) && // Right Half
				x2 - (this.helperProportions.width / 2) < r && // Left Half
				t < y1 + (this.helperProportions.height / 2) && // Bottom Half
				y2 - (this.helperProportions.height / 2) < b ); // Top Half

		}
	},

	_intersectsWithPointer: function(item) {

		var isOverElementHeight = (this.options.axis === "x") || isOverAxis(this.positionAbs.top + this.offset.click.top, item.top, item.height),
			isOverElementWidth = (this.options.axis === "y") || isOverAxis(this.positionAbs.left + this.offset.click.left, item.left, item.width),
			isOverElement = isOverElementHeight && isOverElementWidth,
			verticalDirection = this._getDragVerticalDirection(),
			horizontalDirection = this._getDragHorizontalDirection();

		if (!isOverElement) {
			return false;
		}

		return this.floating ?
			( ((horizontalDirection && horizontalDirection === "right") || verticalDirection === "down") ? 2 : 1 )
			: ( verticalDirection && (verticalDirection === "down" ? 2 : 1) );

	},

	_intersectsWithSides: function(item) {

		var isOverBottomHalf = isOverAxis(this.positionAbs.top + this.offset.click.top, item.top + (item.height/2), item.height),
			isOverRightHalf = isOverAxis(this.positionAbs.left + this.offset.click.left, item.left + (item.width/2), item.width),
			verticalDirection = this._getDragVerticalDirection(),
			horizontalDirection = this._getDragHorizontalDirection();

		if (this.floating && horizontalDirection) {
			return ((horizontalDirection === "right" && isOverRightHalf) || (horizontalDirection === "left" && !isOverRightHalf));
		} else {
			return verticalDirection && ((verticalDirection === "down" && isOverBottomHalf) || (verticalDirection === "up" && !isOverBottomHalf));
		}

	},

	_getDragVerticalDirection: function() {
		var delta = this.positionAbs.top - this.lastPositionAbs.top;
		return delta !== 0 && (delta > 0 ? "down" : "up");
	},

	_getDragHorizontalDirection: function() {
		var delta = this.positionAbs.left - this.lastPositionAbs.left;
		return delta !== 0 && (delta > 0 ? "right" : "left");
	},

	refresh: function(event) {
		this._refreshItems(event);
		this.refreshPositions();
		return this;
	},

	_connectWith: function() {
		var options = this.options;
		return options.connectWith.constructor === String ? [options.connectWith] : options.connectWith;
	},

	_getItemsAsjQuery: function(connected) {

		var i, j, cur, inst,
			items = [],
			queries = [],
			connectWith = this._connectWith();

		if(connectWith && connected) {
			for (i = connectWith.length - 1; i >= 0; i--){
				cur = $(connectWith[i]);
				for ( j = cur.length - 1; j >= 0; j--){
					inst = $.data(cur[j], this.widgetFullName);
					if(inst && inst !== this && !inst.options.disabled) {
						queries.push([$.isFunction(inst.options.items) ? inst.options.items.call(inst.element) : $(inst.options.items, inst.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"), inst]);
					}
				}
			}
		}

		queries.push([$.isFunction(this.options.items) ? this.options.items.call(this.element, null, { options: this.options, item: this.currentItem }) : $(this.options.items, this.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"), this]);

		for (i = queries.length - 1; i >= 0; i--){
			queries[i][0].each(function() {
				items.push(this);
			});
		}

		return $(items);

	},

	_removeCurrentsFromItems: function() {

		var list = this.currentItem.find(":data(" + this.widgetName + "-item)");

		this.items = $.grep(this.items, function (item) {
			for (var j=0; j < list.length; j++) {
				if(list[j] === item.item[0]) {
					return false;
				}
			}
			return true;
		});

	},

	_refreshItems: function(event) {

		this.items = [];
		this.containers = [this];

		var i, j, cur, inst, targetData, _queries, item, queriesLength,
			items = this.items,
			queries = [[$.isFunction(this.options.items) ? this.options.items.call(this.element[0], event, { item: this.currentItem }) : $(this.options.items, this.element), this]],
			connectWith = this._connectWith();

		if(connectWith && this.ready) { //Shouldn't be run the first time through due to massive slow-down
			for (i = connectWith.length - 1; i >= 0; i--){
				cur = $(connectWith[i]);
				for (j = cur.length - 1; j >= 0; j--){
					inst = $.data(cur[j], this.widgetFullName);
					if(inst && inst !== this && !inst.options.disabled) {
						queries.push([$.isFunction(inst.options.items) ? inst.options.items.call(inst.element[0], event, { item: this.currentItem }) : $(inst.options.items, inst.element), inst]);
						this.containers.push(inst);
					}
				}
			}
		}

		for (i = queries.length - 1; i >= 0; i--) {
			targetData = queries[i][1];
			_queries = queries[i][0];

			for (j=0, queriesLength = _queries.length; j < queriesLength; j++) {
				item = $(_queries[j]);

				item.data(this.widgetName + "-item", targetData); // Data for target checking (mouse manager)

				items.push({
					item: item,
					instance: targetData,
					width: 0, height: 0,
					left: 0, top: 0
				});
			}
		}

	},

	refreshPositions: function(fast) {

		//This has to be redone because due to the item being moved out/into the offsetParent, the offsetParent's position will change
		if(this.offsetParent && this.helper) {
			this.offset.parent = this._getParentOffset();
		}

		var i, item, t, p;

		for (i = this.items.length - 1; i >= 0; i--){
			item = this.items[i];

			//We ignore calculating positions of all connected containers when we're not over them
			if(item.instance !== this.currentContainer && this.currentContainer && item.item[0] !== this.currentItem[0]) {
				continue;
			}

			t = this.options.toleranceElement ? $(this.options.toleranceElement, item.item) : item.item;

			if (!fast) {
				item.width = t.outerWidth();
				item.height = t.outerHeight();
			}

			p = t.offset();
			item.left = p.left;
			item.top = p.top;
		}

		if(this.options.custom && this.options.custom.refreshContainers) {
			this.options.custom.refreshContainers.call(this);
		} else {
			for (i = this.containers.length - 1; i >= 0; i--){
				p = this.containers[i].element.offset();
				this.containers[i].containerCache.left = p.left;
				this.containers[i].containerCache.top = p.top;
				this.containers[i].containerCache.width	= this.containers[i].element.outerWidth();
				this.containers[i].containerCache.height = this.containers[i].element.outerHeight();
			}
		}

		return this;
	},

	_createPlaceholder: function(that) {
		that = that || this;
		var className,
			o = that.options;

		if(!o.placeholder || o.placeholder.constructor === String) {
			className = o.placeholder;
			o.placeholder = {
				element: function() {

					var nodeName = that.currentItem[0].nodeName.toLowerCase(),
						element = $( "<" + nodeName + ">", that.document[0] )
							.addClass(className || that.currentItem[0].className+" ui-sortable-placeholder")
							.removeClass("ui-sortable-helper");

					if ( nodeName === "tr" ) {
						that.currentItem.children().each(function() {
							$( "<td>&#160;</td>", that.document[0] )
								.attr( "colspan", $( this ).attr( "colspan" ) || 1 )
								.appendTo( element );
						});
					} else if ( nodeName === "img" ) {
						element.attr( "src", that.currentItem.attr( "src" ) );
					}

					if ( !className ) {
						element.css( "visibility", "hidden" );
					}

					return element;
				},
				update: function(container, p) {

					// 1. If a className is set as 'placeholder option, we don't force sizes - the class is responsible for that
					// 2. The option 'forcePlaceholderSize can be enabled to force it even if a class name is specified
					if(className && !o.forcePlaceholderSize) {
						return;
					}

					//If the element doesn't have a actual height by itself (without styles coming from a stylesheet), it receives the inline height from the dragged item
					if(!p.height()) { p.height(that.currentItem.innerHeight() - parseInt(that.currentItem.css("paddingTop")||0, 10) - parseInt(that.currentItem.css("paddingBottom")||0, 10)); }
					if(!p.width()) { p.width(that.currentItem.innerWidth() - parseInt(that.currentItem.css("paddingLeft")||0, 10) - parseInt(that.currentItem.css("paddingRight")||0, 10)); }
				}
			};
		}

		//Create the placeholder
		that.placeholder = $(o.placeholder.element.call(that.element, that.currentItem));

		//Append it after the actual current item
		that.currentItem.after(that.placeholder);

		//Update the size of the placeholder (TODO: Logic to fuzzy, see line 316/317)
		o.placeholder.update(that, that.placeholder);

	},

	_contactContainers: function(event) {
		var i, j, dist, itemWithLeastDistance, posProperty, sizeProperty, base, cur, nearBottom, floating,
			innermostContainer = null,
			innermostIndex = null;

		// get innermost container that intersects with item
		for (i = this.containers.length - 1; i >= 0; i--) {

			// never consider a container that's located within the item itself
			if($.contains(this.currentItem[0], this.containers[i].element[0])) {
				continue;
			}

			if(this._intersectsWith(this.containers[i].containerCache)) {

				// if we've already found a container and it's more "inner" than this, then continue
				if(innermostContainer && $.contains(this.containers[i].element[0], innermostContainer.element[0])) {
					continue;
				}

				innermostContainer = this.containers[i];
				innermostIndex = i;

			} else {
				// container doesn't intersect. trigger "out" event if necessary
				if(this.containers[i].containerCache.over) {
					this.containers[i]._trigger("out", event, this._uiHash(this));
					this.containers[i].containerCache.over = 0;
				}
			}

		}

		// if no intersecting containers found, return
		if(!innermostContainer) {
			return;
		}

		// move the item into the container if it's not there already
		if(this.containers.length === 1) {
			if (!this.containers[innermostIndex].containerCache.over) {
				this.containers[innermostIndex]._trigger("over", event, this._uiHash(this));
				this.containers[innermostIndex].containerCache.over = 1;
			}
		} else {

			//When entering a new container, we will find the item with the least distance and append our item near it
			dist = 10000;
			itemWithLeastDistance = null;
			floating = innermostContainer.floating || isFloating(this.currentItem);
			posProperty = floating ? "left" : "top";
			sizeProperty = floating ? "width" : "height";
			base = this.positionAbs[posProperty] + this.offset.click[posProperty];
			for (j = this.items.length - 1; j >= 0; j--) {
				if(!$.contains(this.containers[innermostIndex].element[0], this.items[j].item[0])) {
					continue;
				}
				if(this.items[j].item[0] === this.currentItem[0]) {
					continue;
				}
				if (floating && !isOverAxis(this.positionAbs.top + this.offset.click.top, this.items[j].top, this.items[j].height)) {
					continue;
				}
				cur = this.items[j].item.offset()[posProperty];
				nearBottom = false;
				if(Math.abs(cur - base) > Math.abs(cur + this.items[j][sizeProperty] - base)){
					nearBottom = true;
					cur += this.items[j][sizeProperty];
				}

				if(Math.abs(cur - base) < dist) {
					dist = Math.abs(cur - base); itemWithLeastDistance = this.items[j];
					this.direction = nearBottom ? "up": "down";
				}
			}

			//Check if dropOnEmpty is enabled
			if(!itemWithLeastDistance && !this.options.dropOnEmpty) {
				return;
			}

			if(this.currentContainer === this.containers[innermostIndex]) {
				return;
			}

			itemWithLeastDistance ? this._rearrange(event, itemWithLeastDistance, null, true) : this._rearrange(event, null, this.containers[innermostIndex].element, true);
			this._trigger("change", event, this._uiHash());
			this.containers[innermostIndex]._trigger("change", event, this._uiHash(this));
			this.currentContainer = this.containers[innermostIndex];

			//Update the placeholder
			this.options.placeholder.update(this.currentContainer, this.placeholder);

			this.containers[innermostIndex]._trigger("over", event, this._uiHash(this));
			this.containers[innermostIndex].containerCache.over = 1;
		}


	},

	_createHelper: function(event) {

		var o = this.options,
			helper = $.isFunction(o.helper) ? $(o.helper.apply(this.element[0], [event, this.currentItem])) : (o.helper === "clone" ? this.currentItem.clone() : this.currentItem);

		//Add the helper to the DOM if that didn't happen already
		if(!helper.parents("body").length) {
			$(o.appendTo !== "parent" ? o.appendTo : this.currentItem[0].parentNode)[0].appendChild(helper[0]);
		}

		if(helper[0] === this.currentItem[0]) {
			this._storedCSS = { width: this.currentItem[0].style.width, height: this.currentItem[0].style.height, position: this.currentItem.css("position"), top: this.currentItem.css("top"), left: this.currentItem.css("left") };
		}

		if(!helper[0].style.width || o.forceHelperSize) {
			helper.width(this.currentItem.width());
		}
		if(!helper[0].style.height || o.forceHelperSize) {
			helper.height(this.currentItem.height());
		}

		return helper;

	},

	_adjustOffsetFromHelper: function(obj) {
		if (typeof obj === "string") {
			obj = obj.split(" ");
		}
		if ($.isArray(obj)) {
			obj = {left: +obj[0], top: +obj[1] || 0};
		}
		if ("left" in obj) {
			this.offset.click.left = obj.left + this.margins.left;
		}
		if ("right" in obj) {
			this.offset.click.left = this.helperProportions.width - obj.right + this.margins.left;
		}
		if ("top" in obj) {
			this.offset.click.top = obj.top + this.margins.top;
		}
		if ("bottom" in obj) {
			this.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top;
		}
	},

	_getParentOffset: function() {


		//Get the offsetParent and cache its position
		this.offsetParent = this.helper.offsetParent();
		var po = this.offsetParent.offset();

		// This is a special case where we need to modify a offset calculated on start, since the following happened:
		// 1. The position of the helper is absolute, so it's position is calculated based on the next positioned parent
		// 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't the document, which means that
		//    the scroll is included in the initial calculation of the offset of the parent, and never recalculated upon drag
		if(this.cssPosition === "absolute" && this.scrollParent[0] !== document && $.contains(this.scrollParent[0], this.offsetParent[0])) {
			po.left += this.scrollParent.scrollLeft();
			po.top += this.scrollParent.scrollTop();
		}

		// This needs to be actually done for all browsers, since pageX/pageY includes this information
		// with an ugly IE fix
		if( this.offsetParent[0] === document.body || (this.offsetParent[0].tagName && this.offsetParent[0].tagName.toLowerCase() === "html" && $.ui.ie)) {
			po = { top: 0, left: 0 };
		}

		return {
			top: po.top + (parseInt(this.offsetParent.css("borderTopWidth"),10) || 0),
			left: po.left + (parseInt(this.offsetParent.css("borderLeftWidth"),10) || 0)
		};

	},

	_getRelativeOffset: function() {

		if(this.cssPosition === "relative") {
			var p = this.currentItem.position();
			return {
				top: p.top - (parseInt(this.helper.css("top"),10) || 0) + this.scrollParent.scrollTop(),
				left: p.left - (parseInt(this.helper.css("left"),10) || 0) + this.scrollParent.scrollLeft()
			};
		} else {
			return { top: 0, left: 0 };
		}

	},

	_cacheMargins: function() {
		this.margins = {
			left: (parseInt(this.currentItem.css("marginLeft"),10) || 0),
			top: (parseInt(this.currentItem.css("marginTop"),10) || 0)
		};
	},

	_cacheHelperProportions: function() {
		this.helperProportions = {
			width: this.helper.outerWidth(),
			height: this.helper.outerHeight()
		};
	},

	_setContainment: function() {

		var ce, co, over,
			o = this.options;
		if(o.containment === "parent") {
			o.containment = this.helper[0].parentNode;
		}
		if(o.containment === "document" || o.containment === "window") {
			this.containment = [
				0 - this.offset.relative.left - this.offset.parent.left,
				0 - this.offset.relative.top - this.offset.parent.top,
				$(o.containment === "document" ? document : window).width() - this.helperProportions.width - this.margins.left,
				($(o.containment === "document" ? document : window).height() || document.body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top
			];
		}

		if(!(/^(document|window|parent)$/).test(o.containment)) {
			ce = $(o.containment)[0];
			co = $(o.containment).offset();
			over = ($(ce).css("overflow") !== "hidden");

			this.containment = [
				co.left + (parseInt($(ce).css("borderLeftWidth"),10) || 0) + (parseInt($(ce).css("paddingLeft"),10) || 0) - this.margins.left,
				co.top + (parseInt($(ce).css("borderTopWidth"),10) || 0) + (parseInt($(ce).css("paddingTop"),10) || 0) - this.margins.top,
				co.left+(over ? Math.max(ce.scrollWidth,ce.offsetWidth) : ce.offsetWidth) - (parseInt($(ce).css("borderLeftWidth"),10) || 0) - (parseInt($(ce).css("paddingRight"),10) || 0) - this.helperProportions.width - this.margins.left,
				co.top+(over ? Math.max(ce.scrollHeight,ce.offsetHeight) : ce.offsetHeight) - (parseInt($(ce).css("borderTopWidth"),10) || 0) - (parseInt($(ce).css("paddingBottom"),10) || 0) - this.helperProportions.height - this.margins.top
			];
		}

	},

	_convertPositionTo: function(d, pos) {

		if(!pos) {
			pos = this.position;
		}
		var mod = d === "absolute" ? 1 : -1,
			scroll = this.cssPosition === "absolute" && !(this.scrollParent[0] !== document && $.contains(this.scrollParent[0], this.offsetParent[0])) ? this.offsetParent : this.scrollParent,
			scrollIsRootNode = (/(html|body)/i).test(scroll[0].tagName);

		return {
			top: (
				pos.top	+																// The absolute mouse position
				this.offset.relative.top * mod +										// Only for relative positioned nodes: Relative offset from element to offset parent
				this.offset.parent.top * mod -											// The offsetParent's offset without borders (offset + border)
				( ( this.cssPosition === "fixed" ? -this.scrollParent.scrollTop() : ( scrollIsRootNode ? 0 : scroll.scrollTop() ) ) * mod)
			),
			left: (
				pos.left +																// The absolute mouse position
				this.offset.relative.left * mod +										// Only for relative positioned nodes: Relative offset from element to offset parent
				this.offset.parent.left * mod	-										// The offsetParent's offset without borders (offset + border)
				( ( this.cssPosition === "fixed" ? -this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 : scroll.scrollLeft() ) * mod)
			)
		};

	},

	_generatePosition: function(event) {

		var top, left,
			o = this.options,
			pageX = event.pageX,
			pageY = event.pageY,
			scroll = this.cssPosition === "absolute" && !(this.scrollParent[0] !== document && $.contains(this.scrollParent[0], this.offsetParent[0])) ? this.offsetParent : this.scrollParent, scrollIsRootNode = (/(html|body)/i).test(scroll[0].tagName);

		// This is another very weird special case that only happens for relative elements:
		// 1. If the css position is relative
		// 2. and the scroll parent is the document or similar to the offset parent
		// we have to refresh the relative offset during the scroll so there are no jumps
		if(this.cssPosition === "relative" && !(this.scrollParent[0] !== document && this.scrollParent[0] !== this.offsetParent[0])) {
			this.offset.relative = this._getRelativeOffset();
		}

		/*
		 * - Position constraining -
		 * Constrain the position to a mix of grid, containment.
		 */

		if(this.originalPosition) { //If we are not dragging yet, we won't check for options

			if(this.containment) {
				if(event.pageX - this.offset.click.left < this.containment[0]) {
					pageX = this.containment[0] + this.offset.click.left;
				}
				if(event.pageY - this.offset.click.top < this.containment[1]) {
					pageY = this.containment[1] + this.offset.click.top;
				}
				if(event.pageX - this.offset.click.left > this.containment[2]) {
					pageX = this.containment[2] + this.offset.click.left;
				}
				if(event.pageY - this.offset.click.top > this.containment[3]) {
					pageY = this.containment[3] + this.offset.click.top;
				}
			}

			if(o.grid) {
				top = this.originalPageY + Math.round((pageY - this.originalPageY) / o.grid[1]) * o.grid[1];
				pageY = this.containment ? ( (top - this.offset.click.top >= this.containment[1] && top - this.offset.click.top <= this.containment[3]) ? top : ((top - this.offset.click.top >= this.containment[1]) ? top - o.grid[1] : top + o.grid[1])) : top;

				left = this.originalPageX + Math.round((pageX - this.originalPageX) / o.grid[0]) * o.grid[0];
				pageX = this.containment ? ( (left - this.offset.click.left >= this.containment[0] && left - this.offset.click.left <= this.containment[2]) ? left : ((left - this.offset.click.left >= this.containment[0]) ? left - o.grid[0] : left + o.grid[0])) : left;
			}

		}

		return {
			top: (
				pageY -																// The absolute mouse position
				this.offset.click.top -													// Click offset (relative to the element)
				this.offset.relative.top	-											// Only for relative positioned nodes: Relative offset from element to offset parent
				this.offset.parent.top +												// The offsetParent's offset without borders (offset + border)
				( ( this.cssPosition === "fixed" ? -this.scrollParent.scrollTop() : ( scrollIsRootNode ? 0 : scroll.scrollTop() ) ))
			),
			left: (
				pageX -																// The absolute mouse position
				this.offset.click.left -												// Click offset (relative to the element)
				this.offset.relative.left	-											// Only for relative positioned nodes: Relative offset from element to offset parent
				this.offset.parent.left +												// The offsetParent's offset without borders (offset + border)
				( ( this.cssPosition === "fixed" ? -this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 : scroll.scrollLeft() ))
			)
		};

	},

	_rearrange: function(event, i, a, hardRefresh) {

		a ? a[0].appendChild(this.placeholder[0]) : i.item[0].parentNode.insertBefore(this.placeholder[0], (this.direction === "down" ? i.item[0] : i.item[0].nextSibling));

		//Various things done here to improve the performance:
		// 1. we create a setTimeout, that calls refreshPositions
		// 2. on the instance, we have a counter variable, that get's higher after every append
		// 3. on the local scope, we copy the counter variable, and check in the timeout, if it's still the same
		// 4. this lets only the last addition to the timeout stack through
		this.counter = this.counter ? ++this.counter : 1;
		var counter = this.counter;

		this._delay(function() {
			if(counter === this.counter) {
				this.refreshPositions(!hardRefresh); //Precompute after each DOM insertion, NOT on mousemove
			}
		});

	},

	_clear: function(event, noPropagation) {

		this.reverting = false;
		// We delay all events that have to be triggered to after the point where the placeholder has been removed and
		// everything else normalized again
		var i,
			delayedTriggers = [];

		// We first have to update the dom position of the actual currentItem
		// Note: don't do it if the current item is already removed (by a user), or it gets reappended (see #4088)
		if(!this._noFinalSort && this.currentItem.parent().length) {
			this.placeholder.before(this.currentItem);
		}
		this._noFinalSort = null;

		if(this.helper[0] === this.currentItem[0]) {
			for(i in this._storedCSS) {
				if(this._storedCSS[i] === "auto" || this._storedCSS[i] === "static") {
					this._storedCSS[i] = "";
				}
			}
			this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper");
		} else {
			this.currentItem.show();
		}

		if(this.fromOutside && !noPropagation) {
			delayedTriggers.push(function(event) { this._trigger("receive", event, this._uiHash(this.fromOutside)); });
		}
		if((this.fromOutside || this.domPosition.prev !== this.currentItem.prev().not(".ui-sortable-helper")[0] || this.domPosition.parent !== this.currentItem.parent()[0]) && !noPropagation) {
			delayedTriggers.push(function(event) { this._trigger("update", event, this._uiHash()); }); //Trigger update callback if the DOM position has changed
		}

		// Check if the items Container has Changed and trigger appropriate
		// events.
		if (this !== this.currentContainer) {
			if(!noPropagation) {
				delayedTriggers.push(function(event) { this._trigger("remove", event, this._uiHash()); });
				delayedTriggers.push((function(c) { return function(event) { c._trigger("receive", event, this._uiHash(this)); };  }).call(this, this.currentContainer));
				delayedTriggers.push((function(c) { return function(event) { c._trigger("update", event, this._uiHash(this));  }; }).call(this, this.currentContainer));
			}
		}


		//Post events to containers
		for (i = this.containers.length - 1; i >= 0; i--){
			if(!noPropagation) {
				delayedTriggers.push((function(c) { return function(event) { c._trigger("deactivate", event, this._uiHash(this)); };  }).call(this, this.containers[i]));
			}
			if(this.containers[i].containerCache.over) {
				delayedTriggers.push((function(c) { return function(event) { c._trigger("out", event, this._uiHash(this)); };  }).call(this, this.containers[i]));
				this.containers[i].containerCache.over = 0;
			}
		}

		//Do what was originally in plugins
		if ( this.storedCursor ) {
			this.document.find( "body" ).css( "cursor", this.storedCursor );
			this.storedStylesheet.remove();
		}
		if(this._storedOpacity) {
			this.helper.css("opacity", this._storedOpacity);
		}
		if(this._storedZIndex) {
			this.helper.css("zIndex", this._storedZIndex === "auto" ? "" : this._storedZIndex);
		}

		this.dragging = false;
		if(this.cancelHelperRemoval) {
			if(!noPropagation) {
				this._trigger("beforeStop", event, this._uiHash());
				for (i=0; i < delayedTriggers.length; i++) {
					delayedTriggers[i].call(this, event);
				} //Trigger all delayed events
				this._trigger("stop", event, this._uiHash());
			}

			this.fromOutside = false;
			return false;
		}

		if(!noPropagation) {
			this._trigger("beforeStop", event, this._uiHash());
		}

		//$(this.placeholder[0]).remove(); would have been the jQuery way - unfortunately, it unbinds ALL events from the original node!
		this.placeholder[0].parentNode.removeChild(this.placeholder[0]);

		if(this.helper[0] !== this.currentItem[0]) {
			this.helper.remove();
		}
		this.helper = null;

		if(!noPropagation) {
			for (i=0; i < delayedTriggers.length; i++) {
				delayedTriggers[i].call(this, event);
			} //Trigger all delayed events
			this._trigger("stop", event, this._uiHash());
		}

		this.fromOutside = false;
		return true;

	},

	_trigger: function() {
		if ($.Widget.prototype._trigger.apply(this, arguments) === false) {
			this.cancel();
		}
	},

	_uiHash: function(_inst) {
		var inst = _inst || this;
		return {
			helper: inst.helper,
			placeholder: inst.placeholder || $([]),
			position: inst.position,
			originalPosition: inst.originalPosition,
			offset: inst.positionAbs,
			item: inst.currentItem,
			sender: _inst ? _inst.element : null
		};
	}

});

})(jQuery);
/*!
 * jQuery UI Button 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/button/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 */
(function( $, undefined ) {

var lastActive, startXPos, startYPos, clickDragged,
	baseClasses = "ui-button ui-widget ui-state-default ui-corner-all",
	stateClasses = "ui-state-hover ui-state-active ",
	typeClasses = "ui-button-icons-only ui-button-icon-only ui-button-text-icons ui-button-text-icon-primary ui-button-text-icon-secondary ui-button-text-only",
	formResetHandler = function() {
		var form = $( this );
		setTimeout(function() {
			form.find( ":ui-button" ).button( "refresh" );
		}, 1 );
	},
	radioGroup = function( radio ) {
		var name = radio.name,
			form = radio.form,
			radios = $( [] );
		if ( name ) {
			name = name.replace( /'/g, "\\'" );
			if ( form ) {
				radios = $( form ).find( "[name='" + name + "']" );
			} else {
				radios = $( "[name='" + name + "']", radio.ownerDocument )
					.filter(function() {
						return !this.form;
					});
			}
		}
		return radios;
	};

$.widget( "ui.button", {
	version: "1.10.3",
	defaultElement: "<button>",
	options: {
		disabled: null,
		text: true,
		label: null,
		icons: {
			primary: null,
			secondary: null
		}
	},
	_create: function() {
		this.element.closest( "form" )
			.unbind( "reset" + this.eventNamespace )
			.bind( "reset" + this.eventNamespace, formResetHandler );

		if ( typeof this.options.disabled !== "boolean" ) {
			this.options.disabled = !!this.element.prop( "disabled" );
		} else {
			this.element.prop( "disabled", this.options.disabled );
		}

		this._determineButtonType();
		this.hasTitle = !!this.buttonElement.attr( "title" );

		var that = this,
			options = this.options,
			toggleButton = this.type === "checkbox" || this.type === "radio",
			activeClass = !toggleButton ? "ui-state-active" : "",
			focusClass = "ui-state-focus";

		if ( options.label === null ) {
			options.label = (this.type === "input" ? this.buttonElement.val() : this.buttonElement.html());
		}

		this._hoverable( this.buttonElement );

		this.buttonElement
			.addClass( baseClasses )
			.attr( "role", "button" )
			.bind( "mouseenter" + this.eventNamespace, function() {
				if ( options.disabled ) {
					return;
				}
				if ( this === lastActive ) {
					$( this ).addClass( "ui-state-active" );
				}
			})
			.bind( "mouseleave" + this.eventNamespace, function() {
				if ( options.disabled ) {
					return;
				}
				$( this ).removeClass( activeClass );
			})
			.bind( "click" + this.eventNamespace, function( event ) {
				if ( options.disabled ) {
					event.preventDefault();
					event.stopImmediatePropagation();
				}
			});

		this.element
			.bind( "focus" + this.eventNamespace, function() {
				// no need to check disabled, focus won't be triggered anyway
				that.buttonElement.addClass( focusClass );
			})
			.bind( "blur" + this.eventNamespace, function() {
				that.buttonElement.removeClass( focusClass );
			});

		if ( toggleButton ) {
			this.element.bind( "change" + this.eventNamespace, function() {
				if ( clickDragged ) {
					return;
				}
				that.refresh();
			});
			// if mouse moves between mousedown and mouseup (drag) set clickDragged flag
			// prevents issue where button state changes but checkbox/radio checked state
			// does not in Firefox (see ticket #6970)
			this.buttonElement
				.bind( "mousedown" + this.eventNamespace, function( event ) {
					if ( options.disabled ) {
						return;
					}
					clickDragged = false;
					startXPos = event.pageX;
					startYPos = event.pageY;
				})
				.bind( "mouseup" + this.eventNamespace, function( event ) {
					if ( options.disabled ) {
						return;
					}
					if ( startXPos !== event.pageX || startYPos !== event.pageY ) {
						clickDragged = true;
					}
			});
		}

		if ( this.type === "checkbox" ) {
			this.buttonElement.bind( "click" + this.eventNamespace, function() {
				if ( options.disabled || clickDragged ) {
					return false;
				}
			});
		} else if ( this.type === "radio" ) {
			this.buttonElement.bind( "click" + this.eventNamespace, function() {
				if ( options.disabled || clickDragged ) {
					return false;
				}
				$( this ).addClass( "ui-state-active" );
				that.buttonElement.attr( "aria-pressed", "true" );

				var radio = that.element[ 0 ];
				radioGroup( radio )
					.not( radio )
					.map(function() {
						return $( this ).button( "widget" )[ 0 ];
					})
					.removeClass( "ui-state-active" )
					.attr( "aria-pressed", "false" );
			});
		} else {
			this.buttonElement
				.bind( "mousedown" + this.eventNamespace, function() {
					if ( options.disabled ) {
						return false;
					}
					$( this ).addClass( "ui-state-active" );
					lastActive = this;
					that.document.one( "mouseup", function() {
						lastActive = null;
					});
				})
				.bind( "mouseup" + this.eventNamespace, function() {
					if ( options.disabled ) {
						return false;
					}
					$( this ).removeClass( "ui-state-active" );
				})
				.bind( "keydown" + this.eventNamespace, function(event) {
					if ( options.disabled ) {
						return false;
					}
					if ( event.keyCode === $.ui.keyCode.SPACE || event.keyCode === $.ui.keyCode.ENTER ) {
						$( this ).addClass( "ui-state-active" );
					}
				})
				// see #8559, we bind to blur here in case the button element loses
				// focus between keydown and keyup, it would be left in an "active" state
				.bind( "keyup" + this.eventNamespace + " blur" + this.eventNamespace, function() {
					$( this ).removeClass( "ui-state-active" );
				});

			if ( this.buttonElement.is("a") ) {
				this.buttonElement.keyup(function(event) {
					if ( event.keyCode === $.ui.keyCode.SPACE ) {
						// TODO pass through original event correctly (just as 2nd argument doesn't work)
						$( this ).click();
					}
				});
			}
		}

		// TODO: pull out $.Widget's handling for the disabled option into
		// $.Widget.prototype._setOptionDisabled so it's easy to proxy and can
		// be overridden by individual plugins
		this._setOption( "disabled", options.disabled );
		this._resetButton();
	},

	_determineButtonType: function() {
		var ancestor, labelSelector, checked;

		if ( this.element.is("[type=checkbox]") ) {
			this.type = "checkbox";
		} else if ( this.element.is("[type=radio]") ) {
			this.type = "radio";
		} else if ( this.element.is("input") ) {
			this.type = "input";
		} else {
			this.type = "button";
		}

		if ( this.type === "checkbox" || this.type === "radio" ) {
			// we don't search against the document in case the element
			// is disconnected from the DOM
			ancestor = this.element.parents().last();
			labelSelector = "label[for='" + this.element.attr("id") + "']";
			this.buttonElement = ancestor.find( labelSelector );
			if ( !this.buttonElement.length ) {
				ancestor = ancestor.length ? ancestor.siblings() : this.element.siblings();
				this.buttonElement = ancestor.filter( labelSelector );
				if ( !this.buttonElement.length ) {
					this.buttonElement = ancestor.find( labelSelector );
				}
			}
			this.element.addClass( "ui-helper-hidden-accessible" );

			checked = this.element.is( ":checked" );
			if ( checked ) {
				this.buttonElement.addClass( "ui-state-active" );
			}
			this.buttonElement.prop( "aria-pressed", checked );
		} else {
			this.buttonElement = this.element;
		}
	},

	widget: function() {
		return this.buttonElement;
	},

	_destroy: function() {
		this.element
			.removeClass( "ui-helper-hidden-accessible" );
		this.buttonElement
			.removeClass( baseClasses + " " + stateClasses + " " + typeClasses )
			.removeAttr( "role" )
			.removeAttr( "aria-pressed" )
			.html( this.buttonElement.find(".ui-button-text").html() );

		if ( !this.hasTitle ) {
			this.buttonElement.removeAttr( "title" );
		}
	},

	_setOption: function( key, value ) {
		this._super( key, value );
		if ( key === "disabled" ) {
			if ( value ) {
				this.element.prop( "disabled", true );
			} else {
				this.element.prop( "disabled", false );
			}
			return;
		}
		this._resetButton();
	},

	refresh: function() {
		//See #8237 & #8828
		var isDisabled = this.element.is( "input, button" ) ? this.element.is( ":disabled" ) : this.element.hasClass( "ui-button-disabled" );

		if ( isDisabled !== this.options.disabled ) {
			this._setOption( "disabled", isDisabled );
		}
		if ( this.type === "radio" ) {
			radioGroup( this.element[0] ).each(function() {
				if ( $( this ).is( ":checked" ) ) {
					$( this ).button( "widget" )
						.addClass( "ui-state-active" )
						.attr( "aria-pressed", "true" );
				} else {
					$( this ).button( "widget" )
						.removeClass( "ui-state-active" )
						.attr( "aria-pressed", "false" );
				}
			});
		} else if ( this.type === "checkbox" ) {
			if ( this.element.is( ":checked" ) ) {
				this.buttonElement
					.addClass( "ui-state-active" )
					.attr( "aria-pressed", "true" );
			} else {
				this.buttonElement
					.removeClass( "ui-state-active" )
					.attr( "aria-pressed", "false" );
			}
		}
	},

	_resetButton: function() {
		if ( this.type === "input" ) {
			if ( this.options.label ) {
				this.element.val( this.options.label );
			}
			return;
		}
		var buttonElement = this.buttonElement.removeClass( typeClasses ),
			buttonText = $( "<span></span>", this.document[0] )
				.addClass( "ui-button-text" )
				.html( this.options.label )
				.appendTo( buttonElement.empty() )
				.text(),
			icons = this.options.icons,
			multipleIcons = icons.primary && icons.secondary,
			buttonClasses = [];

		if ( icons.primary || icons.secondary ) {
			if ( this.options.text ) {
				buttonClasses.push( "ui-button-text-icon" + ( multipleIcons ? "s" : ( icons.primary ? "-primary" : "-secondary" ) ) );
			}

			if ( icons.primary ) {
				buttonElement.prepend( "<span class='ui-button-icon-primary ui-icon " + icons.primary + "'></span>" );
			}

			if ( icons.secondary ) {
				buttonElement.append( "<span class='ui-button-icon-secondary ui-icon " + icons.secondary + "'></span>" );
			}

			if ( !this.options.text ) {
				buttonClasses.push( multipleIcons ? "ui-button-icons-only" : "ui-button-icon-only" );

				if ( !this.hasTitle ) {
					buttonElement.attr( "title", $.trim( buttonText ) );
				}
			}
		} else {
			buttonClasses.push( "ui-button-text-only" );
		}
		buttonElement.addClass( buttonClasses.join( " " ) );
	}
});

$.widget( "ui.buttonset", {
	version: "1.10.3",
	options: {
		items: "button, input[type=button], input[type=submit], input[type=reset], input[type=checkbox], input[type=radio], a, :data(ui-button)"
	},

	_create: function() {
		this.element.addClass( "ui-buttonset" );
	},

	_init: function() {
		this.refresh();
	},

	_setOption: function( key, value ) {
		if ( key === "disabled" ) {
			this.buttons.button( "option", key, value );
		}

		this._super( key, value );
	},

	refresh: function() {
		var rtl = this.element.css( "direction" ) === "rtl";

		this.buttons = this.element.find( this.options.items )
			.filter( ":ui-button" )
				.button( "refresh" )
			.end()
			.not( ":ui-button" )
				.button()
			.end()
			.map(function() {
				return $( this ).button( "widget" )[ 0 ];
			})
				.removeClass( "ui-corner-all ui-corner-left ui-corner-right" )
				.filter( ":first" )
					.addClass( rtl ? "ui-corner-right" : "ui-corner-left" )
				.end()
				.filter( ":last" )
					.addClass( rtl ? "ui-corner-left" : "ui-corner-right" )
				.end()
			.end();
	},

	_destroy: function() {
		this.element.removeClass( "ui-buttonset" );
		this.buttons
			.map(function() {
				return $( this ).button( "widget" )[ 0 ];
			})
				.removeClass( "ui-corner-left ui-corner-right" )
			.end()
			.button( "destroy" );
	}
});

}( jQuery ) );
/*!
 * jQuery UI Dialog 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/dialog/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 *  jquery.ui.button.js
 *	jquery.ui.draggable.js
 *	jquery.ui.mouse.js
 *	jquery.ui.position.js
 *	jquery.ui.resizable.js
 */
(function( $, undefined ) {

var sizeRelatedOptions = {
		buttons: true,
		height: true,
		maxHeight: true,
		maxWidth: true,
		minHeight: true,
		minWidth: true,
		width: true
	},
	resizableRelatedOptions = {
		maxHeight: true,
		maxWidth: true,
		minHeight: true,
		minWidth: true
	};

$.widget( "ui.dialog", {
	version: "1.10.3",
	options: {
		appendTo: "body",
		autoOpen: true,
		buttons: [],
		closeOnEscape: true,
		closeText: "close",
		dialogClass: "",
		draggable: true,
		hide: null,
		height: "auto",
		maxHeight: null,
		maxWidth: null,
		minHeight: 150,
		minWidth: 150,
		modal: false,
		position: {
			my: "center",
			at: "center",
			of: window,
			collision: "fit",
			// Ensure the titlebar is always visible
			using: function( pos ) {
				var topOffset = $( this ).css( pos ).offset().top;
				if ( topOffset < 0 ) {
					$( this ).css( "top", pos.top - topOffset );
				}
			}
		},
		resizable: true,
		show: null,
		title: null,
		width: 300,

		// callbacks
		beforeClose: null,
		close: null,
		drag: null,
		dragStart: null,
		dragStop: null,
		focus: null,
		open: null,
		resize: null,
		resizeStart: null,
		resizeStop: null
	},

	_create: function() {
		this.originalCss = {
			display: this.element[0].style.display,
			width: this.element[0].style.width,
			minHeight: this.element[0].style.minHeight,
			maxHeight: this.element[0].style.maxHeight,
			height: this.element[0].style.height
		};
		this.originalPosition = {
			parent: this.element.parent(),
			index: this.element.parent().children().index( this.element )
		};
		this.originalTitle = this.element.attr("title");
		this.options.title = this.options.title || this.originalTitle;

		this._createWrapper();

		this.element
			.show()
			.removeAttr("title")
			.addClass("ui-dialog-content ui-widget-content")
			.appendTo( this.uiDialog );

		this._createTitlebar();
		this._createButtonPane();

		if ( this.options.draggable && $.fn.draggable ) {
			this._makeDraggable();
		}
		if ( this.options.resizable && $.fn.resizable ) {
			this._makeResizable();
		}

		this._isOpen = false;
	},

	_init: function() {
		if ( this.options.autoOpen ) {
			this.open();
		}
	},

	_appendTo: function() {
		var element = this.options.appendTo;
		if ( element && (element.jquery || element.nodeType) ) {
			return $( element );
		}
		return this.document.find( element || "body" ).eq( 0 );
	},

	_destroy: function() {
		var next,
			originalPosition = this.originalPosition;

		this._destroyOverlay();

		this.element
			.removeUniqueId()
			.removeClass("ui-dialog-content ui-widget-content")
			.css( this.originalCss )
			// Without detaching first, the following becomes really slow
			.detach();

		this.uiDialog.stop( true, true ).remove();

		if ( this.originalTitle ) {
			this.element.attr( "title", this.originalTitle );
		}

		next = originalPosition.parent.children().eq( originalPosition.index );
		// Don't try to place the dialog next to itself (#8613)
		if ( next.length && next[0] !== this.element[0] ) {
			next.before( this.element );
		} else {
			originalPosition.parent.append( this.element );
		}
	},

	widget: function() {
		return this.uiDialog;
	},

	disable: $.noop,
	enable: $.noop,

	close: function( event ) {
		var that = this;

		if ( !this._isOpen || this._trigger( "beforeClose", event ) === false ) {
			return;
		}

		this._isOpen = false;
		this._destroyOverlay();

		if ( !this.opener.filter(":focusable").focus().length ) {
			// Hiding a focused element doesn't trigger blur in WebKit
			// so in case we have nothing to focus on, explicitly blur the active element
			// https://bugs.webkit.org/show_bug.cgi?id=47182
			$( this.document[0].activeElement ).blur();
		}

		this._hide( this.uiDialog, this.options.hide, function() {
			that._trigger( "close", event );
		});
	},

	isOpen: function() {
		return this._isOpen;
	},

	moveToTop: function() {
		this._moveToTop();
	},

	_moveToTop: function( event, silent ) {
		var moved = !!this.uiDialog.nextAll(":visible").insertBefore( this.uiDialog ).length;
		if ( moved && !silent ) {
			this._trigger( "focus", event );
		}
		return moved;
	},

	open: function() {
		var that = this;
		if ( this._isOpen ) {
			if ( this._moveToTop() ) {
				this._focusTabbable();
			}
			return;
		}

		this._isOpen = true;
		this.opener = $( this.document[0].activeElement );

		this._size();
		this._position();
		this._createOverlay();
		this._moveToTop( null, true );
		this._show( this.uiDialog, this.options.show, function() {
			that._focusTabbable();
			that._trigger("focus");
		});

		this._trigger("open");
	},

	_focusTabbable: function() {
		// Set focus to the first match:
		// 1. First element inside the dialog matching [autofocus]
		// 2. Tabbable element inside the content element
		// 3. Tabbable element inside the buttonpane
		// 4. The close button
		// 5. The dialog itself
		var hasFocus = this.element.find("[autofocus]");
		if ( !hasFocus.length ) {
			hasFocus = this.element.find(":tabbable");
		}
		if ( !hasFocus.length ) {
			hasFocus = this.uiDialogButtonPane.find(":tabbable");
		}
		if ( !hasFocus.length ) {
			hasFocus = this.uiDialogTitlebarClose.filter(":tabbable");
		}
		if ( !hasFocus.length ) {
			hasFocus = this.uiDialog;
		}
		hasFocus.eq( 0 ).focus();
	},

	_keepFocus: function( event ) {
		function checkFocus() {
			var activeElement = this.document[0].activeElement,
				isActive = this.uiDialog[0] === activeElement ||
					$.contains( this.uiDialog[0], activeElement );
			if ( !isActive ) {
				this._focusTabbable();
			}
		}
		event.preventDefault();
		checkFocus.call( this );
		// support: IE
		// IE <= 8 doesn't prevent moving focus even with event.preventDefault()
		// so we check again later
		this._delay( checkFocus );
	},

	_createWrapper: function() {
		this.uiDialog = $("<div>")
			.addClass( "ui-dialog ui-widget ui-widget-content ui-corner-all ui-front " +
				this.options.dialogClass )
			.hide()
			.attr({
				// Setting tabIndex makes the div focusable
				tabIndex: -1,
				role: "dialog"
			})
			.appendTo( this._appendTo() );

		this._on( this.uiDialog, {
			keydown: function( event ) {
				if ( this.options.closeOnEscape && !event.isDefaultPrevented() && event.keyCode &&
						event.keyCode === $.ui.keyCode.ESCAPE ) {
					event.preventDefault();
					this.close( event );
					return;
				}

				// prevent tabbing out of dialogs
				if ( event.keyCode !== $.ui.keyCode.TAB ) {
					return;
				}
				var tabbables = this.uiDialog.find(":tabbable"),
					first = tabbables.filter(":first"),
					last  = tabbables.filter(":last");

				if ( ( event.target === last[0] || event.target === this.uiDialog[0] ) && !event.shiftKey ) {
					first.focus( 1 );
					event.preventDefault();
				} else if ( ( event.target === first[0] || event.target === this.uiDialog[0] ) && event.shiftKey ) {
					last.focus( 1 );
					event.preventDefault();
				}
			},
			mousedown: function( event ) {
				if ( this._moveToTop( event ) ) {
					this._focusTabbable();
				}
			}
		});

		// We assume that any existing aria-describedby attribute means
		// that the dialog content is marked up properly
		// otherwise we brute force the content as the description
		if ( !this.element.find("[aria-describedby]").length ) {
			this.uiDialog.attr({
				"aria-describedby": this.element.uniqueId().attr("id")
			});
		}
	},

	_createTitlebar: function() {
		var uiDialogTitle;

		this.uiDialogTitlebar = $("<div>")
			.addClass("ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix")
			.prependTo( this.uiDialog );
		this._on( this.uiDialogTitlebar, {
			mousedown: function( event ) {
				// Don't prevent click on close button (#8838)
				// Focusing a dialog that is partially scrolled out of view
				// causes the browser to scroll it into view, preventing the click event
				if ( !$( event.target ).closest(".ui-dialog-titlebar-close") ) {
					// Dialog isn't getting focus when dragging (#8063)
					this.uiDialog.focus();
				}
			}
		});

		this.uiDialogTitlebarClose = $("<button></button>")
			.button({
				label: this.options.closeText,
				icons: {
					primary: "ui-icon-closethick"
				},
				text: false
			})
			.addClass("ui-dialog-titlebar-close")
			.appendTo( this.uiDialogTitlebar );
		this._on( this.uiDialogTitlebarClose, {
			click: function( event ) {
				event.preventDefault();
				this.close( event );
			}
		});

		uiDialogTitle = $("<span>")
			.uniqueId()
			.addClass("ui-dialog-title")
			.prependTo( this.uiDialogTitlebar );
		this._title( uiDialogTitle );

		this.uiDialog.attr({
			"aria-labelledby": uiDialogTitle.attr("id")
		});
	},

	_title: function( title ) {
		if ( !this.options.title ) {
			title.html("&#160;");
		}
		title.text( this.options.title );
	},

	_createButtonPane: function() {
		this.uiDialogButtonPane = $("<div>")
			.addClass("ui-dialog-buttonpane ui-widget-content ui-helper-clearfix");

		this.uiButtonSet = $("<div>")
			.addClass("ui-dialog-buttonset")
			.appendTo( this.uiDialogButtonPane );

		this._createButtons();
	},

	_createButtons: function() {
		var that = this,
			buttons = this.options.buttons;

		// if we already have a button pane, remove it
		this.uiDialogButtonPane.remove();
		this.uiButtonSet.empty();

		if ( $.isEmptyObject( buttons ) || ($.isArray( buttons ) && !buttons.length) ) {
			this.uiDialog.removeClass("ui-dialog-buttons");
			return;
		}

		$.each( buttons, function( name, props ) {
			var click, buttonOptions;
			props = $.isFunction( props ) ?
				{ click: props, text: name } :
				props;
			// Default to a non-submitting button
			props = $.extend( { type: "button" }, props );
			// Change the context for the click callback to be the main element
			click = props.click;
			props.click = function() {
				click.apply( that.element[0], arguments );
			};
			buttonOptions = {
				icons: props.icons,
				text: props.showText
			};
			delete props.icons;
			delete props.showText;
			$( "<button></button>", props )
				.button( buttonOptions )
				.appendTo( that.uiButtonSet );
		});
		this.uiDialog.addClass("ui-dialog-buttons");
		this.uiDialogButtonPane.appendTo( this.uiDialog );
	},

	_makeDraggable: function() {
		var that = this,
			options = this.options;

		function filteredUi( ui ) {
			return {
				position: ui.position,
				offset: ui.offset
			};
		}

		this.uiDialog.draggable({
			cancel: ".ui-dialog-content, .ui-dialog-titlebar-close",
			handle: ".ui-dialog-titlebar",
			containment: "document",
			start: function( event, ui ) {
				$( this ).addClass("ui-dialog-dragging");
				that._blockFrames();
				that._trigger( "dragStart", event, filteredUi( ui ) );
			},
			drag: function( event, ui ) {
				that._trigger( "drag", event, filteredUi( ui ) );
			},
			stop: function( event, ui ) {
				options.position = [
					ui.position.left - that.document.scrollLeft(),
					ui.position.top - that.document.scrollTop()
				];
				$( this ).removeClass("ui-dialog-dragging");
				that._unblockFrames();
				that._trigger( "dragStop", event, filteredUi( ui ) );
			}
		});
	},

	_makeResizable: function() {
		var that = this,
			options = this.options,
			handles = options.resizable,
			// .ui-resizable has position: relative defined in the stylesheet
			// but dialogs have to use absolute or fixed positioning
			position = this.uiDialog.css("position"),
			resizeHandles = typeof handles === "string" ?
				handles	:
				"n,e,s,w,se,sw,ne,nw";

		function filteredUi( ui ) {
			return {
				originalPosition: ui.originalPosition,
				originalSize: ui.originalSize,
				position: ui.position,
				size: ui.size
			};
		}

		this.uiDialog.resizable({
			cancel: ".ui-dialog-content",
			containment: "document",
			alsoResize: this.element,
			maxWidth: options.maxWidth,
			maxHeight: options.maxHeight,
			minWidth: options.minWidth,
			minHeight: this._minHeight(),
			handles: resizeHandles,
			start: function( event, ui ) {
				$( this ).addClass("ui-dialog-resizing");
				that._blockFrames();
				that._trigger( "resizeStart", event, filteredUi( ui ) );
			},
			resize: function( event, ui ) {
				that._trigger( "resize", event, filteredUi( ui ) );
			},
			stop: function( event, ui ) {
				options.height = $( this ).height();
				options.width = $( this ).width();
				$( this ).removeClass("ui-dialog-resizing");
				that._unblockFrames();
				that._trigger( "resizeStop", event, filteredUi( ui ) );
			}
		})
		.css( "position", position );
	},

	_minHeight: function() {
		var options = this.options;

		return options.height === "auto" ?
			options.minHeight :
			Math.min( options.minHeight, options.height );
	},

	_position: function() {
		// Need to show the dialog to get the actual offset in the position plugin
		var isVisible = this.uiDialog.is(":visible");
		if ( !isVisible ) {
			this.uiDialog.show();
		}
		this.uiDialog.position( this.options.position );
		if ( !isVisible ) {
			this.uiDialog.hide();
		}
	},

	_setOptions: function( options ) {
		var that = this,
			resize = false,
			resizableOptions = {};

		$.each( options, function( key, value ) {
			that._setOption( key, value );

			if ( key in sizeRelatedOptions ) {
				resize = true;
			}
			if ( key in resizableRelatedOptions ) {
				resizableOptions[ key ] = value;
			}
		});

		if ( resize ) {
			this._size();
			this._position();
		}
		if ( this.uiDialog.is(":data(ui-resizable)") ) {
			this.uiDialog.resizable( "option", resizableOptions );
		}
	},

	_setOption: function( key, value ) {
		/*jshint maxcomplexity:15*/
		var isDraggable, isResizable,
			uiDialog = this.uiDialog;

		if ( key === "dialogClass" ) {
			uiDialog
				.removeClass( this.options.dialogClass )
				.addClass( value );
		}

		if ( key === "disabled" ) {
			return;
		}

		this._super( key, value );

		if ( key === "appendTo" ) {
			this.uiDialog.appendTo( this._appendTo() );
		}

		if ( key === "buttons" ) {
			this._createButtons();
		}

		if ( key === "closeText" ) {
			this.uiDialogTitlebarClose.button({
				// Ensure that we always pass a string
				label: "" + value
			});
		}

		if ( key === "draggable" ) {
			isDraggable = uiDialog.is(":data(ui-draggable)");
			if ( isDraggable && !value ) {
				uiDialog.draggable("destroy");
			}

			if ( !isDraggable && value ) {
				this._makeDraggable();
			}
		}

		if ( key === "position" ) {
			this._position();
		}

		if ( key === "resizable" ) {
			// currently resizable, becoming non-resizable
			isResizable = uiDialog.is(":data(ui-resizable)");
			if ( isResizable && !value ) {
				uiDialog.resizable("destroy");
			}

			// currently resizable, changing handles
			if ( isResizable && typeof value === "string" ) {
				uiDialog.resizable( "option", "handles", value );
			}

			// currently non-resizable, becoming resizable
			if ( !isResizable && value !== false ) {
				this._makeResizable();
			}
		}

		if ( key === "title" ) {
			this._title( this.uiDialogTitlebar.find(".ui-dialog-title") );
		}
	},

	_size: function() {
		// If the user has resized the dialog, the .ui-dialog and .ui-dialog-content
		// divs will both have width and height set, so we need to reset them
		var nonContentHeight, minContentHeight, maxContentHeight,
			options = this.options;

		// Reset content sizing
		this.element.show().css({
			width: "auto",
			minHeight: 0,
			maxHeight: "none",
			height: 0
		});

		if ( options.minWidth > options.width ) {
			options.width = options.minWidth;
		}

		// reset wrapper sizing
		// determine the height of all the non-content elements
		nonContentHeight = this.uiDialog.css({
				height: "auto",
				width: options.width
			})
			.outerHeight();
		minContentHeight = Math.max( 0, options.minHeight - nonContentHeight );
		maxContentHeight = typeof options.maxHeight === "number" ?
			Math.max( 0, options.maxHeight - nonContentHeight ) :
			"none";

		if ( options.height === "auto" ) {
			this.element.css({
				minHeight: minContentHeight,
				maxHeight: maxContentHeight,
				height: "auto"
			});
		} else {
			this.element.height( Math.max( 0, options.height - nonContentHeight ) );
		}

		if (this.uiDialog.is(":data(ui-resizable)") ) {
			this.uiDialog.resizable( "option", "minHeight", this._minHeight() );
		}
	},

	_blockFrames: function() {
		this.iframeBlocks = this.document.find( "iframe" ).map(function() {
			var iframe = $( this );

			return $( "<div>" )
				.css({
					position: "absolute",
					width: iframe.outerWidth(),
					height: iframe.outerHeight()
				})
				.appendTo( iframe.parent() )
				.offset( iframe.offset() )[0];
		});
	},

	_unblockFrames: function() {
		if ( this.iframeBlocks ) {
			this.iframeBlocks.remove();
			delete this.iframeBlocks;
		}
	},

	_allowInteraction: function( event ) {
		if ( $( event.target ).closest(".ui-dialog").length ) {
			return true;
		}

		// TODO: Remove hack when datepicker implements
		// the .ui-front logic (#8989)
		return !!$( event.target ).closest(".ui-datepicker").length;
	},

	_createOverlay: function() {
		if ( !this.options.modal ) {
			return;
		}

		var that = this,
			widgetFullName = this.widgetFullName;
		if ( !$.ui.dialog.overlayInstances ) {
			// Prevent use of anchors and inputs.
			// We use a delay in case the overlay is created from an
			// event that we're going to be cancelling. (#2804)
			this._delay(function() {
				// Handle .dialog().dialog("close") (#4065)
				if ( $.ui.dialog.overlayInstances ) {
					this.document.bind( "focusin.dialog", function( event ) {
						if ( !that._allowInteraction( event ) ) {
							event.preventDefault();
							$(".ui-dialog:visible:last .ui-dialog-content")
								.data( widgetFullName )._focusTabbable();
						}
					});
				}
			});
		}

		this.overlay = $("<div>")
			.addClass("ui-widget-overlay ui-front")
			.appendTo( this._appendTo() );
		this._on( this.overlay, {
			mousedown: "_keepFocus"
		});
		$.ui.dialog.overlayInstances++;
	},

	_destroyOverlay: function() {
		if ( !this.options.modal ) {
			return;
		}

		if ( this.overlay ) {
			$.ui.dialog.overlayInstances--;

			if ( !$.ui.dialog.overlayInstances ) {
				this.document.unbind( "focusin.dialog" );
			}
			this.overlay.remove();
			this.overlay = null;
		}
	}
});

$.ui.dialog.overlayInstances = 0;

// DEPRECATED
if ( $.uiBackCompat !== false ) {
	// position option with array notation
	// just override with old implementation
	$.widget( "ui.dialog", $.ui.dialog, {
		_position: function() {
			var position = this.options.position,
				myAt = [],
				offset = [ 0, 0 ],
				isVisible;

			if ( position ) {
				if ( typeof position === "string" || (typeof position === "object" && "0" in position ) ) {
					myAt = position.split ? position.split(" ") : [ position[0], position[1] ];
					if ( myAt.length === 1 ) {
						myAt[1] = myAt[0];
					}

					$.each( [ "left", "top" ], function( i, offsetPosition ) {
						if ( +myAt[ i ] === myAt[ i ] ) {
							offset[ i ] = myAt[ i ];
							myAt[ i ] = offsetPosition;
						}
					});

					position = {
						my: myAt[0] + (offset[0] < 0 ? offset[0] : "+" + offset[0]) + " " +
							myAt[1] + (offset[1] < 0 ? offset[1] : "+" + offset[1]),
						at: myAt.join(" ")
					};
				}

				position = $.extend( {}, $.ui.dialog.prototype.options.position, position );
			} else {
				position = $.ui.dialog.prototype.options.position;
			}

			// need to show the dialog to get the actual offset in the position plugin
			isVisible = this.uiDialog.is(":visible");
			if ( !isVisible ) {
				this.uiDialog.show();
			}
			this.uiDialog.position( position );
			if ( !isVisible ) {
				this.uiDialog.hide();
			}
		}
	});
}

}( jQuery ) );
/*!
 * jQuery UI Datepicker 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/datepicker/
 *
 * Depends:
 *	jquery.ui.core.js
 */
(function( $, undefined ) {

$.extend($.ui, { datepicker: { version: "1.10.3" } });

var PROP_NAME = "datepicker",
	instActive;

/* Date picker manager.
   Use the singleton instance of this class, $.datepicker, to interact with the date picker.
   Settings for (groups of) date pickers are maintained in an instance object,
   allowing multiple different settings on the same page. */

function Datepicker() {
	this._curInst = null; // The current instance in use
	this._keyEvent = false; // If the last event was a key event
	this._disabledInputs = []; // List of date picker inputs that have been disabled
	this._datepickerShowing = false; // True if the popup picker is showing , false if not
	this._inDialog = false; // True if showing within a "dialog", false if not
	this._mainDivId = "ui-datepicker-div"; // The ID of the main datepicker division
	this._inlineClass = "ui-datepicker-inline"; // The name of the inline marker class
	this._appendClass = "ui-datepicker-append"; // The name of the append marker class
	this._triggerClass = "ui-datepicker-trigger"; // The name of the trigger marker class
	this._dialogClass = "ui-datepicker-dialog"; // The name of the dialog marker class
	this._disableClass = "ui-datepicker-disabled"; // The name of the disabled covering marker class
	this._unselectableClass = "ui-datepicker-unselectable"; // The name of the unselectable cell marker class
	this._currentClass = "ui-datepicker-current-day"; // The name of the current day marker class
	this._dayOverClass = "ui-datepicker-days-cell-over"; // The name of the day hover marker class
	this.regional = []; // Available regional settings, indexed by language code
	this.regional[""] = { // Default regional settings
		closeText: "Done", // Display text for close link
		prevText: "Prev", // Display text for previous month link
		nextText: "Next", // Display text for next month link
		currentText: "Today", // Display text for current month link
		monthNames: ["January","February","March","April","May","June",
			"July","August","September","October","November","December"], // Names of months for drop-down and formatting
		monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"], // For formatting
		dayNames: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"], // For formatting
		dayNamesShort: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"], // For formatting
		dayNamesMin: ["Su","Mo","Tu","We","Th","Fr","Sa"], // Column headings for days starting at Sunday
		weekHeader: "Wk", // Column header for week of the year
		dateFormat: "mm/dd/yy", // See format options on parseDate
		firstDay: 0, // The first day of the week, Sun = 0, Mon = 1, ...
		isRTL: false, // True if right-to-left language, false if left-to-right
		showMonthAfterYear: false, // True if the year select precedes month, false for month then year
		yearSuffix: "" // Additional text to append to the year in the month headers
	};
	this._defaults = { // Global defaults for all the date picker instances
		showOn: "focus", // "focus" for popup on focus,
			// "button" for trigger button, or "both" for either
		showAnim: "fadeIn", // Name of jQuery animation for popup
		showOptions: {}, // Options for enhanced animations
		defaultDate: null, // Used when field is blank: actual date,
			// +/-number for offset from today, null for today
		appendText: "", // Display text following the input box, e.g. showing the format
		buttonText: "...", // Text for trigger button
		buttonImage: "", // URL for trigger button image
		buttonImageOnly: false, // True if the image appears alone, false if it appears on a button
		hideIfNoPrevNext: false, // True to hide next/previous month links
			// if not applicable, false to just disable them
		navigationAsDateFormat: false, // True if date formatting applied to prev/today/next links
		gotoCurrent: false, // True if today link goes back to current selection instead
		changeMonth: false, // True if month can be selected directly, false if only prev/next
		changeYear: false, // True if year can be selected directly, false if only prev/next
		yearRange: "c-10:c+10", // Range of years to display in drop-down,
			// either relative to today's year (-nn:+nn), relative to currently displayed year
			// (c-nn:c+nn), absolute (nnnn:nnnn), or a combination of the above (nnnn:-n)
		showOtherMonths: false, // True to show dates in other months, false to leave blank
		selectOtherMonths: false, // True to allow selection of dates in other months, false for unselectable
		showWeek: false, // True to show week of the year, false to not show it
		calculateWeek: this.iso8601Week, // How to calculate the week of the year,
			// takes a Date and returns the number of the week for it
		shortYearCutoff: "+10", // Short year values < this are in the current century,
			// > this are in the previous century,
			// string value starting with "+" for current year + value
		minDate: null, // The earliest selectable date, or null for no limit
		maxDate: null, // The latest selectable date, or null for no limit
		duration: "fast", // Duration of display/closure
		beforeShowDay: null, // Function that takes a date and returns an array with
			// [0] = true if selectable, false if not, [1] = custom CSS class name(s) or "",
			// [2] = cell title (optional), e.g. $.datepicker.noWeekends
		beforeShow: null, // Function that takes an input field and
			// returns a set of custom settings for the date picker
		onSelect: null, // Define a callback function when a date is selected
		onChangeMonthYear: null, // Define a callback function when the month or year is changed
		onClose: null, // Define a callback function when the datepicker is closed
		numberOfMonths: 1, // Number of months to show at a time
		showCurrentAtPos: 0, // The position in multipe months at which to show the current month (starting at 0)
		stepMonths: 1, // Number of months to step back/forward
		stepBigMonths: 12, // Number of months to step back/forward for the big links
		altField: "", // Selector for an alternate field to store selected dates into
		altFormat: "", // The date format to use for the alternate field
		constrainInput: true, // The input is constrained by the current date format
		showButtonPanel: false, // True to show button panel, false to not show it
		autoSize: false, // True to size the input for the date format, false to leave as is
		disabled: false // The initial disabled state
	};
	$.extend(this._defaults, this.regional[""]);
	this.dpDiv = bindHover($("<div id='" + this._mainDivId + "' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>"));
}

$.extend(Datepicker.prototype, {
	/* Class name added to elements to indicate already configured with a date picker. */
	markerClassName: "hasDatepicker",

	//Keep track of the maximum number of rows displayed (see #7043)
	maxRows: 4,

	// TODO rename to "widget" when switching to widget factory
	_widgetDatepicker: function() {
		return this.dpDiv;
	},

	/* Override the default settings for all instances of the date picker.
	 * @param  settings  object - the new settings to use as defaults (anonymous object)
	 * @return the manager object
	 */
	setDefaults: function(settings) {
		extendRemove(this._defaults, settings || {});
		return this;
	},

	/* Attach the date picker to a jQuery selection.
	 * @param  target	element - the target input field or division or span
	 * @param  settings  object - the new settings to use for this date picker instance (anonymous)
	 */
	_attachDatepicker: function(target, settings) {
		var nodeName, inline, inst;
		nodeName = target.nodeName.toLowerCase();
		inline = (nodeName === "div" || nodeName === "span");
		if (!target.id) {
			this.uuid += 1;
			target.id = "dp" + this.uuid;
		}
		inst = this._newInst($(target), inline);
		inst.settings = $.extend({}, settings || {});
		if (nodeName === "input") {
			this._connectDatepicker(target, inst);
		} else if (inline) {
			this._inlineDatepicker(target, inst);
		}
	},

	/* Create a new instance object. */
	_newInst: function(target, inline) {
		var id = target[0].id.replace(/([^A-Za-z0-9_\-])/g, "\\\\$1"); // escape jQuery meta chars
		return {id: id, input: target, // associated target
			selectedDay: 0, selectedMonth: 0, selectedYear: 0, // current selection
			drawMonth: 0, drawYear: 0, // month being drawn
			inline: inline, // is datepicker inline or not
			dpDiv: (!inline ? this.dpDiv : // presentation div
			bindHover($("<div class='" + this._inlineClass + " ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>")))};
	},

	/* Attach the date picker to an input field. */
	_connectDatepicker: function(target, inst) {
		var input = $(target);
		inst.append = $([]);
		inst.trigger = $([]);
		if (input.hasClass(this.markerClassName)) {
			return;
		}
		this._attachments(input, inst);
		input.addClass(this.markerClassName).keydown(this._doKeyDown).
			keypress(this._doKeyPress).keyup(this._doKeyUp);
		this._autoSize(inst);
		$.data(target, PROP_NAME, inst);
		//If disabled option is true, disable the datepicker once it has been attached to the input (see ticket #5665)
		if( inst.settings.disabled ) {
			this._disableDatepicker( target );
		}
	},

	/* Make attachments based on settings. */
	_attachments: function(input, inst) {
		var showOn, buttonText, buttonImage,
			appendText = this._get(inst, "appendText"),
			isRTL = this._get(inst, "isRTL");

		if (inst.append) {
			inst.append.remove();
		}
		if (appendText) {
			inst.append = $("<span class='" + this._appendClass + "'>" + appendText + "</span>");
			input[isRTL ? "before" : "after"](inst.append);
		}

		input.unbind("focus", this._showDatepicker);

		if (inst.trigger) {
			inst.trigger.remove();
		}

		showOn = this._get(inst, "showOn");
		if (showOn === "focus" || showOn === "both") { // pop-up date picker when in the marked field
			input.focus(this._showDatepicker);
		}
		if (showOn === "button" || showOn === "both") { // pop-up date picker when button clicked
			buttonText = this._get(inst, "buttonText");
			buttonImage = this._get(inst, "buttonImage");
			inst.trigger = $(this._get(inst, "buttonImageOnly") ?
				$("<img/>").addClass(this._triggerClass).
					attr({ src: buttonImage, alt: buttonText, title: buttonText }) :
				$("<button type='button'></button>").addClass(this._triggerClass).
					html(!buttonImage ? buttonText : $("<img/>").attr(
					{ src:buttonImage, alt:buttonText, title:buttonText })));
			input[isRTL ? "before" : "after"](inst.trigger);
			inst.trigger.click(function() {
				if ($.datepicker._datepickerShowing && $.datepicker._lastInput === input[0]) {
					$.datepicker._hideDatepicker();
				} else if ($.datepicker._datepickerShowing && $.datepicker._lastInput !== input[0]) {
					$.datepicker._hideDatepicker();
					$.datepicker._showDatepicker(input[0]);
				} else {
					$.datepicker._showDatepicker(input[0]);
				}
				return false;
			});
		}
	},

	/* Apply the maximum length for the date format. */
	_autoSize: function(inst) {
		if (this._get(inst, "autoSize") && !inst.inline) {
			var findMax, max, maxI, i,
				date = new Date(2009, 12 - 1, 20), // Ensure double digits
				dateFormat = this._get(inst, "dateFormat");

			if (dateFormat.match(/[DM]/)) {
				findMax = function(names) {
					max = 0;
					maxI = 0;
					for (i = 0; i < names.length; i++) {
						if (names[i].length > max) {
							max = names[i].length;
							maxI = i;
						}
					}
					return maxI;
				};
				date.setMonth(findMax(this._get(inst, (dateFormat.match(/MM/) ?
					"monthNames" : "monthNamesShort"))));
				date.setDate(findMax(this._get(inst, (dateFormat.match(/DD/) ?
					"dayNames" : "dayNamesShort"))) + 20 - date.getDay());
			}
			inst.input.attr("size", this._formatDate(inst, date).length);
		}
	},

	/* Attach an inline date picker to a div. */
	_inlineDatepicker: function(target, inst) {
		var divSpan = $(target);
		if (divSpan.hasClass(this.markerClassName)) {
			return;
		}
		divSpan.addClass(this.markerClassName).append(inst.dpDiv);
		$.data(target, PROP_NAME, inst);
		this._setDate(inst, this._getDefaultDate(inst), true);
		this._updateDatepicker(inst);
		this._updateAlternate(inst);
		//If disabled option is true, disable the datepicker before showing it (see ticket #5665)
		if( inst.settings.disabled ) {
			this._disableDatepicker( target );
		}
		// Set display:block in place of inst.dpDiv.show() which won't work on disconnected elements
		// http://bugs.jqueryui.com/ticket/7552 - A Datepicker created on a detached div has zero height
		inst.dpDiv.css( "display", "block" );
	},

	/* Pop-up the date picker in a "dialog" box.
	 * @param  input element - ignored
	 * @param  date	string or Date - the initial date to display
	 * @param  onSelect  function - the function to call when a date is selected
	 * @param  settings  object - update the dialog date picker instance's settings (anonymous object)
	 * @param  pos int[2] - coordinates for the dialog's position within the screen or
	 *					event - with x/y coordinates or
	 *					leave empty for default (screen centre)
	 * @return the manager object
	 */
	_dialogDatepicker: function(input, date, onSelect, settings, pos) {
		var id, browserWidth, browserHeight, scrollX, scrollY,
			inst = this._dialogInst; // internal instance

		if (!inst) {
			this.uuid += 1;
			id = "dp" + this.uuid;
			this._dialogInput = $("<input type='text' id='" + id +
				"' style='position: absolute; top: -100px; width: 0px;'/>");
			this._dialogInput.keydown(this._doKeyDown);
			$("body").append(this._dialogInput);
			inst = this._dialogInst = this._newInst(this._dialogInput, false);
			inst.settings = {};
			$.data(this._dialogInput[0], PROP_NAME, inst);
		}
		extendRemove(inst.settings, settings || {});
		date = (date && date.constructor === Date ? this._formatDate(inst, date) : date);
		this._dialogInput.val(date);

		this._pos = (pos ? (pos.length ? pos : [pos.pageX, pos.pageY]) : null);
		if (!this._pos) {
			browserWidth = document.documentElement.clientWidth;
			browserHeight = document.documentElement.clientHeight;
			scrollX = document.documentElement.scrollLeft || document.body.scrollLeft;
			scrollY = document.documentElement.scrollTop || document.body.scrollTop;
			this._pos = // should use actual width/height below
				[(browserWidth / 2) - 100 + scrollX, (browserHeight / 2) - 150 + scrollY];
		}

		// move input on screen for focus, but hidden behind dialog
		this._dialogInput.css("left", (this._pos[0] + 20) + "px").css("top", this._pos[1] + "px");
		inst.settings.onSelect = onSelect;
		this._inDialog = true;
		this.dpDiv.addClass(this._dialogClass);
		this._showDatepicker(this._dialogInput[0]);
		if ($.blockUI) {
			$.blockUI(this.dpDiv);
		}
		$.data(this._dialogInput[0], PROP_NAME, inst);
		return this;
	},

	/* Detach a datepicker from its control.
	 * @param  target	element - the target input field or division or span
	 */
	_destroyDatepicker: function(target) {
		var nodeName,
			$target = $(target),
			inst = $.data(target, PROP_NAME);

		if (!$target.hasClass(this.markerClassName)) {
			return;
		}

		nodeName = target.nodeName.toLowerCase();
		$.removeData(target, PROP_NAME);
		if (nodeName === "input") {
			inst.append.remove();
			inst.trigger.remove();
			$target.removeClass(this.markerClassName).
				unbind("focus", this._showDatepicker).
				unbind("keydown", this._doKeyDown).
				unbind("keypress", this._doKeyPress).
				unbind("keyup", this._doKeyUp);
		} else if (nodeName === "div" || nodeName === "span") {
			$target.removeClass(this.markerClassName).empty();
		}
	},

	/* Enable the date picker to a jQuery selection.
	 * @param  target	element - the target input field or division or span
	 */
	_enableDatepicker: function(target) {
		var nodeName, inline,
			$target = $(target),
			inst = $.data(target, PROP_NAME);

		if (!$target.hasClass(this.markerClassName)) {
			return;
		}

		nodeName = target.nodeName.toLowerCase();
		if (nodeName === "input") {
			target.disabled = false;
			inst.trigger.filter("button").
				each(function() { this.disabled = false; }).end().
				filter("img").css({opacity: "1.0", cursor: ""});
		} else if (nodeName === "div" || nodeName === "span") {
			inline = $target.children("." + this._inlineClass);
			inline.children().removeClass("ui-state-disabled");
			inline.find("select.ui-datepicker-month, select.ui-datepicker-year").
				prop("disabled", false);
		}
		this._disabledInputs = $.map(this._disabledInputs,
			function(value) { return (value === target ? null : value); }); // delete entry
	},

	/* Disable the date picker to a jQuery selection.
	 * @param  target	element - the target input field or division or span
	 */
	_disableDatepicker: function(target) {
		var nodeName, inline,
			$target = $(target),
			inst = $.data(target, PROP_NAME);

		if (!$target.hasClass(this.markerClassName)) {
			return;
		}

		nodeName = target.nodeName.toLowerCase();
		if (nodeName === "input") {
			target.disabled = true;
			inst.trigger.filter("button").
				each(function() { this.disabled = true; }).end().
				filter("img").css({opacity: "0.5", cursor: "default"});
		} else if (nodeName === "div" || nodeName === "span") {
			inline = $target.children("." + this._inlineClass);
			inline.children().addClass("ui-state-disabled");
			inline.find("select.ui-datepicker-month, select.ui-datepicker-year").
				prop("disabled", true);
		}
		this._disabledInputs = $.map(this._disabledInputs,
			function(value) { return (value === target ? null : value); }); // delete entry
		this._disabledInputs[this._disabledInputs.length] = target;
	},

	/* Is the first field in a jQuery collection disabled as a datepicker?
	 * @param  target	element - the target input field or division or span
	 * @return boolean - true if disabled, false if enabled
	 */
	_isDisabledDatepicker: function(target) {
		if (!target) {
			return false;
		}
		for (var i = 0; i < this._disabledInputs.length; i++) {
			if (this._disabledInputs[i] === target) {
				return true;
			}
		}
		return false;
	},

	/* Retrieve the instance data for the target control.
	 * @param  target  element - the target input field or division or span
	 * @return  object - the associated instance data
	 * @throws  error if a jQuery problem getting data
	 */
	_getInst: function(target) {
		try {
			return $.data(target, PROP_NAME);
		}
		catch (err) {
			throw "Missing instance data for this datepicker";
		}
	},

	/* Update or retrieve the settings for a date picker attached to an input field or division.
	 * @param  target  element - the target input field or division or span
	 * @param  name	object - the new settings to update or
	 *				string - the name of the setting to change or retrieve,
	 *				when retrieving also "all" for all instance settings or
	 *				"defaults" for all global defaults
	 * @param  value   any - the new value for the setting
	 *				(omit if above is an object or to retrieve a value)
	 */
	_optionDatepicker: function(target, name, value) {
		var settings, date, minDate, maxDate,
			inst = this._getInst(target);

		if (arguments.length === 2 && typeof name === "string") {
			return (name === "defaults" ? $.extend({}, $.datepicker._defaults) :
				(inst ? (name === "all" ? $.extend({}, inst.settings) :
				this._get(inst, name)) : null));
		}

		settings = name || {};
		if (typeof name === "string") {
			settings = {};
			settings[name] = value;
		}

		if (inst) {
			if (this._curInst === inst) {
				this._hideDatepicker();
			}

			date = this._getDateDatepicker(target, true);
			minDate = this._getMinMaxDate(inst, "min");
			maxDate = this._getMinMaxDate(inst, "max");
			extendRemove(inst.settings, settings);
			// reformat the old minDate/maxDate values if dateFormat changes and a new minDate/maxDate isn't provided
			if (minDate !== null && settings.dateFormat !== undefined && settings.minDate === undefined) {
				inst.settings.minDate = this._formatDate(inst, minDate);
			}
			if (maxDate !== null && settings.dateFormat !== undefined && settings.maxDate === undefined) {
				inst.settings.maxDate = this._formatDate(inst, maxDate);
			}
			if ( "disabled" in settings ) {
				if ( settings.disabled ) {
					this._disableDatepicker(target);
				} else {
					this._enableDatepicker(target);
				}
			}
			this._attachments($(target), inst);
			this._autoSize(inst);
			this._setDate(inst, date);
			this._updateAlternate(inst);
			this._updateDatepicker(inst);
		}
	},

	// change method deprecated
	_changeDatepicker: function(target, name, value) {
		this._optionDatepicker(target, name, value);
	},

	/* Redraw the date picker attached to an input field or division.
	 * @param  target  element - the target input field or division or span
	 */
	_refreshDatepicker: function(target) {
		var inst = this._getInst(target);
		if (inst) {
			this._updateDatepicker(inst);
		}
	},

	/* Set the dates for a jQuery selection.
	 * @param  target element - the target input field or division or span
	 * @param  date	Date - the new date
	 */
	_setDateDatepicker: function(target, date) {
		var inst = this._getInst(target);
		if (inst) {
			this._setDate(inst, date);
			this._updateDatepicker(inst);
			this._updateAlternate(inst);
		}
	},

	/* Get the date(s) for the first entry in a jQuery selection.
	 * @param  target element - the target input field or division or span
	 * @param  noDefault boolean - true if no default date is to be used
	 * @return Date - the current date
	 */
	_getDateDatepicker: function(target, noDefault) {
		var inst = this._getInst(target);
		if (inst && !inst.inline) {
			this._setDateFromField(inst, noDefault);
		}
		return (inst ? this._getDate(inst) : null);
	},

	/* Handle keystrokes. */
	_doKeyDown: function(event) {
		var onSelect, dateStr, sel,
			inst = $.datepicker._getInst(event.target),
			handled = true,
			isRTL = inst.dpDiv.is(".ui-datepicker-rtl");

		inst._keyEvent = true;
		if ($.datepicker._datepickerShowing) {
			switch (event.keyCode) {
				case 9: $.datepicker._hideDatepicker();
						handled = false;
						break; // hide on tab out
				case 13: sel = $("td." + $.datepicker._dayOverClass + ":not(." +
									$.datepicker._currentClass + ")", inst.dpDiv);
						if (sel[0]) {
							$.datepicker._selectDay(event.target, inst.selectedMonth, inst.selectedYear, sel[0]);
						}

						onSelect = $.datepicker._get(inst, "onSelect");
						if (onSelect) {
							dateStr = $.datepicker._formatDate(inst);

							// trigger custom callback
							onSelect.apply((inst.input ? inst.input[0] : null), [dateStr, inst]);
						} else {
							$.datepicker._hideDatepicker();
						}

						return false; // don't submit the form
				case 27: $.datepicker._hideDatepicker();
						break; // hide on escape
				case 33: $.datepicker._adjustDate(event.target, (event.ctrlKey ?
							-$.datepicker._get(inst, "stepBigMonths") :
							-$.datepicker._get(inst, "stepMonths")), "M");
						break; // previous month/year on page up/+ ctrl
				case 34: $.datepicker._adjustDate(event.target, (event.ctrlKey ?
							+$.datepicker._get(inst, "stepBigMonths") :
							+$.datepicker._get(inst, "stepMonths")), "M");
						break; // next month/year on page down/+ ctrl
				case 35: if (event.ctrlKey || event.metaKey) {
							$.datepicker._clearDate(event.target);
						}
						handled = event.ctrlKey || event.metaKey;
						break; // clear on ctrl or command +end
				case 36: if (event.ctrlKey || event.metaKey) {
							$.datepicker._gotoToday(event.target);
						}
						handled = event.ctrlKey || event.metaKey;
						break; // current on ctrl or command +home
				case 37: if (event.ctrlKey || event.metaKey) {
							$.datepicker._adjustDate(event.target, (isRTL ? +1 : -1), "D");
						}
						handled = event.ctrlKey || event.metaKey;
						// -1 day on ctrl or command +left
						if (event.originalEvent.altKey) {
							$.datepicker._adjustDate(event.target, (event.ctrlKey ?
								-$.datepicker._get(inst, "stepBigMonths") :
								-$.datepicker._get(inst, "stepMonths")), "M");
						}
						// next month/year on alt +left on Mac
						break;
				case 38: if (event.ctrlKey || event.metaKey) {
							$.datepicker._adjustDate(event.target, -7, "D");
						}
						handled = event.ctrlKey || event.metaKey;
						break; // -1 week on ctrl or command +up
				case 39: if (event.ctrlKey || event.metaKey) {
							$.datepicker._adjustDate(event.target, (isRTL ? -1 : +1), "D");
						}
						handled = event.ctrlKey || event.metaKey;
						// +1 day on ctrl or command +right
						if (event.originalEvent.altKey) {
							$.datepicker._adjustDate(event.target, (event.ctrlKey ?
								+$.datepicker._get(inst, "stepBigMonths") :
								+$.datepicker._get(inst, "stepMonths")), "M");
						}
						// next month/year on alt +right
						break;
				case 40: if (event.ctrlKey || event.metaKey) {
							$.datepicker._adjustDate(event.target, +7, "D");
						}
						handled = event.ctrlKey || event.metaKey;
						break; // +1 week on ctrl or command +down
				default: handled = false;
			}
		} else if (event.keyCode === 36 && event.ctrlKey) { // display the date picker on ctrl+home
			$.datepicker._showDatepicker(this);
		} else {
			handled = false;
		}

		if (handled) {
			event.preventDefault();
			event.stopPropagation();
		}
	},

	/* Filter entered characters - based on date format. */
	_doKeyPress: function(event) {
		var chars, chr,
			inst = $.datepicker._getInst(event.target);

		if ($.datepicker._get(inst, "constrainInput")) {
			chars = $.datepicker._possibleChars($.datepicker._get(inst, "dateFormat"));
			chr = String.fromCharCode(event.charCode == null ? event.keyCode : event.charCode);
			return event.ctrlKey || event.metaKey || (chr < " " || !chars || chars.indexOf(chr) > -1);
		}
	},

	/* Synchronise manual entry and field/alternate field. */
	_doKeyUp: function(event) {
		var date,
			inst = $.datepicker._getInst(event.target);

		if (inst.input.val() !== inst.lastVal) {
			try {
				date = $.datepicker.parseDate($.datepicker._get(inst, "dateFormat"),
					(inst.input ? inst.input.val() : null),
					$.datepicker._getFormatConfig(inst));

				if (date) { // only if valid
					$.datepicker._setDateFromField(inst);
					$.datepicker._updateAlternate(inst);
					$.datepicker._updateDatepicker(inst);
				}
			}
			catch (err) {
			}
		}
		return true;
	},

	/* Pop-up the date picker for a given input field.
	 * If false returned from beforeShow event handler do not show.
	 * @param  input  element - the input field attached to the date picker or
	 *					event - if triggered by focus
	 */
	_showDatepicker: function(input) {
		input = input.target || input;
		if (input.nodeName.toLowerCase() !== "input") { // find from button/image trigger
			input = $("input", input.parentNode)[0];
		}

		if ($.datepicker._isDisabledDatepicker(input) || $.datepicker._lastInput === input) { // already here
			return;
		}

		var inst, beforeShow, beforeShowSettings, isFixed,
			offset, showAnim, duration;

		inst = $.datepicker._getInst(input);
		if ($.datepicker._curInst && $.datepicker._curInst !== inst) {
			$.datepicker._curInst.dpDiv.stop(true, true);
			if ( inst && $.datepicker._datepickerShowing ) {
				$.datepicker._hideDatepicker( $.datepicker._curInst.input[0] );
			}
		}

		beforeShow = $.datepicker._get(inst, "beforeShow");
		beforeShowSettings = beforeShow ? beforeShow.apply(input, [input, inst]) : {};
		if(beforeShowSettings === false){
			return;
		}
		extendRemove(inst.settings, beforeShowSettings);

		inst.lastVal = null;
		$.datepicker._lastInput = input;
		$.datepicker._setDateFromField(inst);

		if ($.datepicker._inDialog) { // hide cursor
			input.value = "";
		}
		if (!$.datepicker._pos) { // position below input
			$.datepicker._pos = $.datepicker._findPos(input);
			$.datepicker._pos[1] += input.offsetHeight; // add the height
		}

		isFixed = false;
		$(input).parents().each(function() {
			isFixed |= $(this).css("position") === "fixed";
			return !isFixed;
		});

		offset = {left: $.datepicker._pos[0], top: $.datepicker._pos[1]};
		$.datepicker._pos = null;
		//to avoid flashes on Firefox
		inst.dpDiv.empty();
		// determine sizing offscreen
		inst.dpDiv.css({position: "absolute", display: "block", top: "-1000px"});
		$.datepicker._updateDatepicker(inst);
		// fix width for dynamic number of date pickers
		// and adjust position before showing
		offset = $.datepicker._checkOffset(inst, offset, isFixed);
		inst.dpDiv.css({position: ($.datepicker._inDialog && $.blockUI ?
			"static" : (isFixed ? "fixed" : "absolute")), display: "none",
			left: offset.left + "px", top: offset.top + "px"});

		if (!inst.inline) {
			showAnim = $.datepicker._get(inst, "showAnim");
			duration = $.datepicker._get(inst, "duration");
			inst.dpDiv.zIndex($(input).zIndex()+1);
			$.datepicker._datepickerShowing = true;

			if ( $.effects && $.effects.effect[ showAnim ] ) {
				inst.dpDiv.show(showAnim, $.datepicker._get(inst, "showOptions"), duration);
			} else {
				inst.dpDiv[showAnim || "show"](showAnim ? duration : null);
			}

			if ( $.datepicker._shouldFocusInput( inst ) ) {
				inst.input.focus();
			}

			$.datepicker._curInst = inst;
		}
	},

	/* Generate the date picker content. */
	_updateDatepicker: function(inst) {
		this.maxRows = 4; //Reset the max number of rows being displayed (see #7043)
		instActive = inst; // for delegate hover events
		inst.dpDiv.empty().append(this._generateHTML(inst));
		this._attachHandlers(inst);
		inst.dpDiv.find("." + this._dayOverClass + " a").mouseover();

		var origyearshtml,
			numMonths = this._getNumberOfMonths(inst),
			cols = numMonths[1],
			width = 17;

		inst.dpDiv.removeClass("ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4").width("");
		if (cols > 1) {
			inst.dpDiv.addClass("ui-datepicker-multi-" + cols).css("width", (width * cols) + "em");
		}
		inst.dpDiv[(numMonths[0] !== 1 || numMonths[1] !== 1 ? "add" : "remove") +
			"Class"]("ui-datepicker-multi");
		inst.dpDiv[(this._get(inst, "isRTL") ? "add" : "remove") +
			"Class"]("ui-datepicker-rtl");

		if (inst === $.datepicker._curInst && $.datepicker._datepickerShowing && $.datepicker._shouldFocusInput( inst ) ) {
			inst.input.focus();
		}

		// deffered render of the years select (to avoid flashes on Firefox)
		if( inst.yearshtml ){
			origyearshtml = inst.yearshtml;
			setTimeout(function(){
				//assure that inst.yearshtml didn't change.
				if( origyearshtml === inst.yearshtml && inst.yearshtml ){
					inst.dpDiv.find("select.ui-datepicker-year:first").replaceWith(inst.yearshtml);
				}
				origyearshtml = inst.yearshtml = null;
			}, 0);
		}
	},

	// #6694 - don't focus the input if it's already focused
	// this breaks the change event in IE
	// Support: IE and jQuery <1.9
	_shouldFocusInput: function( inst ) {
		return inst.input && inst.input.is( ":visible" ) && !inst.input.is( ":disabled" ) && !inst.input.is( ":focus" );
	},

	/* Check positioning to remain on screen. */
	_checkOffset: function(inst, offset, isFixed) {
		var dpWidth = inst.dpDiv.outerWidth(),
			dpHeight = inst.dpDiv.outerHeight(),
			inputWidth = inst.input ? inst.input.outerWidth() : 0,
			inputHeight = inst.input ? inst.input.outerHeight() : 0,
			viewWidth = document.documentElement.clientWidth + (isFixed ? 0 : $(document).scrollLeft()),
			viewHeight = document.documentElement.clientHeight + (isFixed ? 0 : $(document).scrollTop());

		offset.left -= (this._get(inst, "isRTL") ? (dpWidth - inputWidth) : 0);
		offset.left -= (isFixed && offset.left === inst.input.offset().left) ? $(document).scrollLeft() : 0;
		offset.top -= (isFixed && offset.top === (inst.input.offset().top + inputHeight)) ? $(document).scrollTop() : 0;

		// now check if datepicker is showing outside window viewport - move to a better place if so.
		offset.left -= Math.min(offset.left, (offset.left + dpWidth > viewWidth && viewWidth > dpWidth) ?
			Math.abs(offset.left + dpWidth - viewWidth) : 0);
		offset.top -= Math.min(offset.top, (offset.top + dpHeight > viewHeight && viewHeight > dpHeight) ?
			Math.abs(dpHeight + inputHeight) : 0);

		return offset;
	},

	/* Find an object's position on the screen. */
	_findPos: function(obj) {
		var position,
			inst = this._getInst(obj),
			isRTL = this._get(inst, "isRTL");

		while (obj && (obj.type === "hidden" || obj.nodeType !== 1 || $.expr.filters.hidden(obj))) {
			obj = obj[isRTL ? "previousSibling" : "nextSibling"];
		}

		position = $(obj).offset();
		return [position.left, position.top];
	},

	/* Hide the date picker from view.
	 * @param  input  element - the input field attached to the date picker
	 */
	_hideDatepicker: function(input) {
		var showAnim, duration, postProcess, onClose,
			inst = this._curInst;

		if (!inst || (input && inst !== $.data(input, PROP_NAME))) {
			return;
		}

		if (this._datepickerShowing) {
			showAnim = this._get(inst, "showAnim");
			duration = this._get(inst, "duration");
			postProcess = function() {
				$.datepicker._tidyDialog(inst);
			};

			// DEPRECATED: after BC for 1.8.x $.effects[ showAnim ] is not needed
			if ( $.effects && ( $.effects.effect[ showAnim ] || $.effects[ showAnim ] ) ) {
				inst.dpDiv.hide(showAnim, $.datepicker._get(inst, "showOptions"), duration, postProcess);
			} else {
				inst.dpDiv[(showAnim === "slideDown" ? "slideUp" :
					(showAnim === "fadeIn" ? "fadeOut" : "hide"))]((showAnim ? duration : null), postProcess);
			}

			if (!showAnim) {
				postProcess();
			}
			this._datepickerShowing = false;

			onClose = this._get(inst, "onClose");
			if (onClose) {
				onClose.apply((inst.input ? inst.input[0] : null), [(inst.input ? inst.input.val() : ""), inst]);
			}

			this._lastInput = null;
			if (this._inDialog) {
				this._dialogInput.css({ position: "absolute", left: "0", top: "-100px" });
				if ($.blockUI) {
					$.unblockUI();
					$("body").append(this.dpDiv);
				}
			}
			this._inDialog = false;
		}
	},

	/* Tidy up after a dialog display. */
	_tidyDialog: function(inst) {
		inst.dpDiv.removeClass(this._dialogClass).unbind(".ui-datepicker-calendar");
	},

	/* Close date picker if clicked elsewhere. */
	_checkExternalClick: function(event) {
		if (!$.datepicker._curInst) {
			return;
		}

		var $target = $(event.target),
			inst = $.datepicker._getInst($target[0]);

		if ( ( ( $target[0].id !== $.datepicker._mainDivId &&
				$target.parents("#" + $.datepicker._mainDivId).length === 0 &&
				!$target.hasClass($.datepicker.markerClassName) &&
				!$target.closest("." + $.datepicker._triggerClass).length &&
				$.datepicker._datepickerShowing && !($.datepicker._inDialog && $.blockUI) ) ) ||
			( $target.hasClass($.datepicker.markerClassName) && $.datepicker._curInst !== inst ) ) {
				$.datepicker._hideDatepicker();
		}
	},

	/* Adjust one of the date sub-fields. */
	_adjustDate: function(id, offset, period) {
		var target = $(id),
			inst = this._getInst(target[0]);

		if (this._isDisabledDatepicker(target[0])) {
			return;
		}
		this._adjustInstDate(inst, offset +
			(period === "M" ? this._get(inst, "showCurrentAtPos") : 0), // undo positioning
			period);
		this._updateDatepicker(inst);
	},

	/* Action for current link. */
	_gotoToday: function(id) {
		var date,
			target = $(id),
			inst = this._getInst(target[0]);

		if (this._get(inst, "gotoCurrent") && inst.currentDay) {
			inst.selectedDay = inst.currentDay;
			inst.drawMonth = inst.selectedMonth = inst.currentMonth;
			inst.drawYear = inst.selectedYear = inst.currentYear;
		} else {
			date = new Date();
			inst.selectedDay = date.getDate();
			inst.drawMonth = inst.selectedMonth = date.getMonth();
			inst.drawYear = inst.selectedYear = date.getFullYear();
		}
		this._notifyChange(inst);
		this._adjustDate(target);
	},

	/* Action for selecting a new month/year. */
	_selectMonthYear: function(id, select, period) {
		var target = $(id),
			inst = this._getInst(target[0]);

		inst["selected" + (period === "M" ? "Month" : "Year")] =
		inst["draw" + (period === "M" ? "Month" : "Year")] =
			parseInt(select.options[select.selectedIndex].value,10);

		this._notifyChange(inst);
		this._adjustDate(target);
	},

	/* Action for selecting a day. */
	_selectDay: function(id, month, year, td) {
		var inst,
			target = $(id);

		if ($(td).hasClass(this._unselectableClass) || this._isDisabledDatepicker(target[0])) {
			return;
		}

		inst = this._getInst(target[0]);
		inst.selectedDay = inst.currentDay = $("a", td).html();
		inst.selectedMonth = inst.currentMonth = month;
		inst.selectedYear = inst.currentYear = year;
		this._selectDate(id, this._formatDate(inst,
			inst.currentDay, inst.currentMonth, inst.currentYear));
	},

	/* Erase the input field and hide the date picker. */
	_clearDate: function(id) {
		var target = $(id);
		this._selectDate(target, "");
	},

	/* Update the input field with the selected date. */
	_selectDate: function(id, dateStr) {
		var onSelect,
			target = $(id),
			inst = this._getInst(target[0]);

		dateStr = (dateStr != null ? dateStr : this._formatDate(inst));
		if (inst.input) {
			inst.input.val(dateStr);
		}
		this._updateAlternate(inst);

		onSelect = this._get(inst, "onSelect");
		if (onSelect) {
			onSelect.apply((inst.input ? inst.input[0] : null), [dateStr, inst]);  // trigger custom callback
		} else if (inst.input) {
			inst.input.trigger("change"); // fire the change event
		}

		if (inst.inline){
			this._updateDatepicker(inst);
		} else {
			this._hideDatepicker();
			this._lastInput = inst.input[0];
			if (typeof(inst.input[0]) !== "object") {
				inst.input.focus(); // restore focus
			}
			this._lastInput = null;
		}
	},

	/* Update any alternate field to synchronise with the main field. */
	_updateAlternate: function(inst) {
		var altFormat, date, dateStr,
			altField = this._get(inst, "altField");

		if (altField) { // update alternate field too
			altFormat = this._get(inst, "altFormat") || this._get(inst, "dateFormat");
			date = this._getDate(inst);
			dateStr = this.formatDate(altFormat, date, this._getFormatConfig(inst));
			$(altField).each(function() { $(this).val(dateStr); });
		}
	},

	/* Set as beforeShowDay function to prevent selection of weekends.
	 * @param  date  Date - the date to customise
	 * @return [boolean, string] - is this date selectable?, what is its CSS class?
	 */
	noWeekends: function(date) {
		var day = date.getDay();
		return [(day > 0 && day < 6), ""];
	},

	/* Set as calculateWeek to determine the week of the year based on the ISO 8601 definition.
	 * @param  date  Date - the date to get the week for
	 * @return  number - the number of the week within the year that contains this date
	 */
	iso8601Week: function(date) {
		var time,
			checkDate = new Date(date.getTime());

		// Find Thursday of this week starting on Monday
		checkDate.setDate(checkDate.getDate() + 4 - (checkDate.getDay() || 7));

		time = checkDate.getTime();
		checkDate.setMonth(0); // Compare with Jan 1
		checkDate.setDate(1);
		return Math.floor(Math.round((time - checkDate) / 86400000) / 7) + 1;
	},

	/* Parse a string value into a date object.
	 * See formatDate below for the possible formats.
	 *
	 * @param  format string - the expected format of the date
	 * @param  value string - the date in the above format
	 * @param  settings Object - attributes include:
	 *					shortYearCutoff  number - the cutoff year for determining the century (optional)
	 *					dayNamesShort	string[7] - abbreviated names of the days from Sunday (optional)
	 *					dayNames		string[7] - names of the days from Sunday (optional)
	 *					monthNamesShort string[12] - abbreviated names of the months (optional)
	 *					monthNames		string[12] - names of the months (optional)
	 * @return  Date - the extracted date value or null if value is blank
	 */
	parseDate: function (format, value, settings) {
		if (format == null || value == null) {
			throw "Invalid arguments";
		}

		value = (typeof value === "object" ? value.toString() : value + "");
		if (value === "") {
			return null;
		}

		var iFormat, dim, extra,
			iValue = 0,
			shortYearCutoffTemp = (settings ? settings.shortYearCutoff : null) || this._defaults.shortYearCutoff,
			shortYearCutoff = (typeof shortYearCutoffTemp !== "string" ? shortYearCutoffTemp :
				new Date().getFullYear() % 100 + parseInt(shortYearCutoffTemp, 10)),
			dayNamesShort = (settings ? settings.dayNamesShort : null) || this._defaults.dayNamesShort,
			dayNames = (settings ? settings.dayNames : null) || this._defaults.dayNames,
			monthNamesShort = (settings ? settings.monthNamesShort : null) || this._defaults.monthNamesShort,
			monthNames = (settings ? settings.monthNames : null) || this._defaults.monthNames,
			year = -1,
			month = -1,
			day = -1,
			doy = -1,
			literal = false,
			date,
			// Check whether a format character is doubled
			lookAhead = function(match) {
				var matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) === match);
				if (matches) {
					iFormat++;
				}
				return matches;
			},
			// Extract a number from the string value
			getNumber = function(match) {
				var isDoubled = lookAhead(match),
					size = (match === "@" ? 14 : (match === "!" ? 20 :
					(match === "y" && isDoubled ? 4 : (match === "o" ? 3 : 2)))),
					digits = new RegExp("^\\d{1," + size + "}"),
					num = value.substring(iValue).match(digits);
				if (!num) {
					throw "Missing number at position " + iValue;
				}
				iValue += num[0].length;
				return parseInt(num[0], 10);
			},
			// Extract a name from the string value and convert to an index
			getName = function(match, shortNames, longNames) {
				var index = -1,
					names = $.map(lookAhead(match) ? longNames : shortNames, function (v, k) {
						return [ [k, v] ];
					}).sort(function (a, b) {
						return -(a[1].length - b[1].length);
					});

				$.each(names, function (i, pair) {
					var name = pair[1];
					if (value.substr(iValue, name.length).toLowerCase() === name.toLowerCase()) {
						index = pair[0];
						iValue += name.length;
						return false;
					}
				});
				if (index !== -1) {
					return index + 1;
				} else {
					throw "Unknown name at position " + iValue;
				}
			},
			// Confirm that a literal character matches the string value
			checkLiteral = function() {
				if (value.charAt(iValue) !== format.charAt(iFormat)) {
					throw "Unexpected literal at position " + iValue;
				}
				iValue++;
			};

		for (iFormat = 0; iFormat < format.length; iFormat++) {
			if (literal) {
				if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
					literal = false;
				} else {
					checkLiteral();
				}
			} else {
				switch (format.charAt(iFormat)) {
					case "d":
						day = getNumber("d");
						break;
					case "D":
						getName("D", dayNamesShort, dayNames);
						break;
					case "o":
						doy = getNumber("o");
						break;
					case "m":
						month = getNumber("m");
						break;
					case "M":
						month = getName("M", monthNamesShort, monthNames);
						break;
					case "y":
						year = getNumber("y");
						break;
					case "@":
						date = new Date(getNumber("@"));
						year = date.getFullYear();
						month = date.getMonth() + 1;
						day = date.getDate();
						break;
					case "!":
						date = new Date((getNumber("!") - this._ticksTo1970) / 10000);
						year = date.getFullYear();
						month = date.getMonth() + 1;
						day = date.getDate();
						break;
					case "'":
						if (lookAhead("'")){
							checkLiteral();
						} else {
							literal = true;
						}
						break;
					default:
						checkLiteral();
				}
			}
		}

		if (iValue < value.length){
			extra = value.substr(iValue);
			if (!/^\s+/.test(extra)) {
				throw "Extra/unparsed characters found in date: " + extra;
			}
		}

		if (year === -1) {
			year = new Date().getFullYear();
		} else if (year < 100) {
			year += new Date().getFullYear() - new Date().getFullYear() % 100 +
				(year <= shortYearCutoff ? 0 : -100);
		}

		if (doy > -1) {
			month = 1;
			day = doy;
			do {
				dim = this._getDaysInMonth(year, month - 1);
				if (day <= dim) {
					break;
				}
				month++;
				day -= dim;
			} while (true);
		}

		date = this._daylightSavingAdjust(new Date(year, month - 1, day));
		if (date.getFullYear() !== year || date.getMonth() + 1 !== month || date.getDate() !== day) {
			throw "Invalid date"; // E.g. 31/02/00
		}
		return date;
	},

	/* Standard date formats. */
	ATOM: "yy-mm-dd", // RFC 3339 (ISO 8601)
	COOKIE: "D, dd M yy",
	ISO_8601: "yy-mm-dd",
	RFC_822: "D, d M y",
	RFC_850: "DD, dd-M-y",
	RFC_1036: "D, d M y",
	RFC_1123: "D, d M yy",
	RFC_2822: "D, d M yy",
	RSS: "D, d M y", // RFC 822
	TICKS: "!",
	TIMESTAMP: "@",
	W3C: "yy-mm-dd", // ISO 8601

	_ticksTo1970: (((1970 - 1) * 365 + Math.floor(1970 / 4) - Math.floor(1970 / 100) +
		Math.floor(1970 / 400)) * 24 * 60 * 60 * 10000000),

	/* Format a date object into a string value.
	 * The format can be combinations of the following:
	 * d  - day of month (no leading zero)
	 * dd - day of month (two digit)
	 * o  - day of year (no leading zeros)
	 * oo - day of year (three digit)
	 * D  - day name short
	 * DD - day name long
	 * m  - month of year (no leading zero)
	 * mm - month of year (two digit)
	 * M  - month name short
	 * MM - month name long
	 * y  - year (two digit)
	 * yy - year (four digit)
	 * @ - Unix timestamp (ms since 01/01/1970)
	 * ! - Windows ticks (100ns since 01/01/0001)
	 * "..." - literal text
	 * '' - single quote
	 *
	 * @param  format string - the desired format of the date
	 * @param  date Date - the date value to format
	 * @param  settings Object - attributes include:
	 *					dayNamesShort	string[7] - abbreviated names of the days from Sunday (optional)
	 *					dayNames		string[7] - names of the days from Sunday (optional)
	 *					monthNamesShort string[12] - abbreviated names of the months (optional)
	 *					monthNames		string[12] - names of the months (optional)
	 * @return  string - the date in the above format
	 */
	formatDate: function (format, date, settings) {
		if (!date) {
			return "";
		}

		var iFormat,
			dayNamesShort = (settings ? settings.dayNamesShort : null) || this._defaults.dayNamesShort,
			dayNames = (settings ? settings.dayNames : null) || this._defaults.dayNames,
			monthNamesShort = (settings ? settings.monthNamesShort : null) || this._defaults.monthNamesShort,
			monthNames = (settings ? settings.monthNames : null) || this._defaults.monthNames,
			// Check whether a format character is doubled
			lookAhead = function(match) {
				var matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) === match);
				if (matches) {
					iFormat++;
				}
				return matches;
			},
			// Format a number, with leading zero if necessary
			formatNumber = function(match, value, len) {
				var num = "" + value;
				if (lookAhead(match)) {
					while (num.length < len) {
						num = "0" + num;
					}
				}
				return num;
			},
			// Format a name, short or long as requested
			formatName = function(match, value, shortNames, longNames) {
				return (lookAhead(match) ? longNames[value] : shortNames[value]);
			},
			output = "",
			literal = false;

		if (date) {
			for (iFormat = 0; iFormat < format.length; iFormat++) {
				if (literal) {
					if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
						literal = false;
					} else {
						output += format.charAt(iFormat);
					}
				} else {
					switch (format.charAt(iFormat)) {
						case "d":
							output += formatNumber("d", date.getDate(), 2);
							break;
						case "D":
							output += formatName("D", date.getDay(), dayNamesShort, dayNames);
							break;
						case "o":
							output += formatNumber("o",
								Math.round((new Date(date.getFullYear(), date.getMonth(), date.getDate()).getTime() - new Date(date.getFullYear(), 0, 0).getTime()) / 86400000), 3);
							break;
						case "m":
							output += formatNumber("m", date.getMonth() + 1, 2);
							break;
						case "M":
							output += formatName("M", date.getMonth(), monthNamesShort, monthNames);
							break;
						case "y":
							output += (lookAhead("y") ? date.getFullYear() :
								(date.getYear() % 100 < 10 ? "0" : "") + date.getYear() % 100);
							break;
						case "@":
							output += date.getTime();
							break;
						case "!":
							output += date.getTime() * 10000 + this._ticksTo1970;
							break;
						case "'":
							if (lookAhead("'")) {
								output += "'";
							} else {
								literal = true;
							}
							break;
						default:
							output += format.charAt(iFormat);
					}
				}
			}
		}
		return output;
	},

	/* Extract all possible characters from the date format. */
	_possibleChars: function (format) {
		var iFormat,
			chars = "",
			literal = false,
			// Check whether a format character is doubled
			lookAhead = function(match) {
				var matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) === match);
				if (matches) {
					iFormat++;
				}
				return matches;
			};

		for (iFormat = 0; iFormat < format.length; iFormat++) {
			if (literal) {
				if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
					literal = false;
				} else {
					chars += format.charAt(iFormat);
				}
			} else {
				switch (format.charAt(iFormat)) {
					case "d": case "m": case "y": case "@":
						chars += "0123456789";
						break;
					case "D": case "M":
						return null; // Accept anything
					case "'":
						if (lookAhead("'")) {
							chars += "'";
						} else {
							literal = true;
						}
						break;
					default:
						chars += format.charAt(iFormat);
				}
			}
		}
		return chars;
	},

	/* Get a setting value, defaulting if necessary. */
	_get: function(inst, name) {
		return inst.settings[name] !== undefined ?
			inst.settings[name] : this._defaults[name];
	},

	/* Parse existing date and initialise date picker. */
	_setDateFromField: function(inst, noDefault) {
		if (inst.input.val() === inst.lastVal) {
			return;
		}

		var dateFormat = this._get(inst, "dateFormat"),
			dates = inst.lastVal = inst.input ? inst.input.val() : null,
			defaultDate = this._getDefaultDate(inst),
			date = defaultDate,
			settings = this._getFormatConfig(inst);

		try {
			date = this.parseDate(dateFormat, dates, settings) || defaultDate;
		} catch (event) {
			dates = (noDefault ? "" : dates);
		}
		inst.selectedDay = date.getDate();
		inst.drawMonth = inst.selectedMonth = date.getMonth();
		inst.drawYear = inst.selectedYear = date.getFullYear();
		inst.currentDay = (dates ? date.getDate() : 0);
		inst.currentMonth = (dates ? date.getMonth() : 0);
		inst.currentYear = (dates ? date.getFullYear() : 0);
		this._adjustInstDate(inst);
	},

	/* Retrieve the default date shown on opening. */
	_getDefaultDate: function(inst) {
		return this._restrictMinMax(inst,
			this._determineDate(inst, this._get(inst, "defaultDate"), new Date()));
	},

	/* A date may be specified as an exact value or a relative one. */
	_determineDate: function(inst, date, defaultDate) {
		var offsetNumeric = function(offset) {
				var date = new Date();
				date.setDate(date.getDate() + offset);
				return date;
			},
			offsetString = function(offset) {
				try {
					return $.datepicker.parseDate($.datepicker._get(inst, "dateFormat"),
						offset, $.datepicker._getFormatConfig(inst));
				}
				catch (e) {
					// Ignore
				}

				var date = (offset.toLowerCase().match(/^c/) ?
					$.datepicker._getDate(inst) : null) || new Date(),
					year = date.getFullYear(),
					month = date.getMonth(),
					day = date.getDate(),
					pattern = /([+\-]?[0-9]+)\s*(d|D|w|W|m|M|y|Y)?/g,
					matches = pattern.exec(offset);

				while (matches) {
					switch (matches[2] || "d") {
						case "d" : case "D" :
							day += parseInt(matches[1],10); break;
						case "w" : case "W" :
							day += parseInt(matches[1],10) * 7; break;
						case "m" : case "M" :
							month += parseInt(matches[1],10);
							day = Math.min(day, $.datepicker._getDaysInMonth(year, month));
							break;
						case "y": case "Y" :
							year += parseInt(matches[1],10);
							day = Math.min(day, $.datepicker._getDaysInMonth(year, month));
							break;
					}
					matches = pattern.exec(offset);
				}
				return new Date(year, month, day);
			},
			newDate = (date == null || date === "" ? defaultDate : (typeof date === "string" ? offsetString(date) :
				(typeof date === "number" ? (isNaN(date) ? defaultDate : offsetNumeric(date)) : new Date(date.getTime()))));

		newDate = (newDate && newDate.toString() === "Invalid Date" ? defaultDate : newDate);
		if (newDate) {
			newDate.setHours(0);
			newDate.setMinutes(0);
			newDate.setSeconds(0);
			newDate.setMilliseconds(0);
		}
		return this._daylightSavingAdjust(newDate);
	},

	/* Handle switch to/from daylight saving.
	 * Hours may be non-zero on daylight saving cut-over:
	 * > 12 when midnight changeover, but then cannot generate
	 * midnight datetime, so jump to 1AM, otherwise reset.
	 * @param  date  (Date) the date to check
	 * @return  (Date) the corrected date
	 */
	_daylightSavingAdjust: function(date) {
		if (!date) {
			return null;
		}
		date.setHours(date.getHours() > 12 ? date.getHours() + 2 : 0);
		return date;
	},

	/* Set the date(s) directly. */
	_setDate: function(inst, date, noChange) {
		var clear = !date,
			origMonth = inst.selectedMonth,
			origYear = inst.selectedYear,
			newDate = this._restrictMinMax(inst, this._determineDate(inst, date, new Date()));

		inst.selectedDay = inst.currentDay = newDate.getDate();
		inst.drawMonth = inst.selectedMonth = inst.currentMonth = newDate.getMonth();
		inst.drawYear = inst.selectedYear = inst.currentYear = newDate.getFullYear();
		if ((origMonth !== inst.selectedMonth || origYear !== inst.selectedYear) && !noChange) {
			this._notifyChange(inst);
		}
		this._adjustInstDate(inst);
		if (inst.input) {
			inst.input.val(clear ? "" : this._formatDate(inst));
		}
	},

	/* Retrieve the date(s) directly. */
	_getDate: function(inst) {
		var startDate = (!inst.currentYear || (inst.input && inst.input.val() === "") ? null :
			this._daylightSavingAdjust(new Date(
			inst.currentYear, inst.currentMonth, inst.currentDay)));
			return startDate;
	},

	/* Attach the onxxx handlers.  These are declared statically so
	 * they work with static code transformers like Caja.
	 */
	_attachHandlers: function(inst) {
		var stepMonths = this._get(inst, "stepMonths"),
			id = "#" + inst.id.replace( /\\\\/g, "\\" );
		inst.dpDiv.find("[data-handler]").map(function () {
			var handler = {
				prev: function () {
					$.datepicker._adjustDate(id, -stepMonths, "M");
				},
				next: function () {
					$.datepicker._adjustDate(id, +stepMonths, "M");
				},
				hide: function () {
					$.datepicker._hideDatepicker();
				},
				today: function () {
					$.datepicker._gotoToday(id);
				},
				selectDay: function () {
					$.datepicker._selectDay(id, +this.getAttribute("data-month"), +this.getAttribute("data-year"), this);
					return false;
				},
				selectMonth: function () {
					$.datepicker._selectMonthYear(id, this, "M");
					return false;
				},
				selectYear: function () {
					$.datepicker._selectMonthYear(id, this, "Y");
					return false;
				}
			};
			$(this).bind(this.getAttribute("data-event"), handler[this.getAttribute("data-handler")]);
		});
	},

	/* Generate the HTML for the current state of the date picker. */
	_generateHTML: function(inst) {
		var maxDraw, prevText, prev, nextText, next, currentText, gotoDate,
			controls, buttonPanel, firstDay, showWeek, dayNames, dayNamesMin,
			monthNames, monthNamesShort, beforeShowDay, showOtherMonths,
			selectOtherMonths, defaultDate, html, dow, row, group, col, selectedDate,
			cornerClass, calender, thead, day, daysInMonth, leadDays, curRows, numRows,
			printDate, dRow, tbody, daySettings, otherMonth, unselectable,
			tempDate = new Date(),
			today = this._daylightSavingAdjust(
				new Date(tempDate.getFullYear(), tempDate.getMonth(), tempDate.getDate())), // clear time
			isRTL = this._get(inst, "isRTL"),
			showButtonPanel = this._get(inst, "showButtonPanel"),
			hideIfNoPrevNext = this._get(inst, "hideIfNoPrevNext"),
			navigationAsDateFormat = this._get(inst, "navigationAsDateFormat"),
			numMonths = this._getNumberOfMonths(inst),
			showCurrentAtPos = this._get(inst, "showCurrentAtPos"),
			stepMonths = this._get(inst, "stepMonths"),
			isMultiMonth = (numMonths[0] !== 1 || numMonths[1] !== 1),
			currentDate = this._daylightSavingAdjust((!inst.currentDay ? new Date(9999, 9, 9) :
				new Date(inst.currentYear, inst.currentMonth, inst.currentDay))),
			minDate = this._getMinMaxDate(inst, "min"),
			maxDate = this._getMinMaxDate(inst, "max"),
			drawMonth = inst.drawMonth - showCurrentAtPos,
			drawYear = inst.drawYear;

		if (drawMonth < 0) {
			drawMonth += 12;
			drawYear--;
		}
		if (maxDate) {
			maxDraw = this._daylightSavingAdjust(new Date(maxDate.getFullYear(),
				maxDate.getMonth() - (numMonths[0] * numMonths[1]) + 1, maxDate.getDate()));
			maxDraw = (minDate && maxDraw < minDate ? minDate : maxDraw);
			while (this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1)) > maxDraw) {
				drawMonth--;
				if (drawMonth < 0) {
					drawMonth = 11;
					drawYear--;
				}
			}
		}
		inst.drawMonth = drawMonth;
		inst.drawYear = drawYear;

		prevText = this._get(inst, "prevText");
		prevText = (!navigationAsDateFormat ? prevText : this.formatDate(prevText,
			this._daylightSavingAdjust(new Date(drawYear, drawMonth - stepMonths, 1)),
			this._getFormatConfig(inst)));

		prev = (this._canAdjustMonth(inst, -1, drawYear, drawMonth) ?
			"<a class='ui-datepicker-prev ui-corner-all' data-handler='prev' data-event='click'" +
			" title='" + prevText + "'><span class='ui-icon ui-icon-circle-triangle-" + ( isRTL ? "e" : "w") + "'>" + prevText + "</span></a>" :
			(hideIfNoPrevNext ? "" : "<a class='ui-datepicker-prev ui-corner-all ui-state-disabled' title='"+ prevText +"'><span class='ui-icon ui-icon-circle-triangle-" + ( isRTL ? "e" : "w") + "'>" + prevText + "</span></a>"));

		nextText = this._get(inst, "nextText");
		nextText = (!navigationAsDateFormat ? nextText : this.formatDate(nextText,
			this._daylightSavingAdjust(new Date(drawYear, drawMonth + stepMonths, 1)),
			this._getFormatConfig(inst)));

		next = (this._canAdjustMonth(inst, +1, drawYear, drawMonth) ?
			"<a class='ui-datepicker-next ui-corner-all' data-handler='next' data-event='click'" +
			" title='" + nextText + "'><span class='ui-icon ui-icon-circle-triangle-" + ( isRTL ? "w" : "e") + "'>" + nextText + "</span></a>" :
			(hideIfNoPrevNext ? "" : "<a class='ui-datepicker-next ui-corner-all ui-state-disabled' title='"+ nextText + "'><span class='ui-icon ui-icon-circle-triangle-" + ( isRTL ? "w" : "e") + "'>" + nextText + "</span></a>"));

		currentText = this._get(inst, "currentText");
		gotoDate = (this._get(inst, "gotoCurrent") && inst.currentDay ? currentDate : today);
		currentText = (!navigationAsDateFormat ? currentText :
			this.formatDate(currentText, gotoDate, this._getFormatConfig(inst)));

		controls = (!inst.inline ? "<button type='button' class='ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all' data-handler='hide' data-event='click'>" +
			this._get(inst, "closeText") + "</button>" : "");

		buttonPanel = (showButtonPanel) ? "<div class='ui-datepicker-buttonpane ui-widget-content'>" + (isRTL ? controls : "") +
			(this._isInRange(inst, gotoDate) ? "<button type='button' class='ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all' data-handler='today' data-event='click'" +
			">" + currentText + "</button>" : "") + (isRTL ? "" : controls) + "</div>" : "";

		firstDay = parseInt(this._get(inst, "firstDay"),10);
		firstDay = (isNaN(firstDay) ? 0 : firstDay);

		showWeek = this._get(inst, "showWeek");
		dayNames = this._get(inst, "dayNames");
		dayNamesMin = this._get(inst, "dayNamesMin");
		monthNames = this._get(inst, "monthNames");
		monthNamesShort = this._get(inst, "monthNamesShort");
		beforeShowDay = this._get(inst, "beforeShowDay");
		showOtherMonths = this._get(inst, "showOtherMonths");
		selectOtherMonths = this._get(inst, "selectOtherMonths");
		defaultDate = this._getDefaultDate(inst);
		html = "";
		dow;
		for (row = 0; row < numMonths[0]; row++) {
			group = "";
			this.maxRows = 4;
			for (col = 0; col < numMonths[1]; col++) {
				selectedDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, inst.selectedDay));
				cornerClass = " ui-corner-all";
				calender = "";
				if (isMultiMonth) {
					calender += "<div class='ui-datepicker-group";
					if (numMonths[1] > 1) {
						switch (col) {
							case 0: calender += " ui-datepicker-group-first";
								cornerClass = " ui-corner-" + (isRTL ? "right" : "left"); break;
							case numMonths[1]-1: calender += " ui-datepicker-group-last";
								cornerClass = " ui-corner-" + (isRTL ? "left" : "right"); break;
							default: calender += " ui-datepicker-group-middle"; cornerClass = ""; break;
						}
					}
					calender += "'>";
				}
				calender += "<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix" + cornerClass + "'>" +
					(/all|left/.test(cornerClass) && row === 0 ? (isRTL ? next : prev) : "") +
					(/all|right/.test(cornerClass) && row === 0 ? (isRTL ? prev : next) : "") +
					this._generateMonthYearHeader(inst, drawMonth, drawYear, minDate, maxDate,
					row > 0 || col > 0, monthNames, monthNamesShort) + // draw month headers
					"</div><table class='ui-datepicker-calendar'><thead>" +
					"<tr>";
				thead = (showWeek ? "<th class='ui-datepicker-week-col'>" + this._get(inst, "weekHeader") + "</th>" : "");
				for (dow = 0; dow < 7; dow++) { // days of the week
					day = (dow + firstDay) % 7;
					thead += "<th" + ((dow + firstDay + 6) % 7 >= 5 ? " class='ui-datepicker-week-end'" : "") + ">" +
						"<span title='" + dayNames[day] + "'>" + dayNamesMin[day] + "</span></th>";
				}
				calender += thead + "</tr></thead><tbody>";
				daysInMonth = this._getDaysInMonth(drawYear, drawMonth);
				if (drawYear === inst.selectedYear && drawMonth === inst.selectedMonth) {
					inst.selectedDay = Math.min(inst.selectedDay, daysInMonth);
				}
				leadDays = (this._getFirstDayOfMonth(drawYear, drawMonth) - firstDay + 7) % 7;
				curRows = Math.ceil((leadDays + daysInMonth) / 7); // calculate the number of rows to generate
				numRows = (isMultiMonth ? this.maxRows > curRows ? this.maxRows : curRows : curRows); //If multiple months, use the higher number of rows (see #7043)
				this.maxRows = numRows;
				printDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1 - leadDays));
				for (dRow = 0; dRow < numRows; dRow++) { // create date picker rows
					calender += "<tr>";
					tbody = (!showWeek ? "" : "<td class='ui-datepicker-week-col'>" +
						this._get(inst, "calculateWeek")(printDate) + "</td>");
					for (dow = 0; dow < 7; dow++) { // create date picker days
						daySettings = (beforeShowDay ?
							beforeShowDay.apply((inst.input ? inst.input[0] : null), [printDate]) : [true, ""]);
						otherMonth = (printDate.getMonth() !== drawMonth);
						unselectable = (otherMonth && !selectOtherMonths) || !daySettings[0] ||
							(minDate && printDate < minDate) || (maxDate && printDate > maxDate);
						tbody += "<td class='" +
							((dow + firstDay + 6) % 7 >= 5 ? " ui-datepicker-week-end" : "") + // highlight weekends
							(otherMonth ? " ui-datepicker-other-month" : "") + // highlight days from other months
							((printDate.getTime() === selectedDate.getTime() && drawMonth === inst.selectedMonth && inst._keyEvent) || // user pressed key
							(defaultDate.getTime() === printDate.getTime() && defaultDate.getTime() === selectedDate.getTime()) ?
							// or defaultDate is current printedDate and defaultDate is selectedDate
							" " + this._dayOverClass : "") + // highlight selected day
							(unselectable ? " " + this._unselectableClass + " ui-state-disabled": "") +  // highlight unselectable days
							(otherMonth && !showOtherMonths ? "" : " " + daySettings[1] + // highlight custom dates
							(printDate.getTime() === currentDate.getTime() ? " " + this._currentClass : "") + // highlight selected day
							(printDate.getTime() === today.getTime() ? " ui-datepicker-today" : "")) + "'" + // highlight today (if different)
							((!otherMonth || showOtherMonths) && daySettings[2] ? " title='" + daySettings[2].replace(/'/g, "&#39;") + "'" : "") + // cell title
							(unselectable ? "" : " data-handler='selectDay' data-event='click' data-month='" + printDate.getMonth() + "' data-year='" + printDate.getFullYear() + "'") + ">" + // actions
							(otherMonth && !showOtherMonths ? "&#xa0;" : // display for other months
							(unselectable ? "<span class='ui-state-default'>" + printDate.getDate() + "</span>" : "<a class='ui-state-default" +
							(printDate.getTime() === today.getTime() ? " ui-state-highlight" : "") +
							(printDate.getTime() === currentDate.getTime() ? " ui-state-active" : "") + // highlight selected day
							(otherMonth ? " ui-priority-secondary" : "") + // distinguish dates from other months
							"' href='#'>" + printDate.getDate() + "</a>")) + "</td>"; // display selectable date
						printDate.setDate(printDate.getDate() + 1);
						printDate = this._daylightSavingAdjust(printDate);
					}
					calender += tbody + "</tr>";
				}
				drawMonth++;
				if (drawMonth > 11) {
					drawMonth = 0;
					drawYear++;
				}
				calender += "</tbody></table>" + (isMultiMonth ? "</div>" +
							((numMonths[0] > 0 && col === numMonths[1]-1) ? "<div class='ui-datepicker-row-break'></div>" : "") : "");
				group += calender;
			}
			html += group;
		}
		html += buttonPanel;
		inst._keyEvent = false;
		return html;
	},

	/* Generate the month and year header. */
	_generateMonthYearHeader: function(inst, drawMonth, drawYear, minDate, maxDate,
			secondary, monthNames, monthNamesShort) {

		var inMinYear, inMaxYear, month, years, thisYear, determineYear, year, endYear,
			changeMonth = this._get(inst, "changeMonth"),
			changeYear = this._get(inst, "changeYear"),
			showMonthAfterYear = this._get(inst, "showMonthAfterYear"),
			html = "<div class='ui-datepicker-title'>",
			monthHtml = "";

		// month selection
		if (secondary || !changeMonth) {
			monthHtml += "<span class='ui-datepicker-month'>" + monthNames[drawMonth] + "</span>";
		} else {
			inMinYear = (minDate && minDate.getFullYear() === drawYear);
			inMaxYear = (maxDate && maxDate.getFullYear() === drawYear);
			monthHtml += "<select class='ui-datepicker-month' data-handler='selectMonth' data-event='change'>";
			for ( month = 0; month < 12; month++) {
				if ((!inMinYear || month >= minDate.getMonth()) && (!inMaxYear || month <= maxDate.getMonth())) {
					monthHtml += "<option value='" + month + "'" +
						(month === drawMonth ? " selected='selected'" : "") +
						">" + monthNamesShort[month] + "</option>";
				}
			}
			monthHtml += "</select>";
		}

		if (!showMonthAfterYear) {
			html += monthHtml + (secondary || !(changeMonth && changeYear) ? "&#xa0;" : "");
		}

		// year selection
		if ( !inst.yearshtml ) {
			inst.yearshtml = "";
			if (secondary || !changeYear) {
				html += "<span class='ui-datepicker-year'>" + drawYear + "</span>";
			} else {
				// determine range of years to display
				years = this._get(inst, "yearRange").split(":");
				thisYear = new Date().getFullYear();
				determineYear = function(value) {
					var year = (value.match(/c[+\-].*/) ? drawYear + parseInt(value.substring(1), 10) :
						(value.match(/[+\-].*/) ? thisYear + parseInt(value, 10) :
						parseInt(value, 10)));
					return (isNaN(year) ? thisYear : year);
				};
				year = determineYear(years[0]);
				endYear = Math.max(year, determineYear(years[1] || ""));
				year = (minDate ? Math.max(year, minDate.getFullYear()) : year);
				endYear = (maxDate ? Math.min(endYear, maxDate.getFullYear()) : endYear);
				inst.yearshtml += "<select class='ui-datepicker-year' data-handler='selectYear' data-event='change'>";
				for (; year <= endYear; year++) {
					inst.yearshtml += "<option value='" + year + "'" +
						(year === drawYear ? " selected='selected'" : "") +
						">" + year + "</option>";
				}
				inst.yearshtml += "</select>";

				html += inst.yearshtml;
				inst.yearshtml = null;
			}
		}

		html += this._get(inst, "yearSuffix");
		if (showMonthAfterYear) {
			html += (secondary || !(changeMonth && changeYear) ? "&#xa0;" : "") + monthHtml;
		}
		html += "</div>"; // Close datepicker_header
		return html;
	},

	/* Adjust one of the date sub-fields. */
	_adjustInstDate: function(inst, offset, period) {
		var year = inst.drawYear + (period === "Y" ? offset : 0),
			month = inst.drawMonth + (period === "M" ? offset : 0),
			day = Math.min(inst.selectedDay, this._getDaysInMonth(year, month)) + (period === "D" ? offset : 0),
			date = this._restrictMinMax(inst, this._daylightSavingAdjust(new Date(year, month, day)));

		inst.selectedDay = date.getDate();
		inst.drawMonth = inst.selectedMonth = date.getMonth();
		inst.drawYear = inst.selectedYear = date.getFullYear();
		if (period === "M" || period === "Y") {
			this._notifyChange(inst);
		}
	},

	/* Ensure a date is within any min/max bounds. */
	_restrictMinMax: function(inst, date) {
		var minDate = this._getMinMaxDate(inst, "min"),
			maxDate = this._getMinMaxDate(inst, "max"),
			newDate = (minDate && date < minDate ? minDate : date);
		return (maxDate && newDate > maxDate ? maxDate : newDate);
	},

	/* Notify change of month/year. */
	_notifyChange: function(inst) {
		var onChange = this._get(inst, "onChangeMonthYear");
		if (onChange) {
			onChange.apply((inst.input ? inst.input[0] : null),
				[inst.selectedYear, inst.selectedMonth + 1, inst]);
		}
	},

	/* Determine the number of months to show. */
	_getNumberOfMonths: function(inst) {
		var numMonths = this._get(inst, "numberOfMonths");
		return (numMonths == null ? [1, 1] : (typeof numMonths === "number" ? [1, numMonths] : numMonths));
	},

	/* Determine the current maximum date - ensure no time components are set. */
	_getMinMaxDate: function(inst, minMax) {
		return this._determineDate(inst, this._get(inst, minMax + "Date"), null);
	},

	/* Find the number of days in a given month. */
	_getDaysInMonth: function(year, month) {
		return 32 - this._daylightSavingAdjust(new Date(year, month, 32)).getDate();
	},

	/* Find the day of the week of the first of a month. */
	_getFirstDayOfMonth: function(year, month) {
		return new Date(year, month, 1).getDay();
	},

	/* Determines if we should allow a "next/prev" month display change. */
	_canAdjustMonth: function(inst, offset, curYear, curMonth) {
		var numMonths = this._getNumberOfMonths(inst),
			date = this._daylightSavingAdjust(new Date(curYear,
			curMonth + (offset < 0 ? offset : numMonths[0] * numMonths[1]), 1));

		if (offset < 0) {
			date.setDate(this._getDaysInMonth(date.getFullYear(), date.getMonth()));
		}
		return this._isInRange(inst, date);
	},

	/* Is the given date in the accepted range? */
	_isInRange: function(inst, date) {
		var yearSplit, currentYear,
			minDate = this._getMinMaxDate(inst, "min"),
			maxDate = this._getMinMaxDate(inst, "max"),
			minYear = null,
			maxYear = null,
			years = this._get(inst, "yearRange");
			if (years){
				yearSplit = years.split(":");
				currentYear = new Date().getFullYear();
				minYear = parseInt(yearSplit[0], 10);
				maxYear = parseInt(yearSplit[1], 10);
				if ( yearSplit[0].match(/[+\-].*/) ) {
					minYear += currentYear;
				}
				if ( yearSplit[1].match(/[+\-].*/) ) {
					maxYear += currentYear;
				}
			}

		return ((!minDate || date.getTime() >= minDate.getTime()) &&
			(!maxDate || date.getTime() <= maxDate.getTime()) &&
			(!minYear || date.getFullYear() >= minYear) &&
			(!maxYear || date.getFullYear() <= maxYear));
	},

	/* Provide the configuration settings for formatting/parsing. */
	_getFormatConfig: function(inst) {
		var shortYearCutoff = this._get(inst, "shortYearCutoff");
		shortYearCutoff = (typeof shortYearCutoff !== "string" ? shortYearCutoff :
			new Date().getFullYear() % 100 + parseInt(shortYearCutoff, 10));
		return {shortYearCutoff: shortYearCutoff,
			dayNamesShort: this._get(inst, "dayNamesShort"), dayNames: this._get(inst, "dayNames"),
			monthNamesShort: this._get(inst, "monthNamesShort"), monthNames: this._get(inst, "monthNames")};
	},

	/* Format the given date for display. */
	_formatDate: function(inst, day, month, year) {
		if (!day) {
			inst.currentDay = inst.selectedDay;
			inst.currentMonth = inst.selectedMonth;
			inst.currentYear = inst.selectedYear;
		}
		var date = (day ? (typeof day === "object" ? day :
			this._daylightSavingAdjust(new Date(year, month, day))) :
			this._daylightSavingAdjust(new Date(inst.currentYear, inst.currentMonth, inst.currentDay)));
		return this.formatDate(this._get(inst, "dateFormat"), date, this._getFormatConfig(inst));
	}
});

/*
 * Bind hover events for datepicker elements.
 * Done via delegate so the binding only occurs once in the lifetime of the parent div.
 * Global instActive, set by _updateDatepicker allows the handlers to find their way back to the active picker.
 */
function bindHover(dpDiv) {
	var selector = "button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a";
	return dpDiv.delegate(selector, "mouseout", function() {
			$(this).removeClass("ui-state-hover");
			if (this.className.indexOf("ui-datepicker-prev") !== -1) {
				$(this).removeClass("ui-datepicker-prev-hover");
			}
			if (this.className.indexOf("ui-datepicker-next") !== -1) {
				$(this).removeClass("ui-datepicker-next-hover");
			}
		})
		.delegate(selector, "mouseover", function(){
			if (!$.datepicker._isDisabledDatepicker( instActive.inline ? dpDiv.parent()[0] : instActive.input[0])) {
				$(this).parents(".ui-datepicker-calendar").find("a").removeClass("ui-state-hover");
				$(this).addClass("ui-state-hover");
				if (this.className.indexOf("ui-datepicker-prev") !== -1) {
					$(this).addClass("ui-datepicker-prev-hover");
				}
				if (this.className.indexOf("ui-datepicker-next") !== -1) {
					$(this).addClass("ui-datepicker-next-hover");
				}
			}
		});
}

/* jQuery extend now ignores nulls! */
function extendRemove(target, props) {
	$.extend(target, props);
	for (var name in props) {
		if (props[name] == null) {
			target[name] = props[name];
		}
	}
	return target;
}

/* Invoke the datepicker functionality.
   @param  options  string - a command, optionally followed by additional parameters or
					Object - settings for attaching new datepicker functionality
   @return  jQuery object */
$.fn.datepicker = function(options){

	/* Verify an empty collection wasn't passed - Fixes #6976 */
	if ( !this.length ) {
		return this;
	}

	/* Initialise the date picker. */
	if (!$.datepicker.initialized) {
		$(document).mousedown($.datepicker._checkExternalClick);
		$.datepicker.initialized = true;
	}

	/* Append datepicker main container to body if not exist. */
	if ($("#"+$.datepicker._mainDivId).length === 0) {
		$("body").append($.datepicker.dpDiv);
	}

	var otherArgs = Array.prototype.slice.call(arguments, 1);
	if (typeof options === "string" && (options === "isDisabled" || options === "getDate" || options === "widget")) {
		return $.datepicker["_" + options + "Datepicker"].
			apply($.datepicker, [this[0]].concat(otherArgs));
	}
	if (options === "option" && arguments.length === 2 && typeof arguments[1] === "string") {
		return $.datepicker["_" + options + "Datepicker"].
			apply($.datepicker, [this[0]].concat(otherArgs));
	}
	return this.each(function() {
		typeof options === "string" ?
			$.datepicker["_" + options + "Datepicker"].
				apply($.datepicker, [this].concat(otherArgs)) :
			$.datepicker._attachDatepicker(this, options);
	});
};

$.datepicker = new Datepicker(); // singleton instance
$.datepicker.initialized = false;
$.datepicker.uuid = new Date().getTime();
$.datepicker.version = "1.10.3";

})(jQuery);

(function () {
	"use strict";

	var ExtInfo = Class({
		__init__: function (hnode) {
			this.win = hnode;
			this.baseurl = Leo.Urls.remoteUrl('/dictQuery/m-query/conf/' + lp + '/query.conf/entry.html');
		},
		show: function (uid) {
			if (!Leo.Browser.checkAsyncUpdate())
				return;

			if (touch) {
				this.win.fadeIn();
			}
			else {
				this.win = this.win.dialog({
						width: 1000,
						height: 600
					});
			}

			this.win.empty().spin();
			$.ajaxAsync(this.baseurl, {
					type: 'GET',
					dataType: 'html',
					data: {
						uid: uid
					}
				}).react({
					success: this.handleLoadSuccess_.bind(this),
					error: this.handleLoadError_.bind(this)
				});
		},
		handleFormSubmit_: function (eventObject, button) {
			cancelEvent(eventObject);
			var query = this.baseurl + '?' + this.win.find('form').serialize();
			if (button)
				query += '&fetch=' + button;
			$.ajaxAsync(query, {
					type: 'GET',
					dataType: 'html'
				}).react({
					success: this.handleLoadSuccess_.bind(this),
					error: this.handleLoadError_.bind(this)
				});
			return false;
		},
		handleLoadSuccess_: function (hdoc) {
			this.win.spin('stop');
			hdoc = $('<div class="section"></div>').append($(hdoc).filter(':not(title)'));
			hdoc.find("form").on('submit', this.handleFormSubmit_.bind(this));
			var that = this;
			hdoc.find("input[name='fetch']").on('click', function (eventObject) {
				that.handleFormSubmit_(eventObject, this.value);
			});
			this.win.empty().append(hdoc);
		},
		handleLoadError_: function ( ){
			this.win.spin('stop');
			Leo.dict.errorPopup("Anfrage fehlgeschlagen");
		}
	});

	Names.extend('Leo.Dict', {
		ExtInfo: ExtInfo
	});

})();

function setLeoOrgCookie(cookiename, value) {
	if (getCookiePermission()) {
		setCookie(cookiename, value, 10000, '/');
	}
}

function getCookiePermission(whichCookie) {
	var userAllowsCookies = false;
	if (getCookie("config") || getCookie("assistance") || getCookie("setFocus")) {
		userAllowsCookies = true;
	}
	if (!userAllowsCookies) {
		userAllowsCookies = window.confirm(_("Hiermit stimmen Sie zu, dass die LEO GmbH dauerhaft ein Cookie bei Ihnen setzen darf, um die Konfiguration für dict.leo.org zu speichern."));
	}
	return userAllowsCookies;
}
/*
 * jPlayer Plugin for jQuery JavaScript Library
 * http://www.jplayer.org
 *
 * Copyright (c) 2009 - 2012 Happyworm Ltd
 * Dual licensed under the MIT and GPL licenses.
 *  - http://www.opensource.org/licenses/mit-license.php
 *  - http://www.gnu.org/copyleft/gpl.html
 *
 * Author: Mark J Panaghiston
 * Version: 2.2.0
 * Date: 13th September 2012
 */

(function(b,f){b.fn.jPlayer=function(a){var c="string"===typeof a,d=Array.prototype.slice.call(arguments,1),e=this,a=!c&&d.length?b.extend.apply(null,[!0,a].concat(d)):a;if(c&&"_"===a.charAt(0))return e;c?this.each(function(){var c=b.data(this,"jPlayer"),h=c&&b.isFunction(c[a])?c[a].apply(c,d):c;if(h!==c&&h!==f)return e=h,!1}):this.each(function(){var c=b.data(this,"jPlayer");c?c.option(a||{}):b.data(this,"jPlayer",new b.jPlayer(a,this))});return e};b.jPlayer=function(a,c){if(arguments.length){this.element=
b(c);this.options=b.extend(!0,{},this.options,a);var d=this;this.element.bind("remove.jPlayer",function(){d.destroy()});this._init()}};b.jPlayer.emulateMethods="load play pause";b.jPlayer.emulateStatus="src readyState networkState currentTime duration paused ended playbackRate";b.jPlayer.emulateOptions="muted volume";b.jPlayer.reservedEvent="ready flashreset resize repeat error warning";b.jPlayer.event={ready:"jPlayer_ready",flashreset:"jPlayer_flashreset",resize:"jPlayer_resize",repeat:"jPlayer_repeat",
click:"jPlayer_click",error:"jPlayer_error",warning:"jPlayer_warning",loadstart:"jPlayer_loadstart",progress:"jPlayer_progress",suspend:"jPlayer_suspend",abort:"jPlayer_abort",emptied:"jPlayer_emptied",stalled:"jPlayer_stalled",play:"jPlayer_play",pause:"jPlayer_pause",loadedmetadata:"jPlayer_loadedmetadata",loadeddata:"jPlayer_loadeddata",waiting:"jPlayer_waiting",playing:"jPlayer_playing",canplay:"jPlayer_canplay",canplaythrough:"jPlayer_canplaythrough",seeking:"jPlayer_seeking",seeked:"jPlayer_seeked",
timeupdate:"jPlayer_timeupdate",ended:"jPlayer_ended",ratechange:"jPlayer_ratechange",durationchange:"jPlayer_durationchange",volumechange:"jPlayer_volumechange"};b.jPlayer.htmlEvent="loadstart abort emptied stalled loadedmetadata loadeddata canplay canplaythrough ratechange".split(" ");b.jPlayer.pause=function(){b.each(b.jPlayer.prototype.instances,function(a,c){c.data("jPlayer").status.srcSet&&c.jPlayer("pause")})};b.jPlayer.timeFormat={showHour:!1,showMin:!0,showSec:!0,padHour:!1,padMin:!0,padSec:!0,
sepHour:":",sepMin:":",sepSec:""};b.jPlayer.convertTime=function(a){var c=new Date(1E3*a),d=c.getUTCHours(),a=c.getUTCMinutes(),c=c.getUTCSeconds(),d=b.jPlayer.timeFormat.padHour&&10>d?"0"+d:d,a=b.jPlayer.timeFormat.padMin&&10>a?"0"+a:a,c=b.jPlayer.timeFormat.padSec&&10>c?"0"+c:c;return(b.jPlayer.timeFormat.showHour?d+b.jPlayer.timeFormat.sepHour:"")+(b.jPlayer.timeFormat.showMin?a+b.jPlayer.timeFormat.sepMin:"")+(b.jPlayer.timeFormat.showSec?c+b.jPlayer.timeFormat.sepSec:"")};b.jPlayer.uaBrowser=
function(a){var a=a.toLowerCase(),c=/(opera)(?:.*version)?[ \/]([\w.]+)/,b=/(msie) ([\w.]+)/,e=/(mozilla)(?:.*? rv:([\w.]+))?/,a=/(webkit)[ \/]([\w.]+)/.exec(a)||c.exec(a)||b.exec(a)||0>a.indexOf("compatible")&&e.exec(a)||[];return{browser:a[1]||"",version:a[2]||"0"}};b.jPlayer.uaPlatform=function(a){var b=a.toLowerCase(),d=/(android)/,e=/(mobile)/,a=/(ipad|iphone|ipod|android|blackberry|playbook|windows ce|webos)/.exec(b)||[],b=/(ipad|playbook)/.exec(b)||!e.exec(b)&&d.exec(b)||[];a[1]&&(a[1]=a[1].replace(/\s/g,
"_"));return{platform:a[1]||"",tablet:b[1]||""}};b.jPlayer.browser={};b.jPlayer.platform={};var i=b.jPlayer.uaBrowser(navigator.userAgent);i.browser&&(b.jPlayer.browser[i.browser]=!0,b.jPlayer.browser.version=i.version);i=b.jPlayer.uaPlatform(navigator.userAgent);i.platform&&(b.jPlayer.platform[i.platform]=!0,b.jPlayer.platform.mobile=!i.tablet,b.jPlayer.platform.tablet=!!i.tablet);b.jPlayer.prototype={count:0,version:{script:"2.2.0",needFlash:"2.2.0",flash:"unknown"},options:{swfPath:"js",solution:"html, flash",
supplied:"mp3",preload:"metadata",volume:0.8,muted:!1,wmode:"opaque",backgroundColor:"#000000",cssSelectorAncestor:"#jp_container_1",cssSelector:{videoPlay:".jp-video-play",play:".jp-play",pause:".jp-pause",stop:".jp-stop",seekBar:".jp-seek-bar",playBar:".jp-play-bar",mute:".jp-mute",unmute:".jp-unmute",volumeBar:".jp-volume-bar",volumeBarValue:".jp-volume-bar-value",volumeMax:".jp-volume-max",currentTime:".jp-current-time",duration:".jp-duration",fullScreen:".jp-full-screen",restoreScreen:".jp-restore-screen",
repeat:".jp-repeat",repeatOff:".jp-repeat-off",gui:".jp-gui",noSolution:".jp-no-solution"},fullScreen:!1,autohide:{restored:!1,full:!0,fadeIn:200,fadeOut:600,hold:1E3},loop:!1,repeat:function(a){a.jPlayer.options.loop?b(this).unbind(".jPlayerRepeat").bind(b.jPlayer.event.ended+".jPlayer.jPlayerRepeat",function(){b(this).jPlayer("play")}):b(this).unbind(".jPlayerRepeat")},nativeVideoControls:{},noFullScreen:{msie:/msie [0-6]/,ipad:/ipad.*?os [0-4]/,iphone:/iphone/,ipod:/ipod/,android_pad:/android [0-3](?!.*?mobile)/,
android_phone:/android.*?mobile/,blackberry:/blackberry/,windows_ce:/windows ce/,webos:/webos/},noVolume:{ipad:/ipad/,iphone:/iphone/,ipod:/ipod/,android_pad:/android(?!.*?mobile)/,android_phone:/android.*?mobile/,blackberry:/blackberry/,windows_ce:/windows ce/,webos:/webos/,playbook:/playbook/},verticalVolume:!1,idPrefix:"jp",noConflict:"jQuery",emulateHtml:!1,errorAlerts:!1,warningAlerts:!1},optionsAudio:{size:{width:"0px",height:"0px",cssClass:""},sizeFull:{width:"0px",height:"0px",cssClass:""}},
optionsVideo:{size:{width:"480px",height:"270px",cssClass:"jp-video-270p"},sizeFull:{width:"100%",height:"100%",cssClass:"jp-video-full"}},instances:{},status:{src:"",media:{},paused:!0,format:{},formatType:"",waitForPlay:!0,waitForLoad:!0,srcSet:!1,video:!1,seekPercent:0,currentPercentRelative:0,currentPercentAbsolute:0,currentTime:0,duration:0,readyState:0,networkState:0,playbackRate:1,ended:0},internal:{ready:!1},solution:{html:!0,flash:!0},format:{mp3:{codec:'audio/mpeg; codecs="mp3"',flashCanPlay:!0,
media:"audio"},m4a:{codec:'audio/mp4; codecs="mp4a.40.2"',flashCanPlay:!0,media:"audio"},oga:{codec:'audio/ogg; codecs="vorbis"',flashCanPlay:!1,media:"audio"},wav:{codec:'audio/wav; codecs="1"',flashCanPlay:!1,media:"audio"},webma:{codec:'audio/webm; codecs="vorbis"',flashCanPlay:!1,media:"audio"},fla:{codec:"audio/x-flv",flashCanPlay:!0,media:"audio"},rtmpa:{codec:'audio/rtmp; codecs="rtmp"',flashCanPlay:!0,media:"audio"},m4v:{codec:'video/mp4; codecs="avc1.42E01E, mp4a.40.2"',flashCanPlay:!0,media:"video"},
ogv:{codec:'video/ogg; codecs="theora, vorbis"',flashCanPlay:!1,media:"video"},webmv:{codec:'video/webm; codecs="vorbis, vp8"',flashCanPlay:!1,media:"video"},flv:{codec:"video/x-flv",flashCanPlay:!0,media:"video"},rtmpv:{codec:'video/rtmp; codecs="rtmp"',flashCanPlay:!0,media:"video"}},_init:function(){var a=this;this.element.empty();this.status=b.extend({},this.status);this.internal=b.extend({},this.internal);this.internal.domNode=this.element.get(0);this.formats=[];this.solutions=[];this.require=
{};this.htmlElement={};this.html={};this.html.audio={};this.html.video={};this.flash={};this.css={};this.css.cs={};this.css.jq={};this.ancestorJq=[];this.options.volume=this._limitValue(this.options.volume,0,1);b.each(this.options.supplied.toLowerCase().split(","),function(c,d){var e=d.replace(/^\s+|\s+$/g,"");if(a.format[e]){var f=false;b.each(a.formats,function(a,b){if(e===b){f=true;return false}});f||a.formats.push(e)}});b.each(this.options.solution.toLowerCase().split(","),function(c,d){var e=
d.replace(/^\s+|\s+$/g,"");if(a.solution[e]){var f=false;b.each(a.solutions,function(a,b){if(e===b){f=true;return false}});f||a.solutions.push(e)}});this.internal.instance="jp_"+this.count;this.instances[this.internal.instance]=this.element;this.element.attr("id")||this.element.attr("id",this.options.idPrefix+"_jplayer_"+this.count);this.internal.self=b.extend({},{id:this.element.attr("id"),jq:this.element});this.internal.audio=b.extend({},{id:this.options.idPrefix+"_audio_"+this.count,jq:f});this.internal.video=
b.extend({},{id:this.options.idPrefix+"_video_"+this.count,jq:f});this.internal.flash=b.extend({},{id:this.options.idPrefix+"_flash_"+this.count,jq:f,swf:this.options.swfPath+(this.options.swfPath.toLowerCase().slice(-4)!==".swf"?(this.options.swfPath&&this.options.swfPath.slice(-1)!=="/"?"/":"")+"Jplayer.swf":"")});this.internal.poster=b.extend({},{id:this.options.idPrefix+"_poster_"+this.count,jq:f});b.each(b.jPlayer.event,function(b,c){if(a.options[b]!==f){a.element.bind(c+".jPlayer",a.options[b]);
a.options[b]=f}});this.require.audio=false;this.require.video=false;b.each(this.formats,function(b,c){a.require[a.format[c].media]=true});this.options=this.require.video?b.extend(true,{},this.optionsVideo,this.options):b.extend(true,{},this.optionsAudio,this.options);this._setSize();this.status.nativeVideoControls=this._uaBlocklist(this.options.nativeVideoControls);this.status.noFullScreen=this._uaBlocklist(this.options.noFullScreen);this.status.noVolume=this._uaBlocklist(this.options.noVolume);this._restrictNativeVideoControls();
this.htmlElement.poster=document.createElement("img");this.htmlElement.poster.id=this.internal.poster.id;this.htmlElement.poster.onload=function(){(!a.status.video||a.status.waitForPlay)&&a.internal.poster.jq.show()};this.element.append(this.htmlElement.poster);this.internal.poster.jq=b("#"+this.internal.poster.id);this.internal.poster.jq.css({width:this.status.width,height:this.status.height});this.internal.poster.jq.hide();this.internal.poster.jq.bind("click.jPlayer",function(){a._trigger(b.jPlayer.event.click)});
this.html.audio.available=false;if(this.require.audio){this.htmlElement.audio=document.createElement("audio");this.htmlElement.audio.id=this.internal.audio.id;this.html.audio.available=!!this.htmlElement.audio.canPlayType&&this._testCanPlayType(this.htmlElement.audio)}this.html.video.available=false;if(this.require.video){this.htmlElement.video=document.createElement("video");this.htmlElement.video.id=this.internal.video.id;this.html.video.available=!!this.htmlElement.video.canPlayType&&this._testCanPlayType(this.htmlElement.video)}this.flash.available=
this._checkForFlash(10);this.html.canPlay={};this.flash.canPlay={};b.each(this.formats,function(b,c){a.html.canPlay[c]=a.html[a.format[c].media].available&&""!==a.htmlElement[a.format[c].media].canPlayType(a.format[c].codec);a.flash.canPlay[c]=a.format[c].flashCanPlay&&a.flash.available});this.html.desired=false;this.flash.desired=false;b.each(this.solutions,function(c,d){if(c===0)a[d].desired=true;else{var e=false,f=false;b.each(a.formats,function(b,c){a[a.solutions[0]].canPlay[c]&&(a.format[c].media===
"video"?f=true:e=true)});a[d].desired=a.require.audio&&!e||a.require.video&&!f}});this.html.support={};this.flash.support={};b.each(this.formats,function(b,c){a.html.support[c]=a.html.canPlay[c]&&a.html.desired;a.flash.support[c]=a.flash.canPlay[c]&&a.flash.desired});this.html.used=false;this.flash.used=false;b.each(this.solutions,function(c,d){b.each(a.formats,function(b,c){if(a[d].support[c]){a[d].used=true;return false}})});this._resetActive();this._resetGate();this._cssSelectorAncestor(this.options.cssSelectorAncestor);
if(!this.html.used&&!this.flash.used){this._error({type:b.jPlayer.error.NO_SOLUTION,context:"{solution:'"+this.options.solution+"', supplied:'"+this.options.supplied+"'}",message:b.jPlayer.errorMsg.NO_SOLUTION,hint:b.jPlayer.errorHint.NO_SOLUTION});this.css.jq.noSolution.length&&this.css.jq.noSolution.show()}else this.css.jq.noSolution.length&&this.css.jq.noSolution.hide();if(this.flash.used){var c,d="jQuery="+encodeURI(this.options.noConflict)+"&id="+encodeURI(this.internal.self.id)+"&vol="+this.options.volume+
"&muted="+this.options.muted;if(b.jPlayer.browser.msie&&Number(b.jPlayer.browser.version)<=8){d=['<param name="movie" value="'+this.internal.flash.swf+'" />','<param name="FlashVars" value="'+d+'" />','<param name="allowScriptAccess" value="always" />','<param name="bgcolor" value="'+this.options.backgroundColor+'" />','<param name="wmode" value="'+this.options.wmode+'" />'];c=document.createElement('<object id="'+this.internal.flash.id+'" classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="0" height="0"></object>');
for(var e=0;e<d.length;e++)c.appendChild(document.createElement(d[e]))}else{e=function(a,b,c){var d=document.createElement("param");d.setAttribute("name",b);d.setAttribute("value",c);a.appendChild(d)};c=document.createElement("object");c.setAttribute("id",this.internal.flash.id);c.setAttribute("data",this.internal.flash.swf);c.setAttribute("type","application/x-shockwave-flash");c.setAttribute("width","1");c.setAttribute("height","1");e(c,"flashvars",d);e(c,"allowscriptaccess","always");e(c,"bgcolor",
this.options.backgroundColor);e(c,"wmode",this.options.wmode)}this.element.append(c);this.internal.flash.jq=b(c)}if(this.html.used){if(this.html.audio.available){this._addHtmlEventListeners(this.htmlElement.audio,this.html.audio);this.element.append(this.htmlElement.audio);this.internal.audio.jq=b("#"+this.internal.audio.id)}if(this.html.video.available){this._addHtmlEventListeners(this.htmlElement.video,this.html.video);this.element.append(this.htmlElement.video);this.internal.video.jq=b("#"+this.internal.video.id);
this.status.nativeVideoControls?this.internal.video.jq.css({width:this.status.width,height:this.status.height}):this.internal.video.jq.css({width:"0px",height:"0px"});this.internal.video.jq.bind("click.jPlayer",function(){a._trigger(b.jPlayer.event.click)})}}this.options.emulateHtml&&this._emulateHtmlBridge();this.html.used&&!this.flash.used&&setTimeout(function(){a.internal.ready=true;a.version.flash="n/a";a._trigger(b.jPlayer.event.repeat);a._trigger(b.jPlayer.event.ready)},100);this._updateNativeVideoControls();
this._updateInterface();this._updateButtons(false);this._updateAutohide();this._updateVolume(this.options.volume);this._updateMute(this.options.muted);this.css.jq.videoPlay.length&&this.css.jq.videoPlay.hide();b.jPlayer.prototype.count++},destroy:function(){this.clearMedia();this._removeUiClass();this.css.jq.currentTime.length&&this.css.jq.currentTime.text("");this.css.jq.duration.length&&this.css.jq.duration.text("");b.each(this.css.jq,function(a,b){b.length&&b.unbind(".jPlayer")});this.internal.poster.jq.unbind(".jPlayer");
this.internal.video.jq&&this.internal.video.jq.unbind(".jPlayer");this.options.emulateHtml&&this._destroyHtmlBridge();this.element.removeData("jPlayer");this.element.unbind(".jPlayer");this.element.empty();delete this.instances[this.internal.instance]},enable:function(){},disable:function(){},_testCanPlayType:function(a){try{a.canPlayType(this.format.mp3.codec);return true}catch(b){return false}},_uaBlocklist:function(a){var c=navigator.userAgent.toLowerCase(),d=false;b.each(a,function(a,b){if(b&&
b.test(c)){d=true;return false}});return d},_restrictNativeVideoControls:function(){if(this.require.audio&&this.status.nativeVideoControls){this.status.nativeVideoControls=false;this.status.noFullScreen=true}},_updateNativeVideoControls:function(){if(this.html.video.available&&this.html.used){this.htmlElement.video.controls=this.status.nativeVideoControls;this._updateAutohide();if(this.status.nativeVideoControls&&this.require.video){this.internal.poster.jq.hide();this.internal.video.jq.css({width:this.status.width,
height:this.status.height})}else if(this.status.waitForPlay&&this.status.video){this.internal.poster.jq.show();this.internal.video.jq.css({width:"0px",height:"0px"})}}},_addHtmlEventListeners:function(a,c){var d=this;a.preload=this.options.preload;a.muted=this.options.muted;a.volume=this.options.volume;a.addEventListener("progress",function(){if(c.gate){d._getHtmlStatus(a);d._updateInterface();d._trigger(b.jPlayer.event.progress)}},false);a.addEventListener("timeupdate",function(){if(c.gate){d._getHtmlStatus(a);
d._updateInterface();d._trigger(b.jPlayer.event.timeupdate)}},false);a.addEventListener("durationchange",function(){if(c.gate){d._getHtmlStatus(a);d._updateInterface();d._trigger(b.jPlayer.event.durationchange)}},false);a.addEventListener("play",function(){if(c.gate){d._updateButtons(true);d._html_checkWaitForPlay();d._trigger(b.jPlayer.event.play)}},false);a.addEventListener("playing",function(){if(c.gate){d._updateButtons(true);d._seeked();d._trigger(b.jPlayer.event.playing)}},false);a.addEventListener("pause",
function(){if(c.gate){d._updateButtons(false);d._trigger(b.jPlayer.event.pause)}},false);a.addEventListener("waiting",function(){if(c.gate){d._seeking();d._trigger(b.jPlayer.event.waiting)}},false);a.addEventListener("seeking",function(){if(c.gate){d._seeking();d._trigger(b.jPlayer.event.seeking)}},false);a.addEventListener("seeked",function(){if(c.gate){d._seeked();d._trigger(b.jPlayer.event.seeked)}},false);a.addEventListener("volumechange",function(){if(c.gate){d.options.volume=a.volume;d.options.muted=
a.muted;d._updateMute();d._updateVolume();d._trigger(b.jPlayer.event.volumechange)}},false);a.addEventListener("suspend",function(){if(c.gate){d._seeked();d._trigger(b.jPlayer.event.suspend)}},false);a.addEventListener("ended",function(){if(c.gate){if(!b.jPlayer.browser.webkit)d.htmlElement.media.currentTime=0;d.htmlElement.media.pause();d._updateButtons(false);d._getHtmlStatus(a,true);d._updateInterface();d._trigger(b.jPlayer.event.ended)}},false);a.addEventListener("error",function(){if(c.gate){d._updateButtons(false);
d._seeked();if(d.status.srcSet){clearTimeout(d.internal.htmlDlyCmdId);d.status.waitForLoad=true;d.status.waitForPlay=true;d.status.video&&!d.status.nativeVideoControls&&d.internal.video.jq.css({width:"0px",height:"0px"});d._validString(d.status.media.poster)&&!d.status.nativeVideoControls&&d.internal.poster.jq.show();d.css.jq.videoPlay.length&&d.css.jq.videoPlay.show();d._error({type:b.jPlayer.error.URL,context:d.status.src,message:b.jPlayer.errorMsg.URL,hint:b.jPlayer.errorHint.URL})}}},false);b.each(b.jPlayer.htmlEvent,
function(e,g){a.addEventListener(this,function(){c.gate&&d._trigger(b.jPlayer.event[g])},false)})},_getHtmlStatus:function(a,b){var d=0,e=0,g=0,f=0;if(isFinite(a.duration))this.status.duration=a.duration;d=a.currentTime;e=this.status.duration>0?100*d/this.status.duration:0;if(typeof a.seekable==="object"&&a.seekable.length>0){g=this.status.duration>0?100*a.seekable.end(a.seekable.length-1)/this.status.duration:100;f=this.status.duration>0?100*a.currentTime/a.seekable.end(a.seekable.length-1):0}else{g=
100;f=e}if(b)e=f=d=0;this.status.seekPercent=g;this.status.currentPercentRelative=f;this.status.currentPercentAbsolute=e;this.status.currentTime=d;this.status.readyState=a.readyState;this.status.networkState=a.networkState;this.status.playbackRate=a.playbackRate;this.status.ended=a.ended},_resetStatus:function(){this.status=b.extend({},this.status,b.jPlayer.prototype.status)},_trigger:function(a,c,d){a=b.Event(a);a.jPlayer={};a.jPlayer.version=b.extend({},this.version);a.jPlayer.options=b.extend(true,
{},this.options);a.jPlayer.status=b.extend(true,{},this.status);a.jPlayer.html=b.extend(true,{},this.html);a.jPlayer.flash=b.extend(true,{},this.flash);if(c)a.jPlayer.error=b.extend({},c);if(d)a.jPlayer.warning=b.extend({},d);this.element.trigger(a)},jPlayerFlashEvent:function(a,c){if(a===b.jPlayer.event.ready)if(this.internal.ready){if(this.flash.gate){if(this.status.srcSet){var d=this.status.currentTime,e=this.status.paused;this.setMedia(this.status.media);d>0&&(e?this.pause(d):this.play(d))}this._trigger(b.jPlayer.event.flashreset)}}else{this.internal.ready=
true;this.internal.flash.jq.css({width:"0px",height:"0px"});this.version.flash=c.version;this.version.needFlash!==this.version.flash&&this._error({type:b.jPlayer.error.VERSION,context:this.version.flash,message:b.jPlayer.errorMsg.VERSION+this.version.flash,hint:b.jPlayer.errorHint.VERSION});this._trigger(b.jPlayer.event.repeat);this._trigger(a)}if(this.flash.gate)switch(a){case b.jPlayer.event.progress:this._getFlashStatus(c);this._updateInterface();this._trigger(a);break;case b.jPlayer.event.timeupdate:this._getFlashStatus(c);
this._updateInterface();this._trigger(a);break;case b.jPlayer.event.play:this._seeked();this._updateButtons(true);this._trigger(a);break;case b.jPlayer.event.pause:this._updateButtons(false);this._trigger(a);break;case b.jPlayer.event.ended:this._updateButtons(false);this._trigger(a);break;case b.jPlayer.event.click:this._trigger(a);break;case b.jPlayer.event.error:this.status.waitForLoad=true;this.status.waitForPlay=true;this.status.video&&this.internal.flash.jq.css({width:"0px",height:"0px"});this._validString(this.status.media.poster)&&
this.internal.poster.jq.show();this.css.jq.videoPlay.length&&this.status.video&&this.css.jq.videoPlay.show();this.status.video?this._flash_setVideo(this.status.media):this._flash_setAudio(this.status.media);this._updateButtons(false);this._error({type:b.jPlayer.error.URL,context:c.src,message:b.jPlayer.errorMsg.URL,hint:b.jPlayer.errorHint.URL});break;case b.jPlayer.event.seeking:this._seeking();this._trigger(a);break;case b.jPlayer.event.seeked:this._seeked();this._trigger(a);break;case b.jPlayer.event.ready:break;
default:this._trigger(a)}return false},_getFlashStatus:function(a){this.status.seekPercent=a.seekPercent;this.status.currentPercentRelative=a.currentPercentRelative;this.status.currentPercentAbsolute=a.currentPercentAbsolute;this.status.currentTime=a.currentTime;this.status.duration=a.duration;this.status.readyState=4;this.status.networkState=0;this.status.playbackRate=1;this.status.ended=false},_updateButtons:function(a){if(a!==f){this.status.paused=!a;if(this.css.jq.play.length&&this.css.jq.pause.length)if(a){this.css.jq.play.hide();
this.css.jq.pause.show()}else{this.css.jq.play.show();this.css.jq.pause.hide()}}if(this.css.jq.restoreScreen.length&&this.css.jq.fullScreen.length)if(this.status.noFullScreen){this.css.jq.fullScreen.hide();this.css.jq.restoreScreen.hide()}else if(this.options.fullScreen){this.css.jq.fullScreen.hide();this.css.jq.restoreScreen.show()}else{this.css.jq.fullScreen.show();this.css.jq.restoreScreen.hide()}if(this.css.jq.repeat.length&&this.css.jq.repeatOff.length)if(this.options.loop){this.css.jq.repeat.hide();
this.css.jq.repeatOff.show()}else{this.css.jq.repeat.show();this.css.jq.repeatOff.hide()}},_updateInterface:function(){this.css.jq.seekBar.length&&this.css.jq.seekBar.width(this.status.seekPercent+"%");this.css.jq.playBar.length&&this.css.jq.playBar.width(this.status.currentPercentRelative+"%");this.css.jq.currentTime.length&&this.css.jq.currentTime.text(b.jPlayer.convertTime(this.status.currentTime));this.css.jq.duration.length&&this.css.jq.duration.text(b.jPlayer.convertTime(this.status.duration))},
_seeking:function(){this.css.jq.seekBar.length&&this.css.jq.seekBar.addClass("jp-seeking-bg")},_seeked:function(){this.css.jq.seekBar.length&&this.css.jq.seekBar.removeClass("jp-seeking-bg")},_resetGate:function(){this.html.audio.gate=false;this.html.video.gate=false;this.flash.gate=false},_resetActive:function(){this.html.active=false;this.flash.active=false},setMedia:function(a){var c=this,d=false,e=this.status.media.poster!==a.poster;this._resetMedia();this._resetGate();this._resetActive();b.each(this.formats,
function(e,f){var i=c.format[f].media==="video";b.each(c.solutions,function(b,e){if(c[e].support[f]&&c._validString(a[f])){var g=e==="html";if(i){if(g){c.html.video.gate=true;c._html_setVideo(a);c.html.active=true}else{c.flash.gate=true;c._flash_setVideo(a);c.flash.active=true}c.css.jq.videoPlay.length&&c.css.jq.videoPlay.show();c.status.video=true}else{if(g){c.html.audio.gate=true;c._html_setAudio(a);c.html.active=true}else{c.flash.gate=true;c._flash_setAudio(a);c.flash.active=true}c.css.jq.videoPlay.length&&
c.css.jq.videoPlay.hide();c.status.video=false}d=true;return false}});if(d)return false});if(d){if((!this.status.nativeVideoControls||!this.html.video.gate)&&this._validString(a.poster))e?this.htmlElement.poster.src=a.poster:this.internal.poster.jq.show();this.status.srcSet=true;this.status.media=b.extend({},a);this._updateButtons(false);this._updateInterface()}else this._error({type:b.jPlayer.error.NO_SUPPORT,context:"{supplied:'"+this.options.supplied+"'}",message:b.jPlayer.errorMsg.NO_SUPPORT,
hint:b.jPlayer.errorHint.NO_SUPPORT})},_resetMedia:function(){this._resetStatus();this._updateButtons(false);this._updateInterface();this._seeked();this.internal.poster.jq.hide();clearTimeout(this.internal.htmlDlyCmdId);this.html.active?this._html_resetMedia():this.flash.active&&this._flash_resetMedia()},clearMedia:function(){this._resetMedia();this.html.active?this._html_clearMedia():this.flash.active&&this._flash_clearMedia();this._resetGate();this._resetActive()},load:function(){this.status.srcSet?
this.html.active?this._html_load():this.flash.active&&this._flash_load():this._urlNotSetError("load")},play:function(a){a=typeof a==="number"?a:NaN;this.status.srcSet?this.html.active?this._html_play(a):this.flash.active&&this._flash_play(a):this._urlNotSetError("play")},videoPlay:function(){this.play()},pause:function(a){a=typeof a==="number"?a:NaN;this.status.srcSet?this.html.active?this._html_pause(a):this.flash.active&&this._flash_pause(a):this._urlNotSetError("pause")},pauseOthers:function(){var a=
this;b.each(this.instances,function(b,d){a.element!==d&&d.data("jPlayer").status.srcSet&&d.jPlayer("pause")})},stop:function(){this.status.srcSet?this.html.active?this._html_pause(0):this.flash.active&&this._flash_pause(0):this._urlNotSetError("stop")},playHead:function(a){a=this._limitValue(a,0,100);this.status.srcSet?this.html.active?this._html_playHead(a):this.flash.active&&this._flash_playHead(a):this._urlNotSetError("playHead")},_muted:function(a){this.options.muted=a;this.html.used&&this._html_mute(a);
this.flash.used&&this._flash_mute(a);if(!this.html.video.gate&&!this.html.audio.gate){this._updateMute(a);this._updateVolume(this.options.volume);this._trigger(b.jPlayer.event.volumechange)}},mute:function(a){a=a===f?true:!!a;this._muted(a)},unmute:function(a){a=a===f?true:!!a;this._muted(!a)},_updateMute:function(a){if(a===f)a=this.options.muted;if(this.css.jq.mute.length&&this.css.jq.unmute.length)if(this.status.noVolume){this.css.jq.mute.hide();this.css.jq.unmute.hide()}else if(a){this.css.jq.mute.hide();
this.css.jq.unmute.show()}else{this.css.jq.mute.show();this.css.jq.unmute.hide()}},volume:function(a){a=this._limitValue(a,0,1);this.options.volume=a;this.html.used&&this._html_volume(a);this.flash.used&&this._flash_volume(a);if(!this.html.video.gate&&!this.html.audio.gate){this._updateVolume(a);this._trigger(b.jPlayer.event.volumechange)}},volumeBar:function(a){if(this.css.jq.volumeBar.length){var b=this.css.jq.volumeBar.offset(),d=a.pageX-b.left,e=this.css.jq.volumeBar.width(),a=this.css.jq.volumeBar.height()-
a.pageY+b.top,b=this.css.jq.volumeBar.height();this.options.verticalVolume?this.volume(a/b):this.volume(d/e)}this.options.muted&&this._muted(false)},volumeBarValue:function(a){this.volumeBar(a)},_updateVolume:function(a){if(a===f)a=this.options.volume;a=this.options.muted?0:a;if(this.status.noVolume){this.css.jq.volumeBar.length&&this.css.jq.volumeBar.hide();this.css.jq.volumeBarValue.length&&this.css.jq.volumeBarValue.hide();this.css.jq.volumeMax.length&&this.css.jq.volumeMax.hide()}else{this.css.jq.volumeBar.length&&
this.css.jq.volumeBar.show();if(this.css.jq.volumeBarValue.length){this.css.jq.volumeBarValue.show();this.css.jq.volumeBarValue[this.options.verticalVolume?"height":"width"](a*100+"%")}this.css.jq.volumeMax.length&&this.css.jq.volumeMax.show()}},volumeMax:function(){this.volume(1);this.options.muted&&this._muted(false)},_cssSelectorAncestor:function(a){var c=this;this.options.cssSelectorAncestor=a;this._removeUiClass();this.ancestorJq=a?b(a):[];a&&this.ancestorJq.length!==1&&this._warning({type:b.jPlayer.warning.CSS_SELECTOR_COUNT,
context:a,message:b.jPlayer.warningMsg.CSS_SELECTOR_COUNT+this.ancestorJq.length+" found for cssSelectorAncestor.",hint:b.jPlayer.warningHint.CSS_SELECTOR_COUNT});this._addUiClass();b.each(this.options.cssSelector,function(a,b){c._cssSelector(a,b)})},_cssSelector:function(a,c){var d=this;if(typeof c==="string")if(b.jPlayer.prototype.options.cssSelector[a]){this.css.jq[a]&&this.css.jq[a].length&&this.css.jq[a].unbind(".jPlayer");this.options.cssSelector[a]=c;this.css.cs[a]=this.options.cssSelectorAncestor+
" "+c;this.css.jq[a]=c?b(this.css.cs[a]):[];this.css.jq[a].length&&this.css.jq[a].bind("click.jPlayer",function(c){d[a](c);b(this).blur();return false});c&&this.css.jq[a].length!==1&&this._warning({type:b.jPlayer.warning.CSS_SELECTOR_COUNT,context:this.css.cs[a],message:b.jPlayer.warningMsg.CSS_SELECTOR_COUNT+this.css.jq[a].length+" found for "+a+" method.",hint:b.jPlayer.warningHint.CSS_SELECTOR_COUNT})}else this._warning({type:b.jPlayer.warning.CSS_SELECTOR_METHOD,context:a,message:b.jPlayer.warningMsg.CSS_SELECTOR_METHOD,
hint:b.jPlayer.warningHint.CSS_SELECTOR_METHOD});else this._warning({type:b.jPlayer.warning.CSS_SELECTOR_STRING,context:c,message:b.jPlayer.warningMsg.CSS_SELECTOR_STRING,hint:b.jPlayer.warningHint.CSS_SELECTOR_STRING})},seekBar:function(a){if(this.css.jq.seekBar){var b=this.css.jq.seekBar.offset(),a=a.pageX-b.left,b=this.css.jq.seekBar.width();this.playHead(100*a/b)}},playBar:function(a){this.seekBar(a)},repeat:function(){this._loop(true)},repeatOff:function(){this._loop(false)},_loop:function(a){if(this.options.loop!==
a){this.options.loop=a;this._updateButtons();this._trigger(b.jPlayer.event.repeat)}},currentTime:function(){},duration:function(){},gui:function(){},noSolution:function(){},option:function(a,c){var d=a;if(arguments.length===0)return b.extend(true,{},this.options);if(typeof a==="string"){var e=a.split(".");if(c===f){for(var d=b.extend(true,{},this.options),g=0;g<e.length;g++)if(d[e[g]]!==f)d=d[e[g]];else{this._warning({type:b.jPlayer.warning.OPTION_KEY,context:a,message:b.jPlayer.warningMsg.OPTION_KEY,
hint:b.jPlayer.warningHint.OPTION_KEY});return f}return d}for(var g=d={},h=0;h<e.length;h++)if(h<e.length-1){g[e[h]]={};g=g[e[h]]}else g[e[h]]=c}this._setOptions(d);return this},_setOptions:function(a){var c=this;b.each(a,function(a,b){c._setOption(a,b)});return this},_setOption:function(a,c){var d=this;switch(a){case "volume":this.volume(c);break;case "muted":this._muted(c);break;case "cssSelectorAncestor":this._cssSelectorAncestor(c);break;case "cssSelector":b.each(c,function(a,b){d._cssSelector(a,
b)});break;case "fullScreen":if(this.options[a]!==c){this._removeUiClass();this.options[a]=c;this._refreshSize()}break;case "size":!this.options.fullScreen&&this.options[a].cssClass!==c.cssClass&&this._removeUiClass();this.options[a]=b.extend({},this.options[a],c);this._refreshSize();break;case "sizeFull":this.options.fullScreen&&this.options[a].cssClass!==c.cssClass&&this._removeUiClass();this.options[a]=b.extend({},this.options[a],c);this._refreshSize();break;case "autohide":this.options[a]=b.extend({},
this.options[a],c);this._updateAutohide();break;case "loop":this._loop(c);break;case "nativeVideoControls":this.options[a]=b.extend({},this.options[a],c);this.status.nativeVideoControls=this._uaBlocklist(this.options.nativeVideoControls);this._restrictNativeVideoControls();this._updateNativeVideoControls();break;case "noFullScreen":this.options[a]=b.extend({},this.options[a],c);this.status.nativeVideoControls=this._uaBlocklist(this.options.nativeVideoControls);this.status.noFullScreen=this._uaBlocklist(this.options.noFullScreen);
this._restrictNativeVideoControls();this._updateButtons();break;case "noVolume":this.options[a]=b.extend({},this.options[a],c);this.status.noVolume=this._uaBlocklist(this.options.noVolume);this._updateVolume();this._updateMute();break;case "emulateHtml":if(this.options[a]!==c)(this.options[a]=c)?this._emulateHtmlBridge():this._destroyHtmlBridge()}return this},_refreshSize:function(){this._setSize();this._addUiClass();this._updateSize();this._updateButtons();this._updateAutohide();this._trigger(b.jPlayer.event.resize)},
_setSize:function(){if(this.options.fullScreen){this.status.width=this.options.sizeFull.width;this.status.height=this.options.sizeFull.height;this.status.cssClass=this.options.sizeFull.cssClass}else{this.status.width=this.options.size.width;this.status.height=this.options.size.height;this.status.cssClass=this.options.size.cssClass}this.element.css({width:this.status.width,height:this.status.height})},_addUiClass:function(){this.ancestorJq.length&&this.ancestorJq.addClass(this.status.cssClass)},_removeUiClass:function(){this.ancestorJq.length&&
this.ancestorJq.removeClass(this.status.cssClass)},_updateSize:function(){this.internal.poster.jq.css({width:this.status.width,height:this.status.height});!this.status.waitForPlay&&this.html.active&&this.status.video||this.html.video.available&&this.html.used&&this.status.nativeVideoControls?this.internal.video.jq.css({width:this.status.width,height:this.status.height}):!this.status.waitForPlay&&(this.flash.active&&this.status.video)&&this.internal.flash.jq.css({width:this.status.width,height:this.status.height})},
_updateAutohide:function(){var a=this,b=function(){a.css.jq.gui.fadeIn(a.options.autohide.fadeIn,function(){clearTimeout(a.internal.autohideId);a.internal.autohideId=setTimeout(function(){a.css.jq.gui.fadeOut(a.options.autohide.fadeOut)},a.options.autohide.hold)})};if(this.css.jq.gui.length){this.css.jq.gui.stop(true,true);clearTimeout(this.internal.autohideId);this.element.unbind(".jPlayerAutohide");this.css.jq.gui.unbind(".jPlayerAutohide");if(this.status.nativeVideoControls)this.css.jq.gui.hide();
else if(this.options.fullScreen&&this.options.autohide.full||!this.options.fullScreen&&this.options.autohide.restored){this.element.bind("mousemove.jPlayer.jPlayerAutohide",b);this.css.jq.gui.bind("mousemove.jPlayer.jPlayerAutohide",b);this.css.jq.gui.hide()}else this.css.jq.gui.show()}},fullScreen:function(){this._setOption("fullScreen",true)},restoreScreen:function(){this._setOption("fullScreen",false)},_html_initMedia:function(){this.htmlElement.media.src=this.status.src;this.options.preload!==
"none"&&this._html_load();this._trigger(b.jPlayer.event.timeupdate)},_html_setAudio:function(a){var c=this;b.each(this.formats,function(b,e){if(c.html.support[e]&&a[e]){c.status.src=a[e];c.status.format[e]=true;c.status.formatType=e;return false}});this.htmlElement.media=this.htmlElement.audio;this._html_initMedia()},_html_setVideo:function(a){var c=this;b.each(this.formats,function(b,e){if(c.html.support[e]&&a[e]){c.status.src=a[e];c.status.format[e]=true;c.status.formatType=e;return false}});if(this.status.nativeVideoControls)this.htmlElement.video.poster=
this._validString(a.poster)?a.poster:"";this.htmlElement.media=this.htmlElement.video;this._html_initMedia()},_html_resetMedia:function(){if(this.htmlElement.media){this.htmlElement.media.id===this.internal.video.id&&!this.status.nativeVideoControls&&this.internal.video.jq.css({width:"0px",height:"0px"});this.htmlElement.media.pause()}},_html_clearMedia:function(){if(this.htmlElement.media){this.htmlElement.media.src="";this.htmlElement.media.load()}},_html_load:function(){if(this.status.waitForLoad){this.status.waitForLoad=
false;this.htmlElement.media.load()}clearTimeout(this.internal.htmlDlyCmdId)},_html_play:function(a){var b=this;this._html_load();this.htmlElement.media.play();if(!isNaN(a))try{this.htmlElement.media.currentTime=a}catch(d){this.internal.htmlDlyCmdId=setTimeout(function(){b.play(a)},100);return}this._html_checkWaitForPlay()},_html_pause:function(a){var b=this;a>0?this._html_load():clearTimeout(this.internal.htmlDlyCmdId);this.htmlElement.media.pause();if(!isNaN(a))try{this.htmlElement.media.currentTime=
a}catch(d){this.internal.htmlDlyCmdId=setTimeout(function(){b.pause(a)},100);return}a>0&&this._html_checkWaitForPlay()},_html_playHead:function(a){var b=this;this._html_load();try{if(typeof this.htmlElement.media.seekable==="object"&&this.htmlElement.media.seekable.length>0)this.htmlElement.media.currentTime=a*this.htmlElement.media.seekable.end(this.htmlElement.media.seekable.length-1)/100;else if(this.htmlElement.media.duration>0&&!isNaN(this.htmlElement.media.duration))this.htmlElement.media.currentTime=
a*this.htmlElement.media.duration/100;else throw"e";}catch(d){this.internal.htmlDlyCmdId=setTimeout(function(){b.playHead(a)},100);return}this.status.waitForLoad||this._html_checkWaitForPlay()},_html_checkWaitForPlay:function(){if(this.status.waitForPlay){this.status.waitForPlay=false;this.css.jq.videoPlay.length&&this.css.jq.videoPlay.hide();if(this.status.video){this.internal.poster.jq.hide();this.internal.video.jq.css({width:this.status.width,height:this.status.height})}}},_html_volume:function(a){if(this.html.audio.available)this.htmlElement.audio.volume=
a;if(this.html.video.available)this.htmlElement.video.volume=a},_html_mute:function(a){if(this.html.audio.available)this.htmlElement.audio.muted=a;if(this.html.video.available)this.htmlElement.video.muted=a},_flash_setAudio:function(a){var c=this;try{b.each(this.formats,function(b,d){if(c.flash.support[d]&&a[d]){switch(d){case "m4a":case "fla":c._getMovie().fl_setAudio_m4a(a[d]);break;case "mp3":c._getMovie().fl_setAudio_mp3(a[d]);break;case "rtmpa":c._getMovie().fl_setAudio_rtmp(a[d])}c.status.src=
a[d];c.status.format[d]=true;c.status.formatType=d;return false}});if(this.options.preload==="auto"){this._flash_load();this.status.waitForLoad=false}}catch(d){this._flashError(d)}},_flash_setVideo:function(a){var c=this;try{b.each(this.formats,function(b,d){if(c.flash.support[d]&&a[d]){switch(d){case "m4v":case "flv":c._getMovie().fl_setVideo_m4v(a[d]);break;case "rtmpv":c._getMovie().fl_setVideo_rtmp(a[d])}c.status.src=a[d];c.status.format[d]=true;c.status.formatType=d;return false}});if(this.options.preload===
"auto"){this._flash_load();this.status.waitForLoad=false}}catch(d){this._flashError(d)}},_flash_resetMedia:function(){this.internal.flash.jq.css({width:"0px",height:"0px"});this._flash_pause(NaN)},_flash_clearMedia:function(){try{this._getMovie().fl_clearMedia()}catch(a){this._flashError(a)}},_flash_load:function(){try{this._getMovie().fl_load()}catch(a){this._flashError(a)}this.status.waitForLoad=false},_flash_play:function(a){try{this._getMovie().fl_play(a)}catch(b){this._flashError(b)}this.status.waitForLoad=
false;this._flash_checkWaitForPlay()},_flash_pause:function(a){try{this._getMovie().fl_pause(a)}catch(b){this._flashError(b)}if(a>0){this.status.waitForLoad=false;this._flash_checkWaitForPlay()}},_flash_playHead:function(a){try{this._getMovie().fl_play_head(a)}catch(b){this._flashError(b)}this.status.waitForLoad||this._flash_checkWaitForPlay()},_flash_checkWaitForPlay:function(){if(this.status.waitForPlay){this.status.waitForPlay=false;this.css.jq.videoPlay.length&&this.css.jq.videoPlay.hide();if(this.status.video){this.internal.poster.jq.hide();
this.internal.flash.jq.css({width:this.status.width,height:this.status.height})}}},_flash_volume:function(a){try{this._getMovie().fl_volume(a)}catch(b){this._flashError(b)}},_flash_mute:function(a){try{this._getMovie().fl_mute(a)}catch(b){this._flashError(b)}},_getMovie:function(){return document[this.internal.flash.id]},_checkForFlash:function(a){var b=false,d;if(window.ActiveXObject)try{new ActiveXObject("ShockwaveFlash.ShockwaveFlash."+a);b=true}catch(e){}else if(navigator.plugins&&navigator.mimeTypes.length>
0)(d=navigator.plugins["Shockwave Flash"])&&navigator.plugins["Shockwave Flash"].description.replace(/.*\s(\d+\.\d+).*/,"$1")>=a&&(b=true);return b},_validString:function(a){return a&&typeof a==="string"},_limitValue:function(a,b,d){return a<b?b:a>d?d:a},_urlNotSetError:function(a){this._error({type:b.jPlayer.error.URL_NOT_SET,context:a,message:b.jPlayer.errorMsg.URL_NOT_SET,hint:b.jPlayer.errorHint.URL_NOT_SET})},_flashError:function(a){var c;c=this.internal.ready?"FLASH_DISABLED":"FLASH";this._error({type:b.jPlayer.error[c],
context:this.internal.flash.swf,message:b.jPlayer.errorMsg[c]+a.message,hint:b.jPlayer.errorHint[c]});this.internal.flash.jq.css({width:"1px",height:"1px"})},_error:function(a){this._trigger(b.jPlayer.event.error,a);this.options.errorAlerts&&this._alert("Error!"+(a.message?"\n\n"+a.message:"")+(a.hint?"\n\n"+a.hint:"")+"\n\nContext: "+a.context)},_warning:function(a){this._trigger(b.jPlayer.event.warning,f,a);this.options.warningAlerts&&this._alert("Warning!"+(a.message?"\n\n"+a.message:"")+(a.hint?
"\n\n"+a.hint:"")+"\n\nContext: "+a.context)},_alert:function(a){alert("jPlayer "+this.version.script+" : id='"+this.internal.self.id+"' : "+a)},_emulateHtmlBridge:function(){var a=this;b.each(b.jPlayer.emulateMethods.split(/\s+/g),function(b,d){a.internal.domNode[d]=function(b){a[d](b)}});b.each(b.jPlayer.event,function(c,d){var e=true;b.each(b.jPlayer.reservedEvent.split(/\s+/g),function(a,b){if(b===c)return e=false});e&&a.element.bind(d+".jPlayer.jPlayerHtml",function(){a._emulateHtmlUpdate();
var b=document.createEvent("Event");b.initEvent(c,false,true);a.internal.domNode.dispatchEvent(b)})})},_emulateHtmlUpdate:function(){var a=this;b.each(b.jPlayer.emulateStatus.split(/\s+/g),function(b,d){a.internal.domNode[d]=a.status[d]});b.each(b.jPlayer.emulateOptions.split(/\s+/g),function(b,d){a.internal.domNode[d]=a.options[d]})},_destroyHtmlBridge:function(){var a=this;this.element.unbind(".jPlayerHtml");b.each((b.jPlayer.emulateMethods+" "+b.jPlayer.emulateStatus+" "+b.jPlayer.emulateOptions).split(/\s+/g),
function(b,d){delete a.internal.domNode[d]})}};b.jPlayer.error={FLASH:"e_flash",FLASH_DISABLED:"e_flash_disabled",NO_SOLUTION:"e_no_solution",NO_SUPPORT:"e_no_support",URL:"e_url",URL_NOT_SET:"e_url_not_set",VERSION:"e_version"};b.jPlayer.errorMsg={FLASH:"jPlayer's Flash fallback is not configured correctly, or a command was issued before the jPlayer Ready event. Details: ",FLASH_DISABLED:"jPlayer's Flash fallback has been disabled by the browser due to the CSS rules you have used. Details: ",NO_SOLUTION:"No solution can be found by jPlayer in this browser. Neither HTML nor Flash can be used.",
NO_SUPPORT:"It is not possible to play any media format provided in setMedia() on this browser using your current options.",URL:"Media URL could not be loaded.",URL_NOT_SET:"Attempt to issue media playback commands, while no media url is set.",VERSION:"jPlayer "+b.jPlayer.prototype.version.script+" needs Jplayer.swf version "+b.jPlayer.prototype.version.needFlash+" but found "};b.jPlayer.errorHint={FLASH:"Check your swfPath option and that Jplayer.swf is there.",FLASH_DISABLED:"Check that you have not display:none; the jPlayer entity or any ancestor.",
NO_SOLUTION:"Review the jPlayer options: support and supplied.",NO_SUPPORT:"Video or audio formats defined in the supplied option are missing.",URL:"Check media URL is valid.",URL_NOT_SET:"Use setMedia() to set the media URL.",VERSION:"Update jPlayer files."};b.jPlayer.warning={CSS_SELECTOR_COUNT:"e_css_selector_count",CSS_SELECTOR_METHOD:"e_css_selector_method",CSS_SELECTOR_STRING:"e_css_selector_string",OPTION_KEY:"e_option_key"};b.jPlayer.warningMsg={CSS_SELECTOR_COUNT:"The number of css selectors found did not equal one: ",
CSS_SELECTOR_METHOD:"The methodName given in jPlayer('cssSelector') is not a valid jPlayer method.",CSS_SELECTOR_STRING:"The methodCssSelector given in jPlayer('cssSelector') is not a String or is empty.",OPTION_KEY:"The option requested in jPlayer('option') is undefined."};b.jPlayer.warningHint={CSS_SELECTOR_COUNT:"Check your css selector and the ancestor.",CSS_SELECTOR_METHOD:"Check your method name.",CSS_SELECTOR_STRING:"Check your css selector is a string.",OPTION_KEY:"Check your option name."}})(jQuery);var QueryState = Object.freeze ({
	INPUT: 1,
	CORRECT: 2
});
	
var VocableRepr = Class(ObjectRepr, {
	// Eingebene Übersetzung wird korregiert
	check:
	function(node) {
		if (!node) {
			node = $("#" + this.crId).find("[data-dz-button-role='solve']");
		}
		$(node).blendOut();
		this.row = $(node).closest("tr, [data-dz-role='row']");
		var input = this.row.find("input[type='text']");
		var text = input.val().trim();
		
		// Es wird auf direkten Treffer geprüft
		if (this.isEqual(text, $(this.getWord(this.cycle().to)).text())) {
			// gewusst
			this.success();
		}
		else {
			// TODO Durch mögliche Alternativen suchen
			
			this.failure(text);
		}
		this.row.find(".solution").blendIn();
		this.cycle().state = QueryState.CORRECT;
	},
	isEqual:
	function(a, b) {
		var strict = this.cycle().strict;
		if (strict == 1) {
			// very strict
			// do nothing
		}
		else if (strict == 2) {
			a = recode(a);
			b = recode(b);
		}
		else if (strict == 3) {
			a = recode(simplify(a));
			b = recode(simplify(b));
		}
		else {
			throw "unknown strict in cycle";
		}
		
		if (a == b) {
			return true;
		}
		return false;
	},
	// Lösung wird aufgedeckt
	reveal:
	function(node) {
		$(node).blendOut();
		this.row = $(node).closest("tr");
		this.row.find(".solution").blendIn();
	},
	// Repr wird ausgelesen
	getRepr:
	function(lang) {
		var xPath = new XPath();
		xPath.evaluate(".//side[@lang='"+lang+"']//repr", this.xmlNode.ownerDocument, this.xmlNode);
		var repr = xPath.iterateNext();
		return repr;
	},
	// Repr wird ausgelesen
	getSearch:
	function(lang) {
		var xPath = new XPath();
		xPath.evaluate(".//side[@lang='"+lang+"']//search/word", this.xmlNode.ownerDocument, this.xmlNode);
		var search = xPath.iterateNext();
		return search;
	},
	// Repr wird ausgelesen
	getCat:
	function(lang) {
		var xPath = new XPath();
		xPath.evaluate(".//category", this.xmlNode.ownerDocument, this.xmlNode);
		var cat = xPath.iterateNext();
		if (cat) {
			return cat.getAttribute("type");
		}
		return null;
	},
	// word wird ausgelesen
	getWord:
	function(lang) {
		var xPath = new XPath();
		xPath.evaluate(".//side[@lang='"+lang+"']//word", this.xmlNode.ownerDocument, this.xmlNode);
		var word = xPath.iterateNext();
		return word;
	},
	// Abfrage war erfolgreich
	success:
	function() {
		this.__success();
	},
	__success:
	function() {
		this.cycle().success++;
		this.xmlNode.setAttribute("attemp", "1");
		this.xmlNode.setAttribute("success", "1");
		this.manager.ajax.startPostRequest(
			this.objectQuery().appending("action", "success")
		);
		// Nach success verschieben() ? bei allen mod richtig?
		if (this.row) {
			this.row.find(".answer").html("<img width='16px' height='16px' alt='RICHTIG' src='/img/16x16/dialog-ok-apply.png'/>");
		}
		$("#result").html(this.cycle().success + "/" + this.cycle().count);
	},
	// Abfrage war nicht erfolgreich
	failure:
	function(text) {
		// Wird als falsch geflagt und dann korrektur hinten angehängt
		this.__failure();
		this.writeCorrection(text);
	},
	__failure:
	function() {
		this.cycle().error();
		this.xmlNode.setAttribute("attemp", "1");
		this.manager.ajax.startPostRequest(
			this.objectQuery().appending("action", "failure")
		);
		if (this.row) {
			this.row.find(".answer").html("<img width='16px' height='16px' alt='FALSCH' src='/img/16x16/dialog-cancel.png'/>");
		}
		
	},
	// Verbesserung wird geschrieben
	writeCorrection: 
	function(input) {
		var word = this.getWord(this.cycle().to);
		var dmp = new diff_match_patch();
		var result = dmp.diff_prettyHtml(dmp.diff_main(input,  word.firstChild.data));
		this.row.find(".answer").append(result);
	},
	// Erzeugt aus der Lösung einen Buchstabensalat
	salad:
	function(obj) {
		var letters = this.getWord(this.parent.parent.to).firstChild.data;
		var str = "";
		while (letters.length > 0) {
			var pos = Math.round(Math.random() * (letters.length -1));
			str += letters.slice(pos,pos + 1) + " ";
			if (pos > 0) {
				if (pos < letters.length) {
					letters = letters.substring(0, pos) + letters.substring(pos+1);
				}
				else {
					letters = letters.substring(0, letters.length-1);
				}
			}
			else {
				letters = letters.substring(1);
			}
		}
		// Buchstabensalat wird ins HTML eingefügt
		if (obj) {
			$(obj).html(str);
		}
		else {
			$("#"+this.crId).find("input[type='text']").val(str);
		}
	},
	makeError:
	function() {
		var str = makeError(this.getWord(this.parent.parent.to).firstChild.data, parseInt(this.parent.parent.getId("strict")), this.cycle().strict);
		$("#"+this.crId).find("input[type='text']").val(str);
	},
	// Vokabel wird als aktuell gesetzt
	// Wird beim assign verwendet
	setCurrent:
	function() {
		$("#"+this.crId).find("td:nth-child(4)").addClass("highlight");
		return this;
	},
	removeCurrent:
	function() {
		$("#"+this.crId).find("td:nth-child(4)").removeClass("highlight");
	},
	// Gibt an ob eine Vokabel für einen Abfragedurchgang verwendet werden soll
	// TODO Auf den Server auslagern?
	isValid:
	function() {
		return true;
	},
	// Lädt den Cycle oder die Vocableexercise
	cycle:
	function() {
		return this.parent.parent;
	},

	editComment:
	function() {
		var spinners = [];
		if (this.displays.vocabsort) {
			spinners.push({
					hnode: this.displays.vocabsort.hnode,
					opts: {radius:3, length: 4, width: 2, left: 0, top: 0}
				});
		}
		this.requestDisplay(new ObjectDisplayState("edit", {
				target: 'commentedit'
			}));
		// HACK
		$("#manageFolderCommentedit").closest(".ui-dialog").css("z-index", 99999);
	},

	saveComment:
	function() {
		this.save('commentedit');
		this.manager.viewports.commentedit.close();
	},
	// Vokabe wir Vorgesprochen
	play:
	function(side) {
		var url = $(this.xmlNode).find("side[lang='"+side+"'] pron").attr("url");
		Leo.dict.playLeo(url);
	}
});
globalRepresentations.setReprClass("vocable", VocableRepr);

var manageFolder;

/** Normal ManageFolder as used in Trainer */
var ManageTrainerFolder = Class(XmlManager, {
	__init__: function () {
		this.vocab_origidx_ = [];
		XmlManager.prototype.__init__.apply(this, arguments);
		this.representations.setReprClass("lexicon", ManageFolderLexiconRepr);
		this.representations.setReprClass("lexiconlisting", ManageFolderLexiconListingRepr);
		this.representations.setReprClass("folder", ManageFolderFolderRepr);
		this.representations.setReprClass("metaobject", ManageFolderMetaobjectRepr);
		this.representations.setReprClass("vocablelisting", ManageFolderVocableListingRepr);
		this.representations.setReprClass("folderlisting", ManageFolderFolderListingRepr);
		this.representations.setReprClass("box", ManageFolderBoxRepr);
		this.representations.setRenderHandler('metalisting', manageFolder_dragdrop);
		this.representations.setRenderHandler('folder', manageFolder_dragdrop);
		this.representations.setRenderHandler('lexicon', manageFolder_dragdrop);
		
		
	},

	initViewports:
	function (options) {
		//Obj.extend(options.tree, { initialRender: true });
		this.setViewport(new XsltViewport('tree', options.tree));
		//Obj.extend(options.list, { initialRender: true });
		this.setViewport(new XsltViewport('list', options.list));
		this.setViewport(new XsltViewport('workspace', options.workspace));		
		this.setViewport(new EditDialogViewport('contentedit', options.contentedit));
		this.setViewport(new EditDialogViewport('commentedit', options.commentedit));
	},

	reInit:
	function () {
		XmlManager.prototype.reInit.call(this, this.viewport_options_);
	},

	handleInitComplete:
	function() {
		requireArgs(arguments, 0);
		// Lang Parameter werden gesetzt
		this.xslt.setLangParameter();
		// Check workspace mode
		if (this.repr.getNode('1').listings.folderlisting_0.getXmlObjectNodes().length === 0)
			this.useSimpleLayout();
		// Flag toplevel lexicons
		this.repr.getNode('1').listings.lexiconlisting_0.flagAsColumns();
		XmlManager.prototype.handleInitComplete.call(this);
	},

	useSimpleLayout:
	function () {
		this.viewports.tree.hnode.parents('.panels').addClass('simple-folders');
	},

	useAdvancedLayout:
	function () {
		this.viewports.tree.hnode.parents('.panels').removeClass('simple-folders');
	},

	/*
	setupWorkspace:
	function () {
		var repr = null;
		// If there is anything rendered, remember it
		if (this.viewports.workspace)
			repr = this.viewports.workspace.repr;
		// Check if there are Folders. If there are any, use advanced workspace.
		if (this.repr.getNode('1').listings.folderlisting_0.getXmlObjectNodes().length === 0)
			this.useSimpleLayout();
		else
			this.useAdvancedLayout();
	}
	*/

	/** Client-side sorting of vocables.
	 * Not very useful because usually the full list of vacables is not available.
	 * This means that only the vocables on the serverpage can be sorted this way.
	 */
	sortVocabs: function () {
		// Find nodes to push at front
		var topids = {};
		Dom.getAllXPath(this.repr.getNode('1').xmlNode, './/lexiconlisting/objects/lexicon[@data-dz-column]/vocablelisting/objects/vocable').forEach(function (v) {
			topids[v.getAttribute('id')] = 1;
		});

		// Node list to sort
		var xlist = this.repr.getNode('2').listings.vocablelisting_0.getXmlObjectsNode();

		// Revert previous sorting
		var moved = this.vocab_origidx_.length;
		this.vocab_origidx_.forEach(function (oi, ni) {
			xlist.insertBefore(xlist.children[0], xlist.children[oi + moved - ni]);
		});

		// New sort
		var tailhead = xlist.firstChild;
		this.vocab_origidx_ = [];

		[].slice.apply(xlist.children).forEach(function (xnode, idx) {
			if (topids[xnode.getAttribute('id')]) {
				// move before "bad" elements
				if (xnode == tailhead) {
					// already at front
					tailhead = tailhead.nextSibling; // Assumes updated nextSibling
				}
				else {
					xlist.insertBefore(xnode, tailhead);
				}
				this.vocab_origidx_.push(idx)
			}
		}, this);
	},
	/* Zeigt den Root-Folder an */
	viewRoot:
	function() {
		this.listings.metalisting_0.renderViewport('workspace');
		/*
		Dom.getAllXPath(this.xmlDocument, '//lexicon[@data-dz-column]').forEach(function (node) {
			node.removeAttribute('data-dz-column');
		});
		*/
		this.repr.getNode('1').listings.lexiconlisting_0.flagAsColumns();
		this.listings.metalisting_0.renderViewport('list');
	}
});

var ManageFolder;
// Set default
if (!isdefined(ManageFolder)) {
	ManageFolder = ManageTrainerFolder;
}

/** In dict we want to load different data by default */
var ManageDictFolder = Class(ManageTrainerFolder, {
	query: function () {
		var qu = ManageTrainerFolder.prototype.query.apply(this, arguments);
		return qu.appending('filter-by-date', 'true');
	},
	cb_xmlLoaded: 
	function(xml, node, req) {
		xml.documentElement.setAttribute("application", "dict");
		ManageTrainerFolder.prototype.cb_xmlLoaded.call(this, xml, node, req);
	}
});

var ManageFolderLexiconRepr = Class(ObjectRepr, {
	queryAppendColumns: function(qu) {
		requireArgs(arguments, 1);
		return qu.appending('filter-object' + this.spId, 'true');
	},

	flagAsColumn:
	function () {
		// un-flag other columns
		/*
		this.manager.repr.getNode('1').clearSelection({recursive:true});
		this.setSelected(true);
		*/

		Dom.getAllXPath(this.manager.xmlDocument, '//lexicon[@data-dz-column]').forEach(function (node) {
			node.removeAttribute('data-dz-column');
		});
		// flag this
		this.setFlag('data-dz-column', true);
		//this.manager.sortVocabs();
	},

	renderViewport:
	function (name, options) {
		ObjectRepr.prototype.renderViewport.apply(this, arguments);

		if (name == 'workspace') {
			// Also update vocablelisting
			this.flagAsColumn();
			this.manager.repr.getNode('2').listings.vocablelisting_0.renderContent();
			//this.manager.repr.getNode('2').renderContent();
			/*
			var r = this.manager.repr; //.getNode('2'); //.listings.vocablelisting_0;
			r.renderViewport.apply(r, arguments);
			*/
		}
	},

	renderContent:
	function () {
		// When a lexicon column is modified, the vocable listing has to be re-rendered
		//if (this.getFlag('data-dz-column')) {
		if (this.selected()) {
			debug_message("lexiconlisting simple mode render divertion");
			//this.flagAsColumns();
			this.manager.repr.getNode('2').listings.vocablelisting_0.renderContent();
		}

		// In any case do the normal rendering to update all the usual places
		ListingRepr.prototype.renderContent.apply(this, arguments);
	},

	toggle:
	function(node, idword) {
		this.manager.ajax.startPostRequest(
			this.objectQuery().appending("action", "toggle").appending("idword", idword).appending("checked", node.checked)
		);
	},
	
	printDialog:
	function() {
		// TODO: Gleich richtig im Manager anlegen?
		if (!this.manager.viewports["print"]) {
			this.manager.addViewport(new DialogViewport('print', {node: $("#print"), mode: 'print',  dialog: {width: 640, height: 480, modal: false}}));
		}
		this.renderViewport('print');
		$("#print").fadeIn();
	},

	print:
	function(param, page) {
		var url = this.objectQuery().appending("action", "print").appending(param, page).appendingRaw($('#print').closest("form").serialize());
		url = url.toString().replace(/\.php/, ".pdf");
		window.open(url);
	}
});


var ManageFolderLexiconListingRepr = Class(ListingRepr, {
	queryAppendColumns: function(qu) {
		requireArgs(arguments, 1);

		Dom.getAllXPath(this.xmlNode, './objects/lexicon[@data-dz-column]').forEach(function (xnode) {
			this.getNode(xnode.getAttribute('id')).queryAppendColumns(qu);
		}, this);

		return qu;
	},

	flagAsColumns:
	function () {
		// un-flag other columns
/*
		this.manager.repr.getNode('1').clearSelection({recursive:true});
		this.getServerPageNodes().forEach(function (node) {
			node.setSelected(true);
		});
*/
		Dom.getAllXPath(this.manager.xmlDocument, '//lexicon[@data-dz-column]').forEach(function (node) {
			node.removeAttribute('data-dz-column');
		});
		// flag columns in this listing
		Dom.getAllXPath(this.xmlNode, './objects/lexicon').forEach(function (node) {
			node.setAttribute('data-dz-column', true);
		});

		//this.manager.sortVocabs();
	},

	renderContent:
	function () {
		// When a lexicon column is modified, the vocable listing has to be re-rendered
		debug_message("lexiconlisting simple mode render divertion");
		this.flagAsColumns();
		this.manager.repr.getNode('2').listings.vocablelisting_0.renderContent();

		// In any case do the normal rendering to update all the usual places
		ListingRepr.prototype.renderContent.apply(this, arguments);
	}
});

var ManageFolderFolderRepr = Class(ObjectRepr, {
	queryAppendColumns: function(qu) {
		requireArgs(arguments, 1);

		if (Dom.getAllXPath(this.xmlNode, './lexiconlisting[@id=0]/objects/lexicon[@data-dz-column]').length) {
			qu.appending('filter-object' + this.spId, 'true');
		}
		//this.listings.lexiconlisting_0.queryAppendColumns(qu);

		return qu;
	},

	flagAsColumns:
	function () {
		this.listings.lexiconlisting_0.flagAsColumns();
	},

	renderViewport:
	function (name, options) {
		if (name == 'workspace') {
			// Also update vocablelisting
			this.flagAsColumns();
			var qu = makeQueryUrl("");
			this.queryAppendColumns(qu);
			var vls = this.manager.repr.getNode('2').listings.vocablelisting_0;
			vls.requestDisplay(
					new ListingDisplayState('', 0, vls.dataProperties, qu.querystring())
				);
			//this.manager.repr.getNode('2').listings.vocablelisting_0.renderContent();
		}
		ObjectRepr.prototype.renderViewport.apply(this, arguments);
	},


	printDialog:
	function() {
		// TODO: Gleich richtig im Manager anlegen?
		if (!this.manager.viewports["print"]) {
			this.manager.addViewport(new DialogViewport('print', {node: $("#print"), mode: 'print',  dialog: {width: 640, height: 480, modal: false}}));
		}
		this.renderViewport('print');
		$("#print").fadeIn();
	},

	print:
	function(param, page) {
		var url = this.objectQuery().appending("action", "print").appending(param, page).appendingRaw($('#print').closest("form").serialize());
		url = url.toString().replace(/\.php/, ".pdf");
		window.open(url);
	}
});

var ManageFolderBoxRepr = Class(ObjectRepr, {
	print:
	function(param, page) {
		var url = this.objectQuery().appending("action", "print").appending(param, page).appendingRaw($('#print').closest("form").serialize());
		url = url.toString().replace(/\.php/, ".pdf");
		window.open(url);
	}
});

var ManageFolderMetaobjectRepr = Class(ObjectRepr, {
	printDialog:
	function() {
		// TODO: Gleich richtig im Manager anlegen?
		if (!this.manager.viewports["print"]) {
			this.manager.addViewport(new DialogViewport('print', {node: $("#print"), mode: 'print',  dialog: {width: 640, height: 480, modal: false}}));
		}
		this.renderViewport('print');
		$("#print").fadeIn();
	},

	print:
	function(param, page) {
		var url = this.objectQuery().appending("action", "print").appending(param, page).appendingRaw($('#print').closest("form").serialize());
		url = url.toString().replace(/\.php/, ".pdf");
		window.open(url);
	}
});

// var MetaobjectRepr = Class(ObjectRepr, {
// 	print:
// 	function(param, page) {
// 		var url = this.objectQuery().appending("action", "print").appending(param, page).appendingRaw($('#managefolder').serialize());
// 		url = url.toString().replace(/\.php/, ".pdf");
// 		window.open(url);
// 	}
// });
// globalRepresentations.setReprClass("metaobject", MetaobjectRepr);


ManageFolderVocableListingRepr = Class(ListingRepr, {
	objectQuery: function (options) {
		var options = defaulting(options, {});
		var qu = ListingRepr.prototype.objectQuery.call(this, options);
		if (isdefined(options.restrictStr)) {
			qu.appendingRaw(options.restrictStr);
		}
		return qu;
	},
	printDialog:
	function() {
		// TODO: Gleich richtig im Manager anlegen?
		if (!this.manager.viewports["print"]) {
			this.manager.addViewport(new DialogViewport('print', {node: $("#print"), mode: 'print',  dialog: {width: 640, height: 480, modal: false}}));
		}
		this.renderViewport('print');
		$("#print").fadeIn();
	},
	
	print:
	function(param, page) {
		var url = this.objectQuery().appending("action", "print").appending(param, page).appendingRaw($('#print').closest("form").serialize());
		url = url.toString().replace(/\.php/, ".pdf");
		window.open(url);
	},
	deleteAllVocables:
	function() {
		if (confirm("Alle Vokabeln und deren Statistik löschen?")) {
			this.manager.ajax.startPostRequest(
				this.objectQuery().appending("action", "delete-all")
			);
		}
	},
	resetStatistic:
	function() {
		if (confirm("Gesamte Statistik zurücksetzen?")) {
			this.manager.ajax.startPostRequest(
				this.objectQuery().appending("action", "reset-statistic")
			);
		}
	}
});


// TODO: Do the same search as the DB
globalRepresentations.setSearchFunction('vocablelisting', function (xnode, searchterm) {
	return $(xnode).find('word').is(function () {
		return this.firstChild.data.toLowerCase().indexOf(searchterm) !== -1;
	});
});

ManageFolderFolderListingRepr = Class(ListingRepr, {
	/*
	cb_updated:
	function () {
		// For folders this is sent when the first item is inserted, since depending
		// on the type of that item the folders appearence changes.
		ListingRepr.prototype.cb_update.apply(this, arguments);
	},
	*/

	cb_nodeInserted:
	function () {
		ListingRepr.prototype.cb_nodeInserted.apply(this, arguments);
		if ((this.parent.crId == 'metaobject_1') && (this.getXmlObjectNodes().length == 1)) {
			// Was first folder that got inserted.
			//this.manager.viewports.list.reRender();
			this.manager.useAdvancedLayout();
		}
	},
	cb_nodeDeleted:
	function () {
		ListingRepr.prototype.cb_nodeDeleted.apply(this, arguments);
		if ((this.parent.crId == 'metaobject_1') && (this.getXmlObjectNodes().length == 0)) {
			// Re-render metalisting because we now need the simple viewport.
			this.manager.useSimpleLayout();
			//this.manager.viewports.list.reRender();
		}
	}
});

/*
// The workspace viewport node is created when rendering the metalisting, so
// setup of the viewport needs to take place after rendering of the metalisting.
function manageFolder_metalisting_renderHandler(node) {
	this.manager.setupWorkspace();
	// TODO: Trigger render of workspace?
	this.manager.repr.getNode('1').listings.lexiconlisting_0.renderViewport('workspace');
};
*/

var ImportFolder = Class(XmlManagerListPanel, {
	/**
	* Wizzard einen Folder oder ein Lexicon zu importieren
	*/
	open:
	function() {
		if (this.viewports.list.inUse()) {
			// Already initialized
			// Should be ok to just re-display existing dialog.
			// We probably want to continue to work were we left of.
			/*
			if (this.viewports.workspace.inUse()) {
				this.viewports.workspace.close();
			}
			this.listings.metalisting_0.getNode('1').listings.personlisting_0.reset();
			*/
		}
		else {
			this.listings.metalisting_0.renderViewport('list', {renderMode: "select-source"});
		}
		$("#importFolder").dialog({
			height: 600,
			width: 800,
			modal: false
		});
		this.source = null;
	},
	/**
	 * Ein Folder oder ein Lexicon ist zum Import gewählt worden
	 * @param sNode Javascrit Object des Knoten
	 */
	selectSource: 
	function(sNode) {
		sNode.xmlNode.setAttribute("selected", "selected");
		this.source = sNode;
		this.viewports["workspace"].hide();
		this.listings.metalisting_0.renderViewport('list', {renderMode: "select-target"});
	},
	/**
	 * Ziel ist ausgewählt worden
	 * @param sNode Javascrit Object des Knoten
	 */
	selectTarget: 
	function(sNode) {
		// TODO an den Server senden
		$("#importFolder").dialog("close");
		this.manager.ajax.startPostRequest(
			this.source.objectQuery().appending("action", "import").appending("idfolder", sNode.rId)
		);
	}
});

function manageFolder_dragdrop(_displayn, _repr, _mode, display) {
	if (display.viewport.name !== 'tree')
		return;

	function handleDrop(eventObject, ui) {
		// Get js objects
		var source = $(ui.draggable).dz('repr');
		var target = $(eventObject.target).dz('repr');
		source.move(target.spId);
	}

	var drag_spec = {
		scope: display.viewport.name,
		containment: display.viewport.hcnode,
		distance: 3, /* to prevent accidential dragging. */
		helper: 'clone',
		axis: 'y',
		revert: true
	};
	var drop_spec = {
		scope: display.viewport.name,
		greedy: true,
		drop: handleDrop
	};

	// Folder
	display.hnode.find("[data-dz-role='container'][data-dz-name^='folder_']")
		.draggable(drag_spec)
		.droppable(drop_spec);

	// Lexicon
	display.hnode.find("[data-dz-role='container'][data-dz-name^='lexicon_']")
		.draggable(drag_spec);
};


Leo.Js.dictExtra.staticallyLoaded();
