 /*************************************************************
  *															  *
  *		This software is distributed under the GPL License	  *
  *															  *
  *															  *
  *		Android like Toast Notifications and more!!	    	  *
  *															  *
  *		Author: Jose J. Llopis Temes						  *
  *		contact: joselltemes -@- -gmail- -dot- com			  *
  *     Release Date: 2013-11-28						      *
  *															  *
  ************************************************************/
 window.Toast=
	function(message,duration,style)
	{
		var span;
		if(document.getElementById("toaster")==null)
		{
			span=document.createElement("span");
		}
		else
		{
			span=document.getElementById("toaster");
			document.body.removeChild(span);
			span=document.createElement("span");
		}
			var t=document.createTextNode(message);
			
			span.setAttribute("id", "toaster");			
			span.style.padding="5px";
			span.style.zIndex=1000;
			span.style.borderRadius="5px";
			span.style.display="flex";
			span.style.height="1rem";
			span.style.opacity=0.5;
			span.style.textAlign="center";
			span.style.position="fixed";
			span.style.backgroundColor="#333";
			span.style.borderColor="#AAA";
			span.style.borderWidth="5px";
			span.style.color="#fff";
			span.style.boxShadow="0px 1px 1px #888888";
			span.style.left="25%";
			span.style.top="90%";
			span.style.top="90%";
			span.appendChild(t);			
			span.style.transition = 'all '+(duration/4000)+'s ease-in-out';
			
			if(style==0)//classic toast
			{
				span.style.opacity=0;
				setTimeout(function(){fade(1);setTimeout(function(){fade(0);},duration);},1000);
			}
			else if(style==1)//"flip" toast
			{				
				span.style.transformStyle="preserve-3d";
				span.style.backfaceVisibility="hidden";
				span.style.transform="rotateY( 180deg )";
				
				setTimeout(function(){flip(0);setTimeout(function(){flip(180);},duration);},1000);
			}
			else if(style==2)//crecer
			{			
				span.style.transform="scale(0)";
				span.style.opacity=1;
				setTimeout(function(){resize(1);setTimeout(function(){resize(0);},duration);},1000);
			}
			else if(style==3)//crecer y girar en x
			{			
				span.style.transform="scale(0) rotateZ(360deg)";
				span.style.opacity=1;
				setTimeout(function(){giraRes(1);setTimeout(function(){giraRes(0);},duration);},1000);
			}
			else if(style==4)//appear from top
			{
				span.style.top="-2rem";
				span.style.opacity=1;
				setTimeout(function(){appear(0);setTimeout(function(){appear(-2);},duration);},1000);
			}
			else if(style==5)//appear from bottom;
			{
				span.style.top="120%";
				span.style.opacity=1;
				setTimeout(function(){appearBottom(95);setTimeout(function(){appearBottom(120);},duration);},1000);
			}
			document.body.appendChild(span);
			
			function resize(parameter){span.style.transform="scale("+parameter+")";span.style.opacity=1;}
			function fade(parameter){span.style.opacity=parameter;}
			function appear(parameter){span.style.top=parameter+"rem";}
			function appearBottom(parameter){span.style.top=parameter+"%";}
			function giraRes(parameter)
			{
				span.style.opacity=1;
					if(parameter==1){span.style.transform="scale(1) rotateZ(0deg)";}
					if(parameter==0){span.style.transform="scale(0) rotateZ(360deg)";}
			}
			function flip(parameter){span.style.transform="rotateY("+parameter+"deg)";span.style.opacity=1;}
	}
	window.Toast.LENGTH_LONG=10000;
	window.Toast.LENGTH_SHORT=2000;