var watchID = null;

var borde = null,
	circulo = null,
	letras = null,
	needle_fija = null,
	needle_movil = null,
	grados_destino = 0;
	
var puntos = new Array();

function draw(degrees) {

	borde.setAttribute("transform","rotate("+toDeg(-degrees)+" 100 100)");
	circulo.setAttribute("transform","rotate("+toDeg(-degrees)+" 100 100)");
	letras.setAttribute("transform","rotate("+toDeg(-degrees)+" 100 100)");
	//alert("rotate("+toDeg(-degrees)+" 100 100)");
	needle_movil.setAttribute("transform","rotate("+(toDeg(-(grados_destino + degrees)))+" 100 100)");
	//alert("rotate("+(toDeg(-(grados_destino + degrees - Math.PI / 2))-90)+" 100 100)");
	
}

function init() {

	var S=document.getElementById("sv");
	//alert(S);
	var SD=S.contentDocument;
	//alert(SD);
	borde=SD.getElementById('Circle');
	//alert(borde);
	circulo=SD.getElementById('Layer_5');
	//alert(circulo);
	letras=SD.getElementById('Letras');
	//alert(letras);
	needle_fija=SD.getElementById('Aguja_Verde');
	//alert(needle_fija);
	needle_movil=SD.getElementById('Aguja_Roja');
	//alert(needle_movil);
	
	needle_fija.setAttribute("transform","rotate(0 100 100)");
	
	needle_movil.setAttribute("display","none");
	
	draw(0);
	
	if (window.DeviceOrientationEvent) {
		window.addEventListener("deviceorientation", function (e) {
		  deg = 2 * Math.PI - (e.alpha * (Math.PI / 180));
		  draw(deg);
		  //output.innerHTML = grados_destino;
		}, false);
	  }

}

var deg = 0;
var dest = 0;
var lat_anterior = 0;
var long_anterior = 0;
var output = document.getElementById("out");
var rastreo = 0;
var destino_lat = 0;
var destino_long = 0;
var vuelta = 0;

function iniciar_seguimiento(){

	reiniciar_todo();
	needle_movil.setAttribute("display","none");
	navigator.geolocation.clearWatch(rastreo);
	
	document.getElementById("foot-button").innerHTML = '<button class="useit" id="stop_tracing" onclick="parar_seguimiento();" style="padding: 10px !important;">'+
						trd["#stop_tracing"]+'</button><a href="#pagefour" onclick="refresh_table();"><button class="useit-second"  id="points_list_tracing" style="padding: 10px !important;" >'+
						trd["#points_list_tracing"]+'</button></a>';
	$("#foot-button").trigger('create');
	
	var geo_options = {
	  enableHighAccuracy: true
	};

	if (!navigator.geolocation){
		alert("Geolocation is not supported by your browser");
		return;
	}
  
	function geo_success(position) {
		var latitude  = position.coords.latitude;
		var longitude = position.coords.longitude;
		var distancia = calcular_distancia_real(long_anterior,lat_anterior,longitude,latitude);
		if(distancia > 300 || (lat_anterior == 0 && long_anterior == 0)){
			lat_anterior = latitude;
			long_anterior = longitude;
			puntos[puntos.length] = latitude+","+longitude;
			//localStorage.setItem(localStorage.length+1, latitude+","+longitude); /////////////////////////////////
			latitude = recortar_numero(latitude, 4); 
			longitude = recortar_numero(longitude, 4); 
			output.innerHTML = "<span id='last_point'>"+trd['#last_point']+"</span> "+latitude+","+longitude;
		}
	};

	function geo_error() {
		alert("Unable to retrieve your location");
	};
	
	alert(trd['#tracking_init']);

	rastreo = navigator.geolocation.watchPosition(geo_success, geo_error, geo_options);

}

function parar_seguimiento(){

	needle_movil.setAttribute("display","none");
	document.getElementById("foot-button").innerHTML = '<button class="useit_big" id="back_tracing" onclick="camino_vuelta();" style="padding: 10px !important;">'+trd["#back_tracing"]+'</button>';
	$("#foot-button").trigger('create');
	navigator.geolocation.clearWatch(rastreo);
	output.innerHTML = "";
	vuelta = 0;
	navigator.geolocation.clearWatch(rastreo);

}

function reiniciar_todo(){

	puntos = new Array();
	//localStorage.clear(); /////////////////////////////////
	lat_anterior = 0;
	long_anterior = 0;
	grados_destino = 0;	
	output.innerHTML = "";

}

function camino_vuelta(){

	navigator.geolocation.clearWatch(rastreo);

	document.getElementById("foot-button").innerHTML = '<button class="useit" id="next_tracing" onclick="sig_punto();" style="padding: 10px !important;">'+trd["#next_tracing"]+'</button><button class="useit-second" id="start_new_tracing" onclick="iniciar_seguimiento();" style="padding: 10px !important;">'+trd["#start_new_tracing"]+'</button>';
	$("#foot-button").trigger('create');
	
	if(puntos[0] !== null){ /////////////////////////////////
	
		needle_movil.setAttribute("display","inline");
	
		vuelta = 1;
		
		// TEST
		var destino_str = puntos[puntos.length-1];
		//var destino_str = localStorage.getItem(localStorage.length); /////////////////////////////////
		
		destino_lat = parseFloat(destino_str.substring(0, destino_str.indexOf(",")));
			
		destino_long = parseFloat(destino_str.substring(destino_str.indexOf(",")+1, destino_str.length));
		// TEST		

		alert(trd['#next_destination']+" "+destino_lat+","+destino_long);
		
		var geo_options = {
		  enableHighAccuracy: true
		};

		if (!navigator.geolocation){
			alert("Geolocation is not supported by your browser");
			return;
		}
	  
		function geo_success(position) {
			var latitude  = position.coords.latitude;
			var longitude = position.coords.longitude;
			//var distancia_real = calcular_distancia_real(0, 0, destino_long, destino_lat);
			var distancia_real = calcular_distancia_real(longitude, latitude, destino_long, destino_lat);
			distancia_real = distancia_real/1000;
			output.innerHTML = "<span id='distance'>" + trd['#distance'] + "</span> " + distancia_real.toFixed(2) + " <span id='distance_km'>" + 
								trd['#distance_km'] + "</span>";
			var angulo = calcular_angulo(longitude, latitude, destino_long, destino_lat);
			//var angulo = calcular_angulo(0, 0, destino_long, destino_lat);
			grados_destino = angulo;
		};

		function geo_error() {
			document.getElementById("foot-button").innerHTML = '<button class="useit_big" id="start_tracing" onclick="iniciar_seguimiento();" style="padding: 10px !important;">'+trd["#start_tracing"]+'</button>';
			alert("Unable to retrieve your location");
		};

		rastreo = navigator.geolocation.watchPosition(geo_success, geo_error, geo_options);
		
	} else {
	
		alert(trd['#list_empty']);
		document.getElementById("foot-button").innerHTML = '<button class="useit_big" id="start_tracing" onclick="iniciar_seguimiento();" style="padding: 10px !important;">'+trd["#start_tracing"]+'</button>';
		$("#foot-button").trigger('create');
	
	}
	
}

function sig_punto(){
	
	if(vuelta == 1){

		if(puntos[1] != null){ /////////////////////////////////
			puntos.splice(puntos.length-1, 1);
			//localStorage.removeItem(localStorage.length); ////////////////////////////////////////
			//[destino_lat, destino_long] = sscanf (localStorage.getItem(localStorage.length), "%f,%f");
			// TEST
			var destino_str = puntos[puntos.length-1];
			//var destino_str = localStorage.getItem(localStorage.length); /////////////////////////////////
			destino_lat = parseFloat(destino_str.substring(0, destino_str.indexOf(",")));
			destino_long = parseFloat(destino_str.substring(destino_str.indexOf(",")+1, destino_str.length));
			// TEST	
			alert(trd['next_destination']+" "+destino_lat+","+destino_long);
		} else {
			alert(trd['#no_new']);
		}
		
	}else{
		
		alert("Pulse primero el botón vuelta.");
		
	}
}	

function toRad(x){ 
	return x*Math.PI/180;
}

function toDeg(x){ 
	return Math.round(x*180/Math.PI);
}

function calcular_distancia_real(long_p1,lat_p1,long_p2,lat_p2){
	var distancia_real = 6378.137 * Math.acos( Math.cos( toRad(lat_p1) ) * Math.cos( toRad(lat_p2) ) * Math.cos( toRad(long_p2 - long_p1) ) + Math.sin( toRad(lat_p1) ) * Math.sin( toRad(lat_p2)) );
	return (distancia_real * 1000);
}

function calcular_distancia(long_p1,lat_p1,long_p2,lat_p2){
	var distancia = Math.sqrt( Math.pow((long_p1-long_p2),2) + Math.pow((lat_p1-lat_p2),2) );
	return distancia;
}

function calcular_angulo(long_actual,lat_actual,long_destino,lat_destino){
	
	var long_x = long_actual;
	var lat_x = lat_destino;

	var d1 = calcular_distancia(long_actual,lat_actual,long_destino,lat_destino);
	var d2 = calcular_distancia(long_x,lat_x,long_destino,lat_destino);
	var d3 = calcular_distancia(long_actual,lat_actual,long_x,lat_x);

	var angulo = Math.asin(d2/d1);

	if(long_actual == long_destino || lat_actual == lat_destino){

		if(long_actual < long_destino && lat_actual == lat_destino){
			angulo = 0;
		}else if(long_actual == long_destino && lat_actual < lat_destino){
			angulo = Math.PI/2;
		}else if(long_actual > long_destino && lat_actual == lat_destino){
			angulo = Math.PI;
		}else if(long_actual == long_destino && lat_actual > lat_destino){
			angulo = 3*Math.PI/2;
		}
	
	} else {
	
		if(long_actual < long_destino && lat_actual < lat_destino){
			angulo = (Math.PI/2) - angulo;
		}else if(long_actual > long_destino && lat_actual < lat_destino){
			angulo = (Math.PI/2) + angulo;
		}else if(long_actual > long_destino && lat_actual > lat_destino){
			angulo = (3*Math.PI/2) - angulo;
		}else if(long_actual < long_destino && lat_actual > lat_destino){
			angulo = (3*Math.PI/2) + angulo;
		}
	
	}
	
	//angulo = toDeg(angulo);

	return angulo;

}

function recortar_numero(numero, decimales){
	var x = Math.pow(10,decimales);
	numero = Math.floor(numero*x)/x; 
	return numero;
}

