// Global variable
var img = null,
	needle_fija = null,
	needle_movil = null,
	grados_destino = 0,
	ctx = null;

function draw(degrees) {

	borde.setAttribute("transform","rotate("+toDeg(-degrees)+" 100 100)");
	circulo.setAttribute("transform","rotate("+toDeg(-degrees)+" 100 100)");
	letras.setAttribute("transform","rotate("+toDeg(-degrees)+" 100 100)");
	//alert("rotate("+toDeg(-degrees)+" 100 100)");
	needle_movil.setAttribute("transform","rotate("+(toDeg(-(grados_destino + degrees)))+" 100 100)");
	//alert("rotate("+(toDeg(-(grados_destino + degrees - Math.PI / 2))-90)+" 100 100)");
	
}

function init() {

	var S=document.getElementById("sv");
	//alert(S);
	var SD=S.contentDocument;
	//alert(SD);
	borde=SD.getElementById('Circle');
	//alert(borde);
	circulo=SD.getElementById('Layer_5');
	//alert(circulo);
	letras=SD.getElementById('Letras');
	//alert(letras);
	needle_fija=SD.getElementById('Aguja_Verde');
	//alert(needle_fija);
	needle_movil=SD.getElementById('Aguja_Roja');
	//alert(needle_movil);
	
	needle_fija.setAttribute("transform","rotate(0 100 100)");
	
	needle_movil.setAttribute("display","none");
	
	draw(0);
	
	if (window.DeviceOrientationEvent) {
		window.addEventListener("deviceorientation", function (e) {
		  deg = 2 * Math.PI - (e.alpha * (Math.PI / 180));
		  draw(deg);
		  //output.innerHTML = grados_destino;
		}, false);
	  }

}

var deg = 0;
var dest = 0;
var output = document.getElementById("out");
var rastreo = 0;
var destino_lat = 0;
var destino_long = 0;

function validaFloat(numero){
	if (isNaN(numero) || numero == "")
		return false;
	else
		return true;
}

function ir_punto() {
	
	parar_seguimiento();
	
	destino_lat = document.getElementById("lat").value;
	destino_long = document.getElementById("long").value;
	
	if(validaFloat(destino_lat) && validaFloat(destino_long)){
	
		needle_movil.setAttribute("display","inline");
		
		var geo_options = {
		  enableHighAccuracy: true
		};

		if (!navigator.geolocation){
			alert("Geolocation is not supported by your browser");
			return;
		}
	  
		function geo_success(position) {
		
			var latitude  = position.coords.latitude;
			var longitude = position.coords.longitude;
			var distancia_real = calcular_distancia_real(longitude, latitude, destino_long, destino_lat);
			distancia_real = distancia_real/1000;
			output.innerHTML = "<span id='distance'>" + trd['#distance'] + "</span> " + distancia_real.toFixed(2) + " <span id='distance_km'>" + trd['#distance_km'] + "</span>";
			var angulo = calcular_angulo(longitude, latitude, destino_long, destino_lat);
			grados_destino = angulo;
			draw(0);
		};

		function geo_error() {
			alert("Unable to retrieve your location");
		};
		
		alert(trd['#generate_route']);

		rastreo = navigator.geolocation.watchPosition(geo_success, geo_error, geo_options);
		
	} else {
	
		alert(trd['#no_valid']);
	
	}
  
}

function parar_seguimiento(){

	navigator.geolocation.clearWatch(rastreo);
	output.innerHTML = "";
	needle_movil.setAttribute("display","none");
	
}

function toRad(x){ 
	return x*Math.PI/180;
}

function toDeg(x){ 
	return Math.round(x*180/Math.PI);
}

function calcular_distancia_real(long_p1,lat_p1,long_p2,lat_p2){
	var distancia_real = 6378.137 * Math.acos( Math.cos( toRad(lat_p1) ) * Math.cos( toRad(lat_p2) ) * Math.cos( toRad(long_p2 - long_p1) ) + Math.sin( toRad(lat_p1) ) * Math.sin( toRad(lat_p2)) );
	return (distancia_real * 1000);
}

function calcular_distancia(long_p1,lat_p1,long_p2,lat_p2){
	var distancia = Math.sqrt( Math.pow((long_p1-long_p2),2) + Math.pow((lat_p1-lat_p2),2) );
	return distancia;
}

function calcular_angulo(long_actual,lat_actual,long_destino,lat_destino){
	
	var long_x = long_actual;
	var lat_x = lat_destino;

	var d1 = calcular_distancia(long_actual,lat_actual,long_destino,lat_destino);
	var d2 = calcular_distancia(long_x,lat_x,long_destino,lat_destino);
	var d3 = calcular_distancia(long_actual,lat_actual,long_x,lat_x);

	var angulo = Math.asin(d2/d1);

	if(long_actual == long_destino || lat_actual == lat_destino){

		if(long_actual < long_destino && lat_actual == lat_destino){
			angulo = 0;
		}else if(long_actual == long_destino && lat_actual < lat_destino){
			angulo = Math.PI/2;
		}else if(long_actual > long_destino && lat_actual == lat_destino){
			angulo = Math.PI;
		}else if(long_actual == long_destino && lat_actual > lat_destino){
			angulo = 3*Math.PI/2;
		}
	
	} else {
	
		if(long_actual < long_destino && lat_actual < lat_destino){
			angulo = (Math.PI/2) - angulo;
		}else if(long_actual > long_destino && lat_actual < lat_destino){
			angulo = (Math.PI/2) + angulo;
		}else if(long_actual > long_destino && lat_actual > lat_destino){
			angulo = (3*Math.PI/2) - angulo;
		}else if(long_actual < long_destino && lat_actual > lat_destino){
			angulo = (3*Math.PI/2) + angulo;
		}
	
	}
	
	//angulo = toDeg(angulo);
	
	return angulo;

}