var poligono;

var lat_anterior = 0;
var long_anterior = 0;

var map = L.map('map').setView([40.3250, -3.8664], 15);

L.tileLayer('http://{s}.tile.opencyclemap.org/cycle/{z}/{x}/{y}.png', {
	tileSize: 256,
	maxZoom: 18,
	minZoom: 10,
	attribution: '© <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors.'
}).addTo(map);

var popup = L.popup();

function cambiar_color(valor){
	alert(trd['track_stop']);
	var lat_anterior = 0;
	var long_anterior = 0;
	var puntos = poligono.getLatLngs();
	var init_point =  [ puntos[puntos.length-1] ];
	//var init_point =  [L.latLng(0, 0)];
	poligono = L.polyline(init_point, {color: 'red'}).addTo(map);
}

function geoFindMe() {

	var init_point =  [L.latLng(0, 0)];
	poligono = L.polyline(init_point, {color: 'blue'}).addTo(map);
	
	var geo_options = {
	  enableHighAccuracy: true
	};

	if (!navigator.geolocation){
		alert("Geolocation is not supported by your browser");
		return;
	}
  
	function geo_success(position) {
	
		var latitude  = position.coords.latitude;
		var longitude = position.coords.longitude;
		
		var distancia = calcular_distancia_real(long_anterior,lat_anterior,longitude,latitude);
		
		if(distancia > 50 || (lat_anterior == 0 && long_anterior == 0)){
		
			var puntos = poligono.getLatLngs();
			
			if(puntos[0].lat == 0 && puntos[0].lng == 0){
			
				poligono.setLatLngs( [L.latLng(latitude, longitude)] ); 
			
			} else {
			
				poligono.addLatLng( L.latLng(latitude, longitude) ); 
			
			}
		
			lat_anterior = latitude;
			long_anterior = longitude;
			map.panTo([latitude, longitude]);
			
		}
	};

	function geo_error() {
		alert("Unable to retrieve your location");
	};
	
	alert(trd['track_init']);

	var wpid = navigator.geolocation.watchPosition(geo_success, geo_error, geo_options);
  
}

function toRad(x){ 
	return x*Math.PI/180;
}

function calcular_distancia_real(long_p1,lat_p1,long_p2,lat_p2){
	var distancia_real = 6378.137 * Math.acos( Math.cos( toRad(lat_p1) ) * Math.cos( toRad(lat_p2) ) * Math.cos( toRad(long_p2 - long_p1) ) + Math.sin( toRad(lat_p1) ) * Math.sin( toRad(lat_p2)) );
	return (distancia_real * 1000);
}