(function($) {
  var appL = $.mobile.appL = {
    host: 'http://pappcornbackapp.com/ws/expWS.php',
    base: 'http://pappcornbackapp.com/adminApp/',
    idTeam: 'LIGAAPP',
    data: "",
    activePage: "",
    userPosition: "",
    cargando: false,
    cargoNoticias: false,
    noticia: false,
    load: false,
    link: true,
    init: function() {
      $(document).bind('pageinit', function() {
        $('.icoReload').click(function() {
          appL.activePage = $.mobile.urlHistory.getActive().hash;
          if (!appL.cargando) {
            appL.cargando = true;
            checkData(true);
          }
        });
        appL.activePage = $.mobile.urlHistory.getActive().hash;
        $('#home').on('pageshow', function() {
          if (appL.link) {
            appL.activePage = "#menu"
          };
        });
        if (appL.activePage != "#menu" && appL.load) {
          appL.link = false;
        }
        if (!appL.load) {
          appL.load = true;
          checkData(true);
        }
      });
    },
    loadPosition: function() {
      if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function(position) {
          appL.userPosition = position;
        });
      } else {
      }
    },
    loadJsonData: function(f) {
      $.ajax({
        type: "POST",
        url: appL.host,
        cache: true,
        data: 'code=' + appL.idTeam + '&app=nacional',
        async: true,
        crossDomain: true,
        dataType: 'json',
        success: function(data) {
          appL.data = data;
          localStorage.setItem('dataJson', JSON.stringify(appL.data));
          appL.preload();
          appL.cargando = false;
          if (typeof f == "function")
            f();
        },
        error: function(xhr, testStatus, error) {
          appL.data = localStorage.getItem('dataJson');
          if (jQuery.isEmptyObject(appL.data) || !appL.data || appL.data == "") {
            alert("No se ha podido actualizar, los datos pueden estar desactualizados.");
            appL.preload();
            if (typeof f == "function")
              f();
          } else {
            alert("No inicializar por favor inicializarla con internet.");
            $.mobile.changePage("#error", {
              transition: "slideup",
              changeHash: false
            });
          }

        }
      });
    },
    preload: function() {
      appL.loadPosition();           
      mostrarNoticias();
      mostrarEquipos();
      mostrarTabla("");
      mostrarTablaRecla("");
      mostrarTablaDesc("");
      mostrarTablaGole("");
      mostrarResultados();
      mostrarCalendario();
      mostrarPanelMin();
      loadMenu();

      $.mobile.changePage(appL.activePage, {
          transition: "slideup",
          changeHash: false
      });
      
      // mostrarMinAmin();
      // mostrarLinks();
      // mostrarBracket();
      // mostrarResultados("1");
      // mostrarResultados(2);
    },
    clean: function(f) {
      $('#news').empty();
      $('.m-carousel').carousel('destroy');
      $('#sliderNews').append("\
              <div class='m-carousel m-fluid m-carousel-photos'>\
              <div id='loadNotiCC' class='m-carousel-inner'></div>\
              <div class='m-carousel-controls m-carousel-hud'>\
              <a class='m-carousel-prev' href='#' data-slide='prev'>Previous</a>\
              <a class='m-carousel-next' href='#' data-slide='next'>Next</a>\
              </div>\
              </div>\
              ");
      var fileref = document.createElement('script');
      fileref.setAttribute("type", "text/javascript");
      fileref.setAttribute("src", 'carousel.js');
    },
  };
  appL.init();

  function loadMenu() {
    $(".menuLat").empty();
    $(".menuLat").append('\
            <div class="menuLFixed">\
            <div class="slogan"></div>\
            <div class="cuadritos">\
            <a href="#noticias"><div class="icoML left">\
            <div class="icoMI icoMenu ">\
            </div>\
            <p>NOTICIAS</p>\
            </div></a>\
            <a href="#team"><div class="icoML left">\
            <div class="icoMI icoPlan ">\
            </div>\
            <p>EQUIPOS</p>\
            </div></a>\
            <a href="#menuTablas"><div class="icoML left last">\
            <div class="icoMI icoTab">\
            </div>\
            <p>TABLAS</p>\
            </div></a>\
            <a href="#cal"><div class="icoML left">\
            <div class="icoMI icoCal ">\
            </div>\
            <p>CALEND.</p>\
            </div></a>\
            <a href="#res-0"><div class="icoML left">\
            <div class="icoMI icoRes ">\
            </div>\
            <p>RESULT.</p>\
            </div></a>\
            <a href="#minamin"><div class="icoML left last">\
            <div class="icoMI icoMin ">\
            </div>\
            <p>MIN A MIN</p>\
            </div></a>\
            <a href="#historia"><div class="icoML left firts">\
            <div class="icoMI icoRed ">\
            </div>\
            <p>HISTORIA</p>\
            </div></a>\
            <a href="#info"><div class="icoInfo centro"></div></a>\
            </div></div>');

  }
  // forse fuerza a cargar de nuevo

  function checkData(forse, f) {
    data = localStorage.getItem('dataJson');
    try {
      appL.data = JSON.parse(data);
    } catch (err) {
      appL.data = null;
    }
    if (jQuery.isEmptyObject(appL.data) || !appL.data || appL.data == "" || forse) {
      $.mobile.changePage("#home", {
        transition: "slideup",
        changeHash: false
      });
      appL.loadJsonData(function() {        
        if (typeof f == "function")
          f();
      });
    } else {
      if (typeof f == "function")
        f();
    }

  }
  function mostrarLinks(){
      $('#urlFacebook').attr('href', appL.data.infoTeam.facebook);
    $('#urlTwitter').attr('href', appL.data.infoTeam.twitter);
    $('#urlTwitter').attr('data-widget-id', appL.data.infoTeam.codeWidget);
    $('#urlWeb').attr('href', appL.data.infoTeam.webSite);
    !function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+"://platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");
    $('#linkFace').attr('src', appL.data.infoTeam.facebook);
    $('#linkTwitter').attr('src', appL.data.infoTeam.twitter);
    $('#linkWeb').attr('src', appL.data.infoTeam.webSite);
    $('#linkExtra').attr('src', appL.data.infoTeam.extra);    
    
  }

  function getMes(date) {
    var monthNames = ["Ene", "Feb", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Sept", "Oct", "Nov", "Dec"];
    return monthNames[date];
  }

  function mostrarTabla(data) {
    // $('#tableRes' + data + ' tbody').empty();
    $('#tablescc' + data).empty();
    if (appL.data['isTable' + data] == 1) {
      $('#tablescc' + data).append('\
        <div id="bracketc' + data + '" class="bracketsTable">\
     ');
      var cont = 1;
      var idLvlActual = 0;
      $.each(appL.data['table' + data], function(index, element) {
        if (idLvlActual != element.nivel) {
          idLvlActual = element.nivel;
          $('#bracketc' + data + '').append('<div id="lvlBra' + data + '-' + idLvlActual + '" class="level l' + (idLvlActual - 1) + '">');
        }
        var content = '\
          <div class="gameTeam ">\
              <div class="teamBra f">\
                  <div class="logoTB ' + element.localCode + 'P"></div>\
                  ' + element.localName + '\
              </div>\
              <div class="resultTB">\
                  <div class="subResultTB">\
                      ' + element.resultadoIda + '\
                  </div>\
                  <div class="subResultTB">\
                      ' + element.resultadoVuelta + '\
                  </div>\
              </div>\
              <div class="teamBra">\
                  <div class="logoTB ' + element.visCode + 'P"></div>\
                  ' + element.visName + '\
              </div>\
          </div>\
          <div class="spacelvl' + (idLvlActual - 1) + '"><br></div>\
        ';

        $('#lvlBra' + data + '-' + idLvlActual).append(content);
        cont++;
      });

    } else {
      var cont = 1;
      var grupo = -1;
      $.each(appL.data['table' + data], function(index, element) {
        // si inicia etapa tablas    
        if (grupo == -1 && element.etapa == '1') {
          grupo = 0;
          $('#tablescc' + data).append('\
            <div class="tTable"></div>\
             <table id="tableRes' + data + '-' + grupo + '" class="tableResS">\
                <thead><tr><th class="pos">POS</th><th class="equi">EQUIPOS</th><th class="">PTS</th><th class="">PJ</th><th class="">PG</th><th class="">PE</th><th class="">PP</th><th class="">DG</th></tr>\
                </thead>\
                <tbody></tbody>\
            </table>\
         ');
        } else if (grupo == -1 && element.etapa == '2') {
          grupo = 1;
          $('#tablescc' + data).append('\
        <div class="tTable">Grupo ' + grupo + '</div>\
         <table id="tableRes' + data + '-' + grupo + '" class="tableResS">\
            <thead><tr><th class="pos">POS</th><th class="equi">EQUIPOS</th><th class="">PTS</th><th class="">PJ</th><th class="">PG</th><th class="">PE</th><th class="">PP</th><th class="">DG</th></tr>\
            <tbody></tbody>\
        </table>\
     ');
        }
        if (element.grupo != grupo) {
          grupo = grupo + 1;
          $('#tablescc' + data).append('\
        <div class="tTable secondTable">Grupo ' + grupo + '</div>\
         <table id="tableRes' + data + '-' + grupo + '" class="tableResS">\
            <thead><tr><th class="pos">POS</th><th class="equi">EQUIPOS</th><th class="">PTS</th><th class="">PJ</th><th class="">PG</th><th class="">PE</th><th class="">PP</th><th class="">DG</th></tr>\
            <tbody></tbody>\
        </table>\
     ');
        }
        $('#tableRes' + data + '-' + element.grupo + ' tbody').append('\
           <tr>\
           <td class="c1 p e">' + cont + '</td>\
           <td class="c2 e">\
           <div class="' + element.team.code + 'P logoMargin">\
           </div><p class="nombreTeam">' + element.team.title + '</p>\
           </td>\
           <td class="c1 e">' + element.ptn + '</td>\
           <td class="c2 e">' + element.pj + '</td>\
           <td class="c1 e">' + element.pg + '</td>\
           <td class="c2 e">' + element.pe + '</td>\
           <td class="c1 e">' + element.pp + '</td>\
           <td class="c2 e">' + element.dg + '</td>\
           </tr>\
          ');
        cont++;
      });
    }
  }
  function mostrarTablaRecla() {
    // $('#tableRes' + data + ' tbody').empty();
    $('#tablesReclaCC').empty();
    $('#tablesReclaCC').append('\
          <div class="tTable"></div>\
           <table id="tableRecla" class="tableResS">\
              <thead>\
              <tr>\
                <th class="">POS</th>\
                <th class="">NOMBRE</th>\
                <th class="">PTS</th>\
                <th class="">PJ</th>\
                <th class="">PG</th>\
                <th class="">PE</th>\
                <th class="">PP</th>\
                <th class="">DG</th>\
              </tr>\
              </thead>\
              <tbody></tbody>\
          </table>\
       ');
      var cont=1;
      $.each(appL.data['recla'], function(index, element) {        
        // si inicia etapa tablas
        $('#tableRecla tbody').append('\
           <tr>\
           <td class="c1 p e">' + cont + '</td>\
           <td class="c2 e">\
           <div class="' + element.team.code + 'P logoMargin">\
           </div><p class="nombreTeam">' + element.team.title + '</p>\
           </td>\
           <td class="c1 e">' + element.ptn + '</td>\
           <td class="c2 e">' + element.pj + '</td>\
           <td class="c1 e">' + element.pg + '</td>\
           <td class="c2 e">' + element.pe + '</td>\
           <td class="c1 e">' + element.pp + '</td>\
           <td class="c2 e">' + element.dg + '</td>\
           </tr>\
         ');
        cont++;
      });

  }  
  function mostrarTablaDesc(data) {
    // $('#tableRes' + data + ' tbody').empty();
    $('#tablaDesCC' + data).empty();
    $('#tablaDesCC' + data).append('\
          <div class="tTable"></div>\
           <table id="tableDesc" class="tableResS">\
              <thead>\
              <tr>\
                <th class="">Pos</th>\
                <th class="">Nombre</th>\
                <th class="">Puntos</th>\
                <th class="">Promedio</th>\
              </tr>\
              </thead>\
              <tbody></tbody>\
          </table>\
       ');
      var cont=18;
      $.each(appL.data['desenso'], function(index, element) {        
        // si inicia etapa tablas
        $('#tableDesc tbody').append('\
           <tr>\
                <td class="">'+ cont +'</td>\
                <td class=""><div class="' + element.code + 'P logoMargin">\
                              </div><p class="nombreTeam">' + element.title + '</p></td>\
                <td class="">'+element.ptnDes+'</td>\
                <td class="">'+element.promedio+'</td>\
           </tr>\
           ');
        cont--;
      });
  }

  function mostrarResultados() {
    // $('#tableRes' + data + ' tbody').empty();
    $('#results').empty();
      var cont=-1;
      var idRes='';
      var firts=0;
      $.each(appL.data['resLiga'], function(index, element) { 
        // si inicia etapa tablas
        if(cont!=element.numero){
          if(cont!=-1){
            cont= element.numero;            
            if(firts==1){
              firts=0;
              addResult(cont,'#res-0');   
            }
            else{
              addResult(cont,'');   

            }
            idRes=parseInt(cont);
          }
          else{
            $('#calFDay').html('Fecha '+element.numero);
            $("#backRes").attr("href", "#res-"+(element.numero-1));            
            cont= element.numero;
            firts=1;
          }          
        } 
        $('#results'+idRes).append('\
          <div class="itemListGame">\
              <div class="logLT">\
                <div class="' + element.localCode + 'M left">\
                </div>\
                <div class="nameLT">\
                  '+element.localName+'\
                </div>\
              </div>\
              <div class="infoT">\
                <h3>'+element.fecha+'</h3>\
                <h3>'+element.golesLocal+' - '+element.golesVisitante+'</h3>\
              </div>\
              <div class="logRT">\
                <div class="nameRT">\
                  '+element.visName+'\
                </div>\
                  <div class="' + element.visCode + 'M left ">\
                  </div>\
          </div>\
           ');
      });
  }
  function addResult(number,linkBack){
    back='';
    if(linkBack==''){
      back='#res-'+(number-0+1);
    }
    else{
     back= linkBack;
    }
    $('#res-'+parseInt(number)).remove();
    $('#body').append('<div id="res-'+parseInt(number)+'" data-role="page">\
        <div data-role="panel" id="menuPanel" class="menuLat" data-position="left" data-display="push"></div>\
        <div class="headerPages">\
            <div class="headPage">\
                <a href="#menu">\
                    <div class="icoHome left"></div>\
                </a>\
                <div class="slogan2"></div>\
                <div class="rightMenu">\
                    <div class="icoReload left"></div>\
                    <a href="#menuPanel"><div class="icoMenuP right"></div></a>\
                </div>\
            </div>\
            <div class="tittlePage">\
                    <div class="icoRes"></div>\
                    <p>Resultados</p>\
                </div>\
            <div class="topResult">\
                <a id="backRes" href="#res-'+(parseInt(number)-1)+'"><div class="trianL left"><img src="assets/images/left.png"></div></a>\
                <a href="'+back+'"><div class="trianR right"><img src="assets/images/right.png"></div></a>\
                <p>Fecha  '+number+'</p>\
            </div>\
        <div id="results'+parseInt(number)+'" class=" ">\
    </div>');
  }
  function mostrarCalendario() {
    // $('#tableRes' + data + ' tbody').empty();
    $('#calc').empty();
    var cont=-1;
    var idRes='';
    var firts=0;
    var cont2=1;
    $.each(appL.data['calLiga'], function(index, element) { 
      if(cont!=element.numero){        
          if(cont!=-1){
            cont2++;
            cont = element.numero;   
            if(firts==1){
              firts=0;
              addCalc(cont,cont2,'#cal');   
            }
            else{
              addCalc(cont,cont2,'');   

            }
            idRes =parseInt(cont);
          }
          else{
            $('#restFDay').html('Fecha '+element.numero);
            $("#linkCal").attr("href", "#calc-"+(parseInt(element.numero)+1));            
            cont= element.numero;
            firts=1;
          }          
        }   
        // si inicia etapa tablas 
        $('#calc'+idRes).append('\
          <div class="itemListGame">\
              <div class="logLT">\
                <div class="' + element.localCode + 'M left">\
                </div>\
                <div class="nameLT">\
                  '+element.localName+'\
                </div>\
              </div>\
              <div class="infoT">\
              <h3>'+element.fecha+' '+element.hora+'</h3>\
              <h3 class="estadio">'+element.estadio+'</h3>\
              </div>\
              <div class="logRT">\
                <div class="nameRT">\
                  '+element.visName+'\
                </div>\
                <div class="' + element.visCode + 'M left ">\
                </div>\
          </div>\
           ');
      });
  }
  function addCalc(number,cont,linkBack){
    back='';
    if(linkBack==''){
      back='#calc-'+(number-1);
    }
    else{
     back= linkBack;
    }
    $('#calc-'+parseInt(number)).remove();
    $('#body').append('<div id="calc-'+parseInt(number)+'" data-role="page">\
        <div data-role="panel" id="menuPansel" class="menuLat" data-position="left" data-display="push"></div>\
        <div class="headerPages">\
            <div class="headPage">\
                <a href="#menu">\
                    <div class="icoHome left"></div>\
                </a>\
                <div class="slogan2"></div>\
                <div class="rightMenu">\
                    <div class="icoReload left"></div>\
                    <a href="#menuPanel"><div class="icoMenuP right"></div></a>\
                </div>\
            </div>\
            <div class="tittlePage">\
                    <div class="icoCal"></div>\
                    <p>Calendario</p>\
                </div>\
            <div class="topResult">\
                <a id="backRes" href="'+back+'"><div class="trianL left"><img src="assets/images/left.png"></div></a>\
                <a href="#calc-'+(parseInt(number)+1)+'"><div class="trianR right"><img src="assets/images/right.png"></div></a>\
                <p>Fecha  '+number+'</p>\
            </div>\
        </div>\
        <div id="calc'+parseInt(number)+'" class="results">\
        </div>\
    </div>');
  }
  function mostrarTablaGole(data) {
    // $('#tableRes' + data + ' tbody').empty();
    $('#tablesGolCC').empty();    
    $('#tablesGolCC' + data).append('\
          <div class="tTable"></div>\
           <table id="tableGoles" class="tableResS">\
              <thead>\
              <tr>\
                <th class="">Equipo</th>\
                <th class="">Nombre</th>\
                <th class="">Goles</th>\
              </tr>\
              </thead>\
              <tbody></tbody>\
          </table>\
       ');
      $.each(appL.data['goleadores'], function(index, element) {
        // si inicia etapa tablas    
                
        $('#tableGoles tbody').append('\
           <tr>\
                <td class=""><div class="'+element.equipo+'M"></div></td>\
                <td class="">'+element.nombre+'</td>\
                <td class="">'+element.goles+'</td>\
           </tr>\
           ');
      });
  }

  function mostrarBracket() {
    $('#bracket').empty();
    var cont = 1;
    var idLvlActual = 0;
    var startert=false;
    $.each(appL.data['bracket'], function(index, element) {
      if (idLvlActual != element.nivel) {
        idLvlActual = element.nivel;
        $('#bracket').append('<div id="lvlBra' + idLvlActual + '"class="level l' + (idLvlActual - 1) + '">');
      }
      var content = '\
          <div class="gameTeam ">\
              <div class="teamBra f">\
                  <div class="logoTB ' + element.localCode + 'P"></div>\
                  ' + element.localName + '\
              </div>\
              <div class="resultTB">\
                  ' + element.resultadoIda + ' (' + element.resultadoVuelta + ')\
              </div>\
              <div class="teamBra">\
                  <div class="logoTB ' + element.visCode + 'P"></div>\
                  ' + element.visName + '\
              </div>\
          </div>\
          <div class="spacelvl' + (idLvlActual - 1) + '"><br></div>\
        ';

      $('#lvlBra' + idLvlActual).append(content);
      cont++;
    });
  }

  function mostrarEquipos() {    
    $('#plantel').empty();
    var cont = 1;
    $.each(appL.data['teams'], function(index, element) {
      $('#plantel').append('<a target="_blank" href="'+element.linkApp+'"><div class="equipoList">\
        <div class="teamItemList">\
          <div class="logo">\
              <div class="'+element.code+'"></div>\
          </div>\
          <div class="infoTeamList">\
                <h2>'+element.title+'</h2>\
                <h3>'+element.ubicacion+'</h3>\
                <h3>'+element.estadio+'</h3>\
                <h3>Descarga la aplicación aquí.</h3>\
          </div>\
          <div class="linkDown">\
            <div class="icoDownTeam">\
          </div>\
          </div>\
        </div></a>');
      cont++;
    });
  }

  function mostrarPanelMin() {    
    $('#liskTeamMin').empty();
    $.each(appL.data['teams'], function(index, element) {
      $('#liskTeamMin').append('\
        <a href="#'+element.code+'MIN"><div class="icoTeamMin"><div class="'+element.code+'M"></div></div></a>\
        ');
      addMinamin(element);
    });
  }
  function addMinamin(element){
    var code ='<div id="'+element.code+'MIN" data-role="page">\
      <div data-role="panel" id="menuPanel" class="menuLat" data-position="left" data-display="push"></div>\
      <div class="headerPages">\
          <div class="headPage">\
              <a href="#minamin">\
              <div class="backLinkMin"><img src="assets/images/left.png"></div>\
              </a>\
              <div class="slogan2"></div>\
              <div class="rightMenu">\
                  <div class="icoReload left"></div>\
                  <a href="#menuPanel"><div class="icoMenuP right"></div></a>\
              </div>\
          </div>\
          <div class="tittlePage">\
              <div class="icoMin"></div>\
              <p>MIN A MIN</p>\
          </div>\
          <div id="'+element.code+'pMin" class="lastP">\
              <div id="localT" class="team left">\
                  <div class="COL01 ico"></div>\
                  <h2>NACIONAL</h2>\
              </div>\
              <div class="resultadoLP">\
                  <h1>Fecha 01</h1>\
                  <h5>2 - 5</h5>\
                  <h3>Atanasio Girardot</h3>\
                  <h4>14/07/2013</h4>\
              </div>\
              <div id="visT"class="team right">\
                  <div class="COL03 ico"></div>\
                  <h2>SANTA FE</h2>\
              </div>\
          </div>\
          <div id="lastResults">\
              <div class="icoDownR left k1"></div>\
              EN JUEGO\
              <div class="icoDownR right k2"></div>\
          </div>\
      </div>\
      <div id="'+element.code+'minInfo" class="cMinTeam">\
      </div>\
  </div>';
  $('#body').append(code);
  mostrarMinAmin(element, element.code);

  }
  function mostrarMinAmin(element, code) {    
    var data=element.minamin
    if (typeof data.titulo == 'undefined') {
      data.titulo='';
      data.golesLocal='';
      data.golesVisitante='';
      data.fecha='';
      data.titulo='';
      data.titulo='';
      data.localName= "-";
      data.visName= "-";
    }
    $('#'+element.code+'pMin').empty();
    $('#'+element.code+'minInfo').empty();
    $('#'+element.code+'pMin').append('\
      <div id="localT" class="team left">\
      <div class="' + data['localCode'] + ' ico"></div>\
      <h2>' + data.localName + '</h2>\
      </div>\
      <div class="resultadoLP">\
      <h1>' + data.titulo + '</h1>\
      <h5>' + data.golesLocal + ' - ' + data.golesVisitante + '</h5>\
      <h3>' + data.estadio + '</h3>\
      <h4>' + data.fecha + '</h4>\
      </div>\
      <div id="visT"class="team right">\
      <div class="' + data['visCode'] + ' ico"></div>\
      <h2>' + data.visName + '</h2>\
      </div>\
    ');
    appL.codeActual=element.code;
    $.each(data.eventos, function(index, element) {
      var ico = '';
      if (element.evento == 0) ico = "cancha";
      else if (element.evento == 1) ico = 'relog';
      else if (element.evento == 2) ico = 'tarjeta';
      else if (element.evento == 3) ico = 'balon';
      else if (element.evento == 4) ico = 'pito';
      else if (element.evento == 5) ico = 'bandera';


      $('#'+appL.codeActual+'minInfo').append('\
            <div class="ccMin">\
                <div class="dataMin">\
                    <h2>Minuto</h2>\
                    <h3>' + element.minuto + '</h3>\
                </div>\
                <div class="infoMin">\
                    <div class="' + ico + ' icoTT"></div>\
                    <p>\
                        ' + element.titulo + '\
                    </p>\
                </div>\
            </div>');
    });
  }

  function mostrarNoticias() {
    $.each(appL.data['iIMG'], function(index, element) {
      var url = appL.base + element['imagen'];
      $('#loadNotiCC').append("<div class='m-item'><img src='" + url + "'></div>");
    });
    $.each(appL.data['noticias'], function(index, element) {
      $('#news').append("<div class='cnoti'><div class='imgc'><div class='imgNoticia'></div><p>" + element.fecha + "</p></div><div class='textnoti'><h3>" + element.title + "</h3><p>" + element.descripcion + "</p></div></div>");
    });
    $('.m-carousel').carousel({
      dragRadius: 10,
      moveRadius: 20,
      classPrefix: undefined,
      classNames: {
        outer: "carousel",
        inner: "carousel-inner",
        item: "item",
        center: "center",
        touch: "has-touch",
        dragging: "dragging",
        active: "active"
      }
    });
    // self.setInterval(function(){moveCarousel()},1000);
  }

  function moveCarousel() {
    $('.m-carousel').carousel('next');
    self.setInterval(function() {
      moveCarousel()
    }, 1000);
  }

})(jQuery);
