Translation.getLang(); //load and initialized Transaltion app see locale.js

function isEmpty(obj) {
    for(var prop in obj) {
        if(obj.hasOwnProperty(prop))
            return false;
    }
    return true;
}

var lightApp = {
	'brightness': 0,
	'menuLeft': false,
	'menuRight': false,
	init : function() {
		$('#text1').html(Translation.echo('text1'));
		$('#text2').html(Translation.echo('text2'));
		
	},
	setBrightness: function( brightness ) {
	
		brightness = brightness.toFixed(2);	
		if (brightness <= 0) brightness =0;
		if (brightness >= 1) brightness =1;
		this.brightness = parseFloat(brightness);
		
		backgroundColor = this.float2color(this.brightness);
		colorText = this.float2color(1 - this.brightness);	
	
		$('#viewState0 .content').css('background-color',backgroundColor);
		$('#viewState0 .content').css('color',colorText);

	
	},
	float2color: function( percentage ) {
		var color_part_dec = 255 * percentage;
		var color_part_hex = Number(parseInt( color_part_dec , 10)).toString(16);
		return "#" + color_part_hex + color_part_hex + color_part_hex;
	}
}
		
$(document).ready(function(){
	lightApp.init();

	$('#viewPort').hammer().on("doubletap", ".content", function(event) {
		event.preventDefault();
		if (lightApp.brightness < 1) {
			lightApp.setBrightness(1);
			var t=setTimeout(function(){$('#helpBox').fadeOut('slow');},1500);
		} else {
			lightApp.setBrightness(0);
			var t=setTimeout(function(){if (lightApp.brightness == 0) $('#helpBox').fadeIn('slow');},5000);
		}
		
	});
		
	$('#viewState0').hammer().on("dragup", ".content", function(event) {
		event.preventDefault();
		brightness =lightApp.brightness +0.02;
		lightApp.setBrightness(brightness);
		if (brightness == 1) var t=setTimeout(function(){$('#helpBox').fadeOut('slow');},1500);
	});	

	$('#viewState0').hammer().on("dragdown", ".content", function(event) {
		event.preventDefault();
		brightness =lightApp.brightness -0.02;
		lightApp.setBrightness(brightness);
		if (brightness == 0) var t=setTimeout(function(){$('#helpBox').fadeIn('slow');},5000);
	});	
	
	
	$('#btn_light').click(function() {
		if (lightApp.brightness < 1) {
			lightApp.setBrightness(1);
			var t=setTimeout(function(){$('#helpBox').fadeOut('slow');},1500);
		} else {
			lightApp.setBrightness(0);
			var t=setTimeout(function(){if (lightApp.brightness == 0) $('#helpBox').fadeIn('slow');},5000);
		}
	});
	
});