
//TOAST
 (function($) {
  $.fn.ambiance = function(options) {

    var defaults = {
      title: "",
      message: "",
      type: "default",
      permanent: false,
      timeout: 2,
      fade: true,
     
    };

    var options = $.extend(defaults, options);
    var note_area = $("#ambiance-notification");

    // Construct the new notification.
    var note = $(window.document.createElement('div'))
                .addClass("ambiance")
                .addClass("ambiance-" + options['type']);

    note.css({width: options['width']});


    // Deal with adding the close feature or not.
    if (!options['permanent']) {
      note.prepend($(window.document.createElement('a'))
                    .addClass("ambiance-close")
                    .attr("href", "#_")
                    .html("&times;"));
    }

    // Deal with adding the title if given.
    if (options['title'] !== "") {
      note.append($(window.document.createElement('div'))
                   .addClass("ambiance-title")
                   .append(options['title']));
    }

    // Append the message (this can also be HTML or even an object!).
    note.append(options['message']);

    // Add the notification to the notification area.
    note_area.append(note);

    // Deal with non-permanent note.
    if (!options['permanent']) {
      if (options['timeout'] != 0) {
        if (options['fade']) {
          note.delay(options['timeout'] * 1000).fadeOut('slow');
          note.queue(function() { $(this).remove(); });
        } else {
          note.delay(options['timeout'] * 1000)
              .queue(function() { $(this).remove(); });
        }
      }
    }
  };
  $.ambiance = $.fn.ambiance; // Rename for easier calling.
})(jQuery);

jQuery(document).ready(function() {
  // Deal with adding the notification area to the page.
  if (jQuery("#ambiance-notification").length == 0) {
    var note_area = jQuery(window.document.createElement('div'))
                     .attr("id", "ambiance-notification");
    jQuery('body').append(note_area);
  }
});

// Deal with close event on a note.
jQuery(document).on("click", ".ambiance-close", function () {
  jQuery(this).parent().remove();
  return false;
});



//CRUD
var listaProduto = JSON.parse(localStorage.getItem('tbProduto') || '[]');
var indexSelecionado = -1;

function exibirLista(){
	//Monta o html (desde o cabeçalho) e exibe em uma table (tablelistaProduto) definida no nosso código html.
	var html = '';
	html += '<tr><th>Item</th><th>Quantidade</th><th>Excluir</th></tr>';
	$.each(listaProduto, function(key, value){
		var produto = JSON.parse(value);
		html += '<tr>';
		html += '<td>'+produto.item+'</td><td>'+produto.qtd+'</td>';
		html += '<td><img src="js/delete.png" onclick="apagarProduto('+key+')" /></label></td>';
		html += '</tr>';
	});
	$('#tabelaListaProdutos').html(html);
}

function adicionarProduto() {
	//Transforma os dados do formulario em JSON
	var produto = JSON.stringify({item: $("#item").val(), qtd: $("#qtd").val()});
	//Adiciona no array global listaProduto
	listaProduto.push(produto);
	//Atualiza o localStorage 'tbProdto'
	localStorage.setItem('tbProduto', JSON.stringify(listaProduto));
	//Termina chamando a função que exibe os items na lista
    exibirLista();
	//Limpa os campos e exibe mensagem de sucesso
	$("#item").val("");$("#qtd").val("");

}

function apagarProduto(index){
	//Utiliza a função splice para remover o item selecionado (index) do array
	listaProduto.splice(index, 1);
	//Atualiza o localStorage 'tbProdto' com o registro excluído
	localStorage.setItem("tbProduto", JSON.stringify(listaProduto));
	//Termina chamando a função que exibe os items na lista
	exibirLista();
}

function apagarTudo(){
 
  decisao = confirm("Você apagará todos os itens da lista. Deseja realmente fazer isso?");
    if (decisao){
    //Remove completamente o item 'tbProdto' do localStorage, apagando todas as músicas mesmo que a página seja reiniciada
    localStorage.removeItem('tbProduto');
    //Atualiza a variável global listaProduto que estará vazia
    listaProduto = JSON.parse(localStorage.getItem('tbProduto') || '[]');
    //Termina chamando a função que exibe os items na lista
    exibirLista();

  } else {
    
}

	
	
}

function enviarForm(){
	var inputItem = document.getElementById("item").value;
	var inputQtd = document.getElementById("qtd").value;

	if(inputItem == "" || inputQtd == ""){
		$.ambiance({message: "Campo vazio."});

  //$.ambiance({message: "Campo vazio."});

	}else{
	 adicionarProduto();
	}
 };

