function loadArticles(url, mainList, page){
	ga_storage._trackPageview(page, 'ArticlesList');
	$.ui.showMask("Loading...");
	$.getJSON(url,
	    {'foo':'bar'},
	    function(data){
	    	var list = "";
	        $.each(data.posts, 
	            function(i, post){
					list += "<li class=\"divider\"><h3>" + post.title + " by <strong>" + post.author.name + "</strong></li>";
	                list += "<li><div class='grid' onclick=goToSingleArticle(" + post.id + ") id='" + post.id + "'>";
	                try{
	                	list += "<img src='" + post.thumbnail_images.thumbnail.url + "' class='floatLeft' />";
	                } catch(err){

	                }
	                list += "" + post.excerpt + "";
	                list += "<div></li>";

	                window.localStorage.setItem(post.id,  JSON.stringify(post));
	            }
	        );
	        $(mainList).html( list );
	        $.ui.hideMask()
	        $.ui.unblockUI()
	    }
	);
}

function cleanUpArticles(){
	$(".articlesList").empty();
}

function articlesPanel(){
	loadArticles('http://www.livegaelic.com/?json=1&callback=?', ".articlesList", "Articles");
}

function featuresPanel(){
	loadArticles('http://www.livegaelic.com/category/features/?json=1&callback=?', ".articlesList", "Features");
}

function craicPanel(){
	loadArticles('http://www.livegaelic.com/category/craic/?json=1&callback=?', ".articlesList", "Craic");
}

function newsPanel(){
	loadArticles('http://www.livegaelic.com/category/news/?json=1&callback=?', ".articlesList", "News");
}

function properPunterPanel(){
	loadArticles('http://www.livegaelic.com/category/features/the-proper-punter/?json=1&callback=?', ".articlesList", "Proper Punter");
}

function bestOfPanel(){
	loadArticles('http://www.livegaelic.com/category/features/best-of/?json=1&callback=?', ".articlesList", "Best Of");
}

function goToSingleArticle(id){
	window.localStorage.setItem("articleId",  id);	
	singleArticle();
	$.ui.loadContent("#showArticle",true,true,"slide");
}

function singleArticle(){
	id = window.localStorage.getItem("articleId");	
	var post = JSON.parse(window.localStorage.getItem(id)) || [];
	ga_storage._trackPageview('/index#article' + post.title, post.title);
	var html = "";
	if(post.content.indexOf("//www.youtube.com") !== -1){
		html = "<div>" + post.content.replace("//www.youtube", "http://www.youtube", "g") + "</div>";
	} else {
		html = "<div>" + replaceAll("<a", "<p", post.content) + "</div>";
	}
	$("#singleArticle").html(html);	
}

function replaceAll(find, replace, str) {
  return str.replace(new RegExp(find, 'g'), replace);
}