function serverError(){
	//navigator.splashscreen.show();
	if(navigator.connection.type === Connection.NONE){
		$.ui.loadContent("#error",true,true,"pop");
		return "No Internet Connection Detected. Please Check Your Settings";
	} else {
		$.ui.loadContent("#error",true,true,"pop");
		return "Server Error. Please try again later";
	}
}

function updateMainList(){
	ga_storage._trackPageview('Match List', 'Match List');
	$.ui.showMask("Loading...");
	$.jsonP({
	    url: BaseUrl + '/api/v2/users/246.json?callback=?',
	    success:function(data){
	    	var list="";  
	        $.each(data.results, 
	            function(i, field){
					var date = new Date(i)
                    var showDate = date.getDay() + "/" + date.getMonth() + "/" + date.getFullYear()
                    list += "<li class=\"divider\"><h3>" + i + "</h3></li>"
	                for(i=0; i<field.length; i++){
	                   matchId = field[i].id
	                   var status = field[i].finished ? "Full Time" : "Latest"
	                   var match = field[i].team1 + " " + field[i].score1 + " : " + field[i].score2 + " " + field[i].team2
	                   list += "<li>" + match + "</li>"
	                }
	            }
	        );
	        $("#mainList").html( list );
	        $.ui.hideMask()
	    },
	    error:function(){
	        serverError();
	        $.ui.hideMask()
	    }
	});
}

var myScroller;
$.ui.ready(function () {
    myScroller = $("#main2").scroller(); //Fetch the scroller from cache
    myScroller.addPullToRefresh();
    $.bind(myScroller, 'scrollstart', function () {
        this.setRefreshContent("Updating list...");
    });
    $.bind(myScroller, "refresh-trigger", function () {
    	updateMainList();
    });
    var hideClose;
    $.bind(myScroller, "refresh-release", function () {
        var that = this;
        //this.setRefreshContent("New content...");
        clearTimeout(hideClose);
        hideClose = setTimeout(function () {
            that.hideRefresh();
        }, 500);
        return false; //tells it to not auto-cancel the refresh
    });
    myScroller.enable();
    $("#main2").css("overflow", "auto");
});
