function trackerPanel(){
	ga_storage._trackPageview('Tracker', 'Tracker Page');
	$.ui.showMask("Loading...");
	$.jsonP({
	    url: BaseUrl + '/api/v2/trackers?callback=?',
	    success:function(data){
	        var list="";  
	        $.each(data.results, 
	            function(i, field){
	                
	                for(i=0; i<field.length; i++){
	                   var date = new Date(field[i].created_at);
	                   var description = field[i].description;
	                   var match = field[i].match === undefined ? "" : field[i].match;
	                   list += "<li class='divider'><h3>" + date.getDate() + "/" + date.getMonth() + " " + date.getHours() + ":" + date.getMinutes() + " " + match + "</h3></li>";
	                   list += "<li>" + description + "</li>";
	                }
	            }
	        );
	        $("#trackerList").html( list );
	        $.ui.hideMask()
	    },
	    error:function(){
	        serverError();
	        $.ui.hideMask()
	    }
	});
}

var myScroller;
$.ui.ready(function () {
    myScroller = $("#tracker").scroller(); //Fetch the scroller from cache
    myScroller.addPullToRefresh();
    $.bind(myScroller, 'scrollstart', function () {
        this.setRefreshContent("Updating tracker ...");
    });
    $.bind(myScroller, "refresh-trigger", function () {
    	trackerPanel();
    });
    var hideClose;
    $.bind(myScroller, "refresh-release", function () {
        var that = this;
        //this.setRefreshContent("New content...");
        clearTimeout(hideClose);
        hideClose = setTimeout(function () {
            that.hideRefresh();
        }, 500);
        return false; //tells it to not auto-cancel the refresh
    });

    $.bind(myScroller, "refresh-cancel", function () {
        clearTimeout(hideClose);
    });
    myScroller.enable();
    $("#tracker").css("overflow", "auto");
});

