function reset() {
	$('#loan_input').val("");
	$('#interest_input').val("");
	$('#result_panel').html("Result");
}

function calculateLoan() {
	var loan = $('#loan_input').val();
	var interest = $('#interest_input').val();
	var term = $('#term_select').val();
	var freq = $('#freq_select').val();

	if(loan == null || loan == "") {
		return;
	}

	if(interest == null || interest == "") {
		return;
	}

	if(term == null || term == "") {
		return;
	}

	if(freq == null || freq == "") {
		return;
	}

	loan = parseFloat(loan);
	interest = parseFloat(interest);
	term = parseFloat(term);
	freq = parseFloat(freq);
	numOfPayments = term / freq;

	rate = parseFloat(interest / 100) / 12 * freq;

	var paymentPerPeriod = ((rate + rate / (Math.pow((1 + rate), numOfPayments) - 1) )) * loan;

	$('#result_panel').html(paymentPerPeriod.toFixed(2));
	$('#result_unit').html($('#freq_select option:selected').text());
}

$(function() {

	$('#loan_input').keyup(function() {
		calculateLoan();
	});
	
	$('#interest_input').keyup(function() {
		calculateLoan();
	});

	$('#term_select').change(function() {
		calculateLoan();
	});

	$('#freq_select').change(function() {
		calculateLoan();
	});
	
	$('#action_clear').click(function() {
		reset();
	});
});