var App = {
    zoom: 3,
    map: {},
    template: function($id, $element, $name) {
        return '<li data-id_rep="' + $id + '" data-id_element="' + $element + '">\
                    ' + $name + '\
                </li>';
    },
    apply_reps: function() {
        jQuery('#loading').show();
        var $Layer_Marker = new OpenLayers.Layer.Markers("Markers");
        jQuery.getJSON("reps.json", function($json) {
            var $items = [];
            jQuery.each($json, function($key, $rep) {
                var $geolocation = new OpenLayers.LonLat($rep.lon, $rep.lat).transform(new OpenLayers.Projection("EPSG:4326"), App.map.getProjectionObject());
                var $Marker = new OpenLayers.Marker($geolocation);
                $Marker.icon.url = "img/marker_rep.png"
                $Layer_Marker.addMarker($Marker);
                jQuery($Marker.events.element).data('name', $rep.fullname).on('touchstart click', this, function() {
                    var $name = jQuery(this).data('name');
                    App.map.addPopup(new OpenLayers.Popup.FramedCloud("featurePopup",
                            $geolocation,
                            new OpenLayers.Size(100, 100),
                            $name,
                            null, true, function() {
                                this.destroy();
                            }), true);
                });
                $items.push(App.template($key, $Marker.events.element.id, $rep.fullname));
            });
            jQuery("<ul/>", {
                html: $items.join("")
            }).appendTo("main menu").find('li').on('touchstart', this, function() {
                jQuery('main menu').removeClass('show');
                var $id_element = jQuery(this).data('id_element');
                jQuery('#'+$id_element).click();
            });
            App.map.addLayer($Layer_Marker);
            jQuery('#loading').hide();
        });
    },
    init: function() {
        App.map = new OpenLayers.Map({
            div: "map",
            layers: [new OpenLayers.Layer.OSM()],
            center: new OpenLayers.LonLat(-51.22067189, -30.06074719).transform("EPSG:4326", "EPSG:900913"),
            zoom: App.zoom
        });
        App.apply_reps();
    }
};
jQuery(document).ready(function() {
    OpenLayers.ImgPath = "img/";
    App.init();
    jQuery('main header button').on('touchstart', this, function() {
        jQuery('main menu').toggleClass('show');
    });
});