/* Timer para el videjuego Legue of legends
 * Author: Jose Ordonez - alias reston.
 * 26-08-2013
 * Venezuela - Zulia
 */
var intervalBaron = null;
var intervalDragon = null;
var intervalBlueAmigo = null;
var intervalBlueEnemigo = null;
var intervalRedAmigo = null;
var intervalRedEnemigo = null;
var audio = document.getElementById('audioSound');
var lock = window.navigator.requestWakeLock('screen');
var hidden, visibilityChange;
if (typeof document.hidden !== "undefined") { // Opera 12.10 and Firefox 18 and later support 
  hidden = "hidden";
  visibilityChange = "visibilitychange";
} else if (typeof document.mozHidden !== "undefined") {
  hidden = "mozHidden";
  visibilityChange = "mozvisibilitychange";
} else if (typeof document.msHidden !== "undefined") {
  hidden = "msHidden";
  visibilityChange = "msvisibilitychange";
} else if (typeof document.webkitHidden !== "undefined") {
  hidden = "webkitHidden";
  visibilityChange = "webkitvisibilitychange";
}
document.addEventListener(visibilityChange, handleVisibilityChange, false);

//al cerrar pagina quitar lock
window.addEventListener('unload', function () {
    lock.unlock();
});
//manejando la visibilidad de la App.
function handleVisibilityChange() {
  if (document[hidden]) {
    if(lock){
        lock.unlock();
        lock = null;
    }
  } else {
    if (!lock) {
        lock = window.navigator.requestWakeLock('screen');
    }
  }
}

function countdown(element, min, sec) {
        var interval;
        var flag;
        var seconds = sec;
        var minutes = min;
        var el = document.getElementById(element);
        if( element == 'TimerBaron'){
            interval = intervalBaron;
        }
        else if (element == 'TimerDragon') {
            interval = intervalDragon;
        }
        else if(element == 'TimerBlueAmigo'){
            interval = intervalBlueAmigo;
        }
        else if (element == 'TimerBlueEnemigo') {
            interval = intervalBlueEnemigo;
        }
        else if (element == 'TimerRedAmigo') {
            interval = intervalRedAmigo;
        }
        else if (element == 'TimerRedEnemigo') {
            interval = intervalRedEnemigo;
        }
        if(interval){ //Limpia los intervalos que existan
            clearInterval(interval);
            el.textContent = "";
            RemoveClassFromElement(el.parentNode, "grayscale");
            interval = null;
        }else{
            AddClassToElement(el.parentNode, "grayscale");
            //Inicio de los intervalos.
            interval = setInterval(function() {
            var minute_text = '00';
            if(seconds === 0) {
                if(minutes === 0) {
                    el.textContent = "";
                    clearInterval(interval);
                    //Establecer el sonido a reproducir y reproducirlo.
                    if (el.parentNode.id === 'blueEnemigo' || el.parentNode.id === 'blueAmigo') {
                        audio.src = "sound/blue.ogg";
                        audio.play();
                    }else if (el.parentNode.id === 'redEnemigo' || el.parentNode.id === 'redAmigo'){
                        audio.src = "sound/red.ogg";
                        audio.play();
                    }else{
                        audio.src = "sound/"+el.parentNode.id+".ogg";
                        audio.play();
                    }
                    RemoveClassFromElement(el.parentNode, "grayscale");
                    //faltaría colocar el palpitar del cuadro siguientes versiones (?)
                    return;
                } else {
                    minutes--;
                    seconds = 60;
                }
            }
            if(minutes > 0) {
                minute_text = minutes;
            }
            if (seconds < 10) {
                seconds = '0'+seconds;
            }
            el.textContent = minute_text+':'+seconds;
            seconds--;
            }, 1000);
        }
        if( element == 'TimerBaron'){
            intervalBaron = interval;
        }
        else if (element == 'TimerDragon') {
            intervalDragon = interval;
        }
        else if(element == 'TimerBlueAmigo'){
            intervalBlueAmigo = interval;
        }
        else if (element == 'TimerBlueEnemigo') {
            intervalBlueEnemigo = interval;
        }
        else if (element == 'TimerRedAmigo') {
            intervalRedAmigo = interval;
        }
        else if (element == 'TimerRedEnemigo') {
            intervalRedEnemigo = interval;
        }
    }
//jQuery add class
function AddClassToElement(elem,value){
 var rspaces = /\s+/;
 var classNames = (value || "").split( rspaces );
 var className = " " + elem.className + " ",
 setClass = elem.className;
 for ( var c = 0, cl = classNames.length; c < cl; c++ ) {
  if ( className.indexOf( " " + classNames[c] + " " ) < 0 ) {
   setClass += " " + classNames[c];
  }
 }
 elem.className = setClass.replace(/^\s+|\s+$/g,'');//trim
}

//jQuery remove class
function RemoveClassFromElement(elem,value){
 var rspaces = /\s+/;
 var rclass = /[\n\t]/g;
 var classNames = (value || "").split( rspaces );
 var className = (" " + elem.className + " ").replace(rclass, " ");
 for ( var c = 0, cl = classNames.length; c < cl; c++ ) {
  className = className.replace(" " + classNames[c] + " ", " ");
 }
 elem.className = className.replace(/^\s+|\s+$/g,'');//trim
}

