ig.module(
	'game.entities.helicopter'
)
.requires(
	'impact.entity',
    'game.entities.particle'
)
.defines(function(){
	
    EntityHelicopter = ig.Entity.extend({
        name: 'Helicopter',                 //Each helicopter will be given a unique name when spawned so that we can identify it when dropping bombs
        size: {x: 8, y: 4},
        halfWidth: 4,
        halfHeight: 2,
        offset: {x: 0, y: 0},
        maxVel: {x: 40, y: 20},
        gravityFactor : 0,
        ydir : 1,
        yspeed : 10,

        type: ig.Entity.TYPE.B, 					// Evil enemy group

        health: 100,
        speed: 20,
        flip: false,
        dying: false,
        bombDropped: false,
        bombTimer: null,

        animSheet: new ig.AnimationSheet( 'media/helicopter.png', 8, 4 ),
        soundHelicopter: new ig.Sound('media/soundHelicopter.ogg'),
        soundBombDrop: new ig.Sound('media/soundBombDrop.ogg'),


        init: function( x, y, settings ) {
            this.parent( x, y, settings );
            this.addAnim( 'fly', 0.01, [0,1] );
            this.addAnim( 'dying', 0.01, [2,3] );
            this.speed = this.speed + Math.floor(Math.random()*40);

            //Start with a random x, y position and direction
            this.pos.x = ig.game.width;
            this.pos.y = Math.random() * 40;

            var direction = (Math.random() * 2 - 1);
            if (direction > 0) {
                this.pos.x = -10;
                this.flip = !this.flip;
                this.currentAnim.flip.x = this.flip;
            }


            //Start with a random y speed
            this.yspeed = Math.random()*20;

            this.bombTimer = new ig.Timer();

            this.soundHelicopter.play();
        },


        update: function() {

            if (!this.dying) {
                var xdir = this.flip ? -1 : 1;
                this.vel.x = this.speed * xdir;

                //Random change y movement
                var change = Math.random()*500
                if (change < 10)
                {
                    this.ydir = -this.ydir;
                    this.yspeed = Math.random()*20;
                }

                this.vel.y = this.yspeed * this.ydir;

                //Keep within bounds of sky
                if ((this.pos.x > ig.game.width +20) ||
                    (this.pos.x < 0 - 20)) {
                        this.vel.x = -this.vel.x;
                        this.flip = !this.flip;
                        this.currentAnim.flip.x = this.flip;
                }

                if (this.pos.y > 40) this.pos.y = 40;
                if (this.pos.y < -5) this.pos.y = -5;
            }
            else {
                //Helicopter is dying
                this.gravityFactor = 0.1;
                this.currentAnim.flip.x = this.flip;
                if (this.pos.y > 50) {
                    ig.game.soundSplash.play();
                    for (var i = 0; i < 10; i++) {
                        ig.game.spawnEntity(EntityWaveParticle, this.pos.x+this.halfWidth, this.pos.y+this.halfHeight, { vel: {x: -30, y: -20}, restrictY : true });
                    }
                    this.kill();
                    ig.game.numHelicopters -= 1;
                }
            }


            //If helicopter is over player then drop a bomb
            var player = ig.game.getEntityByName('Player');
            if (player) {
                if (!this.dying && !this.bombDropped &&
                     (player.pos.x + 5) < this.pos.x &&
                     this.pos.x < (player.pos.x + player.size.x-5)  &&
                     this.bombTimer.delta() > 1
                    )  {
                    this.soundBombDrop.play();
                    ig.game.spawnEntity(EntityBomb, this.pos.x+4, this.pos.y+4, {helicopterName: this.name});
                    this.bombDropped = true;
                    this.bombTimer.set(0);
                }
            }


            this.parent();
        }

    });


    EntityBomb = ig.Entity.extend({
        name: 'Bomb',
        size: { x: 2, y: 2 },
        offset: { x: 0, y: 0 },
        vel: { x: 0, y: 10 },
        gravityFactor: 0.05,
        target: { x: 0, y: 0 },
        helicopterName: "",                             // Name of helicopter that dropped this bomb

        type: ig.Entity.TYPE.NONE,
        checkAgainst: ig.Entity.TYPE.A, 				// Check for collisions against the player
        collides: ig.Entity.COLLIDES.PASSIVE,
        particleTimer: null,

        animSheet: new ig.AnimationSheet('media/bomb.png', 2, 2),
        soundBombHit: new ig.Sound('media/soundBombHit.ogg'),

        init: function (x, y, settings) {
            this.parent(x, y, settings);
            this.addAnim('idle', 0.05, [0,1,2,3]);
        },


        update: function () {
            this.parent();

            //Kill bomb if it hits water
            if (this.pos.y > 50) {
                this.killMe();
                ig.game.spawnEntity(EntityWaveParticle, this.pos.x, this.pos.y, { vel: {x: 10, y: -20}, restrictY : true });
                ig.game.spawnEntity(EntityWaveParticle, this.pos.x, this.pos.y, { vel: {x: 10, y: -20}, restrictY : true });
            }
        },

        killMe: function() {
            //Reset the flag in the helicopter that dropped this bomb to indicate it can drop another bomb
            var helicopter = ig.game.getEntityByName(this.helicopterName);
            if (helicopter)
                helicopter.bombDropped = false;
            this.kill();
        },

        check: function (other) {
            if (other.name == 'Player') {
                this.soundBombHit.play();
                this.killMe();
                ig.game.spawnEntity(EntityFireParticle, this.pos.x, this.pos.y, { vel: {x: 20, y: -20} });
                ig.game.spawnEntity(EntityFireParticle, this.pos.x, this.pos.y, { vel: {x: 20, y: -20} });
                ig.game.spawnEntity(EntityFireParticle, this.pos.x, this.pos.y, { vel: {x: 20, y: -20} });
                other.health -= 3;
            }
        }

    });


    EntityFireParticle = EntityParticle.extend({
        lifetime: 1,
        fadetime: 1,
        bounciness: 0,
        gravityFactor: 0.1,
        vel: {x: 10, y: 0},
        offset: {x: 0, y: 0},

        type: ig.Entity.TYPE.NONE,

        animSheet: new ig.AnimationSheet( 'media/fireParticle.png', 1, 1 ),

        init: function( x, y, settings ) {
            this.addAnim( 'idle', 0.1, [0, 1, 2] );
            this.parent( x, y, settings );
        }
    });




});