ig.module(
        'game.main'
    )
    .requires(
        'impact.game',
        'impact.font',

        'game.entities.player',
        'game.entities.helicopter',
        'game.entities.submarine'

    )
    .defines(function(){

        var MyGame = ig.Game.extend({

            width:  240,
            height: 160,

            gravity: 300,
            clearColor: null, //'#000000',

            font: new ig.Font( 'media/visitor.font.10.png' ),

            //Sounds
            soundSplash: new ig.Sound('media/soundSplash.ogg'),
            soundMissileHit: new ig.Sound('media/soundMissileHit.ogg'),
            soundAirRaid: new ig.Sound('media/soundAirRaid.ogg'),

            currentScore:    0,
            generalTimer: null,

            //Helicopters
            helicopterTimer: null,
            helicopterDelay: 30,
            helicopterMaxDelay: 30,
            numHelicopters: 0,

            //Submarines
            subTimer: null,
            subDelay: 10,
            subMaxDelay: 10,
            numSubs: 0,

            //Current game state - Main menu , help, game etc
            gameState: "StartScreen",


            //***********************
            // Initialise stuff
            //***********************
            init: function () {

                //Music
                ig.music.add( 'media/soundSOS.ogg', 'SOS' );
                ig.music.volume = 0.7;
                ig.music.loop = true;

                //Bind keys and touch events
                ig.input.initAccelerometer();
                ig.input.initMouse();
                ig.input.bind( ig.KEY.LEFT_ARROW, 'left' );
                ig.input.bind( ig.KEY.RIGHT_ARROW, 'right' );
                ig.input.bind( ig.KEY.MOUSE1, 'shoot' );
                //ig.input.bindTouch( '#canvas', 'shoot' );


                this.generalTimer = new ig.Timer();
                this.gameOverTimer = new ig.Timer();
                this.helicopterTimer = new ig.Timer();
                this.subTimer = new ig.Timer();

                //this.startGame();
                this.startScreen();
            },


            //***********************
            // Start Screen
            //***********************
            startScreen: function() {
                this.generalTimer.set(0);
                this.gameState = "StartScreen";

                //Kill off any existing helicopters and subs from previous game
                var enemies = ig.game.getEntitiesByType('EntityHelicopter');
                for (var e=0; e<enemies.length; e++)
                    enemies[e].kill();

                enemies = ig.game.getEntitiesByType('EntitySubmarine');
                for (var e=0; e<enemies.length; e++)
                    enemies[e].kill();

                document.getElementById("gameOver").style.visibility = "";
                document.getElementById("startScreen").style.visibility = "visible";
                ig.music.play();
            },


            //***********************
            // Start Game
            //***********************
            startGame: function() {

                ig.music.stop();

                document.getElementById("startScreen").style.visibility = "";
                this.gameState = "Playing";
                this.currentScore = 0;

                //Reset the general timer
                this.generalTimer.set(0);

                //Spawn new player
                ig.game.spawnEntity(EntityPlayer, ig.game.width / 2, 44, { health: 100 });

            },


            //***********************
            // Initiate Game over
            //***********************
            setGameOver: function() {
                ig.game.gameState = "GameOver";
                document.getElementById("gameOver").style.visibility = "visible";
                this.generalTimer.set(0);
            },



            //***********************
            // Update stuff
            //***********************
            update: function() {

                if (!(this.gameState == "StartScreen")) {
                    this.spawnRandomHelicopter();
                    this.spawnRandomSubmarine();
                }

                if (this.gameState == "StartScreen" && this.generalTimer.delta() > 3) {
                    if (ig.input.state('shoot')) {
                        this.startGame();
                    }
                }
                else if (this.gameState == "GameOver" && this.generalTimer.delta() > 3) {
                    if (ig.input.state('shoot')) {
                        this.startScreen();
                    }
                }

                this.parent();
            },



            //***********************
            // Draw stuff
            //***********************
            draw: function() {
                //Transparent canvas!
                ig.system.context.clearRect( 0 ,0, ig.system.realWidth, ig.system.realHeight );

                if (this.gameState == "Playing") {
                    this.font.draw( 'Score ' + ig.game.currentScore, 1, ig.game.height - 8 );
                }

                this.parent();
            },



            //************************
            // Spawn Random Helicopter
            //************************
            spawnRandomHelicopter: function() {

                //Reduce the time between helicopters spawning the longer the game goes on
                if (this.generalTimer.delta() > 300) this.helicopterMaxDelay = 10;
                else if (this.generalTimer.delta() > 150) this.helicopterMaxDelay = 15;
                else this.helicopterMaxDelay = 20;

                if (this.numHelicopters < 10) {
                    if (this.helicopterTimer.delta() > this.helicopterDelay) {

                        this.numHelicopters += 1;
                        this.soundAirRaid.play();
                        ig.game.spawnEntity(EntityHelicopter, 0, 0, {name: 'Helicopter_' + this.numHelicopters});

                        this.helicopterDelay = Math.random() * this.helicopterMaxDelay;
                        this.helicopterTimer.set(this.helicopterDelay);
                    }
                }
            },


            //***********************
            // Spawn Random Submarine
            //***********************
            spawnRandomSubmarine: function() {

                if (this.numSubs < 10) {
                    if (this.subTimer.delta() > this.subDelay) {

                        this.numSubs += 1;
                        ig.game.spawnEntity(EntitySubmarine, 0, 0, {name: 'Submarine_' + this.numSubs});

                        this.subDelay = Math.random() * this.subMaxDelay;
                        this.subTimer.set(this.subDelay);
                    }
                }
            }


        });








        //********************
        // Start the main loop
        //********************
        ig.main('#canvas', MyGame, 60, 240, 160, 2);


    });
