ig.module(
        'game.entities.submarine'
    )
    .requires(
        'impact.entity',
        'game.entities.particle',
        'game.entities.helicopter'      //Required for fire particle
    )
    .defines(function(){

        EntitySubmarine = ig.Entity.extend({
            name: 'Submarine',                 //Each submarine will be given a unique name when spawned so that we can identify it when launching bombs
            size: {x: 20, y: 4},
            halfWidth: 12,
            halfHeight: 4,
            offset: {x: 2, y: 4},
            maxVel: {x: 30, y: 0},
            gravityFactor : 0,

            type: ig.Entity.TYPE.B, 					// Evil enemy group

            health: 100,
            speed: 20,
            flip: false,
            dying: false,
            bombDropped: false,
            bombTimer: null,

            animSheet: new ig.AnimationSheet( 'media/submarine.png', 24, 8 ),
            soundSubmarine: new ig.Sound('media/soundSubmarine.ogg'),
            soundSubBomb: new ig.Sound('media/soundSubBomb.ogg'),



            init: function( x, y, settings ) {
                this.parent( x, y, settings );
                this.addAnim( 'swim', 0.01, [0, 1] );
                this.addAnim( 'dying', 0.01, [2] );
                this.speed = 5 + Math.floor(Math.random()*25);

                //Start with a random x,y position and direction
                this.pos.x = ig.game.width;
                this.pos.y = 60 + Math.random() * 90;

                var direction = (Math.random() * 2 - 1);
                if (direction > 0) {
                    this.pos.x = -24;
                    this.flip = !this.flip;
                    this.currentAnim.flip.x = this.flip;
                }

                this.bombTimer = new ig.Timer();
                this.soundSubmarine.play();
            },


            update: function() {

                if (!this.dying) {
                    var xdir = this.flip ? 1 : -1;
                    this.vel.x = this.speed * xdir;

                    //If out of bounds kill off the sub
                    if ((this.pos.x > ig.game.width) ||
                        (this.pos.x < -30)) {
                        this.kill();
                        ig.game.numSubs -= 1;
                    }

                }
                else {
                    //Submarine is dying
                    this.gravityFactor = 0.2;
                    this.currentAnim.flip.x = this.flip;
                    if (this.pos.y > ig.game.height) {
                        this.kill();
                        ig.game.numSubs -= 1;
                    }
                }


                //If Submarine is under player then shoot a bomb
                var player = ig.game.getEntityByName('Player');
                if (player) {
                    if (!this.bombDropped &&
                        (player.pos.x+5) < (this.pos.x + this.halfWidth) &&
                        (this.pos.x + this.halfWidth) < (player.pos.x + player.size.x-5)  &&
                        this.bombTimer.delta() > 1
                        )  {
                        this.soundSubBomb.play();
                        ig.game.spawnEntity(EntitySubBomb, this.pos.x + this.halfWidth, this.pos.y, {subName: this.name});
                        this.bombDropped = true;
                        this.bombTimer.set(0);
                    }
                }


                this.parent();
            }

        });


        EntitySubBomb = ig.Entity.extend({
            name: 'SubBomb',
            size: { x: 2, y: 3 },
            offset: { x: 0, y: 0 },
            vel: { x: 0, y: -15 },
            gravityFactor: 0,
            target: { x: 0, y: 0 },
            subName: "",                                    // Name of submarine that shot this bomb

            type: ig.Entity.TYPE.B,
            checkAgainst: ig.Entity.TYPE.A, 				// Check for collisions against the player
            collides: ig.Entity.COLLIDES.PASSIVE,
            particleTimer: null,

            animSheet: new ig.AnimationSheet('media/subBomb.png', 2, 3),
            soundSubBombHit: new ig.Sound('media/soundSubBombHit.ogg'),

            init: function (x, y, settings) {
                this.vel.y = -(15 + Math.random() * 10);
                this.parent(x, y, settings);
                this.addAnim('idle', 0.05, [0,1]);
            },


            update: function () {
                this.parent();

               //Kill bomb if it hits top of water
               if (this.pos.y < 45) {
                    this.killMe();
                    ig.game.spawnEntity(EntityWaveParticle, this.pos.x, this.pos.y, { vel: {x: 10, y: -20}, restrictY : true });
                    ig.game.spawnEntity(EntityWaveParticle, this.pos.x, this.pos.y, { vel: {x: 10, y: -20}, restrictY : true });
                }
            },

            killMe: function() {
                //Reset the flag in the submarine that shot this bomb to indicate it can shoot another bomb
                var submarine = ig.game.getEntityByName(this.subName);
                if (submarine)
                    submarine.bombDropped = false;
                this.kill();
            },

            check: function (other) {
                if (other.name == 'Player') {
                    this.soundSubBombHit.play();
                    this.killMe();
                    ig.game.spawnEntity(EntityFireParticle, this.pos.x, this.pos.y, { vel: {x: 20, y: -20} });
                    ig.game.spawnEntity(EntityFireParticle, this.pos.x, this.pos.y, { vel: {x: 20, y: -20} });
                    ig.game.spawnEntity(EntityFireParticle, this.pos.x, this.pos.y, { vel: {x: 20, y: -20} });
                    other.health -= 5;
                }
            }

        });



    });