$(document).ready(function() {

    $('#back-help').click(function (){
       $('#help-center').find('li#clone-name-new').each(function (){
          $(this).remove(); 
       }); 
       $('#help-center').find('li#clone-upzilla-new').each(function (){
          $(this).remove(); 
       });
    });
    
    $('#back-home').click(function (){
       $('#district').find('li#clone-new').each(function (){
          $(this).remove(); 
       }); 
    });

    function list(district) {
        var district_name = district.attr('data-district');
        $.ajax({
            type: 'GET',
            url: "data/help.xml",
            dataType: 'xml',
            success: function(data) {
                $('#clone-name').hide(0);
                $('#clone-upzilla').hide(0);
                $(data).find('help').find(district_name).find('center').each(function() {
                    var upzilla = $(this).find('upzilla').text();
                    var name = $(this).find('name').text();
                    var phone = $(this).find('phone').text();
                    var name_clone = $('#clone-name').clone().show(0);
                    var upzilla_clone = $('#clone-upzilla').clone().show(0);
                    
                    name_clone.find('h4').text(name);
                    name_clone.attr('id', 'clone-name-new');
                    upzilla_clone.find('a').text(upzilla + ' Upzilla').attr('href', 'tel:+' + phone);
                    upzilla_clone.attr('id', 'clone-upzilla-new');
                    
                    $('#help-center').append(name_clone);
                    $('#help-center').append(upzilla_clone);
                });
            }
        });
    }

    $('#divisions').find('li').find('a').each(function() {
        $(this).click(function() {
            var division = $(this).attr('data-division');
            $.ajax({
                type: 'GET',
                url: "data/division.xml",
                dataType: 'xml',
                success: function(data) {
                    $('#district').find('#clone').hide(0);
                    $(data).find('divisions').find(division).find('district').each(function() {
                        var district = $('#district').find('#clone').clone();
                        var name = $(this).text();
                        district.show(0);
                        district.attr('id', 'clone-new');
                        district.find('a').attr('data-district', name);
                        district.find('a').text(name);
                        district.find('a').click(function() {
                            list($(this));
                        });
                        $('#district').append(district);
                    });
                }, error: function(data) {
                    console.log(data);
                }
            });
        });
    });
});
