﻿// variable which will hold the database connection
var db;

function initializeDB() {
    if (window.indexedDB) {
        console.log("IndexedDB support is there");
    }
    else {
        alert("Indexed DB is not supported. Where are you trying to run this ? ");
    }

    // open the database
    // 1st parameter : Database name. We are using the name 'notesdb'
    // 2nd parameter is the version of the database.
    var request = indexedDB.open('MotherChildHealthCareCslSoft', 1);

    request.onsuccess = function (e) {
        // e.target.result has the connection to the database
        db = e.target.result;
        //Alternately, if you want - you can retrieve all the items
    }

    request.onerror = function (e) {
        console.log(e);
    };

    // this will fire when the version of the database changes
    // We can only create Object stores in a versionchange transaction.
    request.onupgradeneeded = function (e) {
        // e.target.result holds the connection to database
        db = e.target.result;

        if (db.objectStoreNames.contains("mother")) {
            db.deleteObjectStore("mother");
        }

        var objectStore = db.createObjectStore('mother', { keyPath: 'id', autoIncrement: true });

        console.log("Mother Object Store has been created");

        if (db.objectStoreNames.contains("child")) {
            db.deleteObjectStore("child");
        }

        objectStore = db.createObjectStore('child', { keyPath: 'id', autoIncrement: true });

        console.log("Child Object Store has been created");
    };
}
$(document).ready(function () {
    initializeDB();
    $("#btnMother").click(function () {
        $("#topic-list").html("");
        $.mobile.changePage($("#view-topics"));
        $("#hTopics").text("মা স্বাস্থ্য সেবা");
        ViewTopic('M', 'Topics.xml');
    });

    $("#btnChild").click(function () {
        $("#topic-list").html("");
        $.mobile.changePage($("#view-topics"));
        $("#hTopics").text("শিশু স্বাস্থ্য সেবা");
        ViewTopic('C', 'Topics.xml');
    });

    $("#btnService").click(function () {
        document.getElementById('topic-list').innerHTML = "<p style='padding-left:10px;'><b>স্বাস্থ্য সেবায় সরকারী সাফল্য</b><br><br>" +
            "শিশুদের টিকাদান কর্মসূচির সাফল্যের জন্য এক্ষেত্রে বাংলাদেশ বিশ্বে অন্যতম আদর্শ দেশ হিসেবে তার স্থান করে নিয়েছে।" +
        "স্বাস্থ্যখাতকে যুগোপযোগী করতে প্রণয়ন করা হয়েছে “জাতীয় স্বাস্থ্য নীতিমালা-২০১১”। তৃণমূল পর্যায়ের দরিদ্র মানুষদের " +
        "স্বাস্থ্যসেবা নিশ্চিত করতে গড়ে তোলা হয়েছে ১২ হাজার ২১৭টি কমিউনিটি ক্লিনিক।" +
 "২৭৫টি উপজেলা হাসপাতালকে উন্নীত করা হয়েছে ৫০ শয্যায়। মেডিকেল কলেজ ও জেলা হাসপতালগুলোতে ২ হাজার শয্যা" +
 "সংখ্যা বৃদ্ধি করা হয়েছে। মাতৃ ও শিশু মৃত্যুহার এবং জন্মহার  হ্রাস করা সম্ভব হয়েছে উল্লেখযোগ্য হারে।" +
 "১৯৯০ সালে নবজাতক মৃত্যুর হার ১৪৯ থেকে নেমে বর্তমানে দাঁড়িয়েছে ৫৪তে। স্বাস্থ্যসেবাকে জনগণের দোড়গোড়ায় পৌঁছে " +
 "দেবার লক্ষকে সামনে রেখে নির্মাণ করা হয়েছে নতুন  ৪টি মেডিকেল কলেজ, নিয়োগ দেওয়া হয়েছে ৪০ হাজারেও বেশি জনবল।<br><br>" +
            "<b>ঢাকার গুরুত্বপূর্ণ হাসপাতাল এবং ক্লিনিকঃ</b><br><br>" +
            "ঢাকা মেডিকেল কলেজ হাসপাতাল : ৮৬২৬৮১২-২৯<br>" +
    "পিজি হাসপাতাল : ৯৬৬১০৫১-৫৬<br>" +
    "বারডেম হাসপাতাল : ৯৬৬১৫৫১, ৮৬১৬৬৪১-৫০<br>" +
    "আল-মানার হাসপাতাল : ৯১২১৩৮৭, ৯১২১৫৮৮<br>" +
    "ইসলামী ব্যাংক হাসপাতাল : ৯৩৩৬৪২১-৩, ৯৩৩৬৬৫৭<br>" +
    "    ইসলামীয়া চক্ষু হাসপাতাল : ৮১১২১৫৬<br>" +
    "    স্যার সলিমুল্লাহ মেডিকেল কলেজ হাসপাতাল : ৭৩১০০৬১-৪<br>" +
    "    সম্মিলিত সামরিক হাসপাতাল : ৯৮৭১৪৯৬, ৮১১০৩৪৫<br>" +
    "    সোহরাওয়ার্দী হাসপাতাল : ৯০৩০৮০০-১৯<br>" +
    "    শিশু হাসপাতাল : ৮১১৬০৬১-২, ৯১১৯১১৯<br>" +
    "    ইসলামী ব্যাংক সেন্ট্রাল হাসপাতাল : ৯৩৩৮৮১০, ৮৩১৬১৬৬<br>" +
    "    মনোয়ারা হাসপাতাল : ৮৩১৮১৩৫, ৮৩১৯৮০২<br>" +
    "    হলি ফ্যামিলি : ৯৮০১৮৭৮<br>" +
     "   ক্যান্সার গবেষণা ইনষ্টিটিউটও হাসপাতাল : ৮৮২৬৫৬১-৫<br>" +
    "    ইবনে সিনা হাসপাতাল : ৮১১৩৭০৯, ৮১১৯৫১৩-৫<br>" +
    "    ইবনে সিনা ইমেজিং সেন্টার : ৮৬১৮০০৭, ৮৬১৮২৬২, ৯৬৬৬৪৯৭<br>" +
     "   শমরিতা হাসপাতাল লিঃ : ৮৬১১৩০৭, ৯১৩১৯০১-৩<br>" +
    "    ষ্টোনক্রাস হসপিটাল : ৯৬৬৮৪৮২, ৯১৩৭৩২<br>" +
    "    ফুয়াদ আল খতিব হাসপাতাল : ৯০০৭১৮৮, ৮০১৩৬৩৮<br>" +
    "    হার্ট এন্ড চেষ্ট হাসপাতাল : ৯৮০১৮৭৪<br>" +
     "   ক্রিসেন্ট গ্যাস্ট্রোলিভার এন্ড জেনারেল হসপিটাল : ৯১১৬৮৫১<br>" +
     "   ঢাকা ডেন্টাল কলেজ হাসপাতাল : ৮০১৭১৪৫, ৮০১৭১৪৭<br>" +
     "   কিডনি হাসপাতাল : ৮১২২০১৯<br>" +
     "   মার্কস এন্ড (নাক-কান-গলা) : ৯৮৭২২৪১<br>" +
      "  মিরপুর জেনারেল হাসপাতাল : ৮০১৫৪৪৪<br>" +
     "   দি বারাকা জেনারেল হাসপাতাল : ৮৩১৭৭৬৫, ৯৩৪৬২৬৫<br>" +
      "  দি বারাকা কিডনী হাসপাতাল : ৯৩৫১১৬৪<br>" +
      "  আদ দ্বীন হাসপাতাল : ৯৩৫১১৬৪<br>" +
     "   আল রাজী হাসপাতাল : ৮১১৯২২৯, ৯১১৭৭৭৫<br>" +
       "     পপুলার মেডিকেল কলেজ হাসপাতাল : ০২-৯৬৬৩৩০১<br><br>" +
            "<b>উপজেলা স্বাস্থ্য কমপ্লেক্স:</b><br><br></p>";

        $.mobile.changePage($("#view-topics"));
        $("#hTopics").text("তথ্য পুঞ্জি");
        ViewTopic('HC', 'HC.xml');
    });

    $(".ui-btn-right").click(function () {
        $.mobile.changePage($("#home"));
    });

    $("#btnCare").click(function () {
        $.mobile.changePage($("#view-motherchild"));
        ShowMotherChild();
    });

    $("#btnMotherRegister").click(function () {
        ClearMother();
        $("#btnSaveMother").attr("mId", -1);
        $.mobile.changePage($("#entry-mother"));
    });

    $("#btnSaveMother").click(function () {
        var id = parseInt($("#btnSaveMother").attr("mId"));
        if ($("#txtMotherName").val() == "" || $("#txtPD").val() == "")
            return;
        SaveMotherInfo(id);
    });

    $("#btnChildRegister").click(function () {
        ClearChild();
        $("#btnSaveChild").attr("cId", -1);
        $.mobile.changePage($("#entry-child"));
    });

    $("#btnSaveChild").click(function () {
        if ($("#txtChildName").val() == "" || $("#txtGender").val() == "" || $("#txtDOB").val() == "")
            return;
        var id = parseInt($("#btnSaveChild").attr("cId"));
        SaveChildInfo(id);
    });
});
function ShowMotherChild() {
    $("#child-list").html("");
    LoadMother();
    setTimeout(LoadChild, 300);
}
function LoadMother() {
    var transaction = db.transaction(['mother']);
    var store = transaction.objectStore('mother');
    $('#btnMotherRegister').removeClass('ui-disabled');
    document.getElementById('child-list').innerHTML = "<p style='padding-left:10px;'><center><b>মা</b></center></p>";
    store.openCursor().onsuccess = function (e) {
        var cursor = e.target.result;
        if (cursor) {
            var value = cursor.value;
            var noteElement = $("<div data-role='collapsible' data-mini='true' data-collapsed-icon='carat-d' data-expanded-icon='carat-u'/>");
            var h3NoteTitle = $("<h3/>").text(value.MotherName);
            var div = $('<div data-role="navbar"></div>');
            var ul = $('<ul/>');
            var liEdit = $('<li><a href="#" data-role="button">পরিবর্তন</a></li>');
            var liDelete = $('<li><a href="#" data-role="button">মুছে দিন</a></li>');
            var liDetails = $('<li><a href="#" data-role="button">বিস্তারিত</a></li>');

            ul.append(liEdit).append(liDelete).append(liDetails);
            div.append(ul);
            liEdit.click(function () {
                EditMother(value);
            });
            liDelete.click(function () {
                var r = confirm("আপনি মুছে ফেলতে চান?");
                if (r == true) {
                    DeleteMother(value.id);
                    $("#btnCare").trigger("click");
                }
            });
            liDetails.click(function () {
                var todate = new Date();
                var pd = value.PD;
                var days = dateDiff(pd, todate);
                ViewDetails("M", days.d, value.MotherName);
            });

            var pNoteDetails = $("<p/>").html("<b>গর্ভাবস্থা তারিখ : " + value.PD + "</b><br><br>");
            pNoteDetails.append(div);
            noteElement.append(h3NoteTitle);
            noteElement.append(pNoteDetails);
            $("#child-list").append(noteElement);
            $('#btnMotherRegister').addClass('ui-disabled');
            cursor.continue();
        }
        $('div[data-role=navbar]').navbar({ refresh: true });
        $('div[data-role=collapsible]').collapsible({ refresh: true });
    };
}
function LoadChild() {
    var transaction = db.transaction(['child']);
    var store = transaction.objectStore('child');
    $('#child-list').append("<p style='padding-left:10px;'><center><b>শিশু</b></center></p>");
    store.openCursor().onsuccess = function (e) {
        var cursor = e.target.result;
        if (cursor) {
            var value = cursor.value;
            var noteElement = $("<div data-role='collapsible' data-mini='true' data-collapsed-icon='carat-d' data-expanded-icon='carat-u'/>");
            var h3NoteTitle = $("<h3/>").text(value.ChildName);

            var div = $('<div data-role="navbar"></div>');
            var ul = $('<ul/>');
            var liEdit = $('<li><a href="#" data-role="button">পরিবর্তন</a></li>');
            var liDelete = $('<li><a href="#" data-role="button">মুছে দিন</a></li>');
            var liDetails = $('<li><a href="#" data-role="button">বিস্তারিত</a></li>');

            ul.append(liEdit).append(liDelete).append(liDetails);
            div.append(ul);
            liEdit.click(function () {
                EditChild(value);
            });
            liDelete.click(function () {
                var r = confirm("আপনি মুছে ফেলতে চান?");
                if (r == true) {
                    DeleteChild(value.id);
                    $("#btnCare").trigger("click");
                }
            });
            liDetails.click(function () {
                var todate = new Date();
                var dob = value.DOB;
                var days = dateDiff(dob, todate);
                ViewDetails("C", days.d, value.ChildName);
            });

            var pNoteDetails = $("<p/>").html("<b>ছেলে অথবা মেয়ে : " + value.Gender + "<br>" + "জন্ম তারিখ : " + value.DOB + "</b><br><br>");
            pNoteDetails.append(div);
            noteElement.append(h3NoteTitle);
            noteElement.append(pNoteDetails);
            $("#child-list").append(noteElement);
            cursor.continue();
        }
        $('div[data-role=navbar]').navbar({ refresh: true });
        $('div[data-role=collapsible]').collapsible({ refresh: true });
    };
}
function dateDiff(str1, str2) {
    var diff = Date.parse(str2) - Date.parse(str1);
    return isNaN(diff) ? NaN : {
        diff: diff,
        ms: Math.floor(diff % 1000),
        s: Math.floor(diff / 1000 % 60),
        m: Math.floor(diff / 60000 % 60),
        h: Math.floor(diff / 3600000 % 24),
        d: Math.floor(diff / 86400000)
    };
}
function EditMother(minfo) {
    ClearMother();
    $("#btnSaveMother").attr("mId", minfo.id);
    $("#txtMotherName").val(minfo.MotherName);
    $("#txtPD").val(minfo.PD);
    $.mobile.changePage($("#entry-mother"));
}
function EditChild(cinfo) {
    ClearChild();
    $("#btnSaveChild").attr("cId", cinfo.id);
    $("#txtChildName").val(cinfo.ChildName);
    $("#txtGender").val(cinfo.Gender);
    $("#txtDOB").val(cinfo.DOB);
    $.mobile.changePage($("#entry-child"));
}
function DeleteMother(id) {
    var transaction = db.transaction("mother", "readwrite");
    var objectStore = transaction.objectStore("mother");
    var request = objectStore.delete(id);
    request.onsuccess = function (evt) {
        console.log(id + " deleted");
    }
    request.onerror = function (evt) {
        console.log(id + " delete fail");
    }
}
function DeleteChild(id) {
    var transaction = db.transaction("child", "readwrite");
    var objectStore = transaction.objectStore("child");
    var request = objectStore.delete(id);
    request.onsuccess = function (evt) {
        console.log(id + " deleted");
    }
    request.onerror = function (evt) {
        console.log(id + " delete fail");
    }
}
function SaveMotherInfo(id) {
    var store = db.transaction(["mother"], "readwrite").objectStore("mother");
    var request = store.get(id);
    request.onerror = function (event) {
        // Handle errors!
    };
    request.onsuccess = function (event) {
        var data;
        if (request.result == undefined)
            data = {};
        else
            data = request.result;

        // update the value(s) in the object that you want to change
        data.MotherName = $("#txtMotherName").val();
        data.PD = $("#txtPD").val();
        // Put this updated object back into the database.
        var saveRequest;
        if (request.result == undefined)
            saveRequest = store.add(data);
        else
            saveRequest = store.put(data);

        saveRequest.onerror = function (e) {
            // Do something with the error
            alert("Error in saving the mother. Reason : " + e.value);
        };
        saveRequest.onsuccess = function (e) {
            $("#btnCare").trigger("click");
        };
    };
}
function SaveChildInfo(id) {
    var store = db.transaction(["child"], "readwrite").objectStore("child");
    var request = store.get(id);
    request.onerror = function (event) {
        // Handle errors!
    };
    request.onsuccess = function (event) {
        var data;
        if (request.result == undefined)
            data = {};
        else
            data = request.result;

        // update the value(s) in the object that you want to change
        data.ChildName = $("#txtChildName").val();
        data.Gender = $("#txtGender").val();
        data.DOB = $("#txtDOB").val();
        // Put this updated object back into the database.
        var saveRequest;
        if (request.result == undefined)
            saveRequest = store.add(data);
        else
            saveRequest = store.put(data);

        saveRequest.onerror = function (e) {
            // Do something with the error
            alert("Error in saving the child. Reason : " + e.value);
        };
        saveRequest.onsuccess = function (e) {
            $("#btnCare").trigger("click");
        };
    };
}
function ClearMother() {
    $("#txtMotherName").val('');
    $("#txtPD").val('');
}
function ClearChild() {
    $("#txtChildName").val('');
    $("#txtGender").val('');
    $("#txtDOB").val('');
}

function ViewTopic(type, xmlFile) {
    var xhr = new XMLHttpRequest({ mozSystem: true });
    xhr.open("GET", xmlFile, true);
    xhr.responseType = "document";
    xhr.onreadystatechange = function () {
        if (xhr.readyState == 4) {
            $(xhr.responseXML).find('topic').each(function () {
                var topictype = $(this).attr('topictype');
                if (topictype == type) {
                    var topic = new Object();
                    topic.id = $(this).attr('id');
                    topic.name = $(this).attr('name');
                    topic.topictype = topictype;
                    AddSubTopics($(this), topic);
                }
            });

            $("ul").listview();
        }
    }
    xhr.send();
}
function AddSubTopics(xmlTopic, topic) {
    var noteElement = AddMainTopic(topic);
    var listContainer = $('<ul data-role="listview" data-inset="true">');
    var topics = [];
    $(xmlTopic).find('subtopic').each(function () {
        var subtopic = new Object();
        subtopic.id = $(this).attr('id');
        subtopic.name = $(this).attr('name');
        //subtopic.topicimage = $(this).attr('topicimage');
        //subtopic.fromday = $(this).attr('fromday');
        //subtopic.today = $(this).attr('today');
        subtopic.desc = $(this).text();
        topics.push(subtopic);
        AddSubTopic(subtopic, $(this).text(), listContainer);
    });
    topic.topics = topics;
    noteElement.append(listContainer);
    $("#topic-list").append(noteElement);
    $('div[data-role=collapsible]').collapsible({ refresh: true });
}
function AddMainTopic(topic) {
    var noteElement = $("<div data-role='collapsible' data-mini='true' data-collapsed-icon='carat-d' data-expanded-icon='carat-u'/>");
    var h3NoteTitle = $("<h3/>").text(topic.name);
    noteElement.append(h3NoteTitle);
    return noteElement;
}
function AddSubTopic(topic, desc, listContainer) {
    var topicButton = $('<li data-icon="false">' + topic.name + '</li>');
    topicButton.click(function () {
        $.mobile.changePage($("#topic-details"));
        $("#hDetails").text($(this).text());
        $("#divDetails").html(desc);
    });
    listContainer.append(topicButton);
}

function ViewDetails(type, days, desc) {
    $("#divDetails").html("");
    $("#hDetails").text(desc);
    var xhr = new XMLHttpRequest({ mozSystem: true });
    xhr.open("GET", "Vaccination Date.xml", true);
    xhr.responseType = "document";
    xhr.onreadystatechange = function () {
        if (xhr.readyState == 4) {
            $(xhr.responseXML).find('topic').each(function () {
                var topictype = $(this).attr('topictype');
                var fromday = parseInt($(this).attr('fromday'));
                var today = parseInt($(this).attr('today'));
                if (topictype == type && days >= fromday && days <= today) {
                    $("#divDetails").append("<p><b>" + $(this).attr('name') + "</b></p>");
                }
            });
            $.mobile.changePage($("#topic-details"));                        
        }
    }
    xhr.send();
}