﻿// Generated by Construct 2, the HTML5 game and app creator :: http://www.scirra.com
var cr = {};
cr.plugins_ = {};
cr.behaviors = {};
if (typeof Object.getPrototypeOf !== "function")
{
	if (typeof "test".__proto__ === "object")
	{
		Object.getPrototypeOf = function(object) {
			return object.__proto__;
		};
	}
	else
	{
		Object.getPrototypeOf = function(object) {
			return object.constructor.prototype;
		};
	}
}
(function(){
	cr.logexport = function (msg)
	{
		if (window.console && window.console.log)
			window.console.log(msg);
	};
	cr.seal = function(x)
	{
		return x;
	};
	cr.freeze = function(x)
	{
		return x;
	};
	cr.is_undefined = function (x)
	{
		return typeof x === "undefined";
	};
	cr.is_number = function (x)
	{
		return typeof x === "number";
	};
	cr.is_string = function (x)
	{
		return typeof x === "string";
	};
	cr.isPOT = function (x)
	{
		return x > 0 && ((x - 1) & x) === 0;
	};
	cr.nextHighestPowerOfTwo = function(x) {
		--x;
		for (var i = 1; i < 32; i <<= 1) {
			x = x | x >> i;
		}
		return x + 1;
	}
	cr.abs = function (x)
	{
		return (x < 0 ? -x : x);
	};
	cr.max = function (a, b)
	{
		return (a > b ? a : b);
	};
	cr.min = function (a, b)
	{
		return (a < b ? a : b);
	};
	cr.PI = Math.PI;
	cr.round = function (x)
	{
		return (x + 0.5) | 0;
	};
	cr.floor = function (x)
	{
		if (x >= 0)
			return x | 0;
		else
			return (x | 0) - 1;		// correctly round down when negative
	};
	cr.ceil = function (x)
	{
		var f = x | 0;
		return (f === x ? f : f + 1);
	};
	function Vector2(x, y)
	{
		this.x = x;
		this.y = y;
		cr.seal(this);
	};
	Vector2.prototype.offset = function (px, py)
	{
		this.x += px;
		this.y += py;
		return this;
	};
	Vector2.prototype.mul = function (px, py)
	{
		this.x *= px;
		this.y *= py;
		return this;
	};
	cr.vector2 = Vector2;
	cr.segments_intersect = function(a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y)
	{
		var max_ax, min_ax, max_ay, min_ay, max_bx, min_bx, max_by, min_by;
		if (a1x < a2x)
		{
			min_ax = a1x;
			max_ax = a2x;
		}
		else
		{
			min_ax = a2x;
			max_ax = a1x;
		}
		if (b1x < b2x)
		{
			min_bx = b1x;
			max_bx = b2x;
		}
		else
		{
			min_bx = b2x;
			max_bx = b1x;
		}
		if (max_ax < min_bx || min_ax > max_bx)
			return false;
		if (a1y < a2y)
		{
			min_ay = a1y;
			max_ay = a2y;
		}
		else
		{
			min_ay = a2y;
			max_ay = a1y;
		}
		if (b1y < b2y)
		{
			min_by = b1y;
			max_by = b2y;
		}
		else
		{
			min_by = b2y;
			max_by = b1y;
		}
		if (max_ay < min_by || min_ay > max_by)
			return false;
		var dpx = b1x - a1x + b2x - a2x;
		var dpy = b1y - a1y + b2y - a2y;
		var qax = a2x - a1x;
		var qay = a2y - a1y;
		var qbx = b2x - b1x;
		var qby = b2y - b1y;
		var d = cr.abs(qay * qbx - qby * qax);
		var la = qbx * dpy - qby * dpx;
		if (cr.abs(la) > d)
			return false;
		var lb = qax * dpy - qay * dpx;
		return cr.abs(lb) <= d;
	};
	function Rect(left, top, right, bottom)
	{
		this.set(left, top, right, bottom);
		cr.seal(this);
	};
	Rect.prototype.set = function (left, top, right, bottom)
	{
		this.left = left;
		this.top = top;
		this.right = right;
		this.bottom = bottom;
	};
	Rect.prototype.copy = function (r)
	{
		this.left = r.left;
		this.top = r.top;
		this.right = r.right;
		this.bottom = r.bottom;
	};
	Rect.prototype.width = function ()
	{
		return this.right - this.left;
	};
	Rect.prototype.height = function ()
	{
		return this.bottom - this.top;
	};
	Rect.prototype.offset = function (px, py)
	{
		this.left += px;
		this.top += py;
		this.right += px;
		this.bottom += py;
		return this;
	};
	Rect.prototype.normalize = function ()
	{
		var temp = 0;
		if (this.left > this.right)
		{
			temp = this.left;
			this.left = this.right;
			this.right = temp;
		}
		if (this.top > this.bottom)
		{
			temp = this.top;
			this.top = this.bottom;
			this.bottom = temp;
		}
	};
	Rect.prototype.intersects_rect = function (rc)
	{
		return !(rc.right < this.left || rc.bottom < this.top || rc.left > this.right || rc.top > this.bottom);
	};
	Rect.prototype.intersects_rect_off = function (rc, ox, oy)
	{
		return !(rc.right + ox < this.left || rc.bottom + oy < this.top || rc.left + ox > this.right || rc.top + oy > this.bottom);
	};
	Rect.prototype.contains_pt = function (x, y)
	{
		return (x >= this.left && x <= this.right) && (y >= this.top && y <= this.bottom);
	};
	Rect.prototype.equals = function (r)
	{
		return this.left === r.left && this.top === r.top && this.right === r.right && this.bottom === r.bottom;
	};
	cr.rect = Rect;
	function Quad()
	{
		this.tlx = 0;
		this.tly = 0;
		this.trx = 0;
		this.try_ = 0;	// is a keyword otherwise!
		this.brx = 0;
		this.bry = 0;
		this.blx = 0;
		this.bly = 0;
		cr.seal(this);
	};
	Quad.prototype.set_from_rect = function (rc)
	{
		this.tlx = rc.left;
		this.tly = rc.top;
		this.trx = rc.right;
		this.try_ = rc.top;
		this.brx = rc.right;
		this.bry = rc.bottom;
		this.blx = rc.left;
		this.bly = rc.bottom;
	};
	Quad.prototype.set_from_rotated_rect = function (rc, a)
	{
		if (a === 0)
		{
			this.set_from_rect(rc);
		}
		else
		{
			var sin_a = Math.sin(a);
			var cos_a = Math.cos(a);
			var left_sin_a = rc.left * sin_a;
			var top_sin_a = rc.top * sin_a;
			var right_sin_a = rc.right * sin_a;
			var bottom_sin_a = rc.bottom * sin_a;
			var left_cos_a = rc.left * cos_a;
			var top_cos_a = rc.top * cos_a;
			var right_cos_a = rc.right * cos_a;
			var bottom_cos_a = rc.bottom * cos_a;
			this.tlx = left_cos_a - top_sin_a;
			this.tly = top_cos_a + left_sin_a;
			this.trx = right_cos_a - top_sin_a;
			this.try_ = top_cos_a + right_sin_a;
			this.brx = right_cos_a - bottom_sin_a;
			this.bry = bottom_cos_a + right_sin_a;
			this.blx = left_cos_a - bottom_sin_a;
			this.bly = bottom_cos_a + left_sin_a;
		}
	};
	Quad.prototype.offset = function (px, py)
	{
		this.tlx += px;
		this.tly += py;
		this.trx += px;
		this.try_ += py;
		this.brx += px;
		this.bry += py;
		this.blx += px;
		this.bly += py;
		return this;
	};
	var minresult = 0;
	var maxresult = 0;
	function minmax4(a, b, c, d)
	{
		if (a < b)
		{
			if (c < d)
			{
				if (a < c)
					minresult = a;
				else
					minresult = c;
				if (b > d)
					maxresult = b;
				else
					maxresult = d;
			}
			else
			{
				if (a < d)
					minresult = a;
				else
					minresult = d;
				if (b > c)
					maxresult = b;
				else
					maxresult = c;
			}
		}
		else
		{
			if (c < d)
			{
				if (b < c)
					minresult = b;
				else
					minresult = c;
				if (a > d)
					maxresult = a;
				else
					maxresult = d;
			}
			else
			{
				if (b < d)
					minresult = b;
				else
					minresult = d;
				if (a > c)
					maxresult = a;
				else
					maxresult = c;
			}
		}
	};
	Quad.prototype.bounding_box = function (rc)
	{
		minmax4(this.tlx, this.trx, this.brx, this.blx);
		rc.left = minresult;
		rc.right = maxresult;
		minmax4(this.tly, this.try_, this.bry, this.bly);
		rc.top = minresult;
		rc.bottom = maxresult;
	};
	Quad.prototype.contains_pt = function (x, y)
	{
		var v0x = this.trx - this.tlx;
		var v0y = this.try_ - this.tly;
		var v1x = this.brx - this.tlx;
		var v1y = this.bry - this.tly;
		var v2x = x - this.tlx;
		var v2y = y - this.tly;
		var dot00 = v0x * v0x + v0y * v0y
		var dot01 = v0x * v1x + v0y * v1y
		var dot02 = v0x * v2x + v0y * v2y
		var dot11 = v1x * v1x + v1y * v1y
		var dot12 = v1x * v2x + v1y * v2y
		var invDenom = 1.0 / (dot00 * dot11 - dot01 * dot01);
		var u = (dot11 * dot02 - dot01 * dot12) * invDenom;
		var v = (dot00 * dot12 - dot01 * dot02) * invDenom;
		if ((u >= 0.0) && (v > 0.0) && (u + v < 1))
			return true;
		v0x = this.blx - this.tlx;
		v0y = this.bly - this.tly;
		var dot00 = v0x * v0x + v0y * v0y
		var dot01 = v0x * v1x + v0y * v1y
		var dot02 = v0x * v2x + v0y * v2y
		invDenom = 1.0 / (dot00 * dot11 - dot01 * dot01);
		u = (dot11 * dot02 - dot01 * dot12) * invDenom;
		v = (dot00 * dot12 - dot01 * dot02) * invDenom;
		return (u >= 0.0) && (v > 0.0) && (u + v < 1);
	};
	Quad.prototype.at = function (i, xory)
	{
		if (xory)
		{
			switch (i)
			{
				case 0: return this.tlx;
				case 1: return this.trx;
				case 2: return this.brx;
				case 3: return this.blx;
				case 4: return this.tlx;
				default: return this.tlx;
			}
		}
		else
		{
			switch (i)
			{
				case 0: return this.tly;
				case 1: return this.try_;
				case 2: return this.bry;
				case 3: return this.bly;
				case 4: return this.tly;
				default: return this.tly;
			}
		}
	};
	Quad.prototype.midX = function ()
	{
		return (this.tlx + this.trx  + this.brx + this.blx) / 4;
	};
	Quad.prototype.midY = function ()
	{
		return (this.tly + this.try_ + this.bry + this.bly) / 4;
	};
	Quad.prototype.intersects_segment = function (x1, y1, x2, y2)
	{
		if (this.contains_pt(x1, y1) || this.contains_pt(x2, y2))
			return true;
		var a1x, a1y, a2x, a2y;
		var i;
		for (i = 0; i < 4; i++)
		{
			a1x = this.at(i, true);
			a1y = this.at(i, false);
			a2x = this.at(i + 1, true);
			a2y = this.at(i + 1, false);
			if (cr.segments_intersect(x1, y1, x2, y2, a1x, a1y, a2x, a2y))
				return true;
		}
		return false;
	};
	Quad.prototype.intersects_quad = function (rhs)
	{
		var midx = rhs.midX();
		var midy = rhs.midY();
		if (this.contains_pt(midx, midy))
			return true;
		midx = this.midX();
		midy = this.midY();
		if (rhs.contains_pt(midx, midy))
			return true;
		var a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y;
		var i, j;
		for (i = 0; i < 4; i++)
		{
			for (j = 0; j < 4; j++)
			{
				a1x = this.at(i, true);
				a1y = this.at(i, false);
				a2x = this.at(i + 1, true);
				a2y = this.at(i + 1, false);
				b1x = rhs.at(j, true);
				b1y = rhs.at(j, false);
				b2x = rhs.at(j + 1, true);
				b2y = rhs.at(j + 1, false);
				if (cr.segments_intersect(a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y))
					return true;
			}
		}
		return false;
	};
	cr.quad = Quad;
	cr.RGB = function (red, green, blue)
	{
		return Math.max(Math.min(red, 255), 0)
			 | (Math.max(Math.min(green, 255), 0) << 8)
			 | (Math.max(Math.min(blue, 255), 0) << 16);
	};
	cr.GetRValue = function (rgb)
	{
		return rgb & 0xFF;
	};
	cr.GetGValue = function (rgb)
	{
		return (rgb & 0xFF00) >> 8;
	};
	cr.GetBValue = function (rgb)
	{
		return (rgb & 0xFF0000) >> 16;
	};
	cr.shallowCopy = function (a, b, allowOverwrite)
	{
		var attr;
		for (attr in b)
		{
			if (b.hasOwnProperty(attr))
			{
;
				a[attr] = b[attr];
			}
		}
		return a;
	};
	cr.arrayRemove = function (arr, index)
	{
		var i, len;
		index = cr.floor(index);
		if (index < 0 || index >= arr.length)
			return;							// index out of bounds
		if (index === 0)					// removing first item
			arr.shift();
		else if (index === arr.length - 1)	// removing last item
			arr.pop();
		else
		{
			for (i = index, len = arr.length - 1; i < len; i++)
				arr[i] = arr[i + 1];
			arr.length = len;
		}
	};
	cr.shallowAssignArray = function (dest, src)
	{
		dest.length = src.length;
		var i, len;
		for (i = 0, len = src.length; i < len; i++)
			dest[i] = src[i];
	};
	cr.appendArray = function (a, b)
	{
		a.push.apply(a, b);
	};
	cr.arrayFindRemove = function (arr, item)
	{
		var index = arr.indexOf(item);
		if (index !== -1)
			cr.arrayRemove(arr, index);
	};
	cr.clamp = function(x, a, b)
	{
		if (x < a)
			return a;
		else if (x > b)
			return b;
		else
			return x;
	};
	cr.to_radians = function(x)
	{
		return x / (180.0 / cr.PI);
	};
	cr.to_degrees = function(x)
	{
		return x * (180.0 / cr.PI);
	};
	cr.clamp_angle_degrees = function (a)
	{
		a %= 360;       // now in (-360, 360) range
		if (a < 0)
			a += 360;   // now in [0, 360) range
		return a;
	};
	cr.clamp_angle = function (a)
	{
		a %= 2 * cr.PI;       // now in (-2pi, 2pi) range
		if (a < 0)
			a += 2 * cr.PI;   // now in [0, 2pi) range
		return a;
	};
	cr.to_clamped_degrees = function (x)
	{
		return cr.clamp_angle_degrees(cr.to_degrees(x));
	};
	cr.to_clamped_radians = function (x)
	{
		return cr.clamp_angle(cr.to_radians(x));
	};
	cr.angleTo = function(x1, y1, x2, y2)
	{
		var dx = x2 - x1;
        var dy = y2 - y1;
		return Math.atan2(dy, dx);
	};
	cr.angleDiff = function (a1, a2)
	{
		if (a1 === a2)
			return 0;
		var s1 = Math.sin(a1);
		var c1 = Math.cos(a1);
		var s2 = Math.sin(a2);
		var c2 = Math.cos(a2);
		var n = s1 * s2 + c1 * c2;
		if (n >= 1)
			return 0;
		if (n <= -1)
			return cr.PI;
		return Math.acos(n);
	};
	cr.angleRotate = function (start, end, step)
	{
		var ss = Math.sin(start);
		var cs = Math.cos(start);
		var se = Math.sin(end);
		var ce = Math.cos(end);
		if (Math.acos(ss * se + cs * ce) > step)
		{
			if (cs * se - ss * ce > 0)
				return cr.clamp_angle(start + step);
			else
				return cr.clamp_angle(start - step);
		}
		else
			return cr.clamp_angle(end);
	};
	cr.angleClockwise = function (a1, a2)
	{
		var s1 = Math.sin(a1);
		var c1 = Math.cos(a1);
		var s2 = Math.sin(a2);
		var c2 = Math.cos(a2);
		return c1 * s2 - s1 * c2 <= 0;
	};
	cr.rotatePtAround = function (px, py, a, ox, oy, getx)
	{
		if (a === 0)
			return getx ? px : py;
		var sin_a = Math.sin(a);
		var cos_a = Math.cos(a);
		px -= ox;
		py -= oy;
		var left_sin_a = px * sin_a;
		var top_sin_a = py * sin_a;
		var left_cos_a = px * cos_a;
		var top_cos_a = py * cos_a;
		px = left_cos_a - top_sin_a;
		py = top_cos_a + left_sin_a;
		px += ox;
		py += oy;
		return getx ? px : py;
	}
	cr.distanceTo = function(x1, y1, x2, y2)
	{
		var dx = x2 - x1;
        var dy = y2 - y1;
		return Math.sqrt(dx*dx + dy*dy);
	};
	cr.xor = function (x, y)
	{
		return !x !== !y;
	};
	cr.lerp = function (a, b, x)
	{
		return a + (b - a) * x;
	};
	cr.unlerp = function (a, b, c)
	{
		if (a === b)
			return 0;		// avoid divide by 0
		return (c - a) / (b - a);
	};
	cr.anglelerp = function (a, b, x)
	{
		var diff = cr.angleDiff(a, b);
		if (cr.angleClockwise(b, a))
		{
			return a + diff * x;
		}
		else
		{
			return a - diff * x;
		}
	};
	cr.hasAnyOwnProperty = function (o)
	{
		var p;
		for (p in o)
		{
			if (o.hasOwnProperty(p))
				return true;
		}
		return false;
	};
	cr.wipe = function (obj)
	{
		var p;
		for (p in obj)
		{
			if (obj.hasOwnProperty(p))
				delete obj[p];
		}
	};
	var startup_time = +(new Date());
	cr.performance_now = function()
	{
		if (typeof window["performance"] !== "undefined")
		{
			var winperf = window["performance"];
			if (typeof winperf.now !== "undefined")
				return winperf.now();
			else if (typeof winperf["webkitNow"] !== "undefined")
				return winperf["webkitNow"]();
			else if (typeof winperf["mozNow"] !== "undefined")
				return winperf["mozNow"]();
			else if (typeof winperf["msNow"] !== "undefined")
				return winperf["msNow"]();
		}
		return Date.now() - startup_time;
	};
	var supports_set = ((typeof window === "undefined" || !window["c2ejecta"]) && (typeof Set !== "undefined" && typeof Set.prototype["forEach"] !== "undefined"));
	function ObjectSet_()
	{
		this.s = null;
		this.items = null;			// lazy allocated (hopefully results in better GC performance)
		this.item_count = 0;
		if (supports_set)
		{
			this.s = new Set();
		}
		this.values_cache = [];
		this.cache_valid = true;
		cr.seal(this);
	};
	ObjectSet_.prototype.contains = function (x)
	{
		if (this.isEmpty())
			return false;
		if (supports_set)
			return this.s["has"](x);
		else
			return (this.items && this.items.hasOwnProperty(x));
	};
	ObjectSet_.prototype.add = function (x)
	{
		if (supports_set)
		{
			if (!this.s["has"](x))
			{
				this.s["add"](x);
				this.cache_valid = false;
			}
		}
		else
		{
			var str = x.toString();
			var items = this.items;
			if (!items)
			{
				this.items = {};
				this.items[str] = x;
				this.item_count = 1;
				this.cache_valid = false;
			}
			else if (!items.hasOwnProperty(str))
			{
				items[str] = x;
				this.item_count++;
				this.cache_valid = false;
			}
		}
	};
	ObjectSet_.prototype.remove = function (x)
	{
		if (this.isEmpty())
			return;
		if (supports_set)
		{
			if (this.s["has"](x))
			{
				this.s["delete"](x);
				this.cache_valid = false;
			}
		}
		else if (this.items)
		{
			var str = x.toString();
			var items = this.items;
			if (items.hasOwnProperty(str))
			{
				delete items[str];
				this.item_count--;
				this.cache_valid = false;
			}
		}
	};
	ObjectSet_.prototype.clear = function (/*wipe_*/)
	{
		if (this.isEmpty())
			return;
		if (supports_set)
		{
			this.s["clear"]();			// best!
		}
		else
		{
				this.items = null;		// creates garbage; will lazy allocate on next add()
			this.item_count = 0;
		}
		this.values_cache.length = 0;
		this.cache_valid = true;
	};
	ObjectSet_.prototype.isEmpty = function ()
	{
		return this.count() === 0;
	};
	ObjectSet_.prototype.count = function ()
	{
		if (supports_set)
			return this.s["size"];
		else
			return this.item_count;
	};
	var current_arr = null;
	var current_index = 0;
	function set_append_to_arr(x)
	{
		current_arr[current_index++] = x;
	};
	ObjectSet_.prototype.update_cache = function ()
	{
		if (this.cache_valid)
			return;
		if (supports_set)
		{
			this.values_cache.length = this.s["size"];
			current_arr = this.values_cache;
			current_index = 0;
			this.s["forEach"](set_append_to_arr);
;
			current_arr = null;
			current_index = 0;
		}
		else
		{
			var values_cache = this.values_cache;
			values_cache.length = this.item_count;
			var p, n = 0, items = this.items;
			if (items)
			{
				for (p in items)
				{
					if (items.hasOwnProperty(p))
						values_cache[n++] = items[p];
				}
			}
;
		}
		this.cache_valid = true;
	};
	ObjectSet_.prototype.valuesRef = function ()
	{
		this.update_cache();
		return this.values_cache;
	};
	cr.ObjectSet = ObjectSet_;
	function KahanAdder_()
	{
		this.c = 0;
        this.y = 0;
        this.t = 0;
        this.sum = 0;
		cr.seal(this);
	};
	KahanAdder_.prototype.add = function (v)
	{
		this.y = v - this.c;
	    this.t = this.sum + this.y;
	    this.c = (this.t - this.sum) - this.y;
	    this.sum = this.t;
	};
    KahanAdder_.prototype.reset = function ()
    {
        this.c = 0;
        this.y = 0;
        this.t = 0;
        this.sum = 0;
    };
	cr.KahanAdder = KahanAdder_;
	cr.regexp_escape = function(text)
	{
		return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
	};
	function CollisionPoly_(pts_array_)
	{
		this.pts_cache = [];
		this.bboxLeft = 0;
		this.bboxTop = 0;
		this.bboxRight = 0;
		this.bboxBottom = 0;
		this.convexpolys = null;		// for physics behavior to cache separated polys
		this.set_pts(pts_array_);
		cr.seal(this);
	};
	CollisionPoly_.prototype.set_pts = function(pts_array_)
	{
		this.pts_array = pts_array_;
		this.pts_count = pts_array_.length / 2;			// x, y, x, y... in array
		this.pts_cache.length = pts_array_.length;
		this.cache_width = -1;
		this.cache_height = -1;
		this.cache_angle = 0;
	};
	CollisionPoly_.prototype.is_empty = function()
	{
		return !this.pts_array.length;
	};
	CollisionPoly_.prototype.update_bbox = function ()
	{
		var myptscache = this.pts_cache;
		var bboxLeft_ = myptscache[0];
		var bboxRight_ = bboxLeft_;
		var bboxTop_ = myptscache[1];
		var bboxBottom_ = bboxTop_;
		var x, y, i = 1, i2, len = this.pts_count;
		for ( ; i < len; ++i)
		{
			i2 = i*2;
			x = myptscache[i2];
			y = myptscache[i2+1];
			if (x < bboxLeft_)
				bboxLeft_ = x;
			if (x > bboxRight_)
				bboxRight_ = x;
			if (y < bboxTop_)
				bboxTop_ = y;
			if (y > bboxBottom_)
				bboxBottom_ = y;
		}
		this.bboxLeft = bboxLeft_;
		this.bboxRight = bboxRight_;
		this.bboxTop = bboxTop_;
		this.bboxBottom = bboxBottom_;
	};
	CollisionPoly_.prototype.set_from_rect = function(rc, offx, offy)
	{
		this.pts_cache.length = 8;
		this.pts_count = 4;
		var myptscache = this.pts_cache;
		myptscache[0] = rc.left - offx;
		myptscache[1] = rc.top - offy;
		myptscache[2] = rc.right - offx;
		myptscache[3] = rc.top - offy;
		myptscache[4] = rc.right - offx;
		myptscache[5] = rc.bottom - offy;
		myptscache[6] = rc.left - offx;
		myptscache[7] = rc.bottom - offy;
		this.cache_width = rc.right - rc.left;
		this.cache_height = rc.bottom - rc.top;
		this.update_bbox();
	};
	CollisionPoly_.prototype.set_from_quad = function(q, offx, offy, w, h)
	{
		this.pts_cache.length = 8;
		this.pts_count = 4;
		var myptscache = this.pts_cache;
		myptscache[0] = q.tlx - offx;
		myptscache[1] = q.tly - offy;
		myptscache[2] = q.trx - offx;
		myptscache[3] = q.try_ - offy;
		myptscache[4] = q.brx - offx;
		myptscache[5] = q.bry - offy;
		myptscache[6] = q.blx - offx;
		myptscache[7] = q.bly - offy;
		this.cache_width = w;
		this.cache_height = h;
		this.update_bbox();
	};
	CollisionPoly_.prototype.set_from_poly = function (r)
	{
		this.pts_count = r.pts_count;
		cr.shallowAssignArray(this.pts_cache, r.pts_cache);
		this.bboxLeft = r.bboxLeft;
		this.bboxTop - r.bboxTop;
		this.bboxRight = r.bboxRight;
		this.bboxBottom = r.bboxBottom;
	};
	CollisionPoly_.prototype.cache_poly = function(w, h, a)
	{
		if (this.cache_width === w && this.cache_height === h && this.cache_angle === a)
			return;		// cache up-to-date
		this.cache_width = w;
		this.cache_height = h;
		this.cache_angle = a;
		var i, i2, i21, len, x, y;
		var sina = 0;
		var cosa = 1;
		var myptsarray = this.pts_array;
		var myptscache = this.pts_cache;
		if (a !== 0)
		{
			sina = Math.sin(a);
			cosa = Math.cos(a);
		}
		for (i = 0, len = this.pts_count; i < len; i++)
		{
			i2 = i*2;
			i21 = i2+1;
			x = myptsarray[i2] * w;
			y = myptsarray[i21] * h;
			myptscache[i2] = (x * cosa) - (y * sina);
			myptscache[i21] = (y * cosa) + (x * sina);
		}
		this.update_bbox();
	};
	CollisionPoly_.prototype.contains_pt = function (a2x, a2y)
	{
		var myptscache = this.pts_cache;
		if (a2x === myptscache[0] && a2y === myptscache[1])
			return true;
		var i, i2, imod, len = this.pts_count;
		var a1x = this.bboxLeft - 110;
		var a1y = this.bboxTop - 101;
		var a3x = this.bboxRight + 131
		var a3y = this.bboxBottom + 120;
		var b1x, b1y, b2x, b2y;
		var count1 = 0, count2 = 0;
		for (i = 0; i < len; i++)
		{
			i2 = i*2;
			imod = ((i+1)%len)*2;
			b1x = myptscache[i2];
			b1y = myptscache[i2+1];
			b2x = myptscache[imod];
			b2y = myptscache[imod+1];
			if (cr.segments_intersect(a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y))
				count1++;
			if (cr.segments_intersect(a3x, a3y, a2x, a2y, b1x, b1y, b2x, b2y))
				count2++;
		}
		return (count1 % 2 === 1) || (count2 % 2 === 1);
	};
	CollisionPoly_.prototype.intersects_poly = function (rhs, offx, offy)
	{
		var rhspts = rhs.pts_cache;
		var mypts = this.pts_cache;
		if (this.contains_pt(rhspts[0] + offx, rhspts[1] + offy))
			return true;
		if (rhs.contains_pt(mypts[0] - offx, mypts[1] - offy))
			return true;
		var i, i2, imod, leni, j, j2, jmod, lenj;
		var a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y;
		for (i = 0, leni = this.pts_count; i < leni; i++)
		{
			i2 = i*2;
			imod = ((i+1)%leni)*2;
			a1x = mypts[i2];
			a1y = mypts[i2+1];
			a2x = mypts[imod];
			a2y = mypts[imod+1];
			for (j = 0, lenj = rhs.pts_count; j < lenj; j++)
			{
				j2 = j*2;
				jmod = ((j+1)%lenj)*2;
				b1x = rhspts[j2] + offx;
				b1y = rhspts[j2+1] + offy;
				b2x = rhspts[jmod] + offx;
				b2y = rhspts[jmod+1] + offy;
				if (cr.segments_intersect(a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y))
					return true;
			}
		}
		return false;
	};
	CollisionPoly_.prototype.intersects_segment = function (offx, offy, x1, y1, x2, y2)
	{
		var mypts = this.pts_cache;
		if (this.contains_pt(x1 - offx, y1 - offy))
			return true;
		var i, leni, i2, imod;
		var a1x, a1y, a2x, a2y;
		for (i = 0, leni = this.pts_count; i < leni; i++)
		{
			i2 = i*2;
			imod = ((i+1)%leni)*2;
			a1x = mypts[i2] + offx;
			a1y = mypts[i2+1] + offy;
			a2x = mypts[imod] + offx;
			a2y = mypts[imod+1] + offy;
			if (cr.segments_intersect(x1, y1, x2, y2, a1x, a1y, a2x, a2y))
				return true;
		}
		return false;
	};
	CollisionPoly_.prototype.mirror = function (px)
	{
		var i, leni, i2;
		for (i = 0, leni = this.pts_count; i < leni; ++i)
		{
			i2 = i*2;
			this.pts_cache[i2] = px * 2 - this.pts_cache[i2];
		}
	};
	CollisionPoly_.prototype.flip = function (py)
	{
		var i, leni, i21;
		for (i = 0, leni = this.pts_count; i < leni; ++i)
		{
			i21 = i*2+1;
			this.pts_cache[i21] = py * 2 - this.pts_cache[i21];
		}
	};
	CollisionPoly_.prototype.diag = function ()
	{
		var i, leni, i2, i21, temp;
		for (i = 0, leni = this.pts_count; i < leni; ++i)
		{
			i2 = i*2;
			i21 = i2+1;
			temp = this.pts_cache[i2];
			this.pts_cache[i2] = this.pts_cache[i21];
			this.pts_cache[i21] = temp;
		}
	};
	cr.CollisionPoly = CollisionPoly_;
	function SparseGrid_(cellwidth_, cellheight_)
	{
		this.cellwidth = cellwidth_;
		this.cellheight = cellheight_;
		this.cells = {};
	};
	SparseGrid_.prototype.totalCellCount = 0;
	SparseGrid_.prototype.getCell = function (x_, y_, create_if_missing)
	{
		var ret;
		var col = this.cells[x_];
		if (!col)
		{
			if (create_if_missing)
			{
				ret = allocGridCell(this, x_, y_);
				this.cells[x_] = {};
				this.cells[x_][y_] = ret;
				return ret;
			}
			else
				return null;
		}
		ret = col[y_];
		if (ret)
			return ret;
		else if (create_if_missing)
		{
			ret = allocGridCell(this, x_, y_);
			this.cells[x_][y_] = ret;
			return ret;
		}
		else
			return null;
	};
	SparseGrid_.prototype.XToCell = function (x_)
	{
		return cr.floor(x_ / this.cellwidth);
	};
	SparseGrid_.prototype.YToCell = function (y_)
	{
		return cr.floor(y_ / this.cellheight);
	};
	SparseGrid_.prototype.update = function (inst, oldrange, newrange)
	{
		var x, lenx, y, leny, cell;
		if (oldrange)
		{
			for (x = oldrange.left, lenx = oldrange.right; x <= lenx; ++x)
			{
				for (y = oldrange.top, leny = oldrange.bottom; y <= leny; ++y)
				{
					if (newrange && newrange.contains_pt(x, y))
						continue;	// is still in this cell
					cell = this.getCell(x, y, false);	// don't create if missing
					if (!cell)
						continue;	// cell does not exist yet
					cell.remove(inst);
					if (cell.isEmpty())
					{
						freeGridCell(cell);
						this.cells[x][y] = null;
					}
				}
			}
		}
		if (newrange)
		{
			for (x = newrange.left, lenx = newrange.right; x <= lenx; ++x)
			{
				for (y = newrange.top, leny = newrange.bottom; y <= leny; ++y)
				{
					if (oldrange && oldrange.contains_pt(x, y))
						continue;	// is still in this cell
					this.getCell(x, y, true).insert(inst);
				}
			}
		}
	};
	SparseGrid_.prototype.queryRange = function (rc, result)
	{
		var x, lenx, ystart, y, leny, cell;
		x = this.XToCell(rc.left);
		ystart = this.YToCell(rc.top);
		lenx = this.XToCell(rc.right);
		leny = this.YToCell(rc.bottom);
		for ( ; x <= lenx; ++x)
		{
			for (y = ystart; y <= leny; ++y)
			{
				cell = this.getCell(x, y, false);
				if (!cell)
					continue;
				cell.dump(result);
			}
		}
	};
	cr.SparseGrid = SparseGrid_;
	var gridcellcache = [];
	function allocGridCell(grid_, x_, y_)
	{
		var ret;
		SparseGrid_.prototype.totalCellCount++;
		if (gridcellcache.length)
		{
			ret = gridcellcache.pop();
			ret.grid = grid_;
			ret.x = x_;
			ret.y = y_;
			return ret;
		}
		else
			return new cr.GridCell(grid_, x_, y_);
	};
	function freeGridCell(c)
	{
		SparseGrid_.prototype.totalCellCount--;
		c.objects.clear();
		if (gridcellcache.length < 1000)
			gridcellcache.push(c);
	};
	function GridCell_(grid_, x_, y_)
	{
		this.grid = grid_;
		this.x = x_;
		this.y = y_;
		this.objects = new cr.ObjectSet();
	};
	GridCell_.prototype.isEmpty = function ()
	{
		return this.objects.isEmpty();
	};
	GridCell_.prototype.insert = function (inst)
	{
		this.objects.add(inst);
	};
	GridCell_.prototype.remove = function (inst)
	{
		this.objects.remove(inst);
	};
	GridCell_.prototype.dump = function (result)
	{
		cr.appendArray(result, this.objects.valuesRef());
	};
	cr.GridCell = GridCell_;
	var fxNames = [ "lighter",
					"xor",
					"copy",
					"destination-over",
					"source-in",
					"destination-in",
					"source-out",
					"destination-out",
					"source-atop",
					"destination-atop"];
	cr.effectToCompositeOp = function(effect)
	{
		if (effect <= 0 || effect >= 11)
			return "source-over";
		return fxNames[effect - 1];	// not including "none" so offset by 1
	};
	cr.setGLBlend = function(this_, effect, gl)
	{
		if (!gl)
			return;
		this_.srcBlend = gl.ONE;
		this_.destBlend = gl.ONE_MINUS_SRC_ALPHA;
		switch (effect) {
		case 1:		// lighter (additive)
			this_.srcBlend = gl.ONE;
			this_.destBlend = gl.ONE;
			break;
		case 2:		// xor
			break;	// todo
		case 3:		// copy
			this_.srcBlend = gl.ONE;
			this_.destBlend = gl.ZERO;
			break;
		case 4:		// destination-over
			this_.srcBlend = gl.ONE_MINUS_DST_ALPHA;
			this_.destBlend = gl.ONE;
			break;
		case 5:		// source-in
			this_.srcBlend = gl.DST_ALPHA;
			this_.destBlend = gl.ZERO;
			break;
		case 6:		// destination-in
			this_.srcBlend = gl.ZERO;
			this_.destBlend = gl.SRC_ALPHA;
			break;
		case 7:		// source-out
			this_.srcBlend = gl.ONE_MINUS_DST_ALPHA;
			this_.destBlend = gl.ZERO;
			break;
		case 8:		// destination-out
			this_.srcBlend = gl.ZERO;
			this_.destBlend = gl.ONE_MINUS_SRC_ALPHA;
			break;
		case 9:		// source-atop
			this_.srcBlend = gl.DST_ALPHA;
			this_.destBlend = gl.ONE_MINUS_SRC_ALPHA;
			break;
		case 10:	// destination-atop
			this_.srcBlend = gl.ONE_MINUS_DST_ALPHA;
			this_.destBlend = gl.SRC_ALPHA;
			break;
		}
	};
	cr.round6dp = function (x)
	{
		return cr.round(x * 1000000) / 1000000;
	};
	/*
	var localeCompare_options = {
		"usage": "search",
		"sensitivity": "accent"
	};
	var has_localeCompare = !!"a".localeCompare;
	var localeCompare_works1 = (has_localeCompare && "a".localeCompare("A", undefined, localeCompare_options) === 0);
	var localeCompare_works2 = (has_localeCompare && "a".localeCompare("á", undefined, localeCompare_options) !== 0);
	var supports_localeCompare = (has_localeCompare && localeCompare_works1 && localeCompare_works2);
	*/
	cr.equals_nocase = function (a, b)
	{
		if (typeof a !== "string" || typeof b !== "string")
			return false;
		if (a.length !== b.length)
			return false;
		if (a === b)
			return true;
		/*
		if (supports_localeCompare)
		{
			return (a.localeCompare(b, undefined, localeCompare_options) === 0);
		}
		else
		{
		*/
			return a.toLowerCase() === b.toLowerCase();
	};
}());
;
(function()
{
	function Runtime(canvas)
	{
		if (!canvas || (!canvas.getContext && !canvas["dc"]))
			return;
		if (canvas["c2runtime"])
			return;
		else
			canvas["c2runtime"] = this;
		var self = this;
		this.isCrosswalk = /crosswalk/i.test(navigator.userAgent) || /xwalk/i.test(navigator.userAgent) || !!(typeof window["c2isCrosswalk"] !== "undefined" && window["c2isCrosswalk"]);
		this.isPhoneGap = (!this.isCrosswalk && (typeof window["device"] !== "undefined" && (typeof window["device"]["cordova"] !== "undefined" || typeof window["device"]["phonegap"] !== "undefined")));
		this.isDirectCanvas = !!canvas["dc"];
		this.isAppMobi = (typeof window["AppMobi"] !== "undefined" || this.isDirectCanvas);
		this.isCocoonJs = !!window["c2cocoonjs"];
		this.isEjecta = !!window["c2ejecta"];
		if (this.isCocoonJs)
		{
			CocoonJS["App"]["onSuspended"].addEventListener(function() {
				self["setSuspended"](true);
			});
			CocoonJS["App"]["onActivated"].addEventListener(function () {
				self["setSuspended"](false);
			});
		}
		if (this.isEjecta)
		{
			document.addEventListener("pagehide", function() {
				self["setSuspended"](true);
			});
			document.addEventListener("pageshow", function() {
				self["setSuspended"](false);
			});
			document.addEventListener("resize", function () {
				self["setSize"](window.innerWidth, window.innerHeight);
			});
		}
		this.isDomFree = (this.isDirectCanvas || this.isCocoonJs || this.isEjecta);
		this.isTizen = /tizen/i.test(navigator.userAgent);
		this.isAndroid = /android/i.test(navigator.userAgent) && !this.isTizen;		// tizen says "like Android"
		this.isIE = /msie/i.test(navigator.userAgent) || /trident/i.test(navigator.userAgent);
		this.isiPhone = /iphone/i.test(navigator.userAgent) || /ipod/i.test(navigator.userAgent);	// treat ipod as an iphone
		this.isiPad = /ipad/i.test(navigator.userAgent);
		this.isiOS = this.isiPhone || this.isiPad || this.isEjecta;
		this.isiPhoneiOS6 = (this.isiPhone && /os\s6/i.test(navigator.userAgent));
		this.isChrome = /chrome/i.test(navigator.userAgent) || /chromium/i.test(navigator.userAgent);
		this.isAmazonWebApp = /amazonwebappplatform/i.test(navigator.userAgent);
		this.isFirefox = /firefox/i.test(navigator.userAgent);
		this.isSafari = !this.isChrome && /safari/i.test(navigator.userAgent);		// Chrome includes Safari in UA
		this.isWindows = /windows/i.test(navigator.userAgent);
		this.isNodeWebkit = (typeof window["c2nodewebkit"] !== "undefined" || /nodewebkit/i.test(navigator.userAgent));
		this.isArcade = (typeof window["is_scirra_arcade"] !== "undefined");
		this.isWindows8App = !!(typeof window["c2isWindows8"] !== "undefined" && window["c2isWindows8"]);
		this.isWindows8Capable = !!(typeof window["c2isWindows8Capable"] !== "undefined" && window["c2isWindows8Capable"]);
		this.isWindowsPhone8 = !!(typeof window["c2isWindowsPhone8"] !== "undefined" && window["c2isWindowsPhone8"]);
		this.isWindowsPhone81 = !!(typeof window["c2isWindowsPhone81"] !== "undefined" && window["c2isWindowsPhone81"]);
		this.isWinJS = (this.isWindows8App || this.isWindows8Capable || this.isWindowsPhone81);	// note not WP8.0
		this.isBlackberry10 = !!(typeof window["c2isBlackberry10"] !== "undefined" && window["c2isBlackberry10"]);
		this.isAndroidStockBrowser = (this.isAndroid && !this.isChrome && !this.isFirefox && !this.isAmazonWebApp && !this.isDomFree);
		this.devicePixelRatio = 1;
		this.isMobile = (this.isPhoneGap || this.isCrosswalk || this.isAppMobi || this.isCocoonJs || this.isAndroid || this.isiOS || this.isWindowsPhone8 || this.isWindowsPhone81 || this.isBlackberry10 || this.isTizen || this.isEjecta);
		if (!this.isMobile)
		{
			this.isMobile = /(blackberry|bb10|playbook|palm|symbian|nokia|windows\s+ce|phone|mobile|tablet|kindle|silk)/i.test(navigator.userAgent);
		}
		if (typeof cr_is_preview !== "undefined" && !this.isNodeWebkit && (window.location.search === "?nw" || /nodewebkit/i.test(navigator.userAgent)))
		{
			this.isNodeWebkit = true;
		}
		this.isDebug = (typeof cr_is_preview !== "undefined" && window.location.search.indexOf("debug") > -1)
		this.canvas = canvas;
		this.canvasdiv = document.getElementById("c2canvasdiv");
		this.gl = null;
		this.glwrap = null;
		this.ctx = null;
		this.fullscreenOldMarginCss = "";
		this.firstInFullscreen = false;
		this.oldWidth = 0;		// for restoring non-fullscreen canvas after fullscreen
		this.oldHeight = 0;
		this.canvas.oncontextmenu = function (e) { if (e.preventDefault) e.preventDefault(); return false; };
		this.canvas.onselectstart = function (e) { if (e.preventDefault) e.preventDefault(); return false; };
		if (this.isDirectCanvas)
			window["c2runtime"] = this;
		if (this.isNodeWebkit)
		{
			window.ondragover = function(e) { e.preventDefault(); return false; };
			window.ondrop = function(e) { e.preventDefault(); return false; };
			require("nw.gui")["App"]["clearCache"]();
		}
		this.width = canvas.width;
		this.height = canvas.height;
		this.draw_width = this.width;
		this.draw_height = this.height;
		this.cssWidth = this.width;
		this.cssHeight = this.height;
		this.lastWindowWidth = window.innerWidth;
		this.lastWindowHeight = window.innerHeight;
		this.redraw = true;
		this.isSuspended = false;
		if (!Date.now) {
		  Date.now = function now() {
			return +new Date();
		  };
		}
		this.plugins = [];
		this.types = {};
		this.types_by_index = [];
		this.behaviors = [];
		this.layouts = {};
		this.layouts_by_index = [];
		this.eventsheets = {};
		this.eventsheets_by_index = [];
		this.wait_for_textures = [];        // for blocking until textures loaded
		this.triggers_to_postinit = [];
		this.all_global_vars = [];
		this.all_local_vars = [];
		this.solidBehavior = null;
		this.jumpthruBehavior = null;
		this.deathRow = new cr.ObjectSet();
		this.isInClearDeathRow = false;
		this.isInOnDestroy = 0;					// needs to support recursion so increments and decrements and is true if > 0
		this.isRunningEvents = false;
		this.createRow = [];
		this.isLoadingState = false;
		this.saveToSlot = "";
		this.loadFromSlot = "";
		this.loadFromJson = "";
		this.lastSaveJson = "";
		this.signalledContinuousPreview = false;
		this.suspendDrawing = false;		// for hiding display until continuous preview loads
		this.dt = 0;
        this.dt1 = 0;
		this.logictime = 0;			// used to calculate CPUUtilisation
		this.cpuutilisation = 0;
		this.zeroDtCount = 0;
        this.timescale = 1.0;
        this.kahanTime = new cr.KahanAdder();
		this.last_tick_time = 0;
		this.measuring_dt = true;
		this.fps = 0;
		this.last_fps_time = 0;
		this.tickcount = 0;
		this.execcount = 0;
		this.framecount = 0;        // for fps
		this.objectcount = 0;
		this.changelayout = null;
		this.destroycallbacks = [];
		this.event_stack = [];
		this.event_stack_index = -1;
		this.localvar_stack = [[]];
		this.localvar_stack_index = 0;
		this.trigger_depth = 0;		// recursion depth for triggers
		this.pushEventStack(null);
		this.loop_stack = [];
		this.loop_stack_index = -1;
		this.next_uid = 0;
		this.next_puid = 0;		// permanent unique ids
		this.layout_first_tick = true;
		this.family_count = 0;
		this.suspend_events = [];
		this.raf_id = -1;
		this.timeout_id = -1;
		this.isloading = true;
		this.loadingprogress = 0;
		this.isNodeFullscreen = false;
		this.stackLocalCount = 0;	// number of stack-based local vars for recursion
		this.halfFramerateMode = false;
		this.lastRafTime = 0;		// time of last requestAnimationFrame call
		this.ranLastRaf = false;	// false if last requestAnimationFrame was skipped for half framerate mode
		this.had_a_click = false;
		this.isInUserInputEvent = false;
        this.objects_to_tick = new cr.ObjectSet();
		this.objects_to_tick2 = new cr.ObjectSet();
		this.registered_collisions = [];
		this.temp_poly = new cr.CollisionPoly([]);
		this.temp_poly2 = new cr.CollisionPoly([]);
		this.allGroups = [];				// array of all event groups
        this.groups_by_name = {};
		this.cndsBySid = {};
		this.actsBySid = {};
		this.varsBySid = {};
		this.blocksBySid = {};
		this.running_layout = null;			// currently running layout
		this.layer_canvas = null;			// for layers "render-to-texture"
		this.layer_ctx = null;
		this.layer_tex = null;
		this.layout_tex = null;
		this.layout_canvas = null;
		this.layout_ctx = null;
		this.is_WebGL_context_lost = false;
		this.uses_background_blending = false;	// if any shader uses background blending, so entire layout renders to texture
		this.fx_tex = [null, null];
		this.fullscreen_scaling = 0;
		this.files_subfolder = "";			// path with project files
		this.objectsByUid = {};				// maps every in-use UID (as a string) to its instance
		this.loaderlogo = null;
		this.snapshotCanvas = null;
		this.snapshotData = "";
		this.load();
		this.isRetina = ((!this.isDomFree || this.isEjecta) && this.useHighDpi && !this.isAndroidStockBrowser);
		this.devicePixelRatio = (this.isRetina ? (window["devicePixelRatio"] || window["webkitDevicePixelRatio"] || window["mozDevicePixelRatio"] || window["msDevicePixelRatio"] || 1) : 1);
		this.ClearDeathRow();
		var attribs;
		var alpha_canvas = this.alphaBackground && !(this.isNodeWebkit || this.isWinJS || this.isWindowsPhone8 || this.isCrosswalk);
		if (this.fullscreen_mode > 0)
			this["setSize"](window.innerWidth, window.innerHeight, true);
		try {
			if (this.enableWebGL && (this.isCocoonJs || this.isEjecta || !this.isDomFree))
			{
				attribs = {
					"alpha": alpha_canvas,
					"depth": false,
					"antialias": false,
					"failIfMajorPerformanceCaveat": true
				};
				this.gl = (canvas.getContext("webgl", attribs) || canvas.getContext("experimental-webgl", attribs));
			}
		}
		catch (e) {
		}
		if (this.gl)
		{
;
			if (!this.isDomFree)
			{
				this.overlay_canvas = document.createElement("canvas");
				jQuery(this.overlay_canvas).appendTo(this.canvas.parentNode);
				this.overlay_canvas.oncontextmenu = function (e) { return false; };
				this.overlay_canvas.onselectstart = function (e) { return false; };
				this.overlay_canvas.width = this.cssWidth;
				this.overlay_canvas.height = this.cssHeight;
				jQuery(this.overlay_canvas).css({"width": this.cssWidth + "px",
												"height": this.cssHeight + "px"});
				this.positionOverlayCanvas();
				this.overlay_ctx = this.overlay_canvas.getContext("2d");
			}
			this.glwrap = new cr.GLWrap(this.gl, this.isMobile);
			this.glwrap.setSize(canvas.width, canvas.height);
			this.ctx = null;
			this.canvas.addEventListener("webglcontextlost", function (ev) {
				ev.preventDefault();
				self.onContextLost();
				console.log("[Construct 2] WebGL context lost");
				window["cr_setSuspended"](true);		// stop rendering
			}, false);
			this.canvas.addEventListener("webglcontextrestored", function (ev) {
				self.glwrap.initState();
				self.glwrap.setSize(self.glwrap.width, self.glwrap.height, true);
				self.layer_tex = null;
				self.layout_tex = null;
				self.fx_tex[0] = null;
				self.fx_tex[1] = null;
				self.onContextRestored();
				self.redraw = true;
				console.log("[Construct 2] WebGL context restored");
				window["cr_setSuspended"](false);		// resume rendering
			}, false);
			var i, len, j, lenj, k, lenk, t, s, l, y;
			for (i = 0, len = this.types_by_index.length; i < len; i++)
			{
				t = this.types_by_index[i];
				for (j = 0, lenj = t.effect_types.length; j < lenj; j++)
				{
					s = t.effect_types[j];
					s.shaderindex = this.glwrap.getShaderIndex(s.id);
					this.uses_background_blending = this.uses_background_blending || this.glwrap.programUsesDest(s.shaderindex);
				}
			}
			for (i = 0, len = this.layouts_by_index.length; i < len; i++)
			{
				l = this.layouts_by_index[i];
				for (j = 0, lenj = l.effect_types.length; j < lenj; j++)
				{
					s = l.effect_types[j];
					s.shaderindex = this.glwrap.getShaderIndex(s.id);
				}
				for (j = 0, lenj = l.layers.length; j < lenj; j++)
				{
					y = l.layers[j];
					for (k = 0, lenk = y.effect_types.length; k < lenk; k++)
					{
						s = y.effect_types[k];
						s.shaderindex = this.glwrap.getShaderIndex(s.id);
						this.uses_background_blending = this.uses_background_blending || this.glwrap.programUsesDest(s.shaderindex);
					}
				}
			}
		}
		else
		{
			if (this.fullscreen_mode > 0 && this.isDirectCanvas)
			{
;
				this.canvas = null;
				document.oncontextmenu = function (e) { return false; };
				document.onselectstart = function (e) { return false; };
				this.ctx = AppMobi["canvas"]["getContext"]("2d");
				try {
					this.ctx["samplingMode"] = this.linearSampling ? "smooth" : "sharp";
					this.ctx["globalScale"] = 1;
					this.ctx["HTML5CompatibilityMode"] = true;
					this.ctx["imageSmoothingEnabled"] = this.linearSampling;
				} catch(e){}
				if (this.width !== 0 && this.height !== 0)
				{
					this.ctx.width = this.width;
					this.ctx.height = this.height;
				}
			}
			if (!this.ctx)
			{
;
				if (this.isCocoonJs)
				{
					attribs = {
						"antialias": !!this.linearSampling,
						"alpha": alpha_canvas
					};
					this.ctx = canvas.getContext("2d", attribs);
				}
				else
				{
					attribs = {
						"alpha": alpha_canvas
					};
					this.ctx = canvas.getContext("2d", attribs);
				}
				this.ctx["webkitImageSmoothingEnabled"] = this.linearSampling;
				this.ctx["mozImageSmoothingEnabled"] = this.linearSampling;
				this.ctx["msImageSmoothingEnabled"] = this.linearSampling;
				this.ctx["imageSmoothingEnabled"] = this.linearSampling;
			}
			this.overlay_canvas = null;
			this.overlay_ctx = null;
		}
		this.tickFunc = function () { self.tick(false); };
		if (window != window.top && !this.isDomFree && !this.isWinJS && !this.isWindowsPhone8)
		{
			document.addEventListener("mousedown", function () {
				window.focus();
			}, true);
			document.addEventListener("touchstart", function () {
				window.focus();
			}, true);
		}
		if (typeof cr_is_preview !== "undefined")
		{
			if (this.isCocoonJs)
				console.log("[Construct 2] In preview-over-wifi via CocoonJS mode");
			if (window.location.search.indexOf("continuous") > -1)
			{
				cr.logexport("Reloading for continuous preview");
				this.loadFromSlot = "__c2_continuouspreview";
				this.suspendDrawing = true;
			}
			if (this.pauseOnBlur && !this.isMobile)
			{
				jQuery(window).focus(function ()
				{
					self["setSuspended"](false);
				});
				jQuery(window).blur(function ()
				{
					self["setSuspended"](true);
				});
			}
		}
		if (this.fullscreen_mode === 0 && this.isRetina && this.devicePixelRatio > 1)
		{
			this["setSize"](this.original_width, this.original_height, true);
		}
		this.tryLockOrientation();
		this.go();			// run loading screen
		this.extra = {};
		cr.seal(this);
	};
	var webkitRepaintFlag = false;
	Runtime.prototype["setSize"] = function (w, h, force)
	{
		var offx = 0, offy = 0;
		var neww = 0, newh = 0, intscale = 0;
		var tryHideAddressBar = (this.isiPhoneiOS6 && this.isSafari && !navigator["standalone"] && !this.isDomFree && !this.isPhoneGap);
		if (tryHideAddressBar)
			h += 60;		// height of Safari iPhone iOS 6 address bar
		if (this.lastWindowWidth === w && this.lastWindowHeight === h && !force)
			return;
		this.lastWindowWidth = w;
		this.lastWindowHeight = h;
		var mode = this.fullscreen_mode;
		var orig_aspect, cur_aspect;
		var isfullscreen = (document["mozFullScreen"] || document["webkitIsFullScreen"] || !!document["msFullscreenElement"] || document["fullScreen"] || this.isNodeFullscreen);
		if (!isfullscreen && this.fullscreen_mode === 0 && !force)
			return;			// ignore size events when not fullscreen and not using a fullscreen-in-browser mode
		if (isfullscreen && this.fullscreen_scaling > 0)
			mode = this.fullscreen_scaling;
		if (mode >= 4)
		{
			orig_aspect = this.original_width / this.original_height;
			cur_aspect = w / h;
			if (cur_aspect > orig_aspect)
			{
				neww = h * orig_aspect;
				if (mode === 5)	// integer scaling
				{
					intscale = neww / this.original_width;
					if (intscale > 1)
						intscale = Math.floor(intscale);
					else if (intscale < 1)
						intscale = 1 / Math.ceil(1 / intscale);
					neww = this.original_width * intscale;
					newh = this.original_height * intscale;
					offx = (w - neww) / 2;
					offy = (h - newh) / 2;
					w = neww;
					h = newh;
				}
				else
				{
					offx = (w - neww) / 2;
					w = neww;
				}
			}
			else
			{
				newh = w / orig_aspect;
				if (mode === 5)	// integer scaling
				{
					intscale = newh / this.original_height;
					if (intscale > 1)
						intscale = Math.floor(intscale);
					else if (intscale < 1)
						intscale = 1 / Math.ceil(1 / intscale);
					neww = this.original_width * intscale;
					newh = this.original_height * intscale;
					offx = (w - neww) / 2;
					offy = (h - newh) / 2;
					w = neww;
					h = newh;
				}
				else
				{
					offy = (h - newh) / 2;
					h = newh;
				}
			}
			if (isfullscreen && !this.isNodeWebkit)
			{
				offx = 0;
				offy = 0;
			}
			offx = Math.floor(offx);
			offy = Math.floor(offy);
			w = Math.floor(w);
			h = Math.floor(h);
		}
		else if (this.isNodeWebkit && this.isNodeFullscreen && this.fullscreen_mode_set === 0)
		{
			offx = Math.floor((w - this.original_width) / 2);
			offy = Math.floor((h - this.original_height) / 2);
			w = this.original_width;
			h = this.original_height;
		}
		if (mode < 2)
			this.aspect_scale = this.devicePixelRatio;
		if (this.isRetina && this.isiPad && this.devicePixelRatio > 1)	// don't apply to iPad 1-2
		{
			if (w >= 1024)
				w = 1023;		// 2046 retina pixels
			if (h >= 1024)
				h = 1023;
		}
		var multiplier = this.devicePixelRatio;
		this.cssWidth = w;
		this.cssHeight = h;
		this.width = Math.round(w * multiplier);
		this.height = Math.round(h * multiplier);
		this.redraw = true;
		if (this.wantFullscreenScalingQuality)
		{
			this.draw_width = this.width;
			this.draw_height = this.height;
			this.fullscreenScalingQuality = true;
		}
		else
		{
			if ((this.width < this.original_width && this.height < this.original_height) || mode === 1)
			{
				this.draw_width = this.width;
				this.draw_height = this.height;
				this.fullscreenScalingQuality = true;
			}
			else
			{
				this.draw_width = this.original_width;
				this.draw_height = this.original_height;
				this.fullscreenScalingQuality = false;
				/*var orig_aspect = this.original_width / this.original_height;
				var cur_aspect = this.width / this.height;
				if ((this.fullscreen_mode !== 2 && cur_aspect > orig_aspect) || (this.fullscreen_mode === 2 && cur_aspect < orig_aspect))
					this.aspect_scale = this.height / this.original_height;
				else
					this.aspect_scale = this.width / this.original_width;*/
				if (mode === 2)		// scale inner
				{
					orig_aspect = this.original_width / this.original_height;
					cur_aspect = this.lastWindowWidth / this.lastWindowHeight;
					if (cur_aspect < orig_aspect)
						this.draw_width = this.draw_height * cur_aspect;
					else if (cur_aspect > orig_aspect)
						this.draw_height = this.draw_width / cur_aspect;
				}
				else if (mode === 3)
				{
					orig_aspect = this.original_width / this.original_height;
					cur_aspect = this.lastWindowWidth / this.lastWindowHeight;
					if (cur_aspect > orig_aspect)
						this.draw_width = this.draw_height * cur_aspect;
					else if (cur_aspect < orig_aspect)
						this.draw_height = this.draw_width / cur_aspect;
				}
			}
		}
		if (this.canvasdiv && !this.isDomFree)
		{
			jQuery(this.canvasdiv).css({"width": w + "px",
										"height": h + "px",
										"margin-left": offx,
										"margin-top": offy});
			if (typeof cr_is_preview !== "undefined")
			{
				jQuery("#borderwrap").css({"width": w + "px",
											"height": h + "px"});
			}
		}
		if (this.canvas)
		{
			this.canvas.width = Math.round(w * multiplier);
			this.canvas.height = Math.round(h * multiplier);
			if (this.isEjecta)
			{
				this.canvas.style.left = offx + "px";
				this.canvas.style.top = offy + "px";
				this.canvas.style.width = w + "px";
				this.canvas.style.height = h + "px";
			}
			else if (this.isRetina && !this.isDomFree)
			{
				jQuery(this.canvas).css({"width": w + "px",
										"height": h + "px"});
			}
		}
		if (this.overlay_canvas)
		{
			this.overlay_canvas.width = w;
			this.overlay_canvas.height = h;
			jQuery(this.overlay_canvas).css({"width": w + "px",
											"height": h + "px"});
		}
		if (this.glwrap)
		{
			this.glwrap.setSize(Math.round(w * multiplier), Math.round(h * multiplier));
		}
		if (this.isDirectCanvas && this.ctx)
		{
			this.ctx.width = w;
			this.ctx.height = h;
		}
		if (this.ctx)
		{
			this.ctx["webkitImageSmoothingEnabled"] = this.linearSampling;
			this.ctx["mozImageSmoothingEnabled"] = this.linearSampling;
			this.ctx["msImageSmoothingEnabled"] = this.linearSampling;
			this.ctx["imageSmoothingEnabled"] = this.linearSampling;
		}
		this.tryLockOrientation();
		if (!this.isDomFree && (tryHideAddressBar || this.isiPhone))
		{
			window.setTimeout(function () {
				window.scrollTo(0, 1);
			}, 100);
		}
	};
	Runtime.prototype.tryLockOrientation = function ()
	{
		if (!this.autoLockOrientation || this.orientations === 0)
			return;
		var orientation = "portrait";
		if (this.orientations === 2)
			orientation = "landscape";
		if (screen["lockOrientation"])
			screen["lockOrientation"](orientation);
		else if (screen["webkitLockOrientation"])
			screen["webkitLockOrientation"](orientation);
		else if (screen["mozLockOrientation"])
			screen["mozLockOrientation"](orientation);
		else if (screen["msLockOrientation"])
			screen["msLockOrientation"](orientation);
	};
	Runtime.prototype.onContextLost = function ()
	{
		this.is_WebGL_context_lost = true;
		var i, len, t;
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			t = this.types_by_index[i];
			if (t.onLostWebGLContext)
				t.onLostWebGLContext();
		}
	};
	Runtime.prototype.onContextRestored = function ()
	{
		this.is_WebGL_context_lost = false;
		var i, len, t;
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			t = this.types_by_index[i];
			if (t.onRestoreWebGLContext)
				t.onRestoreWebGLContext();
		}
	};
	Runtime.prototype.positionOverlayCanvas = function()
	{
		if (this.isDomFree)
			return;
		var isfullscreen = (document["mozFullScreen"] || document["webkitIsFullScreen"] || document["fullScreen"] || !!document["msFullscreenElement"] || this.isNodeFullscreen);
		var overlay_position = isfullscreen ? jQuery(this.canvas).offset() : jQuery(this.canvas).position();
		overlay_position.position = "absolute";
		jQuery(this.overlay_canvas).css(overlay_position);
	};
	var caf = window["cancelAnimationFrame"] ||
	  window["mozCancelAnimationFrame"]    ||
	  window["webkitCancelAnimationFrame"] ||
	  window["msCancelAnimationFrame"]     ||
	  window["oCancelAnimationFrame"];
	Runtime.prototype["setSuspended"] = function (s)
	{
		var i, len;
		if (s && !this.isSuspended)
		{
			cr.logexport("[Construct 2] Suspending");
			this.isSuspended = true;			// next tick will be last
			if (this.raf_id !== -1 && caf)		// note: CocoonJS does not implement cancelAnimationFrame
				caf(this.raf_id);
			if (this.timeout_id !== -1)
				clearTimeout(this.timeout_id);
			for (i = 0, len = this.suspend_events.length; i < len; i++)
				this.suspend_events[i](true);
		}
		else if (!s && this.isSuspended)
		{
			cr.logexport("[Construct 2] Resuming");
			this.isSuspended = false;
			this.last_tick_time = cr.performance_now();	// ensure first tick is a zero-dt one
			this.last_fps_time = cr.performance_now();	// reset FPS counter
			this.framecount = 0;
			this.logictime = 0;
			for (i = 0, len = this.suspend_events.length; i < len; i++)
				this.suspend_events[i](false);
			this.tick(false);						// kick off runtime again
		}
	};
	Runtime.prototype.addSuspendCallback = function (f)
	{
		this.suspend_events.push(f);
	};
	Runtime.prototype.load = function ()
	{
;
		var pm = cr.getProjectModel();
		this.name = pm[0];
		this.first_layout = pm[1];
		this.fullscreen_mode = pm[11];	// 0 = off, 1 = crop, 2 = scale inner, 3 = scale outer, 4 = letterbox scale, 5 = integer letterbox scale
		this.fullscreen_mode_set = pm[11];
		this.original_width = pm[9];
		this.original_height = pm[10];
		this.parallax_x_origin = this.original_width / 2;
		this.parallax_y_origin = this.original_height / 2;
		if (this.isDomFree && !this.isEjecta && (pm[11] >= 4 || pm[11] === 0))
		{
			cr.logexport("[Construct 2] Letterbox scale fullscreen modes are not supported on this platform - falling back to 'Scale outer'");
			this.fullscreen_mode = 3;
			this.fullscreen_mode_set = 3;
		}
		this.uses_loader_layout = pm[17];
		this.loaderstyle = pm[18];
		if (this.loaderstyle === 0)
		{
			this.loaderlogo = new Image();
			this.loaderlogo.src = "loading-logo.png";
		}
		this.next_uid = pm[20];
		this.system = new cr.system_object(this);
		var i, len, j, lenj, k, lenk, idstr, m, b, t, f;
		var plugin, plugin_ctor;
		for (i = 0, len = pm[2].length; i < len; i++)
		{
			m = pm[2][i];
;
			cr.add_common_aces(m);
			plugin = new m[0](this);
			plugin.singleglobal = m[1];
			plugin.is_world = m[2];
			plugin.must_predraw = m[9];
			if (plugin.onCreate)
				plugin.onCreate();  // opportunity to override default ACEs
			cr.seal(plugin);
			this.plugins.push(plugin);
		}
		pm = cr.getProjectModel();
		for (i = 0, len = pm[3].length; i < len; i++)
		{
			m = pm[3][i];
			plugin_ctor = m[1];
;
			plugin = null;
			for (j = 0, lenj = this.plugins.length; j < lenj; j++)
			{
				if (this.plugins[j] instanceof plugin_ctor)
				{
					plugin = this.plugins[j];
					break;
				}
			}
;
;
			var type_inst = new plugin.Type(plugin);
;
			type_inst.name = m[0];
			type_inst.is_family = m[2];
			type_inst.instvar_sids = m[3].slice(0);
			type_inst.vars_count = m[3].length;
			type_inst.behs_count = m[4];
			type_inst.fx_count = m[5];
			type_inst.sid = m[11];
			if (type_inst.is_family)
			{
				type_inst.members = [];				// types in this family
				type_inst.family_index = this.family_count++;
				type_inst.families = null;
			}
			else
			{
				type_inst.members = null;
				type_inst.family_index = -1;
				type_inst.families = [];			// families this type belongs to
			}
			type_inst.family_var_map = null;
			type_inst.family_beh_map = null;
			type_inst.family_fx_map = null;
			type_inst.is_contained = false;
			type_inst.container = null;
			if (m[6])
			{
				type_inst.texture_file = m[6][0];
				type_inst.texture_filesize = m[6][1];
				type_inst.texture_pixelformat = m[6][2];
			}
			else
			{
				type_inst.texture_file = null;
				type_inst.texture_filesize = 0;
				type_inst.texture_pixelformat = 0;		// rgba8
			}
			if (m[7])
			{
				type_inst.animations = m[7];
			}
			else
			{
				type_inst.animations = null;
			}
			type_inst.index = i;                                // save index in to types array in type
			type_inst.instances = [];                           // all instances of this type
			type_inst.deadCache = [];							// destroyed instances to recycle next create
			type_inst.solstack = [new cr.selection(type_inst)]; // initialise SOL stack with one empty SOL
			type_inst.cur_sol = 0;
			type_inst.default_instance = null;
			type_inst.default_layerindex = 0;
			type_inst.stale_iids = true;
			type_inst.updateIIDs = cr.type_updateIIDs;
			type_inst.getFirstPicked = cr.type_getFirstPicked;
			type_inst.getPairedInstance = cr.type_getPairedInstance;
			type_inst.getCurrentSol = cr.type_getCurrentSol;
			type_inst.pushCleanSol = cr.type_pushCleanSol;
			type_inst.pushCopySol = cr.type_pushCopySol;
			type_inst.popSol = cr.type_popSol;
			type_inst.getBehaviorByName = cr.type_getBehaviorByName;
			type_inst.getBehaviorIndexByName = cr.type_getBehaviorIndexByName;
			type_inst.getEffectIndexByName = cr.type_getEffectIndexByName;
			type_inst.applySolToContainer = cr.type_applySolToContainer;
			type_inst.getInstanceByIID = cr.type_getInstanceByIID;
			type_inst.collision_grid = new cr.SparseGrid(this.original_width, this.original_height);
			type_inst.any_cell_changed = true;
			type_inst.any_instance_parallaxed = false;
			type_inst.extra = {};
			type_inst.toString = cr.type_toString;
			type_inst.behaviors = [];
			for (j = 0, lenj = m[8].length; j < lenj; j++)
			{
				b = m[8][j];
				var behavior_ctor = b[1];
				var behavior_plugin = null;
				for (k = 0, lenk = this.behaviors.length; k < lenk; k++)
				{
					if (this.behaviors[k] instanceof behavior_ctor)
					{
						behavior_plugin = this.behaviors[k];
						break;
					}
				}
				if (!behavior_plugin)
				{
					behavior_plugin = new behavior_ctor(this);
					behavior_plugin.my_types = [];						// types using this behavior
					behavior_plugin.my_instances = new cr.ObjectSet(); 	// instances of this behavior
					if (behavior_plugin.onCreate)
						behavior_plugin.onCreate();
					cr.seal(behavior_plugin);
					this.behaviors.push(behavior_plugin);
					if (cr.behaviors.solid && behavior_plugin instanceof cr.behaviors.solid)
						this.solidBehavior = behavior_plugin;
					if (cr.behaviors.jumpthru && behavior_plugin instanceof cr.behaviors.jumpthru)
						this.jumpthruBehavior = behavior_plugin;
				}
				if (behavior_plugin.my_types.indexOf(type_inst) === -1)
					behavior_plugin.my_types.push(type_inst);
				var behavior_type = new behavior_plugin.Type(behavior_plugin, type_inst);
				behavior_type.name = b[0];
				behavior_type.sid = b[2];
				behavior_type.onCreate();
				cr.seal(behavior_type);
				type_inst.behaviors.push(behavior_type);
			}
			type_inst.global = m[9];
			type_inst.isOnLoaderLayout = m[10];
			type_inst.effect_types = [];
			for (j = 0, lenj = m[12].length; j < lenj; j++)
			{
				type_inst.effect_types.push({
					id: m[12][j][0],
					name: m[12][j][1],
					shaderindex: -1,
					active: true,
					index: j
				});
			}
			type_inst.tile_poly_data = m[13];
			if (!this.uses_loader_layout || type_inst.is_family || type_inst.isOnLoaderLayout || !plugin.is_world)
			{
				type_inst.onCreate();
				cr.seal(type_inst);
			}
			if (type_inst.name)
				this.types[type_inst.name] = type_inst;
			this.types_by_index.push(type_inst);
			if (plugin.singleglobal)
			{
				var instance = new plugin.Instance(type_inst);
				instance.uid = this.next_uid++;
				instance.puid = this.next_puid++;
				instance.iid = 0;
				instance.get_iid = cr.inst_get_iid;
				instance.toString = cr.inst_toString;
				instance.properties = m[14];
				instance.onCreate();
				cr.seal(instance);
				type_inst.instances.push(instance);
				this.objectsByUid[instance.uid.toString()] = instance;
			}
		}
		for (i = 0, len = pm[4].length; i < len; i++)
		{
			var familydata = pm[4][i];
			var familytype = this.types_by_index[familydata[0]];
			var familymember;
			for (j = 1, lenj = familydata.length; j < lenj; j++)
			{
				familymember = this.types_by_index[familydata[j]];
				familymember.families.push(familytype);
				familytype.members.push(familymember);
			}
		}
		for (i = 0, len = pm[23].length; i < len; i++)
		{
			var containerdata = pm[23][i];
			var containertypes = [];
			for (j = 0, lenj = containerdata.length; j < lenj; j++)
				containertypes.push(this.types_by_index[containerdata[j]]);
			for (j = 0, lenj = containertypes.length; j < lenj; j++)
			{
				containertypes[j].is_contained = true;
				containertypes[j].container = containertypes;
			}
		}
		if (this.family_count > 0)
		{
			for (i = 0, len = this.types_by_index.length; i < len; i++)
			{
				t = this.types_by_index[i];
				if (t.is_family || !t.families.length)
					continue;
				t.family_var_map = new Array(this.family_count);
				t.family_beh_map = new Array(this.family_count);
				t.family_fx_map = new Array(this.family_count);
				var all_fx = [];
				var varsum = 0;
				var behsum = 0;
				var fxsum = 0;
				for (j = 0, lenj = t.families.length; j < lenj; j++)
				{
					f = t.families[j];
					t.family_var_map[f.family_index] = varsum;
					varsum += f.vars_count;
					t.family_beh_map[f.family_index] = behsum;
					behsum += f.behs_count;
					t.family_fx_map[f.family_index] = fxsum;
					fxsum += f.fx_count;
					for (k = 0, lenk = f.effect_types.length; k < lenk; k++)
						all_fx.push(cr.shallowCopy({}, f.effect_types[k]));
				}
				t.effect_types = all_fx.concat(t.effect_types);
				for (j = 0, lenj = t.effect_types.length; j < lenj; j++)
					t.effect_types[j].index = j;
			}
		}
		for (i = 0, len = pm[5].length; i < len; i++)
		{
			m = pm[5][i];
			var layout = new cr.layout(this, m);
			cr.seal(layout);
			this.layouts[layout.name] = layout;
			this.layouts_by_index.push(layout);
		}
		for (i = 0, len = pm[6].length; i < len; i++)
		{
			m = pm[6][i];
			var sheet = new cr.eventsheet(this, m);
			cr.seal(sheet);
			this.eventsheets[sheet.name] = sheet;
			this.eventsheets_by_index.push(sheet);
		}
		for (i = 0, len = this.eventsheets_by_index.length; i < len; i++)
			this.eventsheets_by_index[i].postInit();
		for (i = 0, len = this.eventsheets_by_index.length; i < len; i++)
			this.eventsheets_by_index[i].updateDeepIncludes();
		for (i = 0, len = this.triggers_to_postinit.length; i < len; i++)
			this.triggers_to_postinit[i].postInit();
		this.triggers_to_postinit.length = 0;
		this.files_subfolder = pm[7];
		this.pixel_rounding = pm[8];
		this.aspect_scale = 1.0;
		this.enableWebGL = pm[12];
		this.linearSampling = pm[13];
		this.alphaBackground = pm[14];
		this.versionstr = pm[15];
		this.useHighDpi = pm[16];
		this.orientations = pm[19];		// 0 = any, 1 = portrait, 2 = landscape
		this.autoLockOrientation = (this.orientations > 0);
		this.pauseOnBlur = pm[21];
		this.wantFullscreenScalingQuality = pm[22];		// false = low quality, true = high quality
		this.fullscreenScalingQuality = this.wantFullscreenScalingQuality;
		this.start_time = Date.now();
	};
	var anyImageHadError = false;
	Runtime.prototype.waitForImageLoad = function (img_)
	{
		img_.onerror = function (e)
		{
			img_.c2error = true;
			anyImageHadError = true;
			if (console && console.error)
				console.error("Error loading image '" + img_.src + "': ", e);
		};
		this.wait_for_textures.push(img_);
	};
	Runtime.prototype.findWaitingTexture = function (src_)
	{
		var i, len;
		for (i = 0, len = this.wait_for_textures.length; i < len; i++)
		{
			if (this.wait_for_textures[i].cr_src === src_)
				return this.wait_for_textures[i];
		}
		return null;
	};
	Runtime.prototype.areAllTexturesLoaded = function ()
	{
		var totalsize = 0;
		var completedsize = 0;
		var ret = true;
		var i, len, img;
		for (i = 0, len = this.wait_for_textures.length; i < len; i++)
		{
			img = this.wait_for_textures[i];
			var filesize = img.cr_filesize;
			if (!filesize || filesize <= 0)
				filesize = 50000;
			totalsize += filesize;
			if ((img.complete || img["loaded"]) && !img.c2error)
				completedsize += filesize;
			else
				ret = false;    // not all textures loaded
		}
		if (totalsize == 0)
			this.progress = 0;
		else
			this.progress = (completedsize / totalsize);
		return ret;
	};
	Runtime.prototype.go = function ()
	{
		if (!this.ctx && !this.glwrap)
			return;
		var ctx = this.ctx || this.overlay_ctx;
		if (this.overlay_canvas)
			this.positionOverlayCanvas();
		this.progress = 0;
		this.last_progress = -1;
		if (this.areAllTexturesLoaded())
			this.go_textures_done();
		else
		{
			var ms_elapsed = Date.now() - this.start_time;
			if (ctx)
			{
				var overlay_width = this.width;
				var overlay_height = this.height;
				var multiplier = this.devicePixelRatio;
				if (this.overlay_canvas)
				{
					overlay_width = this.cssWidth;
					overlay_height = this.cssHeight;
					multiplier = 1;
				}
				if (this.loaderstyle !== 3 && (this.isCocoonJs || (ms_elapsed >= 500 && this.last_progress != this.progress)))
				{
					ctx.clearRect(0, 0, overlay_width, overlay_height);
					var mx = overlay_width / 2;
					var my = overlay_height / 2;
					var haslogo = (this.loaderstyle === 0 && this.loaderlogo.complete);
					var hlw = 40 * multiplier;
					var hlh = 0;
					var logowidth = 80 * multiplier;
					var logoheight;
					if (haslogo)
					{
						logowidth = this.loaderlogo.width * multiplier;
						logoheight = this.loaderlogo.height * multiplier;
						hlw = logowidth / 2;
						hlh = logoheight / 2;
						ctx.drawImage(this.loaderlogo, cr.floor(mx - hlw), cr.floor(my - hlh), logowidth, logoheight);
					}
					if (this.loaderstyle <= 1)
					{
						my += hlh + (haslogo ? 12 * multiplier : 0);
						mx -= hlw;
						mx = cr.floor(mx) + 0.5;
						my = cr.floor(my) + 0.5;
						ctx.fillStyle = anyImageHadError ? "red" : "DodgerBlue";
						ctx.fillRect(mx, my, Math.floor(logowidth * this.progress), 6 * multiplier);
						ctx.strokeStyle = "black";
						ctx.strokeRect(mx, my, logowidth, 6 * multiplier);
						ctx.strokeStyle = "white";
						ctx.strokeRect(mx - 1 * multiplier, my - 1 * multiplier, logowidth + 2 * multiplier, 8 * multiplier);
					}
					else if (this.loaderstyle === 2)
					{
						ctx.font = (this.isEjecta ? "12pt ArialMT" : "12pt Arial");
						ctx.fillStyle = anyImageHadError ? "#f00" : "#999";
						ctx.textBaseLine = "middle";
						var percent_text = Math.round(this.progress * 100) + "%";
						var text_dim = ctx.measureText ? ctx.measureText(percent_text) : null;
						var text_width = text_dim ? text_dim.width : 0;
						ctx.fillText(percent_text, mx - (text_width / 2), my);
					}
				}
				this.last_progress = this.progress;
			}
			setTimeout((function (self) { return function () { self.go(); }; })(this), (this.isCocoonJs ? 10 : 100));
		}
	};
	Runtime.prototype.go_textures_done = function ()
	{
		if (this.overlay_canvas)
		{
			this.canvas.parentNode.removeChild(this.overlay_canvas);
			this.overlay_ctx = null;
			this.overlay_canvas = null;
		}
		this.start_time = Date.now();
		this.last_fps_time = cr.performance_now();       // for counting framerate
		var i, len, t;
		if (this.uses_loader_layout)
		{
			for (i = 0, len = this.types_by_index.length; i < len; i++)
			{
				t = this.types_by_index[i];
				if (!t.is_family && !t.isOnLoaderLayout && t.plugin.is_world)
				{
					t.onCreate();
					cr.seal(t);
				}
			}
		}
		else
			this.isloading = false;
		for (i = 0, len = this.layouts_by_index.length; i < len; i++)
		{
			this.layouts_by_index[i].createGlobalNonWorlds();
		}
		if (this.fullscreen_mode >= 2)
		{
			var orig_aspect = this.original_width / this.original_height;
			var cur_aspect = this.width / this.height;
			if ((this.fullscreen_mode !== 2 && cur_aspect > orig_aspect) || (this.fullscreen_mode === 2 && cur_aspect < orig_aspect))
				this.aspect_scale = this.height / this.original_height;
			else
				this.aspect_scale = this.width / this.original_width;
		}
		if (this.first_layout)
			this.layouts[this.first_layout].startRunning();
		else
			this.layouts_by_index[0].startRunning();
;
		if (!this.uses_loader_layout)
		{
			this.loadingprogress = 1;
			this.trigger(cr.system_object.prototype.cnds.OnLoadFinished, null);
		}
		if (navigator["splashscreen"] && navigator["splashscreen"]["hide"])
			navigator["splashscreen"]["hide"]();
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			t = this.types_by_index[i];
			if (t.onAppBegin)
				t.onAppBegin();
		}
		this.tick(false);
		if (this.isDirectCanvas)
			AppMobi["webview"]["execute"]("onGameReady();");
	};
	var raf = window["requestAnimationFrame"] ||
	  window["mozRequestAnimationFrame"]    ||
	  window["webkitRequestAnimationFrame"] ||
	  window["msRequestAnimationFrame"]     ||
	  window["oRequestAnimationFrame"];
	Runtime.prototype.tick = function (background_wake)
	{
		if (!this.running_layout)
			return;
		var logic_start = cr.performance_now();
		if (this.halfFramerateMode && this.ranLastRaf)
		{
			if (logic_start - this.lastRafTime < 29)
			{
				this.ranLastRaf = false;
				this.lastRafTime = logic_start;
				if (raf)
					this.raf_id = raf(this.tickFunc, this.canvas);
				else	// no idea if this works without raf/hi res timers but let's hope for the best
					this.timeout_id = setTimeout(this.tickFunc, this.isMobile ? 1 : 16);
				return;		// skipped this frame
			}
		}
		this.ranLastRaf = true;
		this.lastRafTime = logic_start;
		var fsmode = this.fullscreen_mode;
		var isfullscreen = (document["mozFullScreen"] || document["webkitIsFullScreen"] || document["fullScreen"] || !!document["msFullscreenElement"]);
		if ((isfullscreen || this.isNodeFullscreen) && this.fullscreen_scaling > 0)
			fsmode = this.fullscreen_scaling;
		if (fsmode > 0 && (!this.isiPhone || window.self !== window.top))
		{
			var curwidth = window.innerWidth;
			var curheight = window.innerHeight;
			if (this.lastWindowWidth !== curwidth || this.lastWindowHeight !== curheight)
			{
					this["setSize"](curwidth, curheight);
			}
		}
		if (!this.isDomFree)
		{
			if (isfullscreen)
			{
				if (!this.firstInFullscreen)
				{
					this.fullscreenOldMarginCss = jQuery(this.canvas).css("margin") || "0";
					this.firstInFullscreen = true;
				}
				if (!this.isChrome && !this.isNodeWebkit)
				{
					jQuery(this.canvas).css({
						"margin-left": "" + Math.floor((screen.width - (this.width / this.devicePixelRatio)) / 2) + "px",
						"margin-top": "" + Math.floor((screen.height - (this.height / this.devicePixelRatio)) / 2) + "px"
					});
				}
			}
			else
			{
				if (this.firstInFullscreen)
				{
					if (!this.isChrome && !this.isNodeWebkit)
					{
						jQuery(this.canvas).css("margin", this.fullscreenOldMarginCss);
					}
					this.fullscreenOldMarginCss = "";
					this.firstInFullscreen = false;
					if (this.fullscreen_mode === 0)
					{
						this["setSize"](Math.round(this.oldWidth / this.devicePixelRatio), Math.round(this.oldHeight / this.devicePixelRatio), true);
					}
				}
				else
				{
					this.oldWidth = this.width;
					this.oldHeight = this.height;
				}
			}
		}
		if (this.isloading)
		{
			var done = this.areAllTexturesLoaded();		// updates this.progress
			this.loadingprogress = this.progress;
			if (done)
			{
				this.isloading = false;
				this.progress = 1;
				this.trigger(cr.system_object.prototype.cnds.OnLoadFinished, null);
			}
		}
		this.logic();
		if ((this.redraw || this.isCocoonJs) && !this.is_WebGL_context_lost && !this.suspendDrawing && !background_wake)
		{
			this.redraw = false;
			if (this.glwrap)
				this.drawGL();
			else
				this.draw();
			if (this.snapshotCanvas)
			{
				if (this.canvas && this.canvas.toDataURL)
				{
					this.snapshotData = this.canvas.toDataURL(this.snapshotCanvas[0], this.snapshotCanvas[1]);
					this.trigger(cr.system_object.prototype.cnds.OnCanvasSnapshot, null);
				}
				this.snapshotCanvas = null;
			}
		}
		if (!this.hit_breakpoint)
		{
			this.tickcount++;
			this.execcount++;
			this.framecount++;
		}
		this.logictime += cr.performance_now() - logic_start;
		if (this.isSuspended || background_wake)
			return;
		if (raf)
			this.raf_id = raf(this.tickFunc, this.canvas);
		else
		{
			this.timeout_id = setTimeout(this.tickFunc, this.isMobile ? 1 : 16);
		}
	};
	Runtime.prototype.logic = function ()
	{
		var i, leni, j, lenj, k, lenk, type, inst, binst;
		var cur_time = cr.performance_now();
		if (cur_time - this.last_fps_time >= 1000)  // every 1 second
		{
			this.last_fps_time += 1000;
			this.fps = this.framecount;
			this.framecount = 0;
			this.cpuutilisation = this.logictime;
			this.logictime = 0;
		}
		if (this.measuring_dt)
		{
			if (this.last_tick_time !== 0)
			{
				var ms_diff = cur_time - this.last_tick_time;
				if (ms_diff === 0 && !this.isDebug)
				{
					this.zeroDtCount++;
					if (this.zeroDtCout >= 10)
						this.measuring_dt = false;
					this.dt1 = 1.0 / 60.0;            // 60fps assumed (0.01666...)
				}
				else
				{
					this.dt1 = ms_diff / 1000.0; // dt measured in seconds
					if (this.dt1 > 0.5)
						this.dt1 = 0;
					else if (this.dt1 > 0.1)
						this.dt1 = 0.1;
				}
			}
			this.last_tick_time = cur_time;
		}
        this.dt = this.dt1 * this.timescale;
        this.kahanTime.add(this.dt);
		var isfullscreen = (document["mozFullScreen"] || document["webkitIsFullScreen"] || document["fullScreen"] || !!document["msFullscreenElement"] || this.isNodeFullscreen);
		if (this.fullscreen_mode >= 2 /* scale */ || (isfullscreen && this.fullscreen_scaling > 0))
		{
			var orig_aspect = this.original_width / this.original_height;
			var cur_aspect = this.width / this.height;
			var mode = this.fullscreen_mode;
			if (isfullscreen && this.fullscreen_scaling > 0)
				mode = this.fullscreen_scaling;
			if ((mode !== 2 && cur_aspect > orig_aspect) || (mode === 2 && cur_aspect < orig_aspect))
			{
				this.aspect_scale = this.height / this.original_height;
			}
			else
			{
				this.aspect_scale = this.width / this.original_width;
			}
			if (this.running_layout)
			{
				this.running_layout.scrollToX(this.running_layout.scrollX);
				this.running_layout.scrollToY(this.running_layout.scrollY);
			}
		}
		else
			this.aspect_scale = (this.isRetina ? this.devicePixelRatio : 1);
		this.ClearDeathRow();
		this.isInOnDestroy++;
		this.system.runWaits();		// prevent instance list changing
		this.isInOnDestroy--;
		this.ClearDeathRow();		// allow instance list changing
		this.isInOnDestroy++;
		for (i = 0, leni = this.types_by_index.length; i < leni; i++)
		{
			type = this.types_by_index[i];
			if (type.is_family || (!type.behaviors.length && !type.families.length))
				continue;
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
			{
				inst = type.instances[j];
				for (k = 0, lenk = inst.behavior_insts.length; k < lenk; k++)
				{
					inst.behavior_insts[k].tick();
				}
			}
		}
		for (i = 0, leni = this.types_by_index.length; i < leni; i++)
		{
			type = this.types_by_index[i];
			if (type.is_family || (!type.behaviors.length && !type.families.length))
				continue;	// type doesn't have any behaviors
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
			{
				inst = type.instances[j];
				for (k = 0, lenk = inst.behavior_insts.length; k < lenk; k++)
				{
					binst = inst.behavior_insts[k];
					if (binst.posttick)
						binst.posttick();
				}
			}
		}
        var tickarr = this.objects_to_tick.valuesRef();
        for (i = 0, leni = tickarr.length; i < leni; i++)
            tickarr[i].tick();
		this.isInOnDestroy--;		// end preventing instance lists from being changed
		this.handleSaveLoad();		// save/load now if queued
		i = 0;
		while (this.changelayout && i++ < 10)
		{
			this.doChangeLayout(this.changelayout);
		}
        for (i = 0, leni = this.eventsheets_by_index.length; i < leni; i++)
            this.eventsheets_by_index[i].hasRun = false;
		if (this.running_layout.event_sheet)
			this.running_layout.event_sheet.run();
		this.registered_collisions.length = 0;
		this.layout_first_tick = false;
		this.isInOnDestroy++;		// prevent instance lists from being changed
		for (i = 0, leni = this.types_by_index.length; i < leni; i++)
		{
			type = this.types_by_index[i];
			if (type.is_family || (!type.behaviors.length && !type.families.length))
				continue;	// type doesn't have any behaviors
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
			{
				var inst = type.instances[j];
				for (k = 0, lenk = inst.behavior_insts.length; k < lenk; k++)
				{
					binst = inst.behavior_insts[k];
					if (binst.tick2)
						binst.tick2();
				}
			}
		}
        tickarr = this.objects_to_tick2.valuesRef();
        for (i = 0, leni = tickarr.length; i < leni; i++)
            tickarr[i].tick2();
		this.isInOnDestroy--;		// end preventing instance lists from being changed
	};
	Runtime.prototype.doChangeLayout = function (changeToLayout)
	{
;
		var prev_layout = this.running_layout;
		this.running_layout.stopRunning();
		var i, len, j, lenj, k, lenk, type, inst, binst;
		if (this.glwrap)
		{
			for (i = 0, len = this.types_by_index.length; i < len; i++)
			{
				type = this.types_by_index[i];
				if (type.is_family)
					continue;
				if (type.unloadTextures && (!type.global || type.instances.length === 0) && changeToLayout.initial_types.indexOf(type) === -1)
				{
					type.unloadTextures();
				}
			}
		}
		if (prev_layout == changeToLayout)
			this.system.waits.length = 0;
		changeToLayout.startRunning();
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			type = this.types_by_index[i];
			if (!type.global && !type.plugin.singleglobal)
				continue;
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
			{
				inst = type.instances[j];
				if (inst.onLayoutChange)
					inst.onLayoutChange();
				if (inst.behavior_insts)
				{
					for (k = 0, lenk = inst.behavior_insts.length; k < lenk; k++)
					{
						binst = inst.behavior_insts[k];
						if (binst.onLayoutChange)
							binst.onLayoutChange();
					}
				}
			}
		}
		this.redraw = true;
		this.layout_first_tick = true;
		this.ClearDeathRow();
	};
    Runtime.prototype.tickMe = function (inst)
    {
        this.objects_to_tick.add(inst);
    };
	Runtime.prototype.untickMe = function (inst)
	{
		this.objects_to_tick.remove(inst);
	};
	Runtime.prototype.tick2Me = function (inst)
    {
        this.objects_to_tick2.add(inst);
    };
	Runtime.prototype.untick2Me = function (inst)
	{
		this.objects_to_tick2.remove(inst);
	};
    Runtime.prototype.getDt = function (inst)
    {
        if (!inst || inst.my_timescale === -1.0)
            return this.dt;
        return this.dt1 * inst.my_timescale;
    };
	Runtime.prototype.draw = function ()
	{
		this.running_layout.draw(this.ctx);
		if (this.isDirectCanvas)
			this.ctx["present"]();
	};
	Runtime.prototype.drawGL = function ()
	{
		this.running_layout.drawGL(this.glwrap);
		this.glwrap.present();
	};
	Runtime.prototype.addDestroyCallback = function (f)
	{
		if (f)
			this.destroycallbacks.push(f);
	};
	Runtime.prototype.removeDestroyCallback = function (f)
	{
		cr.arrayFindRemove(this.destroycallbacks, f);
	};
	Runtime.prototype.getObjectByUID = function (uid_)
	{
;
		var uidstr = uid_.toString();
		if (this.objectsByUid.hasOwnProperty(uidstr))
			return this.objectsByUid[uidstr];
		else
			return null;
	};
	Runtime.prototype.DestroyInstance = function (inst)
	{
		var i, len;
		if (!this.deathRow.contains(inst))
		{
			this.deathRow.add(inst);
			if (inst.is_contained)
			{
				for (i = 0, len = inst.siblings.length; i < len; i++)
				{
					this.DestroyInstance(inst.siblings[i]);
				}
			}
			if (this.isInClearDeathRow)
				this.deathRow.values_cache.push(inst);
			this.isInOnDestroy++;		// support recursion
			this.trigger(Object.getPrototypeOf(inst.type.plugin).cnds.OnDestroyed, inst);
			this.isInOnDestroy--;
		}
	};
	Runtime.prototype.ClearDeathRow = function ()
	{
		var inst, index, type, instances, binst;
		var i, j, k, leni, lenj, lenk;
		var w, f;
		this.isInClearDeathRow = true;
		for (i = 0, leni = this.createRow.length; i < leni; i++)
		{
			inst = this.createRow[i];
			type = inst.type;
			type.instances.push(inst);
			for (j = 0, lenj = type.families.length; j < lenj; j++)
			{
				type.families[j].instances.push(inst);
				type.families[j].stale_iids = true;
			}
		}
		this.createRow.length = 0;
		var arr = this.deathRow.valuesRef();	// get array of items from set
		for (i = 0; i < arr.length; i++)		// check array length every time in case it changes
		{
			inst = arr[i];
			type = inst.type;
			instances = type.instances;
			for (j = 0, lenj = this.destroycallbacks.length; j < lenj; j++)
				this.destroycallbacks[j](inst);
			cr.arrayFindRemove(instances, inst);
			if (instances.length === 0)
				type.any_instance_parallaxed = false;
			if (inst.collcells)
			{
				type.collision_grid.update(inst, inst.collcells, null);
			}
			if (inst.layer)
			{
				cr.arrayRemove(inst.layer.instances, inst.get_zindex());
				inst.layer.zindices_stale = true;
			}
			for (j = 0, lenj = type.families.length; j < lenj; j++)
			{
				cr.arrayFindRemove(type.families[j].instances, inst);
				type.families[j].stale_iids = true;
			}
			if (inst.behavior_insts)
			{
				for (j = 0, lenj = inst.behavior_insts.length; j < lenj; j++)
				{
					binst = inst.behavior_insts[j];
					if (binst.onDestroy)
						binst.onDestroy();
					binst.behavior.my_instances.remove(inst);
				}
			}
            this.objects_to_tick.remove(inst);
			this.objects_to_tick2.remove(inst);
			for (j = 0, lenj = this.system.waits.length; j < lenj; j++)
			{
				w = this.system.waits[j];
				if (w.sols.hasOwnProperty(type.index))
					cr.arrayFindRemove(w.sols[type.index].insts, inst);
				if (!type.is_family)
				{
					for (k = 0, lenk = type.families.length; k < lenk; k++)
					{
						f = type.families[k];
						if (w.sols.hasOwnProperty(f.index))
							cr.arrayFindRemove(w.sols[f.index].insts, inst);
					}
				}
			}
			if (inst.onDestroy)
				inst.onDestroy();
			if (this.objectsByUid.hasOwnProperty(inst.uid.toString()))
				delete this.objectsByUid[inst.uid.toString()];
			this.objectcount--;
			if (type.deadCache.length < 64)
				type.deadCache.push(inst);
			type.stale_iids = true;
		}
		if (!this.deathRow.isEmpty())
			this.redraw = true;
		this.deathRow.clear();
		this.isInClearDeathRow = false;
	};
	Runtime.prototype.createInstance = function (type, layer, sx, sy)
	{
		if (type.is_family)
		{
			var i = cr.floor(Math.random() * type.members.length);
			return this.createInstance(type.members[i], layer, sx, sy);
		}
		if (!type.default_instance)
		{
			return null;
		}
		return this.createInstanceFromInit(type.default_instance, layer, false, sx, sy, false);
	};
	var all_behaviors = [];
	Runtime.prototype.createInstanceFromInit = function (initial_inst, layer, is_startup_instance, sx, sy, skip_siblings)
	{
		var i, len, j, lenj, p, effect_fallback, x, y;
		if (!initial_inst)
			return null;
		var type = this.types_by_index[initial_inst[1]];
;
;
		var is_world = type.plugin.is_world;
;
		if (this.isloading && is_world && !type.isOnLoaderLayout)
			return null;
		if (is_world && !this.glwrap && initial_inst[0][11] === 11)
			return null;
		var original_layer = layer;
		if (!is_world)
			layer = null;
		var inst;
		if (type.deadCache.length)
		{
			inst = type.deadCache.pop();
			inst.recycled = true;
			type.plugin.Instance.call(inst, type);
		}
		else
		{
			inst = new type.plugin.Instance(type);
			inst.recycled = false;
		}
		if (is_startup_instance && !skip_siblings)
			inst.uid = initial_inst[2];
		else
			inst.uid = this.next_uid++;
		this.objectsByUid[inst.uid.toString()] = inst;
		inst.puid = this.next_puid++;
		inst.iid = type.instances.length;
		for (i = 0, len = this.createRow.length; i < len; ++i)
		{
			if (this.createRow[i].type === type)
				inst.iid++;
		}
		inst.get_iid = cr.inst_get_iid;
		var initial_vars = initial_inst[3];
		if (inst.recycled)
		{
			cr.wipe(inst.extra);
		}
		else
		{
			inst.extra = {};
			if (typeof cr_is_preview !== "undefined")
			{
				inst.instance_var_names = [];
				inst.instance_var_names.length = initial_vars.length;
				for (i = 0, len = initial_vars.length; i < len; i++)
					inst.instance_var_names[i] = initial_vars[i][1];
			}
			inst.instance_vars = [];
			inst.instance_vars.length = initial_vars.length;
		}
		for (i = 0, len = initial_vars.length; i < len; i++)
			inst.instance_vars[i] = initial_vars[i][0];
		if (is_world)
		{
			var wm = initial_inst[0];
;
			inst.x = cr.is_undefined(sx) ? wm[0] : sx;
			inst.y = cr.is_undefined(sy) ? wm[1] : sy;
			inst.z = wm[2];
			inst.width = wm[3];
			inst.height = wm[4];
			inst.depth = wm[5];
			inst.angle = wm[6];
			inst.opacity = wm[7];
			inst.hotspotX = wm[8];
			inst.hotspotY = wm[9];
			inst.blend_mode = wm[10];
			effect_fallback = wm[11];
			if (!this.glwrap && type.effect_types.length)	// no WebGL renderer and shaders used
				inst.blend_mode = effect_fallback;			// use fallback blend mode - destroy mode was handled above
			inst.compositeOp = cr.effectToCompositeOp(inst.blend_mode);
			if (this.gl)
				cr.setGLBlend(inst, inst.blend_mode, this.gl);
			if (inst.recycled)
			{
				for (i = 0, len = wm[12].length; i < len; i++)
				{
					for (j = 0, lenj = wm[12][i].length; j < lenj; j++)
						inst.effect_params[i][j] = wm[12][i][j];
				}
				inst.bbox.set(0, 0, 0, 0);
				inst.collcells.set(0, 0, -1, -1);
				inst.bquad.set_from_rect(inst.bbox);
				inst.bbox_changed_callbacks.length = 0;
			}
			else
			{
				inst.effect_params = wm[12].slice(0);
				for (i = 0, len = inst.effect_params.length; i < len; i++)
					inst.effect_params[i] = wm[12][i].slice(0);
				inst.active_effect_types = [];
				inst.active_effect_flags = [];
				inst.active_effect_flags.length = type.effect_types.length;
				inst.bbox = new cr.rect(0, 0, 0, 0);
				inst.collcells = new cr.rect(0, 0, -1, -1);
				inst.bquad = new cr.quad();
				inst.bbox_changed_callbacks = [];
				inst.set_bbox_changed = cr.set_bbox_changed;
				inst.add_bbox_changed_callback = cr.add_bbox_changed_callback;
				inst.contains_pt = cr.inst_contains_pt;
				inst.update_bbox = cr.update_bbox;
				inst.update_collision_cell = cr.update_collision_cell;
				inst.get_zindex = cr.inst_get_zindex;
			}
			inst.tilemap_exists = false;
			inst.tilemap_width = 0;
			inst.tilemap_height = 0;
			inst.tilemap_data = null;
			if (wm.length === 14)
			{
				inst.tilemap_exists = true;
				inst.tilemap_width = wm[13][0];
				inst.tilemap_height = wm[13][1];
				inst.tilemap_data = wm[13][2];
			}
			for (i = 0, len = type.effect_types.length; i < len; i++)
				inst.active_effect_flags[i] = true;
			inst.updateActiveEffects = cr.inst_updateActiveEffects;
			inst.updateActiveEffects();
			inst.uses_shaders = !!inst.active_effect_types.length;
			inst.bbox_changed = true;
			inst.cell_changed = true;
			type.any_cell_changed = true;
			inst.visible = true;
            inst.my_timescale = -1.0;
			inst.layer = layer;
			inst.zindex = layer.instances.length;	// will be placed at top of current layer
			if (typeof inst.collision_poly === "undefined")
				inst.collision_poly = null;
			inst.collisionsEnabled = true;
			this.redraw = true;
		}
		inst.toString = cr.inst_toString;
		var initial_props, binst;
		all_behaviors.length = 0;
		for (i = 0, len = type.families.length; i < len; i++)
		{
			all_behaviors.push.apply(all_behaviors, type.families[i].behaviors);
		}
		all_behaviors.push.apply(all_behaviors, type.behaviors);
		if (inst.recycled)
		{
			for (i = 0, len = all_behaviors.length; i < len; i++)
			{
				var btype = all_behaviors[i];
				binst = inst.behavior_insts[i];
				binst.recycled = true;
				btype.behavior.Instance.call(binst, btype, inst);
				initial_props = initial_inst[4][i];
				for (j = 0, lenj = initial_props.length; j < lenj; j++)
					binst.properties[j] = initial_props[j];
				binst.onCreate();
				btype.behavior.my_instances.add(inst);
			}
		}
		else
		{
			inst.behavior_insts = [];
			for (i = 0, len = all_behaviors.length; i < len; i++)
			{
				var btype = all_behaviors[i];
				var binst = new btype.behavior.Instance(btype, inst);
				binst.recycled = false;
				binst.properties = initial_inst[4][i].slice(0);
				binst.onCreate();
				cr.seal(binst);
				inst.behavior_insts.push(binst);
				btype.behavior.my_instances.add(inst);
			}
		}
		initial_props = initial_inst[5];
		if (inst.recycled)
		{
			for (i = 0, len = initial_props.length; i < len; i++)
				inst.properties[i] = initial_props[i];
		}
		else
			inst.properties = initial_props.slice(0);
		this.createRow.push(inst);
		if (layer)
		{
;
			layer.instances.push(inst);
			if (layer.parallaxX !== 1 || layer.parallaxY !== 1)
				type.any_instance_parallaxed = true;
		}
		this.objectcount++;
		if (type.is_contained)
		{
			inst.is_contained = true;
			if (inst.recycled)
				inst.siblings.length = 0;
			else
				inst.siblings = [];			// note: should not include self in siblings
			if (!is_startup_instance && !skip_siblings)	// layout links initial instances
			{
				for (i = 0, len = type.container.length; i < len; i++)
				{
					if (type.container[i] === type)
						continue;
					if (!type.container[i].default_instance)
					{
						return null;
					}
					inst.siblings.push(this.createInstanceFromInit(type.container[i].default_instance, original_layer, false, is_world ? inst.x : sx, is_world ? inst.y : sy, true));
				}
				for (i = 0, len = inst.siblings.length; i < len; i++)
				{
					inst.siblings[i].siblings.push(inst);
					for (j = 0; j < len; j++)
					{
						if (i !== j)
							inst.siblings[i].siblings.push(inst.siblings[j]);
					}
				}
			}
		}
		else
		{
			inst.is_contained = false;
			inst.siblings = null;
		}
		inst.onCreate();
		if (!inst.recycled)
			cr.seal(inst);
		for (i = 0, len = inst.behavior_insts.length; i < len; i++)
		{
			if (inst.behavior_insts[i].postCreate)
				inst.behavior_insts[i].postCreate();
		}
		return inst;
	};
	Runtime.prototype.getLayerByName = function (layer_name)
	{
		var i, len;
		for (i = 0, len = this.running_layout.layers.length; i < len; i++)
		{
			var layer = this.running_layout.layers[i];
			if (cr.equals_nocase(layer.name, layer_name))
				return layer;
		}
		return null;
	};
	Runtime.prototype.getLayerByNumber = function (index)
	{
		index = cr.floor(index);
		if (index < 0)
			index = 0;
		if (index >= this.running_layout.layers.length)
			index = this.running_layout.layers.length - 1;
		return this.running_layout.layers[index];
	};
	Runtime.prototype.getLayer = function (l)
	{
		if (cr.is_number(l))
			return this.getLayerByNumber(l);
		else
			return this.getLayerByName(l.toString());
	};
	Runtime.prototype.clearSol = function (solModifiers)
	{
		var i, len;
		for (i = 0, len = solModifiers.length; i < len; i++)
		{
			solModifiers[i].getCurrentSol().select_all = true;
		}
	};
	Runtime.prototype.pushCleanSol = function (solModifiers)
	{
		var i, len;
		for (i = 0, len = solModifiers.length; i < len; i++)
		{
			solModifiers[i].pushCleanSol();
		}
	};
	Runtime.prototype.pushCopySol = function (solModifiers)
	{
		var i, len;
		for (i = 0, len = solModifiers.length; i < len; i++)
		{
			solModifiers[i].pushCopySol();
		}
	};
	Runtime.prototype.popSol = function (solModifiers)
	{
		var i, len;
		for (i = 0, len = solModifiers.length; i < len; i++)
		{
			solModifiers[i].popSol();
		}
	};
	Runtime.prototype.updateAllCells = function (type)
	{
		if (!type.any_cell_changed)
			return;		// all instances must already be up-to-date
		var i, len, instances = type.instances;
		for (i = 0, len = instances.length; i < len; ++i)
		{
			instances[i].update_collision_cell();
		}
		var createRow = this.createRow;
		for (i = 0, len = createRow.length; i < len; ++i)
		{
			if (createRow[i].type === type)
				createRow[i].update_collision_cell();
		}
		type.any_cell_changed = false;
	};
	Runtime.prototype.getCollisionCandidates = function (layer, rtype, bbox, candidates)
	{
		var i, len, t;
		var is_parallaxed = (layer ? (layer.parallaxX !== 1 || layer.parallaxY !== 1) : false);
		if (rtype.is_family)
		{
			for (i = 0, len = rtype.members.length; i < len; ++i)
			{
				t = rtype.members[i];
				if (is_parallaxed || t.any_instance_parallaxed)
				{
					cr.appendArray(candidates, t.instances);
				}
				else
				{
					this.updateAllCells(t);
					t.collision_grid.queryRange(bbox, candidates);
				}
			}
		}
		else
		{
			if (is_parallaxed || rtype.any_instance_parallaxed)
			{
				cr.appendArray(candidates, rtype.instances);
			}
			else
			{
				this.updateAllCells(rtype);
				rtype.collision_grid.queryRange(bbox, candidates);
			}
		}
	};
	Runtime.prototype.getTypesCollisionCandidates = function (layer, types, bbox, candidates)
	{
		var i, len;
		for (i = 0, len = types.length; i < len; ++i)
		{
			this.getCollisionCandidates(layer, types[i], bbox, candidates);
		}
	};
	Runtime.prototype.getSolidCollisionCandidates = function (layer, bbox, candidates)
	{
		var solid = this.getSolidBehavior();
		if (!solid)
			return null;
		this.getTypesCollisionCandidates(layer, solid.my_types, bbox, candidates);
	};
	Runtime.prototype.getJumpthruCollisionCandidates = function (layer, bbox, candidates)
	{
		var jumpthru = this.getJumpthruBehavior();
		if (!jumpthru)
			return null;
		this.getTypesCollisionCandidates(layer, jumpthru.my_types, bbox, candidates);
	};
	Runtime.prototype.testAndSelectCanvasPointOverlap = function (type, ptx, pty, inverted)
	{
		var sol = type.getCurrentSol();
		var i, j, inst, len;
		var lx, ly;
		if (sol.select_all)
		{
			if (!inverted)
			{
				sol.select_all = false;
				sol.instances.length = 0;   // clear contents
			}
			for (i = 0, len = type.instances.length; i < len; i++)
			{
				inst = type.instances[i];
				inst.update_bbox();
				lx = inst.layer.canvasToLayer(ptx, pty, true);
				ly = inst.layer.canvasToLayer(ptx, pty, false);
				if (inst.contains_pt(lx, ly))
				{
					if (inverted)
						return false;
					else
						sol.instances.push(inst);
				}
			}
		}
		else
		{
			j = 0;
			for (i = 0, len = sol.instances.length; i < len; i++)
			{
				inst = sol.instances[i];
				inst.update_bbox();
				lx = inst.layer.canvasToLayer(ptx, pty, true);
				ly = inst.layer.canvasToLayer(ptx, pty, false);
				if (inst.contains_pt(lx, ly))
				{
					if (inverted)
						return false;
					else
					{
						sol.instances[j] = sol.instances[i];
						j++;
					}
				}
			}
			if (!inverted)
				sol.instances.length = j;
		}
		type.applySolToContainer();
		if (inverted)
			return true;		// did not find anything overlapping
		else
			return sol.hasObjects();
	};
	Runtime.prototype.testOverlap = function (a, b)
	{
		if (!a || !b || a === b || !a.collisionsEnabled || !b.collisionsEnabled)
			return false;
		a.update_bbox();
		b.update_bbox();
		var layera = a.layer;
		var layerb = b.layer;
		var different_layers = (layera !== layerb && (layera.parallaxX !== layerb.parallaxX || layerb.parallaxY !== layerb.parallaxY || layera.scale !== layerb.scale || layera.angle !== layerb.angle || layera.zoomRate !== layerb.zoomRate));
		var i, len, i2, i21, x, y, haspolya, haspolyb, polya, polyb;
		if (!different_layers)	// same layers: easy check
		{
			if (!a.bbox.intersects_rect(b.bbox))
				return false;
			if (!a.bquad.intersects_quad(b.bquad))
				return false;
			if (a.tilemap_exists && b.tilemap_exists)
				return false;
			if (a.tilemap_exists)
				return this.testTilemapOverlap(a, b);
			if (b.tilemap_exists)
				return this.testTilemapOverlap(b, a);
			haspolya = (a.collision_poly && !a.collision_poly.is_empty());
			haspolyb = (b.collision_poly && !b.collision_poly.is_empty());
			if (!haspolya && !haspolyb)
				return true;
			if (haspolya)
			{
				a.collision_poly.cache_poly(a.width, a.height, a.angle);
				polya = a.collision_poly;
			}
			else
			{
				this.temp_poly.set_from_quad(a.bquad, a.x, a.y, a.width, a.height);
				polya = this.temp_poly;
			}
			if (haspolyb)
			{
				b.collision_poly.cache_poly(b.width, b.height, b.angle);
				polyb = b.collision_poly;
			}
			else
			{
				this.temp_poly.set_from_quad(b.bquad, b.x, b.y, b.width, b.height);
				polyb = this.temp_poly;
			}
			return polya.intersects_poly(polyb, b.x - a.x, b.y - a.y);
		}
		else	// different layers: need to do full translated check
		{
			haspolya = (a.collision_poly && !a.collision_poly.is_empty());
			haspolyb = (b.collision_poly && !b.collision_poly.is_empty());
			if (haspolya)
			{
				a.collision_poly.cache_poly(a.width, a.height, a.angle);
				this.temp_poly.set_from_poly(a.collision_poly);
			}
			else
			{
				this.temp_poly.set_from_quad(a.bquad, a.x, a.y, a.width, a.height);
			}
			polya = this.temp_poly;
			if (haspolyb)
			{
				b.collision_poly.cache_poly(b.width, b.height, b.angle);
				this.temp_poly2.set_from_poly(b.collision_poly);
			}
			else
			{
				this.temp_poly2.set_from_quad(b.bquad, b.x, b.y, b.width, b.height);
			}
			polyb = this.temp_poly2;
			for (i = 0, len = polya.pts_count; i < len; i++)
			{
				i2 = i * 2;
				i21 = i2 + 1;
				x = polya.pts_cache[i2];
				y = polya.pts_cache[i21];
				polya.pts_cache[i2] = layera.layerToCanvas(x + a.x, y + a.y, true);
				polya.pts_cache[i21] = layera.layerToCanvas(x + a.x, y + a.y, false);
			}
			polya.update_bbox();
			for (i = 0, len = polyb.pts_count; i < len; i++)
			{
				i2 = i * 2;
				i21 = i2 + 1;
				x = polyb.pts_cache[i2];
				y = polyb.pts_cache[i21];
				polyb.pts_cache[i2] = layerb.layerToCanvas(x + b.x, y + b.y, true);
				polyb.pts_cache[i21] = layerb.layerToCanvas(x + b.x, y + b.y, false);
			}
			polyb.update_bbox();
			return polya.intersects_poly(polyb, 0, 0);
		}
	};
	var tmpQuad = new cr.quad();
	var tmpRect = new cr.rect(0, 0, 0, 0);
	var collrect_candidates = [];
	Runtime.prototype.testTilemapOverlap = function (tm, a)
	{
		var i, len, c, rc;
		var bbox = a.bbox;
		var tmx = tm.x;
		var tmy = tm.y;
		tm.getCollisionRectCandidates(bbox, collrect_candidates);
		var collrects = collrect_candidates;
		var haspolya = (a.collision_poly && !a.collision_poly.is_empty());
		for (i = 0, len = collrects.length; i < len; ++i)
		{
			c = collrects[i];
			rc = c.rc;
			if (bbox.intersects_rect_off(rc, tmx, tmy))
			{
				tmpQuad.set_from_rect(rc);
				tmpQuad.offset(tmx, tmy);
				if (tmpQuad.intersects_quad(a.bquad))
				{
					if (haspolya)
					{
						a.collision_poly.cache_poly(a.width, a.height, a.angle);
						if (c.poly)
						{
							if (c.poly.intersects_poly(a.collision_poly, a.x - (tmx + rc.left), a.y - (tmy + rc.top)))
							{
								collrect_candidates.length = 0;
								return true;
							}
						}
						else
						{
							this.temp_poly.set_from_quad(tmpQuad, 0, 0, rc.right - rc.left, rc.bottom - rc.top);
							if (this.temp_poly.intersects_poly(a.collision_poly, a.x, a.y))
							{
								collrect_candidates.length = 0;
								return true;
							}
						}
					}
					else
					{
						if (c.poly)
						{
							this.temp_poly.set_from_quad(a.bquad, 0, 0, a.width, a.height);
							if (c.poly.intersects_poly(this.temp_poly, -(tmx + rc.left), -(tmy + rc.top)))
							{
								collrect_candidates.length = 0;
								return true;
							}
						}
						else
						{
							collrect_candidates.length = 0;
							return true;
						}
					}
				}
			}
		}
		collrect_candidates.length = 0;
		return false;
	};
	Runtime.prototype.testRectOverlap = function (r, b)
	{
		if (!b || !b.collisionsEnabled)
			return false;
		b.update_bbox();
		var layerb = b.layer;
		var haspolyb, polyb;
		if (!b.bbox.intersects_rect(r))
			return false;
		if (b.tilemap_exists)
		{
			b.getCollisionRectCandidates(r, collrect_candidates);
			var collrects = collrect_candidates;
			var i, len, c, tilerc;
			var tmx = b.x;
			var tmy = b.y;
			for (i = 0, len = collrects.length; i < len; ++i)
			{
				c = collrects[i];
				tilerc = c.rc;
				if (r.intersects_rect_off(tilerc, tmx, tmy))
				{
					if (c.poly)
					{
						this.temp_poly.set_from_rect(r, 0, 0);
						if (c.poly.intersects_poly(this.temp_poly, -(tmx + tilerc.left), -(tmy + tilerc.top)))
						{
							collrect_candidates.length = 0;
							return true;
						}
					}
					else
					{
						collrect_candidates.length = 0;
						return true;
					}
				}
			}
			collrect_candidates.length = 0;
			return false;
		}
		else
		{
			tmpQuad.set_from_rect(r);
			if (!b.bquad.intersects_quad(tmpQuad))
				return false;
			haspolyb = (b.collision_poly && !b.collision_poly.is_empty());
			if (!haspolyb)
				return true;
			b.collision_poly.cache_poly(b.width, b.height, b.angle);
			tmpQuad.offset(-r.left, -r.top);
			this.temp_poly.set_from_quad(tmpQuad, 0, 0, 1, 1);
			return b.collision_poly.intersects_poly(this.temp_poly, r.left - b.x, r.top - b.y);
		}
	};
	Runtime.prototype.testSegmentOverlap = function (x1, y1, x2, y2, b)
	{
		if (!b || !b.collisionsEnabled)
			return false;
		b.update_bbox();
		var layerb = b.layer;
		var haspolyb, polyb;
		tmpRect.set(cr.min(x1, x2), cr.min(y1, y2), cr.max(x1, x2), cr.max(y1, y2));
		if (!b.bbox.intersects_rect(tmpRect))
			return false;
		if (b.tilemap_exists)
		{
			b.getCollisionRectCandidates(tmpRect, collrect_candidates);
			var collrects = collrect_candidates;
			var i, len, c, tilerc;
			var tmx = b.x;
			var tmy = b.y;
			for (i = 0, len = collrects.length; i < len; ++i)
			{
				c = collrects[i];
				tilerc = c.rc;
				if (tmpRect.intersects_rect_off(tilerc, tmx, tmy))
				{
					tmpQuad.set_from_rect(tilerc);
					tmpQuad.offset(tmx, tmy);
					if (tmpQuad.intersects_segment(x1, y1, x2, y2))
					{
						if (c.poly)
						{
							if (c.poly.intersects_segment(tmx + tilerc.left, tmy + tilerc.top, x1, y1, x2, y2))
							{
								collrect_candidates.length = 0;
								return true;
							}
						}
						else
						{
							collrect_candidates.length = 0;
							return true;
						}
					}
				}
			}
			collrect_candidates.length = 0;
			return false;
		}
		else
		{
			if (!b.bquad.intersects_segment(x1, y1, x2, y2))
				return false;
			haspolyb = (b.collision_poly && !b.collision_poly.is_empty());
			if (!haspolyb)
				return true;
			b.collision_poly.cache_poly(b.width, b.height, b.angle);
			return b.collision_poly.intersects_segment(b.x, b.y, x1, y1, x2, y2);
		}
	};
	Runtime.prototype.typeHasBehavior = function (t, b)
	{
		if (!b)
			return false;
		var i, len, j, lenj, f;
		for (i = 0, len = t.behaviors.length; i < len; i++)
		{
			if (t.behaviors[i].behavior instanceof b)
				return true;
		}
		if (!t.is_family)
		{
			for (i = 0, len = t.families.length; i < len; i++)
			{
				f = t.families[i];
				for (j = 0, lenj = f.behaviors.length; j < lenj; j++)
				{
					if (f.behaviors[j].behavior instanceof b)
						return true;
				}
			}
		}
		return false;
	};
	Runtime.prototype.typeHasNoSaveBehavior = function (t)
	{
		return this.typeHasBehavior(t, cr.behaviors.NoSave);
	};
	Runtime.prototype.typeHasPersistBehavior = function (t)
	{
		return this.typeHasBehavior(t, cr.behaviors.Persist);
	};
	Runtime.prototype.getSolidBehavior = function ()
	{
		return this.solidBehavior;
	};
	Runtime.prototype.getJumpthruBehavior = function ()
	{
		return this.jumpthruBehavior;
	};
	var candidates = [];
	Runtime.prototype.testOverlapSolid = function (inst)
	{
		var i, len, s;
		inst.update_bbox();
		this.getSolidCollisionCandidates(inst.layer, inst.bbox, candidates);
		for (i = 0, len = candidates.length; i < len; ++i)
		{
			s = candidates[i];
			if (!s.extra.solidEnabled)
				continue;
			if (this.testOverlap(inst, s))
			{
				candidates.length = 0;
				return s;
			}
		}
		candidates.length = 0;
		return null;
	};
	Runtime.prototype.testRectOverlapSolid = function (r)
	{
		var i, len, s;
		this.getSolidCollisionCandidates(null, r, candidates);
		for (i = 0, len = candidates.length; i < len; ++i)
		{
			s = candidates[i];
			if (!s.extra.solidEnabled)
				continue;
			if (this.testRectOverlap(r, s))
			{
				candidates.length = 0;
				return s;
			}
		}
		candidates.length = 0;
		return null;
	};
	var jumpthru_array_ret = [];
	Runtime.prototype.testOverlapJumpThru = function (inst, all)
	{
		var ret = null;
		if (all)
		{
			ret = jumpthru_array_ret;
			ret.length = 0;
		}
		inst.update_bbox();
		this.getJumpthruCollisionCandidates(inst.layer, inst.bbox, candidates);
		var i, len, j;
		for (i = 0, len = candidates.length; i < len; ++i)
		{
			j = candidates[i];
			if (!j.extra.jumpthruEnabled)
				continue;
			if (this.testOverlap(inst, j))
			{
				if (all)
					ret.push(j);
				else
				{
					candidates.length = 0;
					return j;
				}
			}
		}
		candidates.length = 0;
		return ret;
	};
	Runtime.prototype.pushOutSolid = function (inst, xdir, ydir, dist, include_jumpthrus, specific_jumpthru)
	{
		var push_dist = dist || 50;
		var oldx = inst.x
		var oldy = inst.y;
		var i;
		var last_overlapped = null, secondlast_overlapped = null;
		for (i = 0; i < push_dist; i++)
		{
			inst.x = (oldx + (xdir * i));
			inst.y = (oldy + (ydir * i));
			inst.set_bbox_changed();
			if (!this.testOverlap(inst, last_overlapped))
			{
				last_overlapped = this.testOverlapSolid(inst);
				if (last_overlapped)
					secondlast_overlapped = last_overlapped;
				if (!last_overlapped)
				{
					if (include_jumpthrus)
					{
						if (specific_jumpthru)
							last_overlapped = (this.testOverlap(inst, specific_jumpthru) ? specific_jumpthru : null);
						else
							last_overlapped = this.testOverlapJumpThru(inst);
						if (last_overlapped)
							secondlast_overlapped = last_overlapped;
					}
					if (!last_overlapped)
					{
						if (secondlast_overlapped)
							this.pushInFractional(inst, xdir, ydir, secondlast_overlapped, 16);
						return true;
					}
				}
			}
		}
		inst.x = oldx;
		inst.y = oldy;
		inst.set_bbox_changed();
		return false;
	};
	Runtime.prototype.pushOut = function (inst, xdir, ydir, dist, otherinst)
	{
		var push_dist = dist || 50;
		var oldx = inst.x
		var oldy = inst.y;
		var i;
		for (i = 0; i < push_dist; i++)
		{
			inst.x = (oldx + (xdir * i));
			inst.y = (oldy + (ydir * i));
			inst.set_bbox_changed();
			if (!this.testOverlap(inst, otherinst))
				return true;
		}
		inst.x = oldx;
		inst.y = oldy;
		inst.set_bbox_changed();
		return false;
	};
	Runtime.prototype.pushInFractional = function (inst, xdir, ydir, obj, limit)
	{
		var divisor = 2;
		var frac;
		var forward = false;
		var overlapping = false;
		var bestx = inst.x;
		var besty = inst.y;
		while (divisor <= limit)
		{
			frac = 1 / divisor;
			divisor *= 2;
			inst.x += xdir * frac * (forward ? 1 : -1);
			inst.y += ydir * frac * (forward ? 1 : -1);
			inst.set_bbox_changed();
			if (this.testOverlap(inst, obj))
			{
				forward = true;
				overlapping = true;
			}
			else
			{
				forward = false;
				overlapping = false;
				bestx = inst.x;
				besty = inst.y;
			}
		}
		if (overlapping)
		{
			inst.x = bestx;
			inst.y = besty;
			inst.set_bbox_changed();
		}
	};
	Runtime.prototype.pushOutSolidNearest = function (inst, max_dist_)
	{
		var max_dist = (cr.is_undefined(max_dist_) ? 100 : max_dist_);
		var dist = 0;
		var oldx = inst.x
		var oldy = inst.y;
		var dir = 0;
		var dx = 0, dy = 0;
		var last_overlapped = this.testOverlapSolid(inst);
		if (!last_overlapped)
			return true;		// already clear of solids
		while (dist <= max_dist)
		{
			switch (dir) {
			case 0:		dx = 0; dy = -1; dist++; break;
			case 1:		dx = 1; dy = -1; break;
			case 2:		dx = 1; dy = 0; break;
			case 3:		dx = 1; dy = 1; break;
			case 4:		dx = 0; dy = 1; break;
			case 5:		dx = -1; dy = 1; break;
			case 6:		dx = -1; dy = 0; break;
			case 7:		dx = -1; dy = -1; break;
			}
			dir = (dir + 1) % 8;
			inst.x = cr.floor(oldx + (dx * dist));
			inst.y = cr.floor(oldy + (dy * dist));
			inst.set_bbox_changed();
			if (!this.testOverlap(inst, last_overlapped))
			{
				last_overlapped = this.testOverlapSolid(inst);
				if (!last_overlapped)
					return true;
			}
		}
		inst.x = oldx;
		inst.y = oldy;
		inst.set_bbox_changed();
		return false;
	};
	Runtime.prototype.registerCollision = function (a, b)
	{
		if (!a.collisionsEnabled || !b.collisionsEnabled)
			return;
		this.registered_collisions.push([a, b]);
	};
	Runtime.prototype.checkRegisteredCollision = function (a, b)
	{
		var i, len, x;
		for (i = 0, len = this.registered_collisions.length; i < len; i++)
		{
			x = this.registered_collisions[i];
			if ((x[0] == a && x[1] == b) || (x[0] == b && x[1] == a))
				return true;
		}
		return false;
	};
	Runtime.prototype.calculateSolidBounceAngle = function(inst, startx, starty, obj)
	{
		var objx = inst.x;
		var objy = inst.y;
		var radius = cr.max(10, cr.distanceTo(startx, starty, objx, objy));
		var startangle = cr.angleTo(startx, starty, objx, objy);
		var firstsolid = obj || this.testOverlapSolid(inst);
		if (!firstsolid)
			return cr.clamp_angle(startangle + cr.PI);
		var cursolid = firstsolid;
		var i, curangle, anticlockwise_free_angle, clockwise_free_angle;
		var increment = cr.to_radians(5);	// 5 degree increments
		for (i = 1; i < 36; i++)
		{
			curangle = startangle - i * increment;
			inst.x = startx + Math.cos(curangle) * radius;
			inst.y = starty + Math.sin(curangle) * radius;
			inst.set_bbox_changed();
			if (!this.testOverlap(inst, cursolid))
			{
				cursolid = obj ? null : this.testOverlapSolid(inst);
				if (!cursolid)
				{
					anticlockwise_free_angle = curangle;
					break;
				}
			}
		}
		if (i === 36)
			anticlockwise_free_angle = cr.clamp_angle(startangle + cr.PI);
		var cursolid = firstsolid;
		for (i = 1; i < 36; i++)
		{
			curangle = startangle + i * increment;
			inst.x = startx + Math.cos(curangle) * radius;
			inst.y = starty + Math.sin(curangle) * radius;
			inst.set_bbox_changed();
			if (!this.testOverlap(inst, cursolid))
			{
				cursolid = obj ? null : this.testOverlapSolid(inst);
				if (!cursolid)
				{
					clockwise_free_angle = curangle;
					break;
				}
			}
		}
		if (i === 36)
			clockwise_free_angle = cr.clamp_angle(startangle + cr.PI);
		inst.x = objx;
		inst.y = objy;
		inst.set_bbox_changed();
		if (clockwise_free_angle === anticlockwise_free_angle)
			return clockwise_free_angle;
		var half_diff = cr.angleDiff(clockwise_free_angle, anticlockwise_free_angle) / 2;
		var normal;
		if (cr.angleClockwise(clockwise_free_angle, anticlockwise_free_angle))
		{
			normal = cr.clamp_angle(anticlockwise_free_angle + half_diff + cr.PI);
		}
		else
		{
			normal = cr.clamp_angle(clockwise_free_angle + half_diff);
		}
;
		var vx = Math.cos(startangle);
		var vy = Math.sin(startangle);
		var nx = Math.cos(normal);
		var ny = Math.sin(normal);
		var v_dot_n = vx * nx + vy * ny;
		var rx = vx - 2 * v_dot_n * nx;
		var ry = vy - 2 * v_dot_n * ny;
		return cr.angleTo(0, 0, rx, ry);
	};
	var triggerSheetIndex = -1;
	Runtime.prototype.trigger = function (method, inst, value /* for fast triggers */)
	{
;
		if (!this.running_layout)
			return false;
		var sheet = this.running_layout.event_sheet;
		if (!sheet)
			return false;     // no event sheet active; nothing to trigger
		var ret = false;
		var r, i, len;
		triggerSheetIndex++;
		var deep_includes = sheet.deep_includes;
		for (i = 0, len = deep_includes.length; i < len; ++i)
		{
			r = this.triggerOnSheet(method, inst, deep_includes[i], value);
			ret = ret || r;
		}
		r = this.triggerOnSheet(method, inst, sheet, value);
		ret = ret || r;
		triggerSheetIndex--;
		return ret;
    };
    Runtime.prototype.triggerOnSheet = function (method, inst, sheet, value)
    {
        var ret = false;
		var i, leni, r, families;
		if (!inst)
		{
			r = this.triggerOnSheetForTypeName(method, inst, "system", sheet, value);
			ret = ret || r;
		}
		else
		{
			r = this.triggerOnSheetForTypeName(method, inst, inst.type.name, sheet, value);
			ret = ret || r;
			families = inst.type.families;
			for (i = 0, leni = families.length; i < leni; ++i)
			{
				r = this.triggerOnSheetForTypeName(method, inst, families[i].name, sheet, value);
				ret = ret || r;
			}
		}
		return ret;             // true if anything got triggered
	};
	Runtime.prototype.triggerOnSheetForTypeName = function (method, inst, type_name, sheet, value)
	{
		var i, leni;
		var ret = false, ret2 = false;
		var trig, index;
		var fasttrigger = (typeof value !== "undefined");
		var triggers = (fasttrigger ? sheet.fasttriggers : sheet.triggers);
		var obj_entry = triggers[type_name];
		if (!obj_entry)
			return ret;
		var triggers_list = null;
		for (i = 0, leni = obj_entry.length; i < leni; ++i)
		{
			if (obj_entry[i].method == method)
			{
				triggers_list = obj_entry[i].evs;
				break;
			}
		}
		if (!triggers_list)
			return ret;
		var triggers_to_fire;
		if (fasttrigger)
		{
			triggers_to_fire = triggers_list[value];
		}
		else
		{
			triggers_to_fire = triggers_list;
		}
		if (!triggers_to_fire)
			return null;
		for (i = 0, leni = triggers_to_fire.length; i < leni; i++)
		{
			trig = triggers_to_fire[i][0];
			index = triggers_to_fire[i][1];
			ret2 = this.executeSingleTrigger(inst, type_name, trig, index);
			ret = ret || ret2;
		}
		return ret;
	};
	Runtime.prototype.executeSingleTrigger = function (inst, type_name, trig, index)
	{
		var i, leni;
		var ret = false;
		this.trigger_depth++;
		var current_event = this.getCurrentEventStack().current_event;
		if (current_event)
			this.pushCleanSol(current_event.solModifiersIncludingParents);
		var isrecursive = (this.trigger_depth > 1);		// calling trigger from inside another trigger
		this.pushCleanSol(trig.solModifiersIncludingParents);
		if (isrecursive)
			this.pushLocalVarStack();
		var event_stack = this.pushEventStack(trig);
		event_stack.current_event = trig;
		if (inst)
		{
			var sol = this.types[type_name].getCurrentSol();
			sol.select_all = false;
			sol.instances.length = 1;
			sol.instances[0] = inst;
			this.types[type_name].applySolToContainer();
		}
		var ok_to_run = true;
		if (trig.parent)
		{
			var temp_parents_arr = event_stack.temp_parents_arr;
			var cur_parent = trig.parent;
			while (cur_parent)
			{
				temp_parents_arr.push(cur_parent);
				cur_parent = cur_parent.parent;
			}
			temp_parents_arr.reverse();
			for (i = 0, leni = temp_parents_arr.length; i < leni; i++)
			{
				if (!temp_parents_arr[i].run_pretrigger())   // parent event failed
				{
					ok_to_run = false;
					break;
				}
			}
		}
		if (ok_to_run)
		{
			this.execcount++;
			if (trig.orblock)
				trig.run_orblocktrigger(index);
			else
				trig.run();
			ret = ret || event_stack.last_event_true;
		}
		this.popEventStack();
		if (isrecursive)
			this.popLocalVarStack();
		this.popSol(trig.solModifiersIncludingParents);
		if (current_event)
			this.popSol(current_event.solModifiersIncludingParents);
		if (this.isInOnDestroy === 0 && triggerSheetIndex === 0 && !this.isRunningEvents && (!this.deathRow.isEmpty() || this.createRow.length))
		{
			this.ClearDeathRow();
		}
		this.trigger_depth--;
		return ret;
	};
	Runtime.prototype.getCurrentCondition = function ()
	{
		var evinfo = this.getCurrentEventStack();
		return evinfo.current_event.conditions[evinfo.cndindex];
	};
	Runtime.prototype.getCurrentAction = function ()
	{
		var evinfo = this.getCurrentEventStack();
		return evinfo.current_event.actions[evinfo.actindex];
	};
	Runtime.prototype.pushLocalVarStack = function ()
	{
		this.localvar_stack_index++;
		if (this.localvar_stack_index >= this.localvar_stack.length)
			this.localvar_stack.push([]);
	};
	Runtime.prototype.popLocalVarStack = function ()
	{
;
		this.localvar_stack_index--;
	};
	Runtime.prototype.getCurrentLocalVarStack = function ()
	{
		return this.localvar_stack[this.localvar_stack_index];
	};
	Runtime.prototype.pushEventStack = function (cur_event)
	{
		this.event_stack_index++;
		if (this.event_stack_index >= this.event_stack.length)
			this.event_stack.push(new cr.eventStackFrame());
		var ret = this.getCurrentEventStack();
		ret.reset(cur_event);
		return ret;
	};
	Runtime.prototype.popEventStack = function ()
	{
;
		this.event_stack_index--;
	};
	Runtime.prototype.getCurrentEventStack = function ()
	{
		return this.event_stack[this.event_stack_index];
	};
	Runtime.prototype.pushLoopStack = function (name_)
	{
		this.loop_stack_index++;
		if (this.loop_stack_index >= this.loop_stack.length)
		{
			this.loop_stack.push(cr.seal({ name: name_, index: 0, stopped: false }));
		}
		var ret = this.getCurrentLoop();
		ret.name = name_;
		ret.index = 0;
		ret.stopped = false;
		return ret;
	};
	Runtime.prototype.popLoopStack = function ()
	{
;
		this.loop_stack_index--;
	};
	Runtime.prototype.getCurrentLoop = function ()
	{
		return this.loop_stack[this.loop_stack_index];
	};
	Runtime.prototype.getEventVariableByName = function (name, scope)
	{
		var i, leni, j, lenj, sheet, e;
		while (scope)
		{
			for (i = 0, leni = scope.subevents.length; i < leni; i++)
			{
				e = scope.subevents[i];
				if (e instanceof cr.eventvariable && cr.equals_nocase(name, e.name))
					return e;
			}
			scope = scope.parent;
		}
		for (i = 0, leni = this.eventsheets_by_index.length; i < leni; i++)
		{
			sheet = this.eventsheets_by_index[i];
			for (j = 0, lenj = sheet.events.length; j < lenj; j++)
			{
				e = sheet.events[j];
				if (e instanceof cr.eventvariable && cr.equals_nocase(name, e.name))
					return e;
			}
		}
		return null;
	};
	Runtime.prototype.getLayoutBySid = function (sid_)
	{
		var i, len;
		for (i = 0, len = this.layouts_by_index.length; i < len; i++)
		{
			if (this.layouts_by_index[i].sid === sid_)
				return this.layouts_by_index[i];
		}
		return null;
	};
	Runtime.prototype.getObjectTypeBySid = function (sid_)
	{
		var i, len;
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			if (this.types_by_index[i].sid === sid_)
				return this.types_by_index[i];
		}
		return null;
	};
	Runtime.prototype.getGroupBySid = function (sid_)
	{
		var i, len;
		for (i = 0, len = this.allGroups.length; i < len; i++)
		{
			if (this.allGroups[i].sid === sid_)
				return this.allGroups[i];
		}
		return null;
	};
	function makeSaveDb(e)
	{
		var db = e.target.result;
		db.createObjectStore("saves", { keyPath: "slot" });
	};
	function IndexedDB_WriteSlot(slot_, data_, oncomplete_, onerror_)
	{
		var request = indexedDB.open("_C2SaveStates");
		request.onupgradeneeded = makeSaveDb;
		request.onerror = onerror_;
		request.onsuccess = function (e)
		{
			var db = e.target.result;
			db.onerror = onerror_;
			var transaction = db.transaction(["saves"], "readwrite");
			var objectStore = transaction.objectStore("saves");
			var putReq = objectStore.put({"slot": slot_, "data": data_ });
			putReq.onsuccess = oncomplete_;
		};
	};
	function IndexedDB_ReadSlot(slot_, oncomplete_, onerror_)
	{
		var request = indexedDB.open("_C2SaveStates");
		request.onupgradeneeded = makeSaveDb;
		request.onerror = onerror_;
		request.onsuccess = function (e)
		{
			var db = e.target.result;
			db.onerror = onerror_;
			var transaction = db.transaction(["saves"]);
			var objectStore = transaction.objectStore("saves");
			var readReq = objectStore.get(slot_);
			readReq.onsuccess = function (e)
			{
				if (readReq.result)
					oncomplete_(readReq.result["data"]);
				else
					oncomplete_(null);
			};
		};
	};
	Runtime.prototype.signalContinuousPreview = function ()
	{
		this.signalledContinuousPreview = true;
	};
	function doContinuousPreviewReload()
	{
		cr.logexport("Reloading for continuous preview");
		if (!!window["c2cocoonjs"])
		{
			CocoonJS["App"]["reload"]();
		}
		else
		{
			if (window.location.search.indexOf("continuous") > -1)
				window.location.reload(true);
			else
				window.location = window.location + "?continuous";
		}
	};
	Runtime.prototype.handleSaveLoad = function ()
	{
		var self = this;
		var savingToSlot = this.saveToSlot;
		var savingJson = this.lastSaveJson;
		var loadingFromSlot = this.loadFromSlot;
		var continuous = false;
		if (this.signalledContinuousPreview)
		{
			continuous = true;
			savingToSlot = "__c2_continuouspreview";
			this.signalledContinuousPreview = false;
		}
		if (savingToSlot.length)
		{
			this.ClearDeathRow();
			savingJson = this.saveToJSONString();
			if (window.indexedDB && !this.isCocoonJs)
			{
				IndexedDB_WriteSlot(savingToSlot, savingJson, function ()
				{
					cr.logexport("Saved state to IndexedDB storage (" + savingJson.length + " bytes)");
					self.lastSaveJson = savingJson;
					self.trigger(cr.system_object.prototype.cnds.OnSaveComplete, null);
					self.lastSaveJson = "";
					if (continuous)
						doContinuousPreviewReload();
				}, function (e)
				{
					try {
						localStorage.setItem("__c2save_" + savingToSlot, savingJson);
						cr.logexport("Saved state to WebStorage (" + savingJson.length + " bytes)");
						self.lastSaveJson = savingJson;
						self.trigger(cr.system_object.prototype.cnds.OnSaveComplete, null);
						self.lastSaveJson = "";
						if (continuous)
							doContinuousPreviewReload();
					}
					catch (f)
					{
						cr.logexport("Failed to save game state: " + e + "; " + f);
					}
				});
			}
			else
			{
				try {
					localStorage.setItem("__c2save_" + savingToSlot, savingJson);
					cr.logexport("Saved state to WebStorage (" + savingJson.length + " bytes)");
					self.lastSaveJson = savingJson;
					this.trigger(cr.system_object.prototype.cnds.OnSaveComplete, null);
					self.lastSaveJson = "";
					if (continuous)
						doContinuousPreviewReload();
				}
				catch (e)
				{
					cr.logexport("Error saving to WebStorage: " + e);
				}
			}
			this.saveToSlot = "";
			this.loadFromSlot = "";
			this.loadFromJson = "";
		}
		if (loadingFromSlot.length)
		{
			if (window.indexedDB && !this.isCocoonJs)
			{
				IndexedDB_ReadSlot(loadingFromSlot, function (result_)
				{
					if (result_)
					{
						self.loadFromJson = result_;
						cr.logexport("Loaded state from IndexedDB storage (" + self.loadFromJson.length + " bytes)");
					}
					else
					{
						self.loadFromJson = localStorage.getItem("__c2save_" + loadingFromSlot) || "";
						cr.logexport("Loaded state from WebStorage (" + self.loadFromJson.length + " bytes)");
					}
					self.suspendDrawing = false;
					if (!self.loadFromJson.length)
						self.trigger(cr.system_object.prototype.cnds.OnLoadFailed, null);
				}, function (e)
				{
					self.loadFromJson = localStorage.getItem("__c2save_" + loadingFromSlot) || "";
					cr.logexport("Loaded state from WebStorage (" + self.loadFromJson.length + " bytes)");
					self.suspendDrawing = false;
					if (!self.loadFromJson.length)
						self.trigger(cr.system_object.prototype.cnds.OnLoadFailed, null);
				});
			}
			else
			{
				this.loadFromJson = localStorage.getItem("__c2save_" + loadingFromSlot) || "";
				cr.logexport("Loaded state from WebStorage (" + this.loadFromJson.length + " bytes)");
				this.suspendDrawing = false;
				if (!self.loadFromJson.length)
					self.trigger(cr.system_object.prototype.cnds.OnLoadFailed, null);
			}
			this.loadFromSlot = "";
			this.saveToSlot = "";
		}
		if (this.loadFromJson.length)
		{
			this.ClearDeathRow();
			this.loadFromJSONString(this.loadFromJson);
			this.lastSaveJson = this.loadFromJson;
			this.trigger(cr.system_object.prototype.cnds.OnLoadComplete, null);
			this.lastSaveJson = "";
			this.loadFromJson = "";
		}
	};
	function CopyExtraObject(extra)
	{
		var p, ret = {};
		for (p in extra)
		{
			if (extra.hasOwnProperty(p))
			{
				if (extra[p] instanceof cr.ObjectSet)
					continue;
				if (extra[p] && typeof extra[p].c2userdata !== "undefined")
					continue;
				ret[p] = extra[p];
			}
		}
		return ret;
	};
	Runtime.prototype.saveToJSONString = function()
	{
		var i, len, j, lenj, type, layout, typeobj, g, c, a, v, p;
		var o = {
			"c2save":				true,
			"version":				1,
			"rt": {
				"time":				this.kahanTime.sum,
				"timescale":		this.timescale,
				"tickcount":		this.tickcount,
				"execcount":		this.execcount,
				"next_uid":			this.next_uid,
				"running_layout":	this.running_layout.sid,
				"start_time_offset": (Date.now() - this.start_time)
			},
			"types": {},
			"layouts": {},
			"events": {
				"groups": {},
				"cnds": {},
				"acts": {},
				"vars": {}
			}
		};
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			type = this.types_by_index[i];
			if (type.is_family || this.typeHasNoSaveBehavior(type))
				continue;
			typeobj = {
				"instances": []
			};
			if (cr.hasAnyOwnProperty(type.extra))
				typeobj["ex"] = CopyExtraObject(type.extra);
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
			{
				typeobj["instances"].push(this.saveInstanceToJSON(type.instances[j]));
			}
			o["types"][type.sid.toString()] = typeobj;
		}
		for (i = 0, len = this.layouts_by_index.length; i < len; i++)
		{
			layout = this.layouts_by_index[i];
			o["layouts"][layout.sid.toString()] = layout.saveToJSON();
		}
		var ogroups = o["events"]["groups"];
		for (i = 0, len = this.allGroups.length; i < len; i++)
		{
			g = this.allGroups[i];
			ogroups[g.sid.toString()] = this.groups_by_name[g.group_name].group_active;
		}
		var ocnds = o["events"]["cnds"];
		for (p in this.cndsBySid)
		{
			if (this.cndsBySid.hasOwnProperty(p))
			{
				c = this.cndsBySid[p];
				if (cr.hasAnyOwnProperty(c.extra))
					ocnds[p] = { "ex": CopyExtraObject(c.extra) };
			}
		}
		var oacts = o["events"]["acts"];
		for (p in this.actsBySid)
		{
			if (this.actsBySid.hasOwnProperty(p))
			{
				a = this.actsBySid[p];
				if (cr.hasAnyOwnProperty(a.extra))
					oacts[p] = { "ex": a.extra };
			}
		}
		var ovars = o["events"]["vars"];
		for (p in this.varsBySid)
		{
			if (this.varsBySid.hasOwnProperty(p))
			{
				v = this.varsBySid[p];
				if (!v.is_constant && (!v.parent || v.is_static))
					ovars[p] = v.data;
			}
		}
		o["system"] = this.system.saveToJSON();
		return JSON.stringify(o);
	};
	Runtime.prototype.refreshUidMap = function ()
	{
		var i, len, type, j, lenj, inst;
		this.objectsByUid = {};
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			type = this.types_by_index[i];
			if (type.is_family)
				continue;
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
			{
				inst = type.instances[j];
				this.objectsByUid[inst.uid.toString()] = inst;
			}
		}
	};
	Runtime.prototype.loadFromJSONString = function (str)
	{
		var o = JSON.parse(str);
		if (!o["c2save"])
			return;		// probably not a c2 save state
		if (o["version"] > 1)
			return;		// from future version of c2; assume not compatible
		var rt = o["rt"];
		this.kahanTime.reset();
		this.kahanTime.sum = rt["time"];
		this.timescale = rt["timescale"];
		this.tickcount = rt["tickcount"];
		this.start_time = Date.now() - rt["start_time_offset"];
		var layout_sid = rt["running_layout"];
		if (layout_sid !== this.running_layout.sid)
		{
			var changeToLayout = this.getLayoutBySid(layout_sid);
			if (changeToLayout)
				this.doChangeLayout(changeToLayout);
			else
				return;		// layout that was saved on has gone missing (deleted?)
		}
		this.isLoadingState = true;
		var i, len, j, lenj, k, lenk, p, type, existing_insts, load_insts, inst, binst, layout, layer, g, iid, t;
		var otypes = o["types"];
		for (p in otypes)
		{
			if (otypes.hasOwnProperty(p))
			{
				type = this.getObjectTypeBySid(parseInt(p, 10));
				if (!type || type.is_family || this.typeHasNoSaveBehavior(type))
					continue;
				if (otypes[p]["ex"])
					type.extra = otypes[p]["ex"];
				else
					cr.wipe(type.extra);
				existing_insts = type.instances;
				load_insts = otypes[p]["instances"];
				for (i = 0, len = cr.min(existing_insts.length, load_insts.length); i < len; i++)
				{
					this.loadInstanceFromJSON(existing_insts[i], load_insts[i]);
				}
				for (i = load_insts.length, len = existing_insts.length; i < len; i++)
					this.DestroyInstance(existing_insts[i]);
				for (i = existing_insts.length, len = load_insts.length; i < len; i++)
				{
					layer = null;
					if (type.plugin.is_world)
					{
						layer = this.running_layout.getLayerBySid(load_insts[i]["w"]["l"]);
						if (!layer)
							continue;
					}
					inst = this.createInstanceFromInit(type.default_instance, layer, false, 0, 0, true);
					this.loadInstanceFromJSON(inst, load_insts[i]);
				}
				type.stale_iids = true;
			}
		}
		this.ClearDeathRow();
		this.refreshUidMap();
		var olayouts = o["layouts"];
		for (p in olayouts)
		{
			if (olayouts.hasOwnProperty(p))
			{
				layout = this.getLayoutBySid(parseInt(p, 10));
				if (!layout)
					continue;		// must've gone missing
				layout.loadFromJSON(olayouts[p]);
			}
		}
		var ogroups = o["events"]["groups"];
		for (p in ogroups)
		{
			if (ogroups.hasOwnProperty(p))
			{
				g = this.getGroupBySid(parseInt(p, 10));
				if (g && this.groups_by_name[g.group_name])
					this.groups_by_name[g.group_name].group_active = ogroups[p];
			}
		}
		var ocnds = o["events"]["cnds"];
		for (p in ocnds)
		{
			if (ocnds.hasOwnProperty(p) && this.cndsBySid.hasOwnProperty(p))
			{
				this.cndsBySid[p].extra = ocnds[p]["ex"];
			}
		}
		var oacts = o["events"]["acts"];
		for (p in oacts)
		{
			if (oacts.hasOwnProperty(p) && this.actsBySid.hasOwnProperty(p))
			{
				this.actsBySid[p].extra = oacts[p]["ex"];
			}
		}
		var ovars = o["events"]["vars"];
		for (p in ovars)
		{
			if (ovars.hasOwnProperty(p) && this.varsBySid.hasOwnProperty(p))
			{
				this.varsBySid[p].data = ovars[p];
			}
		}
		this.next_uid = rt["next_uid"];
		this.isLoadingState = false;
		this.system.loadFromJSON(o["system"]);
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			type = this.types_by_index[i];
			if (type.is_family)
				continue;
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
			{
				inst = type.instances[j];
				if (type.is_contained)
				{
					iid = inst.get_iid();
					inst.siblings.length = 0;
					for (k = 0, lenk = type.container.length; k < lenk; k++)
					{
						t = type.container[k];
						if (type === t)
							continue;
;
						inst.siblings.push(t.instances[iid]);
					}
				}
				if (inst.afterLoad)
					inst.afterLoad();
				if (inst.behavior_insts)
				{
					for (k = 0, lenk = inst.behavior_insts.length; k < lenk; k++)
					{
						binst = inst.behavior_insts[k];
						if (binst.afterLoad)
							binst.afterLoad();
					}
				}
			}
		}
		this.redraw = true;
	};
	Runtime.prototype.saveInstanceToJSON = function(inst, state_only)
	{
		var i, len, world, behinst, et;
		var type = inst.type;
		var plugin = type.plugin;
		var o = {};
		if (state_only)
			o["c2"] = true;		// mark as known json data from Construct 2
		else
			o["uid"] = inst.uid;
		if (cr.hasAnyOwnProperty(inst.extra))
			o["ex"] = CopyExtraObject(inst.extra);
		if (inst.instance_vars && inst.instance_vars.length)
		{
			o["ivs"] = {};
			for (i = 0, len = inst.instance_vars.length; i < len; i++)
			{
				o["ivs"][inst.type.instvar_sids[i].toString()] = inst.instance_vars[i];
			}
		}
		if (plugin.is_world)
		{
			world = {
				"x": inst.x,
				"y": inst.y,
				"w": inst.width,
				"h": inst.height,
				"l": inst.layer.sid,
				"zi": inst.get_zindex()
			};
			if (inst.angle !== 0)
				world["a"] = inst.angle;
			if (inst.opacity !== 1)
				world["o"] = inst.opacity;
			if (inst.hotspotX !== 0.5)
				world["hX"] = inst.hotspotX;
			if (inst.hotspotY !== 0.5)
				world["hY"] = inst.hotspotY;
			if (inst.blend_mode !== 0)
				world["bm"] = inst.blend_mode;
			if (!inst.visible)
				world["v"] = inst.visible;
			if (!inst.collisionsEnabled)
				world["ce"] = inst.collisionsEnabled;
			if (inst.my_timescale !== -1)
				world["mts"] = inst.my_timescale;
			if (type.effect_types.length)
			{
				world["fx"] = [];
				for (i = 0, len = type.effect_types.length; i < len; i++)
				{
					et = type.effect_types[i];
					world["fx"].push({"name": et.name,
									  "active": inst.active_effect_flags[et.index],
									  "params": inst.effect_params[et.index] });
				}
			}
			o["w"] = world;
		}
		if (inst.behavior_insts && inst.behavior_insts.length)
		{
			o["behs"] = {};
			for (i = 0, len = inst.behavior_insts.length; i < len; i++)
			{
				behinst = inst.behavior_insts[i];
				if (behinst.saveToJSON)
					o["behs"][behinst.type.sid.toString()] = behinst.saveToJSON();
			}
		}
		if (inst.saveToJSON)
			o["data"] = inst.saveToJSON();
		return o;
	};
	Runtime.prototype.getInstanceVarIndexBySid = function (type, sid_)
	{
		var i, len;
		for (i = 0, len = type.instvar_sids.length; i < len; i++)
		{
			if (type.instvar_sids[i] === sid_)
				return i;
		}
		return -1;
	};
	Runtime.prototype.getBehaviorIndexBySid = function (inst, sid_)
	{
		var i, len;
		for (i = 0, len = inst.behavior_insts.length; i < len; i++)
		{
			if (inst.behavior_insts[i].type.sid === sid_)
				return i;
		}
		return -1;
	};
	Runtime.prototype.loadInstanceFromJSON = function(inst, o, state_only)
	{
		var p, i, len, iv, oivs, world, fxindex, obehs, behindex;
		var oldlayer;
		var type = inst.type;
		var plugin = type.plugin;
		if (state_only)
		{
			if (!o["c2"])
				return;
		}
		else
			inst.uid = o["uid"];
		if (o["ex"])
			inst.extra = o["ex"];
		else
			cr.wipe(inst.extra);
		oivs = o["ivs"];
		if (oivs)
		{
			for (p in oivs)
			{
				if (oivs.hasOwnProperty(p))
				{
					iv = this.getInstanceVarIndexBySid(type, parseInt(p, 10));
					if (iv < 0 || iv >= inst.instance_vars.length)
						continue;		// must've gone missing
					inst.instance_vars[iv] = oivs[p];
				}
			}
		}
		if (plugin.is_world)
		{
			world = o["w"];
			if (inst.layer.sid !== world["l"])
			{
				oldlayer = inst.layer;
				inst.layer = this.running_layout.getLayerBySid(world["l"]);
				if (inst.layer)
				{
					inst.layer.instances.push(inst);
					inst.layer.zindices_stale = true;
					cr.arrayFindRemove(oldlayer.instances, inst);
					oldlayer.zindices_stale = true;
				}
				else
				{
					inst.layer = oldlayer;
					this.DestroyInstance(inst);
				}
			}
			inst.x = world["x"];
			inst.y = world["y"];
			inst.width = world["w"];
			inst.height = world["h"];
			inst.zindex = world["zi"];
			inst.angle = world.hasOwnProperty("a") ? world["a"] : 0;
			inst.opacity = world.hasOwnProperty("o") ? world["o"] : 1;
			inst.hotspotX = world.hasOwnProperty("hX") ? world["hX"] : 0.5;
			inst.hotspotY = world.hasOwnProperty("hY") ? world["hY"] : 0.5;
			inst.visible = world.hasOwnProperty("v") ? world["v"] : true;
			inst.collisionsEnabled = world.hasOwnProperty("ce") ? world["ce"] : true;
			inst.my_timescale = world.hasOwnProperty("mts") ? world["mts"] : -1;
			inst.blend_mode = world.hasOwnProperty("bm") ? world["bm"] : 0;;
			inst.compositeOp = cr.effectToCompositeOp(inst.blend_mode);
			if (this.gl)
				cr.setGLBlend(inst, inst.blend_mode, this.gl);
			inst.set_bbox_changed();
			if (world.hasOwnProperty("fx"))
			{
				for (i = 0, len = world["fx"].length; i < len; i++)
				{
					fxindex = type.getEffectIndexByName(world["fx"][i]["name"]);
					if (fxindex < 0)
						continue;		// must've gone missing
					inst.active_effect_flags[fxindex] = world["fx"][i]["active"];
					inst.effect_params[fxindex] = world["fx"][i]["params"];
				}
			}
			inst.updateActiveEffects();
		}
		obehs = o["behs"];
		if (obehs)
		{
			for (p in obehs)
			{
				if (obehs.hasOwnProperty(p))
				{
					behindex = this.getBehaviorIndexBySid(inst, parseInt(p, 10));
					if (behindex < 0)
						continue;		// must've gone missing
					inst.behavior_insts[behindex].loadFromJSON(obehs[p]);
				}
			}
		}
		if (o["data"])
			inst.loadFromJSON(o["data"]);
	};
	cr.runtime = Runtime;
	cr.createRuntime = function (canvasid)
	{
		return new Runtime(document.getElementById(canvasid));
	};
	cr.createDCRuntime = function (w, h)
	{
		return new Runtime({ "dc": true, "width": w, "height": h });
	};
	window["cr_createRuntime"] = cr.createRuntime;
	window["cr_createDCRuntime"] = cr.createDCRuntime;
	window["createCocoonJSRuntime"] = function ()
	{
		window["c2cocoonjs"] = true;
		var canvas = document.createElement("screencanvas") || document.createElement("canvas");
		canvas.screencanvas = true;
		document.body.appendChild(canvas);
		var rt = new Runtime(canvas);
		window["c2runtime"] = rt;
		window.addEventListener("orientationchange", function () {
			window["c2runtime"]["setSize"](window.innerWidth, window.innerHeight);
		});
		window["c2runtime"]["setSize"](window.innerWidth, window.innerHeight);
		return rt;
	};
	window["createEjectaRuntime"] = function ()
	{
		var canvas = document.getElementById("canvas");
		var rt = new Runtime(canvas);
		window["c2runtime"] = rt;
		window["c2runtime"]["setSize"](window.innerWidth, window.innerHeight);
		return rt;
	};
}());
window["cr_getC2Runtime"] = function()
{
	var canvas = document.getElementById("c2canvas");
	if (canvas)
		return canvas["c2runtime"];
	else if (window["c2runtime"])
		return window["c2runtime"];
	else
		return null;
}
window["cr_sizeCanvas"] = function(w, h)
{
	if (w === 0 || h === 0)
		return;
	var runtime = window["cr_getC2Runtime"]();
	if (runtime)
		runtime["setSize"](w, h);
}
window["cr_setSuspended"] = function(s)
{
	var runtime = window["cr_getC2Runtime"]();
	if (runtime)
		runtime["setSuspended"](s);
}
;
(function()
{
	function Layout(runtime, m)
	{
		this.runtime = runtime;
		this.event_sheet = null;
		this.scrollX = (this.runtime.original_width / 2);
		this.scrollY = (this.runtime.original_height / 2);
		this.scale = 1.0;
		this.angle = 0;
		this.first_visit = true;
		this.name = m[0];
		this.width = m[1];
		this.height = m[2];
		this.unbounded_scrolling = m[3];
		this.sheetname = m[4];
		this.sid = m[5];
		var lm = m[6];
		var i, len;
		this.layers = [];
		this.initial_types = [];
		for (i = 0, len = lm.length; i < len; i++)
		{
			var layer = new cr.layer(this, lm[i]);
			layer.number = i;
			cr.seal(layer);
			this.layers.push(layer);
		}
		var im = m[7];
		this.initial_nonworld = [];
		for (i = 0, len = im.length; i < len; i++)
		{
			var inst = im[i];
			var type = this.runtime.types_by_index[inst[1]];
;
			if (!type.default_instance)
				type.default_instance = inst;
			this.initial_nonworld.push(inst);
			if (this.initial_types.indexOf(type) === -1)
				this.initial_types.push(type);
		}
		this.effect_types = [];
		this.active_effect_types = [];
		this.effect_params = [];
		for (i = 0, len = m[8].length; i < len; i++)
		{
			this.effect_types.push({
				id: m[8][i][0],
				name: m[8][i][1],
				shaderindex: -1,
				active: true,
				index: i
			});
			this.effect_params.push(m[8][i][2].slice(0));
		}
		this.updateActiveEffects();
		this.rcTex = new cr.rect(0, 0, 1, 1);
		this.rcTex2 = new cr.rect(0, 0, 1, 1);
		this.persist_data = {};
	};
	Layout.prototype.saveObjectToPersist = function (inst)
	{
		var sidStr = inst.type.sid.toString();
		if (!this.persist_data.hasOwnProperty(sidStr))
			this.persist_data[sidStr] = [];
		var type_persist = this.persist_data[sidStr];
		type_persist.push(this.runtime.saveInstanceToJSON(inst));
	};
	Layout.prototype.hasOpaqueBottomLayer = function ()
	{
		var layer = this.layers[0];
		return !layer.transparent && layer.opacity === 1.0 && !layer.forceOwnTexture && layer.visible;
	};
	Layout.prototype.updateActiveEffects = function ()
	{
		this.active_effect_types.length = 0;
		var i, len, et;
		for (i = 0, len = this.effect_types.length; i < len; i++)
		{
			et = this.effect_types[i];
			if (et.active)
				this.active_effect_types.push(et);
		}
	};
	Layout.prototype.getEffectByName = function (name_)
	{
		var i, len, et;
		for (i = 0, len = this.effect_types.length; i < len; i++)
		{
			et = this.effect_types[i];
			if (et.name === name_)
				return et;
		}
		return null;
	};
	var created_instances = [];
	Layout.prototype.startRunning = function ()
	{
		if (this.sheetname)
		{
			this.event_sheet = this.runtime.eventsheets[this.sheetname];
;
			this.event_sheet.updateDeepIncludes();
		}
		this.runtime.running_layout = this;
		this.scrollX = (this.runtime.original_width / 2);
		this.scrollY = (this.runtime.original_height / 2);
		var i, k, len, lenk, type, type_instances, inst, iid, t, s, p, q, type_data, layer;
		for (i = 0, len = this.runtime.types_by_index.length; i < len; i++)
		{
			type = this.runtime.types_by_index[i];
			if (type.is_family)
				continue;		// instances are only transferred for their real type
			type_instances = type.instances;
			for (k = 0, lenk = type_instances.length; k < lenk; k++)
			{
				inst = type_instances[k];
				if (inst.layer)
				{
					var num = inst.layer.number;
					if (num >= this.layers.length)
						num = this.layers.length - 1;
					inst.layer = this.layers[num];
					inst.layer.instances.push(inst);
					inst.layer.zindices_stale = true;
				}
			}
		}
		var layer;
		created_instances.length = 0;
		this.boundScrolling();
		for (i = 0, len = this.layers.length; i < len; i++)
		{
			layer = this.layers[i];
			layer.createInitialInstances();		// fills created_instances
			layer.disableAngle = true;
			var px = layer.canvasToLayer(0, 0, true, true);
			var py = layer.canvasToLayer(0, 0, false, true);
			layer.disableAngle = false;
			if (this.runtime.pixel_rounding)
			{
				px = (px + 0.5) | 0;
				py = (py + 0.5) | 0;
			}
			layer.rotateViewport(px, py, null);
		}
		var uids_changed = false;
		if (!this.first_visit)
		{
			for (p in this.persist_data)
			{
				if (this.persist_data.hasOwnProperty(p))
				{
					type = this.runtime.getObjectTypeBySid(parseInt(p, 10));
					if (!type || type.is_family || !this.runtime.typeHasPersistBehavior(type))
						continue;
					type_data = this.persist_data[p];
					for (i = 0, len = type_data.length; i < len; i++)
					{
						layer = null;
						if (type.plugin.is_world)
						{
							layer = this.getLayerBySid(type_data[i]["w"]["l"]);
							if (!layer)
								continue;
						}
						inst = this.runtime.createInstanceFromInit(type.default_instance, layer, false, 0, 0, true);
						this.runtime.loadInstanceFromJSON(inst, type_data[i]);
						uids_changed = true;
						created_instances.push(inst);
					}
					type_data.length = 0;
				}
			}
			for (i = 0, len = this.layers.length; i < len; i++)
			{
				this.layers[i].instances.sort(sortInstanceByZIndex);
				this.layers[i].zindices_stale = true;		// in case of duplicates/holes
			}
		}
		if (uids_changed)
		{
			this.runtime.ClearDeathRow();
			this.runtime.refreshUidMap();
		}
		for (i = 0; i < created_instances.length; i++)
		{
			inst = created_instances[i];
			if (!inst.type.is_contained)
				continue;
			iid = inst.get_iid();
			for (k = 0, lenk = inst.type.container.length; k < lenk; k++)
			{
				t = inst.type.container[k];
				if (inst.type === t)
					continue;
				if (t.instances.length > iid)
					inst.siblings.push(t.instances[iid]);
				else
				{
					if (!t.default_instance)
					{
					}
					else
					{
						s = this.runtime.createInstanceFromInit(t.default_instance, inst.layer, true, inst.x, inst.y, true);
						this.runtime.ClearDeathRow();
						t.updateIIDs();
						inst.siblings.push(s);
						created_instances.push(s);		// come back around and link up its own instances too
					}
				}
			}
		}
		for (i = 0, len = this.initial_nonworld.length; i < len; i++)
		{
			inst = this.runtime.createInstanceFromInit(this.initial_nonworld[i], null, true);
;
		}
		this.runtime.changelayout = null;
		this.runtime.ClearDeathRow();
		if (this.runtime.ctx && !this.runtime.isDomFree)
		{
			for (i = 0, len = this.runtime.types_by_index.length; i < len; i++)
			{
				t = this.runtime.types_by_index[i];
				if (t.is_family || !t.instances.length || !t.preloadCanvas2D)
					continue;
				t.preloadCanvas2D(this.runtime.ctx);
			}
		}
		/*
		if (this.runtime.glwrap)
		{
			console.log("Estimated VRAM at layout start: " + this.runtime.glwrap.textureCount() + " textures, approx. " + Math.round(this.runtime.glwrap.estimateVRAM() / 1024) + " kb");
		}
		*/
		for (i = 0, len = created_instances.length; i < len; i++)
		{
			inst = created_instances[i];
			this.runtime.trigger(Object.getPrototypeOf(inst.type.plugin).cnds.OnCreated, inst);
		}
		created_instances.length = 0;
		this.runtime.trigger(cr.system_object.prototype.cnds.OnLayoutStart, null);
		this.first_visit = false;
	};
	Layout.prototype.createGlobalNonWorlds = function ()
	{
		var i, k, len, initial_inst, inst, type;
		for (i = 0, k = 0, len = this.initial_nonworld.length; i < len; i++)
		{
			initial_inst = this.initial_nonworld[i];
			type = this.runtime.types_by_index[initial_inst[1]];
			if (type.global)
				inst = this.runtime.createInstanceFromInit(initial_inst, null, true);
			else
			{
				this.initial_nonworld[k] = initial_inst;
				k++;
			}
		}
		this.initial_nonworld.length = k;
	};
	Layout.prototype.stopRunning = function ()
	{
;
		/*
		if (this.runtime.glwrap)
		{
			console.log("Estimated VRAM at layout end: " + this.runtime.glwrap.textureCount() + " textures, approx. " + Math.round(this.runtime.glwrap.estimateVRAM() / 1024) + " kb");
		}
		*/
		this.runtime.trigger(cr.system_object.prototype.cnds.OnLayoutEnd, null);
		this.runtime.system.waits.length = 0;
		var i, leni, j, lenj;
		var layer_instances, inst, type;
		for (i = 0, leni = this.layers.length; i < leni; i++)
		{
			layer_instances = this.layers[i].instances;
			for (j = 0, lenj = layer_instances.length; j < lenj; j++)
			{
				inst = layer_instances[j];
				if (!inst.type.global)
				{
					if (this.runtime.typeHasPersistBehavior(inst.type))
						this.saveObjectToPersist(inst);
					this.runtime.DestroyInstance(inst);
				}
			}
			this.runtime.ClearDeathRow();
			layer_instances.length = 0;
			this.layers[i].zindices_stale = true;
		}
		for (i = 0, leni = this.runtime.types_by_index.length; i < leni; i++)
		{
			type = this.runtime.types_by_index[i];
			if (type.global || type.plugin.is_world || type.plugin.singleglobal || type.is_family)
				continue;
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
				this.runtime.DestroyInstance(type.instances[j]);
			this.runtime.ClearDeathRow();
		}
	};
	Layout.prototype.draw = function (ctx)
	{
		var layout_canvas;
		var layout_ctx = ctx;
		var ctx_changed = false;
		var render_offscreen = !this.runtime.fullscreenScalingQuality;
		if (render_offscreen)
		{
			if (!this.runtime.layout_canvas)
			{
				this.runtime.layout_canvas = document.createElement("canvas");
				layout_canvas = this.runtime.layout_canvas;
				layout_canvas.width = this.runtime.draw_width;
				layout_canvas.height = this.runtime.draw_height;
				this.runtime.layout_ctx = layout_canvas.getContext("2d");
				ctx_changed = true;
			}
			layout_canvas = this.runtime.layout_canvas;
			layout_ctx = this.runtime.layout_ctx;
			if (layout_canvas.width !== this.runtime.draw_width)
			{
				layout_canvas.width = this.runtime.draw_width;
				ctx_changed = true;
			}
			if (layout_canvas.height !== this.runtime.draw_height)
			{
				layout_canvas.height = this.runtime.draw_height;
				ctx_changed = true;
			}
			if (ctx_changed)
			{
				layout_ctx["webkitImageSmoothingEnabled"] = this.runtime.linearSampling;
				layout_ctx["mozImageSmoothingEnabled"] = this.runtime.linearSampling;
				layout_ctx["msImageSmoothingEnabled"] = this.runtime.linearSampling;
				layout_ctx["imageSmoothingEnabled"] = this.runtime.linearSampling;
			}
		}
		layout_ctx.globalAlpha = 1;
		layout_ctx.globalCompositeOperation = "source-over";
		if (this.runtime.alphaBackground && !this.hasOpaqueBottomLayer())
			layout_ctx.clearRect(0, 0, this.runtime.draw_width, this.runtime.draw_height);
		var i, len, l;
		for (i = 0, len = this.layers.length; i < len; i++)
		{
			l = this.layers[i];
			if (l.visible && l.opacity > 0 && l.blend_mode !== 11)
				l.draw(layout_ctx);
		}
		if (render_offscreen)
		{
			ctx.drawImage(layout_canvas, 0, 0, this.runtime.width, this.runtime.height);
		}
	};
	Layout.prototype.drawGL = function (glw)
	{
		var render_to_texture = (this.active_effect_types.length > 0 ||
								 this.runtime.uses_background_blending ||
								 !this.runtime.fullscreenScalingQuality);
		if (render_to_texture)
		{
			if (!this.runtime.layout_tex)
			{
				this.runtime.layout_tex = glw.createEmptyTexture(this.runtime.draw_width, this.runtime.draw_height, this.runtime.linearSampling);
			}
			if (this.runtime.layout_tex.c2width !== this.runtime.draw_width || this.runtime.layout_tex.c2height !== this.runtime.draw_height)
			{
				glw.deleteTexture(this.runtime.layout_tex);
				this.runtime.layout_tex = glw.createEmptyTexture(this.runtime.draw_width, this.runtime.draw_height, this.runtime.linearSampling);
			}
			glw.setRenderingToTexture(this.runtime.layout_tex);
			if (!this.runtime.fullscreenScalingQuality)
			{
				glw.setSize(this.runtime.draw_width, this.runtime.draw_height);
			}
		}
		else
		{
			if (this.runtime.layout_tex)
			{
				glw.setRenderingToTexture(null);
				glw.deleteTexture(this.runtime.layout_tex);
				this.runtime.layout_tex = null;
			}
		}
		if (this.runtime.alphaBackground && !this.hasOpaqueBottomLayer())
			glw.clear(0, 0, 0, 0);
		var i, len;
		for (i = 0, len = this.layers.length; i < len; i++)
		{
			if (this.layers[i].visible && this.layers[i].opacity > 0)
				this.layers[i].drawGL(glw);
		}
		if (render_to_texture)
		{
			if (this.active_effect_types.length === 0 ||
				(this.active_effect_types.length === 1 && this.runtime.fullscreenScalingQuality))
			{
				if (this.active_effect_types.length === 1)
				{
					var etindex = this.active_effect_types[0].index;
					glw.switchProgram(this.active_effect_types[0].shaderindex);
					glw.setProgramParameters(null,								// backTex
											 1.0 / this.runtime.draw_width,		// pixelWidth
											 1.0 / this.runtime.draw_height,	// pixelHeight
											 0.0, 0.0,							// destStart
											 1.0, 1.0,							// destEnd
											 this.scale,						// layerScale
											 this.angle,						// layerAngle
											 0.0, 0.0,							// viewOrigin
											 this.effect_params[etindex]);		// fx parameters
					if (glw.programIsAnimated(this.active_effect_types[0].shaderindex))
						this.runtime.redraw = true;
				}
				else
					glw.switchProgram(0);
				if (!this.runtime.fullscreenScalingQuality)
				{
					glw.setSize(this.runtime.width, this.runtime.height);
				}
				glw.setRenderingToTexture(null);				// to backbuffer
				glw.setOpacity(1);
				glw.setTexture(this.runtime.layout_tex);
				glw.setAlphaBlend();
				glw.resetModelView();
				glw.updateModelView();
				var halfw = this.runtime.width / 2;
				var halfh = this.runtime.height / 2;
				glw.quad(-halfw, halfh, halfw, halfh, halfw, -halfh, -halfw, -halfh);
				glw.setTexture(null);
			}
			else
			{
				this.renderEffectChain(glw, null, null, null);
			}
		}
	};
	Layout.prototype.getRenderTarget = function()
	{
		return (this.active_effect_types.length > 0 ||
				this.runtime.uses_background_blending ||
				!this.runtime.fullscreenScalingQuality) ? this.runtime.layout_tex : null;
	};
	Layout.prototype.getMinLayerScale = function ()
	{
		var m = this.layers[0].getScale();
		var i, len, l;
		for (i = 1, len = this.layers.length; i < len; i++)
		{
			l = this.layers[i];
			if (l.parallaxX === 0 && l.parallaxY === 0)
				continue;
			if (l.getScale() < m)
				m = l.getScale();
		}
		return m;
	};
	Layout.prototype.scrollToX = function (x)
	{
		if (!this.unbounded_scrolling)
		{
			var widthBoundary = (this.runtime.draw_width * (1 / this.getMinLayerScale()) / 2);
			if (x > this.width - widthBoundary)
				x = this.width - widthBoundary;
			if (x < widthBoundary)
				x = widthBoundary;
		}
		if (this.scrollX !== x)
		{
			this.scrollX = x;
			this.runtime.redraw = true;
		}
	};
	Layout.prototype.scrollToY = function (y)
	{
		if (!this.unbounded_scrolling)
		{
			var heightBoundary = (this.runtime.draw_height * (1 / this.getMinLayerScale()) / 2);
			if (y > this.height - heightBoundary)
				y = this.height - heightBoundary;
			if (y < heightBoundary)
				y = heightBoundary;
		}
		if (this.scrollY !== y)
		{
			this.scrollY = y;
			this.runtime.redraw = true;
		}
	};
	Layout.prototype.boundScrolling = function ()
	{
		this.scrollToX(this.scrollX);
		this.scrollToY(this.scrollY);
	};
	Layout.prototype.renderEffectChain = function (glw, layer, inst, rendertarget)
	{
		var active_effect_types = inst ?
							inst.active_effect_types :
							layer ?
								layer.active_effect_types :
								this.active_effect_types;
		var layerScale = 1, layerAngle = 0, viewOriginLeft = 0, viewOriginTop = 0;
		if (inst)
		{
			layerScale = inst.layer.getScale();
			layerAngle = inst.layer.getAngle();
			viewOriginLeft = inst.layer.viewLeft;
			viewOriginTop = inst.layer.viewTop;
		}
		else if (layer)
		{
			layerScale = layer.getScale();
			layerAngle = layer.getAngle();
			viewOriginLeft = layer.viewLeft;
			viewOriginTop = layer.viewTop;
		}
		var fx_tex = this.runtime.fx_tex;
		var i, len, last, temp, fx_index = 0, other_fx_index = 1;
		var y, h;
		var windowWidth = this.runtime.draw_width;
		var windowHeight = this.runtime.draw_height;
		var halfw = windowWidth / 2;
		var halfh = windowHeight / 2;
		var rcTex = layer ? layer.rcTex : this.rcTex;
		var rcTex2 = layer ? layer.rcTex2 : this.rcTex2;
		var screenleft = 0, clearleft = 0;
		var screentop = 0, cleartop = 0;
		var screenright = windowWidth, clearright = windowWidth;
		var screenbottom = windowHeight, clearbottom = windowHeight;
		var boxExtendHorizontal = 0;
		var boxExtendVertical = 0;
		var inst_layer_angle = inst ? inst.layer.getAngle() : 0;
		if (inst)
		{
			for (i = 0, len = active_effect_types.length; i < len; i++)
			{
				boxExtendHorizontal += glw.getProgramBoxExtendHorizontal(active_effect_types[i].shaderindex);
				boxExtendVertical += glw.getProgramBoxExtendVertical(active_effect_types[i].shaderindex);
			}
			var bbox = inst.bbox;
			screenleft = layer.layerToCanvas(bbox.left, bbox.top, true, true);
			screentop = layer.layerToCanvas(bbox.left, bbox.top, false, true);
			screenright = layer.layerToCanvas(bbox.right, bbox.bottom, true, true);
			screenbottom = layer.layerToCanvas(bbox.right, bbox.bottom, false, true);
			if (inst_layer_angle !== 0)
			{
				var screentrx = layer.layerToCanvas(bbox.right, bbox.top, true, true);
				var screentry = layer.layerToCanvas(bbox.right, bbox.top, false, true);
				var screenblx = layer.layerToCanvas(bbox.left, bbox.bottom, true, true);
				var screenbly = layer.layerToCanvas(bbox.left, bbox.bottom, false, true);
				temp = Math.min(screenleft, screenright, screentrx, screenblx);
				screenright = Math.max(screenleft, screenright, screentrx, screenblx);
				screenleft = temp;
				temp = Math.min(screentop, screenbottom, screentry, screenbly);
				screenbottom = Math.max(screentop, screenbottom, screentry, screenbly);
				screentop = temp;
			}
			screenleft -= boxExtendHorizontal;
			screentop -= boxExtendVertical;
			screenright += boxExtendHorizontal;
			screenbottom += boxExtendVertical;
			rcTex2.left = screenleft / windowWidth;
			rcTex2.top = 1 - screentop / windowHeight;
			rcTex2.right = screenright / windowWidth;
			rcTex2.bottom = 1 - screenbottom / windowHeight;
			clearleft = screenleft = cr.floor(screenleft);
			cleartop = screentop = cr.floor(screentop);
			clearright = screenright = cr.ceil(screenright);
			clearbottom = screenbottom = cr.ceil(screenbottom);
			clearleft -= boxExtendHorizontal;
			cleartop -= boxExtendVertical;
			clearright += boxExtendHorizontal;
			clearbottom += boxExtendVertical;
			if (screenleft < 0)					screenleft = 0;
			if (screentop < 0)					screentop = 0;
			if (screenright > windowWidth)		screenright = windowWidth;
			if (screenbottom > windowHeight)	screenbottom = windowHeight;
			if (clearleft < 0)					clearleft = 0;
			if (cleartop < 0)					cleartop = 0;
			if (clearright > windowWidth)		clearright = windowWidth;
			if (clearbottom > windowHeight)		clearbottom = windowHeight;
			rcTex.left = screenleft / windowWidth;
			rcTex.top = 1 - screentop / windowHeight;
			rcTex.right = screenright / windowWidth;
			rcTex.bottom = 1 - screenbottom / windowHeight;
		}
		else
		{
			rcTex.left = rcTex2.left = 0;
			rcTex.top = rcTex2.top = 0;
			rcTex.right = rcTex2.right = 1;
			rcTex.bottom = rcTex2.bottom = 1;
		}
		var pre_draw = (inst && (((inst.angle || inst_layer_angle) && glw.programUsesDest(active_effect_types[0].shaderindex)) || boxExtendHorizontal !== 0 || boxExtendVertical !== 0 || inst.opacity !== 1 || inst.type.plugin.must_predraw)) || (layer && !inst && layer.opacity !== 1);
		glw.setAlphaBlend();
		if (pre_draw)
		{
			if (!fx_tex[fx_index])
			{
				fx_tex[fx_index] = glw.createEmptyTexture(windowWidth, windowHeight, this.runtime.linearSampling);
			}
			if (fx_tex[fx_index].c2width !== windowWidth || fx_tex[fx_index].c2height !== windowHeight)
			{
				glw.deleteTexture(fx_tex[fx_index]);
				fx_tex[fx_index] = glw.createEmptyTexture(windowWidth, windowHeight, this.runtime.linearSampling);
			}
			glw.switchProgram(0);
			glw.setRenderingToTexture(fx_tex[fx_index]);
			h = clearbottom - cleartop;
			y = (windowHeight - cleartop) - h;
			glw.clearRect(clearleft, y, clearright - clearleft, h);
			if (inst)
			{
				inst.drawGL(glw);
			}
			else
			{
				glw.setTexture(this.runtime.layer_tex);
				glw.setOpacity(layer.opacity);
				glw.resetModelView();
				glw.translate(-halfw, -halfh);
				glw.updateModelView();
				glw.quadTex(screenleft, screenbottom, screenright, screenbottom, screenright, screentop, screenleft, screentop, rcTex);
			}
			rcTex2.left = rcTex2.top = 0;
			rcTex2.right = rcTex2.bottom = 1;
			if (inst)
			{
				temp = rcTex.top;
				rcTex.top = rcTex.bottom;
				rcTex.bottom = temp;
			}
			fx_index = 1;
			other_fx_index = 0;
		}
		glw.setOpacity(1);
		var last = active_effect_types.length - 1;
		var post_draw = glw.programUsesCrossSampling(active_effect_types[last].shaderindex) ||
						(!layer && !inst && !this.runtime.fullscreenScalingQuality);
		var etindex = 0;
		for (i = 0, len = active_effect_types.length; i < len; i++)
		{
			if (!fx_tex[fx_index])
			{
				fx_tex[fx_index] = glw.createEmptyTexture(windowWidth, windowHeight, this.runtime.linearSampling);
			}
			if (fx_tex[fx_index].c2width !== windowWidth || fx_tex[fx_index].c2height !== windowHeight)
			{
				glw.deleteTexture(fx_tex[fx_index]);
				fx_tex[fx_index] = glw.createEmptyTexture(windowWidth, windowHeight, this.runtime.linearSampling);
			}
			glw.switchProgram(active_effect_types[i].shaderindex);
			etindex = active_effect_types[i].index;
			if (glw.programIsAnimated(active_effect_types[i].shaderindex))
				this.runtime.redraw = true;
			if (i == 0 && !pre_draw)
			{
				glw.setRenderingToTexture(fx_tex[fx_index]);
				h = clearbottom - cleartop;
				y = (windowHeight - cleartop) - h;
				glw.clearRect(clearleft, y, clearright - clearleft, h);
				if (inst)
				{
					glw.setProgramParameters(rendertarget,					// backTex
											 1.0 / inst.width,				// pixelWidth
											 1.0 / inst.height,				// pixelHeight
											 rcTex2.left, rcTex2.top,		// destStart
											 rcTex2.right, rcTex2.bottom,	// destEnd
											 layerScale,
											 layerAngle,
											 viewOriginLeft, viewOriginTop,
											 inst.effect_params[etindex]);	// fx params
					inst.drawGL(glw);
				}
				else
				{
					glw.setProgramParameters(rendertarget,					// backTex
											 1.0 / windowWidth,				// pixelWidth
											 1.0 / windowHeight,			// pixelHeight
											 0.0, 0.0,						// destStart
											 1.0, 1.0,						// destEnd
											 layerScale,
											 layerAngle,
											 viewOriginLeft, viewOriginTop,
											 layer ?						// fx params
												layer.effect_params[etindex] :
												this.effect_params[etindex]);
					glw.setTexture(layer ? this.runtime.layer_tex : this.runtime.layout_tex);
					glw.resetModelView();
					glw.translate(-halfw, -halfh);
					glw.updateModelView();
					glw.quadTex(screenleft, screenbottom, screenright, screenbottom, screenright, screentop, screenleft, screentop, rcTex);
				}
				rcTex2.left = rcTex2.top = 0;
				rcTex2.right = rcTex2.bottom = 1;
				if (inst && !post_draw)
				{
					temp = screenbottom;
					screenbottom = screentop;
					screentop = temp;
				}
			}
			else
			{
				glw.setProgramParameters(rendertarget,						// backTex
										 1.0 / windowWidth,					// pixelWidth
										 1.0 / windowHeight,				// pixelHeight
										 rcTex2.left, rcTex2.top,			// destStart
										 rcTex2.right, rcTex2.bottom,		// destEnd
										 layerScale,
										 layerAngle,
										 viewOriginLeft, viewOriginTop,
										 inst ?								// fx params
											inst.effect_params[etindex] :
											layer ?
												layer.effect_params[etindex] :
												this.effect_params[etindex]);
				glw.setTexture(null);
				if (i === last && !post_draw)
				{
					if (inst)
						glw.setBlend(inst.srcBlend, inst.destBlend);
					else if (layer)
						glw.setBlend(layer.srcBlend, layer.destBlend);
					glw.setRenderingToTexture(rendertarget);
				}
				else
				{
					glw.setRenderingToTexture(fx_tex[fx_index]);
					h = clearbottom - cleartop;
					y = (windowHeight - cleartop) - h;
					glw.clearRect(clearleft, y, clearright - clearleft, h);
				}
				glw.setTexture(fx_tex[other_fx_index]);
				glw.resetModelView();
				glw.translate(-halfw, -halfh);
				glw.updateModelView();
				glw.quadTex(screenleft, screenbottom, screenright, screenbottom, screenright, screentop, screenleft, screentop, rcTex);
				if (i === last && !post_draw)
					glw.setTexture(null);
			}
			fx_index = (fx_index === 0 ? 1 : 0);
			other_fx_index = (fx_index === 0 ? 1 : 0);		// will be opposite to fx_index since it was just assigned
		}
		if (post_draw)
		{
			glw.switchProgram(0);
			if (inst)
				glw.setBlend(inst.srcBlend, inst.destBlend);
			else if (layer)
				glw.setBlend(layer.srcBlend, layer.destBlend);
			else
			{
				if (!this.runtime.fullscreenScalingQuality)
				{
					glw.setSize(this.runtime.width, this.runtime.height);
					halfw = this.runtime.width / 2;
					halfh = this.runtime.height / 2;
					screenleft = 0;
					screentop = 0;
					screenright = this.runtime.width;
					screenbottom = this.runtime.height;
				}
			}
			glw.setRenderingToTexture(rendertarget);
			glw.setTexture(fx_tex[other_fx_index]);
			glw.resetModelView();
			glw.translate(-halfw, -halfh);
			glw.updateModelView();
			if (inst && active_effect_types.length === 1 && !pre_draw)
				glw.quadTex(screenleft, screentop, screenright, screentop, screenright, screenbottom, screenleft, screenbottom, rcTex);
			else
				glw.quadTex(screenleft, screenbottom, screenright, screenbottom, screenright, screentop, screenleft, screentop, rcTex);
			glw.setTexture(null);
		}
	};
	Layout.prototype.getLayerBySid = function (sid_)
	{
		var i, len;
		for (i = 0, len = this.layers.length; i < len; i++)
		{
			if (this.layers[i].sid === sid_)
				return this.layers[i];
		}
		return null;
	};
	Layout.prototype.saveToJSON = function ()
	{
		var i, len, layer, et;
		var o = {
			"sx": this.scrollX,
			"sy": this.scrollY,
			"s": this.scale,
			"a": this.angle,
			"w": this.width,
			"h": this.height,
			"fv": this.first_visit,			// added r127
			"persist": this.persist_data,
			"fx": [],
			"layers": {}
		};
		for (i = 0, len = this.effect_types.length; i < len; i++)
		{
			et = this.effect_types[i];
			o["fx"].push({"name": et.name, "active": et.active, "params": this.effect_params[et.index] });
		}
		for (i = 0, len = this.layers.length; i < len; i++)
		{
			layer = this.layers[i];
			o["layers"][layer.sid.toString()] = layer.saveToJSON();
		}
		return o;
	};
	Layout.prototype.loadFromJSON = function (o)
	{
		var i, len, fx, p, layer;
		this.scrollX = o["sx"];
		this.scrollY = o["sy"];
		this.scale = o["s"];
		this.angle = o["a"];
		this.width = o["w"];
		this.height = o["h"];
		this.persist_data = o["persist"];
		if (typeof o["fv"] !== "undefined")
			this.first_visit = o["fv"];
		var ofx = o["fx"];
		for (i = 0, len = ofx.length; i < len; i++)
		{
			fx = this.getEffectByName(ofx[i]["name"]);
			if (!fx)
				continue;		// must've gone missing
			fx.active = ofx[i]["active"];
			this.effect_params[fx.index] = ofx[i]["params"];
		}
		this.updateActiveEffects();
		var olayers = o["layers"];
		for (p in olayers)
		{
			if (olayers.hasOwnProperty(p))
			{
				layer = this.getLayerBySid(parseInt(p, 10));
				if (!layer)
					continue;		// must've gone missing
				layer.loadFromJSON(olayers[p]);
			}
		}
	};
	cr.layout = Layout;
	function Layer(layout, m)
	{
		this.layout = layout;
		this.runtime = layout.runtime;
		this.instances = [];        // running instances
		this.scale = 1.0;
		this.angle = 0;
		this.disableAngle = false;
		this.tmprect = new cr.rect(0, 0, 0, 0);
		this.tmpquad = new cr.quad();
		this.viewLeft = 0;
		this.viewRight = 0;
		this.viewTop = 0;
		this.viewBottom = 0;
		this.zindices_stale = false;
		this.name = m[0];
		this.index = m[1];
		this.sid = m[2];
		this.visible = m[3];		// initially visible
		this.background_color = m[4];
		this.transparent = m[5];
		this.parallaxX = m[6];
		this.parallaxY = m[7];
		this.opacity = m[8];
		this.forceOwnTexture = m[9];
		this.zoomRate = m[10];
		this.blend_mode = m[11];
		this.effect_fallback = m[12];
		this.compositeOp = "source-over";
		this.srcBlend = 0;
		this.destBlend = 0;
		this.render_offscreen = false;
		var im = m[13];
		var i, len;
		this.initial_instances = [];
		for (i = 0, len = im.length; i < len; i++)
		{
			var inst = im[i];
			var type = this.runtime.types_by_index[inst[1]];
;
			if (!type.default_instance)
			{
				type.default_instance = inst;
				type.default_layerindex = this.index;
			}
			this.initial_instances.push(inst);
			if (this.layout.initial_types.indexOf(type) === -1)
				this.layout.initial_types.push(type);
		}
		this.effect_types = [];
		this.active_effect_types = [];
		this.effect_params = [];
		for (i = 0, len = m[14].length; i < len; i++)
		{
			this.effect_types.push({
				id: m[14][i][0],
				name: m[14][i][1],
				shaderindex: -1,
				active: true,
				index: i
			});
			this.effect_params.push(m[14][i][2].slice(0));
		}
		this.updateActiveEffects();
		this.rcTex = new cr.rect(0, 0, 1, 1);
		this.rcTex2 = new cr.rect(0, 0, 1, 1);
	};
	Layer.prototype.updateActiveEffects = function ()
	{
		this.active_effect_types.length = 0;
		var i, len, et;
		for (i = 0, len = this.effect_types.length; i < len; i++)
		{
			et = this.effect_types[i];
			if (et.active)
				this.active_effect_types.push(et);
		}
	};
	Layer.prototype.getEffectByName = function (name_)
	{
		var i, len, et;
		for (i = 0, len = this.effect_types.length; i < len; i++)
		{
			et = this.effect_types[i];
			if (et.name === name_)
				return et;
		}
		return null;
	};
	Layer.prototype.createInitialInstances = function ()
	{
		var i, k, len, inst, initial_inst, type, keep, hasPersistBehavior;
		for (i = 0, k = 0, len = this.initial_instances.length; i < len; i++)
		{
			initial_inst = this.initial_instances[i];
			type = this.runtime.types_by_index[initial_inst[1]];
;
			hasPersistBehavior = this.runtime.typeHasPersistBehavior(type);
			keep = true;
			if (!hasPersistBehavior || this.layout.first_visit)
			{
				inst = this.runtime.createInstanceFromInit(initial_inst, this, true);
;
				created_instances.push(inst);
				if (inst.type.global)
					keep = false;
			}
			if (keep)
			{
				this.initial_instances[k] = this.initial_instances[i];
				k++;
			}
		}
		this.initial_instances.length = k;
		this.runtime.ClearDeathRow();		// flushes creation row so IIDs will be correct
		if (!this.runtime.glwrap && this.effect_types.length)	// no WebGL renderer and shaders used
			this.blend_mode = this.effect_fallback;				// use fallback blend mode
		this.compositeOp = cr.effectToCompositeOp(this.blend_mode);
		if (this.runtime.gl)
			cr.setGLBlend(this, this.blend_mode, this.runtime.gl);
	};
	Layer.prototype.updateZIndices = function ()
	{
		if (!this.zindices_stale)
			return;
		var i, len;
		for (i = 0, len = this.instances.length; i < len; i++)
		{
;
;
			this.instances[i].zindex = i;
		}
		this.zindices_stale = false;
	};
	Layer.prototype.getScale = function (include_aspect)
	{
		return this.getNormalScale() * (this.runtime.fullscreenScalingQuality || include_aspect ? this.runtime.aspect_scale : 1);
	};
	Layer.prototype.getNormalScale = function ()
	{
		return ((this.scale * this.layout.scale) - 1) * this.zoomRate + 1;
	};
	Layer.prototype.getAngle = function ()
	{
		if (this.disableAngle)
			return 0;
		return cr.clamp_angle(this.layout.angle + this.angle);
	};
	Layer.prototype.draw = function (ctx)
	{
		this.render_offscreen = (this.forceOwnTexture || this.opacity !== 1.0 || this.blend_mode !== 0);
		var layer_canvas = this.runtime.canvas;
		var layer_ctx = ctx;
		var ctx_changed = false;
		if (this.render_offscreen)
		{
			if (!this.runtime.layer_canvas)
			{
				this.runtime.layer_canvas = document.createElement("canvas");
;
				layer_canvas = this.runtime.layer_canvas;
				layer_canvas.width = this.runtime.draw_width;
				layer_canvas.height = this.runtime.draw_height;
				this.runtime.layer_ctx = layer_canvas.getContext("2d");
;
				ctx_changed = true;
			}
			layer_canvas = this.runtime.layer_canvas;
			layer_ctx = this.runtime.layer_ctx;
			if (layer_canvas.width !== this.runtime.draw_width)
			{
				layer_canvas.width = this.runtime.draw_width;
				ctx_changed = true;
			}
			if (layer_canvas.height !== this.runtime.draw_height)
			{
				layer_canvas.height = this.runtime.draw_height;
				ctx_changed = true;
			}
			if (ctx_changed)
			{
				layer_ctx["webkitImageSmoothingEnabled"] = this.runtime.linearSampling;
				layer_ctx["mozImageSmoothingEnabled"] = this.runtime.linearSampling;
				layer_ctx["msImageSmoothingEnabled"] = this.runtime.linearSampling;
				layer_ctx["imageSmoothingEnabled"] = this.runtime.linearSampling;
			}
			if (this.transparent)
				layer_ctx.clearRect(0, 0, this.runtime.draw_width, this.runtime.draw_height);
		}
		layer_ctx.globalAlpha = 1;
		layer_ctx.globalCompositeOperation = "source-over";
		if (!this.transparent)
		{
			layer_ctx.fillStyle = "rgb(" + this.background_color[0] + "," + this.background_color[1] + "," + this.background_color[2] + ")";
			layer_ctx.fillRect(0, 0, this.runtime.draw_width, this.runtime.draw_height);
		}
		layer_ctx.save();
		this.disableAngle = true;
		var px = this.canvasToLayer(0, 0, true, true);
		var py = this.canvasToLayer(0, 0, false, true);
		this.disableAngle = false;
		if (this.runtime.pixel_rounding)
		{
			px = (px + 0.5) | 0;
			py = (py + 0.5) | 0;
		}
		this.rotateViewport(px, py, layer_ctx);
		var myscale = this.getScale();
		layer_ctx.scale(myscale, myscale);
		layer_ctx.translate(-px, -py);
		var i, len, inst, bbox;
		for (i = 0, len = this.instances.length; i < len; i++)
		{
			inst = this.instances[i];
			if (!inst.visible || inst.width === 0 || inst.height === 0)
				continue;
			inst.update_bbox();
			bbox = inst.bbox;
			if (bbox.right < this.viewLeft || bbox.bottom < this.viewTop || bbox.left > this.viewRight || bbox.top > this.viewBottom)
				continue;
			layer_ctx.globalCompositeOperation = inst.compositeOp;
			inst.draw(layer_ctx);
		}
		layer_ctx.restore();
		if (this.render_offscreen)
		{
			ctx.globalCompositeOperation = this.compositeOp;
			ctx.globalAlpha = this.opacity;
			ctx.drawImage(layer_canvas, 0, 0);
		}
	};
	Layer.prototype.rotateViewport = function (px, py, ctx)
	{
		var myscale = this.getScale();
		this.viewLeft = px;
		this.viewTop = py;
		this.viewRight = px + (this.runtime.draw_width * (1 / myscale));
		this.viewBottom = py + (this.runtime.draw_height * (1 / myscale));
		var myAngle = this.getAngle();
		if (myAngle !== 0)
		{
			if (ctx)
			{
				ctx.translate(this.runtime.draw_width / 2, this.runtime.draw_height / 2);
				ctx.rotate(-myAngle);
				ctx.translate(this.runtime.draw_width / -2, this.runtime.draw_height / -2);
			}
			this.tmprect.set(this.viewLeft, this.viewTop, this.viewRight, this.viewBottom);
			this.tmprect.offset((this.viewLeft + this.viewRight) / -2, (this.viewTop + this.viewBottom) / -2);
			this.tmpquad.set_from_rotated_rect(this.tmprect, myAngle);
			this.tmpquad.bounding_box(this.tmprect);
			this.tmprect.offset((this.viewLeft + this.viewRight) / 2, (this.viewTop + this.viewBottom) / 2);
			this.viewLeft = this.tmprect.left;
			this.viewTop = this.tmprect.top;
			this.viewRight = this.tmprect.right;
			this.viewBottom = this.tmprect.bottom;
		}
	}
	Layer.prototype.drawGL = function (glw)
	{
		var windowWidth = this.runtime.draw_width;
		var windowHeight = this.runtime.draw_height;
		var shaderindex = 0;
		var etindex = 0;
		this.render_offscreen = (this.forceOwnTexture || this.opacity !== 1.0 || this.active_effect_types.length > 0 || this.blend_mode !== 0);
		if (this.render_offscreen)
		{
			if (!this.runtime.layer_tex)
			{
				this.runtime.layer_tex = glw.createEmptyTexture(this.runtime.draw_width, this.runtime.draw_height, this.runtime.linearSampling);
			}
			if (this.runtime.layer_tex.c2width !== this.runtime.draw_width || this.runtime.layer_tex.c2height !== this.runtime.draw_height)
			{
				glw.deleteTexture(this.runtime.layer_tex);
				this.runtime.layer_tex = glw.createEmptyTexture(this.runtime.draw_width, this.runtime.draw_height, this.runtime.linearSampling);
			}
			glw.setRenderingToTexture(this.runtime.layer_tex);
			if (this.transparent)
				glw.clear(0, 0, 0, 0);
		}
		if (!this.transparent)
		{
			glw.clear(this.background_color[0] / 255, this.background_color[1] / 255, this.background_color[2] / 255, 1);
		}
		this.disableAngle = true;
		var px = this.canvasToLayer(0, 0, true, true);
		var py = this.canvasToLayer(0, 0, false, true);
		this.disableAngle = false;
		if (this.runtime.pixel_rounding)
		{
			px = (px + 0.5) | 0;
			py = (py + 0.5) | 0;
		}
		this.rotateViewport(px, py, null);
		var myscale = this.getScale();
		glw.resetModelView();
		glw.scale(myscale, myscale);
		glw.rotateZ(-this.getAngle());
		glw.translate((this.viewLeft + this.viewRight) / -2, (this.viewTop + this.viewBottom) / -2);
		glw.updateModelView();
		var i, len, inst, bbox;
		for (i = 0, len = this.instances.length; i < len; i++)
		{
			inst = this.instances[i];
			if (!inst.visible || inst.width === 0 || inst.height === 0)
				continue;
			inst.update_bbox();
			bbox = inst.bbox;
			if (bbox.right < this.viewLeft || bbox.bottom < this.viewTop || bbox.left > this.viewRight || bbox.top > this.viewBottom)
				continue;
			if (inst.uses_shaders)
			{
				shaderindex = inst.active_effect_types[0].shaderindex;
				etindex = inst.active_effect_types[0].index;
				if (inst.active_effect_types.length === 1 && !glw.programUsesCrossSampling(shaderindex) &&
					!glw.programExtendsBox(shaderindex) && ((!inst.angle && !inst.layer.getAngle()) || !glw.programUsesDest(shaderindex)) &&
					inst.opacity === 1 && !inst.type.plugin.must_predraw)
				{
					glw.switchProgram(shaderindex);
					glw.setBlend(inst.srcBlend, inst.destBlend);
					if (glw.programIsAnimated(shaderindex))
						this.runtime.redraw = true;
					var destStartX = 0, destStartY = 0, destEndX = 0, destEndY = 0;
					if (glw.programUsesDest(shaderindex))
					{
						var bbox = inst.bbox;
						var screenleft = this.layerToCanvas(bbox.left, bbox.top, true, true);
						var screentop = this.layerToCanvas(bbox.left, bbox.top, false, true);
						var screenright = this.layerToCanvas(bbox.right, bbox.bottom, true, true);
						var screenbottom = this.layerToCanvas(bbox.right, bbox.bottom, false, true);
						destStartX = screenleft / windowWidth;
						destStartY = 1 - screentop / windowHeight;
						destEndX = screenright / windowWidth;
						destEndY = 1 - screenbottom / windowHeight;
					}
					glw.setProgramParameters(this.render_offscreen ? this.runtime.layer_tex : this.layout.getRenderTarget(), // backTex
											 1.0 / inst.width,			// pixelWidth
											 1.0 / inst.height,			// pixelHeight
											 destStartX, destStartY,
											 destEndX, destEndY,
											 this.getScale(),
											 this.getAngle(),
											 this.viewLeft, this.viewTop,
											 inst.effect_params[etindex]);
					inst.drawGL(glw);
				}
				else
				{
					this.layout.renderEffectChain(glw, this, inst, this.render_offscreen ? this.runtime.layer_tex : this.layout.getRenderTarget());
					glw.resetModelView();
					glw.scale(myscale, myscale);
					glw.rotateZ(-this.getAngle());
					glw.translate((this.viewLeft + this.viewRight) / -2, (this.viewTop + this.viewBottom) / -2);
					glw.updateModelView();
				}
			}
			else
			{
				glw.switchProgram(0);		// un-set any previously set shader
				glw.setBlend(inst.srcBlend, inst.destBlend);
				inst.drawGL(glw);
			}
		}
		if (this.render_offscreen)
		{
			shaderindex = this.active_effect_types.length ? this.active_effect_types[0].shaderindex : 0;
			etindex = this.active_effect_types.length ? this.active_effect_types[0].index : 0;
			if (this.active_effect_types.length === 0 || (this.active_effect_types.length === 1 &&
				!glw.programUsesCrossSampling(shaderindex) && this.opacity === 1))
			{
				if (this.active_effect_types.length === 1)
				{
					glw.switchProgram(shaderindex);
					glw.setProgramParameters(this.layout.getRenderTarget(),		// backTex
											 1.0 / this.runtime.draw_width,		// pixelWidth
											 1.0 / this.runtime.draw_height,	// pixelHeight
											 0.0, 0.0,							// destStart
											 1.0, 1.0,							// destEnd
											 this.getScale(),					// layerScale
											 this.getAngle(),
											 this.viewLeft, this.viewTop,
											 this.effect_params[etindex]);		// fx parameters
					if (glw.programIsAnimated(shaderindex))
						this.runtime.redraw = true;
				}
				else
					glw.switchProgram(0);
				glw.setRenderingToTexture(this.layout.getRenderTarget());
				glw.setOpacity(this.opacity);
				glw.setTexture(this.runtime.layer_tex);
				glw.setBlend(this.srcBlend, this.destBlend);
				glw.resetModelView();
				glw.updateModelView();
				var halfw = this.runtime.draw_width / 2;
				var halfh = this.runtime.draw_height / 2;
				glw.quad(-halfw, halfh, halfw, halfh, halfw, -halfh, -halfw, -halfh);
				glw.setTexture(null);
			}
			else
			{
				this.layout.renderEffectChain(glw, this, null, this.layout.getRenderTarget());
			}
		}
	};
	Layer.prototype.canvasToLayer = function (ptx, pty, getx, using_draw_area)
	{
		var multiplier = this.runtime.devicePixelRatio;
		if (this.runtime.isRetina)
		{
			ptx *= multiplier;
			pty *= multiplier;
		}
		var ox = this.runtime.parallax_x_origin;
		var oy = this.runtime.parallax_y_origin;
		var x = ((this.layout.scrollX - ox) * this.parallaxX) + ox;
		var y = ((this.layout.scrollY - oy) * this.parallaxY) + oy;
		var invScale = 1 / this.getScale(!using_draw_area);
		if (using_draw_area)
		{
			x -= (this.runtime.draw_width * invScale) / 2;
			y -= (this.runtime.draw_height * invScale) / 2;
		}
		else
		{
			x -= (this.runtime.width * invScale) / 2;
			y -= (this.runtime.height * invScale) / 2;
		}
		x += ptx * invScale;
		y += pty * invScale;
		var a = this.getAngle();
		if (a !== 0)
		{
			x -= this.layout.scrollX;
			y -= this.layout.scrollY;
			var cosa = Math.cos(a);
			var sina = Math.sin(a);
			var x_temp = (x * cosa) - (y * sina);
			y = (y * cosa) + (x * sina);
			x = x_temp;
			x += this.layout.scrollX;
			y += this.layout.scrollY;
		}
		return getx ? x : y;
	};
	Layer.prototype.layerToCanvas = function (ptx, pty, getx, using_draw_area)
	{
		var a = this.getAngle();
		if (a !== 0)
		{
			ptx -= this.layout.scrollX;
			pty -= this.layout.scrollY;
			var cosa = Math.cos(-a);
			var sina = Math.sin(-a);
			var x_temp = (ptx * cosa) - (pty * sina);
			pty = (pty * cosa) + (ptx * sina);
			ptx = x_temp;
			ptx += this.layout.scrollX;
			pty += this.layout.scrollY;
		}
		var ox = this.runtime.parallax_x_origin;
		var oy = this.runtime.parallax_y_origin;
		var x = ((this.layout.scrollX - ox) * this.parallaxX) + ox;
		var y = ((this.layout.scrollY - oy) * this.parallaxY) + oy;
		var invScale = 1 / this.getScale(!using_draw_area);
		if (using_draw_area)
		{
			x -= (this.runtime.draw_width * invScale) / 2;
			y -= (this.runtime.draw_height * invScale) / 2;
		}
		else
		{
			x -= (this.runtime.width * invScale) / 2;
			y -= (this.runtime.height * invScale) / 2;
		}
		x = (ptx - x) / invScale;
		y = (pty - y) / invScale;
		var multiplier = this.runtime.devicePixelRatio;
		if (this.runtime.isRetina)
		{
			x /= multiplier;
			y /= multiplier;
		}
		return getx ? x : y;
	};
	Layer.prototype.rotatePt = function (x_, y_, getx)
	{
		if (this.getAngle() === 0)
			return getx ? x_ : y_;
		var nx = this.layerToCanvas(x_, y_, true);
		var ny = this.layerToCanvas(x_, y_, false);
		this.disableAngle = true;
		var px = this.canvasToLayer(nx, ny, true);
		var py = this.canvasToLayer(nx, ny, true);
		this.disableAngle = false;
		return getx ? px : py;
	};
	Layer.prototype.saveToJSON = function ()
	{
		var i, len, et;
		var o = {
			"s": this.scale,
			"a": this.angle,
			"vl": this.viewLeft,
			"vt": this.viewTop,
			"vr": this.viewRight,
			"vb": this.viewBottom,
			"v": this.visible,
			"bc": this.background_color,
			"t": this.transparent,
			"px": this.parallaxX,
			"py": this.parallaxY,
			"o": this.opacity,
			"zr": this.zoomRate,
			"fx": [],
			"instances": []
		};
		for (i = 0, len = this.effect_types.length; i < len; i++)
		{
			et = this.effect_types[i];
			o["fx"].push({"name": et.name, "active": et.active, "params": this.effect_params[et.index] });
		}
		return o;
	};
	function sortInstanceByZIndex(a, b)
	{
		return a.zindex - b.zindex;
	};
	Layer.prototype.loadFromJSON = function (o)
	{
		var i, len, p, inst, fx;
		this.scale = o["s"];
		this.angle = o["a"];
		this.viewLeft = o["vl"];
		this.viewTop = o["vt"];
		this.viewRight = o["vr"];
		this.viewBottom = o["vb"];
		this.visible = o["v"];
		this.background_color = o["bc"];
		this.transparent = o["t"];
		this.parallaxX = o["px"];
		this.parallaxY = o["py"];
		this.opacity = o["o"];
		this.zoomRate = o["zr"];
		var ofx = o["fx"];
		for (i = 0, len = ofx.length; i < len; i++)
		{
			fx = this.getEffectByName(ofx[i]["name"]);
			if (!fx)
				continue;		// must've gone missing
			fx.active = ofx[i]["active"];
			this.effect_params[fx.index] = ofx[i]["params"];
		}
		this.updateActiveEffects();
		this.instances.sort(sortInstanceByZIndex);
		this.zindices_stale = true;
	};
	cr.layer = Layer;
}());
;
(function()
{
	var allUniqueSolModifiers = [];
	function testSolsMatch(arr1, arr2)
	{
		var i, len = arr1.length;
		switch (len) {
		case 0:
			return true;
		case 1:
			return arr1[0] === arr2[0];
		case 2:
			return arr1[0] === arr2[0] && arr1[1] === arr2[1];
		default:
			for (i = 0; i < len; i++)
			{
				if (arr1[i] !== arr2[i])
					return false;
			}
			return true;
		}
	};
	function solArraySorter(t1, t2)
	{
		return t1.index - t2.index;
	};
	function findMatchingSolModifier(arr)
	{
		var i, len, u, temp, subarr;
		if (arr.length === 2)
		{
			if (arr[0].index > arr[1].index)
			{
				temp = arr[0];
				arr[0] = arr[1];
				arr[1] = temp;
			}
		}
		else if (arr.length > 2)
			arr.sort(solArraySorter);		// so testSolsMatch compares in same order
		if (arr.length >= allUniqueSolModifiers.length)
			allUniqueSolModifiers.length = arr.length + 1;
		if (!allUniqueSolModifiers[arr.length])
			allUniqueSolModifiers[arr.length] = [];
		subarr = allUniqueSolModifiers[arr.length];
		for (i = 0, len = subarr.length; i < len; i++)
		{
			u = subarr[i];
			if (testSolsMatch(arr, u))
				return u;
		}
		subarr.push(arr);
		return arr;
	};
	function EventSheet(runtime, m)
	{
		this.runtime = runtime;
		this.triggers = {};
		this.fasttriggers = {};
        this.hasRun = false;
        this.includes = new cr.ObjectSet(); 	// all event sheets included by this sheet, at first-level indirection only
		this.deep_includes = [];				// all includes from this sheet recursively, in trigger order
		this.already_included_sheets = [];		// used while building deep_includes
		this.name = m[0];
		var em = m[1];		// events model
		this.events = [];       // triggers won't make it to this array
		var i, len;
		for (i = 0, len = em.length; i < len; i++)
			this.init_event(em[i], null, this.events);
	};
    EventSheet.prototype.toString = function ()
    {
        return this.name;
    };
	EventSheet.prototype.init_event = function (m, parent, nontriggers)
	{
		switch (m[0]) {
		case 0:	// event block
		{
			var block = new cr.eventblock(this, parent, m);
			cr.seal(block);
			if (block.orblock)
			{
				nontriggers.push(block);
				var i, len;
				for (i = 0, len = block.conditions.length; i < len; i++)
				{
					if (block.conditions[i].trigger)
						this.init_trigger(block, i);
				}
			}
			else
			{
				if (block.is_trigger())
					this.init_trigger(block, 0);
				else
					nontriggers.push(block);
			}
			break;
		}
		case 1: // variable
		{
			var v = new cr.eventvariable(this, parent, m);
			cr.seal(v);
			nontriggers.push(v);
			break;
		}
        case 2:	// include
        {
            var inc = new cr.eventinclude(this, parent, m);
			cr.seal(inc);
            nontriggers.push(inc);
			break;
        }
		default:
;
		}
	};
	EventSheet.prototype.postInit = function ()
	{
		var i, len;
		for (i = 0, len = this.events.length; i < len; i++)
		{
			this.events[i].postInit(i < len - 1 && this.events[i + 1].is_else_block);
		}
	};
	EventSheet.prototype.updateDeepIncludes = function ()
	{
		this.deep_includes.length = 0;
		this.already_included_sheets.length = 0;
		this.addDeepIncludes(this);
		this.already_included_sheets.length = 0;
	};
	EventSheet.prototype.addDeepIncludes = function (root_sheet)
	{
		var i, len, inc, sheet;
		var deep_includes = root_sheet.deep_includes;
		var already_included_sheets = root_sheet.already_included_sheets;
		var arr = this.includes.valuesRef();
		for (i = 0, len = arr.length; i < len; ++i)
		{
			inc = arr[i];
			sheet = inc.include_sheet;
			if (!inc.isActive() || root_sheet === sheet || already_included_sheets.indexOf(sheet) > -1)
				continue;
			already_included_sheets.push(sheet);
			sheet.addDeepIncludes(root_sheet);
			deep_includes.push(sheet);
		}
	};
	EventSheet.prototype.run = function (from_include)
	{
		if (!this.runtime.resuming_breakpoint)
		{
			this.hasRun = true;
			if (!from_include)
				this.runtime.isRunningEvents = true;
		}
		var i, len;
		for (i = 0, len = this.events.length; i < len; i++)
		{
			var ev = this.events[i];
			ev.run();
				this.runtime.clearSol(ev.solModifiers);
				if (!this.runtime.deathRow.isEmpty() || this.runtime.createRow.length)
					this.runtime.ClearDeathRow();
		}
			if (!from_include)
				this.runtime.isRunningEvents = false;
	};
	function isPerformanceSensitiveTrigger(method)
	{
		if (cr.plugins_.Sprite && method === cr.plugins_.Sprite.prototype.cnds.OnFrameChanged)
		{
			return true;
		}
		return false;
	};
	EventSheet.prototype.init_trigger = function (trig, index)
	{
		if (!trig.orblock)
			this.runtime.triggers_to_postinit.push(trig);	// needs to be postInit'd later
		var i, len;
		var cnd = trig.conditions[index];
		var type_name;
		if (cnd.type)
			type_name = cnd.type.name;
		else
			type_name = "system";
		var fasttrigger = cnd.fasttrigger;
		var triggers = (fasttrigger ? this.fasttriggers : this.triggers);
		if (!triggers[type_name])
			triggers[type_name] = [];
		var obj_entry = triggers[type_name];
		var method = cnd.func;
		if (fasttrigger)
		{
			if (!cnd.parameters.length)				// no parameters
				return;
			var firstparam = cnd.parameters[0];
			if (firstparam.type !== 1 ||			// not a string param
				firstparam.expression.type !== 2)	// not a string literal node
			{
				return;
			}
			var fastevs;
			var firstvalue = firstparam.expression.value.toLowerCase();
			var i, len;
			for (i = 0, len = obj_entry.length; i < len; i++)
			{
				if (obj_entry[i].method == method)
				{
					fastevs = obj_entry[i].evs;
					if (!fastevs[firstvalue])
						fastevs[firstvalue] = [[trig, index]];
					else
						fastevs[firstvalue].push([trig, index]);
					return;
				}
			}
			fastevs = {};
			fastevs[firstvalue] = [[trig, index]];
			obj_entry.push({ method: method, evs: fastevs });
		}
		else
		{
			for (i = 0, len = obj_entry.length; i < len; i++)
			{
				if (obj_entry[i].method == method)
				{
					obj_entry[i].evs.push([trig, index]);
					return;
				}
			}
			if (isPerformanceSensitiveTrigger(method))
				obj_entry.unshift({ method: method, evs: [[trig, index]]});
			else
				obj_entry.push({ method: method, evs: [[trig, index]]});
		}
	};
	cr.eventsheet = EventSheet;
	function Selection(type)
	{
		this.type = type;
		this.instances = [];        // subset of picked instances
		this.else_instances = [];	// subset of unpicked instances
		this.select_all = true;
	};
	Selection.prototype.hasObjects = function ()
	{
		if (this.select_all)
			return this.type.instances.length;
		else
			return this.instances.length;
	};
	Selection.prototype.getObjects = function ()
	{
		if (this.select_all)
			return this.type.instances;
		else
			return this.instances;
	};
	/*
	Selection.prototype.ensure_picked = function (inst, skip_siblings)
	{
		var i, len;
		var orblock = inst.runtime.getCurrentEventStack().current_event.orblock;
		if (this.select_all)
		{
			this.select_all = false;
			if (orblock)
			{
				cr.shallowAssignArray(this.else_instances, inst.type.instances);
				cr.arrayFindRemove(this.else_instances, inst);
			}
			this.instances.length = 1;
			this.instances[0] = inst;
		}
		else
		{
			if (orblock)
			{
				i = this.else_instances.indexOf(inst);
				if (i !== -1)
				{
					this.instances.push(this.else_instances[i]);
					this.else_instances.splice(i, 1);
				}
			}
			else
			{
				if (this.instances.indexOf(inst) === -1)
					this.instances.push(inst);
			}
		}
		if (!skip_siblings)
		{
		}
	};
	*/
	Selection.prototype.pick_one = function (inst)
	{
		if (!inst)
			return;
		if (inst.runtime.getCurrentEventStack().current_event.orblock)
		{
			if (this.select_all)
			{
				this.instances.length = 0;
				cr.shallowAssignArray(this.else_instances, inst.type.instances);
				this.select_all = false;
			}
			var i = this.else_instances.indexOf(inst);
			if (i !== -1)
			{
				this.instances.push(this.else_instances[i]);
				this.else_instances.splice(i, 1);
			}
		}
		else
		{
			this.select_all = false;
			this.instances.length = 1;
			this.instances[0] = inst;
		}
	};
	cr.selection = Selection;
	function EventBlock(sheet, parent, m)
	{
		this.sheet = sheet;
		this.parent = parent;
		this.runtime = sheet.runtime;
		this.solModifiers = [];
		this.solModifiersIncludingParents = [];
		this.solWriterAfterCnds = false;	// block does not change SOL after running its conditions
		this.group = false;					// is group of events
		this.initially_activated = false;	// if a group, is active on startup
		this.toplevelevent = false;			// is an event block parented only by a top-level group
		this.toplevelgroup = false;			// is parented only by other groups or is top-level (i.e. not in a subevent)
		this.has_else_block = false;		// is followed by else
;
		this.conditions = [];
		this.actions = [];
		this.subevents = [];
		this.group_name = "";
		this.group = false;
		this.initially_activated = false;
		this.group_active = false;
		this.contained_includes = null;
        if (m[1])
        {
			this.group_name = m[1][1].toLowerCase();
			this.group = true;
			this.initially_activated = !!m[1][0];
			this.contained_includes = [];
			this.group_active = this.initially_activated;
			this.runtime.allGroups.push(this);
            this.runtime.groups_by_name[this.group_name] = this;
        }
		this.orblock = m[2];
		this.sid = m[4];
		if (!this.group)
			this.runtime.blocksBySid[this.sid.toString()] = this;
		var i, len;
		var cm = m[5];
		for (i = 0, len = cm.length; i < len; i++)
		{
			var cnd = new cr.condition(this, cm[i]);
			cnd.index = i;
			cr.seal(cnd);
			this.conditions.push(cnd);
			/*
			if (cnd.is_logical())
				this.is_logical = true;
			if (cnd.type && !cnd.type.plugin.singleglobal && this.cndReferences.indexOf(cnd.type) === -1)
				this.cndReferences.push(cnd.type);
			*/
			this.addSolModifier(cnd.type);
		}
		var am = m[6];
		for (i = 0, len = am.length; i < len; i++)
		{
			var act = new cr.action(this, am[i]);
			act.index = i;
			cr.seal(act);
			this.actions.push(act);
		}
		if (m.length === 8)
		{
			var em = m[7];
			for (i = 0, len = em.length; i < len; i++)
				this.sheet.init_event(em[i], this, this.subevents);
		}
		this.is_else_block = false;
		if (this.conditions.length)
		{
			this.is_else_block = (this.conditions[0].type == null && this.conditions[0].func == cr.system_object.prototype.cnds.Else);
		}
	};
	window["_c2hh_"] = "147DF109867446C7EFC98BA7E5CBF7C27C8C57A6";
	EventBlock.prototype.postInit = function (hasElse/*, prevBlock_*/)
	{
		var i, len;
		var p = this.parent;
		if (this.group)
		{
			this.toplevelgroup = true;
			while (p)
			{
				if (!p.group)
				{
					this.toplevelgroup = false;
					break;
				}
				p = p.parent;
			}
		}
		this.toplevelevent = !this.is_trigger() && (!this.parent || (this.parent.group && this.parent.toplevelgroup));
		this.has_else_block = !!hasElse;
		this.solModifiersIncludingParents = this.solModifiers.slice(0);
		p = this.parent;
		while (p)
		{
			for (i = 0, len = p.solModifiers.length; i < len; i++)
				this.addParentSolModifier(p.solModifiers[i]);
			p = p.parent;
		}
		this.solModifiers = findMatchingSolModifier(this.solModifiers);
		this.solModifiersIncludingParents = findMatchingSolModifier(this.solModifiersIncludingParents);
		var i, len/*, s*/;
		for (i = 0, len = this.conditions.length; i < len; i++)
			this.conditions[i].postInit();
		for (i = 0, len = this.actions.length; i < len; i++)
			this.actions[i].postInit();
		for (i = 0, len = this.subevents.length; i < len; i++)
		{
			this.subevents[i].postInit(i < len - 1 && this.subevents[i + 1].is_else_block);
		}
		/*
		if (this.is_else_block && this.prev_block)
		{
			for (i = 0, len = this.prev_block.solModifiers.length; i < len; i++)
			{
				s = this.prev_block.solModifiers[i];
				if (this.solModifiers.indexOf(s) === -1)
					this.solModifiers.push(s);
			}
		}
		*/
	};
	EventBlock.prototype.setGroupActive = function (a)
	{
		if (this.group_active === !!a)
			return;		// same state
		this.group_active = !!a;
		var i, len;
		for (i = 0, len = this.contained_includes.length; i < len; ++i)
		{
			this.contained_includes[i].updateActive();
		}
		if (len > 0 && this.runtime.running_layout.event_sheet)
			this.runtime.running_layout.event_sheet.updateDeepIncludes();
	};
	function addSolModifierToList(type, arr)
	{
		var i, len, t;
		if (!type)
			return;
		if (arr.indexOf(type) === -1)
			arr.push(type);
		if (type.is_contained)
		{
			for (i = 0, len = type.container.length; i < len; i++)
			{
				t = type.container[i];
				if (type === t)
					continue;		// already handled
				if (arr.indexOf(t) === -1)
					arr.push(t);
			}
		}
	};
	EventBlock.prototype.addSolModifier = function (type)
	{
		addSolModifierToList(type, this.solModifiers);
	};
	EventBlock.prototype.addParentSolModifier = function (type)
	{
		addSolModifierToList(type, this.solModifiersIncludingParents);
	};
	EventBlock.prototype.setSolWriterAfterCnds = function ()
	{
		this.solWriterAfterCnds = true;
		if (this.parent)
			this.parent.setSolWriterAfterCnds();
	};
	EventBlock.prototype.is_trigger = function ()
	{
		if (!this.conditions.length)    // no conditions
			return false;
		else
			return this.conditions[0].trigger;
	};
	EventBlock.prototype.run = function ()
	{
		var i, len, any_true = false, cnd_result;
		var runtime = this.runtime;
		var evinfo = this.runtime.getCurrentEventStack();
		evinfo.current_event = this;
		var conditions = this.conditions;
			if (!this.is_else_block)
				evinfo.else_branch_ran = false;
		if (this.orblock)
		{
			if (conditions.length === 0)
				any_true = true;		// be sure to run if empty block
				evinfo.cndindex = 0
			for (len = conditions.length; evinfo.cndindex < len; evinfo.cndindex++)
			{
				if (conditions[evinfo.cndindex].trigger)		// skip triggers when running OR block
					continue;
				cnd_result = conditions[evinfo.cndindex].run();
				if (cnd_result)			// make sure all conditions run and run if any were true
					any_true = true;
			}
			evinfo.last_event_true = any_true;
			if (any_true)
				this.run_actions_and_subevents();
		}
		else
		{
				evinfo.cndindex = 0
			for (len = conditions.length; evinfo.cndindex < len; evinfo.cndindex++)
			{
				cnd_result = conditions[evinfo.cndindex].run();
				if (!cnd_result)    // condition failed
				{
					evinfo.last_event_true = false;
					if (this.toplevelevent && (!runtime.deathRow.isEmpty() || runtime.createRow.length))
						runtime.ClearDeathRow();
					return;		// bail out now
				}
			}
			evinfo.last_event_true = true;
			this.run_actions_and_subevents();
		}
		this.end_run(evinfo);
	};
	EventBlock.prototype.end_run = function (evinfo)
	{
		if (evinfo.last_event_true && this.has_else_block)
			evinfo.else_branch_ran = true;
		if (this.toplevelevent && (!this.runtime.deathRow.isEmpty() || this.runtime.createRow.length))
			this.runtime.ClearDeathRow();
	};
	EventBlock.prototype.run_orblocktrigger = function (index)
	{
		var evinfo = this.runtime.getCurrentEventStack();
		evinfo.current_event = this;
		if (this.conditions[index].run())
		{
			this.run_actions_and_subevents();
			this.runtime.getCurrentEventStack().last_event_true = true;
		}
	};
	EventBlock.prototype.run_actions_and_subevents = function ()
	{
		var evinfo = this.runtime.getCurrentEventStack();
		var len;
		for (evinfo.actindex = 0, len = this.actions.length; evinfo.actindex < len; evinfo.actindex++)
		{
			if (this.actions[evinfo.actindex].run())
				return;
		}
		this.run_subevents();
	};
	EventBlock.prototype.resume_actions_and_subevents = function ()
	{
		var evinfo = this.runtime.getCurrentEventStack();
		var len;
		for (len = this.actions.length; evinfo.actindex < len; evinfo.actindex++)
		{
			if (this.actions[evinfo.actindex].run())
				return;
		}
		this.run_subevents();
	};
	EventBlock.prototype.run_subevents = function ()
	{
		if (!this.subevents.length)
			return;
		var i, len, subev, pushpop/*, skipped_pop = false, pop_modifiers = null*/;
		var last = this.subevents.length - 1;
			this.runtime.pushEventStack(this);
		if (this.solWriterAfterCnds)
		{
			for (i = 0, len = this.subevents.length; i < len; i++)
			{
				subev = this.subevents[i];
					pushpop = (!this.toplevelgroup || (!this.group && i < last));
					if (pushpop)
						this.runtime.pushCopySol(subev.solModifiers);
				subev.run();
					if (pushpop)
						this.runtime.popSol(subev.solModifiers);
					else
						this.runtime.clearSol(subev.solModifiers);
			}
		}
		else
		{
			for (i = 0, len = this.subevents.length; i < len; i++)
			{
				this.subevents[i].run();
			}
		}
			this.runtime.popEventStack();
	};
	EventBlock.prototype.run_pretrigger = function ()
	{
		var evinfo = this.runtime.getCurrentEventStack();
		evinfo.current_event = this;
		var any_true = false;
		var i, len;
		for (evinfo.cndindex = 0, len = this.conditions.length; evinfo.cndindex < len; evinfo.cndindex++)
		{
;
			if (this.conditions[evinfo.cndindex].run())
				any_true = true;
			else if (!this.orblock)			// condition failed (let OR blocks run all conditions anyway)
				return false;               // bail out
		}
		return this.orblock ? any_true : true;
	};
	EventBlock.prototype.retrigger = function ()
	{
		this.runtime.execcount++;
		var prevcndindex = this.runtime.getCurrentEventStack().cndindex;
		var len;
		var evinfo = this.runtime.pushEventStack(this);
		if (!this.orblock)
		{
			for (evinfo.cndindex = prevcndindex + 1, len = this.conditions.length; evinfo.cndindex < len; evinfo.cndindex++)
			{
				if (!this.conditions[evinfo.cndindex].run())    // condition failed
				{
					this.runtime.popEventStack();               // moving up level of recursion
					return false;                               // bail out
				}
			}
		}
		this.run_actions_and_subevents();
		this.runtime.popEventStack();
		return true;		// ran an iteration
	};
	EventBlock.prototype.isFirstConditionOfType = function (cnd)
	{
		var cndindex = cnd.index;
		if (cndindex === 0)
			return true;
		--cndindex;
		for ( ; cndindex >= 0; --cndindex)
		{
			if (this.conditions[cndindex].type === cnd.type)
				return false;
		}
		return true;
	};
	cr.eventblock = EventBlock;
	function Condition(block, m)
	{
		this.block = block;
		this.sheet = block.sheet;
		this.runtime = block.runtime;
		this.parameters = [];
		this.results = [];
		this.extra = {};		// for plugins to stow away some custom info
		this.index = -1;
		this.anyParamVariesPerInstance = false;
		this.func = m[1];
;
		this.trigger = (m[3] > 0);
		this.fasttrigger = (m[3] === 2);
		this.looping = m[4];
		this.inverted = m[5];
		this.isstatic = m[6];
		this.sid = m[7];
		this.runtime.cndsBySid[this.sid.toString()] = this;
		if (m[0] === -1)		// system object
		{
			this.type = null;
			this.run = this.run_system;
			this.behaviortype = null;
			this.beh_index = -1;
		}
		else
		{
			this.type = this.runtime.types_by_index[m[0]];
;
			if (this.isstatic)
				this.run = this.run_static;
			else
				this.run = this.run_object;
			if (m[2])
			{
				this.behaviortype = this.type.getBehaviorByName(m[2]);
;
				this.beh_index = this.type.getBehaviorIndexByName(m[2]);
;
			}
			else
			{
				this.behaviortype = null;
				this.beh_index = -1;
			}
			if (this.block.parent)
				this.block.parent.setSolWriterAfterCnds();
		}
		if (this.fasttrigger)
			this.run = this.run_true;
		if (m.length === 10)
		{
			var i, len;
			var em = m[9];
			for (i = 0, len = em.length; i < len; i++)
			{
				var param = new cr.parameter(this, em[i]);
				cr.seal(param);
				this.parameters.push(param);
			}
			this.results.length = em.length;
		}
	};
	Condition.prototype.postInit = function ()
	{
		var i, len, p;
		for (i = 0, len = this.parameters.length; i < len; i++)
		{
			p = this.parameters[i];
			p.postInit();
			if (p.variesPerInstance)
				this.anyParamVariesPerInstance = true;
		}
	};
	/*
	Condition.prototype.is_logical = function ()
	{
		return !this.type || this.type.plugin.singleglobal;
	};
	*/
	Condition.prototype.run_true = function ()
	{
		return true;
	};
	Condition.prototype.run_system = function ()
	{
		var i, len;
		for (i = 0, len = this.parameters.length; i < len; i++)
			this.results[i] = this.parameters[i].get();
		return cr.xor(this.func.apply(this.runtime.system, this.results), this.inverted);
	};
	Condition.prototype.run_static = function ()
	{
		var i, len;
		for (i = 0, len = this.parameters.length; i < len; i++)
			this.results[i] = this.parameters[i].get();
		var ret = this.func.apply(this.behaviortype ? this.behaviortype : this.type, this.results);
		this.type.applySolToContainer();
		return ret;
	};
	Condition.prototype.run_object = function ()
	{
		var i, j, k, leni, lenj, p, ret, met, inst, s, sol2;
		var type = this.type;
		var sol = type.getCurrentSol();
		var is_orblock = this.block.orblock && !this.trigger;		// triggers in OR blocks need to work normally
		var offset = 0;
		var is_contained = type.is_contained;
		var is_family = type.is_family;
		var family_index = type.family_index;
		var beh_index = this.beh_index;
		var is_beh = (beh_index > -1);
		var params_vary = this.anyParamVariesPerInstance;
		var parameters = this.parameters;
		var results = this.results;
		var inverted = this.inverted;
		var func = this.func;
		var arr, container;
		if (params_vary)
		{
			for (j = 0, lenj = parameters.length; j < lenj; ++j)
			{
				p = parameters[j];
				if (!p.variesPerInstance)
					results[j] = p.get(0);
			}
		}
		else
		{
			for (j = 0, lenj = parameters.length; j < lenj; ++j)
				results[j] = parameters[j].get(0);
		}
		if (sol.select_all) {
			sol.instances.length = 0;       // clear contents
			sol.else_instances.length = 0;
			arr = type.instances;
			for (i = 0, leni = arr.length; i < leni; ++i)
			{
				inst = arr[i];
;
				if (params_vary)
				{
					for (j = 0, lenj = parameters.length; j < lenj; ++j)
					{
						p = parameters[j];
						if (p.variesPerInstance)
							results[j] = p.get(i);        // default SOL index is current object
					}
				}
				if (is_beh)
				{
					offset = 0;
					if (is_family)
					{
						offset = inst.type.family_beh_map[family_index];
					}
					ret = func.apply(inst.behavior_insts[beh_index + offset], results);
				}
				else
					ret = func.apply(inst, results);
				met = cr.xor(ret, inverted);
				if (met)
					sol.instances.push(inst);
				else if (is_orblock)					// in OR blocks, keep the instances not meeting the condition for subsequent testing
					sol.else_instances.push(inst);
			}
			if (type.finish)
				type.finish(true);
			sol.select_all = false;
			type.applySolToContainer();
			return sol.hasObjects();
		}
		else {
			k = 0;
			var using_else_instances = (is_orblock && !this.block.isFirstConditionOfType(this));
			arr = (using_else_instances ? sol.else_instances : sol.instances);
			var any_true = false;
			for (i = 0, leni = arr.length; i < leni; ++i)
			{
				inst = arr[i];
;
				if (params_vary)
				{
					for (j = 0, lenj = parameters.length; j < lenj; ++j)
					{
						p = parameters[j];
						if (p.variesPerInstance)
							results[j] = p.get(i);        // default SOL index is current object
					}
				}
				if (is_beh)
				{
					offset = 0;
					if (is_family)
					{
						offset = inst.type.family_beh_map[family_index];
					}
					ret = func.apply(inst.behavior_insts[beh_index + offset], results);
				}
				else
					ret = func.apply(inst, results);
				if (cr.xor(ret, inverted))
				{
					any_true = true;
					if (using_else_instances)
					{
						sol.instances.push(inst);
						if (is_contained)
						{
							for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
							{
								s = inst.siblings[j];
								s.type.getCurrentSol().instances.push(s);
							}
						}
					}
					else
					{
						arr[k] = inst;
						if (is_contained)
						{
							for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
							{
								s = inst.siblings[j];
								s.type.getCurrentSol().instances[k] = s;
							}
						}
						k++;
					}
				}
				else
				{
					if (using_else_instances)
					{
						arr[k] = inst;
						if (is_contained)
						{
							for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
							{
								s = inst.siblings[j];
								s.type.getCurrentSol().else_instances[k] = s;
							}
						}
						k++;
					}
					else if (is_orblock)
					{
						sol.else_instances.push(inst);
						if (is_contained)
						{
							for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
							{
								s = inst.siblings[j];
								s.type.getCurrentSol().else_instances.push(s);
							}
						}
					}
				}
			}
			arr.length = k;
			if (is_contained)
			{
				container = type.container;
				for (i = 0, leni = container.length; i < leni; i++)
				{
					sol2 = container[i].getCurrentSol();
					if (using_else_instances)
						sol2.else_instances.length = k;
					else
						sol2.instances.length = k;
				}
			}
			var pick_in_finish = any_true;		// don't pick in finish() if we're only doing the logic test below
			if (using_else_instances && !any_true)
			{
				for (i = 0, leni = sol.instances.length; i < leni; i++)
				{
					inst = sol.instances[i];
					if (params_vary)
					{
						for (j = 0, lenj = parameters.length; j < lenj; j++)
						{
							p = parameters[j];
							if (p.variesPerInstance)
								results[j] = p.get(i);
						}
					}
					if (is_beh)
						ret = func.apply(inst.behavior_insts[beh_index], results);
					else
						ret = func.apply(inst, results);
					if (cr.xor(ret, inverted))
					{
						any_true = true;
						break;		// got our flag, don't need to test any more
					}
				}
			}
			if (type.finish)
				type.finish(pick_in_finish || is_orblock);
			return is_orblock ? any_true : sol.hasObjects();
		}
	};
	cr.condition = Condition;
	function Action(block, m)
	{
		this.block = block;
		this.sheet = block.sheet;
		this.runtime = block.runtime;
		this.parameters = [];
		this.results = [];
		this.extra = {};		// for plugins to stow away some custom info
		this.index = -1;
		this.anyParamVariesPerInstance = false;
		this.func = m[1];
;
		if (m[0] === -1)	// system
		{
			this.type = null;
			this.run = this.run_system;
			this.behaviortype = null;
			this.beh_index = -1;
		}
		else
		{
			this.type = this.runtime.types_by_index[m[0]];
;
			this.run = this.run_object;
			if (m[2])
			{
				this.behaviortype = this.type.getBehaviorByName(m[2]);
;
				this.beh_index = this.type.getBehaviorIndexByName(m[2]);
;
			}
			else
			{
				this.behaviortype = null;
				this.beh_index = -1;
			}
		}
		this.sid = m[3];
		this.runtime.actsBySid[this.sid.toString()] = this;
		if (m.length === 6)
		{
			var i, len;
			var em = m[5];
			for (i = 0, len = em.length; i < len; i++)
			{
				var param = new cr.parameter(this, em[i]);
				cr.seal(param);
				this.parameters.push(param);
			}
			this.results.length = em.length;
		}
	};
	Action.prototype.postInit = function ()
	{
		var i, len, p;
		for (i = 0, len = this.parameters.length; i < len; i++)
		{
			p = this.parameters[i];
			p.postInit();
			if (p.variesPerInstance)
				this.anyParamVariesPerInstance = true;
		}
	};
	Action.prototype.run_system = function ()
	{
		var i, len;
		for (i = 0, len = this.parameters.length; i < len; i++)
			this.results[i] = this.parameters[i].get();
		return this.func.apply(this.runtime.system, this.results);
	};
	Action.prototype.run_object = function ()
	{
		var instances = this.type.getCurrentSol().getObjects();
		var is_family = this.type.is_family;
		var family_index = this.type.family_index;
		var beh_index = this.beh_index;
		var is_beh = (beh_index > -1);
		var params_vary = this.anyParamVariesPerInstance;
		var parameters = this.parameters;
		var results = this.results;
		var func = this.func;
		var i, j, leni, lenj, p, inst, offset;
		if (params_vary)
		{
			for (j = 0, lenj = parameters.length; j < lenj; ++j)
			{
				p = parameters[j];
				if (!p.variesPerInstance)
					results[j] = p.get(0);
			}
		}
		else
		{
			for (j = 0, lenj = parameters.length; j < lenj; ++j)
				results[j] = parameters[j].get(0);
		}
		for (i = 0, leni = instances.length; i < leni; ++i)
		{
			inst = instances[i];
			if (params_vary)
			{
				for (j = 0, lenj = parameters.length; j < lenj; ++j)
				{
					p = parameters[j];
					if (p.variesPerInstance)
						results[j] = p.get(i);    // pass i to use as default SOL index
				}
			}
			if (is_beh)
			{
				offset = 0;
				if (is_family)
				{
					offset = inst.type.family_beh_map[family_index];
				}
				func.apply(inst.behavior_insts[beh_index + offset], results);
			}
			else
				func.apply(inst, results);
		}
		return false;
	};
	cr.action = Action;
	var tempValues = [];
	var tempValuesPtr = -1;
	function Parameter(owner, m)
	{
		this.owner = owner;
		this.block = owner.block;
		this.sheet = owner.sheet;
		this.runtime = owner.runtime;
		this.type = m[0];
		this.expression = null;
		this.solindex = 0;
		this.get = null;
		this.combosel = 0;
		this.layout = null;
		this.key = 0;
		this.object = null;
		this.index = 0;
		this.varname = null;
		this.eventvar = null;
		this.fileinfo = null;
		this.subparams = null;
		this.variadicret = null;
		this.subparams = null;
		this.variadicret = null;
		this.variesPerInstance = false;
		var i, len, param;
		switch (m[0])
		{
			case 0:		// number
			case 7:		// any
				this.expression = new cr.expNode(this, m[1]);
				this.solindex = 0;
				this.get = this.get_exp;
				break;
			case 1:		// string
				this.expression = new cr.expNode(this, m[1]);
				this.solindex = 0;
				this.get = this.get_exp_str;
				break;
			case 5:		// layer
				this.expression = new cr.expNode(this, m[1]);
				this.solindex = 0;
				this.get = this.get_layer;
				break;
			case 3:		// combo
			case 8:		// cmp
				this.combosel = m[1];
				this.get = this.get_combosel;
				break;
			case 6:		// layout
				this.layout = this.runtime.layouts[m[1]];
;
				this.get = this.get_layout;
				break;
			case 9:		// keyb
				this.key = m[1];
				this.get = this.get_key;
				break;
			case 4:		// object
				this.object = this.runtime.types_by_index[m[1]];
;
				this.get = this.get_object;
				this.block.addSolModifier(this.object);
				if (this.owner instanceof cr.action)
					this.block.setSolWriterAfterCnds();
				else if (this.block.parent)
					this.block.parent.setSolWriterAfterCnds();
				break;
			case 10:	// instvar
				this.index = m[1];
				if (owner.type.is_family)
				{
					this.get = this.get_familyvar;
					this.variesPerInstance = true;
				}
				else
					this.get = this.get_instvar;
				break;
			case 11:	// eventvar
				this.varname = m[1];
				this.eventvar = null;
				this.get = this.get_eventvar;
				break;
			case 2:		// audiofile	["name", ismusic]
			case 12:	// fileinfo		"name"
				this.fileinfo = m[1];
				this.get = this.get_audiofile;
				break;
			case 13:	// variadic
				this.get = this.get_variadic;
				this.subparams = [];
				this.variadicret = [];
				for (i = 1, len = m.length; i < len; i++)
				{
					param = new cr.parameter(this.owner, m[i]);
					cr.seal(param);
					this.subparams.push(param);
					this.variadicret.push(0);
				}
				break;
			default:
;
		}
	};
	Parameter.prototype.postInit = function ()
	{
		var i, len;
		if (this.type === 11)		// eventvar
		{
			this.eventvar = this.runtime.getEventVariableByName(this.varname, this.block.parent);
;
		}
		else if (this.type === 13)	// variadic, postInit all sub-params
		{
			for (i = 0, len = this.subparams.length; i < len; i++)
				this.subparams[i].postInit();
		}
		if (this.expression)
			this.expression.postInit();
	};
	Parameter.prototype.maybeVaryForType = function (t)
	{
		if (this.variesPerInstance)
			return;				// already varies per instance, no need to check again
		if (!t)
			return;				// never vary for system type
		if (!t.plugin.singleglobal)
		{
			this.variesPerInstance = true;
			return;
		}
	};
	Parameter.prototype.setVaries = function ()
	{
		this.variesPerInstance = true;
	};
	Parameter.prototype.pushTempValue = function ()
	{
		tempValuesPtr++;
		if (tempValues.length === tempValuesPtr)
			tempValues.push(new cr.expvalue());
		return tempValues[tempValuesPtr];
	};
	Parameter.prototype.popTempValue = function ()
	{
		tempValuesPtr--;
	};
	Parameter.prototype.get_exp = function (solindex)
	{
		this.solindex = solindex || 0;   // default SOL index to use
		var temp = this.pushTempValue();
		this.expression.get(temp);
		this.popTempValue();
		return temp.data;      			// return actual JS value, not expvalue
	};
	Parameter.prototype.get_exp_str = function (solindex)
	{
		this.solindex = solindex || 0;   // default SOL index to use
		var temp = this.pushTempValue();
		this.expression.get(temp);
		this.popTempValue();
		if (cr.is_string(temp.data))
			return temp.data;
		else
			return "";
	};
	Parameter.prototype.get_object = function ()
	{
		return this.object;
	};
	Parameter.prototype.get_combosel = function ()
	{
		return this.combosel;
	};
	Parameter.prototype.get_layer = function (solindex)
	{
		this.solindex = solindex || 0;   // default SOL index to use
		var temp = this.pushTempValue();
		this.expression.get(temp);
		this.popTempValue();
		if (temp.is_number())
			return this.runtime.getLayerByNumber(temp.data);
		else
			return this.runtime.getLayerByName(temp.data);
	}
	Parameter.prototype.get_layout = function ()
	{
		return this.layout;
	};
	Parameter.prototype.get_key = function ()
	{
		return this.key;
	};
	Parameter.prototype.get_instvar = function ()
	{
		return this.index;
	};
	Parameter.prototype.get_familyvar = function (solindex_)
	{
		var solindex = solindex_ || 0;
		var familytype = this.owner.type;
		var realtype = null;
		var sol = familytype.getCurrentSol();
		var objs = sol.getObjects();
		if (objs.length)
			realtype = objs[solindex % objs.length].type;
		else if (sol.else_instances.length)
			realtype = sol.else_instances[solindex % sol.else_instances.length].type;
		else if (familytype.instances.length)
			realtype = familytype.instances[solindex % familytype.instances.length].type;
		else
			return 0;
		return this.index + realtype.family_var_map[familytype.family_index];
	};
	Parameter.prototype.get_eventvar = function ()
	{
		return this.eventvar;
	};
	Parameter.prototype.get_audiofile = function ()
	{
		return this.fileinfo;
	};
	Parameter.prototype.get_variadic = function ()
	{
		var i, len;
		for (i = 0, len = this.subparams.length; i < len; i++)
		{
			this.variadicret[i] = this.subparams[i].get();
		}
		return this.variadicret;
	};
	cr.parameter = Parameter;
	function EventVariable(sheet, parent, m)
	{
		this.sheet = sheet;
		this.parent = parent;
		this.runtime = sheet.runtime;
		this.solModifiers = [];
		this.name = m[1];
		this.vartype = m[2];
		this.initial = m[3];
		this.is_static = !!m[4];
		this.is_constant = !!m[5];
		this.sid = m[6];
		this.runtime.varsBySid[this.sid.toString()] = this;
		this.data = this.initial;	// note: also stored in event stack frame for local nonstatic nonconst vars
		if (this.parent)			// local var
		{
			if (this.is_static || this.is_constant)
				this.localIndex = -1;
			else
				this.localIndex = this.runtime.stackLocalCount++;
			this.runtime.all_local_vars.push(this);
		}
		else						// global var
		{
			this.localIndex = -1;
			this.runtime.all_global_vars.push(this);
		}
	};
	EventVariable.prototype.postInit = function ()
	{
		this.solModifiers = findMatchingSolModifier(this.solModifiers);
	};
	EventVariable.prototype.setValue = function (x)
	{
;
		var lvs = this.runtime.getCurrentLocalVarStack();
		if (!this.parent || this.is_static || !lvs)
			this.data = x;
		else	// local nonstatic variable: use event stack to keep value at this level of recursion
		{
			if (this.localIndex >= lvs.length)
				lvs.length = this.localIndex + 1;
			lvs[this.localIndex] = x;
		}
	};
	EventVariable.prototype.getValue = function ()
	{
		var lvs = this.runtime.getCurrentLocalVarStack();
		if (!this.parent || this.is_static || !lvs || this.is_constant)
			return this.data;
		else	// local nonstatic variable
		{
			if (this.localIndex >= lvs.length)
			{
;
				return this.initial;
			}
			if (typeof lvs[this.localIndex] === "undefined")
			{
;
				return this.initial;
			}
			return lvs[this.localIndex];
		}
	};
	EventVariable.prototype.run = function ()
	{
			if (this.parent && !this.is_static && !this.is_constant)
				this.setValue(this.initial);
	};
	cr.eventvariable = EventVariable;
	function EventInclude(sheet, parent, m)
	{
		this.sheet = sheet;
		this.parent = parent;
		this.runtime = sheet.runtime;
		this.solModifiers = [];
		this.include_sheet = null;		// determined in postInit
		this.include_sheet_name = m[1];
		this.active = true;
	};
	EventInclude.prototype.toString = function ()
	{
		return "include:" + this.include_sheet.toString();
	};
	EventInclude.prototype.postInit = function ()
	{
        this.include_sheet = this.runtime.eventsheets[this.include_sheet_name];
;
;
        this.sheet.includes.add(this);
		this.solModifiers = findMatchingSolModifier(this.solModifiers);
		var p = this.parent;
		while (p)
		{
			if (p.group)
				p.contained_includes.push(this);
			p = p.parent;
		}
		this.updateActive();
	};
	EventInclude.prototype.run = function ()
	{
			if (this.parent)
				this.runtime.pushCleanSol(this.runtime.types_by_index);
        if (!this.include_sheet.hasRun)
            this.include_sheet.run(true);			// from include
			if (this.parent)
				this.runtime.popSol(this.runtime.types_by_index);
	};
	EventInclude.prototype.updateActive = function ()
	{
		var p = this.parent;
		while (p)
		{
			if (p.group && !p.group_active)
			{
				this.active = false;
				return;
			}
			p = p.parent;
		}
		this.active = true;
	};
	EventInclude.prototype.isActive = function ()
	{
		return this.active;
	};
	cr.eventinclude = EventInclude;
	function EventStackFrame()
	{
		this.temp_parents_arr = [];
		this.reset(null);
		cr.seal(this);
	};
	EventStackFrame.prototype.reset = function (cur_event)
	{
		this.current_event = cur_event;
		this.cndindex = 0;
		this.actindex = 0;
		this.temp_parents_arr.length = 0;
		this.last_event_true = false;
		this.else_branch_ran = false;
		this.any_true_state = false;
	};
	EventStackFrame.prototype.isModifierAfterCnds = function ()
	{
		if (this.current_event.solWriterAfterCnds)
			return true;
		if (this.cndindex < this.current_event.conditions.length - 1)
			return !!this.current_event.solModifiers.length;
		return false;
	};
	cr.eventStackFrame = EventStackFrame;
}());
(function()
{
	function ExpNode(owner_, m)
	{
		this.owner = owner_;
		this.runtime = owner_.runtime;
		this.type = m[0];
;
		this.get = [this.eval_int,
					this.eval_float,
					this.eval_string,
					this.eval_unaryminus,
					this.eval_add,
					this.eval_subtract,
					this.eval_multiply,
					this.eval_divide,
					this.eval_mod,
					this.eval_power,
					this.eval_and,
					this.eval_or,
					this.eval_equal,
					this.eval_notequal,
					this.eval_less,
					this.eval_lessequal,
					this.eval_greater,
					this.eval_greaterequal,
					this.eval_conditional,
					this.eval_system_exp,
					this.eval_object_behavior_exp,
					this.eval_instvar_exp,
					this.eval_object_behavior_exp,
					this.eval_eventvar_exp][this.type];
		var paramsModel = null;
		this.value = null;
		this.first = null;
		this.second = null;
		this.third = null;
		this.func = null;
		this.results = null;
		this.parameters = null;
		this.object_type = null;
		this.beh_index = -1;
		this.instance_expr = null;
		this.varindex = -1;
		this.behavior_type = null;
		this.varname = null;
		this.eventvar = null;
		this.return_string = false;
		switch (this.type) {
		case 0:		// int
		case 1:		// float
		case 2:		// string
			this.value = m[1];
			break;
		case 3:		// unaryminus
			this.first = new cr.expNode(owner_, m[1]);
			break;
		case 18:	// conditional
			this.first = new cr.expNode(owner_, m[1]);
			this.second = new cr.expNode(owner_, m[2]);
			this.third = new cr.expNode(owner_, m[3]);
			break;
		case 19:	// system_exp
			this.func = m[1];
;
			if (this.func === cr.system_object.prototype.exps.random
			 || this.func === cr.system_object.prototype.exps.choose)
			{
				this.owner.setVaries();
			}
			this.results = [];
			this.parameters = [];
			if (m.length === 3)
			{
				paramsModel = m[2];
				this.results.length = paramsModel.length + 1;	// must also fit 'ret'
			}
			else
				this.results.length = 1;      // to fit 'ret'
			break;
		case 20:	// object_exp
			this.object_type = this.runtime.types_by_index[m[1]];
;
			this.beh_index = -1;
			this.func = m[2];
			this.return_string = m[3];
			if (cr.plugins_.Function && this.func === cr.plugins_.Function.prototype.exps.Call)
			{
				this.owner.setVaries();
			}
			if (m[4])
				this.instance_expr = new cr.expNode(owner_, m[4]);
			else
				this.instance_expr = null;
			this.results = [];
			this.parameters = [];
			if (m.length === 6)
			{
				paramsModel = m[5];
				this.results.length = paramsModel.length + 1;
			}
			else
				this.results.length = 1;	// to fit 'ret'
			break;
		case 21:		// instvar_exp
			this.object_type = this.runtime.types_by_index[m[1]];
;
			this.return_string = m[2];
			if (m[3])
				this.instance_expr = new cr.expNode(owner_, m[3]);
			else
				this.instance_expr = null;
			this.varindex = m[4];
			break;
		case 22:		// behavior_exp
			this.object_type = this.runtime.types_by_index[m[1]];
;
			this.behavior_type = this.object_type.getBehaviorByName(m[2]);
;
			this.beh_index = this.object_type.getBehaviorIndexByName(m[2]);
			this.func = m[3];
			this.return_string = m[4];
			if (m[5])
				this.instance_expr = new cr.expNode(owner_, m[5]);
			else
				this.instance_expr = null;
			this.results = [];
			this.parameters = [];
			if (m.length === 7)
			{
				paramsModel = m[6];
				this.results.length = paramsModel.length + 1;
			}
			else
				this.results.length = 1;	// to fit 'ret'
			break;
		case 23:		// eventvar_exp
			this.varname = m[1];
			this.eventvar = null;	// assigned in postInit
			break;
		}
		this.owner.maybeVaryForType(this.object_type);
		if (this.type >= 4 && this.type <= 17)
		{
			this.first = new cr.expNode(owner_, m[1]);
			this.second = new cr.expNode(owner_, m[2]);
		}
		if (paramsModel)
		{
			var i, len;
			for (i = 0, len = paramsModel.length; i < len; i++)
				this.parameters.push(new cr.expNode(owner_, paramsModel[i]));
		}
		cr.seal(this);
	};
	ExpNode.prototype.postInit = function ()
	{
		if (this.type === 23)	// eventvar_exp
		{
			this.eventvar = this.owner.runtime.getEventVariableByName(this.varname, this.owner.block.parent);
;
		}
		if (this.first)
			this.first.postInit();
		if (this.second)
			this.second.postInit();
		if (this.third)
			this.third.postInit();
		if (this.instance_expr)
			this.instance_expr.postInit();
		if (this.parameters)
		{
			var i, len;
			for (i = 0, len = this.parameters.length; i < len; i++)
				this.parameters[i].postInit();
		}
	};
	ExpNode.prototype.eval_system_exp = function (ret)
	{
		this.results[0] = ret;
		var temp = this.owner.pushTempValue();
		var i, len;
		for (i = 0, len = this.parameters.length; i < len; i++)
		{
			this.parameters[i].get(temp);
			this.results[i + 1] = temp.data;   // passing actual javascript value as argument instead of expvalue
		}
		this.owner.popTempValue();
		this.func.apply(this.runtime.system, this.results);
	};
	ExpNode.prototype.eval_object_behavior_exp = function (ret)
	{
		var sol = this.object_type.getCurrentSol();
		var instances = sol.getObjects();
		if (!instances.length)
		{
			if (sol.else_instances.length)
				instances = sol.else_instances;
			else
			{
				if (this.return_string)
					ret.set_string("");
				else
					ret.set_int(0);
				return;
			}
		}
		this.results[0] = ret;
		ret.object_class = this.object_type;		// so expression can access family type if need be
		var temp = this.owner.pushTempValue();
		var i, len;
		for (i = 0, len = this.parameters.length; i < len; i++) {
			this.parameters[i].get(temp);
			this.results[i + 1] = temp.data;   // passing actual javascript value as argument instead of expvalue
		}
		var index = this.owner.solindex;
		if (this.instance_expr) {
			this.instance_expr.get(temp);
			if (temp.is_number()) {
				index = temp.data;
				instances = this.object_type.instances;    // pick from all instances, not SOL
			}
		}
		this.owner.popTempValue();
		index %= instances.length;      // wraparound
		if (index < 0)
			index += instances.length;
		var returned_val;
		var inst = instances[index];
		if (this.beh_index > -1)
		{
			var offset = 0;
			if (this.object_type.is_family)
			{
				offset = inst.type.family_beh_map[this.object_type.family_index];
			}
			returned_val = this.func.apply(inst.behavior_insts[this.beh_index + offset], this.results);
		}
		else
			returned_val = this.func.apply(inst, this.results);
;
	};
	ExpNode.prototype.eval_instvar_exp = function (ret)
	{
		var sol = this.object_type.getCurrentSol();
		var instances = sol.getObjects();
		if (!instances.length)
		{
			if (sol.else_instances.length)
				instances = sol.else_instances;
			else
			{
				if (this.return_string)
					ret.set_string("");
				else
					ret.set_int(0);
				return;
			}
		}
		var index = this.owner.solindex;
		if (this.instance_expr)
		{
			var temp = this.owner.pushTempValue();
			this.instance_expr.get(temp);
			if (temp.is_number())
			{
				index = temp.data;
				var type_instances = this.object_type.instances;
				index %= type_instances.length;     // wraparound
				if (index < 0)                      // offset
					index += type_instances.length;
				var to_ret = type_instances[index].instance_vars[this.varindex];
				if (cr.is_string(to_ret))
					ret.set_string(to_ret);
				else
					ret.set_float(to_ret);
				this.owner.popTempValue();
				return;         // done
			}
			this.owner.popTempValue();
		}
		index %= instances.length;      // wraparound
		if (index < 0)
			index += instances.length;
		var inst = instances[index];
		var offset = 0;
		if (this.object_type.is_family)
		{
			offset = inst.type.family_var_map[this.object_type.family_index];
		}
		var to_ret = inst.instance_vars[this.varindex + offset];
		if (cr.is_string(to_ret))
			ret.set_string(to_ret);
		else
			ret.set_float(to_ret);
	};
	ExpNode.prototype.eval_int = function (ret)
	{
		ret.type = cr.exptype.Integer;
		ret.data = this.value;
	};
	ExpNode.prototype.eval_float = function (ret)
	{
		ret.type = cr.exptype.Float;
		ret.data = this.value;
	};
	ExpNode.prototype.eval_string = function (ret)
	{
		ret.type = cr.exptype.String;
		ret.data = this.value;
	};
	ExpNode.prototype.eval_unaryminus = function (ret)
	{
		this.first.get(ret);                // retrieve operand
		if (ret.is_number())
			ret.data = -ret.data;
	};
	ExpNode.prototype.eval_add = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number() && temp.is_number())
		{
			ret.data += temp.data;          // both operands numbers: add
			if (temp.is_float())
				ret.make_float();
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_subtract = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number() && temp.is_number())
		{
			ret.data -= temp.data;          // both operands numbers: subtract
			if (temp.is_float())
				ret.make_float();
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_multiply = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number() && temp.is_number())
		{
			ret.data *= temp.data;          // both operands numbers: multiply
			if (temp.is_float())
				ret.make_float();
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_divide = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number() && temp.is_number())
		{
			ret.data /= temp.data;          // both operands numbers: divide
			ret.make_float();
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_mod = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number() && temp.is_number())
		{
			ret.data %= temp.data;          // both operands numbers: modulo
			if (temp.is_float())
				ret.make_float();
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_power = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number() && temp.is_number())
		{
			ret.data = Math.pow(ret.data, temp.data);   // both operands numbers: raise to power
			if (temp.is_float())
				ret.make_float();
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_and = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number())
		{
			if (temp.is_string())
			{
				ret.set_string(ret.data.toString() + temp.data);
			}
			else
			{
				if (ret.data && temp.data)
					ret.set_int(1);
				else
					ret.set_int(0);
			}
		}
		else if (ret.is_string())
		{
			if (temp.is_string())
				ret.data += temp.data;
			else
			{
				ret.data += (Math.round(temp.data * 1e10) / 1e10).toString();
			}
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_or = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number() && temp.is_number())
		{
			if (ret.data || temp.data)
				ret.set_int(1);
			else
				ret.set_int(0);
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_conditional = function (ret)
	{
		this.first.get(ret);                // condition operand
		if (ret.data)                       // is true
			this.second.get(ret);           // evaluate second operand to ret
		else
			this.third.get(ret);            // evaluate third operand to ret
	};
	ExpNode.prototype.eval_equal = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		ret.set_int(ret.data === temp.data ? 1 : 0);
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_notequal = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		ret.set_int(ret.data !== temp.data ? 1 : 0);
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_less = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		ret.set_int(ret.data < temp.data ? 1 : 0);
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_lessequal = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		ret.set_int(ret.data <= temp.data ? 1 : 0);
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_greater = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		ret.set_int(ret.data > temp.data ? 1 : 0);
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_greaterequal = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		ret.set_int(ret.data >= temp.data ? 1 : 0);
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_eventvar_exp = function (ret)
	{
		var val = this.eventvar.getValue();
		if (cr.is_number(val))
			ret.set_float(val);
		else
			ret.set_string(val);
	};
	cr.expNode = ExpNode;
	function ExpValue(type, data)
	{
		this.type = type || cr.exptype.Integer;
		this.data = data || 0;
		this.object_class = null;
;
;
;
		if (this.type == cr.exptype.Integer)
			this.data = Math.floor(this.data);
		cr.seal(this);
	};
	ExpValue.prototype.is_int = function ()
	{
		return this.type === cr.exptype.Integer;
	};
	ExpValue.prototype.is_float = function ()
	{
		return this.type === cr.exptype.Float;
	};
	ExpValue.prototype.is_number = function ()
	{
		return this.type === cr.exptype.Integer || this.type === cr.exptype.Float;
	};
	ExpValue.prototype.is_string = function ()
	{
		return this.type === cr.exptype.String;
	};
	ExpValue.prototype.make_int = function ()
	{
		if (!this.is_int())
		{
			if (this.is_float())
				this.data = Math.floor(this.data);      // truncate float
			else if (this.is_string())
				this.data = parseInt(this.data, 10);
			this.type = cr.exptype.Integer;
		}
	};
	ExpValue.prototype.make_float = function ()
	{
		if (!this.is_float())
		{
			if (this.is_string())
				this.data = parseFloat(this.data);
			this.type = cr.exptype.Float;
		}
	};
	ExpValue.prototype.make_string = function ()
	{
		if (!this.is_string())
		{
			this.data = this.data.toString();
			this.type = cr.exptype.String;
		}
	};
	ExpValue.prototype.set_int = function (val)
	{
;
		this.type = cr.exptype.Integer;
		this.data = Math.floor(val);
	};
	ExpValue.prototype.set_float = function (val)
	{
;
		this.type = cr.exptype.Float;
		this.data = val;
	};
	ExpValue.prototype.set_string = function (val)
	{
;
		this.type = cr.exptype.String;
		this.data = val;
	};
	ExpValue.prototype.set_any = function (val)
	{
		if (cr.is_number(val))
		{
			this.type = cr.exptype.Float;
			this.data = val;
		}
		else if (cr.is_string(val))
		{
			this.type = cr.exptype.String;
			this.data = val.toString();
		}
		else
		{
			this.type = cr.exptype.Integer;
			this.data = 0;
		}
	};
	cr.expvalue = ExpValue;
	cr.exptype = {
		Integer: 0,     // emulated; no native integer support in javascript
		Float: 1,
		String: 2
	};
}());
;
cr.system_object = function (runtime)
{
    this.runtime = runtime;
	this.waits = [];
};
cr.system_object.prototype.saveToJSON = function ()
{
	var o = {};
	var i, len, j, lenj, p, w, t, sobj;
	o["waits"] = [];
	var owaits = o["waits"];
	var waitobj;
	for (i = 0, len = this.waits.length; i < len; i++)
	{
		w = this.waits[i];
		waitobj = {
			"t": w.time,
			"ev": w.ev.sid,
			"sm": [],
			"sols": {}
		};
		if (w.ev.actions[w.actindex])
			waitobj["act"] = w.ev.actions[w.actindex].sid;
		for (j = 0, lenj = w.solModifiers.length; j < lenj; j++)
			waitobj["sm"].push(w.solModifiers[j].sid);
		for (p in w.sols)
		{
			if (w.sols.hasOwnProperty(p))
			{
				t = this.runtime.types_by_index[parseInt(p, 10)];
;
				sobj = {
					"sa": w.sols[p].sa,
					"insts": []
				};
				for (j = 0, lenj = w.sols[p].insts.length; j < lenj; j++)
					sobj["insts"].push(w.sols[p].insts[j].uid);
				waitobj["sols"][t.sid.toString()] = sobj;
			}
		}
		owaits.push(waitobj);
	}
	return o;
};
cr.system_object.prototype.loadFromJSON = function (o)
{
	var owaits = o["waits"];
	var i, len, j, lenj, p, w, addWait, e, aindex, t, savedsol, nusol, inst;
	this.waits.length = 0;
	for (i = 0, len = owaits.length; i < len; i++)
	{
		w = owaits[i];
		e = this.runtime.blocksBySid[w["ev"].toString()];
		if (!e)
			continue;	// event must've gone missing
		aindex = -1;
		for (j = 0, lenj = e.actions.length; j < lenj; j++)
		{
			if (e.actions[j].sid === w["act"])
			{
				aindex = j;
				break;
			}
		}
		if (aindex === -1)
			continue;	// action must've gone missing
		addWait = {};
		addWait.sols = {};
		addWait.solModifiers = [];
		addWait.deleteme = false;
		addWait.time = w["t"];
		addWait.ev = e;
		addWait.actindex = aindex;
		for (j = 0, lenj = w["sm"].length; j < lenj; j++)
		{
			t = this.runtime.getObjectTypeBySid(w["sm"][j]);
			if (t)
				addWait.solModifiers.push(t);
		}
		for (p in w["sols"])
		{
			if (w["sols"].hasOwnProperty(p))
			{
				t = this.runtime.getObjectTypeBySid(parseInt(p, 10));
				if (!t)
					continue;		// type must've been deleted
				savedsol = w["sols"][p];
				nusol = {
					sa: savedsol["sa"],
					insts: []
				};
				for (j = 0, lenj = savedsol["insts"].length; j < lenj; j++)
				{
					inst = this.runtime.getObjectByUID(savedsol["insts"][j]);
					if (inst)
						nusol.insts.push(inst);
				}
				addWait.sols[t.index.toString()] = nusol;
			}
		}
		this.waits.push(addWait);
	}
};
(function ()
{
	var sysProto = cr.system_object.prototype;
	function SysCnds() {};
    SysCnds.prototype.EveryTick = function()
    {
        return true;
    };
    SysCnds.prototype.OnLayoutStart = function()
    {
        return true;
    };
    SysCnds.prototype.OnLayoutEnd = function()
    {
        return true;
    };
    SysCnds.prototype.Compare = function(x, cmp, y)
    {
        return cr.do_cmp(x, cmp, y);
    };
    SysCnds.prototype.CompareTime = function (cmp, t)
    {
        var elapsed = this.runtime.kahanTime.sum;
        if (cmp === 0)
        {
            var cnd = this.runtime.getCurrentCondition();
            if (!cnd.extra.CompareTime_executed)
            {
                if (elapsed >= t)
                {
                    cnd.extra.CompareTime_executed = true;
                    return true;
                }
            }
            return false;
        }
        return cr.do_cmp(elapsed, cmp, t);
    };
    SysCnds.prototype.LayerVisible = function (layer)
    {
        if (!layer)
            return false;
        else
            return layer.visible;
    };
	SysCnds.prototype.LayerCmpOpacity = function (layer, cmp, opacity_)
	{
		if (!layer)
			return false;
		return cr.do_cmp(layer.opacity * 100, cmp, opacity_);
	};
    SysCnds.prototype.Repeat = function (count)
    {
		var current_frame = this.runtime.getCurrentEventStack();
        var current_event = current_frame.current_event;
		var solModifierAfterCnds = current_frame.isModifierAfterCnds();
        var current_loop = this.runtime.pushLoopStack();
        var i;
		if (solModifierAfterCnds)
		{
			for (i = 0; i < count && !current_loop.stopped; i++)
			{
				this.runtime.pushCopySol(current_event.solModifiers);
				current_loop.index = i;
				current_event.retrigger();
				this.runtime.popSol(current_event.solModifiers);
			}
		}
		else
		{
			for (i = 0; i < count && !current_loop.stopped; i++)
			{
				current_loop.index = i;
				current_event.retrigger();
			}
		}
        this.runtime.popLoopStack();
		return false;
    };
	SysCnds.prototype.While = function (count)
    {
		var current_frame = this.runtime.getCurrentEventStack();
        var current_event = current_frame.current_event;
		var solModifierAfterCnds = current_frame.isModifierAfterCnds();
        var current_loop = this.runtime.pushLoopStack();
        var i;
		if (solModifierAfterCnds)
		{
			for (i = 0; !current_loop.stopped; i++)
			{
				this.runtime.pushCopySol(current_event.solModifiers);
				current_loop.index = i;
				if (!current_event.retrigger())		// one of the other conditions returned false
					current_loop.stopped = true;	// break
				this.runtime.popSol(current_event.solModifiers);
			}
		}
		else
		{
			for (i = 0; !current_loop.stopped; i++)
			{
				current_loop.index = i;
				if (!current_event.retrigger())
					current_loop.stopped = true;
			}
		}
        this.runtime.popLoopStack();
		return false;
    };
    SysCnds.prototype.For = function (name, start, end)
    {
        var current_frame = this.runtime.getCurrentEventStack();
        var current_event = current_frame.current_event;
		var solModifierAfterCnds = current_frame.isModifierAfterCnds();
        var current_loop = this.runtime.pushLoopStack(name);
        var i;
		if (end < start)
		{
			if (solModifierAfterCnds)
			{
				for (i = start; i >= end && !current_loop.stopped; --i)  // inclusive to end
				{
					this.runtime.pushCopySol(current_event.solModifiers);
					current_loop.index = i;
					current_event.retrigger();
					this.runtime.popSol(current_event.solModifiers);
				}
			}
			else
			{
				for (i = start; i >= end && !current_loop.stopped; --i)  // inclusive to end
				{
					current_loop.index = i;
					current_event.retrigger();
				}
			}
		}
		else
		{
			if (solModifierAfterCnds)
			{
				for (i = start; i <= end && !current_loop.stopped; ++i)  // inclusive to end
				{
					this.runtime.pushCopySol(current_event.solModifiers);
					current_loop.index = i;
					current_event.retrigger();
					this.runtime.popSol(current_event.solModifiers);
				}
			}
			else
			{
				for (i = start; i <= end && !current_loop.stopped; ++i)  // inclusive to end
				{
					current_loop.index = i;
					current_event.retrigger();
				}
			}
		}
        this.runtime.popLoopStack();
		return false;
    };
	var foreach_instancestack = [];
	var foreach_instanceptr = -1;
    SysCnds.prototype.ForEach = function (obj)
    {
        var sol = obj.getCurrentSol();
		foreach_instanceptr++;
		if (foreach_instancestack.length === foreach_instanceptr)
			foreach_instancestack.push([]);
		var instances = foreach_instancestack[foreach_instanceptr];
		cr.shallowAssignArray(instances, sol.getObjects());
        var current_frame = this.runtime.getCurrentEventStack();
        var current_event = current_frame.current_event;
		var solModifierAfterCnds = current_frame.isModifierAfterCnds();
        var current_loop = this.runtime.pushLoopStack();
        var i, len, j, lenj, inst, s, sol2;
		var is_contained = obj.is_contained;
		if (solModifierAfterCnds)
		{
			for (i = 0, len = instances.length; i < len && !current_loop.stopped; i++)
			{
				this.runtime.pushCopySol(current_event.solModifiers);
				inst = instances[i];
				sol = obj.getCurrentSol();
				sol.select_all = false;
				sol.instances.length = 1;
				sol.instances[0] = inst;
				if (is_contained)
				{
					for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
					{
						s = inst.siblings[j];
						sol2 = s.type.getCurrentSol();
						sol2.select_all = false;
						sol2.instances.length = 1;
						sol2.instances[0] = s;
					}
				}
				current_loop.index = i;
				current_event.retrigger();
				this.runtime.popSol(current_event.solModifiers);
			}
		}
		else
		{
			sol.select_all = false;
			sol.instances.length = 1;
			for (i = 0, len = instances.length; i < len && !current_loop.stopped; i++)
			{
				inst = instances[i];
				sol.instances[0] = inst;
				if (is_contained)
				{
					for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
					{
						s = inst.siblings[j];
						sol2 = s.type.getCurrentSol();
						sol2.select_all = false;
						sol2.instances.length = 1;
						sol2.instances[0] = s;
					}
				}
				current_loop.index = i;
				current_event.retrigger();
			}
		}
		instances.length = 0;
        this.runtime.popLoopStack();
		foreach_instanceptr--;
		return false;
    };
	function foreach_sortinstances(a, b)
	{
		var va = a.extra.c2_foreachordered_val;
		var vb = b.extra.c2_foreachordered_val;
		if (cr.is_number(va) && cr.is_number(vb))
			return va - vb;
		else
		{
			va = "" + va;
			vb = "" + vb;
			if (va < vb)
				return -1;
			else if (va > vb)
				return 1;
			else
				return 0;
		}
	};
	SysCnds.prototype.ForEachOrdered = function (obj, exp, order)
    {
        var sol = obj.getCurrentSol();
		foreach_instanceptr++;
		if (foreach_instancestack.length === foreach_instanceptr)
			foreach_instancestack.push([]);
		var instances = foreach_instancestack[foreach_instanceptr];
		cr.shallowAssignArray(instances, sol.getObjects());
        var current_frame = this.runtime.getCurrentEventStack();
        var current_event = current_frame.current_event;
		var current_condition = this.runtime.getCurrentCondition();
		var solModifierAfterCnds = current_frame.isModifierAfterCnds();
        var current_loop = this.runtime.pushLoopStack();
		var i, len, j, lenj, inst, s, sol2;
		for (i = 0, len = instances.length; i < len; i++)
		{
			instances[i].extra.c2_foreachordered_val = current_condition.parameters[1].get(i);
		}
		instances.sort(foreach_sortinstances);
		if (order === 1)
			instances.reverse();
		var is_contained = obj.is_contained;
		if (solModifierAfterCnds)
		{
			for (i = 0, len = instances.length; i < len && !current_loop.stopped; i++)
			{
				this.runtime.pushCopySol(current_event.solModifiers);
				inst = instances[i];
				sol = obj.getCurrentSol();
				sol.select_all = false;
				sol.instances.length = 1;
				sol.instances[0] = inst;
				if (is_contained)
				{
					for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
					{
						s = inst.siblings[j];
						sol2 = s.type.getCurrentSol();
						sol2.select_all = false;
						sol2.instances.length = 1;
						sol2.instances[0] = s;
					}
				}
				current_loop.index = i;
				current_event.retrigger();
				this.runtime.popSol(current_event.solModifiers);
			}
		}
		else
		{
			sol.select_all = false;
			sol.instances.length = 1;
			for (i = 0, len = instances.length; i < len && !current_loop.stopped; i++)
			{
				inst = instances[i];
				sol.instances[0] = inst;
				if (is_contained)
				{
					for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
					{
						s = inst.siblings[j];
						sol2 = s.type.getCurrentSol();
						sol2.select_all = false;
						sol2.instances.length = 1;
						sol2.instances[0] = s;
					}
				}
				current_loop.index = i;
				current_event.retrigger();
			}
		}
		instances.length = 0;
        this.runtime.popLoopStack();
		foreach_instanceptr--;
		return false;
    };
	SysCnds.prototype.PickByComparison = function (obj_, exp_, cmp_, val_)
	{
		var i, len, k, inst;
		if (!obj_)
			return;
		foreach_instanceptr++;
		if (foreach_instancestack.length === foreach_instanceptr)
			foreach_instancestack.push([]);
		var tmp_instances = foreach_instancestack[foreach_instanceptr];
		var sol = obj_.getCurrentSol();
		cr.shallowAssignArray(tmp_instances, sol.getObjects());
		if (sol.select_all)
			sol.else_instances.length = 0;
		var current_condition = this.runtime.getCurrentCondition();
		for (i = 0, k = 0, len = tmp_instances.length; i < len; i++)
		{
			inst = tmp_instances[i];
			tmp_instances[k] = inst;
			exp_ = current_condition.parameters[1].get(i);
			val_ = current_condition.parameters[3].get(i);
			if (cr.do_cmp(exp_, cmp_, val_))
			{
				k++;
			}
			else
			{
				sol.else_instances.push(inst);
			}
		}
		tmp_instances.length = k;
		sol.select_all = false;
		cr.shallowAssignArray(sol.instances, tmp_instances);
		tmp_instances.length = 0;
		foreach_instanceptr--;
		obj_.applySolToContainer();
		return !!sol.instances.length;
	};
	SysCnds.prototype.PickByEvaluate = function (obj_, exp_)
	{
		var i, len, k, inst;
		if (!obj_)
			return;
		foreach_instanceptr++;
		if (foreach_instancestack.length === foreach_instanceptr)
			foreach_instancestack.push([]);
		var tmp_instances = foreach_instancestack[foreach_instanceptr];
		var sol = obj_.getCurrentSol();
		cr.shallowAssignArray(tmp_instances, sol.getObjects());
		if (sol.select_all)
			sol.else_instances.length = 0;
		var current_condition = this.runtime.getCurrentCondition();
		for (i = 0, k = 0, len = tmp_instances.length; i < len; i++)
		{
			inst = tmp_instances[i];
			tmp_instances[k] = inst;
			exp_ = current_condition.parameters[1].get(i);
			if (exp_)
			{
				k++;
			}
			else
			{
				sol.else_instances.push(inst);
			}
		}
		tmp_instances.length = k;
		sol.select_all = false;
		cr.shallowAssignArray(sol.instances, tmp_instances);
		tmp_instances.length = 0;
		foreach_instanceptr--;
		obj_.applySolToContainer();
		return !!sol.instances.length;
	};
    SysCnds.prototype.TriggerOnce = function ()
    {
        var cndextra = this.runtime.getCurrentCondition().extra;
		if (typeof cndextra.TriggerOnce_lastTick === "undefined")
			cndextra.TriggerOnce_lastTick = -1;
        var last_tick = cndextra.TriggerOnce_lastTick;
        var cur_tick = this.runtime.tickcount;
        cndextra.TriggerOnce_lastTick = cur_tick;
        return this.runtime.layout_first_tick || last_tick !== cur_tick - 1;
    };
    SysCnds.prototype.Every = function (seconds)
    {
        var cnd = this.runtime.getCurrentCondition();
        var last_time = cnd.extra.Every_lastTime || 0;
        var cur_time = this.runtime.kahanTime.sum;
		if (typeof cnd.extra.Every_seconds === "undefined")
			cnd.extra.Every_seconds = seconds;
		var this_seconds = cnd.extra.Every_seconds;
        if (cur_time >= last_time + this_seconds)
        {
            cnd.extra.Every_lastTime = last_time + this_seconds;
			if (cur_time >= cnd.extra.Every_lastTime + 0.04)
			{
				cnd.extra.Every_lastTime = cur_time;
			}
			cnd.extra.Every_seconds = seconds;
            return true;
        }
		else if (cur_time < last_time - 0.1)
		{
			cnd.extra.Every_lastTime = cur_time;
		}
		return false;
    };
    SysCnds.prototype.PickNth = function (obj, index)
    {
        if (!obj)
            return false;
        var sol = obj.getCurrentSol();
        var instances = sol.getObjects();
		index = cr.floor(index);
        if (index < 0 || index >= instances.length)
            return false;
		var inst = instances[index];
        sol.pick_one(inst);
		obj.applySolToContainer();
        return true;
    };
	SysCnds.prototype.PickRandom = function (obj)
    {
        if (!obj)
            return false;
        var sol = obj.getCurrentSol();
        var instances = sol.getObjects();
		var index = cr.floor(Math.random() * instances.length);
        if (index >= instances.length)
            return false;
		var inst = instances[index];
        sol.pick_one(inst);
		obj.applySolToContainer();
        return true;
    };
	SysCnds.prototype.CompareVar = function (v, cmp, val)
    {
        return cr.do_cmp(v.getValue(), cmp, val);
    };
    SysCnds.prototype.IsGroupActive = function (group)
    {
		var g = this.runtime.groups_by_name[group.toLowerCase()];
        return g && g.group_active;
    };
	SysCnds.prototype.IsPreview = function ()
	{
		return typeof cr_is_preview !== "undefined";
	};
	SysCnds.prototype.PickAll = function (obj)
    {
        if (!obj)
            return false;
		if (!obj.instances.length)
			return false;
        var sol = obj.getCurrentSol();
        sol.select_all = true;
		obj.applySolToContainer();
        return true;
    };
	SysCnds.prototype.IsMobile = function ()
	{
		return this.runtime.isMobile;
	};
	SysCnds.prototype.CompareBetween = function (x, a, b)
	{
		return x >= a && x <= b;
	};
	SysCnds.prototype.Else = function ()
	{
		var current_frame = this.runtime.getCurrentEventStack();
		if (current_frame.else_branch_ran)
			return false;		// another event in this else-if chain has run
		else
			return !current_frame.last_event_true;
		/*
		var current_frame = this.runtime.getCurrentEventStack();
        var current_event = current_frame.current_event;
		var prev_event = current_event.prev_block;
		if (!prev_event)
			return false;
		if (prev_event.is_logical)
			return !this.runtime.last_event_true;
		var i, len, j, lenj, s, sol, temp, inst, any_picked = false;
		for (i = 0, len = prev_event.cndReferences.length; i < len; i++)
		{
			s = prev_event.cndReferences[i];
			sol = s.getCurrentSol();
			if (sol.select_all || sol.instances.length === s.instances.length)
			{
				sol.select_all = false;
				sol.instances.length = 0;
			}
			else
			{
				if (sol.instances.length === 1 && sol.else_instances.length === 0 && s.instances.length >= 2)
				{
					inst = sol.instances[0];
					sol.instances.length = 0;
					for (j = 0, lenj = s.instances.length; j < lenj; j++)
					{
						if (s.instances[j] != inst)
							sol.instances.push(s.instances[j]);
					}
					any_picked = true;
				}
				else
				{
					temp = sol.instances;
					sol.instances = sol.else_instances;
					sol.else_instances = temp;
					any_picked = true;
				}
			}
		}
		return any_picked;
		*/
	};
	SysCnds.prototype.OnLoadFinished = function ()
	{
		return true;
	};
	SysCnds.prototype.OnCanvasSnapshot = function ()
	{
		return true;
	};
	SysCnds.prototype.EffectsSupported = function ()
	{
		return !!this.runtime.glwrap;
	};
	SysCnds.prototype.OnSaveComplete = function ()
	{
		return true;
	};
	SysCnds.prototype.OnLoadComplete = function ()
	{
		return true;
	};
	SysCnds.prototype.OnLoadFailed = function ()
	{
		return true;
	};
	SysCnds.prototype.ObjectUIDExists = function (u)
	{
		return !!this.runtime.getObjectByUID(u);
	};
	SysCnds.prototype.IsOnPlatform = function (p)
	{
		var rt = this.runtime;
		switch (p) {
		case 0:		// HTML5 website
			return !rt.isDomFree && !rt.isNodeWebkit && !rt.isPhoneGap && !rt.isCrosswalk && !rt.isWinJS && !rt.isWindowsPhone8 && !rt.isBlackberry10 && !rt.isAmazonWebApp;
		case 1:		// iOS
			return rt.isiOS;
		case 2:		// Android
			return rt.isAndroid;
		case 3:		// Windows 8
			return rt.isWindows8App;
		case 4:		// Windows Phone 8
			return rt.isWindowsPhone8;
		case 5:		// Blackberry 10
			return rt.isBlackberry10;
		case 6:		// Tizen
			return rt.isTizen;
		case 7:		// CocoonJS
			return rt.isCocoonJs;
		case 8:		// PhoneGap
			return rt.isPhoneGap;
		case 9:	// Scirra Arcade
			return rt.isArcade;
		case 10:	// node-webkit
			return rt.isNodeWebkit;
		case 11:	// crosswalk
			return rt.isCrosswalk;
		case 12:	// amazon webapp
			return rt.isAmazonWebApp;
		default:	// should not be possible
			return false;
		}
	};
	var cacheRegex = null;
	var lastRegex = "";
	var lastFlags = "";
	function getRegex(regex_, flags_)
	{
		if (!cacheRegex || regex_ !== lastRegex || flags_ !== lastFlags)
		{
			cacheRegex = new RegExp(regex_, flags_);
			lastRegex = regex_;
			lastFlags = flags_;
		}
		cacheRegex.lastIndex = 0;		// reset
		return cacheRegex;
	};
	SysCnds.prototype.RegexTest = function (str_, regex_, flags_)
	{
		var regex = getRegex(regex_, flags_);
		return regex.test(str_);
	};
	var tmp_arr = [];
	SysCnds.prototype.PickOverlappingPoint = function (obj_, x_, y_)
	{
		if (!obj_)
            return false;
        var sol = obj_.getCurrentSol();
        var instances = sol.getObjects();
		var current_event = this.runtime.getCurrentEventStack().current_event;
		var orblock = current_event.orblock;
		var cnd = this.runtime.getCurrentCondition();
		var i, len, inst, pick;
		if (sol.select_all)
		{
			cr.shallowAssignArray(tmp_arr, instances);
			sol.else_instances.length = 0;
			sol.select_all = false;
			sol.instances.length = 0;
		}
		else
		{
			if (orblock)
			{
				cr.shallowAssignArray(tmp_arr, sol.else_instances);
				sol.else_instances.length = 0;
			}
			else
			{
				cr.shallowAssignArray(tmp_arr, instances);
				sol.instances.length = 0;
			}
		}
		for (i = 0, len = tmp_arr.length; i < len; ++i)
		{
			inst = tmp_arr[i];
			inst.update_bbox();
			pick = cr.xor(inst.contains_pt(x_, y_), cnd.inverted);
			if (pick)
				sol.instances.push(inst);
			else
				sol.else_instances.push(inst);
		}
		obj_.applySolToContainer();
		return cr.xor(!!sol.instances.length, cnd.inverted);
	};
	sysProto.cnds = new SysCnds();
    function SysActs() {};
    SysActs.prototype.GoToLayout = function(to)
    {
		if (this.runtime.isloading)
			return;		// cannot change layout while loading on loader layout
		if (this.runtime.changelayout)
			return;		// already changing to a different layout
;
        this.runtime.changelayout = to;
    };
    SysActs.prototype.CreateObject = function (obj, layer, x, y)
    {
        if (!layer || !obj)
            return;
        var inst = this.runtime.createInstance(obj, layer, x, y);
		if (!inst)
			return;
		this.runtime.isInOnDestroy++;
		var i, len, s;
		this.runtime.trigger(Object.getPrototypeOf(obj.plugin).cnds.OnCreated, inst);
		if (inst.is_contained)
		{
			for (i = 0, len = inst.siblings.length; i < len; i++)
			{
				s = inst.siblings[i];
				this.runtime.trigger(Object.getPrototypeOf(s.type.plugin).cnds.OnCreated, s);
			}
		}
		this.runtime.isInOnDestroy--;
        var sol = obj.getCurrentSol();
        sol.select_all = false;
		sol.instances.length = 1;
		sol.instances[0] = inst;
		if (inst.is_contained)
		{
			for (i = 0, len = inst.siblings.length; i < len; i++)
			{
				s = inst.siblings[i];
				sol = s.type.getCurrentSol();
				sol.select_all = false;
				sol.instances.length = 1;
				sol.instances[0] = s;
			}
		}
    };
    SysActs.prototype.SetLayerVisible = function (layer, visible_)
    {
        if (!layer)
            return;
		if (layer.visible !== visible_)
		{
			layer.visible = visible_;
			this.runtime.redraw = true;
		}
    };
	SysActs.prototype.SetLayerOpacity = function (layer, opacity_)
	{
		if (!layer)
			return;
		opacity_ = cr.clamp(opacity_ / 100, 0, 1);
		if (layer.opacity !== opacity_)
		{
			layer.opacity = opacity_;
			this.runtime.redraw = true;
		}
	};
	SysActs.prototype.SetLayerScaleRate = function (layer, sr)
	{
		if (!layer)
			return;
		if (layer.zoomRate !== sr)
		{
			layer.zoomRate = sr;
			this.runtime.redraw = true;
		}
	};
	SysActs.prototype.SetLayoutScale = function (s)
	{
		if (!this.runtime.running_layout)
			return;
		if (this.runtime.running_layout.scale !== s)
		{
			this.runtime.running_layout.scale = s;
			this.runtime.running_layout.boundScrolling();
			this.runtime.redraw = true;
		}
	};
    SysActs.prototype.ScrollX = function(x)
    {
        this.runtime.running_layout.scrollToX(x);
    };
    SysActs.prototype.ScrollY = function(y)
    {
        this.runtime.running_layout.scrollToY(y);
    };
    SysActs.prototype.Scroll = function(x, y)
    {
        this.runtime.running_layout.scrollToX(x);
        this.runtime.running_layout.scrollToY(y);
    };
    SysActs.prototype.ScrollToObject = function(obj)
    {
        var inst = obj.getFirstPicked();
        if (inst)
        {
            this.runtime.running_layout.scrollToX(inst.x);
            this.runtime.running_layout.scrollToY(inst.y);
        }
    };
	SysActs.prototype.SetVar = function(v, x)
	{
;
		if (v.vartype === 0)
		{
			if (cr.is_number(x))
				v.setValue(x);
			else
				v.setValue(parseFloat(x));
		}
		else if (v.vartype === 1)
			v.setValue(x.toString());
	};
	SysActs.prototype.AddVar = function(v, x)
	{
;
		if (v.vartype === 0)
		{
			if (cr.is_number(x))
				v.setValue(v.getValue() + x);
			else
				v.setValue(v.getValue() + parseFloat(x));
		}
		else if (v.vartype === 1)
			v.setValue(v.getValue() + x.toString());
	};
	SysActs.prototype.SubVar = function(v, x)
	{
;
		if (v.vartype === 0)
		{
			if (cr.is_number(x))
				v.setValue(v.getValue() - x);
			else
				v.setValue(v.getValue() - parseFloat(x));
		}
	};
    SysActs.prototype.SetGroupActive = function (group, active)
    {
		var g = this.runtime.groups_by_name[group.toLowerCase()];
		if (!g)
			return;
		switch (active) {
		case 0:
			g.setGroupActive(false);
			break;
		case 1:
			g.setGroupActive(true);
			break;
		case 2:
			g.setGroupActive(!g.group_active);
			break;
		}
    };
    SysActs.prototype.SetTimescale = function (ts_)
    {
        var ts = ts_;
        if (ts < 0)
            ts = 0;
        this.runtime.timescale = ts;
    };
    SysActs.prototype.SetObjectTimescale = function (obj, ts_)
    {
        var ts = ts_;
        if (ts < 0)
            ts = 0;
        if (!obj)
            return;
        var sol = obj.getCurrentSol();
        var instances = sol.getObjects();
        var i, len;
        for (i = 0, len = instances.length; i < len; i++)
        {
            instances[i].my_timescale = ts;
        }
    };
    SysActs.prototype.RestoreObjectTimescale = function (obj)
    {
        if (!obj)
            return false;
        var sol = obj.getCurrentSol();
        var instances = sol.getObjects();
        var i, len;
        for (i = 0, len = instances.length; i < len; i++)
        {
            instances[i].my_timescale = -1.0;
        }
    };
	var waitobjrecycle = [];
	function allocWaitObject()
	{
		var w;
		if (waitobjrecycle.length)
			w = waitobjrecycle.pop();
		else
		{
			w = {};
			w.sols = {};
			w.solModifiers = [];
		}
		w.deleteme = false;
		return w;
	};
	function freeWaitObject(w)
	{
		cr.wipe(w.sols);
		w.solModifiers.length = 0;
		waitobjrecycle.push(w);
	};
	var solstateobjects = [];
	function allocSolStateObject()
	{
		var s;
		if (solstateobjects.length)
			s = solstateobjects.pop();
		else
		{
			s = {};
			s.insts = [];
		}
		s.sa = false;
		return s;
	};
	function freeSolStateObject(s)
	{
		s.insts.length = 0;
		solstateobjects.push(s);
	};
	SysActs.prototype.Wait = function (seconds)
	{
		if (seconds < 0)
			return;
		var i, len, s, t, ss;
		var evinfo = this.runtime.getCurrentEventStack();
		var waitobj = allocWaitObject();
		waitobj.time = this.runtime.kahanTime.sum + seconds;
		waitobj.ev = evinfo.current_event;
		waitobj.actindex = evinfo.actindex + 1;	// pointing at next action
		for (i = 0, len = this.runtime.types_by_index.length; i < len; i++)
		{
			t = this.runtime.types_by_index[i];
			s = t.getCurrentSol();
			if (s.select_all && evinfo.current_event.solModifiers.indexOf(t) === -1)
				continue;
			waitobj.solModifiers.push(t);
			ss = allocSolStateObject();
			ss.sa = s.select_all;
			cr.shallowAssignArray(ss.insts, s.instances);
			waitobj.sols[i.toString()] = ss;
		}
		this.waits.push(waitobj);
		return true;
	};
	SysActs.prototype.SetLayerScale = function (layer, scale)
    {
        if (!layer)
            return;
		if (layer.scale === scale)
			return;
        layer.scale = scale;
        this.runtime.redraw = true;
    };
	SysActs.prototype.ResetGlobals = function ()
	{
		var i, len, g;
		for (i = 0, len = this.runtime.all_global_vars.length; i < len; i++)
		{
			g = this.runtime.all_global_vars[i];
			g.data = g.initial;
		}
	};
	SysActs.prototype.SetLayoutAngle = function (a)
	{
		a = cr.to_radians(a);
		a = cr.clamp_angle(a);
		if (this.runtime.running_layout)
		{
			if (this.runtime.running_layout.angle !== a)
			{
				this.runtime.running_layout.angle = a;
				this.runtime.redraw = true;
			}
		}
	};
	SysActs.prototype.SetLayerAngle = function (layer, a)
    {
        if (!layer)
            return;
		a = cr.to_radians(a);
		a = cr.clamp_angle(a);
		if (layer.angle === a)
			return;
        layer.angle = a;
        this.runtime.redraw = true;
    };
	SysActs.prototype.SetLayerParallax = function (layer, px, py)
    {
        if (!layer)
            return;
		if (layer.parallaxX === px / 100 && layer.parallaxY === py / 100)
			return;
        layer.parallaxX = px / 100;
		layer.parallaxY = py / 100;
		if (layer.parallaxX !== 1 || layer.parallaxY !== 1)
		{
			var i, len, instances = layer.instances;
			for (i = 0, len = instances.length; i < len; ++i)
			{
				instances[i].type.any_instance_parallaxed = true;
			}
		}
        this.runtime.redraw = true;
    };
	SysActs.prototype.SetLayerBackground = function (layer, c)
    {
        if (!layer)
            return;
		var r = cr.GetRValue(c);
		var g = cr.GetGValue(c);
		var b = cr.GetBValue(c);
		if (layer.background_color[0] === r && layer.background_color[1] === g && layer.background_color[2] === b)
			return;
        layer.background_color[0] = r;
		layer.background_color[1] = g;
		layer.background_color[2] = b;
        this.runtime.redraw = true;
    };
	SysActs.prototype.SetLayerTransparent = function (layer, t)
    {
        if (!layer)
            return;
		if (!!t === !!layer.transparent)
			return;
		layer.transparent = !!t;
        this.runtime.redraw = true;
    };
	SysActs.prototype.StopLoop = function ()
	{
		if (this.runtime.loop_stack_index < 0)
			return;		// no loop currently running
		this.runtime.getCurrentLoop().stopped = true;
	};
	SysActs.prototype.GoToLayoutByName = function (layoutname)
	{
		if (this.runtime.isloading)
			return;		// cannot change layout while loading on loader layout
		if (this.runtime.changelayout)
			return;		// already changing to different layout
;
		var l;
		for (l in this.runtime.layouts)
		{
			if (this.runtime.layouts.hasOwnProperty(l) && cr.equals_nocase(l, layoutname))
			{
				this.runtime.changelayout = this.runtime.layouts[l];
				return;
			}
		}
	};
	SysActs.prototype.RestartLayout = function (layoutname)
	{
		if (this.runtime.isloading)
			return;		// cannot restart loader layouts
		if (this.runtime.changelayout)
			return;		// already changing to a different layout
;
		if (!this.runtime.running_layout)
			return;
		this.runtime.changelayout = this.runtime.running_layout;
		var i, len, g;
		for (i = 0, len = this.runtime.allGroups.length; i < len; i++)
		{
			g = this.runtime.allGroups[i];
			g.setGroupActive(g.initially_activated);
		}
	};
	SysActs.prototype.SnapshotCanvas = function (format_, quality_)
	{
		this.runtime.snapshotCanvas = [format_ === 0 ? "image/png" : "image/jpeg", quality_ / 100];
		this.runtime.redraw = true;		// force redraw so snapshot is always taken
	};
	SysActs.prototype.SetCanvasSize = function (w, h)
	{
		if (w <= 0 || h <= 0)
			return;
		var mode = this.runtime.fullscreen_mode;
		var isfullscreen = (document["mozFullScreen"] || document["webkitIsFullScreen"] || !!document["msFullscreenElement"] || document["fullScreen"] || this.runtime.isNodeFullscreen);
		if (isfullscreen && this.runtime.fullscreen_scaling > 0)
			mode = this.runtime.fullscreen_scaling;
		if (mode === 0)
		{
			this.runtime["setSize"](w, h, true);
		}
		else
		{
			this.runtime.original_width = w;
			this.runtime.original_height = h;
			this.runtime["setSize"](this.runtime.lastWindowWidth, this.runtime.lastWindowHeight, true);
		}
	};
	SysActs.prototype.SetLayoutEffectEnabled = function (enable_, effectname_)
	{
		if (!this.runtime.running_layout || !this.runtime.glwrap)
			return;
		var et = this.runtime.running_layout.getEffectByName(effectname_);
		if (!et)
			return;		// effect name not found
		var enable = (enable_ === 1);
		if (et.active == enable)
			return;		// no change
		et.active = enable;
		this.runtime.running_layout.updateActiveEffects();
		this.runtime.redraw = true;
	};
	SysActs.prototype.SetLayerEffectEnabled = function (layer, enable_, effectname_)
	{
		if (!layer || !this.runtime.glwrap)
			return;
		var et = layer.getEffectByName(effectname_);
		if (!et)
			return;		// effect name not found
		var enable = (enable_ === 1);
		if (et.active == enable)
			return;		// no change
		et.active = enable;
		layer.updateActiveEffects();
		this.runtime.redraw = true;
	};
	SysActs.prototype.SetLayoutEffectParam = function (effectname_, index_, value_)
	{
		if (!this.runtime.running_layout || !this.runtime.glwrap)
			return;
		var et = this.runtime.running_layout.getEffectByName(effectname_);
		if (!et)
			return;		// effect name not found
		var params = this.runtime.running_layout.effect_params[et.index];
		index_ = Math.floor(index_);
		if (index_ < 0 || index_ >= params.length)
			return;		// effect index out of bounds
		if (this.runtime.glwrap.getProgramParameterType(et.shaderindex, index_) === 1)
			value_ /= 100.0;
		if (params[index_] === value_)
			return;		// no change
		params[index_] = value_;
		if (et.active)
			this.runtime.redraw = true;
	};
	SysActs.prototype.SetLayerEffectParam = function (layer, effectname_, index_, value_)
	{
		if (!layer || !this.runtime.glwrap)
			return;
		var et = layer.getEffectByName(effectname_);
		if (!et)
			return;		// effect name not found
		var params = layer.effect_params[et.index];
		index_ = Math.floor(index_);
		if (index_ < 0 || index_ >= params.length)
			return;		// effect index out of bounds
		if (this.runtime.glwrap.getProgramParameterType(et.shaderindex, index_) === 1)
			value_ /= 100.0;
		if (params[index_] === value_)
			return;		// no change
		params[index_] = value_;
		if (et.active)
			this.runtime.redraw = true;
	};
	SysActs.prototype.SaveState = function (slot_)
	{
		this.runtime.saveToSlot = slot_;
	};
	SysActs.prototype.LoadState = function (slot_)
	{
		this.runtime.loadFromSlot = slot_;
	};
	SysActs.prototype.LoadStateJSON = function (jsonstr_)
	{
		this.runtime.loadFromJson = jsonstr_;
	};
	SysActs.prototype.SetHalfFramerateMode = function (set_)
	{
		this.runtime.halfFramerateMode = (set_ !== 0);
	};
	SysActs.prototype.SetFullscreenQuality = function (q)
	{
		var isfullscreen = (document["mozFullScreen"] || document["webkitIsFullScreen"] || !!document["msFullscreenElement"] || document["fullScreen"] || this.isNodeFullscreen);
		if (!isfullscreen && this.runtime.fullscreen_mode === 0)
			return;
		this.runtime.wantFullscreenScalingQuality = (q !== 0);
		this.runtime["setSize"](this.runtime.lastWindowWidth, this.runtime.lastWindowHeight, true);
	};
	sysProto.acts = new SysActs();
    function SysExps() {};
    SysExps.prototype["int"] = function(ret, x)
    {
        if (cr.is_string(x))
        {
            ret.set_int(parseInt(x, 10));
            if (isNaN(ret.data))
                ret.data = 0;
        }
        else
            ret.set_int(x);
    };
    SysExps.prototype["float"] = function(ret, x)
    {
        if (cr.is_string(x))
        {
            ret.set_float(parseFloat(x));
            if (isNaN(ret.data))
                ret.data = 0;
        }
        else
            ret.set_float(x);
    };
    SysExps.prototype.str = function(ret, x)
    {
        if (cr.is_string(x))
            ret.set_string(x);
        else
            ret.set_string(x.toString());
    };
    SysExps.prototype.len = function(ret, x)
    {
        ret.set_int(x.length || 0);
    };
    SysExps.prototype.random = function (ret, a, b)
    {
        if (b === undefined)
        {
            ret.set_float(Math.random() * a);
        }
        else
        {
            ret.set_float(Math.random() * (b - a) + a);
        }
    };
    SysExps.prototype.sqrt = function(ret, x)
    {
        ret.set_float(Math.sqrt(x));
    };
    SysExps.prototype.abs = function(ret, x)
    {
        ret.set_float(Math.abs(x));
    };
    SysExps.prototype.round = function(ret, x)
    {
        ret.set_int(Math.round(x));
    };
    SysExps.prototype.floor = function(ret, x)
    {
        ret.set_int(Math.floor(x));
    };
    SysExps.prototype.ceil = function(ret, x)
    {
        ret.set_int(Math.ceil(x));
    };
    SysExps.prototype.sin = function(ret, x)
    {
        ret.set_float(Math.sin(cr.to_radians(x)));
    };
    SysExps.prototype.cos = function(ret, x)
    {
        ret.set_float(Math.cos(cr.to_radians(x)));
    };
    SysExps.prototype.tan = function(ret, x)
    {
        ret.set_float(Math.tan(cr.to_radians(x)));
    };
    SysExps.prototype.asin = function(ret, x)
    {
        ret.set_float(cr.to_degrees(Math.asin(x)));
    };
    SysExps.prototype.acos = function(ret, x)
    {
        ret.set_float(cr.to_degrees(Math.acos(x)));
    };
    SysExps.prototype.atan = function(ret, x)
    {
        ret.set_float(cr.to_degrees(Math.atan(x)));
    };
    SysExps.prototype.exp = function(ret, x)
    {
        ret.set_float(Math.exp(x));
    };
    SysExps.prototype.ln = function(ret, x)
    {
        ret.set_float(Math.log(x));
    };
    SysExps.prototype.log10 = function(ret, x)
    {
        ret.set_float(Math.log(x) / Math.LN10);
    };
    SysExps.prototype.max = function(ret)
    {
		var max_ = arguments[1];
		var i, len;
		for (i = 2, len = arguments.length; i < len; i++)
		{
			if (max_ < arguments[i])
				max_ = arguments[i];
		}
		ret.set_float(max_);
    };
    SysExps.prototype.min = function(ret)
    {
        var min_ = arguments[1];
		var i, len;
		for (i = 2, len = arguments.length; i < len; i++)
		{
			if (min_ > arguments[i])
				min_ = arguments[i];
		}
		ret.set_float(min_);
    };
    SysExps.prototype.dt = function(ret)
    {
        ret.set_float(this.runtime.dt);
    };
    SysExps.prototype.timescale = function(ret)
    {
        ret.set_float(this.runtime.timescale);
    };
    SysExps.prototype.wallclocktime = function(ret)
    {
        ret.set_float((Date.now() - this.runtime.start_time) / 1000.0);
    };
    SysExps.prototype.time = function(ret)
    {
        ret.set_float(this.runtime.kahanTime.sum);
    };
    SysExps.prototype.tickcount = function(ret)
    {
        ret.set_int(this.runtime.tickcount);
    };
    SysExps.prototype.objectcount = function(ret)
    {
        ret.set_int(this.runtime.objectcount);
    };
    SysExps.prototype.fps = function(ret)
    {
        ret.set_int(this.runtime.fps);
    };
    SysExps.prototype.loopindex = function(ret, name_)
    {
		var loop, i, len;
        if (!this.runtime.loop_stack.length)
        {
            ret.set_int(0);
            return;
        }
        if (name_)
        {
            for (i = 0, len = this.runtime.loop_stack.length; i < len; i++)
            {
                loop = this.runtime.loop_stack[i];
                if (loop.name === name_)
                {
                    ret.set_int(loop.index);
                    return;
                }
            }
            ret.set_int(0);
        }
        else
        {
			loop = this.runtime.getCurrentLoop();
			ret.set_int(loop ? loop.index : -1);
        }
    };
    SysExps.prototype.distance = function(ret, x1, y1, x2, y2)
    {
        ret.set_float(cr.distanceTo(x1, y1, x2, y2));
    };
    SysExps.prototype.angle = function(ret, x1, y1, x2, y2)
    {
        ret.set_float(cr.to_degrees(cr.angleTo(x1, y1, x2, y2)));
    };
    SysExps.prototype.scrollx = function(ret)
    {
        ret.set_float(this.runtime.running_layout.scrollX);
    };
    SysExps.prototype.scrolly = function(ret)
    {
        ret.set_float(this.runtime.running_layout.scrollY);
    };
    SysExps.prototype.newline = function(ret)
    {
        ret.set_string("\n");
    };
    SysExps.prototype.lerp = function(ret, a, b, x)
    {
        ret.set_float(cr.lerp(a, b, x));
    };
    SysExps.prototype.windowwidth = function(ret)
    {
        ret.set_int(this.runtime.width);
    };
    SysExps.prototype.windowheight = function(ret)
    {
        ret.set_int(this.runtime.height);
    };
	SysExps.prototype.uppercase = function(ret, str)
	{
		ret.set_string(cr.is_string(str) ? str.toUpperCase() : "");
	};
	SysExps.prototype.lowercase = function(ret, str)
	{
		ret.set_string(cr.is_string(str) ? str.toLowerCase() : "");
	};
	SysExps.prototype.clamp = function(ret, x, l, u)
	{
		if (x < l)
			ret.set_float(l);
		else if (x > u)
			ret.set_float(u);
		else
			ret.set_float(x);
	};
	SysExps.prototype.layerscale = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		if (!layer)
			ret.set_float(0);
		else
			ret.set_float(layer.scale);
	};
	SysExps.prototype.layeropacity = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		if (!layer)
			ret.set_float(0);
		else
			ret.set_float(layer.opacity * 100);
	};
	SysExps.prototype.layerscalerate = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		if (!layer)
			ret.set_float(0);
		else
			ret.set_float(layer.zoomRate);
	};
	SysExps.prototype.layerparallaxx = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		if (!layer)
			ret.set_float(0);
		else
			ret.set_float(layer.parallaxX * 100);
	};
	SysExps.prototype.layerparallaxy = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		if (!layer)
			ret.set_float(0);
		else
			ret.set_float(layer.parallaxY * 100);
	};
	SysExps.prototype.layoutscale = function (ret)
	{
		if (this.runtime.running_layout)
			ret.set_float(this.runtime.running_layout.scale);
		else
			ret.set_float(0);
	};
	SysExps.prototype.layoutangle = function (ret)
	{
		ret.set_float(cr.to_degrees(this.runtime.running_layout.angle));
	};
	SysExps.prototype.layerangle = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		if (!layer)
			ret.set_float(0);
		else
			ret.set_float(cr.to_degrees(layer.angle));
	};
	SysExps.prototype.layoutwidth = function (ret)
	{
		ret.set_int(this.runtime.running_layout.width);
	};
	SysExps.prototype.layoutheight = function (ret)
	{
		ret.set_int(this.runtime.running_layout.height);
	};
	SysExps.prototype.find = function (ret, text, searchstr)
	{
		if (cr.is_string(text) && cr.is_string(searchstr))
			ret.set_int(text.search(new RegExp(cr.regexp_escape(searchstr), "i")));
		else
			ret.set_int(-1);
	};
	SysExps.prototype.left = function (ret, text, n)
	{
		ret.set_string(cr.is_string(text) ? text.substr(0, n) : "");
	};
	SysExps.prototype.right = function (ret, text, n)
	{
		ret.set_string(cr.is_string(text) ? text.substr(text.length - n) : "");
	};
	SysExps.prototype.mid = function (ret, text, index_, length_)
	{
		ret.set_string(cr.is_string(text) ? text.substr(index_, length_) : "");
	};
	SysExps.prototype.tokenat = function (ret, text, index_, sep)
	{
		if (cr.is_string(text) && cr.is_string(sep))
		{
			var arr = text.split(sep);
			var i = cr.floor(index_);
			if (i < 0 || i >= arr.length)
				ret.set_string("");
			else
				ret.set_string(arr[i]);
		}
		else
			ret.set_string("");
	};
	SysExps.prototype.tokencount = function (ret, text, sep)
	{
		if (cr.is_string(text) && text.length)
			ret.set_int(text.split(sep).length);
		else
			ret.set_int(0);
	};
	SysExps.prototype.replace = function (ret, text, find_, replace_)
	{
		if (cr.is_string(text) && cr.is_string(find_) && cr.is_string(replace_))
			ret.set_string(text.replace(new RegExp(cr.regexp_escape(find_), "gi"), replace_));
		else
			ret.set_string(cr.is_string(text) ? text : "");
	};
	SysExps.prototype.trim = function (ret, text)
	{
		ret.set_string(cr.is_string(text) ? text.trim() : "");
	};
	SysExps.prototype.pi = function (ret)
	{
		ret.set_float(cr.PI);
	};
	SysExps.prototype.layoutname = function (ret)
	{
		if (this.runtime.running_layout)
			ret.set_string(this.runtime.running_layout.name);
		else
			ret.set_string("");
	};
	SysExps.prototype.renderer = function (ret)
	{
		ret.set_string(this.runtime.gl ? "webgl" : "canvas2d");
	};
	SysExps.prototype.anglediff = function (ret, a, b)
	{
		ret.set_float(cr.to_degrees(cr.angleDiff(cr.to_radians(a), cr.to_radians(b))));
	};
	SysExps.prototype.choose = function (ret)
	{
		var index = cr.floor(Math.random() * (arguments.length - 1));
		ret.set_any(arguments[index + 1]);
	};
	SysExps.prototype.rgb = function (ret, r, g, b)
	{
		ret.set_int(cr.RGB(r, g, b));
	};
	SysExps.prototype.projectversion = function (ret)
	{
		ret.set_string(this.runtime.versionstr);
	};
	SysExps.prototype.anglelerp = function (ret, a, b, x)
	{
		a = cr.to_radians(a);
		b = cr.to_radians(b);
		var diff = cr.angleDiff(a, b);
		if (cr.angleClockwise(b, a))
		{
			ret.set_float(cr.to_clamped_degrees(a + diff * x));
		}
		else
		{
			ret.set_float(cr.to_clamped_degrees(a - diff * x));
		}
	};
	SysExps.prototype.anglerotate = function (ret, a, b, c)
	{
		a = cr.to_radians(a);
		b = cr.to_radians(b);
		c = cr.to_radians(c);
		ret.set_float(cr.to_clamped_degrees(cr.angleRotate(a, b, c)));
	};
	SysExps.prototype.zeropad = function (ret, n, d)
	{
		var s = (n < 0 ? "-" : "");
		if (n < 0) n = -n;
		var zeroes = d - n.toString().length;
		for (var i = 0; i < zeroes; i++)
			s += "0";
		ret.set_string(s + n.toString());
	};
	SysExps.prototype.cpuutilisation = function (ret)
	{
		ret.set_float(this.runtime.cpuutilisation / 1000);
	};
	SysExps.prototype.viewportleft = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.viewLeft : 0);
	};
	SysExps.prototype.viewporttop = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.viewTop : 0);
	};
	SysExps.prototype.viewportright = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.viewRight : 0);
	};
	SysExps.prototype.viewportbottom = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.viewBottom : 0);
	};
	SysExps.prototype.loadingprogress = function (ret)
	{
		ret.set_float(this.runtime.loadingprogress);
	};
	SysExps.prototype.unlerp = function(ret, a, b, y)
    {
        ret.set_float(cr.unlerp(a, b, y));
    };
	SysExps.prototype.canvassnapshot = function (ret)
	{
		ret.set_string(this.runtime.snapshotData);
	};
	SysExps.prototype.urlencode = function (ret, s)
	{
		ret.set_string(encodeURIComponent(s));
	};
	SysExps.prototype.urldecode = function (ret, s)
	{
		ret.set_string(decodeURIComponent(s));
	};
	SysExps.prototype.canvastolayerx = function (ret, layerparam, x, y)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.canvasToLayer(x, y, true) : 0);
	};
	SysExps.prototype.canvastolayery = function (ret, layerparam, x, y)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.canvasToLayer(x, y, false) : 0);
	};
	SysExps.prototype.layertocanvasx = function (ret, layerparam, x, y)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.layerToCanvas(x, y, true) : 0);
	};
	SysExps.prototype.layertocanvasy = function (ret, layerparam, x, y)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.layerToCanvas(x, y, false) : 0);
	};
	SysExps.prototype.savestatejson = function (ret)
	{
		ret.set_string(this.runtime.lastSaveJson);
	};
	SysExps.prototype.imagememoryusage = function (ret)
	{
		if (this.runtime.glwrap)
			ret.set_float(Math.round(100 * this.runtime.glwrap.estimateVRAM() / (1024 * 1024)) / 100);
		else
			ret.set_float(0);
	};
	SysExps.prototype.regexsearch = function (ret, str_, regex_, flags_)
	{
		var regex = getRegex(regex_, flags_);
		ret.set_int(str_ ? str_.search(regex) : -1);
	};
	SysExps.prototype.regexreplace = function (ret, str_, regex_, flags_, replace_)
	{
		var regex = getRegex(regex_, flags_);
		ret.set_string(str_ ? str_.replace(regex, replace_) : "");
	};
	var regexMatches = [];
	var lastMatchesStr = "";
	var lastMatchesRegex = "";
	var lastMatchesFlags = "";
	function updateRegexMatches(str_, regex_, flags_)
	{
		if (str_ === lastMatchesStr && regex_ === lastMatchesRegex && flags_ === lastMatchesFlags)
			return;
		var regex = getRegex(regex_, flags_);
		regexMatches = str_.match(regex);
		lastMatchesStr = str_;
		lastMatchesRegex = regex_;
		lastMatchesFlags = flags_;
	};
	SysExps.prototype.regexmatchcount = function (ret, str_, regex_, flags_)
	{
		var regex = getRegex(regex_, flags_);
		updateRegexMatches(str_, regex_, flags_);
		ret.set_int(regexMatches ? regexMatches.length : 0);
	};
	SysExps.prototype.regexmatchat = function (ret, str_, regex_, flags_, index_)
	{
		index_ = Math.floor(index_);
		var regex = getRegex(regex_, flags_);
		updateRegexMatches(str_, regex_, flags_);
		if (!regexMatches || index_ < 0 || index_ >= regexMatches.length)
			ret.set_string("");
		else
			ret.set_string(regexMatches[index_]);
	};
	SysExps.prototype.infinity = function (ret)
	{
		ret.set_float(Infinity);
	};
	SysExps.prototype.setbit = function (ret, n, b, v)
	{
		n = n | 0;
		b = b | 0;
		v = (v !== 0 ? 1 : 0);
		ret.set_int((n & ~(1 << b)) | (v << b));
	};
	SysExps.prototype.togglebit = function (ret, n, b)
	{
		n = n | 0;
		b = b | 0;
		ret.set_int(n ^ (1 << b));
	};
	SysExps.prototype.getbit = function (ret, n, b)
	{
		n = n | 0;
		b = b | 0;
		ret.set_int((n & (1 << b)) ? 1 : 0);
	};
	sysProto.exps = new SysExps();
	sysProto.runWaits = function ()
	{
		var i, j, len, w, k, s, ss;
		var evinfo = this.runtime.getCurrentEventStack();
		for (i = 0, len = this.waits.length; i < len; i++)
		{
			w = this.waits[i];
			if (w.time > this.runtime.kahanTime.sum)
				continue;
			evinfo.current_event = w.ev;
			evinfo.actindex = w.actindex;
			evinfo.cndindex = 0;
			for (k in w.sols)
			{
				if (w.sols.hasOwnProperty(k))
				{
					s = this.runtime.types_by_index[parseInt(k, 10)].getCurrentSol();
					ss = w.sols[k];
					s.select_all = ss.sa;
					cr.shallowAssignArray(s.instances, ss.insts);
					freeSolStateObject(ss);
				}
			}
			w.ev.resume_actions_and_subevents();
			this.runtime.clearSol(w.solModifiers);
			w.deleteme = true;
		}
		for (i = 0, j = 0, len = this.waits.length; i < len; i++)
		{
			w = this.waits[i];
			this.waits[j] = w;
			if (w.deleteme)
				freeWaitObject(w);
			else
				j++;
		}
		this.waits.length = j;
	};
}());
;
(function () {
	cr.add_common_aces = function (m)
	{
		var pluginProto = m[0].prototype;
		var singleglobal_ = m[1];
		var position_aces = m[3];
		var size_aces = m[4];
		var angle_aces = m[5];
		var appearance_aces = m[6];
		var zorder_aces = m[7];
		var effects_aces = m[8];
		if (!pluginProto.cnds)
			pluginProto.cnds = {};
		if (!pluginProto.acts)
			pluginProto.acts = {};
		if (!pluginProto.exps)
			pluginProto.exps = {};
		var cnds = pluginProto.cnds;
		var acts = pluginProto.acts;
		var exps = pluginProto.exps;
		if (position_aces)
		{
			cnds.CompareX = function (cmp, x)
			{
				return cr.do_cmp(this.x, cmp, x);
			};
			cnds.CompareY = function (cmp, y)
			{
				return cr.do_cmp(this.y, cmp, y);
			};
			cnds.IsOnScreen = function ()
			{
				var layer = this.layer;
				this.update_bbox();
				var bbox = this.bbox;
				return !(bbox.right < layer.viewLeft || bbox.bottom < layer.viewTop || bbox.left > layer.viewRight || bbox.top > layer.viewBottom);
			};
			cnds.IsOutsideLayout = function ()
			{
				this.update_bbox();
				var bbox = this.bbox;
				var layout = this.runtime.running_layout;
				return (bbox.right < 0 || bbox.bottom < 0 || bbox.left > layout.width || bbox.top > layout.height);
			};
			cnds.PickDistance = function (which, x, y)
			{
				var sol = this.getCurrentSol();
				var instances = sol.getObjects();
				if (!instances.length)
					return false;
				var inst = instances[0];
				var pickme = inst;
				var dist = cr.distanceTo(inst.x, inst.y, x, y);
				var i, len, d;
				for (i = 1, len = instances.length; i < len; i++)
				{
					inst = instances[i];
					d = cr.distanceTo(inst.x, inst.y, x, y);
					if ((which === 0 && d < dist) || (which === 1 && d > dist))
					{
						dist = d;
						pickme = inst;
					}
				}
				sol.pick_one(pickme);
				return true;
			};
			acts.SetX = function (x)
			{
				if (this.x !== x)
				{
					this.x = x;
					this.set_bbox_changed();
				}
			};
			acts.SetY = function (y)
			{
				if (this.y !== y)
				{
					this.y = y;
					this.set_bbox_changed();
				}
			};
			acts.SetPos = function (x, y)
			{
				if (this.x !== x || this.y !== y)
				{
					this.x = x;
					this.y = y;
					this.set_bbox_changed();
				}
			};
			acts.SetPosToObject = function (obj, imgpt)
			{
				var inst = obj.getPairedInstance(this);
				if (!inst)
					return;
				var newx, newy;
				if (inst.getImagePoint)
				{
					newx = inst.getImagePoint(imgpt, true);
					newy = inst.getImagePoint(imgpt, false);
				}
				else
				{
					newx = inst.x;
					newy = inst.y;
				}
				if (this.x !== newx || this.y !== newy)
				{
					this.x = newx;
					this.y = newy;
					this.set_bbox_changed();
				}
			};
			acts.MoveForward = function (dist)
			{
				if (dist !== 0)
				{
					this.x += Math.cos(this.angle) * dist;
					this.y += Math.sin(this.angle) * dist;
					this.set_bbox_changed();
				}
			};
			acts.MoveAtAngle = function (a, dist)
			{
				if (dist !== 0)
				{
					this.x += Math.cos(cr.to_radians(a)) * dist;
					this.y += Math.sin(cr.to_radians(a)) * dist;
					this.set_bbox_changed();
				}
			};
			exps.X = function (ret)
			{
				ret.set_float(this.x);
			};
			exps.Y = function (ret)
			{
				ret.set_float(this.y);
			};
			exps.dt = function (ret)
			{
				ret.set_float(this.runtime.getDt(this));
			};
		}
		if (size_aces)
		{
			cnds.CompareWidth = function (cmp, w)
			{
				return cr.do_cmp(this.width, cmp, w);
			};
			cnds.CompareHeight = function (cmp, h)
			{
				return cr.do_cmp(this.height, cmp, h);
			};
			acts.SetWidth = function (w)
			{
				if (this.width !== w)
				{
					this.width = w;
					this.set_bbox_changed();
				}
			};
			acts.SetHeight = function (h)
			{
				if (this.height !== h)
				{
					this.height = h;
					this.set_bbox_changed();
				}
			};
			acts.SetSize = function (w, h)
			{
				if (this.width !== w || this.height !== h)
				{
					this.width = w;
					this.height = h;
					this.set_bbox_changed();
				}
			};
			exps.Width = function (ret)
			{
				ret.set_float(this.width);
			};
			exps.Height = function (ret)
			{
				ret.set_float(this.height);
			};
			exps.BBoxLeft = function (ret)
			{
				this.update_bbox();
				ret.set_float(this.bbox.left);
			};
			exps.BBoxTop = function (ret)
			{
				this.update_bbox();
				ret.set_float(this.bbox.top);
			};
			exps.BBoxRight = function (ret)
			{
				this.update_bbox();
				ret.set_float(this.bbox.right);
			};
			exps.BBoxBottom = function (ret)
			{
				this.update_bbox();
				ret.set_float(this.bbox.bottom);
			};
		}
		if (angle_aces)
		{
			cnds.AngleWithin = function (within, a)
			{
				return cr.angleDiff(this.angle, cr.to_radians(a)) <= cr.to_radians(within);
			};
			cnds.IsClockwiseFrom = function (a)
			{
				return cr.angleClockwise(this.angle, cr.to_radians(a));
			};
			cnds.IsBetweenAngles = function (a, b)
			{
				var lower = cr.to_clamped_radians(a);
				var upper = cr.to_clamped_radians(b);
				var angle = cr.clamp_angle(this.angle);
				var obtuse = (!cr.angleClockwise(upper, lower));
				if (obtuse)
					return !(!cr.angleClockwise(angle, lower) && cr.angleClockwise(angle, upper));
				else
					return cr.angleClockwise(angle, lower) && !cr.angleClockwise(angle, upper);
			};
			acts.SetAngle = function (a)
			{
				var newangle = cr.to_radians(cr.clamp_angle_degrees(a));
				if (isNaN(newangle))
					return;
				if (this.angle !== newangle)
				{
					this.angle = newangle;
					this.set_bbox_changed();
				}
			};
			acts.RotateClockwise = function (a)
			{
				if (a !== 0 && !isNaN(a))
				{
					this.angle += cr.to_radians(a);
					this.angle = cr.clamp_angle(this.angle);
					this.set_bbox_changed();
				}
			};
			acts.RotateCounterclockwise = function (a)
			{
				if (a !== 0 && !isNaN(a))
				{
					this.angle -= cr.to_radians(a);
					this.angle = cr.clamp_angle(this.angle);
					this.set_bbox_changed();
				}
			};
			acts.RotateTowardAngle = function (amt, target)
			{
				var newangle = cr.angleRotate(this.angle, cr.to_radians(target), cr.to_radians(amt));
				if (isNaN(newangle))
					return;
				if (this.angle !== newangle)
				{
					this.angle = newangle;
					this.set_bbox_changed();
				}
			};
			acts.RotateTowardPosition = function (amt, x, y)
			{
				var dx = x - this.x;
				var dy = y - this.y;
				var target = Math.atan2(dy, dx);
				var newangle = cr.angleRotate(this.angle, target, cr.to_radians(amt));
				if (isNaN(newangle))
					return;
				if (this.angle !== newangle)
				{
					this.angle = newangle;
					this.set_bbox_changed();
				}
			};
			acts.SetTowardPosition = function (x, y)
			{
				var dx = x - this.x;
				var dy = y - this.y;
				var newangle = Math.atan2(dy, dx);
				if (isNaN(newangle))
					return;
				if (this.angle !== newangle)
				{
					this.angle = newangle;
					this.set_bbox_changed();
				}
			};
			exps.Angle = function (ret)
			{
				ret.set_float(cr.to_clamped_degrees(this.angle));
			};
		}
		if (!singleglobal_)
		{
			cnds.CompareInstanceVar = function (iv, cmp, val)
			{
				return cr.do_cmp(this.instance_vars[iv], cmp, val);
			};
			cnds.IsBoolInstanceVarSet = function (iv)
			{
				return this.instance_vars[iv];
			};
			cnds.PickInstVarHiLow = function (which, iv)
			{
				var sol = this.getCurrentSol();
				var instances = sol.getObjects();
				if (!instances.length)
					return false;
				var inst = instances[0];
				var pickme = inst;
				var val = inst.instance_vars[iv];
				var i, len, v;
				for (i = 1, len = instances.length; i < len; i++)
				{
					inst = instances[i];
					v = inst.instance_vars[iv];
					if ((which === 0 && v < val) || (which === 1 && v > val))
					{
						val = v;
						pickme = inst;
					}
				}
				sol.pick_one(pickme);
				return true;
			};
			cnds.PickByUID = function (u)
			{
				var i, len, j, inst, families, instances, sol;
				var cnd = this.runtime.getCurrentCondition();
				if (cnd.inverted)
				{
					sol = this.getCurrentSol();
					if (sol.select_all)
					{
						sol.select_all = false;
						sol.instances.length = 0;
						sol.else_instances.length = 0;
						instances = this.instances;
						for (i = 0, len = instances.length; i < len; i++)
						{
							inst = instances[i];
							if (inst.uid === u)
								sol.else_instances.push(inst);
							else
								sol.instances.push(inst);
						}
						this.applySolToContainer();
						return !!sol.instances.length;
					}
					else
					{
						for (i = 0, j = 0, len = sol.instances.length; i < len; i++)
						{
							inst = sol.instances[i];
							sol.instances[j] = inst;
							if (inst.uid === u)
							{
								sol.else_instances.push(inst);
							}
							else
								j++;
						}
						sol.instances.length = j;
						this.applySolToContainer();
						return !!sol.instances.length;
					}
				}
				else
				{
					inst = this.runtime.getObjectByUID(u);
					if (!inst)
						return false;
					sol = this.getCurrentSol();
					if (!sol.select_all && sol.instances.indexOf(inst) === -1)
						return false;		// not picked
					if (this.is_family)
					{
						families = inst.type.families;
						for (i = 0, len = families.length; i < len; i++)
						{
							if (families[i] === this)
							{
								sol.pick_one(inst);
								this.applySolToContainer();
								return true;
							}
						}
					}
					else if (inst.type === this)
					{
						sol.pick_one(inst);
						this.applySolToContainer();
						return true;
					}
					return false;
				}
			};
			cnds.OnCreated = function ()
			{
				return true;
			};
			cnds.OnDestroyed = function ()
			{
				return true;
			};
			acts.SetInstanceVar = function (iv, val)
			{
				var myinstvars = this.instance_vars;
				if (cr.is_number(myinstvars[iv]))
				{
					if (cr.is_number(val))
						myinstvars[iv] = val;
					else
						myinstvars[iv] = parseFloat(val);
				}
				else if (cr.is_string(myinstvars[iv]))
				{
					if (cr.is_string(val))
						myinstvars[iv] = val;
					else
						myinstvars[iv] = val.toString();
				}
				else
;
			};
			acts.AddInstanceVar = function (iv, val)
			{
				var myinstvars = this.instance_vars;
				if (cr.is_number(myinstvars[iv]))
				{
					if (cr.is_number(val))
						myinstvars[iv] += val;
					else
						myinstvars[iv] += parseFloat(val);
				}
				else if (cr.is_string(myinstvars[iv]))
				{
					if (cr.is_string(val))
						myinstvars[iv] += val;
					else
						myinstvars[iv] += val.toString();
				}
				else
;
			};
			acts.SubInstanceVar = function (iv, val)
			{
				var myinstvars = this.instance_vars;
				if (cr.is_number(myinstvars[iv]))
				{
					if (cr.is_number(val))
						myinstvars[iv] -= val;
					else
						myinstvars[iv] -= parseFloat(val);
				}
				else
;
			};
			acts.SetBoolInstanceVar = function (iv, val)
			{
				this.instance_vars[iv] = val ? 1 : 0;
			};
			acts.ToggleBoolInstanceVar = function (iv)
			{
				this.instance_vars[iv] = 1 - this.instance_vars[iv];
			};
			acts.Destroy = function ()
			{
				this.runtime.DestroyInstance(this);
			};
			if (!acts.LoadFromJsonString)
			{
				acts.LoadFromJsonString = function (str_)
				{
					var o, i, len, binst;
					try {
						o = JSON.parse(str_);
					}
					catch (e) {
						return;
					}
					this.runtime.loadInstanceFromJSON(this, o, true);
					if (this.afterLoad)
						this.afterLoad();
					if (this.behavior_insts)
					{
						for (i = 0, len = this.behavior_insts.length; i < len; ++i)
						{
							binst = this.behavior_insts[i];
							if (binst.afterLoad)
								binst.afterLoad();
						}
					}
				};
			}
			exps.Count = function (ret)
			{
				var count = ret.object_class.instances.length;
				var i, len, inst;
				for (i = 0, len = this.runtime.createRow.length; i < len; i++)
				{
					inst = this.runtime.createRow[i];
					if (ret.object_class.is_family)
					{
						if (inst.type.families.indexOf(ret.object_class) >= 0)
							count++;
					}
					else
					{
						if (inst.type === ret.object_class)
							count++;
					}
				}
				ret.set_int(count);
			};
			exps.PickedCount = function (ret)
			{
				ret.set_int(ret.object_class.getCurrentSol().getObjects().length);
			};
			exps.UID = function (ret)
			{
				ret.set_int(this.uid);
			};
			exps.IID = function (ret)
			{
				ret.set_int(this.get_iid());
			};
			if (!exps.AsJSON)
			{
				exps.AsJSON = function (ret)
				{
					ret.set_string(JSON.stringify(this.runtime.saveInstanceToJSON(this, true)));
				};
			}
		}
		if (appearance_aces)
		{
			cnds.IsVisible = function ()
			{
				return this.visible;
			};
			acts.SetVisible = function (v)
			{
				if (!v !== !this.visible)
				{
					this.visible = v;
					this.runtime.redraw = true;
				}
			};
			cnds.CompareOpacity = function (cmp, x)
			{
				return cr.do_cmp(cr.round6dp(this.opacity * 100), cmp, x);
			};
			acts.SetOpacity = function (x)
			{
				var new_opacity = x / 100.0;
				if (new_opacity < 0)
					new_opacity = 0;
				else if (new_opacity > 1)
					new_opacity = 1;
				if (new_opacity !== this.opacity)
				{
					this.opacity = new_opacity;
					this.runtime.redraw = true;
				}
			};
			exps.Opacity = function (ret)
			{
				ret.set_float(cr.round6dp(this.opacity * 100.0));
			};
		}
		if (zorder_aces)
		{
			cnds.IsOnLayer = function (layer_)
			{
				if (!layer_)
					return false;
				return this.layer === layer_;
			};
			cnds.PickTopBottom = function (which_)
			{
				var sol = this.getCurrentSol();
				var instances = sol.getObjects();
				if (!instances.length)
					return false;
				var inst = instances[0];
				var pickme = inst;
				var i, len;
				for (i = 1, len = instances.length; i < len; i++)
				{
					inst = instances[i];
					if (which_ === 0)
					{
						if (inst.layer.index > pickme.layer.index || (inst.layer.index === pickme.layer.index && inst.get_zindex() > pickme.get_zindex()))
						{
							pickme = inst;
						}
					}
					else
					{
						if (inst.layer.index < pickme.layer.index || (inst.layer.index === pickme.layer.index && inst.get_zindex() < pickme.get_zindex()))
						{
							pickme = inst;
						}
					}
				}
				sol.pick_one(pickme);
				return true;
			};
			acts.MoveToTop = function ()
			{
				var zindex = this.get_zindex();
				if (zindex === this.layer.instances.length - 1)
					return;
				cr.arrayRemove(this.layer.instances, zindex);
				this.layer.instances.push(this);
				this.runtime.redraw = true;
				this.layer.zindices_stale = true;
			};
			acts.MoveToBottom = function ()
			{
				var zindex = this.get_zindex();
				if (zindex === 0)
					return;
				cr.arrayRemove(this.layer.instances, zindex);
				this.layer.instances.unshift(this);
				this.runtime.redraw = true;
				this.layer.zindices_stale = true;
			};
			acts.MoveToLayer = function (layerMove)
			{
				if (!layerMove || layerMove == this.layer)
					return;
				cr.arrayRemove(this.layer.instances, this.get_zindex());
				this.layer.zindices_stale = true;
				this.layer = layerMove;
				this.zindex = layerMove.instances.length;
				layerMove.instances.push(this);
				this.runtime.redraw = true;
			};
			acts.ZMoveToObject = function (where_, obj_)
			{
				var isafter = (where_ === 0);
				if (!obj_)
					return;
				var other = obj_.getFirstPicked(this);
				if (!other || other.uid === this.uid)
					return;
				if (this.layer.index !== other.layer.index)
				{
					cr.arrayRemove(this.layer.instances, this.get_zindex());
					this.layer.zindices_stale = true;
					this.layer = other.layer;
					this.zindex = other.layer.instances.length;
					other.layer.instances.push(this);
				}
				var myZ = this.get_zindex();
				var insertZ = other.get_zindex();
				cr.arrayRemove(this.layer.instances, myZ);
				if (myZ < insertZ)
					insertZ--;
				if (isafter)
					insertZ++;
				if (insertZ === this.layer.instances.length)
					this.layer.instances.push(this);
				else
					this.layer.instances.splice(insertZ, 0, this);
				this.layer.zindices_stale = true;
				this.runtime.redraw = true;
			};
			exps.LayerNumber = function (ret)
			{
				ret.set_int(this.layer.number);
			};
			exps.LayerName = function (ret)
			{
				ret.set_string(this.layer.name);
			};
			exps.ZIndex = function (ret)
			{
				ret.set_int(this.get_zindex());
			};
		}
		if (effects_aces)
		{
			acts.SetEffectEnabled = function (enable_, effectname_)
			{
				if (!this.runtime.glwrap)
					return;
				var i = this.type.getEffectIndexByName(effectname_);
				if (i < 0)
					return;		// effect name not found
				var enable = (enable_ === 1);
				if (this.active_effect_flags[i] === enable)
					return;		// no change
				this.active_effect_flags[i] = enable;
				this.updateActiveEffects();
				this.runtime.redraw = true;
			};
			acts.SetEffectParam = function (effectname_, index_, value_)
			{
				if (!this.runtime.glwrap)
					return;
				var i = this.type.getEffectIndexByName(effectname_);
				if (i < 0)
					return;		// effect name not found
				var et = this.type.effect_types[i];
				var params = this.effect_params[i];
				index_ = Math.floor(index_);
				if (index_ < 0 || index_ >= params.length)
					return;		// effect index out of bounds
				if (this.runtime.glwrap.getProgramParameterType(et.shaderindex, index_) === 1)
					value_ /= 100.0;
				if (params[index_] === value_)
					return;		// no change
				params[index_] = value_;
				if (et.active)
					this.runtime.redraw = true;
			};
		}
	};
	cr.set_bbox_changed = function ()
	{
		this.bbox_changed = true;      		// will recreate next time box requested
		this.cell_changed = true;
		this.type.any_cell_changed = true;	// avoid unnecessary updateAllBBox() calls
		this.runtime.redraw = true;     	// assume runtime needs to redraw
		var i, len, callbacks = this.bbox_changed_callbacks;
		for (i = 0, len = callbacks.length; i < len; ++i)
		{
			callbacks[i](this);
		}
	};
	cr.add_bbox_changed_callback = function (f)
	{
		if (f)
		{
			this.bbox_changed_callbacks.push(f);
		}
	};
	cr.update_bbox = function ()
	{
		if (!this.bbox_changed)
			return;                 // bounding box not changed
		var bbox = this.bbox;
		var bquad = this.bquad;
		bbox.set(this.x, this.y, this.x + this.width, this.y + this.height);
		bbox.offset(-this.hotspotX * this.width, -this.hotspotY * this.height);
		if (!this.angle)
		{
			bquad.set_from_rect(bbox);    // make bounding quad from box
		}
		else
		{
			bbox.offset(-this.x, -this.y);       			// translate to origin
			bquad.set_from_rotated_rect(bbox, this.angle);	// rotate around origin
			bquad.offset(this.x, this.y);      				// translate back to original position
			bquad.bounding_box(bbox);
		}
		bbox.normalize();
		this.bbox_changed = false;  // bounding box up to date
	};
	var tmprc = new cr.rect(0, 0, 0, 0);
	cr.update_collision_cell = function ()
	{
		if (!this.cell_changed || !this.collisionsEnabled)
			return;
		this.update_bbox();
		var mygrid = this.type.collision_grid;
		var collcells = this.collcells;
		var bbox = this.bbox;
		tmprc.set(mygrid.XToCell(bbox.left), mygrid.YToCell(bbox.top), mygrid.XToCell(bbox.right), mygrid.YToCell(bbox.bottom));
		if (collcells.equals(tmprc))
			return;
		if (collcells.right < collcells.left)
			mygrid.update(this, null, tmprc);		// first insertion with invalid rect: don't provide old range
		else
			mygrid.update(this, collcells, tmprc);
		collcells.copy(tmprc);
		this.cell_changed = false;
	};
	cr.inst_contains_pt = function (x, y)
	{
		if (!this.bbox.contains_pt(x, y))
			return false;
		if (!this.bquad.contains_pt(x, y))
			return false;
		if (this.collision_poly && !this.collision_poly.is_empty())
		{
			this.collision_poly.cache_poly(this.width, this.height, this.angle);
			return this.collision_poly.contains_pt(x - this.x, y - this.y);
		}
		else
			return true;
	};
	cr.inst_get_iid = function ()
	{
		this.type.updateIIDs();
		return this.iid;
	};
	cr.inst_get_zindex = function ()
	{
		this.layer.updateZIndices();
		return this.zindex;
	};
	cr.inst_updateActiveEffects = function ()
	{
		this.active_effect_types.length = 0;
		var i, len, et, inst;
		for (i = 0, len = this.active_effect_flags.length; i < len; i++)
		{
			if (this.active_effect_flags[i])
				this.active_effect_types.push(this.type.effect_types[i]);
		}
		this.uses_shaders = !!this.active_effect_types.length;
	};
	cr.inst_toString = function ()
	{
		return "Inst" + this.puid;
	};
	cr.type_getFirstPicked = function (frominst)
	{
		if (frominst && frominst.is_contained && frominst.type != this)
		{
			var i, len, s;
			for (i = 0, len = frominst.siblings.length; i < len; i++)
			{
				s = frominst.siblings[i];
				if (s.type == this)
					return s;
			}
		}
		var instances = this.getCurrentSol().getObjects();
		if (instances.length)
			return instances[0];
		else
			return null;
	};
	cr.type_getPairedInstance = function (inst)
	{
		var instances = this.getCurrentSol().getObjects();
		if (instances.length)
			return instances[inst.get_iid() % instances.length];
		else
			return null;
	};
	cr.type_updateIIDs = function ()
	{
		if (!this.stale_iids || this.is_family)
			return;		// up to date or is family - don't want family to overwrite IIDs
		var i, len;
		for (i = 0, len = this.instances.length; i < len; i++)
			this.instances[i].iid = i;
		var next_iid = i;
		var createRow = this.runtime.createRow;
		for (i = 0, len = createRow.length; i < len; ++i)
		{
			if (createRow[i].type === this)
				createRow[i].iid = next_iid++;
		}
		this.stale_iids = false;
	};
	cr.type_getInstanceByIID = function (i)
	{
		if (i < this.instances.length)
			return this.instances[i];
		i -= this.instances.length;
		var createRow = this.runtime.createRow;
		var j, lenj;
		for (j = 0, lenj = createRow.length; j < lenj; ++j)
		{
			if (createRow[j].type === this)
			{
				if (i === 0)
					return createRow[j];
				--i;
			}
		}
;
		return null;
	};
	cr.type_getCurrentSol = function ()
	{
		return this.solstack[this.cur_sol];
	};
	cr.type_pushCleanSol = function ()
	{
		this.cur_sol++;
		if (this.cur_sol === this.solstack.length)
			this.solstack.push(new cr.selection(this));
		else
			this.solstack[this.cur_sol].select_all = true;  // else clear next SOL
	};
	cr.type_pushCopySol = function ()
	{
		this.cur_sol++;
		if (this.cur_sol === this.solstack.length)
			this.solstack.push(new cr.selection(this));
		var clonesol = this.solstack[this.cur_sol];
		var prevsol = this.solstack[this.cur_sol - 1];
		if (prevsol.select_all)
			clonesol.select_all = true;
		else
		{
			clonesol.select_all = false;
			cr.shallowAssignArray(clonesol.instances, prevsol.instances);
			cr.shallowAssignArray(clonesol.else_instances, prevsol.else_instances);
		}
	};
	cr.type_popSol = function ()
	{
;
		this.cur_sol--;
	};
	cr.type_getBehaviorByName = function (behname)
	{
		var i, len, j, lenj, f, index = 0;
		if (!this.is_family)
		{
			for (i = 0, len = this.families.length; i < len; i++)
			{
				f = this.families[i];
				for (j = 0, lenj = f.behaviors.length; j < lenj; j++)
				{
					if (behname === f.behaviors[j].name)
					{
						this.extra.lastBehIndex = index;
						return f.behaviors[j];
					}
					index++;
				}
			}
		}
		for (i = 0, len = this.behaviors.length; i < len; i++) {
			if (behname === this.behaviors[i].name)
			{
				this.extra.lastBehIndex = index;
				return this.behaviors[i];
			}
			index++;
		}
		return null;
	};
	cr.type_getBehaviorIndexByName = function (behname)
	{
		var b = this.getBehaviorByName(behname);
		if (b)
			return this.extra.lastBehIndex;
		else
			return -1;
	};
	cr.type_getEffectIndexByName = function (name_)
	{
		var i, len;
		for (i = 0, len = this.effect_types.length; i < len; i++)
		{
			if (this.effect_types[i].name === name_)
				return i;
		}
		return -1;
	};
	cr.type_applySolToContainer = function ()
	{
		if (!this.is_contained || this.is_family)
			return;
		var i, len, j, lenj, t, sol, sol2;
		this.updateIIDs();
		sol = this.getCurrentSol();
		var select_all = sol.select_all;
		var es = this.runtime.getCurrentEventStack();
		var orblock = es && es.current_event && es.current_event.orblock;
		for (i = 0, len = this.container.length; i < len; i++)
		{
			t = this.container[i];
			if (t === this)
				continue;
			t.updateIIDs();
			sol2 = t.getCurrentSol();
			sol2.select_all = select_all;
			if (!select_all)
			{
				sol2.instances.length = sol.instances.length;
				for (j = 0, lenj = sol.instances.length; j < lenj; j++)
					sol2.instances[j] = t.getInstanceByIID(sol.instances[j].iid);
				if (orblock)
				{
					sol2.else_instances.length = sol.else_instances.length;
					for (j = 0, lenj = sol.else_instances.length; j < lenj; j++)
						sol2.else_instances[j] = t.getInstanceByIID(sol.else_instances[j].iid);
				}
			}
		}
	};
	cr.type_toString = function ()
	{
		return "Type" + this.sid;
	};
	cr.do_cmp = function (x, cmp, y)
	{
		if (typeof x === "undefined" || typeof y === "undefined")
			return false;
		switch (cmp)
		{
			case 0:     // equal
				return x === y;
			case 1:     // not equal
				return x !== y;
			case 2:     // less
				return x < y;
			case 3:     // less/equal
				return x <= y;
			case 4:     // greater
				return x > y;
			case 5:     // greater/equal
				return x >= y;
			default:
;
				return false;
		}
	};
})();
cr.shaders = {};
;
;
cr.plugins_.Audio = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var pluginProto = cr.plugins_.Audio.prototype;
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	typeProto.onCreate = function()
	{
	};
	var audRuntime = null;
	var audInst = null;
	var audTag = "";
	var appPath = "";			// for PhoneGap only
	var API_HTML5 = 0;
	var API_WEBAUDIO = 1;
	var API_PHONEGAP = 2;
	var API_APPMOBI = 3;
	var api = API_HTML5;
	var context = null;
	var audioBuffers = [];		// cache of buffers
	var audioInstances = [];	// cache of instances
	var lastAudio = null;
	var useOgg = false;			// determined at create time
	var timescale_mode = 0;
	var silent = false;
	var masterVolume = 1;
	var listenerX = 0;
	var listenerY = 0;
	var panningModel = 1;		// HRTF
	var distanceModel = 1;		// Inverse
	var refDistance = 10;
	var maxDistance = 10000;
	var rolloffFactor = 1;
	var micSource = null;
	var micTag = "";
	var isMusicWorkaround = false;
	var musicPlayNextTouch = [];
	function dbToLinear(x)
	{
		var v = dbToLinear_nocap(x);
		if (v < 0)
			v = 0;
		if (v > 1)
			v = 1;
		return v;
	};
	function linearToDb(x)
	{
		if (x < 0)
			x = 0;
		if (x > 1)
			x = 1;
		return linearToDb_nocap(x);
	};
	function dbToLinear_nocap(x)
	{
		return Math.pow(10, x / 20);
	};
	function linearToDb_nocap(x)
	{
		return (Math.log(x) / Math.log(10)) * 20;
	};
	var effects = {};
	function getDestinationForTag(tag)
	{
		tag = tag.toLowerCase();
		if (effects.hasOwnProperty(tag))
		{
			if (effects[tag].length)
				return effects[tag][0].getInputNode();
		}
		return context["destination"];
	};
	function createGain()
	{
		if (context["createGain"])
			return context["createGain"]();
		else
			return context["createGainNode"]();
	};
	function createDelay(d)
	{
		if (context["createDelay"])
			return context["createDelay"](d);
		else
			return context["createDelayNode"](d);
	};
	function startSource(s)
	{
		if (s["start"])
			s["start"](0);
		else
			s["noteOn"](0);
	};
	function startSourceAt(s, x, d)
	{
		if (s["start"])
			s["start"](0, x);
		else
			s["noteGrainOn"](0, x, d - x);
	};
	function stopSource(s)
	{
		try {
			if (s["stop"])
				s["stop"](0);
			else
				s["noteOff"](0);
		}
		catch (e) {}
	};
	function setAudioParam(ap, value, ramp, time)
	{
		if (!ap)
			return;		// iOS is missing some parameters
		ap["cancelScheduledValues"](0);
		if (time === 0)
		{
			ap["value"] = value;
			return;
		}
		var curTime = context["currentTime"];
		time += curTime;
		switch (ramp) {
		case 0:		// step
			ap["setValueAtTime"](value, time);
			break;
		case 1:		// linear
			ap["setValueAtTime"](ap["value"], curTime);		// to set what to ramp from
			ap["linearRampToValueAtTime"](value, time);
			break;
		case 2:		// exponential
			ap["setValueAtTime"](ap["value"], curTime);		// to set what to ramp from
			ap["exponentialRampToValueAtTime"](value, time);
			break;
		}
	};
	var filterTypes = ["lowpass", "highpass", "bandpass", "lowshelf", "highshelf", "peaking", "notch", "allpass"];
	function FilterEffect(type, freq, detune, q, gain, mix)
	{
		this.type = "filter";
		this.params = [type, freq, detune, q, gain, mix];
		this.inputNode = createGain();
		this.wetNode = createGain();
		this.wetNode["gain"]["value"] = mix;
		this.dryNode = createGain();
		this.dryNode["gain"]["value"] = 1 - mix;
		this.filterNode = context["createBiquadFilter"]();
		if (typeof this.filterNode["type"] === "number")
			this.filterNode["type"] = type;
		else
			this.filterNode["type"] = filterTypes[type];
		this.filterNode["frequency"]["value"] = freq;
		if (this.filterNode["detune"])		// iOS 6 doesn't have detune yet
			this.filterNode["detune"]["value"] = detune;
		this.filterNode["Q"]["value"] = q;
		this.filterNode["gain"]["value"] = gain;
		this.inputNode["connect"](this.filterNode);
		this.inputNode["connect"](this.dryNode);
		this.filterNode["connect"](this.wetNode);
	};
	FilterEffect.prototype.connectTo = function (node)
	{
		this.wetNode["disconnect"]();
		this.wetNode["connect"](node);
		this.dryNode["disconnect"]();
		this.dryNode["connect"](node);
	};
	FilterEffect.prototype.remove = function ()
	{
		this.inputNode["disconnect"]();
		this.filterNode["disconnect"]();
		this.wetNode["disconnect"]();
		this.dryNode["disconnect"]();
	};
	FilterEffect.prototype.getInputNode = function ()
	{
		return this.inputNode;
	};
	FilterEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[5] = value;
			setAudioParam(this.wetNode["gain"], value, ramp, time);
			setAudioParam(this.dryNode["gain"], 1 - value, ramp, time);
			break;
		case 1:		// filter frequency
			this.params[1] = value;
			setAudioParam(this.filterNode["frequency"], value, ramp, time);
			break;
		case 2:		// filter detune
			this.params[2] = value;
			setAudioParam(this.filterNode["detune"], value, ramp, time);
			break;
		case 3:		// filter Q
			this.params[3] = value;
			setAudioParam(this.filterNode["Q"], value, ramp, time);
			break;
		case 4:		// filter/delay gain (note value is in dB here)
			this.params[4] = value;
			setAudioParam(this.filterNode["gain"], value, ramp, time);
			break;
		}
	};
	function DelayEffect(delayTime, delayGain, mix)
	{
		this.type = "delay";
		this.params = [delayTime, delayGain, mix];
		this.inputNode = createGain();
		this.wetNode = createGain();
		this.wetNode["gain"]["value"] = mix;
		this.dryNode = createGain();
		this.dryNode["gain"]["value"] = 1 - mix;
		this.mainNode = createGain();
		this.delayNode = createDelay(delayTime);
		this.delayNode["delayTime"]["value"] = delayTime;
		this.delayGainNode = createGain();
		this.delayGainNode["gain"]["value"] = delayGain;
		this.inputNode["connect"](this.mainNode);
		this.inputNode["connect"](this.dryNode);
		this.mainNode["connect"](this.wetNode);
		this.mainNode["connect"](this.delayNode);
		this.delayNode["connect"](this.delayGainNode);
		this.delayGainNode["connect"](this.mainNode);
	};
	DelayEffect.prototype.connectTo = function (node)
	{
		this.wetNode["disconnect"]();
		this.wetNode["connect"](node);
		this.dryNode["disconnect"]();
		this.dryNode["connect"](node);
	};
	DelayEffect.prototype.remove = function ()
	{
		this.inputNode["disconnect"]();
		this.mainNode["disconnect"]();
		this.delayNode["disconnect"]();
		this.delayGainNode["disconnect"]();
		this.wetNode["disconnect"]();
		this.dryNode["disconnect"]();
	};
	DelayEffect.prototype.getInputNode = function ()
	{
		return this.inputNode;
	};
	DelayEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[2] = value;
			setAudioParam(this.wetNode["gain"], value, ramp, time);
			setAudioParam(this.dryNode["gain"], 1 - value, ramp, time);
			break;
		case 4:		// filter/delay gain (note value is passed in dB but needs to be linear here)
			this.params[1] = dbToLinear(value);
			setAudioParam(this.delayGainNode["gain"], dbToLinear(value), ramp, time);
			break;
		case 5:		// delay time
			this.params[0] = value;
			setAudioParam(this.delayNode["delayTime"], value, ramp, time);
			break;
		}
	};
	function ConvolveEffect(buffer, normalize, mix, src)
	{
		this.type = "convolve";
		this.params = [normalize, mix, src];
		this.inputNode = createGain();
		this.wetNode = createGain();
		this.wetNode["gain"]["value"] = mix;
		this.dryNode = createGain();
		this.dryNode["gain"]["value"] = 1 - mix;
		this.convolveNode = context["createConvolver"]();
		if (buffer)
		{
			this.convolveNode["normalize"] = normalize;
			this.convolveNode["buffer"] = buffer;
		}
		this.inputNode["connect"](this.convolveNode);
		this.inputNode["connect"](this.dryNode);
		this.convolveNode["connect"](this.wetNode);
	};
	ConvolveEffect.prototype.connectTo = function (node)
	{
		this.wetNode["disconnect"]();
		this.wetNode["connect"](node);
		this.dryNode["disconnect"]();
		this.dryNode["connect"](node);
	};
	ConvolveEffect.prototype.remove = function ()
	{
		this.inputNode["disconnect"]();
		this.convolveNode["disconnect"]();
		this.wetNode["disconnect"]();
		this.dryNode["disconnect"]();
	};
	ConvolveEffect.prototype.getInputNode = function ()
	{
		return this.inputNode;
	};
	ConvolveEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[1] = value;
			setAudioParam(this.wetNode["gain"], value, ramp, time);
			setAudioParam(this.dryNode["gain"], 1 - value, ramp, time);
			break;
		}
	};
	function FlangerEffect(delay, modulation, freq, feedback, mix)
	{
		this.type = "flanger";
		this.params = [delay, modulation, freq, feedback, mix];
		this.inputNode = createGain();
		this.dryNode = createGain();
		this.dryNode["gain"]["value"] = 1 - (mix / 2);
		this.wetNode = createGain();
		this.wetNode["gain"]["value"] = mix / 2;
		this.feedbackNode = createGain();
		this.feedbackNode["gain"]["value"] = feedback;
		this.delayNode = createDelay(delay + modulation);
		this.delayNode["delayTime"]["value"] = delay;
		this.oscNode = context["createOscillator"]();
		this.oscNode["frequency"]["value"] = freq;
		this.oscGainNode = createGain();
		this.oscGainNode["gain"]["value"] = modulation;
		this.inputNode["connect"](this.delayNode);
		this.inputNode["connect"](this.dryNode);
		this.delayNode["connect"](this.wetNode);
		this.delayNode["connect"](this.feedbackNode);
		this.feedbackNode["connect"](this.delayNode);
		this.oscNode["connect"](this.oscGainNode);
		this.oscGainNode["connect"](this.delayNode["delayTime"]);
		startSource(this.oscNode);
	};
	FlangerEffect.prototype.connectTo = function (node)
	{
		this.dryNode["disconnect"]();
		this.dryNode["connect"](node);
		this.wetNode["disconnect"]();
		this.wetNode["connect"](node);
	};
	FlangerEffect.prototype.remove = function ()
	{
		this.inputNode["disconnect"]();
		this.delayNode["disconnect"]();
		this.oscNode["disconnect"]();
		this.oscGainNode["disconnect"]();
		this.dryNode["disconnect"]();
		this.wetNode["disconnect"]();
		this.feedbackNode["disconnect"]();
	};
	FlangerEffect.prototype.getInputNode = function ()
	{
		return this.inputNode;
	};
	FlangerEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[4] = value;
			setAudioParam(this.wetNode["gain"], value / 2, ramp, time);
			setAudioParam(this.dryNode["gain"], 1 - (value / 2), ramp, time);
			break;
		case 6:		// modulation
			this.params[1] = value / 1000;
			setAudioParam(this.oscGainNode["gain"], value / 1000, ramp, time);
			break;
		case 7:		// modulation frequency
			this.params[2] = value;
			setAudioParam(this.oscNode["frequency"], value, ramp, time);
			break;
		case 8:		// feedback
			this.params[3] = value / 100;
			setAudioParam(this.feedbackNode["gain"], value / 100, ramp, time);
			break;
		}
	};
	function PhaserEffect(freq, detune, q, modulation, modfreq, mix)
	{
		this.type = "phaser";
		this.params = [freq, detune, q, modulation, modfreq, mix];
		this.inputNode = createGain();
		this.dryNode = createGain();
		this.dryNode["gain"]["value"] = 1 - (mix / 2);
		this.wetNode = createGain();
		this.wetNode["gain"]["value"] = mix / 2;
		this.filterNode = context["createBiquadFilter"]();
		if (typeof this.filterNode["type"] === "number")
			this.filterNode["type"] = 7;	// all-pass
		else
			this.filterNode["type"] = "allpass";
		this.filterNode["frequency"]["value"] = freq;
		if (this.filterNode["detune"])		// iOS 6 doesn't have detune yet
			this.filterNode["detune"]["value"] = detune;
		this.filterNode["Q"]["value"] = q;
		this.oscNode = context["createOscillator"]();
		this.oscNode["frequency"]["value"] = modfreq;
		this.oscGainNode = createGain();
		this.oscGainNode["gain"]["value"] = modulation;
		this.inputNode["connect"](this.filterNode);
		this.inputNode["connect"](this.dryNode);
		this.filterNode["connect"](this.wetNode);
		this.oscNode["connect"](this.oscGainNode);
		this.oscGainNode["connect"](this.filterNode["frequency"]);
		startSource(this.oscNode);
	};
	PhaserEffect.prototype.connectTo = function (node)
	{
		this.dryNode["disconnect"]();
		this.dryNode["connect"](node);
		this.wetNode["disconnect"]();
		this.wetNode["connect"](node);
	};
	PhaserEffect.prototype.remove = function ()
	{
		this.inputNode["disconnect"]();
		this.filterNode["disconnect"]();
		this.oscNode["disconnect"]();
		this.oscGainNode["disconnect"]();
		this.dryNode["disconnect"]();
		this.wetNode["disconnect"]();
	};
	PhaserEffect.prototype.getInputNode = function ()
	{
		return this.inputNode;
	};
	PhaserEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[5] = value;
			setAudioParam(this.wetNode["gain"], value / 2, ramp, time);
			setAudioParam(this.dryNode["gain"], 1 - (value / 2), ramp, time);
			break;
		case 1:		// filter frequency
			this.params[0] = value;
			setAudioParam(this.filterNode["frequency"], value, ramp, time);
			break;
		case 2:		// filter detune
			this.params[1] = value;
			setAudioParam(this.filterNode["detune"], value, ramp, time);
			break;
		case 3:		// filter Q
			this.params[2] = value;
			setAudioParam(this.filterNode["Q"], value, ramp, time);
			break;
		case 6:		// modulation
			this.params[3] = value;
			setAudioParam(this.oscGainNode["gain"], value, ramp, time);
			break;
		case 7:		// modulation frequency
			this.params[4] = value;
			setAudioParam(this.oscNode["frequency"], value, ramp, time);
			break;
		}
	};
	function GainEffect(g)
	{
		this.type = "gain";
		this.params = [g];
		this.node = createGain();
		this.node["gain"]["value"] = g;
	};
	GainEffect.prototype.connectTo = function (node_)
	{
		this.node["disconnect"]();
		this.node["connect"](node_);
	};
	GainEffect.prototype.remove = function ()
	{
		this.node["disconnect"]();
	};
	GainEffect.prototype.getInputNode = function ()
	{
		return this.node;
	};
	GainEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 4:		// gain
			this.params[0] = dbToLinear(value);
			setAudioParam(this.node["gain"], dbToLinear(value), ramp, time);
			break;
		}
	};
	function TremoloEffect(freq, mix)
	{
		this.type = "tremolo";
		this.params = [freq, mix];
		this.node = createGain();
		this.node["gain"]["value"] = 1 - (mix / 2);
		this.oscNode = context["createOscillator"]();
		this.oscNode["frequency"]["value"] = freq;
		this.oscGainNode = createGain();
		this.oscGainNode["gain"]["value"] = mix / 2;
		this.oscNode["connect"](this.oscGainNode);
		this.oscGainNode["connect"](this.node["gain"]);
		startSource(this.oscNode);
	};
	TremoloEffect.prototype.connectTo = function (node_)
	{
		this.node["disconnect"]();
		this.node["connect"](node_);
	};
	TremoloEffect.prototype.remove = function ()
	{
		this.oscNode["disconnect"]();
		this.oscGainNode["disconnect"]();
		this.node["disconnect"]();
	};
	TremoloEffect.prototype.getInputNode = function ()
	{
		return this.node;
	};
	TremoloEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[1] = value;
			setAudioParam(this.node["gain"]["value"], 1 - (value / 2), ramp, time);
			setAudioParam(this.oscGainNode["gain"]["value"], value / 2, ramp, time);
			break;
		case 7:		// modulation frequency
			this.params[0] = value;
			setAudioParam(this.oscNode["frequency"], value, ramp, time);
			break;
		}
	};
	function RingModulatorEffect(freq, mix)
	{
		this.type = "ringmod";
		this.params = [freq, mix];
		this.inputNode = createGain();
		this.wetNode = createGain();
		this.wetNode["gain"]["value"] = mix;
		this.dryNode = createGain();
		this.dryNode["gain"]["value"] = 1 - mix;
		this.ringNode = createGain();
		this.ringNode["gain"]["value"] = 0;
		this.oscNode = context["createOscillator"]();
		this.oscNode["frequency"]["value"] = freq;
		this.oscNode["connect"](this.ringNode["gain"]);
		startSource(this.oscNode);
		this.inputNode["connect"](this.ringNode);
		this.inputNode["connect"](this.dryNode);
		this.ringNode["connect"](this.wetNode);
	};
	RingModulatorEffect.prototype.connectTo = function (node_)
	{
		this.wetNode["disconnect"]();
		this.wetNode["connect"](node_);
		this.dryNode["disconnect"]();
		this.dryNode["connect"](node_);
	};
	RingModulatorEffect.prototype.remove = function ()
	{
		this.oscNode["disconnect"]();
		this.ringNode["disconnect"]();
		this.inputNode["disconnect"]();
		this.wetNode["disconnect"]();
		this.dryNode["disconnect"]();
	};
	RingModulatorEffect.prototype.getInputNode = function ()
	{
		return this.inputNode;
	};
	RingModulatorEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[1] = value;
			setAudioParam(this.wetNode["gain"], value, ramp, time);
			setAudioParam(this.dryNode["gain"], 1 - value, ramp, time);
			break;
		case 7:		// modulation frequency
			this.params[0] = value;
			setAudioParam(this.oscNode["frequency"], value, ramp, time);
			break;
		}
	};
	function DistortionEffect(threshold, headroom, drive, makeupgain, mix)
	{
		this.type = "distortion";
		this.params = [threshold, headroom, drive, makeupgain, mix];
		this.inputNode = createGain();
		this.preGain = createGain();
		this.postGain = createGain();
		this.setDrive(drive, dbToLinear_nocap(makeupgain));
		this.wetNode = createGain();
		this.wetNode["gain"]["value"] = mix;
		this.dryNode = createGain();
		this.dryNode["gain"]["value"] = 1 - mix;
		this.waveShaper = context["createWaveShaper"]();
		this.curve = new Float32Array(65536);
		this.generateColortouchCurve(threshold, headroom);
		this.waveShaper.curve = this.curve;
		this.inputNode["connect"](this.preGain);
		this.inputNode["connect"](this.dryNode);
		this.preGain["connect"](this.waveShaper);
		this.waveShaper["connect"](this.postGain);
		this.postGain["connect"](this.wetNode);
	};
	DistortionEffect.prototype.setDrive = function (drive, makeupgain)
	{
		if (drive < 0.01)
			drive = 0.01;
		this.preGain["gain"]["value"] = drive;
		this.postGain["gain"]["value"] = Math.pow(1 / drive, 0.6) * makeupgain;
	};
	function e4(x, k)
	{
		return 1.0 - Math.exp(-k * x);
	}
	DistortionEffect.prototype.shape = function (x, linearThreshold, linearHeadroom)
	{
		var maximum = 1.05 * linearHeadroom * linearThreshold;
		var kk = (maximum - linearThreshold);
		var sign = x < 0 ? -1 : +1;
		var absx = x < 0 ? -x : x;
		var shapedInput = absx < linearThreshold ? absx : linearThreshold + kk * e4(absx - linearThreshold, 1.0 / kk);
		shapedInput *= sign;
		return shapedInput;
	};
	DistortionEffect.prototype.generateColortouchCurve = function (threshold, headroom)
	{
		var linearThreshold = dbToLinear_nocap(threshold);
		var linearHeadroom = dbToLinear_nocap(headroom);
		var n = 65536;
		var n2 = n / 2;
		var x = 0;
		for (var i = 0; i < n2; ++i) {
			x = i / n2;
			x = this.shape(x, linearThreshold, linearHeadroom);
			this.curve[n2 + i] = x;
			this.curve[n2 - i - 1] = -x;
		}
	};
	DistortionEffect.prototype.connectTo = function (node)
	{
		this.wetNode["disconnect"]();
		this.wetNode["connect"](node);
		this.dryNode["disconnect"]();
		this.dryNode["connect"](node);
	};
	DistortionEffect.prototype.remove = function ()
	{
		this.inputNode["disconnect"]();
		this.preGain["disconnect"]();
		this.waveShaper["disconnect"]();
		this.postGain["disconnect"]();
		this.wetNode["disconnect"]();
		this.dryNode["disconnect"]();
	};
	DistortionEffect.prototype.getInputNode = function ()
	{
		return this.inputNode;
	};
	DistortionEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[4] = value;
			setAudioParam(this.wetNode["gain"], value, ramp, time);
			setAudioParam(this.dryNode["gain"], 1 - value, ramp, time);
			break;
		}
	};
	function CompressorEffect(threshold, knee, ratio, attack, release)
	{
		this.type = "compressor";
		this.params = [threshold, knee, ratio, attack, release];
		this.node = context["createDynamicsCompressor"]();
		try {
			this.node["threshold"]["value"] = threshold;
			this.node["knee"]["value"] = knee;
			this.node["ratio"]["value"] = ratio;
			this.node["attack"]["value"] = attack;
			this.node["release"]["value"] = release;
		}
		catch (e) {}
	};
	CompressorEffect.prototype.connectTo = function (node_)
	{
		this.node["disconnect"]();
		this.node["connect"](node_);
	};
	CompressorEffect.prototype.remove = function ()
	{
		this.node["disconnect"]();
	};
	CompressorEffect.prototype.getInputNode = function ()
	{
		return this.node;
	};
	CompressorEffect.prototype.setParam = function(param, value, ramp, time)
	{
	};
	function AnalyserEffect(fftSize, smoothing)
	{
		this.type = "analyser";
		this.params = [fftSize, smoothing];
		this.node = context["createAnalyser"]();
		this.node["fftSize"] = fftSize;
		this.node["smoothingTimeConstant"] = smoothing;
		this.freqBins = new Float32Array(this.node["frequencyBinCount"]);
		this.signal = new Uint8Array(fftSize);
		this.peak = 0;
		this.rms = 0;
	};
	AnalyserEffect.prototype.tick = function ()
	{
		this.node["getFloatFrequencyData"](this.freqBins);
		this.node["getByteTimeDomainData"](this.signal);
		var fftSize = this.node["fftSize"];
		var i = 0;
		this.peak = 0;
		var rmsSquaredSum = 0;
		var s = 0;
		for ( ; i < fftSize; i++)
		{
			s = (this.signal[i] - 128) / 128;
			if (s < 0)
				s = -s;
			if (this.peak < s)
				this.peak = s;
			rmsSquaredSum += s * s;
		}
		this.peak = linearToDb(this.peak);
		this.rms = linearToDb(Math.sqrt(rmsSquaredSum / fftSize));
	};
	AnalyserEffect.prototype.connectTo = function (node_)
	{
		this.node["disconnect"]();
		this.node["connect"](node_);
	};
	AnalyserEffect.prototype.remove = function ()
	{
		this.node["disconnect"]();
	};
	AnalyserEffect.prototype.getInputNode = function ()
	{
		return this.node;
	};
	AnalyserEffect.prototype.setParam = function(param, value, ramp, time)
	{
	};
	var OT_POS_SAMPLES = 4;
	function ObjectTracker()
	{
		this.obj = null;
		this.loadUid = 0;
		this.speeds = [];
		this.lastX = 0;
		this.lastY = 0;
		this.moveAngle = 0;
	};
	ObjectTracker.prototype.setObject = function (obj_)
	{
		this.obj = obj_;
		if (this.obj)
		{
			this.lastX = this.obj.x;
			this.lastY = this.obj.y;
		}
		this.speeds.length = 0;
	};
	ObjectTracker.prototype.hasObject = function ()
	{
		return !!this.obj;
	};
	ObjectTracker.prototype.tick = function (dt)
	{
		if (!this.obj || dt === 0)
			return;
		this.moveAngle = cr.angleTo(this.lastX, this.lastY, this.obj.x, this.obj.y);
		var s = cr.distanceTo(this.lastX, this.lastY, this.obj.x, this.obj.y) / dt;
		if (this.speeds.length < OT_POS_SAMPLES)
			this.speeds.push(s);
		else
		{
			this.speeds.shift();
			this.speeds.push(s);
		}
		this.lastX = this.obj.x;
		this.lastY = this.obj.y;
	};
	ObjectTracker.prototype.getSpeed = function ()
	{
		if (!this.speeds.length)
			return 0;
		var i, len, sum = 0;
		for (i = 0, len = this.speeds.length; i < len; i++)
		{
			sum += this.speeds[i];
		}
		return sum / this.speeds.length;
	};
	ObjectTracker.prototype.getVelocityX = function ()
	{
		return Math.cos(this.moveAngle) * this.getSpeed();
	};
	ObjectTracker.prototype.getVelocityY = function ()
	{
		return Math.sin(this.moveAngle) * this.getSpeed();
	};
	var iOShadtouch = false;	// has had touch input on iOS to work around web audio API muting
	function C2AudioBuffer(src_, is_music)
	{
		this.src = src_;
		this.myapi = api;
		this.is_music = is_music;
		this.added_end_listener = false;
		var self = this;
		this.outNode = null;
		this.mediaSourceNode = null;
		this.panWhenReady = [];		// for web audio API positioned sounds
		this.seekWhenReady = 0;
		this.pauseWhenReady = false;
		this.supportWebAudioAPI = false;
		if (api === API_WEBAUDIO && is_music)
		{
			this.myapi = API_HTML5;
			this.outNode = createGain();
		}
		this.bufferObject = null;			// actual audio object
		this.audioData = null;				// web audio api: ajax request result (compressed audio that needs decoding)
		var request;
		switch (this.myapi) {
		case API_HTML5:
			this.bufferObject = new Audio();
			if (api === API_WEBAUDIO && context["createMediaElementSource"] && !audRuntime.isFirefox && !/wiiu/i.test(navigator.userAgent))
			{
				this.supportWebAudioAPI = true;		// can be routed through web audio api
				this.bufferObject.addEventListener("canplay", function ()
				{
					if (!self.mediaSourceNode)		// protect against this event firing twice
					{
						self.mediaSourceNode = context["createMediaElementSource"](self.bufferObject);
						self.mediaSourceNode["connect"](self.outNode);
					}
				});
			}
			this.bufferObject.autoplay = false;	// this is only a source buffer, not an instance
			this.bufferObject.preload = "auto";
			this.bufferObject.src = src_;
			break;
		case API_WEBAUDIO:
			request = new XMLHttpRequest();
			request.open("GET", src_, true);
			request.responseType = "arraybuffer";
			request.onload = function () {
				self.audioData = request.response;
				self.decodeAudioBuffer();
			};
			request.send();
			break;
		case API_PHONEGAP:
			this.bufferObject = true;
			break;
		case API_APPMOBI:
			this.bufferObject = true;
			break;
		}
	};
	C2AudioBuffer.prototype.decodeAudioBuffer = function ()
	{
		if (this.bufferObject || !this.audioData)
			return;		// audio already decoded or AJAX request not yet complete
		var self = this;
		if (context["decodeAudioData"])
		{
			context["decodeAudioData"](this.audioData, function (buffer) {
					self.bufferObject = buffer;
					var p, i, len, a;
					if (!cr.is_undefined(self.playTagWhenReady) && !silent)
					{
						if (self.panWhenReady.length)
						{
							for (i = 0, len = self.panWhenReady.length; i < len; i++)
							{
								p = self.panWhenReady[i];
								a = new C2AudioInstance(self, p.thistag);
								a.setPannerEnabled(true);
								if (typeof p.objUid !== "undefined")
								{
									p.obj = audRuntime.getObjectByUID(p.objUid);
									if (!p.obj)
										continue;
								}
								if (p.obj)
								{
									var px = cr.rotatePtAround(p.obj.x, p.obj.y, -p.obj.layer.getAngle(), listenerX, listenerY, true);
									var py = cr.rotatePtAround(p.obj.x, p.obj.y, -p.obj.layer.getAngle(), listenerX, listenerY, false);
									a.setPan(px, py, cr.to_degrees(p.obj.angle - p.obj.layer.getAngle()), p.ia, p.oa, p.og);
									a.setObject(p.obj);
								}
								else
								{
									a.setPan(p.x, p.y, p.a, p.ia, p.oa, p.og);
								}
								a.play(self.loopWhenReady, self.volumeWhenReady, self.seekWhenReady);
								if (self.pauseWhenReady)
									a.pause();
								audioInstances.push(a);
							}
							self.panWhenReady.length = 0;
						}
						else
						{
							a = new C2AudioInstance(self, self.playTagWhenReady);
							a.play(self.loopWhenReady, self.volumeWhenReady, self.seekWhenReady);
							if (self.pauseWhenReady)
								a.pause();
							audioInstances.push(a);
						}
					}
					else if (!cr.is_undefined(self.convolveWhenReady))
					{
						var convolveNode = self.convolveWhenReady.convolveNode;
						convolveNode["normalize"] = self.normalizeWhenReady;
						convolveNode["buffer"] = buffer;
					}
			});
		}
		else
		{
			this.bufferObject = context["createBuffer"](this.audioData, false);
			if (!cr.is_undefined(this.playTagWhenReady) && !silent)
			{
				var a = new C2AudioInstance(this, this.playTagWhenReady);
				a.play(this.loopWhenReady, this.volumeWhenReady, this.seekWhenReady);
				if (this.pauseWhenReady)
					a.pause();
				audioInstances.push(a);
			}
			else if (!cr.is_undefined(this.convolveWhenReady))
			{
				var convolveNode = this.convolveWhenReady.convolveNode;
				convolveNode["normalize"] = this.normalizeWhenReady;
				convolveNode["buffer"] = this.bufferObject;
			}
		}
	};
	C2AudioBuffer.prototype.isLoaded = function ()
	{
		switch (this.myapi) {
		case API_HTML5:
			return this.bufferObject["readyState"] === 4;	// HAVE_ENOUGH_DATA
		case API_WEBAUDIO:
			return !!this.audioData;			// null until AJAX request completes
		case API_PHONEGAP:
			return true;
		case API_APPMOBI:
			return true;
		}
		return false;
	};
	function C2AudioInstance(buffer_, tag_)
	{
		var self = this;
		this.tag = tag_;
		this.fresh = true;
		this.stopped = true;
		this.src = buffer_.src;
		this.buffer = buffer_;
		this.myapi = api;
		this.is_music = buffer_.is_music;
		this.playbackRate = 1;
		this.pgended = true;			// for PhoneGap only: ended flag
		this.resume_me = false;			// make sure resumes when leaving suspend
		this.is_paused = false;
		this.resume_position = 0;		// for web audio api to resume from correct playback position
		this.looping = false;
		this.is_muted = false;
		this.is_silent = false;
		this.volume = 1;
		this.mutevol = 1;
		this.startTime = audRuntime.kahanTime.sum;
		this.gainNode = null;
		this.pannerNode = null;
		this.pannerEnabled = false;
		this.objectTracker = null;
		this.panX = 0;
		this.panY = 0;
		this.panAngle = 0;
		this.panConeInner = 0;
		this.panConeOuter = 0;
		this.panConeOuterGain = 0;
		this.instanceObject = null;
		var add_end_listener = false;
		if (this.myapi === API_WEBAUDIO && this.buffer.myapi === API_HTML5 && !this.buffer.supportWebAudioAPI)
			this.myapi = API_HTML5;
		switch (this.myapi) {
		case API_HTML5:
			if (this.is_music)
			{
				this.instanceObject = buffer_.bufferObject;
				add_end_listener = !buffer_.added_end_listener;
				buffer_.added_end_listener = true;
			}
			else
			{
				this.instanceObject = new Audio();
				this.instanceObject.autoplay = false;
				this.instanceObject.src = buffer_.bufferObject.src;
				add_end_listener = true;
			}
			if (add_end_listener)
			{
				this.instanceObject.addEventListener('ended', function () {
						audTag = self.tag;
						self.stopped = true;
						audRuntime.trigger(cr.plugins_.Audio.prototype.cnds.OnEnded, audInst);
				});
			}
			break;
		case API_WEBAUDIO:
			this.gainNode = createGain();
			this.gainNode["connect"](getDestinationForTag(tag_));
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				if (buffer_.bufferObject)
				{
					this.instanceObject = context["createBufferSource"]();
					this.instanceObject["buffer"] = buffer_.bufferObject;
					this.instanceObject["connect"](this.gainNode);
				}
			}
			else
			{
				this.instanceObject = this.buffer.bufferObject;		// reference the audio element
				this.buffer.outNode["connect"](this.gainNode);
			}
			break;
		case API_PHONEGAP:
			this.instanceObject = new window["Media"](appPath + this.src, null, null, function (status) {
					if (status === window["Media"]["MEDIA_STOPPED"])
					{
						self.pgended = true;
						self.stopped = true;
						audTag = self.tag;
						audRuntime.trigger(cr.plugins_.Audio.prototype.cnds.OnEnded, audInst);
					}
			});
			break;
		case API_APPMOBI:
			this.instanceObject = true;
			break;
		}
	};
	C2AudioInstance.prototype.hasEnded = function ()
	{
		switch (this.myapi) {
		case API_HTML5:
			return this.instanceObject.ended;
		case API_WEBAUDIO:
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				if (!this.fresh && !this.stopped && this.instanceObject["loop"])
					return false;
				if (this.is_paused)
					return false;
				return (audRuntime.kahanTime.sum - this.startTime) > this.buffer.bufferObject["duration"];
			}
			else
				return this.instanceObject.ended;
		case API_PHONEGAP:
			return this.pgended;
		case API_APPMOBI:
			true;	// recycling an AppMobi sound does not matter because it will just do another throwaway playSound
		}
		return true;
	};
	C2AudioInstance.prototype.canBeRecycled = function ()
	{
		if (this.fresh || this.stopped)
			return true;		// not yet used or is not playing
		return this.hasEnded();
	};
	C2AudioInstance.prototype.setPannerEnabled = function (enable_)
	{
		if (api !== API_WEBAUDIO)
			return;
		if (!this.pannerEnabled && enable_)
		{
			if (!this.gainNode)
				return;
			if (!this.pannerNode)
			{
				this.pannerNode = context["createPanner"]();
				if (typeof this.pannerNode["panningModel"] === "number")
					this.pannerNode["panningModel"] = panningModel;
				else
					this.pannerNode["panningModel"] = ["equalpower", "HRTF", "soundfield"][panningModel];
				if (typeof this.pannerNode["distanceModel"] === "number")
					this.pannerNode["distanceModel"] = distanceModel;
				else
					this.pannerNode["distanceModel"] = ["linear", "inverse", "exponential"][distanceModel];
				this.pannerNode["refDistance"] = refDistance;
				this.pannerNode["maxDistance"] = maxDistance;
				this.pannerNode["rolloffFactor"] = rolloffFactor;
			}
			this.gainNode["disconnect"]();
			this.gainNode["connect"](this.pannerNode);
			this.pannerNode["connect"](getDestinationForTag(this.tag));
			this.pannerEnabled = true;
		}
		else if (this.pannerEnabled && !enable_)
		{
			if (!this.gainNode)
				return;
			this.pannerNode["disconnect"]();
			this.gainNode["disconnect"]();
			this.gainNode["connect"](getDestinationForTag(this.tag));
			this.pannerEnabled = false;
		}
	};
	C2AudioInstance.prototype.setPan = function (x, y, angle, innerangle, outerangle, outergain)
	{
		if (!this.pannerEnabled || api !== API_WEBAUDIO)
			return;
		this.pannerNode["setPosition"](x, y, 0);
		this.pannerNode["setOrientation"](Math.cos(cr.to_radians(angle)), Math.sin(cr.to_radians(angle)), 0);
		this.pannerNode["coneInnerAngle"] = innerangle;
		this.pannerNode["coneOuterAngle"] = outerangle;
		this.pannerNode["coneOuterGain"] = outergain;
		this.panX = x;
		this.panY = y;
		this.panAngle = angle;
		this.panConeInner = innerangle;
		this.panConeOuter = outerangle;
		this.panConeOuterGain = outergain;
	};
	C2AudioInstance.prototype.setObject = function (o)
	{
		if (!this.pannerEnabled || api !== API_WEBAUDIO)
			return;
		if (!this.objectTracker)
			this.objectTracker = new ObjectTracker();
		this.objectTracker.setObject(o);
	};
	C2AudioInstance.prototype.tick = function (dt)
	{
		if (!this.pannerEnabled || api !== API_WEBAUDIO || !this.objectTracker || !this.objectTracker.hasObject() || !this.isPlaying())
		{
			return;
		}
		this.objectTracker.tick(dt);
		var inst = this.objectTracker.obj;
		var px = cr.rotatePtAround(inst.x, inst.y, -inst.layer.getAngle(), listenerX, listenerY, true);
		var py = cr.rotatePtAround(inst.x, inst.y, -inst.layer.getAngle(), listenerX, listenerY, false);
		this.pannerNode["setPosition"](px, py, 0);
		var a = 0;
		if (typeof this.objectTracker.obj.angle !== "undefined")
		{
			a = inst.angle - inst.layer.getAngle();
			this.pannerNode["setOrientation"](Math.cos(a), Math.sin(a), 0);
		}
		px = cr.rotatePtAround(this.objectTracker.getVelocityX(), this.objectTracker.getVelocityY(), -inst.layer.getAngle(), 0, 0, true);
		py = cr.rotatePtAround(this.objectTracker.getVelocityX(), this.objectTracker.getVelocityY(), -inst.layer.getAngle(), 0, 0, false);
		this.pannerNode["setVelocity"](px, py, 0);
	};
	C2AudioInstance.prototype.play = function (looping, vol, fromPosition)
	{
		var instobj = this.instanceObject;
		this.looping = looping;
		this.volume = vol;
		var seekPos = fromPosition || 0;
		switch (this.myapi) {
		case API_HTML5:
			if (instobj.playbackRate !== 1.0)
				instobj.playbackRate = 1.0;
			if (instobj.volume !== vol * masterVolume)
				instobj.volume = vol * masterVolume;
			if (instobj.loop !== looping)
				instobj.loop = looping;
			if (instobj.muted)
				instobj.muted = false;
			if (instobj.currentTime !== seekPos)
			{
				try {
					instobj.currentTime = seekPos;
				}
				catch (err)
				{
;
				}
			}
			if (this.is_music && isMusicWorkaround && !audRuntime.isInUserInputEvent)
				musicPlayNextTouch.push(this);
			else
			{
				try {
					this.instanceObject.play();
				}
				catch (e) {}	// sometimes throws on WP8.1... try not to kill the app
			}
			break;
		case API_WEBAUDIO:
			this.muted = false;
			this.mutevol = 1;
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				if (!this.fresh)
				{
					this.instanceObject = context["createBufferSource"]();
					this.instanceObject["buffer"] = this.buffer.bufferObject;
					this.instanceObject["connect"](this.gainNode);
				}
				this.instanceObject.loop = looping;
				this.gainNode["gain"]["value"] = vol * masterVolume;
				if (seekPos === 0)
					startSource(this.instanceObject);
				else
					startSourceAt(this.instanceObject, seekPos, this.getDuration());
			}
			else
			{
				if (instobj.playbackRate !== 1.0)
					instobj.playbackRate = 1.0;
				if (instobj.loop !== looping)
					instobj.loop = looping;
				this.gainNode["gain"]["value"] = vol * masterVolume;
				if (instobj.currentTime !== seekPos)
				{
					try {
						instobj.currentTime = seekPos;
					}
					catch (err)
					{
;
					}
				}
				if (this.is_music && isMusicWorkaround && !audRuntime.isInUserInputEvent)
					musicPlayNextTouch.push(this);
				else
					instobj.play();
			}
			break;
		case API_PHONEGAP:
			if ((!this.fresh && this.stopped) || seekPos !== 0)
				instobj["seekTo"](seekPos);
			instobj["play"]();
			this.pgended = false;
			break;
		case API_APPMOBI:
			if (audRuntime.isDirectCanvas)
				AppMobi["context"]["playSound"](this.src, looping);
			else
				AppMobi["player"]["playSound"](this.src, looping);
			break;
		}
		this.playbackRate = 1;
		this.startTime = audRuntime.kahanTime.sum - seekPos;
		this.fresh = false;
		this.stopped = false;
		this.is_paused = false;
	};
	C2AudioInstance.prototype.stop = function ()
	{
		switch (this.myapi) {
		case API_HTML5:
			if (!this.instanceObject.paused)
				this.instanceObject.pause();
			break;
		case API_WEBAUDIO:
			if (this.buffer.myapi === API_WEBAUDIO)
				stopSource(this.instanceObject);
			else
			{
				if (!this.instanceObject.paused)
					this.instanceObject.pause();
			}
			break;
		case API_PHONEGAP:
			this.instanceObject["stop"]();
			break;
		case API_APPMOBI:
			if (audRuntime.isDirectCanvas)
				AppMobi["context"]["stopSound"](this.src);
			break;
		}
		this.stopped = true;
		this.is_paused = false;
	};
	C2AudioInstance.prototype.pause = function ()
	{
		if (this.fresh || this.stopped || this.hasEnded() || this.is_paused)
			return;
		switch (this.myapi) {
		case API_HTML5:
			if (!this.instanceObject.paused)
				this.instanceObject.pause();
			break;
		case API_WEBAUDIO:
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				this.resume_position = this.getPlaybackTime();
				if (this.looping)
					this.resume_position = this.resume_position % this.getDuration();
				stopSource(this.instanceObject);
			}
			else
			{
				if (!this.instanceObject.paused)
					this.instanceObject.pause();
			}
			break;
		case API_PHONEGAP:
			this.instanceObject["pause"]();
			break;
		case API_APPMOBI:
			if (audRuntime.isDirectCanvas)
				AppMobi["context"]["stopSound"](this.src);
			break;
		}
		this.is_paused = true;
	};
	C2AudioInstance.prototype.resume = function ()
	{
		if (this.fresh || this.stopped || this.hasEnded() || !this.is_paused)
			return;
		switch (this.myapi) {
		case API_HTML5:
			this.instanceObject.play();
			break;
		case API_WEBAUDIO:
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				this.instanceObject = context["createBufferSource"]();
				this.instanceObject["buffer"] = this.buffer.bufferObject;
				this.instanceObject["connect"](this.gainNode);
				this.instanceObject.loop = this.looping;
				this.gainNode["gain"]["value"] = masterVolume * this.volume * this.mutevol;
				this.startTime = audRuntime.kahanTime.sum - this.resume_position;
				startSourceAt(this.instanceObject, this.resume_position, this.getDuration());
			}
			else
			{
				this.instanceObject.play();
			}
			break;
		case API_PHONEGAP:
			this.instanceObject["play"]();
			break;
		case API_APPMOBI:
			if (audRuntime.isDirectCanvas)
				AppMobi["context"]["resumeSound"](this.src);
			break;
		}
		this.is_paused = false;
	};
	C2AudioInstance.prototype.seek = function (pos)
	{
		if (this.fresh || this.stopped || this.hasEnded())
			return;
		switch (this.myapi) {
		case API_HTML5:
			try {
				this.instanceObject.currentTime = pos;
			}
			catch (e) {}
			break;
		case API_WEBAUDIO:
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				if (this.is_paused)
					this.resume_position = pos;
				else
				{
					this.pause();
					this.resume_position = pos;
					this.resume();
				}
			}
			else
			{
				try {
					this.instanceObject.currentTime = pos;
				}
				catch (e) {}
			}
			break;
		case API_PHONEGAP:
			break;
		case API_APPMOBI:
			if (audRuntime.isDirectCanvas)
				AppMobi["context"]["seekSound"](this.src, pos);
			break;
		}
	};
	C2AudioInstance.prototype.reconnect = function (toNode)
	{
		if (this.myapi !== API_WEBAUDIO)
			return;
		if (this.pannerEnabled)
		{
			this.pannerNode["disconnect"]();
			this.pannerNode["connect"](toNode);
		}
		else
		{
			this.gainNode["disconnect"]();
			this.gainNode["connect"](toNode);
		}
	};
	C2AudioInstance.prototype.getDuration = function ()
	{
		switch (this.myapi) {
		case API_HTML5:
			if (typeof this.instanceObject.duration !== "undefined")
				return this.instanceObject.duration;
			else
				return 0;
		case API_WEBAUDIO:
			return this.buffer.bufferObject["duration"];
		case API_PHONEGAP:
			return this.instanceObject["getDuration"]();
		case API_APPMOBI:
			if (audRuntime.isDirectCanvas)
				return AppMobi["context"]["getDurationSound"](this.src);
			else
				return 0;
		}
		return 0;
	};
	C2AudioInstance.prototype.getPlaybackTime = function ()
	{
		var duration = this.getDuration();
		var ret = 0;
		switch (this.myapi) {
		case API_HTML5:
			if (typeof this.instanceObject.currentTime !== "undefined")
				ret = this.instanceObject.currentTime;
			break;
		case API_WEBAUDIO:
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				if (this.is_paused)
					return this.resume_position;
				else
					ret = audRuntime.kahanTime.sum - this.startTime;
			}
			else if (typeof this.instanceObject.currentTime !== "undefined")
				ret = this.instanceObject.currentTime;
			break;
		case API_PHONEGAP:
			break;
		case API_APPMOBI:
			if (audRuntime.isDirectCanvas)
				ret = AppMobi["context"]["getPlaybackTimeSound"](this.src);
			break;
		}
		if (!this.looping && ret > duration)
			ret = duration;
		return ret;
	};
	C2AudioInstance.prototype.isPlaying = function ()
	{
		return !this.is_paused && !this.fresh && !this.stopped && !this.hasEnded();
	};
	C2AudioInstance.prototype.setVolume = function (v)
	{
		this.volume = v;
		this.updateVolume();
	};
	C2AudioInstance.prototype.updateVolume = function ()
	{
		var volToSet = this.volume * masterVolume;
		switch (this.myapi) {
		case API_HTML5:
			if (this.instanceObject.volume && this.instanceObject.volume !== volToSet)
				this.instanceObject.volume = volToSet;
			break;
		case API_WEBAUDIO:
			this.gainNode["gain"]["value"] = volToSet * this.mutevol;
			break;
		case API_PHONEGAP:
			break;
		case API_APPMOBI:
			break;
		}
	};
	C2AudioInstance.prototype.getVolume = function ()
	{
		return this.volume;
	};
	C2AudioInstance.prototype.doSetMuted = function (m)
	{
		switch (this.myapi) {
		case API_HTML5:
			if (this.instanceObject.muted !== !!m)
				this.instanceObject.muted = !!m;
			break;
		case API_WEBAUDIO:
			this.mutevol = (m ? 0 : 1);
			this.gainNode["gain"]["value"] = masterVolume * this.volume * this.mutevol;
			break;
		case API_PHONEGAP:
			break;
		case API_APPMOBI:
			break;
		}
	};
	C2AudioInstance.prototype.setMuted = function (m)
	{
		this.is_muted = !!m;
		this.doSetMuted(this.is_muted || this.is_silent);
	};
	C2AudioInstance.prototype.setSilent = function (m)
	{
		this.is_silent = !!m;
		this.doSetMuted(this.is_muted || this.is_silent);
	};
	C2AudioInstance.prototype.setLooping = function (l)
	{
		this.looping = l;
		switch (this.myapi) {
		case API_HTML5:
			if (this.instanceObject.loop !== !!l)
				this.instanceObject.loop = !!l;
			break;
		case API_WEBAUDIO:
			if (this.instanceObject.loop !== !!l)
				this.instanceObject.loop = !!l;
			break;
		case API_PHONEGAP:
			break;
		case API_APPMOBI:
			if (audRuntime.isDirectCanvas)
				AppMobi["context"]["setLoopingSound"](this.src, l);
			break;
		}
	};
	C2AudioInstance.prototype.setPlaybackRate = function (r)
	{
		this.playbackRate = r;
		this.updatePlaybackRate();
	};
	C2AudioInstance.prototype.updatePlaybackRate = function ()
	{
		var r = this.playbackRate;
		if ((timescale_mode === 1 && !this.is_music) || timescale_mode === 2)
			r *= audRuntime.timescale;
		switch (this.myapi) {
		case API_HTML5:
			if (this.instanceObject.playbackRate !== r)
				this.instanceObject.playbackRate = r;
			break;
		case API_WEBAUDIO:
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				if (this.instanceObject["playbackRate"]["value"] !== r)
					this.instanceObject["playbackRate"]["value"] = r;
			}
			else
			{
				if (this.instanceObject.playbackRate !== r)
					this.instanceObject.playbackRate = r;
			}
			break;
		case API_PHONEGAP:
			break;
		case API_APPMOBI:
			break;
		}
	};
	C2AudioInstance.prototype.setSuspended = function (s)
	{
		switch (this.myapi) {
		case API_HTML5:
			if (s)
			{
				if (this.isPlaying())
				{
					this.instanceObject["pause"]();
					this.resume_me = true;
				}
				else
					this.resume_me = false;
			}
			else
			{
				if (this.resume_me)
					this.instanceObject["play"]();
			}
			break;
		case API_WEBAUDIO:
			if (s)
			{
				if (this.isPlaying())
				{
					if (this.buffer.myapi === API_WEBAUDIO)
					{
						this.resume_position = this.getPlaybackTime();
						if (this.looping)
							this.resume_position = this.resume_position % this.getDuration();
						stopSource(this.instanceObject);
					}
					else
						this.instanceObject["pause"]();
					this.resume_me = true;
				}
				else
					this.resume_me = false;
			}
			else
			{
				if (this.resume_me)
				{
					if (this.buffer.myapi === API_WEBAUDIO)
					{
						this.instanceObject = context["createBufferSource"]();
						this.instanceObject["buffer"] = this.buffer.bufferObject;
						this.instanceObject["connect"](this.gainNode);
						this.instanceObject.loop = this.looping;
						this.gainNode["gain"]["value"] = masterVolume * this.volume * this.mutevol;
						this.startTime = audRuntime.kahanTime.sum - this.resume_position;
						startSourceAt(this.instanceObject, this.resume_position, this.getDuration());
					}
					else
					{
						this.instanceObject["play"]();
					}
				}
			}
			break;
		case API_PHONEGAP:
			if (s)
			{
				if (this.isPlaying())
				{
					this.instanceObject["pause"]();
					this.resume_me = true;
				}
				else
					this.resume_me = false;
			}
			else
			{
				if (this.resume_me)
					this.instanceObject["play"]();
			}
			break;
		case API_APPMOBI:
			break;
		}
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
		audRuntime = this.runtime;
		audInst = this;
		this.listenerTracker = null;
		this.listenerZ = -600;
		if ((this.runtime.isiOS || (this.runtime.isAndroid && (this.runtime.isChrome || this.runtime.isAndroidStockBrowser))) && !this.runtime.isCrosswalk && !this.runtime.isDomFree)
		{
			isMusicWorkaround = true;
		}
		context = null;
		if (typeof AudioContext !== "undefined")
		{
			api = API_WEBAUDIO;
			context = new AudioContext();
		}
		else if (typeof webkitAudioContext !== "undefined")
		{
			api = API_WEBAUDIO;
			context = new webkitAudioContext();
		}
		if ((this.runtime.isiOS && api === API_WEBAUDIO) || isMusicWorkaround)
		{
			document.addEventListener("touchstart", function ()
			{
				var i, len, m;
				if (!iOShadtouch && context)
				{
					var buffer = context["createBuffer"](1, 1, 22050);
					var source = context["createBufferSource"]();
					source["buffer"] = buffer;
					source["connect"](context["destination"]);
					startSource(source);
					iOShadtouch = true;
				}
				if (isMusicWorkaround)
				{
					if (!silent)
					{
						for (i = 0, len = musicPlayNextTouch.length; i < len; ++i)
						{
							m = musicPlayNextTouch[i];
							if (!m.stopped && !m.is_paused)
								m.instanceObject.play();
						}
					}
					musicPlayNextTouch.length = 0;
				}
			}, true);
		}
		if (api !== API_WEBAUDIO)
		{
			if (this.runtime.isPhoneGap)
				api = API_PHONEGAP;
			else if (this.runtime.isAppMobi)
				api = API_APPMOBI;
		}
		if (api === API_PHONEGAP)
		{
			appPath = location.href;
			var i = appPath.lastIndexOf("/");
			if (i > -1)
				appPath = appPath.substr(0, i + 1);
			appPath = appPath.replace("file://", "");
		}
		if (this.runtime.isSafari && this.runtime.isWindows && typeof Audio === "undefined")
		{
			alert("It looks like you're using Safari for Windows without Quicktime.  Audio cannot be played until Quicktime is installed.");
			this.runtime.DestroyInstance(this);
		}
		else
		{
			if (this.runtime.isDirectCanvas)
				useOgg = this.runtime.isAndroid;		// AAC on iOS, OGG on Android
			else
			{
				try {
					useOgg = !!(new Audio().canPlayType('audio/ogg; codecs="vorbis"'));
				}
				catch (e)
				{
					useOgg = false;
				}
			}
			switch (api) {
			case API_HTML5:
;
				break;
			case API_WEBAUDIO:
;
				break;
			case API_PHONEGAP:
;
				break;
			case API_APPMOBI:
;
				break;
			default:
;
			}
			this.runtime.tickMe(this);
		}
	};
	var instanceProto = pluginProto.Instance.prototype;
	instanceProto.onCreate = function ()
	{
		timescale_mode = this.properties[0];	// 0 = off, 1 = sounds only, 2 = all
		this.saveload = this.properties[1];		// 0 = all, 1 = sounds only, 2 = music only, 3 = none
		panningModel = this.properties[2];		// 0 = equalpower, 1 = hrtf, 3 = soundfield
		distanceModel = this.properties[3];		// 0 = linear, 1 = inverse, 2 = exponential
		this.listenerZ = -this.properties[4];
		refDistance = this.properties[5];
		maxDistance = this.properties[6];
		rolloffFactor = this.properties[7];
		this.listenerTracker = new ObjectTracker();
		if (api === API_WEBAUDIO)
		{
			context["listener"]["speedOfSound"] = this.properties[8];
			context["listener"]["dopplerFactor"] = this.properties[9];
			context["listener"]["setPosition"](this.runtime.draw_width / 2, this.runtime.draw_height / 2, this.listenerZ);
			context["listener"]["setOrientation"](0, 0, 1, 0, -1, 0);
			window["c2OnAudioMicStream"] = function (localMediaStream, tag)
			{
				if (micSource)
					micSource["disconnect"]();
				micTag = tag.toLowerCase();
				micSource = context["createMediaStreamSource"](localMediaStream);
				micSource["connect"](getDestinationForTag(micTag));
			};
		}
		this.runtime.addSuspendCallback(function(s)
		{
			audInst.onSuspend(s);
		});
		var self = this;
		this.runtime.addDestroyCallback(function (inst)
		{
			self.onInstanceDestroyed(inst);
		});
	};
	instanceProto.onInstanceDestroyed = function (inst)
	{
		var i, len, a;
		for (i = 0, len = audioInstances.length; i < len; i++)
		{
			a = audioInstances[i];
			if (a.objectTracker)
			{
				if (a.objectTracker.obj === inst)
				{
					a.objectTracker.obj = null;
					if (a.pannerEnabled && a.isPlaying() && a.looping)
						a.stop();
				}
			}
		}
		if (this.listenerTracker.obj === inst)
			this.listenerTracker.obj = null;
	};
	instanceProto.saveToJSON = function ()
	{
		var o = {
			"silent": silent,
			"masterVolume": masterVolume,
			"listenerZ": this.listenerZ,
			"listenerUid": this.listenerTracker.hasObject() ? this.listenerTracker.obj.uid : -1,
			"playing": [],
			"effects": {}
		};
		var playingarr = o["playing"];
		var i, len, a, d, p, panobj, playbackTime;
		for (i = 0, len = audioInstances.length; i < len; i++)
		{
			a = audioInstances[i];
			if (!a.isPlaying())
				continue;				// no need to save stopped sounds
			if (this.saveload === 3)	// not saving/loading any sounds/music
				continue;
			if (a.is_music && this.saveload === 1)	// not saving/loading music
				continue;
			if (!a.is_music && this.saveload === 2)	// not saving/loading sound
				continue;
			playbackTime = a.getPlaybackTime();
			if (a.looping)
				playbackTime = playbackTime % a.getDuration();
			d = {
				"tag": a.tag,
				"buffersrc": a.buffer.src,
				"is_music": a.is_music,
				"playbackTime": playbackTime,
				"volume": a.volume,
				"looping": a.looping,
				"muted": a.is_muted,
				"playbackRate": a.playbackRate,
				"paused": a.is_paused,
				"resume_position": a.resume_position
			};
			if (a.pannerEnabled)
			{
				d["pan"] = {};
				panobj = d["pan"];
				if (a.objectTracker && a.objectTracker.hasObject())
				{
					panobj["objUid"] = a.objectTracker.obj.uid;
				}
				else
				{
					panobj["x"] = a.panX;
					panobj["y"] = a.panY;
					panobj["a"] = a.panAngle;
				}
				panobj["ia"] = a.panConeInner;
				panobj["oa"] = a.panConeOuter;
				panobj["og"] = a.panConeOuterGain;
			}
			playingarr.push(d);
		}
		var fxobj = o["effects"];
		var fxarr;
		for (p in effects)
		{
			if (effects.hasOwnProperty(p))
			{
				fxarr = [];
				for (i = 0, len = effects[p].length; i < len; i++)
				{
					fxarr.push({ "type": effects[p][i].type, "params": effects[p][i].params });
				}
				fxobj[p] = fxarr;
			}
		}
		return o;
	};
	var objectTrackerUidsToLoad = [];
	instanceProto.loadFromJSON = function (o)
	{
		var setSilent = o["silent"];
		masterVolume = o["masterVolume"];
		this.listenerZ = o["listenerZ"];
		this.listenerTracker.setObject(null);
		var listenerUid = o["listenerUid"];
		if (listenerUid !== -1)
		{
			this.listenerTracker.loadUid = listenerUid;
			objectTrackerUidsToLoad.push(this.listenerTracker);
		}
		var playingarr = o["playing"];
		var i, len, d, src, is_music, tag, playbackTime, looping, vol, b, a, p, pan, panObjUid;
		if (this.saveload !== 3)
		{
			for (i = 0, len = audioInstances.length; i < len; i++)
			{
				a = audioInstances[i];
				if (a.is_music && this.saveload === 1)
					continue;		// only saving/loading sound: leave music playing
				if (!a.is_music && this.saveload === 2)
					continue;		// only saving/loading music: leave sound playing
				a.stop();
			}
		}
		var fxarr, fxtype, fxparams, fx;
		for (p in effects)
		{
			if (effects.hasOwnProperty(p))
			{
				for (i = 0, len = effects[p].length; i < len; i++)
					effects[p][i].remove();
			}
		}
		cr.wipe(effects);
		for (p in o["effects"])
		{
			if (o["effects"].hasOwnProperty(p))
			{
				fxarr = o["effects"][p];
				for (i = 0, len = fxarr.length; i < len; i++)
				{
					fxtype = fxarr[i]["type"];
					fxparams = fxarr[i]["params"];
					switch (fxtype) {
					case "filter":
						addEffectForTag(p, new FilterEffect(fxparams[0], fxparams[1], fxparams[2], fxparams[3], fxparams[4], fxparams[5]));
						break;
					case "delay":
						addEffectForTag(p, new DelayEffect(fxparams[0], fxparams[1], fxparams[2]));
						break;
					case "convolve":
						src = fxparams[2];
						b = this.getAudioBuffer(src, false);
						if (b.bufferObject)
						{
							fx = new ConvolveEffect(b.bufferObject, fxparams[0], fxparams[1], src);
						}
						else
						{
							fx = new ConvolveEffect(null, fxparams[0], fxparams[1], src);
							b.normalizeWhenReady = fxparams[0];
							b.convolveWhenReady = fx;
						}
						addEffectForTag(p, fx);
						break;
					case "flanger":
						addEffectForTag(p, new FlangerEffect(fxparams[0], fxparams[1], fxparams[2], fxparams[3], fxparams[4]));
						break;
					case "phaser":
						addEffectForTag(p, new PhaserEffect(fxparams[0], fxparams[1], fxparams[2], fxparams[3], fxparams[4], fxparams[5]));
						break;
					case "gain":
						addEffectForTag(p, new GainEffect(fxparams[0]));
						break;
					case "tremolo":
						addEffectForTag(p, new TremoloEffect(fxparams[0], fxparams[1]));
						break;
					case "ringmod":
						addEffectForTag(p, new RingModulatorEffect(fxparams[0], fxparams[1]));
						break;
					case "distortion":
						addEffectForTag(p, new DistortionEffect(fxparams[0], fxparams[1], fxparams[2], fxparams[3], fxparams[4]));
						break;
					case "compressor":
						addEffectForTag(p, new CompressorEffect(fxparams[0], fxparams[1], fxparams[2], fxparams[3], fxparams[4]));
						break;
					case "analyser":
						addEffectForTag(p, new AnalyserEffect(fxparams[0], fxparams[1]));
						break;
					}
				}
			}
		}
		for (i = 0, len = playingarr.length; i < len; i++)
		{
			if (this.saveload === 3)	// not saving/loading any sounds/music
				continue;
			d = playingarr[i];
			src = d["buffersrc"];
			is_music = d["is_music"];
			tag = d["tag"];
			playbackTime = d["playbackTime"];
			looping = d["looping"];
			vol = d["volume"];
			pan = d["pan"];
			panObjUid = (pan && pan.hasOwnProperty("objUid")) ? pan["objUid"] : -1;
			if (is_music && this.saveload === 1)	// not saving/loading music
				continue;
			if (!is_music && this.saveload === 2)	// not saving/loading sound
				continue;
			a = this.getAudioInstance(src, tag, is_music, looping, vol);
			if (!a)
			{
				b = this.getAudioBuffer(src, is_music);
				b.seekWhenReady = playbackTime;
				b.pauseWhenReady = d["paused"];
				if (pan)
				{
					if (panObjUid !== -1)
					{
						b.panWhenReady.push({ objUid: panObjUid, ia: pan["ia"], oa: pan["oa"], og: pan["og"], thistag: tag });
					}
					else
					{
						b.panWhenReady.push({ x: pan["x"], y: pan["y"], a: pan["a"], ia: pan["ia"], oa: pan["oa"], og: pan["og"], thistag: tag });
					}
				}
				continue;
			}
			a.resume_position = d["resume_position"];
			a.setPannerEnabled(!!pan);
			a.play(looping, vol, playbackTime);
			a.updatePlaybackRate();
			a.updateVolume();
			a.doSetMuted(a.is_muted || a.is_silent);
			if (d["paused"])
				a.pause();
			if (d["muted"])
				a.setMuted(true);
			a.doSetMuted(a.is_muted || a.is_silent);
			if (pan)
			{
				if (panObjUid !== -1)
				{
					a.objectTracker = a.objectTracker || new ObjectTracker();
					a.objectTracker.loadUid = panObjUid;
					objectTrackerUidsToLoad.push(a.objectTracker);
				}
				else
				{
					a.setPan(pan["x"], pan["y"], pan["a"], pan["ia"], pan["oa"], pan["og"]);
				}
			}
		}
		if (setSilent && !silent)			// setting silent
		{
			for (i = 0, len = audioInstances.length; i < len; i++)
				audioInstances[i].setSilent(true);
			silent = true;
		}
		else if (!setSilent && silent)		// setting not silent
		{
			for (i = 0, len = audioInstances.length; i < len; i++)
				audioInstances[i].setSilent(false);
			silent = false;
		}
	};
	instanceProto.afterLoad = function ()
	{
		var i, len, ot, inst;
		for (i = 0, len = objectTrackerUidsToLoad.length; i < len; i++)
		{
			ot = objectTrackerUidsToLoad[i];
			inst = this.runtime.getObjectByUID(ot.loadUid);
			ot.setObject(inst);
			ot.loadUid = -1;
			if (inst)
			{
				listenerX = inst.x;
				listenerY = inst.y;
			}
		}
		objectTrackerUidsToLoad.length = 0;
	};
	instanceProto.onSuspend = function (s)
	{
		var i, len;
		for (i = 0, len = audioInstances.length; i < len; i++)
			audioInstances[i].setSuspended(s);
	};
	instanceProto.tick = function ()
	{
		var dt = this.runtime.dt;
		var i, len, a;
		for (i = 0, len = audioInstances.length; i < len; i++)
		{
			a = audioInstances[i];
			a.tick(dt);
			if (a.myapi !== API_HTML5 && a.myapi !== API_APPMOBI)
			{
				if (!a.fresh && !a.stopped && a.hasEnded())
				{
					a.stopped = true;
					audTag = a.tag;
					audRuntime.trigger(cr.plugins_.Audio.prototype.cnds.OnEnded, audInst);
				}
			}
			if (timescale_mode !== 0)
				a.updatePlaybackRate();
		}
		var p, arr, f;
		for (p in effects)
		{
			if (effects.hasOwnProperty(p))
			{
				arr = effects[p];
				for (i = 0, len = arr.length; i < len; i++)
				{
					f = arr[i];
					if (f.tick)
						f.tick();
				}
			}
		}
		if (api === API_WEBAUDIO && this.listenerTracker.hasObject())
		{
			this.listenerTracker.tick(dt);
			listenerX = this.listenerTracker.obj.x;
			listenerY = this.listenerTracker.obj.y;
			context["listener"]["setPosition"](this.listenerTracker.obj.x, this.listenerTracker.obj.y, this.listenerZ);
			context["listener"]["setVelocity"](this.listenerTracker.getVelocityX(), this.listenerTracker.getVelocityY(), 0);
		}
	};
	instanceProto.getAudioBuffer = function (src_, is_music)
	{
		var i, len, a, ret = null, j, k, lenj, ai;
		for (i = 0, len = audioBuffers.length; i < len; i++)
		{
			a = audioBuffers[i];
			if (a.src === src_)
			{
				ret = a;
				break;
			}
		}
		if (!ret)
		{
			ret = new C2AudioBuffer(src_, is_music);
			audioBuffers.push(ret);
		}
		return ret;
	};
	instanceProto.getAudioInstance = function (src_, tag, is_music, looping, vol)
	{
		var i, len, a;
		for (i = 0, len = audioInstances.length; i < len; i++)
		{
			a = audioInstances[i];
			if (a.src === src_ && (a.canBeRecycled() || is_music))
			{
				a.tag = tag;
				return a;
			}
		}
		var b = this.getAudioBuffer(src_, is_music);
		if (!b.bufferObject)
		{
			if (tag !== "<preload>")
			{
				b.playTagWhenReady = tag;
				b.loopWhenReady = looping;
				b.volumeWhenReady = vol;
			}
			return null;
		}
		a = new C2AudioInstance(b, tag);
		audioInstances.push(a);
		return a;
	};
	var taggedAudio = [];
	function getAudioByTag(tag)
	{
		taggedAudio.length = 0;
		if (!tag.length)
		{
			if (!lastAudio || lastAudio.hasEnded())
				return;
			else
			{
				taggedAudio.length = 1;
				taggedAudio[0] = lastAudio;
				return;
			}
		}
		var i, len, a;
		for (i = 0, len = audioInstances.length; i < len; i++)
		{
			a = audioInstances[i];
			if (cr.equals_nocase(tag, a.tag))
				taggedAudio.push(a);
		}
	};
	function reconnectEffects(tag)
	{
		var i, len, arr, n, toNode = context["destination"];
		if (effects.hasOwnProperty(tag))
		{
			arr = effects[tag];
			if (arr.length)
			{
				toNode = arr[0].getInputNode();
				for (i = 0, len = arr.length; i < len; i++)
				{
					n = arr[i];
					if (i + 1 === len)
						n.connectTo(context["destination"]);
					else
						n.connectTo(arr[i + 1].getInputNode());
				}
			}
		}
		getAudioByTag(tag);
		for (i = 0, len = taggedAudio.length; i < len; i++)
			taggedAudio[i].reconnect(toNode);
		if (micSource && micTag === tag)
		{
			micSource["disconnect"]();
			micSource["connect"](toNode);
		}
	};
	function addEffectForTag(tag, fx)
	{
		if (!effects.hasOwnProperty(tag))
			effects[tag] = [fx];
		else
			effects[tag].push(fx);
		reconnectEffects(tag);
	};
	function Cnds() {};
	Cnds.prototype.OnEnded = function (t)
	{
		return cr.equals_nocase(audTag, t);
	};
	Cnds.prototype.PreloadsComplete = function ()
	{
		var i, len;
		for (i = 0, len = audioBuffers.length; i < len; i++)
		{
			if (!audioBuffers[i].isLoaded())
				return false;
		}
		return true;
	};
	Cnds.prototype.AdvancedAudioSupported = function ()
	{
		return api === API_WEBAUDIO;
	};
	Cnds.prototype.IsSilent = function ()
	{
		return silent;
	};
	Cnds.prototype.IsAnyPlaying = function ()
	{
		var i, len;
		for (i = 0, len = audioInstances.length; i < len; i++)
		{
			if (audioInstances[i].isPlaying())
				return true;
		}
		return false;
	};
	Cnds.prototype.IsTagPlaying = function (tag)
	{
		getAudioByTag(tag);
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
		{
			if (taggedAudio[i].isPlaying())
				return true;
		}
		return false;
	};
	pluginProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.Play = function (file, looping, vol, tag)
	{
		if (silent)
			return;
		var v = dbToLinear(vol);
		var is_music = file[1];
		var src = this.runtime.files_subfolder + file[0] + (useOgg ? ".ogg" : ".m4a");
		lastAudio = this.getAudioInstance(src, tag, is_music, looping!==0, v);
		if (!lastAudio)
			return;
		lastAudio.setPannerEnabled(false);
		lastAudio.play(looping!==0, v);
	};
	Acts.prototype.PlayAtPosition = function (file, looping, vol, x_, y_, angle_, innerangle_, outerangle_, outergain_, tag)
	{
		if (silent)
			return;
		var v = dbToLinear(vol);
		var is_music = file[1];
		var src = this.runtime.files_subfolder + file[0] + (useOgg ? ".ogg" : ".m4a");
		lastAudio = this.getAudioInstance(src, tag, is_music, looping!==0, v);
		if (!lastAudio)
		{
			var b = this.getAudioBuffer(src, is_music);
			b.panWhenReady.push({ x: x_, y: y_, a: angle_, ia: innerangle_, oa: outerangle_, og: dbToLinear(outergain_), thistag: tag });
			return;
		}
		lastAudio.setPannerEnabled(true);
		lastAudio.setPan(x_, y_, angle_, innerangle_, outerangle_, dbToLinear(outergain_));
		lastAudio.play(looping!==0, v);
	};
	Acts.prototype.PlayAtObject = function (file, looping, vol, obj, innerangle, outerangle, outergain, tag)
	{
		if (silent || !obj)
			return;
		var inst = obj.getFirstPicked();
		if (!inst)
			return;
		var v = dbToLinear(vol);
		var is_music = file[1];
		var src = this.runtime.files_subfolder + file[0] + (useOgg ? ".ogg" : ".m4a");
		lastAudio = this.getAudioInstance(src, tag, is_music, looping!==0, v);
		if (!lastAudio)
		{
			var b = this.getAudioBuffer(src, is_music);
			b.panWhenReady.push({ obj: inst, ia: innerangle, oa: outerangle, og: dbToLinear(outergain), thistag: tag });
			return;
		}
		lastAudio.setPannerEnabled(true);
		var px = cr.rotatePtAround(inst.x, inst.y, -inst.layer.getAngle(), listenerX, listenerY, true);
		var py = cr.rotatePtAround(inst.x, inst.y, -inst.layer.getAngle(), listenerX, listenerY, false);
		lastAudio.setPan(px, py, cr.to_degrees(inst.angle - inst.layer.getAngle()), innerangle, outerangle, dbToLinear(outergain));
		lastAudio.setObject(inst);
		lastAudio.play(looping!==0, v);
	};
	Acts.prototype.PlayByName = function (folder, filename, looping, vol, tag)
	{
		if (silent)
			return;
		var v = dbToLinear(vol);
		var is_music = (folder === 1);
		var src = this.runtime.files_subfolder + filename.toLowerCase() + (useOgg ? ".ogg" : ".m4a");
		lastAudio = this.getAudioInstance(src, tag, is_music, looping!==0, v);
		if (!lastAudio)
			return;
		lastAudio.setPannerEnabled(false);
		lastAudio.play(looping!==0, v);
	};
	Acts.prototype.PlayAtPositionByName = function (folder, filename, looping, vol, x_, y_, angle_, innerangle_, outerangle_, outergain_, tag)
	{
		if (silent)
			return;
		var v = dbToLinear(vol);
		var is_music = (folder === 1);
		var src = this.runtime.files_subfolder + filename.toLowerCase() + (useOgg ? ".ogg" : ".m4a");
		lastAudio = this.getAudioInstance(src, tag, is_music, looping!==0, v);
		if (!lastAudio)
		{
			var b = this.getAudioBuffer(src, is_music);
			b.panWhenReady.push({ x: x_, y: y_, a: angle_, ia: innerangle_, oa: outerangle_, og: dbToLinear(outergain_), thistag: tag });
			return;
		}
		lastAudio.setPannerEnabled(true);
		lastAudio.setPan(x_, y_, angle_, innerangle_, outerangle_, dbToLinear(outergain_));
		lastAudio.play(looping!==0, v);
	};
	Acts.prototype.PlayAtObjectByName = function (folder, filename, looping, vol, obj, innerangle, outerangle, outergain, tag)
	{
		if (silent || !obj)
			return;
		var inst = obj.getFirstPicked();
		if (!inst)
			return;
		var v = dbToLinear(vol);
		var is_music = (folder === 1);
		var src = this.runtime.files_subfolder + filename.toLowerCase() + (useOgg ? ".ogg" : ".m4a");
		lastAudio = this.getAudioInstance(src, tag, is_music, looping!==0, v);
		if (!lastAudio)
		{
			var b = this.getAudioBuffer(src, is_music);
			b.panWhenReady.push({ obj: inst, ia: innerangle, oa: outerangle, og: dbToLinear(outergain), thistag: tag });
			return;
		}
		lastAudio.setPannerEnabled(true);
		var px = cr.rotatePtAround(inst.x, inst.y, -inst.layer.getAngle(), listenerX, listenerY, true);
		var py = cr.rotatePtAround(inst.x, inst.y, -inst.layer.getAngle(), listenerX, listenerY, false);
		lastAudio.setPan(px, py, cr.to_degrees(inst.angle - inst.layer.getAngle()), innerangle, outerangle, dbToLinear(outergain));
		lastAudio.setObject(inst);
		lastAudio.play(looping!==0, v);
	};
	Acts.prototype.SetLooping = function (tag, looping)
	{
		getAudioByTag(tag);
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
			taggedAudio[i].setLooping(looping === 0);
	};
	Acts.prototype.SetMuted = function (tag, muted)
	{
		getAudioByTag(tag);
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
			taggedAudio[i].setMuted(muted === 0);
	};
	Acts.prototype.SetVolume = function (tag, vol)
	{
		getAudioByTag(tag);
		var v = dbToLinear(vol);
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
			taggedAudio[i].setVolume(v);
	};
	Acts.prototype.Preload = function (file)
	{
		if (silent)
			return;
		var is_music = file[1];
		var src = this.runtime.files_subfolder + file[0] + (useOgg ? ".ogg" : ".m4a");
		if (api === API_APPMOBI)
		{
			if (this.runtime.isDirectCanvas)
				AppMobi["context"]["loadSound"](src);
			else
				AppMobi["player"]["loadSound"](src);
			return;
		}
		else if (api === API_PHONEGAP)
		{
			return;
		}
		this.getAudioInstance(src, "<preload>", is_music, false);
	};
	Acts.prototype.PreloadByName = function (folder, filename)
	{
		if (silent)
			return;
		var is_music = (folder === 1);
		var src = this.runtime.files_subfolder + filename.toLowerCase() + (useOgg ? ".ogg" : ".m4a");
		if (api === API_APPMOBI)
		{
			if (this.runtime.isDirectCanvas)
				AppMobi["context"]["loadSound"](src);
			else
				AppMobi["player"]["loadSound"](src);
			return;
		}
		else if (api === API_PHONEGAP)
		{
			return;
		}
		this.getAudioInstance(src, "<preload>", is_music, false);
	};
	Acts.prototype.SetPlaybackRate = function (tag, rate)
	{
		getAudioByTag(tag);
		if (rate < 0.0)
			rate = 0;
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
			taggedAudio[i].setPlaybackRate(rate);
	};
	Acts.prototype.Stop = function (tag)
	{
		getAudioByTag(tag);
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
			taggedAudio[i].stop();
	};
	Acts.prototype.StopAll = function ()
	{
		var i, len;
		for (i = 0, len = audioInstances.length; i < len; i++)
			audioInstances[i].stop();
	};
	Acts.prototype.SetPaused = function (tag, state)
	{
		getAudioByTag(tag);
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
		{
			if (state === 0)
				taggedAudio[i].pause();
			else
				taggedAudio[i].resume();
		}
	};
	Acts.prototype.Seek = function (tag, pos)
	{
		getAudioByTag(tag);
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
		{
			taggedAudio[i].seek(pos);
		}
	};
	Acts.prototype.SetSilent = function (s)
	{
		var i, len;
		if (s === 2)					// toggling
			s = (silent ? 1 : 0);		// choose opposite state
		if (s === 0 && !silent)			// setting silent
		{
			for (i = 0, len = audioInstances.length; i < len; i++)
				audioInstances[i].setSilent(true);
			silent = true;
		}
		else if (s === 1 && silent)		// setting not silent
		{
			for (i = 0, len = audioInstances.length; i < len; i++)
				audioInstances[i].setSilent(false);
			silent = false;
		}
	};
	Acts.prototype.SetMasterVolume = function (vol)
	{
		masterVolume = dbToLinear(vol);
		var i, len;
		for (i = 0, len = audioInstances.length; i < len; i++)
			audioInstances[i].updateVolume();
	};
	Acts.prototype.AddFilterEffect = function (tag, type, freq, detune, q, gain, mix)
	{
		if (api !== API_WEBAUDIO || type < 0 || type >= filterTypes.length || !context["createBiquadFilter"])
			return;
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		addEffectForTag(tag, new FilterEffect(type, freq, detune, q, gain, mix));
	};
	Acts.prototype.AddDelayEffect = function (tag, delay, gain, mix)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		addEffectForTag(tag, new DelayEffect(delay, dbToLinear(gain), mix));
	};
	Acts.prototype.AddFlangerEffect = function (tag, delay, modulation, freq, feedback, mix)
	{
		if (api !== API_WEBAUDIO || !context["createOscillator"])
			return;
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		addEffectForTag(tag, new FlangerEffect(delay / 1000, modulation / 1000, freq, feedback / 100, mix));
	};
	Acts.prototype.AddPhaserEffect = function (tag, freq, detune, q, mod, modfreq, mix)
	{
		if (api !== API_WEBAUDIO || !context["createOscillator"])
			return;
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		addEffectForTag(tag, new PhaserEffect(freq, detune, q, mod, modfreq, mix));
	};
	Acts.prototype.AddConvolutionEffect = function (tag, file, norm, mix)
	{
		if (api !== API_WEBAUDIO || !context["createConvolver"])
			return;
		var doNormalize = (norm === 0);
		var src = this.runtime.files_subfolder + file[0] + (useOgg ? ".ogg" : ".m4a");
		var b = this.getAudioBuffer(src, false);
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		var fx;
		if (b.bufferObject)
		{
			fx = new ConvolveEffect(b.bufferObject, doNormalize, mix, src);
		}
		else
		{
			fx = new ConvolveEffect(null, doNormalize, mix, src);
			b.normalizeWhenReady = doNormalize;
			b.convolveWhenReady = fx;
		}
		addEffectForTag(tag, fx);
	};
	Acts.prototype.AddGainEffect = function (tag, g)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		addEffectForTag(tag, new GainEffect(dbToLinear(g)));
	};
	Acts.prototype.AddMuteEffect = function (tag)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		addEffectForTag(tag, new GainEffect(0));	// re-use gain effect with 0 gain
	};
	Acts.prototype.AddTremoloEffect = function (tag, freq, mix)
	{
		if (api !== API_WEBAUDIO || !context["createOscillator"])
			return;
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		addEffectForTag(tag, new TremoloEffect(freq, mix));
	};
	Acts.prototype.AddRingModEffect = function (tag, freq, mix)
	{
		if (api !== API_WEBAUDIO || !context["createOscillator"])
			return;
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		addEffectForTag(tag, new RingModulatorEffect(freq, mix));
	};
	Acts.prototype.AddDistortionEffect = function (tag, threshold, headroom, drive, makeupgain, mix)
	{
		if (api !== API_WEBAUDIO || !context["createWaveShaper"])
			return;
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		addEffectForTag(tag, new DistortionEffect(threshold, headroom, drive, makeupgain, mix));
	};
	Acts.prototype.AddCompressorEffect = function (tag, threshold, knee, ratio, attack, release)
	{
		if (api !== API_WEBAUDIO || !context["createDynamicsCompressor"])
			return;
		tag = tag.toLowerCase();
		addEffectForTag(tag, new CompressorEffect(threshold, knee, ratio, attack / 1000, release / 1000));
	};
	Acts.prototype.AddAnalyserEffect = function (tag, fftSize, smoothing)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		addEffectForTag(tag, new AnalyserEffect(fftSize, smoothing));
	};
	Acts.prototype.RemoveEffects = function (tag)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		var i, len, arr;
		if (effects.hasOwnProperty(tag))
		{
			arr = effects[tag];
			if (arr.length)
			{
				for (i = 0, len = arr.length; i < len; i++)
					arr[i].remove();
				arr.length = 0;
				reconnectEffects(tag);
			}
		}
	};
	Acts.prototype.SetEffectParameter = function (tag, index, param, value, ramp, time)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		index = Math.floor(index);
		var arr;
		if (!effects.hasOwnProperty(tag))
			return;
		arr = effects[tag];
		if (index < 0 || index >= arr.length)
			return;
		arr[index].setParam(param, value, ramp, time);
	};
	Acts.prototype.SetListenerObject = function (obj_)
	{
		if (!obj_ || api !== API_WEBAUDIO)
			return;
		var inst = obj_.getFirstPicked();
		if (!inst)
			return;
		this.listenerTracker.setObject(inst);
		listenerX = inst.x;
		listenerY = inst.y;
	};
	Acts.prototype.SetListenerZ = function (z)
	{
		this.listenerZ = z;
	};
	pluginProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.Duration = function (ret, tag)
	{
		getAudioByTag(tag);
		if (taggedAudio.length)
			ret.set_float(taggedAudio[0].getDuration());
		else
			ret.set_float(0);
	};
	Exps.prototype.PlaybackTime = function (ret, tag)
	{
		getAudioByTag(tag);
		if (taggedAudio.length)
			ret.set_float(taggedAudio[0].getPlaybackTime());
		else
			ret.set_float(0);
	};
	Exps.prototype.Volume = function (ret, tag)
	{
		getAudioByTag(tag);
		if (taggedAudio.length)
		{
			var v = taggedAudio[0].getVolume();
			ret.set_float(linearToDb(v));
		}
		else
			ret.set_float(0);
	};
	Exps.prototype.MasterVolume = function (ret)
	{
		ret.set_float(masterVolume);
	};
	Exps.prototype.EffectCount = function (ret, tag)
	{
		tag = tag.toLowerCase();
		var arr = null;
		if (effects.hasOwnProperty(tag))
			arr = effects[tag];
		ret.set_int(arr ? arr.length : 0);
	};
	function getAnalyser(tag, index)
	{
		var arr = null;
		if (effects.hasOwnProperty(tag))
			arr = effects[tag];
		if (arr && index >= 0 && index < arr.length && arr[index].freqBins)
			return arr[index];
		else
			return null;
	};
	Exps.prototype.AnalyserFreqBinCount = function (ret, tag, index)
	{
		tag = tag.toLowerCase();
		index = Math.floor(index);
		var analyser = getAnalyser(tag, index);
		ret.set_int(analyser ? analyser.node["frequencyBinCount"] : 0);
	};
	Exps.prototype.AnalyserFreqBinAt = function (ret, tag, index, bin)
	{
		tag = tag.toLowerCase();
		index = Math.floor(index);
		bin = Math.floor(bin);
		var analyser = getAnalyser(tag, index);
		if (!analyser)
			ret.set_float(0);
		else if (bin < 0 || bin >= analyser.node["frequencyBinCount"])
			ret.set_float(0);
		else
			ret.set_float(analyser.freqBins[bin]);
	};
	Exps.prototype.AnalyserPeakLevel = function (ret, tag, index)
	{
		tag = tag.toLowerCase();
		index = Math.floor(index);
		var analyser = getAnalyser(tag, index);
		if (analyser)
			ret.set_float(analyser.peak);
		else
			ret.set_float(0);
	};
	Exps.prototype.AnalyserRMSLevel = function (ret, tag, index)
	{
		tag = tag.toLowerCase();
		index = Math.floor(index);
		var analyser = getAnalyser(tag, index);
		if (analyser)
			ret.set_float(analyser.rms);
		else
			ret.set_float(0);
	};
	pluginProto.exps = new Exps();
}());
;
;
cr.plugins_.Mouse = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var pluginProto = cr.plugins_.Mouse.prototype;
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	typeProto.onCreate = function()
	{
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
		this.buttonMap = new Array(4);		// mouse down states
		this.mouseXcanvas = 0;				// mouse position relative to canvas
		this.mouseYcanvas = 0;
		this.triggerButton = 0;
		this.triggerType = 0;
		this.triggerDir = 0;
		this.handled = false;
	};
	var instanceProto = pluginProto.Instance.prototype;
	instanceProto.onCreate = function()
	{
		var self = this;
		if (!this.runtime.isDomFree)
		{
			jQuery(document).mousemove(
				function(info) {
					self.onMouseMove(info);
				}
			);
			jQuery(document).mousedown(
				function(info) {
					self.onMouseDown(info);
				}
			);
			jQuery(document).mouseup(
				function(info) {
					self.onMouseUp(info);
				}
			);
			jQuery(document).dblclick(
				function(info) {
					self.onDoubleClick(info);
				}
			);
			var wheelevent = function(info) {
								self.onWheel(info);
							};
			document.addEventListener("mousewheel", wheelevent, false);
			document.addEventListener("DOMMouseScroll", wheelevent, false);
		}
	};
	var dummyoffset = {left: 0, top: 0};
	instanceProto.onMouseMove = function(info)
	{
		var offset = this.runtime.isDomFree ? dummyoffset : jQuery(this.runtime.canvas).offset();
		this.mouseXcanvas = info.pageX - offset.left;
		this.mouseYcanvas = info.pageY - offset.top;
	};
	instanceProto.mouseInGame = function ()
	{
		if (this.runtime.fullscreen_mode > 0)
			return true;
		return this.mouseXcanvas >= 0 && this.mouseYcanvas >= 0
		    && this.mouseXcanvas < this.runtime.width && this.mouseYcanvas < this.runtime.height;
	};
	instanceProto.onMouseDown = function(info)
	{
		if (!this.mouseInGame())
			return;
		if (this.runtime.had_a_click && !this.runtime.isMobile)
			info.preventDefault();
		this.buttonMap[info.which] = true;
		this.runtime.isInUserInputEvent = true;
		this.runtime.trigger(cr.plugins_.Mouse.prototype.cnds.OnAnyClick, this);
		this.triggerButton = info.which - 1;	// 1-based
		this.triggerType = 0;					// single click
		this.runtime.trigger(cr.plugins_.Mouse.prototype.cnds.OnClick, this);
		this.runtime.trigger(cr.plugins_.Mouse.prototype.cnds.OnObjectClicked, this);
		this.runtime.isInUserInputEvent = false;
	};
	instanceProto.onMouseUp = function(info)
	{
		if (!this.buttonMap[info.which])
			return;
		if (this.runtime.had_a_click && !this.runtime.isMobile)
			info.preventDefault();
		this.runtime.had_a_click = true;
		this.buttonMap[info.which] = false;
		this.runtime.isInUserInputEvent = true;
		this.triggerButton = info.which - 1;	// 1-based
		this.runtime.trigger(cr.plugins_.Mouse.prototype.cnds.OnRelease, this);
		this.runtime.isInUserInputEvent = false;
	};
	instanceProto.onDoubleClick = function(info)
	{
		if (!this.mouseInGame())
			return;
		info.preventDefault();
		this.runtime.isInUserInputEvent = true;
		this.triggerButton = info.which - 1;	// 1-based
		this.triggerType = 1;					// double click
		this.runtime.trigger(cr.plugins_.Mouse.prototype.cnds.OnClick, this);
		this.runtime.trigger(cr.plugins_.Mouse.prototype.cnds.OnObjectClicked, this);
		this.runtime.isInUserInputEvent = false;
	};
	instanceProto.onWheel = function (info)
	{
		var delta = info.wheelDelta ? info.wheelDelta : info.detail ? -info.detail : 0;
		this.triggerDir = (delta < 0 ? 0 : 1);
		this.handled = false;
		this.runtime.isInUserInputEvent = true;
		this.runtime.trigger(cr.plugins_.Mouse.prototype.cnds.OnWheel, this);
		this.runtime.isInUserInputEvent = false;
		if (this.handled)
			info.preventDefault();
	};
	function Cnds() {};
	Cnds.prototype.OnClick = function (button, type)
	{
		return button === this.triggerButton && type === this.triggerType;
	};
	Cnds.prototype.OnAnyClick = function ()
	{
		return true;
	};
	Cnds.prototype.IsButtonDown = function (button)
	{
		return this.buttonMap[button + 1];	// jQuery uses 1-based buttons for some reason
	};
	Cnds.prototype.OnRelease = function (button)
	{
		return button === this.triggerButton;
	};
	Cnds.prototype.IsOverObject = function (obj)
	{
		var cnd = this.runtime.getCurrentCondition();
		var mx = this.mouseXcanvas;
		var my = this.mouseYcanvas;
		return cr.xor(this.runtime.testAndSelectCanvasPointOverlap(obj, mx, my, cnd.inverted), cnd.inverted);
	};
	Cnds.prototype.OnObjectClicked = function (button, type, obj)
	{
		if (button !== this.triggerButton || type !== this.triggerType)
			return false;	// wrong click type
		return this.runtime.testAndSelectCanvasPointOverlap(obj, this.mouseXcanvas, this.mouseYcanvas, false);
	};
	Cnds.prototype.OnWheel = function (dir)
	{
		this.handled = true;
		return dir === this.triggerDir;
	};
	pluginProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.SetCursor = function (c)
	{
		var cursor_style = ["auto", "pointer", "text", "crosshair", "move", "help", "wait", "none"][c];
		if (this.runtime.canvas && this.runtime.canvas.style)
			this.runtime.canvas.style.cursor = cursor_style;
	};
	Acts.prototype.SetCursorSprite = function (obj)
	{
		if (this.runtime.isDomFree || this.runtime.isMobile || !obj)
			return;
		var inst = obj.getFirstPicked();
		if (!inst || !inst.curFrame)
			return;
		var frame = inst.curFrame;
		var datauri = frame.getDataUri();
		var cursor_style = "url(" + datauri + ") " + Math.round(frame.hotspotX * frame.width) + " " + Math.round(frame.hotspotY * frame.height) + ", auto";
		jQuery(this.runtime.canvas).css("cursor", cursor_style);
	};
	pluginProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.X = function (ret, layerparam)
	{
		var layer, oldScale, oldZoomRate, oldParallaxX, oldAngle;
		if (cr.is_undefined(layerparam))
		{
			layer = this.runtime.getLayerByNumber(0);
			oldScale = layer.scale;
			oldZoomRate = layer.zoomRate;
			oldParallaxX = layer.parallaxX;
			oldAngle = layer.angle;
			layer.scale = this.runtime.running_layout.scale;
			layer.zoomRate = 1.0;
			layer.parallaxX = 1.0;
			layer.angle = this.runtime.running_layout.angle;
			ret.set_float(layer.canvasToLayer(this.mouseXcanvas, this.mouseYcanvas, true));
			layer.scale = oldScale;
			layer.zoomRate = oldZoomRate;
			layer.parallaxX = oldParallaxX;
			layer.angle = oldAngle;
		}
		else
		{
			if (cr.is_number(layerparam))
				layer = this.runtime.getLayerByNumber(layerparam);
			else
				layer = this.runtime.getLayerByName(layerparam);
			if (layer)
				ret.set_float(layer.canvasToLayer(this.mouseXcanvas, this.mouseYcanvas, true));
			else
				ret.set_float(0);
		}
	};
	Exps.prototype.Y = function (ret, layerparam)
	{
		var layer, oldScale, oldZoomRate, oldParallaxY, oldAngle;
		if (cr.is_undefined(layerparam))
		{
			layer = this.runtime.getLayerByNumber(0);
			oldScale = layer.scale;
			oldZoomRate = layer.zoomRate;
			oldParallaxY = layer.parallaxY;
			oldAngle = layer.angle;
			layer.scale = this.runtime.running_layout.scale;
			layer.zoomRate = 1.0;
			layer.parallaxY = 1.0;
			layer.angle = this.runtime.running_layout.angle;
			ret.set_float(layer.canvasToLayer(this.mouseXcanvas, this.mouseYcanvas, false));
			layer.scale = oldScale;
			layer.zoomRate = oldZoomRate;
			layer.parallaxY = oldParallaxY;
			layer.angle = oldAngle;
		}
		else
		{
			if (cr.is_number(layerparam))
				layer = this.runtime.getLayerByNumber(layerparam);
			else
				layer = this.runtime.getLayerByName(layerparam);
			if (layer)
				ret.set_float(layer.canvasToLayer(this.mouseXcanvas, this.mouseYcanvas, false));
			else
				ret.set_float(0);
		}
	};
	Exps.prototype.AbsoluteX = function (ret)
	{
		ret.set_float(this.mouseXcanvas);
	};
	Exps.prototype.AbsoluteY = function (ret)
	{
		ret.set_float(this.mouseYcanvas);
	};
	pluginProto.exps = new Exps();
}());
;
;
cr.plugins_.Particles = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var pluginProto = cr.plugins_.Particles.prototype;
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	typeProto.onCreate = function()
	{
		if (this.is_family)
			return;
		this.texture_img = new Image();
		this.texture_img["idtkLoadDisposed"] = true;
		this.texture_img.src = this.texture_file;
		this.texture_img.cr_filesize = this.texture_filesize;
		this.webGL_texture = null;
		this.runtime.waitForImageLoad(this.texture_img);
	};
	typeProto.onLostWebGLContext = function ()
	{
		if (this.is_family)
			return;
		this.webGL_texture = null;
	};
	typeProto.onRestoreWebGLContext = function ()
	{
		if (this.is_family || !this.instances.length)
			return;
		if (!this.webGL_texture)
		{
			this.webGL_texture = this.runtime.glwrap.loadTexture(this.texture_img, true, this.runtime.linearSampling, this.texture_pixelformat);
		}
	};
	typeProto.loadTextures = function ()
	{
		if (this.is_family || this.webGL_texture || !this.runtime.glwrap)
			return;
		this.webGL_texture = this.runtime.glwrap.loadTexture(this.texture_img, true, this.runtime.linearSampling, this.texture_pixelformat);
	};
	typeProto.unloadTextures = function ()
	{
		if (this.is_family || this.instances.length || !this.webGL_texture)
			return;
		this.runtime.glwrap.deleteTexture(this.webGL_texture);
		this.webGL_texture = null;
	};
	typeProto.preloadCanvas2D = function (ctx)
	{
		ctx.drawImage(this.texture_img, 0, 0);
	};
	function Particle(owner)
	{
		this.owner = owner;
		this.active = false;
		this.x = 0;
		this.y = 0;
		this.speed = 0;
		this.angle = 0;
		this.opacity = 1;
		this.grow = 0;
		this.size = 0;
		this.gs = 0;			// gravity speed
		this.age = 0;
		cr.seal(this);
	};
	Particle.prototype.init = function ()
	{
		var owner = this.owner;
		this.x = owner.x - (owner.xrandom / 2) + (Math.random() * owner.xrandom);
		this.y = owner.y - (owner.yrandom / 2) + (Math.random() * owner.yrandom);
		this.speed = owner.initspeed - (owner.speedrandom / 2) + (Math.random() * owner.speedrandom);
		this.angle = owner.angle - (owner.spraycone / 2) + (Math.random() * owner.spraycone);
		this.opacity = owner.initopacity;
		this.size = owner.initsize - (owner.sizerandom / 2) + (Math.random() * owner.sizerandom);
		this.grow = owner.growrate - (owner.growrandom / 2) + (Math.random() * owner.growrandom);
		this.gs = 0;
		this.age = 0;
	};
	Particle.prototype.tick = function (dt)
	{
		var owner = this.owner;
		this.x += Math.cos(this.angle) * this.speed * dt;
		this.y += Math.sin(this.angle) * this.speed * dt;
		this.y += this.gs * dt;
		this.speed += owner.acc * dt;
		this.size += this.grow * dt;
		this.gs += owner.g * dt;
		this.age += dt;
		if (this.size < 1)
		{
			this.active = false;
			return;
		}
		if (owner.lifeanglerandom !== 0)
			this.angle += (Math.random() * owner.lifeanglerandom * dt) - (owner.lifeanglerandom * dt / 2);
		if (owner.lifespeedrandom !== 0)
			this.speed += (Math.random() * owner.lifespeedrandom * dt) - (owner.lifespeedrandom * dt / 2);
		if (owner.lifeopacityrandom !== 0)
		{
			this.opacity += (Math.random() * owner.lifeopacityrandom * dt) - (owner.lifeopacityrandom * dt / 2);
			if (this.opacity < 0)
				this.opacity = 0;
			else if (this.opacity > 1)
				this.opacity = 1;
		}
		if (owner.destroymode <= 1 && this.age >= owner.timeout)
		{
			this.active = false;
		}
		if (owner.destroymode === 2 && this.speed <= 0)
		{
			this.active = false;
		}
	};
	Particle.prototype.draw = function (ctx)
	{
		var curopacity = this.owner.opacity * this.opacity;
		if (curopacity === 0)
			return;
		if (this.owner.destroymode === 0)
			curopacity *= 1 - (this.age / this.owner.timeout);
		ctx.globalAlpha = curopacity;
		var drawx = this.x - this.size / 2;
		var drawy = this.y - this.size / 2;
		if (this.owner.runtime.pixel_rounding)
		{
			drawx = (drawx + 0.5) | 0;
			drawy = (drawy + 0.5) | 0;
		}
		ctx.drawImage(this.owner.type.texture_img, drawx, drawy, this.size, this.size);
	};
	Particle.prototype.drawGL = function (glw)
	{
		var curopacity = this.owner.opacity * this.opacity;
		if (this.owner.destroymode === 0)
			curopacity *= 1 - (this.age / this.owner.timeout);
		var drawsize = this.size;
		var scaleddrawsize = drawsize * this.owner.particlescale;
		var drawx = this.x - drawsize / 2;
		var drawy = this.y - drawsize / 2;
		if (this.owner.runtime.pixel_rounding)
		{
			drawx = (drawx + 0.5) | 0;
			drawy = (drawy + 0.5) | 0;
		}
		if (scaleddrawsize < 1 || curopacity === 0)
			return;
		if (scaleddrawsize < glw.minPointSize || scaleddrawsize > glw.maxPointSize)
		{
			glw.setOpacity(curopacity);
			glw.quad(drawx, drawy, drawx + drawsize, drawy, drawx + drawsize, drawy + drawsize, drawx, drawy + drawsize);
		}
		else
			glw.point(this.x, this.y, scaleddrawsize, curopacity);
	};
	Particle.prototype.left = function ()
	{
		return this.x - this.size / 2;
	};
	Particle.prototype.right = function ()
	{
		return this.x + this.size / 2;
	};
	Particle.prototype.top = function ()
	{
		return this.y - this.size / 2;
	};
	Particle.prototype.bottom = function ()
	{
		return this.y + this.size / 2;
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
	};
	var instanceProto = pluginProto.Instance.prototype;
	var deadparticles = [];
	instanceProto.onCreate = function()
	{
		var props = this.properties;
		this.rate = props[0];
		this.spraycone = cr.to_radians(props[1]);
		this.spraytype = props[2];			// 0 = continuous, 1 = one-shot
		this.spraying = true;				// for continuous mode only
		this.initspeed = props[3];
		this.initsize = props[4];
		this.initopacity = props[5] / 100.0;
		this.growrate = props[6];
		this.xrandom = props[7];
		this.yrandom = props[8];
		this.speedrandom = props[9];
		this.sizerandom = props[10];
		this.growrandom = props[11];
		this.acc = props[12];
		this.g = props[13];
		this.lifeanglerandom = props[14];
		this.lifespeedrandom = props[15];
		this.lifeopacityrandom = props[16];
		this.destroymode = props[17];		// 0 = fade, 1 = timeout, 2 = stopped
		this.timeout = props[18];
		this.particleCreateCounter = 0;
		this.particlescale = 1;
		this.particleBoxLeft = this.x;
		this.particleBoxTop = this.y;
		this.particleBoxRight = this.x;
		this.particleBoxBottom = this.y;
		this.add_bbox_changed_callback(function (self) {
			self.bbox.set(self.particleBoxLeft, self.particleBoxTop, self.particleBoxRight, self.particleBoxBottom);
			self.bquad.set_from_rect(self.bbox);
			self.bbox_changed = false;
			self.update_collision_cell();
		});
		if (!this.recycled)
			this.particles = [];
		this.runtime.tickMe(this);
		this.type.loadTextures();
		if (this.spraytype === 1)
		{
			for (var i = 0; i < this.rate; i++)
				this.allocateParticle().opacity = 0;
		}
		this.first_tick = true;		// for re-init'ing one-shot particles on first tick so they assume any new angle/position
	};
	instanceProto.saveToJSON = function ()
	{
		var o = {
			"r": this.rate,
			"sc": this.spraycone,
			"st": this.spraytype,
			"s": this.spraying,
			"isp": this.initspeed,
			"isz": this.initsize,
			"io": this.initopacity,
			"gr": this.growrate,
			"xr": this.xrandom,
			"yr": this.yrandom,
			"spr": this.speedrandom,
			"szr": this.sizerandom,
			"grnd": this.growrandom,
			"acc": this.acc,
			"g": this.g,
			"lar": this.lifeanglerandom,
			"lsr": this.lifespeedrandom,
			"lor": this.lifeopacityrandom,
			"dm": this.destroymode,
			"to": this.timeout,
			"pcc": this.particleCreateCounter,
			"ft": this.first_tick,
			"p": []
		};
		var i, len, p;
		var arr = o["p"];
		for (i = 0, len = this.particles.length; i < len; i++)
		{
			p = this.particles[i];
			arr.push([p.x, p.y, p.speed, p.angle, p.opacity, p.grow, p.size, p.gs, p.age]);
		}
		return o;
	};
	instanceProto.loadFromJSON = function (o)
	{
		this.rate = o["r"];
		this.spraycone = o["sc"];
		this.spraytype = o["st"];
		this.spraying = o["s"];
		this.initspeed = o["isp"];
		this.initsize = o["isz"];
		this.initopacity = o["io"];
		this.growrate = o["gr"];
		this.xrandom = o["xr"];
		this.yrandom = o["yr"];
		this.speedrandom = o["spr"];
		this.sizerandom = o["szr"];
		this.growrandom = o["grnd"];
		this.acc = o["acc"];
		this.g = o["g"];
		this.lifeanglerandom = o["lar"];
		this.lifespeedrandom = o["lsr"];
		this.lifeopacityrandom = o["lor"];
		this.destroymode = o["dm"];
		this.timeout = o["to"];
		this.particleCreateCounter = o["pcc"];
		this.first_tick = o["ft"];
		deadparticles.push.apply(deadparticles, this.particles);
		this.particles.length = 0;
		var i, len, p, d;
		var arr = o["p"];
		for (i = 0, len = arr.length; i < len; i++)
		{
			p = this.allocateParticle();
			d = arr[i];
			p.x = d[0];
			p.y = d[1];
			p.speed = d[2];
			p.angle = d[3];
			p.opacity = d[4];
			p.grow = d[5];
			p.size = d[6];
			p.gs = d[7];
			p.age = d[8];
		}
	};
	instanceProto.onDestroy = function ()
	{
		deadparticles.push.apply(deadparticles, this.particles);
		this.particles.length = 0;
	};
	instanceProto.allocateParticle = function ()
	{
		var p;
		if (deadparticles.length)
		{
			p = deadparticles.pop();
			p.owner = this;
		}
		else
			p = new Particle(this);
		this.particles.push(p);
		p.active = true;
		return p;
	};
	instanceProto.tick = function()
	{
		var dt = this.runtime.getDt(this);
		var i, len, p, n, j;
		if (this.spraytype === 0 && this.spraying)
		{
			this.particleCreateCounter += dt * this.rate;
			n = cr.floor(this.particleCreateCounter);
			this.particleCreateCounter -= n;
			for (i = 0; i < n; i++)
			{
				p = this.allocateParticle();
				p.init();
			}
		}
		this.particleBoxLeft = this.x;
		this.particleBoxTop = this.y;
		this.particleBoxRight = this.x;
		this.particleBoxBottom = this.y;
		for (i = 0, j = 0, len = this.particles.length; i < len; i++)
		{
			p = this.particles[i];
			this.particles[j] = p;
			this.runtime.redraw = true;
			if (this.spraytype === 1 && this.first_tick)
				p.init();
			p.tick(dt);
			if (!p.active)
			{
				deadparticles.push(p);
				continue;
			}
			if (p.left() < this.particleBoxLeft)
				this.particleBoxLeft = p.left();
			if (p.right() > this.particleBoxRight)
				this.particleBoxRight = p.right();
			if (p.top() < this.particleBoxTop)
				this.particleBoxTop = p.top();
			if (p.bottom() > this.particleBoxBottom)
				this.particleBoxBottom = p.bottom();
			j++;
		}
		this.particles.length = j;
		this.set_bbox_changed();
		this.first_tick = false;
		if (this.spraytype === 1 && this.particles.length === 0)
			this.runtime.DestroyInstance(this);
	};
	instanceProto.draw = function (ctx)
	{
		var i, len, p, layer = this.layer;
		for (i = 0, len = this.particles.length; i < len; i++)
		{
			p = this.particles[i];
			if (p.right() >= layer.viewLeft && p.bottom() >= layer.viewTop && p.left() <= layer.viewRight && p.top() <= layer.viewBottom)
			{
				p.draw(ctx);
			}
		}
	};
	instanceProto.drawGL = function (glw)
	{
		this.particlescale = this.layer.getScale();
		glw.setTexture(this.type.webGL_texture);
		var i, len, p, layer = this.layer;
		for (i = 0, len = this.particles.length; i < len; i++)
		{
			p = this.particles[i];
			if (p.right() >= layer.viewLeft && p.bottom() >= layer.viewTop && p.left() <= layer.viewRight && p.top() <= layer.viewBottom)
			{
				p.drawGL(glw);
			}
		}
	};
	function Cnds() {};
	Cnds.prototype.IsSpraying = function ()
	{
		return this.spraying;
	};
	pluginProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.SetSpraying = function (set_)
	{
		this.spraying = (set_ !== 0);
	};
	Acts.prototype.SetEffect = function (effect)
	{
		this.compositeOp = cr.effectToCompositeOp(effect);
		cr.setGLBlend(this, effect, this.runtime.gl);
		this.runtime.redraw = true;
	};
	Acts.prototype.SetRate = function (x)
	{
		this.rate = x;
		var diff, i;
		if (this.spraytype === 1 && this.first_tick)
		{
			if (x < this.particles.length)
			{
				diff = this.particles.length - x;
				for (i = 0; i < diff; i++)
					deadparticles.push(this.particles.pop());
			}
			else if (x > this.particles.length)
			{
				diff = x - this.particles.length;
				for (i = 0; i < diff; i++)
					this.allocateParticle().opacity = 0;
			}
		}
	};
	Acts.prototype.SetSprayCone = function (x)
	{
		this.spraycone = cr.to_radians(x);
	};
	Acts.prototype.SetInitSpeed = function (x)
	{
		this.initspeed = x;
	};
	Acts.prototype.SetInitSize = function (x)
	{
		this.initsize = x;
	};
	Acts.prototype.SetInitOpacity = function (x)
	{
		this.initopacity = x / 100;
	};
	Acts.prototype.SetGrowRate = function (x)
	{
		this.growrate = x;
	};
	Acts.prototype.SetXRandomiser = function (x)
	{
		this.xrandom = x;
	};
	Acts.prototype.SetYRandomiser = function (x)
	{
		this.yrandom = x;
	};
	Acts.prototype.SetSpeedRandomiser = function (x)
	{
		this.speedrandom = x;
	};
	Acts.prototype.SetSizeRandomiser = function (x)
	{
		this.sizerandom = x;
	};
	Acts.prototype.SetGrowRateRandomiser = function (x)
	{
		this.growrandom = x;
	};
	Acts.prototype.SetParticleAcc = function (x)
	{
		this.acc = x;
	};
	Acts.prototype.SetGravity = function (x)
	{
		this.g = x;
	};
	Acts.prototype.SetAngleRandomiser = function (x)
	{
		this.lifeanglerandom = x;
	};
	Acts.prototype.SetSpeedRandomiser = function (x)
	{
		this.lifespeedrandom = x;
	};
	Acts.prototype.SetOpacityRandomiser = function (x)
	{
		this.lifeopacityrandom = x;
	};
	Acts.prototype.SetTimeout = function (x)
	{
		this.timeout = x;
	};
	pluginProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.ParticleCount = function (ret)
	{
		ret.set_int(this.particles.length);
	};
	Exps.prototype.Rate = function (ret)
	{
		ret.set_float(this.rate);
	};
	Exps.prototype.SprayCone = function (ret)
	{
		ret.set_float(cr.to_degrees(this.spraycone));
	};
	Exps.prototype.InitSpeed = function (ret)
	{
		ret.set_float(this.initspeed);
	};
	Exps.prototype.InitSize = function (ret)
	{
		ret.set_float(this.initsize);
	};
	Exps.prototype.InitOpacity = function (ret)
	{
		ret.set_float(this.initopacity * 100);
	};
	Exps.prototype.InitGrowRate = function (ret)
	{
		ret.set_float(this.growrate);
	};
	Exps.prototype.XRandom = function (ret)
	{
		ret.set_float(this.xrandom);
	};
	Exps.prototype.YRandom = function (ret)
	{
		ret.set_float(this.yrandom);
	};
	Exps.prototype.InitSpeedRandom = function (ret)
	{
		ret.set_float(this.speedrandom);
	};
	Exps.prototype.InitSizeRandom = function (ret)
	{
		ret.set_float(this.sizerandom);
	};
	Exps.prototype.InitGrowRandom = function (ret)
	{
		ret.set_float(this.growrandom);
	};
	Exps.prototype.ParticleAcceleration = function (ret)
	{
		ret.set_float(this.acc);
	};
	Exps.prototype.Gravity = function (ret)
	{
		ret.set_float(this.g);
	};
	Exps.prototype.ParticleAngleRandom = function (ret)
	{
		ret.set_float(this.lifeanglerandom);
	};
	Exps.prototype.ParticleSpeedRandom = function (ret)
	{
		ret.set_float(this.lifespeedrandom);
	};
	Exps.prototype.ParticleOpacityRandom = function (ret)
	{
		ret.set_float(this.lifeopacityrandom);
	};
	Exps.prototype.Timeout = function (ret)
	{
		ret.set_float(this.timeout);
	};
	pluginProto.exps = new Exps();
}());
;
;
cr.plugins_.Sprite = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var pluginProto = cr.plugins_.Sprite.prototype;
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	function frame_getDataUri()
	{
		if (this.datauri.length === 0)
		{
			var tmpcanvas = document.createElement("canvas");
			tmpcanvas.width = this.width;
			tmpcanvas.height = this.height;
			var tmpctx = tmpcanvas.getContext("2d");
			if (this.spritesheeted)
			{
				tmpctx.drawImage(this.texture_img, this.offx, this.offy, this.width, this.height,
										 0, 0, this.width, this.height);
			}
			else
			{
				tmpctx.drawImage(this.texture_img, 0, 0, this.width, this.height);
			}
			this.datauri = tmpcanvas.toDataURL("image/png");
		}
		return this.datauri;
	};
	typeProto.onCreate = function()
	{
		if (this.is_family)
			return;
		var i, leni, j, lenj;
		var anim, frame, animobj, frameobj, wt, uv;
		this.all_frames = [];
		this.has_loaded_textures = false;
		for (i = 0, leni = this.animations.length; i < leni; i++)
		{
			anim = this.animations[i];
			animobj = {};
			animobj.name = anim[0];
			animobj.speed = anim[1];
			animobj.loop = anim[2];
			animobj.repeatcount = anim[3];
			animobj.repeatto = anim[4];
			animobj.pingpong = anim[5];
			animobj.sid = anim[6];
			animobj.frames = [];
			for (j = 0, lenj = anim[7].length; j < lenj; j++)
			{
				frame = anim[7][j];
				frameobj = {};
				frameobj.texture_file = frame[0];
				frameobj.texture_filesize = frame[1];
				frameobj.offx = frame[2];
				frameobj.offy = frame[3];
				frameobj.width = frame[4];
				frameobj.height = frame[5];
				frameobj.duration = frame[6];
				frameobj.hotspotX = frame[7];
				frameobj.hotspotY = frame[8];
				frameobj.image_points = frame[9];
				frameobj.poly_pts = frame[10];
				frameobj.pixelformat = frame[11];
				frameobj.spritesheeted = (frameobj.width !== 0);
				frameobj.datauri = "";		// generated on demand and cached
				frameobj.getDataUri = frame_getDataUri;
				uv = {};
				uv.left = 0;
				uv.top = 0;
				uv.right = 1;
				uv.bottom = 1;
				frameobj.sheetTex = uv;
				frameobj.webGL_texture = null;
				wt = this.runtime.findWaitingTexture(frame[0]);
				if (wt)
				{
					frameobj.texture_img = wt;
				}
				else
				{
					frameobj.texture_img = new Image();
					frameobj.texture_img["idtkLoadDisposed"] = true;
					frameobj.texture_img.src = frame[0];
					frameobj.texture_img.cr_src = frame[0];
					frameobj.texture_img.cr_filesize = frame[1];
					frameobj.texture_img.c2webGL_texture = null;
					this.runtime.waitForImageLoad(frameobj.texture_img);
				}
				cr.seal(frameobj);
				animobj.frames.push(frameobj);
				this.all_frames.push(frameobj);
			}
			cr.seal(animobj);
			this.animations[i] = animobj;		// swap array data for object
		}
	};
	typeProto.updateAllCurrentTexture = function ()
	{
		var i, len, inst;
		for (i = 0, len = this.instances.length; i < len; i++)
		{
			inst = this.instances[i];
			inst.curWebGLTexture = inst.curFrame.webGL_texture;
		}
	};
	typeProto.onLostWebGLContext = function ()
	{
		if (this.is_family)
			return;
		var i, len, frame;
		for (i = 0, len = this.all_frames.length; i < len; ++i)
		{
			frame = this.all_frames[i];
			frame.texture_img.c2webGL_texture = null;
			frame.webGL_texture = null;
		}
	};
	typeProto.onRestoreWebGLContext = function ()
	{
		if (this.is_family || !this.instances.length)
			return;
		var i, len, frame;
		for (i = 0, len = this.all_frames.length; i < len; ++i)
		{
			frame = this.all_frames[i];
			frame.webGL_texture = this.runtime.glwrap.loadTexture(frame.texture_img, false, this.runtime.linearSampling, frame.pixelformat);
		}
		this.updateAllCurrentTexture();
	};
	typeProto.loadTextures = function ()
	{
		if (this.is_family || this.has_loaded_textures || !this.runtime.glwrap)
			return;
		var i, len, frame;
		for (i = 0, len = this.all_frames.length; i < len; ++i)
		{
			frame = this.all_frames[i];
			frame.webGL_texture = this.runtime.glwrap.loadTexture(frame.texture_img, false, this.runtime.linearSampling, frame.pixelformat);
		}
		this.has_loaded_textures = true;
	};
	typeProto.unloadTextures = function ()
	{
		if (this.is_family || this.instances.length || !this.has_loaded_textures)
			return;
		var i, len, frame;
		for (i = 0, len = this.all_frames.length; i < len; ++i)
		{
			frame = this.all_frames[i];
			this.runtime.glwrap.deleteTexture(frame.webGL_texture);
			frame.webGL_texture = null;
		}
		this.has_loaded_textures = false;
	};
	var already_drawn_images = [];
	typeProto.preloadCanvas2D = function (ctx)
	{
		var i, len, frameimg;
		already_drawn_images.length = 0;
		for (i = 0, len = this.all_frames.length; i < len; ++i)
		{
			frameimg = this.all_frames[i].texture_img;
			if (already_drawn_images.indexOf(frameimg) !== -1)
					continue;
			ctx.drawImage(frameimg, 0, 0);
			already_drawn_images.push(frameimg);
		}
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
		var poly_pts = this.type.animations[0].frames[0].poly_pts;
		if (this.recycled)
			this.collision_poly.set_pts(poly_pts);
		else
			this.collision_poly = new cr.CollisionPoly(poly_pts);
	};
	var instanceProto = pluginProto.Instance.prototype;
	instanceProto.onCreate = function()
	{
		this.visible = (this.properties[0] === 0);	// 0=visible, 1=invisible
		this.isTicking = false;
		this.inAnimTrigger = false;
		this.collisionsEnabled = (this.properties[3] !== 0);
		if (!(this.type.animations.length === 1 && this.type.animations[0].frames.length === 1) && this.type.animations[0].speed !== 0)
		{
			this.runtime.tickMe(this);
			this.isTicking = true;
		}
		this.cur_animation = this.getAnimationByName(this.properties[1]) || this.type.animations[0];
		this.cur_frame = this.properties[2];
		if (this.cur_frame < 0)
			this.cur_frame = 0;
		if (this.cur_frame >= this.cur_animation.frames.length)
			this.cur_frame = this.cur_animation.frames.length - 1;
		var curanimframe = this.cur_animation.frames[this.cur_frame];
		this.collision_poly.set_pts(curanimframe.poly_pts);
		this.hotspotX = curanimframe.hotspotX;
		this.hotspotY = curanimframe.hotspotY;
		this.cur_anim_speed = this.cur_animation.speed;
		if (this.recycled)
			this.animTimer.reset();
		else
			this.animTimer = new cr.KahanAdder();
		this.frameStart = this.getNowTime();
		this.animPlaying = true;
		this.animRepeats = 0;
		this.animForwards = true;
		this.animTriggerName = "";
		this.changeAnimName = "";
		this.changeAnimFrom = 0;
		this.changeAnimFrame = -1;
		this.type.loadTextures();
		var i, leni, j, lenj;
		var anim, frame, uv, maintex;
		for (i = 0, leni = this.type.animations.length; i < leni; i++)
		{
			anim = this.type.animations[i];
			for (j = 0, lenj = anim.frames.length; j < lenj; j++)
			{
				frame = anim.frames[j];
				if (frame.width === 0)
				{
					frame.width = frame.texture_img.width;
					frame.height = frame.texture_img.height;
				}
				if (frame.spritesheeted)
				{
					maintex = frame.texture_img;
					uv = frame.sheetTex;
					uv.left = frame.offx / maintex.width;
					uv.top = frame.offy / maintex.height;
					uv.right = (frame.offx + frame.width) / maintex.width;
					uv.bottom = (frame.offy + frame.height) / maintex.height;
					if (frame.offx === 0 && frame.offy === 0 && frame.width === maintex.width && frame.height === maintex.height)
					{
						frame.spritesheeted = false;
					}
				}
			}
		}
		this.curFrame = this.cur_animation.frames[this.cur_frame];
		this.curWebGLTexture = this.curFrame.webGL_texture;
	};
	instanceProto.saveToJSON = function ()
	{
		var o = {
			"a": this.cur_animation.sid,
			"f": this.cur_frame,
			"cas": this.cur_anim_speed,
			"fs": this.frameStart,
			"ar": this.animRepeats,
			"at": this.animTimer.sum
		};
		if (!this.animPlaying)
			o["ap"] = this.animPlaying;
		if (!this.animForwards)
			o["af"] = this.animForwards;
		return o;
	};
	instanceProto.loadFromJSON = function (o)
	{
		var anim = this.getAnimationBySid(o["a"]);
		if (anim)
			this.cur_animation = anim;
		this.cur_frame = o["f"];
		if (this.cur_frame < 0)
			this.cur_frame = 0;
		if (this.cur_frame >= this.cur_animation.frames.length)
			this.cur_frame = this.cur_animation.frames.length - 1;
		this.cur_anim_speed = o["cas"];
		this.frameStart = o["fs"];
		this.animRepeats = o["ar"];
		this.animTimer.reset();
		this.animTimer.sum = o["at"];
		this.animPlaying = o.hasOwnProperty("ap") ? o["ap"] : true;
		this.animForwards = o.hasOwnProperty("af") ? o["af"] : true;
		this.curFrame = this.cur_animation.frames[this.cur_frame];
		this.curWebGLTexture = this.curFrame.webGL_texture;
		this.collision_poly.set_pts(this.curFrame.poly_pts);
		this.hotspotX = this.curFrame.hotspotX;
		this.hotspotY = this.curFrame.hotspotY;
	};
	instanceProto.animationFinish = function (reverse)
	{
		this.cur_frame = reverse ? 0 : this.cur_animation.frames.length - 1;
		this.animPlaying = false;
		this.animTriggerName = this.cur_animation.name;
		this.inAnimTrigger = true;
		this.runtime.trigger(cr.plugins_.Sprite.prototype.cnds.OnAnyAnimFinished, this);
		this.runtime.trigger(cr.plugins_.Sprite.prototype.cnds.OnAnimFinished, this);
		this.inAnimTrigger = false;
		this.animRepeats = 0;
	};
	instanceProto.getNowTime = function()
	{
		return this.animTimer.sum;
	};
	instanceProto.tick = function()
	{
		this.animTimer.add(this.runtime.getDt(this));
		if (this.changeAnimName.length)
			this.doChangeAnim();
		if (this.changeAnimFrame >= 0)
			this.doChangeAnimFrame();
		var now = this.getNowTime();
		var cur_animation = this.cur_animation;
		var prev_frame = cur_animation.frames[this.cur_frame];
		var next_frame;
		var cur_frame_time = prev_frame.duration / this.cur_anim_speed;
		if (this.animPlaying && now >= this.frameStart + cur_frame_time)
		{
			if (this.animForwards)
			{
				this.cur_frame++;
			}
			else
			{
				this.cur_frame--;
			}
			this.frameStart += cur_frame_time;
			if (this.cur_frame >= cur_animation.frames.length)
			{
				if (cur_animation.pingpong)
				{
					this.animForwards = false;
					this.cur_frame = cur_animation.frames.length - 2;
				}
				else if (cur_animation.loop)
				{
					this.cur_frame = cur_animation.repeatto;
				}
				else
				{
					this.animRepeats++;
					if (this.animRepeats >= cur_animation.repeatcount)
					{
						this.animationFinish(false);
					}
					else
					{
						this.cur_frame = cur_animation.repeatto;
					}
				}
			}
			if (this.cur_frame < 0)
			{
				if (cur_animation.pingpong)
				{
					this.cur_frame = 1;
					this.animForwards = true;
					if (!cur_animation.loop)
					{
						this.animRepeats++;
						if (this.animRepeats >= cur_animation.repeatcount)
						{
							this.animationFinish(true);
						}
					}
				}
				else
				{
					if (cur_animation.loop)
					{
						this.cur_frame = cur_animation.repeatto;
					}
					else
					{
						this.animRepeats++;
						if (this.animRepeats >= cur_animation.repeatcount)
						{
							this.animationFinish(true);
						}
						else
						{
							this.cur_frame = cur_animation.repeatto;
						}
					}
				}
			}
			if (this.cur_frame < 0)
				this.cur_frame = 0;
			else if (this.cur_frame >= cur_animation.frames.length)
				this.cur_frame = cur_animation.frames.length - 1;
			if (now > this.frameStart + (cur_animation.frames[this.cur_frame].duration / this.cur_anim_speed))
			{
				this.frameStart = now;
			}
			next_frame = cur_animation.frames[this.cur_frame];
			this.OnFrameChanged(prev_frame, next_frame);
			this.runtime.redraw = true;
		}
	};
	instanceProto.getAnimationByName = function (name_)
	{
		var i, len, a;
		for (i = 0, len = this.type.animations.length; i < len; i++)
		{
			a = this.type.animations[i];
			if (cr.equals_nocase(a.name, name_))
				return a;
		}
		return null;
	};
	instanceProto.getAnimationBySid = function (sid_)
	{
		var i, len, a;
		for (i = 0, len = this.type.animations.length; i < len; i++)
		{
			a = this.type.animations[i];
			if (a.sid === sid_)
				return a;
		}
		return null;
	};
	instanceProto.doChangeAnim = function ()
	{
		var prev_frame = this.cur_animation.frames[this.cur_frame];
		var anim = this.getAnimationByName(this.changeAnimName);
		this.changeAnimName = "";
		if (!anim)
			return;
		if (cr.equals_nocase(anim.name, this.cur_animation.name) && this.animPlaying)
			return;
		this.cur_animation = anim;
		this.cur_anim_speed = anim.speed;
		if (this.cur_frame < 0)
			this.cur_frame = 0;
		if (this.cur_frame >= this.cur_animation.frames.length)
			this.cur_frame = this.cur_animation.frames.length - 1;
		if (this.changeAnimFrom === 1)
			this.cur_frame = 0;
		this.animPlaying = true;
		this.frameStart = this.getNowTime();
		this.animForwards = true;
		this.OnFrameChanged(prev_frame, this.cur_animation.frames[this.cur_frame]);
		this.runtime.redraw = true;
	};
	instanceProto.doChangeAnimFrame = function ()
	{
		var prev_frame = this.cur_animation.frames[this.cur_frame];
		var prev_frame_number = this.cur_frame;
		this.cur_frame = cr.floor(this.changeAnimFrame);
		if (this.cur_frame < 0)
			this.cur_frame = 0;
		if (this.cur_frame >= this.cur_animation.frames.length)
			this.cur_frame = this.cur_animation.frames.length - 1;
		if (prev_frame_number !== this.cur_frame)
		{
			this.OnFrameChanged(prev_frame, this.cur_animation.frames[this.cur_frame]);
			this.frameStart = this.getNowTime();
			this.runtime.redraw = true;
		}
		this.changeAnimFrame = -1;
	};
	instanceProto.OnFrameChanged = function (prev_frame, next_frame)
	{
		var oldw = prev_frame.width;
		var oldh = prev_frame.height;
		var neww = next_frame.width;
		var newh = next_frame.height;
		if (oldw != neww)
			this.width *= (neww / oldw);
		if (oldh != newh)
			this.height *= (newh / oldh);
		this.hotspotX = next_frame.hotspotX;
		this.hotspotY = next_frame.hotspotY;
		this.collision_poly.set_pts(next_frame.poly_pts);
		this.set_bbox_changed();
		this.curFrame = next_frame;
		this.curWebGLTexture = next_frame.webGL_texture;
		var i, len, b;
		for (i = 0, len = this.behavior_insts.length; i < len; i++)
		{
			b = this.behavior_insts[i];
			if (b.onSpriteFrameChanged)
				b.onSpriteFrameChanged(prev_frame, next_frame);
		}
		this.runtime.trigger(cr.plugins_.Sprite.prototype.cnds.OnFrameChanged, this);
	};
	instanceProto.draw = function(ctx)
	{
		ctx.globalAlpha = this.opacity;
		var cur_frame = this.curFrame;
		var spritesheeted = cur_frame.spritesheeted;
		var cur_image = cur_frame.texture_img;
		var myx = this.x;
		var myy = this.y;
		var w = this.width;
		var h = this.height;
		if (this.angle === 0 && w >= 0 && h >= 0)
		{
			myx -= this.hotspotX * w;
			myy -= this.hotspotY * h;
			if (this.runtime.pixel_rounding)
			{
				myx = (myx + 0.5) | 0;
				myy = (myy + 0.5) | 0;
			}
			if (spritesheeted)
			{
				ctx.drawImage(cur_image, cur_frame.offx, cur_frame.offy, cur_frame.width, cur_frame.height,
										 myx, myy, w, h);
			}
			else
			{
				ctx.drawImage(cur_image, myx, myy, w, h);
			}
		}
		else
		{
			if (this.runtime.pixel_rounding)
			{
				myx = (myx + 0.5) | 0;
				myy = (myy + 0.5) | 0;
			}
			ctx.save();
			var widthfactor = w > 0 ? 1 : -1;
			var heightfactor = h > 0 ? 1 : -1;
			ctx.translate(myx, myy);
			if (widthfactor !== 1 || heightfactor !== 1)
				ctx.scale(widthfactor, heightfactor);
			ctx.rotate(this.angle * widthfactor * heightfactor);
			var drawx = 0 - (this.hotspotX * cr.abs(w))
			var drawy = 0 - (this.hotspotY * cr.abs(h));
			if (spritesheeted)
			{
				ctx.drawImage(cur_image, cur_frame.offx, cur_frame.offy, cur_frame.width, cur_frame.height,
										 drawx, drawy, cr.abs(w), cr.abs(h));
			}
			else
			{
				ctx.drawImage(cur_image, drawx, drawy, cr.abs(w), cr.abs(h));
			}
			ctx.restore();
		}
		/*
		ctx.strokeStyle = "#f00";
		ctx.lineWidth = 3;
		ctx.beginPath();
		this.collision_poly.cache_poly(this.width, this.height, this.angle);
		var i, len, ax, ay, bx, by;
		for (i = 0, len = this.collision_poly.pts_count; i < len; i++)
		{
			ax = this.collision_poly.pts_cache[i*2] + this.x;
			ay = this.collision_poly.pts_cache[i*2+1] + this.y;
			bx = this.collision_poly.pts_cache[((i+1)%len)*2] + this.x;
			by = this.collision_poly.pts_cache[((i+1)%len)*2+1] + this.y;
			ctx.moveTo(ax, ay);
			ctx.lineTo(bx, by);
		}
		ctx.stroke();
		ctx.closePath();
		*/
		/*
		if (this.behavior_insts.length >= 1 && this.behavior_insts[0].draw)
		{
			this.behavior_insts[0].draw(ctx);
		}
		*/
	};
	instanceProto.drawGL = function(glw)
	{
		glw.setTexture(this.curWebGLTexture);
		glw.setOpacity(this.opacity);
		var cur_frame = this.curFrame;
		var q = this.bquad;
		if (this.runtime.pixel_rounding)
		{
			var ox = ((this.x + 0.5) | 0) - this.x;
			var oy = ((this.y + 0.5) | 0) - this.y;
			if (cur_frame.spritesheeted)
				glw.quadTex(q.tlx + ox, q.tly + oy, q.trx + ox, q.try_ + oy, q.brx + ox, q.bry + oy, q.blx + ox, q.bly + oy, cur_frame.sheetTex);
			else
				glw.quad(q.tlx + ox, q.tly + oy, q.trx + ox, q.try_ + oy, q.brx + ox, q.bry + oy, q.blx + ox, q.bly + oy);
		}
		else
		{
			if (cur_frame.spritesheeted)
				glw.quadTex(q.tlx, q.tly, q.trx, q.try_, q.brx, q.bry, q.blx, q.bly, cur_frame.sheetTex);
			else
				glw.quad(q.tlx, q.tly, q.trx, q.try_, q.brx, q.bry, q.blx, q.bly);
		}
	};
	instanceProto.getImagePointIndexByName = function(name_)
	{
		var cur_frame = this.curFrame;
		var i, len;
		for (i = 0, len = cur_frame.image_points.length; i < len; i++)
		{
			if (cr.equals_nocase(name_, cur_frame.image_points[i][0]))
				return i;
		}
		return -1;
	};
	instanceProto.getImagePoint = function(imgpt, getX)
	{
		var cur_frame = this.curFrame;
		var image_points = cur_frame.image_points;
		var index;
		if (cr.is_string(imgpt))
			index = this.getImagePointIndexByName(imgpt);
		else
			index = imgpt - 1;	// 0 is origin
		index = cr.floor(index);
		if (index < 0 || index >= image_points.length)
			return getX ? this.x : this.y;	// return origin
		var x = (image_points[index][1] - cur_frame.hotspotX) * this.width;
		var y = image_points[index][2];
		y = (y - cur_frame.hotspotY) * this.height;
		var cosa = Math.cos(this.angle);
		var sina = Math.sin(this.angle);
		var x_temp = (x * cosa) - (y * sina);
		y = (y * cosa) + (x * sina);
		x = x_temp;
		x += this.x;
		y += this.y;
		return getX ? x : y;
	};
	function Cnds() {};
	var arrCache = [];
	function allocArr()
	{
		if (arrCache.length)
			return arrCache.pop();
		else
			return [0, 0, 0];
	};
	function freeArr(a)
	{
		a[0] = 0;
		a[1] = 0;
		a[2] = 0;
		arrCache.push(a);
	};
	function makeCollKey(a, b)
	{
		if (a < b)
			return "" + a + "," + b;
		else
			return "" + b + "," + a;
	};
	function collmemory_add(collmemory, a, b, tickcount)
	{
		var a_uid = a.uid;
		var b_uid = b.uid;
		var key = makeCollKey(a_uid, b_uid);
		if (collmemory.hasOwnProperty(key))
		{
			collmemory[key][2] = tickcount;
			return;
		}
		var arr = allocArr();
		arr[0] = a_uid;
		arr[1] = b_uid;
		arr[2] = tickcount;
		collmemory[key] = arr;
	};
	function collmemory_remove(collmemory, a, b)
	{
		var key = makeCollKey(a.uid, b.uid);
		if (collmemory.hasOwnProperty(key))
		{
			freeArr(collmemory[key]);
			delete collmemory[key];
		}
	};
	function collmemory_removeInstance(collmemory, inst)
	{
		var uid = inst.uid;
		var p, entry;
		for (p in collmemory)
		{
			if (collmemory.hasOwnProperty(p))
			{
				entry = collmemory[p];
				if (entry[0] === uid || entry[1] === uid)
				{
					freeArr(collmemory[p]);
					delete collmemory[p];
				}
			}
		}
	};
	var last_coll_tickcount = -2;
	function collmemory_has(collmemory, a, b)
	{
		var key = makeCollKey(a.uid, b.uid);
		if (collmemory.hasOwnProperty(key))
		{
			last_coll_tickcount = collmemory[key][2];
			return true;
		}
		else
		{
			last_coll_tickcount = -2;
			return false;
		}
	};
	var candidates = [];
	Cnds.prototype.OnCollision = function (rtype)
	{
		if (!rtype)
			return false;
		var runtime = this.runtime;
		var cnd = runtime.getCurrentCondition();
		var ltype = cnd.type;
		if (!cnd.extra.collmemory)
		{
			cnd.extra.collmemory = {};
			runtime.addDestroyCallback((function (collmemory) {
				return function(inst) {
					collmemory_removeInstance(collmemory, inst);
				};
			})(cnd.extra.collmemory));
		}
		var collmemory = cnd.extra.collmemory;
		var lsol = ltype.getCurrentSol();
		var rsol = rtype.getCurrentSol();
		var linstances = lsol.getObjects();
		var rinstances;
		var l, linst, r, rinst;
		var curlsol, currsol;
		var tickcount = this.runtime.tickcount;
		var lasttickcount = tickcount - 1;
		var exists, run;
		var current_event = runtime.getCurrentEventStack().current_event;
		var orblock = current_event.orblock;
		for (l = 0; l < linstances.length; l++)
		{
			linst = linstances[l];
			if (rsol.select_all)
			{
				linst.update_bbox();
				this.runtime.getCollisionCandidates(linst.layer, rtype, linst.bbox, candidates);
				rinstances = candidates;
			}
			else
				rinstances = rsol.getObjects();
			for (r = 0; r < rinstances.length; r++)
			{
				rinst = rinstances[r];
				if (runtime.testOverlap(linst, rinst) || runtime.checkRegisteredCollision(linst, rinst))
				{
					exists = collmemory_has(collmemory, linst, rinst);
					run = (!exists || (last_coll_tickcount < lasttickcount));
					collmemory_add(collmemory, linst, rinst, tickcount);
					if (run)
					{
						runtime.pushCopySol(current_event.solModifiers);
						curlsol = ltype.getCurrentSol();
						currsol = rtype.getCurrentSol();
						curlsol.select_all = false;
						currsol.select_all = false;
						if (ltype === rtype)
						{
							curlsol.instances.length = 2;	// just use lsol, is same reference as rsol
							curlsol.instances[0] = linst;
							curlsol.instances[1] = rinst;
							ltype.applySolToContainer();
						}
						else
						{
							curlsol.instances.length = 1;
							currsol.instances.length = 1;
							curlsol.instances[0] = linst;
							currsol.instances[0] = rinst;
							ltype.applySolToContainer();
							rtype.applySolToContainer();
						}
						current_event.retrigger();
						runtime.popSol(current_event.solModifiers);
					}
				}
				else
				{
					collmemory_remove(collmemory, linst, rinst);
				}
			}
			candidates.length = 0;
		}
		return false;
	};
	var rpicktype = null;
	var rtopick = new cr.ObjectSet();
	var needscollisionfinish = false;
	function DoOverlapCondition(rtype, offx, offy)
	{
		if (!rtype)
			return false;
		var do_offset = (offx !== 0 || offy !== 0);
		var oldx, oldy, ret = false, r, lenr, rinst;
		var cnd = this.runtime.getCurrentCondition();
		var ltype = cnd.type;
		var inverted = cnd.inverted;
		var rsol = rtype.getCurrentSol();
		var orblock = this.runtime.getCurrentEventStack().current_event.orblock;
		var rinstances;
		if (rsol.select_all)
		{
			this.update_bbox();
			this.runtime.getCollisionCandidates(this.layer, rtype, this.bbox, candidates);
			rinstances = candidates;
		}
		else if (orblock)
			rinstances = rsol.else_instances;
		else
			rinstances = rsol.instances;
		rpicktype = rtype;
		needscollisionfinish = (ltype !== rtype && !inverted);
		if (do_offset)
		{
			oldx = this.x;
			oldy = this.y;
			this.x += offx;
			this.y += offy;
			this.set_bbox_changed();
		}
		for (r = 0, lenr = rinstances.length; r < lenr; r++)
		{
			rinst = rinstances[r];
			if (this.runtime.testOverlap(this, rinst))
			{
				ret = true;
				if (inverted)
					break;
				if (ltype !== rtype)
					rtopick.add(rinst);
			}
		}
		if (do_offset)
		{
			this.x = oldx;
			this.y = oldy;
			this.set_bbox_changed();
		}
		candidates.length = 0;
		return ret;
	};
	typeProto.finish = function (do_pick)
	{
		if (!needscollisionfinish)
			return;
		if (do_pick)
		{
			var orblock = this.runtime.getCurrentEventStack().current_event.orblock;
			var sol = rpicktype.getCurrentSol();
			var topick = rtopick.valuesRef();
			var i, len, inst;
			if (sol.select_all)
			{
				sol.select_all = false;
				sol.instances.length = topick.length;
				for (i = 0, len = topick.length; i < len; i++)
				{
					sol.instances[i] = topick[i];
				}
				if (orblock)
				{
					sol.else_instances.length = 0;
					for (i = 0, len = rpicktype.instances.length; i < len; i++)
					{
						inst = rpicktype.instances[i];
						if (!rtopick.contains(inst))
							sol.else_instances.push(inst);
					}
				}
			}
			else
			{
				if (orblock)
				{
					var initsize = sol.instances.length;
					sol.instances.length = initsize + topick.length;
					for (i = 0, len = topick.length; i < len; i++)
					{
						sol.instances[initsize + i] = topick[i];
						cr.arrayFindRemove(sol.else_instances, topick[i]);
					}
				}
				else
				{
					cr.shallowAssignArray(sol.instances, topick);
				}
			}
			rpicktype.applySolToContainer();
		}
		rtopick.clear();
		needscollisionfinish = false;
	};
	Cnds.prototype.IsOverlapping = function (rtype)
	{
		return DoOverlapCondition.call(this, rtype, 0, 0);
	};
	Cnds.prototype.IsOverlappingOffset = function (rtype, offx, offy)
	{
		return DoOverlapCondition.call(this, rtype, offx, offy);
	};
	Cnds.prototype.IsAnimPlaying = function (animname)
	{
		if (this.changeAnimName.length)
			return cr.equals_nocase(this.changeAnimName, animname);
		else
			return cr.equals_nocase(this.cur_animation.name, animname);
	};
	Cnds.prototype.CompareFrame = function (cmp, framenum)
	{
		return cr.do_cmp(this.cur_frame, cmp, framenum);
	};
	Cnds.prototype.CompareAnimSpeed = function (cmp, x)
	{
		var s = (this.animForwards ? this.cur_anim_speed : -this.cur_anim_speed);
		return cr.do_cmp(s, cmp, x);
	};
	Cnds.prototype.OnAnimFinished = function (animname)
	{
		return cr.equals_nocase(this.animTriggerName, animname);
	};
	Cnds.prototype.OnAnyAnimFinished = function ()
	{
		return true;
	};
	Cnds.prototype.OnFrameChanged = function ()
	{
		return true;
	};
	Cnds.prototype.IsMirrored = function ()
	{
		return this.width < 0;
	};
	Cnds.prototype.IsFlipped = function ()
	{
		return this.height < 0;
	};
	Cnds.prototype.OnURLLoaded = function ()
	{
		return true;
	};
	Cnds.prototype.IsCollisionEnabled = function ()
	{
		return this.collisionsEnabled;
	};
	pluginProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.Spawn = function (obj, layer, imgpt)
	{
		if (!obj || !layer)
			return;
		var inst = this.runtime.createInstance(obj, layer, this.getImagePoint(imgpt, true), this.getImagePoint(imgpt, false));
		if (!inst)
			return;
		if (typeof inst.angle !== "undefined")
		{
			inst.angle = this.angle;
			inst.set_bbox_changed();
		}
		this.runtime.isInOnDestroy++;
		var i, len, s;
		this.runtime.trigger(Object.getPrototypeOf(obj.plugin).cnds.OnCreated, inst);
		if (inst.is_contained)
		{
			for (i = 0, len = inst.siblings.length; i < len; i++)
			{
				s = inst.siblings[i];
				this.runtime.trigger(Object.getPrototypeOf(s.type.plugin).cnds.OnCreated, s);
			}
		}
		this.runtime.isInOnDestroy--;
		var cur_act = this.runtime.getCurrentAction();
		var reset_sol = false;
		if (cr.is_undefined(cur_act.extra.Spawn_LastExec) || cur_act.extra.Spawn_LastExec < this.runtime.execcount)
		{
			reset_sol = true;
			cur_act.extra.Spawn_LastExec = this.runtime.execcount;
		}
		var sol;
		if (obj != this.type)
		{
			sol = obj.getCurrentSol();
			sol.select_all = false;
			if (reset_sol)
			{
				sol.instances.length = 1;
				sol.instances[0] = inst;
			}
			else
				sol.instances.push(inst);
			if (inst.is_contained)
			{
				for (i = 0, len = inst.siblings.length; i < len; i++)
				{
					s = inst.siblings[i];
					sol = s.type.getCurrentSol();
					sol.select_all = false;
					if (reset_sol)
					{
						sol.instances.length = 1;
						sol.instances[0] = s;
					}
					else
						sol.instances.push(s);
				}
			}
		}
	};
	Acts.prototype.SetEffect = function (effect)
	{
		this.compositeOp = cr.effectToCompositeOp(effect);
		cr.setGLBlend(this, effect, this.runtime.gl);
		this.runtime.redraw = true;
	};
	Acts.prototype.StopAnim = function ()
	{
		this.animPlaying = false;
	};
	Acts.prototype.StartAnim = function (from)
	{
		this.animPlaying = true;
		this.frameStart = this.getNowTime();
		if (from === 1 && this.cur_frame !== 0)
		{
			this.changeAnimFrame = 0;
			if (!this.inAnimTrigger)
				this.doChangeAnimFrame();
		}
		if (!this.isTicking)
		{
			this.runtime.tickMe(this);
			this.isTicking = true;
		}
	};
	Acts.prototype.SetAnim = function (animname, from)
	{
		this.changeAnimName = animname;
		this.changeAnimFrom = from;
		if (!this.isTicking)
		{
			this.runtime.tickMe(this);
			this.isTicking = true;
		}
		if (!this.inAnimTrigger)
			this.doChangeAnim();
	};
	Acts.prototype.SetAnimFrame = function (framenumber)
	{
		this.changeAnimFrame = framenumber;
		if (!this.isTicking)
		{
			this.runtime.tickMe(this);
			this.isTicking = true;
		}
		if (!this.inAnimTrigger)
			this.doChangeAnimFrame();
	};
	Acts.prototype.SetAnimSpeed = function (s)
	{
		this.cur_anim_speed = cr.abs(s);
		this.animForwards = (s >= 0);
		if (!this.isTicking)
		{
			this.runtime.tickMe(this);
			this.isTicking = true;
		}
	};
	Acts.prototype.SetMirrored = function (m)
	{
		var neww = cr.abs(this.width) * (m === 0 ? -1 : 1);
		if (this.width === neww)
			return;
		this.width = neww;
		this.set_bbox_changed();
	};
	Acts.prototype.SetFlipped = function (f)
	{
		var newh = cr.abs(this.height) * (f === 0 ? -1 : 1);
		if (this.height === newh)
			return;
		this.height = newh;
		this.set_bbox_changed();
	};
	Acts.prototype.SetScale = function (s)
	{
		var cur_frame = this.curFrame;
		var mirror_factor = (this.width < 0 ? -1 : 1);
		var flip_factor = (this.height < 0 ? -1 : 1);
		var new_width = cur_frame.width * s * mirror_factor;
		var new_height = cur_frame.height * s * flip_factor;
		if (this.width !== new_width || this.height !== new_height)
		{
			this.width = new_width;
			this.height = new_height;
			this.set_bbox_changed();
		}
	};
	Acts.prototype.LoadURL = function (url_, resize_)
	{
		var img = new Image();
		var self = this;
		var curFrame_ = this.curFrame;
		img.onload = function ()
		{
			if (curFrame_.texture_img.src === img.src)
			{
				if (self.runtime.glwrap && self.curFrame === curFrame_)
					self.curWebGLTexture = curFrame_.webGL_texture;
				self.runtime.redraw = true;
				self.runtime.trigger(cr.plugins_.Sprite.prototype.cnds.OnURLLoaded, self);
				return;
			}
			curFrame_.texture_img = img;
			curFrame_.offx = 0;
			curFrame_.offy = 0;
			curFrame_.width = img.width;
			curFrame_.height = img.height;
			curFrame_.spritesheeted = false;
			curFrame_.datauri = "";
			if (self.runtime.glwrap)
			{
				if (curFrame_.webGL_texture)
					self.runtime.glwrap.deleteTexture(curFrame_.webGL_texture);
				curFrame_.webGL_texture = self.runtime.glwrap.loadTexture(img, false, self.runtime.linearSampling);
				if (self.curFrame === curFrame_)
					self.curWebGLTexture = curFrame_.webGL_texture;
				self.type.updateAllCurrentTexture();
			}
			if (resize_ === 0)		// resize to image size
			{
				self.width = img.width;
				self.height = img.height;
				self.set_bbox_changed();
			}
			self.runtime.redraw = true;
			self.runtime.trigger(cr.plugins_.Sprite.prototype.cnds.OnURLLoaded, self);
		};
		if (url_.substr(0, 5) !== "data:")
			img.crossOrigin = 'anonymous';
		img.src = url_;
	};
	Acts.prototype.SetCollisions = function (set_)
	{
		if (this.collisionsEnabled === (set_ !== 0))
			return;		// no change
		this.collisionsEnabled = (set_ !== 0);
		if (this.collisionsEnabled)
			this.set_bbox_changed();		// needs to be added back to cells
		else
		{
			if (this.collcells.right >= this.collcells.left)
				this.type.collision_grid.update(this, this.collcells, null);
			this.collcells.set(0, 0, -1, -1);
		}
	};
	pluginProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.AnimationFrame = function (ret)
	{
		ret.set_int(this.cur_frame);
	};
	Exps.prototype.AnimationFrameCount = function (ret)
	{
		ret.set_int(this.cur_animation.frames.length);
	};
	Exps.prototype.AnimationName = function (ret)
	{
		ret.set_string(this.cur_animation.name);
	};
	Exps.prototype.AnimationSpeed = function (ret)
	{
		ret.set_float(this.animForwards ? this.cur_anim_speed : -this.cur_anim_speed);
	};
	Exps.prototype.ImagePointX = function (ret, imgpt)
	{
		ret.set_float(this.getImagePoint(imgpt, true));
	};
	Exps.prototype.ImagePointY = function (ret, imgpt)
	{
		ret.set_float(this.getImagePoint(imgpt, false));
	};
	Exps.prototype.ImagePointCount = function (ret)
	{
		ret.set_int(this.curFrame.image_points.length);
	};
	Exps.prototype.ImageWidth = function (ret)
	{
		ret.set_float(this.curFrame.width);
	};
	Exps.prototype.ImageHeight = function (ret)
	{
		ret.set_float(this.curFrame.height);
	};
	pluginProto.exps = new Exps();
}());
;
;
cr.plugins_.Touch = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var pluginProto = cr.plugins_.Touch.prototype;
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	typeProto.onCreate = function()
	{
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
		this.touches = [];
		this.mouseDown = false;
	};
	var instanceProto = pluginProto.Instance.prototype;
	var dummyoffset = {left: 0, top: 0};
	instanceProto.findTouch = function (id)
	{
		var i, len;
		for (i = 0, len = this.touches.length; i < len; i++)
		{
			if (this.touches[i]["id"] === id)
				return i;
		}
		return -1;
	};
	var appmobi_accx = 0;
	var appmobi_accy = 0;
	var appmobi_accz = 0;
	function AppMobiGetAcceleration(evt)
	{
		appmobi_accx = evt.x;
		appmobi_accy = evt.y;
		appmobi_accz = evt.z;
	};
	var pg_accx = 0;
	var pg_accy = 0;
	var pg_accz = 0;
	function PhoneGapGetAcceleration(evt)
	{
		pg_accx = evt.x;
		pg_accy = evt.y;
		pg_accz = evt.z;
	};
	var theInstance = null;
	instanceProto.onCreate = function()
	{
		theInstance = this;
		this.isWindows8 = !!(typeof window["c2isWindows8"] !== "undefined" && window["c2isWindows8"]);
		this.orient_alpha = 0;
		this.orient_beta = 0;
		this.orient_gamma = 0;
		this.acc_g_x = 0;
		this.acc_g_y = 0;
		this.acc_g_z = 0;
		this.acc_x = 0;
		this.acc_y = 0;
		this.acc_z = 0;
		this.curTouchX = 0;
		this.curTouchY = 0;
		this.trigger_index = 0;
		this.trigger_id = 0;
		this.useMouseInput = (this.properties[0] !== 0);
		var elem = (this.runtime.fullscreen_mode > 0) ? document : this.runtime.canvas;
		var elem2 = document;
		if (this.runtime.isDirectCanvas)
			elem2 = elem = window["Canvas"];
		else if (this.runtime.isCocoonJs)
			elem2 = elem = window;
		var self = this;
		if (window.navigator["pointerEnabled"])
		{
			elem.addEventListener("pointerdown",
				function(info) {
					self.onPointerStart(info);
				},
				false
			);
			elem.addEventListener("pointermove",
				function(info) {
					self.onPointerMove(info);
				},
				false
			);
			elem2.addEventListener("pointerup",
				function(info) {
					self.onPointerEnd(info);
				},
				false
			);
			elem2.addEventListener("pointercancel",
				function(info) {
					self.onPointerEnd(info);
				},
				false
			);
			if (this.runtime.canvas)
			{
				this.runtime.canvas.addEventListener("MSGestureHold", function(e) {
					e.preventDefault();
				}, false);
				document.addEventListener("MSGestureHold", function(e) {
					e.preventDefault();
				}, false);
				this.runtime.canvas.addEventListener("gesturehold", function(e) {
					e.preventDefault();
				}, false);
				document.addEventListener("gesturehold", function(e) {
					e.preventDefault();
				}, false);
			}
		}
		else if (window.navigator["msPointerEnabled"])
		{
			elem.addEventListener("MSPointerDown",
				function(info) {
					self.onPointerStart(info);
				},
				false
			);
			elem.addEventListener("MSPointerMove",
				function(info) {
					self.onPointerMove(info);
				},
				false
			);
			elem2.addEventListener("MSPointerUp",
				function(info) {
					self.onPointerEnd(info);
				},
				false
			);
			elem2.addEventListener("MSPointerCancel",
				function(info) {
					self.onPointerEnd(info);
				},
				false
			);
			if (this.runtime.canvas)
			{
				this.runtime.canvas.addEventListener("MSGestureHold", function(e) {
					e.preventDefault();
				}, false);
				document.addEventListener("MSGestureHold", function(e) {
					e.preventDefault();
				}, false);
			}
		}
		else
		{
			elem.addEventListener("touchstart",
				function(info) {
					self.onTouchStart(info);
				},
				false
			);
			elem.addEventListener("touchmove",
				function(info) {
					self.onTouchMove(info);
				},
				false
			);
			elem2.addEventListener("touchend",
				function(info) {
					self.onTouchEnd(info);
				},
				false
			);
			elem2.addEventListener("touchcancel",
				function(info) {
					self.onTouchEnd(info);
				},
				false
			);
		}
		if (this.isWindows8)
		{
			var win8accelerometerFn = function(e) {
					var reading = e["reading"];
					self.acc_x = reading["accelerationX"];
					self.acc_y = reading["accelerationY"];
					self.acc_z = reading["accelerationZ"];
				};
			var win8inclinometerFn = function(e) {
					var reading = e["reading"];
					self.orient_alpha = reading["yawDegrees"];
					self.orient_beta = reading["pitchDegrees"];
					self.orient_gamma = reading["rollDegrees"];
				};
			var accelerometer = Windows["Devices"]["Sensors"]["Accelerometer"]["getDefault"]();
            if (accelerometer)
			{
                accelerometer["reportInterval"] = Math.max(accelerometer["minimumReportInterval"], 16);
				accelerometer.addEventListener("readingchanged", win8accelerometerFn);
            }
			var inclinometer = Windows["Devices"]["Sensors"]["Inclinometer"]["getDefault"]();
			if (inclinometer)
			{
				inclinometer["reportInterval"] = Math.max(inclinometer["minimumReportInterval"], 16);
				inclinometer.addEventListener("readingchanged", win8inclinometerFn);
			}
			document.addEventListener("visibilitychange", function(e) {
				if (document["hidden"] || document["msHidden"])
				{
					if (accelerometer)
						accelerometer.removeEventListener("readingchanged", win8accelerometerFn);
					if (inclinometer)
						inclinometer.removeEventListener("readingchanged", win8inclinometerFn);
				}
				else
				{
					if (accelerometer)
						accelerometer.addEventListener("readingchanged", win8accelerometerFn);
					if (inclinometer)
						inclinometer.addEventListener("readingchanged", win8inclinometerFn);
				}
			}, false);
		}
		else
		{
			window.addEventListener("deviceorientation", function (eventData) {
				self.orient_alpha = eventData["alpha"] || 0;
				self.orient_beta = eventData["beta"] || 0;
				self.orient_gamma = eventData["gamma"] || 0;
			}, false);
			window.addEventListener("devicemotion", function (eventData) {
				if (eventData["accelerationIncludingGravity"])
				{
					self.acc_g_x = eventData["accelerationIncludingGravity"]["x"] || 0;
					self.acc_g_y = eventData["accelerationIncludingGravity"]["y"] || 0;
					self.acc_g_z = eventData["accelerationIncludingGravity"]["z"] || 0;
				}
				if (eventData["acceleration"])
				{
					self.acc_x = eventData["acceleration"]["x"] || 0;
					self.acc_y = eventData["acceleration"]["y"] || 0;
					self.acc_z = eventData["acceleration"]["z"] || 0;
				}
			}, false);
		}
		if (this.useMouseInput && !this.runtime.isDomFree)
		{
			jQuery(document).mousemove(
				function(info) {
					self.onMouseMove(info);
				}
			);
			jQuery(document).mousedown(
				function(info) {
					self.onMouseDown(info);
				}
			);
			jQuery(document).mouseup(
				function(info) {
					self.onMouseUp(info);
				}
			);
		}
		if (this.runtime.isAppMobi && !this.runtime.isDirectCanvas)
		{
			AppMobi["accelerometer"]["watchAcceleration"](AppMobiGetAcceleration, { "frequency": 40, "adjustForRotation": true });
		}
		if (this.runtime.isPhoneGap && navigator["accelerometer"] && navigator["accelerometer"]["watchAcceleration"])
		{
			navigator["accelerometer"]["watchAcceleration"](PhoneGapGetAcceleration, null, { "frequency": 40 });
		}
		this.runtime.tick2Me(this);
	};
	instanceProto.onPointerMove = function (info)
	{
		if (info["pointerType"] === info["MSPOINTER_TYPE_MOUSE"] || info["pointerType"] === "mouse")
			return;
		if (info.preventDefault)
			info.preventDefault();
		var i = this.findTouch(info["pointerId"]);
		var nowtime = cr.performance_now();
		if (i >= 0)
		{
			var offset = this.runtime.isDomFree ? dummyoffset : jQuery(this.runtime.canvas).offset();
			var t = this.touches[i];
			if (nowtime - t.time < 2)
				return;
			t.lasttime = t.time;
			t.lastx = t.x;
			t.lasty = t.y;
			t.time = nowtime;
			t.x = info.pageX - offset.left;
			t.y = info.pageY - offset.top;
		}
	};
	instanceProto.onPointerStart = function (info)
	{
		if (info["pointerType"] === info["MSPOINTER_TYPE_MOUSE"] || info["pointerType"] === "mouse")
			return;
		if (info.preventDefault)
			info.preventDefault();
		var offset = this.runtime.isDomFree ? dummyoffset : jQuery(this.runtime.canvas).offset();
		var touchx = info.pageX - offset.left;
		var touchy = info.pageY - offset.top;
		var nowtime = cr.performance_now();
		this.trigger_index = this.touches.length;
		this.trigger_id = info["pointerId"];
		this.touches.push({ time: nowtime,
							x: touchx,
							y: touchy,
							lasttime: nowtime,
							lastx: touchx,
							lasty: touchy,
							"id": info["pointerId"],
							startindex: this.trigger_index
						});
		this.runtime.isInUserInputEvent = true;
		this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnNthTouchStart, this);
		this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnTouchStart, this);
		this.curTouchX = touchx;
		this.curTouchY = touchy;
		this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnTouchObject, this);
		this.runtime.isInUserInputEvent = false;
	};
	instanceProto.onPointerEnd = function (info)
	{
		if (info["pointerType"] === info["MSPOINTER_TYPE_MOUSE"] || info["pointerType"] === "mouse")
			return;
		if (info.preventDefault)
			info.preventDefault();
		var i = this.findTouch(info["pointerId"]);
		this.trigger_index = (i >= 0 ? this.touches[i].startindex : -1);
		this.trigger_id = (i >= 0 ? this.touches[i]["id"] : -1);
		this.runtime.isInUserInputEvent = true;
		this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnNthTouchEnd, this);
		this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnTouchEnd, this);
		this.runtime.isInUserInputEvent = false;
		if (i >= 0)
		{
			this.touches.splice(i, 1);
		}
	};
	instanceProto.onTouchMove = function (info)
	{
		if (info.preventDefault)
			info.preventDefault();
		var nowtime = cr.performance_now();
		var i, len, t, u;
		for (i = 0, len = info.changedTouches.length; i < len; i++)
		{
			t = info.changedTouches[i];
			var j = this.findTouch(t["identifier"]);
			if (j >= 0)
			{
				var offset = this.runtime.isDomFree ? dummyoffset : jQuery(this.runtime.canvas).offset();
				u = this.touches[j];
				if (nowtime - u.time < 2)
					continue;
				u.lasttime = u.time;
				u.lastx = u.x;
				u.lasty = u.y;
				u.time = nowtime;
				u.x = t.pageX - offset.left;
				u.y = t.pageY - offset.top;
			}
		}
	};
	instanceProto.onTouchStart = function (info)
	{
		if (info.preventDefault)
			info.preventDefault();
		var offset = this.runtime.isDomFree ? dummyoffset : jQuery(this.runtime.canvas).offset();
		var nowtime = cr.performance_now();
		this.runtime.isInUserInputEvent = true;
		var i, len, t, j;
		for (i = 0, len = info.changedTouches.length; i < len; i++)
		{
			t = info.changedTouches[i];
			j = this.findTouch(t["identifier"]);
			if (j !== -1)
				continue;
			var touchx = t.pageX - offset.left;
			var touchy = t.pageY - offset.top;
			this.trigger_index = this.touches.length;
			this.trigger_id = t["identifier"];
			this.touches.push({ time: nowtime,
								x: touchx,
								y: touchy,
								lasttime: nowtime,
								lastx: touchx,
								lasty: touchy,
								"id": t["identifier"],
								startindex: this.trigger_index
							});
			this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnNthTouchStart, this);
			this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnTouchStart, this);
			this.curTouchX = touchx;
			this.curTouchY = touchy;
			this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnTouchObject, this);
		}
		this.runtime.isInUserInputEvent = false;
	};
	instanceProto.onTouchEnd = function (info)
	{
		if (info.preventDefault)
			info.preventDefault();
		this.runtime.isInUserInputEvent = true;
		var i, len, t, j;
		for (i = 0, len = info.changedTouches.length; i < len; i++)
		{
			t = info.changedTouches[i];
			j = this.findTouch(t["identifier"]);
			if (j >= 0)
			{
				this.trigger_index = this.touches[j].startindex;
				this.trigger_id = this.touches[j]["id"];
				this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnNthTouchEnd, this);
				this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnTouchEnd, this);
				this.touches.splice(j, 1);
			}
		}
		this.runtime.isInUserInputEvent = false;
	};
	instanceProto.getAlpha = function ()
	{
		if (this.runtime.isAppMobi && this.orient_alpha === 0 && appmobi_accz !== 0)
			return appmobi_accz * 90;
		else if (this.runtime.isPhoneGap  && this.orient_alpha === 0 && pg_accz !== 0)
			return pg_accz * 90;
		else
			return this.orient_alpha;
	};
	instanceProto.getBeta = function ()
	{
		if (this.runtime.isAppMobi && this.orient_beta === 0 && appmobi_accy !== 0)
			return appmobi_accy * -90;
		else if (this.runtime.isPhoneGap  && this.orient_beta === 0 && pg_accy !== 0)
			return pg_accy * -90;
		else
			return this.orient_beta;
	};
	instanceProto.getGamma = function ()
	{
		if (this.runtime.isAppMobi && this.orient_gamma === 0 && appmobi_accx !== 0)
			return appmobi_accx * 90;
		else if (this.runtime.isPhoneGap  && this.orient_gamma === 0 && pg_accx !== 0)
			return pg_accx * 90;
		else
			return this.orient_gamma;
	};
	var noop_func = function(){};
	instanceProto.onMouseDown = function(info)
	{
		if (info.preventDefault && this.runtime.had_a_click && !this.runtime.isMobile)
			info.preventDefault();
		var t = { pageX: info.pageX, pageY: info.pageY, "identifier": 0 };
		var fakeinfo = { changedTouches: [t] };
		this.onTouchStart(fakeinfo);
		this.mouseDown = true;
	};
	instanceProto.onMouseMove = function(info)
	{
		if (!this.mouseDown)
			return;
		var t = { pageX: info.pageX, pageY: info.pageY, "identifier": 0 };
		var fakeinfo = { changedTouches: [t] };
		this.onTouchMove(fakeinfo);
	};
	instanceProto.onMouseUp = function(info)
	{
		if (info.preventDefault && this.runtime.had_a_click && !this.runtime.isMobile)
			info.preventDefault();
		this.runtime.had_a_click = true;
		var t = { pageX: info.pageX, pageY: info.pageY, "identifier": 0 };
		var fakeinfo = { changedTouches: [t] };
		this.onTouchEnd(fakeinfo);
		this.mouseDown = false;
	};
	instanceProto.tick2 = function()
	{
		var i, len, t;
		var nowtime = cr.performance_now();
		for (i = 0, len = this.touches.length; i < len; i++)
		{
			t = this.touches[i];
			if (t.time <= nowtime - 50)
				t.lasttime = nowtime;
		}
	};
	function Cnds() {};
	Cnds.prototype.OnTouchStart = function ()
	{
		return true;
	};
	Cnds.prototype.OnTouchEnd = function ()
	{
		return true;
	};
	Cnds.prototype.IsInTouch = function ()
	{
		return this.touches.length;
	};
	Cnds.prototype.OnTouchObject = function (type)
	{
		if (!type)
			return false;
		return this.runtime.testAndSelectCanvasPointOverlap(type, this.curTouchX, this.curTouchY, false);
	};
	Cnds.prototype.IsTouchingObject = function (type)
	{
		if (!type)
			return false;
		var sol = type.getCurrentSol();
		var instances = sol.getObjects();
		var px, py;
		var touching = [];
		var i, leni, j, lenj;
		for (i = 0, leni = instances.length; i < leni; i++)
		{
			var inst = instances[i];
			inst.update_bbox();
			for (j = 0, lenj = this.touches.length; j < lenj; j++)
			{
				var touch = this.touches[j];
				px = inst.layer.canvasToLayer(touch.x, touch.y, true);
				py = inst.layer.canvasToLayer(touch.x, touch.y, false);
				if (inst.contains_pt(px, py))
				{
					touching.push(inst);
					break;
				}
			}
		}
		if (touching.length)
		{
			sol.select_all = false;
			sol.instances = touching;
			type.applySolToContainer();
			return true;
		}
		else
			return false;
	};
	Cnds.prototype.CompareTouchSpeed = function (index, cmp, s)
	{
		index = Math.floor(index);
		if (index < 0 || index >= this.touches.length)
			return false;
		var t = this.touches[index];
		var dist = cr.distanceTo(t.x, t.y, t.lastx, t.lasty);
		var timediff = (t.time - t.lasttime) / 1000;
		var speed = 0;
		if (timediff > 0)
			speed = dist / timediff;
		return cr.do_cmp(speed, cmp, s);
	};
	Cnds.prototype.OrientationSupported = function ()
	{
		return typeof window["DeviceOrientationEvent"] !== "undefined";
	};
	Cnds.prototype.MotionSupported = function ()
	{
		return typeof window["DeviceMotionEvent"] !== "undefined";
	};
	Cnds.prototype.CompareOrientation = function (orientation_, cmp_, angle_)
	{
		var v = 0;
		if (orientation_ === 0)
			v = this.getAlpha();
		else if (orientation_ === 1)
			v = this.getBeta();
		else
			v = this.getGamma();
		return cr.do_cmp(v, cmp_, angle_);
	};
	Cnds.prototype.CompareAcceleration = function (acceleration_, cmp_, angle_)
	{
		var v = 0;
		if (acceleration_ === 0)
			v = this.acc_g_x;
		else if (acceleration_ === 1)
			v = this.acc_g_y;
		else if (acceleration_ === 2)
			v = this.acc_g_z;
		else if (acceleration_ === 3)
			v = this.acc_x;
		else if (acceleration_ === 4)
			v = this.acc_y;
		else if (acceleration_ === 5)
			v = this.acc_z;
		return cr.do_cmp(v, cmp_, angle_);
	};
	Cnds.prototype.OnNthTouchStart = function (touch_)
	{
		touch_ = Math.floor(touch_);
		return touch_ === this.trigger_index;
	};
	Cnds.prototype.OnNthTouchEnd = function (touch_)
	{
		touch_ = Math.floor(touch_);
		return touch_ === this.trigger_index;
	};
	Cnds.prototype.HasNthTouch = function (touch_)
	{
		touch_ = Math.floor(touch_);
		return this.touches.length >= touch_ + 1;
	};
	pluginProto.cnds = new Cnds();
	function Exps() {};
	Exps.prototype.TouchCount = function (ret)
	{
		ret.set_int(this.touches.length);
	};
	Exps.prototype.X = function (ret, layerparam)
	{
		if (this.touches.length)
		{
			var layer, oldScale, oldZoomRate, oldParallaxX, oldAngle;
			if (cr.is_undefined(layerparam))
			{
				layer = this.runtime.getLayerByNumber(0);
				oldScale = layer.scale;
				oldZoomRate = layer.zoomRate;
				oldParallaxX = layer.parallaxX;
				oldAngle = layer.angle;
				layer.scale = this.runtime.running_layout.scale;
				layer.zoomRate = 1.0;
				layer.parallaxX = 1.0;
				layer.angle = this.runtime.running_layout.angle;
				ret.set_float(layer.canvasToLayer(this.touches[0].x, this.touches[0].y, true));
				layer.scale = oldScale;
				layer.zoomRate = oldZoomRate;
				layer.parallaxX = oldParallaxX;
				layer.angle = oldAngle;
			}
			else
			{
				if (cr.is_number(layerparam))
					layer = this.runtime.getLayerByNumber(layerparam);
				else
					layer = this.runtime.getLayerByName(layerparam);
				if (layer)
					ret.set_float(layer.canvasToLayer(this.touches[0].x, this.touches[0].y, true));
				else
					ret.set_float(0);
			}
		}
		else
			ret.set_float(0);
	};
	Exps.prototype.XAt = function (ret, index, layerparam)
	{
		index = Math.floor(index);
		if (index < 0 || index >= this.touches.length)
		{
			ret.set_float(0);
			return;
		}
		var layer, oldScale, oldZoomRate, oldParallaxX, oldAngle;
		if (cr.is_undefined(layerparam))
		{
			layer = this.runtime.getLayerByNumber(0);
			oldScale = layer.scale;
			oldZoomRate = layer.zoomRate;
			oldParallaxX = layer.parallaxX;
			oldAngle = layer.angle;
			layer.scale = this.runtime.running_layout.scale;
			layer.zoomRate = 1.0;
			layer.parallaxX = 1.0;
			layer.angle = this.runtime.running_layout.angle;
			ret.set_float(layer.canvasToLayer(this.touches[index].x, this.touches[index].y, true));
			layer.scale = oldScale;
			layer.zoomRate = oldZoomRate;
			layer.parallaxX = oldParallaxX;
			layer.angle = oldAngle;
		}
		else
		{
			if (cr.is_number(layerparam))
				layer = this.runtime.getLayerByNumber(layerparam);
			else
				layer = this.runtime.getLayerByName(layerparam);
			if (layer)
				ret.set_float(layer.canvasToLayer(this.touches[index].x, this.touches[index].y, true));
			else
				ret.set_float(0);
		}
	};
	Exps.prototype.XForID = function (ret, id, layerparam)
	{
		var index = this.findTouch(id);
		if (index < 0)
		{
			ret.set_float(0);
			return;
		}
		var touch = this.touches[index];
		var layer, oldScale, oldZoomRate, oldParallaxX, oldAngle;
		if (cr.is_undefined(layerparam))
		{
			layer = this.runtime.getLayerByNumber(0);
			oldScale = layer.scale;
			oldZoomRate = layer.zoomRate;
			oldParallaxX = layer.parallaxX;
			oldAngle = layer.angle;
			layer.scale = this.runtime.running_layout.scale;
			layer.zoomRate = 1.0;
			layer.parallaxX = 1.0;
			layer.angle = this.runtime.running_layout.angle;
			ret.set_float(layer.canvasToLayer(touch.x, touch.y, true));
			layer.scale = oldScale;
			layer.zoomRate = oldZoomRate;
			layer.parallaxX = oldParallaxX;
			layer.angle = oldAngle;
		}
		else
		{
			if (cr.is_number(layerparam))
				layer = this.runtime.getLayerByNumber(layerparam);
			else
				layer = this.runtime.getLayerByName(layerparam);
			if (layer)
				ret.set_float(layer.canvasToLayer(touch.x, touch.y, true));
			else
				ret.set_float(0);
		}
	};
	Exps.prototype.Y = function (ret, layerparam)
	{
		if (this.touches.length)
		{
			var layer, oldScale, oldZoomRate, oldParallaxY, oldAngle;
			if (cr.is_undefined(layerparam))
			{
				layer = this.runtime.getLayerByNumber(0);
				oldScale = layer.scale;
				oldZoomRate = layer.zoomRate;
				oldParallaxY = layer.parallaxY;
				oldAngle = layer.angle;
				layer.scale = this.runtime.running_layout.scale;
				layer.zoomRate = 1.0;
				layer.parallaxY = 1.0;
				layer.angle = this.runtime.running_layout.angle;
				ret.set_float(layer.canvasToLayer(this.touches[0].x, this.touches[0].y, false));
				layer.scale = oldScale;
				layer.zoomRate = oldZoomRate;
				layer.parallaxY = oldParallaxY;
				layer.angle = oldAngle;
			}
			else
			{
				if (cr.is_number(layerparam))
					layer = this.runtime.getLayerByNumber(layerparam);
				else
					layer = this.runtime.getLayerByName(layerparam);
				if (layer)
					ret.set_float(layer.canvasToLayer(this.touches[0].x, this.touches[0].y, false));
				else
					ret.set_float(0);
			}
		}
		else
			ret.set_float(0);
	};
	Exps.prototype.YAt = function (ret, index, layerparam)
	{
		index = Math.floor(index);
		if (index < 0 || index >= this.touches.length)
		{
			ret.set_float(0);
			return;
		}
		var layer, oldScale, oldZoomRate, oldParallaxY, oldAngle;
		if (cr.is_undefined(layerparam))
		{
			layer = this.runtime.getLayerByNumber(0);
			oldScale = layer.scale;
			oldZoomRate = layer.zoomRate;
			oldParallaxY = layer.parallaxY;
			oldAngle = layer.angle;
			layer.scale = this.runtime.running_layout.scale;
			layer.zoomRate = 1.0;
			layer.parallaxY = 1.0;
			layer.angle = this.runtime.running_layout.angle;
			ret.set_float(layer.canvasToLayer(this.touches[index].x, this.touches[index].y, false));
			layer.scale = oldScale;
			layer.zoomRate = oldZoomRate;
			layer.parallaxY = oldParallaxY;
			layer.angle = oldAngle;
		}
		else
		{
			if (cr.is_number(layerparam))
				layer = this.runtime.getLayerByNumber(layerparam);
			else
				layer = this.runtime.getLayerByName(layerparam);
			if (layer)
				ret.set_float(layer.canvasToLayer(this.touches[index].x, this.touches[index].y, false));
			else
				ret.set_float(0);
		}
	};
	Exps.prototype.YForID = function (ret, id, layerparam)
	{
		var index = this.findTouch(id);
		if (index < 0)
		{
			ret.set_float(0);
			return;
		}
		var touch = this.touches[index];
		var layer, oldScale, oldZoomRate, oldParallaxY, oldAngle;
		if (cr.is_undefined(layerparam))
		{
			layer = this.runtime.getLayerByNumber(0);
			oldScale = layer.scale;
			oldZoomRate = layer.zoomRate;
			oldParallaxY = layer.parallaxY;
			oldAngle = layer.angle;
			layer.scale = this.runtime.running_layout.scale;
			layer.zoomRate = 1.0;
			layer.parallaxY = 1.0;
			layer.angle = this.runtime.running_layout.angle;
			ret.set_float(layer.canvasToLayer(touch.x, touch.y, false));
			layer.scale = oldScale;
			layer.zoomRate = oldZoomRate;
			layer.parallaxY = oldParallaxY;
			layer.angle = oldAngle;
		}
		else
		{
			if (cr.is_number(layerparam))
				layer = this.runtime.getLayerByNumber(layerparam);
			else
				layer = this.runtime.getLayerByName(layerparam);
			if (layer)
				ret.set_float(layer.canvasToLayer(touch.x, touch.y, false));
			else
				ret.set_float(0);
		}
	};
	Exps.prototype.AbsoluteX = function (ret)
	{
		if (this.touches.length)
			ret.set_float(this.touches[0].x);
		else
			ret.set_float(0);
	};
	Exps.prototype.AbsoluteXAt = function (ret, index)
	{
		index = Math.floor(index);
		if (index < 0 || index >= this.touches.length)
		{
			ret.set_float(0);
			return;
		}
		ret.set_float(this.touches[index].x);
	};
	Exps.prototype.AbsoluteXForID = function (ret, id)
	{
		var index = this.findTouch(id);
		if (index < 0)
		{
			ret.set_float(0);
			return;
		}
		var touch = this.touches[index];
		ret.set_float(touch.x);
	};
	Exps.prototype.AbsoluteY = function (ret)
	{
		if (this.touches.length)
			ret.set_float(this.touches[0].y);
		else
			ret.set_float(0);
	};
	Exps.prototype.AbsoluteYAt = function (ret, index)
	{
		index = Math.floor(index);
		if (index < 0 || index >= this.touches.length)
		{
			ret.set_float(0);
			return;
		}
		ret.set_float(this.touches[index].y);
	};
	Exps.prototype.AbsoluteYForID = function (ret, id)
	{
		var index = this.findTouch(id);
		if (index < 0)
		{
			ret.set_float(0);
			return;
		}
		var touch = this.touches[index];
		ret.set_float(touch.y);
	};
	Exps.prototype.SpeedAt = function (ret, index)
	{
		index = Math.floor(index);
		if (index < 0 || index >= this.touches.length)
		{
			ret.set_float(0);
			return;
		}
		var t = this.touches[index];
		var dist = cr.distanceTo(t.x, t.y, t.lastx, t.lasty);
		var timediff = (t.time - t.lasttime) / 1000;
		if (timediff === 0)
			ret.set_float(0);
		else
			ret.set_float(dist / timediff);
	};
	Exps.prototype.SpeedForID = function (ret, id)
	{
		var index = this.findTouch(id);
		if (index < 0)
		{
			ret.set_float(0);
			return;
		}
		var touch = this.touches[index];
		var dist = cr.distanceTo(touch.x, touch.y, touch.lastx, touch.lasty);
		var timediff = (touch.time - touch.lasttime) / 1000;
		if (timediff === 0)
			ret.set_float(0);
		else
			ret.set_float(dist / timediff);
	};
	Exps.prototype.AngleAt = function (ret, index)
	{
		index = Math.floor(index);
		if (index < 0 || index >= this.touches.length)
		{
			ret.set_float(0);
			return;
		}
		var t = this.touches[index];
		ret.set_float(cr.to_degrees(cr.angleTo(t.lastx, t.lasty, t.x, t.y)));
	};
	Exps.prototype.AngleForID = function (ret, id)
	{
		var index = this.findTouch(id);
		if (index < 0)
		{
			ret.set_float(0);
			return;
		}
		var touch = this.touches[index];
		ret.set_float(cr.to_degrees(cr.angleTo(touch.lastx, touch.lasty, touch.x, touch.y)));
	};
	Exps.prototype.Alpha = function (ret)
	{
		ret.set_float(this.getAlpha());
	};
	Exps.prototype.Beta = function (ret)
	{
		ret.set_float(this.getBeta());
	};
	Exps.prototype.Gamma = function (ret)
	{
		ret.set_float(this.getGamma());
	};
	Exps.prototype.AccelerationXWithG = function (ret)
	{
		ret.set_float(this.acc_g_x);
	};
	Exps.prototype.AccelerationYWithG = function (ret)
	{
		ret.set_float(this.acc_g_y);
	};
	Exps.prototype.AccelerationZWithG = function (ret)
	{
		ret.set_float(this.acc_g_z);
	};
	Exps.prototype.AccelerationX = function (ret)
	{
		ret.set_float(this.acc_x);
	};
	Exps.prototype.AccelerationY = function (ret)
	{
		ret.set_float(this.acc_y);
	};
	Exps.prototype.AccelerationZ = function (ret)
	{
		ret.set_float(this.acc_z);
	};
	Exps.prototype.TouchIndex = function (ret)
	{
		ret.set_int(this.trigger_index);
	};
	Exps.prototype.TouchID = function (ret)
	{
		ret.set_float(this.trigger_id);
	};
	pluginProto.exps = new Exps();
}());
var Box2D = (function () {
var Module = {};
function b(a){throw a;}var f=void 0,j=!0,l=null,n=!1;function aa(){return function(){}}var ca="object"===typeof process&&"function"===typeof require,da="object"===typeof window,ea="function"===typeof importScripts,fa=!da&&!ca&&!ea;"object"===typeof module&&(module.Z=Module);
if(ca){Module.print=function(a){process.stdout.write(a+"\n")};Module.printErr=function(a){process.stderr.write(a+"\n")};var ga=require("fs"),ha=require("path");Module.read=function(a,c){var a=ha.normalize(a),d=ga.readFileSync(a);!d&&a!=ha.resolve(a)&&(a=path.join(__dirname,"..","src",a),d=ga.readFileSync(a));d&&!c&&(d=d.toString());return d};Module.readBinary=function(a){return Module.read(a,j)};Module.load=function(a){ia(read(a))};Module.arguments||(Module.arguments=process.argv.slice(2))}
fa&&(Module.print=print,"undefined"!=typeof printErr&&(Module.printErr=printErr),Module.read=read,Module.readBinary=function(a){return read(a,"binary")},Module.arguments||("undefined"!=typeof scriptArgs?Module.arguments=scriptArgs:"undefined"!=typeof arguments&&(Module.arguments=arguments)));da&&!ea&&(Module.print||(Module.print=function(a){console.log(a)}),Module.printErr||(Module.printErr=function(a){console.log(a)}));
if(da||ea)Module.read=function(a){var c=new XMLHttpRequest;c.open("GET",a,n);c.send(l);return c.responseText},Module.arguments||"undefined"!=typeof arguments&&(Module.arguments=arguments);ea&&(Module.print||(Module.print=aa()),Module.load=importScripts);!ea&&(!da&&!ca&&!fa)&&b("Unknown runtime environment. Where are we?");function ia(a){eval.call(l,a)}"undefined"==!Module.load&&Module.read&&(Module.load=function(a){ia(Module.read(a))});Module.print||(Module.print=aa());
Module.printErr||(Module.printErr=Module.print);Module.arguments||(Module.arguments=[]);Module.print=Module.print;Module.i=Module.printErr;Module.preRun||(Module.preRun=[]);Module.postRun||(Module.postRun=[]);function ja(){return ka}function ma(a){ka=a}function na(a){if(1==oa)return 1;var c={"%i1":1,"%i8":1,"%i16":2,"%i32":4,"%i64":8,"%float":4,"%double":8}["%"+a];c||("*"==a.charAt(a.length-1)?c=oa:"i"==a[0]&&(a=parseInt(a.substr(1)),qa(0==a%8),c=a/8));return c}
function ra(a,c,d){d&&d.length?(d.splice||(d=Array.prototype.slice.call(d)),d.splice(0,0,c),Module["dynCall_"+a].apply(l,d)):Module["dynCall_"+a].call(l,c)}var sa=[l,l,l,l,l,l,l,l,l,l,l,l,l,l,l,l,l,l,l,l];function ta(a){for(var c=0;c<sa.length;c++)if(!sa[c])return sa[c]=a,2+2*c;b("Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.")}var ua;
function wa(){var a=[],c=0;this.G=function(d){d&=255;c&&(a.push(d),c--);if(0==a.length){if(128>d)return String.fromCharCode(d);a.push(d);c=191<d&&224>d?1:2;return""}if(0<c)return"";var d=a[0],e=a[1],g=a[2],d=191<d&&224>d?String.fromCharCode((d&31)<<6|e&63):String.fromCharCode((d&15)<<12|(e&63)<<6|g&63);a.length=0;return d};this.U=function(a){for(var a=unescape(encodeURIComponent(a)),c=[],g=0;g<a.length;g++)c.push(a.charCodeAt(g));return c}}
function xa(a){var c=ka;ka=ka+a|0;ka=ka+7>>3<<3;return c}function ya(a){var c=za;za=za+a|0;za=za+7>>3<<3;return c}function Aa(a){var c=Ba;Ba=Ba+a|0;Ba=Ba+7>>3<<3;Ba>=Ca&&Ea("Cannot enlarge memory arrays in asm.js. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value, or (2) set Module.TOTAL_MEMORY before the program runs.");return c}function Fa(a,c){return Math.ceil(a/(c?c:8))*(c?c:8)}var oa=4,Ga={},Ha=n,Ia;
function Ea(a){Module.print(a+":\n"+Error().stack);Ha=j;b("Assertion: "+a)}function qa(a,c){a||Ea("Assertion failed: "+c)}var Ja=this;Module.ccall=function(a,c,d,e){return Ka(La(a),c,d,e)};function La(a){try{var c=Ja.Module["_"+a];c||(c=eval("_"+a))}catch(d){}qa(c,"Cannot call unknown function "+a+" (perhaps LLVM optimizations or closure removed it?)");return c}
function Ka(a,c,d,e){function g(a,c){if("string"==c){if(a===l||a===f||0===a)return 0;h||(h=ja());var d=xa(a.length+1);Ma(a,d);return d}return"array"==c?(h||(h=ja()),d=xa(a.length),Na(a,d),d):a}var h=0,i=0,e=e?e.map(function(a){return g(a,d[i++])}):[];a=a.apply(l,e);"string"==c?c=Oa(a):(qa("array"!=c),c=a);h&&ma(h);return c}Module.cwrap=function(a,c,d){var e=La(a);return function(){return Ka(e,c,d,Array.prototype.slice.call(arguments))}};
function Pa(a,c,d){d=d||"i8";"*"===d.charAt(d.length-1)&&(d="i32");switch(d){case "i1":p[a]=c;break;case "i8":p[a]=c;break;case "i16":Qa[a>>1]=c;break;case "i32":q[a>>2]=c;break;case "i64":Ia=[c>>>0,(Math.min(+Math.floor(c/4294967296),4294967295)|0)>>>0];q[a>>2]=Ia[0];q[a+4>>2]=Ia[1];break;case "float":Ra[a>>2]=c;break;case "double":Sa[a>>3]=c;break;default:Ea("invalid type for setValue: "+d)}}Module.setValue=Pa;
function Ta(a,c){c=c||"i8";"*"===c.charAt(c.length-1)&&(c="i32");switch(c){case "i1":return p[a];case "i8":return p[a];case "i16":return Qa[a>>1];case "i32":return q[a>>2];case "i64":return q[a>>2];case "float":return Ra[a>>2];case "double":return Sa[a>>3];default:Ea("invalid type for setValue: "+c)}return l}Module.getValue=Ta;var Ua=1,Va=2,Wa=4;Module.ALLOC_NORMAL=0;Module.ALLOC_STACK=Ua;Module.ALLOC_STATIC=Va;Module.ALLOC_DYNAMIC=3;Module.ALLOC_NONE=Wa;
function Xa(a,c,d,e){var g,h;"number"===typeof a?(g=j,h=a):(g=n,h=a.length);var i="string"===typeof c?c:l,d=d==Wa?e:[Ya,xa,ya,Aa][d===f?Va:d](Math.max(h,i?1:c.length));if(g){e=d;qa(0==(d&3));for(a=d+(h&-4);e<a;e+=4)q[e>>2]=0;for(a=d+h;e<a;)p[e++|0]=0;return d}if("i8"===i)return a.subarray||a.slice?Za.set(a,d):Za.set(new Uint8Array(a),d),d;for(var e=0,k,r;e<h;){var H=a[e];"function"===typeof H&&(H=Ga.$(H));g=i||c[e];0===g?e++:("i64"==g&&(g="i32"),Pa(d+e,H,g),r!==g&&(k=na(g),r=g),e+=k)}return d}
Module.allocate=Xa;function Oa(a,c){for(var d=n,e,g=0;;){e=Za[a+g|0];if(128<=e)d=j;else if(0==e&&!c)break;g++;if(c&&g==c)break}c||(c=g);var h="";if(!d){for(;0<c;)e=String.fromCharCode.apply(String,Za.subarray(a,a+Math.min(c,1024))),h=h?h+e:e,a+=1024,c-=1024;return h}d=new wa;for(g=0;g<c;g++)e=Za[a+g|0],h+=d.G(e);return h}Module.Pointer_stringify=Oa;var p,Za,Qa,$a,q,ab,Ra,Sa,bb=0,za=0,cb=0,ka=0,db=0,eb=0,Ba=0,Ca=Module.TOTAL_MEMORY||16777216;
qa(!!Int32Array&&!!Float64Array&&!!(new Int32Array(1)).subarray&&!!(new Int32Array(1)).set,"Cannot fallback to non-typed array case: Code is too specialized");var fb=new ArrayBuffer(Ca);p=new Int8Array(fb);Qa=new Int16Array(fb);q=new Int32Array(fb);Za=new Uint8Array(fb);$a=new Uint16Array(fb);ab=new Uint32Array(fb);Ra=new Float32Array(fb);Sa=new Float64Array(fb);q[0]=255;qa(255===Za[0]&&0===Za[3],"Typed arrays 2 must be run on a little-endian system");Module.HEAP=f;Module.HEAP8=p;Module.HEAP16=Qa;
Module.HEAP32=q;Module.HEAPU8=Za;Module.HEAPU16=$a;Module.HEAPU32=ab;Module.HEAPF32=Ra;Module.HEAPF64=Sa;function gb(a){for(;0<a.length;){var c=a.shift();if("function"==typeof c)c();else{var d=c.p;"number"===typeof d?c.m===f?ra("v",d):ra("vi",d,[c.m]):d(c.m===f?l:c.m)}}}var hb=[],ib=[],jb=[],kb=n;function lb(a,c,d){a=(new wa).U(a);d&&(a.length=d);c||a.push(0);return a}Module.intArrayFromString=lb;Module.intArrayToString=function(a){for(var c=[],d=0;d<a.length;d++){var e=a[d];255<e&&(e&=255);c.push(String.fromCharCode(e))}return c.join("")};
function Ma(a,c,d){a=lb(a,d);for(d=0;d<a.length;)p[c+d|0]=a[d],d+=1}Module.writeStringToMemory=Ma;function Na(a,c){for(var d=0;d<a.length;d++)p[c+d|0]=a[d]}Module.writeArrayToMemory=Na;function mb(a,c){return 0<=a?a:32>=c?2*Math.abs(1<<c-1)+a:Math.pow(2,c)+a}function nb(a,c){if(0>=a)return a;var d=32>=c?Math.abs(1<<c-1):Math.pow(2,c-1);if(a>=d&&(32>=c||a>d))a=-2*d+a;return a}Math.imul||(Math.imul=function(a,c){var d=a&65535,e=c&65535;return d*e+((a>>>16)*e+d*(c>>>16)<<16)|0});
var ob=0,pb={},qb=n,rb=l;function sb(a){ob++;Module.monitorRunDependencies&&Module.monitorRunDependencies(ob);a?(qa(!pb[a]),pb[a]=1):Module.i("warning: run dependency added without ID")}Module.addRunDependency=sb;function tb(a){ob--;Module.monitorRunDependencies&&Module.monitorRunDependencies(ob);a?(qa(pb[a]),delete pb[a]):Module.i("warning: run dependency removed without ID");0==ob&&(rb!==l&&(clearInterval(rb),rb=l),!qb&&ub&&vb())}Module.removeRunDependency=tb;Module.preloadedImages={};
Module.preloadedAudios={};var bb=8,za=bb+23168,hb=hb.concat([]),s,t;s=Xa([0,0,0,0,152,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"i8",Va);t=Xa([0,0,0,0,168,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"i8",Va);
Xa([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,8,1,0,0,248,0,0,0,44,0,0,0,58,0,0,0,74,0,0,0,174,0,0,0,86,1,0,0,190,1,0,0,18,1,0,0,104,2,0,0,116,0,0,0,214,0,0,0,154,0,0,0,18,
1,0,0,254,0,0,0,78,1,0,0,0,1,0,0,248,1,0,0,130,0,0,0,160,0,0,0,90,0,0,0,212,0,0,0,244,1,0,0,220,1,0,0,44,0,0,0,120,0,0,0,250,1,0,0,160,0,0,0,60,0,0,0,120,0,0,0,50,0,0,0,72,1,0,0,156,0,0,0,178,0,0,0,210,1,0,0,84,1,0,0,174,0,0,0,68,0,0,0,56,0,0,0,52,2,0,0,170,0,0,0,118,1,0,0,166,0,0,0,84,0,0,0,208,0,0,0,42,0,0,0,130,1,0,0,82,0,0,0,96,0,0,0,222,1,0,0,188,0,0,0,142,1,0,0,16,1,0,0,44,0,0,0,52,0,0,0,246,0,0,0,124,0,0,0,42,0,0,0,202,0,0,0,60,0,0,0,102,0,0,0,22,1,0,0,34,1,0,0,216,0,0,0,198,0,0,0,152,0,0,
0,68,0,0,0,114,1,0,0,88,0,0,0,62,0,0,0,6,2,0,0,38,2,0,0,190,0,0,0,240,0,0,0,132,0,0,0,96,1,0,0,152,0,0,0,52,0,0,0,64,0,0,0,108,1,0,0,218,0,0,0,138,0,0,0,150,1,0,0,46,0,0,0,78,0,0,0,54,0,0,0,202,0,0,0,56,1,0,0,28,1,0,0,66,1,0,0,250,0,0,0,28,2,0,0,60,0,0,0,248,0,0,0,88,1,0,0,0,1,0,0,66,2,0,0,222,0,0,0,72,2,0,0,2,1,0,0,168,0,0,0,116,0,0,0,56,0,0,0,56,0,0,0,80,2,0,0,70,0,0,0,190,0,0,0,148,0,0,0,74,0,0,0,42,0,0,0,72,0,0,0,62,2,0,0,76,0,0,0,162,1,0,0,178,1,0,0,50,0,0,0,70,0,0,0,46,0,0,0,50,0,0,0,126,1,
0,0,60,0,0,0,166,0,0,0,198,0,0,0,188,1,0,0,60,1,0,0,56,2,0,0,40,2,0,0,170,1,0,0,136,1,0,0,222,0,0,0,94,1,0,0,64,0,0,0,212,0,0,0,120,1,0,0,106,1,0,0,98,2,0,0,136,0,0,0,68,0,0,0,88,1,0,0,146,0,0,0,106,2,0,0,62,0,0,0,42,0,0,0,148,0,0,0,88,0,0,0,208,0,0,0,164,0,0,0,86,0,0,0,130,0,0,0,108,0,0,0,92,0,0,0,166,0,0,0,72,0,0,0,238,0,0,0,14,1,0,0,84,0,0,0,96,0,0,0,58,1,0,0,148,1,0,0,210,1,0,0,170,1,0,0,94,0,0,0,118,0,0,0,62,1,0,0,54,1,0,0,82,0,0,0,200,1,0,0,74,0,0,0,242,1,0,0,128,1,0,0,120,0,0,0,134,0,0,0,224,
0,0,0,50,0,0,0,46,0,0,0,38,1,0,0,46,1,0,0,46,0,0,0,240,0,0,0,20,1,0,0,208,0,0,0,118,0,0,0,46,0,0,0,254,0,0,0,54,1,0,0,42,0,0,0,72,0,0,0,50,0,0,0,64,1,0,0,44,0,0,0,42,0,0,0,214,0,0,0,142,1,0,0,164,1,0,0,2,1,0,0,214,0,0,0,62,0,0,0,140,0,0,0,174,0,0,0,138,0,0,0,116,0,0,0,76,0,0,0,46,0,0,0,76,0,0,0,216,1,0,0,100,2,0,0,56,0,0,0,72,0,0,0,100,0,0,0,168,1,0,0,2,2,0,0,80,0,0,0,144,1,0,0,174,0,0,0,78,1,0,0,194,1,0,0,72,0,0,0,16,1,0,0,80,1,0,0,246,0,0,0,42,0,0,0,152,1,0,0,196,0,0,0,32,2,0,0,106,0,0,0,56,0,0,
0,208,1,0,0,246,1,0,0,228,0,0,0,112,0,0,0,42,0,0,0,78,0,0,0,52,0,0,0,0,2,0,0,84,0,0,0,158,0,0,0,198,0,0,0,60,1,0,0,238,0,0,0,94,2,0,0,72,0,0,0,134,0,0,0,222,0,0,0,232,0,0,0,116,0,0,0,196,1,0,0,76,1,0,0,46,0,0,0,44,0,0,0,48,0,0,0,42,0,0,0,204,0,0,0,94,0,0,0,66,0,0,0,218,0,0,0,186,0,0,0,146,0,0,0,112,1,0,0,86,0,0,0,206,1,0,0,212,1,0,0,230,0,0,0,188,0,0,0,94,1,0,0,38,1,0,0,168,1,0,0,44,0,0,0,54,0,0,0,248,0,0,0,78,2,0,0,238,1,0,0,14,2,0,0,82,0,0,0,118,0,0,0,126,0,0,0,210,0,0,0,200,0,0,0,14,1,0,0,90,2,
0,0,118,1,0,0,56,1,0,0,126,0,0,0,62,0,0,0,254,1,0,0,20,2,0,0,216,0,0,0,244,0,0,0,42,0,0,0,46,0,0,0,82,0,0,0,150,0,0,0,58,0,0,0,110,0,0,0,70,0,0,0,30,1,0,0,186,1,0,0,182,0,0,0,88,0,0,0,42,0,0,0,44,0,0,0,52,0,0,0,54,0,0,0,134,1,0,0,166,1,0,0,204,0,0,0,42,1,0,0,78,0,0,0,110,0,0,0,162,0,0,0,202,1,0,0,64,0,0,0,236,0,0,0,46,0,0,0,158,0,0,0,54,0,0,0,218,0,0,0,124,1,0,0,100,0,0,0,142,0,0,0,58,1,0,0,110,1,0,0,168,0,0,0,74,0,0,0,160,0,0,0,160,1,0,0,230,1,0,0,232,1,0,0,164,0,0,0,188,0,0,0,138,1,0,0,238,0,0,
0,52,0,0,0,138,0,0,0,104,1,0,0,108,0,0,0,242,0,0,0,70,0,0,0,180,0,0,0,44,0,0,0,90,1,0,0,72,1,0,0,48,0,0,0,206,0,0,0,140,1,0,0,60,0,0,0,172,1,0,0,226,0,0,0,90,0,0,0,216,0,0,0,44,0,0,0,44,0,0,0,154,1,0,0,76,0,0,0,206,0,0,0,214,1,0,0,220,0,0,0,88,0,0,0,186,0,0,0,142,0,0,0,192,0,0,0,122,0,0,0,106,0,0,0,226,0,0,0,98,1,0,0,42,0,0,0,44,0,0,0,196,0,0,0,252,1,0,0,50,0,0,0,186,0,0,0,122,0,0,0,86,1,0,0,66,0,0,0,150,0,0,0,198,1,0,0,62,0,0,0,48,0,0,0,66,0,0,0,56,0,0,0,92,2,0,0,60,0,0,0,116,1,0,0,46,0,0,0,110,
1,0,0,186,0,0,0,28,1,0,0,184,0,0,0,188,0,0,0,80,0,0,0,50,0,0,0,164,0,0,0,54,0,0,0,186,0,0,0,54,0,0,0,236,1,0,0,22,1,0,0,234,0,0,0,46,0,0,0,196,0,0,0,232,0,0,0,176,1,0,0,12,1,0,0,210,0,0,0,4,1,0,0,122,0,0,0,212,0,0,0,184,0,0,0,84,0,0,0,140,1,0,0,224,0,0,0,50,0,0,0,226,0,0,0,242,0,0,0,50,1,0,0,44,0,0,0,56,0,0,0,70,0,0,0,100,0,0,0,66,0,0,0,92,0,0,0,84,0,0,0,58,0,0,0,46,0,0,0,42,0,0,0,92,0,0,0,64,0,0,0,134,1,0,0,10,1,0,0,184,0,0,0,48,0,0,0,52,1,0,0,94,0,0,0,164,0,0,0,36,1,0,0,162,0,0,0,66,0,0,0,48,0,
0,0,106,0,0,0,54,0,0,0,176,0,0,0,108,2,0,0,44,0,0,0,68,0,0,0,82,1,0,0,44,0,0,0,100,0,0,0,98,1,0,0,98,0,0,0,152,0,0,0,154,0,0,0,206,0,0,0,188,0,0,0,44,1,0,0,122,1,0,0,172,1,0,0,74,0,0,0,132,1,0,0,206,0,0,0,138,0,0,0,72,0,0,0,86,0,0,0,156,0,0,0,144,0,0,0,158,0,0,0,58,0,0,0,132,0,0,0,124,0,0,0,252,0,0,0,48,0,0,0,100,0,0,0,88,2,0,0,62,0,0,0,136,0,0,0,74,2,0,0,96,0,0,0,54,0,0,0,124,0,0,0,122,0,0,0,182,1,0,0,94,0,0,0,24,2,0,0,68,0,0,0,68,0,0,0,188,1,0,0,192,0,0,0,254,0,0,0,60,2,0,0,186,1,0,0,64,0,0,0,76,
0,0,0,152,0,0,0,218,0,0,0,156,0,0,0,16,1,0,0,44,1,0,0,80,0,0,0,36,2,0,0,198,0,0,0,160,0,0,0,42,0,0,0,142,0,0,0,240,1,0,0,10,2,0,0,116,0,0,0,72,0,0,0,144,0,0,0,192,1,0,0,172,0,0,0,146,0,0,0,92,1,0,0,166,0,0,0,82,1,0,0,48,0,0,0,16,2,0,0,244,0,0,0,98,0,0,0,190,0,0,0,92,0,0,0,240,0,0,0,234,1,0,0,56,0,0,0,122,0,0,0,118,0,0,0,64,2,0,0,48,1,0,0,172,0,0,0,218,1,0,0,102,0,0,0,130,0,0,0,204,0,0,0,64,0,0,0,26,1,0,0,74,1,0,0,54,2,0,0,106,0,0,0,76,2,0,0,92,0,0,0,178,0,0,0,18,2,0,0,18,1,0,0,42,2,0,0,92,1,0,0,48,
1,0,0,58,0,0,0,228,0,0,0,86,2,0,0,202,0,0,0,148,0,0,0,124,0,0,0,192,0,0,0,52,0,0,0,120,0,0,0,176,0,0,0,70,0,0,0,154,0,0,0,78,0,0,0,246,0,0,0,50,0,0,0,84,1,0,0,44,2,0,0,138,0,0,0,98,0,0,0,42,0,0,0,96,2,0,0,36,1,0,0,94,0,0,0,108,0,0,0,158,1,0,0,64,1,0,0,52,1,0,0,132,0,0,0,166,0,0,0,62,0,0,0,40,1,0,0,84,0,0,0,74,1,0,0,112,0,0,0,198,0,0,0,206,0,0,0,96,0,0,0,68,0,0,0,70,0,0,0,4,2,0,0,68,1,0,0,114,0,0,0,2,1,0,0,102,0,0,0,74,0,0,0,100,0,0,0,48,2,0,0,202,0,0,0,234,0,0,0,108,0,0,0,250,0,0,0,136,0,0,0,154,
1,0,0,104,0,0,0,10,1,0,0,102,1,0,0,104,0,0,0,74,0,0,0,200,1,0,0,236,0,0,0,200,0,0,0,252,0,0,0,226,0,0,0,78,0,0,0,28,1,0,0,144,0,0,0,46,1,0,0,50,1,0,0,128,0,0,0,164,0,0,0,102,0,0,0,42,0,0,0,48,0,0,0,236,0,0,0,52,0,0,0,128,0,0,0,194,0,0,0,76,0,0,0,178,0,0,0,52,0,0,0,170,0,0,0,146,0,0,0,214,0,0,0,58,0,0,0,132,0,0,0,90,0,0,0,156,0,0,0,42,0,0,0,110,0,0,0,218,1,0,0,204,0,0,0,112,0,0,0,44,0,0,0,66,0,0,0,102,2,0,0,98,0,0,0,64,0,0,0,92,0,0,0,96,0,0,0,200,0,0,0,42,0,0,0,78,0,0,0,50,2,0,0,170,0,0,0,194,0,0,
0,170,0,0,0,216,1,0,0,70,1,0,0,68,1,0,0,46,2,0,0,14,1,0,0,138,1,0,0,180,0,0,0,140,0,0,0,60,0,0,0,82,0,0,0,94,0,0,0,112,0,0,0,72,0,0,0,172,0,0,0,144,0,0,0,180,0,0,0,182,1,0,0,244,0,0,0,68,1,0,0,120,0,0,0,220,0,0,0,112,0,0,0,186,0,0,0,214,1,0,0,48,0,0,0,136,1,0,0,242,0,0,0,10,1,0,0,70,0,0,0,50,0,0,0,60,0,0,0,234,0,0,0,22,2,0,0,172,0,0,0,178,0,0,0,110,2,0,0,60,0,0,0,134,0,0,0,178,0,0,0,118,0,0,0,76,0,0,0,92,0,0,0,90,0,0,0,178,0,0,0,156,1,0,0,88,0,0,0,160,1,0,0,62,1,0,0,112,0,0,0,168,0,0,0,174,1,0,0,
6,1,0,0,64,0,0,0,106,0,0,0,50,0,0,0,42,0,0,0,184,0,0,0,6,1,0,0,62,1,0,0,114,0,0,0,116,0,0,0,46,0,0,0,124,0,0,0,204,1,0,0,220,0,0,0,196,0,0,0,42,0,0,0,96,0,0,0,134,0,0,0,192,0,0,0,146,0,0,0,102,1,0,0,104,0,0,0,26,1,0,0,154,0,0,0,182,0,0,0,150,0,0,0,72,0,0,0,54,0,0,0,230,0,0,0,58,0,0,0,86,1,0,0,250,0,0,0,232,0,0,0,34,1,0,0,108,0,0,0,226,1,0,0,142,0,0,0,248,0,0,0,162,1,0,0,176,0,0,0,182,0,0,0,212,0,0,0,56,0,0,0,66,0,0,0,104,0,0,0,98,0,0,0,142,0,0,0,86,0,0,0,102,0,0,0,110,0,0,0,58,0,0,0,66,0,0,0,62,0,
0,0,102,0,0,0,60,0,0,0,118,0,0,0,202,1,0,0,100,1,0,0,42,0,0,0,20,1,0,0,98,0,0,0,190,0,0,0,42,1,0,0,30,2,0,0,58,2,0,0,128,0,0,0,178,1,0,0,42,0,0,0,246,0,0,0,66,1,0,0,196,0,0,0,8,2,0,0,50,0,0,0,70,0,0,0,162,0,0,0,90,0,0,0,106,0,0,0,140,0,0,0,156,0,0,0,172,0,0,0,82,0,0,0,146,1,0,0,182,0,0,0,94,0,0,0,68,0,0,0,154,0,0,0,196,1,0,0,252,0,0,0,116,1,0,0,48,0,0,0,194,1,0,0,114,0,0,0,150,0,0,0,12,1,0,0,44,0,0,0,208,1,0,0,210,0,0,0,12,2,0,0,82,2,0,0,56,0,0,0,46,0,0,0,240,0,0,0,242,0,0,0,44,0,0,0,62,0,0,0,172,
0,0,0,90,0,0,0,42,0,0,0,150,0,0,0,162,0,0,0,210,0,0,0,170,0,0,0,176,0,0,0,68,0,0,0,32,1,0,0,190,1,0,0,188,0,0,0,180,1,0,0,70,1,0,0,156,1,0,0,204,0,0,0,24,1,0,0,52,0,0,0,70,0,0,0,74,1,0,0,176,0,0,0,100,0,0,0,86,0,0,0,48,0,0,0,90,0,0,0,194,0,0,0,220,1,0,0,192,1,0,0,42,1,0,0,208,0,0,0,184,1,0,0,86,0,0,0,126,1,0,0,56,0,0,0,230,0,0,0,202,0,0,0,158,0,0,0,78,0,0,0,194,0,0,0,64,0,0,0,196,0,0,0,180,0,0,0,154,0,0,0,122,1,0,0,90,1,0,0,86,0,0,0,126,0,0,0,60,1,0,0,126,0,0,0,62,0,0,0,92,0,0,0,132,0,0,0,24,1,0,
0,204,1,0,0,114,0,0,0,58,0,0,0,96,1,0,0,58,0,0,0,66,0,0,0,176,1,0,0,148,0,0,0,180,0,0,0,76,0,0,0,124,0,0,0,24,1,0,0,138,0,0,0,26,2,0,0,182,0,0,0,80,0,0,0,108,0,0,0,72,1,0,0,174,1,0,0,130,0,0,0,44,0,0,0,44,0,0,0,60,0,0,0,164,0,0,0,114,0,0,0,84,2,0,0,146,1,0,0,104,1,0,0,148,1,0,0,146,0,0,0,158,0,0,0,34,2,0,0,132,0,0,0,116,0,0,0,100,0,0,0,166,1,0,0,78,1,0,0,128,1,0,0,168,0,0,0,32,1,0,0,152,1,0,0,228,1,0,0,136,0,0,0,86,0,0,0,110,0,0,0,224,1,0,0,110,0,0,0,144,0,0,0,128,0,0,0,104,0,0,0,30,1,0,0,232,0,0,
0,244,0,0,0,158,1,0,0,200,0,0,0,136,0,0,0,80,0,0,0,134,0,0,0,98,0,0,0,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,76,0,0,0,0,0,0,0,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,95,102,105,120,116,117,114,101,67,111,117,110,116,32,62,32,48,0,0,0,0,0,0,32,32,106,100,46,109,97,120,77,111,116,111,114,84,111,114,113,117,101,32,61,32,37,46,49,53,108,101,102,59,10,0,32,32,106,100,46,101,110,97,98,108,101,76,105,
109,105,116,32,61,32,98,111,111,108,40,37,100,41,59,10,0,0,0,32,32,106,100,46,106,111,105,110,116,50,32,61,32,106,111,105,110,116,115,91,37,100,93,59,10,0,0,0,0,0,0,32,32,106,100,46,109,97,120,70,111,114,99,101,32,61,32,37,46,49,53,108,101,102,59,10,0,0,0,0,0,0,0,98,50,86,101,99,50,32,103,40,37,46,49,53,108,101,102,44,32,37,46,49,53,108,101,102,41,59,10,0,0,0,0,32,32,32,32,102,100,46,102,105,108,116,101,114,46,109,97,115,107,66,105,116,115,32,61,32,117,105,110,116,49,54,40,37,100,41,59,10,0,0,0,48,
32,60,61,32,105,66,32,38,38,32,105,66,32,60,32,109,95,110,111,100,101,67,97,112,97,99,105,116,121,0,0,102,105,120,116,117,114,101,45,62,109,95,98,111,100,121,32,61,61,32,116,104,105,115,0,32,32,106,100,46,109,111,116,111,114,83,112,101,101,100,32,61,32,37,46,49,53,108,101,102,59,10,0,0,0,0,0,32,32,106,100,46,103,114,111,117,110,100,65,110,99,104,111,114,66,46,83,101,116,40,37,46,49,53,108,101,102,44,32,37,46,49,53,108,101,102,41,59,10,0,0,0,0,0,0,32,32,106,100,46,106,111,105,110,116,49,32,61,32,106,
111,105,110,116,115,91,37,100,93,59,10,0,0,0,0,0,0,118,101,114,116,101,120,67,111,117,110,116,32,60,61,32,56,0,0,0,0,0,0,0,0,32,32,32,32,102,100,46,102,105,108,116,101,114,46,99,97,116,101,103,111,114,121,66,105,116,115,32,61,32,117,105,110,116,49,54,40,37,100,41,59,10,0,0,0,0,0,0,0,105,65,32,33,61,32,40,45,49,41,0,0,0,0,0,0,109,95,119,111,114,108,100,45,62,73,115,76,111,99,107,101,100,40,41,32,61,61,32,102,97,108,115,101,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,
110,97,109,105,99,115,47,98,50,66,111,100,121,46,99,112,112,0,0,32,32,106,100,46,101,110,97,98,108,101,77,111,116,111,114,32,61,32,98,111,111,108,40,37,100,41,59,10,0,0,0,32,32,106,100,46,103,114,111,117,110,100,65,110,99,104,111,114,65,46,83,101,116,40,37,46,49,53,108,101,102,44,32,37,46,49,53,108,101,102,41,59,10,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,67,111,109,109,111,110,47,98,50,83,116,97,99,107,65,108,108,111,99,97,116,111,114,46,99,112,112,0,0,97,108,112,
104,97,48,32,60,32,49,46,48,102,0,0,0,32,32,32,32,102,100,46,105,115,83,101,110,115,111,114,32,61,32,98,111,111,108,40,37,100,41,59,10,0,0,0,0,99,104,105,108,100,50,32,33,61,32,40,45,49,41,0,0,98,50,73,115,86,97,108,105,100,40,98,100,45,62,108,105,110,101,97,114,68,97,109,112,105,110,103,41,32,38,38,32,98,100,45,62,108,105,110,101,97,114,68,97,109,112,105,110,103,32,62,61,32,48,46,48,102,0,0,0,0,0,0,0,99,111,117,110,116,32,62,61,32,51,0,0,0,0,0,0,32,32,106,100,46,108,111,99,97,108,65,120,105,115,
65,46,83,101,116,40,37,46,49,53,108,101,102,44,32,37,46,49,53,108,101,102,41,59,10,0,32,32,106,100,46,114,101,102,101,114,101,110,99,101,65,110,103,108,101,32,61,32,37,46,49,53,108,101,102,59,10,0,32,32,106,100,46,109,97,120,76,101,110,103,116,104,32,61,32,37,46,49,53,108,101,102,59,10,0,0,0,0,0,0,77,111,117,115,101,32,106,111,105,110,116,32,100,117,109,112,105,110,103,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,46,10,0,0,32,32,106,100,46,108,101,110,103,116,104,32,61,32,37,46,
49,53,108,101,102,59,10,0,99,104,105,108,100,49,32,33,61,32,40,45,49,41,0,0,116,121,112,101,65,32,61,61,32,98,50,95,100,121,110,97,109,105,99,66,111,100,121,32,124,124,32,116,121,112,101,66,32,61,61,32,98,50,95,100,121,110,97,109,105,99,66,111,100,121,0,0,0,0,0,0,32,32,32,32,102,100,46,100,101,110,115,105,116,121,32,61,32,37,46,49,53,108,101,102,59,10,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,67,111,108,108,105,115,105,111,110,47,98,50,68,105,115,116,97,110,99,101,
46,99,112,112,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,67,111,109,109,111,110,47,98,50,66,108,111,99,107,65,108,108,111,99,97,116,111,114,46,99,112,112,0,0,98,50,73,115,86,97,108,105,100,40,98,100,45,62,97,110,103,117,108,97,114,68,97,109,112,105,110,103,41,32,38,38,32,98,100,45,62,97,110,103,117,108,97,114,68,97,109,112,105,110,103,32,62,61,32,48,46,48,102,0,0,0,0,0,112,32,61,61,32,101,110,116,114,121,45,62,100,97,116,97,0,0,0,0,0,0,0,0,97,114,101,97,32,62,32,49,46,
49,57,50,48,57,50,57,48,69,45,48,55,70,0,0,99,104,105,108,100,73,110,100,101,120,32,60,32,109,95,99,111,117,110,116,0,0,0,0,32,32,106,100,46,108,111,99,97,108,65,110,99,104,111,114,66,46,83,101,116,40,37,46,49,53,108,101,102,44,32,37,46,49,53,108,101,102,41,59,10,0,0,0,0,0,0,0,48,32,60,32,99,111,117,110,116,32,38,38,32,99,111,117,110,116,32,60,32,51,0,0,100,32,43,32,104,32,42,32,107,32,62,32,49,46,49,57,50,48,57,50,57,48,69,45,48,55,70,0,0,0,0,0,112,99,45,62,112,111,105,110,116,67,111,117,110,116,
32,62,32,48,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,67,111,108,108,105,115,105,111,110,47,83,104,97,112,101,115,47,98,50,80,111,108,121,103,111,110,83,104,97,112,101,46,99,112,112,0,0,109,95,110,111,100,101,115,91,112,114,111,120,121,73,100,93,46,73,115,76,101,97,102,40,41,0,0,0,0,0,0,0,115,116,97,99,107,67,111,117,110,116,32,60,32,115,116,97,99,107,83,105,122,101,0,0,32,32,32,32,102,100,46,114,101,115,116,105,116,117,116,105,111,110,32,61,32,37,46,49,53,108,101,
102,59,10,0,0,99,97,99,104,101,45,62,99,111,117,110,116,32,60,61,32,51,0,0,0,0,0,0,0,98,50,73,115,86,97,108,105,100,40,98,100,45,62,97,110,103,117,108,97,114,86,101,108,111,99,105,116,121,41,0,0,109,95,101,110,116,114,121,67,111,117,110,116,32,62,32,48,0,0,0,0,0,0,0,0,98,108,111,99,107,67,111,117,110,116,32,42,32,98,108,111,99,107,83,105,122,101,32,60,61,32,98,50,95,99,104,117,110,107,83,105,122,101,0,0,109,95,118,101,114,116,101,120,67,111,117,110,116,32,62,61,32,51,0,0,0,0,0,0,48,32,60,61,32,105,
110,100,101,120,32,38,38,32,105,110,100,101,120,32,60,32,109,95,99,111,117,110,116,32,45,32,49,0,0,0,0,0,0,0,32,32,106,100,46,108,111,99,97,108,65,110,99,104,111,114,65,46,83,101,116,40,37,46,49,53,108,101,102,44,32,37,46,49,53,108,101,102,41,59,10,0,0,0,0,0,0,0,98,50,73,115,86,97,108,105,100,40,100,101,102,45,62,100,97,109,112,105,110,103,82,97,116,105,111,41,32,38,38,32,100,101,102,45,62,100,97,109,112,105,110,103,82,97,116,105,111,32,62,61,32,48,46,48,102,0,0,0,0,0,0,0,32,32,98,50,71,101,97,114,
74,111,105,110,116,68,101,102,32,106,100,59,10,0,0,0,97,46,120,32,62,61,32,48,46,48,102,32,38,38,32,97,46,121,32,62,61,32,48,46,48,102,0,0,0,0,0,0,48,32,60,61,32,116,121,112,101,65,32,38,38,32,116,121,112,101,66,32,60,32,98,50,83,104,97,112,101,58,58,101,95,116,121,112,101,67,111,117,110,116,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,67,111,108,108,105,115,105,111,110,47,83,104,97,112,101,115,47,98,50,67,104,97,105,110,83,104,97,112,101,46,99,112,112,0,0,0,0,98,45,62,
73,115,65,99,116,105,118,101,40,41,32,61,61,32,116,114,117,101,0,0,0,32,32,98,50,87,104,101,101,108,74,111,105,110,116,68,101,102,32,106,100,59,10,0,0,32,32,32,32,102,100,46,102,114,105,99,116,105,111,110,32,61,32,37,46,49,53,108,101,102,59,10,0,0,0,0,0,32,32,98,50,87,101,108,100,74,111,105,110,116,68,101,102,32,106,100,59,10,0,0,0,48,32,60,61,32,105,110,100,101,120,32,38,38,32,105,110,100,101,120,32,60,32,109,95,99,111,117,110,116,0,0,0,32,32,98,50,82,111,112,101,74,111,105,110,116,68,101,102,32,
106,100,59,10,0,0,0,98,50,73,115,86,97,108,105,100,40,98,100,45,62,97,110,103,108,101,41,0,0,0,0,109,95,101,110,116,114,121,67,111,117,110,116,32,60,32,98,50,95,109,97,120,83,116,97,99,107,69,110,116,114,105,101,115,0,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,74,111,105,110,116,115,47,98,50,82,101,118,111,108,117,116,101,74,111,105,110,116,46,99,112,112,0,0,48,32,60,61,32,105,110,100,101,120,32,38,38,32,105,110,100,101,120,32,60,32,98,
50,95,98,108,111,99,107,83,105,122,101,115,0,0,0,0,0,48,46,48,102,32,60,61,32,108,111,119,101,114,32,38,38,32,108,111,119,101,114,32,60,61,32,105,110,112,117,116,46,109,97,120,70,114,97,99,116,105,111,110,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,74,111,105,110,116,115,47,98,50,80,117,108,108,101,121,74,111,105,110,116,46,99,112,112,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,67,111,108,108,105,115,105,111,110,
47,98,50,84,105,109,101,79,102,73,109,112,97,99,116,46,99,112,112,0,99,111,117,110,116,32,62,61,32,50,0,0,0,0,0,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,0,32,32,106,100,46,99,111,108,108,105,100,101,67,111,110,110,101,99,116,101,100,32,61,32,98,111,111,108,40,37,100,41,59,10,0,0,0,0,0,0,32,32,98,50,80,117,108,108,101,121,74,111,105,110,116,68,101,102,32,106,100,59,10,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,74,111,105,110,116,115,
47,98,50,80,114,105,115,109,97,116,105,99,74,111,105,110,116,46,99,112,112,0,98,50,73,115,86,97,108,105,100,40,100,101,102,45,62,102,114,101,113,117,101,110,99,121,72,122,41,32,38,38,32,100,101,102,45,62,102,114,101,113,117,101,110,99,121,72,122,32,62,61,32,48,46,48,102,0,47,47,32,68,117,109,112,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,102,111,114,32,116,104,105,115,32,106,111,105,110,116,32,116,121,112,101,46,10,0,0,98,50,73,115,86,97,108,105,100,40,114,97,116,105,111,
41,0,0,0,0,0,0,0,0,32,32,32,32,98,111,100,105,101,115,91,37,100,93,45,62,67,114,101,97,116,101,70,105,120,116,117,114,101,40,38,102,100,41,59,10,0,0,0,0,32,32,98,50,70,114,105,99,116,105,111,110,74,111,105,110,116,68,101,102,32,106,100,59,10,0,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,74,111,105,110,116,115,47,98,50,77,111,117,115,101,74,111,105,110,116,46,99,112,112,0,0,0,0,0,112,111,105,110,116,67,111,117,110,116,32,61,61,32,49,32,
124,124,32,112,111,105,110,116,67,111,117,110,116,32,61,61,32,50,0,0,0,0,0,0,115,95,105,110,105,116,105,97,108,105,122,101,100,32,61,61,32,116,114,117,101,0,0,0,32,32,32,32,102,100,46,115,104,97,112,101,32,61,32,38,115,104,97,112,101,59,10,0,109,95,106,111,105,110,116,67,111,117,110,116,32,62,32,48,0,0,0,0,0,0,0,0,48,32,60,32,109,95,110,111,100,101,67,111,117,110,116,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,74,111,105,110,116,115,47,98,50,74,
111,105,110,116,46,99,112,112,0,0,32,32,32,32,98,50,70,105,120,116,117,114,101,68,101,102,32,102,100,59,10,0,0,0,10,0,0,0,0,0,0,0,32,32,125,10,0,0,0,0,110,111,100,101,45,62,73,115,76,101,97,102,40,41,32,61,61,32,102,97,108,115,101,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,74,111,105,110,116,115,47,98,50,71,101,97,114,74,111,105,110,116,46,99,112,112,0,0,0,0,0,0,32,32,32,32,115,104,97,112,101,46,109,95,104,97,115,78,101,120,116,86,101,114,116,101,
120,32,61,32,98,111,111,108,40,37,100,41,59,10,0,0,32,32,123,10,0,0,0,0,109,95,110,111,100,101,67,111,117,110,116,32,43,32,102,114,101,101,67,111,117,110,116,32,61,61,32,109,95,110,111,100,101,67,97,112,97,99,105,116,121,0,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,67,111,108,108,105,115,105,111,110,47,98,50,68,105,115,116,97,110,99,101,46,104,0,0,0,0,0,0,0,32,32,32,32,115,104,97,112,101,46,109,95,104,97,115,80,114,101,118,86,101,114,116,101,120,32,61,32,98,111,111,
108,40,37,100,41,59,10,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,74,111,105,110,116,115,47,98,50,70,114,105,99,116,105,111,110,74,111,105,110,116,46,99,112,112,0,0,71,101,116,72,101,105,103,104,116,40,41,32,61,61,32,67,111,109,112,117,116,101,72,101,105,103,104,116,40,41,0,0,48,32,60,61,32,102,114,101,101,73,110,100,101,120,32,38,38,32,102,114,101,101,73,110,100,101,120,32,60,32,109,95,110,111,100,101,67,97,112,97,99,105,116,121,0,0,0,0,109,
95,98,111,100,121,67,111,117,110,116,32,60,32,109,95,98,111,100,121,67,97,112,97,99,105,116,121,0,0,0,0,32,32,32,32,115,104,97,112,101,46,109,95,110,101,120,116,86,101,114,116,101,120,46,83,101,116,40,37,46,49,53,108,101,102,44,32,37,46,49,53,108,101,102,41,59,10,0,0,32,32,98,111,100,105,101,115,91,37,100,93,32,61,32,109,95,119,111,114,108,100,45,62,67,114,101,97,116,101,66,111,100,121,40,38,98,100,41,59,10,0,0,0,0,0,0,0,32,32,98,50,68,105,115,116,97,110,99,101,74,111,105,110,116,68,101,102,32,106,
100,59,10,0,0,0,0,0,0,0,98,100,45,62,108,105,110,101,97,114,86,101,108,111,99,105,116,121,46,73,115,86,97,108,105,100,40,41,0,0,0,0,109,95,101,110,116,114,121,67,111,117,110,116,32,61,61,32,48,0,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,67,111,110,116,97,99,116,115,47,98,50,80,111,108,121,103,111,110,67,111,110,116,97,99,116,46,99,112,112,0,0,0,0,0,0,0,109,95,99,111,110,116,97,99,116,67,111,117,110,116,32,60,32,109,95,99,111,110,116,
97,99,116,67,97,112,97,99,105,116,121,0,0,0,0,0,0,32,32,32,32,115,104,97,112,101,46,109,95,112,114,101,118,86,101,114,116,101,120,46,83,101,116,40,37,46,49,53,108,101,102,44,32,37,46,49,53,108,101,102,41,59,10,0,0,32,32,98,100,46,103,114,97,118,105,116,121,83,99,97,108,101,32,61,32,37,46,49,53,108,101,102,59,10,0,0,0,97,97,98,98,46,117,112,112,101,114,66,111,117,110,100,32,61,61,32,110,111,100,101,45,62,97,97,98,98,46,117,112,112,101,114,66,111,117,110,100,0,0,0,0,0,0,0,0,66,111,120,50,68,95,118,
50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,67,111,110,116,97,99,116,115,47,98,50,80,111,108,121,103,111,110,65,110,100,67,105,114,99,108,101,67,111,110,116,97,99,116,46,99,112,112,0,0,0,0,0,0,109,95,106,111,105,110,116,67,111,117,110,116,32,60,32,109,95,106,111,105,110,116,67,97,112,97,99,105,116,121,0,0,32,32,32,32,115,104,97,112,101,46,67,114,101,97,116,101,67,104,97,105,110,40,118,115,44,32,37,100,41,59,10,0,32,32,98,100,46,97,99,116,105,118,101,32,61,32,98,111,111,108,
40,37,100,41,59,10,0,0,0,0,0,0,0,0,48,32,60,32,115,105,122,101,0,0,0,0,0,0,0,0,97,97,98,98,46,108,111,119,101,114,66,111,117,110,100,32,61,61,32,110,111,100,101,45,62,97,97,98,98,46,108,111,119,101,114,66,111,117,110,100,0,0,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,67,111,110,116,97,99,116,115,47,98,50,69,100,103,101,65,110,100,80,111,108,121,103,111,110,67,111,110,116,97,99,116,46,99,112,112,0,0,0,0,0,0,0,0,101,100,103,101,46,76,101,
110,103,116,104,83,113,117,97,114,101,100,40,41,32,62,32,49,46,49,57,50,48,57,50,57,48,69,45,48,55,70,32,42,32,49,46,49,57,50,48,57,50,57,48,69,45,48,55,70,0,0,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,98,50,73,115,108,97,110,100,46,104,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,67,111,110,116,97,99,116,115,47,98,50,69,100,103,101,65,110,100,67,105,114,99,108,101,67,111,110,116,97,
99,116,46,99,112,112,0,32,32,32,32,98,50,67,104,97,105,110,83,104,97,112,101,32,115,104,97,112,101,59,10,0,0,0,0,0,0,0,0,32,32,98,100,46,98,117,108,108,101,116,32,61,32,98,111,111,108,40,37,100,41,59,10,0,0,0,0,0,0,0,0,110,111,100,101,45,62,104,101,105,103,104,116,32,61,61,32,104,101,105,103,104,116,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,67,111,109,109,111,110,47,98,50,77,97,116,104,46,104,0,0,0,0,0,0,32,32,106,100,46,98,111,100,121,66,32,61,32,98,111,100,105,101,115,91,
37,100,93,59,10,0,0,0,0,0,0,0,32,32,32,32,115,104,97,112,101,46,83,101,116,40,118,115,44,32,37,100,41,59,10,0,32,32,98,100,46,102,105,120,101,100,82,111,116,97,116,105,111,110,32,61,32,98,111,111,108,40,37,100,41,59,10,0,109,95,110,111,100,101,115,91,99,104,105,108,100,50,93,46,112,97,114,101,110,116,32,61,61,32,105,110,100,101,120,0,32,32,98,50,82,101,118,111,108,117,116,101,74,111,105,110,116,68,101,102,32,106,100,59,10,0,0,0,0,0,0,0,100,101,102,45,62,114,97,116,105,111,32,33,61,32,48,46,48,102,
0,0,0,0,0,0,32,32,98,50,80,114,105,115,109,97,116,105,99,74,111,105,110,116,68,101,102,32,106,100,59,10,0,0,0,0,0,0,98,50,73,115,86,97,108,105,100,40,100,101,102,45,62,109,97,120,70,111,114,99,101,41,32,38,38,32,100,101,102,45,62,109,97,120,70,111,114,99,101,32,62,61,32,48,46,48,102,0,0,0,0,0,0,0,100,101,102,45,62,98,111,100,121,65,32,33,61,32,100,101,102,45,62,98,111,100,121,66,0,0,0,0,0,0,0,0,32,32,32,32,118,115,91,37,100,93,46,83,101,116,40,37,46,49,53,108,101,102,44,32,37,46,49,53,108,101,102,
41,59,10,0,0,0,0,0,0,32,32,98,100,46,97,119,97,107,101,32,61,32,98,111,111,108,40,37,100,41,59,10,0,109,95,116,121,112,101,66,32,61,61,32,101,95,114,101,118,111,108,117,116,101,74,111,105,110,116,32,124,124,32,109,95,116,121,112,101,66,32,61,61,32,101,95,112,114,105,115,109,97,116,105,99,74,111,105,110,116,0,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,67,111,110,116,97,99,116,115,47,98,50,67,111,110,116,97,99,116,83,111,108,118,101,114,
46,99,112,112,0,0,0,0,0,0,0,0,109,95,110,111,100,101,115,91,99,104,105,108,100,49,93,46,112,97,114,101,110,116,32,61,61,32,105,110,100,101,120,0,98,50,73,115,86,97,108,105,100,40,116,111,114,113,117,101,41,32,38,38,32,116,111,114,113,117,101,32,62,61,32,48,46,48,102,0,0,0,0,0,109,95,102,105,120,116,117,114,101,66,45,62,71,101,116,84,121,112,101,40,41,32,61,61,32,98,50,83,104,97,112,101,58,58,101,95,112,111,108,121,103,111,110,0,0,0,0,0,109,95,102,105,120,116,117,114,101,66,45,62,71,101,116,84,121,
112,101,40,41,32,61,61,32,98,50,83,104,97,112,101,58,58,101,95,99,105,114,99,108,101,0,0,0,0,0,0,109,97,110,105,102,111,108,100,45,62,112,111,105,110,116,67,111,117,110,116,32,62,32,48,0,0,0,0,0,0,0,0,48,32,60,61,32,116,121,112,101,50,32,38,38,32,116,121,112,101,50,32,60,32,98,50,83,104,97,112,101,58,58,101,95,116,121,112,101,67,111,117,110,116,0,0,0,0,0,0,32,32,32,32,98,50,86,101,99,50,32,118,115,91,37,100,93,59,10,0,0,0,0,0,32,32,98,100,46,97,108,108,111,119,83,108,101,101,112,32,61,32,98,111,111,
108,40,37,100,41,59,10,0,0,0,0,48,32,60,61,32,99,104,105,108,100,50,32,38,38,32,99,104,105,108,100,50,32,60,32,109,95,110,111,100,101,67,97,112,97,99,105,116,121,0,0,32,32,98,100,46,97,110,103,117,108,97,114,68,97,109,112,105,110,103,32,61,32,37,46,49,53,108,101,102,59,10,0,109,95,98,111,100,121,67,111,117,110,116,32,62,32,48,0,116,111,105,73,110,100,101,120,66,32,60,32,109,95,98,111,100,121,67,111,117,110,116,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,
115,47,67,111,110,116,97,99,116,115,47,98,50,67,111,110,116,97,99,116,46,99,112,112,0,0,0,0,0,0,48,32,60,61,32,110,111,100,101,73,100,32,38,38,32,110,111,100,101,73,100,32,60,32,109,95,110,111,100,101,67,97,112,97,99,105,116,121,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,67,111,110,116,97,99,116,115,47,98,50,67,105,114,99,108,101,67,111,110,116,97,99,116,46,99,112,112,0,0,0,0,0,0,0,0,32,32,32,32,98,50,80,111,108,121,103,111,110,83,104,97,112,
101,32,115,104,97,112,101,59,10,0,0,0,0,0,0,48,32,60,61,32,112,114,111,120,121,73,100,32,38,38,32,112,114,111,120,121,73,100,32,60,32,109,95,110,111,100,101,67,97,112,97,99,105,116,121,0,0,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,67,111,110,116,97,99,116,115,47,98,50,67,104,97,105,110,65,110,100,80,111,108,121,103,111,110,67,111,110,116,97,99,116,46,99,112,112,0,0,0,0,0,0,0,48,32,60,61,32,99,104,105,108,100,49,32,38,38,32,99,104,105,
108,100,49,32,60,32,109,95,110,111,100,101,67,97,112,97,99,105,116,121,0,0,32,32,98,100,46,108,105,110,101,97,114,68,97,109,112,105,110,103,32,61,32,37,46,49,53,108,101,102,59,10,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,67,111,110,116,97,99,116,115,47,98,50,67,104,97,105,110,65,110,100,67,105,114,99,108,101,67,111,110,116,97,99,116,46,99,112,112,0,0,0,0,0,0,0,0,114,46,76,101,110,103,116,104,83,113,117,97,114,101,100,40,41,32,62,32,48,46,48,
102,0,0,0,0,0,0,0,0,32,32,32,32,115,104,97,112,101,46,109,95,104,97,115,86,101,114,116,101,120,51,32,61,32,98,111,111,108,40,37,100,41,59,10,0,0,0,0,0,110,111,100,101,45,62,104,101].concat([105,103,104,116,32,61,61,32,48,0,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,67,111,108,108,105,115,105,111,110,47,98,50,67,111,108,108,105,100,101,80,111,108,121,103,111,110,46,99,112,112,0,0,0,0,0,0,0,32,32,98,100,46,97,110,103,117,108,97,114,86,101,108,111,99,105,116,121,32,61,
32,37,46,49,53,108,101,102,59,10,0,0,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,67,111,108,108,105,115,105,111,110,47,98,50,68,121,110,97,109,105,99,84,114,101,101,46,104,0,0,0,0,32,32,32,32,115,104,97,112,101,46,109,95,104,97,115,86,101,114,116,101,120,48,32,61,32,98,111,111,108,40,37,100,41,59,10,0,0,0,0,0,99,104,105,108,100,50,32,61,61,32,40,45,49,41,0,0,32,32,98,100,46,108,105,110,101,97,114,86,101,108,111,99,105,116,121,46,83,101,116,40,37,46,49,53,108,101,102,
44,32,37,46,49,53,108,101,102,41,59,10,0,0,0,0,0,98,111,100,105,101,115,32,61,32,78,85,76,76,59,10,0,32,32,32,32,115,104,97,112,101,46,109,95,118,101,114,116,101,120,51,46,83,101,116,40,37,46,49,53,108,101,102,44,32,37,46,49,53,108,101,102,41,59,10,0,0,0,0,0,32,32,98,100,46,97,110,103,108,101,32,61,32,37,46,49,53,108,101,102,59,10,0,0,98,100,45,62,112,111,115,105,116,105,111,110,46,73,115,86,97,108,105,100,40,41,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,
99,115,47,98,50,87,111,114,108,100,46,99,112,112,0,109,95,105,110,100,101,120,32,61,61,32,48,0,0,0,0,109,95,110,111,100,101,115,91,105,110,100,101,120,93,46,112,97,114,101,110,116,32,61,61,32,40,45,49,41,0,0,0,106,111,105,110,116,115,32,61,32,78,85,76,76,59,10,0,32,32,32,32,115,104,97,112,101,46,109,95,118,101,114,116,101,120,50,46,83,101,116,40,37,46,49,53,108,101,102,44,32,37,46,49,53,108,101,102,41,59,10,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,
105,99,115,47,98,50,73,115,108,97,110,100,46,99,112,112,0,0,0,0,0,0,0,0,48,32,60,61,32,105,110,100,101,120,32,38,38,32,105,110,100,101,120,32,60,32,99,104,97,105,110,45,62,109,95,99,111,117,110,116,0,0,0,0,32,32,98,100,46,112,111,115,105,116,105,111,110,46,83,101,116,40,37,46,49,53,108,101,102,44,32,37,46,49,53,108,101,102,41,59,10,0,0,0,98,50,70,114,101,101,40,98,111,100,105,101,115,41,59,10,0,0,0,0,0,0,0,0,32,32,32,32,115,104,97,112,101,46,109,95,118,101,114,116,101,120,49,46,83,101,116,40,37,46,
49,53,108,101,102,44,32,37,46,49,53,108,101,102,41,59,10,0,0,0,0,0,106,32,60,32,98,50,95,98,108,111,99,107,83,105,122,101,115,0,0,0,0,0,0,0,109,95,110,111,100,101,115,91,66,45,62,112,97,114,101,110,116,93,46,99,104,105,108,100,50,32,61,61,32,105,65,0,32,32,98,100,46,116,121,112,101,32,61,32,98,50,66,111,100,121,84,121,112,101,40,37,100,41,59,10,0,0,0,0,32,32,106,100,46,109,97,120,77,111,116,111,114,70,111,114,99,101,32,61,32,37,46,49,53,108,101,102,59,10,0,0,51,32,60,61,32,99,111,117,110,116,32,38,
38,32,99,111,117,110,116,32,60,61,32,56,0,0,0,0,0,0,0,0,98,50,70,114,101,101,40,106,111,105,110,116,115,41,59,10,0,0,0,0,0,0,0,0,32,32,32,32,115,104,97,112,101,46,109,95,118,101,114,116,101,120,48,46,83,101,116,40,37,46,49,53,108,101,102,44,32,37,46,49,53,108,101,102,41,59,10,0,0,0,0,0,48,32,60,61,32,105,69,32,38,38,32,105,69,32,60,32,109,95,110,111,100,101,67,97,112,97,99,105,116,121,0,0,32,32,98,50,66,111,100,121,68,101,102,32,98,100,59,10,0,0,0,0,0,0,0,0,109,95,118,101,114,116,105,99,101,115,32,
61,61,32,95,95,110,117,108,108,32,38,38,32,109,95,99,111,117,110,116,32,61,61,32,48,0,0,0,0,48,32,60,61,32,105,68,32,38,38,32,105,68,32,60,32,109,95,110,111,100,101,67,97,112,97,99,105,116,121,0,0,125,10,0,0,0,0,0,0,32,32,106,100,46,98,111,100,121,65,32,61,32,98,111,100,105,101,115,91,37,100,93,59,10,0,0,0,0,0,0,0,32,32,32,32,98,50,69,100,103,101,83,104,97,112,101,32,115,104,97,112,101,59,10,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,67,111,108,108,105,115,105,111,110,47,98,50,
68,121,110,97,109,105,99,84,114,101,101,46,99,112,112,0,0,108,111,119,101,114,32,60,61,32,117,112,112,101,114,0,0,116,97,114,103,101,116,32,62,32,116,111,108,101,114,97,110,99,101,0,0,0,0,0,0,114,97,116,105,111,32,62,32,49,46,49,57,50,48,57,50,57,48,69,45,48,55,70,0,32,32,106,100,46,114,97,116,105,111,32,61,32,37,46,49,53,108,101,102,59,10,0,0,100,101,102,45,62,116,97,114,103,101,116,46,73,115,86,97,108,105,100,40,41,0,0,0,109,95,110,111,100,101,115,91,67,45,62,112,97,114,101,110,116,93,46,99,104,
105,108,100,50,32,61,61,32,105,65,0,123,10,0,0,0,0,0,0,102,97,108,115,101,0,0,0,32,32,32,32,115,104,97,112,101,46,109,95,112,46,83,101,116,40,37,46,49,53,108,101,102,44,32,37,46,49,53,108,101,102,41,59,10,0,0,0,109,95,116,121,112,101,65,32,61,61,32,101,95,114,101,118,111,108,117,116,101,74,111,105,110,116,32,124,124,32,109,95,116,121,112,101,65,32,61,61,32,101,95,112,114,105,115,109,97,116,105,99,74,111,105,110,116,0,0,0,0,0,0,0,48,32,60,61,32,101,100,103,101,49,32,38,38,32,101,100,103,101,49,32,
60,32,112,111,108,121,49,45,62,109,95,118,101,114,116,101,120,67,111,117,110,116,0,0,0,0,0,0,98,50,73,115,86,97,108,105,100,40,102,111,114,99,101,41,32,38,38,32,102,111,114,99,101,32,62,61,32,48,46,48,102,0,0,0,0,0,0,0,109,95,73,32,62,32,48,46,48,102,0,0,0,0,0,0,109,95,102,105,120,116,117,114,101,65,45,62,71,101,116,84,121,112,101,40,41,32,61,61,32,98,50,83,104,97,112,101,58,58,101,95,112,111,108,121,103,111,110,0,0,0,0,0,109,95,102,105,120,116,117,114,101,65,45,62,71,101,116,84,121,112,101,40,41,
32,61,61,32,98,50,83,104,97,112,101,58,58,101,95,101,100,103,101,0,0,0,0,0,0,0,0,32,32,106,111,105,110,116,115,91,37,100,93,32,61,32,109,95,119,111,114,108,100,45,62,67,114,101,97,116,101,74,111,105,110,116,40,38,106,100,41,59,10,0,0,0,0,0,0,32,32,106,100,46,108,101,110,103,116,104,66,32,61,32,37,46,49,53,108,101,102,59,10,0,0,0,0,0,0,0,0,32,32,106,100,46,117,112,112,101,114,84,114,97,110,115,108,97,116,105,111,110,32,61,32,37,46,49,53,108,101,102,59,10,0,0,0,0,0,0,0,112,111,105,110,116,67,111,117,
110,116,32,62,32,48,0,0,98,50,74,111,105,110,116,42,42,32,106,111,105,110,116,115,32,61,32,40,98,50,74,111,105,110,116,42,42,41,98,50,65,108,108,111,99,40,37,100,32,42,32,115,105,122,101,111,102,40,98,50,74,111,105,110,116,42,41,41,59,10,0,0,48,32,60,61,32,116,121,112,101,49,32,38,38,32,116,121,112,101,49,32,60,32,98,50,83,104,97,112,101,58,58,101,95,116,121,112,101,67,111,117,110,116,0,0,0,0,0,0,109,95,102,105,120,116,117,114,101,65,45,62,71,101,116,84,121,112,101,40,41,32,61,61,32,98,50,83,104,
97,112,101,58,58,101,95,99,105,114,99,108,101,0,0,0,0,0,0,32,32,32,32,115,104,97,112,101,46,109,95,114,97,100,105,117,115,32,61,32,37,46,49,53,108,101,102,59,10,0,0,109,95,102,105,120,116,117,114,101,65,45,62,71,101,116,84,121,112,101,40,41,32,61,61,32,98,50,83,104,97,112,101,58,58,101,95,99,104,97,105,110,0,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,68,121,110,97,109,105,99,115,47,98,50,70,105,120,116,117,114,101,46,99,112,112,0,0,0,0,0,0,0,48,32,60,61,32,105,71,32,
38,38,32,105,71,32,60,32,109,95,110,111,100,101,67,97,112,97,99,105,116,121,0,0,109,95,116,121,112,101,32,61,61,32,98,50,95,100,121,110,97,109,105,99,66,111,100,121,0,0,0,0,0,0,0,0,73,115,76,111,99,107,101,100,40,41,32,61,61,32,102,97,108,115,101,0,0,0,0,0,116,111,105,73,110,100,101,120,65,32,60,32,109,95,98,111,100,121,67,111,117,110,116,0,109,95,110,111,100,101,67,111,117,110,116,32,61,61,32,109,95,110,111,100,101,67,97,112,97,99,105,116,121,0,0,0,32,32,106,100,46,100,97,109,112,105,110,103,82,
97,116,105,111,32,61,32,37,46,49,53,108,101,102,59,10,0,0,0,32,32,106,100,46,117,112,112,101,114,65,110,103,108,101,32,61,32,37,46,49,53,108,101,102,59,10,0,0,0,0,0,32,32,106,100,46,108,101,110,103,116,104,65,32,61,32,37,46,49,53,108,101,102,59,10,0,0,0,0,0,0,0,0,32,32,106,100,46,108,111,119,101,114,84,114,97,110,115,108,97,116,105,111,110,32,61,32,37,46,49,53,108,101,102,59,10,0,0,0,0,0,0,0,109,95,112,114,111,120,121,67,111,117,110,116,32,61,61,32,48,0,0,0,0,0,0,0,98,50,66,111,100,121,42,42,32,98,
111,100,105,101,115,32,61,32,40,98,50,66,111,100,121,42,42,41,98,50,65,108,108,111,99,40,37,100,32,42,32,115,105,122,101,111,102,40,98,50,66,111,100,121,42,41,41,59,10,0,0,0,0,0,32,32,32,32,98,50,67,105,114,99,108,101,83,104,97,112,101,32,115,104,97,112,101,59,10,0,0,0,0,0,0,0,48,32,60,61,32,105,70,32,38,38,32,105,70,32,60,32,109,95,110,111,100,101,67,97,112,97,99,105,116,121,0,0,102,111,117,110,100,0,0,0,32,32,106,100,46,102,114,101,113,117,101,110,99,121,72,122,32,61,32,37,46,49,53,108,101,102,
59,10,0,0,0,0,32,32,106,100,46,108,111,119,101,114,65,110,103,108,101,32,61,32,37,46,49,53,108,101,102,59,10,0,0,0,0,0,32,32,106,100,46,109,97,120,84,111,114,113,117,101,32,61,32,37,46,49,53,108,101,102,59,10,0,0,0,0,0,0,109,95,119,111,114,108,100,45,62,83,101,116,71,114,97,118,105,116,121,40,103,41,59,10,0,0,0,0,0,0,0,0,32,32,32,32,102,100,46,102,105,108,116,101,114,46,103,114,111,117,112,73,110,100,101,120,32,61,32,105,110,116,49,54,40,37,100,41,59,10,0,0,48,32,60,61,32,105,67,32,38,38,32,105,67,
32,60,32,109,95,110,111,100,101,67,97,112,97,99,105,116,121,0,0,100,101,110,32,62,32,48,46,48,102,0,0,0,0,0,0,66,111,120,50,68,95,118,50,46,50,46,49,47,66,111,120,50,68,47,67,111,108,108,105,115,105,111,110,47,98,50,67,111,108,108,105,100,101,69,100,103,101,46,99,112,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,108,111,97,116,51,50,32,98,50,83,105,109,112,108,101,120,58,58,71,101,116,77,101,116,114,105,99,40,41,32,99,111,110,115,116,0,0,0,0,118,111,105,100,32,98,50,83,105,109,112,108,101,120,58,58,71,101,116,87,105,116,110,101,115,115,80,111,105,110,116,115,40,98,50,86,101,99,50,32,42,44,
32,98,50,86,101,99,50,32,42,41,32,99,111,110,115,116,0,0,0,0,0,0,98,50,86,101,99,50,32,98,50,83,105,109,112,108,101,120,58,58,71,101,116,67,108,111,115,101,115,116,80,111,105,110,116,40,41,32,99,111,110,115,116,0,0,0,0,0,0,0,102,108,111,97,116,51,50,32,98,50,83,101,112,97,114,97,116,105,111,110,70,117,110,99,116,105,111,110,58,58,69,118,97,108,117,97,116,101,40,105,110,116,51,50,44,32,105,110,116,51,50,44,32,102,108,111,97,116,51,50,41,32,99,111,110,115,116,0,0,0,0,0,102,108,111,97,116,51,50,32,98,
50,83,101,112,97,114,97,116,105,111,110,70,117,110,99,116,105,111,110,58,58,70,105,110,100,77,105,110,83,101,112,97,114,97,116,105,111,110,40,105,110,116,51,50,32,42,44,32,105,110,116,51,50,32,42,44,32,102,108,111,97,116,51,50,41,32,99,111,110,115,116,0,0,0,0,0,0,0,0,99,111,110,115,116,32,98,50,86,101,99,50,32,38,98,50,68,105,115,116,97,110,99,101,80,114,111,120,121,58,58,71,101,116,86,101,114,116,101,120,40,105,110,116,51,50,41,32,99,111,110,115,116,0,0,0,118,105,114,116,117,97,108,32,98,111,111,
108,32,98,50,80,111,108,121,103,111,110,83,104,97,112,101,58,58,82,97,121,67,97,115,116,40,98,50,82,97,121,67,97,115,116,79,117,116,112,117,116,32,42,44,32,99,111,110,115,116,32,98,50,82,97,121,67,97,115,116,73,110,112,117,116,32,38,44,32,99,111,110,115,116,32,98,50,84,114,97,110,115,102,111,114,109,32,38,44,32,105,110,116,51,50,41,32,99,111,110,115,116,0,0,0,0,0,0,0,118,105,114,116,117,97,108,32,118,111,105,100,32,98,50,80,111,108,121,103,111,110,83,104,97,112,101,58,58,67,111,109,112,117,116,101,
77,97,115,115,40,98,50,77,97,115,115,68,97,116,97,32,42,44,32,102,108,111,97,116,51,50,41,32,99,111,110,115,116,0,0,0,118,111,105,100,32,98,50,68,121,110,97,109,105,99,84,114,101,101,58,58,86,97,108,105,100,97,116,101,40,41,32,99,111,110,115,116,0,0,0,0,118,111,105,100,32,98,50,68,121,110,97,109,105,99,84,114,101,101,58,58,82,97,121,67,97,115,116,40,84,32,42,44,32,99,111,110,115,116,32,98,50,82,97,121,67,97,115,116,73,110,112,117,116,32,38,41,32,99,111,110,115,116,32,91,84,32,61,32,98,50,87,111,114,
108,100,82,97,121,67,97,115,116,87,114,97,112,112,101,114,93,0,0,0,0,0,0,118,111,105,100,32,98,50,68,121,110,97,109,105,99,84,114,101,101,58,58,86,97,108,105,100,97,116,101,83,116,114,117,99,116,117,114,101,40,105,110,116,51,50,41,32,99,111,110,115,116,0,0,0,0,0,0,118,111,105,100,32,98,50,68,121,110,97,109,105,99,84,114,101,101,58,58,86,97,108,105,100,97,116,101,77,101,116,114,105,99,115,40,105,110,116,51,50,41,32,99,111,110,115,116,0,0,0,0,0,0,0,0,105,110,116,51,50,32,98,50,68,121,110,97,109,105,
99,84,114,101,101,58,58,71,101,116,77,97,120,66,97,108,97,110,99,101,40,41,32,99,111,110,115,116,0,0,0,0,0,0,105,110,116,51,50,32,98,50,68,121,110,97,109,105,99,84,114,101,101,58,58,67,111,109,112,117,116,101,72,101,105,103,104,116,40,105,110,116,51,50,41,32,99,111,110,115,116,0,118,111,105,100,32,42,98,50,68,121,110,97,109,105,99,84,114,101,101,58,58,71,101,116,85,115,101,114,68,97,116,97,40,105,110,116,51,50,41,32,99,111,110,115,116,0,0,0,99,111,110,115,116,32,98,50,65,65,66,66,32,38,98,50,68,121,
110,97,109,105,99,84,114,101,101,58,58,71,101,116,70,97,116,65,65,66,66,40,105,110,116,51,50,41,32,99,111,110,115,116,0,0,0,0,118,105,114,116,117,97,108,32,98,111,111,108,32,98,50,67,104,97,105,110,83,104,97,112,101,58,58,82,97,121,67,97,115,116,40,98,50,82,97,121,67,97,115,116,79,117,116,112,117,116,32,42,44,32,99,111,110,115,116,32,98,50,82,97,121,67,97,115,116,73,110,112,117,116,32,38,44,32,99,111,110,115,116,32,98,50,84,114,97,110,115,102,111,114,109,32,38,44,32,105,110,116,51,50,41,32,99,111,
110,115,116,0,118,111,105,100,32,98,50,67,104,97,105,110,83,104,97,112,101,58,58,71,101,116,67,104,105,108,100,69,100,103,101,40,98,50,69,100,103,101,83,104,97,112,101,32,42,44,32,105,110,116,51,50,41,32,99,111,110,115,116,0,0,0,0,0,118,105,114,116,117,97,108,32,118,111,105,100,32,98,50,67,104,97,105,110,83,104,97,112,101,58,58,67,111,109,112,117,116,101,65,65,66,66,40,98,50,65,65,66,66,32,42,44,32,99,111,110,115,116,32,98,50,84,114,97,110,115,102,111,114,109,32,38,44,32,105,110,116,51,50,41,32,99,
111,110,115,116,0,0,0,0,0,0,118,111,105,100,32,98,50,83,105,109,112,108,101,120,58,58,82,101,97,100,67,97,99,104,101,40,99,111,110,115,116,32,98,50,83,105,109,112,108,101,120,67,97,99,104,101,32,42,44,32,99,111,110,115,116,32,98,50,68,105,115,116,97,110,99,101,80,114,111,120,121,32,42,44,32,99,111,110,115,116,32,98,50,84,114,97,110,115,102,111,114,109,32,38,44,32,99,111,110,115,116,32,98,50,68,105,115,116,97,110,99,101,80,114,111,120,121,32,42,44,32,99,111,110,115,116,32,98,50,84,114,97,110,115,102,
111,114,109,32,38,41,0,0,0,118,111,105,100,32,98,50,70,105,120,116,117,114,101,58,58,68,101,115,116,114,111,121,40,98,50,66,108,111,99,107,65,108,108,111,99,97,116,111,114,32,42,41,0,0,0,0,0,118,111,105,100,32,98,50,70,105,120,116,117,114,101,58,58,67,114,101,97,116,101,80,114,111,120,105,101,115,40,98,50,66,114,111,97,100,80,104,97,115,101,32,42,44,32,99,111,110,115,116,32,98,50,84,114,97,110,115,102,111,114,109,32,38,41,0,0,0,0,0,0,115,116,97,116,105,99,32,118,111,105,100,32,98,50,67,111,110,116,
97,99,116,58,58,68,101,115,116,114,111,121,40,98,50,67,111,110,116,97,99,116,32,42,44,32,98,50,66,108,111,99,107,65,108,108,111,99,97,116,111,114,32,42,41,0,115,116,97,116,105,99,32,98,50,67,111,110,116,97,99,116,32,42,98,50,67,111,110,116,97,99,116,58,58,67,114,101,97,116,101,40,98,50,70,105,120,116,117,114,101,32,42,44,32,105,110,116,51,50,44,32,98,50,70,105,120,116,117,114,101,32,42,44,32,105,110,116,51,50,44,32,98,50,66,108,111,99,107,65,108,108,111,99,97,116,111,114,32,42,41,0,118,111,105,100,
32,98,50,73,115,108,97,110,100,58,58,83,111,108,118,101,84,79,73,40,99,111,110,115,116,32,98,50,84,105,109,101,83,116,101,112,32,38,44,32,105,110,116,51,50,44,32,105,110,116,51,50,41,0,0,0,0,0,0,0,118,111,105,100,32,98,50,73,115,108,97,110,100,58,58,65,100,100,40,98,50,67,111,110,116,97,99,116,32,42,41,0,118,111,105,100,32,98,50,73,115,108,97,110,100,58,58,65,100,100,40,98,50,74,111,105,110,116,32,42,41,0,0,0,118,111,105,100,32,98,50,73,115,108,97,110,100,58,58,65,100,100,40,98,50,66,111,100,121,
32,42,41,0,0,0,0,118,111,105,100,32,98,50,87,111,114,108,100,58,58,68,114,97,119,83,104,97,112,101,40,98,50,70,105,120,116,117,114,101,32,42,44,32,99,111,110,115,116,32,98,50,84,114,97,110,115,102,111,114,109,32,38,44,32,99,111,110,115,116,32,98,50,67,111,108,111,114,32,38,41,0,0,0,0,0,0,118,111,105,100,32,98,50,87,111,114,108,100,58,58,83,111,108,118,101,84,79,73,40,99,111,110,115,116,32,98,50,84,105,109,101,83,116,101,112,32,38,41,0,0,0,0,0,0,118,111,105,100,32,98,50,87,111,114,108,100,58,58,83,
111,108,118,101,40,99,111,110,115,116,32,98,50,84,105,109,101,83,116,101,112,32,38,41,0,118,111,105,100,32,98,50,87,111,114,108,100,58,58,68,101,115,116,114,111,121,74,111,105,110,116,40,98,50,74,111,105,110,116,32,42,41,0,0,0,118,111,105,100,32,98,50,87,111,114,108,100,58,58,68,101,115,116,114,111,121,66,111,100,121,40,98,50,66,111,100,121,32,42,41,0,0,0,0,0,98,50,74,111,105,110,116,32,42,98,50,87,111,114,108,100,58,58,67,114,101,97,116,101,74,111,105,110,116,40,99,111,110,115,116,32,98,50,74,111,
105,110,116,68,101,102,32,42,41,0,0,0,0,0,0,0,98,50,66,111,100,121,32,42,98,50,87,111,114,108,100,58,58,67,114,101,97,116,101,66,111,100,121,40,99,111,110,115,116,32,98,50,66,111,100,121,68,101,102,32,42,41,0,0,118,111,105,100,32,98,50,83,119,101,101,112,58,58,65,100,118,97,110,99,101,40,102,108,111,97,116,51,50,41,0,0,98,50,74,111,105,110,116,58,58,98,50,74,111,105,110,116,40,99,111,110,115,116,32,98,50,74,111,105,110,116,68,101,102,32,42,41,0,0,0,0,115,116,97,116,105,99,32,118,111,105,100,32,98,
50,74,111,105,110,116,58,58,68,101,115,116,114,111,121,40,98,50,74,111,105,110,116,32,42,44,32,98,50,66,108,111,99,107,65,108,108,111,99,97,116,111,114,32,42,41,0,0,0,0,0,115,116,97,116,105,99,32,98,50,74,111,105,110,116,32,42,98,50,74,111,105,110,116,58,58,67,114,101,97,116,101,40,99,111,110,115,116,32,98,50,74,111,105,110,116,68,101,102,32,42,44,32,98,50,66,108,111,99,107,65,108,108,111,99,97,116,111,114,32,42,41,0,98,50,66,111,100,121,58,58,98,50,66,111,100,121,40,99,111,110,115,116,32,98,50,66,
111,100,121,68,101,102,32,42,44,32,98,50,87,111,114,108,100,32,42,41,0,0,0,0,118,111,105,100,32,98,50,66,111,100,121,58,58,83,101,116,65,99,116,105,118,101,40,98,111,111,108,41,0,0,0,0,118,111,105,100,32,98,50,66,111,100,121,58,58,83,101,116,84,121,112,101,40,98,50,66,111,100,121,84,121,112,101,41,0,0,0,0,0,0,0,0,118,111,105,100,32,98,50,66,111,100,121,58,58,68,101,115,116,114,111,121,70,105,120,116,117,114,101,40,98,50,70,105,120,116,117,114,101,32,42,41,0,0,0,0,0,0,0,0,118,111,105,100,32,98,50,
66,111,100,121,58,58,82,101,115,101,116,77,97,115,115,68,97,116,97,40,41,0,0,0,0,98,50,70,105,120,116,117,114,101,32,42,98,50,66,111,100,121,58,58,67,114,101,97,116,101,70,105,120,116,117,114,101,40,99,111,110,115,116,32,98,50,70,105,120,116,117,114,101,68,101,102,32,42,41,0,0,118,111,105,100,32,98,50,66,111,100,121,58,58,83,101,116,84,114,97,110,115,102,111,114,109,40,99,111,110,115,116,32,98,50,86,101,99,50,32,38,44,32,102,108,111,97,116,51,50,41,0,0,0,0,0,0,118,111,105,100,32,98,50,66,111,100,
121,58,58,83,101,116,77,97,115,115,68,97,116,97,40,99,111,110,115,116,32,98,50,77,97,115,115,68,97,116,97,32,42,41,0,0,0,0,98,50,80,111,108,121,103,111,110,65,110,100,67,105,114,99,108,101,67,111,110,116,97,99,116,58,58,98,50,80,111,108,121,103,111,110,65,110,100,67,105,114,99,108,101,67,111,110,116,97,99,116,40,98,50,70,105,120,116,117,114,101,32,42,44,32,98,50,70,105,120,116,117,114,101,32,42,41,0,0,118,111,105,100,32,98,50,80,111,115,105,116,105,111,110,83,111,108,118,101,114,77,97,110,105,102,
111,108,100,58,58,73,110,105,116,105,97,108,105,122,101,40,98,50,67,111,110,116,97,99,116,80,111,115,105,116,105,111,110,67,111,110,115,116,114,97,105,110,116,32,42,44,32,99,111,110,115,116,32,98,50,84,114,97,110,115,102,111,114,109,32,38,44,32,99,111,110,115,116,32,98,50,84,114,97,110,115,102,111,114,109,32,38,44,32,105,110,116,51,50,41,0,0,0,0,0,0,0,98,50,67,104,97,105,110,65,110,100,80,111,108,121,103,111,110,67,111,110,116,97,99,116,58,58,98,50,67,104,97,105,110,65,110,100,80,111,108,121,103,
111,110,67,111,110,116,97,99,116,40,98,50,70,105,120,116,117,114,101,32,42,44,32,105,110,116,51,50,44,32,98,50,70,105,120,116,117,114,101,32,42,44,32,105,110,116,51,50,41,0,0,0,0,0,0,98,50,69,100,103,101,65,110,100,80,111,108,121,103,111,110,67,111,110,116,97,99,116,58,58,98,50,69,100,103,101,65,110,100,80,111,108,121,103,111,110,67,111,110,116,97,99,116,40,98,50,70,105,120,116,117,114,101,32,42,44,32,98,50,70,105,120,116,117,114,101,32,42,41,0,0,0,0,0,0,98,50,67,104,97,105,110,65,110,100,67,105,
114,99,108,101,67,111,110,116,97,99,116,58,58,98,50,67,104,97,105,110,65,110,100,67,105,114,99,108,101,67,111,110,116,97,99,116,40,98,50,70,105,120,116,117,114,101,32,42,44,32,105,110,116,51,50,44,32,98,50,70,105,120,116,117,114,101,32,42,44,32,105,110,116,51,50,41,0,0,0,0,0,0,0,0,98,50,69,100,103,101,65,110,100,67,105,114,99,108,101,67,111,110,116,97,99,116,58,58,98,50,69,100,103,101,65,110,100,67,105,114,99,108,101,67,111,110,116,97,99,116,40,98,50,70,105,120,116,117,114,101,32,42,44,32,98,50,70,
105,120,116,117,114,101,32,42,41,0,0,0,0,0,0,0,0,102,108,111,97,116,51,50,32,98,50,83,101,112,97,114,97,116,105,111,110,70,117,110,99,116,105,111,110,58,58,73,110,105,116,105,97,108,105,122,101,40,99,111,110,115,116,32,98,50,83,105,109,112,108,101,120,67,97,99,104,101,32,42,44,32,99,111,110,115,116,32,98,50,68,105,115,116,97,110,99,101,80,114,111,120,121,32,42,44,32,99,111,110,115,116,32,98,50,83,119,101,101,112,32,38,44,32,99,111,110,115,116,32,98,50,68,105,115,116,97,110,99,101,80,114,111,120,121,
32,42,44,32,99,111,110,115,116,32,98,50,83,119,101,101,112,32,38,44,32,102,108,111,97,116,51,50,41,0,0,0,98,50,83,116,97,99,107,65,108,108,111,99,97,116,111,114,58,58,126,98,50,83,116,97,99,107,65,108,108,111,99,97,116,111,114,40,41,0,0,0,118,111,105,100,32,42,98,50,83,116,97,99,107,65,108,108,111,99,97,116,111,114,58,58,65,108,108,111,99,97,116,101,40,105,110,116,51,50,41,0,118,111,105,100,32,98,50,83,116,97,99,107,65,108,108,111,99,97,116,111,114,58,58,70,114,101,101,40,118,111,105,100,32,42,41,
0,0,0,0,0,118,111,105,100,32,98,50,80,117,108,108,101,121,74,111,105,110,116,68,101,102,58,58,73,110,105,116,105,97,108,105,122,101,40,98,50,66,111,100,121,32,42,44,32,98,50,66,111,100,121,32,42,44,32,99,111,110,115,116,32,98,50,86,101,99,50,32,38,44,32,99,111,110,115,116,32,98,50,86,101,99,50,32,38,44,32,99,111,110,115,116,32,98,50,86,101,99,50,32,38,44,32,99,111,110,115,116,32,98,50,86,101,99,50,32,38,44,32,102,108,111,97,116,51,50,41,0,0,118,111,105,100,32,98,50,80,114,105,115,109,97,116,105,99,
74,111,105,110,116,58,58,83,101,116,76,105,109,105,116,115,40,102,108,111,97,116,51,50,44,32,102,108,111,97,116,51,50,41,0,0,0,0,0,0,98,50,80,111,108,121,103,111,110,67,111,110,116,97,99,116,58,58,98,50,80,111,108,121,103,111,110,67,111,110,116,97,99,116,40,98,50,70,105,120,116,117,114,101,32,42,44,32,98,50,70,105,120,116,117,114,101,32,42,41,0,0,0,0,98,50,66,108,111,99,107,65,108,108,111,99,97,116,111,114,58,58,98,50,66,108,111,99,107,65,108,108,111,99,97,116,111,114,40,41,0,0,0,0,118,111,105,100,
32,42,98,50,66,108,111,99,107,65,108,108,111,99,97,116,111,114,58,58,65,108,108,111,99,97,116,101,40,105,110,116,51,50,41,0,118,111,105,100,32,98,50,66,108,111,99,107,65,108,108,111,99,97,116,111,114,58,58,70,114,101,101,40,118,111,105,100,32,42,44,32,105,110,116,51,50,41,0,0,0,0,0,0,118,111,105,100,32,98,50,82,101,118,111,108,117,116,101,74,111,105,110,116,58,58,83,101,116,76,105,109,105,116,115,40,102,108,111,97,116,51,50,44,32,102,108,111,97,116,51,50,41,0,0,0,0,0,0,0,118,111,105,100,32,98,50,
70,114,105,99,116,105,111,110,74,111,105,110,116,58,58,83,101,116,77,97,120,84,111,114,113,117,101,40,102,108,111,97,116,51,50,41,0,0,0,0,0,118,111,105,100,32,98,50,70,114,105,99,116,105,111,110,74,111,105,110,116,58,58,83,101,116,77,97,120,70,111,114,99,101,40,102,108,111,97,116,51,50,41,0,0,0,0,0,0,118,111,105,100,32,98,50,68,105,115,116,97,110,99,101,80,114,111,120,121,58,58,83,101,116,40,99,111,110,115,116,32,98,50,83,104,97,112,101,32,42,44,32,105,110,116,51,50,41,0,0,0,0,0,0,0,98,50,67,111,
110,116,97,99,116,83,111,108,118,101,114,58,58,98,50,67,111,110,116,97,99,116,83,111,108,118,101,114,40,98,50,67,111,110,116,97,99,116,83,111,108,118,101,114,68,101,102,32,42,41,0,0,118,111,105,100,32,98,50,67,111,110,116,97,99,116,83,111,108,118,101,114,58,58,73,110,105,116,105,97,108,105,122,101,86,101,108,111,99,105,116,121,67,111,110,115,116,114,97,105,110,116,115,40,41,0,0,0,118,111,105,100,32,98,50,67,111,110,116,97,99,116,83,111,108,118,101,114,58,58,83,111,108,118,101,86,101,108,111,99,105,
116,121,67,111,110,115,116,114,97,105,110,116,115,40,41,0,0,0,0,0,0,0,0,98,50,67,105,114,99,108,101,67,111,110,116,97,99,116,58,58,98,50,67,105,114,99,108,101,67,111,110,116,97,99,116,40,98,50,70,105,120,116,117,114,101,32,42,44,32,98,50,70,105,120,116,117,114,101,32,42,41,0,0,0,0,0,0,118,111,105,100,32,98,50,80,111,108,121,103,111,110,83,104,97,112,101,58,58,83,101,116,40,99,111,110,115,116,32,98,50,86,101,99,50,32,42,44,32,105,110,116,51,50,41,0,98,50,80,117,108,108,101,121,74,111,105,110,116,58,
58,98,50,80,117,108,108,101,121,74,111,105,110,116,40,99,111,110,115,116,32,98,50,80,117,108,108,101,121,74,111,105,110,116,68,101,102,32,42,41,0,0,98,111,111,108,32,98,50,68,121,110,97,109,105,99,84,114,101,101,58,58,77,111,118,101,80,114,111,120,121,40,105,110,116,51,50,44,32,99,111,110,115,116,32,98,50,65,65,66,66,32,38,44,32,99,111,110,115,116,32,98,50,86,101,99,50,32,38,41,0,0,0,0,118,111,105,100,32,98,50,68,121,110,97,109,105,99,84,114,101,101,58,58,70,114,101,101,78,111,100,101,40,105,110,
116,51,50,41,0,0,0,0,0,105,110,116,51,50,32,98,50,68,121,110,97,109,105,99,84,114,101,101,58,58,66,97,108,97,110,99,101,40,105,110,116,51,50,41,0,0,0,0,0,118,111,105,100,32,98,50,68,121,110,97,109,105,99,84,114,101,101,58,58,68,101,115,116,114,111,121,80,114,111,120,121,40,105,110,116,51,50,41,0,105,110,116,51,50,32,98,50,68,121,110,97,109,105,99,84,114,101,101,58,58,65,108,108,111,99,97,116,101,78,111,100,101,40,41,0,0,0,0,0,118,111,105,100,32,98,50,68,121,110,97,109,105,99,84,114,101,101,58,58,
73,110,115,101,114,116,76,101,97,102,40,105,110,116,51,50,41,0,0,0,98,50,77,111,117,115,101,74,111,105,110,116,58,58,98,50,77,111,117,115,101,74,111,105,110,116,40,99,111,110,115,116,32,98,50,77,111,117,115,101,74,111,105,110,116,68,101,102,32,42,41,0,0,0,0,0,118,105,114,116,117,97,108,32,118,111,105,100,32,98,50,77,111,117,115,101,74,111,105,110,116,58,58,73,110,105,116,86,101,108,111,99,105,116,121,67,111,110,115,116,114,97,105,110,116,115,40,99,111,110,115,116,32,98,50,83,111,108,118,101,114,68,
97,116,97,32,38,41,0,0,0,0,0,0,0,0,118,111,105,100,32,98,50,67,104,97,105,110,83,104,97,112,101,58,58,67,114,101,97,116,101,67,104,97,105,110,40,99,111,110,115,116,32,98,50,86,101,99,50,32,42,44,32,105,110,116,51,50,41,0,0,0,118,111,105,100,32,98,50,67,104,97,105,110,83,104,97,112,101,58,58,67,114,101,97,116,101,76,111,111,112,40,99,111,110,115,116,32,98,50,86,101,99,50,32,42,44,32,105,110,116,51,50,41,0,0,0,0,98,50,71,101,97,114,74,111,105,110,116,58,58,98,50,71,101,97,114,74,111,105,110,116,40,
99,111,110,115,116,32,98,50,71,101,97,114,74,111,105,110,116,68,101,102,32,42,41,0,0,0,0,0,0,0,0,118,111,105,100,32,98,50,71,101,97,114,74,111,105,110,116,58,58,83,101,116,82,97,116,105,111,40,102,108,111,97,116,51,50,41,0,0,0,0,0,118,111,105,100,32,98,50,70,105,110,100,73,110,99,105,100,101,110,116,69,100,103,101,40,98,50,67,108,105,112,86,101,114,116,101,120,32,42,44,32,99,111,110,115,116,32,98,50,80,111,108,121,103,111,110,83,104,97,112,101,32,42,44,32,99,111,110,115,116,32,98,50,84,114,97,110,
115,102,111,114,109,32,38,44,32,105,110,116,51,50,44,32,99,111,110,115,116,32,98,50,80,111,108,121,103,111,110,83,104,97,112,101,32,42,44,32,99,111,110,115,116,32,98,50,84,114,97,110,115,102,111,114,109,32,38,41,0,0,0,0,0,0,0,0,102,108,111,97,116,51,50,32,98,50,69,100,103,101,83,101,112,97,114,97,116,105,111,110,40,99,111,110,115,116,32,98,50,80,111,108,121,103,111,110,83,104,97,112,101,32,42,44,32,99,111,110,115,116,32,98,50,84,114,97,110,115,102,111,114,109,32,38,44,32,105,110,116,51,50,44,32,99,
111,110,115,116,32,98,50,80,111,108,121,103,111,110,83,104,97,112,101,32,42,44,32,99,111,110,115,116,32,98,50,84,114,97,110,115,102,111,114,109,32,38,41,0,0,0,0,0,0,0,98,50,86,101,99,50,32,67,111,109,112,117,116,101,67,101,110,116,114,111,105,100,40,99,111,110,115,116,32,98,50,86,101,99,50,32,42,44,32,105,110,116,51,50,41,0,0,0,118,111,105,100,32,98,50,67,111,108,108,105,100,101,69,100,103,101,65,110,100,67,105,114,99,108,101,40,98,50,77,97,110,105,102,111,108,100,32,42,44,32,99,111,110,115,116,32,
98,50,69,100,103,101,83,104,97,112,101,32,42,44,32,99,111,110,115,116,32,98,50,84,114,97,110,115,102,111,114,109,32,38,44,32,99,111,110,115,116,32,98,50,67,105,114,99,108,101,83,104,97,112,101,32,42,44,32,99,111,110,115,116,32,98,50,84,114,97,110,115,102,111,114,109,32,38,41,0,118,111,105,100,32,98,50,84,105,109,101,79,102,73,109,112,97,99,116,40,98,50,84,79,73,79,117,116,112,117,116,32,42,44,32,99,111,110,115,116,32,98,50,84,79,73,73,110,112,117,116,32,42,41,0,0,118,111,105,100,32,98,50,68,105,115,
116,97,110,99,101,40,98,50,68,105,115,116,97,110,99,101,79,117,116,112,117,116,32,42,44,32,98,50,83,105,109,112,108,101,120,67,97,99,104,101,32,42,44,32,99,111,110,115,116,32,98,50,68,105,115,116,97,110,99,101,73,110,112,117,116,32,42,41,0,0,0,0,0,0,136,83,0,0,78,0,0,0,4,1,0,0,150,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,83,0,0,42,0,0,0,62,0,0,0,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,83,0,0,42,0,0,0,42,0,0,0,42,0,0,0,42,0,0,0,20,1,0,0,210,0,0,0,48,0,0,0,42,0,0,0,42,0,0,0,42,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,224,83,0,0,168,0,0,0,254,0,0,0,56,0,0,0,82,0,0,0,44,0,0,0,42,0,0,0,86,0,0,0,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,83,0,0,58,0,0,0,74,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,83,0,0,70,0,0,0,40,1,0,0,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,84,0,0,62,0,0,0,190,0,0,0,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,84,0,0,54,0,0,0,236,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,84,0,0,80,0,0,0,70,1,0,0,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,84,0,0,90,1,0,0,66,0,
0,0,58,1,0,0,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,84,0,0,52,1,0,0,102,0,0,0,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,84,0,0,182,0,0,0,152,0,0,0,144,1,0,0,38,1,0,0,48,0,0,0,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,84,0,0,82,0,0,0,222,0,0,0,68,0,0,0,78,0,0,0,76,0,0,0,136,0,0,0,166,0,0,0,48,0,0,0,4,1,0,0,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,84,0,0,90,0,0,0,46,1,0,0,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,84,0,0,112,1,0,0,0,1,0,0,54,0,0,0,66,0,0,0,68,0,0,0,54,0,0,0,88,1,0,0,114,1,0,0,164,1,0,0,168,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,84,0,0,120,0,0,0,230,0,0,0,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,84,0,0,106,1,0,0,216,0,0,0,72,0,0,0,84,0,0,0,104,0,0,0,44,1,0,0,160,0,0,0,130,0,0,0,108,1,0,0,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,84,0,0,206,1,0,0,120,1,0,0,78,0,0,0,88,0,0,0,50,1,0,0,82,1,0,0,58,0,0,0,84,0,0,0,198,1,0,0,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,84,0,0,110,0,0,0,250,0,0,0,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,84,0,0,88,0,0,0,234,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,192,84,0,0,180,0,0,0,220,0,0,0,104,0,0,0,100,1,0,0,64,0,0,0,42,0,0,0,84,0,0,0,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,84,0,0,192,0,0,0,144,0,0,0,80,0,0,0,80,0,0,0,98,0,0,0,96,0,0,0,6,1,0,0,80,0,0,0,180,1,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,84,0,0,140,0,0,0,114,0,0,0,82,0,0,0,70,2,0,0,54,0,0,0,66,0,0,0,42,0,0,0,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,84,0,0,212,1,0,0,156,0,0,0,52,0,0,0,48,0,0,0,64,1,0,0,42,0,0,0,194,0,0,0,200,0,0,0,132,1,0,0,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,126,0,0,
0,80,1,0,0,56,0,0,0,50,0,0,0,36,1,0,0,76,1,0,0,92,1,0,0,8,1,0,0,124,1,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,85,0,0,108,0,0,0,8,1,0,0,162,0,0,0,76,1,0,0,68,0,0,0,50,0,0,0,52,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,85,0,0,224,0,0,0,184,1,0,0,76,0,0,0,58,0,0,0,48,1,0,0,128,0,0,0,158,0,0,0,184,0,0,0,66,1,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,85,0,0,170,0,0,0,88,0,0,0,60,0,0,0,62,0,0,0,84,1,0,0,30,1,0,0,238,0,0,0,114,0,0,0,162,0,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,85,0,0,194,0,0,0,12,1,0,0,
46,0,0,0,52,0,0,0,208,0,0,0,56,1,0,0,64,0,0,0,54,1,0,0]).concat([26,1,0,0,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,85,0,0,80,0,0,0,56,0,0,0,142,0,0,0,68,2,0,0,66,0,0,0,68,0,0,0,44,0,0,0,82,0,0,0,0,0,0,0,0,0,0,0,83,116,57,116,121,112,101,95,105,110,102,111,0,0,0,0,83,116,57,101,120,99,101,112,116,105,111,110,0,0,0,0,83,116,57,98,97,100,95,97,108,108,111,99,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,78,49,
48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,57,98,50,67,111,110,116,97,99,116,0,0,0,0,0,0,55,98,50,83,104,97,112,101,0,0,0,0,0,0,0,0,55,98,50,74,111,105,110,116,0,0,0,0,0,0,0,0,54,98,50,68,114,97,119,0,50,53,98,50,80,111,108,121,103,111,110,65,110,100,67,105,114,99,108,101,67,111,110,116,97,99,
116,0,0,0,0,0,50,52,98,50,67,104,97,105,110,65,110,100,80,111,108,121,103,111,110,67,111,110,116,97,99,116,0,0,0,0,0,0,50,51,98,50,69,100,103,101,65,110,100,80,111,108,121,103,111,110,67,111,110,116,97,99,116,0,0,0,0,0,0,0,50,51,98,50,67,104,97,105,110,65,110,100,67,105,114,99,108,101,67,111,110,116,97,99,116,0,0,0,0,0,0,0,50,50,98,50,69,100,103,101,65,110,100,67,105,114,99,108,101,67,111,110,116,97,99,116,0,0,0,0,0,0,0,0,50,49,98,50,68,101,115,116,114,117,99,116,105,111,110,76,105,115,116,101,110,
101,114,0,49,55,98,50,82,97,121,67,97,115,116,67,97,108,108,98,97,99,107,0,0,0,0,0,49,55,98,50,67,111,110,116,97,99,116,76,105,115,116,101,110,101,114,0,0,0,0,0,49,54,98,50,80,114,105,115,109,97,116,105,99,74,111,105,110,116,0,0,0,0,0,0,49,54,98,50,80,111,108,121,103,111,110,67,111,110,116,97,99,116,0,0,0,0,0,0,49,53,98,50,82,101,118,111,108,117,116,101,74,111,105,110,116,0,0,0,0,0,0,0,49,53,98,50,81,117,101,114,121,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,49,53,98,50,70,114,105,99,116,105,111,110,
74,111,105,110,116,0,0,0,0,0,0,0,49,53,98,50,68,105,115,116,97,110,99,101,74,111,105,110,116,0,0,0,0,0,0,0,49,53,98,50,67,111,110,116,97,99,116,70,105,108,116,101,114,0,0,0,0,0,0,0,49,53,98,50,67,105,114,99,108,101,67,111,110,116,97,99,116,0,0,0,0,0,0,0,49,52,98,50,80,111,108,121,103,111,110,83,104,97,112,101,0,0,0,0,0,0,0,0,49,51,98,50,80,117,108,108,101,121,74,111,105,110,116,0,49,51,98,50,67,105,114,99,108,101,83,104,97,112,101,0,49,50,98,50,87,104,101,101,108,74,111,105,110,116,0,0,49,50,98,50,
77,111,117,115,101,74,111,105,110,116,0,0,49,50,98,50,67,104,97,105,110,83,104,97,112,101,0,0,49,49,98,50,87,101,108,100,74,111,105,110,116,0,0,0,49,49,98,50,82,111,112,101,74,111,105,110,116,0,0,0,49,49,98,50,71,101,97,114,74,111,105,110,116,0,0,0,49,49,98,50,69,100,103,101,83,104,97,112,101,0,0,0,0,0,0,0,72,80,0,0,0,0,0,0,88,80,0,0,0,0,0,0,104,80,0,0,128,83,0,0,0,0,0,0,0,0,0,0,120,80,0,0,168,83,0,0,0,0,0,0,0,0,0,0,160,80,0,0,184,83,0,0,0,0,0,0,0,0,0,0,200,80,0,0,120,83,0,0,0,0,0,0,0,0,0,0,240,80,
0,0,0,0,0,0,0,81,0,0,0,0,0,0,16,81,0,0,0,0,0,0,32,81,0,0,0,0,0,0,40,81,0,0,200,83,0,0,0,0,0,0,0,0,0,0,72,81,0,0,200,83,0,0,0,0,0,0,0,0,0,0,104,81,0,0,200,83,0,0,0,0,0,0,0,0,0,0,136,81,0,0,200,83,0,0,0,0,0,0,0,0,0,0,168,81,0,0,200,83,0,0,0,0,0,0,0,0,0,0,200,81,0,0,0,0,0,0,224,81,0,0,0,0,0,0,248,81,0,0,0,0,0,0,16,82,0,0,216,83,0,0,0,0,0,0,0,0,0,0,40,82,0,0,200,83,0,0,0,0,0,0,0,0,0,0,64,82,0,0,216,83,0,0,0,0,0,0,0,0,0,0,88,82,0,0,0,0,0,0,112,82,0,0,216,83,0,0,0,0,0,0,0,0,0,0,136,82,0,0,216,83,0,0,0,
0,0,0,0,0,0,0,160,82,0,0,0,0,0,0,184,82,0,0,200,83,0,0,0,0,0,0,0,0,0,0,208,82,0,0,208,83,0,0,0,0,0,0,0,0,0,0,232,82,0,0,216,83,0,0,0,0,0,0,0,0,0,0,248,82,0,0,208,83,0,0,0,0,0,0,0,0,0,0,8,83,0,0,216,83,0,0,0,0,0,0,0,0,0,0,24,83,0,0,216,83,0,0,0,0,0,0,0,0,0,0,40,83,0,0,208,83,0,0,0,0,0,0,0,0,0,0,56,83,0,0,216,83,0,0,0,0,0,0,0,0,0,0,72,83,0,0,216,83,0,0,0,0,0,0,0,0,0,0,88,83,0,0,216,83,0,0,0,0,0,0,0,0,0,0,104,83,0,0,208,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,32,0,0,0,64,0,0,0,96,0,0,0,128,0,0,0,160,0,0,0,192,0,0,0,224,0,0,0,0,1,0,0,64,1,0,0,128,1,0,0,192,1,0,0,0,2,0,0,128,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]),"i8",Wa,8);q[s+8>>2]=288;q[s+12>>2]=224;q[s+16>>2]=130;q[s+20>>2]=290;q[s+24>>2]=52;q[s+28>>2]=42;q[s+32>>2]=46;q[s+36>>2]=60;q[t+8>>2]=288;q[t+12>>2]=336;q[t+16>>2]=130;q[t+20>>2]=290;q[t+24>>2]=52;q[t+28>>2]=44;q[t+32>>2]=48;q[t+36>>2]=74;q[5342]=t+8|0;q[5344]=t+8|0;q[5346]=s+8|0;q[5350]=s+8|0;q[5354]=s+8|0;q[5358]=s+8|0;q[5362]=t+8|0;q[5364]=t+8|0;q[5366]=t+8|0;q[5368]=t+8|0;q[5370]=s+8|0;q[5374]=s+8|0;
q[5378]=s+8|0;q[5382]=s+8|0;q[5386]=s+8|0;q[5390]=t+8|0;q[5392]=t+8|0;q[5394]=t+8|0;q[5396]=s+8|0;q[5400]=s+8|0;q[5404]=s+8|0;q[5408]=t+8|0;q[5410]=s+8|0;q[5414]=s+8|0;q[5418]=t+8|0;q[5420]=s+8|0;q[5424]=s+8|0;q[5428]=s+8|0;q[5432]=s+8|0;q[5436]=s+8|0;q[5440]=s+8|0;q[5444]=s+8|0;q[5448]=s+8|0;q[5452]=s+8|0;q[5456]=s+8|0;q[5460]=s+8|0;var wb=Fa(Xa(12,"i8",Va),8);qa(0==wb%8);
function xb(a){function c(){this.name="ExitStatus";this.message="Program terminated with exit("+a+")";this.status=a;Module.print("Exit Status: "+a)}c.prototype=Error();gb(jb);Ha=j;b(new c)}Module._memcpy=yb;var zb=Math.sqrt;Module._memset=Ab;var Bb=Math.sin,Cb=Math.cos,Db=Math.floor,Eb=5,Fb=6,Gb=9,Hb=13,Ib=21,Jb=22,Kb=0;function Lb(a){return q[Kb>>2]=a}var Mb=Xa(1,"i32*",Va),Nb=Xa(1,"i32*",Va),Ob=Xa(1,"i32*",Va),Pb=Xa(1,"i32*",Va),Qb=2,v=[l],Rb=j;
function Sb(a,c){if("string"!==typeof a)return l;c===f&&(c="/");a&&"/"==a[0]&&(c="");for(var d=(c+"/"+a).split("/").reverse(),e=[""];d.length;){var g=d.pop();""==g||"."==g||(".."==g?1<e.length&&e.pop():e.push(g))}return 1==e.length?"/":e.join("/")}
function Tb(a,c,d){var e={S:n,o:n,error:0,name:l,path:l,object:l,C:n,F:l,D:l},a=Sb(a);if("/"==a)e.S=j,e.o=e.C=j,e.name="/",e.path=e.F="/",e.object=e.D=Ub;else if(a!==l)for(var d=d||0,a=a.slice(1).split("/"),g=Ub,h=[""];a.length;){1==a.length&&g.g&&(e.C=j,e.F=1==h.length?"/":h.join("/"),e.D=g,e.name=a[0]);var i=a.shift();if(g.g)if(g.H){if(!g.d.hasOwnProperty(i)){e.error=2;break}}else{e.error=Hb;break}else{e.error=20;break}g=g.d[i];if(g.link&&!(c&&0==a.length)){if(40<d){e.error=92;break}e=Sb(g.link,
h.join("/"));e=Tb([e].concat(a).join("/"),c,d+1);break}h.push(i);0==a.length&&(e.o=j,e.path=h.join("/"),e.object=g)}return e}function Vb(a){Wb();a=Tb(a,f);if(a.o)return a.object;Lb(a.error);return l}
function Xb(a,c,d,e,g){a||(a="/");"string"===typeof a&&(a=Vb(a));a||(Lb(Hb),b(Error("Parent path must exist.")));a.g||(Lb(20),b(Error("Parent must be a folder.")));!a.write&&!Rb&&(Lb(Hb),b(Error("Parent folder must be writeable.")));if(!c||"."==c||".."==c)Lb(2),b(Error("Name must not be empty."));a.d.hasOwnProperty(c)&&(Lb(17),b(Error("Can't overwrite object.")));a.d[c]={H:e===f?j:e,write:g===f?n:g,timestamp:Date.now(),R:Qb++};for(var h in d)d.hasOwnProperty(h)&&(a.d[c][h]=d[h]);return a.d[c]}
function Yb(a,c,d,e){return Xb(a,c,{g:j,f:n,d:{}},d,e)}function Zb(a,c,d,e){a=Vb(a);a===l&&b(Error("Invalid parent."));for(c=c.split("/").reverse();c.length;){var g=c.pop();g&&(a.d.hasOwnProperty(g)||Yb(a,g,d,e),a=a.d[g])}return a}function $b(a,c,d,e,g){d.g=n;return Xb(a,c,d,e,g)}function ac(a,c,d,e,g){if("string"===typeof d){for(var h=Array(d.length),i=0,k=d.length;i<k;++i)h[i]=d.charCodeAt(i);d=h}d={f:n,d:d.subarray?d.subarray(0):d};return $b(a,c,d,e,g)}
function bc(a,c,d,e){!d&&!e&&b(Error("A device must have at least one callback defined."));return $b(a,c,{f:j,input:d,h:e},Boolean(d),Boolean(e))}function Wb(){Ub||(Ub={H:j,write:j,g:j,f:n,timestamp:Date.now(),R:1,d:{}})}var cc,Ub;function dc(a,c,d){a=v[a];if(!a)return-1;a.sender(Za.subarray(c,c+d));return d}
function ec(a,c,d,e){a=v[a];if(!a||a.object.f)return Lb(Gb),-1;if(a.k){if(a.object.g)return Lb(Ib),-1;if(0>d||0>e)return Lb(Jb),-1;for(var g=a.object.d;g.length<e;)g.push(0);for(var h=0;h<d;h++)g[e+h]=Za[c+h|0];a.object.timestamp=Date.now();return h}Lb(Hb);return-1}
function fc(a,c,d){var e=v[a];if(e&&"socket"in e)return dc(a,c,d);if(e){if(e.k){if(0>d)return Lb(Jb),-1;if(e.object.f){if(e.object.h){for(a=0;a<d;a++)try{e.object.h(p[c+a|0])}catch(g){return Lb(Eb),-1}e.object.timestamp=Date.now();return a}Lb(Fb);return-1}c=ec(a,c,d,e.position);-1!=c&&(e.position+=c);return c}Lb(Hb);return-1}Lb(Gb);return-1}function gc(a,c,d,e){d*=c;if(0==d)return 0;a=fc(e,a,d);return-1==a?(v[e]&&(v[e].error=j),0):Math.floor(a/c)}Module._strlen=hc;
function ic(a){return 0>a||0===a&&-Infinity===1/a}
function jc(a,c){function d(a){var d;"double"===a?d=Sa[c+g>>3]:"i64"==a?(d=[q[c+g>>2],q[c+(g+8)>>2]],g+=8):(a="i32",d=q[c+g>>2]);g+=Math.max(Math.max(na(a),oa),8);return d}for(var e=a,g=0,h=[],i,k;;){var r=e;i=p[e];if(0===i)break;k=p[e+1|0];if(37==i){var H=n,$=n,N=n,E=n;a:for(;;){switch(k){case 43:H=j;break;case 45:$=j;break;case 35:N=j;break;case 48:if(E)break a;else{E=j;break}default:break a}e++;k=p[e+1|0]}var la=0;if(42==k)la=d("i32"),e++,k=p[e+1|0];else for(;48<=k&&57>=k;)la=10*la+(k-48),e++,
k=p[e+1|0];var Da=n;if(46==k){var u=0,Da=j;e++;k=p[e+1|0];if(42==k)u=d("i32"),e++;else for(;;){k=p[e+1|0];if(48>k||57<k)break;u=10*u+(k-48);e++}k=p[e+1|0]}else u=6;var y;switch(String.fromCharCode(k)){case "h":k=p[e+2|0];104==k?(e++,y=1):y=2;break;case "l":k=p[e+2|0];108==k?(e++,y=8):y=4;break;case "L":case "q":case "j":y=8;break;case "z":case "t":case "I":y=4;break;default:y=l}y&&e++;k=p[e+1|0];switch(String.fromCharCode(k)){case "d":case "i":case "u":case "o":case "x":case "X":case "p":r=100==k||
105==k;y=y||4;var va=i=d("i"+8*y),m;8==y&&(i=117==k?+(i[0]>>>0)+4294967296*+(i[1]>>>0):+(i[0]>>>0)+4294967296*+(i[1]|0));4>=y&&(i=(r?nb:mb)(i&Math.pow(256,y)-1,8*y));var pa=Math.abs(i),r="";if(100==k||105==k)m=8==y&&kc?kc.stringify(va[0],va[1],l):nb(i,8*y).toString(10);else if(117==k)m=8==y&&kc?kc.stringify(va[0],va[1],j):mb(i,8*y).toString(10),i=Math.abs(i);else if(111==k)m=(N?"0":"")+pa.toString(8);else if(120==k||88==k){r=N&&0!=i?"0x":"";if(8==y&&kc)if(va[1]){m=(va[1]>>>0).toString(16);for(N=(va[0]>>>
0).toString(16);8>N.length;)N="0"+N;m+=N}else m=(va[0]>>>0).toString(16);else if(0>i){i=-i;m=(pa-1).toString(16);va=[];for(N=0;N<m.length;N++)va.push((15-parseInt(m[N],16)).toString(16));for(m=va.join("");m.length<2*y;)m="f"+m}else m=pa.toString(16);88==k&&(r=r.toUpperCase(),m=m.toUpperCase())}else 112==k&&(0===pa?m="(nil)":(r="0x",m=pa.toString(16)));if(Da)for(;m.length<u;)m="0"+m;for(H&&(r=0>i?"-"+r:"+"+r);r.length+m.length<la;)$?m+=" ":E?m="0"+m:r=" "+r;m=r+m;m.split("").forEach(function(a){h.push(a.charCodeAt(0))});
break;case "f":case "F":case "e":case "E":case "g":case "G":i=d("double");if(isNaN(i))m="nan",E=n;else if(isFinite(i)){Da=n;y=Math.min(u,20);if(103==k||71==k)Da=j,u=u||1,y=parseInt(i.toExponential(y).split("e")[1],10),u>y&&-4<=y?(k=(103==k?"f":"F").charCodeAt(0),u-=y+1):(k=(103==k?"e":"E").charCodeAt(0),u--),y=Math.min(u,20);if(101==k||69==k)m=i.toExponential(y),/[eE][-+]\d$/.test(m)&&(m=m.slice(0,-1)+"0"+m.slice(-1));else if(102==k||70==k)m=i.toFixed(y),0===i&&ic(i)&&(m="-"+m);r=m.split("e");if(Da&&
!N)for(;1<r[0].length&&-1!=r[0].indexOf(".")&&("0"==r[0].slice(-1)||"."==r[0].slice(-1));)r[0]=r[0].slice(0,-1);else for(N&&-1==m.indexOf(".")&&(r[0]+=".");u>y++;)r[0]+="0";m=r[0]+(1<r.length?"e"+r[1]:"");69==k&&(m=m.toUpperCase());H&&0<=i&&(m="+"+m)}else m=(0>i?"-":"")+"inf",E=n;for(;m.length<la;)m=$?m+" ":E&&("-"==m[0]||"+"==m[0])?m[0]+"0"+m.slice(1):(E?"0":" ")+m;97>k&&(m=m.toUpperCase());m.split("").forEach(function(a){h.push(a.charCodeAt(0))});break;case "s":E=(H=d("i8*"))?hc(H):6;Da&&(E=Math.min(E,
u));if(!$)for(;E<la--;)h.push(32);if(H)for(N=0;N<E;N++)h.push(Za[H++|0]);else h=h.concat(lb("(null)".substr(0,E),j));if($)for(;E<la--;)h.push(32);break;case "c":for($&&h.push(d("i8"));0<--la;)h.push(32);$||h.push(d("i8"));break;case "n":$=d("i32*");q[$>>2]=h.length;break;case "%":h.push(i);break;default:for(N=r;N<e+2;N++)h.push(p[N])}e+=2}else h.push(i),e+=1}return h}function lc(a,c,d){d=jc(c,d);c=ja();a=gc(Xa(d,"i8",Ua),1,d.length,a);ma(c);return a}function mc(a,c){return lc(q[Nb>>2],a,c)}
var nc=Math.atan2;function oc(a){oc.N||(Ba=Ba+4095>>12<<12,oc.N=j,qa(Aa),oc.M=Aa,Aa=function(){Ea("cannot dynamically allocate, sbrk now has control")});var c=Ba;0!=a&&oc.M(a);return c}function pc(){return q[pc.e>>2]}function qc(){return!!qc.I}
function rc(a){var c=n;try{a==__ZTIi&&(c=j)}catch(d){}try{a==__ZTIj&&(c=j)}catch(e){}try{a==__ZTIl&&(c=j)}catch(g){}try{a==__ZTIm&&(c=j)}catch(h){}try{a==__ZTIx&&(c=j)}catch(i){}try{a==__ZTIy&&(c=j)}catch(k){}try{a==__ZTIf&&(c=j)}catch(r){}try{a==__ZTId&&(c=j)}catch(H){}try{a==__ZTIe&&(c=j)}catch($){}try{a==__ZTIc&&(c=j)}catch(N){}try{a==__ZTIa&&(c=j)}catch(E){}try{a==__ZTIh&&(c=j)}catch(la){}try{a==__ZTIs&&(c=j)}catch(Da){}try{a==__ZTIt&&(c=j)}catch(u){}return c}
function sc(a,c,d){if(0==d)return n;if(0==c||c==a)return j;switch(rc(c)?c:q[q[c>>2]-8>>2]){case 0:return 0==q[q[a>>2]-8>>2]?sc(q[a+8>>2],q[c+8>>2],d):n;case 1:return n;case 2:return sc(a,q[c+8>>2],d);default:return n}}
function tc(a,c,d){if(!tc.Q){try{q[__ZTVN10__cxxabiv119__pointer_type_infoE>>2]=0}catch(e){}try{q[t>>2]=1}catch(g){}try{q[s>>2]=2}catch(h){}tc.Q=j}q[pc.e>>2]=a;q[pc.e+4>>2]=c;q[pc.e+8>>2]=d;"uncaught_exception"in qc?qc.I++:qc.I=1;b(a+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.")}var uc=n,vc=n,wc=n,xc=n,yc=f,zc=f,Ac=[];
function Bc(){var a=Module.canvas;Ac.forEach(function(c){c(a.width,a.height)})}function Cc(){var a=Module.canvas;this.Y=a.width;this.X=a.height;a.width=screen.width;a.height=screen.height;a=ab[SDL.screen+0*oa>>2];q[SDL.screen+0*oa>>2]=a|8388608;Bc()}function Dc(){var a=Module.canvas;a.width=this.Y;a.height=this.X;a=ab[SDL.screen+0*oa>>2];q[SDL.screen+0*oa>>2]=a&-8388609;Bc()}var Ec,Fc,Gc,Hc;
hb.unshift({p:function(){if(!Module.noFSInit&&!cc){var a,c,d,e=function(a){a===l||10===a?(c.l(c.buffer.join("")),c.buffer=[]):c.buffer.push(k.G(a))};qa(!cc,"FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");cc=j;Wb();a=a||Module.stdin;c=c||Module.stdout;d=d||Module.stderr;var g=j,h=j,i=j;a||(g=n,a=function(){if(!a.n||!a.n.length){var c;"undefined"!=typeof window&&"function"==
typeof window.prompt?(c=window.prompt("Input: "),c===l&&(c=String.fromCharCode(0))):"function"==typeof readline&&(c=readline());c||(c="");a.n=lb(c+"\n",j)}return a.n.shift()});var k=new wa;c||(h=n,c=e);c.l||(c.l=Module.print);c.buffer||(c.buffer=[]);d||(i=n,d=e);d.l||(d.l=Module.print);d.buffer||(d.buffer=[]);try{Yb("/","tmp",j,j)}catch(r){}var e=Yb("/","dev",j,j),H=bc(e,"stdin",a),$=bc(e,"stdout",l,c);d=bc(e,"stderr",l,d);bc(e,"tty",a,c);bc(e,"null",aa(),aa());v[1]={path:"/dev/stdin",object:H,position:0,
A:j,k:n,z:n,B:!g,error:n,u:n,J:[]};v[2]={path:"/dev/stdout",object:$,position:0,A:n,k:j,z:n,B:!h,error:n,u:n,J:[]};v[3]={path:"/dev/stderr",object:d,position:0,A:n,k:j,z:n,B:!i,error:n,u:n,J:[]};q[Mb>>2]=1;q[Nb>>2]=2;q[Ob>>2]=3;Zb("/","dev/shm/tmp",j,j);for(g=v.length;g<Math.max(Mb,Nb,Ob)+4;g++)v[g]=l;v[Mb]=v[1];v[Nb]=v[2];v[Ob]=v[3];Xa([Xa([0,0,0,0,Mb,0,0,0,Nb,0,0,0,Ob,0,0,0],"void*",0)],"void*",Wa,Pb)}}});ib.push({p:function(){Rb=n}});
jb.push({p:function(){cc&&(v[2]&&0<v[2].object.h.buffer.length&&v[2].object.h(10),v[3]&&0<v[3].object.h.buffer.length&&v[3].object.h(10))}});Module.FS_createFolder=Yb;Module.FS_createPath=Zb;Module.FS_createDataFile=ac;
Module.FS_createPreloadedFile=function(a,c,d,e,g,h,i,k){function r(){wc=document.pointerLockElement===E||document.mozPointerLockElement===E||document.webkitPointerLockElement===E}function H(a){return{jpg:"image/jpeg",jpeg:"image/jpeg",png:"image/png",bmp:"image/bmp",ogg:"audio/ogg",wav:"audio/wav",mp3:"audio/mpeg"}[a.substr(a.lastIndexOf(".")+1)]}function $(d){function m(d){k||ac(a,c,d,e,g);h&&h();tb("cp "+la)}var r=n;Module.preloadPlugins.forEach(function(a){!r&&a.canHandle(la)&&(a.handle(d,la,m,
function(){i&&i();tb("cp "+la)}),r=j)});r||m(d)}Module.preloadPlugins||(Module.preloadPlugins=[]);if(!Ec&&!ea){Ec=j;try{new Blob,Fc=j}catch(N){Fc=n,console.log("warning: no blob constructor, cannot create blobs with mimetypes")}Gc="undefined"!=typeof MozBlobBuilder?MozBlobBuilder:"undefined"!=typeof WebKitBlobBuilder?WebKitBlobBuilder:!Fc?console.log("warning: no BlobBuilder"):l;Hc="undefined"!=typeof window?window.URL?window.URL:window.webkitURL:console.log("warning: cannot create object URLs");
Module.preloadPlugins.push({canHandle:function(a){return!Module.ba&&/\.(jpg|jpeg|png|bmp)$/.exec(a)},handle:function(a,c,d,e){var g=l;if(Fc)try{g=new Blob([a],{type:H(c)})}catch(h){var i="Blob constructor present but fails: "+h+"; falling back to blob builder";ua||(ua={});ua[i]||(ua[i]=1,Module.i(i))}g||(g=new Gc,g.append((new Uint8Array(a)).buffer),g=g.getBlob());var k=Hc.createObjectURL(g),m=new Image;m.onload=function(){qa(m.complete,"Image "+c+" could not be decoded");var e=document.createElement("canvas");
e.width=m.width;e.height=m.height;e.getContext("2d").drawImage(m,0,0);Module.preloadedImages[c]=e;Hc.revokeObjectURL(k);d&&d(a)};m.onerror=function(){console.log("Image "+k+" could not be decoded");e&&e()};m.src=k}});Module.preloadPlugins.push({canHandle:function(a){return!Module.aa&&a.substr(-4)in{".ogg":1,".wav":1,".mp3":1}},handle:function(a,c,d,e){function g(e){i||(i=j,Module.preloadedAudios[c]=e,d&&d(a))}function h(){i||(i=j,Module.preloadedAudios[c]=new Audio,e&&e())}var i=n;if(Fc){try{var k=
new Blob([a],{type:H(c)})}catch(m){return h()}var k=Hc.createObjectURL(k),r=new Audio;r.addEventListener("canplaythrough",function(){g(r)},n);r.onerror=function(){if(!i){console.log("warning: browser could not fully decode audio "+c+", trying slower base64 approach");for(var d="",e=0,h=0,k=0;k<a.length;k++){e=e<<8|a[k];for(h+=8;6<=h;)var m=e>>h-6&63,h=h-6,d=d+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"[m]}2==h?(d+="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"[(e&
3)<<4],d+="=="):4==h&&(d+="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"[(e&15)<<2],d+="=");r.src="data:audio/x-"+c.substr(-3)+";base64,"+d;g(r)}};r.src=k;setTimeout(function(){Ha||g(r)},1E4)}else return h()}});var E=Module.canvas;E.r=E.requestPointerLock||E.mozRequestPointerLock||E.webkitRequestPointerLock;E.v=document.exitPointerLock||document.mozExitPointerLock||document.webkitExitPointerLock||aa();E.v=E.v.bind(document);document.addEventListener("pointerlockchange",r,n);document.addEventListener("mozpointerlockchange",
r,n);document.addEventListener("webkitpointerlockchange",r,n);Module.elementPointerLock&&E.addEventListener("click",function(a){!wc&&E.r&&(E.r(),a.preventDefault())},n)}for(var la,Da=[a,c],u=Da[0],y=1;y<Da.length;y++)"/"!=u[u.length-1]&&(u+="/"),u+=Da[y];"/"==u[0]&&(u=u.substr(1));la=u;sb("cp "+la);if("string"==typeof d){var va=i,m=function(){va?va():b('Loading data file "'+d+'" failed.')},pa=new XMLHttpRequest;pa.open("GET",d,j);pa.responseType="arraybuffer";pa.onload=function(){if(200==pa.status||
0==pa.status&&pa.response){var a=pa.response;qa(a,'Loading data file "'+d+'" failed (no arrayBuffer).');a=new Uint8Array(a);$(a);tb("al "+d)}else m()};pa.onerror=m;pa.send(l);sb("al "+d)}else $(d)};
Module.FS_createLazyFile=function(a,c,d,e,g){if("undefined"!==typeof XMLHttpRequest){ea||b("Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc");var h=function(){this.q=n;this.j=[]};h.prototype.get=function(a){if(!(a>this.length-1||0>a)){var c=a%this.O;return this.P(Math.floor(a/this.O))[c]}};h.prototype.W=function(a){this.P=a};h.prototype.s=function(){var a=new XMLHttpRequest;a.open("HEAD",d,n);a.send(l);200<=a.status&&300>a.status||
304===a.status||b(Error("Couldn't load "+d+". Status: "+a.status));var c=Number(a.getResponseHeader("Content-length")),e,g=1048576;if(!((e=a.getResponseHeader("Accept-Ranges"))&&"bytes"===e))g=c;var h=this;h.W(function(a){var e=a*g,i=(a+1)*g-1,i=Math.min(i,c-1);if("undefined"===typeof h.j[a]){var r=h.j;e>i&&b(Error("invalid range ("+e+", "+i+") or no bytes requested!"));i>c-1&&b(Error("only "+c+" bytes available! programmer error!"));var u=new XMLHttpRequest;u.open("GET",d,n);c!==g&&u.setRequestHeader("Range",
"bytes="+e+"-"+i);"undefined"!=typeof Uint8Array&&(u.responseType="arraybuffer");u.overrideMimeType&&u.overrideMimeType("text/plain; charset=x-user-defined");u.send(l);200<=u.status&&300>u.status||304===u.status||b(Error("Couldn't load "+d+". Status: "+u.status));e=u.response!==f?new Uint8Array(u.response||[]):lb(u.responseText||"",j);r[a]=e}"undefined"===typeof h.j[a]&&b(Error("doXHR failed!"));return h.j[a]});this.L=c;this.K=g;this.q=j};h=new h;Object.defineProperty(h,"length",{get:function(){this.q||
this.s();return this.L}});Object.defineProperty(h,"chunkSize",{get:function(){this.q||this.s();return this.K}});h={f:n,d:h}}else h={f:n,url:d};return $b(a,c,h,e,g)};Module.FS_createLink=function(a,c,d,e,g){return $b(a,c,{f:n,link:d},e,g)};Module.FS_createDevice=bc;Kb=ya(4);q[Kb>>2]=0;pc.e=Xa(12,"void*",Va);
Module.requestFullScreen=function(a,c){function d(){vc=n;(document.webkitFullScreenElement||document.webkitFullscreenElement||document.mozFullScreenElement||document.mozFullscreenElement||document.fullScreenElement||document.fullscreenElement)===e?(e.t=document.cancelFullScreen||document.mozCancelFullScreen||document.webkitCancelFullScreen,e.t=e.t.bind(document),yc&&e.r(),vc=j,zc&&Cc()):zc&&Dc();if(Module.onFullScreen)Module.onFullScreen(vc)}yc=a;zc=c;"undefined"===typeof yc&&(yc=j);"undefined"===
typeof zc&&(zc=n);var e=Module.canvas;xc||(xc=j,document.addEventListener("fullscreenchange",d,n),document.addEventListener("mozfullscreenchange",d,n),document.addEventListener("webkitfullscreenchange",d,n));e.V=e.requestFullScreen||e.mozRequestFullScreen||(e.webkitRequestFullScreen?function(){e.webkitRequestFullScreen(Element.ALLOW_KEYBOARD_INPUT)}:l);e.V()};
Module.requestAnimationFrame=function(a){window.requestAnimationFrame||(window.requestAnimationFrame=window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame||window.setTimeout);window.requestAnimationFrame(a)};Module.pauseMainLoop=aa();Module.resumeMainLoop=function(){uc&&(uc=n,l())};Module.getUserMedia=function(){window.w||(window.w=navigator.getUserMedia||navigator.mozGetUserMedia);window.w(f)};
cb=ka=Fa(za);db=cb+5242880;eb=Ba=Fa(db);qa(eb<Ca);var Ic=Math.min;
var x=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.__ZTVN10__cxxabiv120__si_class_type_infoE|0;var n=env.__ZTVN10__cxxabiv117__class_type_infoE|0;var o=+env.NaN;var p=+env.Infinity;var q=0;var r=0;var s=0;var t=0;var u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0.0;var D=0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=0;var N=global.Math.floor;var O=global.Math.abs;var P=global.Math.sqrt;var Q=global.Math.pow;var R=global.Math.cos;var S=global.Math.sin;var T=global.Math.tan;var U=global.Math.acos;var V=global.Math.asin;var W=global.Math.atan;var X=global.Math.atan2;var Y=global.Math.exp;var Z=global.Math.log;var _=global.Math.ceil;var $=global.Math.imul;var aa=env.abort;var ab=env.assert;var ac=env.asmPrintInt;var ad=env.asmPrintFloat;var ae=env.min;var af=env.jsCall;var ag=env.invoke_viiiii;var ah=env.invoke_vif;var ai=env.invoke_viifii;var aj=env.invoke_vi;var ak=env.invoke_vii;var al=env.invoke_ii;var am=env.invoke_viifi;var an=env.invoke_if;var ao=env.invoke_iiiii;var ap=env.invoke_viffif;var aq=env.invoke_iiii;var ar=env.invoke_fif;var as=env.invoke_viff;var at=env.invoke_viiiiiiif;var au=env.invoke_vifff;var av=env.invoke_viiiiii;var aw=env.invoke_iiif;var ax=env.invoke_iif;var ay=env.invoke_vifii;var az=env.invoke_fi;var aA=env.invoke_iii;var aB=env.invoke_fiiiif;var aC=env.invoke_i;var aD=env.invoke_iiiiii;var aE=env.invoke_ifff;var aF=env.invoke_iff;var aG=env.invoke_viii;var aH=env.invoke_v;var aI=env.invoke_viif;var aJ=env.invoke_viiii;var aK=env._llvm_va_end;var aL=env._cosf;var aM=env._floorf;var aN=env.___cxa_throw;var aO=env._abort;var aP=env._fprintf;var aQ=env._llvm_eh_exception;var aR=env._printf;var aS=env._sqrtf;var aT=env.__ZNK12b2WheelJoint13GetDefinitionEP15b2WheelJointDef;var aU=env.___setErrNo;var aV=env._fwrite;var aW=env._send;var aX=env._write;var aY=env._exit;var aZ=env._llvm_lifetime_end;var a_=env.___cxa_find_matching_catch;var a$=env._atan2f;var a0=env._sysconf;var a1=env.___cxa_pure_virtual;var a2=env._vprintf;var a3=env.___cxa_is_number_type;var a4=env.__reallyNegative;var a5=env.___resumeException;var a6=env.__formatString;var a7=env.___cxa_does_inherit;var a8=env.__ZSt9terminatev;var a9=env._sinf;var ba=env.___assert_func;var bb=env.__ZSt18uncaught_exceptionv;var bc=env._pwrite;var bd=env.___cxa_call_unexpected;var be=env._sbrk;var bf=env.___cxa_allocate_exception;var bg=env.___errno_location;var bh=env.___gxx_personality_v0;var bi=env._llvm_lifetime_start;var bj=env._time;var bk=env.__exit;
function bP(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+7>>3<<3;return b|0}function bQ(){return i|0}function bR(a){a=a|0;i=a}function bS(a,b){a=a|0;b=b|0;if((q|0)==0){q=a;r=b}}function bT(b){b=b|0;a[k]=a[b];a[k+1|0]=a[b+1|0];a[k+2|0]=a[b+2|0];a[k+3|0]=a[b+3|0]}function bU(b){b=b|0;a[k]=a[b];a[k+1|0]=a[b+1|0];a[k+2|0]=a[b+2|0];a[k+3|0]=a[b+3|0];a[k+4|0]=a[b+4|0];a[k+5|0]=a[b+5|0];a[k+6|0]=a[b+6|0];a[k+7|0]=a[b+7|0]}function bV(a){a=a|0;D=a}function bW(a){a=a|0;E=a}function bX(a){a=a|0;F=a}function bY(a){a=a|0;G=a}function bZ(a){a=a|0;H=a}function b_(a){a=a|0;I=a}function b$(a){a=a|0;J=a}function b0(a){a=a|0;K=a}function b1(a){a=a|0;L=a}function b2(a){a=a|0;M=a}function b3(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0;c[a>>2]=-1;b=a+12|0;c[b>>2]=16;c[a+8>>2]=0;d=vh(576)|0;e=a+4|0;c[e>>2]=d;vq(d|0,0,(c[b>>2]|0)*36&-1|0);d=(c[b>>2]|0)-1|0;if((d|0)>0){f=0;while(1){g=f+1|0;c[(c[e>>2]|0)+(f*36&-1)+20>>2]=g;c[(c[e>>2]|0)+(f*36&-1)+32>>2]=-1;h=(c[b>>2]|0)-1|0;if((g|0)<(h|0)){f=g}else{i=h;break}}}else{i=d}c[(c[e>>2]|0)+(i*36&-1)+20>>2]=-1;c[(c[e>>2]|0)+(((c[b>>2]|0)-1|0)*36&-1)+32>>2]=-1;vq(a+16|0,0,16);c[a+48>>2]=16;c[a+52>>2]=0;c[a+44>>2]=vh(192)|0;c[a+36>>2]=16;c[a+40>>2]=0;c[a+32>>2]=vh(64)|0;return}function b4(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0.0,k=0,l=0,m=0,n=0,o=0;e=a|0;f=cj(e)|0;h=a+4|0;i=(c[h>>2]|0)+(f*36&-1)|0;j=+(+g[b+4>>2]+-.10000000149011612);g[i>>2]=+g[b>>2]+-.10000000149011612;g[i+4>>2]=j;i=(c[h>>2]|0)+(f*36&-1)+8|0;j=+(+g[b+12>>2]+.10000000149011612);g[i>>2]=+g[b+8>>2]+.10000000149011612;g[i+4>>2]=j;c[(c[h>>2]|0)+(f*36&-1)+16>>2]=d;c[(c[h>>2]|0)+(f*36&-1)+32>>2]=0;ck(e,f);e=a+28|0;c[e>>2]=(c[e>>2]|0)+1;e=a+40|0;h=c[e>>2]|0;d=a+36|0;i=a+32|0;if((h|0)!=(c[d>>2]|0)){k=h;l=c[i>>2]|0;m=l+(k<<2)|0;c[m>>2]=f;n=c[e>>2]|0;o=n+1|0;c[e>>2]=o;return f|0}a=c[i>>2]|0;c[d>>2]=h<<1;d=vh(h<<3)|0;c[i>>2]=d;h=a;a=c[e>>2]<<2;vp(d|0,h|0,a)|0;vi(h);k=c[e>>2]|0;l=c[i>>2]|0;m=l+(k<<2)|0;c[m>>2]=f;n=c[e>>2]|0;o=n+1|0;c[e>>2]=o;return f|0}function b5(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0;h=a+60|0;c[h>>2]=0;i=e+12|0;j=+g[f+12>>2];l=+g[i>>2];m=+g[f+8>>2];n=+g[e+16>>2];o=+g[f>>2]+(j*l-m*n)- +g[d>>2];p=l*m+j*n+ +g[f+4>>2]- +g[d+4>>2];n=+g[d+12>>2];j=+g[d+8>>2];m=o*n+p*j;l=n*p+o*(-0.0-j);j=+g[b+8>>2]+ +g[e+8>>2];e=c[b+148>>2]|0;do{if((e|0)>0){d=0;o=-3.4028234663852886e+38;f=0;while(1){p=(m- +g[b+20+(d<<3)>>2])*+g[b+84+(d<<3)>>2]+(l- +g[b+20+(d<<3)+4>>2])*+g[b+84+(d<<3)+4>>2];if(p>j){q=28;break}r=p>o;s=r?p:o;t=r?d:f;r=d+1|0;if((r|0)<(e|0)){d=r;o=s;f=t}else{q=12;break}}if((q|0)==12){u=s<1.1920928955078125e-7;v=t;break}else if((q|0)==28){return}}else{u=1;v=0}}while(0);q=v+1|0;t=b+20+(v<<3)|0;f=c[t>>2]|0;d=c[t+4>>2]|0;s=(c[k>>2]=f,+g[k>>2]);t=d;o=(c[k>>2]=t,+g[k>>2]);r=b+20+(((q|0)<(e|0)?q:0)<<3)|0;q=c[r>>2]|0;e=c[r+4>>2]|0;p=(c[k>>2]=q,+g[k>>2]);r=e;n=(c[k>>2]=r,+g[k>>2]);if(u){c[h>>2]=1;c[a+56>>2]=1;u=b+84+(v<<3)|0;w=a+40|0;x=c[u+4>>2]|0;c[w>>2]=c[u>>2];c[w+4>>2]=x;x=a+48|0;y=+((o+n)*.5);g[x>>2]=(s+p)*.5;g[x+4>>2]=y;x=i;w=a;u=c[x+4>>2]|0;c[w>>2]=c[x>>2];c[w+4>>2]=u;c[a+16>>2]=0;return}y=m-s;z=l-o;A=m-p;B=l-n;if(y*(p-s)+z*(n-o)<=0.0){if(y*y+z*z>j*j){return}c[h>>2]=1;c[a+56>>2]=1;u=a+40|0;w=u;C=+z;g[w>>2]=y;g[w+4>>2]=C;C=+P(+(y*y+z*z));if(C>=1.1920928955078125e-7){D=1.0/C;g[u>>2]=y*D;g[a+44>>2]=z*D}u=a+48|0;c[u>>2]=f&-1;c[u+4>>2]=t|d&0;d=i;t=a;u=c[d+4>>2]|0;c[t>>2]=c[d>>2];c[t+4>>2]=u;c[a+16>>2]=0;return}if(A*(s-p)+B*(o-n)>0.0){D=(s+p)*.5;p=(o+n)*.5;u=b+84+(v<<3)|0;if((m-D)*+g[u>>2]+(l-p)*+g[b+84+(v<<3)+4>>2]>j){return}c[h>>2]=1;c[a+56>>2]=1;v=u;u=a+40|0;b=c[v+4>>2]|0;c[u>>2]=c[v>>2];c[u+4>>2]=b;b=a+48|0;l=+p;g[b>>2]=D;g[b+4>>2]=l;b=i;u=a;v=c[b+4>>2]|0;c[u>>2]=c[b>>2];c[u+4>>2]=v;c[a+16>>2]=0;return}if(A*A+B*B>j*j){return}c[h>>2]=1;c[a+56>>2]=1;h=a+40|0;v=h;j=+B;g[v>>2]=A;g[v+4>>2]=j;j=+P(+(A*A+B*B));if(j>=1.1920928955078125e-7){l=1.0/j;g[h>>2]=A*l;g[a+44>>2]=B*l}h=a+48|0;c[h>>2]=q&-1;c[h+4>>2]=r|e&0;e=i;i=a;r=c[e+4>>2]|0;c[i>>2]=c[e>>2];c[i+4>>2]=r;c[a+16>>2]=0;return}function b6(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0;i=b+60|0;c[i>>2]=0;j=f+12|0;l=+g[h+12>>2];m=+g[j>>2];n=+g[h+8>>2];o=+g[f+16>>2];p=+g[h>>2]+(l*m-n*o)- +g[e>>2];q=m*n+l*o+ +g[h+4>>2]- +g[e+4>>2];o=+g[e+12>>2];l=+g[e+8>>2];n=p*o+q*l;m=o*q+p*(-0.0-l);e=d+12|0;h=c[e>>2]|0;r=c[e+4>>2]|0;l=(c[k>>2]=h,+g[k>>2]);e=r;p=(c[k>>2]=e,+g[k>>2]);s=d+20|0;t=c[s>>2]|0;u=c[s+4>>2]|0;q=(c[k>>2]=t,+g[k>>2]);s=u;o=(c[k>>2]=s,+g[k>>2]);v=q-l;w=o-p;x=v*(q-n)+w*(o-m);y=n-l;z=m-p;A=y*v+z*w;B=+g[d+8>>2]+ +g[f+8>>2];if(A<=0.0){if(y*y+z*z>B*B){return}do{if((a[d+44|0]&1)!=0){f=d+28|0;if((l-n)*(l- +g[f>>2])+(p-m)*(p- +g[f+4>>2])<=0.0){break}return}}while(0);c[i>>2]=1;c[b+56>>2]=0;g[b+40>>2]=0.0;g[b+44>>2]=0.0;f=b+48|0;c[f>>2]=h&-1;c[f+4>>2]=e|r&0;f=b+16|0;c[f>>2]=0;C=f;a[f]=0;a[C+1|0]=0;a[C+2|0]=0;a[C+3|0]=0;C=j;f=b;D=c[C+4>>2]|0;c[f>>2]=c[C>>2];c[f+4>>2]=D;return}if(x<=0.0){E=n-q;F=m-o;if(E*E+F*F>B*B){return}do{if((a[d+45|0]&1)!=0){D=d+36|0;if(E*(+g[D>>2]-q)+F*(+g[D+4>>2]-o)<=0.0){break}return}}while(0);c[i>>2]=1;c[b+56>>2]=0;g[b+40>>2]=0.0;g[b+44>>2]=0.0;d=b+48|0;c[d>>2]=t&-1;c[d+4>>2]=s|u&0;u=b+16|0;c[u>>2]=0;s=u;a[u]=1;a[s+1|0]=0;a[s+2|0]=0;a[s+3|0]=0;s=j;u=b;d=c[s+4>>2]|0;c[u>>2]=c[s>>2];c[u+4>>2]=d;return}F=v*v+w*w;if(F<=0.0){ba(12984,127,18976,12968)}E=1.0/F;F=n-(l*x+q*A)*E;q=m-(p*x+o*A)*E;if(F*F+q*q>B*B){return}B=-0.0-w;if(v*z+y*B<0.0){G=w;H=-0.0-v}else{G=B;H=v}v=+P(+(H*H+G*G));if(v<1.1920928955078125e-7){I=G;J=H}else{B=1.0/v;I=G*B;J=H*B}c[i>>2]=1;c[b+56>>2]=1;i=b+40|0;B=+J;g[i>>2]=I;g[i+4>>2]=B;i=b+48|0;c[i>>2]=h&-1;c[i+4>>2]=e|r&0;r=b+16|0;c[r>>2]=0;e=r;a[r]=0;a[e+1|0]=0;a[e+2|0]=1;a[e+3|0]=0;e=j;j=b;b=c[e+4>>2]|0;c[j>>2]=c[e>>2];c[j+4>>2]=b;return}function b7(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,Q=0,R=0,S=0,T=0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0,ac=0.0,ad=0.0,ae=0,af=0.0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0.0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0.0,aG=0.0,aH=0.0,aI=0.0,aJ=0,aK=0,aL=0,aM=0,aN=0,aO=0,aP=0,aQ=0,aR=0,aS=0,aT=0,aU=0.0,aV=0,aW=0,aX=0.0;l=i;i=i+40|0;m=l|0;n=l+16|0;o=n|0;p=n;q=i;i=i+24|0;r=i;i=i+24|0;s=r|0;t=r;u=b+132|0;v=+g[f+12>>2];w=+g[j+8>>2];x=+g[f+8>>2];y=+g[j+12>>2];z=v*w-x*y;A=w*x+v*y;y=+z;w=+A;B=+g[j>>2]- +g[f>>2];C=+g[j+4>>2]- +g[f+4>>2];D=v*B+x*C;E=B*(-0.0-x)+v*C;C=+E;f=u;g[f>>2]=D;g[f+4>>2]=C;f=b+140|0;g[f>>2]=y;g[f+4>>2]=w;f=b+144|0;w=+g[h+12>>2];j=b+140|0;y=+g[h+16>>2];F=u|0;C=D+(A*w-z*y);u=b+136|0;D=w*z+A*y+E;G=b+148|0;E=+D;g[G>>2]=C;g[G+4>>2]=E;G=e+28|0;H=b+156|0;I=c[G>>2]|0;J=c[G+4>>2]|0;c[H>>2]=I;c[H+4>>2]=J;H=e+12|0;G=b+164|0;K=c[H>>2]|0;L=c[H+4>>2]|0;c[G>>2]=K;c[G+4>>2]=L;H=e+20|0;M=b+172|0;N=c[H>>2]|0;O=c[H+4>>2]|0;c[M>>2]=N;c[M+4>>2]=O;H=e+36|0;Q=b+180|0;R=c[H>>2]|0;S=c[H+4>>2]|0;c[Q>>2]=R;c[Q+4>>2]=S;Q=a[e+44|0]&1;H=Q<<24>>24!=0;T=a[e+45|0]|0;e=(T&1)!=0;E=(c[k>>2]=N,+g[k>>2]);y=(c[k>>2]=K,+g[k>>2]);A=E-y;z=(c[k>>2]=O,+g[k>>2]);O=b+168|0;w=(c[k>>2]=L,+g[k>>2]);v=z-w;x=+P(+(A*A+v*v));B=(c[k>>2]=I,+g[k>>2]);U=(c[k>>2]=J,+g[k>>2]);V=(c[k>>2]=R,+g[k>>2]);W=(c[k>>2]=S,+g[k>>2]);if(x<1.1920928955078125e-7){X=A;Y=v}else{Z=1.0/x;X=A*Z;Y=v*Z}S=b+196|0;Z=-0.0-X;R=S|0;g[R>>2]=Y;J=b+200|0;g[J>>2]=Z;v=(C-y)*Y+(D-w)*Z;if(H){Z=y-B;y=w-U;w=+P(+(Z*Z+y*y));if(w<1.1920928955078125e-7){_=Z;$=y}else{A=1.0/w;_=Z*A;$=y*A}A=-0.0-_;g[b+188>>2]=$;g[b+192>>2]=A;aa=(C-B)*$+(D-U)*A;ab=Y*_-X*$>=0.0}else{aa=0.0;ab=0}L93:do{if(e){$=V-E;_=W-z;A=+P(+($*$+_*_));if(A<1.1920928955078125e-7){ac=$;ad=_}else{U=1.0/A;ac=$*U;ad=_*U}U=-0.0-ac;I=b+204|0;g[I>>2]=ad;L=b+208|0;g[L>>2]=U;K=X*ad-Y*ac>0.0;_=(C-E)*ad+(D-z)*U;if((Q&T)<<24>>24==0){ae=K;af=_;ag=100;break}if(ab&K){do{if(aa<0.0&v<0.0){N=_>=0.0;a[b+248|0]=N&1;ah=b+212|0;if(N){ai=ah;break}N=ah;U=+(-0.0-Y);$=+X;g[N>>2]=U;g[N+4>>2]=$;N=b+228|0;g[N>>2]=U;g[N+4>>2]=$;N=b+236|0;g[N>>2]=U;g[N+4>>2]=$;break L93}else{a[b+248|0]=1;ai=b+212|0}}while(0);N=S;ah=ai;aj=c[N+4>>2]|0;c[ah>>2]=c[N>>2];c[ah+4>>2]=aj;aj=b+188|0;ah=b+228|0;N=c[aj+4>>2]|0;c[ah>>2]=c[aj>>2];c[ah+4>>2]=N;N=b+204|0;ah=b+236|0;aj=c[N+4>>2]|0;c[ah>>2]=c[N>>2];c[ah+4>>2]=aj;break}if(ab){do{if(aa<0.0){if(v<0.0){a[b+248|0]=0;ak=b+212|0}else{aj=_>=0.0;a[b+248|0]=aj&1;ah=b+212|0;if(aj){al=ah;break}else{ak=ah}}ah=ak;$=+X;g[ah>>2]=-0.0-Y;g[ah+4>>2]=$;ah=b+228|0;$=+(-0.0- +g[L>>2]);g[ah>>2]=-0.0- +g[I>>2];g[ah+4>>2]=$;ah=b+236|0;$=+(-0.0- +g[J>>2]);g[ah>>2]=-0.0- +g[R>>2];g[ah+4>>2]=$;break L93}else{a[b+248|0]=1;al=b+212|0}}while(0);ah=S;aj=al;N=c[ah+4>>2]|0;c[aj>>2]=c[ah>>2];c[aj+4>>2]=N;N=b+188|0;aj=b+228|0;am=c[N+4>>2]|0;c[aj>>2]=c[N>>2];c[aj+4>>2]=am;am=b+236|0;aj=c[ah+4>>2]|0;c[am>>2]=c[ah>>2];c[am+4>>2]=aj;break}if(!K){do{if(aa<0.0|v<0.0){a[b+248|0]=0;an=b+212|0}else{aj=_>=0.0;a[b+248|0]=aj&1;am=b+212|0;if(!aj){an=am;break}aj=S;ah=am;am=c[aj>>2]|0;N=c[aj+4>>2]|0;c[ah>>2]=am;c[ah+4>>2]=N;ah=b+228|0;c[ah>>2]=am;c[ah+4>>2]=N;ah=b+236|0;c[ah>>2]=am;c[ah+4>>2]=N;break L93}}while(0);K=an;$=+X;g[K>>2]=-0.0-Y;g[K+4>>2]=$;K=b+228|0;$=+(-0.0- +g[L>>2]);g[K>>2]=-0.0- +g[I>>2];g[K+4>>2]=$;K=b+236|0;$=+(-0.0- +g[b+192>>2]);g[K>>2]=-0.0- +g[b+188>>2];g[K+4>>2]=$;break}do{if(_<0.0){if(aa<0.0){a[b+248|0]=0;ao=b+212|0}else{K=v>=0.0;a[b+248|0]=K&1;N=b+212|0;if(K){ap=N;break}else{ao=N}}N=ao;$=+X;g[N>>2]=-0.0-Y;g[N+4>>2]=$;N=b+228|0;$=+(-0.0- +g[J>>2]);g[N>>2]=-0.0- +g[R>>2];g[N+4>>2]=$;N=b+236|0;$=+(-0.0- +g[b+192>>2]);g[N>>2]=-0.0- +g[b+188>>2];g[N+4>>2]=$;break L93}else{a[b+248|0]=1;ap=b+212|0}}while(0);I=S;L=ap;N=c[I+4>>2]|0;c[L>>2]=c[I>>2];c[L+4>>2]=N;N=b+228|0;L=c[I+4>>2]|0;c[N>>2]=c[I>>2];c[N+4>>2]=L;L=b+204|0;N=b+236|0;I=c[L+4>>2]|0;c[N>>2]=c[L>>2];c[N+4>>2]=I}else{ae=0;af=0.0;ag=100}}while(0);L134:do{if((ag|0)==100){if(H){ap=aa>=0.0;if(ab){do{if(ap){a[b+248|0]=1;aq=b+212|0}else{ao=v>=0.0;a[b+248|0]=ao&1;an=b+212|0;if(ao){aq=an;break}ao=an;an=0;z=+X;c[ao>>2]=an|(g[k>>2]=-0.0-Y,c[k>>2]|0);g[ao+4>>2]=z;ao=S;al=b+228|0;ak=c[ao>>2]|0;ai=c[ao+4>>2]|0;c[al>>2]=ak;c[al+4>>2]=ai;ai=b+236|0;c[ai>>2]=an|(g[k>>2]=-0.0-(c[k>>2]=ak,+g[k>>2]),c[k>>2]|0);g[ai+4>>2]=z;break L134}}while(0);ai=S;ak=aq;an=c[ai+4>>2]|0;c[ak>>2]=c[ai>>2];c[ak+4>>2]=an;an=b+188|0;ak=b+228|0;ai=c[an+4>>2]|0;c[ak>>2]=c[an>>2];c[ak+4>>2]=ai;ai=b+236|0;z=+(-0.0- +g[J>>2]);g[ai>>2]=-0.0- +g[R>>2];g[ai+4>>2]=z;break}else{do{if(ap){ai=v>=0.0;a[b+248|0]=ai&1;ak=b+212|0;if(!ai){ar=ak;break}ai=S;an=ak;ak=c[ai>>2]|0;al=c[ai+4>>2]|0;c[an>>2]=ak;c[an+4>>2]=al;an=b+228|0;c[an>>2]=ak;c[an+4>>2]=al;al=b+236|0;z=+X;g[al>>2]=-0.0-(c[k>>2]=ak,+g[k>>2]);g[al+4>>2]=z;break L134}else{a[b+248|0]=0;ar=b+212|0}}while(0);ap=ar;z=+X;g[ap>>2]=-0.0-Y;g[ap+4>>2]=z;ap=S;al=b+228|0;ak=c[ap+4>>2]|0;c[al>>2]=c[ap>>2];c[al+4>>2]=ak;ak=b+236|0;z=+(-0.0- +g[b+192>>2]);g[ak>>2]=-0.0- +g[b+188>>2];g[ak+4>>2]=z;break}}ak=v>=0.0;if(!e){a[b+248|0]=ak&1;al=b+212|0;if(ak){ap=S;an=al;ai=c[ap>>2]|0;ao=c[ap+4>>2]|0;c[an>>2]=ai;c[an+4>>2]=ao;ao=b+228|0;z=+(-0.0-(c[k>>2]=ai,+g[k>>2]));D=+X;g[ao>>2]=z;g[ao+4>>2]=D;ao=b+236|0;g[ao>>2]=z;g[ao+4>>2]=D;break}else{ao=al;D=+X;g[ao>>2]=-0.0-Y;g[ao+4>>2]=D;ao=S;al=b+228|0;ai=c[ao>>2]|0;an=c[ao+4>>2]|0;c[al>>2]=ai;c[al+4>>2]=an;al=b+236|0;c[al>>2]=ai;c[al+4>>2]=an;break}}if(ae){do{if(ak){a[b+248|0]=1;as=b+212|0}else{an=af>=0.0;a[b+248|0]=an&1;al=b+212|0;if(an){as=al;break}an=al;D=+(-0.0-Y);z=+X;g[an>>2]=D;g[an+4>>2]=z;an=b+228|0;g[an>>2]=D;g[an+4>>2]=z;an=S;al=b+236|0;ai=c[an+4>>2]|0;c[al>>2]=c[an>>2];c[al+4>>2]=ai;break L134}}while(0);ai=S;al=as;an=c[ai+4>>2]|0;c[al>>2]=c[ai>>2];c[al+4>>2]=an;an=b+228|0;z=+(-0.0- +g[J>>2]);g[an>>2]=-0.0- +g[R>>2];g[an+4>>2]=z;an=b+204|0;al=b+236|0;ai=c[an+4>>2]|0;c[al>>2]=c[an>>2];c[al+4>>2]=ai;break}else{do{if(ak){ai=af>=0.0;a[b+248|0]=ai&1;al=b+212|0;if(!ai){at=al;break}ai=S;an=al;al=c[ai>>2]|0;ao=c[ai+4>>2]|0;c[an>>2]=al;c[an+4>>2]=ao;an=b+228|0;z=+X;g[an>>2]=-0.0-(c[k>>2]=al,+g[k>>2]);g[an+4>>2]=z;an=b+236|0;c[an>>2]=al;c[an+4>>2]=ao;break L134}else{a[b+248|0]=0;at=b+212|0}}while(0);ak=at;z=+X;g[ak>>2]=-0.0-Y;g[ak+4>>2]=z;ak=b+228|0;z=+(-0.0- +g[b+208>>2]);g[ak>>2]=-0.0- +g[b+204>>2];g[ak+4>>2]=z;ak=S;ao=b+236|0;an=c[ak+4>>2]|0;c[ao>>2]=c[ak>>2];c[ao+4>>2]=an;break}}}while(0);at=h+148|0;as=b+128|0;c[as>>2]=c[at>>2];if((c[at>>2]|0)>0){ae=0;do{Y=+g[f>>2];X=+g[h+20+(ae<<3)>>2];af=+g[j>>2];v=+g[h+20+(ae<<3)+4>>2];e=b+(ae<<3)|0;aa=+(X*af+Y*v+ +g[u>>2]);g[e>>2]=+g[F>>2]+(Y*X-af*v);g[e+4>>2]=aa;aa=+g[f>>2];v=+g[h+84+(ae<<3)>>2];af=+g[j>>2];X=+g[h+84+(ae<<3)+4>>2];e=b+64+(ae<<3)|0;Y=+(v*af+aa*X);g[e>>2]=aa*v-af*X;g[e+4>>2]=Y;ae=ae+1|0;}while((ae|0)<(c[at>>2]|0))}at=b+244|0;g[at>>2]=.019999999552965164;ae=d+60|0;c[ae>>2]=0;e=b+248|0;ar=c[as>>2]|0;if((ar|0)>0){Y=+g[b+164>>2];X=+g[O>>2];af=+g[b+212>>2];v=+g[b+216>>2];O=0;aa=3.4028234663852886e+38;while(1){z=af*(+g[b+(O<<3)>>2]-Y)+v*(+g[b+(O<<3)+4>>2]-X);D=z<aa?z:aa;aq=O+1|0;if((aq|0)<(ar|0)){O=aq;aa=D}else{au=D;break}}}else{au=3.4028234663852886e+38}if(au>+g[at>>2]){i=l;return}b8(m,b);O=c[m>>2]|0;do{if((O|0)==0){ag=136}else{aa=+g[m+8>>2];if(aa>+g[at>>2]){i=l;return}if(aa<=au*.9800000190734863+.0010000000474974513){ag=136;break}ar=c[m+4>>2]|0;aq=n;ab=d+56|0;if((O|0)==1){av=aq;aw=ab;ag=138;break}c[ab>>2]=2;ab=c[G>>2]|0;H=c[G+4>>2]|0;c[o>>2]=ab;c[o+4>>2]=H;an=n+8|0;ao=an;a[an]=0;an=ar&255;a[ao+1|0]=an;a[ao+2|0]=0;a[ao+3|0]=1;ao=p+12|0;ak=c[M>>2]|0;al=c[M+4>>2]|0;c[ao>>2]=ak;c[ao+4>>2]=al;ao=p+20|0;ai=ao;a[ao]=0;a[ai+1|0]=an;a[ai+2|0]=0;a[ai+3|0]=1;ai=ar+1|0;ao=(ai|0)<(c[as>>2]|0)?ai:0;ai=b+(ar<<3)|0;ap=b+(ao<<3)|0;T=b+64+(ar<<3)|0;ax=ar;ay=ao&255;az=c[T>>2]|0;aA=c[T+4>>2]|0;aB=c[ap>>2]|0;aC=c[ap+4>>2]|0;aD=c[ai>>2]|0;aE=c[ai+4>>2]|0;aF=(c[k>>2]=ak,+g[k>>2]);aG=(c[k>>2]=ab,+g[k>>2]);aH=(c[k>>2]=al,+g[k>>2]);aI=(c[k>>2]=H,+g[k>>2]);aJ=an;aK=0;aL=aq}}while(0);if((ag|0)==136){av=n;aw=d+56|0;ag=138}do{if((ag|0)==138){c[aw>>2]=1;O=c[as>>2]|0;if((O|0)>1){au=+g[b+216>>2];aa=+g[b+212>>2];m=0;X=aa*+g[b+64>>2]+au*+g[b+68>>2];aq=1;while(1){v=aa*+g[b+64+(aq<<3)>>2]+au*+g[b+64+(aq<<3)+4>>2];an=v<X;H=an?aq:m;al=aq+1|0;if((al|0)<(O|0)){m=H;X=an?v:X;aq=al}else{aM=H;break}}}else{aM=0}aq=aM+1|0;m=(aq|0)<(O|0)?aq:0;aq=b+(aM<<3)|0;H=c[aq>>2]|0;al=c[aq+4>>2]|0;c[o>>2]=H;c[o+4>>2]=al;aq=n+8|0;an=aq;a[aq]=0;aq=aM&255;a[an+1|0]=aq;a[an+2|0]=1;a[an+3|0]=0;an=b+(m<<3)|0;ab=p+12|0;ak=c[an>>2]|0;ai=c[an+4>>2]|0;c[ab>>2]=ak;c[ab+4>>2]=ai;ab=p+20|0;an=ab;a[ab]=0;a[an+1|0]=m&255;a[an+2|0]=1;a[an+3|0]=0;X=(c[k>>2]=H,+g[k>>2]);au=(c[k>>2]=al,+g[k>>2]);aa=(c[k>>2]=ak,+g[k>>2]);v=(c[k>>2]=ai,+g[k>>2]);if((a[e]&1)==0){ax=1;ay=0;az=(g[k>>2]=-0.0- +g[R>>2],c[k>>2]|0);aA=(g[k>>2]=-0.0- +g[J>>2],c[k>>2]|0);aB=c[G>>2]|0;aC=c[G+4>>2]|0;aD=c[M>>2]|0;aE=c[M+4>>2]|0;aF=aa;aG=X;aH=v;aI=au;aJ=aq;aK=1;aL=av;break}else{ai=S;ax=0;ay=1;az=c[ai>>2]|0;aA=c[ai+4>>2]|0;aB=c[M>>2]|0;aC=c[M+4>>2]|0;aD=c[G>>2]|0;aE=c[G+4>>2]|0;aF=aa;aG=X;aH=v;aI=au;aJ=aq;aK=1;aL=av;break}}}while(0);au=(c[k>>2]=az,+g[k>>2]);v=(c[k>>2]=aA,+g[k>>2]);X=(c[k>>2]=aD,+g[k>>2]);aa=(c[k>>2]=aE,+g[k>>2]);Y=-0.0-au;af=X*v+aa*Y;D=-0.0-v;z=(c[k>>2]=aB,+g[k>>2])*D+(c[k>>2]=aC,+g[k>>2])*au;ad=v*aG+aI*Y-af;E=v*aF+aH*Y-af;if(ad>0.0){aN=0}else{aC=q;aB=n;c[aC>>2]=c[aB>>2];c[aC+4>>2]=c[aB+4>>2];c[aC+8>>2]=c[aB+8>>2];aN=1}if(E>0.0){aO=aN}else{aB=q+(aN*12&-1)|0;aC=aL+12|0;c[aB>>2]=c[aC>>2];c[aB+4>>2]=c[aC+4>>2];c[aB+8>>2]=c[aC+8>>2];aO=aN+1|0}if(ad*E<0.0){af=ad/(ad-E);aN=q+(aO*12&-1)|0;E=+(aI+af*(aH-aI));g[aN>>2]=aG+af*(aF-aG);g[aN+4>>2]=E;aN=q+(aO*12&-1)+8|0;aC=aN;a[aN]=ax&255;a[aC+1|0]=aJ;a[aC+2|0]=0;a[aC+3|0]=1;aP=aO+1|0}else{aP=aO}if((aP|0)<2){i=l;return}E=+g[q>>2];aG=+g[q+4>>2];aF=E*D+au*aG-z;aP=q+12|0;af=+g[aP>>2];aI=+g[q+16>>2];aH=af*D+au*aI-z;if(aF>0.0){aQ=0}else{aO=r;aC=q;c[aO>>2]=c[aC>>2];c[aO+4>>2]=c[aC+4>>2];c[aO+8>>2]=c[aC+8>>2];aQ=1}if(aH>0.0){aR=aQ}else{aC=t+(aQ*12&-1)|0;aO=aP;c[aC>>2]=c[aO>>2];c[aC+4>>2]=c[aO+4>>2];c[aC+8>>2]=c[aO+8>>2];aR=aQ+1|0}if(aF*aH<0.0){z=aF/(aF-aH);aQ=t+(aR*12&-1)|0;aH=+(aG+z*(aI-aG));g[aQ>>2]=E+z*(af-E);g[aQ+4>>2]=aH;aQ=t+(aR*12&-1)+8|0;aO=aQ;a[aQ]=ay;a[aO+1|0]=a[q+9|0]|0;a[aO+2|0]=0;a[aO+3|0]=1;aS=aR+1|0}else{aS=aR}if((aS|0)<2){i=l;return}aS=d+40|0;do{if(aK){aR=aS;c[aR>>2]=az;c[aR+4>>2]=aA;aR=d+48|0;c[aR>>2]=aD;c[aR+4>>2]=aE;aH=+g[r>>2];E=+g[t+4>>2];af=+g[at>>2];if(au*(aH-X)+v*(E-aa)>af){aT=0;aU=af}else{af=aH- +g[F>>2];aH=E- +g[u>>2];E=+g[f>>2];z=+g[j>>2];aR=d;aG=+(E*aH+af*(-0.0-z));g[aR>>2]=af*E+aH*z;g[aR+4>>2]=aG;c[d+16>>2]=c[r+8>>2];aT=1;aU=+g[at>>2]}aG=+g[t+12>>2];z=+g[r+16>>2];if(au*(aG-X)+v*(z-aa)>aU){aV=aT;break}aH=aG- +g[F>>2];aG=z- +g[u>>2];z=+g[f>>2];E=+g[j>>2];aR=d+(aT*20&-1)|0;af=+(z*aG+aH*(-0.0-E));g[aR>>2]=aH*z+aG*E;g[aR+4>>2]=af;c[d+(aT*20&-1)+16>>2]=c[t+20>>2];aV=aT+1|0}else{aR=h+84+(ax<<3)|0;aO=aS;q=c[aR+4>>2]|0;c[aO>>2]=c[aR>>2];c[aO+4>>2]=q;q=h+20+(ax<<3)|0;aO=d+48|0;aR=c[q+4>>2]|0;c[aO>>2]=c[q>>2];c[aO+4>>2]=aR;af=+g[at>>2];if(au*(+g[r>>2]-X)+v*(+g[t+4>>2]-aa)>af){aW=0;aX=af}else{aR=d;aO=c[s+4>>2]|0;c[aR>>2]=c[s>>2];c[aR+4>>2]=aO;aO=r+8|0;aR=aO;q=d+16|0;ay=q;a[ay+2|0]=a[aR+3|0]|0;a[ay+3|0]=a[aR+2|0]|0;a[q]=a[aR+1|0]|0;a[ay+1|0]=a[aO]|0;aW=1;aX=+g[at>>2]}aO=t+12|0;if(au*(+g[aO>>2]-X)+v*(+g[r+16>>2]-aa)>aX){aV=aW;break}ay=aO;aO=d+(aW*20&-1)|0;aR=c[ay+4>>2]|0;c[aO>>2]=c[ay>>2];c[aO+4>>2]=aR;aR=t+20|0;aO=aR;ay=d+(aW*20&-1)+16|0;q=ay;a[q+2|0]=a[aO+3|0]|0;a[q+3|0]=a[aO+2|0]|0;a[ay]=a[aO+1|0]|0;a[q+1|0]=a[aR]|0;aV=aW+1|0}}while(0);c[ae>>2]=aV;i=l;return}function b8(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0.0,E=0;d=a|0;c[d>>2]=0;e=a+4|0;c[e>>2]=-1;f=a+8|0;g[f>>2]=-3.4028234663852886e+38;h=+g[b+216>>2];i=+g[b+212>>2];a=c[b+128>>2]|0;if((a|0)<=0){return}j=+g[b+164>>2];k=+g[b+168>>2];l=+g[b+172>>2];m=+g[b+176>>2];n=+g[b+244>>2];o=b+228|0;p=b+232|0;q=b+236|0;r=b+240|0;s=0;t=-3.4028234663852886e+38;while(1){u=+g[b+64+(s<<3)>>2];v=-0.0-u;w=-0.0- +g[b+64+(s<<3)+4>>2];x=+g[b+(s<<3)>>2];y=+g[b+(s<<3)+4>>2];z=(x-j)*v+(y-k)*w;A=(x-l)*v+(y-m)*w;B=z<A?z:A;if(B>n){break}if(h*u+i*w<0.0){if((v- +g[o>>2])*i+(w- +g[p>>2])*h>=-.03490658849477768&B>t){C=182}else{D=t}}else{if((v- +g[q>>2])*i+(w- +g[r>>2])*h>=-.03490658849477768&B>t){C=182}else{D=t}}if((C|0)==182){C=0;c[d>>2]=2;c[e>>2]=s;g[f>>2]=B;D=B}E=s+1|0;if((E|0)<(a|0)){s=E;t=D}else{C=186;break}}if((C|0)==186){return}c[d>>2]=2;c[e>>2]=s;g[f>>2]=B;return}function b9(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0,A=0.0,B=0;h=c[b+148>>2]|0;i=+g[f+12>>2];j=+g[e+12>>2];k=+g[f+8>>2];l=+g[e+16>>2];m=+g[d+12>>2];n=+g[b+12>>2];o=+g[d+8>>2];p=+g[b+16>>2];q=+g[f>>2]+(i*j-k*l)-(+g[d>>2]+(m*n-o*p));r=j*k+i*l+ +g[f+4>>2]-(n*o+m*p+ +g[d+4>>2]);p=m*q+o*r;n=m*r+q*(-0.0-o);if((h|0)>0){s=0;o=-3.4028234663852886e+38;t=0;while(1){q=p*+g[b+84+(s<<3)>>2]+n*+g[b+84+(s<<3)+4>>2];u=q>o;v=u?s:t;w=s+1|0;if((w|0)<(h|0)){s=w;o=u?q:o;t=v}else{x=v;break}}}else{x=0}o=+cb(b,d,x,e,f);t=((x|0)>0?x:h)-1|0;n=+cb(b,d,t,e,f);s=x+1|0;v=(s|0)<(h|0)?s:0;p=+cb(b,d,v,e,f);if(n>o&n>p){q=n;s=t;while(1){t=((s|0)>0?s:h)-1|0;n=+cb(b,d,t,e,f);if(n>q){q=n;s=t}else{y=q;z=s;break}}c[a>>2]=z;return+y}if(p>o){A=p;B=v}else{y=o;z=x;c[a>>2]=z;return+y}while(1){x=B+1|0;v=(x|0)<(h|0)?x:0;o=+cb(b,d,v,e,f);if(o>A){A=o;B=v}else{y=A;z=B;break}}c[a>>2]=z;return+y}function ca(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0,B=0,C=0,D=0,E=0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0,O=0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0;j=i;i=i+40|0;k=j|0;l=j+8|0;m=j+16|0;n=m|0;o=i;i=i+24|0;p=i;i=i+24|0;q=b+60|0;c[q>>2]=0;r=+g[d+8>>2]+ +g[f+8>>2];c[k>>2]=0;s=+b9(k,d,e,f,h);if(s>r){i=j;return}c[l>>2]=0;t=+b9(l,f,h,d,e);if(t>r){i=j;return}if(t>s*.9800000190734863+.0010000000474974513){s=+g[h>>2];t=+g[h+4>>2];u=+g[h+8>>2];v=+g[h+12>>2];w=+g[e>>2];x=+g[e+4>>2];y=+g[e+8>>2];z=+g[e+12>>2];A=c[l>>2]|0;c[b+56>>2]=2;B=f;C=d;D=A;E=1;F=w;G=x;H=y;I=z;J=s;K=t;L=u;M=v}else{v=+g[e>>2];u=+g[e+4>>2];t=+g[e+8>>2];s=+g[e+12>>2];z=+g[h>>2];y=+g[h+4>>2];x=+g[h+8>>2];w=+g[h+12>>2];h=c[k>>2]|0;c[b+56>>2]=1;B=d;C=f;D=h;E=0;F=z;G=y;H=x;I=w;J=v;K=u;L=t;M=s}h=m;f=c[C+148>>2]|0;if((D|0)<=-1){ba(10264,151,18656,11704)}d=c[B+148>>2]|0;if((d|0)<=(D|0)){ba(10264,151,18656,11704)}s=+g[B+84+(D<<3)>>2];t=+g[B+84+(D<<3)+4>>2];u=M*s-L*t;v=L*s+M*t;t=I*u+H*v;s=-0.0-H;w=I*v+u*s;if((f|0)>0){k=0;u=3.4028234663852886e+38;e=0;while(1){v=t*+g[C+84+(k<<3)>>2]+w*+g[C+84+(k<<3)+4>>2];A=v<u;l=A?k:e;N=k+1|0;if((N|0)<(f|0)){k=N;u=A?v:u;e=l}else{O=l;break}}}else{O=0}e=O+1|0;k=(e|0)<(f|0)?e:0;u=+g[C+20+(O<<3)>>2];w=+g[C+20+(O<<3)+4>>2];t=F+(I*u-H*w);v=G+(H*u+I*w);w=+v;g[n>>2]=t;g[n+4>>2]=w;n=D&255;e=m+8|0;f=e;a[e]=n;e=O&255;a[f+1|0]=e;a[f+2|0]=1;a[f+3|0]=0;f=h+12|0;w=+g[C+20+(k<<3)>>2];u=+g[C+20+(k<<3)+4>>2];x=F+(I*w-H*u);y=G+(H*w+I*u);C=f;u=+y;g[C>>2]=x;g[C+4>>2]=u;C=h+20|0;h=C;a[C]=n;a[h+1|0]=k&255;a[h+2|0]=1;a[h+3|0]=0;h=D+1|0;k=(h|0)<(d|0)?h:0;h=B+20+(D<<3)|0;u=+g[h>>2];w=+g[h+4>>2];h=B+20+(k<<3)|0;z=+g[h>>2];Q=+g[h+4>>2];R=z-u;S=Q-w;T=+P(+(R*R+S*S));if(T<1.1920928955078125e-7){U=R;V=S}else{W=1.0/T;U=R*W;V=S*W}W=M*U-L*V;S=M*V+L*U;R=W*-1.0;T=J+(M*u-L*w);X=K+(L*u+M*w);Y=T*S+X*R;Z=r-(T*W+X*S);X=r+((J+(M*z-L*Q))*W+(K+(L*z+M*Q))*S);M=-0.0-W;L=-0.0-S;K=t*M+v*L-Z;J=x*M+y*L-Z;if(K>0.0){_=0}else{h=o;B=m;c[h>>2]=c[B>>2];c[h+4>>2]=c[B+4>>2];c[h+8>>2]=c[B+8>>2];_=1}if(J>0.0){$=_}else{B=o+(_*12&-1)|0;h=f;c[B>>2]=c[h>>2];c[B+4>>2]=c[h+4>>2];c[B+8>>2]=c[h+8>>2];$=_+1|0}if(K*J<0.0){Z=K/(K-J);_=o+($*12&-1)|0;J=+(v+Z*(y-v));g[_>>2]=t+Z*(x-t);g[_+4>>2]=J;_=o+($*12&-1)+8|0;h=_;a[_]=n;a[h+1|0]=e;a[h+2|0]=0;a[h+3|0]=1;aa=$+1|0}else{aa=$}if((aa|0)<2){i=j;return}J=+g[o>>2];t=+g[o+4>>2];x=W*J+S*t-X;aa=o+12|0;Z=+g[aa>>2];v=+g[o+16>>2];y=W*Z+S*v-X;if(x>0.0){ab=0}else{$=p;h=o;c[$>>2]=c[h>>2];c[$+4>>2]=c[h+4>>2];c[$+8>>2]=c[h+8>>2];ab=1}if(y>0.0){ac=ab}else{h=p+(ab*12&-1)|0;$=aa;c[h>>2]=c[$>>2];c[h+4>>2]=c[$+4>>2];c[h+8>>2]=c[$+8>>2];ac=ab+1|0}if(x*y<0.0){X=x/(x-y);ab=p+(ac*12&-1)|0;y=+(t+X*(v-t));g[ab>>2]=J+X*(Z-J);g[ab+4>>2]=y;ab=p+(ac*12&-1)+8|0;$=ab;a[ab]=k&255;a[$+1|0]=a[o+9|0]|0;a[$+2|0]=0;a[$+3|0]=1;ad=ac+1|0}else{ad=ac}if((ad|0)<2){i=j;return}ad=b+40|0;y=+(U*-1.0);g[ad>>2]=V;g[ad+4>>2]=y;ad=b+48|0;y=+((w+Q)*.5);g[ad>>2]=(u+z)*.5;g[ad+4>>2]=y;y=+g[p>>2];z=+g[p+4>>2];ad=S*y+R*z-Y>r;do{if(E<<24>>24==0){if(ad){ae=0}else{u=y-F;Q=z-G;ac=b;w=+(u*s+I*Q);g[ac>>2]=I*u+H*Q;g[ac+4>>2]=w;c[b+16>>2]=c[p+8>>2];ae=1}w=+g[p+12>>2];Q=+g[p+16>>2];if(S*w+R*Q-Y>r){af=ae;break}u=w-F;w=Q-G;ac=b+(ae*20&-1)|0;Q=+(u*s+I*w);g[ac>>2]=I*u+H*w;g[ac+4>>2]=Q;c[b+(ae*20&-1)+16>>2]=c[p+20>>2];af=ae+1|0}else{if(ad){ag=0}else{Q=y-F;w=z-G;ac=b;u=+(Q*s+I*w);g[ac>>2]=I*Q+H*w;g[ac+4>>2]=u;ac=b+16|0;$=c[p+8>>2]|0;c[ac>>2]=$;o=ac;a[ac]=$>>>8&255;a[o+1|0]=$&255;a[o+2|0]=$>>>24&255;a[o+3|0]=$>>>16&255;ag=1}u=+g[p+12>>2];w=+g[p+16>>2];if(S*u+R*w-Y>r){af=ag;break}Q=u-F;u=w-G;$=b+(ag*20&-1)|0;w=+(Q*s+I*u);g[$>>2]=I*Q+H*u;g[$+4>>2]=w;$=b+(ag*20&-1)+16|0;o=c[p+20>>2]|0;c[$>>2]=o;ac=$;a[$]=o>>>8&255;a[ac+1|0]=o&255;a[ac+2|0]=o>>>24&255;a[ac+3|0]=o>>>16&255;af=ag+1|0}}while(0);c[q>>2]=af;i=j;return}function cb(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0,t=0.0,u=0,v=0,w=0,x=0;h=c[e+148>>2]|0;if((d|0)<=-1){ba(10264,32,18800,11704);return 0.0}if((c[a+148>>2]|0)<=(d|0)){ba(10264,32,18800,11704);return 0.0}i=+g[b+12>>2];j=+g[a+84+(d<<3)>>2];k=+g[b+8>>2];l=+g[a+84+(d<<3)+4>>2];m=i*j-k*l;n=j*k+i*l;l=+g[f+12>>2];j=+g[f+8>>2];o=l*m+j*n;p=l*n+m*(-0.0-j);if((h|0)>0){q=0;r=3.4028234663852886e+38;s=0;while(1){t=o*+g[e+20+(q<<3)>>2]+p*+g[e+20+(q<<3)+4>>2];u=t<r;v=u?q:s;w=q+1|0;if((w|0)<(h|0)){q=w;r=u?t:r;s=v}else{x=v;break}}}else{x=0}r=+g[a+20+(d<<3)>>2];p=+g[a+20+(d<<3)+4>>2];o=+g[e+20+(x<<3)>>2];t=+g[e+20+(x<<3)+4>>2];return+(m*(+g[f>>2]+(l*o-j*t)-(+g[b>>2]+(i*r-k*p)))+n*(o*j+l*t+ +g[f+4>>2]-(r*k+i*p+ +g[b+4>>2])))}function cc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0.0,z=0.0,A=0.0,B=0.0;e=i;i=i+8|0;f=e|0;h=d;j=+g[h>>2];k=+g[d+8>>2]-j;l=+g[d+12>>2]- +g[d+4>>2];m=+g[h+4>>2];if(k>0.0){n=k}else{n=-0.0-k}if(l>0.0){o=l}else{o=-0.0-l}h=a|0;p=a+8|0;a=f;q=f+4|0;do{if(n<1.1920928955078125e-7){if(j<+g[h>>2]){r=0;i=e;return r|0}if(+g[p>>2]<j){r=0}else{s=3.4028234663852886e+38;t=-3.4028234663852886e+38;break}i=e;return r|0}else{u=1.0/k;v=u*(+g[h>>2]-j);w=u*(+g[p>>2]-j);x=v>w;u=x?w:v;y=x?v:w;if(u>-3.4028234663852886e+38){g[q>>2]=0.0;g[a>>2]=x?1.0:-1.0;z=u}else{z=-3.4028234663852886e+38}u=y>3.4028234663852886e+38?3.4028234663852886e+38:y;if(z>u){r=0}else{s=u;t=z;break}i=e;return r|0}}while(0);do{if(o<1.1920928955078125e-7){if(m<+g[h+4>>2]){r=0;i=e;return r|0}if(+g[p+4>>2]<m){r=0}else{A=t;break}i=e;return r|0}else{z=1.0/l;j=z*(+g[h+4>>2]-m);k=z*(+g[p+4>>2]-m);q=j>k;z=q?k:j;n=q?j:k;if(z>t){g[a>>2]=0.0;g[a+4>>2]=q?1.0:-1.0;B=z}else{B=t}if(B>(s<n?s:n)){r=0}else{A=B;break}i=e;return r|0}}while(0);if(A<0.0){r=0;i=e;return r|0}if(+g[d+16>>2]<A){r=0;i=e;return r|0}g[b+8>>2]=A;d=b;b=c[f+4>>2]|0;c[d>>2]=c[f>>2];c[d+4>>2]=b;r=1;i=e;return r|0}function cd(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;h=+h;var i=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0,B=0,C=0,D=0,E=0.0,F=0.0;i=b+60|0;if((c[i>>2]|0)==0){return}j=c[b+56>>2]|0;if((j|0)==0){k=a|0;g[k>>2]=1.0;l=a+4|0;g[l>>2]=0.0;m=+g[d+12>>2];n=+g[b+48>>2];o=+g[d+8>>2];p=+g[b+52>>2];q=+g[d>>2]+(m*n-o*p);r=n*o+m*p+ +g[d+4>>2];p=+g[f+12>>2];m=+g[b>>2];o=+g[f+8>>2];n=+g[b+4>>2];s=+g[f>>2]+(p*m-o*n);t=m*o+p*n+ +g[f+4>>2];n=q-s;p=r-t;do{if(n*n+p*p>1.4210854715202004e-14){o=s-q;m=t-r;u=a;v=+m;g[u>>2]=o;g[u+4>>2]=v;v=+P(+(o*o+m*m));if(v<1.1920928955078125e-7){w=o;x=m;break}y=1.0/v;v=o*y;g[k>>2]=v;o=m*y;g[l>>2]=o;w=v;x=o}else{w=1.0;x=0.0}}while(0);l=a+8|0;p=+((r+x*e+(t-x*h))*.5);g[l>>2]=(q+w*e+(s-w*h))*.5;g[l+4>>2]=p;return}else if((j|0)==1){l=d+12|0;p=+g[l>>2];w=+g[b+40>>2];k=d+8|0;s=+g[k>>2];q=+g[b+44>>2];x=p*w-s*q;t=w*s+p*q;u=a;q=+t;g[u>>2]=x;g[u+4>>2]=q;q=+g[l>>2];p=+g[b+48>>2];s=+g[k>>2];w=+g[b+52>>2];r=+g[d>>2]+(q*p-s*w);n=p*s+q*w+ +g[d+4>>2];if((c[i>>2]|0)<=0){return}k=f+12|0;l=f+8|0;u=f|0;z=f+4|0;A=a|0;B=a+4|0;C=0;w=x;x=t;while(1){t=+g[k>>2];q=+g[b+(C*20&-1)>>2];s=+g[l>>2];p=+g[b+(C*20&-1)+4>>2];o=+g[u>>2]+(t*q-s*p);v=q*s+t*p+ +g[z>>2];p=e-(w*(o-r)+(v-n)*x);D=a+8+(C<<3)|0;t=+((v-x*h+(v+x*p))*.5);g[D>>2]=(o-w*h+(o+w*p))*.5;g[D+4>>2]=t;D=C+1|0;if((D|0)>=(c[i>>2]|0)){break}C=D;w=+g[A>>2];x=+g[B>>2]}return}else if((j|0)==2){j=f+12|0;x=+g[j>>2];w=+g[b+40>>2];B=f+8|0;n=+g[B>>2];r=+g[b+44>>2];t=x*w-n*r;p=w*n+x*r;A=a;r=+p;g[A>>2]=t;g[A+4>>2]=r;r=+g[j>>2];x=+g[b+48>>2];n=+g[B>>2];w=+g[b+52>>2];o=+g[f>>2]+(r*x-n*w);v=x*n+r*w+ +g[f+4>>2];if((c[i>>2]|0)>0){f=d+12|0;B=d+8|0;j=d|0;C=d+4|0;d=a|0;z=a+4|0;u=0;w=t;r=p;while(1){n=+g[f>>2];x=+g[b+(u*20&-1)>>2];s=+g[B>>2];q=+g[b+(u*20&-1)+4>>2];y=+g[j>>2]+(n*x-s*q);m=x*s+n*q+ +g[C>>2];q=h-(w*(y-o)+(m-v)*r);l=a+8+(u<<3)|0;n=+((m-r*e+(m+r*q))*.5);g[l>>2]=(y-w*e+(y+w*q))*.5;g[l+4>>2]=n;l=u+1|0;n=+g[d>>2];q=+g[z>>2];if((l|0)<(c[i>>2]|0)){u=l;w=n;r=q}else{E=n;F=q;break}}}else{E=t;F=p}p=+(-0.0-F);g[A>>2]=-0.0-E;g[A+4>>2]=p;return}else{return}}function ce(a){a=a|0;var b=0,d=0.0,e=0.0,f=0,h=0.0,i=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0;b=a+16|0;d=+g[b>>2];e=+g[b+4>>2];b=a+36|0;f=a+52|0;h=+g[f>>2];i=+g[f+4>>2];f=a+72|0;j=a+88|0;k=+g[j>>2];l=+g[j+4>>2];m=h-d;n=i-e;o=d*m+e*n;p=h*m+i*n;q=k-d;r=l-e;s=d*q+e*r;t=k*q+l*r;u=k-h;v=l-i;w=h*u+i*v;x=k*u+l*v;v=m*r-n*q;q=(h*l-i*k)*v;n=(e*k-d*l)*v;l=(d*i-e*h)*v;if(!(o<-0.0|s<-0.0)){g[a+24>>2]=1.0;c[a+108>>2]=1;return}if(!(o>=-0.0|p<=0.0|l>0.0)){v=1.0/(p-o);g[a+24>>2]=p*v;g[a+60>>2]=v*(-0.0-o);c[a+108>>2]=2;return}if(!(s>=-0.0|t<=0.0|n>0.0)){o=1.0/(t-s);g[a+24>>2]=t*o;g[a+96>>2]=o*(-0.0-s);c[a+108>>2]=2;j=b;y=f;vp(j|0,y|0,36)|0;return}if(!(p>0.0|w<-0.0)){g[a+60>>2]=1.0;c[a+108>>2]=1;y=a;j=b;vp(y|0,j|0,36)|0;return}if(!(t>0.0|x>0.0)){g[a+96>>2]=1.0;c[a+108>>2]=1;j=a;y=f;vp(j|0,y|0,36)|0;return}if(w>=-0.0|x<=0.0|q>0.0){t=1.0/(l+(q+n));g[a+24>>2]=q*t;g[a+60>>2]=n*t;g[a+96>>2]=l*t;c[a+108>>2]=3;return}else{t=1.0/(x-w);g[a+60>>2]=x*t;g[a+96>>2]=t*(-0.0-w);c[a+108>>2]=2;y=a;a=f;vp(y|0,a|0,36)|0;return}}function cf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0;e=c[b+4>>2]|0;if((e|0)==0){c[a+16>>2]=b+12;c[a+20>>2]=1;g[a+24>>2]=+g[b+8>>2];return}else if((e|0)==2){c[a+16>>2]=b+20;c[a+20>>2]=c[b+148>>2];g[a+24>>2]=+g[b+8>>2];return}else if((e|0)==3){if((d|0)<=-1){ba(5304,53,17648,10824)}f=b+16|0;if((c[f>>2]|0)<=(d|0)){ba(5304,53,17648,10824)}h=b+12|0;i=(c[h>>2]|0)+(d<<3)|0;j=a;k=c[i+4>>2]|0;c[j>>2]=c[i>>2];c[j+4>>2]=k;k=d+1|0;d=a+8|0;j=c[h>>2]|0;if((k|0)<(c[f>>2]|0)){f=j+(k<<3)|0;k=d;h=c[f+4>>2]|0;c[k>>2]=c[f>>2];c[k+4>>2]=h}else{h=j;j=d;d=c[h+4>>2]|0;c[j>>2]=c[h>>2];c[j+4>>2]=d}c[a+16>>2]=a;c[a+20>>2]=2;g[a+24>>2]=+g[b+8>>2];return}else if((e|0)==1){c[a+16>>2]=b+12;c[a+20>>2]=2;g[a+24>>2]=+g[b+8>>2];return}else{ba(5304,81,17648,11592)}}function cg(d,e,f){d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0.0,E=0.0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,Q=0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0,Z=0,_=0.0,$=0.0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0.0,aq=0.0,ar=0.0;h=i;i=i+176|0;j=h|0;k=h+16|0;l=h+32|0;m=h+144|0;n=h+160|0;c[1044]=(c[1044]|0)+1;o=j;p=f+56|0;c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];p=k;o=f+72|0;c[p>>2]=c[o>>2];c[p+4>>2]=c[o+4>>2];c[p+8>>2]=c[o+8>>2];c[p+12>>2]=c[o+12>>2];ch(l,e,f|0,j,f+28|0,k);o=l|0;p=l+108|0;q=c[p>>2]|0;if((q|0)==1|(q|0)==2|(q|0)==3){r=l+16|0;s=l+20|0;t=+g[j+12>>2];u=+g[j+8>>2];v=f+16|0;w=f+20|0;x=+g[j>>2];y=+g[j+4>>2];z=+g[k+12>>2];A=+g[k+8>>2];B=-0.0-A;j=f+44|0;C=f+48|0;D=+g[k>>2];E=+g[k+4>>2];k=l+52|0;F=l+56|0;G=l+16|0;H=l+52|0;I=l+24|0;J=l+60|0;K=l;L=l+36|0;M=0;N=q;L460:while(1){O=(N|0)>0;if(O){Q=0;do{c[m+(Q<<2)>>2]=c[o+(Q*36&-1)+28>>2];c[n+(Q<<2)>>2]=c[o+(Q*36&-1)+32>>2];Q=Q+1|0;}while((Q|0)<(N|0))}do{if((N|0)==2){R=+g[G>>2];S=+g[G+4>>2];T=+g[H>>2];U=+g[H+4>>2];V=T-R;W=U-S;X=R*V+S*W;if(X>=-0.0){g[I>>2]=1.0;c[p>>2]=1;Y=356;break}S=T*V+U*W;if(S>0.0){W=1.0/(S-X);g[I>>2]=S*W;g[J>>2]=W*(-0.0-X);c[p>>2]=2;Y=357;break}else{g[J>>2]=1.0;c[p>>2]=1;vp(K|0,L|0,36)|0;Y=356;break}}else if((N|0)==3){ce(l);Q=c[p>>2]|0;if((Q|0)==0){Y=354;break L460}else if((Q|0)==1){Y=356}else if((Q|0)==2){Y=357}else if((Q|0)==3){Z=M;Y=381;break L460}else{Y=355;break L460}}else if((N|0)==1){Y=356}else{Y=352;break L460}}while(0);do{if((Y|0)==356){Y=0;_=-0.0- +g[r>>2];$=-0.0- +g[s>>2];aa=1}else if((Y|0)==357){Y=0;X=+g[r>>2];W=+g[k>>2]-X;S=+g[s>>2];U=+g[F>>2]-S;if(W*(-0.0-S)-U*(-0.0-X)>0.0){_=U*-1.0;$=W;aa=2;break}else{_=U;$=W*-1.0;aa=2;break}}}while(0);if($*$+_*_<1.4210854715202004e-14){Z=M;Y=381;break}Q=o+(aa*36&-1)|0;W=-0.0-$;U=t*(-0.0-_)+u*W;X=t*W+_*u;ab=c[v>>2]|0;ac=c[w>>2]|0;if((ac|0)>1){W=X*+g[ab+4>>2]+U*+g[ab>>2];ad=1;ae=0;while(1){S=U*+g[ab+(ad<<3)>>2]+X*+g[ab+(ad<<3)+4>>2];af=S>W;ag=af?ad:ae;ah=ad+1|0;if((ah|0)<(ac|0)){W=af?S:W;ad=ah;ae=ag}else{break}}ae=o+(aa*36&-1)+28|0;c[ae>>2]=ag;if((ag|0)>-1){ai=ag;aj=ae}else{Y=395;break}}else{ae=o+(aa*36&-1)+28|0;c[ae>>2]=0;ai=0;aj=ae}if((ac|0)<=(ai|0)){Y=396;break}W=+g[ab+(ai<<3)>>2];X=+g[ab+(ai<<3)+4>>2];U=x+(t*W-u*X);ae=Q;S=+(W*u+t*X+y);g[ae>>2]=U;g[ae+4>>2]=S;S=_*z+$*A;X=$*z+_*B;ae=c[j>>2]|0;ad=c[C>>2]|0;if((ad|0)>1){W=X*+g[ae+4>>2]+S*+g[ae>>2];ah=1;af=0;while(1){V=S*+g[ae+(ah<<3)>>2]+X*+g[ae+(ah<<3)+4>>2];ak=V>W;al=ak?ah:af;am=ah+1|0;if((am|0)<(ad|0)){W=ak?V:W;ah=am;af=al}else{break}}af=o+(aa*36&-1)+32|0;c[af>>2]=al;if((al|0)>-1){an=al;ao=af}else{Y=397;break}}else{af=o+(aa*36&-1)+32|0;c[af>>2]=0;an=0;ao=af}if((ad|0)<=(an|0)){Y=398;break}W=+g[ae+(an<<3)>>2];X=+g[ae+(an<<3)+4>>2];S=D+(z*W-A*X);af=o+(aa*36&-1)+8|0;V=+(W*A+z*X+E);g[af>>2]=S;g[af+4>>2]=V;af=o+(aa*36&-1)+16|0;V=+(+g[o+(aa*36&-1)+12>>2]- +g[o+(aa*36&-1)+4>>2]);g[af>>2]=S-U;g[af+4>>2]=V;af=M+1|0;c[1042]=(c[1042]|0)+1;if(O){ah=c[aj>>2]|0;Q=0;do{if((ah|0)==(c[m+(Q<<2)>>2]|0)){if((c[ao>>2]|0)==(c[n+(Q<<2)>>2]|0)){Z=af;Y=381;break L460}}Q=Q+1|0;}while((Q|0)<(N|0))}Q=(c[p>>2]|0)+1|0;c[p>>2]=Q;if((af|0)<20){M=af;N=Q}else{Z=af;Y=381;break}}if((Y|0)==352){ba(5304,498,19160,11592)}else if((Y|0)==354){ba(5304,194,13608,11592)}else if((Y|0)==355){ba(5304,207,13608,11592)}else if((Y|0)==381){N=c[1040]|0;c[1040]=(N|0)>(Z|0)?N:Z;N=d+8|0;ci(l,d|0,N);M=d|0;n=N|0;E=+g[M>>2]- +g[n>>2];ao=d+4|0;m=d+12|0;z=+g[ao>>2]- +g[m>>2];aj=d+16|0;g[aj>>2]=+P(+(E*E+z*z));c[d+20>>2]=Z;Z=c[p>>2]|0;if((Z|0)==0){ba(5304,246,13504,11592)}else if((Z|0)==2){z=+g[r>>2]- +g[k>>2];E=+g[s>>2]- +g[F>>2];ap=+P(+(z*z+E*E))}else if((Z|0)==3){E=+g[r>>2];z=+g[s>>2];ap=(+g[k>>2]-E)*(+g[l+92>>2]-z)-(+g[F>>2]-z)*(+g[l+88>>2]-E)}else if((Z|0)==1){ap=0.0}else{ba(5304,259,13504,11592)}g[e>>2]=ap;b[e+4>>1]=Z&65535;l=0;do{a[l+(e+6)|0]=c[o+(l*36&-1)+28>>2]&255;a[l+(e+9)|0]=c[o+(l*36&-1)+32>>2]&255;l=l+1|0;}while((l|0)<(Z|0));if((a[f+88|0]&1)==0){i=h;return}ap=+g[f+24>>2];E=+g[f+52>>2];z=+g[aj>>2];A=ap+E;if(!(z>A&z>1.1920928955078125e-7)){f=d;D=+((+g[M>>2]+ +g[n>>2])*.5);B=+((+g[ao>>2]+ +g[m>>2])*.5);g[f>>2]=D;g[f+4>>2]=B;f=N;g[f>>2]=D;g[f+4>>2]=B;g[aj>>2]=0.0;i=h;return}g[aj>>2]=z-A;A=+g[n>>2];z=+g[M>>2];B=A-z;D=+g[m>>2];_=+g[ao>>2];$=D-_;y=+P(+(B*B+$*$));if(y<1.1920928955078125e-7){aq=B;ar=$}else{t=1.0/y;aq=B*t;ar=$*t}g[M>>2]=ap*aq+z;g[ao>>2]=ap*ar+_;g[n>>2]=A-E*aq;g[m>>2]=D-E*ar;i=h;return}else if((Y|0)==395){ba(7536,103,13816,6368)}else if((Y|0)==396){ba(7536,103,13816,6368)}else if((Y|0)==397){ba(7536,103,13816,6368)}else if((Y|0)==398){ba(7536,103,13816,6368)}}else if((q|0)==0){ba(5304,194,13608,11592)}else{ba(5304,207,13608,11592)}}function ch(a,e,f,h,i,j){a=a|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0;k=b[e+4>>1]|0;if((k&65535)>=4){ba(5304,102,14776,5808)}l=k&65535;m=a+108|0;c[m>>2]=l;n=a|0;L542:do{if(k<<16>>16==0){o=l}else{p=f+20|0;q=f+16|0;r=i+20|0;s=i+16|0;t=h+12|0;u=h+8|0;v=h|0;w=h+4|0;x=j+12|0;y=j+8|0;z=j|0;A=j+4|0;B=0;while(1){C=d[B+(e+6)|0]|0;c[n+(B*36&-1)+28>>2]=C;D=d[B+(e+9)|0]|0;c[n+(B*36&-1)+32>>2]=D;if((c[p>>2]|0)<=(C|0)){E=407;break}F=(c[q>>2]|0)+(C<<3)|0;G=+g[F>>2];H=+g[F+4>>2];if((c[r>>2]|0)<=(D|0)){E=409;break}F=(c[s>>2]|0)+(D<<3)|0;I=+g[F>>2];J=+g[F+4>>2];K=+g[t>>2];L=+g[u>>2];M=+g[v>>2]+(G*K-H*L);F=n+(B*36&-1)|0;N=+(H*K+G*L+ +g[w>>2]);g[F>>2]=M;g[F+4>>2]=N;N=+g[x>>2];L=+g[y>>2];G=+g[z>>2]+(I*N-J*L);F=n+(B*36&-1)+8|0;K=+(J*N+I*L+ +g[A>>2]);g[F>>2]=G;g[F+4>>2]=K;F=n+(B*36&-1)+16|0;K=+(+g[n+(B*36&-1)+12>>2]- +g[n+(B*36&-1)+4>>2]);g[F>>2]=G-M;g[F+4>>2]=K;g[n+(B*36&-1)+24>>2]=0.0;F=B+1|0;D=c[m>>2]|0;if((F|0)<(D|0)){B=F}else{o=D;break L542}}if((E|0)==407){ba(7536,103,13816,6368)}else if((E|0)==409){ba(7536,103,13816,6368)}}}while(0);do{if((o|0)>1){K=+g[e>>2];if((o|0)==2){M=+g[a+16>>2]- +g[a+52>>2];G=+g[a+20>>2]- +g[a+56>>2];O=+P(+(M*M+G*G))}else if((o|0)==3){G=+g[a+16>>2];M=+g[a+20>>2];O=(+g[a+52>>2]-G)*(+g[a+92>>2]-M)-(+g[a+56>>2]-M)*(+g[a+88>>2]-G)}else{ba(5304,259,13504,11592)}if(O>=K*.5){if(!(K*2.0<O|O<1.1920928955078125e-7)){E=419;break}}c[m>>2]=0}else{E=419}}while(0);do{if((E|0)==419){if((o|0)==0){break}return}}while(0);c[a+28>>2]=0;c[a+32>>2]=0;if((c[f+20>>2]|0)<=0){ba(7536,103,13816,6368)}o=c[f+16>>2]|0;O=+g[o>>2];K=+g[o+4>>2];if((c[i+20>>2]|0)<=0){ba(7536,103,13816,6368)}o=c[i+16>>2]|0;G=+g[o>>2];M=+g[o+4>>2];L=+g[h+12>>2];I=+g[h+8>>2];N=+g[h>>2]+(O*L-K*I);J=K*L+O*I+ +g[h+4>>2];h=a;I=+J;g[h>>2]=N;g[h+4>>2]=I;I=+g[j+12>>2];O=+g[j+8>>2];L=+g[j>>2]+(G*I-M*O);K=M*I+G*O+ +g[j+4>>2];j=a+8|0;O=+K;g[j>>2]=L;g[j+4>>2]=O;j=a+16|0;O=+(K-J);g[j>>2]=L-N;g[j+4>>2]=O;c[m>>2]=1;return}function ci(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;e=c[a+108>>2]|0;if((e|0)==0){ba(5304,217,13544,11592)}else if((e|0)==1){f=a;h=b;i=c[f+4>>2]|0;c[h>>2]=c[f>>2];c[h+4>>2]=i;i=a+8|0;h=d;f=c[i+4>>2]|0;c[h>>2]=c[i>>2];c[h+4>>2]=f;return}else if((e|0)==2){f=a+24|0;j=+g[f>>2];h=a+60|0;k=+g[h>>2];i=b;l=+(j*+g[a+4>>2]+k*+g[a+40>>2]);g[i>>2]=j*+g[a>>2]+k*+g[a+36>>2];g[i+4>>2]=l;l=+g[f>>2];k=+g[h>>2];h=d;j=+(l*+g[a+12>>2]+k*+g[a+48>>2]);g[h>>2]=l*+g[a+8>>2]+k*+g[a+44>>2];g[h+4>>2]=j;return}else if((e|0)==3){j=+g[a+24>>2];k=+g[a+60>>2];l=+g[a+96>>2];e=b;m=+(j*+g[a>>2]+k*+g[a+36>>2]+l*+g[a+72>>2]);n=+(j*+g[a+4>>2]+k*+g[a+40>>2]+l*+g[a+76>>2]);g[e>>2]=m;g[e+4>>2]=n;e=d;g[e>>2]=m;g[e+4>>2]=n;return}else{ba(5304,236,13544,11592)}}function cj(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;b=a+16|0;d=c[b>>2]|0;if((d|0)==-1){e=a+8|0;f=c[e>>2]|0;g=a+12|0;if((f|0)!=(c[g>>2]|0)){ba(11392,61,18232,12440);return 0}h=a+4|0;i=c[h>>2]|0;c[g>>2]=f<<1;j=vh(f*72&-1)|0;c[h>>2]=j;f=i;i=(c[e>>2]|0)*36&-1;vp(j|0,f|0,i)|0;vi(f);f=c[e>>2]|0;i=(c[g>>2]|0)-1|0;if((f|0)<(i|0)){j=f;while(1){f=j+1|0;c[(c[h>>2]|0)+(j*36&-1)+20>>2]=f;c[(c[h>>2]|0)+(j*36&-1)+32>>2]=-1;k=(c[g>>2]|0)-1|0;if((f|0)<(k|0)){j=f}else{l=k;break}}}else{l=i}c[(c[h>>2]|0)+(l*36&-1)+20>>2]=-1;c[(c[h>>2]|0)+(((c[g>>2]|0)-1|0)*36&-1)+32>>2]=-1;g=c[e>>2]|0;c[b>>2]=g;m=g;n=h;o=e}else{m=d;n=a+4|0;o=a+8|0}a=(c[n>>2]|0)+(m*36&-1)+20|0;c[b>>2]=c[a>>2];c[a>>2]=-1;c[(c[n>>2]|0)+(m*36&-1)+24>>2]=-1;c[(c[n>>2]|0)+(m*36&-1)+28>>2]=-1;c[(c[n>>2]|0)+(m*36&-1)+32>>2]=0;c[(c[n>>2]|0)+(m*36&-1)+16>>2]=0;c[o>>2]=(c[o>>2]|0)+1;return m|0}function ck(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0,G=0;d=a+24|0;c[d>>2]=(c[d>>2]|0)+1;d=a|0;e=c[d>>2]|0;if((e|0)==-1){c[d>>2]=b;c[(c[a+4>>2]|0)+(b*36&-1)+20>>2]=-1;return}f=a+4|0;h=c[f>>2]|0;i=+g[h+(b*36&-1)>>2];j=+g[h+(b*36&-1)+4>>2];k=+g[h+(b*36&-1)+8>>2];l=+g[h+(b*36&-1)+12>>2];m=c[h+(e*36&-1)+24>>2]|0;L600:do{if((m|0)==-1){n=e}else{o=e;p=m;while(1){q=c[h+(o*36&-1)+28>>2]|0;r=+g[h+(o*36&-1)+8>>2];s=+g[h+(o*36&-1)>>2];t=+g[h+(o*36&-1)+12>>2];u=+g[h+(o*36&-1)+4>>2];v=((r>k?r:k)-(s<i?s:i)+((t>l?t:l)-(u<j?u:j)))*2.0;w=v*2.0;x=(v-(r-s+(t-u))*2.0)*2.0;u=+g[h+(p*36&-1)>>2];t=i<u?i:u;s=+g[h+(p*36&-1)+4>>2];r=j<s?j:s;v=+g[h+(p*36&-1)+8>>2];y=k>v?k:v;z=+g[h+(p*36&-1)+12>>2];A=l>z?l:z;if((c[h+(p*36&-1)+24>>2]|0)==-1){B=(y-t+(A-r))*2.0}else{B=(y-t+(A-r))*2.0-(v-u+(z-s))*2.0}s=x+B;z=+g[h+(q*36&-1)>>2];u=i<z?i:z;v=+g[h+(q*36&-1)+4>>2];r=j<v?j:v;A=+g[h+(q*36&-1)+8>>2];t=k>A?k:A;y=+g[h+(q*36&-1)+12>>2];C=l>y?l:y;if((c[h+(q*36&-1)+24>>2]|0)==-1){D=(t-u+(C-r))*2.0}else{D=(t-u+(C-r))*2.0-(A-z+(y-v))*2.0}v=x+D;if(w<s&w<v){n=o;break L600}E=s<v?p:q;q=c[h+(E*36&-1)+24>>2]|0;if((q|0)==-1){n=E;break}else{o=E;p=q}}}}while(0);m=c[h+(n*36&-1)+20>>2]|0;h=cj(a)|0;c[(c[f>>2]|0)+(h*36&-1)+20>>2]=m;c[(c[f>>2]|0)+(h*36&-1)+16>>2]=0;e=c[f>>2]|0;D=+g[e+(n*36&-1)>>2];B=+g[e+(n*36&-1)+4>>2];p=e+(h*36&-1)|0;v=+(j<B?j:B);g[p>>2]=i<D?i:D;g[p+4>>2]=v;v=+g[e+(n*36&-1)+8>>2];D=+g[e+(n*36&-1)+12>>2];p=e+(h*36&-1)+8|0;i=+(l>D?l:D);g[p>>2]=k>v?k:v;g[p+4>>2]=i;p=c[f>>2]|0;c[p+(h*36&-1)+32>>2]=(c[p+(n*36&-1)+32>>2]|0)+1;p=c[f>>2]|0;if((m|0)==-1){c[p+(h*36&-1)+24>>2]=n;c[(c[f>>2]|0)+(h*36&-1)+28>>2]=b;c[(c[f>>2]|0)+(n*36&-1)+20>>2]=h;c[(c[f>>2]|0)+(b*36&-1)+20>>2]=h;c[d>>2]=h}else{d=p+(m*36&-1)+24|0;if((c[d>>2]|0)==(n|0)){c[d>>2]=h}else{c[p+(m*36&-1)+28>>2]=h}c[(c[f>>2]|0)+(h*36&-1)+24>>2]=n;c[(c[f>>2]|0)+(h*36&-1)+28>>2]=b;c[(c[f>>2]|0)+(n*36&-1)+20>>2]=h;c[(c[f>>2]|0)+(b*36&-1)+20>>2]=h}h=c[(c[f>>2]|0)+(b*36&-1)+20>>2]|0;if((h|0)==-1){return}else{F=h}while(1){h=co(a,F)|0;b=c[f>>2]|0;n=c[b+(h*36&-1)+24>>2]|0;m=c[b+(h*36&-1)+28>>2]|0;if((n|0)==-1){G=465;break}if((m|0)==-1){G=467;break}p=c[b+(n*36&-1)+32>>2]|0;d=c[b+(m*36&-1)+32>>2]|0;c[b+(h*36&-1)+32>>2]=((p|0)>(d|0)?p:d)+1;d=c[f>>2]|0;i=+g[d+(n*36&-1)>>2];v=+g[d+(m*36&-1)>>2];k=+g[d+(n*36&-1)+4>>2];D=+g[d+(m*36&-1)+4>>2];p=d+(h*36&-1)|0;l=+(k<D?k:D);g[p>>2]=i<v?i:v;g[p+4>>2]=l;l=+g[d+(n*36&-1)+8>>2];v=+g[d+(m*36&-1)+8>>2];i=+g[d+(n*36&-1)+12>>2];D=+g[d+(m*36&-1)+12>>2];m=d+(h*36&-1)+8|0;k=+(i>D?i:D);g[m>>2]=l>v?l:v;g[m+4>>2]=k;m=c[(c[f>>2]|0)+(h*36&-1)+20>>2]|0;if((m|0)==-1){G=472;break}else{F=m}}if((G|0)==465){ba(11392,307,18272,5200)}else if((G|0)==467){ba(11392,308,18272,4936)}else if((G|0)==472){return}}function cl(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;if((b|0)<=-1){ba(11392,126,18192,9904)}d=a+12|0;if((c[d>>2]|0)<=(b|0)){ba(11392,126,18192,9904)}e=a+4|0;if((c[(c[e>>2]|0)+(b*36&-1)+24>>2]|0)!=-1){ba(11392,127,18192,5720)}cm(a,b);if((c[d>>2]|0)<=(b|0)){ba(11392,97,18112,9768)}d=a+8|0;if((c[d>>2]|0)>0){f=a+16|0;c[(c[e>>2]|0)+(b*36&-1)+20>>2]=c[f>>2];c[(c[e>>2]|0)+(b*36&-1)+32>>2]=-1;c[f>>2]=b;c[d>>2]=(c[d>>2]|0)-1;return}else{ba(11392,98,18112,7256)}}function cm(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;d=a|0;if((c[d>>2]|0)==(b|0)){c[d>>2]=-1;return}e=a+4|0;f=c[e>>2]|0;h=c[f+(b*36&-1)+20>>2]|0;i=c[f+(h*36&-1)+20>>2]|0;j=c[f+(h*36&-1)+24>>2]|0;if((j|0)==(b|0)){k=c[f+(h*36&-1)+28>>2]|0}else{k=j}if((i|0)==-1){c[d>>2]=k;c[f+(k*36&-1)+20>>2]=-1;if((h|0)<=-1){ba(11392,97,18112,9768)}if((c[a+12>>2]|0)<=(h|0)){ba(11392,97,18112,9768)}d=a+8|0;if((c[d>>2]|0)<=0){ba(11392,98,18112,7256)}j=a+16|0;c[(c[e>>2]|0)+(h*36&-1)+20>>2]=c[j>>2];c[(c[e>>2]|0)+(h*36&-1)+32>>2]=-1;c[j>>2]=h;c[d>>2]=(c[d>>2]|0)-1;return}d=f+(i*36&-1)+24|0;if((c[d>>2]|0)==(h|0)){c[d>>2]=k}else{c[f+(i*36&-1)+28>>2]=k}c[(c[e>>2]|0)+(k*36&-1)+20>>2]=i;if((h|0)<=-1){ba(11392,97,18112,9768)}if((c[a+12>>2]|0)<=(h|0)){ba(11392,97,18112,9768)}k=a+8|0;if((c[k>>2]|0)<=0){ba(11392,98,18112,7256)}f=a+16|0;c[(c[e>>2]|0)+(h*36&-1)+20>>2]=c[f>>2];c[(c[e>>2]|0)+(h*36&-1)+32>>2]=-1;c[f>>2]=h;c[k>>2]=(c[k>>2]|0)-1;k=i;do{i=co(a,k)|0;h=c[e>>2]|0;f=c[h+(i*36&-1)+24>>2]|0;d=c[h+(i*36&-1)+28>>2]|0;l=+g[h+(f*36&-1)>>2];m=+g[h+(d*36&-1)>>2];n=+g[h+(f*36&-1)+4>>2];o=+g[h+(d*36&-1)+4>>2];j=h+(i*36&-1)|0;p=+(n<o?n:o);g[j>>2]=l<m?l:m;g[j+4>>2]=p;p=+g[h+(f*36&-1)+8>>2];m=+g[h+(d*36&-1)+8>>2];l=+g[h+(f*36&-1)+12>>2];o=+g[h+(d*36&-1)+12>>2];j=h+(i*36&-1)+8|0;n=+(l>o?l:o);g[j>>2]=p>m?p:m;g[j+4>>2]=n;j=c[e>>2]|0;h=c[j+(f*36&-1)+32>>2]|0;f=c[j+(d*36&-1)+32>>2]|0;c[j+(i*36&-1)+32>>2]=((h|0)>(f|0)?h:f)+1;k=c[(c[e>>2]|0)+(i*36&-1)+20>>2]|0;}while((k|0)!=-1);return}function cn(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0;if((b|0)<=-1){ba(11392,135,18040,9904);return 0}if((c[a+12>>2]|0)<=(b|0)){ba(11392,135,18040,9904);return 0}f=a+4|0;h=c[f>>2]|0;if((c[h+(b*36&-1)+24>>2]|0)!=-1){ba(11392,137,18040,5720);return 0}do{if(+g[h+(b*36&-1)>>2]<=+g[d>>2]){if(+g[h+(b*36&-1)+4>>2]>+g[d+4>>2]){break}if(+g[d+8>>2]>+g[h+(b*36&-1)+8>>2]){break}if(+g[d+12>>2]>+g[h+(b*36&-1)+12>>2]){break}else{i=0}return i|0}}while(0);cm(a,b);h=d;j=d+8|0;k=+g[h>>2]+-.10000000149011612;l=+g[h+4>>2]+-.10000000149011612;m=+g[j>>2]+.10000000149011612;n=+g[j+4>>2]+.10000000149011612;o=+g[e>>2]*2.0;p=+g[e+4>>2]*2.0;if(o<0.0){q=m;r=k+o}else{q=o+m;r=k}if(p<0.0){s=n;t=l+p}else{s=p+n;t=l}e=c[f>>2]|0;f=e+(b*36&-1)|0;l=+t;g[f>>2]=r;g[f+4>>2]=l;f=e+(b*36&-1)+8|0;l=+s;g[f>>2]=q;g[f+4>>2]=l;ck(a,b);i=1;return i|0}function co(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0,I=0,J=0,K=0;if((b|0)==-1){ba(11392,382,18152,4672);return 0}d=a+4|0;e=c[d>>2]|0;f=e+(b*36&-1)|0;h=e+(b*36&-1)+24|0;i=c[h>>2]|0;if((i|0)==-1){j=b;return j|0}k=e+(b*36&-1)+32|0;if((c[k>>2]|0)<2){j=b;return j|0}l=e+(b*36&-1)+28|0;m=c[l>>2]|0;if((i|0)<=-1){ba(11392,392,18152,4432);return 0}n=c[a+12>>2]|0;if((i|0)>=(n|0)){ba(11392,392,18152,4432);return 0}if(!((m|0)>-1&(m|0)<(n|0))){ba(11392,393,18152,12936);return 0}o=e+(i*36&-1)|0;p=e+(m*36&-1)|0;q=e+(m*36&-1)+32|0;r=e+(i*36&-1)+32|0;s=(c[q>>2]|0)-(c[r>>2]|0)|0;if((s|0)>1){t=e+(m*36&-1)+24|0;u=c[t>>2]|0;v=e+(m*36&-1)+28|0;w=c[v>>2]|0;x=e+(u*36&-1)|0;y=e+(w*36&-1)|0;if(!((u|0)>-1&(u|0)<(n|0))){ba(11392,407,18152,12728);return 0}if(!((w|0)>-1&(w|0)<(n|0))){ba(11392,408,18152,12328);return 0}c[t>>2]=b;t=e+(b*36&-1)+20|0;z=e+(m*36&-1)+20|0;c[z>>2]=c[t>>2];c[t>>2]=m;t=c[z>>2]|0;do{if((t|0)==-1){c[a>>2]=m}else{z=c[d>>2]|0;A=z+(t*36&-1)+24|0;if((c[A>>2]|0)==(b|0)){c[A>>2]=m;break}A=z+(t*36&-1)+28|0;if((c[A>>2]|0)==(b|0)){c[A>>2]=m;break}else{ba(11392,424,18152,11552);return 0}}}while(0);t=e+(u*36&-1)+32|0;A=e+(w*36&-1)+32|0;if((c[t>>2]|0)>(c[A>>2]|0)){c[v>>2]=u;c[l>>2]=w;c[e+(w*36&-1)+20>>2]=b;B=+g[o>>2];C=+g[y>>2];D=B<C?B:C;C=+g[e+(i*36&-1)+4>>2];B=+g[e+(w*36&-1)+4>>2];z=f;E=+(C<B?C:B);g[z>>2]=D;g[z+4>>2]=E;E=+g[e+(i*36&-1)+8>>2];B=+g[e+(w*36&-1)+8>>2];C=+g[e+(i*36&-1)+12>>2];F=+g[e+(w*36&-1)+12>>2];z=e+(b*36&-1)+8|0;G=+(C>F?C:F);g[z>>2]=E>B?E:B;g[z+4>>2]=G;G=+g[x>>2];B=+g[e+(b*36&-1)+4>>2];E=+g[e+(u*36&-1)+4>>2];z=p;F=+(B<E?B:E);g[z>>2]=D<G?D:G;g[z+4>>2]=F;F=+g[e+(b*36&-1)+8>>2];G=+g[e+(u*36&-1)+8>>2];D=+g[e+(b*36&-1)+12>>2];E=+g[e+(u*36&-1)+12>>2];z=e+(m*36&-1)+8|0;B=+(D>E?D:E);g[z>>2]=F>G?F:G;g[z+4>>2]=B;z=c[r>>2]|0;H=c[A>>2]|0;I=((z|0)>(H|0)?z:H)+1|0;c[k>>2]=I;H=c[t>>2]|0;J=(I|0)>(H|0)?I:H}else{c[v>>2]=w;c[l>>2]=u;c[e+(u*36&-1)+20>>2]=b;B=+g[o>>2];G=+g[x>>2];F=B<G?B:G;G=+g[e+(i*36&-1)+4>>2];B=+g[e+(u*36&-1)+4>>2];x=f;E=+(G<B?G:B);g[x>>2]=F;g[x+4>>2]=E;E=+g[e+(i*36&-1)+8>>2];B=+g[e+(u*36&-1)+8>>2];G=+g[e+(i*36&-1)+12>>2];D=+g[e+(u*36&-1)+12>>2];u=e+(b*36&-1)+8|0;C=+(G>D?G:D);g[u>>2]=E>B?E:B;g[u+4>>2]=C;C=+g[y>>2];B=+g[e+(b*36&-1)+4>>2];E=+g[e+(w*36&-1)+4>>2];y=p;D=+(B<E?B:E);g[y>>2]=F<C?F:C;g[y+4>>2]=D;D=+g[e+(b*36&-1)+8>>2];C=+g[e+(w*36&-1)+8>>2];F=+g[e+(b*36&-1)+12>>2];E=+g[e+(w*36&-1)+12>>2];w=e+(m*36&-1)+8|0;B=+(F>E?F:E);g[w>>2]=D>C?D:C;g[w+4>>2]=B;w=c[r>>2]|0;y=c[t>>2]|0;t=((w|0)>(y|0)?w:y)+1|0;c[k>>2]=t;y=c[A>>2]|0;J=(t|0)>(y|0)?t:y}c[q>>2]=J+1;j=m;return j|0}if((s|0)>=-1){j=b;return j|0}s=e+(i*36&-1)+24|0;J=c[s>>2]|0;y=e+(i*36&-1)+28|0;t=c[y>>2]|0;A=e+(J*36&-1)|0;w=e+(t*36&-1)|0;if(!((J|0)>-1&(J|0)<(n|0))){ba(11392,467,18152,11296);return 0}if(!((t|0)>-1&(t|0)<(n|0))){ba(11392,468,18152,11200);return 0}c[s>>2]=b;s=e+(b*36&-1)+20|0;n=e+(i*36&-1)+20|0;c[n>>2]=c[s>>2];c[s>>2]=i;s=c[n>>2]|0;do{if((s|0)==-1){c[a>>2]=i}else{n=c[d>>2]|0;u=n+(s*36&-1)+24|0;if((c[u>>2]|0)==(b|0)){c[u>>2]=i;break}u=n+(s*36&-1)+28|0;if((c[u>>2]|0)==(b|0)){c[u>>2]=i;break}else{ba(11392,484,18152,11e3);return 0}}}while(0);s=e+(J*36&-1)+32|0;d=e+(t*36&-1)+32|0;if((c[s>>2]|0)>(c[d>>2]|0)){c[y>>2]=J;c[h>>2]=t;c[e+(t*36&-1)+20>>2]=b;B=+g[p>>2];C=+g[w>>2];D=B<C?B:C;C=+g[e+(m*36&-1)+4>>2];B=+g[e+(t*36&-1)+4>>2];a=f;E=+(C<B?C:B);g[a>>2]=D;g[a+4>>2]=E;E=+g[e+(m*36&-1)+8>>2];B=+g[e+(t*36&-1)+8>>2];C=+g[e+(m*36&-1)+12>>2];F=+g[e+(t*36&-1)+12>>2];a=e+(b*36&-1)+8|0;G=+(C>F?C:F);g[a>>2]=E>B?E:B;g[a+4>>2]=G;G=+g[A>>2];B=+g[e+(b*36&-1)+4>>2];E=+g[e+(J*36&-1)+4>>2];a=o;F=+(B<E?B:E);g[a>>2]=D<G?D:G;g[a+4>>2]=F;F=+g[e+(b*36&-1)+8>>2];G=+g[e+(J*36&-1)+8>>2];D=+g[e+(b*36&-1)+12>>2];E=+g[e+(J*36&-1)+12>>2];a=e+(i*36&-1)+8|0;B=+(D>E?D:E);g[a>>2]=F>G?F:G;g[a+4>>2]=B;a=c[q>>2]|0;u=c[d>>2]|0;n=((a|0)>(u|0)?a:u)+1|0;c[k>>2]=n;u=c[s>>2]|0;K=(n|0)>(u|0)?n:u}else{c[y>>2]=t;c[h>>2]=J;c[e+(J*36&-1)+20>>2]=b;B=+g[p>>2];G=+g[A>>2];F=B<G?B:G;G=+g[e+(m*36&-1)+4>>2];B=+g[e+(J*36&-1)+4>>2];A=f;E=+(G<B?G:B);g[A>>2]=F;g[A+4>>2]=E;E=+g[e+(m*36&-1)+8>>2];B=+g[e+(J*36&-1)+8>>2];G=+g[e+(m*36&-1)+12>>2];D=+g[e+(J*36&-1)+12>>2];J=e+(b*36&-1)+8|0;C=+(G>D?G:D);g[J>>2]=E>B?E:B;g[J+4>>2]=C;C=+g[w>>2];B=+g[e+(b*36&-1)+4>>2];E=+g[e+(t*36&-1)+4>>2];w=o;D=+(B<E?B:E);g[w>>2]=F<C?F:C;g[w+4>>2]=D;D=+g[e+(b*36&-1)+8>>2];C=+g[e+(t*36&-1)+8>>2];F=+g[e+(b*36&-1)+12>>2];E=+g[e+(t*36&-1)+12>>2];t=e+(i*36&-1)+8|0;B=+(F>E?F:E);g[t>>2]=D>C?D:C;g[t+4>>2]=B;t=c[q>>2]|0;q=c[s>>2]|0;s=((t|0)>(q|0)?t:q)+1|0;c[k>>2]=s;k=c[d>>2]|0;K=(s|0)>(k|0)?s:k}c[r>>2]=K+1;j=i;return j|0}function cp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;if((b|0)<=-1){ba(11392,563,14360,9768);return 0}if((c[a+12>>2]|0)<=(b|0)){ba(11392,563,14360,9768);return 0}d=c[a+4>>2]|0;e=c[d+(b*36&-1)+24>>2]|0;if((e|0)==-1){return 0}else{f=cp(a,e)|0;e=cp(a,c[d+(b*36&-1)+28>>2]|0)|0;return((f|0)>(e|0)?f:e)+1|0}return 0}function cq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;if((b|0)==-1){return}d=a|0;e=a+4|0;f=a+12|0;g=b;while(1){h=c[e>>2]|0;if((c[d>>2]|0)==(g|0)){if((c[h+(g*36&-1)+20>>2]|0)!=-1){i=596;break}}b=c[h+(g*36&-1)+24>>2]|0;j=c[h+(g*36&-1)+28>>2]|0;if((b|0)==-1){i=598;break}if((b|0)<=-1){i=614;break}k=c[f>>2]|0;if((b|0)>=(k|0)){i=613;break}if(!((j|0)>-1&(j|0)<(k|0))){i=606;break}if((c[h+(b*36&-1)+20>>2]|0)!=(g|0)){i=608;break}if((c[h+(j*36&-1)+20>>2]|0)!=(g|0)){i=610;break}cq(a,b);if((j|0)==-1){i=616;break}else{g=j}}if((i|0)==598){if((j|0)!=-1){ba(11392,602,14200,10448)}if((c[h+(g*36&-1)+32>>2]|0)==0){return}else{ba(11392,603,14200,10240)}}else if((i|0)==610){ba(11392,611,14200,8896)}else if((i|0)==613){ba(11392,607,14200,10024)}else if((i|0)==616){return}else if((i|0)==606){ba(11392,608,14200,9600)}else if((i|0)==614){ba(11392,607,14200,10024)}else if((i|0)==596){ba(11392,591,14200,10680)}else if((i|0)==608){ba(11392,610,14200,9296)}}function cr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0;if((b|0)==-1){return}d=a+4|0;e=a+12|0;f=b;while(1){h=c[d>>2]|0;b=c[h+(f*36&-1)+24>>2]|0;i=c[h+(f*36&-1)+28>>2]|0;if((b|0)==-1){j=621;break}if((b|0)<=-1){j=647;break}k=c[e>>2]|0;if((b|0)>=(k|0)){j=648;break}if(!((i|0)>-1&(i|0)<(k|0))){j=629;break}k=c[h+(b*36&-1)+32>>2]|0;l=c[h+(i*36&-1)+32>>2]|0;if((c[h+(f*36&-1)+32>>2]|0)!=(((k|0)>(l|0)?k:l)+1|0)){j=631;break}m=+g[h+(b*36&-1)>>2];n=+g[h+(i*36&-1)>>2];o=+g[h+(b*36&-1)+4>>2];p=+g[h+(i*36&-1)+4>>2];q=+g[h+(b*36&-1)+8>>2];r=+g[h+(i*36&-1)+8>>2];s=+g[h+(b*36&-1)+12>>2];t=+g[h+(i*36&-1)+12>>2];if((m<n?m:n)!=+g[h+(f*36&-1)>>2]){j=643;break}if((o<p?o:p)!=+g[h+(f*36&-1)+4>>2]){j=644;break}if((q>r?q:r)!=+g[h+(f*36&-1)+8>>2]){j=645;break}if((s>t?s:t)!=+g[h+(f*36&-1)+12>>2]){j=646;break}cr(a,b);if((i|0)==-1){j=640;break}else{f=i}}if((j|0)==648){ba(11392,637,14256,10024)}else if((j|0)==631){ba(11392,644,14256,8744)}else if((j|0)==621){if((i|0)!=-1){ba(11392,632,14256,10448)}if((c[h+(f*36&-1)+32>>2]|0)==0){return}else{ba(11392,633,14256,10240)}}else if((j|0)==645){ba(11392,650,14256,8160)}else if((j|0)==629){ba(11392,638,14256,9600)}else if((j|0)==640){return}else if((j|0)==643){ba(11392,649,14256,8392)}else if((j|0)==644){ba(11392,649,14256,8392)}else if((j|0)==646){ba(11392,650,14256,8160)}else if((j|0)==647){ba(11392,637,14256,10024)}}function cs(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;b=a|0;cq(a,c[b>>2]|0);cr(a,c[b>>2]|0);d=c[a+16>>2]|0;L849:do{if((d|0)==-1){e=0}else{f=a+12|0;g=a+4|0;h=0;i=d;while(1){if((i|0)<=-1){j=663;break}if((i|0)>=(c[f>>2]|0)){j=662;break}k=h+1|0;l=c[(c[g>>2]|0)+(i*36&-1)+20>>2]|0;if((l|0)==-1){e=k;break L849}else{h=k;i=l}}if((j|0)==662){ba(11392,665,14064,7712)}else if((j|0)==663){ba(11392,665,14064,7712)}}}while(0);j=c[b>>2]|0;if((j|0)==-1){m=0}else{m=c[(c[a+4>>2]|0)+(j*36&-1)+32>>2]|0}if((m|0)!=(cp(a,j)|0)){ba(11392,670,14064,7680)}if(((c[a+8>>2]|0)+e|0)==(c[a+12>>2]|0)){return}else{ba(11392,672,14064,7488)}}function ct(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0,I=0,J=0;b=a+8|0;d=vh(c[b>>2]<<2)|0;e=d;f=a+12|0;if((c[f>>2]|0)<=0){h=c[e>>2]|0;i=a|0;c[i>>2]=h;vi(d);cs(a);return}j=a+4|0;k=a+16|0;l=0;m=0;L872:while(1){n=c[j>>2]|0;do{if((c[n+(l*36&-1)+32>>2]|0)<0){o=m}else{if((c[n+(l*36&-1)+24>>2]|0)==-1){c[n+(l*36&-1)+20>>2]=-1;c[e+(m<<2)>>2]=l;o=m+1|0;break}if((c[b>>2]|0)<=0){p=672;break L872}c[n+(l*36&-1)+20>>2]=c[k>>2];c[(c[j>>2]|0)+(l*36&-1)+32>>2]=-1;c[k>>2]=l;c[b>>2]=(c[b>>2]|0)-1;o=m}}while(0);n=l+1|0;if((n|0)<(c[f>>2]|0)){l=n;m=o}else{break}}if((p|0)==672){ba(11392,98,18112,7256)}if((o|0)<=1){h=c[e>>2]|0;i=a|0;c[i>>2]=h;vi(d);cs(a);return}p=a+4|0;m=o;do{o=c[p>>2]|0;l=0;f=-1;b=-1;q=3.4028234663852886e+38;while(1){k=c[e+(l<<2)>>2]|0;r=+g[o+(k*36&-1)>>2];s=+g[o+(k*36&-1)+4>>2];t=+g[o+(k*36&-1)+8>>2];u=+g[o+(k*36&-1)+12>>2];k=l+1|0;j=(k|0)<(m|0);if(j){v=k;w=f;x=b;y=q}else{z=b;A=f;break}do{n=c[e+(v<<2)>>2]|0;B=+g[o+(n*36&-1)>>2];C=+g[o+(n*36&-1)+4>>2];D=+g[o+(n*36&-1)+8>>2];E=+g[o+(n*36&-1)+12>>2];F=((t>D?t:D)-(r<B?r:B)+((u>E?u:E)-(s<C?s:C)))*2.0;n=F<y;w=n?v:w;x=n?l:x;y=n?F:y;v=v+1|0;}while((v|0)<(m|0));if(j){l=k;f=w;b=x;q=y}else{z=x;A=w;break}}b=e+(z<<2)|0;f=c[b>>2]|0;l=e+(A<<2)|0;n=c[l>>2]|0;G=cj(a)|0;H=c[p>>2]|0;c[H+(G*36&-1)+24>>2]=f;c[H+(G*36&-1)+28>>2]=n;I=c[o+(f*36&-1)+32>>2]|0;J=c[o+(n*36&-1)+32>>2]|0;c[H+(G*36&-1)+32>>2]=((I|0)>(J|0)?I:J)+1;q=+g[o+(f*36&-1)>>2];s=+g[o+(n*36&-1)>>2];u=+g[o+(f*36&-1)+4>>2];r=+g[o+(n*36&-1)+4>>2];J=H+(G*36&-1)|0;t=+(u<r?u:r);g[J>>2]=q<s?q:s;g[J+4>>2]=t;t=+g[o+(f*36&-1)+8>>2];s=+g[o+(n*36&-1)+8>>2];q=+g[o+(f*36&-1)+12>>2];r=+g[o+(n*36&-1)+12>>2];J=H+(G*36&-1)+8|0;u=+(q>r?q:r);g[J>>2]=t>s?t:s;g[J+4>>2]=u;c[H+(G*36&-1)+20>>2]=-1;c[o+(f*36&-1)+20>>2]=G;c[o+(n*36&-1)+20>>2]=G;m=m-1|0;c[l>>2]=c[e+(m<<2)>>2];c[b>>2]=G;}while((m|0)>1);h=c[e>>2]|0;i=a|0;c[i>>2]=h;vi(d);cs(a);return}function cu(d,e){d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0,D=0.0,E=0.0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,O=0,P=0,Q=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0.0,_=0.0,$=0,aa=0.0,ab=0.0,ac=0.0,ad=0.0,ae=0.0,af=0.0,ag=0.0,ah=0.0,ai=0.0,aj=0.0,ak=0.0,al=0.0,am=0.0,an=0,ao=0,ap=0.0,aq=0,ar=0,as=0.0,at=0.0,au=0,av=0.0,aw=0.0,ax=0.0,ay=0.0,az=0,aA=0.0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0;f=i;i=i+336|0;h=f|0;j=f+40|0;k=f+80|0;l=f+96|0;m=f+192|0;n=f+216|0;o=f+320|0;p=f+328|0;c[1038]=(c[1038]|0)+1;q=d|0;c[q>>2]=0;r=e+128|0;s=d+4|0;g[s>>2]=+g[r>>2];d=e|0;t=e+28|0;u=h;v=e+56|0;vp(u|0,v|0,36)|0;v=j;u=e+92|0;vp(v|0,u|0,36)|0;u=h+24|0;w=+g[u>>2];x=+N(+(w/6.2831854820251465))*6.2831854820251465;y=w-x;g[u>>2]=y;v=h+28|0;w=+g[v>>2]-x;g[v>>2]=w;z=j+24|0;x=+g[z>>2];A=+N(+(x/6.2831854820251465))*6.2831854820251465;B=x-A;g[z>>2]=B;C=j+28|0;x=+g[C>>2]-A;g[C>>2]=x;A=+g[r>>2];D=+g[e+24>>2]+ +g[e+52>>2]+-.014999999664723873;E=D<.004999999888241291?.004999999888241291:D;if(E<=.0012499999720603228){ba(6688,280,19104,11456)}b[k+4>>1]=0;r=l;F=e;c[r>>2]=c[F>>2];c[r+4>>2]=c[F+4>>2];c[r+8>>2]=c[F+8>>2];c[r+12>>2]=c[F+12>>2];c[r+16>>2]=c[F+16>>2];c[r+20>>2]=c[F+20>>2];c[r+24>>2]=c[F+24>>2];F=l+28|0;r=t;c[F>>2]=c[r>>2];c[F+4>>2]=c[r+4>>2];c[F+8>>2]=c[r+8>>2];c[F+12>>2]=c[r+12>>2];c[F+16>>2]=c[r+16>>2];c[F+20>>2]=c[r+20>>2];c[F+24>>2]=c[r+24>>2];a[l+88|0]=0;r=h+8|0;F=h+12|0;e=h+16|0;G=h+20|0;H=h|0;I=h+4|0;J=j+8|0;K=j+12|0;L=j+16|0;M=j+20|0;O=j|0;P=j+4|0;Q=l+56|0;T=l+64|0;U=l+68|0;V=l+72|0;W=l+80|0;X=l+84|0;Y=m+16|0;D=E+.0012499999720603228;Z=E+-.0012499999720603228;_=0.0;$=0;aa=y;y=w;w=B;B=x;L900:while(1){x=1.0-_;ab=x*+g[r>>2]+_*+g[e>>2];ac=x*+g[F>>2]+_*+g[G>>2];ad=x*aa+_*y;ae=+S(+ad);af=+R(+ad);ad=+g[H>>2];ag=+g[I>>2];ah=x*+g[J>>2]+_*+g[L>>2];ai=x*+g[K>>2]+_*+g[M>>2];aj=x*w+_*B;x=+S(+aj);ak=+R(+aj);aj=+g[O>>2];al=+g[P>>2];am=+(ac-(ae*ad+af*ag));g[Q>>2]=ab-(af*ad-ae*ag);g[Q+4>>2]=am;g[T>>2]=ae;g[U>>2]=af;af=+(ai-(x*aj+ak*al));g[V>>2]=ah-(ak*aj-x*al);g[V+4>>2]=af;g[W>>2]=x;g[X>>2]=ak;cg(m,k,l);ak=+g[Y>>2];if(ak<=0.0){an=688;break}if(ak<D){an=690;break}+cv(n,k,d,h,t,j,_);ao=0;ak=A;while(1){x=+cz(n,o,p,ak);if(x>D){an=693;break L900}if(x>Z){ap=ak;break}aq=c[o>>2]|0;ar=c[p>>2]|0;af=+cA(n,aq,ar,_);if(af<Z){an=696;break L900}if(af>D){as=ak;at=_;au=0;av=af;aw=x}else{an=698;break L900}while(1){if((au&1|0)==0){ax=(at+as)*.5}else{ax=at+(E-av)*(as-at)/(aw-av)}x=+cA(n,aq,ar,ax);af=x-E;if(af>0.0){ay=af}else{ay=-0.0-af}if(ay<.0012499999720603228){az=au;aA=ax;break}aB=x>E;aC=au+1|0;c[1030]=(c[1030]|0)+1;if((aC|0)==50){az=50;aA=ak;break}else{as=aB?as:ax;at=aB?ax:at;au=aC;av=aB?x:av;aw=aB?aw:x}}ar=c[1032]|0;c[1032]=(ar|0)>(az|0)?ar:az;ar=ao+1|0;if((ar|0)==8){ap=_;break}else{ao=ar;ak=aA}}ao=$+1|0;c[1036]=(c[1036]|0)+1;if((ao|0)==20){an=710;break}_=ap;$=ao;aa=+g[u>>2];y=+g[v>>2];w=+g[z>>2];B=+g[C>>2]}if((an|0)==710){c[q>>2]=1;g[s>>2]=ap;aD=20;aE=c[1034]|0;aF=(aE|0)>(aD|0);aG=aF?aE:aD;c[1034]=aG;i=f;return}else if((an|0)==696){c[q>>2]=1;g[s>>2]=_}else if((an|0)==688){c[q>>2]=2;g[s>>2]=0.0;aD=$;aE=c[1034]|0;aF=(aE|0)>(aD|0);aG=aF?aE:aD;c[1034]=aG;i=f;return}else if((an|0)==690){c[q>>2]=3;g[s>>2]=_;aD=$;aE=c[1034]|0;aF=(aE|0)>(aD|0);aG=aF?aE:aD;c[1034]=aG;i=f;return}else if((an|0)==693){c[q>>2]=4;g[s>>2]=A}else if((an|0)==698){c[q>>2]=3;g[s>>2]=_}c[1036]=(c[1036]|0)+1;aD=$+1|0;aE=c[1034]|0;aF=(aE|0)>(aD|0);aG=aF?aE:aD;c[1034]=aG;i=f;return}function cv(e,f,h,i,j,k,l){e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=+l;var m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;c[e>>2]=h;c[e+4>>2]=j;m=b[f+4>>1]|0;if(!(m<<16>>16!=0&(m&65535)<3)){ba(6688,50,16840,5584);return 0.0}n=e+8|0;o=n;p=i;vp(o|0,p|0,36)|0;p=e+44|0;o=p;i=k;vp(o|0,i|0,36)|0;q=1.0-l;r=q*+g[e+16>>2]+ +g[e+24>>2]*l;s=q*+g[e+20>>2]+ +g[e+28>>2]*l;t=q*+g[e+32>>2]+ +g[e+36>>2]*l;u=+S(+t);v=+R(+t);t=+g[n>>2];w=+g[e+12>>2];x=r-(v*t-u*w);r=s-(u*t+v*w);w=q*+g[e+52>>2]+ +g[e+60>>2]*l;t=q*+g[e+56>>2]+ +g[e+64>>2]*l;s=q*+g[e+68>>2]+ +g[e+72>>2]*l;l=+S(+s);q=+R(+s);s=+g[p>>2];y=+g[e+48>>2];z=w-(q*s-l*y);w=t-(l*s+q*y);if(m<<16>>16==1){c[e+80>>2]=0;m=d[f+6|0]|0;if((c[h+20>>2]|0)<=(m|0)){ba(7536,103,13816,6368);return 0.0}p=(c[h+16>>2]|0)+(m<<3)|0;y=+g[p>>2];s=+g[p+4>>2];p=d[f+9|0]|0;if((c[j+20>>2]|0)<=(p|0)){ba(7536,103,13816,6368);return 0.0}m=(c[j+16>>2]|0)+(p<<3)|0;t=+g[m>>2];A=+g[m+4>>2];m=e+92|0;B=z+(q*t-l*A)-(x+(v*y-u*s));C=w+(l*t+q*A)-(r+(u*y+v*s));p=m;s=+C;g[p>>2]=B;g[p+4>>2]=s;s=+P(+(B*B+C*C));if(s<1.1920928955078125e-7){D=0.0;return+D}y=1.0/s;g[m>>2]=B*y;g[e+96>>2]=C*y;D=s;return+D}m=f+6|0;p=f+7|0;n=e+80|0;if((a[m]|0)==(a[p]|0)){c[n>>2]=2;i=d[f+9|0]|0;o=c[j+20>>2]|0;if((o|0)<=(i|0)){ba(7536,103,13816,6368);return 0.0}k=c[j+16>>2]|0;E=k+(i<<3)|0;s=+g[E>>2];y=+g[E+4>>2];E=d[f+10|0]|0;if((o|0)<=(E|0)){ba(7536,103,13816,6368);return 0.0}o=k+(E<<3)|0;C=+g[o>>2];B=+g[o+4>>2];o=e+92|0;A=B-y;t=(C-s)*-1.0;E=o;F=+t;g[E>>2]=A;g[E+4>>2]=F;F=+P(+(A*A+t*t));if(F<1.1920928955078125e-7){G=A;H=t}else{I=1.0/F;F=A*I;g[o>>2]=F;A=t*I;g[e+96>>2]=A;G=F;H=A}A=(s+C)*.5;C=(y+B)*.5;o=e+84|0;B=+C;g[o>>2]=A;g[o+4>>2]=B;o=d[m]|0;if((c[h+20>>2]|0)<=(o|0)){ba(7536,103,13816,6368);return 0.0}k=(c[h+16>>2]|0)+(o<<3)|0;B=+g[k>>2];y=+g[k+4>>2];s=(q*G-l*H)*(x+(v*B-u*y)-(z+(q*A-l*C)))+(l*G+q*H)*(r+(u*B+v*y)-(w+(l*A+q*C)));if(s>=0.0){D=s;return+D}C=+(-0.0-H);g[E>>2]=-0.0-G;g[E+4>>2]=C;D=-0.0-s;return+D}else{c[n>>2]=1;n=d[m]|0;m=c[h+20>>2]|0;if((m|0)<=(n|0)){ba(7536,103,13816,6368);return 0.0}E=c[h+16>>2]|0;h=E+(n<<3)|0;s=+g[h>>2];C=+g[h+4>>2];h=d[p]|0;if((m|0)<=(h|0)){ba(7536,103,13816,6368);return 0.0}m=E+(h<<3)|0;G=+g[m>>2];H=+g[m+4>>2];m=e+92|0;A=H-C;y=(G-s)*-1.0;h=m;B=+y;g[h>>2]=A;g[h+4>>2]=B;B=+P(+(A*A+y*y));if(B<1.1920928955078125e-7){J=A;K=y}else{F=1.0/B;B=A*F;g[m>>2]=B;A=y*F;g[e+96>>2]=A;J=B;K=A}A=(s+G)*.5;G=(C+H)*.5;m=e+84|0;H=+G;g[m>>2]=A;g[m+4>>2]=H;m=d[f+9|0]|0;if((c[j+20>>2]|0)<=(m|0)){ba(7536,103,13816,6368);return 0.0}f=(c[j+16>>2]|0)+(m<<3)|0;H=+g[f>>2];C=+g[f+4>>2];s=(v*J-u*K)*(z+(q*H-l*C)-(x+(v*A-u*G)))+(u*J+v*K)*(w+(l*H+q*C)-(r+(u*A+v*G)));if(s>=0.0){D=s;return+D}G=+(-0.0-K);g[h>>2]=-0.0-J;g[h+4>>2]=G;D=-0.0-s;return+D}return 0.0}function cw(a){a=a|0;return(c[a+16>>2]|0)-1|0}function cx(a){a=a|0;var b=0;c[a>>2]=20296;b=a+12|0;vi(c[b>>2]|0);c[b>>2]=0;c[a+16>>2]=0;vl(a);return}function cy(a){a=a|0;var b=0;c[a>>2]=20296;b=a+12|0;vi(c[b>>2]|0);c[b>>2]=0;c[a+16>>2]=0;return}function cz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0.0,H=0.0,I=0.0,J=0,K=0,L=0,M=0;f=1.0-e;h=f*+g[a+16>>2]+ +g[a+24>>2]*e;i=f*+g[a+20>>2]+ +g[a+28>>2]*e;j=f*+g[a+32>>2]+ +g[a+36>>2]*e;k=+S(+j);l=+R(+j);j=+g[a+8>>2];m=+g[a+12>>2];n=h-(l*j-k*m);h=i-(k*j+l*m);m=f*+g[a+52>>2]+ +g[a+60>>2]*e;j=f*+g[a+56>>2]+ +g[a+64>>2]*e;i=f*+g[a+68>>2]+ +g[a+72>>2]*e;e=+S(+i);f=+R(+i);i=+g[a+44>>2];o=+g[a+48>>2];p=m-(f*i-e*o);m=j-(e*i+f*o);q=c[a+80>>2]|0;if((q|0)==0){r=a+92|0;o=+g[r>>2];s=a+96|0;i=+g[s>>2];j=l*o+k*i;t=o*(-0.0-k)+l*i;u=-0.0-i;i=f*(-0.0-o)+e*u;v=e*o+f*u;w=a|0;x=c[w>>2]|0;y=c[x+16>>2]|0;z=c[x+20>>2]|0;if((z|0)>1){u=t*+g[y+4>>2]+j*+g[y>>2];x=1;A=0;while(1){o=j*+g[y+(x<<3)>>2]+t*+g[y+(x<<3)+4>>2];B=o>u;C=B?x:A;D=x+1|0;if((D|0)<(z|0)){u=B?o:u;x=D;A=C}else{E=C;break}}}else{E=0}c[b>>2]=E;E=a+4|0;A=c[E>>2]|0;x=c[A+16>>2]|0;z=c[A+20>>2]|0;if((z|0)>1){u=v*+g[x+4>>2]+i*+g[x>>2];A=1;y=0;while(1){t=i*+g[x+(A<<3)>>2]+v*+g[x+(A<<3)+4>>2];C=t>u;D=C?A:y;B=A+1|0;if((B|0)<(z|0)){u=C?t:u;A=B;y=D}else{F=D;break}}}else{F=0}c[d>>2]=F;y=c[w>>2]|0;w=c[b>>2]|0;if((w|0)<=-1){ba(7536,103,13816,6368);return 0.0}if((c[y+20>>2]|0)<=(w|0)){ba(7536,103,13816,6368);return 0.0}A=(c[y+16>>2]|0)+(w<<3)|0;u=+g[A>>2];v=+g[A+4>>2];A=c[E>>2]|0;if((F|0)<=-1){ba(7536,103,13816,6368);return 0.0}if((c[A+20>>2]|0)<=(F|0)){ba(7536,103,13816,6368);return 0.0}E=(c[A+16>>2]|0)+(F<<3)|0;i=+g[E>>2];t=+g[E+4>>2];G=+g[r>>2]*(p+(f*i-e*t)-(n+(l*u-k*v)))+ +g[s>>2]*(m+(e*i+f*t)-(h+(k*u+l*v)));return+G}else if((q|0)==1){v=+g[a+92>>2];u=+g[a+96>>2];t=l*v-k*u;i=k*v+l*u;u=+g[a+84>>2];v=+g[a+88>>2];j=n+(l*u-k*v);o=h+(k*u+l*v);v=-0.0-i;u=f*(-0.0-t)+e*v;H=e*t+f*v;c[b>>2]=-1;s=a+4|0;r=c[s>>2]|0;E=c[r+16>>2]|0;F=c[r+20>>2]|0;do{if((F|0)>1){v=H*+g[E+4>>2]+u*+g[E>>2];r=1;A=0;while(1){I=u*+g[E+(r<<3)>>2]+H*+g[E+(r<<3)+4>>2];w=I>v;J=w?r:A;y=r+1|0;if((y|0)<(F|0)){v=w?I:v;r=y;A=J}else{break}}c[d>>2]=J;if((J|0)>-1){K=J;break}ba(7536,103,13816,6368);return 0.0}else{c[d>>2]=0;K=0}}while(0);J=c[s>>2]|0;if((c[J+20>>2]|0)<=(K|0)){ba(7536,103,13816,6368);return 0.0}s=(c[J+16>>2]|0)+(K<<3)|0;H=+g[s>>2];u=+g[s+4>>2];G=t*(p+(f*H-e*u)-j)+i*(m+(e*H+f*u)-o);return+G}else if((q|0)==2){o=+g[a+92>>2];u=+g[a+96>>2];H=f*o-e*u;i=e*o+f*u;u=+g[a+84>>2];o=+g[a+88>>2];j=p+(f*u-e*o);p=m+(e*u+f*o);o=-0.0-i;f=l*(-0.0-H)+k*o;u=k*H+l*o;c[d>>2]=-1;d=a|0;a=c[d>>2]|0;q=c[a+16>>2]|0;s=c[a+20>>2]|0;do{if((s|0)>1){o=u*+g[q+4>>2]+f*+g[q>>2];a=1;K=0;while(1){e=f*+g[q+(a<<3)>>2]+u*+g[q+(a<<3)+4>>2];J=e>o;L=J?a:K;F=a+1|0;if((F|0)<(s|0)){o=J?e:o;a=F;K=L}else{break}}c[b>>2]=L;if((L|0)>-1){M=L;break}ba(7536,103,13816,6368);return 0.0}else{c[b>>2]=0;M=0}}while(0);b=c[d>>2]|0;if((c[b+20>>2]|0)<=(M|0)){ba(7536,103,13816,6368);return 0.0}d=(c[b+16>>2]|0)+(M<<3)|0;u=+g[d>>2];f=+g[d+4>>2];G=H*(n+(l*u-k*f)-j)+i*(h+(k*u+l*f)-p);return+G}else{ba(6688,183,13728,11592);return 0.0}return 0.0}function cA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0,t=0,u=0.0,v=0.0,w=0.0;f=1.0-e;h=f*+g[a+16>>2]+ +g[a+24>>2]*e;i=f*+g[a+20>>2]+ +g[a+28>>2]*e;j=f*+g[a+32>>2]+ +g[a+36>>2]*e;k=+S(+j);l=+R(+j);j=+g[a+8>>2];m=+g[a+12>>2];n=h-(l*j-k*m);h=i-(k*j+l*m);m=f*+g[a+52>>2]+ +g[a+60>>2]*e;j=f*+g[a+56>>2]+ +g[a+64>>2]*e;i=f*+g[a+68>>2]+ +g[a+72>>2]*e;e=+S(+i);f=+R(+i);i=+g[a+44>>2];o=+g[a+48>>2];p=m-(f*i-e*o);m=j-(e*i+f*o);q=c[a+80>>2]|0;if((q|0)==1){o=+g[a+92>>2];i=+g[a+96>>2];j=+g[a+84>>2];r=+g[a+88>>2];s=c[a+4>>2]|0;if((d|0)<=-1){ba(7536,103,13816,6368);return 0.0}if((c[s+20>>2]|0)<=(d|0)){ba(7536,103,13816,6368);return 0.0}t=(c[s+16>>2]|0)+(d<<3)|0;u=+g[t>>2];v=+g[t+4>>2];w=(l*o-k*i)*(p+(f*u-e*v)-(n+(l*j-k*r)))+(k*o+l*i)*(m+(e*u+f*v)-(h+(k*j+l*r)));return+w}else if((q|0)==2){r=+g[a+92>>2];j=+g[a+96>>2];v=+g[a+84>>2];u=+g[a+88>>2];t=c[a>>2]|0;if((b|0)<=-1){ba(7536,103,13816,6368);return 0.0}if((c[t+20>>2]|0)<=(b|0)){ba(7536,103,13816,6368);return 0.0}s=(c[t+16>>2]|0)+(b<<3)|0;i=+g[s>>2];o=+g[s+4>>2];w=(f*r-e*j)*(n+(l*i-k*o)-(p+(f*v-e*u)))+(e*r+f*j)*(h+(k*i+l*o)-(m+(e*v+f*u)));return+w}else if((q|0)==0){u=+g[a+92>>2];v=+g[a+96>>2];q=c[a>>2]|0;if((b|0)<=-1){ba(7536,103,13816,6368);return 0.0}if((c[q+20>>2]|0)<=(b|0)){ba(7536,103,13816,6368);return 0.0}s=(c[q+16>>2]|0)+(b<<3)|0;o=+g[s>>2];i=+g[s+4>>2];s=c[a+4>>2]|0;if((d|0)<=-1){ba(7536,103,13816,6368);return 0.0}if((c[s+20>>2]|0)<=(d|0)){ba(7536,103,13816,6368);return 0.0}a=(c[s+16>>2]|0)+(d<<3)|0;j=+g[a>>2];r=+g[a+4>>2];w=u*(p+(f*j-e*r)-(n+(l*o-k*i)))+v*(m+(e*j+f*r)-(h+(k*o+l*i)));return+w}else{ba(6688,242,13656,11592);return 0.0}return 0.0}function cB(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0;e=df(d,40)|0;if((e|0)==0){f=0}else{c[e>>2]=20296;c[e+4>>2]=3;g[e+8>>2]=.009999999776482582;c[e+12>>2]=0;c[e+16>>2]=0;a[e+36|0]=0;a[e+37|0]=0;f=e}e=c[b+12>>2]|0;d=c[b+16>>2]|0;h=f+12|0;if((c[h>>2]|0)!=0){ba(6208,48,18448,11256);return 0}i=f+16|0;if((c[i>>2]|0)!=0){ba(6208,48,18448,11256);return 0}if((d|0)>1){c[i>>2]=d;j=vh(d<<3)|0;c[h>>2]=j;h=e;e=c[i>>2]<<3;vp(j|0,h|0,e)|0;e=f+36|0;a[e]=0;h=f+37|0;a[h]=0;j=b+20|0;i=f+20|0;d=c[j+4>>2]|0;c[i>>2]=c[j>>2];c[i+4>>2]=d;d=b+28|0;i=f+28|0;j=c[d+4>>2]|0;c[i>>2]=c[d>>2];c[i+4>>2]=j;a[e]=a[b+36|0]&1;a[h]=a[b+37|0]&1;return f|0}else{ba(6208,49,18448,6736);return 0}return 0}function cC(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function cD(a){a=a|0;return}function cE(a){a=a|0;return 1}function cF(a){a=a|0;return}function cG(a){a=a|0;return 1}function cH(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function cI(a){a=a|0;return 1}function cJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=+g[b+12>>2];e=+g[a+12>>2];f=+g[b+8>>2];h=+g[a+16>>2];i=+g[c>>2]-(+g[b>>2]+(d*e-f*h));j=+g[c+4>>2]-(+g[b+4>>2]+(e*f+d*h));h=+g[a+8>>2];return i*i+j*j<=h*h|0}function cK(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;e=+g[c+12>>2];f=+g[a+12>>2];h=+g[c+8>>2];i=+g[a+16>>2];j=+g[c>>2]+(e*f-h*i);k=+g[c+4>>2]+(f*h+e*i);c=a+8|0;i=+g[c>>2];g[b>>2]=j-i;g[b+4>>2]=k-i;i=+g[c>>2];g[b+8>>2]=j+i;g[b+12>>2]=k+i;return}function cL(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0.0,h=0.0,i=0,j=0,k=0,l=0,m=0.0;e=a+8|0;f=+g[e>>2];h=f*d*3.1415927410125732*f;g[b>>2]=h;i=a+12|0;j=i;k=b+4|0;l=c[j+4>>2]|0;c[k>>2]=c[j>>2];c[k+4>>2]=l;f=+g[e>>2];d=+g[i>>2];m=+g[a+16>>2];g[b+12>>2]=h*(f*f*.5+(d*d+m*m));return}function cM(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;e=+g[c+12>>2];f=+g[a+12>>2];h=+g[c+8>>2];i=+g[a+16>>2];j=+g[c>>2];k=j+(e*f-h*i);l=+g[c+4>>2];m=f*h+e*i+l;i=+g[a+20>>2];f=+g[a+24>>2];n=j+(e*i-h*f);j=l+(h*i+e*f);f=+g[a+8>>2];a=b;e=+((m<j?m:j)-f);g[a>>2]=(k<n?k:n)-f;g[a+4>>2]=e;a=b+8|0;e=+(f+(m>j?m:j));g[a>>2]=f+(k>n?k:n);g[a+4>>2]=e;return}function cN(a,b,c){a=a|0;b=b|0;c=+c;var d=0;g[b>>2]=0.0;d=b+4|0;c=+((+g[a+16>>2]+ +g[a+24>>2])*.5);g[d>>2]=(+g[a+12>>2]+ +g[a+20>>2])*.5;g[d+4>>2]=c;g[b+12>>2]=0.0;return}function cO(a,b,c){a=a|0;b=b|0;c=+c;vq(b|0,0,16);return}function cP(a,b){a=a|0;b=b|0;var d=0,e=0;d=df(b,20)|0;if((d|0)==0){e=0}else{c[d>>2]=20136;vq(d+4|0,0,16);e=d}c[e+4>>2]=c[a+4>>2];g[e+8>>2]=+g[a+8>>2];d=a+12|0;a=e+12|0;b=c[d+4>>2]|0;c[a>>2]=c[d>>2];c[a+4>>2]=b;return e|0}function cQ(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0;f=+g[d+12>>2];h=+g[a+12>>2];i=+g[d+8>>2];j=+g[a+16>>2];k=+g[c>>2];l=k-(+g[d>>2]+(f*h-i*j));m=+g[c+4>>2];n=m-(+g[d+4>>2]+(h*i+f*j));j=+g[a+8>>2];f=+g[c+8>>2]-k;k=+g[c+12>>2]-m;m=l*f+n*k;i=f*f+k*k;h=m*m-(l*l+n*n-j*j)*i;if(h<0.0|i<1.1920928955078125e-7){o=0;return o|0}j=m+ +P(+h);h=-0.0-j;if(j>-0.0){o=0;return o|0}if(i*+g[c+16>>2]<h){o=0;return o|0}j=h/i;g[b+8>>2]=j;i=l+f*j;f=n+k*j;c=b;j=+f;g[c>>2]=i;g[c+4>>2]=j;j=+P(+(i*i+f*f));if(j<1.1920928955078125e-7){o=1;return o|0}k=1.0/j;g[b>>2]=i*k;g[b+4>>2]=f*k;o=1;return o|0}function cR(a){a=a|0;vl(a);return}function cS(b,d){b=b|0;d=d|0;var e=0,f=0,h=0;e=df(d,48)|0;if((e|0)==0){f=0}else{c[e>>2]=20512;c[e+4>>2]=1;g[e+8>>2]=.009999999776482582;vq(e+28|0,0,18);f=e}c[f+4>>2]=c[b+4>>2];g[f+8>>2]=+g[b+8>>2];e=b+12|0;d=f+12|0;h=c[e+4>>2]|0;c[d>>2]=c[e>>2];c[d+4>>2]=h;h=b+20|0;d=f+20|0;e=c[h+4>>2]|0;c[d>>2]=c[h>>2];c[d+4>>2]=e;e=b+28|0;d=f+28|0;h=c[e+4>>2]|0;c[d>>2]=c[e>>2];c[d+4>>2]=h;h=b+36|0;d=f+36|0;e=c[h+4>>2]|0;c[d>>2]=c[h>>2];c[d+4>>2]=e;a[f+44|0]=a[b+44|0]&1;a[f+45|0]=a[b+45|0]&1;return f|0}function cT(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0;f=+g[d>>2];h=+g[c>>2]-f;i=+g[d+4>>2];j=+g[c+4>>2]-i;k=+g[d+12>>2];l=+g[d+8>>2];m=h*k+j*l;n=-0.0-l;o=k*j+h*n;h=+g[c+8>>2]-f;f=+g[c+12>>2]-i;i=k*h+l*f-m;l=h*n+k*f-o;d=a+12|0;f=+g[d>>2];k=+g[d+4>>2];d=a+20|0;n=+g[d>>2]-f;h=+g[d+4>>2]-k;j=-0.0-n;p=n*n+h*h;q=+P(+p);if(q<1.1920928955078125e-7){r=h;s=j}else{t=1.0/q;r=h*t;s=t*j}j=(k-o)*s+(f-m)*r;t=l*s+i*r;if(t==0.0){u=0;return u|0}q=j/t;if(q<0.0){u=0;return u|0}if(+g[c+16>>2]<q|p==0.0){u=0;return u|0}t=(n*(m+i*q-f)+h*(o+l*q-k))/p;if(t<0.0|t>1.0){u=0;return u|0}g[b+8>>2]=q;if(j>0.0){c=b;j=+(-0.0-s);g[c>>2]=-0.0-r;g[c+4>>2]=j;u=1;return u|0}else{c=b;j=+s;g[c>>2]=r;g[c+4>>2]=j;u=1;return u|0}return 0}function cU(a){a=a|0;vl(a);return}function cV(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=df(b,152)|0;if((d|0)==0){e=0}else{c[d>>2]=20032;c[d+4>>2]=2;g[d+8>>2]=.009999999776482582;c[d+148>>2]=0;g[d+12>>2]=0.0;g[d+16>>2]=0.0;e=d}c[e+4>>2]=c[a+4>>2];g[e+8>>2]=+g[a+8>>2];d=a+12|0;b=e+12|0;f=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=f;f=e+20|0;b=a+20|0;vp(f|0,b|0,64)|0;b=e+84|0;f=a+84|0;vp(b|0,f|0,64)|0;c[e+148>>2]=c[a+148>>2];return e|0}function cW(a,b,d,e,f){a=a|0;b=+b;d=+d;e=e|0;f=+f;var h=0,i=0.0,j=0.0,k=0,l=0,m=0.0,n=0.0,o=0.0;h=a+148|0;c[h>>2]=4;i=-0.0-b;j=-0.0-d;g[a+20>>2]=i;g[a+24>>2]=j;g[a+28>>2]=b;g[a+32>>2]=j;g[a+36>>2]=b;g[a+40>>2]=d;g[a+44>>2]=i;g[a+48>>2]=d;g[a+84>>2]=0.0;g[a+88>>2]=-1.0;g[a+92>>2]=1.0;g[a+96>>2]=0.0;g[a+100>>2]=0.0;g[a+104>>2]=1.0;g[a+108>>2]=-1.0;g[a+112>>2]=0.0;k=e;e=a+12|0;l=c[k+4>>2]|0;c[e>>2]=c[k>>2];c[e+4>>2]=l;d=+g[k>>2];i=+g[k+4>>2];b=+S(+f);m=+R(+f);k=0;f=j;j=-1.0;while(1){l=a+20+(k<<3)|0;n=+g[l>>2];e=l;o=+(i+(b*n+m*f));g[e>>2]=d+(m*n-b*f);g[e+4>>2]=o;e=a+84+(k<<3)|0;o=+g[e>>2];l=e;n=+(b*o+m*j);g[l>>2]=m*o-b*j;g[l+4>>2]=n;l=k+1|0;if((l|0)>=(c[h>>2]|0)){break}k=l;f=+g[a+20+(l<<3)+4>>2];j=+g[a+84+(l<<3)+4>>2]}return}function cX(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0,l=0;if((e|0)<=-1){ba(6208,89,14624,5952)}f=b+16|0;if(((c[f>>2]|0)-1|0)<=(e|0)){ba(6208,89,14624,5952)}c[d+4>>2]=1;g[d+8>>2]=+g[b+8>>2];h=b+12|0;i=(c[h>>2]|0)+(e<<3)|0;j=d+12|0;k=c[i+4>>2]|0;c[j>>2]=c[i>>2];c[j+4>>2]=k;k=(c[h>>2]|0)+(e+1<<3)|0;j=d+20|0;i=c[k+4>>2]|0;c[j>>2]=c[k>>2];c[j+4>>2]=i;i=d+28|0;if((e|0)>0){j=(c[h>>2]|0)+(e-1<<3)|0;k=i;l=c[j+4>>2]|0;c[k>>2]=c[j>>2];c[k+4>>2]=l;a[d+44|0]=1}else{l=b+20|0;k=i;i=c[l+4>>2]|0;c[k>>2]=c[l>>2];c[k+4>>2]=i;a[d+44|0]=a[b+36|0]&1}i=d+36|0;if(((c[f>>2]|0)-2|0)>(e|0)){f=(c[h>>2]|0)+(e+2<<3)|0;e=i;h=c[f+4>>2]|0;c[e>>2]=c[f>>2];c[e+4>>2]=h;a[d+45|0]=1;return}else{h=b+28|0;e=i;i=c[h+4>>2]|0;c[e>>2]=c[h>>2];c[e+4>>2]=i;a[d+45|0]=a[b+37|0]&1;return}}function cY(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0;h=i;i=i+48|0;j=h|0;k=c[a+16>>2]|0;if((k|0)>(f|0)){c[j>>2]=20512;c[j+4>>2]=1;g[j+8>>2]=.009999999776482582;vq(j+28|0,0,18);l=f+1|0;m=c[a+12>>2]|0;a=m+(f<<3)|0;f=j+12|0;n=c[a+4>>2]|0;c[f>>2]=c[a>>2];c[f+4>>2]=n;n=m+(((l|0)==(k|0)?0:l)<<3)|0;l=j+20|0;k=c[n+4>>2]|0;c[l>>2]=c[n>>2];c[l+4>>2]=k;k=cT(j,b,d,e,0)|0;i=h;return k|0}else{ba(6208,129,14512,5512);return 0}return 0}function cZ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;f=c[a+16>>2]|0;if((f|0)>(e|0)){h=e+1|0;i=(h|0)==(f|0)?0:h;h=c[a+12>>2]|0;j=+g[d+12>>2];k=+g[h+(e<<3)>>2];l=+g[d+8>>2];m=+g[h+(e<<3)+4>>2];n=+g[d>>2];o=n+(j*k-l*m);p=+g[d+4>>2];q=k*l+j*m+p;m=+g[h+(i<<3)>>2];k=+g[h+(i<<3)+4>>2];r=n+(j*m-l*k);n=p+(l*m+j*k);i=b;k=+(q<n?q:n);g[i>>2]=o<r?o:r;g[i+4>>2]=k;i=b+8|0;k=+(q>n?q:n);g[i>>2]=o>r?o:r;g[i+4>>2]=k;return}else{ba(6208,148,14688,5512)}}function c_(a){a=a|0;return}function c$(a){a=a|0;return}function c0(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function c1(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function c2(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;return}function c3(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;return}function c4(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function c5(a,b){a=a|0;b=b|0;return}function c6(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0,m=0;e=+g[d>>2]- +g[b>>2];f=+g[d+4>>2]- +g[b+4>>2];h=+g[b+12>>2];i=+g[b+8>>2];j=e*h+f*i;k=h*f+e*(-0.0-i);b=c[a+148>>2]|0;d=0;while(1){if((d|0)>=(b|0)){l=1;m=926;break}if((j- +g[a+20+(d<<3)>>2])*+g[a+84+(d<<3)>>2]+(k- +g[a+20+(d<<3)+4>>2])*+g[a+84+(d<<3)+4>>2]>0.0){l=0;m=925;break}else{d=d+1|0}}if((m|0)==925){return l|0}else if((m|0)==926){return l|0}return 0}function c7(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0;f=+g[d+12>>2];h=+g[a+20>>2];i=+g[d+8>>2];j=+g[a+24>>2];k=+g[d>>2];l=k+(f*h-i*j);m=+g[d+4>>2];n=h*i+f*j+m;d=c[a+148>>2]|0;if((d|0)>1){j=n;h=l;o=n;p=l;e=1;while(1){q=+g[a+20+(e<<3)>>2];r=+g[a+20+(e<<3)+4>>2];s=k+(f*q-i*r);t=q*i+f*r+m;r=h<s?h:s;q=j<t?j:t;u=p>s?p:s;s=o>t?o:t;v=e+1|0;if((v|0)<(d|0)){j=q;h=r;o=s;p=u;e=v}else{w=q;x=r;y=s;z=u;break}}}else{w=n;x=l;y=n;z=l}l=+g[a+8>>2];a=b;n=+(w-l);g[a>>2]=x-l;g[a+4>>2]=n;a=b+8|0;n=+(y+l);g[a>>2]=z+l;g[a+4>>2]=n;return}function c8(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0;d=+g[b+16>>2];e=+g[b+32>>2];f=+g[b+20>>2];h=+g[b+28>>2];i=d*e-f*h;j=+g[b+24>>2];k=+g[b+12>>2];l=f*j-e*k;m=h*k-d*j;n=+g[b>>2];o=+g[b+4>>2];p=+g[b+8>>2];q=i*n+o*l+m*p;if(q!=0.0){r=1.0/q}else{r=q}q=+g[c>>2];s=+g[c+4>>2];t=+g[c+8>>2];g[a>>2]=r*(i*q+s*l+m*t);g[a+4>>2]=r*((s*e-t*h)*n+o*(t*j-e*q)+(h*q-s*j)*p);g[a+8>>2]=r*((d*t-f*s)*n+o*(f*q-t*k)+(s*k-d*q)*p);return}function c9(a){a=a|0;vl(a);return}function da(a){a=a|0;vl(a);return}function db(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d|0;f=e;c[f>>2]=b;c[f+4>>2]=0;a2(a|0,e|0)|0;i=d;return}function dc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0.0;if((d-3|0)>>>0>=6){ba(5664,122,17936,11096)}e=a+148|0;c[e>>2]=d;d=0;do{f=b+(d<<3)|0;h=a+20+(d<<3)|0;i=c[f+4>>2]|0;c[h>>2]=c[f>>2];c[h+4>>2]=i;d=d+1|0;j=c[e>>2]|0;}while((d|0)<(j|0));if((j|0)>0){k=j;l=0}else{ba(5664,76,18928,5016)}while(1){j=l+1|0;d=(j|0)<(k|0)?j:0;m=+g[a+20+(d<<3)>>2]- +g[a+20+(l<<3)>>2];n=+g[a+20+(d<<3)+4>>2]- +g[a+20+(l<<3)+4>>2];if(m*m+n*n<=1.4210854715202004e-14){o=943;break}d=a+84+(l<<3)|0;b=d;p=+(m*-1.0);g[b>>2]=n;g[b+4>>2]=p;b=a+84+(l<<3)+4|0;p=+g[b>>2];m=+P(+(n*n+p*p));if(m>=1.1920928955078125e-7){q=1.0/m;g[d>>2]=n*q;g[b>>2]=p*q}r=c[e>>2]|0;if((j|0)<(r|0)){k=r;l=j}else{break}}if((o|0)==943){ba(5664,137,17936,8512)}o=a+12|0;l=a+20|0;if((r|0)>2){s=0;t=0.0;u=0.0;v=0.0}else{ba(5664,76,18928,5016)}do{k=a+20+(s<<3)|0;q=+g[k>>2];p=+g[k+4>>2];s=s+1|0;k=(s|0)<(r|0);if(k){w=a+20+(s<<3)|0}else{w=l}e=w;n=+g[e>>2];m=+g[e+4>>2];x=(q*m-p*n)*.5;t=t+x;y=x*.3333333432674408;u=u+(q+0.0+n)*y;v=v+(p+0.0+m)*y}while(k);if(t>1.1920928955078125e-7){y=1.0/t;w=o;t=+(v*y);g[w>>2]=u*y;g[w+4>>2]=t;return}else{ba(5664,115,18928,5488)}}function dd(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0,w=0.0,x=0,y=0.0;h=+g[e>>2];i=+g[d>>2]-h;j=+g[e+4>>2];k=+g[d+4>>2]-j;f=e+12|0;l=+g[f>>2];m=e+8|0;n=+g[m>>2];o=i*l+k*n;p=-0.0-n;q=l*k+i*p;i=+g[d+8>>2]-h;h=+g[d+12>>2]-j;j=l*i+n*h-o;n=i*p+l*h-q;h=+g[d+16>>2];d=c[a+148>>2]|0;l=0.0;e=0;r=-1;p=h;L1236:while(1){if((e|0)>=(d|0)){s=967;break}i=+g[a+84+(e<<3)>>2];k=+g[a+84+(e<<3)+4>>2];t=(+g[a+20+(e<<3)>>2]-o)*i+(+g[a+20+(e<<3)+4>>2]-q)*k;u=j*i+n*k;L1239:do{if(u==0.0){if(t<0.0){v=0;s=972;break L1236}else{w=l;x=r;y=p}}else{do{if(u<0.0){if(t>=l*u){break}w=t/u;x=e;y=p;break L1239}}while(0);if(u<=0.0){w=l;x=r;y=p;break}if(t>=p*u){w=l;x=r;y=p;break}w=l;x=r;y=t/u}}while(0);if(y<w){v=0;s=975;break}else{l=w;e=e+1|0;r=x;p=y}}if((s|0)==975){return v|0}else if((s|0)==972){return v|0}else if((s|0)==967){if(l<0.0|l>h){ba(5664,249,13872,6584);return 0}if((r|0)<=-1){v=0;return v|0}g[b+8>>2]=l;l=+g[f>>2];h=+g[a+84+(r<<3)>>2];y=+g[m>>2];p=+g[a+84+(r<<3)+4>>2];r=b;w=+(h*y+l*p);g[r>>2]=l*h-y*p;g[r+4>>2]=w;v=1;return v|0}return 0}function de(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0.0,h=0.0,i=0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0;e=c[a+148>>2]|0;if((e|0)>2){f=0.0;h=0.0;i=0}else{ba(5664,306,13992,5928)}do{h=h+ +g[a+20+(i<<3)>>2];f=f+ +g[a+20+(i<<3)+4>>2];i=i+1|0;}while((i|0)<(e|0));j=1.0/+(e|0);k=h*j;h=f*j;i=a+20|0;l=a+24|0;j=0.0;f=0.0;m=0;n=0.0;o=0.0;do{p=+g[a+20+(m<<3)>>2]-k;q=+g[a+20+(m<<3)+4>>2]-h;m=m+1|0;r=(m|0)<(e|0);if(r){s=a+20+(m<<3)|0;t=a+20+(m<<3)+4|0}else{s=i;t=l}u=+g[s>>2]-k;v=+g[t>>2]-h;w=p*v-q*u;x=w*.5;o=o+x;y=x*.3333333432674408;f=f+(p+u)*y;j=j+(q+v)*y;n=n+w*.0833333358168602*(u*u+(p*p+p*u)+(v*v+(q*q+q*v)))}while(r);v=o*d;g[b>>2]=v;if(o>1.1920928955078125e-7){q=1.0/o;o=f*q;f=j*q;q=k+o;k=h+f;t=b+4|0;h=+k;g[t>>2]=q;g[t+4>>2]=h;g[b+12>>2]=n*d+v*(q*q+k*k-(o*o+f*f));return}else{ba(5664,352,13992,5488)}}function df(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;if((d|0)==0){e=0;return e|0}if((d|0)<=0){ba(5352,104,17408,8376);return 0}if((d|0)>640){e=vh(d)|0;return e|0}f=a[d+22064|0]|0;d=f&255;if((f&255)>=14){ba(5352,112,17408,6544);return 0}f=b+12+(d<<2)|0;g=c[f>>2]|0;if((g|0)!=0){c[f>>2]=c[g>>2];e=g;return e|0}g=b+4|0;h=c[g>>2]|0;i=b+8|0;j=b|0;if((h|0)==(c[i>>2]|0)){b=c[j>>2]|0;k=h+128|0;c[i>>2]=k;i=vh(k<<3)|0;c[j>>2]=i;k=b;b=c[g>>2]<<3;vp(i|0,k|0,b)|0;vq((c[j>>2]|0)+(c[g>>2]<<3)|0,0,1024);vi(k);l=c[g>>2]|0}else{l=h}h=c[j>>2]|0;j=vh(16384)|0;k=h+(l<<3)+4|0;c[k>>2]=j;b=c[22712+(d<<2)>>2]|0;c[h+(l<<3)>>2]=b;l=16384/(b|0)&-1;if(($(l,b)|0)>=16385){ba(5352,140,17408,5888);return 0}h=l-1|0;if((h|0)>0){l=0;d=j;while(1){i=d+($(l,b)|0)|0;m=l+1|0;c[i>>2]=d+($(m,b)|0);i=c[k>>2]|0;if((m|0)<(h|0)){l=m;d=i}else{n=i;break}}}else{n=j}c[n+($(h,b)|0)>>2]=0;c[f>>2]=c[c[k>>2]>>2];c[g>>2]=(c[g>>2]|0)+1;e=c[k>>2]|0;return e|0}function dg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=b+102796|0;f=c[e>>2]|0;if((f|0)<=0){ba(4840,63,17080,5864)}g=f-1|0;if((c[b+102412+(g*12&-1)>>2]|0)!=(d|0)){ba(4840,65,17080,5464)}if((a[b+102412+(g*12&-1)+8|0]&1)==0){h=b+102412+(g*12&-1)+4|0;i=b+102400|0;c[i>>2]=(c[i>>2]|0)-(c[h>>2]|0);j=f;k=h}else{vi(d);j=c[e>>2]|0;k=b+102412+(g*12&-1)+4|0}g=b+102404|0;c[g>>2]=(c[g>>2]|0)-(c[k>>2]|0);c[e>>2]=j-1;return}function dh(d,e,f){d=d|0;e=e|0;f=f|0;var h=0,i=0.0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;h=e+4|0;i=+g[h>>2];if(!(i==i&!(C=0.0,C!=C)&i>+-p&i<+p)){ba(4720,27,15920,10600)}i=+g[e+8>>2];if(!(i==i&!(C=0.0,C!=C)&i>+-p&i<+p)){ba(4720,27,15920,10600)}j=e+16|0;i=+g[j>>2];if(!(i==i&!(C=0.0,C!=C)&i>+-p&i<+p)){ba(4720,28,15920,7920)}i=+g[e+20>>2];if(!(i==i&!(C=0.0,C!=C)&i>+-p&i<+p)){ba(4720,28,15920,7920)}k=e+12|0;i=+g[k>>2];if(!(i==i&!(C=0.0,C!=C)&i>+-p&i<+p)){ba(4720,29,15920,6424)}l=e+24|0;i=+g[l>>2];if(!(i==i&!(C=0.0,C!=C)&i>+-p&i<+p)){ba(4720,30,15920,5832)}m=e+32|0;i=+g[m>>2];if(i<0.0|i==i&!(C=0.0,C!=C)&i>+-p&i<+p^1){ba(4720,31,15920,5400)}n=e+28|0;i=+g[n>>2];if(i<0.0|i==i&!(C=0.0,C!=C)&i>+-p&i<+p^1){ba(4720,32,15920,4952)}o=d+4|0;b[o>>1]=0;if((a[e+39|0]&1)==0){q=0}else{b[o>>1]=8;q=8}if((a[e+38|0]&1)==0){r=q}else{s=q|16;b[o>>1]=s;r=s}if((a[e+36|0]&1)==0){t=r}else{s=r|4;b[o>>1]=s;t=s}if((a[e+37|0]&1)==0){u=t}else{s=t|2;b[o>>1]=s;u=s}if((a[e+40|0]&1)!=0){b[o>>1]=u|32}c[d+88>>2]=f;f=h;h=d+12|0;u=c[f>>2]|0;o=c[f+4>>2]|0;c[h>>2]=u;c[h+4>>2]=o;i=+g[k>>2];g[d+20>>2]=+S(+i);g[d+24>>2]=+R(+i);g[d+28>>2]=0.0;g[d+32>>2]=0.0;h=d+36|0;c[h>>2]=u;c[h+4>>2]=o;h=d+44|0;c[h>>2]=u;c[h+4>>2]=o;g[d+52>>2]=+g[k>>2];g[d+56>>2]=+g[k>>2];g[d+60>>2]=0.0;c[d+108>>2]=0;c[d+112>>2]=0;c[d+92>>2]=0;c[d+96>>2]=0;k=j;j=d+64|0;o=c[k+4>>2]|0;c[j>>2]=c[k>>2];c[j+4>>2]=o;g[d+72>>2]=+g[l>>2];g[d+132>>2]=+g[n>>2];g[d+136>>2]=+g[m>>2];g[d+140>>2]=+g[e+48>>2];g[d+76>>2]=0.0;g[d+80>>2]=0.0;g[d+84>>2]=0.0;g[d+144>>2]=0.0;m=c[e>>2]|0;c[d>>2]=m;n=d+116|0;if((m|0)==2){g[n>>2]=1.0;g[d+120>>2]=1.0;v=d+124|0;g[v>>2]=0.0;w=d+128|0;g[w>>2]=0.0;x=e+44|0;y=c[x>>2]|0;z=d+148|0;c[z>>2]=y;A=d+100|0;c[A>>2]=0;B=d+104|0;c[B>>2]=0;return}else{g[n>>2]=0.0;g[d+120>>2]=0.0;v=d+124|0;g[v>>2]=0.0;w=d+128|0;g[w>>2]=0.0;x=e+44|0;y=c[x>>2]|0;z=d+148|0;c[z>>2]=y;A=d+100|0;c[A>>2]=0;B=d+104|0;c[B>>2]=0;return}}function di(a,d){a=a|0;d=d|0;var e=0,f=0,h=0,j=0,l=0.0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0;e=i;i=i+16|0;f=e|0;h=a+88|0;if((c[(c[h>>2]|0)+102868>>2]&2|0)!=0){ba(4720,115,16e3,4688)}j=a|0;if((c[j>>2]|0)==(d|0)){i=e;return}c[j>>2]=d;dj(a);do{if((c[j>>2]|0)==0){g[a+64>>2]=0.0;g[a+68>>2]=0.0;g[a+72>>2]=0.0;l=+g[a+56>>2];g[a+52>>2]=l;d=a+44|0;m=a+36|0;n=c[d>>2]|0;o=c[d+4>>2]|0;c[m>>2]=n;c[m+4>>2]=o;m=f|0;d=f;p=f+8|0;q=+S(+l);g[p>>2]=q;r=+R(+l);g[p+4>>2]=r;l=+g[a+28>>2];s=+g[a+32>>2];t=+((c[k>>2]=o,+g[k>>2])-(q*l+r*s));g[m>>2]=(c[k>>2]=n,+g[k>>2])-(r*l-q*s);g[m+4>>2]=t;m=(c[h>>2]|0)+102872|0;n=c[a+100>>2]|0;if((n|0)==0){break}o=a+12|0;p=n;do{dH(p,m,d,o);p=c[p+4>>2]|0;}while((p|0)!=0)}}while(0);h=a+4|0;f=b[h>>1]|0;if((f&2)==0){b[h>>1]=f|2;g[a+144>>2]=0.0}g[a+76>>2]=0.0;g[a+80>>2]=0.0;g[a+84>>2]=0.0;f=c[a+100>>2]|0;if((f|0)==0){i=e;return}else{u=f}do{dI(u);u=c[u+4>>2]|0;}while((u|0)!=0);i=e;return}function dj(a){a=a|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0.0,A=0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0;d=i;i=i+16|0;e=d|0;f=a+116|0;h=a+120|0;j=a+124|0;k=a+128|0;l=a+28|0;g[l>>2]=0.0;g[a+32>>2]=0.0;vq(f|0,0,16);m=c[a>>2]|0;if((m|0)==2){n=4200;o=+g[n>>2];p=+g[n+4>>2];n=c[a+100>>2]|0;do{if((n|0)==0){q=0.0;r=o;s=p;t=1074}else{u=e|0;v=e+4|0;w=e+8|0;x=e+12|0;y=p;z=o;A=n;B=0.0;C=0.0;while(1){D=+g[A>>2];if(D==0.0){E=z;F=y;G=B;H=C}else{I=c[A+12>>2]|0;bN[c[(c[I>>2]|0)+28>>2]&127](I,e,D);D=+g[u>>2];J=D+ +g[f>>2];g[f>>2]=J;K=z+D*+g[v>>2];L=y+D*+g[w>>2];D=+g[x>>2]+ +g[j>>2];g[j>>2]=D;E=K;F=L;G=J;H=D}I=c[A+4>>2]|0;if((I|0)==0){break}else{y=F;z=E;A=I;B=G;C=H}}if(G<=0.0){q=H;r=E;s=F;t=1074;break}C=1.0/G;g[h>>2]=C;M=E*C;N=F*C;O=G;P=H}}while(0);if((t|0)==1074){g[f>>2]=1.0;g[h>>2]=1.0;M=r;N=s;O=1.0;P=q}do{if(P>0.0){if((b[a+4>>1]&16)!=0){t=1080;break}q=P-(N*N+M*M)*O;g[j>>2]=q;if(q>0.0){Q=1.0/q;break}else{ba(4720,319,16088,11792)}}else{t=1080}}while(0);if((t|0)==1080){g[j>>2]=0.0;Q=0.0}g[k>>2]=Q;k=a+44|0;Q=+g[k>>2];O=+g[k+4>>2];j=l;P=+N;g[j>>2]=M;g[j+4>>2]=P;P=+g[a+24>>2];q=+g[a+20>>2];s=+g[a+12>>2]+(P*M-q*N);r=M*q+P*N+ +g[a+16>>2];N=+s;P=+r;g[k>>2]=N;g[k+4>>2]=P;k=a+36|0;g[k>>2]=N;g[k+4>>2]=P;P=+g[a+72>>2];k=a+64|0;g[k>>2]=+g[k>>2]+(r-O)*(-0.0-P);k=a+68|0;g[k>>2]=P*(s-Q)+ +g[k>>2];i=d;return}else if((m|0)==0|(m|0)==1){m=a+12|0;k=a+36|0;j=c[m>>2]|0;l=c[m+4>>2]|0;c[k>>2]=j;c[k+4>>2]=l;k=a+44|0;c[k>>2]=j;c[k+4>>2]=l;g[a+52>>2]=+g[a+56>>2];i=d;return}else{ba(4720,284,16088,12360)}}function dk(d,e){d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;f=d+88|0;h=c[f>>2]|0;if((c[h+102868>>2]&2|0)!=0){ba(4720,153,16120,4688);return 0}i=h|0;h=df(i,44)|0;if((h|0)==0){j=0}else{b[h+32>>1]=1;b[h+34>>1]=-1;b[h+36>>1]=0;c[h+40>>2]=0;c[h+24>>2]=0;c[h+28>>2]=0;vq(h|0,0,16);j=h}c[j+40>>2]=c[e+4>>2];g[j+16>>2]=+g[e+8>>2];g[j+20>>2]=+g[e+12>>2];h=j+8|0;c[h>>2]=d;k=j+4|0;c[k>>2]=0;l=j+32|0;m=e+22|0;b[l>>1]=b[m>>1]|0;b[l+2>>1]=b[m+2>>1]|0;b[l+4>>1]=b[m+4>>1]|0;a[j+38|0]=a[e+20|0]&1;m=c[e>>2]|0;l=bF[c[(c[m>>2]|0)+8>>2]&255](m,i)|0;m=j+12|0;c[m>>2]=l;n=bq[c[(c[l>>2]|0)+12>>2]&1023](l)|0;l=df(i,n*28&-1)|0;i=j+24|0;c[i>>2]=l;do{if((n|0)>0){c[l+16>>2]=0;c[(c[i>>2]|0)+24>>2]=-1;if((n|0)>1){o=1}else{break}do{c[(c[i>>2]|0)+(o*28&-1)+16>>2]=0;c[(c[i>>2]|0)+(o*28&-1)+24>>2]=-1;o=o+1|0;}while((o|0)<(n|0))}}while(0);n=j+28|0;c[n>>2]=0;o=j|0;g[o>>2]=+g[e+16>>2];do{if((b[d+4>>1]&32)!=0){e=(c[f>>2]|0)+102872|0;l=d+12|0;p=c[m>>2]|0;q=bq[c[(c[p>>2]|0)+12>>2]&1023](p)|0;c[n>>2]=q;if((q|0)>0){r=0}else{break}do{q=c[i>>2]|0;p=q+(r*28&-1)|0;s=c[m>>2]|0;t=p|0;bO[c[(c[s>>2]|0)+24>>2]&127](s,t,l,r);c[q+(r*28&-1)+24>>2]=b4(e,t,p)|0;c[q+(r*28&-1)+16>>2]=j;c[q+(r*28&-1)+20>>2]=r;r=r+1|0;}while((r|0)<(c[n>>2]|0))}}while(0);n=d+100|0;c[k>>2]=c[n>>2];c[n>>2]=j;n=d+104|0;c[n>>2]=(c[n>>2]|0)+1;c[h>>2]=d;if(+g[o>>2]<=0.0){u=c[f>>2]|0;v=u+102868|0;w=c[v>>2]|0;x=w|1;c[v>>2]=x;return j|0}dj(d);u=c[f>>2]|0;v=u+102868|0;w=c[v>>2]|0;x=w|1;c[v>>2]=x;return j|0}function dl(a){a=a|0;return}function dm(a){a=a|0;return}function dn(a){a=a|0;var d=0,e=0,f=0,j=0.0,k=0,l=0;d=i;e=a+8|0;f=c[e>>2]|0;db(11584,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(11232,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(11032,(u=i,i=i+8|0,c[u>>2]=c[a>>2],u)|0);j=+g[a+16>>2];db(10864,(u=i,i=i+16|0,h[u>>3]=+g[a+12>>2],h[u+8>>3]=j,u)|0);db(10576,(u=i,i=i+8|0,h[u>>3]=+g[a+56>>2],u)|0);j=+g[a+68>>2];db(10464,(u=i,i=i+16|0,h[u>>3]=+g[a+64>>2],h[u+8>>3]=j,u)|0);db(10320,(u=i,i=i+8|0,h[u>>3]=+g[a+72>>2],u)|0);db(10064,(u=i,i=i+8|0,h[u>>3]=+g[a+132>>2],u)|0);db(9640,(u=i,i=i+8|0,h[u>>3]=+g[a+136>>2],u)|0);k=a+4|0;db(9568,(u=i,i=i+8|0,c[u>>2]=b[k>>1]&4,u)|0);db(9144,(u=i,i=i+8|0,c[u>>2]=b[k>>1]&2,u)|0);db(8864,(u=i,i=i+8|0,c[u>>2]=b[k>>1]&16,u)|0);db(8712,(u=i,i=i+8|0,c[u>>2]=b[k>>1]&8,u)|0);db(8344,(u=i,i=i+8|0,c[u>>2]=b[k>>1]&32,u)|0);db(8128,(u=i,i=i+8|0,h[u>>3]=+g[a+140>>2],u)|0);db(7840,(u=i,i=i+8|0,c[u>>2]=c[e>>2],u)|0);db(7344,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);e=c[a+100>>2]|0;if((e|0)==0){db(11328,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);i=d;return}else{l=e}do{db(7480,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);dJ(l,f);db(7352,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);l=c[l+4>>2]|0;}while((l|0)!=0);db(11328,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);i=d;return}function dp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;d=c[(c[b+48>>2]|0)+8>>2]|0;e=c[(c[b+52>>2]|0)+8>>2]|0;f=c[a+72>>2]|0;do{if((f|0)!=0){if((c[b+4>>2]&2|0)==0){break}bp[c[(c[f>>2]|0)+12>>2]&511](f,b)}}while(0);f=b+8|0;g=c[f>>2]|0;h=b+12|0;if((g|0)!=0){c[g+12>>2]=c[h>>2]}g=c[h>>2]|0;if((g|0)!=0){c[g+8>>2]=c[f>>2]}f=a+60|0;if((c[f>>2]|0)==(b|0)){c[f>>2]=c[h>>2]}h=b+24|0;f=c[h>>2]|0;g=b+28|0;if((f|0)!=0){c[f+12>>2]=c[g>>2]}f=c[g>>2]|0;if((f|0)!=0){c[f+8>>2]=c[h>>2]}h=d+112|0;if((b+16|0)==(c[h>>2]|0)){c[h>>2]=c[g>>2]}g=b+40|0;h=c[g>>2]|0;d=b+44|0;if((h|0)!=0){c[h+12>>2]=c[d>>2]}h=c[d>>2]|0;if((h|0)!=0){c[h+8>>2]=c[g>>2]}g=e+112|0;if((b+32|0)!=(c[g>>2]|0)){i=a+76|0;j=c[i>>2]|0;em(b,j);k=a+64|0;l=c[k>>2]|0;m=l-1|0;c[k>>2]=m;return}c[g>>2]=c[d>>2];i=a+76|0;j=c[i>>2]|0;em(b,j);k=a+64|0;l=c[k>>2]|0;m=l-1|0;c[k>>2]=m;return}function dq(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;f=d+88|0;if((c[(c[f>>2]|0)+102868>>2]&2|0)!=0){ba(4720,201,16040,4688)}g=e+8|0;if((c[g>>2]|0)!=(d|0)){ba(4720,207,16040,4464)}h=d+104|0;if((c[h>>2]|0)<=0){ba(4720,210,16040,4208)}i=d+100|0;while(1){j=c[i>>2]|0;if((j|0)==0){k=1141;break}if((j|0)==(e|0)){break}else{i=j+4|0}}if((k|0)==1141){ba(4720,226,16040,12760)}j=e+4|0;c[i>>2]=c[j>>2];i=c[d+112>>2]|0;if((i|0)!=0){l=i;do{i=c[l+4>>2]|0;l=c[l+12>>2]|0;if((c[i+48>>2]|0)==(e|0)|(c[i+52>>2]|0)==(e|0)){dp((c[f>>2]|0)+102872|0,i)}}while((l|0)!=0)}l=c[f>>2]|0;f=l|0;if((b[d+4>>1]&32)!=0){i=e+28|0;if((c[i>>2]|0)>0){m=e+24|0;n=l+102912|0;o=l+102904|0;p=l+102900|0;q=l+102872|0;r=0;do{s=(c[m>>2]|0)+(r*28&-1)+24|0;t=c[s>>2]|0;u=c[n>>2]|0;v=0;while(1){if((v|0)>=(u|0)){break}w=(c[o>>2]|0)+(v<<2)|0;if((c[w>>2]|0)==(t|0)){k=1151;break}else{v=v+1|0}}if((k|0)==1151){k=0;c[w>>2]=-1}c[p>>2]=(c[p>>2]|0)-1;cl(q,t);c[s>>2]=-1;r=r+1|0;}while((r|0)<(c[i>>2]|0))}c[i>>2]=0}dK(e,f);c[g>>2]=0;c[j>>2]=0;j=a[22108]|0;if((j&255)<14){g=l+12+((j&255)<<2)|0;c[e>>2]=c[g>>2];c[g>>2]=e;c[h>>2]=(c[h>>2]|0)-1;dj(d);return}else{ba(5352,173,17448,6544)}}function dr(a,d){a=a|0;d=d|0;var e=0,f=0,h=0,i=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0;if((c[(c[a+88>>2]|0)+102868>>2]&2|0)!=0){ba(4720,340,16232,4688)}if((c[a>>2]|0)!=2){return}e=a+120|0;g[e>>2]=0.0;f=a+124|0;g[f>>2]=0.0;h=a+128|0;g[h>>2]=0.0;i=+g[d>>2];j=i>0.0?i:1.0;g[a+116>>2]=j;g[e>>2]=1.0/j;i=+g[d+12>>2];do{if(i>0.0){if((b[a+4>>1]&16)!=0){break}l=+g[d+4>>2];m=+g[d+8>>2];n=i-j*(l*l+m*m);g[f>>2]=n;if(n>0.0){g[h>>2]=1.0/n;break}else{ba(4720,366,16232,11792)}}}while(0);h=a+44|0;j=+g[h>>2];i=+g[h+4>>2];f=d+4|0;d=a+28|0;e=c[f>>2]|0;o=c[f+4>>2]|0;c[d>>2]=e;c[d+4>>2]=o;n=+g[a+24>>2];m=(c[k>>2]=e,+g[k>>2]);l=+g[a+20>>2];p=(c[k>>2]=o,+g[k>>2]);q=+g[a+12>>2]+(n*m-l*p);r=m*l+n*p+ +g[a+16>>2];p=+q;n=+r;g[h>>2]=p;g[h+4>>2]=n;h=a+36|0;g[h>>2]=p;g[h+4>>2]=n;n=+g[a+72>>2];h=a+64|0;g[h>>2]=+g[h>>2]+(r-i)*(-0.0-n);h=a+68|0;g[h>>2]=n*(q-j)+ +g[h>>2];return}function ds(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0,h=0,i=0.0,j=0.0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0,v=0;e=a+88|0;f=c[e>>2]|0;if((c[f+102868>>2]&2|0)!=0){ba(4720,404,16176,4688)}h=a+12|0;i=+S(+d);g[a+20>>2]=i;j=+R(+d);g[a+24>>2]=j;l=b;b=h;m=c[l>>2]|0;n=c[l+4>>2]|0;c[b>>2]=m;c[b+4>>2]=n;o=+g[a+28>>2];p=+g[a+32>>2];b=a+44|0;q=+((c[k>>2]=m,+g[k>>2])+(j*o-i*p));r=+(o*i+j*p+(c[k>>2]=n,+g[k>>2]));g[b>>2]=q;g[b+4>>2]=r;g[a+56>>2]=d;b=a+36|0;g[b>>2]=q;g[b+4>>2]=r;g[a+52>>2]=d;b=f+102872|0;n=c[a+100>>2]|0;if((n|0)==0){s=f;t=s+102872|0;u=t|0;dy(u,t);return}else{v=n}do{dH(v,b,h,h);v=c[v+4>>2]|0;}while((v|0)!=0);s=c[e>>2]|0;t=s+102872|0;u=t|0;dy(u,t);return}function dt(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;e=a+88|0;f=c[e>>2]|0;if((c[f+102868>>2]&2|0)!=0){ba(4720,443,15968,4688)}g=a+4|0;h=b[g>>1]|0;if(!((h&32)!=0^d)){return}if(d){b[g>>1]=h|32;d=f+102872|0;i=c[a+100>>2]|0;if((i|0)==0){return}j=a+12|0;k=i;while(1){i=k+28|0;if((c[i>>2]|0)!=0){l=1184;break}m=k+12|0;n=c[m>>2]|0;o=bq[c[(c[n>>2]|0)+12>>2]&1023](n)|0;c[i>>2]=o;if((o|0)>0){o=k+24|0;n=0;do{p=c[o>>2]|0;q=p+(n*28&-1)|0;r=c[m>>2]|0;s=q|0;bO[c[(c[r>>2]|0)+24>>2]&127](r,s,j,n);c[p+(n*28&-1)+24>>2]=b4(d,s,q)|0;c[p+(n*28&-1)+16>>2]=k;c[p+(n*28&-1)+20>>2]=n;n=n+1|0;}while((n|0)<(c[i>>2]|0))}i=c[k+4>>2]|0;if((i|0)==0){l=1205;break}else{k=i}}if((l|0)==1205){return}else if((l|0)==1184){ba(12280,124,14968,12608)}}b[g>>1]=h&-33;h=c[a+100>>2]|0;if((h|0)!=0){g=f+102912|0;k=f+102904|0;d=f+102900|0;j=f+102872|0;f=h;do{h=f+28|0;if((c[h>>2]|0)>0){i=f+24|0;n=0;do{m=(c[i>>2]|0)+(n*28&-1)+24|0;o=c[m>>2]|0;p=c[g>>2]|0;q=0;while(1){if((q|0)>=(p|0)){break}t=(c[k>>2]|0)+(q<<2)|0;if((c[t>>2]|0)==(o|0)){l=1196;break}else{q=q+1|0}}if((l|0)==1196){l=0;c[t>>2]=-1}c[d>>2]=(c[d>>2]|0)-1;cl(j,o);c[m>>2]=-1;n=n+1|0;}while((n|0)<(c[h>>2]|0))}c[h>>2]=0;f=c[f+4>>2]|0;}while((f|0)!=0)}f=a+112|0;a=c[f>>2]|0;if((a|0)!=0){j=a;while(1){a=c[j+12>>2]|0;dp((c[e>>2]|0)+102872|0,c[j+4>>2]|0);if((a|0)==0){break}else{j=a}}}c[f>>2]=0;return}function du(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=c[a>>2]|0;e=c[b>>2]|0;if((d|0)<(e|0)){f=1;return f|0}if((d|0)!=(e|0)){f=0;return f|0}f=(c[a+4>>2]|0)<(c[b+4>>2]|0);return f|0}function dv(d,e,f){d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;h=c[e+16>>2]|0;i=c[f+16>>2]|0;j=c[e+20>>2]|0;e=c[f+20>>2]|0;f=c[h+8>>2]|0;k=c[i+8>>2]|0;if((f|0)==(k|0)){return}l=c[k+112>>2]|0;L1593:do{if((l|0)!=0){m=l;while(1){if((c[m>>2]|0)==(f|0)){n=c[m+4>>2]|0;o=c[n+48>>2]|0;p=c[n+52>>2]|0;q=c[n+56>>2]|0;r=c[n+60>>2]|0;if((o|0)==(h|0)&(p|0)==(i|0)&(q|0)==(j|0)&(r|0)==(e|0)){s=1241;break}if((o|0)==(i|0)&(p|0)==(h|0)&(q|0)==(e|0)&(r|0)==(j|0)){s=1247;break}}m=c[m+12>>2]|0;if((m|0)==0){break L1593}}if((s|0)==1241){return}else if((s|0)==1247){return}}}while(0);do{if((c[k>>2]|0)!=2){if((c[f>>2]|0)==2){break}return}}while(0);s=c[k+108>>2]|0;L1608:do{if((s|0)!=0){k=s;while(1){if((c[k>>2]|0)==(f|0)){if((a[(c[k+4>>2]|0)+61|0]&1)==0){break}}k=c[k+12>>2]|0;if((k|0)==0){break L1608}}return}}while(0);f=c[d+68>>2]|0;do{if((f|0)!=0){if(bv[c[(c[f>>2]|0)+8>>2]&127](f,h,i)|0){break}return}}while(0);f=el(h,j,i,e,c[d+76>>2]|0)|0;if((f|0)==0){return}e=c[(c[f+48>>2]|0)+8>>2]|0;i=c[(c[f+52>>2]|0)+8>>2]|0;c[f+8>>2]=0;j=d+60|0;c[f+12>>2]=c[j>>2];h=c[j>>2]|0;if((h|0)!=0){c[h+8>>2]=f}c[j>>2]=f;j=f+16|0;c[f+20>>2]=f;c[j>>2]=i;c[f+24>>2]=0;h=e+112|0;c[f+28>>2]=c[h>>2];s=c[h>>2]|0;if((s|0)!=0){c[s+8>>2]=j}c[h>>2]=j;j=f+32|0;c[f+36>>2]=f;c[j>>2]=e;c[f+40>>2]=0;h=i+112|0;c[f+44>>2]=c[h>>2];f=c[h>>2]|0;if((f|0)!=0){c[f+8>>2]=j}c[h>>2]=j;j=e+4|0;h=b[j>>1]|0;if((h&2)==0){b[j>>1]=h|2;g[e+144>>2]=0.0}e=i+4|0;h=b[e>>1]|0;if((h&2)==0){b[e>>1]=h|2;g[i+144>>2]=0.0}i=d+64|0;c[i>>2]=(c[i>>2]|0)+1;return}function dw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;e=i;i=i+1040|0;f=e|0;h=f+4|0;j=f|0;c[j>>2]=h;k=f+1028|0;c[k>>2]=0;l=f+1032|0;c[l>>2]=256;c[(c[j>>2]|0)+(c[k>>2]<<2)>>2]=c[a>>2];f=(c[k>>2]|0)+1|0;c[k>>2]=f;if((f|0)>0){m=a+4|0;a=d|0;n=d+4|0;o=d+8|0;p=d+12|0;d=b+56|0;q=b+52|0;r=b+48|0;s=b+44|0;b=f;while(1){f=b-1|0;c[k>>2]=f;t=c[j>>2]|0;u=c[t+(f<<2)>>2]|0;do{if((u|0)==-1){v=f}else{w=c[m>>2]|0;if(+g[a>>2]- +g[w+(u*36&-1)+8>>2]>0.0|+g[n>>2]- +g[w+(u*36&-1)+12>>2]>0.0|+g[w+(u*36&-1)>>2]- +g[o>>2]>0.0|+g[w+(u*36&-1)+4>>2]- +g[p>>2]>0.0){v=f;break}x=w+(u*36&-1)+24|0;if((c[x>>2]|0)==-1){y=c[d>>2]|0;if((y|0)==(u|0)){v=f;break}z=c[q>>2]|0;if((z|0)==(c[r>>2]|0)){A=c[s>>2]|0;c[r>>2]=z<<1;B=vh(z*24&-1)|0;c[s>>2]=B;C=A;A=(c[q>>2]|0)*12&-1;vp(B|0,C|0,A)|0;vi(C);D=c[d>>2]|0;E=c[q>>2]|0}else{D=y;E=z}c[(c[s>>2]|0)+(E*12&-1)>>2]=(D|0)>(u|0)?u:D;z=c[d>>2]|0;c[(c[s>>2]|0)+((c[q>>2]|0)*12&-1)+4>>2]=(z|0)<(u|0)?u:z;c[q>>2]=(c[q>>2]|0)+1;v=c[k>>2]|0;break}do{if((f|0)==(c[l>>2]|0)){c[l>>2]=f<<1;z=vh(f<<3)|0;c[j>>2]=z;y=t;C=c[k>>2]<<2;vp(z|0,y|0,C)|0;if((t|0)==(h|0)){break}vi(y)}}while(0);c[(c[j>>2]|0)+(c[k>>2]<<2)>>2]=c[x>>2];y=(c[k>>2]|0)+1|0;c[k>>2]=y;C=w+(u*36&-1)+28|0;do{if((y|0)==(c[l>>2]|0)){z=c[j>>2]|0;c[l>>2]=y<<1;A=vh(y<<3)|0;c[j>>2]=A;B=z;F=c[k>>2]<<2;vp(A|0,B|0,F)|0;if((z|0)==(h|0)){break}vi(B)}}while(0);c[(c[j>>2]|0)+(c[k>>2]<<2)>>2]=c[C>>2];y=(c[k>>2]|0)+1|0;c[k>>2]=y;v=y}}while(0);if((v|0)>0){b=v}else{break}}}v=c[j>>2]|0;if((v|0)==(h|0)){i=e;return}vi(v);c[j>>2]=0;i=e;return}function dx(d){d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;e=c[d+60>>2]|0;if((e|0)==0){return}f=d+12|0;h=d+4|0;i=d+72|0;j=d+68|0;k=e;L1672:while(1){e=c[k+48>>2]|0;l=c[k+52>>2]|0;m=c[k+56>>2]|0;n=c[k+60>>2]|0;o=c[e+8>>2]|0;p=c[l+8>>2]|0;q=k+4|0;r=c[q>>2]|0;L1674:do{if((r&8|0)==0){s=1287}else{if((c[p>>2]|0)==2){s=1276}else{if((c[o>>2]|0)==2){s=1276}}L1678:do{if((s|0)==1276){s=0;t=c[p+108>>2]|0;if((t|0)!=0){u=t;do{if((c[u>>2]|0)==(o|0)){if((a[(c[u+4>>2]|0)+61|0]&1)==0){break L1678}}u=c[u+12>>2]|0;}while((u|0)!=0)}u=c[j>>2]|0;do{if((u|0)==0){v=r}else{if(bv[c[(c[u>>2]|0)+8>>2]&127](u,e,l)|0){v=c[q>>2]|0;break}else{t=c[k+12>>2]|0;dp(d,k);w=t;break L1674}}}while(0);c[q>>2]=v&-9;s=1287;break L1674}}while(0);u=c[k+12>>2]|0;dp(d,k);w=u}}while(0);do{if((s|0)==1287){s=0;if((b[o+4>>1]&2)==0){x=0}else{x=(c[o>>2]|0)!=0&1}if((b[p+4>>1]&2)==0){y=1}else{y=(c[p>>2]|0)==0}if((x|0)==0&y){w=c[k+12>>2]|0;break}q=c[(c[e+24>>2]|0)+(m*28&-1)+24>>2]|0;r=c[(c[l+24>>2]|0)+(n*28&-1)+24>>2]|0;if((q|0)<=-1){s=1305;break L1672}u=c[f>>2]|0;if((u|0)<=(q|0)){s=1304;break L1672}t=c[h>>2]|0;if(!((r|0)>-1&(u|0)>(r|0))){s=1297;break L1672}if(+g[t+(r*36&-1)>>2]- +g[t+(q*36&-1)+8>>2]>0.0|+g[t+(r*36&-1)+4>>2]- +g[t+(q*36&-1)+12>>2]>0.0|+g[t+(q*36&-1)>>2]- +g[t+(r*36&-1)+8>>2]>0.0|+g[t+(q*36&-1)+4>>2]- +g[t+(r*36&-1)+12>>2]>0.0){r=c[k+12>>2]|0;dp(d,k);w=r;break}else{eh(k,c[i>>2]|0);w=c[k+12>>2]|0;break}}}while(0);if((w|0)==0){s=1302;break}else{k=w}}if((s|0)==1297){ba(10360,159,14456,9904)}else if((s|0)==1302){return}else if((s|0)==1304){ba(10360,159,14456,9904)}else if((s|0)==1305){ba(10360,159,14456,9904)}}function dy(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;d=i;i=i+8|0;e=d|0;f=a+52|0;c[f>>2]=0;g=a+40|0;h=c[g>>2]|0;do{if((h|0)>0){j=a+32|0;k=a+56|0;l=a|0;m=a+12|0;n=a+4|0;o=0;p=h;while(1){q=c[(c[j>>2]|0)+(o<<2)>>2]|0;c[k>>2]=q;if((q|0)==-1){r=p}else{if((q|0)<=-1){s=1329;break}if((c[m>>2]|0)<=(q|0)){s=1330;break}dw(l,a,(c[n>>2]|0)+(q*36&-1)|0);r=c[g>>2]|0}q=o+1|0;if((q|0)<(r|0)){o=q;p=r}else{s=1314;break}}if((s|0)==1314){t=c[f>>2]|0;break}else if((s|0)==1329){ba(10360,159,14456,9904)}else if((s|0)==1330){ba(10360,159,14456,9904)}}else{t=0}}while(0);c[g>>2]=0;g=a+44|0;r=c[g>>2]|0;c[e>>2]=122;dz(r,r+(t*12&-1)|0,e);if((c[f>>2]|0)<=0){i=d;return}e=a+12|0;t=a+4|0;a=0;L1735:while(1){r=c[g>>2]|0;h=r+(a*12&-1)|0;p=c[h>>2]|0;if((p|0)<=-1){s=1328;break}o=c[e>>2]|0;if((o|0)<=(p|0)){s=1327;break}n=c[t>>2]|0;l=r+(a*12&-1)+4|0;r=c[l>>2]|0;if(!((r|0)>-1&(o|0)>(r|0))){s=1321;break}dv(b,c[n+(p*36&-1)+16>>2]|0,c[n+(r*36&-1)+16>>2]|0);r=c[f>>2]|0;n=a;while(1){p=n+1|0;if((p|0)>=(r|0)){s=1331;break L1735}o=c[g>>2]|0;if((c[o+(p*12&-1)>>2]|0)!=(c[h>>2]|0)){a=p;continue L1735}if((c[o+(p*12&-1)+4>>2]|0)==(c[l>>2]|0)){n=p}else{a=p;continue L1735}}}if((s|0)==1321){ba(10360,153,14408,9904)}else if((s|0)==1331){i=d;return}else if((s|0)==1327){ba(10360,153,14408,9904)}else if((s|0)==1328){ba(10360,153,14408,9904)}}function dz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0;e=i;i=i+480|0;f=e|0;g=e+16|0;h=e+32|0;j=e+48|0;k=e+64|0;l=e+224|0;m=e+240|0;n=e+256|0;o=e+272|0;p=e+288|0;q=e+304|0;r=e+320|0;s=e+336|0;t=e+352|0;u=e+368|0;v=e+464|0;w=e+160|0;x=e+176|0;y=e+192|0;z=e+208|0;A=e+384|0;B=e+400|0;C=e+432|0;D=e+448|0;E=e+416|0;F=e+80|0;G=e+96|0;H=e+112|0;I=e+128|0;J=e+144|0;K=a;a=b;L1750:while(1){b=a;L=a-12|0;M=L;N=K;L1752:while(1){O=N;P=b-O|0;Q=(P|0)/12&-1;if((Q|0)==0|(Q|0)==1){R=1432;break L1750}else if((Q|0)==5){R=1347;break L1750}else if((Q|0)==4){R=1346;break L1750}else if((Q|0)==3){R=1338;break L1750}else if((Q|0)==2){R=1336;break L1750}if((P|0)<372){R=1353;break L1750}Q=(P|0)/24&-1;S=N+(Q*12&-1)|0;do{if((P|0)>11988){T=(P|0)/48&-1;U=N+(T*12&-1)|0;V=N+((T+Q|0)*12&-1)|0;T=dA(N,U,S,V,d)|0;if(!(bF[c[d>>2]&255](L,V)|0)){W=T;break}X=V;c[z>>2]=c[X>>2];c[z+4>>2]=c[X+4>>2];c[z+8>>2]=c[X+8>>2];c[X>>2]=c[M>>2];c[X+4>>2]=c[M+4>>2];c[X+8>>2]=c[M+8>>2];c[M>>2]=c[z>>2];c[M+4>>2]=c[z+4>>2];c[M+8>>2]=c[z+8>>2];if(!(bF[c[d>>2]&255](V,S)|0)){W=T+1|0;break}V=S;c[x>>2]=c[V>>2];c[x+4>>2]=c[V+4>>2];c[x+8>>2]=c[V+8>>2];c[V>>2]=c[X>>2];c[V+4>>2]=c[X+4>>2];c[V+8>>2]=c[X+8>>2];c[X>>2]=c[x>>2];c[X+4>>2]=c[x+4>>2];c[X+8>>2]=c[x+8>>2];if(!(bF[c[d>>2]&255](S,U)|0)){W=T+2|0;break}X=U;c[w>>2]=c[X>>2];c[w+4>>2]=c[X+4>>2];c[w+8>>2]=c[X+8>>2];c[X>>2]=c[V>>2];c[X+4>>2]=c[V+4>>2];c[X+8>>2]=c[V+8>>2];c[V>>2]=c[w>>2];c[V+4>>2]=c[w+4>>2];c[V+8>>2]=c[w+8>>2];if(!(bF[c[d>>2]&255](U,N)|0)){W=T+3|0;break}U=N;c[y>>2]=c[U>>2];c[y+4>>2]=c[U+4>>2];c[y+8>>2]=c[U+8>>2];c[U>>2]=c[X>>2];c[U+4>>2]=c[X+4>>2];c[U+8>>2]=c[X+8>>2];c[X>>2]=c[y>>2];c[X+4>>2]=c[y+4>>2];c[X+8>>2]=c[y+8>>2];W=T+4|0}else{T=bF[c[d>>2]&255](S,N)|0;X=bF[c[d>>2]&255](L,S)|0;if(!T){if(!X){W=0;break}T=S;c[J>>2]=c[T>>2];c[J+4>>2]=c[T+4>>2];c[J+8>>2]=c[T+8>>2];c[T>>2]=c[M>>2];c[T+4>>2]=c[M+4>>2];c[T+8>>2]=c[M+8>>2];c[M>>2]=c[J>>2];c[M+4>>2]=c[J+4>>2];c[M+8>>2]=c[J+8>>2];if(!(bF[c[d>>2]&255](S,N)|0)){W=1;break}U=N;c[H>>2]=c[U>>2];c[H+4>>2]=c[U+4>>2];c[H+8>>2]=c[U+8>>2];c[U>>2]=c[T>>2];c[U+4>>2]=c[T+4>>2];c[U+8>>2]=c[T+8>>2];c[T>>2]=c[H>>2];c[T+4>>2]=c[H+4>>2];c[T+8>>2]=c[H+8>>2];W=2;break}T=N;if(X){c[F>>2]=c[T>>2];c[F+4>>2]=c[T+4>>2];c[F+8>>2]=c[T+8>>2];c[T>>2]=c[M>>2];c[T+4>>2]=c[M+4>>2];c[T+8>>2]=c[M+8>>2];c[M>>2]=c[F>>2];c[M+4>>2]=c[F+4>>2];c[M+8>>2]=c[F+8>>2];W=1;break}c[G>>2]=c[T>>2];c[G+4>>2]=c[T+4>>2];c[G+8>>2]=c[T+8>>2];X=S;c[T>>2]=c[X>>2];c[T+4>>2]=c[X+4>>2];c[T+8>>2]=c[X+8>>2];c[X>>2]=c[G>>2];c[X+4>>2]=c[G+4>>2];c[X+8>>2]=c[G+8>>2];if(!(bF[c[d>>2]&255](L,S)|0)){W=1;break}c[I>>2]=c[X>>2];c[I+4>>2]=c[X+4>>2];c[I+8>>2]=c[X+8>>2];c[X>>2]=c[M>>2];c[X+4>>2]=c[M+4>>2];c[X+8>>2]=c[M+8>>2];c[M>>2]=c[I>>2];c[M+4>>2]=c[I+4>>2];c[M+8>>2]=c[I+8>>2];W=2}}while(0);do{if(bF[c[d>>2]&255](N,S)|0){Y=L;Z=W}else{Q=L;while(1){_=Q-12|0;if((N|0)==(_|0)){break}if(bF[c[d>>2]&255](_,S)|0){R=1395;break}else{Q=_}}if((R|0)==1395){R=0;Q=N;c[E>>2]=c[Q>>2];c[E+4>>2]=c[Q+4>>2];c[E+8>>2]=c[Q+8>>2];P=_;c[Q>>2]=c[P>>2];c[Q+4>>2]=c[P+4>>2];c[Q+8>>2]=c[P+8>>2];c[P>>2]=c[E>>2];c[P+4>>2]=c[E+4>>2];c[P+8>>2]=c[E+8>>2];Y=_;Z=W+1|0;break}P=N+12|0;if(bF[c[d>>2]&255](N,L)|0){$=P}else{Q=P;while(1){if((Q|0)==(L|0)){R=1422;break L1750}aa=Q+12|0;if(bF[c[d>>2]&255](N,Q)|0){break}else{Q=aa}}P=Q;c[D>>2]=c[P>>2];c[D+4>>2]=c[P+4>>2];c[D+8>>2]=c[P+8>>2];c[P>>2]=c[M>>2];c[P+4>>2]=c[M+4>>2];c[P+8>>2]=c[M+8>>2];c[M>>2]=c[D>>2];c[M+4>>2]=c[D+4>>2];c[M+8>>2]=c[D+8>>2];$=aa}if(($|0)==(L|0)){R=1416;break L1750}else{ab=L;ac=$}while(1){P=ac;while(1){ad=P+12|0;if(bF[c[d>>2]&255](N,P)|0){ae=ab;break}else{P=ad}}do{ae=ae-12|0;}while(bF[c[d>>2]&255](N,ae)|0);if(P>>>0>=ae>>>0){N=P;continue L1752}X=P;c[C>>2]=c[X>>2];c[C+4>>2]=c[X+4>>2];c[C+8>>2]=c[X+8>>2];T=ae;c[X>>2]=c[T>>2];c[X+4>>2]=c[T+4>>2];c[X+8>>2]=c[T+8>>2];c[T>>2]=c[C>>2];c[T+4>>2]=c[C+4>>2];c[T+8>>2]=c[C+8>>2];ab=ae;ac=ad}}}while(0);Q=N+12|0;L1795:do{if(Q>>>0<Y>>>0){T=Y;X=Q;U=Z;V=S;while(1){af=X;while(1){ag=af+12|0;if(bF[c[d>>2]&255](af,V)|0){af=ag}else{ah=T;break}}do{ah=ah-12|0;}while(!(bF[c[d>>2]&255](ah,V)|0));if(af>>>0>ah>>>0){ai=af;aj=U;ak=V;break L1795}P=af;c[B>>2]=c[P>>2];c[B+4>>2]=c[P+4>>2];c[B+8>>2]=c[P+8>>2];al=ah;c[P>>2]=c[al>>2];c[P+4>>2]=c[al+4>>2];c[P+8>>2]=c[al+8>>2];c[al>>2]=c[B>>2];c[al+4>>2]=c[B+4>>2];c[al+8>>2]=c[B+8>>2];T=ah;X=ag;U=U+1|0;V=(V|0)==(af|0)?ah:V}}else{ai=Q;aj=Z;ak=S}}while(0);do{if((ai|0)==(ak|0)){am=aj}else{if(!(bF[c[d>>2]&255](ak,ai)|0)){am=aj;break}S=ai;c[A>>2]=c[S>>2];c[A+4>>2]=c[S+4>>2];c[A+8>>2]=c[S+8>>2];Q=ak;c[S>>2]=c[Q>>2];c[S+4>>2]=c[Q+4>>2];c[S+8>>2]=c[Q+8>>2];c[Q>>2]=c[A>>2];c[Q+4>>2]=c[A+4>>2];c[Q+8>>2]=c[A+8>>2];am=aj+1|0}}while(0);if((am|0)==0){an=dF(N,ai,d)|0;Q=ai+12|0;if(dF(Q,a,d)|0){R=1407;break}if(an){N=Q;continue}}Q=ai;if((Q-O|0)>=(b-Q|0)){R=1411;break}dz(N,ai,d);N=ai+12|0}if((R|0)==1411){R=0;dz(ai+12|0,a,d);K=N;a=ai;continue}else if((R|0)==1407){R=0;if(an){R=1424;break}else{K=N;a=ai;continue}}}if((R|0)==1432){i=e;return}else if((R|0)==1416){i=e;return}else if((R|0)==1422){i=e;return}else if((R|0)==1424){i=e;return}else if((R|0)==1347){ai=N+12|0;K=N+24|0;an=N+36|0;am=m;m=n;n=o;o=p;dA(N,ai,K,an,d)|0;if(!(bF[c[d>>2]&255](L,an)|0)){i=e;return}p=an;c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[p>>2]=c[M>>2];c[p+4>>2]=c[M+4>>2];c[p+8>>2]=c[M+8>>2];c[M>>2]=c[o>>2];c[M+4>>2]=c[o+4>>2];c[M+8>>2]=c[o+8>>2];if(!(bF[c[d>>2]&255](an,K)|0)){i=e;return}an=K;c[m>>2]=c[an>>2];c[m+4>>2]=c[an+4>>2];c[m+8>>2]=c[an+8>>2];c[an>>2]=c[p>>2];c[an+4>>2]=c[p+4>>2];c[an+8>>2]=c[p+8>>2];c[p>>2]=c[m>>2];c[p+4>>2]=c[m+4>>2];c[p+8>>2]=c[m+8>>2];if(!(bF[c[d>>2]&255](K,ai)|0)){i=e;return}K=ai;c[am>>2]=c[K>>2];c[am+4>>2]=c[K+4>>2];c[am+8>>2]=c[K+8>>2];c[K>>2]=c[an>>2];c[K+4>>2]=c[an+4>>2];c[K+8>>2]=c[an+8>>2];c[an>>2]=c[am>>2];c[an+4>>2]=c[am+4>>2];c[an+8>>2]=c[am+8>>2];if(!(bF[c[d>>2]&255](ai,N)|0)){i=e;return}ai=N;c[n>>2]=c[ai>>2];c[n+4>>2]=c[ai+4>>2];c[n+8>>2]=c[ai+8>>2];c[ai>>2]=c[K>>2];c[ai+4>>2]=c[K+4>>2];c[ai+8>>2]=c[K+8>>2];c[K>>2]=c[n>>2];c[K+4>>2]=c[n+4>>2];c[K+8>>2]=c[n+8>>2];i=e;return}else if((R|0)==1346){dA(N,N+12|0,N+24|0,L,d)|0;i=e;return}else if((R|0)==1353){n=l;K=N+24|0;ai=N+12|0;am=f;f=g;g=h;h=j;j=k;k=bF[c[d>>2]&255](ai,N)|0;an=bF[c[d>>2]&255](K,ai)|0;do{if(k){m=N;if(an){c[am>>2]=c[m>>2];c[am+4>>2]=c[m+4>>2];c[am+8>>2]=c[m+8>>2];p=K;c[m>>2]=c[p>>2];c[m+4>>2]=c[p+4>>2];c[m+8>>2]=c[p+8>>2];c[p>>2]=c[am>>2];c[p+4>>2]=c[am+4>>2];c[p+8>>2]=c[am+8>>2];break}c[f>>2]=c[m>>2];c[f+4>>2]=c[m+4>>2];c[f+8>>2]=c[m+8>>2];p=ai;c[m>>2]=c[p>>2];c[m+4>>2]=c[p+4>>2];c[m+8>>2]=c[p+8>>2];c[p>>2]=c[f>>2];c[p+4>>2]=c[f+4>>2];c[p+8>>2]=c[f+8>>2];if(!(bF[c[d>>2]&255](K,ai)|0)){break}c[h>>2]=c[p>>2];c[h+4>>2]=c[p+4>>2];c[h+8>>2]=c[p+8>>2];m=K;c[p>>2]=c[m>>2];c[p+4>>2]=c[m+4>>2];c[p+8>>2]=c[m+8>>2];c[m>>2]=c[h>>2];c[m+4>>2]=c[h+4>>2];c[m+8>>2]=c[h+8>>2]}else{if(!an){break}m=ai;c[j>>2]=c[m>>2];c[j+4>>2]=c[m+4>>2];c[j+8>>2]=c[m+8>>2];p=K;c[m>>2]=c[p>>2];c[m+4>>2]=c[p+4>>2];c[m+8>>2]=c[p+8>>2];c[p>>2]=c[j>>2];c[p+4>>2]=c[j+4>>2];c[p+8>>2]=c[j+8>>2];if(!(bF[c[d>>2]&255](ai,N)|0)){break}p=N;c[g>>2]=c[p>>2];c[g+4>>2]=c[p+4>>2];c[g+8>>2]=c[p+8>>2];c[p>>2]=c[m>>2];c[p+4>>2]=c[m+4>>2];c[p+8>>2]=c[m+8>>2];c[m>>2]=c[g>>2];c[m+4>>2]=c[g+4>>2];c[m+8>>2]=c[g+8>>2]}}while(0);g=N+36|0;if((g|0)==(a|0)){i=e;return}else{ao=K;ap=g}while(1){if(bF[c[d>>2]&255](ap,ao)|0){g=ap;c[n>>2]=c[g>>2];c[n+4>>2]=c[g+4>>2];c[n+8>>2]=c[g+8>>2];g=ao;K=ap;while(1){ai=K;aq=g;c[ai>>2]=c[aq>>2];c[ai+4>>2]=c[aq+4>>2];c[ai+8>>2]=c[aq+8>>2];if((g|0)==(N|0)){break}ai=g-12|0;if(bF[c[d>>2]&255](l,ai)|0){K=g;g=ai}else{break}}c[aq>>2]=c[n>>2];c[aq+4>>2]=c[n+4>>2];c[aq+8>>2]=c[n+8>>2]}g=ap+12|0;if((g|0)==(a|0)){break}else{ao=ap;ap=g}}i=e;return}else if((R|0)==1338){ap=N+12|0;ao=q;q=r;r=s;s=t;t=u;u=bF[c[d>>2]&255](ap,N)|0;a=bF[c[d>>2]&255](L,ap)|0;if(!u){if(!a){i=e;return}u=ap;c[t>>2]=c[u>>2];c[t+4>>2]=c[u+4>>2];c[t+8>>2]=c[u+8>>2];c[u>>2]=c[M>>2];c[u+4>>2]=c[M+4>>2];c[u+8>>2]=c[M+8>>2];c[M>>2]=c[t>>2];c[M+4>>2]=c[t+4>>2];c[M+8>>2]=c[t+8>>2];if(!(bF[c[d>>2]&255](ap,N)|0)){i=e;return}t=N;c[r>>2]=c[t>>2];c[r+4>>2]=c[t+4>>2];c[r+8>>2]=c[t+8>>2];c[t>>2]=c[u>>2];c[t+4>>2]=c[u+4>>2];c[t+8>>2]=c[u+8>>2];c[u>>2]=c[r>>2];c[u+4>>2]=c[r+4>>2];c[u+8>>2]=c[r+8>>2];i=e;return}r=N;if(a){c[ao>>2]=c[r>>2];c[ao+4>>2]=c[r+4>>2];c[ao+8>>2]=c[r+8>>2];c[r>>2]=c[M>>2];c[r+4>>2]=c[M+4>>2];c[r+8>>2]=c[M+8>>2];c[M>>2]=c[ao>>2];c[M+4>>2]=c[ao+4>>2];c[M+8>>2]=c[ao+8>>2];i=e;return}c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];ao=ap;c[r>>2]=c[ao>>2];c[r+4>>2]=c[ao+4>>2];c[r+8>>2]=c[ao+8>>2];c[ao>>2]=c[q>>2];c[ao+4>>2]=c[q+4>>2];c[ao+8>>2]=c[q+8>>2];if(!(bF[c[d>>2]&255](L,ap)|0)){i=e;return}c[s>>2]=c[ao>>2];c[s+4>>2]=c[ao+4>>2];c[s+8>>2]=c[ao+8>>2];c[ao>>2]=c[M>>2];c[ao+4>>2]=c[M+4>>2];c[ao+8>>2]=c[M+8>>2];c[M>>2]=c[s>>2];c[M+4>>2]=c[s+4>>2];c[M+8>>2]=c[s+8>>2];i=e;return}else if((R|0)==1336){if(!(bF[c[d>>2]&255](L,N)|0)){i=e;return}L=v;v=N;c[L>>2]=c[v>>2];c[L+4>>2]=c[v+4>>2];c[L+8>>2]=c[v+8>>2];c[v>>2]=c[M>>2];c[v+4>>2]=c[M+4>>2];c[v+8>>2]=c[M+8>>2];c[M>>2]=c[L>>2];c[M+4>>2]=c[L+4>>2];c[M+8>>2]=c[L+8>>2];i=e;return}}function dA(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;g=i;i=i+128|0;h=g+80|0;j=g+96|0;k=g+112|0;l=g|0;m=g+16|0;n=g+32|0;o=g+48|0;p=g+64|0;q=bF[c[f>>2]&255](b,a)|0;r=bF[c[f>>2]&255](d,b)|0;do{if(q){s=a;if(r){c[l>>2]=c[s>>2];c[l+4>>2]=c[s+4>>2];c[l+8>>2]=c[s+8>>2];t=d;c[s>>2]=c[t>>2];c[s+4>>2]=c[t+4>>2];c[s+8>>2]=c[t+8>>2];c[t>>2]=c[l>>2];c[t+4>>2]=c[l+4>>2];c[t+8>>2]=c[l+8>>2];u=1;break}c[m>>2]=c[s>>2];c[m+4>>2]=c[s+4>>2];c[m+8>>2]=c[s+8>>2];t=b;c[s>>2]=c[t>>2];c[s+4>>2]=c[t+4>>2];c[s+8>>2]=c[t+8>>2];c[t>>2]=c[m>>2];c[t+4>>2]=c[m+4>>2];c[t+8>>2]=c[m+8>>2];if(!(bF[c[f>>2]&255](d,b)|0)){u=1;break}c[o>>2]=c[t>>2];c[o+4>>2]=c[t+4>>2];c[o+8>>2]=c[t+8>>2];s=d;c[t>>2]=c[s>>2];c[t+4>>2]=c[s+4>>2];c[t+8>>2]=c[s+8>>2];c[s>>2]=c[o>>2];c[s+4>>2]=c[o+4>>2];c[s+8>>2]=c[o+8>>2];u=2}else{if(!r){u=0;break}s=b;c[p>>2]=c[s>>2];c[p+4>>2]=c[s+4>>2];c[p+8>>2]=c[s+8>>2];t=d;c[s>>2]=c[t>>2];c[s+4>>2]=c[t+4>>2];c[s+8>>2]=c[t+8>>2];c[t>>2]=c[p>>2];c[t+4>>2]=c[p+4>>2];c[t+8>>2]=c[p+8>>2];if(!(bF[c[f>>2]&255](b,a)|0)){u=1;break}t=a;c[n>>2]=c[t>>2];c[n+4>>2]=c[t+4>>2];c[n+8>>2]=c[t+8>>2];c[t>>2]=c[s>>2];c[t+4>>2]=c[s+4>>2];c[t+8>>2]=c[s+8>>2];c[s>>2]=c[n>>2];c[s+4>>2]=c[n+4>>2];c[s+8>>2]=c[n+8>>2];u=2}}while(0);if(!(bF[c[f>>2]&255](e,d)|0)){v=u;i=g;return v|0}n=k;k=d;c[n>>2]=c[k>>2];c[n+4>>2]=c[k+4>>2];c[n+8>>2]=c[k+8>>2];p=e;c[k>>2]=c[p>>2];c[k+4>>2]=c[p+4>>2];c[k+8>>2]=c[p+8>>2];c[p>>2]=c[n>>2];c[p+4>>2]=c[n+4>>2];c[p+8>>2]=c[n+8>>2];if(!(bF[c[f>>2]&255](d,b)|0)){v=u+1|0;i=g;return v|0}d=h;h=b;c[d>>2]=c[h>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[h>>2]=c[k>>2];c[h+4>>2]=c[k+4>>2];c[h+8>>2]=c[k+8>>2];c[k>>2]=c[d>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];if(!(bF[c[f>>2]&255](b,a)|0)){v=u+2|0;i=g;return v|0}b=j;j=a;c[b>>2]=c[j>>2];c[b+4>>2]=c[j+4>>2];c[b+8>>2]=c[j+8>>2];c[j>>2]=c[h>>2];c[j+4>>2]=c[h+4>>2];c[j+8>>2]=c[h+8>>2];c[h>>2]=c[b>>2];c[h+4>>2]=c[b+4>>2];c[h+8>>2]=c[b+8>>2];v=u+3|0;i=g;return v|0}function dB(a,b){a=a|0;b=b|0;return}function dC(a,b){a=a|0;b=b|0;return}function dD(a,b,c){a=a|0;b=b|0;c=c|0;return}function dE(a,b,c){a=a|0;b=b|0;c=c|0;return}function dF(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;e=i;i=i+256|0;f=e|0;g=e+16|0;h=e+32|0;j=e+48|0;k=e+64|0;l=e+144|0;m=e+160|0;n=e+176|0;o=e+192|0;p=e+208|0;q=e+224|0;r=e+240|0;s=(b-a|0)/12&-1;if((s|0)==5){t=a+12|0;u=a+24|0;v=a+36|0;w=b-12|0;x=e+80|0;y=e+96|0;z=e+112|0;A=e+128|0;dA(a,t,u,v,d)|0;if(!(bF[c[d>>2]&255](w,v)|0)){B=1;i=e;return B|0}C=v;c[A>>2]=c[C>>2];c[A+4>>2]=c[C+4>>2];c[A+8>>2]=c[C+8>>2];D=w;c[C>>2]=c[D>>2];c[C+4>>2]=c[D+4>>2];c[C+8>>2]=c[D+8>>2];c[D>>2]=c[A>>2];c[D+4>>2]=c[A+4>>2];c[D+8>>2]=c[A+8>>2];if(!(bF[c[d>>2]&255](v,u)|0)){B=1;i=e;return B|0}v=u;c[y>>2]=c[v>>2];c[y+4>>2]=c[v+4>>2];c[y+8>>2]=c[v+8>>2];c[v>>2]=c[C>>2];c[v+4>>2]=c[C+4>>2];c[v+8>>2]=c[C+8>>2];c[C>>2]=c[y>>2];c[C+4>>2]=c[y+4>>2];c[C+8>>2]=c[y+8>>2];if(!(bF[c[d>>2]&255](u,t)|0)){B=1;i=e;return B|0}u=t;c[x>>2]=c[u>>2];c[x+4>>2]=c[u+4>>2];c[x+8>>2]=c[u+8>>2];c[u>>2]=c[v>>2];c[u+4>>2]=c[v+4>>2];c[u+8>>2]=c[v+8>>2];c[v>>2]=c[x>>2];c[v+4>>2]=c[x+4>>2];c[v+8>>2]=c[x+8>>2];if(!(bF[c[d>>2]&255](t,a)|0)){B=1;i=e;return B|0}t=a;c[z>>2]=c[t>>2];c[z+4>>2]=c[t+4>>2];c[z+8>>2]=c[t+8>>2];c[t>>2]=c[u>>2];c[t+4>>2]=c[u+4>>2];c[t+8>>2]=c[u+8>>2];c[u>>2]=c[z>>2];c[u+4>>2]=c[z+4>>2];c[u+8>>2]=c[z+8>>2];B=1;i=e;return B|0}else if((s|0)==2){z=b-12|0;if(!(bF[c[d>>2]&255](z,a)|0)){B=1;i=e;return B|0}u=q;q=a;c[u>>2]=c[q>>2];c[u+4>>2]=c[q+4>>2];c[u+8>>2]=c[q+8>>2];t=z;c[q>>2]=c[t>>2];c[q+4>>2]=c[t+4>>2];c[q+8>>2]=c[t+8>>2];c[t>>2]=c[u>>2];c[t+4>>2]=c[u+4>>2];c[t+8>>2]=c[u+8>>2];B=1;i=e;return B|0}else if((s|0)==4){dA(a,a+12|0,a+24|0,b-12|0,d)|0;B=1;i=e;return B|0}else if((s|0)==3){u=a+12|0;t=b-12|0;q=l;l=m;m=n;n=o;o=p;p=bF[c[d>>2]&255](u,a)|0;z=bF[c[d>>2]&255](t,u)|0;if(!p){if(!z){B=1;i=e;return B|0}p=u;c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];x=t;c[p>>2]=c[x>>2];c[p+4>>2]=c[x+4>>2];c[p+8>>2]=c[x+8>>2];c[x>>2]=c[o>>2];c[x+4>>2]=c[o+4>>2];c[x+8>>2]=c[o+8>>2];if(!(bF[c[d>>2]&255](u,a)|0)){B=1;i=e;return B|0}o=a;c[m>>2]=c[o>>2];c[m+4>>2]=c[o+4>>2];c[m+8>>2]=c[o+8>>2];c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[p>>2]=c[m>>2];c[p+4>>2]=c[m+4>>2];c[p+8>>2]=c[m+8>>2];B=1;i=e;return B|0}m=a;if(z){c[q>>2]=c[m>>2];c[q+4>>2]=c[m+4>>2];c[q+8>>2]=c[m+8>>2];z=t;c[m>>2]=c[z>>2];c[m+4>>2]=c[z+4>>2];c[m+8>>2]=c[z+8>>2];c[z>>2]=c[q>>2];c[z+4>>2]=c[q+4>>2];c[z+8>>2]=c[q+8>>2];B=1;i=e;return B|0}c[l>>2]=c[m>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];q=u;c[m>>2]=c[q>>2];c[m+4>>2]=c[q+4>>2];c[m+8>>2]=c[q+8>>2];c[q>>2]=c[l>>2];c[q+4>>2]=c[l+4>>2];c[q+8>>2]=c[l+8>>2];if(!(bF[c[d>>2]&255](t,u)|0)){B=1;i=e;return B|0}c[n>>2]=c[q>>2];c[n+4>>2]=c[q+4>>2];c[n+8>>2]=c[q+8>>2];u=t;c[q>>2]=c[u>>2];c[q+4>>2]=c[u+4>>2];c[q+8>>2]=c[u+8>>2];c[u>>2]=c[n>>2];c[u+4>>2]=c[n+4>>2];c[u+8>>2]=c[n+8>>2];B=1;i=e;return B|0}else if((s|0)==0|(s|0)==1){B=1;i=e;return B|0}else{s=a+24|0;n=a+12|0;u=f;f=g;g=h;h=j;j=k;k=bF[c[d>>2]&255](n,a)|0;q=bF[c[d>>2]&255](s,n)|0;do{if(k){t=a;if(q){c[u>>2]=c[t>>2];c[u+4>>2]=c[t+4>>2];c[u+8>>2]=c[t+8>>2];l=s;c[t>>2]=c[l>>2];c[t+4>>2]=c[l+4>>2];c[t+8>>2]=c[l+8>>2];c[l>>2]=c[u>>2];c[l+4>>2]=c[u+4>>2];c[l+8>>2]=c[u+8>>2];break}c[f>>2]=c[t>>2];c[f+4>>2]=c[t+4>>2];c[f+8>>2]=c[t+8>>2];l=n;c[t>>2]=c[l>>2];c[t+4>>2]=c[l+4>>2];c[t+8>>2]=c[l+8>>2];c[l>>2]=c[f>>2];c[l+4>>2]=c[f+4>>2];c[l+8>>2]=c[f+8>>2];if(!(bF[c[d>>2]&255](s,n)|0)){break}c[h>>2]=c[l>>2];c[h+4>>2]=c[l+4>>2];c[h+8>>2]=c[l+8>>2];t=s;c[l>>2]=c[t>>2];c[l+4>>2]=c[t+4>>2];c[l+8>>2]=c[t+8>>2];c[t>>2]=c[h>>2];c[t+4>>2]=c[h+4>>2];c[t+8>>2]=c[h+8>>2]}else{if(!q){break}t=n;c[j>>2]=c[t>>2];c[j+4>>2]=c[t+4>>2];c[j+8>>2]=c[t+8>>2];l=s;c[t>>2]=c[l>>2];c[t+4>>2]=c[l+4>>2];c[t+8>>2]=c[l+8>>2];c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];if(!(bF[c[d>>2]&255](n,a)|0)){break}l=a;c[g>>2]=c[l>>2];c[g+4>>2]=c[l+4>>2];c[g+8>>2]=c[l+8>>2];c[l>>2]=c[t>>2];c[l+4>>2]=c[t+4>>2];c[l+8>>2]=c[t+8>>2];c[t>>2]=c[g>>2];c[t+4>>2]=c[g+4>>2];c[t+8>>2]=c[g+8>>2]}}while(0);g=a+36|0;if((g|0)==(b|0)){B=1;i=e;return B|0}n=r;j=s;s=0;q=g;while(1){if(bF[c[d>>2]&255](q,j)|0){g=q;c[n>>2]=c[g>>2];c[n+4>>2]=c[g+4>>2];c[n+8>>2]=c[g+8>>2];g=j;h=q;while(1){f=h;E=g;c[f>>2]=c[E>>2];c[f+4>>2]=c[E+4>>2];c[f+8>>2]=c[E+8>>2];if((g|0)==(a|0)){break}f=g-12|0;if(bF[c[d>>2]&255](r,f)|0){h=g;g=f}else{break}}c[E>>2]=c[n>>2];c[E+4>>2]=c[n+4>>2];c[E+8>>2]=c[n+8>>2];g=s+1|0;if((g|0)==8){break}else{F=g}}else{F=s}g=q+12|0;if((g|0)==(b|0)){B=1;G=1499;break}else{j=q;s=F;q=g}}if((G|0)==1499){i=e;return B|0}B=(q+12|0)==(b|0);i=e;return B|0}return 0}function dG(a){a=a|0;vl(a);return}function dH(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0,O=0,P=0;f=i;i=i+40|0;h=f|0;j=f+16|0;k=f+32|0;l=a+28|0;if((c[l>>2]|0)<=0){i=f;return}m=a+24|0;n=a+12|0;a=h|0;o=j|0;p=h+4|0;q=j+4|0;r=h+8|0;s=j+8|0;t=h+12|0;u=j+12|0;v=e|0;w=d|0;x=e+4|0;y=d+4|0;z=k|0;A=k+4|0;B=b|0;C=b+40|0;D=b+36|0;E=b+32|0;b=0;do{F=c[m>>2]|0;G=c[n>>2]|0;H=F+(b*28&-1)+20|0;bO[c[(c[G>>2]|0)+24>>2]&127](G,h,d,c[H>>2]|0);G=c[n>>2]|0;bO[c[(c[G>>2]|0)+24>>2]&127](G,j,e,c[H>>2]|0);H=F+(b*28&-1)|0;I=+g[a>>2];J=+g[o>>2];K=+g[p>>2];L=+g[q>>2];G=H;M=+(K<L?K:L);g[G>>2]=I<J?I:J;g[G+4>>2]=M;M=+g[r>>2];J=+g[s>>2];I=+g[t>>2];L=+g[u>>2];G=F+(b*28&-1)+8|0;K=+(I>L?I:L);g[G>>2]=M>J?M:J;g[G+4>>2]=K;K=+g[x>>2]- +g[y>>2];g[z>>2]=+g[v>>2]- +g[w>>2];g[A>>2]=K;G=c[F+(b*28&-1)+24>>2]|0;if(cn(B,G,H,k)|0){H=c[C>>2]|0;if((H|0)==(c[D>>2]|0)){F=c[E>>2]|0;c[D>>2]=H<<1;N=vh(H<<3)|0;c[E>>2]=N;O=F;F=c[C>>2]<<2;vp(N|0,O|0,F)|0;vi(O);P=c[C>>2]|0}else{P=H}c[(c[E>>2]|0)+(P<<2)>>2]=G;c[C>>2]=(c[C>>2]|0)+1}b=b+1|0;}while((b|0)<(c[l>>2]|0));i=f;return}function dI(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;b=a+8|0;d=c[b>>2]|0;if((d|0)==0){return}e=c[d+112>>2]|0;if((e|0)==0){f=d}else{d=e;do{e=c[d+4>>2]|0;if((c[e+48>>2]|0)==(a|0)|(c[e+52>>2]|0)==(a|0)){g=e+4|0;c[g>>2]=c[g>>2]|8}d=c[d+12>>2]|0;}while((d|0)!=0);f=c[b>>2]|0}b=c[f+88>>2]|0;if((b|0)==0){return}f=a+28|0;if((c[f>>2]|0)<=0){return}d=a+24|0;a=b+102912|0;g=b+102908|0;e=b+102904|0;b=0;h=c[a>>2]|0;do{i=c[(c[d>>2]|0)+(b*28&-1)+24>>2]|0;if((h|0)==(c[g>>2]|0)){j=c[e>>2]|0;c[g>>2]=h<<1;k=vh(h<<3)|0;c[e>>2]=k;l=j;j=c[a>>2]<<2;vp(k|0,l|0,j)|0;vi(l);m=c[a>>2]|0}else{m=h}c[(c[e>>2]|0)+(m<<2)>>2]=i;h=(c[a>>2]|0)+1|0;c[a>>2]=h;b=b+1|0;}while((b|0)<(c[f>>2]|0));return}function dJ(d,f){d=d|0;f=f|0;var j=0,k=0,l=0,m=0.0,n=0,o=0,p=0,q=0.0,r=0,s=0,t=0,v=0;j=i;db(7320,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(6312,(u=i,i=i+8|0,h[u>>3]=+g[d+16>>2],u)|0);db(5776,(u=i,i=i+8|0,h[u>>3]=+g[d+20>>2],u)|0);db(5272,(u=i,i=i+8|0,h[u>>3]=+g[d>>2],u)|0);db(4904,(u=i,i=i+8|0,c[u>>2]=a[d+38|0]&1,u)|0);db(4624,(u=i,i=i+8|0,c[u>>2]=e[d+32>>1]|0,u)|0);db(4392,(u=i,i=i+8|0,c[u>>2]=e[d+34>>1]|0,u)|0);db(12896,(u=i,i=i+8|0,c[u>>2]=b[d+36>>1]|0,u)|0);k=c[d+12>>2]|0;d=c[k+4>>2]|0;if((d|0)==1){db(11368,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(12200,(u=i,i=i+8|0,h[u>>3]=+g[k+8>>2],u)|0);l=k+28|0;m=+g[l+4>>2];db(11152,(u=i,i=i+16|0,h[u>>3]=+g[l>>2],h[u+8>>3]=m,u)|0);m=+g[k+16>>2];db(10928,(u=i,i=i+16|0,h[u>>3]=+g[k+12>>2],h[u+8>>3]=m,u)|0);l=k+20|0;m=+g[l+4>>2];db(10728,(u=i,i=i+16|0,h[u>>3]=+g[l>>2],h[u+8>>3]=m,u)|0);m=+g[k+40>>2];db(10528,(u=i,i=i+16|0,h[u>>3]=+g[k+36>>2],h[u+8>>3]=m,u)|0);db(10408,(u=i,i=i+8|0,c[u>>2]=a[k+44|0]&1,u)|0);db(10200,(u=i,i=i+8|0,c[u>>2]=a[k+45|0]&1,u)|0)}else if((d|0)==0){db(12696,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(12200,(u=i,i=i+8|0,h[u>>3]=+g[k+8>>2],u)|0);m=+g[k+16>>2];db(11600,(u=i,i=i+16|0,h[u>>3]=+g[k+12>>2],h[u+8>>3]=m,u)|0)}else if((d|0)==2){db(9872,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(9544,(u=i,i=i+8|0,c[u>>2]=8,u)|0);l=k+148|0;n=c[l>>2]|0;if((n|0)>0){o=k+20|0;p=0;while(1){m=+g[o+(p<<3)>>2];q=+g[o+(p<<3)+4>>2];db(9104,(u=i,i=i+24|0,c[u>>2]=p,h[u+8>>3]=m,h[u+16>>3]=q,u)|0);r=p+1|0;s=c[l>>2]|0;if((r|0)<(s|0)){p=r}else{t=s;break}}}else{t=n}db(8840,(u=i,i=i+8|0,c[u>>2]=t,u)|0)}else if((d|0)==3){d=k;db(8680,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);t=k+16|0;db(9544,(u=i,i=i+8|0,c[u>>2]=c[t>>2],u)|0);n=c[t>>2]|0;if((n|0)>0){p=k+12|0;l=0;while(1){o=c[p>>2]|0;q=+g[o+(l<<3)>>2];m=+g[o+(l<<3)+4>>2];db(9104,(u=i,i=i+24|0,c[u>>2]=l,h[u+8>>3]=q,h[u+16>>3]=m,u)|0);o=l+1|0;s=c[t>>2]|0;if((o|0)<(s|0)){l=o}else{v=s;break}}}else{v=n}db(8312,(u=i,i=i+8|0,c[u>>2]=v,u)|0);v=k+20|0;m=+g[v+4>>2];db(8080,(u=i,i=i+16|0,h[u>>3]=+g[v>>2],h[u+8>>3]=m,u)|0);v=k+28|0;m=+g[v+4>>2];db(7792,(u=i,i=i+16|0,h[u>>3]=+g[v>>2],h[u+8>>3]=m,u)|0);db(7584,(u=i,i=i+8|0,c[u>>2]=a[k+36|0]&1,u)|0);db(7440,(u=i,i=i+8|0,c[u>>2]=a[d+37|0]&1,u)|0)}else{i=j;return}db(7344,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(7208,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(7344,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(7016,(u=i,i=i+8|0,c[u>>2]=f,u)|0);i=j;return}function dK(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;if((c[b+28>>2]|0)!=0){ba(12280,72,14920,12608)}e=b+12|0;f=c[e>>2]|0;g=bq[c[(c[f>>2]|0)+12>>2]&1023](f)|0;f=b+24|0;b=c[f>>2]|0;h=b;i=g*28&-1;do{if((i|0)!=0){if((i|0)<=0){ba(5352,164,17448,8376)}if((i|0)>640){vi(h);break}g=a[i+22064|0]|0;if((g&255)<14){j=d+12+((g&255)<<2)|0;c[b>>2]=c[j>>2];c[j>>2]=b;break}else{ba(5352,173,17448,6544)}}}while(0);c[f>>2]=0;f=c[e>>2]|0;b=c[f+4>>2]|0;if((b|0)==3){bo[c[c[f>>2]>>2]&511](f);i=a[22104]|0;if((i&255)>=14){ba(5352,173,17448,6544)}h=d+12+((i&255)<<2)|0;c[f>>2]=c[h>>2];c[h>>2]=f;c[e>>2]=0;return}else if((b|0)==0){bo[c[c[f>>2]>>2]&511](f);h=a[22084]|0;if((h&255)>=14){ba(5352,173,17448,6544)}i=d+12+((h&255)<<2)|0;c[f>>2]=c[i>>2];c[i>>2]=f;c[e>>2]=0;return}else if((b|0)==2){bo[c[c[f>>2]>>2]&511](f);i=a[22216]|0;if((i&255)>=14){ba(5352,173,17448,6544)}h=d+12+((i&255)<<2)|0;c[f>>2]=c[h>>2];c[h>>2]=f;c[e>>2]=0;return}else if((b|0)==1){bo[c[c[f>>2]>>2]&511](f);b=a[22112]|0;if((b&255)>=14){ba(5352,173,17448,6544)}h=d+12+((b&255)<<2)|0;c[f>>2]=c[h>>2];c[h>>2]=f;c[e>>2]=0;return}else{ba(12280,115,14920,11592)}}function dL(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;i=b+40|0;c[i>>2]=d;c[b+44>>2]=e;c[b+48>>2]=f;c[b+28>>2]=0;c[b+36>>2]=0;c[b+32>>2]=0;j=b|0;c[j>>2]=g;c[b+4>>2]=h;h=d<<2;d=g+102796|0;k=c[d>>2]|0;if((k|0)>=32){ba(4840,38,17040,6448)}l=g+102412+(k*12&-1)|0;c[g+102412+(k*12&-1)+4>>2]=h;m=g+102400|0;n=c[m>>2]|0;if((n+h|0)>102400){c[l>>2]=vh(h)|0;a[g+102412+(k*12&-1)+8|0]=1}else{c[l>>2]=g+n;a[g+102412+(k*12&-1)+8|0]=0;c[m>>2]=(c[m>>2]|0)+h}m=g+102404|0;k=(c[m>>2]|0)+h|0;c[m>>2]=k;m=g+102408|0;g=c[m>>2]|0;c[m>>2]=(g|0)>(k|0)?g:k;c[d>>2]=(c[d>>2]|0)+1;c[b+8>>2]=c[l>>2];l=c[j>>2]|0;d=e<<2;e=l+102796|0;k=c[e>>2]|0;if((k|0)>=32){ba(4840,38,17040,6448)}g=l+102412+(k*12&-1)|0;c[l+102412+(k*12&-1)+4>>2]=d;m=l+102400|0;h=c[m>>2]|0;if((h+d|0)>102400){c[g>>2]=vh(d)|0;a[l+102412+(k*12&-1)+8|0]=1}else{c[g>>2]=l+h;a[l+102412+(k*12&-1)+8|0]=0;c[m>>2]=(c[m>>2]|0)+d}m=l+102404|0;k=(c[m>>2]|0)+d|0;c[m>>2]=k;m=l+102408|0;l=c[m>>2]|0;c[m>>2]=(l|0)>(k|0)?l:k;c[e>>2]=(c[e>>2]|0)+1;c[b+12>>2]=c[g>>2];g=c[j>>2]|0;e=f<<2;f=g+102796|0;k=c[f>>2]|0;if((k|0)>=32){ba(4840,38,17040,6448)}l=g+102412+(k*12&-1)|0;c[g+102412+(k*12&-1)+4>>2]=e;m=g+102400|0;d=c[m>>2]|0;if((d+e|0)>102400){c[l>>2]=vh(e)|0;a[g+102412+(k*12&-1)+8|0]=1}else{c[l>>2]=g+d;a[g+102412+(k*12&-1)+8|0]=0;c[m>>2]=(c[m>>2]|0)+e}m=g+102404|0;k=(c[m>>2]|0)+e|0;c[m>>2]=k;m=g+102408|0;g=c[m>>2]|0;c[m>>2]=(g|0)>(k|0)?g:k;c[f>>2]=(c[f>>2]|0)+1;c[b+16>>2]=c[l>>2];l=c[j>>2]|0;f=(c[i>>2]|0)*12&-1;k=l+102796|0;g=c[k>>2]|0;if((g|0)>=32){ba(4840,38,17040,6448)}m=l+102412+(g*12&-1)|0;c[l+102412+(g*12&-1)+4>>2]=f;e=l+102400|0;d=c[e>>2]|0;if((d+f|0)>102400){c[m>>2]=vh(f)|0;a[l+102412+(g*12&-1)+8|0]=1}else{c[m>>2]=l+d;a[l+102412+(g*12&-1)+8|0]=0;c[e>>2]=(c[e>>2]|0)+f}e=l+102404|0;g=(c[e>>2]|0)+f|0;c[e>>2]=g;e=l+102408|0;l=c[e>>2]|0;c[e>>2]=(l|0)>(g|0)?l:g;c[k>>2]=(c[k>>2]|0)+1;c[b+24>>2]=c[m>>2];m=c[j>>2]|0;j=(c[i>>2]|0)*12&-1;i=m+102796|0;k=c[i>>2]|0;if((k|0)>=32){ba(4840,38,17040,6448)}g=m+102412+(k*12&-1)|0;c[m+102412+(k*12&-1)+4>>2]=j;l=m+102400|0;e=c[l>>2]|0;if((e+j|0)>102400){c[g>>2]=vh(j)|0;a[m+102412+(k*12&-1)+8|0]=1;o=m+102404|0;p=c[o>>2]|0;q=p+j|0;c[o>>2]=q;r=m+102408|0;s=c[r>>2]|0;t=(s|0)>(q|0);u=t?s:q;c[r>>2]=u;v=c[i>>2]|0;w=v+1|0;c[i>>2]=w;x=g|0;y=c[x>>2]|0;z=y;A=b+20|0;c[A>>2]=z;return}else{c[g>>2]=m+e;a[m+102412+(k*12&-1)+8|0]=0;c[l>>2]=(c[l>>2]|0)+j;o=m+102404|0;p=c[o>>2]|0;q=p+j|0;c[o>>2]=q;r=m+102408|0;s=c[r>>2]|0;t=(s|0)>(q|0);u=t?s:q;c[r>>2]=u;v=c[i>>2]|0;w=v+1|0;c[i>>2]=w;x=g|0;y=c[x>>2]|0;z=y;A=b+20|0;c[A>>2]=z;return}}function dM(d,e,f,h,j){d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0,m=0,n=0,o=0,p=0,q=0.0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0,O=0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0.0,ad=0.0,ae=0;l=i;i=i+160|0;m=l|0;n=l+24|0;o=l+56|0;p=l+104|0;q=+g[f>>2];r=d+28|0;if((c[r>>2]|0)>0){s=d+8|0;t=h|0;u=h+4|0;h=d+20|0;v=d+24|0;w=0;while(1){x=c[(c[s>>2]|0)+(w<<2)>>2]|0;y=x+44|0;z=c[y>>2]|0;A=c[y+4>>2]|0;B=+g[x+56>>2];y=x+64|0;C=+g[y>>2];D=+g[y+4>>2];E=+g[x+72>>2];y=x+36|0;c[y>>2]=z;c[y+4>>2]=A;g[x+52>>2]=B;if((c[x>>2]|0)==2){F=+g[x+140>>2];G=+g[x+120>>2];H=1.0-q*+g[x+132>>2];I=H<1.0?H:1.0;H=I<0.0?0.0:I;I=1.0-q*+g[x+136>>2];J=I<1.0?I:1.0;K=(E+q*+g[x+128>>2]*+g[x+84>>2])*(J<0.0?0.0:J);L=(C+q*(F*+g[t>>2]+G*+g[x+76>>2]))*H;M=(D+q*(F*+g[u>>2]+G*+g[x+80>>2]))*H}else{K=E;L=C;M=D}x=(c[h>>2]|0)+(w*12&-1)|0;c[x>>2]=z;c[x+4>>2]=A;g[(c[h>>2]|0)+(w*12&-1)+8>>2]=B;A=(c[v>>2]|0)+(w*12&-1)|0;B=+M;g[A>>2]=L;g[A+4>>2]=B;g[(c[v>>2]|0)+(w*12&-1)+8>>2]=K;A=w+1|0;if((A|0)<(c[r>>2]|0)){w=A}else{N=h;O=v;break}}}else{N=d+20|0;O=d+24|0}v=n;h=f;c[v>>2]=c[h>>2];c[v+4>>2]=c[h+4>>2];c[v+8>>2]=c[h+8>>2];c[v+12>>2]=c[h+12>>2];c[v+16>>2]=c[h+16>>2];c[v+20>>2]=c[h+20>>2];v=c[N>>2]|0;c[n+24>>2]=v;w=c[O>>2]|0;c[n+28>>2]=w;u=o;c[u>>2]=c[h>>2];c[u+4>>2]=c[h+4>>2];c[u+8>>2]=c[h+8>>2];c[u+12>>2]=c[h+12>>2];c[u+16>>2]=c[h+16>>2];c[u+20>>2]=c[h+20>>2];h=d+12|0;c[o+24>>2]=c[h>>2];u=d+36|0;c[o+28>>2]=c[u>>2];c[o+32>>2]=v;c[o+36>>2]=w;c[o+40>>2]=c[d>>2];en(p,o);ep(p);if((a[f+20|0]&1)!=0){eo(p)}o=d+32|0;if((c[o>>2]|0)>0){w=d+16|0;v=0;do{t=c[(c[w>>2]|0)+(v<<2)>>2]|0;bp[c[(c[t>>2]|0)+28>>2]&511](t,n);v=v+1|0;}while((v|0)<(c[o>>2]|0))}g[e+12>>2]=0.0;v=f+12|0;if((c[v>>2]|0)>0){w=d+16|0;t=0;do{if((c[o>>2]|0)>0){s=0;do{A=c[(c[w>>2]|0)+(s<<2)>>2]|0;bp[c[(c[A>>2]|0)+32>>2]&511](A,n);s=s+1|0;}while((s|0)<(c[o>>2]|0))}er(p);t=t+1|0;}while((t|0)<(c[v>>2]|0))}v=c[p+48>>2]|0;if((v|0)>0){t=c[p+40>>2]|0;w=c[p+44>>2]|0;s=0;do{A=c[w+(c[t+(s*152&-1)+148>>2]<<2)>>2]|0;x=t+(s*152&-1)+144|0;if((c[x>>2]|0)>0){z=0;do{g[A+64+(z*20&-1)+8>>2]=+g[t+(s*152&-1)+(z*36&-1)+16>>2];g[A+64+(z*20&-1)+12>>2]=+g[t+(s*152&-1)+(z*36&-1)+20>>2];z=z+1|0;}while((z|0)<(c[x>>2]|0))}s=s+1|0;}while((s|0)<(v|0))}g[e+16>>2]=0.0;if((c[r>>2]|0)>0){v=0;do{s=c[N>>2]|0;t=s+(v*12&-1)|0;K=+g[t>>2];L=+g[t+4>>2];M=+g[s+(v*12&-1)+8>>2];s=c[O>>2]|0;w=s+(v*12&-1)|0;B=+g[w>>2];D=+g[w+4>>2];C=+g[s+(v*12&-1)+8>>2];E=q*B;H=q*D;G=E*E+H*H;if(G>4.0){H=2.0/+P(+G);Q=B*H;T=D*H}else{Q=B;T=D}D=q*C;if(D*D>2.4674012660980225){if(D>0.0){U=D}else{U=-0.0-D}V=C*(1.5707963705062866/U)}else{V=C}C=+(L+q*T);g[t>>2]=K+q*Q;g[t+4>>2]=C;g[(c[N>>2]|0)+(v*12&-1)+8>>2]=M+q*V;t=(c[O>>2]|0)+(v*12&-1)|0;M=+T;g[t>>2]=Q;g[t+4>>2]=M;g[(c[O>>2]|0)+(v*12&-1)+8>>2]=V;v=v+1|0;}while((v|0)<(c[r>>2]|0))}v=f+16|0;f=d+16|0;t=0;while(1){if((t|0)>=(c[v>>2]|0)){W=1;break}s=eq(p)|0;if((c[o>>2]|0)>0){w=1;x=0;while(1){z=c[(c[f>>2]|0)+(x<<2)>>2]|0;A=w&(bF[c[(c[z>>2]|0)+36>>2]&255](z,n)|0);z=x+1|0;if((z|0)<(c[o>>2]|0)){w=A;x=z}else{X=A;break}}}else{X=1}if(s&X){W=0;break}else{t=t+1|0}}if((c[r>>2]|0)>0){t=d+8|0;X=0;do{o=c[(c[t>>2]|0)+(X<<2)>>2]|0;n=(c[N>>2]|0)+(X*12&-1)|0;f=o+44|0;v=c[n>>2]|0;x=c[n+4>>2]|0;c[f>>2]=v;c[f+4>>2]=x;V=+g[(c[N>>2]|0)+(X*12&-1)+8>>2];g[o+56>>2]=V;f=(c[O>>2]|0)+(X*12&-1)|0;n=o+64|0;w=c[f+4>>2]|0;c[n>>2]=c[f>>2];c[n+4>>2]=w;g[o+72>>2]=+g[(c[O>>2]|0)+(X*12&-1)+8>>2];Q=+S(+V);g[o+20>>2]=Q;T=+R(+V);g[o+24>>2]=T;V=+g[o+28>>2];U=+g[o+32>>2];w=o+12|0;M=+((c[k>>2]=x,+g[k>>2])-(Q*V+T*U));g[w>>2]=(c[k>>2]=v,+g[k>>2])-(T*V-Q*U);g[w+4>>2]=M;X=X+1|0;}while((X|0)<(c[r>>2]|0))}g[e+20>>2]=0.0;e=c[p+40>>2]|0;X=d+4|0;do{if((c[X>>2]|0)!=0){if((c[u>>2]|0)<=0){break}O=m+16|0;N=0;do{t=c[(c[h>>2]|0)+(N<<2)>>2]|0;w=c[e+(N*152&-1)+144>>2]|0;c[O>>2]=w;if((w|0)>0){v=0;do{g[m+(v<<2)>>2]=+g[e+(N*152&-1)+(v*36&-1)+16>>2];g[m+8+(v<<2)>>2]=+g[e+(N*152&-1)+(v*36&-1)+20>>2];v=v+1|0;}while((v|0)<(w|0))}w=c[X>>2]|0;bL[c[(c[w>>2]|0)+20>>2]&127](w,t,m);N=N+1|0;}while((N|0)<(c[u>>2]|0))}}while(0);if(!j){Y=p+32|0;Z=c[Y>>2]|0;_=e;dg(Z,_);$=p+36|0;aa=c[$>>2]|0;ab=aa;dg(Z,ab);i=l;return}j=c[r>>2]|0;if((j|0)>0){u=d+8|0;M=3.4028234663852886e+38;m=0;while(1){X=c[(c[u>>2]|0)+(m<<2)>>2]|0;L2198:do{if((c[X>>2]|0)==0){ac=M}else{do{if((b[X+4>>1]&4)!=0){U=+g[X+72>>2];if(U*U>.001218469929881394){break}U=+g[X+64>>2];Q=+g[X+68>>2];if(U*U+Q*Q>9999999747378752.0e-20){break}h=X+144|0;Q=q+ +g[h>>2];g[h>>2]=Q;ac=M<Q?M:Q;break L2198}}while(0);g[X+144>>2]=0.0;ac=0.0}}while(0);X=m+1|0;t=c[r>>2]|0;if((X|0)<(t|0)){M=ac;m=X}else{ad=ac;ae=t;break}}}else{ad=3.4028234663852886e+38;ae=j}if(!((ae|0)>0&((ad<.5|W)^1))){Y=p+32|0;Z=c[Y>>2]|0;_=e;dg(Z,_);$=p+36|0;aa=c[$>>2]|0;ab=aa;dg(Z,ab);i=l;return}W=d+8|0;d=0;do{ae=c[(c[W>>2]|0)+(d<<2)>>2]|0;j=ae+4|0;b[j>>1]=b[j>>1]&-3;g[ae+144>>2]=0.0;vq(ae+64|0,0,24);d=d+1|0;}while((d|0)<(c[r>>2]|0));Y=p+32|0;Z=c[Y>>2]|0;_=e;dg(Z,_);$=p+36|0;aa=c[$>>2]|0;ab=aa;dg(Z,ab);i=l;return}function dN(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0,M=0,N=0,O=0,Q=0;f=i;i=i+128|0;h=f|0;j=f+24|0;k=f+72|0;l=a+28|0;m=c[l>>2]|0;if((m|0)<=(d|0)){ba(10776,386,15200,12416)}if((m|0)<=(e|0)){ba(10776,387,15200,9688)}if((m|0)>0){m=a+8|0;n=a+20|0;o=a+24|0;p=0;while(1){q=c[(c[m>>2]|0)+(p<<2)>>2]|0;r=q+44|0;s=(c[n>>2]|0)+(p*12&-1)|0;t=c[r+4>>2]|0;c[s>>2]=c[r>>2];c[s+4>>2]=t;g[(c[n>>2]|0)+(p*12&-1)+8>>2]=+g[q+56>>2];t=q+64|0;s=(c[o>>2]|0)+(p*12&-1)|0;r=c[t+4>>2]|0;c[s>>2]=c[t>>2];c[s+4>>2]=r;g[(c[o>>2]|0)+(p*12&-1)+8>>2]=+g[q+72>>2];q=p+1|0;if((q|0)<(c[l>>2]|0)){p=q}else{u=n;v=o;break}}}else{u=a+20|0;v=a+24|0}o=a+12|0;c[j+24>>2]=c[o>>2];n=a+36|0;c[j+28>>2]=c[n>>2];c[j+40>>2]=c[a>>2];p=j;m=b;c[p>>2]=c[m>>2];c[p+4>>2]=c[m+4>>2];c[p+8>>2]=c[m+8>>2];c[p+12>>2]=c[m+12>>2];c[p+16>>2]=c[m+16>>2];c[p+20>>2]=c[m+20>>2];c[j+32>>2]=c[u>>2];c[j+36>>2]=c[v>>2];en(k,j);j=b+16|0;m=0;while(1){if((m|0)>=(c[j>>2]|0)){break}if(ev(k,d,e)|0){break}else{m=m+1|0}}m=a+8|0;j=(c[u>>2]|0)+(d*12&-1)|0;p=(c[(c[m>>2]|0)+(d<<2)>>2]|0)+36|0;q=c[j+4>>2]|0;c[p>>2]=c[j>>2];c[p+4>>2]=q;g[(c[(c[m>>2]|0)+(d<<2)>>2]|0)+52>>2]=+g[(c[u>>2]|0)+(d*12&-1)+8>>2];d=(c[u>>2]|0)+(e*12&-1)|0;q=(c[(c[m>>2]|0)+(e<<2)>>2]|0)+36|0;p=c[d+4>>2]|0;c[q>>2]=c[d>>2];c[q+4>>2]=p;g[(c[(c[m>>2]|0)+(e<<2)>>2]|0)+52>>2]=+g[(c[u>>2]|0)+(e*12&-1)+8>>2];ep(k);e=b+12|0;if((c[e>>2]|0)>0){p=0;do{er(k);p=p+1|0;}while((p|0)<(c[e>>2]|0))}w=+g[b>>2];if((c[l>>2]|0)>0){b=0;do{e=c[u>>2]|0;p=e+(b*12&-1)|0;x=+g[p>>2];y=+g[p+4>>2];z=+g[e+(b*12&-1)+8>>2];e=c[v>>2]|0;q=e+(b*12&-1)|0;A=+g[q>>2];B=+g[q+4>>2];C=+g[e+(b*12&-1)+8>>2];D=w*A;E=w*B;F=D*D+E*E;if(F>4.0){E=2.0/+P(+F);G=A*E;H=B*E}else{G=A;H=B}B=w*C;if(B*B>2.4674012660980225){if(B>0.0){I=B}else{I=-0.0-B}J=C*(1.5707963705062866/I)}else{J=C}C=x+w*G;x=y+w*H;y=z+w*J;z=+C;B=+x;g[p>>2]=z;g[p+4>>2]=B;g[(c[u>>2]|0)+(b*12&-1)+8>>2]=y;p=(c[v>>2]|0)+(b*12&-1)|0;A=+G;E=+H;g[p>>2]=A;g[p+4>>2]=E;g[(c[v>>2]|0)+(b*12&-1)+8>>2]=J;p=c[(c[m>>2]|0)+(b<<2)>>2]|0;e=p+44|0;g[e>>2]=z;g[e+4>>2]=B;g[p+56>>2]=y;e=p+64|0;g[e>>2]=A;g[e+4>>2]=E;g[p+72>>2]=J;E=+S(+y);g[p+20>>2]=E;A=+R(+y);g[p+24>>2]=A;y=+g[p+28>>2];B=+g[p+32>>2];e=p+12|0;z=+(x-(E*y+A*B));g[e>>2]=C-(A*y-E*B);g[e+4>>2]=z;b=b+1|0;}while((b|0)<(c[l>>2]|0))}l=c[k+40>>2]|0;b=a+4|0;if((c[b>>2]|0)==0){K=k+32|0;L=c[K>>2]|0;M=l;dg(L,M);N=k+36|0;O=c[N>>2]|0;Q=O;dg(L,Q);i=f;return}if((c[n>>2]|0)<=0){K=k+32|0;L=c[K>>2]|0;M=l;dg(L,M);N=k+36|0;O=c[N>>2]|0;Q=O;dg(L,Q);i=f;return}a=h+16|0;m=0;do{v=c[(c[o>>2]|0)+(m<<2)>>2]|0;u=c[l+(m*152&-1)+144>>2]|0;c[a>>2]=u;if((u|0)>0){e=0;do{g[h+(e<<2)>>2]=+g[l+(m*152&-1)+(e*36&-1)+16>>2];g[h+8+(e<<2)>>2]=+g[l+(m*152&-1)+(e*36&-1)+20>>2];e=e+1|0;}while((e|0)<(u|0))}u=c[b>>2]|0;bL[c[(c[u>>2]|0)+20>>2]&127](u,v,h);m=m+1|0;}while((m|0)<(c[n>>2]|0));K=k+32|0;L=c[K>>2]|0;M=l;dg(L,M);N=k+36|0;O=c[N>>2]|0;Q=O;dg(L,Q);i=f;return}function dO(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0;e=b|0;f=b+8|0;c[f>>2]=128;c[b+4>>2]=0;h=vh(1024)|0;c[b>>2]=h;vq(h|0,0,c[f>>2]<<3|0);vq(b+12|0,0,56);do{if((a[22056]&1)==0){f=0;h=1;while(1){if((f|0)>=14){i=1732;break}if((h|0)>(c[22712+(f<<2)>>2]|0)){j=f+1|0;a[h+22064|0]=j&255;k=j}else{a[h+22064|0]=f&255;k=f}j=h+1|0;if((j|0)<641){f=k;h=j}else{i=1737;break}}if((i|0)==1737){a[22056]=1;break}else if((i|0)==1732){ba(5352,73,17368,10976)}}}while(0);c[b+102468>>2]=0;c[b+102472>>2]=0;c[b+102476>>2]=0;c[b+102864>>2]=0;b3(b+102872|0);c[b+102932>>2]=0;c[b+102936>>2]=0;c[b+102940>>2]=4192;c[b+102944>>2]=4184;i=b+102948|0;c[b+102980>>2]=0;c[b+102984>>2]=0;vq(i|0,0,20);a[b+102992|0]=1;a[b+102993|0]=1;a[b+102994|0]=0;a[b+102995|0]=1;a[b+102976|0]=1;k=d;d=b+102968|0;h=c[k+4>>2]|0;c[d>>2]=c[k>>2];c[d+4>>2]=h;c[b+102868>>2]=4;g[b+102988>>2]=0.0;c[i>>2]=e;vq(b+102996|0,0,32);return}function dP(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;b=c[a+102952>>2]|0;if((b|0)!=0){d=a|0;e=b;while(1){b=c[e+96>>2]|0;f=c[e+100>>2]|0;while(1){if((f|0)==0){break}g=c[f+4>>2]|0;c[f+28>>2]=0;dK(f,d);f=g}if((b|0)==0){break}else{e=b}}}vi(c[a+102904>>2]|0);vi(c[a+102916>>2]|0);vi(c[a+102876>>2]|0);if((c[a+102468>>2]|0)!=0){ba(4840,32,17e3,10664)}if((c[a+102864>>2]|0)!=0){ba(4840,33,17e3,7952)}e=a+4|0;d=a|0;a=c[d>>2]|0;if((c[e>>2]|0)>0){h=0;i=a}else{j=a;k=j;vi(k);return}while(1){vi(c[i+(h<<3)+4>>2]|0);a=h+1|0;f=c[d>>2]|0;if((a|0)<(c[e>>2]|0)){h=a;i=f}else{j=f;break}}k=j;vi(k);return}function dQ(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;e=b+102960|0;if((c[e>>2]|0)<=0){ba(10624,133,15568,9672)}if((c[b+102868>>2]&2|0)!=0){ba(10624,134,15568,12392)}f=d+108|0;g=c[f>>2]|0;if((g|0)!=0){h=b+102980|0;i=g;while(1){g=c[i+12>>2]|0;j=c[h>>2]|0;if((j|0)==0){k=i+4|0}else{l=i+4|0;bp[c[(c[j>>2]|0)+8>>2]&511](j,c[l>>2]|0);k=l}dR(b,c[k>>2]|0);c[f>>2]=g;if((g|0)==0){break}else{i=g}}}c[f>>2]=0;f=d+112|0;i=c[f>>2]|0;if((i|0)!=0){k=b+102872|0;h=i;while(1){i=c[h+12>>2]|0;dp(k,c[h+4>>2]|0);if((i|0)==0){break}else{h=i}}}c[f>>2]=0;f=d+100|0;h=c[f>>2]|0;L2321:do{if((h|0)==0){m=d+104|0}else{k=b+102980|0;i=b+102912|0;g=b+102904|0;l=b+102900|0;j=b+102872|0;n=b|0;o=d+104|0;p=h;while(1){q=c[p+4>>2]|0;r=c[k>>2]|0;if((r|0)!=0){bp[c[(c[r>>2]|0)+12>>2]&511](r,p)}r=p+28|0;if((c[r>>2]|0)>0){s=p+24|0;t=0;do{u=(c[s>>2]|0)+(t*28&-1)+24|0;v=c[u>>2]|0;w=c[i>>2]|0;x=0;while(1){if((x|0)>=(w|0)){break}y=(c[g>>2]|0)+(x<<2)|0;if((c[y>>2]|0)==(v|0)){z=1790;break}else{x=x+1|0}}if((z|0)==1790){z=0;c[y>>2]=-1}c[l>>2]=(c[l>>2]|0)-1;cl(j,v);c[u>>2]=-1;t=t+1|0;}while((t|0)<(c[r>>2]|0))}c[r>>2]=0;dK(p,n);t=a[22108]|0;if((t&255)>=14){break}s=b+12+((t&255)<<2)|0;c[p>>2]=c[s>>2];c[s>>2]=p;c[f>>2]=q;c[o>>2]=(c[o>>2]|0)-1;if((q|0)==0){m=o;break L2321}else{p=q}}ba(5352,173,17448,6544)}}while(0);c[f>>2]=0;c[m>>2]=0;m=d+92|0;f=c[m>>2]|0;y=d+96|0;if((f|0)!=0){c[f+96>>2]=c[y>>2]}f=c[y>>2]|0;if((f|0)!=0){c[f+92>>2]=c[m>>2]}m=b+102952|0;if((c[m>>2]|0)==(d|0)){c[m>>2]=c[y>>2]}c[e>>2]=(c[e>>2]|0)-1;e=a[22216]|0;if((e&255)<14){y=b+12+((e&255)<<2)|0;c[d>>2]=c[y>>2];c[y>>2]=d;return}else{ba(5352,173,17448,6544)}}function dR(d,e){d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0,l=0,m=0;if((c[d+102868>>2]&2|0)!=0){ba(10624,274,15528,12392)}f=a[e+61|0]&1;h=e+8|0;i=c[h>>2]|0;j=e+12|0;if((i|0)!=0){c[i+12>>2]=c[j>>2]}i=c[j>>2]|0;if((i|0)!=0){c[i+8>>2]=c[h>>2]}h=d+102956|0;if((c[h>>2]|0)==(e|0)){c[h>>2]=c[j>>2]}j=c[e+48>>2]|0;h=c[e+52>>2]|0;i=j+4|0;k=b[i>>1]|0;if((k&2)==0){b[i>>1]=k|2;g[j+144>>2]=0.0}k=h+4|0;i=b[k>>1]|0;if((i&2)==0){b[k>>1]=i|2;g[h+144>>2]=0.0}i=e+24|0;k=c[i>>2]|0;l=e+28|0;if((k|0)!=0){c[k+12>>2]=c[l>>2]}k=c[l>>2]|0;if((k|0)!=0){c[k+8>>2]=c[i>>2]}k=j+108|0;if((e+16|0)==(c[k>>2]|0)){c[k>>2]=c[l>>2]}c[i>>2]=0;c[l>>2]=0;l=e+40|0;i=c[l>>2]|0;k=e+44|0;if((i|0)!=0){c[i+12>>2]=c[k>>2]}i=c[k>>2]|0;if((i|0)!=0){c[i+8>>2]=c[l>>2]}i=h+108|0;if((e+32|0)==(c[i>>2]|0)){c[i>>2]=c[k>>2]}c[l>>2]=0;c[k>>2]=0;fl(e,d|0);e=d+102964|0;d=c[e>>2]|0;if((d|0)<=0){ba(10624,346,15528,7232)}c[e>>2]=d-1;if(f<<24>>24!=0){return}f=c[h+112>>2]|0;if((f|0)==0){return}else{m=f}do{if((c[m>>2]|0)==(j|0)){f=(c[m+4>>2]|0)+4|0;c[f>>2]=c[f>>2]|8}m=c[m+12>>2]|0;}while((m|0)!=0);return}function dS(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;if((c[b+102868>>2]&2|0)!=0){ba(10624,214,15608,12392);return 0}e=fk(d,b|0)|0;c[e+8>>2]=0;f=b+102956|0;c[e+12>>2]=c[f>>2];g=c[f>>2]|0;if((g|0)!=0){c[g+8>>2]=e}c[f>>2]=e;f=b+102964|0;c[f>>2]=(c[f>>2]|0)+1;f=e+16|0;c[e+20>>2]=e;b=e+52|0;c[f>>2]=c[b>>2];c[e+24>>2]=0;g=e+48|0;h=c[g>>2]|0;i=h+108|0;c[e+28>>2]=c[i>>2];j=c[i>>2]|0;if((j|0)==0){k=h}else{c[j+8>>2]=f;k=c[g>>2]|0}c[k+108>>2]=f;f=e+32|0;c[e+36>>2]=e;c[f>>2]=c[g>>2];c[e+40>>2]=0;g=c[b>>2]|0;k=g+108|0;c[e+44>>2]=c[k>>2];j=c[k>>2]|0;if((j|0)==0){l=g}else{c[j+8>>2]=f;l=c[b>>2]|0}c[l+108>>2]=f;f=c[d+8>>2]|0;if((a[d+16|0]&1)!=0){return e|0}l=c[(c[d+12>>2]|0)+112>>2]|0;if((l|0)==0){return e|0}else{m=l}do{if((c[m>>2]|0)==(f|0)){l=(c[m+4>>2]|0)+4|0;c[l>>2]=c[l>>2]|8}m=c[m+12>>2]|0;}while((m|0)!=0);return e|0}function dT(d,e){d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0.0,af=0.0,ag=0.0,ah=0.0,ai=0.0;f=i;i=i+104|0;h=f|0;j=f+16|0;k=f+72|0;l=d+103008|0;g[l>>2]=0.0;m=d+103012|0;g[m>>2]=0.0;n=d+103016|0;g[n>>2]=0.0;o=d+102960|0;p=d+102872|0;q=d+68|0;dL(j,c[o>>2]|0,c[d+102936>>2]|0,c[d+102964>>2]|0,q,c[d+102944>>2]|0);r=d+102952|0;s=c[r>>2]|0;if((s|0)!=0){t=s;do{s=t+4|0;b[s>>1]=b[s>>1]&-2;t=c[t+96>>2]|0;}while((t|0)!=0)}t=c[d+102932>>2]|0;if((t|0)!=0){s=t;do{t=s+4|0;c[t>>2]=c[t>>2]&-2;s=c[s+12>>2]|0;}while((s|0)!=0)}s=c[d+102956>>2]|0;if((s|0)!=0){t=s;do{a[t+60|0]=0;t=c[t+12>>2]|0;}while((t|0)!=0)}t=c[o>>2]|0;o=t<<2;s=d+102864|0;u=c[s>>2]|0;if((u|0)>=32){ba(4840,38,17040,6448)}v=d+102480+(u*12&-1)|0;c[d+102480+(u*12&-1)+4>>2]=o;w=d+102468|0;x=c[w>>2]|0;if((x+o|0)>102400){c[v>>2]=vh(o)|0;a[d+102480+(u*12&-1)+8|0]=1}else{c[v>>2]=x+(d+68);a[d+102480+(u*12&-1)+8|0]=0;c[w>>2]=(c[w>>2]|0)+o}w=d+102472|0;u=(c[w>>2]|0)+o|0;c[w>>2]=u;w=d+102476|0;o=c[w>>2]|0;c[w>>2]=(o|0)>(u|0)?o:u;c[s>>2]=(c[s>>2]|0)+1;s=c[v>>2]|0;v=s;u=c[r>>2]|0;L2451:do{if((u|0)!=0){o=j+28|0;w=j+36|0;x=j+32|0;y=j+40|0;z=j+8|0;A=j+48|0;B=j+16|0;C=j+44|0;D=j+12|0;E=d+102968|0;F=d+102976|0;G=k+12|0;H=k+16|0;I=k+20|0;J=u;L2453:while(1){K=J+4|0;do{if((b[K>>1]&35)==34){if((c[J>>2]|0)==0){break}c[o>>2]=0;c[w>>2]=0;c[x>>2]=0;c[v>>2]=J;b[K>>1]=b[K>>1]|1;L=1;while(1){M=L-1|0;N=c[v+(M<<2)>>2]|0;O=N+4|0;if((b[O>>1]&32)==0){P=1882;break L2453}Q=c[o>>2]|0;if((Q|0)>=(c[y>>2]|0)){P=1885;break L2453}c[N+8>>2]=Q;c[(c[z>>2]|0)+(c[o>>2]<<2)>>2]=N;c[o>>2]=(c[o>>2]|0)+1;Q=b[O>>1]|0;if((Q&2)==0){b[O>>1]=Q|2;g[N+144>>2]=0.0}do{if((c[N>>2]|0)==0){T=M}else{Q=c[N+112>>2]|0;if((Q|0)==0){U=M}else{O=M;V=Q;while(1){Q=c[V+4>>2]|0;W=Q+4|0;do{if((c[W>>2]&7|0)==6){if((a[(c[Q+48>>2]|0)+38|0]&1)!=0){X=O;break}if((a[(c[Q+52>>2]|0)+38|0]&1)!=0){X=O;break}Y=c[w>>2]|0;if((Y|0)>=(c[C>>2]|0)){P=1896;break L2453}c[w>>2]=Y+1;c[(c[D>>2]|0)+(Y<<2)>>2]=Q;c[W>>2]=c[W>>2]|1;Y=c[V>>2]|0;Z=Y+4|0;if((b[Z>>1]&1)!=0){X=O;break}if((O|0)>=(t|0)){P=1900;break L2453}c[v+(O<<2)>>2]=Y;b[Z>>1]=b[Z>>1]|1;X=O+1|0}else{X=O}}while(0);W=c[V+12>>2]|0;if((W|0)==0){U=X;break}else{O=X;V=W}}}V=c[N+108>>2]|0;if((V|0)==0){T=U;break}else{_=U;$=V}while(1){V=$+4|0;O=c[V>>2]|0;do{if((a[O+60|0]&1)==0){W=c[$>>2]|0;Q=W+4|0;if((b[Q>>1]&32)==0){aa=_;break}Z=c[x>>2]|0;if((Z|0)>=(c[A>>2]|0)){P=1908;break L2453}c[x>>2]=Z+1;c[(c[B>>2]|0)+(Z<<2)>>2]=O;a[(c[V>>2]|0)+60|0]=1;if((b[Q>>1]&1)!=0){aa=_;break}if((_|0)>=(t|0)){P=1912;break L2453}c[v+(_<<2)>>2]=W;b[Q>>1]=b[Q>>1]|1;aa=_+1|0}else{aa=_}}while(0);V=c[$+12>>2]|0;if((V|0)==0){T=aa;break}else{_=aa;$=V}}}}while(0);if((T|0)>0){L=T}else{break}}dM(j,k,e,E,(a[F]&1)!=0);g[l>>2]=+g[G>>2]+ +g[l>>2];g[m>>2]=+g[H>>2]+ +g[m>>2];g[n>>2]=+g[I>>2]+ +g[n>>2];L=c[o>>2]|0;if((L|0)>0){ab=0;ac=L}else{break}while(1){L=c[(c[z>>2]|0)+(ab<<2)>>2]|0;if((c[L>>2]|0)==0){N=L+4|0;b[N>>1]=b[N>>1]&-2;ad=c[o>>2]|0}else{ad=ac}N=ab+1|0;if((N|0)<(ad|0)){ab=N;ac=ad}else{break}}}}while(0);J=c[J+96>>2]|0;if((J|0)==0){break L2451}}if((P|0)==1896){ba(8576,62,15264,8040)}else if((P|0)==1900){ba(10624,495,15488,5752)}else if((P|0)==1885){ba(8576,54,15328,7760)}else if((P|0)==1882){ba(10624,445,15488,6264)}else if((P|0)==1912){ba(10624,524,15488,5752)}else if((P|0)==1908){ba(8576,68,15296,8280)}}}while(0);dg(q,s);s=c[r>>2]|0;if((s|0)!=0){r=h|0;q=h;P=h+8|0;h=P;ad=P+4|0;P=s;do{do{if((b[P+4>>1]&1)!=0){if((c[P>>2]|0)==0){break}ae=+g[P+52>>2];af=+S(+ae);g[h>>2]=af;ag=+R(+ae);g[ad>>2]=ag;ae=+g[P+28>>2];ah=+g[P+32>>2];ai=+(+g[P+40>>2]-(af*ae+ag*ah));g[r>>2]=+g[P+36>>2]-(ag*ae-af*ah);g[r+4>>2]=ai;s=(c[P+88>>2]|0)+102872|0;ac=c[P+100>>2]|0;if((ac|0)==0){break}ab=P+12|0;n=ac;do{dH(n,s,q,ab);n=c[n+4>>2]|0;}while((n|0)!=0)}}while(0);P=c[P+96>>2]|0;}while((P|0)!=0)}dy(p|0,p);g[d+103020>>2]=0.0;d=j|0;dg(c[d>>2]|0,c[j+20>>2]|0);dg(c[d>>2]|0,c[j+24>>2]|0);dg(c[d>>2]|0,c[j+16>>2]|0);dg(c[d>>2]|0,c[j+12>>2]|0);dg(c[d>>2]|0,c[j+8>>2]|0);i=f;return}function dU(d,e){d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0.0,ag=0,ah=0,ai=0,aj=0,ak=0.0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0.0,aw=0.0,ax=0.0,ay=0.0,az=0,aA=0.0,aB=0.0,aC=0.0,aD=0.0,aE=0,aF=0.0,aG=0.0,aH=0,aI=0,aJ=0,aK=0,aL=0,aM=0,aN=0,aO=0,aP=0,aQ=0,aR=0,aS=0,aT=0,aU=0,aV=0,aW=0,aX=0,aY=0,aZ=0,a_=0,a$=0,a0=0,a1=0,a2=0,a3=0,a4=0,a5=0,a6=0,a7=0,a8=0,a9=0,bb=0,bc=0,bd=0;f=i;i=i+368|0;h=f|0;j=f+16|0;k=f+72|0;l=f+208|0;m=f+216|0;n=f+256|0;o=f+296|0;p=f+304|0;q=f+344|0;r=d+102872|0;s=d+102944|0;dL(j,64,32,0,d+68|0,c[s>>2]|0);t=d+102995|0;do{if((a[t]&1)==0){u=d+102932|0}else{v=c[d+102952>>2]|0;if((v|0)!=0){w=v;do{v=w+4|0;b[v>>1]=b[v>>1]&-2;g[w+60>>2]=0.0;w=c[w+96>>2]|0;}while((w|0)!=0)}w=d+102932|0;v=c[w>>2]|0;if((v|0)==0){u=w;break}else{x=v}while(1){v=x+4|0;c[v>>2]=c[v>>2]&-34;c[x+128>>2]=0;g[x+132>>2]=1.0;v=c[x+12>>2]|0;if((v|0)==0){u=w;break}else{x=v}}}}while(0);x=m;m=n;n=j+28|0;w=j+36|0;v=j+32|0;y=j+40|0;z=j+8|0;A=j+44|0;B=j+12|0;C=o|0;D=o+4|0;E=p;p=e|0;F=q|0;G=q+4|0;H=q+8|0;I=q+16|0;J=e+12|0;e=q+12|0;K=q+20|0;L=r|0;M=d+102994|0;d=h|0;N=h;O=h+8|0;h=O;P=O+4|0;O=k+16|0;Q=k+20|0;T=k+24|0;U=k+44|0;V=k+48|0;W=k+52|0;X=k|0;Y=k+28|0;Z=k+56|0;_=k+92|0;$=k+128|0;aa=l|0;ab=l+4|0;L2537:while(1){ac=c[u>>2]|0;if((ac|0)==0){ad=1;ae=2066;break}else{af=1.0;ag=0;ah=ac}while(1){ac=ah+4|0;ai=c[ac>>2]|0;do{if((ai&4|0)==0){aj=ag;ak=af}else{if((c[ah+128>>2]|0)>8){aj=ag;ak=af;break}if((ai&32|0)==0){al=c[ah+48>>2]|0;am=c[ah+52>>2]|0;if((a[al+38|0]&1)!=0){aj=ag;ak=af;break}if((a[am+38|0]&1)!=0){aj=ag;ak=af;break}an=c[al+8>>2]|0;ao=c[am+8>>2]|0;ap=c[an>>2]|0;aq=c[ao>>2]|0;ar=(aq|0)==2;if(!((ap|0)==2|ar)){ae=1961;break L2537}as=b[an+4>>1]|0;at=b[ao+4>>1]|0;if(((as&2)==0|(ap|0)==0)&((at&2)==0|(aq|0)==0)){aj=ag;ak=af;break}if((as&8)==0){au=(ap|0)!=2&1}else{au=1}if((at&8)==0){if((au|0)==0&ar){aj=ag;ak=af;break}}ar=an+28|0;at=an+60|0;av=+g[at>>2];ap=ao+28|0;as=ao+60|0;aw=+g[as>>2];do{if(av<aw){if(av>=1.0){ae=1970;break L2537}ax=(aw-av)/(1.0-av);aq=an+36|0;ay=1.0-ax;az=aq;aA=+(ay*+g[an+40>>2]+ax*+g[an+48>>2]);g[az>>2]=+g[aq>>2]*ay+ax*+g[an+44>>2];g[az+4>>2]=aA;az=an+52|0;g[az>>2]=ay*+g[az>>2]+ax*+g[an+56>>2];g[at>>2]=aw;aB=aw}else{if(aw>=av){aB=av;break}if(aw>=1.0){ae=1975;break L2537}ax=(av-aw)/(1.0-aw);az=ao+36|0;ay=1.0-ax;aq=az;aA=+(ay*+g[ao+40>>2]+ax*+g[ao+48>>2]);g[aq>>2]=+g[az>>2]*ay+ax*+g[ao+44>>2];g[aq+4>>2]=aA;aq=ao+52|0;g[aq>>2]=ay*+g[aq>>2]+ax*+g[ao+56>>2];g[as>>2]=av;aB=av}}while(0);if(aB>=1.0){ae=1979;break L2537}as=c[ah+56>>2]|0;ao=c[ah+60>>2]|0;c[O>>2]=0;c[Q>>2]=0;g[T>>2]=0.0;c[U>>2]=0;c[V>>2]=0;g[W>>2]=0.0;cf(X,c[al+12>>2]|0,as);cf(Y,c[am+12>>2]|0,ao);ao=ar;vp(Z|0,ao|0,36)|0;ao=ap;vp(_|0,ao|0,36)|0;g[$>>2]=1.0;cu(l,k);if((c[aa>>2]|0)==3){av=aB+(1.0-aB)*+g[ab>>2];aC=av<1.0?av:1.0}else{aC=1.0}g[ah+132>>2]=aC;c[ac>>2]=c[ac>>2]|32;aD=aC}else{aD=+g[ah+132>>2]}if(aD>=af){aj=ag;ak=af;break}aj=ah;ak=aD}}while(0);ac=c[ah+12>>2]|0;if((ac|0)==0){break}else{af=ak;ag=aj;ah=ac}}if((aj|0)==0|ak>.9999988079071045){ad=1;ae=2065;break}ac=c[(c[aj+48>>2]|0)+8>>2]|0;ai=c[(c[aj+52>>2]|0)+8>>2]|0;ao=ac+28|0;vp(x|0,ao|0,36)|0;as=ai+28|0;vp(m|0,as|0,36)|0;at=ac+60|0;av=+g[at>>2];if(av>=1.0){ae=1992;break}aw=(ak-av)/(1.0-av);an=ac+36|0;av=1.0-aw;aq=ac+44|0;az=ac+48|0;ax=+g[an>>2]*av+aw*+g[aq>>2];ay=av*+g[ac+40>>2]+aw*+g[az>>2];aE=an;aA=+ax;aF=+ay;g[aE>>2]=aA;g[aE+4>>2]=aF;aE=ac+52|0;an=ac+56|0;aG=av*+g[aE>>2]+aw*+g[an>>2];g[aE>>2]=aG;g[at>>2]=ak;at=ac+44|0;g[at>>2]=aA;g[at+4>>2]=aF;g[an>>2]=aG;aF=+S(+aG);at=ac+20|0;g[at>>2]=aF;aA=+R(+aG);aE=ac+24|0;g[aE>>2]=aA;aH=ac+28|0;aG=+g[aH>>2];aI=ac+32|0;aw=+g[aI>>2];aJ=ac+12|0;av=+(ay-(aF*aG+aA*aw));g[aJ>>2]=ax-(aA*aG-aF*aw);g[aJ+4>>2]=av;aK=ai+60|0;av=+g[aK>>2];if(av>=1.0){ae=1995;break}aw=(ak-av)/(1.0-av);aL=ai+36|0;av=1.0-aw;aM=ai+44|0;aN=ai+48|0;aF=+g[aL>>2]*av+aw*+g[aM>>2];aG=av*+g[ai+40>>2]+aw*+g[aN>>2];aO=aL;aA=+aF;ax=+aG;g[aO>>2]=aA;g[aO+4>>2]=ax;aO=ai+52|0;aL=ai+56|0;ay=av*+g[aO>>2]+aw*+g[aL>>2];g[aO>>2]=ay;g[aK>>2]=ak;aK=ai+44|0;g[aK>>2]=aA;g[aK+4>>2]=ax;g[aL>>2]=ay;ax=+S(+ay);aK=ai+20|0;g[aK>>2]=ax;aA=+R(+ay);aO=ai+24|0;g[aO>>2]=aA;aP=ai+28|0;ay=+g[aP>>2];aQ=ai+32|0;aw=+g[aQ>>2];aR=ai+12|0;av=+(aG-(ax*ay+aA*aw));g[aR>>2]=aF-(aA*ay-ax*aw);g[aR+4>>2]=av;eh(aj,c[s>>2]|0);aS=aj+4|0;aT=c[aS>>2]|0;c[aS>>2]=aT&-33;aU=aj+128|0;c[aU>>2]=(c[aU>>2]|0)+1;if((aT&6|0)!=6){c[aS>>2]=aT&-37;vp(ao|0,x|0,36)|0;vp(as|0,m|0,36)|0;av=+g[an>>2];aw=+S(+av);g[at>>2]=aw;ax=+R(+av);g[aE>>2]=ax;av=+g[aH>>2];ay=+g[aI>>2];aA=+(+g[az>>2]-(aw*av+ax*ay));g[aJ>>2]=+g[aq>>2]-(ax*av-aw*ay);g[aJ+4>>2]=aA;aA=+g[aL>>2];ay=+S(+aA);g[aK>>2]=ay;aw=+R(+aA);g[aO>>2]=aw;aA=+g[aP>>2];av=+g[aQ>>2];ax=+(+g[aN>>2]-(ay*aA+aw*av));g[aR>>2]=+g[aM>>2]-(aw*aA-ay*av);g[aR+4>>2]=ax;continue}aR=ac+4|0;aM=b[aR>>1]|0;if((aM&2)==0){b[aR>>1]=aM|2;g[ac+144>>2]=0.0}aM=ai+4|0;aN=b[aM>>1]|0;if((aN&2)==0){b[aM>>1]=aN|2;g[ai+144>>2]=0.0}c[n>>2]=0;c[w>>2]=0;c[v>>2]=0;aN=c[y>>2]|0;if((aN|0)<=0){ae=2005;break}aQ=ac+8|0;c[aQ>>2]=0;aP=c[z>>2]|0;c[aP>>2]=ac;c[n>>2]=1;if((aN|0)<=1){ae=2008;break}aN=ai+8|0;c[aN>>2]=1;c[aP+4>>2]=ai;c[n>>2]=2;if((c[A>>2]|0)<=0){ae=2011;break}c[w>>2]=1;c[c[B>>2]>>2]=aj;b[aR>>1]=b[aR>>1]|1;b[aM>>1]=b[aM>>1]|1;c[aS>>2]=c[aS>>2]|1;c[C>>2]=ac;c[D>>2]=ai;ai=1;aS=ac;while(1){L2593:do{if((c[aS>>2]|0)==2){ac=c[aS+112>>2]|0;if((ac|0)==0){break}aM=aS+4|0;aR=c[y>>2]|0;aP=ac;ac=c[n>>2]|0;while(1){if((ac|0)==(aR|0)){break L2593}aO=c[w>>2]|0;aK=c[A>>2]|0;if((aO|0)==(aK|0)){break L2593}aL=c[aP+4>>2]|0;aJ=aL+4|0;L2600:do{if((c[aJ>>2]&1|0)==0){aq=c[aP>>2]|0;az=aq|0;do{if((c[az>>2]|0)==2){if((b[aM>>1]&8)!=0){break}if((b[aq+4>>1]&8)==0){aV=ac;break L2600}}}while(0);if((a[(c[aL+48>>2]|0)+38|0]&1)!=0){aV=ac;break}if((a[(c[aL+52>>2]|0)+38|0]&1)!=0){aV=ac;break}aI=aq+28|0;vp(E|0,aI|0,36)|0;aH=aq+4|0;if((b[aH>>1]&1)==0){aE=aq+60|0;ax=+g[aE>>2];if(ax>=1.0){ae=2027;break L2537}av=(ak-ax)/(1.0-ax);at=aq+36|0;ax=1.0-av;ay=+g[at>>2]*ax+av*+g[aq+44>>2];aA=ax*+g[aq+40>>2]+av*+g[aq+48>>2];an=at;aw=+ay;aF=+aA;g[an>>2]=aw;g[an+4>>2]=aF;an=aq+52|0;at=aq+56|0;aG=ax*+g[an>>2]+av*+g[at>>2];g[an>>2]=aG;g[aE>>2]=ak;aE=aq+44|0;g[aE>>2]=aw;g[aE+4>>2]=aF;g[at>>2]=aG;aF=+S(+aG);g[aq+20>>2]=aF;aw=+R(+aG);g[aq+24>>2]=aw;aG=+g[aq+28>>2];av=+g[aq+32>>2];at=aq+12|0;ax=+(aA-(aF*aG+aw*av));g[at>>2]=ay-(aw*aG-aF*av);g[at+4>>2]=ax}eh(aL,c[s>>2]|0);at=c[aJ>>2]|0;if((at&4|0)==0){vp(aI|0,E|0,36)|0;ax=+g[aq+56>>2];av=+S(+ax);g[aq+20>>2]=av;aF=+R(+ax);g[aq+24>>2]=aF;ax=+g[aq+28>>2];aG=+g[aq+32>>2];aE=aq+12|0;aw=+(+g[aq+48>>2]-(av*ax+aF*aG));g[aE>>2]=+g[aq+44>>2]-(aF*ax-av*aG);g[aE+4>>2]=aw;aV=ac;break}if((at&2|0)==0){vp(aI|0,E|0,36)|0;aw=+g[aq+56>>2];aG=+S(+aw);g[aq+20>>2]=aG;av=+R(+aw);g[aq+24>>2]=av;aw=+g[aq+28>>2];ax=+g[aq+32>>2];aI=aq+12|0;aF=+(+g[aq+48>>2]-(aG*aw+av*ax));g[aI>>2]=+g[aq+44>>2]-(av*aw-aG*ax);g[aI+4>>2]=aF;aV=ac;break}c[aJ>>2]=at|1;if((aO|0)>=(aK|0)){ae=2036;break L2537}c[w>>2]=aO+1;c[(c[B>>2]|0)+(aO<<2)>>2]=aL;at=b[aH>>1]|0;if((at&1)!=0){aV=ac;break}b[aH>>1]=at|1;do{if((c[az>>2]|0)!=0){if((at&2)!=0){break}b[aH>>1]=at|3;g[aq+144>>2]=0.0}}while(0);if((ac|0)>=(aR|0)){ae=2043;break L2537}c[aq+8>>2]=ac;c[(c[z>>2]|0)+(ac<<2)>>2]=aq;at=ac+1|0;c[n>>2]=at;aV=at}else{aV=ac}}while(0);aL=c[aP+12>>2]|0;if((aL|0)==0){break}else{aP=aL;ac=aV}}}}while(0);if((ai|0)>=2){break}ac=c[o+(ai<<2)>>2]|0;ai=ai+1|0;aS=ac}aF=(1.0-ak)*+g[p>>2];g[F>>2]=aF;g[G>>2]=1.0/aF;g[H>>2]=1.0;c[I>>2]=20;c[e>>2]=c[J>>2];a[K]=0;dN(j,q,c[aQ>>2]|0,c[aN>>2]|0);aS=c[n>>2]|0;if((aS|0)>0){ai=c[z>>2]|0;ac=0;do{aP=c[ai+(ac<<2)>>2]|0;aR=aP+4|0;b[aR>>1]=b[aR>>1]&-2;do{if((c[aP>>2]|0)==2){aF=+g[aP+52>>2];ax=+S(+aF);g[h>>2]=ax;aG=+R(+aF);g[P>>2]=aG;aF=+g[aP+28>>2];aw=+g[aP+32>>2];av=+(+g[aP+40>>2]-(ax*aF+aG*aw));g[d>>2]=+g[aP+36>>2]-(aG*aF-ax*aw);g[d+4>>2]=av;aR=(c[aP+88>>2]|0)+102872|0;aM=c[aP+100>>2]|0;if((aM|0)!=0){ap=aP+12|0;ar=aM;do{dH(ar,aR,N,ap);ar=c[ar+4>>2]|0;}while((ar|0)!=0)}ar=c[aP+112>>2]|0;if((ar|0)==0){break}else{aW=ar}do{ar=(c[aW+4>>2]|0)+4|0;c[ar>>2]=c[ar>>2]&-34;aW=c[aW+12>>2]|0;}while((aW|0)!=0)}}while(0);ac=ac+1|0;}while((ac|0)<(aS|0))}dy(L,r);if((a[M]&1)!=0){ad=0;ae=2067;break}}if((ae|0)==2065){a[t]=ad;aX=j|0;aY=c[aX>>2]|0;aZ=j+20|0;a_=c[aZ>>2]|0;a$=a_;dg(aY,a$);a0=c[aX>>2]|0;a1=j+24|0;a2=c[a1>>2]|0;a3=a2;dg(a0,a3);a4=c[aX>>2]|0;a5=j+16|0;a6=c[a5>>2]|0;a7=a6;dg(a4,a7);a8=c[aX>>2]|0;a9=c[B>>2]|0;bb=a9;dg(a8,bb);bc=c[z>>2]|0;bd=bc;dg(a8,bd);i=f;return}else if((ae|0)==2066){a[t]=ad;aX=j|0;aY=c[aX>>2]|0;aZ=j+20|0;a_=c[aZ>>2]|0;a$=a_;dg(aY,a$);a0=c[aX>>2]|0;a1=j+24|0;a2=c[a1>>2]|0;a3=a2;dg(a0,a3);a4=c[aX>>2]|0;a5=j+16|0;a6=c[a5>>2]|0;a7=a6;dg(a4,a7);a8=c[aX>>2]|0;a9=c[B>>2]|0;bb=a9;dg(a8,bb);bc=c[z>>2]|0;bd=bc;dg(a8,bd);i=f;return}else if((ae|0)==2067){a[t]=ad;aX=j|0;aY=c[aX>>2]|0;aZ=j+20|0;a_=c[aZ>>2]|0;a$=a_;dg(aY,a$);a0=c[aX>>2]|0;a1=j+24|0;a2=c[a1>>2]|0;a3=a2;dg(a0,a3);a4=c[aX>>2]|0;a5=j+16|0;a6=c[a5>>2]|0;a7=a6;dg(a4,a7);a8=c[aX>>2]|0;a9=c[B>>2]|0;bb=a9;dg(a8,bb);bc=c[z>>2]|0;bd=bc;dg(a8,bd);i=f;return}else if((ae|0)==1979){ba(10624,676,15440,4888)}else if((ae|0)==1995){ba(8768,723,15712,4888)}else if((ae|0)==1975){ba(8768,723,15712,4888)}else if((ae|0)==2043){ba(8576,54,15328,7760)}else if((ae|0)==2008){ba(8576,54,15328,7760)}else if((ae|0)==2036){ba(8576,62,15264,8040)}else if((ae|0)==1992){ba(8768,723,15712,4888)}else if((ae|0)==2027){ba(8768,723,15712,4888)}else if((ae|0)==1961){ba(10624,641,15440,5216)}else if((ae|0)==1970){ba(8768,723,15712,4888)}else if((ae|0)==2011){ba(8576,62,15264,8040)}else if((ae|0)==2005){ba(8576,54,15328,7760)}}function dV(b,d,e,f){b=b|0;d=+d;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0;h=i;i=i+24|0;j=h|0;k=b+102868|0;l=c[k>>2]|0;if((l&1|0)==0){m=l}else{l=b+102872|0;dy(l|0,l);l=c[k>>2]&-2;c[k>>2]=l;m=l}c[k>>2]=m|2;m=j|0;g[m>>2]=d;c[j+12>>2]=e;c[j+16>>2]=f;f=d>0.0;if(f){g[j+4>>2]=1.0/d}else{g[j+4>>2]=0.0}e=b+102988|0;g[j+8>>2]=+g[e>>2]*d;a[j+20|0]=a[b+102992|0]&1;dx(b+102872|0);g[b+103e3>>2]=0.0;if(!((a[b+102995|0]&1)==0|f^1)){dT(b,j);g[b+103004>>2]=0.0}do{if((a[b+102993|0]&1)==0){n=2078}else{d=+g[m>>2];if(d<=0.0){o=d;break}dU(b,j);g[b+103024>>2]=0.0;n=2078}}while(0);if((n|0)==2078){o=+g[m>>2]}if(o>0.0){g[e>>2]=+g[j+4>>2]}j=c[k>>2]|0;if((j&4|0)==0){p=j;q=p&-3;c[k>>2]=q;r=b+102996|0;g[r>>2]=0.0;i=h;return}e=c[b+102952>>2]|0;if((e|0)==0){p=j;q=p&-3;c[k>>2]=q;r=b+102996|0;g[r>>2]=0.0;i=h;return}else{s=e}do{g[s+76>>2]=0.0;g[s+80>>2]=0.0;g[s+84>>2]=0.0;s=c[s+96>>2]|0;}while((s|0)!=0);p=c[k>>2]|0;q=p&-3;c[k>>2]=q;r=b+102996|0;g[r>>2]=0.0;i=h;return}function dW(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;d=i;i=i+56|0;e=d|0;f=d+8|0;h=d+16|0;j=d+24|0;k=d+32|0;l=d+48|0;m=l;n=i;i=i+8|0;o=n;p=(c[b+52>>2]|0)+12|0;q=(c[b+48>>2]|0)+12|0;r=c[q+4>>2]|0;c[e>>2]=c[q>>2];c[e+4>>2]=r;r=p;p=c[r+4>>2]|0;c[f>>2]=c[r>>2];c[f+4>>2]=p;p=b;bp[c[c[p>>2]>>2]&511](h,b);bp[c[(c[p>>2]|0)+4>>2]&511](j,b);g[k>>2]=.5;g[k+4>>2]=.800000011920929;g[k+8>>2]=.800000011920929;p=c[b+4>>2]|0;if((p|0)==5){i=d;return}else if((p|0)==3){r=c[a+102984>>2]|0;bO[c[(c[r>>2]|0)+24>>2]&127](r,h,j,k);i=d;return}else if((p|0)==4){p=b+68|0;r=c[p+4>>2]|0;c[l>>2]=c[p>>2];c[l+4>>2]=r;r=b+76|0;b=c[r+4>>2]|0;c[n>>2]=c[r>>2];c[n+4>>2]=b;b=a+102984|0;n=c[b>>2]|0;bO[c[(c[n>>2]|0)+24>>2]&127](n,m,h,k);n=c[b>>2]|0;bO[c[(c[n>>2]|0)+24>>2]&127](n,o,j,k);n=c[b>>2]|0;bO[c[(c[n>>2]|0)+24>>2]&127](n,m,o,k);i=d;return}else{o=a+102984|0;a=c[o>>2]|0;bO[c[(c[a>>2]|0)+24>>2]&127](a,e,h,k);e=c[o>>2]|0;bO[c[(c[e>>2]|0)+24>>2]&127](e,h,j,k);h=c[o>>2]|0;bO[c[(c[h>>2]|0)+24>>2]&127](h,f,j,k);i=d;return}}function dX(a){a=a|0;var b=0,d=0.0,e=0,f=0,j=0,k=0,l=0,m=0;b=i;if((c[a+102868>>2]&2|0)!=0){i=b;return}d=+g[a+102972>>2];db(4360,(u=i,i=i+16|0,h[u>>3]=+g[a+102968>>2],h[u+8>>3]=d,u)|0);db(12864,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(12632,(u=i,i=i+8|0,c[u>>2]=c[a+102960>>2],u)|0);db(12040,(u=i,i=i+8|0,c[u>>2]=c[a+102964>>2],u)|0);e=c[a+102952>>2]|0;if((e|0)!=0){f=0;j=e;while(1){c[j+8>>2]=f;dn(j);e=c[j+96>>2]|0;if((e|0)==0){break}else{f=f+1|0;j=e}}}j=a+102956|0;a=c[j>>2]|0;do{if((a|0)!=0){f=0;e=a;while(1){c[e+56>>2]=f;k=c[e+12>>2]|0;if((k|0)==0){break}else{f=f+1|0;e=k}}e=c[j>>2]|0;if((e|0)==0){break}else{l=e}do{if((c[l+4>>2]|0)!=6){db(11584,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);bo[c[(c[l>>2]|0)+16>>2]&511](l);db(11328,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0)}l=c[l+12>>2]|0;}while((l|0)!=0);e=c[j>>2]|0;if((e|0)==0){break}else{m=e}do{if((c[m+4>>2]|0)==6){db(11584,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);bo[c[(c[m>>2]|0)+16>>2]&511](m);db(11328,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0)}m=c[m+12>>2]|0;}while((m|0)!=0)}}while(0);db(11128,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(10904,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(10712,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(10512,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);i=b;return}function dY(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0,A=0,B=0.0,C=0,D=0,E=0,F=0,G=0,H=0.0;f=i;i=i+40|0;h=f|0;j=f+8|0;k=f+16|0;l=f+24|0;m=f+32|0;n=m;o=i;i=i+8|0;p=o;q=i;i=i+64|0;r=c[b+12>>2]|0;b=c[r+4>>2]|0;if((b|0)==0){s=+g[d+12>>2];t=+g[r+12>>2];u=+g[d+8>>2];v=+g[r+16>>2];w=t*u+s*v+ +g[d+4>>2];g[h>>2]=+g[d>>2]+(s*t-u*v);g[h+4>>2]=w;w=+g[r+8>>2];g[j>>2]=s-u*0.0;g[j+4>>2]=u+s*0.0;x=c[a+102984>>2]|0;bn[c[(c[x>>2]|0)+20>>2]&63](x,h,w,j,e);i=f;return}else if((b|0)==3){j=c[r+16>>2]|0;h=c[r+12>>2]|0;x=d+12|0;w=+g[x>>2];s=+g[h>>2];y=d+8|0;u=+g[y>>2];v=+g[h+4>>2];z=d|0;t=+g[z>>2];A=d+4|0;B=+g[A>>2];g[m>>2]=t+(w*s-u*v);g[n+4>>2]=s*u+w*v+B;if((j|0)<=1){i=f;return}C=o;D=p+4|0;E=a+102984|0;F=1;v=w;w=u;u=t;t=B;while(1){B=+g[h+(F<<3)>>2];s=+g[h+(F<<3)+4>>2];g[C>>2]=u+(v*B-w*s);g[D>>2]=B*w+v*s+t;G=c[E>>2]|0;bO[c[(c[G>>2]|0)+24>>2]&127](G,n,p,e);G=c[E>>2]|0;br[c[(c[G>>2]|0)+16>>2]&63](G,n,.05000000074505806,e);G=c[o+4>>2]|0;c[m>>2]=c[o>>2];c[m+4>>2]=G;G=F+1|0;if((G|0)>=(j|0)){break}F=G;v=+g[x>>2];w=+g[y>>2];u=+g[z>>2];t=+g[A>>2]}i=f;return}else if((b|0)==2){A=c[r+148>>2]|0;if((A|0)>=9){ba(10624,1077,15360,4600)}z=q|0;if((A|0)>0){y=r+20|0;t=+g[d+12>>2];u=+g[d+8>>2];w=+g[d>>2];v=+g[d+4>>2];x=0;do{s=+g[y+(x<<3)>>2];B=+g[y+(x<<3)+4>>2];F=q+(x<<3)|0;H=+(s*u+t*B+v);g[F>>2]=w+(t*s-u*B);g[F+4>>2]=H;x=x+1|0;}while((x|0)<(A|0))}x=c[a+102984>>2]|0;bO[c[(c[x>>2]|0)+12>>2]&127](x,z,A,e);i=f;return}else if((b|0)==1){u=+g[d+12>>2];t=+g[r+12>>2];w=+g[d+8>>2];v=+g[r+16>>2];H=+g[d>>2];B=+g[d+4>>2];g[k>>2]=H+(u*t-w*v);g[k+4>>2]=t*w+u*v+B;d=r+20|0;v=+g[d>>2];t=+g[d+4>>2];g[l>>2]=H+(u*v-w*t);g[l+4>>2]=v*w+u*t+B;d=c[a+102984>>2]|0;bO[c[(c[d>>2]|0)+24>>2]&127](d,k,l,e);i=f;return}else{i=f;return}}function dZ(a){a=a|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0.0,S=0.0,T=0.0,U=0.0;d=i;i=i+144|0;e=d|0;f=d+16|0;h=d+32|0;j=d+48|0;k=d+64|0;l=d+80|0;m=d+96|0;n=d+128|0;o=n|0;p=n;q=a+102984|0;r=c[q>>2]|0;if((r|0)==0){i=d;return}s=c[r+4>>2]|0;do{if((s&1|0)!=0){r=c[a+102952>>2]|0;if((r|0)==0){break}t=e|0;u=e+4|0;v=e+8|0;w=j|0;x=j+4|0;y=j+8|0;z=k|0;A=k+4|0;B=k+8|0;C=f|0;D=f+4|0;E=f+8|0;F=h|0;G=h+4|0;H=h+8|0;I=r;do{r=I+12|0;J=c[I+100>>2]|0;if((J|0)!=0){K=I+4|0;L=I|0;M=J;do{J=b[K>>1]|0;do{if((J&32)==0){g[t>>2]=.5;g[u>>2]=.5;g[v>>2]=.30000001192092896;dY(a,M,r,e)}else{N=c[L>>2]|0;if((N|0)==1){g[F>>2]=.5;g[G>>2]=.5;g[H>>2]=.8999999761581421;dY(a,M,r,h);break}else if((N|0)==0){g[C>>2]=.5;g[D>>2]=.8999999761581421;g[E>>2]=.5;dY(a,M,r,f);break}else{if((J&2)==0){g[w>>2]=.6000000238418579;g[x>>2]=.6000000238418579;g[y>>2]=.6000000238418579;dY(a,M,r,j);break}else{g[z>>2]=.8999999761581421;g[A>>2]=.699999988079071;g[B>>2]=.699999988079071;dY(a,M,r,k);break}}}}while(0);M=c[M+4>>2]|0;}while((M|0)!=0)}I=c[I+96>>2]|0;}while((I|0)!=0)}}while(0);do{if((s&2|0)!=0){k=c[a+102956>>2]|0;if((k|0)==0){break}else{O=k}do{dW(a,O);O=c[O+12>>2]|0;}while((O|0)!=0)}}while(0);if((s&8|0)!=0){O=a+102932|0;while(1){k=c[O>>2]|0;if((k|0)==0){break}else{O=k+12|0}}}L2800:do{if((s&4|0)!=0){g[l>>2]=.8999999761581421;g[l+4>>2]=.30000001192092896;g[l+8>>2]=.8999999761581421;O=c[a+102952>>2]|0;if((O|0)==0){break}k=a+102884|0;j=a+102876|0;f=m|0;h=m|0;e=m+4|0;I=m+8|0;B=m+12|0;A=m+16|0;z=m+20|0;y=m+24|0;x=m+28|0;w=O;L2803:while(1){do{if((b[w+4>>1]&32)!=0){O=c[w+100>>2]|0;if((O|0)==0){break}else{P=O}do{O=P+28|0;if((c[O>>2]|0)>0){E=P+24|0;D=0;do{C=c[(c[E>>2]|0)+(D*28&-1)+24>>2]|0;if((C|0)<=-1){Q=2175;break L2803}if((c[k>>2]|0)<=(C|0)){Q=2176;break L2803}H=c[j>>2]|0;R=+g[H+(C*36&-1)>>2];S=+g[H+(C*36&-1)+4>>2];T=+g[H+(C*36&-1)+8>>2];U=+g[H+(C*36&-1)+12>>2];g[h>>2]=R;g[e>>2]=S;g[I>>2]=T;g[B>>2]=S;g[A>>2]=T;g[z>>2]=U;g[y>>2]=R;g[x>>2]=U;C=c[q>>2]|0;bO[c[(c[C>>2]|0)+8>>2]&127](C,f,4,l);D=D+1|0;}while((D|0)<(c[O>>2]|0))}P=c[P+4>>2]|0;}while((P|0)!=0)}}while(0);w=c[w+96>>2]|0;if((w|0)==0){break L2800}}if((Q|0)==2175){ba(10360,159,14456,9904)}else if((Q|0)==2176){ba(10360,159,14456,9904)}}}while(0);if((s&16|0)==0){i=d;return}s=c[a+102952>>2]|0;if((s|0)==0){i=d;return}a=n;n=s;do{s=n+12|0;c[a>>2]=c[s>>2];c[a+4>>2]=c[s+4>>2];c[a+8>>2]=c[s+8>>2];c[a+12>>2]=c[s+12>>2];s=n+44|0;Q=c[s+4>>2]|0;c[o>>2]=c[s>>2];c[o+4>>2]=Q;Q=c[q>>2]|0;bp[c[(c[Q>>2]|0)+28>>2]&511](Q,p);n=c[n+96>>2]|0;}while((n|0)!=0);i=d;return}function d_(a){a=a|0;return}function d$(a){a=a|0;return}function d0(a,c,d){a=a|0;c=c|0;d=d|0;var e=0;a=b[c+36>>1]|0;if(!(a<<16>>16!=(b[d+36>>1]|0)|a<<16>>16==0)){e=a<<16>>16>0;return e|0}if((b[d+32>>1]&b[c+34>>1])<<16>>16==0){e=0;return e|0}e=(b[d+34>>1]&b[c+32>>1])<<16>>16!=0;return e|0}function d1(a){a=a|0;vl(a);return}function d2(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0;f=i;i=i+48|0;h=f|0;j=c[(c[a+48>>2]|0)+12>>2]|0;c[h>>2]=20512;c[h+4>>2]=1;g[h+8>>2]=.009999999776482582;vq(h+28|0,0,18);cX(j,h,c[a+56>>2]|0);b6(b,h,d,c[(c[a+52>>2]|0)+12>>2]|0,e);i=f;return}function d3(a){a=a|0;vl(a);return}function d4(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0;f=i;i=i+304|0;h=f+256|0;j=c[(c[a+48>>2]|0)+12>>2]|0;c[h>>2]=20512;c[h+4>>2]=1;g[h+8>>2]=.009999999776482582;vq(h+28|0,0,18);cX(j,h,c[a+56>>2]|0);b7(f|0,b,h,d,c[(c[a+52>>2]|0)+12>>2]|0,e);i=f;return}function d5(a){a=a|0;vl(a);return}function d6(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0.0,l=0.0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0,L=0,M=0,N=0.0,O=0.0,Q=0.0,R=0.0,S=0.0,T=0,U=0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0.0,ac=0,ad=0.0,ae=0.0,af=0,ag=0,ah=0,ai=0,aj=0;e=i;i=i+1064|0;f=e|0;h=e+1040|0;j=d;k=+g[j>>2];l=+g[j+4>>2];m=d+8|0;n=+g[m>>2]-k;o=+g[m+4>>2]-l;p=n*n+o*o;if(p<=0.0){ba(10360,204,14104,10168)}q=+P(+p);if(q<1.1920928955078125e-7){r=n;s=o}else{p=1.0/q;r=n*p;s=o*p}p=s*-1.0;if(p>0.0){t=p}else{t=-0.0-p}if(r>0.0){u=r}else{u=-0.0-r}s=+g[d+16>>2];q=k+n*s;v=l+o*s;d=f+4|0;w=f|0;c[w>>2]=d;x=f+1028|0;c[x>>2]=0;y=f+1032|0;c[y>>2]=256;c[(c[w>>2]|0)+(c[x>>2]<<2)>>2]=c[a>>2];f=(c[x>>2]|0)+1|0;c[x>>2]=f;L2859:do{if((f|0)>0){z=a+4|0;A=h;B=h+8|0;C=h+16|0;D=f;E=l<v?l:v;F=k<q?k:q;G=l>v?l:v;H=k>q?k:q;I=s;while(1){J=D;while(1){K=J-1|0;c[x>>2]=K;L=c[w>>2]|0;M=c[L+(K<<2)>>2]|0;if((M|0)==-1){N=I;O=H;Q=G;R=F;S=E;T=K;break}U=c[z>>2]|0;V=+g[U+(M*36&-1)+8>>2];W=+g[U+(M*36&-1)+12>>2];X=+g[U+(M*36&-1)>>2];Y=+g[U+(M*36&-1)+4>>2];if(F-V>0.0|E-W>0.0|X-H>0.0|Y-G>0.0){Z=I;_=H;$=G;aa=F;ab=E;ac=2206;break}ad=p*(k-(V+X)*.5)+r*(l-(W+Y)*.5);if(ad>0.0){ae=ad}else{ae=-0.0-ad}if(ae-(t*(V-X)*.5+u*(W-Y)*.5)>0.0){Z=I;_=H;$=G;aa=F;ab=E;ac=2206;break}af=U+(M*36&-1)+24|0;if((c[af>>2]|0)==-1){ac=2217;break}do{if((K|0)==(c[y>>2]|0)){c[y>>2]=K<<1;ag=vh(K<<3)|0;c[w>>2]=ag;ah=L;ai=c[x>>2]<<2;vp(ag|0,ah|0,ai)|0;if((L|0)==(d|0)){break}vi(ah)}}while(0);c[(c[w>>2]|0)+(c[x>>2]<<2)>>2]=c[af>>2];L=(c[x>>2]|0)+1|0;c[x>>2]=L;K=U+(M*36&-1)+28|0;do{if((L|0)==(c[y>>2]|0)){ah=c[w>>2]|0;c[y>>2]=L<<1;ai=vh(L<<3)|0;c[w>>2]=ai;ag=ah;aj=c[x>>2]<<2;vp(ai|0,ag|0,aj)|0;if((ah|0)==(d|0)){break}vi(ag)}}while(0);c[(c[w>>2]|0)+(c[x>>2]<<2)>>2]=c[K>>2];J=(c[x>>2]|0)+1|0;c[x>>2]=J;if((J|0)<=0){break L2859}}do{if((ac|0)==2217){ac=0;J=c[j+4>>2]|0;c[A>>2]=c[j>>2];c[A+4>>2]=J;J=c[m+4>>2]|0;c[B>>2]=c[m>>2];c[B+4>>2]=J;g[C>>2]=I;Y=+d7(b,h,M);if(Y==0.0){break L2859}if(Y<=0.0){Z=I;_=H;$=G;aa=F;ab=E;ac=2206;break}W=k+n*Y;X=l+o*Y;Z=Y;_=k>W?k:W;$=l>X?l:X;aa=k<W?k:W;ab=l<X?l:X;ac=2206}}while(0);if((ac|0)==2206){ac=0;N=Z;O=_;Q=$;R=aa;S=ab;T=c[x>>2]|0}if((T|0)>0){D=T;E=S;F=R;G=Q;H=O;I=N}else{break}}}}while(0);T=c[w>>2]|0;if((T|0)==(d|0)){i=e;return}vi(T);c[w>>2]=0;i=e;return}function d7(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0;e=i;i=i+24|0;f=e|0;h=e+16|0;j=c[a>>2]|0;if((d|0)<=-1){ba(10360,153,14408,9904);return 0.0}if((c[j+12>>2]|0)<=(d|0)){ba(10360,153,14408,9904);return 0.0}k=c[(c[j+4>>2]|0)+(d*36&-1)+16>>2]|0;d=c[k+16>>2]|0;j=c[d+12>>2]|0;if(bI[c[(c[j>>2]|0)+20>>2]&127](j,f,b,(c[d+8>>2]|0)+12|0,c[k+20>>2]|0)|0){l=+g[f+8>>2];m=1.0-l;n=m*+g[b+4>>2]+l*+g[b+12>>2];g[h>>2]=+g[b>>2]*m+l*+g[b+8>>2];g[h+4>>2]=n;k=c[a+4>>2]|0;o=+bG[c[(c[k>>2]|0)+8>>2]&63](k,d,h,f|0,l);i=e;return+o}else{o=+g[b+16>>2];i=e;return+o}return 0.0}function d8(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;e=i;i=i+1040|0;f=e|0;h=f+4|0;j=f|0;c[j>>2]=h;k=f+1028|0;c[k>>2]=0;l=f+1032|0;c[l>>2]=256;c[(c[j>>2]|0)+(c[k>>2]<<2)>>2]=c[a>>2];f=(c[k>>2]|0)+1|0;c[k>>2]=f;L2906:do{if((f|0)>0){m=a+4|0;n=d|0;o=d+4|0;p=d+8|0;q=d+12|0;r=b|0;s=b+4|0;t=f;L2908:while(1){u=t-1|0;c[k>>2]=u;v=c[j>>2]|0;w=c[v+(u<<2)>>2]|0;do{if((w|0)==-1){x=u}else{y=c[m>>2]|0;if(+g[n>>2]- +g[y+(w*36&-1)+8>>2]>0.0|+g[o>>2]- +g[y+(w*36&-1)+12>>2]>0.0|+g[y+(w*36&-1)>>2]- +g[p>>2]>0.0|+g[y+(w*36&-1)+4>>2]- +g[q>>2]>0.0){x=u;break}z=y+(w*36&-1)+24|0;if((c[z>>2]|0)==-1){A=c[r>>2]|0;if((w|0)<=-1){break L2908}if((c[A+12>>2]|0)<=(w|0)){break L2908}B=c[s>>2]|0;if(!(bF[c[(c[B>>2]|0)+8>>2]&255](B,c[(c[(c[A+4>>2]|0)+(w*36&-1)+16>>2]|0)+16>>2]|0)|0)){break L2906}x=c[k>>2]|0;break}do{if((u|0)==(c[l>>2]|0)){c[l>>2]=u<<1;A=vh(u<<3)|0;c[j>>2]=A;B=v;C=c[k>>2]<<2;vp(A|0,B|0,C)|0;if((v|0)==(h|0)){break}vi(B)}}while(0);c[(c[j>>2]|0)+(c[k>>2]<<2)>>2]=c[z>>2];B=(c[k>>2]|0)+1|0;c[k>>2]=B;C=y+(w*36&-1)+28|0;do{if((B|0)==(c[l>>2]|0)){A=c[j>>2]|0;c[l>>2]=B<<1;D=vh(B<<3)|0;c[j>>2]=D;E=A;F=c[k>>2]<<2;vp(D|0,E|0,F)|0;if((A|0)==(h|0)){break}vi(E)}}while(0);c[(c[j>>2]|0)+(c[k>>2]<<2)>>2]=c[C>>2];B=(c[k>>2]|0)+1|0;c[k>>2]=B;x=B}}while(0);if((x|0)>0){t=x}else{break L2906}}ba(10360,153,14408,9904)}}while(0);x=c[j>>2]|0;if((x|0)==(h|0)){i=e;return}vi(x);c[j>>2]=0;i=e;return}function d9(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0,k=0.0,l=0.0;h=df(f,144)|0;if((h|0)==0){i=0;j=i|0;return j|0}f=h;c[f>>2]=19280;c[h+4>>2]=4;c[h+48>>2]=a;c[h+52>>2]=d;c[h+56>>2]=b;c[h+60>>2]=e;c[h+124>>2]=0;c[h+128>>2]=0;vq(h+8|0,0,40);g[h+136>>2]=+P(+(+g[a+16>>2]*+g[d+16>>2]));k=+g[a+20>>2];l=+g[d+20>>2];g[h+140>>2]=k>l?k:l;c[f>>2]=19512;if((c[(c[a+12>>2]|0)+4>>2]|0)!=3){ba(10096,43,16664,12232);return 0}if((c[(c[d+12>>2]|0)+4>>2]|0)==0){i=h;j=i|0;return j|0}else{ba(10096,44,16664,9416);return 0}return 0}function ea(b,d){b=b|0;d=d|0;var e=0,f=0;bo[c[(c[b>>2]|0)+4>>2]&511](b);e=a[22208]|0;if((e&255)<14){f=d+12+((e&255)<<2)|0;c[b>>2]=c[f>>2];c[f>>2]=b;return}else{ba(5352,173,17448,6544)}}function eb(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0,k=0.0,l=0.0;h=df(f,144)|0;if((h|0)==0){i=0;j=i|0;return j|0}f=h;c[f>>2]=19280;c[h+4>>2]=4;c[h+48>>2]=a;c[h+52>>2]=d;c[h+56>>2]=b;c[h+60>>2]=e;c[h+124>>2]=0;c[h+128>>2]=0;vq(h+8|0,0,40);g[h+136>>2]=+P(+(+g[a+16>>2]*+g[d+16>>2]));k=+g[a+20>>2];l=+g[d+20>>2];g[h+140>>2]=k>l?k:l;c[f>>2]=19448;if((c[(c[a+12>>2]|0)+4>>2]|0)!=3){ba(9952,43,16488,12232);return 0}if((c[(c[d+12>>2]|0)+4>>2]|0)==2){i=h;j=i|0;return j|0}else{ba(9952,44,16488,9368);return 0}return 0}function ec(b,d){b=b|0;d=d|0;var e=0,f=0;bo[c[(c[b>>2]|0)+4>>2]&511](b);e=a[22208]|0;if((e&255)<14){f=d+12+((e&255)<<2)|0;c[b>>2]=c[f>>2];c[f>>2]=b;return}else{ba(5352,173,17448,6544)}}function ed(a){a=a|0;return}function ee(a){a=a|0;return}function ef(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0;f=c[(c[a+48>>2]|0)+12>>2]|0;h=c[(c[a+52>>2]|0)+12>>2]|0;a=b+60|0;c[a>>2]=0;i=f+12|0;j=+g[d+12>>2];k=+g[i>>2];l=+g[d+8>>2];m=+g[f+16>>2];n=h+12|0;o=+g[e+12>>2];p=+g[n>>2];q=+g[e+8>>2];r=+g[h+16>>2];s=+g[e>>2]+(o*p-q*r)-(+g[d>>2]+(j*k-l*m));t=p*q+o*r+ +g[e+4>>2]-(k*l+j*m+ +g[d+4>>2]);m=+g[f+8>>2]+ +g[h+8>>2];if(s*s+t*t>m*m){return}c[b+56>>2]=0;h=i;i=b+48|0;f=c[h+4>>2]|0;c[i>>2]=c[h>>2];c[i+4>>2]=f;g[b+40>>2]=0.0;g[b+44>>2]=0.0;c[a>>2]=1;a=n;n=b;f=c[a+4>>2]|0;c[n>>2]=c[a>>2];c[n+4>>2]=f;c[b+16>>2]=0;return}function eg(a){a=a|0;vl(a);return}function eh(d,e){d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;f=i;i=i+200|0;h=f|0;j=f+96|0;k=f+112|0;l=f+136|0;m=d+64|0;n=l;o=m;vp(n|0,o|0,64)|0;o=d+4|0;n=c[o>>2]|0;c[o>>2]=n|4;p=n>>>1;n=c[d+48>>2]|0;q=c[d+52>>2]|0;r=((a[q+38|0]|a[n+38|0])&1)!=0;s=c[n+8>>2]|0;t=c[q+8>>2]|0;u=s+12|0;v=t+12|0;do{if(r){w=c[n+12>>2]|0;x=c[q+12>>2]|0;y=c[d+56>>2]|0;z=c[d+60>>2]|0;c[h+16>>2]=0;c[h+20>>2]=0;g[h+24>>2]=0.0;c[h+44>>2]=0;c[h+48>>2]=0;g[h+52>>2]=0.0;cf(h|0,w,y);cf(h+28|0,x,z);z=h+56|0;x=u;c[z>>2]=c[x>>2];c[z+4>>2]=c[x+4>>2];c[z+8>>2]=c[x+8>>2];c[z+12>>2]=c[x+12>>2];x=h+72|0;z=v;c[x>>2]=c[z>>2];c[x+4>>2]=c[z+4>>2];c[x+8>>2]=c[z+8>>2];c[x+12>>2]=c[z+12>>2];a[h+88|0]=1;b[j+4>>1]=0;cg(k,j,h);z=+g[k+16>>2]<11920928955078125.0e-22;c[d+124>>2]=0;A=z;B=p&1}else{bO[c[c[d>>2]>>2]&127](d,m,u,v);z=d+124|0;x=(c[z>>2]|0)>0;if(x){y=c[l+60>>2]|0;w=0;do{C=d+64+(w*20&-1)+8|0;g[C>>2]=0.0;D=d+64+(w*20&-1)+12|0;g[D>>2]=0.0;E=c[d+64+(w*20&-1)+16>>2]|0;F=0;while(1){if((F|0)>=(y|0)){break}if((c[l+(F*20&-1)+16>>2]|0)==(E|0)){G=2312;break}else{F=F+1|0}}if((G|0)==2312){G=0;g[C>>2]=+g[l+(F*20&-1)+8>>2];g[D>>2]=+g[l+(F*20&-1)+12>>2]}w=w+1|0;}while((w|0)<(c[z>>2]|0))}z=p&1;if(!(x^(z|0)!=0)){A=x;B=z;break}w=s+4|0;y=b[w>>1]|0;if((y&2)==0){b[w>>1]=y|2;g[s+144>>2]=0.0}y=t+4|0;w=b[y>>1]|0;if((w&2)!=0){A=x;B=z;break}b[y>>1]=w|2;g[t+144>>2]=0.0;A=x;B=z}}while(0);t=c[o>>2]|0;c[o>>2]=A?t|2:t&-3;t=(B|0)==0;B=A^1;o=(e|0)==0;if(!(t^1|B|o)){bp[c[(c[e>>2]|0)+8>>2]&511](e,d)}if(!(t|A|o)){bp[c[(c[e>>2]|0)+12>>2]&511](e,d)}if(r|B|o){i=f;return}bL[c[(c[e>>2]|0)+16>>2]&127](e,d,l);i=f;return}function ei(a){a=a|0;vl(a);return}function ej(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0.0,k=0.0;e=df(f,144)|0;if((e|0)==0){h=0;i=h|0;return i|0}f=e;c[f>>2]=19280;c[e+4>>2]=4;c[e+48>>2]=a;c[e+52>>2]=d;c[e+56>>2]=0;c[e+60>>2]=0;c[e+124>>2]=0;c[e+128>>2]=0;vq(e+8|0,0,40);g[e+136>>2]=+P(+(+g[a+16>>2]*+g[d+16>>2]));j=+g[a+20>>2];k=+g[d+20>>2];g[e+140>>2]=j>k?j:k;c[f>>2]=2e4;if((c[(c[a+12>>2]|0)+4>>2]|0)!=0){ba(9808,44,17872,12152);return 0}if((c[(c[d+12>>2]|0)+4>>2]|0)==0){h=e;i=h|0;return i|0}else{ba(9808,45,17872,9416);return 0}return 0}function ek(b,d){b=b|0;d=d|0;var e=0,f=0;bo[c[(c[b>>2]|0)+4>>2]&511](b);e=a[22208]|0;if((e&255)<14){f=d+12+((e&255)<<2)|0;c[b>>2]=c[f>>2];c[f>>2]=b;return}else{ba(5352,173,17448,6544)}}function el(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0;if((a[21856]&1)==0){c[5466]=62;c[5467]=140;a[21872]=1;c[5490]=54;c[5491]=386;a[21968]=1;c[5472]=54;c[5473]=386;a[21896]=0;c[5496]=70;c[5497]=296;a[21992]=1;c[5478]=60;c[5479]=106;a[21920]=1;c[5469]=60;c[5470]=106;a[21884]=0;c[5484]=64;c[5485]=228;a[21944]=1;c[5493]=64;c[5494]=228;a[21980]=0;c[5502]=52;c[5503]=278;a[22016]=1;c[5475]=52;c[5476]=278;a[21908]=0;c[5508]=72;c[5509]=160;a[22040]=1;c[5499]=72;c[5500]=160;a[22004]=0;a[21856]=1}h=c[(c[b+12>>2]|0)+4>>2]|0;i=c[(c[e+12>>2]|0)+4>>2]|0;if(h>>>0>=4){ba(9712,80,15104,12104);return 0}if(i>>>0>=4){ba(9712,81,15104,9496);return 0}j=c[21864+(h*48&-1)+(i*12&-1)>>2]|0;if((j|0)==0){k=0;return k|0}if((a[21864+(h*48&-1)+(i*12&-1)+8|0]&1)==0){k=bI[j&127](e,f,b,d,g)|0;return k|0}else{k=bI[j&127](b,d,e,f,g)|0;return k|0}return 0}function em(d,e){d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0,l=0;if((a[21856]&1)==0){ba(9712,103,15040,7184)}f=d+48|0;do{if((c[d+124>>2]|0)>0){h=c[(c[f>>2]|0)+8>>2]|0;i=h+4|0;j=b[i>>1]|0;if((j&2)==0){b[i>>1]=j|2;g[h+144>>2]=0.0}h=d+52|0;j=c[(c[h>>2]|0)+8>>2]|0;i=j+4|0;k=b[i>>1]|0;if((k&2)!=0){l=h;break}b[i>>1]=k|2;g[j+144>>2]=0.0;l=h}else{l=d+52|0}}while(0);h=c[(c[(c[f>>2]|0)+12>>2]|0)+4>>2]|0;f=c[(c[(c[l>>2]|0)+12>>2]|0)+4>>2]|0;if((h|0)>-1&(f|0)<4){bp[c[21864+(h*48&-1)+(f*12&-1)+4>>2]&511](d,e);return}else{ba(9712,114,15040,6160)}}function en(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0,z=0;e=b;f=d;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];c[e+16>>2]=c[f+16>>2];c[e+20>>2]=c[f+20>>2];f=c[d+40>>2]|0;e=b+32|0;c[e>>2]=f;h=c[d+28>>2]|0;i=b+48|0;c[i>>2]=h;j=h*88&-1;h=f+102796|0;k=c[h>>2]|0;if((k|0)>=32){ba(4840,38,17040,6448)}l=f+102412+(k*12&-1)|0;c[f+102412+(k*12&-1)+4>>2]=j;m=f+102400|0;n=c[m>>2]|0;if((n+j|0)>102400){c[l>>2]=vh(j)|0;a[f+102412+(k*12&-1)+8|0]=1}else{c[l>>2]=f+n;a[f+102412+(k*12&-1)+8|0]=0;c[m>>2]=(c[m>>2]|0)+j}m=f+102404|0;k=(c[m>>2]|0)+j|0;c[m>>2]=k;m=f+102408|0;f=c[m>>2]|0;c[m>>2]=(f|0)>(k|0)?f:k;c[h>>2]=(c[h>>2]|0)+1;h=b+36|0;c[h>>2]=c[l>>2];l=c[e>>2]|0;e=(c[i>>2]|0)*152&-1;k=l+102796|0;f=c[k>>2]|0;if((f|0)>=32){ba(4840,38,17040,6448)}m=l+102412+(f*12&-1)|0;c[l+102412+(f*12&-1)+4>>2]=e;j=l+102400|0;n=c[j>>2]|0;if((n+e|0)>102400){c[m>>2]=vh(e)|0;a[l+102412+(f*12&-1)+8|0]=1}else{c[m>>2]=l+n;a[l+102412+(f*12&-1)+8|0]=0;c[j>>2]=(c[j>>2]|0)+e}j=l+102404|0;f=(c[j>>2]|0)+e|0;c[j>>2]=f;j=l+102408|0;l=c[j>>2]|0;c[j>>2]=(l|0)>(f|0)?l:f;c[k>>2]=(c[k>>2]|0)+1;k=b+40|0;c[k>>2]=c[m>>2];c[b+24>>2]=c[d+32>>2];c[b+28>>2]=c[d+36>>2];m=c[d+24>>2]|0;d=b+44|0;c[d>>2]=m;if((c[i>>2]|0)<=0){return}f=b+20|0;l=b+8|0;b=0;j=m;while(1){m=c[j+(b<<2)>>2]|0;e=c[m+48>>2]|0;n=c[m+52>>2]|0;o=c[e+8>>2]|0;p=c[n+8>>2]|0;q=c[m+124>>2]|0;if((q|0)<=0){r=2378;break}s=+g[(c[n+12>>2]|0)+8>>2];t=+g[(c[e+12>>2]|0)+8>>2];e=c[k>>2]|0;g[e+(b*152&-1)+136>>2]=+g[m+136>>2];g[e+(b*152&-1)+140>>2]=+g[m+140>>2];n=o+8|0;c[e+(b*152&-1)+112>>2]=c[n>>2];u=p+8|0;c[e+(b*152&-1)+116>>2]=c[u>>2];v=o+120|0;g[e+(b*152&-1)+120>>2]=+g[v>>2];w=p+120|0;g[e+(b*152&-1)+124>>2]=+g[w>>2];x=o+128|0;g[e+(b*152&-1)+128>>2]=+g[x>>2];y=p+128|0;g[e+(b*152&-1)+132>>2]=+g[y>>2];c[e+(b*152&-1)+148>>2]=b;c[e+(b*152&-1)+144>>2]=q;vq(e+(b*152&-1)+80|0,0,32);z=c[h>>2]|0;c[z+(b*88&-1)+32>>2]=c[n>>2];c[z+(b*88&-1)+36>>2]=c[u>>2];g[z+(b*88&-1)+40>>2]=+g[v>>2];g[z+(b*88&-1)+44>>2]=+g[w>>2];w=o+28|0;o=z+(b*88&-1)+48|0;v=c[w+4>>2]|0;c[o>>2]=c[w>>2];c[o+4>>2]=v;v=p+28|0;p=z+(b*88&-1)+56|0;o=c[v+4>>2]|0;c[p>>2]=c[v>>2];c[p+4>>2]=o;g[z+(b*88&-1)+64>>2]=+g[x>>2];g[z+(b*88&-1)+68>>2]=+g[y>>2];y=m+104|0;x=z+(b*88&-1)+16|0;o=c[y+4>>2]|0;c[x>>2]=c[y>>2];c[x+4>>2]=o;o=m+112|0;x=z+(b*88&-1)+24|0;y=c[o+4>>2]|0;c[x>>2]=c[o>>2];c[x+4>>2]=y;c[z+(b*88&-1)+84>>2]=q;g[z+(b*88&-1)+76>>2]=t;g[z+(b*88&-1)+80>>2]=s;c[z+(b*88&-1)+72>>2]=c[m+120>>2];y=0;do{if((a[f]&1)==0){g[e+(b*152&-1)+(y*36&-1)+16>>2]=0.0;g[e+(b*152&-1)+(y*36&-1)+20>>2]=0.0}else{g[e+(b*152&-1)+(y*36&-1)+16>>2]=+g[l>>2]*+g[m+64+(y*20&-1)+8>>2];g[e+(b*152&-1)+(y*36&-1)+20>>2]=+g[l>>2]*+g[m+64+(y*20&-1)+12>>2]}g[e+(b*152&-1)+(y*36&-1)+24>>2]=0.0;g[e+(b*152&-1)+(y*36&-1)+28>>2]=0.0;g[e+(b*152&-1)+(y*36&-1)+32>>2]=0.0;x=m+64+(y*20&-1)|0;o=z+(b*88&-1)+(y<<3)|0;vq(e+(b*152&-1)+(y*36&-1)|0,0,16);p=c[x+4>>2]|0;c[o>>2]=c[x>>2];c[o+4>>2]=p;y=y+1|0;}while((y|0)<(q|0));q=b+1|0;if((q|0)>=(c[i>>2]|0)){r=2387;break}b=q;j=c[d>>2]|0}if((r|0)==2387){return}else if((r|0)==2378){ba(9232,71,17704,12024)}}function eo(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0;b=a+48|0;if((c[b>>2]|0)<=0){return}d=a+40|0;e=a+28|0;a=0;do{f=c[d>>2]|0;h=c[f+(a*152&-1)+112>>2]|0;i=c[f+(a*152&-1)+116>>2]|0;j=+g[f+(a*152&-1)+120>>2];k=+g[f+(a*152&-1)+128>>2];l=+g[f+(a*152&-1)+124>>2];m=+g[f+(a*152&-1)+132>>2];n=c[f+(a*152&-1)+144>>2]|0;o=c[e>>2]|0;p=o+(h*12&-1)|0;q=+g[p>>2];r=+g[p+4>>2];s=+g[o+(h*12&-1)+8>>2];t=o+(i*12&-1)|0;u=+g[t>>2];v=+g[t+4>>2];w=+g[o+(i*12&-1)+8>>2];o=f+(a*152&-1)+72|0;x=+g[o>>2];y=+g[o+4>>2];z=x*-1.0;if((n|0)>0){A=r;B=q;C=v;D=u;E=s;F=w;o=0;while(1){G=+g[f+(a*152&-1)+(o*36&-1)+16>>2];H=+g[f+(a*152&-1)+(o*36&-1)+20>>2];I=x*G+y*H;J=y*G+z*H;H=E-k*(+g[f+(a*152&-1)+(o*36&-1)>>2]*J- +g[f+(a*152&-1)+(o*36&-1)+4>>2]*I);G=B-j*I;K=A-j*J;L=F+m*(J*+g[f+(a*152&-1)+(o*36&-1)+8>>2]-I*+g[f+(a*152&-1)+(o*36&-1)+12>>2]);M=D+l*I;I=C+l*J;t=o+1|0;if((t|0)<(n|0)){A=K;B=G;C=I;D=M;E=H;F=L;o=t}else{N=K;O=G;P=I;Q=M;R=H;S=L;break}}}else{N=r;O=q;P=v;Q=u;R=s;S=w}F=+N;g[p>>2]=O;g[p+4>>2]=F;g[(c[e>>2]|0)+(h*12&-1)+8>>2]=R;o=(c[e>>2]|0)+(i*12&-1)|0;F=+P;g[o>>2]=Q;g[o+4>>2]=F;g[(c[e>>2]|0)+(i*12&-1)+8>>2]=S;a=a+1|0;}while((a|0)<(c[b>>2]|0));return}
function ep(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0.0,M=0.0,N=0.0,O=0,P=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0,$=0.0,aa=0.0,ab=0.0,ac=0.0,ad=0.0,ae=0,af=0.0,ag=0.0,ah=0.0;b=i;i=i+16|0;d=b|0;e=d|0;f=d;h=i;i=i+16|0;j=h|0;k=h;l=i;i=i+24|0;m=l|0;n=l;o=a+48|0;if((c[o>>2]|0)<=0){i=b;return}p=a+40|0;q=a+36|0;r=a+44|0;s=a+24|0;t=a+28|0;a=d+8|0;d=a;u=a+4|0;a=h+8|0;h=a;v=a+4|0;a=l+8|0;l=0;while(1){w=c[p>>2]|0;x=c[q>>2]|0;y=c[(c[r>>2]|0)+(c[w+(l*152&-1)+148>>2]<<2)>>2]|0;z=c[w+(l*152&-1)+112>>2]|0;A=c[w+(l*152&-1)+116>>2]|0;B=+g[w+(l*152&-1)+120>>2];C=+g[w+(l*152&-1)+124>>2];D=+g[w+(l*152&-1)+128>>2];E=+g[w+(l*152&-1)+132>>2];F=x+(l*88&-1)+48|0;G=+g[F>>2];H=+g[F+4>>2];F=x+(l*88&-1)+56|0;I=+g[F>>2];J=+g[F+4>>2];F=c[s>>2]|0;K=F+(z*12&-1)|0;L=+g[K>>2];M=+g[K+4>>2];N=+g[F+(z*12&-1)+8>>2];K=c[t>>2]|0;O=K+(z*12&-1)|0;P=+g[O>>2];Q=+g[O+4>>2];T=+g[K+(z*12&-1)+8>>2];z=F+(A*12&-1)|0;U=+g[z>>2];V=+g[z+4>>2];W=+g[F+(A*12&-1)+8>>2];F=K+(A*12&-1)|0;X=+g[F>>2];Y=+g[F+4>>2];Z=+g[K+(A*12&-1)+8>>2];if((c[y+124>>2]|0)<=0){_=2400;break}$=+g[x+(l*88&-1)+80>>2];aa=+g[x+(l*88&-1)+76>>2];ab=+S(+N);g[d>>2]=ab;ac=+R(+N);g[u>>2]=ac;N=+S(+W);g[h>>2]=N;ad=+R(+W);g[v>>2]=ad;W=+(M-(H*ac+G*ab));g[e>>2]=L-(G*ac-H*ab);g[e+4>>2]=W;W=+(V-(J*ad+I*N));g[j>>2]=U-(I*ad-J*N);g[j+4>>2]=W;cd(n,y+64|0,f,aa,k,$);y=w+(l*152&-1)+72|0;x=y;A=c[m+4>>2]|0;c[x>>2]=c[m>>2];c[x+4>>2]=A;A=w+(l*152&-1)+144|0;x=c[A>>2]|0;do{if((x|0)>0){K=w+(l*152&-1)+76|0;F=y|0;$=B+C;aa=-0.0-Z;W=-0.0-T;z=w+(l*152&-1)+140|0;O=0;do{N=+g[a+(O<<3)>>2];J=N-L;ad=+g[a+(O<<3)+4>>2];ae=w+(l*152&-1)+(O*36&-1)|0;I=+(ad-M);g[ae>>2]=J;g[ae+4>>2]=I;I=N-U;ae=w+(l*152&-1)+(O*36&-1)+8|0;N=+(ad-V);g[ae>>2]=I;g[ae+4>>2]=N;N=+g[K>>2];ad=+g[w+(l*152&-1)+(O*36&-1)+4>>2];ab=+g[F>>2];H=J*N-ad*ab;ac=+g[w+(l*152&-1)+(O*36&-1)+12>>2];G=N*I-ab*ac;ab=$+H*D*H+G*E*G;if(ab>0.0){af=1.0/ab}else{af=0.0}g[w+(l*152&-1)+(O*36&-1)+24>>2]=af;ab=+g[K>>2];G=+g[F>>2]*-1.0;H=J*G-ab*ad;N=G*I-ab*ac;ab=$+H*D*H+N*E*N;if(ab>0.0){ag=1.0/ab}else{ag=0.0}g[w+(l*152&-1)+(O*36&-1)+28>>2]=ag;ae=w+(l*152&-1)+(O*36&-1)+32|0;g[ae>>2]=0.0;ab=+g[F>>2]*(X+ac*aa-P-ad*W)+ +g[K>>2]*(Y+Z*I-Q-T*J);if(ab<-1.0){g[ae>>2]=ab*(-0.0- +g[z>>2])}O=O+1|0;}while((O|0)<(x|0));if((c[A>>2]|0)!=2){break}W=+g[w+(l*152&-1)+76>>2];aa=+g[y>>2];$=+g[w+(l*152&-1)>>2]*W- +g[w+(l*152&-1)+4>>2]*aa;ab=W*+g[w+(l*152&-1)+8>>2]-aa*+g[w+(l*152&-1)+12>>2];J=W*+g[w+(l*152&-1)+36>>2]-aa*+g[w+(l*152&-1)+40>>2];I=W*+g[w+(l*152&-1)+44>>2]-aa*+g[w+(l*152&-1)+48>>2];aa=B+C;W=D*$;ad=E*ab;ac=aa+$*W+ab*ad;ab=aa+J*D*J+I*E*I;$=aa+W*J+ad*I;I=ac*ab-$*$;if(ac*ac>=I*1.0e3){c[A>>2]=1;break}g[w+(l*152&-1)+96>>2]=ac;g[w+(l*152&-1)+100>>2]=$;g[w+(l*152&-1)+104>>2]=$;g[w+(l*152&-1)+108>>2]=ab;if(I!=0.0){ah=1.0/I}else{ah=I}I=$*(-0.0-ah);g[w+(l*152&-1)+80>>2]=ab*ah;g[w+(l*152&-1)+84>>2]=I;g[w+(l*152&-1)+88>>2]=I;g[w+(l*152&-1)+92>>2]=ac*ah}}while(0);w=l+1|0;if((w|0)<(c[o>>2]|0)){l=w}else{_=2418;break}}if((_|0)==2418){i=b;return}else if((_|0)==2400){ba(9232,168,17760,9464)}}function eq(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0,y=0,z=0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0.0,ac=0.0,ad=0.0,ae=0.0,af=0.0,ag=0.0,ah=0.0,ai=0.0,aj=0.0,ak=0.0,al=0.0,am=0.0,an=0.0,ao=0.0,ap=0.0,aq=0.0,ar=0;b=i;i=i+16|0;d=b|0;e=d|0;f=d;h=i;i=i+16|0;j=h|0;k=h;l=i;i=i+20|0;i=i+7>>3<<3;m=a+48|0;if((c[m>>2]|0)<=0){n=0.0;o=n>=-.014999999664723873;i=b;return o|0}p=a+36|0;q=a+24|0;a=d+8|0;d=a;r=a+4|0;a=h+8|0;h=a;s=a+4|0;a=l;t=l+8|0;u=l+16|0;v=0;w=0.0;while(1){x=c[p>>2]|0;y=x+(v*88&-1)|0;z=c[x+(v*88&-1)+32>>2]|0;A=c[x+(v*88&-1)+36>>2]|0;B=x+(v*88&-1)+48|0;C=+g[B>>2];D=+g[B+4>>2];E=+g[x+(v*88&-1)+40>>2];F=+g[x+(v*88&-1)+64>>2];B=x+(v*88&-1)+56|0;G=+g[B>>2];H=+g[B+4>>2];I=+g[x+(v*88&-1)+44>>2];J=+g[x+(v*88&-1)+68>>2];B=c[x+(v*88&-1)+84>>2]|0;x=c[q>>2]|0;K=x+(z*12&-1)|0;L=+g[K>>2];M=+g[K+4>>2];N=+g[x+(z*12&-1)+8>>2];K=x+(A*12&-1)|0;O=+g[K>>2];P=+g[K+4>>2];Q=+g[x+(A*12&-1)+8>>2];if((B|0)>0){T=E+I;U=M;V=L;W=P;X=O;K=0;Y=Q;Z=N;_=w;do{$=+S(+Z);g[d>>2]=$;aa=+R(+Z);g[r>>2]=aa;ab=+S(+Y);g[h>>2]=ab;ac=+R(+Y);g[s>>2]=ac;ad=+(U-(D*aa+C*$));g[e>>2]=V-(C*aa-D*$);g[e+4>>2]=ad;ad=+(W-(H*ac+G*ab));g[j>>2]=X-(G*ac-H*ab);g[j+4>>2]=ad;eC(l,y,f,k,K);ad=+g[a>>2];ab=+g[a+4>>2];ac=+g[t>>2];$=+g[t+4>>2];aa=+g[u>>2];ae=ac-V;af=$-U;ag=ac-X;ac=$-W;_=_<aa?_:aa;$=(aa+.004999999888241291)*.20000000298023224;aa=$<0.0?$:0.0;$=ab*ae-ad*af;ah=ab*ag-ad*ac;ai=ah*J*ah+(T+$*F*$);if(ai>0.0){aj=(-0.0-(aa<-.20000000298023224?-.20000000298023224:aa))/ai}else{aj=0.0}ai=ad*aj;ad=ab*aj;V=V-E*ai;U=U-E*ad;Z=Z-F*(ae*ad-af*ai);X=X+I*ai;W=W+I*ad;Y=Y+J*(ag*ad-ac*ai);K=K+1|0;}while((K|0)<(B|0));ak=U;al=V;am=W;an=X;ao=Y;ap=Z;aq=_;ar=c[q>>2]|0}else{ak=M;al=L;am=P;an=O;ao=Q;ap=N;aq=w;ar=x}B=ar+(z*12&-1)|0;J=+ak;g[B>>2]=al;g[B+4>>2]=J;g[(c[q>>2]|0)+(z*12&-1)+8>>2]=ap;B=(c[q>>2]|0)+(A*12&-1)|0;J=+am;g[B>>2]=an;g[B+4>>2]=J;g[(c[q>>2]|0)+(A*12&-1)+8>>2]=ao;B=v+1|0;if((B|0)<(c[m>>2]|0)){v=B;w=aq}else{n=aq;break}}o=n>=-.014999999664723873;i=b;return o|0}function er(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,i=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0.0,E=0.0,F=0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0.0,ac=0.0,ad=0.0;b=a+48|0;if((c[b>>2]|0)<=0){return}d=a+40|0;e=a+28|0;a=0;L3146:while(1){f=c[d>>2]|0;h=f+(a*152&-1)|0;i=c[f+(a*152&-1)+112>>2]|0;j=c[f+(a*152&-1)+116>>2]|0;k=+g[f+(a*152&-1)+120>>2];l=+g[f+(a*152&-1)+128>>2];m=+g[f+(a*152&-1)+124>>2];n=+g[f+(a*152&-1)+132>>2];o=f+(a*152&-1)+144|0;p=c[o>>2]|0;q=c[e>>2]|0;r=q+(i*12&-1)|0;s=q+(j*12&-1)|0;t=f+(a*152&-1)+72|0;u=+g[t>>2];v=+g[t+4>>2];w=u*-1.0;x=+g[f+(a*152&-1)+136>>2];if((p-1|0)>>>0<2){y=+g[r+4>>2];z=+g[r>>2];A=+g[s+4>>2];B=+g[s>>2];C=0;D=+g[q+(j*12&-1)+8>>2];E=+g[q+(i*12&-1)+8>>2]}else{F=2435;break}do{G=+g[f+(a*152&-1)+(C*36&-1)+12>>2];H=+g[f+(a*152&-1)+(C*36&-1)+8>>2];I=+g[f+(a*152&-1)+(C*36&-1)+4>>2];J=+g[f+(a*152&-1)+(C*36&-1)>>2];K=x*+g[f+(a*152&-1)+(C*36&-1)+16>>2];q=f+(a*152&-1)+(C*36&-1)+20|0;L=+g[q>>2];M=L+ +g[f+(a*152&-1)+(C*36&-1)+28>>2]*(-0.0-(v*(B+G*(-0.0-D)-z-I*(-0.0-E))+w*(A+D*H-y-E*J)));N=-0.0-K;O=M<K?M:K;K=O<N?N:O;O=K-L;g[q>>2]=K;K=v*O;L=w*O;z=z-k*K;y=y-k*L;E=E-l*(J*L-I*K);B=B+m*K;A=A+m*L;D=D+n*(H*L-G*K);C=C+1|0;}while((C|0)<(p|0));L3151:do{if((c[o>>2]|0)==1){w=+g[f+(a*152&-1)+12>>2];x=+g[f+(a*152&-1)+8>>2];K=+g[f+(a*152&-1)+4>>2];G=+g[h>>2];p=f+(a*152&-1)+16|0;L=+g[p>>2];H=L+(u*(B+w*(-0.0-D)-z-K*(-0.0-E))+v*(A+D*x-y-E*G)- +g[f+(a*152&-1)+32>>2])*(-0.0- +g[f+(a*152&-1)+24>>2]);I=H>0.0?H:0.0;H=I-L;g[p>>2]=I;I=u*H;L=v*H;P=E-l*(G*L-K*I);Q=D+n*(x*L-w*I);R=B+m*I;S=A+m*L;T=z-k*I;U=y-k*L}else{p=f+(a*152&-1)+16|0;L=+g[p>>2];q=f+(a*152&-1)+52|0;I=+g[q>>2];if(L<0.0|I<0.0){F=2440;break L3146}w=-0.0-D;x=+g[f+(a*152&-1)+12>>2];K=+g[f+(a*152&-1)+8>>2];G=-0.0-E;H=+g[f+(a*152&-1)+4>>2];J=+g[h>>2];O=+g[f+(a*152&-1)+48>>2];N=+g[f+(a*152&-1)+44>>2];M=+g[f+(a*152&-1)+40>>2];V=+g[f+(a*152&-1)+36>>2];W=+g[f+(a*152&-1)+104>>2];X=+g[f+(a*152&-1)+100>>2];Y=u*(B+x*w-z-H*G)+v*(A+D*K-y-E*J)- +g[f+(a*152&-1)+32>>2]-(L*+g[f+(a*152&-1)+96>>2]+I*W);Z=u*(B+O*w-z-M*G)+v*(A+D*N-y-E*V)- +g[f+(a*152&-1)+68>>2]-(L*X+I*+g[f+(a*152&-1)+108>>2]);G=+g[f+(a*152&-1)+80>>2]*Y+ +g[f+(a*152&-1)+88>>2]*Z;w=Y*+g[f+(a*152&-1)+84>>2]+Z*+g[f+(a*152&-1)+92>>2];_=-0.0-G;$=-0.0-w;if(!(G>-0.0|w>-0.0)){w=_-L;G=$-I;aa=u*w;ab=v*w;w=u*G;ac=v*G;G=aa+w;ad=ab+ac;g[p>>2]=_;g[q>>2]=$;P=E-l*(J*ab-H*aa+(V*ac-M*w));Q=D+n*(K*ab-x*aa+(N*ac-O*w));R=B+m*G;S=A+m*ad;T=z-k*G;U=y-k*ad;break}ad=Y*(-0.0- +g[f+(a*152&-1)+24>>2]);do{if(ad>=0.0){if(Z+ad*X<0.0){break}G=ad-L;w=0.0-I;ac=u*G;aa=v*G;G=u*w;ab=v*w;w=G+ac;$=ab+aa;g[p>>2]=ad;g[q>>2]=0.0;P=E-l*(aa*J-ac*H+(ab*V-G*M));Q=D+n*(aa*K-ac*x+(ab*N-G*O));R=B+m*w;S=A+m*$;T=z-k*w;U=y-k*$;break L3151}}while(0);ad=Z*(-0.0- +g[f+(a*152&-1)+60>>2]);do{if(ad>=0.0){if(Y+ad*W<0.0){break}X=0.0-L;$=ad-I;w=u*X;G=v*X;X=u*$;ab=v*$;$=w+X;ac=G+ab;g[p>>2]=0.0;g[q>>2]=ad;P=E-l*(G*J-w*H+(ab*V-X*M));Q=D+n*(G*K-w*x+(ab*N-X*O));R=B+m*$;S=A+m*ac;T=z-k*$;U=y-k*ac;break L3151}}while(0);if(Y<0.0|Z<0.0){P=E;Q=D;R=B;S=A;T=z;U=y;break}ad=0.0-L;W=0.0-I;ac=u*ad;$=v*ad;ad=u*W;X=v*W;W=ac+ad;ab=$+X;g[p>>2]=0.0;g[q>>2]=0.0;P=E-l*($*J-ac*H+(X*V-ad*M));Q=D+n*($*K-ac*x+(X*N-ad*O));R=B+m*W;S=A+m*ab;T=z-k*W;U=y-k*ab}}while(0);f=(c[e>>2]|0)+(i*12&-1)|0;k=+U;g[f>>2]=T;g[f+4>>2]=k;g[(c[e>>2]|0)+(i*12&-1)+8>>2]=P;f=(c[e>>2]|0)+(j*12&-1)|0;k=+S;g[f>>2]=R;g[f+4>>2]=k;g[(c[e>>2]|0)+(j*12&-1)+8>>2]=Q;f=a+1|0;if((f|0)<(c[b>>2]|0)){a=f}else{F=2454;break}}if((F|0)==2435){ba(9232,311,17816,7144)}else if((F|0)==2454){return}else if((F|0)==2440){ba(9232,406,17816,6128)}}function es(a){a=a|0;return}function et(a){a=a|0;return}function eu(a){a=a|0;return}function ev(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0,N=0.0,O=0.0,P=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0.0,ac=0.0,ad=0.0,ae=0.0,af=0.0,ag=0.0,ah=0.0,ai=0.0,aj=0.0,ak=0.0,al=0.0,am=0.0,an=0.0,ao=0.0,ap=0.0,aq=0.0,ar=0.0,as=0.0,at=0;e=i;i=i+16|0;f=e|0;h=f|0;j=f;k=i;i=i+16|0;l=k|0;m=k;n=i;i=i+20|0;i=i+7>>3<<3;o=a+48|0;if((c[o>>2]|0)<=0){p=0.0;q=p>=-.007499999832361937;i=e;return q|0}r=a+36|0;s=a+24|0;a=f+8|0;f=a;t=a+4|0;a=k+8|0;k=a;u=a+4|0;a=n;v=n+8|0;w=n+16|0;x=0;y=0.0;while(1){z=c[r>>2]|0;A=z+(x*88&-1)|0;B=c[z+(x*88&-1)+32>>2]|0;C=c[z+(x*88&-1)+36>>2]|0;D=z+(x*88&-1)+48|0;E=+g[D>>2];F=+g[D+4>>2];D=z+(x*88&-1)+56|0;G=+g[D>>2];H=+g[D+4>>2];D=c[z+(x*88&-1)+84>>2]|0;if((B|0)==(b|0)|(B|0)==(d|0)){I=+g[z+(x*88&-1)+40>>2];J=+g[z+(x*88&-1)+64>>2]}else{I=0.0;J=0.0}K=+g[z+(x*88&-1)+44>>2];L=+g[z+(x*88&-1)+68>>2];z=c[s>>2]|0;M=z+(B*12&-1)|0;N=+g[M>>2];O=+g[M+4>>2];P=+g[z+(B*12&-1)+8>>2];M=z+(C*12&-1)|0;Q=+g[M>>2];T=+g[M+4>>2];U=+g[z+(C*12&-1)+8>>2];if((D|0)>0){V=I+K;W=O;X=N;Y=T;Z=Q;_=P;$=U;M=0;aa=y;do{ab=+S(+_);g[f>>2]=ab;ac=+R(+_);g[t>>2]=ac;ad=+S(+$);g[k>>2]=ad;ae=+R(+$);g[u>>2]=ae;af=+(W-(F*ac+E*ab));g[h>>2]=X-(E*ac-F*ab);g[h+4>>2]=af;af=+(Y-(H*ae+G*ad));g[l>>2]=Z-(G*ae-H*ad);g[l+4>>2]=af;eC(n,A,j,m,M);af=+g[a>>2];ad=+g[a+4>>2];ae=+g[v>>2];ab=+g[v+4>>2];ac=+g[w>>2];ag=ae-X;ah=ab-W;ai=ae-Z;ae=ab-Y;aa=aa<ac?aa:ac;ab=(ac+.004999999888241291)*.75;ac=ab<0.0?ab:0.0;ab=ad*ag-af*ah;aj=ad*ai-af*ae;ak=aj*L*aj+(V+ab*J*ab);if(ak>0.0){al=(-0.0-(ac<-.20000000298023224?-.20000000298023224:ac))/ak}else{al=0.0}ak=af*al;af=ad*al;X=X-I*ak;W=W-I*af;_=_-J*(ag*af-ah*ak);Z=Z+K*ak;Y=Y+K*af;$=$+L*(ai*af-ae*ak);M=M+1|0;}while((M|0)<(D|0));am=W;an=X;ao=Y;ap=Z;aq=_;ar=$;as=aa;at=c[s>>2]|0}else{am=O;an=N;ao=T;ap=Q;aq=P;ar=U;as=y;at=z}D=at+(B*12&-1)|0;L=+am;g[D>>2]=an;g[D+4>>2]=L;g[(c[s>>2]|0)+(B*12&-1)+8>>2]=aq;D=(c[s>>2]|0)+(C*12&-1)|0;L=+ao;g[D>>2]=ap;g[D+4>>2]=L;g[(c[s>>2]|0)+(C*12&-1)+8>>2]=ar;D=x+1|0;if((D|0)<(c[o>>2]|0)){x=D;y=as}else{p=as;break}}q=p>=-.007499999832361937;i=e;return q|0}function ew(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;b6(b,c[(c[a+48>>2]|0)+12>>2]|0,d,c[(c[a+52>>2]|0)+12>>2]|0,e);return}function ex(a){a=a|0;vl(a);return}function ey(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+256|0;b7(f|0,b,c[(c[a+48>>2]|0)+12>>2]|0,d,c[(c[a+52>>2]|0)+12>>2]|0,e);i=f;return}function ez(a){a=a|0;vl(a);return}function eA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;b5(b,c[(c[a+48>>2]|0)+12>>2]|0,d,c[(c[a+52>>2]|0)+12>>2]|0,e);return}function eB(a){a=a|0;vl(a);return}function eC(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0.0;if((c[b+84>>2]|0)<=0){ba(9232,617,16360,5640)}h=c[b+72>>2]|0;if((h|0)==0){i=+g[d+12>>2];j=+g[b+24>>2];k=+g[d+8>>2];l=+g[b+28>>2];m=+g[d>>2]+(i*j-k*l);n=j*k+i*l+ +g[d+4>>2];l=+g[e+12>>2];i=+g[b>>2];k=+g[e+8>>2];j=+g[b+4>>2];o=+g[e>>2]+(l*i-k*j);p=i*k+l*j+ +g[e+4>>2];j=o-m;l=p-n;q=a;k=+l;g[q>>2]=j;g[q+4>>2]=k;k=+P(+(j*j+l*l));if(k<1.1920928955078125e-7){r=j;s=l}else{i=1.0/k;k=j*i;g[a>>2]=k;t=l*i;g[a+4>>2]=t;r=k;s=t}q=a+8|0;t=+((n+p)*.5);g[q>>2]=(m+o)*.5;g[q+4>>2]=t;g[a+16>>2]=j*r+l*s- +g[b+76>>2]- +g[b+80>>2];return}else if((h|0)==1){q=d+12|0;s=+g[q>>2];l=+g[b+16>>2];u=d+8|0;r=+g[u>>2];j=+g[b+20>>2];t=s*l-r*j;o=l*r+s*j;v=a;j=+o;g[v>>2]=t;g[v+4>>2]=j;j=+g[q>>2];s=+g[b+24>>2];r=+g[u>>2];l=+g[b+28>>2];m=+g[e+12>>2];p=+g[b+(f<<3)>>2];n=+g[e+8>>2];k=+g[b+(f<<3)+4>>2];i=+g[e>>2]+(m*p-n*k);w=p*n+m*k+ +g[e+4>>2];g[a+16>>2]=t*(i-(+g[d>>2]+(j*s-r*l)))+(w-(s*r+j*l+ +g[d+4>>2]))*o- +g[b+76>>2]- +g[b+80>>2];u=a+8|0;o=+w;g[u>>2]=i;g[u+4>>2]=o;return}else if((h|0)==2){h=e+12|0;o=+g[h>>2];i=+g[b+16>>2];u=e+8|0;w=+g[u>>2];l=+g[b+20>>2];j=o*i-w*l;r=i*w+o*l;q=a;l=+r;g[q>>2]=j;g[q+4>>2]=l;l=+g[h>>2];o=+g[b+24>>2];w=+g[u>>2];i=+g[b+28>>2];s=+g[d+12>>2];t=+g[b+(f<<3)>>2];k=+g[d+8>>2];m=+g[b+(f<<3)+4>>2];n=+g[d>>2]+(s*t-k*m);p=t*k+s*m+ +g[d+4>>2];g[a+16>>2]=j*(n-(+g[e>>2]+(l*o-w*i)))+(p-(o*w+l*i+ +g[e+4>>2]))*r- +g[b+76>>2]- +g[b+80>>2];b=a+8|0;i=+p;g[b>>2]=n;g[b+4>>2]=i;i=+(-0.0-r);g[q>>2]=-0.0-j;g[q+4>>2]=i;return}else{return}}function eD(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0.0,k=0.0;e=df(f,144)|0;if((e|0)==0){h=0;i=h|0;return i|0}f=e;c[f>>2]=19280;c[e+4>>2]=4;c[e+48>>2]=a;c[e+52>>2]=d;c[e+56>>2]=0;c[e+60>>2]=0;c[e+124>>2]=0;c[e+128>>2]=0;vq(e+8|0,0,40);g[e+136>>2]=+P(+(+g[a+16>>2]*+g[d+16>>2]));j=+g[a+20>>2];k=+g[d+20>>2];g[e+140>>2]=j>k?j:k;c[f>>2]=19544;if((c[(c[a+12>>2]|0)+4>>2]|0)!=1){ba(8616,41,16760,11856);return 0}if((c[(c[d+12>>2]|0)+4>>2]|0)==0){h=e;i=h|0;return i|0}else{ba(8616,42,16760,9416);return 0}return 0}function eE(b,d){b=b|0;d=d|0;var e=0,f=0;bo[c[(c[b>>2]|0)+4>>2]&511](b);e=a[22208]|0;if((e&255)<14){f=d+12+((e&255)<<2)|0;c[b>>2]=c[f>>2];c[f>>2]=b;return}else{ba(5352,173,17448,6544)}}function eF(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0.0,k=0.0;e=df(f,144)|0;if((e|0)==0){h=0;i=h|0;return i|0}f=e;c[f>>2]=19280;c[e+4>>2]=4;c[e+48>>2]=a;c[e+52>>2]=d;c[e+56>>2]=0;c[e+60>>2]=0;c[e+124>>2]=0;c[e+128>>2]=0;vq(e+8|0,0,40);g[e+136>>2]=+P(+(+g[a+16>>2]*+g[d+16>>2]));j=+g[a+20>>2];k=+g[d+20>>2];g[e+140>>2]=j>k?j:k;c[f>>2]=19480;if((c[(c[a+12>>2]|0)+4>>2]|0)!=1){ba(8440,41,16584,11856);return 0}if((c[(c[d+12>>2]|0)+4>>2]|0)==2){h=e;i=h|0;return i|0}else{ba(8440,42,16584,9368);return 0}return 0}function eG(b,d){b=b|0;d=d|0;var e=0,f=0;bo[c[(c[b>>2]|0)+4>>2]&511](b);e=a[22208]|0;if((e&255)<14){f=d+12+((e&255)<<2)|0;c[b>>2]=c[f>>2];c[f>>2]=b;return}else{ba(5352,173,17448,6544)}}function eH(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0.0,k=0.0;e=df(f,144)|0;if((e|0)==0){h=0;i=h|0;return i|0}f=e;c[f>>2]=19280;c[e+4>>2]=4;c[e+48>>2]=a;c[e+52>>2]=d;c[e+56>>2]=0;c[e+60>>2]=0;c[e+124>>2]=0;c[e+128>>2]=0;vq(e+8|0,0,40);g[e+136>>2]=+P(+(+g[a+16>>2]*+g[d+16>>2]));j=+g[a+20>>2];k=+g[d+20>>2];g[e+140>>2]=j>k?j:k;c[f>>2]=19416;if((c[(c[a+12>>2]|0)+4>>2]|0)!=2){ba(8208,41,16280,11808);return 0}if((c[(c[d+12>>2]|0)+4>>2]|0)==0){h=e;i=h|0;return i|0}else{ba(8208,42,16280,9416);return 0}return 0}function eI(b,d){b=b|0;d=d|0;var e=0,f=0;bo[c[(c[b>>2]|0)+4>>2]&511](b);e=a[22208]|0;if((e&255)<14){f=d+12+((e&255)<<2)|0;c[b>>2]=c[f>>2];c[f>>2]=b;return}else{ba(5352,173,17448,6544)}}function eJ(a){a=a|0;return}function eK(a,b){a=a|0;b=+b;return+0.0}function eL(a){a=a|0;return}function eM(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;d=a+108|0;e=c[d>>2]|0;f=b+28|0;b=c[f>>2]|0;h=b+(e*12&-1)|0;i=+g[h>>2];j=+g[h+4>>2];k=+g[b+(e*12&-1)+8>>2];h=a+112|0;l=c[h>>2]|0;m=b+(l*12&-1)|0;n=+g[m>>2];o=+g[m+4>>2];p=+g[b+(l*12&-1)+8>>2];q=+g[a+128>>2];r=+g[a+124>>2];s=+g[a+136>>2];t=+g[a+132>>2];u=+g[a+116>>2];v=+g[a+120>>2];l=a+100|0;w=+g[l>>2];x=(+g[a+76>>2]+(u*(n+s*(-0.0-p)-(i+q*(-0.0-k)))+v*(o+p*t-(j+k*r)))+ +g[a+96>>2]*w)*(-0.0- +g[a+172>>2]);g[l>>2]=w+x;w=u*x;u=v*x;x=+g[a+156>>2];v=k- +g[a+164>>2]*(u*r-w*q);q=+g[a+160>>2];r=p+ +g[a+168>>2]*(u*t-w*s);a=(c[f>>2]|0)+(e*12&-1)|0;s=+(j-x*u);g[a>>2]=i-x*w;g[a+4>>2]=s;g[(c[f>>2]|0)+((c[d>>2]|0)*12&-1)+8>>2]=v;d=(c[f>>2]|0)+((c[h>>2]|0)*12&-1)|0;v=+(o+u*q);g[d>>2]=n+w*q;g[d+4>>2]=v;g[(c[f>>2]|0)+((c[h>>2]|0)*12&-1)+8>>2]=r;return}function eN(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+48>>2]|0;e=+g[d+24>>2];f=+g[b+80>>2];h=+g[d+20>>2];i=+g[b+84>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function eO(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+52>>2]|0;e=+g[d+24>>2];f=+g[b+88>>2];h=+g[d+20>>2];i=+g[b+92>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function eP(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0;d=+g[b+100>>2]*c;c=d*+g[b+120>>2];g[a>>2]=+g[b+116>>2]*d;g[a+4>>2]=c;return}function eQ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;ca(b,c[(c[a+48>>2]|0)+12>>2]|0,d,c[(c[a+52>>2]|0)+12>>2]|0,e);return}function eR(a){a=a|0;vl(a);return}function eS(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0,aH=0,aI=0,aJ=0,aK=0;e=c[b+48>>2]|0;f=c[e+8>>2]|0;h=b+108|0;c[h>>2]=f;i=c[b+52>>2]|0;j=c[i+8>>2]|0;l=b+112|0;c[l>>2]=j;m=e+28|0;n=b+140|0;o=c[m>>2]|0;p=c[m+4>>2]|0;c[n>>2]=o;c[n+4>>2]=p;n=i+28|0;m=b+148|0;q=c[n>>2]|0;r=c[n+4>>2]|0;c[m>>2]=q;c[m+4>>2]=r;s=+g[e+120>>2];g[b+156>>2]=s;t=+g[i+120>>2];g[b+160>>2]=t;u=+g[e+128>>2];g[b+164>>2]=u;v=+g[i+128>>2];g[b+168>>2]=v;i=c[d+24>>2]|0;e=i+(f*12&-1)|0;w=+g[e>>2];x=+g[e+4>>2];y=+g[i+(f*12&-1)+8>>2];e=d+28|0;m=c[e>>2]|0;n=m+(f*12&-1)|0;z=+g[n>>2];A=+g[n+4>>2];B=+g[m+(f*12&-1)+8>>2];n=i+(j*12&-1)|0;C=+g[n>>2];D=+g[n+4>>2];E=+g[i+(j*12&-1)+8>>2];i=m+(j*12&-1)|0;F=+g[i>>2];G=+g[i+4>>2];H=+g[m+(j*12&-1)+8>>2];I=+S(+y);J=+R(+y);y=+S(+E);K=+R(+E);E=+g[b+80>>2]-(c[k>>2]=o,+g[k>>2]);L=+g[b+84>>2]-(c[k>>2]=p,+g[k>>2]);M=J*E-I*L;N=I*E+J*L;p=b+124|0;L=+N;g[p>>2]=M;g[p+4>>2]=L;L=+g[b+88>>2]-(c[k>>2]=q,+g[k>>2]);J=+g[b+92>>2]-(c[k>>2]=r,+g[k>>2]);E=K*L-y*J;I=y*L+K*J;r=b+132|0;J=+I;g[r>>2]=E;g[r+4>>2]=J;r=b+116|0;J=C+E-w-M;w=D+I-x-N;q=r;x=+w;g[q>>2]=J;g[q+4>>2]=x;q=r|0;x=+P(+(J*J+w*w));if(x>.004999999888241291){D=1.0/x;C=J*D;g[q>>2]=C;O=D*w;Q=C}else{g[q>>2]=0.0;O=0.0;Q=0.0}g[b+120>>2]=O;C=O*M-N*Q;w=O*E-Q*I;D=t+(s+C*C*u)+w*w*v;if(D!=0.0){T=1.0/D}else{T=0.0}q=b+172|0;g[q>>2]=T;w=+g[b+68>>2];if(w>0.0){C=x- +g[b+104>>2];x=w*6.2831854820251465;w=x*T*x;J=+g[d>>2];K=J*(x*T*2.0*+g[b+72>>2]+w*J);r=b+96|0;g[r>>2]=K;if(K!=0.0){U=1.0/K}else{U=0.0}g[r>>2]=U;g[b+76>>2]=w*C*J*U;J=D+U;if(J!=0.0){V=1.0/J}else{V=0.0}g[q>>2]=V}else{g[b+96>>2]=0.0;g[b+76>>2]=0.0}if((a[d+20|0]&1)==0){g[b+100>>2]=0.0;W=B;X=H;Y=F;Z=G;_=z;$=A;aa=c[e>>2]|0;ab=aa+(f*12&-1)|0;ac=ab;ad=(g[k>>2]=_,c[k>>2]|0);ae=(g[k>>2]=$,c[k>>2]|0);af=ae;ag=0;ah=0;ai=af;aj=ad;ak=0;al=ah|aj;am=ai|ak;an=ac|0;c[an>>2]=al;ao=ac+4|0;c[ao>>2]=am;ap=c[h>>2]|0;aq=c[e>>2]|0;ar=aq+(ap*12&-1)+8|0;g[ar>>2]=W;as=c[l>>2]|0;at=c[e>>2]|0;au=at+(as*12&-1)|0;av=au;aw=(g[k>>2]=Y,c[k>>2]|0);ax=(g[k>>2]=Z,c[k>>2]|0);ay=ax;az=0;aA=0;aB=ay;aC=aw;aD=0;aE=aA|aC;aF=aB|aD;aG=av|0;c[aG>>2]=aE;aH=av+4|0;c[aH>>2]=aF;aI=c[l>>2]|0;aJ=c[e>>2]|0;aK=aJ+(aI*12&-1)+8|0;g[aK>>2]=X;return}else{q=b+100|0;V=+g[d+8>>2]*+g[q>>2];g[q>>2]=V;J=Q*V;Q=V*O;W=B-u*(Q*M-J*N);X=H+v*(Q*E-J*I);Y=F+J*t;Z=G+Q*t;_=z-J*s;$=A-Q*s;aa=c[e>>2]|0;ab=aa+(f*12&-1)|0;ac=ab;ad=(g[k>>2]=_,c[k>>2]|0);ae=(g[k>>2]=$,c[k>>2]|0);af=ae;ag=0;ah=0;ai=af;aj=ad;ak=0;al=ah|aj;am=ai|ak;an=ac|0;c[an>>2]=al;ao=ac+4|0;c[ao>>2]=am;ap=c[h>>2]|0;aq=c[e>>2]|0;ar=aq+(ap*12&-1)+8|0;g[ar>>2]=W;as=c[l>>2]|0;at=c[e>>2]|0;au=at+(as*12&-1)|0;av=au;aw=(g[k>>2]=Y,c[k>>2]|0);ax=(g[k>>2]=Z,c[k>>2]|0);ay=ax;az=0;aA=0;aB=ay;aC=aw;aD=0;aE=aA|aC;aF=aB|aD;aG=av|0;c[aG>>2]=aE;aH=av+4|0;c[aH>>2]=aF;aI=c[l>>2]|0;aJ=c[e>>2]|0;aK=aJ+(aI*12&-1)+8|0;g[aK>>2]=X;return}}function eT(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0;if(+g[a+68>>2]>0.0){d=1;return d|0}e=a+108|0;f=c[e>>2]|0;h=b+24|0;b=c[h>>2]|0;i=b+(f*12&-1)|0;j=+g[i>>2];k=+g[i+4>>2];l=+g[b+(f*12&-1)+8>>2];f=a+112|0;m=c[f>>2]|0;n=b+(m*12&-1)|0;o=+g[n>>2];p=+g[n+4>>2];q=+g[b+(m*12&-1)+8>>2];r=+S(+l);s=+R(+l);t=+S(+q);u=+R(+q);v=+g[a+80>>2]- +g[a+140>>2];w=+g[a+84>>2]- +g[a+144>>2];x=s*v-r*w;y=r*v+s*w;w=+g[a+88>>2]- +g[a+148>>2];s=+g[a+92>>2]- +g[a+152>>2];v=u*w-t*s;r=t*w+u*s;s=o+v-j-x;u=p+r-k-y;w=+P(+(s*s+u*u));if(w<1.1920928955078125e-7){z=0.0;A=s;B=u}else{t=1.0/w;z=w;A=s*t;B=u*t}t=z- +g[a+104>>2];z=t<.20000000298023224?t:.20000000298023224;t=z<-.20000000298023224?-.20000000298023224:z;z=t*(-0.0- +g[a+172>>2]);u=A*z;A=B*z;z=+g[a+156>>2];B=l- +g[a+164>>2]*(x*A-y*u);y=+g[a+160>>2];x=q+ +g[a+168>>2]*(v*A-r*u);r=+(k-z*A);g[i>>2]=j-z*u;g[i+4>>2]=r;g[(c[h>>2]|0)+((c[e>>2]|0)*12&-1)+8>>2]=B;e=(c[h>>2]|0)+((c[f>>2]|0)*12&-1)|0;B=+(p+y*A);g[e>>2]=o+y*u;g[e+4>>2]=B;g[(c[h>>2]|0)+((c[f>>2]|0)*12&-1)+8>>2]=x;if(t>0.0){C=t}else{C=-0.0-t}d=C<.004999999888241291;return d|0}function eU(b){b=b|0;var d=0,e=0,f=0,j=0.0;d=i;e=c[(c[b+48>>2]|0)+8>>2]|0;f=c[(c[b+52>>2]|0)+8>>2]|0;db(7888,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(11336,(u=i,i=i+8|0,c[u>>2]=e,u)|0);db(8808,(u=i,i=i+8|0,c[u>>2]=f,u)|0);db(6768,(u=i,i=i+8|0,c[u>>2]=a[b+61|0]&1,u)|0);j=+g[b+84>>2];db(5992,(u=i,i=i+16|0,h[u>>3]=+g[b+80>>2],h[u+8>>3]=j,u)|0);j=+g[b+92>>2];db(5536,(u=i,i=i+16|0,h[u>>3]=+g[b+88>>2],h[u+8>>3]=j,u)|0);db(5176,(u=i,i=i+8|0,h[u>>3]=+g[b+104>>2],u)|0);db(12768,(u=i,i=i+8|0,h[u>>3]=+g[b+68>>2],u)|0);db(12472,(u=i,i=i+8|0,h[u>>3]=+g[b+72>>2],u)|0);db(11904,(u=i,i=i+8|0,c[u>>2]=c[b+56>>2],u)|0);i=d;return}function eV(a){a=a|0;vl(a);return}function eW(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0.0,k=0.0;e=df(f,144)|0;if((e|0)==0){h=0;i=h|0;return i|0}f=e;c[f>>2]=19280;c[e+4>>2]=4;c[e+48>>2]=a;c[e+52>>2]=d;c[e+56>>2]=0;c[e+60>>2]=0;c[e+124>>2]=0;c[e+128>>2]=0;vq(e+8|0,0,40);g[e+136>>2]=+P(+(+g[a+16>>2]*+g[d+16>>2]));j=+g[a+20>>2];k=+g[d+20>>2];g[e+140>>2]=j>k?j:k;c[f>>2]=19736;if((c[(c[a+12>>2]|0)+4>>2]|0)!=2){ba(7976,44,17304,11808);return 0}if((c[(c[d+12>>2]|0)+4>>2]|0)==2){h=e;i=h|0;return i|0}else{ba(7976,45,17304,9368);return 0}return 0}function eX(b,d){b=b|0;d=d|0;var e=0,f=0;bo[c[(c[b>>2]|0)+4>>2]&511](b);e=a[22208]|0;if((e&255)<14){f=d+12+((e&255)<<2)|0;c[b>>2]=c[f>>2];c[f>>2]=b;return}else{ba(5352,173,17448,6544)}}function eY(a,b){a=a|0;b=b|0;return 1}function eZ(a){a=a|0;return}function e_(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+48>>2]|0;e=+g[d+24>>2];f=+g[b+68>>2];h=+g[d+20>>2];i=+g[b+72>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function e$(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+52>>2]|0;e=+g[d+24>>2];f=+g[b+76>>2];h=+g[d+20>>2];i=+g[b+80>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function e0(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0;d=+g[b+88>>2]*c;g[a>>2]=+g[b+84>>2]*c;g[a+4>>2]=d;return}function e1(a,b){a=a|0;b=+b;return+(+g[a+92>>2]*b)}function e2(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,T=0.0,U=0.0;e=c[b+48>>2]|0;f=c[e+8>>2]|0;h=b+104|0;c[h>>2]=f;i=c[b+52>>2]|0;j=c[i+8>>2]|0;l=b+108|0;c[l>>2]=j;m=e+28|0;n=b+128|0;o=c[m>>2]|0;p=c[m+4>>2]|0;c[n>>2]=o;c[n+4>>2]=p;n=i+28|0;m=b+136|0;q=c[n>>2]|0;r=c[n+4>>2]|0;c[m>>2]=q;c[m+4>>2]=r;s=+g[e+120>>2];g[b+144>>2]=s;t=+g[i+120>>2];g[b+148>>2]=t;u=+g[e+128>>2];g[b+152>>2]=u;v=+g[i+128>>2];g[b+156>>2]=v;i=c[d+24>>2]|0;w=+g[i+(f*12&-1)+8>>2];e=d+28|0;m=c[e>>2]|0;n=m+(f*12&-1)|0;x=+g[n>>2];y=+g[n+4>>2];z=+g[m+(f*12&-1)+8>>2];A=+g[i+(j*12&-1)+8>>2];i=m+(j*12&-1)|0;B=+g[i>>2];C=+g[i+4>>2];D=+g[m+(j*12&-1)+8>>2];E=+S(+w);F=+R(+w);w=+S(+A);G=+R(+A);A=+g[b+68>>2]-(c[k>>2]=o,+g[k>>2]);H=+g[b+72>>2]-(c[k>>2]=p,+g[k>>2]);I=F*A-E*H;J=E*A+F*H;p=b+112|0;H=+J;g[p>>2]=I;g[p+4>>2]=H;H=+g[b+76>>2]-(c[k>>2]=q,+g[k>>2]);F=+g[b+80>>2]-(c[k>>2]=r,+g[k>>2]);A=G*H-w*F;E=w*H+G*F;r=b+120|0;F=+E;g[r>>2]=A;g[r+4>>2]=F;F=s+t;G=F+J*u*J+E*v*E;H=v*A;w=J*I*(-0.0-u)-E*H;K=F+I*u*I+A*H;H=G*K-w*w;if(H!=0.0){L=1.0/H}else{L=H}H=w*(-0.0-L);g[b+160>>2]=K*L;g[b+164>>2]=H;g[b+168>>2]=H;g[b+172>>2]=G*L;L=u+v;if(L>0.0){M=1.0/L}else{M=L}g[b+176>>2]=M;r=b+84|0;if((a[d+20|0]&1)==0){g[r>>2]=0.0;g[b+88>>2]=0.0;g[b+92>>2]=0.0;N=z;O=D;P=B;Q=C;T=x;U=y}else{q=d+8|0;M=+g[q>>2];d=r|0;L=M*+g[d>>2];g[d>>2]=L;d=b+88|0;G=M*+g[d>>2];g[d>>2]=G;d=b+92|0;M=+g[q>>2]*+g[d>>2];g[d>>2]=M;N=z-u*(M+(G*I-L*J));O=D+v*(M+(G*A-L*E));P=B+t*L;Q=C+t*G;T=x-s*L;U=y-s*G}d=(c[e>>2]|0)+(f*12&-1)|0;G=+U;g[d>>2]=T;g[d+4>>2]=G;g[(c[e>>2]|0)+((c[h>>2]|0)*12&-1)+8>>2]=N;h=(c[e>>2]|0)+((c[l>>2]|0)*12&-1)|0;N=+Q;g[h>>2]=P;g[h+4>>2]=N;g[(c[e>>2]|0)+((c[l>>2]|0)*12&-1)+8>>2]=O;return}function e3(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;d=a+104|0;e=c[d>>2]|0;f=b+28|0;h=c[f>>2]|0;i=h+(e*12&-1)|0;j=+g[i>>2];k=+g[i+4>>2];l=+g[h+(e*12&-1)+8>>2];i=a+108|0;m=c[i>>2]|0;n=h+(m*12&-1)|0;o=+g[n>>2];p=+g[n+4>>2];q=+g[h+(m*12&-1)+8>>2];r=+g[a+144>>2];s=+g[a+148>>2];t=+g[a+152>>2];u=+g[a+156>>2];v=+g[b>>2];b=a+92|0;w=+g[b>>2];x=v*+g[a+100>>2];y=w+(q-l)*(-0.0- +g[a+176>>2]);z=-0.0-x;A=y<x?y:x;x=A<z?z:A;g[b>>2]=x;A=x-w;w=l-t*A;l=q+u*A;A=+g[a+124>>2];q=+g[a+120>>2];x=+g[a+116>>2];z=+g[a+112>>2];y=o+A*(-0.0-l)-j-x*(-0.0-w);B=p+q*l-k-z*w;C=+g[a+172>>2]*B+ +g[a+164>>2]*y;b=a+84|0;m=b;D=+g[m>>2];E=+g[m+4>>2];m=b|0;F=D-(+g[a+168>>2]*B+ +g[a+160>>2]*y);g[m>>2]=F;b=a+88|0;y=+g[b>>2]-C;g[b>>2]=y;C=v*+g[a+96>>2];v=F*F+y*y;if(v>C*C){B=+P(+v);if(B<1.1920928955078125e-7){G=F;H=y}else{v=1.0/B;B=F*v;g[m>>2]=B;I=y*v;g[b>>2]=I;G=B;H=I}I=C*G;g[m>>2]=I;G=C*H;g[b>>2]=G;J=I;K=G}else{J=F;K=y}y=J-D;D=K-E;b=(c[f>>2]|0)+(e*12&-1)|0;E=+(k-r*D);g[b>>2]=j-r*y;g[b+4>>2]=E;g[(c[f>>2]|0)+((c[d>>2]|0)*12&-1)+8>>2]=w-t*(z*D-y*x);d=(c[f>>2]|0)+((c[i>>2]|0)*12&-1)|0;x=+(p+s*D);g[d>>2]=o+s*y;g[d+4>>2]=x;g[(c[f>>2]|0)+((c[i>>2]|0)*12&-1)+8>>2]=l+u*(D*q-y*A);return}function e4(b){b=b|0;var d=0,e=0,f=0,j=0.0;d=i;e=c[(c[b+48>>2]|0)+8>>2]|0;f=c[(c[b+52>>2]|0)+8>>2]|0;db(7056,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(11336,(u=i,i=i+8|0,c[u>>2]=e,u)|0);db(8808,(u=i,i=i+8|0,c[u>>2]=f,u)|0);db(6768,(u=i,i=i+8|0,c[u>>2]=a[b+61|0]&1,u)|0);j=+g[b+72>>2];db(5992,(u=i,i=i+16|0,h[u>>3]=+g[b+68>>2],h[u+8>>3]=j,u)|0);j=+g[b+80>>2];db(5536,(u=i,i=i+16|0,h[u>>3]=+g[b+76>>2],h[u+8>>3]=j,u)|0);db(4328,(u=i,i=i+8|0,h[u>>3]=+g[b+96>>2],u)|0);db(12832,(u=i,i=i+8|0,h[u>>3]=+g[b+100>>2],u)|0);db(11904,(u=i,i=i+8|0,c[u>>2]=c[b+56>>2],u)|0);i=d;return}function e5(a){a=a|0;vl(a);return}function e6(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0.0,L=0,M=0.0,N=0.0,O=0,P=0;e=b|0;c[e>>2]=19312;f=d+8|0;h=d+12|0;if((c[f>>2]|0)==(c[h>>2]|0)){ba(7272,173,15744,9072)}c[b+4>>2]=c[d>>2];c[b+8>>2]=0;c[b+12>>2]=0;i=b+48|0;c[i>>2]=c[f>>2];f=b+52|0;c[f>>2]=c[h>>2];c[b+56>>2]=0;a[b+61|0]=a[d+16|0]&1;a[b+60|0]=0;c[b+64>>2]=c[d+4>>2];vq(b+16|0,0,32);c[e>>2]=20456;e=b+92|0;h=b+100|0;j=b+108|0;l=b+116|0;m=b+124|0;n=b+132|0;o=d+20|0;p=c[o>>2]|0;c[b+68>>2]=p;q=d+24|0;r=c[q>>2]|0;c[b+72>>2]=r;s=c[p+4>>2]|0;c[b+76>>2]=s;t=c[r+4>>2]|0;c[b+80>>2]=t;if((s-1|0)>>>0>=2){ba(7384,53,18560,11640)}if((t-1|0)>>>0>=2){ba(7384,54,18560,9168)}u=c[p+48>>2]|0;c[b+84>>2]=u;v=c[p+52>>2]|0;c[i>>2]=v;w=+g[v+20>>2];x=+g[v+24>>2];y=+g[u+20>>2];z=+g[u+24>>2];i=c[o>>2]|0;if((s|0)==1){A=+g[v+56>>2];B=+g[u+56>>2];s=i+68|0;o=j;p=c[s+4>>2]|0;c[o>>2]=c[s>>2];c[o+4>>2]=p;p=i+76|0;o=e;s=c[p+4>>2]|0;c[o>>2]=c[p>>2];c[o+4>>2]=s;C=+g[i+116>>2];g[b+140>>2]=C;g[m>>2]=0.0;g[b+128>>2]=0.0;D=A-B-C}else{C=+g[u+16>>2];B=+g[u+12>>2];A=+g[v+16>>2];E=+g[v+12>>2];v=i+68|0;u=j;j=c[v>>2]|0;s=c[v+4>>2]|0;c[u>>2]=j;c[u+4>>2]=s;u=i+76|0;v=e;e=c[u>>2]|0;o=c[u+4>>2]|0;c[v>>2]=e;c[v+4>>2]=o;g[b+140>>2]=+g[i+100>>2];v=i+84|0;i=m;m=c[v>>2]|0;u=c[v+4>>2]|0;c[i>>2]=m;c[i+4>>2]=u;F=(c[k>>2]=e,+g[k>>2]);G=(c[k>>2]=o,+g[k>>2]);H=E-B+(x*F-w*G);B=A-C+(w*F+x*G);D=(c[k>>2]=m,+g[k>>2])*(z*H+y*B-(c[k>>2]=j,+g[k>>2]))+(c[k>>2]=u,+g[k>>2])*(H*(-0.0-y)+z*B-(c[k>>2]=s,+g[k>>2]))}s=c[r+48>>2]|0;c[b+88>>2]=s;u=c[r+52>>2]|0;c[f>>2]=u;B=+g[u+20>>2];z=+g[u+24>>2];y=+g[s+20>>2];H=+g[s+24>>2];f=c[q>>2]|0;if((t|0)==1){G=+g[u+56>>2];x=+g[s+56>>2];t=f+68|0;q=l;r=c[t+4>>2]|0;c[q>>2]=c[t>>2];c[q+4>>2]=r;r=f+76|0;q=h;t=c[r+4>>2]|0;c[q>>2]=c[r>>2];c[q+4>>2]=t;F=+g[f+116>>2];g[b+144>>2]=F;g[n>>2]=0.0;g[b+136>>2]=0.0;I=G-x-F;J=d+28|0;K=+g[J>>2];L=b+152|0;g[L>>2]=K;M=I*K;N=D+M;O=b+148|0;g[O>>2]=N;P=b+156|0;g[P>>2]=0.0;return}else{F=+g[s+16>>2];x=+g[s+12>>2];G=+g[u+16>>2];w=+g[u+12>>2];u=f+68|0;s=l;l=c[u>>2]|0;t=c[u+4>>2]|0;c[s>>2]=l;c[s+4>>2]=t;s=f+76|0;u=h;h=c[s>>2]|0;q=c[s+4>>2]|0;c[u>>2]=h;c[u+4>>2]=q;g[b+144>>2]=+g[f+100>>2];u=f+84|0;f=n;n=c[u>>2]|0;s=c[u+4>>2]|0;c[f>>2]=n;c[f+4>>2]=s;C=(c[k>>2]=h,+g[k>>2]);A=(c[k>>2]=q,+g[k>>2]);E=w-x+(z*C-B*A);x=G-F+(B*C+z*A);I=(c[k>>2]=n,+g[k>>2])*(H*E+y*x-(c[k>>2]=l,+g[k>>2]))+(c[k>>2]=s,+g[k>>2])*(E*(-0.0-y)+H*x-(c[k>>2]=t,+g[k>>2]));J=d+28|0;K=+g[J>>2];L=b+152|0;g[L>>2]=K;M=I*K;N=D+M;O=b+148|0;g[O>>2]=N;P=b+156|0;g[P>>2]=0.0;return}}function e7(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;d=a+160|0;e=c[d>>2]|0;f=b+28|0;b=c[f>>2]|0;h=b+(e*12&-1)|0;i=+g[h>>2];j=+g[h+4>>2];k=+g[b+(e*12&-1)+8>>2];h=a+164|0;l=c[h>>2]|0;m=b+(l*12&-1)|0;n=+g[m>>2];o=+g[m+4>>2];p=+g[b+(l*12&-1)+8>>2];l=a+168|0;m=c[l>>2]|0;q=b+(m*12&-1)|0;r=+g[q>>2];s=+g[q+4>>2];t=+g[b+(m*12&-1)+8>>2];m=a+172|0;q=c[m>>2]|0;u=b+(q*12&-1)|0;v=+g[u>>2];w=+g[u+4>>2];x=+g[b+(q*12&-1)+8>>2];y=+g[a+240>>2];z=+g[a+244>>2];A=+g[a+248>>2];B=+g[a+252>>2];C=+g[a+256>>2];D=+g[a+264>>2];E=+g[a+260>>2];F=+g[a+268>>2];G=((i-r)*y+(j-s)*z+((n-v)*A+(o-w)*B)+(k*C-t*D+(p*E-x*F)))*(-0.0- +g[a+272>>2]);q=a+156|0;g[q>>2]=+g[q>>2]+G;H=+g[a+208>>2]*G;I=k+G*+g[a+224>>2]*C;C=G*+g[a+212>>2];k=p+G*+g[a+228>>2]*E;E=G*+g[a+216>>2];p=t-G*+g[a+232>>2]*D;D=G*+g[a+220>>2];t=x-G*+g[a+236>>2]*F;a=(c[f>>2]|0)+(e*12&-1)|0;F=+(j+z*H);g[a>>2]=i+y*H;g[a+4>>2]=F;g[(c[f>>2]|0)+((c[d>>2]|0)*12&-1)+8>>2]=I;d=(c[f>>2]|0)+((c[h>>2]|0)*12&-1)|0;I=+(o+C*B);g[d>>2]=n+A*C;g[d+4>>2]=I;g[(c[f>>2]|0)+((c[h>>2]|0)*12&-1)+8>>2]=k;h=(c[f>>2]|0)+((c[l>>2]|0)*12&-1)|0;k=+(s-z*E);g[h>>2]=r-y*E;g[h+4>>2]=k;g[(c[f>>2]|0)+((c[l>>2]|0)*12&-1)+8>>2]=p;l=(c[f>>2]|0)+((c[m>>2]|0)*12&-1)|0;p=+(w-B*D);g[l>>2]=v-A*D;g[l+4>>2]=p;g[(c[f>>2]|0)+((c[m>>2]|0)*12&-1)+8>>2]=t;return}function e8(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0.0,ac=0.0,ad=0.0,ae=0.0,af=0.0,ag=0.0,ah=0.0,ai=0.0,aj=0.0,ak=0.0,al=0.0,am=0.0,an=0.0,ao=0.0,ap=0.0,aq=0.0,ar=0.0,as=0.0,at=0.0,au=0.0,av=0.0,aw=0.0,ax=0.0,ay=0.0,az=0.0,aA=0.0,aB=0.0,aC=0.0,aD=0.0,aE=0.0,aF=0.0,aG=0.0,aH=0.0,aI=0.0,aJ=0.0,aK=0.0,aL=0.0;e=c[b+48>>2]|0;f=c[e+8>>2]|0;h=b+160|0;c[h>>2]=f;i=c[b+52>>2]|0;j=c[i+8>>2]|0;l=b+164|0;c[l>>2]=j;m=c[b+84>>2]|0;n=c[m+8>>2]|0;o=b+168|0;c[o>>2]=n;p=c[b+88>>2]|0;q=c[p+8>>2]|0;r=b+172|0;c[r>>2]=q;s=e+28|0;t=b+176|0;u=c[s>>2]|0;v=c[s+4>>2]|0;c[t>>2]=u;c[t+4>>2]=v;t=i+28|0;s=b+184|0;w=c[t>>2]|0;x=c[t+4>>2]|0;c[s>>2]=w;c[s+4>>2]=x;s=m+28|0;t=b+192|0;y=c[s>>2]|0;z=c[s+4>>2]|0;c[t>>2]=y;c[t+4>>2]=z;t=p+28|0;s=b+200|0;A=c[t>>2]|0;B=c[t+4>>2]|0;c[s>>2]=A;c[s+4>>2]=B;C=+g[e+120>>2];g[b+208>>2]=C;D=+g[i+120>>2];g[b+212>>2]=D;E=+g[m+120>>2];g[b+216>>2]=E;F=+g[p+120>>2];g[b+220>>2]=F;G=+g[e+128>>2];g[b+224>>2]=G;H=+g[i+128>>2];g[b+228>>2]=H;I=+g[m+128>>2];g[b+232>>2]=I;J=+g[p+128>>2];g[b+236>>2]=J;p=c[d+24>>2]|0;K=+g[p+(f*12&-1)+8>>2];m=d+28|0;i=c[m>>2]|0;e=i+(f*12&-1)|0;L=+g[e>>2];M=+g[e+4>>2];N=+g[i+(f*12&-1)+8>>2];O=+g[p+(j*12&-1)+8>>2];e=i+(j*12&-1)|0;P=+g[e>>2];Q=+g[e+4>>2];T=+g[i+(j*12&-1)+8>>2];U=+g[p+(n*12&-1)+8>>2];j=i+(n*12&-1)|0;V=+g[j>>2];W=+g[j+4>>2];X=+g[i+(n*12&-1)+8>>2];Y=+g[p+(q*12&-1)+8>>2];p=i+(q*12&-1)|0;Z=+g[p>>2];_=+g[p+4>>2];$=+g[i+(q*12&-1)+8>>2];aa=+S(+K);ab=+R(+K);K=+S(+O);ac=+R(+O);O=+S(+U);ad=+R(+U);U=+S(+Y);ae=+R(+Y);q=b+272|0;g[q>>2]=0.0;Y=(c[k>>2]=A,+g[k>>2]);af=(c[k>>2]=B,+g[k>>2]);ag=(c[k>>2]=w,+g[k>>2]);ah=(c[k>>2]=x,+g[k>>2]);if((c[b+76>>2]|0)==1){g[b+240>>2]=0.0;g[b+244>>2]=0.0;g[b+256>>2]=1.0;g[b+264>>2]=1.0;ai=G+I;aj=0.0;ak=0.0;al=1.0;am=1.0}else{an=+g[b+124>>2];ao=+g[b+128>>2];ap=ad*an-O*ao;aq=O*an+ad*ao;ao=+g[b+108>>2]-(c[k>>2]=y,+g[k>>2]);an=+g[b+112>>2]-(c[k>>2]=z,+g[k>>2]);ar=+g[b+92>>2]-(c[k>>2]=u,+g[k>>2]);as=+g[b+96>>2]-(c[k>>2]=v,+g[k>>2]);v=b+240|0;at=+aq;g[v>>2]=ap;g[v+4>>2]=at;at=aq*(ad*ao-O*an)-ap*(O*ao+ad*an);g[b+264>>2]=at;an=aq*(ab*ar-aa*as)-ap*(aa*ar+ab*as);g[b+256>>2]=an;ai=E+C+at*I*at+an*G*an;aj=ap;ak=aq;al=an;am=at}at=ai+0.0;g[q>>2]=at;if((c[b+80>>2]|0)==1){g[b+248>>2]=0.0;g[b+252>>2]=0.0;ai=+g[b+152>>2];g[b+260>>2]=ai;g[b+268>>2]=ai;au=ai*ai*(H+J);av=0.0;aw=0.0;ax=ai;ay=ai}else{ai=+g[b+132>>2];an=+g[b+136>>2];aq=ae*ai-U*an;ap=U*ai+ae*an;an=+g[b+116>>2]-Y;Y=+g[b+120>>2]-af;af=+g[b+100>>2]-ag;ag=+g[b+104>>2]-ah;ah=+g[b+152>>2];ai=aq*ah;as=ap*ah;v=b+248|0;ab=+as;g[v>>2]=ai;g[v+4>>2]=ab;ab=(ap*(ae*an-U*Y)-aq*(U*an+ae*Y))*ah;g[b+268>>2]=ab;Y=ah*(ap*(ac*af-K*ag)-aq*(K*af+ac*ag));g[b+260>>2]=Y;au=ah*ah*(F+D)+ab*J*ab+Y*Y*H;av=ai;aw=as;ax=Y;ay=ab}ab=at+au;g[q>>2]=ab;if(ab>0.0){az=1.0/ab}else{az=0.0}g[q>>2]=az;q=b+156|0;if((a[d+20|0]&1)==0){g[q>>2]=0.0;aA=$;aB=N;aC=X;aD=T;aE=Z;aF=_;aG=V;aH=W;aI=P;aJ=Q;aK=L;aL=M}else{az=+g[q>>2];ab=C*az;C=az*D;D=az*E;E=az*F;aA=$-az*J*ay;aB=N+az*G*al;aC=X-az*I*am;aD=T+az*H*ax;aE=Z-av*E;aF=_-aw*E;aG=V-aj*D;aH=W-ak*D;aI=P+av*C;aJ=Q+C*aw;aK=L+aj*ab;aL=M+ab*ak}q=(c[m>>2]|0)+(f*12&-1)|0;ak=+aL;g[q>>2]=aK;g[q+4>>2]=ak;g[(c[m>>2]|0)+((c[h>>2]|0)*12&-1)+8>>2]=aB;h=(c[m>>2]|0)+((c[l>>2]|0)*12&-1)|0;aB=+aJ;g[h>>2]=aI;g[h+4>>2]=aB;g[(c[m>>2]|0)+((c[l>>2]|0)*12&-1)+8>>2]=aD;l=(c[m>>2]|0)+((c[o>>2]|0)*12&-1)|0;aD=+aH;g[l>>2]=aG;g[l+4>>2]=aD;g[(c[m>>2]|0)+((c[o>>2]|0)*12&-1)+8>>2]=aC;o=(c[m>>2]|0)+((c[r>>2]|0)*12&-1)|0;aC=+aF;g[o>>2]=aE;g[o+4>>2]=aC;g[(c[m>>2]|0)+((c[r>>2]|0)*12&-1)+8>>2]=aA;return}function e9(a){a=a|0;return}function fa(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+48>>2]|0;e=+g[d+24>>2];f=+g[b+92>>2];h=+g[d+20>>2];i=+g[b+96>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function fb(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+52>>2]|0;e=+g[d+24>>2];f=+g[b+100>>2];h=+g[d+20>>2];i=+g[b+104>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function fc(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0,e=0.0;d=+g[b+156>>2];e=d*+g[b+244>>2]*c;g[a>>2]=d*+g[b+240>>2]*c;g[a+4>>2]=e;return}function fd(a,b){a=a|0;b=+b;return+(+g[a+156>>2]*+g[a+256>>2]*b)}function fe(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0.0,ac=0.0,ad=0.0,ae=0.0,af=0.0,ag=0.0,ah=0.0,ai=0.0;d=a+160|0;e=c[d>>2]|0;f=b+24|0;b=c[f>>2]|0;h=b+(e*12&-1)|0;i=+g[h>>2];j=+g[h+4>>2];k=+g[b+(e*12&-1)+8>>2];e=a+164|0;l=c[e>>2]|0;m=b+(l*12&-1)|0;n=+g[m>>2];o=+g[m+4>>2];p=+g[b+(l*12&-1)+8>>2];l=a+168|0;m=c[l>>2]|0;q=b+(m*12&-1)|0;r=+g[q>>2];s=+g[q+4>>2];t=+g[b+(m*12&-1)+8>>2];m=a+172|0;q=c[m>>2]|0;u=b+(q*12&-1)|0;v=+g[u>>2];w=+g[u+4>>2];x=+g[b+(q*12&-1)+8>>2];y=+S(+k);z=+R(+k);A=+S(+p);B=+R(+p);C=+S(+t);D=+R(+t);E=+S(+x);F=+R(+x);if((c[a+76>>2]|0)==1){G=+g[a+224>>2];H=+g[a+232>>2];I=G+H;J=1.0;K=1.0;L=k-t- +g[a+140>>2];M=0.0;N=0.0;O=G;P=H}else{H=+g[a+124>>2];G=+g[a+128>>2];Q=D*H-C*G;T=C*H+D*G;U=+g[a+108>>2]- +g[a+192>>2];V=+g[a+112>>2]- +g[a+196>>2];W=+g[a+92>>2]- +g[a+176>>2];X=+g[a+96>>2]- +g[a+180>>2];Y=z*W-y*X;Z=y*W+z*X;X=T*(D*U-C*V)-Q*(C*U+D*V);z=T*Y-Q*Z;W=+g[a+232>>2];y=+g[a+224>>2];_=i-r+Y;Y=j-s+Z;I=+g[a+216>>2]+ +g[a+208>>2]+X*X*W+z*y*z;J=X;K=z;L=H*(D*_+C*Y-U)+G*(_*(-0.0-C)+D*Y-V);M=Q;N=T;O=y;P=W}if((c[a+80>>2]|0)==1){W=+g[a+152>>2];y=+g[a+228>>2];T=+g[a+236>>2];$=W*W*(y+T);aa=W;ab=W;ac=p-x- +g[a+144>>2];ad=0.0;ae=0.0;af=W;ag=y;ah=T}else{T=+g[a+132>>2];y=+g[a+136>>2];W=F*T-E*y;Q=E*T+F*y;V=+g[a+116>>2]- +g[a+200>>2];Y=+g[a+120>>2]- +g[a+204>>2];D=+g[a+100>>2]- +g[a+184>>2];C=+g[a+104>>2]- +g[a+188>>2];_=B*D-A*C;G=A*D+B*C;C=+g[a+152>>2];B=C*(Q*(F*V-E*Y)-W*(E*V+F*Y));D=C*(Q*_-W*G);A=+g[a+236>>2];U=+g[a+228>>2];H=n-v+_;_=o-w+G;$=C*C*(+g[a+220>>2]+ +g[a+212>>2])+B*B*A+D*U*D;aa=B;ab=D;ac=T*(F*H+E*_-V)+y*(H*(-0.0-E)+F*_-Y);ad=W*C;ae=Q*C;af=C;ag=U;ah=A}A=I+0.0+$;if(A>0.0){ai=(-0.0-(L+ac*af- +g[a+148>>2]))/A}else{ai=0.0}A=ai*+g[a+208>>2];af=ai*+g[a+212>>2];ac=ai*+g[a+216>>2];L=ai*+g[a+220>>2];$=+(j+N*A);g[h>>2]=i+M*A;g[h+4>>2]=$;g[(c[f>>2]|0)+((c[d>>2]|0)*12&-1)+8>>2]=k+K*ai*O;d=(c[f>>2]|0)+((c[e>>2]|0)*12&-1)|0;O=+(o+ae*af);g[d>>2]=n+ad*af;g[d+4>>2]=O;g[(c[f>>2]|0)+((c[e>>2]|0)*12&-1)+8>>2]=p+ab*ai*ag;e=(c[f>>2]|0)+((c[l>>2]|0)*12&-1)|0;ag=+(s-N*ac);g[e>>2]=r-M*ac;g[e+4>>2]=ag;g[(c[f>>2]|0)+((c[l>>2]|0)*12&-1)+8>>2]=t-J*ai*P;l=(c[f>>2]|0)+((c[m>>2]|0)*12&-1)|0;P=+(w-ae*L);g[l>>2]=v-ad*L;g[l+4>>2]=P;g[(c[f>>2]|0)+((c[m>>2]|0)*12&-1)+8>>2]=x-aa*ai*ah;return 1}function ff(b){b=b|0;var d=0,e=0,f=0,j=0,k=0;d=i;e=c[(c[b+48>>2]|0)+8>>2]|0;f=c[(c[b+52>>2]|0)+8>>2]|0;j=c[(c[b+68>>2]|0)+56>>2]|0;k=c[(c[b+72>>2]|0)+56>>2]|0;db(6104,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(11336,(u=i,i=i+8|0,c[u>>2]=e,u)|0);db(8808,(u=i,i=i+8|0,c[u>>2]=f,u)|0);db(6768,(u=i,i=i+8|0,c[u>>2]=a[b+61|0]&1,u)|0);db(4568,(u=i,i=i+8|0,c[u>>2]=j,u)|0);db(4296,(u=i,i=i+8|0,c[u>>2]=k,u)|0);db(11504,(u=i,i=i+8|0,h[u>>3]=+g[b+152>>2],u)|0);db(11904,(u=i,i=i+8|0,c[u>>2]=c[b+56>>2],u)|0);i=d;return}function fg(a){a=a|0;vl(a);return}function fh(a){a=a|0;return}function fi(a){a=a|0;a=i;db(6944,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);i=a;return}function fj(a){a=a|0;vl(a);return}function fk(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;e=b|0;f=c[e>>2]|0;if((f|0)==10){h=df(d,168)|0;do{if((h|0)==0){i=0}else{j=h;c[j>>2]=19312;k=b+8|0;l=b+12|0;if((c[k>>2]|0)==(c[l>>2]|0)){ba(7272,173,15744,9072);return 0}else{c[h+4>>2]=c[e>>2];c[h+8>>2]=0;c[h+12>>2]=0;c[h+48>>2]=c[k>>2];c[h+52>>2]=c[l>>2];c[h+56>>2]=0;a[h+61|0]=a[b+16|0]&1;a[h+60|0]=0;c[h+64>>2]=c[b+4>>2];vq(h+16|0,0,32);c[j>>2]=20400;j=b+20|0;l=h+68|0;k=c[j+4>>2]|0;c[l>>2]=c[j>>2];c[l+4>>2]=k;k=b+28|0;l=h+76|0;j=c[k+4>>2]|0;c[l>>2]=c[k>>2];c[l+4>>2]=j;g[h+84>>2]=+g[b+36>>2];g[h+160>>2]=0.0;g[h+92>>2]=0.0;c[h+164>>2]=0;g[h+88>>2]=0.0;i=h;break}}}while(0);m=i|0;return m|0}else if((f|0)==2){i=df(d,256)|0;if((i|0)==0){n=0}else{h=i;fx(h,b);n=h}m=n|0;return m|0}else if((f|0)==3){n=df(d,176)|0;do{if((n|0)==0){o=0}else{h=n;c[h>>2]=19312;i=b+8|0;j=b+12|0;if((c[i>>2]|0)==(c[j>>2]|0)){ba(7272,173,15744,9072);return 0}else{c[n+4>>2]=c[e>>2];c[n+8>>2]=0;c[n+12>>2]=0;c[n+48>>2]=c[i>>2];c[n+52>>2]=c[j>>2];c[n+56>>2]=0;a[n+61|0]=a[b+16|0]&1;a[n+60|0]=0;c[n+64>>2]=c[b+4>>2];vq(n+16|0,0,32);c[h>>2]=19912;h=b+20|0;j=n+80|0;i=c[h+4>>2]|0;c[j>>2]=c[h>>2];c[j+4>>2]=i;i=b+28|0;j=n+88|0;h=c[i+4>>2]|0;c[j>>2]=c[i>>2];c[j+4>>2]=h;g[n+104>>2]=+g[b+36>>2];g[n+68>>2]=+g[b+40>>2];g[n+72>>2]=+g[b+44>>2];g[n+100>>2]=0.0;g[n+96>>2]=0.0;g[n+76>>2]=0.0;o=n;break}}}while(0);m=o|0;return m|0}else if((f|0)==1){o=df(d,228)|0;do{if((o|0)==0){p=0}else{n=o;c[n>>2]=19312;h=b+8|0;j=b+12|0;if((c[h>>2]|0)==(c[j>>2]|0)){ba(7272,173,15744,9072);return 0}else{c[o+4>>2]=c[e>>2];c[o+8>>2]=0;c[o+12>>2]=0;c[o+48>>2]=c[h>>2];c[o+52>>2]=c[j>>2];c[o+56>>2]=0;a[o+61|0]=a[b+16|0]&1;a[o+60|0]=0;c[o+64>>2]=c[b+4>>2];vq(o+16|0,0,32);c[n>>2]=19768;n=b+20|0;j=o+68|0;h=c[n+4>>2]|0;c[j>>2]=c[n>>2];c[j+4>>2]=h;h=b+28|0;j=o+76|0;n=c[h+4>>2]|0;c[j>>2]=c[h>>2];c[j+4>>2]=n;g[o+116>>2]=+g[b+36>>2];vq(o+84|0,0,16);g[o+120>>2]=+g[b+44>>2];g[o+124>>2]=+g[b+48>>2];g[o+104>>2]=+g[b+60>>2];g[o+108>>2]=+g[b+56>>2];a[o+112|0]=a[b+40|0]&1;a[o+100|0]=a[b+52|0]&1;c[o+224>>2]=0;p=o;break}}}while(0);m=p|0;return m|0}else if((f|0)==8){p=df(d,208)|0;do{if((p|0)==0){q=0}else{o=p;c[o>>2]=19312;n=b+8|0;j=b+12|0;if((c[n>>2]|0)==(c[j>>2]|0)){ba(7272,173,15744,9072);return 0}else{c[p+4>>2]=c[e>>2];c[p+8>>2]=0;c[p+12>>2]=0;c[p+48>>2]=c[n>>2];c[p+52>>2]=c[j>>2];c[p+56>>2]=0;a[p+61|0]=a[b+16|0]&1;a[p+60|0]=0;c[p+64>>2]=c[b+4>>2];vq(p+16|0,0,32);c[o>>2]=20344;o=b+20|0;j=p+80|0;n=c[o+4>>2]|0;c[j>>2]=c[o>>2];c[j+4>>2]=n;n=b+28|0;j=p+88|0;o=c[n+4>>2]|0;c[j>>2]=c[n>>2];c[j+4>>2]=o;g[p+96>>2]=+g[b+36>>2];g[p+68>>2]=+g[b+40>>2];g[p+72>>2]=+g[b+44>>2];g[p+104>>2]=0.0;g[p+108>>2]=0.0;g[p+112>>2]=0.0;q=p;break}}}while(0);m=q|0;return m|0}else if((f|0)==7){q=df(d,224)|0;if((q|0)==0){r=0}else{p=q;gn(p,b);r=p}m=r|0;return m|0}else if((f|0)==4){r=df(d,196)|0;if((r|0)==0){s=0}else{p=r;fJ(p,b);s=p}m=s|0;return m|0}else if((f|0)==9){s=df(d,180)|0;do{if((s|0)==0){t=0}else{p=s;c[p>>2]=19312;r=b+8|0;q=b+12|0;if((c[r>>2]|0)==(c[q>>2]|0)){ba(7272,173,15744,9072);return 0}else{c[s+4>>2]=c[e>>2];c[s+8>>2]=0;c[s+12>>2]=0;c[s+48>>2]=c[r>>2];c[s+52>>2]=c[q>>2];c[s+56>>2]=0;a[s+61|0]=a[b+16|0]&1;a[s+60|0]=0;c[s+64>>2]=c[b+4>>2];vq(s+16|0,0,32);c[p>>2]=19856;p=b+20|0;q=s+68|0;r=c[p+4>>2]|0;c[q>>2]=c[p>>2];c[q+4>>2]=r;r=b+28|0;q=s+76|0;p=c[r+4>>2]|0;c[q>>2]=c[r>>2];c[q+4>>2]=p;g[s+84>>2]=0.0;g[s+88>>2]=0.0;g[s+92>>2]=0.0;g[s+96>>2]=+g[b+36>>2];g[s+100>>2]=+g[b+40>>2];t=s;break}}}while(0);m=t|0;return m|0}else if((f|0)==5){t=df(d,168)|0;if((t|0)==0){u=0}else{s=t;fv(s,b);u=s}m=u|0;return m|0}else if((f|0)==6){f=df(d,276)|0;if((f|0)==0){v=0}else{d=f;e6(d,b);v=d}m=v|0;return m|0}else{ba(7272,113,15848,11592);return 0}return 0}function fl(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;bo[c[(c[b>>2]|0)+20>>2]&511](b);e=c[b+4>>2]|0;if((e|0)==7){f=a[22288]|0;if((f&255)>=14){ba(5352,173,17448,6544)}g=d+12+((f&255)<<2)|0;c[b>>2]=c[g>>2];c[g>>2]=b;return}else if((e|0)==6){g=a[22340]|0;if((g&255)>=14){ba(5352,173,17448,6544)}f=d+12+((g&255)<<2)|0;c[b>>2]=c[f>>2];c[f>>2]=b;return}else if((e|0)==2){f=a[22320]|0;if((f&255)>=14){ba(5352,173,17448,6544)}g=d+12+((f&255)<<2)|0;c[b>>2]=c[g>>2];c[g>>2]=b;return}else if((e|0)==3){g=a[22240]|0;if((g&255)>=14){ba(5352,173,17448,6544)}f=d+12+((g&255)<<2)|0;c[b>>2]=c[f>>2];c[f>>2]=b;return}else if((e|0)==9){f=a[22244]|0;if((f&255)>=14){ba(5352,173,17448,6544)}g=d+12+((f&255)<<2)|0;c[b>>2]=c[g>>2];c[g>>2]=b;return}else if((e|0)==8){g=a[22272]|0;if((g&255)>=14){ba(5352,173,17448,6544)}f=d+12+((g&255)<<2)|0;c[b>>2]=c[f>>2];c[f>>2]=b;return}else if((e|0)==1){f=a[22292]|0;if((f&255)>=14){ba(5352,173,17448,6544)}g=d+12+((f&255)<<2)|0;c[b>>2]=c[g>>2];c[g>>2]=b;return}else if((e|0)==4){g=a[22260]|0;if((g&255)>=14){ba(5352,173,17448,6544)}f=d+12+((g&255)<<2)|0;c[b>>2]=c[f>>2];c[f>>2]=b;return}else if((e|0)==5){f=a[22232]|0;if((f&255)>=14){ba(5352,173,17448,6544)}g=d+12+((f&255)<<2)|0;c[b>>2]=c[g>>2];c[g>>2]=b;return}else if((e|0)==10){e=a[22232]|0;if((e&255)>=14){ba(5352,173,17448,6544)}g=d+12+((e&255)<<2)|0;c[b>>2]=c[g>>2];c[g>>2]=b;return}else{ba(7272,166,15784,11592)}}function fm(a,b){a=a|0;b=b|0;return 1}function fn(a){a=a|0;return}function fo(a,b){a=a|0;b=+b;return+(b*0.0)}function fp(a,b){a=a|0;b=b|0;var d=0;d=b+76|0;b=a;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function fq(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+52>>2]|0;e=+g[d+24>>2];f=+g[b+68>>2];h=+g[d+20>>2];i=+g[b+72>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function fr(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0;d=+g[b+100>>2]*c;g[a>>2]=+g[b+96>>2]*c;g[a+4>>2]=d;return}function fs(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;d=a+116|0;e=c[d>>2]|0;f=b+28|0;h=c[f>>2]|0;i=h+(e*12&-1)|0;j=+g[i>>2];k=+g[i+4>>2];l=+g[h+(e*12&-1)+8>>2];m=+g[a+124>>2];n=+g[a+120>>2];o=+g[a+108>>2];h=a+96|0;i=h|0;p=+g[i>>2];q=a+100|0;r=+g[q>>2];s=-0.0-(j+m*(-0.0-l)+ +g[a+160>>2]+o*p);t=-0.0-(k+l*n+ +g[a+164>>2]+o*r);o=+g[a+148>>2]*s+ +g[a+156>>2]*t;u=h;v=+g[u>>2];w=+g[u+4>>2];x=p+(+g[a+144>>2]*s+ +g[a+152>>2]*t);g[i>>2]=x;t=o+r;g[q>>2]=t;r=+g[b>>2]*+g[a+104>>2];o=t*t+x*x;if(o>r*r){s=r/+P(+o);o=x*s;g[i>>2]=o;r=s*t;g[q>>2]=r;y=o;z=r}else{y=x;z=t}t=y-v;v=z-w;w=+g[a+136>>2];z=l+ +g[a+140>>2]*(v*n-t*m);a=(c[f>>2]|0)+(e*12&-1)|0;m=+(k+v*w);g[a>>2]=j+t*w;g[a+4>>2]=m;g[(c[f>>2]|0)+((c[d>>2]|0)*12&-1)+8>>2]=z;return}function ft(a){a=a|0;a=i;db(5136,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);i=a;return}function fu(a){a=a|0;vl(a);return}function fv(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0,j=0,l=0,m=0,n=0,o=0.0,q=0.0,r=0.0,s=0.0;e=b|0;c[e>>2]=19312;f=d+8|0;h=d+12|0;if((c[f>>2]|0)==(c[h>>2]|0)){ba(7272,173,15744,9072)}c[b+4>>2]=c[d>>2];c[b+8>>2]=0;c[b+12>>2]=0;c[b+48>>2]=c[f>>2];f=c[h>>2]|0;c[b+52>>2]=f;c[b+56>>2]=0;a[b+61|0]=a[d+16|0]&1;a[b+60|0]=0;c[b+64>>2]=c[d+4>>2];vq(b+16|0,0,32);c[e>>2]=20240;e=d+20|0;i=+g[e>>2];if(!(i==i&!(C=0.0,C!=C)&i>+-p&i<+p)){ba(7088,34,18312,11528)}i=+g[d+24>>2];if(!(i==i&!(C=0.0,C!=C)&i>+-p&i<+p)){ba(7088,34,18312,11528)}h=d+28|0;i=+g[h>>2];if(i<0.0|i==i&!(C=0.0,C!=C)&i>+-p&i<+p^1){ba(7088,35,18312,9016)}j=d+32|0;i=+g[j>>2];if(i<0.0|i==i&!(C=0.0,C!=C)&i>+-p&i<+p^1){ba(7088,36,18312,6888)}l=d+36|0;i=+g[l>>2];if(i<0.0|i==i&!(C=0.0,C!=C)&i>+-p&i<+p^1){ba(7088,37,18312,6040)}else{d=e;e=b+76|0;m=c[d>>2]|0;n=c[d+4>>2]|0;c[e>>2]=m;c[e+4>>2]=n;i=(c[k>>2]=m,+g[k>>2])- +g[f+12>>2];o=(c[k>>2]=n,+g[k>>2])- +g[f+16>>2];q=+g[f+24>>2];r=+g[f+20>>2];f=b+68|0;s=+(q*o+i*(-0.0-r));g[f>>2]=i*q+o*r;g[f+4>>2]=s;g[b+104>>2]=+g[h>>2];g[b+96>>2]=0.0;g[b+100>>2]=0.0;g[b+84>>2]=+g[j>>2];g[b+88>>2]=+g[l>>2];g[b+92>>2]=0.0;g[b+108>>2]=0.0;return}}function fw(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0;e=c[b+52>>2]|0;f=c[e+8>>2]|0;h=b+116|0;c[h>>2]=f;i=e+28|0;j=b+128|0;l=c[i>>2]|0;m=c[i+4>>2]|0;c[j>>2]=l;c[j+4>>2]=m;n=+g[e+120>>2];g[b+136>>2]=n;o=+g[e+128>>2];g[b+140>>2]=o;j=c[d+24>>2]|0;i=j+(f*12&-1)|0;p=+g[i>>2];q=+g[i+4>>2];r=+g[j+(f*12&-1)+8>>2];j=d+28|0;i=c[j>>2]|0;s=i+(f*12&-1)|0;t=+g[s>>2];u=+g[s+4>>2];v=+g[i+(f*12&-1)+8>>2];w=+S(+r);x=+R(+r);r=+g[e+116>>2];y=+g[b+84>>2]*6.2831854820251465;z=+g[d>>2];A=z*r*y*y;B=y*r*2.0*+g[b+88>>2]+A;r=(c[k>>2]=l,+g[k>>2]);y=(c[k>>2]=m,+g[k>>2]);if(B<=1.1920928955078125e-7){ba(7088,125,18368,5608)}C=z*B;if(C!=0.0){D=1.0/C}else{D=C}g[b+108>>2]=D;C=A*D;g[b+92>>2]=C;A=+g[b+68>>2]-r;r=+g[b+72>>2]-y;y=x*A-w*r;B=w*A+x*r;m=b+120|0;r=+B;g[m>>2]=y;g[m+4>>2]=r;r=D+(n+B*o*B);x=B*y*(-0.0-o);A=D+(n+y*o*y);D=r*A-x*x;if(D!=0.0){E=1.0/D}else{E=D}D=x*(-0.0-E);g[b+144>>2]=A*E;g[b+148>>2]=D;g[b+152>>2]=D;g[b+156>>2]=r*E;m=b+160|0;E=p+y- +g[b+76>>2];p=q+B- +g[b+80>>2];l=m;q=+p;g[l>>2]=E;g[l+4>>2]=q;g[m>>2]=C*E;g[b+164>>2]=C*p;p=v*.9800000190734863;m=b+96|0;if((a[d+20|0]&1)==0){g[m>>2]=0.0;g[b+100>>2]=0.0;F=p;G=t;H=u;I=c[j>>2]|0;J=I+(f*12&-1)|0;K=J;L=(g[k>>2]=G,c[k>>2]|0);M=(g[k>>2]=H,c[k>>2]|0);N=M;O=0;P=0;Q=N;T=L;U=0;V=P|T;W=Q|U;X=K|0;c[X>>2]=V;Y=K+4|0;c[Y>>2]=W;Z=c[h>>2]|0;_=c[j>>2]|0;$=_+(Z*12&-1)+8|0;g[$>>2]=F;return}else{v=+g[d+8>>2];d=m|0;C=v*+g[d>>2];g[d>>2]=C;d=b+100|0;E=v*+g[d>>2];g[d>>2]=E;F=p+o*(E*y-C*B);G=t+n*C;H=u+E*n;I=c[j>>2]|0;J=I+(f*12&-1)|0;K=J;L=(g[k>>2]=G,c[k>>2]|0);M=(g[k>>2]=H,c[k>>2]|0);N=M;O=0;P=0;Q=N;T=L;U=0;V=P|T;W=Q|U;X=K|0;c[X>>2]=V;Y=K+4|0;c[Y>>2]=W;Z=c[h>>2]|0;_=c[j>>2]|0;$=_+(Z*12&-1)+8|0;g[$>>2]=F;return}}function fx(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;e=b|0;c[e>>2]=19312;f=d+8|0;h=d+12|0;if((c[f>>2]|0)==(c[h>>2]|0)){ba(7272,173,15744,9072)}c[b+4>>2]=c[d>>2];c[b+8>>2]=0;c[b+12>>2]=0;c[b+48>>2]=c[f>>2];c[b+52>>2]=c[h>>2];c[b+56>>2]=0;a[b+61|0]=a[d+16|0]&1;a[b+60|0]=0;c[b+64>>2]=c[d+4>>2];vq(b+16|0,0,32);c[e>>2]=19680;e=b+84|0;h=d+20|0;f=b+68|0;i=c[h+4>>2]|0;c[f>>2]=c[h>>2];c[f+4>>2]=i;i=d+28|0;f=b+76|0;h=c[i+4>>2]|0;c[f>>2]=c[i>>2];c[f+4>>2]=h;h=d+36|0;f=e;i=c[h>>2]|0;j=c[h+4>>2]|0;c[f>>2]=i;c[f+4>>2]=j;l=(c[k>>2]=i,+g[k>>2]);m=(c[k>>2]=j,+g[k>>2]);n=+P(+(l*l+m*m));if(n<1.1920928955078125e-7){o=m;p=l}else{q=1.0/n;n=l*q;g[e>>2]=n;l=m*q;g[b+88>>2]=l;o=l;p=n}e=b+92|0;n=+p;g[e>>2]=o*-1.0;g[e+4>>2]=n;g[b+100>>2]=+g[d+44>>2];g[b+252>>2]=0.0;vq(b+104|0,0,16);g[b+120>>2]=+g[d+52>>2];g[b+124>>2]=+g[d+56>>2];g[b+128>>2]=+g[d+64>>2];g[b+132>>2]=+g[d+68>>2];a[b+136|0]=a[d+48|0]&1;a[b+137|0]=a[d+60|0]&1;c[b+140>>2]=0;vq(b+184|0,0,16);return}function fy(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0.0,ac=0.0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0,aH=0,aI=0,aJ=0,aK=0,aL=0,aM=0,aN=0;e=c[b+48>>2]|0;f=c[e+8>>2]|0;h=b+144|0;c[h>>2]=f;i=c[b+52>>2]|0;j=c[i+8>>2]|0;l=b+148|0;c[l>>2]=j;m=e+28|0;n=b+152|0;o=c[m>>2]|0;p=c[m+4>>2]|0;c[n>>2]=o;c[n+4>>2]=p;n=i+28|0;m=b+160|0;q=c[n>>2]|0;r=c[n+4>>2]|0;c[m>>2]=q;c[m+4>>2]=r;s=+g[e+120>>2];g[b+168>>2]=s;t=+g[i+120>>2];g[b+172>>2]=t;u=+g[e+128>>2];g[b+176>>2]=u;v=+g[i+128>>2];g[b+180>>2]=v;i=c[d+24>>2]|0;e=i+(f*12&-1)|0;w=+g[e>>2];x=+g[e+4>>2];y=+g[i+(f*12&-1)+8>>2];e=d+28|0;m=c[e>>2]|0;n=m+(f*12&-1)|0;z=+g[n>>2];A=+g[n+4>>2];B=+g[m+(f*12&-1)+8>>2];n=i+(j*12&-1)|0;C=+g[n>>2];D=+g[n+4>>2];E=+g[i+(j*12&-1)+8>>2];i=m+(j*12&-1)|0;F=+g[i>>2];G=+g[i+4>>2];H=+g[m+(j*12&-1)+8>>2];I=+S(+y);J=+R(+y);y=+S(+E);K=+R(+E);E=+g[b+68>>2]-(c[k>>2]=o,+g[k>>2]);L=+g[b+72>>2]-(c[k>>2]=p,+g[k>>2]);M=J*E-I*L;N=I*E+J*L;L=+g[b+76>>2]-(c[k>>2]=q,+g[k>>2]);E=+g[b+80>>2]-(c[k>>2]=r,+g[k>>2]);O=K*L-y*E;P=y*L+K*E;E=C-w+O-M;w=D-x+P-N;x=+g[b+84>>2];D=+g[b+88>>2];C=J*x-I*D;K=I*x+J*D;r=b+184|0;D=+K;g[r>>2]=C;g[r+4>>2]=D;D=M+E;M=N+w;N=D*K-M*C;g[b+208>>2]=N;x=O*K-P*C;g[b+212>>2]=x;L=s+t;y=u*N;Q=v*x;T=L+N*y+x*Q;if(T>0.0){U=1.0/T}else{U=T}g[b+252>>2]=U;U=+g[b+92>>2];V=+g[b+96>>2];W=J*U-I*V;X=I*U+J*V;r=b+192|0;V=+X;g[r>>2]=W;g[r+4>>2]=V;V=D*X-M*W;g[b+200>>2]=V;M=O*X-P*W;g[b+204>>2]=M;P=u*V;O=v*M;D=P+O;J=P*N+O*x;U=v+u;I=y+Q;g[b+216>>2]=L+V*P+M*O;g[b+220>>2]=D;g[b+224>>2]=J;g[b+228>>2]=D;g[b+232>>2]=U==0.0?1.0:U;g[b+236>>2]=I;g[b+240>>2]=J;g[b+244>>2]=I;g[b+248>>2]=T;do{if((a[b+136|0]&1)==0){c[b+140>>2]=0;g[b+112>>2]=0.0}else{T=E*C+w*K;I=+g[b+124>>2];J=+g[b+120>>2];U=I-J;if(U>0.0){Y=U}else{Y=-0.0-U}if(Y<.009999999776482582){c[b+140>>2]=3;break}if(T<=J){r=b+140|0;if((c[r>>2]|0)==1){break}c[r>>2]=1;g[b+112>>2]=0.0;break}r=b+140|0;if(T<I){c[r>>2]=0;g[b+112>>2]=0.0;break}if((c[r>>2]|0)==2){break}c[r>>2]=2;g[b+112>>2]=0.0}}while(0);if((a[b+137|0]&1)==0){g[b+116>>2]=0.0}r=b+104|0;if((a[d+20|0]&1)==0){vq(r|0,0,16);Z=B;_=H;$=F;aa=G;ab=z;ac=A;ad=c[e>>2]|0;ae=ad+(f*12&-1)|0;af=ae;ag=(g[k>>2]=ab,c[k>>2]|0);ah=(g[k>>2]=ac,c[k>>2]|0);ai=ah;aj=0;ak=0;al=ai;am=ag;an=0;ao=ak|am;ap=al|an;aq=af|0;c[aq>>2]=ao;ar=af+4|0;c[ar>>2]=ap;as=c[h>>2]|0;at=c[e>>2]|0;au=at+(as*12&-1)+8|0;g[au>>2]=Z;av=c[l>>2]|0;aw=c[e>>2]|0;ax=aw+(av*12&-1)|0;ay=ax;az=(g[k>>2]=$,c[k>>2]|0);aA=(g[k>>2]=aa,c[k>>2]|0);aB=aA;aC=0;aD=0;aE=aB;aF=az;aG=0;aH=aD|aF;aI=aE|aG;aJ=ay|0;c[aJ>>2]=aH;aK=ay+4|0;c[aK>>2]=aI;aL=c[l>>2]|0;aM=c[e>>2]|0;aN=aM+(aL*12&-1)+8|0;g[aN>>2]=_;return}else{q=d+8|0;Y=+g[q>>2];d=r|0;w=Y*+g[d>>2];g[d>>2]=w;d=b+108|0;E=Y*+g[d>>2];g[d>>2]=E;d=b+112|0;I=Y*+g[d>>2];g[d>>2]=I;d=b+116|0;Y=+g[q>>2]*+g[d>>2];g[d>>2]=Y;T=Y+I;I=w*W+C*T;C=w*X+T*K;Z=B-u*(w*V+E+T*N);_=H+v*(E+w*M+T*x);$=F+t*I;aa=G+t*C;ab=z-s*I;ac=A-s*C;ad=c[e>>2]|0;ae=ad+(f*12&-1)|0;af=ae;ag=(g[k>>2]=ab,c[k>>2]|0);ah=(g[k>>2]=ac,c[k>>2]|0);ai=ah;aj=0;ak=0;al=ai;am=ag;an=0;ao=ak|am;ap=al|an;aq=af|0;c[aq>>2]=ao;ar=af+4|0;c[ar>>2]=ap;as=c[h>>2]|0;at=c[e>>2]|0;au=at+(as*12&-1)+8|0;g[au>>2]=Z;av=c[l>>2]|0;aw=c[e>>2]|0;ax=aw+(av*12&-1)|0;ay=ax;az=(g[k>>2]=$,c[k>>2]|0);aA=(g[k>>2]=aa,c[k>>2]|0);aB=aA;aC=0;aD=0;aE=aB;aF=az;aG=0;aH=aD|aF;aI=aE|aG;aJ=ay|0;c[aJ>>2]=aH;aK=ay+4|0;c[aK>>2]=aI;aL=c[l>>2]|0;aM=c[e>>2]|0;aN=aM+(aL*12&-1)+8|0;g[aN>>2]=_;return}}function fz(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0.0,ac=0.0,ad=0.0,ae=0.0,af=0.0,ag=0.0,ah=0.0,ai=0.0,aj=0.0,ak=0,al=0.0;e=i;i=i+32|0;f=e|0;h=e+16|0;j=b+144|0;k=c[j>>2]|0;l=d+28|0;m=c[l>>2]|0;n=m+(k*12&-1)|0;o=+g[n>>2];p=+g[n+4>>2];q=+g[m+(k*12&-1)+8>>2];n=b+148|0;r=c[n>>2]|0;s=m+(r*12&-1)|0;t=+g[s>>2];u=+g[s+4>>2];v=+g[m+(r*12&-1)+8>>2];w=+g[b+168>>2];x=+g[b+172>>2];y=+g[b+176>>2];z=+g[b+180>>2];do{if((a[b+137|0]&1)==0){A=q;B=v;C=t;D=u;E=o;F=p}else{if((c[b+140>>2]|0)==3){A=q;B=v;C=t;D=u;E=o;F=p;break}G=+g[b+184>>2];H=+g[b+188>>2];I=+g[b+212>>2];J=+g[b+208>>2];r=b+116|0;K=+g[r>>2];L=+g[d>>2]*+g[b+128>>2];M=K+ +g[b+252>>2]*(+g[b+132>>2]-((t-o)*G+(u-p)*H+v*I-q*J));N=-0.0-L;O=M<L?M:L;L=O<N?N:O;g[r>>2]=L;O=L-K;K=G*O;G=H*O;A=q-y*J*O;B=v+z*I*O;C=t+x*K;D=u+x*G;E=o-w*K;F=p-w*G}}while(0);p=C-E;o=D-F;d=b+192|0;u=+g[d>>2];r=b+196|0;t=+g[r>>2];m=b+204|0;v=+g[m>>2];s=b+200|0;q=+g[s>>2];G=p*u+o*t+B*v-A*q;K=B-A;do{if((a[b+136|0]&1)==0){P=2813}else{Q=b+140|0;if((c[Q>>2]|0)==0){P=2813;break}R=b+184|0;S=b+188|0;T=b+212|0;U=b+208|0;V=b+104|0;O=+g[V>>2];W=b+108|0;I=+g[W>>2];X=b+112|0;J=+g[X>>2];Y=b+216|0;H=-0.0-G;L=-0.0-K;N=-0.0-(p*+g[R>>2]+o*+g[S>>2]+B*+g[T>>2]-A*+g[U>>2]);g[h>>2]=H;g[h+4>>2]=L;g[h+8>>2]=N;c8(f,Y,h);Z=f|0;g[V>>2]=+g[Z>>2]+ +g[V>>2];_=f+4|0;g[W>>2]=+g[_>>2]+ +g[W>>2];$=f+8|0;N=+g[$>>2]+ +g[X>>2];g[X>>2]=N;aa=c[Q>>2]|0;if((aa|0)==2){M=N<0.0?N:0.0;g[X>>2]=M;ab=M}else if((aa|0)==1){M=N>0.0?N:0.0;g[X>>2]=M;ab=M}else{ab=N}N=ab-J;J=H- +g[b+240>>2]*N;H=L-N*+g[b+244>>2];L=+g[Y>>2];M=+g[b+228>>2];ac=+g[b+220>>2];ad=+g[b+232>>2];ae=L*ad-M*ac;if(ae!=0.0){af=1.0/ae}else{af=ae}ae=O+(J*ad-M*H)*af;M=I+(L*H-J*ac)*af;g[V>>2]=ae;g[W>>2]=M;ac=ae-O;O=M-I;g[Z>>2]=ac;g[_>>2]=O;g[$>>2]=N;ag=O+ac*+g[m>>2]+N*+g[T>>2];ah=ac*+g[s>>2]+O+N*+g[U>>2];ai=ac*+g[r>>2]+N*+g[S>>2];aj=ac*+g[d>>2]+N*+g[R>>2];ak=c[j>>2]|0}}while(0);if((P|0)==2813){af=-0.0-G;G=-0.0-K;K=+g[b+216>>2];ab=+g[b+228>>2];o=+g[b+220>>2];p=+g[b+232>>2];N=K*p-ab*o;if(N!=0.0){al=1.0/N}else{al=N}N=(p*af-ab*G)*al;ab=(K*G-o*af)*al;P=b+104|0;g[P>>2]=+g[P>>2]+N;P=b+108|0;g[P>>2]=ab+ +g[P>>2];ag=ab+N*v;ah=ab+N*q;ai=N*t;aj=N*u;ak=k}k=(c[l>>2]|0)+(ak*12&-1)|0;u=+(F-w*ai);g[k>>2]=E-w*aj;g[k+4>>2]=u;g[(c[l>>2]|0)+((c[j>>2]|0)*12&-1)+8>>2]=A-y*ah;j=(c[l>>2]|0)+((c[n>>2]|0)*12&-1)|0;ah=+(D+x*ai);g[j>>2]=C+x*aj;g[j+4>>2]=ah;g[(c[l>>2]|0)+((c[n>>2]|0)*12&-1)+8>>2]=B+z*ag;i=e;return}function fA(a){a=a|0;return}function fB(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+48>>2]|0;e=+g[d+24>>2];f=+g[b+68>>2];h=+g[d+20>>2];i=+g[b+72>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function fC(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+52>>2]|0;e=+g[d+24>>2];f=+g[b+76>>2];h=+g[d+20>>2];i=+g[b+80>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function fD(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0,e=0.0,f=0.0;d=+g[b+104>>2];e=+g[b+116>>2]+ +g[b+112>>2];f=(d*+g[b+196>>2]+e*+g[b+188>>2])*c;g[a>>2]=(d*+g[b+192>>2]+ +g[b+184>>2]*e)*c;g[a+4>>2]=f;return}function fE(a,b){a=a|0;b=+b;return+(+g[a+108>>2]*b)}function fF(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0,P=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0;e=b+144|0;f=c[e>>2]|0;h=d+24|0;d=c[h>>2]|0;i=d+(f*12&-1)|0;j=+g[i>>2];k=+g[i+4>>2];l=+g[d+(f*12&-1)+8>>2];f=b+148|0;m=c[f>>2]|0;n=d+(m*12&-1)|0;o=+g[n>>2];p=+g[n+4>>2];q=+g[d+(m*12&-1)+8>>2];r=+S(+l);s=+R(+l);t=+S(+q);u=+R(+q);v=+g[b+168>>2];w=+g[b+172>>2];x=+g[b+176>>2];y=+g[b+180>>2];z=+g[b+68>>2]- +g[b+152>>2];A=+g[b+72>>2]- +g[b+156>>2];B=s*z-r*A;C=r*z+s*A;A=+g[b+76>>2]- +g[b+160>>2];z=+g[b+80>>2]- +g[b+164>>2];D=u*A-t*z;E=t*A+u*z;z=o+D-j-B;u=p+E-k-C;A=+g[b+84>>2];t=+g[b+88>>2];F=s*A-r*t;G=r*A+s*t;t=B+z;B=C+u;C=G*t-F*B;A=D*G-E*F;H=+g[b+92>>2];I=+g[b+96>>2];J=s*H-r*I;K=r*H+s*I;I=K*t-J*B;B=D*K-E*J;E=J*z+K*u;D=q-l- +g[b+100>>2];if(E>0.0){L=E}else{L=-0.0-E}if(D>0.0){M=D}else{M=-0.0-D}do{if((a[b+136|0]&1)==0){N=L;O=0;P=0.0}else{t=F*z+G*u;s=+g[b+124>>2];H=+g[b+120>>2];r=s-H;if(r>0.0){Q=r}else{Q=-0.0-r}if(Q<.009999999776482582){r=t<.20000000298023224?t:.20000000298023224;if(t>0.0){T=t}else{T=-0.0-t}N=L>T?L:T;O=1;P=r<-.20000000298023224?-.20000000298023224:r;break}if(t<=H){r=t-H+.004999999888241291;U=r<0.0?r:0.0;r=H-t;N=L>r?L:r;O=1;P=U<-.20000000298023224?-.20000000298023224:U;break}if(t<s){N=L;O=0;P=0.0;break}U=t-s;s=U+-.004999999888241291;t=s<.20000000298023224?s:.20000000298023224;N=L>U?L:U;O=1;P=t<0.0?0.0:t}}while(0);L=v+w;T=x*I;Q=y*B;u=B*Q+(L+I*T);z=Q+T;if(O){t=A*Q+C*T;T=x+y;Q=T==0.0?1.0:T;T=x*C;U=y*A;s=U+T;r=A*U+(L+C*T);T=-0.0-E;L=-0.0-D;U=-0.0-P;P=Q*r-s*s;H=s*t-z*r;V=s*z-Q*t;W=t*V+(u*P+z*H);if(W!=0.0){X=1.0/W}else{X=W}W=s*T;Y=(P*T+H*L+V*U)*X;Z=(t*(W-t*L)+(u*(r*L-s*U)+z*(t*U-r*T)))*X;_=(t*(z*L-Q*T)+(u*(Q*U-s*L)+z*(W-z*U)))*X}else{X=x+y;U=X==0.0?1.0:X;X=-0.0-E;E=-0.0-D;D=U*u-z*z;if(D!=0.0){$=1.0/D}else{$=D}Y=(U*X-z*E)*$;Z=(u*E-z*X)*$;_=0.0}$=F*_+J*Y;J=G*_+K*Y;K=+(k-v*J);g[i>>2]=j-v*$;g[i+4>>2]=K;g[(c[h>>2]|0)+((c[e>>2]|0)*12&-1)+8>>2]=l-x*(C*_+(Z+I*Y));e=(c[h>>2]|0)+((c[f>>2]|0)*12&-1)|0;I=+(p+w*J);g[e>>2]=o+w*$;g[e+4>>2]=I;g[(c[h>>2]|0)+((c[f>>2]|0)*12&-1)+8>>2]=q+y*(A*_+(Z+B*Y));if(N>.004999999888241291){aa=0;return aa|0}aa=M<=.03490658849477768;return aa|0}function fG(b){b=b|0;var d=0,e=0,f=0,j=0.0;d=i;e=c[(c[b+48>>2]|0)+8>>2]|0;f=c[(c[b+52>>2]|0)+8>>2]|0;db(8984,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(11336,(u=i,i=i+8|0,c[u>>2]=e,u)|0);db(8808,(u=i,i=i+8|0,c[u>>2]=f,u)|0);db(6768,(u=i,i=i+8|0,c[u>>2]=a[b+61|0]&1,u)|0);j=+g[b+72>>2];db(5992,(u=i,i=i+16|0,h[u>>3]=+g[b+68>>2],h[u+8>>3]=j,u)|0);j=+g[b+80>>2];db(5536,(u=i,i=i+16|0,h[u>>3]=+g[b+76>>2],h[u+8>>3]=j,u)|0);j=+g[b+88>>2];db(5032,(u=i,i=i+16|0,h[u>>3]=+g[b+84>>2],h[u+8>>3]=j,u)|0);db(5072,(u=i,i=i+8|0,h[u>>3]=+g[b+100>>2],u)|0);db(4264,(u=i,i=i+8|0,c[u>>2]=a[b+136|0]&1,u)|0);db(12568,(u=i,i=i+8|0,h[u>>3]=+g[b+120>>2],u)|0);db(11984,(u=i,i=i+8|0,h[u>>3]=+g[b+124>>2],u)|0);db(4760,(u=i,i=i+8|0,c[u>>2]=a[b+137|0]&1,u)|0);db(4488,(u=i,i=i+8|0,h[u>>3]=+g[b+132>>2],u)|0);db(11064,(u=i,i=i+8|0,h[u>>3]=+g[b+128>>2],u)|0);db(11904,(u=i,i=i+8|0,c[u>>2]=c[b+56>>2],u)|0);i=d;return}function fH(a){a=a|0;vl(a);return}function fI(a,b,d,e,f,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=+j;var k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;c[a+8>>2]=b;c[a+12>>2]=d;k=e;l=a+20|0;m=c[k+4>>2]|0;c[l>>2]=c[k>>2];c[l+4>>2]=m;m=f;l=a+28|0;k=c[m+4>>2]|0;c[l>>2]=c[m>>2];c[l+4>>2]=k;k=h|0;n=+g[k>>2]- +g[b+12>>2];l=h+4|0;o=+g[l>>2]- +g[b+16>>2];p=+g[b+24>>2];q=+g[b+20>>2];b=a+36|0;r=+(p*o+n*(-0.0-q));g[b>>2]=n*p+o*q;g[b+4>>2]=r;b=i|0;r=+g[b>>2]- +g[d+12>>2];h=i+4|0;q=+g[h>>2]- +g[d+16>>2];o=+g[d+24>>2];p=+g[d+20>>2];d=a+44|0;n=+(o*q+r*(-0.0-p));g[d>>2]=r*o+q*p;g[d+4>>2]=n;n=+g[k>>2]- +g[e>>2];p=+g[l>>2]- +g[e+4>>2];g[a+52>>2]=+P(+(n*n+p*p));p=+g[b>>2]- +g[f>>2];n=+g[h>>2]- +g[f+4>>2];g[a+56>>2]=+P(+(p*p+n*n));g[a+60>>2]=j;if(j>1.1920928955078125e-7){return}else{ba(6632,51,17120,11480)}}function fJ(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0;e=b|0;c[e>>2]=19312;f=d+8|0;h=d+12|0;if((c[f>>2]|0)==(c[h>>2]|0)){ba(7272,173,15744,9072)}c[b+4>>2]=c[d>>2];c[b+8>>2]=0;c[b+12>>2]=0;c[b+48>>2]=c[f>>2];c[b+52>>2]=c[h>>2];c[b+56>>2]=0;a[b+61|0]=a[d+16|0]&1;a[b+60|0]=0;c[b+64>>2]=c[d+4>>2];vq(b+16|0,0,32);c[e>>2]=20080;e=d+20|0;h=b+68|0;f=c[e+4>>2]|0;c[h>>2]=c[e>>2];c[h+4>>2]=f;f=d+28|0;h=b+76|0;e=c[f+4>>2]|0;c[h>>2]=c[f>>2];c[h+4>>2]=e;e=d+36|0;h=b+92|0;f=c[e+4>>2]|0;c[h>>2]=c[e>>2];c[h+4>>2]=f;f=d+44|0;h=b+100|0;e=c[f+4>>2]|0;c[h>>2]=c[f>>2];c[h+4>>2]=e;e=d+52|0;g[b+84>>2]=+g[e>>2];h=d+56|0;g[b+88>>2]=+g[h>>2];i=+g[d+60>>2];if(i!=0.0){g[b+112>>2]=i;g[b+108>>2]=+g[e>>2]+i*+g[h>>2];g[b+116>>2]=0.0;return}else{ba(6632,65,17984,8960)}}function fK(a,b){a=a|0;b=+b;return+0.0}function fL(a){a=a|0;return}function fM(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;d=a+120|0;e=c[d>>2]|0;f=b+28|0;b=c[f>>2]|0;h=b+(e*12&-1)|0;i=+g[h>>2];j=+g[h+4>>2];k=+g[b+(e*12&-1)+8>>2];h=a+124|0;l=c[h>>2]|0;m=b+(l*12&-1)|0;n=+g[m>>2];o=+g[m+4>>2];p=+g[b+(l*12&-1)+8>>2];q=+g[a+148>>2];r=+g[a+144>>2];s=+g[a+156>>2];t=+g[a+152>>2];u=+g[a+128>>2];v=+g[a+132>>2];w=+g[a+112>>2];x=+g[a+136>>2];y=+g[a+140>>2];z=(-0.0-((i+q*(-0.0-k))*u+(j+k*r)*v)-w*((n+s*(-0.0-p))*x+(o+p*t)*y))*(-0.0- +g[a+192>>2]);l=a+116|0;g[l>>2]=+g[l>>2]+z;A=-0.0-z;B=u*A;u=v*A;A=z*(-0.0-w);w=x*A;x=y*A;A=+g[a+176>>2];y=k+ +g[a+184>>2]*(u*r-B*q);q=+g[a+180>>2];r=p+ +g[a+188>>2]*(x*t-w*s);a=(c[f>>2]|0)+(e*12&-1)|0;s=+(j+u*A);g[a>>2]=i+B*A;g[a+4>>2]=s;g[(c[f>>2]|0)+((c[d>>2]|0)*12&-1)+8>>2]=y;d=(c[f>>2]|0)+((c[h>>2]|0)*12&-1)|0;y=+(o+x*q);g[d>>2]=n+w*q;g[d+4>>2]=y;g[(c[f>>2]|0)+((c[h>>2]|0)*12&-1)+8>>2]=r;return}function fN(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+48>>2]|0;e=+g[d+24>>2];f=+g[b+92>>2];h=+g[d+20>>2];i=+g[b+96>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function fO(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+52>>2]|0;e=+g[d+24>>2];f=+g[b+100>>2];h=+g[d+20>>2];i=+g[b+104>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function fP(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0,e=0.0;d=+g[b+116>>2];e=d*+g[b+140>>2]*c;g[a>>2]=d*+g[b+136>>2]*c;g[a+4>>2]=e;return}function fQ(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0,aH=0,aI=0,aJ=0,aK=0;e=c[b+48>>2]|0;f=c[e+8>>2]|0;h=b+120|0;c[h>>2]=f;i=c[b+52>>2]|0;j=c[i+8>>2]|0;l=b+124|0;c[l>>2]=j;m=e+28|0;n=b+160|0;o=c[m>>2]|0;p=c[m+4>>2]|0;c[n>>2]=o;c[n+4>>2]=p;n=i+28|0;m=b+168|0;q=c[n>>2]|0;r=c[n+4>>2]|0;c[m>>2]=q;c[m+4>>2]=r;s=+g[e+120>>2];g[b+176>>2]=s;t=+g[i+120>>2];g[b+180>>2]=t;u=+g[e+128>>2];g[b+184>>2]=u;v=+g[i+128>>2];g[b+188>>2]=v;i=c[d+24>>2]|0;e=i+(f*12&-1)|0;w=+g[e>>2];x=+g[e+4>>2];y=+g[i+(f*12&-1)+8>>2];e=d+28|0;m=c[e>>2]|0;n=m+(f*12&-1)|0;z=+g[n>>2];A=+g[n+4>>2];B=+g[m+(f*12&-1)+8>>2];n=i+(j*12&-1)|0;C=+g[n>>2];D=+g[n+4>>2];E=+g[i+(j*12&-1)+8>>2];i=m+(j*12&-1)|0;F=+g[i>>2];G=+g[i+4>>2];H=+g[m+(j*12&-1)+8>>2];I=+S(+y);J=+R(+y);y=+S(+E);K=+R(+E);E=+g[b+92>>2]-(c[k>>2]=o,+g[k>>2]);L=+g[b+96>>2]-(c[k>>2]=p,+g[k>>2]);M=J*E-I*L;N=I*E+J*L;p=b+144|0;L=+N;g[p>>2]=M;g[p+4>>2]=L;L=+g[b+100>>2]-(c[k>>2]=q,+g[k>>2]);J=+g[b+104>>2]-(c[k>>2]=r,+g[k>>2]);E=K*L-y*J;I=y*L+K*J;r=b+152|0;J=+I;g[r>>2]=E;g[r+4>>2]=J;r=b+128|0;J=w+M- +g[b+68>>2];w=x+N- +g[b+72>>2];q=r;x=+w;g[q>>2]=J;g[q+4>>2]=x;q=b+136|0;x=C+E- +g[b+76>>2];C=D+I- +g[b+80>>2];p=q;D=+C;g[p>>2]=x;g[p+4>>2]=D;p=r|0;D=+P(+(J*J+w*w));r=q|0;K=+P(+(x*x+C*C));if(D>.04999999701976776){L=1.0/D;D=J*L;g[p>>2]=D;O=L*w;Q=D}else{g[p>>2]=0.0;O=0.0;Q=0.0}g[b+132>>2]=O;if(K>.04999999701976776){D=1.0/K;K=D*x;g[r>>2]=K;T=D*C;U=K}else{g[r>>2]=0.0;T=0.0;U=0.0}g[b+140>>2]=T;K=M*O-N*Q;C=E*T-I*U;D=+g[b+112>>2];x=s+K*K*u+D*D*(t+C*C*v);if(x>0.0){V=1.0/x}else{V=x}g[b+192>>2]=V;if((a[d+20|0]&1)==0){g[b+116>>2]=0.0;W=B;X=H;Y=F;Z=G;_=z;$=A;aa=c[e>>2]|0;ab=aa+(f*12&-1)|0;ac=ab;ad=(g[k>>2]=_,c[k>>2]|0);ae=(g[k>>2]=$,c[k>>2]|0);af=ae;ag=0;ah=0;ai=af;aj=ad;ak=0;al=ah|aj;am=ai|ak;an=ac|0;c[an>>2]=al;ao=ac+4|0;c[ao>>2]=am;ap=c[h>>2]|0;aq=c[e>>2]|0;ar=aq+(ap*12&-1)+8|0;g[ar>>2]=W;as=c[l>>2]|0;at=c[e>>2]|0;au=at+(as*12&-1)|0;av=au;aw=(g[k>>2]=Y,c[k>>2]|0);ax=(g[k>>2]=Z,c[k>>2]|0);ay=ax;az=0;aA=0;aB=ay;aC=aw;aD=0;aE=aA|aC;aF=aB|aD;aG=av|0;c[aG>>2]=aE;aH=av+4|0;c[aH>>2]=aF;aI=c[l>>2]|0;aJ=c[e>>2]|0;aK=aJ+(aI*12&-1)+8|0;g[aK>>2]=X;return}else{r=b+116|0;V=+g[d+8>>2]*+g[r>>2];g[r>>2]=V;x=-0.0-V;C=Q*x;Q=O*x;x=V*(-0.0-D);D=U*x;U=T*x;W=B+u*(Q*M-C*N);X=H+v*(U*E-D*I);Y=F+D*t;Z=G+U*t;_=z+C*s;$=A+Q*s;aa=c[e>>2]|0;ab=aa+(f*12&-1)|0;ac=ab;ad=(g[k>>2]=_,c[k>>2]|0);ae=(g[k>>2]=$,c[k>>2]|0);af=ae;ag=0;ah=0;ai=af;aj=ad;ak=0;al=ah|aj;am=ai|ak;an=ac|0;c[an>>2]=al;ao=ac+4|0;c[ao>>2]=am;ap=c[h>>2]|0;aq=c[e>>2]|0;ar=aq+(ap*12&-1)+8|0;g[ar>>2]=W;as=c[l>>2]|0;at=c[e>>2]|0;au=at+(as*12&-1)|0;av=au;aw=(g[k>>2]=Y,c[k>>2]|0);ax=(g[k>>2]=Z,c[k>>2]|0);ay=ax;az=0;aA=0;aB=ay;aC=aw;aD=0;aE=aA|aC;aF=aB|aD;aG=av|0;c[aG>>2]=aE;aH=av+4|0;c[aH>>2]=aF;aI=c[l>>2]|0;aJ=c[e>>2]|0;aK=aJ+(aI*12&-1)+8|0;g[aK>>2]=X;return}}function fR(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0;d=a+120|0;e=c[d>>2]|0;f=b+24|0;b=c[f>>2]|0;h=b+(e*12&-1)|0;i=+g[h>>2];j=+g[h+4>>2];k=+g[b+(e*12&-1)+8>>2];e=a+124|0;l=c[e>>2]|0;m=b+(l*12&-1)|0;n=+g[m>>2];o=+g[m+4>>2];p=+g[b+(l*12&-1)+8>>2];q=+S(+k);r=+R(+k);s=+S(+p);t=+R(+p);u=+g[a+92>>2]- +g[a+160>>2];v=+g[a+96>>2]- +g[a+164>>2];w=r*u-q*v;x=q*u+r*v;v=+g[a+100>>2]- +g[a+168>>2];r=+g[a+104>>2]- +g[a+172>>2];u=t*v-s*r;q=s*v+t*r;r=i+w- +g[a+68>>2];t=j+x- +g[a+72>>2];v=n+u- +g[a+76>>2];s=o+q- +g[a+80>>2];y=+P(+(r*r+t*t));z=+P(+(v*v+s*s));if(y>.04999999701976776){A=1.0/y;B=r*A;C=t*A}else{B=0.0;C=0.0}if(z>.04999999701976776){A=1.0/z;D=v*A;E=s*A}else{D=0.0;E=0.0}A=w*C-x*B;s=u*E-q*D;v=+g[a+176>>2];t=+g[a+184>>2];r=+g[a+180>>2];F=+g[a+188>>2];G=+g[a+112>>2];H=v+A*A*t+G*G*(r+s*s*F);if(H>0.0){I=1.0/H}else{I=H}H=+g[a+108>>2]-y-z*G;if(H>0.0){J=H}else{J=-0.0-H}z=H*(-0.0-I);I=-0.0-z;H=B*I;B=C*I;I=z*(-0.0-G);G=D*I;D=E*I;I=+(j+B*v);g[h>>2]=i+H*v;g[h+4>>2]=I;g[(c[f>>2]|0)+((c[d>>2]|0)*12&-1)+8>>2]=k+(w*B-x*H)*t;d=(c[f>>2]|0)+((c[e>>2]|0)*12&-1)|0;t=+(o+D*r);g[d>>2]=n+G*r;g[d+4>>2]=t;g[(c[f>>2]|0)+((c[e>>2]|0)*12&-1)+8>>2]=p+F*(u*D-q*G);return J<.004999999888241291|0}function fS(b){b=b|0;var d=0,e=0,f=0,j=0.0;d=i;e=c[(c[b+48>>2]|0)+8>>2]|0;f=c[(c[b+52>>2]|0)+8>>2]|0;db(6808,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(11336,(u=i,i=i+8|0,c[u>>2]=e,u)|0);db(8808,(u=i,i=i+8|0,c[u>>2]=f,u)|0);db(6768,(u=i,i=i+8|0,c[u>>2]=a[b+61|0]&1,u)|0);j=+g[b+72>>2];db(4792,(u=i,i=i+16|0,h[u>>3]=+g[b+68>>2],h[u+8>>3]=j,u)|0);j=+g[b+80>>2];db(4520,(u=i,i=i+16|0,h[u>>3]=+g[b+76>>2],h[u+8>>3]=j,u)|0);j=+g[b+96>>2];db(5992,(u=i,i=i+16|0,h[u>>3]=+g[b+92>>2],h[u+8>>3]=j,u)|0);j=+g[b+104>>2];db(5536,(u=i,i=i+16|0,h[u>>3]=+g[b+100>>2],h[u+8>>3]=j,u)|0);db(12536,(u=i,i=i+8|0,h[u>>3]=+g[b+84>>2],u)|0);db(11952,(u=i,i=i+8|0,h[u>>3]=+g[b+88>>2],u)|0);db(11504,(u=i,i=i+8|0,h[u>>3]=+g[b+112>>2],u)|0);db(11904,(u=i,i=i+8|0,c[u>>2]=c[b+56>>2],u)|0);i=d;return}function fT(a){a=a|0;vl(a);return}function fU(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0;e=c[b+48>>2]|0;f=c[e+8>>2]|0;h=b+128|0;c[h>>2]=f;i=c[b+52>>2]|0;j=c[i+8>>2]|0;l=b+132|0;c[l>>2]=j;m=e+28|0;n=b+152|0;o=c[m>>2]|0;p=c[m+4>>2]|0;c[n>>2]=o;c[n+4>>2]=p;n=i+28|0;m=b+160|0;q=c[n>>2]|0;r=c[n+4>>2]|0;c[m>>2]=q;c[m+4>>2]=r;s=+g[e+120>>2];g[b+168>>2]=s;t=+g[i+120>>2];g[b+172>>2]=t;u=+g[e+128>>2];g[b+176>>2]=u;v=+g[i+128>>2];g[b+180>>2]=v;i=c[d+24>>2]|0;w=+g[i+(f*12&-1)+8>>2];e=d+28|0;m=c[e>>2]|0;n=m+(f*12&-1)|0;x=+g[n>>2];y=+g[n+4>>2];z=+g[m+(f*12&-1)+8>>2];A=+g[i+(j*12&-1)+8>>2];i=m+(j*12&-1)|0;B=+g[i>>2];C=+g[i+4>>2];D=+g[m+(j*12&-1)+8>>2];E=+S(+w);F=+R(+w);G=+S(+A);H=+R(+A);I=+g[b+68>>2]-(c[k>>2]=o,+g[k>>2]);J=+g[b+72>>2]-(c[k>>2]=p,+g[k>>2]);K=F*I-E*J;L=E*I+F*J;p=b+136|0;J=+L;g[p>>2]=K;g[p+4>>2]=J;J=+g[b+76>>2]-(c[k>>2]=q,+g[k>>2]);F=+g[b+80>>2]-(c[k>>2]=r,+g[k>>2]);I=H*J-G*F;E=G*J+H*F;r=b+144|0;F=+E;g[r>>2]=I;g[r+4>>2]=F;F=u+v;r=F==0.0;H=s+t;g[b+184>>2]=H+u*L*L+v*E*E;J=-0.0-L;G=u*K*J-v*E*I;g[b+196>>2]=G;M=u*J-v*E;g[b+208>>2]=M;g[b+188>>2]=G;g[b+200>>2]=H+u*K*K+v*I*I;H=u*K+v*I;g[b+212>>2]=H;g[b+192>>2]=M;g[b+204>>2]=H;g[b+216>>2]=F;if(F>0.0){N=1.0/F}else{N=F}g[b+220>>2]=N;if((a[b+100|0]&1)==0|r){g[b+96>>2]=0.0}do{if((a[b+112|0]&1)==0|r){c[b+224>>2]=0}else{N=A-w- +g[b+116>>2];F=+g[b+124>>2];H=+g[b+120>>2];M=F-H;if(M>0.0){O=M}else{O=-0.0-M}if(O<.06981317698955536){c[b+224>>2]=3;break}if(N<=H){q=b+224|0;if((c[q>>2]|0)!=1){g[b+92>>2]=0.0}c[q>>2]=1;break}q=b+224|0;if(N<F){c[q>>2]=0;g[b+92>>2]=0.0;break}if((c[q>>2]|0)!=2){g[b+92>>2]=0.0}c[q>>2]=2}}while(0);r=b+84|0;if((a[d+20|0]&1)==0){vq(r|0,0,16);P=z;Q=D;T=B;U=C;V=x;W=y;X=c[e>>2]|0;Y=X+(f*12&-1)|0;Z=Y;_=(g[k>>2]=V,c[k>>2]|0);$=(g[k>>2]=W,c[k>>2]|0);aa=$;ab=0;ac=0;ad=aa;ae=_;af=0;ag=ac|ae;ah=ad|af;ai=Z|0;c[ai>>2]=ag;aj=Z+4|0;c[aj>>2]=ah;ak=c[h>>2]|0;al=c[e>>2]|0;am=al+(ak*12&-1)+8|0;g[am>>2]=P;an=c[l>>2]|0;ao=c[e>>2]|0;ap=ao+(an*12&-1)|0;aq=ap;ar=(g[k>>2]=T,c[k>>2]|0);as=(g[k>>2]=U,c[k>>2]|0);at=as;au=0;av=0;aw=at;ax=ar;ay=0;az=av|ax;aA=aw|ay;aB=aq|0;c[aB>>2]=az;aC=aq+4|0;c[aC>>2]=aA;aD=c[l>>2]|0;aE=c[e>>2]|0;aF=aE+(aD*12&-1)+8|0;g[aF>>2]=Q;return}else{q=d+8|0;O=+g[q>>2];d=r|0;w=O*+g[d>>2];g[d>>2]=w;d=b+88|0;A=O*+g[d>>2];g[d>>2]=A;d=b+92|0;F=O*+g[d>>2];g[d>>2]=F;d=b+96|0;O=+g[q>>2]*+g[d>>2];g[d>>2]=O;P=z-u*(F+(O+(A*K-w*L)));Q=D+v*(F+(O+(A*I-w*E)));T=B+t*w;U=C+t*A;V=x-s*w;W=y-s*A;X=c[e>>2]|0;Y=X+(f*12&-1)|0;Z=Y;_=(g[k>>2]=V,c[k>>2]|0);$=(g[k>>2]=W,c[k>>2]|0);aa=$;ab=0;ac=0;ad=aa;ae=_;af=0;ag=ac|ae;ah=ad|af;ai=Z|0;c[ai>>2]=ag;aj=Z+4|0;c[aj>>2]=ah;ak=c[h>>2]|0;al=c[e>>2]|0;am=al+(ak*12&-1)+8|0;g[am>>2]=P;an=c[l>>2]|0;ao=c[e>>2]|0;ap=ao+(an*12&-1)|0;aq=ap;ar=(g[k>>2]=T,c[k>>2]|0);as=(g[k>>2]=U,c[k>>2]|0);at=as;au=0;av=0;aw=at;ax=ar;ay=0;az=av|ax;aA=aw|ay;aB=aq|0;c[aB>>2]=az;aC=aq+4|0;c[aC>>2]=aA;aD=c[l>>2]|0;aE=c[e>>2]|0;aF=aE+(aD*12&-1)+8|0;g[aF>>2]=Q;return}}function fV(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0,I=0,J=0,K=0,L=0.0,M=0,N=0.0,O=0.0,P=0.0,Q=0,R=0.0,S=0.0,T=0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0.0,ac=0.0,ad=0.0,ae=0,af=0.0;e=i;i=i+32|0;f=e|0;h=e+16|0;j=b+128|0;k=c[j>>2]|0;l=d+28|0;m=c[l>>2]|0;n=m+(k*12&-1)|0;o=+g[n>>2];p=+g[n+4>>2];q=+g[m+(k*12&-1)+8>>2];n=b+132|0;r=c[n>>2]|0;s=m+(r*12&-1)|0;t=+g[s>>2];u=+g[s+4>>2];v=+g[m+(r*12&-1)+8>>2];w=+g[b+168>>2];x=+g[b+172>>2];y=+g[b+176>>2];z=+g[b+180>>2];r=y+z==0.0;do{if((a[b+100|0]&1)==0){A=q;B=v}else{if((c[b+224>>2]|0)==3|r){A=q;B=v;break}m=b+96|0;C=+g[m>>2];D=+g[d>>2]*+g[b+104>>2];E=C+(v-q- +g[b+108>>2])*(-0.0- +g[b+220>>2]);F=-0.0-D;G=E<D?E:D;D=G<F?F:G;g[m>>2]=D;G=D-C;A=q-y*G;B=v+z*G}}while(0);do{if((a[b+112|0]&1)==0){H=75}else{d=b+224|0;if((c[d>>2]|0)==0|r){H=75;break}m=b+148|0;s=b+144|0;I=b+140|0;J=b+136|0;v=t+ +g[m>>2]*(-0.0-B)-o- +g[I>>2]*(-0.0-A);q=u+B*+g[s>>2]-p-A*+g[J>>2];g[f>>2]=v;g[f+4>>2]=q;g[f+8>>2]=B-A;K=b+184|0;c8(h,K,f);G=+g[h>>2];C=-0.0-G;D=+g[h+4>>2];F=-0.0-D;E=+g[h+8>>2];L=-0.0-E;M=c[d>>2]|0;do{if((M|0)==3){d=b+84|0;g[d>>2]=+g[d>>2]-G;d=b+88|0;g[d>>2]=+g[d>>2]-D;d=b+92|0;g[d>>2]=+g[d>>2]-E;N=C;O=F;P=L}else if((M|0)==1){d=b+84|0;Q=b+92|0;R=+g[Q>>2];S=R-E;if(S>=0.0){T=d|0;g[T>>2]=+g[T>>2]-G;T=b+88|0;g[T>>2]=+g[T>>2]-D;g[Q>>2]=S;N=C;O=F;P=L;break}S=R*+g[b+208>>2]-v;U=R*+g[b+212>>2]-q;V=+g[K>>2];W=+g[b+196>>2];X=+g[b+188>>2];Y=+g[b+200>>2];Z=V*Y-W*X;if(Z!=0.0){_=1.0/Z}else{_=Z}Z=(S*Y-W*U)*_;W=(V*U-S*X)*_;T=d|0;g[T>>2]=Z+ +g[T>>2];T=b+88|0;g[T>>2]=W+ +g[T>>2];g[Q>>2]=0.0;N=Z;O=W;P=-0.0-R}else if((M|0)==2){Q=b+84|0;T=b+92|0;R=+g[T>>2];W=R-E;if(W<=0.0){d=Q|0;g[d>>2]=+g[d>>2]-G;d=b+88|0;g[d>>2]=+g[d>>2]-D;g[T>>2]=W;N=C;O=F;P=L;break}W=R*+g[b+208>>2]-v;Z=R*+g[b+212>>2]-q;X=+g[K>>2];S=+g[b+196>>2];U=+g[b+188>>2];V=+g[b+200>>2];Y=X*V-S*U;if(Y!=0.0){$=1.0/Y}else{$=Y}Y=(W*V-S*Z)*$;S=(X*Z-W*U)*$;d=Q|0;g[d>>2]=Y+ +g[d>>2];d=b+88|0;g[d>>2]=S+ +g[d>>2];g[T>>2]=0.0;N=Y;O=S;P=-0.0-R}else{N=C;O=F;P=L}}while(0);aa=P+(O*+g[J>>2]-N*+g[I>>2]);ab=P+(O*+g[s>>2]-N*+g[m>>2]);ac=N;ad=O;ae=c[j>>2]|0}}while(0);if((H|0)==75){O=+g[b+148>>2];N=+g[b+144>>2];P=+g[b+140>>2];$=+g[b+136>>2];_=-0.0-(t+O*(-0.0-B)-o-P*(-0.0-A));L=-0.0-(u+B*N-p-A*$);F=+g[b+184>>2];C=+g[b+196>>2];q=+g[b+188>>2];v=+g[b+200>>2];D=F*v-C*q;if(D!=0.0){af=1.0/D}else{af=D}D=(v*_-C*L)*af;C=(F*L-q*_)*af;H=b+84|0;g[H>>2]=+g[H>>2]+D;H=b+88|0;g[H>>2]=C+ +g[H>>2];aa=C*$-D*P;ab=C*N-D*O;ac=D;ad=C;ae=k}k=(c[l>>2]|0)+(ae*12&-1)|0;C=+(p-w*ad);g[k>>2]=o-w*ac;g[k+4>>2]=C;g[(c[l>>2]|0)+((c[j>>2]|0)*12&-1)+8>>2]=A-y*aa;j=(c[l>>2]|0)+((c[n>>2]|0)*12&-1)|0;aa=+(u+x*ad);g[j>>2]=t+x*ac;g[j+4>>2]=aa;g[(c[l>>2]|0)+((c[n>>2]|0)*12&-1)+8>>2]=B+z*ab;i=e;return}function fW(a){a=a|0;return}function fX(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+48>>2]|0;e=+g[d+24>>2];f=+g[b+68>>2];h=+g[d+20>>2];i=+g[b+72>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function fY(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+52>>2]|0;e=+g[d+24>>2];f=+g[b+76>>2];h=+g[d+20>>2];i=+g[b+80>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function fZ(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0;d=+g[b+88>>2]*c;g[a>>2]=+g[b+84>>2]*c;g[a+4>>2]=d;return}function f_(a,b){a=a|0;b=+b;return+(+g[a+92>>2]*b)}function f$(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;d=a+96|0;e=c[d>>2]|0;f=b+28|0;h=c[f>>2]|0;i=h+(e*12&-1)|0;j=+g[i>>2];k=+g[i+4>>2];l=+g[h+(e*12&-1)+8>>2];i=a+100|0;m=c[i>>2]|0;n=h+(m*12&-1)|0;o=+g[n>>2];p=+g[n+4>>2];q=+g[h+(m*12&-1)+8>>2];r=+g[a+116>>2];s=+g[a+112>>2];t=+g[a+124>>2];u=+g[a+120>>2];v=+g[a+88>>2]- +g[a+84>>2];w=+g[a+104>>2];x=+g[a+108>>2];y=(o+t*(-0.0-q)-(j+r*(-0.0-l)))*w+(p+q*u-(k+l*s))*x;if(v<0.0){z=y+v*+g[b+4>>2]}else{z=y}b=a+92|0;y=+g[b>>2];v=y+z*(-0.0- +g[a+160>>2]);z=v>0.0?0.0:v;g[b>>2]=z;v=z-y;y=w*v;w=x*v;v=+g[a+144>>2];x=l- +g[a+152>>2]*(s*w-r*y);r=+g[a+148>>2];s=q+ +g[a+156>>2]*(w*u-y*t);a=(c[f>>2]|0)+(e*12&-1)|0;t=+(k-v*w);g[a>>2]=j-v*y;g[a+4>>2]=t;g[(c[f>>2]|0)+((c[d>>2]|0)*12&-1)+8>>2]=x;d=(c[f>>2]|0)+((c[i>>2]|0)*12&-1)|0;x=+(p+w*r);g[d>>2]=o+y*r;g[d+4>>2]=x;g[(c[f>>2]|0)+((c[i>>2]|0)*12&-1)+8>>2]=s;return}function f0(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0;e=b+128|0;f=c[e>>2]|0;h=d+24|0;d=c[h>>2]|0;i=d+(f*12&-1)|0;j=+g[i>>2];k=+g[i+4>>2];l=+g[d+(f*12&-1)+8>>2];f=b+132|0;m=c[f>>2]|0;n=d+(m*12&-1)|0;o=+g[n>>2];p=+g[n+4>>2];q=+g[d+(m*12&-1)+8>>2];m=b+176|0;d=b+180|0;do{if((a[b+112|0]&1)==0){r=l;s=q;t=0.0;u=+g[m>>2];v=+g[d>>2]}else{w=+g[d>>2];x=+g[m>>2];n=c[b+224>>2]|0;if((n|0)==0|w+x==0.0){r=l;s=q;t=0.0;u=x;v=w;break}y=q-l- +g[b+116>>2];do{if((n|0)==3){z=y- +g[b+120>>2];A=z<.13962635397911072?z:.13962635397911072;z=A<-.13962635397911072?-.13962635397911072:A;A=z*(-0.0- +g[b+220>>2]);if(z>0.0){B=z;C=A;break}B=-0.0-z;C=A}else if((n|0)==1){A=y- +g[b+120>>2];z=A+.03490658849477768;D=z<0.0?z:0.0;B=-0.0-A;C=(D<-.13962635397911072?-.13962635397911072:D)*(-0.0- +g[b+220>>2])}else if((n|0)==2){D=y- +g[b+124>>2];A=D+-.03490658849477768;z=A<.13962635397911072?A:.13962635397911072;B=D;C=(z<0.0?0.0:z)*(-0.0- +g[b+220>>2])}else{B=0.0;C=0.0}}while(0);r=l-C*x;s=q+C*w;t=B;u=x;v=w}}while(0);B=+S(+r);C=+R(+r);q=+S(+s);l=+R(+s);y=+g[b+68>>2]- +g[b+152>>2];z=+g[b+72>>2]- +g[b+156>>2];D=C*y-B*z;A=B*y+C*z;z=+g[b+76>>2]- +g[b+160>>2];C=+g[b+80>>2]- +g[b+164>>2];y=l*z-q*C;B=q*z+l*C;C=o+y-j-D;l=p+B-k-A;z=+P(+(C*C+l*l));q=+g[b+168>>2];E=+g[b+172>>2];F=q+E;G=F+A*A*u+B*B*v;H=y*v;I=A*D*(-0.0-u)-B*H;J=F+D*D*u+y*H;H=G*J-I*I;if(H!=0.0){K=1.0/H}else{K=H}H=-0.0-(C*J-l*I)*K;J=-0.0-(l*G-C*I)*K;K=+(k-q*J);g[i>>2]=j-q*H;g[i+4>>2]=K;g[(c[h>>2]|0)+((c[e>>2]|0)*12&-1)+8>>2]=r-u*(D*J-A*H);e=(c[h>>2]|0)+((c[f>>2]|0)*12&-1)|0;A=+(p+E*J);g[e>>2]=o+E*H;g[e+4>>2]=A;g[(c[h>>2]|0)+((c[f>>2]|0)*12&-1)+8>>2]=s+v*(y*J-B*H);if(z>.004999999888241291){L=0;return L|0}L=t<=.03490658849477768;return L|0}function f1(b){b=b|0;var d=0,e=0,f=0,j=0.0;d=i;e=c[(c[b+48>>2]|0)+8>>2]|0;f=c[(c[b+52>>2]|0)+8>>2]|0;db(8928,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(11336,(u=i,i=i+8|0,c[u>>2]=e,u)|0);db(8808,(u=i,i=i+8|0,c[u>>2]=f,u)|0);db(6768,(u=i,i=i+8|0,c[u>>2]=a[b+61|0]&1,u)|0);j=+g[b+72>>2];db(5992,(u=i,i=i+16|0,h[u>>3]=+g[b+68>>2],h[u+8>>3]=j,u)|0);j=+g[b+80>>2];db(5536,(u=i,i=i+16|0,h[u>>3]=+g[b+76>>2],h[u+8>>3]=j,u)|0);db(5072,(u=i,i=i+8|0,h[u>>3]=+g[b+116>>2],u)|0);db(4264,(u=i,i=i+8|0,c[u>>2]=a[b+112|0]&1,u)|0);db(12800,(u=i,i=i+8|0,h[u>>3]=+g[b+120>>2],u)|0);db(12504,(u=i,i=i+8|0,h[u>>3]=+g[b+124>>2],u)|0);db(4760,(u=i,i=i+8|0,c[u>>2]=a[b+100|0]&1,u)|0);db(4488,(u=i,i=i+8|0,h[u>>3]=+g[b+108>>2],u)|0);db(4232,(u=i,i=i+8|0,h[u>>3]=+g[b+104>>2],u)|0);db(11904,(u=i,i=i+8|0,c[u>>2]=c[b+56>>2],u)|0);i=d;return}function f2(a){a=a|0;vl(a);return}function f3(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0;e=c[b+48>>2]|0;f=c[e+8>>2]|0;h=b+96|0;c[h>>2]=f;i=c[b+52>>2]|0;j=c[i+8>>2]|0;l=b+100|0;c[l>>2]=j;m=e+28|0;n=b+128|0;o=c[m>>2]|0;p=c[m+4>>2]|0;c[n>>2]=o;c[n+4>>2]=p;n=i+28|0;m=b+136|0;q=c[n>>2]|0;r=c[n+4>>2]|0;c[m>>2]=q;c[m+4>>2]=r;s=+g[e+120>>2];g[b+144>>2]=s;t=+g[i+120>>2];g[b+148>>2]=t;u=+g[e+128>>2];g[b+152>>2]=u;v=+g[i+128>>2];g[b+156>>2]=v;i=c[d+24>>2]|0;e=i+(f*12&-1)|0;w=+g[e>>2];x=+g[e+4>>2];y=+g[i+(f*12&-1)+8>>2];e=d+28|0;m=c[e>>2]|0;n=m+(f*12&-1)|0;z=+g[n>>2];A=+g[n+4>>2];B=+g[m+(f*12&-1)+8>>2];n=i+(j*12&-1)|0;C=+g[n>>2];D=+g[n+4>>2];E=+g[i+(j*12&-1)+8>>2];i=m+(j*12&-1)|0;F=+g[i>>2];G=+g[i+4>>2];H=+g[m+(j*12&-1)+8>>2];I=+S(+y);J=+R(+y);y=+S(+E);K=+R(+E);E=+g[b+68>>2]-(c[k>>2]=o,+g[k>>2]);L=+g[b+72>>2]-(c[k>>2]=p,+g[k>>2]);M=J*E-I*L;N=I*E+J*L;p=b+112|0;L=+N;g[p>>2]=M;g[p+4>>2]=L;L=+g[b+76>>2]-(c[k>>2]=q,+g[k>>2]);J=+g[b+80>>2]-(c[k>>2]=r,+g[k>>2]);E=K*L-y*J;I=y*L+K*J;r=b+120|0;J=+I;g[r>>2]=E;g[r+4>>2]=J;r=b+104|0;J=C+E-w-M;w=D+I-x-N;q=r;x=+w;g[q>>2]=J;g[q+4>>2]=x;q=r|0;r=b+108|0;x=+P(+(J*J+w*w));g[b+88>>2]=x;c[b+164>>2]=x- +g[b+84>>2]>0.0?2:0;if(x<=.004999999888241291){g[q>>2]=0.0;g[r>>2]=0.0;g[b+160>>2]=0.0;g[b+92>>2]=0.0;return}D=1.0/x;x=D*J;g[q>>2]=x;J=D*w;g[r>>2]=J;w=M*J-N*x;D=J*E-x*I;C=t+(s+w*w*u)+D*D*v;if(C!=0.0){O=1.0/C}else{O=0.0}g[b+160>>2]=O;if((a[d+20|0]&1)==0){g[b+92>>2]=0.0;Q=B;T=H;U=F;V=G;W=z;X=A}else{r=b+92|0;O=+g[d+8>>2]*+g[r>>2];g[r>>2]=O;C=x*O;x=O*J;Q=B-u*(x*M-C*N);T=H+v*(x*E-C*I);U=F+C*t;V=G+x*t;W=z-C*s;X=A-x*s}r=(c[e>>2]|0)+(f*12&-1)|0;s=+X;g[r>>2]=W;g[r+4>>2]=s;g[(c[e>>2]|0)+((c[h>>2]|0)*12&-1)+8>>2]=Q;h=(c[e>>2]|0)+((c[l>>2]|0)*12&-1)|0;Q=+V;g[h>>2]=U;g[h+4>>2]=Q;g[(c[e>>2]|0)+((c[l>>2]|0)*12&-1)+8>>2]=T;return}function f4(a,b){a=a|0;b=+b;return+0.0}function f5(a){a=a|0;return}function f6(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+48>>2]|0;e=+g[d+24>>2];f=+g[b+68>>2];h=+g[d+20>>2];i=+g[b+72>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function f7(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+52>>2]|0;e=+g[d+24>>2];f=+g[b+76>>2];h=+g[d+20>>2];i=+g[b+80>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function f8(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0;d=+g[b+92>>2]*c;c=d*+g[b+108>>2];g[a>>2]=+g[b+104>>2]*d;g[a+4>>2]=c;return}function f9(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0;d=a+116|0;e=c[d>>2]|0;f=b+28|0;b=c[f>>2]|0;h=b+(e*12&-1)|0;i=+g[h>>2];j=+g[h+4>>2];k=+g[b+(e*12&-1)+8>>2];h=a+120|0;l=c[h>>2]|0;m=b+(l*12&-1)|0;n=+g[m>>2];o=+g[m+4>>2];p=+g[b+(l*12&-1)+8>>2];q=+g[a+156>>2];r=+g[a+160>>2];s=+g[a+164>>2];t=+g[a+168>>2];if(+g[a+68>>2]>0.0){l=a+112|0;u=+g[l>>2];v=(p-k+ +g[a+76>>2]+ +g[a+100>>2]*u)*(-0.0- +g[a+204>>2]);g[l>>2]=u+v;u=k-s*v;w=p+t*v;v=+g[a+136>>2];x=+g[a+132>>2];y=+g[a+128>>2];z=+g[a+124>>2];A=n+v*(-0.0-w)-i-y*(-0.0-u);B=o+x*w-j-z*u;C=+g[a+184>>2]*B+ +g[a+172>>2]*A;D=+g[a+188>>2]*B+ +g[a+176>>2]*A;A=-0.0-C;B=-0.0-D;l=a+104|0;g[l>>2]=+g[l>>2]-C;l=a+108|0;g[l>>2]=+g[l>>2]-D;E=u-s*(z*B-y*A);F=w+t*(x*B-v*A);G=A;H=B}else{B=+g[a+136>>2];A=+g[a+132>>2];v=+g[a+128>>2];x=+g[a+124>>2];w=n+B*(-0.0-p)-i-v*(-0.0-k);y=o+p*A-j-k*x;z=p-k;u=w*+g[a+172>>2]+y*+g[a+184>>2]+z*+g[a+196>>2];D=w*+g[a+176>>2]+y*+g[a+188>>2]+z*+g[a+200>>2];C=w*+g[a+180>>2]+y*+g[a+192>>2]+z*+g[a+204>>2];z=-0.0-u;y=-0.0-D;l=a+104|0;g[l>>2]=+g[l>>2]-u;l=a+108|0;g[l>>2]=+g[l>>2]-D;l=a+112|0;g[l>>2]=+g[l>>2]-C;E=k-s*(x*y-v*z-C);F=p+t*(A*y-B*z-C);G=z;H=y}l=(c[f>>2]|0)+(e*12&-1)|0;y=+(j-q*H);g[l>>2]=i-q*G;g[l+4>>2]=y;g[(c[f>>2]|0)+((c[d>>2]|0)*12&-1)+8>>2]=E;d=(c[f>>2]|0)+((c[h>>2]|0)*12&-1)|0;E=+(o+r*H);g[d>>2]=n+r*G;g[d+4>>2]=E;g[(c[f>>2]|0)+((c[h>>2]|0)*12&-1)+8>>2]=F;return}function ga(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0;d=a+96|0;e=c[d>>2]|0;f=b+24|0;b=c[f>>2]|0;h=b+(e*12&-1)|0;i=+g[h>>2];j=+g[h+4>>2];k=+g[b+(e*12&-1)+8>>2];e=a+100|0;l=c[e>>2]|0;m=b+(l*12&-1)|0;n=+g[m>>2];o=+g[m+4>>2];p=+g[b+(l*12&-1)+8>>2];q=+S(+k);r=+R(+k);s=+S(+p);t=+R(+p);u=+g[a+68>>2]- +g[a+128>>2];v=+g[a+72>>2]- +g[a+132>>2];w=r*u-q*v;x=q*u+r*v;v=+g[a+76>>2]- +g[a+136>>2];r=+g[a+80>>2]- +g[a+140>>2];u=t*v-s*r;q=s*v+t*r;r=n+u-i-w;t=o+q-j-x;v=+P(+(r*r+t*t));if(v<1.1920928955078125e-7){y=0.0;z=r;A=t}else{s=1.0/v;y=v;z=r*s;A=t*s}l=a+84|0;s=y- +g[l>>2];t=s<.20000000298023224?s:.20000000298023224;s=(t<0.0?0.0:t)*(-0.0- +g[a+160>>2]);t=z*s;z=A*s;s=+g[a+144>>2];A=k- +g[a+152>>2]*(w*z-x*t);x=+g[a+148>>2];w=p+ +g[a+156>>2]*(u*z-q*t);q=+(j-s*z);g[h>>2]=i-s*t;g[h+4>>2]=q;g[(c[f>>2]|0)+((c[d>>2]|0)*12&-1)+8>>2]=A;d=(c[f>>2]|0)+((c[e>>2]|0)*12&-1)|0;A=+(o+x*z);g[d>>2]=n+x*t;g[d+4>>2]=A;g[(c[f>>2]|0)+((c[e>>2]|0)*12&-1)+8>>2]=w;return y- +g[l>>2]<.004999999888241291|0}function gb(b){b=b|0;var d=0,e=0,f=0,j=0.0;d=i;e=c[(c[b+48>>2]|0)+8>>2]|0;f=c[(c[b+52>>2]|0)+8>>2]|0;db(6400,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(11336,(u=i,i=i+8|0,c[u>>2]=e,u)|0);db(8808,(u=i,i=i+8|0,c[u>>2]=f,u)|0);db(6768,(u=i,i=i+8|0,c[u>>2]=a[b+61|0]&1,u)|0);j=+g[b+72>>2];db(5992,(u=i,i=i+16|0,h[u>>3]=+g[b+68>>2],h[u+8>>3]=j,u)|0);j=+g[b+80>>2];db(5536,(u=i,i=i+16|0,h[u>>3]=+g[b+76>>2],h[u+8>>3]=j,u)|0);db(5104,(u=i,i=i+8|0,h[u>>3]=+g[b+84>>2],u)|0);db(11904,(u=i,i=i+8|0,c[u>>2]=c[b+56>>2],u)|0);i=d;return}function gc(a){a=a|0;vl(a);return}function gd(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0,aH=0,aI=0,aJ=0,aK=0,aL=0;e=c[b+48>>2]|0;f=c[e+8>>2]|0;h=b+116|0;c[h>>2]=f;i=c[b+52>>2]|0;j=c[i+8>>2]|0;l=b+120|0;c[l>>2]=j;m=e+28|0;n=b+140|0;o=c[m>>2]|0;p=c[m+4>>2]|0;c[n>>2]=o;c[n+4>>2]=p;n=i+28|0;m=b+148|0;q=c[n>>2]|0;r=c[n+4>>2]|0;c[m>>2]=q;c[m+4>>2]=r;s=+g[e+120>>2];g[b+156>>2]=s;t=+g[i+120>>2];g[b+160>>2]=t;u=+g[e+128>>2];g[b+164>>2]=u;v=+g[i+128>>2];g[b+168>>2]=v;i=c[d+24>>2]|0;w=+g[i+(f*12&-1)+8>>2];e=d+28|0;m=c[e>>2]|0;n=m+(f*12&-1)|0;x=+g[n>>2];y=+g[n+4>>2];z=+g[m+(f*12&-1)+8>>2];A=+g[i+(j*12&-1)+8>>2];i=m+(j*12&-1)|0;B=+g[i>>2];C=+g[i+4>>2];D=+g[m+(j*12&-1)+8>>2];E=+S(+w);F=+R(+w);G=+S(+A);H=+R(+A);I=+g[b+80>>2]-(c[k>>2]=o,+g[k>>2]);J=+g[b+84>>2]-(c[k>>2]=p,+g[k>>2]);K=F*I-E*J;L=E*I+F*J;p=b+124|0;J=+L;g[p>>2]=K;g[p+4>>2]=J;J=+g[b+88>>2]-(c[k>>2]=q,+g[k>>2]);F=+g[b+92>>2]-(c[k>>2]=r,+g[k>>2]);I=H*J-G*F;E=G*J+H*F;r=b+132|0;F=+E;g[r>>2]=I;g[r+4>>2]=F;F=s+t;H=F+u*L*L+v*E*E;J=-0.0-L;G=u*K*J-v*E*I;M=u*J-v*E;J=F+u*K*K+v*I*I;F=u*K+v*I;N=u+v;O=+g[b+68>>2];r=b+172|0;if(O>0.0){P=H*J-G*G;if(P!=0.0){Q=1.0/P}else{Q=P}g[r>>2]=J*Q;P=G*(-0.0-Q);g[b+184>>2]=P;g[b+180>>2]=0.0;g[b+176>>2]=P;g[b+188>>2]=H*Q;vq(b+192|0,0,16);if(N>0.0){T=1.0/N}else{T=0.0}Q=A-w- +g[b+96>>2];w=O*6.2831854820251465;O=w*T*w;A=+g[d>>2];P=A*(w*T*2.0*+g[b+72>>2]+A*O);q=b+100|0;g[q>>2]=P;if(P!=0.0){U=1.0/P}else{U=0.0}g[q>>2]=U;g[b+76>>2]=Q*A*O*U;O=N+U;if(O!=0.0){V=1.0/O}else{V=0.0}g[b+204>>2]=V}else{V=N*J-F*F;O=M*F-N*G;U=F*G-M*J;A=M*U+(H*V+G*O);if(A!=0.0){W=1.0/A}else{W=A}g[r>>2]=V*W;V=O*W;g[b+176>>2]=V;O=U*W;g[b+180>>2]=O;g[b+184>>2]=V;g[b+188>>2]=(N*H-M*M)*W;N=(M*G-H*F)*W;g[b+192>>2]=N;g[b+196>>2]=O;g[b+200>>2]=N;g[b+204>>2]=(H*J-G*G)*W;g[b+100>>2]=0.0;g[b+76>>2]=0.0}r=b+104|0;if((a[d+20|0]&1)==0){g[r>>2]=0.0;g[b+108>>2]=0.0;g[b+112>>2]=0.0;X=z;Y=D;Z=B;_=C;$=x;aa=y;ab=c[e>>2]|0;ac=ab+(f*12&-1)|0;ad=ac;ae=(g[k>>2]=$,c[k>>2]|0);af=(g[k>>2]=aa,c[k>>2]|0);ag=af;ah=0;ai=0;aj=ag;ak=ae;al=0;am=ai|ak;an=aj|al;ao=ad|0;c[ao>>2]=am;ap=ad+4|0;c[ap>>2]=an;aq=c[h>>2]|0;ar=c[e>>2]|0;as=ar+(aq*12&-1)+8|0;g[as>>2]=X;at=c[l>>2]|0;au=c[e>>2]|0;av=au+(at*12&-1)|0;aw=av;ax=(g[k>>2]=Z,c[k>>2]|0);ay=(g[k>>2]=_,c[k>>2]|0);az=ay;aA=0;aB=0;aC=az;aD=ax;aE=0;aF=aB|aD;aG=aC|aE;aH=aw|0;c[aH>>2]=aF;aI=aw+4|0;c[aI>>2]=aG;aJ=c[l>>2]|0;aK=c[e>>2]|0;aL=aK+(aJ*12&-1)+8|0;g[aL>>2]=Y;return}else{W=+g[d+8>>2];d=r|0;G=W*+g[d>>2];g[d>>2]=G;d=b+108|0;J=W*+g[d>>2];g[d>>2]=J;d=b+112|0;H=W*+g[d>>2];g[d>>2]=H;X=z-u*(H+(J*K-G*L));Y=D+v*(H+(J*I-G*E));Z=B+t*G;_=C+t*J;$=x-s*G;aa=y-s*J;ab=c[e>>2]|0;ac=ab+(f*12&-1)|0;ad=ac;ae=(g[k>>2]=$,c[k>>2]|0);af=(g[k>>2]=aa,c[k>>2]|0);ag=af;ah=0;ai=0;aj=ag;ak=ae;al=0;am=ai|ak;an=aj|al;ao=ad|0;c[ao>>2]=am;ap=ad+4|0;c[ap>>2]=an;aq=c[h>>2]|0;ar=c[e>>2]|0;as=ar+(aq*12&-1)+8|0;g[as>>2]=X;at=c[l>>2]|0;au=c[e>>2]|0;av=au+(at*12&-1)|0;aw=av;ax=(g[k>>2]=Z,c[k>>2]|0);ay=(g[k>>2]=_,c[k>>2]|0);az=ay;aA=0;aB=0;aC=az;aD=ax;aE=0;aF=aB|aD;aG=aC|aE;aH=aw|0;c[aH>>2]=aF;aI=aw+4|0;c[aI>>2]=aG;aJ=c[l>>2]|0;aK=c[e>>2]|0;aL=aK+(aJ*12&-1)+8|0;g[aL>>2]=Y;return}}function ge(a){a=a|0;return}function gf(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+48>>2]|0;e=+g[d+24>>2];f=+g[b+80>>2];h=+g[d+20>>2];i=+g[b+84>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function gg(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+52>>2]|0;e=+g[d+24>>2];f=+g[b+88>>2];h=+g[d+20>>2];i=+g[b+92>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function gh(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0;d=+g[b+108>>2]*c;g[a>>2]=+g[b+104>>2]*c;g[a+4>>2]=d;return}function gi(a,b){a=a|0;b=+b;return+(+g[a+112>>2]*b)}function gj(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0;d=a+116|0;e=c[d>>2]|0;f=b+24|0;b=c[f>>2]|0;h=b+(e*12&-1)|0;i=+g[h>>2];j=+g[h+4>>2];k=+g[b+(e*12&-1)+8>>2];e=a+120|0;l=c[e>>2]|0;m=b+(l*12&-1)|0;n=+g[m>>2];o=+g[m+4>>2];p=+g[b+(l*12&-1)+8>>2];q=+S(+k);r=+R(+k);s=+S(+p);t=+R(+p);u=+g[a+156>>2];v=+g[a+160>>2];w=+g[a+164>>2];x=+g[a+168>>2];y=+g[a+80>>2]- +g[a+140>>2];z=+g[a+84>>2]- +g[a+144>>2];A=r*y-q*z;B=q*y+r*z;z=+g[a+88>>2]- +g[a+148>>2];r=+g[a+92>>2]- +g[a+152>>2];y=t*z-s*r;q=s*z+t*r;r=u+v;t=r+w*B*B+x*q*q;z=-0.0-B;s=w*A*z-x*q*y;C=w*z-x*q;z=r+w*A*A+x*y*y;r=w*A+x*y;D=w+x;E=n+y-i-A;F=o+q-j-B;if(+g[a+68>>2]>0.0){G=+P(+(E*E+F*F));H=t*z-s*s;if(H!=0.0){I=1.0/H}else{I=H}H=-0.0-(z*E-s*F)*I;J=-0.0-(t*F-s*E)*I;K=A*J-B*H;L=0.0;M=G;N=y*J-q*H;O=H;Q=J}else{J=p-k- +g[a+96>>2];H=+P(+(E*E+F*F));if(J>0.0){T=J}else{T=-0.0-J}G=D*z-r*r;I=r*C-D*s;U=r*s-C*z;V=C*U+(t*G+s*I);if(V!=0.0){W=1.0/V}else{W=V}V=r*E;X=(C*(F*s-z*E)+(t*(z*J-r*F)+s*(V-s*J)))*W;z=-0.0-(E*G+F*I+U*J)*W;U=-0.0-(C*(V-C*F)+(t*(D*F-r*J)+s*(C*J-D*E)))*W;K=A*U-B*z-X;L=T;M=H;N=y*U-q*z-X;O=z;Q=U}U=+(j-u*Q);g[h>>2]=i-u*O;g[h+4>>2]=U;g[(c[f>>2]|0)+((c[d>>2]|0)*12&-1)+8>>2]=k-w*K;d=(c[f>>2]|0)+((c[e>>2]|0)*12&-1)|0;K=+(o+v*Q);g[d>>2]=n+v*O;g[d+4>>2]=K;g[(c[f>>2]|0)+((c[e>>2]|0)*12&-1)+8>>2]=p+x*N;if(M>.004999999888241291){Y=0;return Y|0}Y=L<=.03490658849477768;return Y|0}function gk(b){b=b|0;var d=0,e=0,f=0,j=0.0;d=i;e=c[(c[b+48>>2]|0)+8>>2]|0;f=c[(c[b+52>>2]|0)+8>>2]|0;db(6344,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(11336,(u=i,i=i+8|0,c[u>>2]=e,u)|0);db(8808,(u=i,i=i+8|0,c[u>>2]=f,u)|0);db(6768,(u=i,i=i+8|0,c[u>>2]=a[b+61|0]&1,u)|0);j=+g[b+84>>2];db(5992,(u=i,i=i+16|0,h[u>>3]=+g[b+80>>2],h[u+8>>3]=j,u)|0);j=+g[b+92>>2];db(5536,(u=i,i=i+16|0,h[u>>3]=+g[b+88>>2],h[u+8>>3]=j,u)|0);db(5072,(u=i,i=i+8|0,h[u>>3]=+g[b+96>>2],u)|0);db(12768,(u=i,i=i+8|0,h[u>>3]=+g[b+68>>2],u)|0);db(12472,(u=i,i=i+8|0,h[u>>3]=+g[b+72>>2],u)|0);db(11904,(u=i,i=i+8|0,c[u>>2]=c[b+56>>2],u)|0);i=d;return}function gl(a){a=a|0;vl(a);return}function gm(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0.0,ac=0.0,ad=0.0,ae=0.0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0,aH=0,aI=0,aJ=0,aK=0,aL=0,aM=0,aN=0,aO=0,aP=0;e=c[b+48>>2]|0;f=c[e+8>>2]|0;h=b+132|0;c[h>>2]=f;i=c[b+52>>2]|0;j=c[i+8>>2]|0;l=b+136|0;c[l>>2]=j;m=e+28|0;n=b+140|0;o=c[m>>2]|0;p=c[m+4>>2]|0;c[n>>2]=o;c[n+4>>2]=p;n=i+28|0;m=b+148|0;q=c[n>>2]|0;r=c[n+4>>2]|0;c[m>>2]=q;c[m+4>>2]=r;s=+g[e+120>>2];g[b+156>>2]=s;t=+g[i+120>>2];g[b+160>>2]=t;u=+g[e+128>>2];g[b+164>>2]=u;v=+g[i+128>>2];g[b+168>>2]=v;i=c[d+24>>2]|0;e=i+(f*12&-1)|0;w=+g[e>>2];x=+g[e+4>>2];y=+g[i+(f*12&-1)+8>>2];e=d+28|0;m=c[e>>2]|0;n=m+(f*12&-1)|0;z=+g[n>>2];A=+g[n+4>>2];B=+g[m+(f*12&-1)+8>>2];n=i+(j*12&-1)|0;C=+g[n>>2];D=+g[n+4>>2];E=+g[i+(j*12&-1)+8>>2];i=m+(j*12&-1)|0;F=+g[i>>2];G=+g[i+4>>2];H=+g[m+(j*12&-1)+8>>2];I=+S(+y);J=+R(+y);y=+S(+E);K=+R(+E);E=+g[b+76>>2]-(c[k>>2]=o,+g[k>>2]);L=+g[b+80>>2]-(c[k>>2]=p,+g[k>>2]);M=J*E-I*L;N=I*E+J*L;L=+g[b+84>>2]-(c[k>>2]=q,+g[k>>2]);E=+g[b+88>>2]-(c[k>>2]=r,+g[k>>2]);O=K*L-y*E;P=y*L+K*E;E=C+O-w-M;w=D+P-x-N;x=+g[b+100>>2];D=+g[b+104>>2];C=J*x-I*D;K=I*x+J*D;r=b+180|0;D=+K;g[r>>2]=C;g[r+4>>2]=D;D=M+E;M=N+w;N=K*D-C*M;g[b+196>>2]=N;x=O*K-P*C;g[b+200>>2]=x;L=s+t;y=L+N*u*N+x*v*x;if(y>0.0){Q=1.0/y}else{Q=y}g[b+204>>2]=Q;r=b+212|0;g[r>>2]=0.0;q=b+216|0;g[q>>2]=0.0;p=b+220|0;g[p>>2]=0.0;Q=+g[b+68>>2];do{if(Q>0.0){y=+g[b+92>>2];T=+g[b+96>>2];U=J*y-I*T;V=I*y+J*T;o=b+172|0;T=+V;g[o>>2]=U;g[o+4>>2]=T;T=D*V-M*U;g[b+188>>2]=T;y=O*V-P*U;g[b+192>>2]=y;W=L+T*u*T+y*v*y;if(W<=0.0){break}y=1.0/W;g[r>>2]=y;T=Q*6.2831854820251465;X=T*y*T;Y=+g[d>>2];Z=Y*(T*y*2.0*+g[b+72>>2]+Y*X);if(Z>0.0){_=1.0/Z}else{_=Z}g[p>>2]=_;g[q>>2]=(E*U+w*V)*Y*X*_;X=W+_;g[r>>2]=X;if(X<=0.0){break}g[r>>2]=1.0/X}else{g[b+116>>2]=0.0}}while(0);do{if((a[b+128|0]&1)==0){g[b+208>>2]=0.0;g[b+112>>2]=0.0}else{_=v+u;r=b+208|0;g[r>>2]=_;if(_<=0.0){break}g[r>>2]=1.0/_}}while(0);if((a[d+20|0]&1)==0){g[b+108>>2]=0.0;g[b+116>>2]=0.0;g[b+112>>2]=0.0;$=B;aa=H;ab=F;ac=G;ad=z;ae=A;af=c[e>>2]|0;ag=af+(f*12&-1)|0;ah=ag;ai=(g[k>>2]=ad,c[k>>2]|0);aj=(g[k>>2]=ae,c[k>>2]|0);ak=aj;al=0;am=0;an=ak;ao=ai;ap=0;aq=am|ao;ar=an|ap;as=ah|0;c[as>>2]=aq;at=ah+4|0;c[at>>2]=ar;au=c[h>>2]|0;av=c[e>>2]|0;aw=av+(au*12&-1)+8|0;g[aw>>2]=$;ax=c[l>>2]|0;ay=c[e>>2]|0;az=ay+(ax*12&-1)|0;aA=az;aB=(g[k>>2]=ab,c[k>>2]|0);aC=(g[k>>2]=ac,c[k>>2]|0);aD=aC;aE=0;aF=0;aG=aD;aH=aB;aI=0;aJ=aF|aH;aK=aG|aI;aL=aA|0;c[aL>>2]=aJ;aM=aA+4|0;c[aM>>2]=aK;aN=c[l>>2]|0;aO=c[e>>2]|0;aP=aO+(aN*12&-1)+8|0;g[aP>>2]=aa;return}else{r=d+8|0;d=b+108|0;_=+g[r>>2]*+g[d>>2];g[d>>2]=_;d=b+116|0;w=+g[r>>2]*+g[d>>2];g[d>>2]=w;d=b+112|0;E=+g[r>>2]*+g[d>>2];g[d>>2]=E;Q=_*C+w*+g[b+172>>2];C=_*K+w*+g[b+176>>2];$=B-(E+(_*N+w*+g[b+188>>2]))*u;aa=H+(E+(_*x+w*+g[b+192>>2]))*v;ab=F+Q*t;ac=G+C*t;ad=z-Q*s;ae=A-C*s;af=c[e>>2]|0;ag=af+(f*12&-1)|0;ah=ag;ai=(g[k>>2]=ad,c[k>>2]|0);aj=(g[k>>2]=ae,c[k>>2]|0);ak=aj;al=0;am=0;an=ak;ao=ai;ap=0;aq=am|ao;ar=an|ap;as=ah|0;c[as>>2]=aq;at=ah+4|0;c[at>>2]=ar;au=c[h>>2]|0;av=c[e>>2]|0;aw=av+(au*12&-1)+8|0;g[aw>>2]=$;ax=c[l>>2]|0;ay=c[e>>2]|0;az=ay+(ax*12&-1)|0;aA=az;aB=(g[k>>2]=ab,c[k>>2]|0);aC=(g[k>>2]=ac,c[k>>2]|0);aD=aC;aE=0;aF=0;aG=aD;aH=aB;aI=0;aJ=aF|aH;aK=aG|aI;aL=aA|0;c[aL>>2]=aJ;aM=aA+4|0;c[aM>>2]=aK;aN=c[l>>2]|0;aO=c[e>>2]|0;aP=aO+(aN*12&-1)+8|0;g[aP>>2]=aa;return}}function gn(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0;e=b|0;c[e>>2]=19312;f=d+8|0;h=d+12|0;if((c[f>>2]|0)==(c[h>>2]|0)){ba(7272,173,15744,9072)}else{c[b+4>>2]=c[d>>2];c[b+8>>2]=0;c[b+12>>2]=0;c[b+48>>2]=c[f>>2];c[b+52>>2]=c[h>>2];c[b+56>>2]=0;a[b+61|0]=a[d+16|0]&1;a[b+60|0]=0;c[b+64>>2]=c[d+4>>2];vq(b+16|0,0,32);c[e>>2]=20184;e=d+20|0;h=b+76|0;f=c[e+4>>2]|0;c[h>>2]=c[e>>2];c[h+4>>2]=f;f=d+28|0;h=b+84|0;e=c[f+4>>2]|0;c[h>>2]=c[f>>2];c[h+4>>2]=e;e=d+36|0;h=b+92|0;f=c[e>>2]|0;i=c[e+4>>2]|0;c[h>>2]=f;c[h+4>>2]=i;h=b+100|0;g[h>>2]=(c[k>>2]=i,+g[k>>2])*-1.0;c[h+4>>2]=f;g[b+204>>2]=0.0;g[b+108>>2]=0.0;g[b+208>>2]=0.0;g[b+112>>2]=0.0;g[b+212>>2]=0.0;g[b+116>>2]=0.0;g[b+120>>2]=+g[d+48>>2];g[b+124>>2]=+g[d+52>>2];a[b+128|0]=a[d+44|0]&1;g[b+68>>2]=+g[d+56>>2];g[b+72>>2]=+g[d+60>>2];g[b+216>>2]=0.0;g[b+220>>2]=0.0;vq(b+172|0,0,16);return}}function go(a){a=a|0;return}function gp(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0;d=+g[a+156>>2];e=+g[a+160>>2];f=+g[a+164>>2];h=+g[a+168>>2];i=a+132|0;j=c[i>>2]|0;k=b+28|0;l=c[k>>2]|0;m=l+(j*12&-1)|0;n=+g[m>>2];o=+g[m+4>>2];p=+g[l+(j*12&-1)+8>>2];m=a+136|0;q=c[m>>2]|0;r=l+(q*12&-1)|0;s=+g[r>>2];t=+g[r+4>>2];u=+g[l+(q*12&-1)+8>>2];v=+g[a+172>>2];w=+g[a+176>>2];x=+g[a+192>>2];y=+g[a+188>>2];q=a+116|0;z=+g[q>>2];A=(+g[a+216>>2]+(u*x+(v*(s-n)+w*(t-o))-p*y)+ +g[a+220>>2]*z)*(-0.0- +g[a+212>>2]);g[q>>2]=z+A;z=v*A;v=w*A;w=n-d*z;n=o-d*v;o=p-f*A*y;y=s+e*z;z=t+e*v;v=u+h*A*x;q=a+112|0;x=+g[q>>2];A=+g[b>>2]*+g[a+120>>2];u=x+(v-o- +g[a+124>>2])*(-0.0- +g[a+208>>2]);t=-0.0-A;s=u<A?u:A;A=s<t?t:s;g[q>>2]=A;s=A-x;x=o-f*s;o=v+h*s;s=+g[a+180>>2];v=+g[a+184>>2];A=+g[a+200>>2];t=+g[a+196>>2];u=((y-w)*s+(z-n)*v+A*o-t*x)*(-0.0- +g[a+204>>2]);q=a+108|0;g[q>>2]=+g[q>>2]+u;p=s*u;s=v*u;q=(c[k>>2]|0)+(j*12&-1)|0;v=+(n-d*s);g[q>>2]=w-d*p;g[q+4>>2]=v;g[(c[k>>2]|0)+((c[i>>2]|0)*12&-1)+8>>2]=x-f*t*u;i=(c[k>>2]|0)+((c[m>>2]|0)*12&-1)|0;t=+(z+e*s);g[i>>2]=y+e*p;g[i+4>>2]=t;g[(c[k>>2]|0)+((c[m>>2]|0)*12&-1)+8>>2]=o+h*A*u;return}function gq(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+48>>2]|0;e=+g[d+24>>2];f=+g[b+76>>2];h=+g[d+20>>2];i=+g[b+80>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function gr(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=c[b+52>>2]|0;e=+g[d+24>>2];f=+g[b+84>>2];h=+g[d+20>>2];i=+g[b+88>>2];j=f*h+e*i+ +g[d+16>>2];g[a>>2]=+g[d+12>>2]+(e*f-h*i);g[a+4>>2]=j;return}function gs(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0,e=0.0,f=0.0;d=+g[b+108>>2];e=+g[b+116>>2];f=(d*+g[b+184>>2]+e*+g[b+176>>2])*c;g[a>>2]=(d*+g[b+180>>2]+e*+g[b+172>>2])*c;g[a+4>>2]=f;return}function gt(a,b){a=a|0;b=+b;return+(+g[a+112>>2]*b)}function gu(a){a=a|0;return c[a+68>>2]|0}function gv(a){a=a|0;return c[a+64>>2]|0}function gw(a,b){a=a|0;b=b|0;c[a+68>>2]=b;return}function gx(a,b){a=a|0;b=b|0;c[a+76>>2]=b;return}function gy(a,b){a=a|0;b=b|0;c[a+64>>2]=b;return}function gz(a,b){a=a|0;b=b|0;c[a+60>>2]=b;return}function gA(a){a=a|0;return c[a+72>>2]|0}function gB(a,b){a=a|0;b=b|0;c[a+72>>2]=b;return}function gC(a){a=a|0;return a|0}function gD(a){a=a|0;return c[a+60>>2]|0}function gE(a){a=a|0;return c[a+76>>2]|0}function gF(a){a=a|0;return c[a+48>>2]|0}function gG(a){a=a|0;return c[a+52>>2]|0}function gH(a,b){a=a|0;b=+b;g[a+68>>2]=b;return}function gI(a){a=a|0;return c[a+64>>2]|0}function gJ(a,b){a=a|0;b=b|0;c[a+64>>2]=b;return}function gK(a){a=a|0;return c[a+12>>2]|0}function gL(a){a=a|0;return a+80|0}function gM(a){a=a|0;return a+88|0}function gN(a){a=a|0;return+(+g[a+68>>2])}function gO(a){a=a|0;return+(+g[a+104>>2])}function gP(a){a=a|0;return+(+g[a+72>>2])}function gQ(b){b=b|0;return(a[b+61|0]&1)!=0|0}function gR(a){a=a|0;return c[a+4>>2]|0}function gS(a,b){a=a|0;b=+b;g[a+72>>2]=b;return}function gT(a,b){a=a|0;b=+b;g[a+104>>2]=b;return}function gU(a){a=a|0;var d=0;if((b[(c[a+48>>2]|0)+4>>1]&32)==0){d=0;return d|0}d=(b[(c[a+52>>2]|0)+4>>1]&32)!=0;return d|0}function gV(a){a=a|0;return+(+g[a+20>>2])}function gW(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function gX(a){a=a|0;return c[a+12>>2]|0}function gY(a,b){a=a|0;b=+b;g[a+20>>2]=b;return}function gZ(a){a=a|0;return c[a+8>>2]|0}function g_(a){a=a|0;return c[a+4>>2]|0}function g$(a){a=a|0;return+(+g[a+16>>2])}function g0(a){a=a|0;return c[a+40>>2]|0}function g1(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0;d=a+132|0;e=c[d>>2]|0;f=b+24|0;b=c[f>>2]|0;h=b+(e*12&-1)|0;i=+g[h>>2];j=+g[h+4>>2];k=+g[b+(e*12&-1)+8>>2];e=a+136|0;l=c[e>>2]|0;m=b+(l*12&-1)|0;n=+g[m>>2];o=+g[m+4>>2];p=+g[b+(l*12&-1)+8>>2];q=+S(+k);r=+R(+k);s=+S(+p);t=+R(+p);u=+g[a+76>>2]- +g[a+140>>2];v=+g[a+80>>2]- +g[a+144>>2];w=r*u-q*v;x=q*u+r*v;v=+g[a+84>>2]- +g[a+148>>2];u=+g[a+88>>2]- +g[a+152>>2];y=t*v-s*u;z=s*v+t*u;u=n-i+y-w;t=o-j+z-x;v=+g[a+100>>2];s=+g[a+104>>2];A=r*v-q*s;B=q*v+r*s;s=A*u+B*t;r=+g[a+156>>2];v=+g[a+160>>2];q=+g[a+164>>2];C=+g[a+196>>2];D=+g[a+168>>2];E=+g[a+200>>2];F=r+v+C*q*C+E*D*E;if(F!=0.0){G=(-0.0-s)/F}else{G=0.0}F=A*G;E=B*G;C=+(j-E*r);g[h>>2]=i-F*r;g[h+4>>2]=C;g[(c[f>>2]|0)+((c[d>>2]|0)*12&-1)+8>>2]=k-(B*(w+u)-A*(x+t))*G*q;d=(c[f>>2]|0)+((c[e>>2]|0)*12&-1)|0;q=+(o+E*v);g[d>>2]=n+F*v;g[d+4>>2]=q;g[(c[f>>2]|0)+((c[e>>2]|0)*12&-1)+8>>2]=p+(y*B-z*A)*G*D;if(s>0.0){H=s;I=H<=.004999999888241291;return I|0}H=-0.0-s;I=H<=.004999999888241291;return I|0}function g2(b){b=b|0;var d=0,e=0,f=0,j=0.0;d=i;e=c[(c[b+48>>2]|0)+8>>2]|0;f=c[(c[b+52>>2]|0)+8>>2]|0;db(6288,(u=i,i=i+1|0,i=i+7>>3<<3,c[u>>2]=0,u)|0);db(11336,(u=i,i=i+8|0,c[u>>2]=e,u)|0);db(8808,(u=i,i=i+8|0,c[u>>2]=f,u)|0);db(6768,(u=i,i=i+8|0,c[u>>2]=a[b+61|0]&1,u)|0);j=+g[b+80>>2];db(5992,(u=i,i=i+16|0,h[u>>3]=+g[b+76>>2],h[u+8>>3]=j,u)|0);j=+g[b+88>>2];db(5536,(u=i,i=i+16|0,h[u>>3]=+g[b+84>>2],h[u+8>>3]=j,u)|0);j=+g[b+96>>2];db(5032,(u=i,i=i+16|0,h[u>>3]=+g[b+92>>2],h[u+8>>3]=j,u)|0);db(4760,(u=i,i=i+8|0,c[u>>2]=a[b+128|0]&1,u)|0);db(4488,(u=i,i=i+8|0,h[u>>3]=+g[b+124>>2],u)|0);db(4232,(u=i,i=i+8|0,h[u>>3]=+g[b+120>>2],u)|0);db(12768,(u=i,i=i+8|0,h[u>>3]=+g[b+68>>2],u)|0);db(12472,(u=i,i=i+8|0,h[u>>3]=+g[b+72>>2],u)|0);db(11904,(u=i,i=i+8|0,c[u>>2]=c[b+56>>2],u)|0);i=d;return}function g3(a){a=a|0;vl(a);return}function g4(){var a=0;a=vo(80)|0;b3(a);c[a+60>>2]=0;c[a+64>>2]=0;c[a+68>>2]=4192;c[a+72>>2]=4184;c[a+76>>2]=0;return a|0}function g5(a,b,c){a=a|0;b=b|0;c=c|0;dv(a,b,c);return}function g6(a){a=a|0;dx(a);return}function g7(a){a=a|0;dy(a|0,a);return}function g8(a){a=a|0;if((a|0)==0){return}vi(c[a+32>>2]|0);vi(c[a+44>>2]|0);vi(c[a+4>>2]|0);vl(a);return}function g9(a,b){a=a|0;b=b|0;dp(a,b);return}function ha(a,b){a=a|0;b=b|0;var c=0;c=a;a=b;vp(c|0,a|0,60)|0;return}function hb(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[22936]|0)){a[22936]=1}bp[c[(c[b>>2]|0)+4>>2]&511](e,b);b=c[e+4>>2]|0;f=408;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 408}function hc(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[22944]|0)){a[22944]=1}bp[c[c[b>>2]>>2]&511](e,b);b=c[e+4>>2]|0;f=400;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 400}function hd(b,d){b=b|0;d=+d;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;if(!(a[22816]|0)){a[22816]=1}bN[c[(c[b>>2]|0)+8>>2]&127](f,b,d);b=c[f+4>>2]|0;g=312;c[g>>2]=c[f>>2];c[g+4>>2]=b;i=e;return 312}function he(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+24>>2]&511](a);return}function hf(a){a=a|0;bo[c[(c[a>>2]|0)+16>>2]&511](a);return}function hg(a,b){a=a|0;b=+b;return+(+bw[c[(c[a>>2]|0)+12>>2]&127](a,b))}function hh(a,c){a=a|0;c=c|0;var d=0,e=0;d=a+32|0;e=c;b[d>>1]=b[e>>1]|0;b[d+2>>1]=b[e+2>>1]|0;b[d+4>>1]=b[e+4>>1]|0;dI(a);return}function hi(){var a=0;a=vo(44)|0;b[a+32>>1]=1;b[a+34>>1]=-1;b[a+36>>1]=0;c[a+40>>2]=0;c[a+24>>2]=0;c[a+28>>2]=0;vq(a|0,0,16);return a|0}function hj(b){b=b|0;var d=0,e=0,f=0,h=0;d=vo(176)|0;e=d;c[e>>2]=19312;f=c[b+8>>2]|0;h=c[b+12>>2]|0;if((f|0)!=(h|0)){c[d+4>>2]=c[b>>2];c[d+8>>2]=0;c[d+12>>2]=0;c[d+48>>2]=f;c[d+52>>2]=h;c[d+56>>2]=0;a[d+61|0]=a[b+16|0]&1;a[d+60|0]=0;c[d+64>>2]=c[b+4>>2];vq(d+16|0,0,32);c[e>>2]=19912;e=b+20|0;h=d+80|0;f=c[e+4>>2]|0;c[h>>2]=c[e>>2];c[h+4>>2]=f;f=b+28|0;h=d+88|0;e=c[f+4>>2]|0;c[h>>2]=c[f>>2];c[h+4>>2]=e;g[d+104>>2]=+g[b+36>>2];g[d+68>>2]=+g[b+40>>2];g[d+72>>2]=+g[b+44>>2];g[d+100>>2]=0.0;g[d+96>>2]=0.0;g[d+76>>2]=0.0;return d|0}ba(7272,173,15744,9072);return 0}function hk(a,b){a=a|0;b=+b;g[a>>2]=b;return}function hl(d,e){d=d|0;e=e|0;var f=0,h=0,i=0;f=d+38|0;if((e&1|0)==(a[f]&1|0)){return}h=c[d+8>>2]|0;d=h+4|0;i=b[d>>1]|0;if((i&2)==0){b[d>>1]=i|2;g[h+144>>2]=0.0}a[f]=e&1;return}function hm(a,b){a=a|0;b=b|0;return(c[a+24>>2]|0)+(b*28&-1)|0}function hn(a,b){a=a|0;b=b|0;c[a+40>>2]=b;return}function ho(a){a=a|0;return a+32|0}function hp(b){b=b|0;return(a[b+38|0]&1)!=0|0}function hq(a){a=a|0;return c[(c[a+12>>2]|0)+4>>2]|0}function hr(a){a=a|0;return+(+g[a>>2])}function hs(a){a=a|0;return c[a+48>>2]|0}function ht(a){a=a|0;return c[a+52>>2]|0}function hu(a,b){a=a|0;b=+b;g[a+84>>2]=b;return}function hv(a){a=a|0;return c[a+64>>2]|0}function hw(a,b){a=a|0;b=+b;g[a+104>>2]=b;return}function hx(a,b){a=a|0;b=b|0;c[a+64>>2]=b;return}function hy(a){a=a|0;return c[a+12>>2]|0}function hz(a){a=a|0;return+(+g[a+104>>2])}function hA(a){a=a|0;return a+76|0}function hB(a){a=a|0;return+(+g[a+84>>2])}function hC(a){a=a|0;return+(+g[a+88>>2])}function hD(b){b=b|0;return(a[b+61|0]&1)!=0|0}function hE(a,d){a=a|0;d=d|0;var e=0,f=0,h=0;e=c[a+52>>2]|0;f=e+4|0;h=b[f>>1]|0;if((h&2)==0){b[f>>1]=h|2;g[e+144>>2]=0.0}e=d;d=a+76|0;a=c[e+4>>2]|0;c[d>>2]=c[e>>2];c[d+4>>2]=a;return}function hF(a){a=a|0;return c[a+4>>2]|0}function hG(a,b){a=a|0;b=+b;g[a+88>>2]=b;return}function hH(a){a=a|0;var d=0;if((b[(c[a+48>>2]|0)+4>>1]&32)==0){d=0;return d|0}d=(b[(c[a+52>>2]|0)+4>>1]&32)!=0;return d|0}function hI(a){a=a|0;return c[a+48>>2]|0}function hJ(a){a=a|0;return c[a+4>>2]|0}function hK(b){b=b|0;var d=0,e=0;if(!(a[22832]|0)){a[22832]=1}d=b+76|0;b=c[d+4>>2]|0;e=24;c[e>>2]=c[d>>2];c[e+4>>2]=b;return 24}function hL(b){b=b|0;var d=0,e=0;if(!(a[22840]|0)){a[22840]=1}d=b+68|0;b=c[d+4>>2]|0;e=16;c[e>>2]=c[d>>2];c[e+4>>2]=b;return 16}function hM(a){a=a|0;return c[a+64>>2]|0}function hN(a){a=a|0;return c[a+52>>2]|0}function hO(b){b=b|0;return(a[b+61|0]&1)!=0|0}function hP(a,b){a=a|0;b=b|0;c[a+64>>2]=b;return}function hQ(a){a=a|0;return c[a+12>>2]|0}function hR(a){a=a|0;var d=0;if((b[(c[a+48>>2]|0)+4>>1]&32)==0){d=0;return d|0}d=(b[(c[a+52>>2]|0)+4>>1]&32)!=0;return d|0}function hS(a){a=a|0;return+(+g[a+112>>2])}function hT(a){a=a|0;var b=0,d=0.0,e=0,f=0.0,h=0.0,i=0.0,j=0,k=0.0;b=c[a>>2]|0;if((b|0)==-1){d=0.0;return+d}e=c[a+4>>2]|0;f=(+g[e+(b*36&-1)+8>>2]- +g[e+(b*36&-1)>>2]+(+g[e+(b*36&-1)+12>>2]- +g[e+(b*36&-1)+4>>2]))*2.0;b=c[a+12>>2]|0;if((b|0)>0){h=0.0;a=0;while(1){if((c[e+(a*36&-1)+32>>2]|0)<0){i=h}else{i=h+(+g[e+(a*36&-1)+8>>2]- +g[e+(a*36&-1)>>2]+(+g[e+(a*36&-1)+12>>2]- +g[e+(a*36&-1)+4>>2]))*2.0}j=a+1|0;if((j|0)<(b|0)){h=i;a=j}else{k=i;break}}}else{k=0.0}d=k/f;return+d}function hU(a){a=a|0;var b=0,d=0;b=c[a>>2]|0;if((b|0)==-1){d=0;return d|0}d=c[(c[a+4>>2]|0)+(b*36&-1)+32>>2]|0;return d|0}function hV(a){a=a|0;return c[a+28>>2]|0}function hW(a,b){a=a|0;b=b|0;var d=0;d=c[a+12>>2]|0;bN[c[(c[d>>2]|0)+28>>2]&127](d,b,+g[a>>2]);return}function hX(a,b){a=a|0;b=b|0;var d=0;d=c[a+12>>2]|0;return bv[c[(c[d>>2]|0)+16>>2]&127](d,(c[a+8>>2]|0)+12|0,b)|0}function hY(a){a=a|0;if((a|0)==0){return}vl(a);return}function hZ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+12>>2]|0;return bI[c[(c[f>>2]|0)+20>>2]&127](f,b,d,(c[a+8>>2]|0)+12|0,e)|0}function h_(a){a=a|0;dI(a);return}function h$(a,b){a=a|0;b=b|0;dJ(a,b);return}function h0(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[23e3]|0)){a[23e3]=1}bp[c[(c[b>>2]|0)+4>>2]&511](e,b);b=c[e+4>>2]|0;f=224;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 224}function h1(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[23008]|0)){a[23008]=1}bp[c[c[b>>2]>>2]&511](e,b);b=c[e+4>>2]|0;f=136;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 136}function h2(a){a=a|0;var b=0;b=vo(168)|0;fv(b,a);return b|0}function h3(b,d){b=b|0;d=+d;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;if(!(a[22856]|0)){a[22856]=1}bN[c[(c[b>>2]|0)+8>>2]&127](f,b,d);b=c[f+4>>2]|0;g=40;c[g>>2]=c[f>>2];c[g+4>>2]=b;i=e;return 40}function h4(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+24>>2]&511](a);return}function h5(a){a=a|0;bo[c[(c[a>>2]|0)+16>>2]&511](a);return}function h6(a,b){a=a|0;b=+b;return+(+bw[c[(c[a>>2]|0)+12>>2]&127](a,b))}function h7(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+24>>2]&511](a);return}function h8(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[22960]|0)){a[22960]=1}bp[c[c[b>>2]>>2]&511](e,b);b=c[e+4>>2]|0;f=32;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 32}function h9(a,b){a=a|0;b=+b;return+(+bw[c[(c[a>>2]|0)+12>>2]&127](a,b))}function ia(a){a=a|0;bo[c[(c[a>>2]|0)+16>>2]&511](a);return}function ib(a){a=a|0;var b=0,d=0.0,e=0.0,f=0.0,h=0.0,i=0,j=0.0,k=0.0;b=c[a+52>>2]|0;d=+g[b+24>>2];e=+g[a+100>>2];f=+g[b+20>>2];h=+g[a+104>>2];i=a+76|0;j=+g[b+12>>2]+(d*e-f*h)- +g[i>>2];k=e*f+d*h+ +g[b+16>>2]- +g[i+4>>2];return+(+P(+(j*j+k*k)))}function ic(a){a=a|0;var b=0,d=0.0,e=0.0,f=0.0,h=0.0,i=0,j=0.0,k=0.0;b=c[a+48>>2]|0;d=+g[b+24>>2];e=+g[a+92>>2];f=+g[b+20>>2];h=+g[a+96>>2];i=a+68|0;j=+g[b+12>>2]+(d*e-f*h)- +g[i>>2];k=e*f+d*h+ +g[b+16>>2]- +g[i+4>>2];return+(+P(+(j*j+k*k)))}function id(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[22952]|0)){a[22952]=1}bp[c[(c[b>>2]|0)+4>>2]&511](e,b);b=c[e+4>>2]|0;f=8;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 8}function ie(b,d){b=b|0;d=+d;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;if(!(a[22824]|0)){a[22824]=1}bN[c[(c[b>>2]|0)+8>>2]&127](f,b,d);b=c[f+4>>2]|0;g=392;c[g>>2]=c[f>>2];c[g+4>>2]=b;i=e;return 392}function ig(a){a=a|0;var b=0;b=vo(196)|0;fJ(b,a);return b|0}function ih(a){a=a|0;if((a|0)==0){return}vi(c[a+32>>2]|0);vi(c[a+44>>2]|0);vi(c[a+4>>2]|0);vl(a);return}function ii(){var a=0;a=vo(60)|0;b3(a);return a|0}function ij(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=a+40|0;e=c[d>>2]|0;f=a+36|0;g=a+32|0;if((e|0)==(c[f>>2]|0)){a=c[g>>2]|0;c[f>>2]=e<<1;f=vh(e<<3)|0;c[g>>2]=f;h=a;a=c[d>>2]<<2;vp(f|0,h|0,a)|0;vi(h);i=c[d>>2]|0}else{i=e}c[(c[g>>2]|0)+(i<<2)>>2]=b;c[d>>2]=(c[d>>2]|0)+1;return}function ik(a,b,c){a=a|0;b=b|0;c=c|0;return b4(a,b,c)|0}function il(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;if(!(cn(a|0,b,d,e)|0)){return}e=a+40|0;d=c[e>>2]|0;f=a+36|0;g=a+32|0;if((d|0)==(c[f>>2]|0)){a=c[g>>2]|0;c[f>>2]=d<<1;f=vh(d<<3)|0;c[g>>2]=f;h=a;a=c[e>>2]<<2;vp(f|0,h|0,a)|0;vi(h);i=c[e>>2]|0}else{i=d}c[(c[g>>2]|0)+(i<<2)>>2]=b;c[e>>2]=(c[e>>2]|0)+1;return}function im(a,b){a=a|0;b=b|0;do{if((b|0)>-1){if((c[a+12>>2]|0)<=(b|0)){break}return(c[a+4>>2]|0)+(b*36&-1)|0}}while(0);ba(10360,159,14456,9904);return 0}function io(a,b){a=a|0;b=b|0;do{if((b|0)>-1){if((c[a+12>>2]|0)<=(b|0)){break}return c[(c[a+4>>2]|0)+(b*36&-1)+16>>2]|0}}while(0);ba(10360,153,14408,9904);return 0}function ip(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;b=c[a+12>>2]|0;if((b|0)<=0){d=0;return d|0}e=c[a+4>>2]|0;a=0;f=0;while(1){if((c[e+(a*36&-1)+32>>2]|0)<2){g=f}else{h=c[e+(a*36&-1)+24>>2]|0;if((h|0)==-1){i=429;break}j=(c[e+((c[e+(a*36&-1)+28>>2]|0)*36&-1)+32>>2]|0)-(c[e+(h*36&-1)+32>>2]|0)|0;h=(j|0)>0?j:-j|0;g=(f|0)>(h|0)?f:h}h=a+1|0;if((h|0)<(b|0)){a=h;f=g}else{d=g;i=433;break}}if((i|0)==429){ba(11392,686,14312,7360);return 0}else if((i|0)==433){return d|0}return 0}function iq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;if((b|0)<=-1){ba(10360,159,14456,9904);return 0}e=c[a+12>>2]|0;if((e|0)<=(b|0)){ba(10360,159,14456,9904);return 0}f=c[a+4>>2]|0;if((d|0)>-1&(e|0)>(d|0)){return(+g[f+(d*36&-1)>>2]- +g[f+(b*36&-1)+8>>2]>0.0|+g[f+(d*36&-1)+4>>2]- +g[f+(b*36&-1)+12>>2]>0.0|+g[f+(b*36&-1)>>2]- +g[f+(d*36&-1)+8>>2]>0.0|+g[f+(b*36&-1)+4>>2]- +g[f+(d*36&-1)+12>>2]>0.0)^1|0}else{ba(10360,159,14456,9904);return 0}return 0}function ir(b,c){b=b|0;c=c|0;a[b+102994|0]=c&1;return}function is(a){a=a|0;var b=0,d=0.0,e=0,f=0.0,h=0.0,i=0.0,j=0,k=0.0;b=c[a+102872>>2]|0;if((b|0)==-1){d=0.0;return+d}e=c[a+102876>>2]|0;f=(+g[e+(b*36&-1)+8>>2]- +g[e+(b*36&-1)>>2]+(+g[e+(b*36&-1)+12>>2]- +g[e+(b*36&-1)+4>>2]))*2.0;b=c[a+102884>>2]|0;if((b|0)>0){h=0.0;a=0;while(1){if((c[e+(a*36&-1)+32>>2]|0)<0){i=h}else{i=h+(+g[e+(a*36&-1)+8>>2]- +g[e+(a*36&-1)>>2]+(+g[e+(a*36&-1)+12>>2]- +g[e+(a*36&-1)+4>>2]))*2.0}j=a+1|0;if((j|0)<(b|0)){h=i;a=j}else{k=i;break}}}else{k=0.0}d=k/f;return+d}function it(a){a=a|0;var b=0,d=0;b=c[a+102872>>2]|0;if((b|0)==-1){d=0;return d|0}d=c[(c[a+102876>>2]|0)+(b*36&-1)+32>>2]|0;return d|0}function iu(a){a=a|0;return a+102996|0}function iv(b){b=b|0;return(a[b+102994|0]&1)!=0|0}function iw(a){a=a|0;return a+102872|0}function ix(a,b){a=a|0;b=b|0;c[a+102944>>2]=b;return}function iy(b,c){b=b|0;c=c|0;a[b+102993|0]=c&1;return}function iz(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+102968|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function iA(a){a=a|0;return c[a+102960>>2]|0}function iB(a){a=a|0;return(c[a+102868>>2]&4|0)!=0|0}function iC(b){b=b|0;return(a[b+102993|0]&1)!=0|0}function iD(a){a=a|0;return c[a+102956>>2]|0}function iE(a){a=a|0;return c[a+102952>>2]|0}function iF(a,b){a=a|0;b=b|0;c[a+102980>>2]=b;return}function iG(a){a=a|0;return c[a+102964>>2]|0}function iH(a){a=a|0;var b=0,d=0;b=c[a+102952>>2]|0;if((b|0)==0){return}else{d=b}do{g[d+76>>2]=0.0;g[d+80>>2]=0.0;g[d+84>>2]=0.0;d=c[d+96>>2]|0;}while((d|0)!=0);return}function iI(b){b=b|0;return(a[b+102992|0]&1)!=0|0}function iJ(d,e){d=d|0;e=e|0;var f=0,h=0;f=d+102976|0;if((e&1|0)==(a[f]&1|0)){return}a[f]=e&1;if(e){return}e=c[d+102952>>2]|0;if((e|0)==0){return}else{h=e}do{e=h+4|0;d=b[e>>1]|0;if((d&2)==0){b[e>>1]=d|2;g[h+144>>2]=0.0}h=c[h+96>>2]|0;}while((h|0)!=0);return}function iK(b){b=b|0;return(a[b+102976|0]&1)!=0|0}function iL(a){a=a|0;return c[a+102900>>2]|0}function iM(a){a=a|0;return(c[a+102868>>2]&2|0)!=0|0}function iN(a){a=a|0;return c[a+102932>>2]|0}function iO(a,b){a=a|0;b=b|0;c[a+102984>>2]=b;return}function iP(a,b){a=a|0;b=b|0;var d=0;d=a+102868|0;a=c[d>>2]|0;c[d>>2]=b?a|4:a&-5;return}function iQ(b){b=b|0;var d=0,e=0;if(!(a[23096]|0)){a[23096]=1}d=b+102968|0;b=c[d+4>>2]|0;e=384;c[e>>2]=c[d>>2];c[e+4>>2]=b;return 384}function iR(a){a=a|0;return c[a+102936>>2]|0}function iS(b,c){b=b|0;c=c|0;a[b+102992|0]=c&1;return}function iT(a,b){a=a|0;b=b|0;c[a+102940>>2]=b;return}function iU(a){a=a|0;return c[a+48>>2]|0}function iV(a){a=a|0;return c[a+52>>2]|0}function iW(a){a=a|0;return c[a+64>>2]|0}function iX(a){a=a|0;return a+84|0}function iY(a){a=a|0;return+(+g[a+120>>2])}function iZ(a){a=a|0;return c[a+12>>2]|0}function i_(a){a=a|0;return a+68|0}function i$(a,d){a=a|0;d=+d;var e=0,f=0,h=0,i=0;e=c[a+48>>2]|0;f=e+4|0;h=b[f>>1]|0;if((h&2)==0){b[f>>1]=h|2;g[e+144>>2]=0.0}e=c[a+52>>2]|0;h=e+4|0;f=b[h>>1]|0;if((f&2)!=0){i=a+132|0;g[i>>2]=d;return}b[h>>1]=f|2;g[e+144>>2]=0.0;i=a+132|0;g[i>>2]=d;return}function i0(a){a=a|0;return a+76|0}function i1(a){a=a|0;return+(+g[a+132>>2])}function i2(a,d){a=a|0;d=+d;var e=0,f=0,h=0,i=0;e=c[a+48>>2]|0;f=e+4|0;h=b[f>>1]|0;if((h&2)==0){b[f>>1]=h|2;g[e+144>>2]=0.0}e=c[a+52>>2]|0;h=e+4|0;f=b[h>>1]|0;if((f&2)!=0){i=a+128|0;g[i>>2]=d;return}b[h>>1]=f|2;g[e+144>>2]=0.0;i=a+128|0;g[i>>2]=d;return}function i3(d,e){d=d|0;e=e|0;var f=0,h=0,i=0,j=0;f=d+136|0;if((e&1|0)==(a[f]&1|0)){return}h=c[d+48>>2]|0;i=h+4|0;j=b[i>>1]|0;if((j&2)==0){b[i>>1]=j|2;g[h+144>>2]=0.0}h=c[d+52>>2]|0;j=h+4|0;i=b[j>>1]|0;if((i&2)==0){b[j>>1]=i|2;g[h+144>>2]=0.0}a[f]=e&1;g[d+112>>2]=0.0;return}function i4(b){b=b|0;return(a[b+137|0]&1)!=0|0}function i5(a,b){a=a|0;b=b|0;c[a+64>>2]=b;return}function i6(a){a=a|0;return+(+g[a+128>>2])}function i7(b){b=b|0;return(a[b+61|0]&1)!=0|0}function i8(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0;b=c[a+48>>2]|0;d=c[a+52>>2]|0;e=+g[a+68>>2]- +g[b+28>>2];f=+g[a+72>>2]- +g[b+32>>2];h=+g[b+24>>2];i=+g[b+20>>2];j=e*h-f*i;k=h*f+e*i;e=+g[a+76>>2]- +g[d+28>>2];f=+g[a+80>>2]- +g[d+32>>2];l=+g[d+24>>2];m=+g[d+20>>2];n=e*l-f*m;o=l*f+e*m;m=+g[a+84>>2];e=+g[a+88>>2];f=h*m-i*e;l=i*m+h*e;a=b+64|0;p=d+64|0;e=+g[b+72>>2];h=+g[d+72>>2];m=-0.0-e;return+((o+ +g[d+48>>2]-(k+ +g[b+48>>2]))*f*e+(n+ +g[d+44>>2]-(j+ +g[b+44>>2]))*l*m+(l*(+g[p+4>>2]+n*h- +g[a+4>>2]-j*e)+f*(+g[p>>2]+o*(-0.0-h)- +g[a>>2]-k*m)))}function i9(d,e){d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0;f=c[d+48>>2]|0;h=f+4|0;i=b[h>>1]|0;if((i&2)==0){b[h>>1]=i|2;g[f+144>>2]=0.0}f=c[d+52>>2]|0;i=f+4|0;h=b[i>>1]|0;if((h&2)!=0){j=d+137|0;k=e&1;a[j]=k;return}b[i>>1]=h|2;g[f+144>>2]=0.0;j=d+137|0;k=e&1;a[j]=k;return}function ja(a){a=a|0;return+(+g[a+100>>2])}function jb(a,b){a=a|0;b=+b;return+(+g[a+116>>2]*b)}function jc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=c[a+40>>2]|0;e=a+32|0;f=0;while(1){if((f|0)>=(d|0)){break}g=(c[e>>2]|0)+(f<<2)|0;if((c[g>>2]|0)==(b|0)){h=549;break}else{f=f+1|0}}if((h|0)==549){c[g>>2]=-1}g=a+28|0;c[g>>2]=(c[g>>2]|0)-1;cl(a|0,b);return}function jd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;g=a+102872|0;c[f>>2]=g;c[f+4>>2]=b;d8(g|0,f,d);i=e;return}function je(a){a=a|0;dZ(a);return}function jf(a,b){a=a|0;b=b|0;dR(a,b);return}function jg(a){a=a|0;var b=0;b=vo(103028)|0;dO(b,a);return b|0}function jh(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;dV(a,b,c,d);return}function ji(a,b){a=a|0;b=b|0;dQ(a,b);return}function jj(a,b){a=a|0;b=b|0;return dS(a,b)|0}function jk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0;f=i;i=i+32|0;h=f|0;j=f+8|0;k=a+102872|0;c[h>>2]=k;c[h+4>>2]=b;g[j+16>>2]=1.0;b=d;d=j;a=c[b+4>>2]|0;c[d>>2]=c[b>>2];c[d+4>>2]=a;a=e;e=j+8|0;d=c[a+4>>2]|0;c[e>>2]=c[a>>2];c[e+4>>2]=d;d6(k|0,h,j);i=f;return}function jl(a){a=a|0;if((a|0)==0){return}dP(a);vl(a);return}function jm(a){a=a|0;dX(a);return}function jn(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[22896]|0)){a[22896]=1}bp[c[c[b>>2]>>2]&511](e,b);b=c[e+4>>2]|0;f=376;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 376}function jo(a){a=a|0;var b=0;b=vo(256)|0;fx(b,a);return b|0}function jp(b,d){b=b|0;d=+d;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;if(!(a[22792]|0)){a[22792]=1}bN[c[(c[b>>2]|0)+8>>2]&127](f,b,d);b=c[f+4>>2]|0;g=368;c[g>>2]=c[f>>2];c[g+4>>2]=b;i=e;return 368}function jq(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+24>>2]&511](a);return}function jr(a){a=a|0;bo[c[(c[a>>2]|0)+16>>2]&511](a);return}function js(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;b=c[a+102884>>2]|0;if((b|0)<=0){d=0;return d|0}e=c[a+102876>>2]|0;a=0;f=0;while(1){if((c[e+(a*36&-1)+32>>2]|0)<2){g=f}else{h=c[e+(a*36&-1)+24>>2]|0;if((h|0)==-1){i=588;break}j=(c[e+((c[e+(a*36&-1)+28>>2]|0)*36&-1)+32>>2]|0)-(c[e+(h*36&-1)+32>>2]|0)|0;h=(j|0)>0?j:-j|0;g=(f|0)>(h|0)?f:h}h=a+1|0;if((h|0)<(b|0)){a=h;f=g}else{d=g;i=592;break}}if((i|0)==592){return d|0}else if((i|0)==588){ba(11392,686,14312,7360);return 0}return 0}function jt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;if((c[a+102868>>2]&2|0)!=0){ba(10624,109,15664,12392);return 0}d=df(a|0,152)|0;if((d|0)==0){e=0}else{f=d;dh(f,b,a);e=f}c[e+92>>2]=0;f=a+102952|0;c[e+96>>2]=c[f>>2];b=c[f>>2]|0;if((b|0)!=0){c[b+92>>2]=e}c[f>>2]=e;f=a+102960|0;c[f>>2]=(c[f>>2]|0)+1;return e|0}function ju(a){a=a|0;return 1}function jv(a,b){a=a|0;b=b|0;return 0}function jw(a){a=a|0;var b=0,d=0.0,e=0.0,f=0.0,h=0.0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0;b=c[a+48>>2]|0;d=+g[b+24>>2];e=+g[a+68>>2];f=+g[b+20>>2];h=+g[a+72>>2];i=c[a+52>>2]|0;j=+g[i+24>>2];k=+g[a+76>>2];l=+g[i+20>>2];m=+g[a+80>>2];n=+g[a+84>>2];o=+g[a+88>>2];return+((+g[i+12>>2]+(j*k-l*m)-(+g[b+12>>2]+(d*e-f*h)))*(d*n-f*o)+(k*l+j*m+ +g[i+16>>2]-(e*f+d*h+ +g[b+16>>2]))*(f*n+d*o))}function jx(a){a=a|0;return c[a+4>>2]|0}function jy(b){b=b|0;return(a[b+136|0]&1)!=0|0}function jz(a){a=a|0;return+(+g[a+124>>2])}function jA(a){a=a|0;var d=0;if((b[(c[a+48>>2]|0)+4>>1]&32)==0){d=0;return d|0}d=(b[(c[a+52>>2]|0)+4>>1]&32)!=0;return d|0}function jB(a){a=a|0;return c[a+4>>2]|0}function jC(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function jD(a){a=a|0;return+(+g[a+8>>2])}function jE(a,b){a=a|0;b=b|0;return a+12|0}function jF(a,b){a=a|0;b=b|0;return a+12|0}function jG(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+12|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function jH(a){a=a|0;return a+12|0}function jI(a){a=a|0;return c[a+48>>2]|0}function jJ(a){a=a|0;return c[a+52>>2]|0}function jK(a){a=a|0;return c[a+64>>2]|0}function jL(a){a=a|0;return a+92|0}function jM(a,b){a=a|0;b=+b;g[a+72>>2]=b;return}function jN(a){a=a|0;return c[a+12>>2]|0}function jO(a){a=a|0;return+(+g[a+68>>2])}function jP(a){a=a|0;return a+76|0}function jQ(a,d){a=a|0;d=+d;var e=0,f=0,h=0,i=0;e=c[a+48>>2]|0;f=e+4|0;h=b[f>>1]|0;if((h&2)==0){b[f>>1]=h|2;g[e+144>>2]=0.0}e=c[a+52>>2]|0;h=e+4|0;f=b[h>>1]|0;if((f&2)!=0){i=a+124|0;g[i>>2]=d;return}b[h>>1]=f|2;g[e+144>>2]=0.0;i=a+124|0;g[i>>2]=d;return}function jR(a){a=a|0;return a+84|0}function jS(a){a=a|0;return+(+g[a+124>>2])}function jT(a,b){a=a|0;b=+b;return+(+g[a+112>>2]*b)}function jU(b){b=b|0;return(a[b+128|0]&1)!=0|0}function jV(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0;b=c[a+48>>2]|0;d=c[a+52>>2]|0;e=+g[b+24>>2];f=+g[a+76>>2];h=+g[b+20>>2];i=+g[a+80>>2];j=+g[d+24>>2];k=+g[a+84>>2];l=+g[d+20>>2];m=+g[a+88>>2];n=+g[a+92>>2];o=+g[a+96>>2];return+((+g[d+12>>2]+(j*k-l*m)-(+g[b+12>>2]+(e*f-h*i)))*(e*n-h*o)+(k*l+j*m+ +g[d+16>>2]-(f*h+e*i+ +g[b+16>>2]))*(h*n+e*o))}function jW(a,b){a=a|0;b=b|0;c[a+64>>2]=b;return}function jX(a){a=a|0;return+(+g[a+72>>2])}function jY(a,d){a=a|0;d=+d;var e=0,f=0,h=0,i=0;e=c[a+48>>2]|0;f=e+4|0;h=b[f>>1]|0;if((h&2)==0){b[f>>1]=h|2;g[e+144>>2]=0.0}e=c[a+52>>2]|0;h=e+4|0;f=b[h>>1]|0;if((f&2)!=0){i=a+120|0;g[i>>2]=d;return}b[h>>1]=f|2;g[e+144>>2]=0.0;i=a+120|0;g[i>>2]=d;return}function jZ(b){b=b|0;return(a[b+61|0]&1)!=0|0}function j_(a){a=a|0;return+(+g[(c[a+52>>2]|0)+72>>2]- +g[(c[a+48>>2]|0)+72>>2])}function j$(d,e){d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0;f=c[d+48>>2]|0;h=f+4|0;i=b[h>>1]|0;if((i&2)==0){b[h>>1]=i|2;g[f+144>>2]=0.0}f=c[d+52>>2]|0;i=f+4|0;h=b[i>>1]|0;if((h&2)!=0){j=d+128|0;k=e&1;a[j]=k;return}b[i>>1]=h|2;g[f+144>>2]=0.0;j=d+128|0;k=e&1;a[j]=k;return}function j0(a){a=a|0;return+(+g[a+120>>2])}function j1(a){a=a|0;return c[a+4>>2]|0}function j2(a,b){a=a|0;b=+b;g[a+68>>2]=b;return}function j3(a){a=a|0;var d=0;if((b[(c[a+48>>2]|0)+4>>1]&32)==0){d=0;return d|0}d=(b[(c[a+52>>2]|0)+4>>1]&32)!=0;return d|0}function j4(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;c[d>>2]=c[d>>2]|b;return}function j5(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;c[d>>2]=c[d>>2]&(b^-1);return}function j6(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function j7(a){a=a|0;return c[a+4>>2]|0}function j8(a){a=a|0;return c[a+12>>2]|0}function j9(a){a=a|0;return c[a+48>>2]|0}function ka(a){a=a|0;return c[a+52>>2]|0}function kb(a){a=a|0;return c[a+64>>2]|0}function kc(a){a=a|0;return c[a+4>>2]|0}function kd(a,b){a=a|0;b=b|0;c[a+64>>2]=b;return}function ke(b){b=b|0;return(a[b+61|0]&1)!=0|0}function kf(a){a=a|0;var d=0;if((b[(c[a+48>>2]|0)+4>>1]&32)==0){d=0;return d|0}d=(b[(c[a+52>>2]|0)+4>>1]&32)!=0;return d|0}function kg(a){a=a|0;return c[a+68>>2]|0}function kh(a){a=a|0;return c[a+72>>2]|0}function ki(a,b){a=a|0;b=+b;return+(+bw[c[(c[a>>2]|0)+12>>2]&127](a,b))}function kj(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[22888]|0)){a[22888]=1}bp[c[(c[b>>2]|0)+4>>2]&511](e,b);b=c[e+4>>2]|0;f=360;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 360}function kk(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+4>>2]&511](a);return}function kl(a,b,d){a=a|0;b=b|0;d=+d;bN[c[(c[a>>2]|0)+28>>2]&127](a,b,d);return}function km(a,b){a=a|0;b=b|0;return bF[c[(c[a>>2]|0)+8>>2]&255](a,b)|0}function kn(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;return bI[c[(c[a>>2]|0)+20>>2]&127](a,b,d,e,f)|0}function ko(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bO[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);return}function kp(a){a=a|0;return bq[c[(c[a>>2]|0)+12>>2]&1023](a)|0}function kq(a,b,d){a=a|0;b=b|0;d=d|0;return bv[c[(c[a>>2]|0)+16>>2]&127](a,b,d)|0}function kr(){var a=0;a=vo(20)|0;c[a>>2]=20136;vq(a+4|0,0,16);return a|0}function ks(a,b){a=a|0;b=b|0;aT(a|0,b|0);return}function kt(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[22984]|0)){a[22984]=1}bp[c[(c[b>>2]|0)+4>>2]&511](e,b);b=c[e+4>>2]|0;f=352;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 352}function ku(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[22992]|0)){a[22992]=1}bp[c[c[b>>2]>>2]&511](e,b);b=c[e+4>>2]|0;f=344;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 344}function kv(a){a=a|0;var b=0;b=vo(224)|0;gn(b,a);return b|0}function kw(b,d){b=b|0;d=+d;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;if(!(a[22848]|0)){a[22848]=1}bN[c[(c[b>>2]|0)+8>>2]&127](f,b,d);b=c[f+4>>2]|0;g=336;c[g>>2]=c[f>>2];c[g+4>>2]=b;i=e;return 336}function kx(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+24>>2]&511](a);return}function ky(a){a=a|0;bo[c[(c[a>>2]|0)+16>>2]&511](a);return}function kz(a,b){a=a|0;b=+b;return+(+bw[c[(c[a>>2]|0)+12>>2]&127](a,b))}function kA(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+4>>2]&511](a);return}function kB(a,b){a=a|0;b=b|0;bp[c[(c[a>>2]|0)+28>>2]&511](a,b);return}function kC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bO[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e);return}function kD(a,b,d,e,f){a=a|0;b=b|0;d=+d;e=e|0;f=f|0;bn[c[(c[a>>2]|0)+20>>2]&63](a,b,d,e,f);return}function kE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bO[c[(c[a>>2]|0)+12>>2]&127](a,b,d,e);return}function kF(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;br[c[(c[a>>2]|0)+16>>2]&63](a,b,d,e);return}function kG(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bO[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);return}function kH(){var a=0;a=vo(8)|0;c[a>>2]=19368;c[a+4>>2]=0;return a|0}function kI(a,b){a=a|0;b=+b;return+(+bw[c[(c[a>>2]|0)+12>>2]&127](a,b))}function kJ(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[23112]|0)){a[23112]=1}bp[c[c[b>>2]>>2]&511](e,b);b=c[e+4>>2]|0;f=328;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 328}function kK(a){a=a|0;bo[c[(c[a>>2]|0)+16>>2]&511](a);return}function kL(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[23104]|0)){a[23104]=1}bp[c[(c[b>>2]|0)+4>>2]&511](e,b);b=c[e+4>>2]|0;f=320;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 320}function kM(b,d){b=b|0;d=+d;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;if(!(a[22968]|0)){a[22968]=1}bN[c[(c[b>>2]|0)+8>>2]&127](f,b,d);b=c[f+4>>2]|0;g=304;c[g>>2]=c[f>>2];c[g+4>>2]=b;i=e;return 304}function kN(a){a=a|0;var b=0;b=vo(276)|0;e6(b,a);return b|0}function kO(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[23056]|0)){a[23056]=1}bp[c[c[b>>2]>>2]&511](e,b);b=c[e+4>>2]|0;f=296;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 296}function kP(a,b){a=a|0;b=+b;return+(+bw[c[(c[a>>2]|0)+12>>2]&127](a,b))}function kQ(a,d,e){a=a|0;d=+d;e=+e;var f=0,h=0,i=0,j=0;if(d>e){ba(6832,575,17248,11440)}f=a+120|0;do{if(+g[f>>2]==d){if(+g[a+124>>2]!=e){break}return}}while(0);h=c[a+48>>2]|0;i=h+4|0;j=b[i>>1]|0;if((j&2)==0){b[i>>1]=j|2;g[h+144>>2]=0.0}h=c[a+52>>2]|0;j=h+4|0;i=b[j>>1]|0;if((i&2)==0){b[j>>1]=i|2;g[h+144>>2]=0.0}g[f>>2]=d;g[a+124>>2]=e;g[a+112>>2]=0.0;return}function kR(a){a=a|0;return c[a+4>>2]|0}function kS(a){a=a|0;return c[a+64>>2]|0}function kT(a){a=a|0;return c[a+52>>2]|0}function kU(b){b=b|0;return(a[b+61|0]&1)!=0|0}function kV(a,b){a=a|0;b=b|0;c[a+64>>2]=b;return}function kW(a){a=a|0;return c[a+48>>2]|0}function kX(a){a=a|0;return c[a+12>>2]|0}function kY(a){a=a|0;var d=0;if((b[(c[a+48>>2]|0)+4>>1]&32)==0){d=0;return d|0}d=(b[(c[a+52>>2]|0)+4>>1]&32)!=0;return d|0}function kZ(a){a=a|0;return+(+g[a+152>>2])}function k_(a){a=a|0;var b=0,d=0;b=c[a>>2]|0;if((b|0)==-1){d=0;return d|0}d=c[(c[a+4>>2]|0)+(b*36&-1)+32>>2]|0;return d|0}function k$(a){a=a|0;var b=0,d=0.0,e=0,f=0.0,h=0.0,i=0.0,j=0,k=0.0;b=c[a>>2]|0;if((b|0)==-1){d=0.0;return+d}e=c[a+4>>2]|0;f=(+g[e+(b*36&-1)+8>>2]- +g[e+(b*36&-1)>>2]+(+g[e+(b*36&-1)+12>>2]- +g[e+(b*36&-1)+4>>2]))*2.0;b=c[a+12>>2]|0;if((b|0)>0){h=0.0;a=0;while(1){if((c[e+(a*36&-1)+32>>2]|0)<0){i=h}else{i=h+(+g[e+(a*36&-1)+8>>2]- +g[e+(a*36&-1)>>2]+(+g[e+(a*36&-1)+12>>2]- +g[e+(a*36&-1)+4>>2]))*2.0}j=a+1|0;if((j|0)<(b|0)){h=i;a=j}else{k=i;break}}}else{k=0.0}d=k/f;return+d}function k0(a){a=a|0;return c[a+48>>2]|0}function k1(a){a=a|0;return c[a+52>>2]|0}function k2(a,b){a=a|0;b=+b;g[a+68>>2]=b;return}function k3(a){a=a|0;return c[a+64>>2]|0}function k4(a,b){a=a|0;b=b|0;c[a+64>>2]=b;return}function k5(a){a=a|0;return c[a+12>>2]|0}function k6(a){a=a|0;return a+80|0}function k7(a){a=a|0;return a+88|0}function k8(a){a=a|0;return+(+g[a+68>>2])}function k9(a){a=a|0;return+(+g[a+72>>2])}function la(b){b=b|0;return(a[b+61|0]&1)!=0|0}function lb(a){a=a|0;return+(+g[a+96>>2])}function lc(a){a=a|0;return c[a+4>>2]|0}function ld(a,b){a=a|0;b=+b;g[a+72>>2]=b;return}function le(a){a=a|0;var d=0;if((b[(c[a+48>>2]|0)+4>>1]&32)==0){d=0;return d|0}d=(b[(c[a+52>>2]|0)+4>>1]&32)!=0;return d|0}function lf(a){a=a|0;return c[a+48>>2]|0}function lg(a){a=a|0;return c[a+52>>2]|0}function lh(a){a=a|0;return c[a+64>>2]|0}function li(a){a=a|0;return+(+g[a+120>>2])}function lj(a){a=a|0;return c[a+12>>2]|0}function lk(a){a=a|0;return a+68|0}function ll(a,d){a=a|0;d=+d;var e=0,f=0,h=0,i=0;e=c[a+48>>2]|0;f=e+4|0;h=b[f>>1]|0;if((h&2)==0){b[f>>1]=h|2;g[e+144>>2]=0.0}e=c[a+52>>2]|0;h=e+4|0;f=b[h>>1]|0;if((f&2)!=0){i=a+108|0;g[i>>2]=d;return}b[h>>1]=f|2;g[e+144>>2]=0.0;i=a+108|0;g[i>>2]=d;return}function lm(a){a=a|0;return a+76|0}function ln(a){a=a|0;return+(+g[(c[a+52>>2]|0)+56>>2]- +g[(c[a+48>>2]|0)+56>>2]- +g[a+116>>2])}function lo(a){a=a|0;return+(+g[a+108>>2])}function lp(a,b){a=a|0;b=+b;return+(+g[a+96>>2]*b)}function lq(b){b=b|0;return(a[b+112|0]&1)!=0|0}function lr(a){a=a|0;bo[c[(c[a>>2]|0)+16>>2]&511](a);return}function ls(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+24>>2]&511](a);return}function lt(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[23048]|0)){a[23048]=1}bp[c[(c[b>>2]|0)+4>>2]&511](e,b);b=c[e+4>>2]|0;f=288;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 288}function lu(b,d){b=b|0;d=+d;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;if(!(a[22880]|0)){a[22880]=1}bN[c[(c[b>>2]|0)+8>>2]&127](f,b,d);b=c[f+4>>2]|0;g=280;c[g>>2]=c[f>>2];c[g+4>>2]=b;i=e;return 280}function lv(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;return+(+bG[c[(c[a>>2]|0)+8>>2]&63](a,b,d,e,f))}function lw(){var a=0;a=vo(4)|0;c[a>>2]=19608;return a|0}function lx(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+4>>2]&511](a);return}function ly(a){a=a|0;if((a|0)==0){return}vi(c[a+4>>2]|0);vl(a);return}function lz(){var a=0,b=0,d=0,e=0,f=0,g=0;a=vo(28)|0;b=a;c[a>>2]=-1;c[a+12>>2]=16;c[a+8>>2]=0;d=vh(576)|0;e=d;c[a+4>>2]=e;vq(d|0,0,576);f=0;while(1){g=f+1|0;c[e+(f*36&-1)+20>>2]=g;c[e+(f*36&-1)+32>>2]=-1;if((g|0)<15){f=g}else{break}}c[d+560>>2]=-1;c[d+572>>2]=-1;c[a+16>>2]=0;c[a+20>>2]=0;c[a+24>>2]=0;return b|0}function lA(a){a=a|0;ct(a);return}function lB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0;e=cj(a)|0;f=a+4|0;h=(c[f>>2]|0)+(e*36&-1)|0;i=+(+g[b+4>>2]+-.10000000149011612);g[h>>2]=+g[b>>2]+-.10000000149011612;g[h+4>>2]=i;h=(c[f>>2]|0)+(e*36&-1)+8|0;i=+(+g[b+12>>2]+.10000000149011612);g[h>>2]=+g[b+8>>2]+.10000000149011612;g[h+4>>2]=i;c[(c[f>>2]|0)+(e*36&-1)+16>>2]=d;c[(c[f>>2]|0)+(e*36&-1)+32>>2]=0;ck(a,e);return e|0}function lC(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return cn(a,b,c,d)|0}function lD(a){a=a|0;cs(a);return}function lE(a,b){a=a|0;b=b|0;cl(a,b);return}function lF(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[23016]|0)){a[23016]=1}bp[c[(c[b>>2]|0)+4>>2]&511](e,b);b=c[e+4>>2]|0;f=272;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 272}function lG(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[23024]|0)){a[23024]=1}bp[c[c[b>>2]>>2]&511](e,b);b=c[e+4>>2]|0;f=264;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 264}function lH(b,d){b=b|0;d=+d;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;if(!(a[22864]|0)){a[22864]=1}bN[c[(c[b>>2]|0)+8>>2]&127](f,b,d);b=c[f+4>>2]|0;g=256;c[g>>2]=c[f>>2];c[g+4>>2]=b;i=e;return 256}function lI(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+24>>2]&511](a);return}function lJ(a){a=a|0;bo[c[(c[a>>2]|0)+16>>2]&511](a);return}function lK(a,b){a=a|0;b=+b;return+(+bw[c[(c[a>>2]|0)+12>>2]&127](a,b))}function lL(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[22912]|0)){a[22912]=1}bp[c[c[b>>2]>>2]&511](e,b);b=c[e+4>>2]|0;f=248;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 248}function lM(a,b){a=a|0;b=+b;if(b==b&!(C=0.0,C!=C)&b>+-p&b<+p){g[a+152>>2]=b;return}else{ba(7384,398,18616,6992)}}function lN(a,b){a=a|0;b=b|0;do{if((b|0)>-1){if((c[a+12>>2]|0)<=(b|0)){break}return(c[a+4>>2]|0)+(b*36&-1)|0}}while(0);ba(10360,159,14456,9904);return 0}function lO(a,b){a=a|0;b=b|0;do{if((b|0)>-1){if((c[a+12>>2]|0)<=(b|0)){break}return c[(c[a+4>>2]|0)+(b*36&-1)+16>>2]|0}}while(0);ba(10360,153,14408,9904);return 0}function lP(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;b=c[a+12>>2]|0;if((b|0)<=0){d=0;return d|0}e=c[a+4>>2]|0;a=0;f=0;while(1){if((c[e+(a*36&-1)+32>>2]|0)<2){g=f}else{h=c[e+(a*36&-1)+24>>2]|0;if((h|0)==-1){i=891;break}j=(c[e+((c[e+(a*36&-1)+28>>2]|0)*36&-1)+32>>2]|0)-(c[e+(h*36&-1)+32>>2]|0)|0;h=(j|0)>0?j:-j|0;g=(f|0)>(h|0)?f:h}h=a+1|0;if((h|0)<(b|0)){a=h;f=g}else{d=g;i=896;break}}if((i|0)==891){ba(11392,686,14312,7360);return 0}else if((i|0)==896){return d|0}return 0}function lQ(b){b=b|0;var d=0,e=0,f=0,h=0;d=vo(208)|0;e=d;c[e>>2]=19312;f=c[b+8>>2]|0;h=c[b+12>>2]|0;if((f|0)!=(h|0)){c[d+4>>2]=c[b>>2];c[d+8>>2]=0;c[d+12>>2]=0;c[d+48>>2]=f;c[d+52>>2]=h;c[d+56>>2]=0;a[d+61|0]=a[b+16|0]&1;a[d+60|0]=0;c[d+64>>2]=c[b+4>>2];vq(d+16|0,0,32);c[e>>2]=20344;e=b+20|0;h=d+80|0;f=c[e+4>>2]|0;c[h>>2]=c[e>>2];c[h+4>>2]=f;f=b+28|0;h=d+88|0;e=c[f+4>>2]|0;c[h>>2]=c[f>>2];c[h+4>>2]=e;g[d+96>>2]=+g[b+36>>2];g[d+68>>2]=+g[b+40>>2];g[d+72>>2]=+g[b+44>>2];g[d+104>>2]=0.0;g[d+108>>2]=0.0;g[d+112>>2]=0.0;return d|0}ba(7272,173,15744,9072);return 0}function lR(b){b=b|0;var d=0,e=0,f=0,h=0;d=vo(228)|0;e=d;c[e>>2]=19312;f=c[b+8>>2]|0;h=c[b+12>>2]|0;if((f|0)!=(h|0)){c[d+4>>2]=c[b>>2];c[d+8>>2]=0;c[d+12>>2]=0;c[d+48>>2]=f;c[d+52>>2]=h;c[d+56>>2]=0;a[d+61|0]=a[b+16|0]&1;a[d+60|0]=0;c[d+64>>2]=c[b+4>>2];vq(d+16|0,0,32);c[e>>2]=19768;e=b+20|0;h=d+68|0;f=c[e+4>>2]|0;c[h>>2]=c[e>>2];c[h+4>>2]=f;f=b+28|0;h=d+76|0;e=c[f+4>>2]|0;c[h>>2]=c[f>>2];c[h+4>>2]=e;g[d+116>>2]=+g[b+36>>2];vq(d+84|0,0,16);g[d+120>>2]=+g[b+44>>2];g[d+124>>2]=+g[b+48>>2];g[d+104>>2]=+g[b+60>>2];g[d+108>>2]=+g[b+56>>2];a[d+112|0]=a[b+40|0]&1;a[d+100|0]=a[b+52|0]&1;c[d+224>>2]=0;return d|0}ba(7272,173,15744,9072);return 0}function lS(a){a=a|0;return}function lT(a){a=a|0;return+0.0}function lU(d,e){d=d|0;e=e|0;var f=0,h=0,i=0,j=0;f=d+112|0;if((e&1|0)==(a[f]&1|0)){return}h=c[d+48>>2]|0;i=h+4|0;j=b[i>>1]|0;if((j&2)==0){b[i>>1]=j|2;g[h+144>>2]=0.0}h=c[d+52>>2]|0;j=h+4|0;i=b[j>>1]|0;if((i&2)==0){b[j>>1]=i|2;g[h+144>>2]=0.0}a[f]=e&1;g[d+92>>2]=0.0;return}function lV(b){b=b|0;return(a[b+100|0]&1)!=0|0}function lW(a,b){a=a|0;b=b|0;c[a+64>>2]=b;return}function lX(a,d){a=a|0;d=+d;var e=0,f=0,h=0,i=0;e=c[a+48>>2]|0;f=e+4|0;h=b[f>>1]|0;if((h&2)==0){b[f>>1]=h|2;g[e+144>>2]=0.0}e=c[a+52>>2]|0;h=e+4|0;f=b[h>>1]|0;if((f&2)!=0){i=a+104|0;g[i>>2]=d;return}b[h>>1]=f|2;g[e+144>>2]=0.0;i=a+104|0;g[i>>2]=d;return}function lY(b){b=b|0;return(a[b+61|0]&1)!=0|0}function lZ(a){a=a|0;return+(+g[(c[a+52>>2]|0)+72>>2]- +g[(c[a+48>>2]|0)+72>>2])}function l_(d,e){d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0;f=c[d+48>>2]|0;h=f+4|0;i=b[h>>1]|0;if((i&2)==0){b[h>>1]=i|2;g[f+144>>2]=0.0}f=c[d+52>>2]|0;i=f+4|0;h=b[i>>1]|0;if((h&2)!=0){j=d+100|0;k=e&1;a[j]=k;return}b[i>>1]=h|2;g[f+144>>2]=0.0;j=d+100|0;k=e&1;a[j]=k;return}function l$(a){a=a|0;return+(+g[a+116>>2])}function l0(a){a=a|0;return+(+g[a+104>>2])}function l1(a){a=a|0;return c[a+4>>2]|0}function l2(a){a=a|0;return+(+g[a+124>>2])}function l3(a){a=a|0;var d=0;if((b[(c[a+48>>2]|0)+4>>1]&32)==0){d=0;return d|0}d=(b[(c[a+52>>2]|0)+4>>1]&32)!=0;return d|0}function l4(a){a=a|0;return c[a+4>>2]|0}function l5(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function l6(a){a=a|0;return+(+g[a+8>>2])}function l7(a){a=a|0;return c[a+12>>2]|0}function l8(a){a=a|0;return c[a+16>>2]|0}function l9(b,d){b=b|0;d=d|0;var e=0,f=0;e=d;d=b+20|0;f=c[e+4>>2]|0;c[d>>2]=c[e>>2];c[d+4>>2]=f;a[b+36|0]=1;return}function ma(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function mb(b,d){b=b|0;d=d|0;var e=0,f=0;e=d;d=b+28|0;f=c[e+4>>2]|0;c[d>>2]=c[e>>2];c[d+4>>2]=f;a[b+37|0]=1;return}function mc(a,b){a=a|0;b=b|0;c[a+16>>2]=b;return}function md(a){a=a|0;return c[a+12>>2]|0}function me(a){a=a|0;return+(+g[a+84>>2])}function mf(a){a=a|0;return c[a+48>>2]|0}function mg(b){b=b|0;return(a[b+61|0]&1)!=0|0}function mh(a){a=a|0;return c[a+64>>2]|0}function mi(a){a=a|0;return c[a+4>>2]|0}function mj(a){a=a|0;return c[a+52>>2]|0}function mk(a){a=a|0;return a+68|0}function ml(a,b){a=a|0;b=+b;g[a+84>>2]=b;return}function mm(a){a=a|0;return a+76|0}function mn(a,b){a=a|0;b=b|0;c[a+64>>2]=b;return}function mo(b,d){b=b|0;d=+d;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;if(!(a[22800]|0)){a[22800]=1}bN[c[(c[b>>2]|0)+8>>2]&127](f,b,d);b=c[f+4>>2]|0;g=240;c[g>>2]=c[f>>2];c[g+4>>2]=b;i=e;return 240}function mp(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+24>>2]&511](a);return}function mq(a){a=a|0;bo[c[(c[a>>2]|0)+16>>2]&511](a);return}function mr(a,b){a=a|0;b=+b;return+(+bw[c[(c[a>>2]|0)+12>>2]&127](a,b))}function ms(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[22904]|0)){a[22904]=1}bp[c[(c[b>>2]|0)+4>>2]&511](e,b);b=c[e+4>>2]|0;f=232;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 232}function mt(){return vo(1)|0}function mu(a){a=a|0;if((a|0)==0){return}vl(a|0);return}function mv(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+4>>2]&511](a);return}function mw(){var a=0;a=vo(4)|0;c[a>>2]=19640;return a|0}function mx(a,b){a=a|0;b=b|0;bp[c[(c[a>>2]|0)+12>>2]&511](a,b);return}function my(a,b){a=a|0;b=b|0;bp[c[(c[a>>2]|0)+8>>2]&511](a,b);return}function mz(a,b,d){a=a|0;b=b|0;d=d|0;bL[c[(c[a>>2]|0)+16>>2]&127](a,b,d);return}function mA(a,b,d){a=a|0;b=b|0;d=d|0;bL[c[(c[a>>2]|0)+20>>2]&127](a,b,d);return}function mB(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+4>>2]&511](a);return}function mC(a,b,d){a=a|0;b=b|0;d=+d;bN[c[(c[a>>2]|0)+28>>2]&127](a,b,d);return}function mD(a,b){a=a|0;b=b|0;return bF[c[(c[a>>2]|0)+8>>2]&255](a,b)|0}function mE(a,b,c){a=a|0;b=b|0;c=c|0;cX(a,b,c);return}function mF(){var b=0;b=vo(40)|0;c[b>>2]=20296;c[b+4>>2]=3;g[b+8>>2]=.009999999776482582;c[b+12>>2]=0;c[b+16>>2]=0;a[b+36|0]=0;a[b+37|0]=0;return b|0}function mG(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bO[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);return}function mH(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;return bI[c[(c[a>>2]|0)+20>>2]&127](a,b,d,e,f)|0}function mI(a){a=a|0;return bq[c[(c[a>>2]|0)+12>>2]&1023](a)|0}function mJ(a,b,d){a=a|0;b=b|0;d=d|0;return bv[c[(c[a>>2]|0)+16>>2]&127](a,b,d)|0}function mK(a,b){a=a|0;b=b|0;return bF[c[(c[a>>2]|0)+8>>2]&255](a,b)|0}function mL(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+4>>2]&511](a);return}function mM(){var a=0;a=vo(4)|0;c[a>>2]=19824;return a|0}function mN(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;if((a|0)==0){return}b=a+4|0;d=a|0;e=c[d>>2]|0;if((c[b>>2]|0)>0){f=0;g=e;while(1){vi(c[g+(f<<3)+4>>2]|0);h=f+1|0;i=c[d>>2]|0;if((h|0)<(c[b>>2]|0)){f=h;g=i}else{j=i;break}}}else{j=e}vi(j);vl(a);return}function mO(a){a=a|0;var b=0,d=0,e=0;b=a+4|0;d=a|0;if((c[b>>2]|0)>0){e=0;do{vi(c[(c[d>>2]|0)+(e<<3)+4>>2]|0);e=e+1|0;}while((e|0)<(c[b>>2]|0))}c[b>>2]=0;vq(c[d>>2]|0,0,c[a+8>>2]<<3|0);vq(a+12|0,0,56);return}function mP(a,b){a=a|0;b=b|0;return df(a,b)|0}function mQ(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+24>>2]&511](a);return}function mR(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[23040]|0)){a[23040]=1}bp[c[c[b>>2]>>2]&511](e,b);b=c[e+4>>2]|0;f=216;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 216}function mS(a,b){a=a|0;b=+b;return+(+bw[c[(c[a>>2]|0)+12>>2]&127](a,b))}function mT(a){a=a|0;bo[c[(c[a>>2]|0)+16>>2]&511](a);return}function mU(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[23032]|0)){a[23032]=1}bp[c[(c[b>>2]|0)+4>>2]&511](e,b);b=c[e+4>>2]|0;f=208;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 208}function mV(a,d,e){a=a|0;d=+d;e=+e;var f=0,h=0,i=0,j=0;if(d>e){ba(6488,473,17496,11440)}f=a+120|0;do{if(+g[f>>2]==d){if(+g[a+124>>2]!=e){break}return}}while(0);h=c[a+48>>2]|0;i=h+4|0;j=b[i>>1]|0;if((j&2)==0){b[i>>1]=j|2;g[h+144>>2]=0.0}h=c[a+52>>2]|0;j=h+4|0;i=b[j>>1]|0;if((i&2)==0){b[j>>1]=i|2;g[h+144>>2]=0.0}g[a+92>>2]=0.0;g[f>>2]=d;g[a+124>>2]=e;return}function mW(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=b+12|0;if((c[f>>2]|0)!=0){ba(6208,48,18448,11256)}g=b+16|0;if((c[g>>2]|0)!=0){ba(6208,48,18448,11256)}if((e|0)>1){c[g>>2]=e;h=vh(e<<3)|0;c[f>>2]=h;f=d;d=c[g>>2]<<3;vp(h|0,f|0,d)|0;a[b+36|0]=0;a[b+37|0]=0;return}else{ba(6208,49,18448,6736)}}function mX(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=b+12|0;if((c[f>>2]|0)!=0){ba(6208,34,18504,11256)}g=b+16|0;if((c[g>>2]|0)!=0){ba(6208,34,18504,11256)}if((e|0)>2){h=e+1|0;c[g>>2]=h;i=vh(h<<3)|0;c[f>>2]=i;h=d;d=e<<3;vp(i|0,h|0,d)|0;d=c[f>>2]|0;h=d;i=d+(e<<3)|0;e=c[h+4>>2]|0;c[i>>2]=c[h>>2];c[i+4>>2]=e;e=c[f>>2]|0;f=e+((c[g>>2]|0)-2<<3)|0;g=b+20|0;i=c[f+4>>2]|0;c[g>>2]=c[f>>2];c[g+4>>2]=i;i=e+8|0;e=b+28|0;g=c[i+4>>2]|0;c[e>>2]=c[i>>2];c[e+4>>2]=g;a[b+36|0]=1;a[b+37|0]=1;return}else{ba(6208,35,18504,5016)}}function mY(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;if((e|0)==0){return}if((e|0)<=0){ba(5352|0,164,17448|0,8376|0)}if((e|0)>640){vi(d);return}f=a[e+22064|0]|0;if((f&255)>=14){ba(5352|0,173,17448|0,6544|0)}e=b+12+((f&255)<<2)|0;c[d>>2]=c[e>>2];c[e>>2]=d;return}function mZ(){var b=0,d=0,e=0,f=0,g=0,h=0,i=0;b=vo(68)|0;d=b;c[b+8>>2]=128;c[b+4>>2]=0;e=vh(1024)|0;c[b>>2]=e;vq(e|0,0,1024);vq(b+12|0,0,56);if((a[22056]&1)==0){f=0;g=1}else{return d|0}while(1){if((f|0)>=14){h=1080;break}if((g|0)>(c[22712+(f<<2)>>2]|0)){b=f+1|0;a[g+22064|0]=b&255;i=b}else{a[g+22064|0]=f&255;i=f}b=g+1|0;if((b|0)<641){f=i;g=b}else{h=1086;break}}if((h|0)==1080){ba(5352,73,17368,10976);return 0}else if((h|0)==1086){a[22056]=1;return d|0}return 0}function m_(a){a=a|0;return c[a+164>>2]|0}function m$(a){a=a|0;var d=0;if((b[(c[a+48>>2]|0)+4>>1]&32)==0){d=0;return d|0}d=(b[(c[a+52>>2]|0)+4>>1]&32)!=0;return d|0}function m0(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function m1(a){a=a|0;return+(+g[a+8>>2])}function m2(a,b){a=a|0;b=b|0;return a+20+(b<<3)|0}function m3(a,b,d){a=a|0;b=+b;d=+d;var e=0.0,f=0.0;c[a+148>>2]=4;e=-0.0-b;f=-0.0-d;g[a+20>>2]=e;g[a+24>>2]=f;g[a+28>>2]=b;g[a+32>>2]=f;g[a+36>>2]=b;g[a+40>>2]=d;g[a+44>>2]=e;g[a+48>>2]=d;g[a+84>>2]=0.0;g[a+88>>2]=-1.0;g[a+92>>2]=1.0;g[a+96>>2]=0.0;g[a+100>>2]=0.0;g[a+104>>2]=1.0;g[a+108>>2]=-1.0;g[a+112>>2]=0.0;g[a+12>>2]=0.0;g[a+16>>2]=0.0;return}function m4(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+12|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function m5(a,b){a=a|0;b=b|0;c[a+148>>2]=b;return}function m6(a){a=a|0;return c[a+148>>2]|0}function m7(a){a=a|0;return c[a+4>>2]|0}function m8(a){a=a|0;return c[a+148>>2]|0}function m9(a){a=a|0;return a+12|0}function na(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;f=d;d=b+12|0;g=c[f+4>>2]|0;c[d>>2]=c[f>>2];c[d+4>>2]=g;g=e;e=b+20|0;d=c[g+4>>2]|0;c[e>>2]=c[g>>2];c[e+4>>2]=d;a[b+44|0]=0;a[b+45|0]=0;return}function nb(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function nc(a){a=a|0;return+(+g[a+8>>2])}function nd(a){a=a|0;return c[a+4>>2]|0}function ne(a){a=a|0;return c[a+12>>2]|0}function nf(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;a=c[d>>2]|0;c[d>>2]=b?a|4:a&-5;return}function ng(a){a=a|0;return+(+g[a+140>>2])}function nh(a){a=a|0;return+(+g[a+136>>2])}function ni(a){a=a|0;return(c[a+4>>2]&2|0)!=0|0}function nj(a){a=a|0;return(c[a+4>>2]&4|0)!=0|0}function nk(a){a=a|0;return c[a+52>>2]|0}function nl(a,b){a=a|0;b=+b;g[a+136>>2]=b;return}function nm(a){a=a|0;return c[a+48>>2]|0}function nn(a){a=a|0;return c[a+56>>2]|0}function no(a){a=a|0;return c[a+60>>2]|0}function np(a,b){a=a|0;b=+b;g[a+140>>2]=b;return}function nq(a){a=a|0;return a+64|0}function nr(a){a=a|0;var b=0.0,d=0.0;b=+g[(c[a+48>>2]|0)+20>>2];d=+g[(c[a+52>>2]|0)+20>>2];g[a+140>>2]=b>d?b:d;return}function ns(a){a=a|0;return+(+g[a+8>>2])}function nt(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function nu(a){a=a|0;return c[a+4>>2]|0}function nv(a){a=a|0;return+(+g[a+56>>2])}function nw(a){a=a|0;return c[a+148>>2]|0}function nx(a){a=a|0;return(b[a+4>>1]&4)!=0|0}function ny(a,b){a=a|0;b=+b;g[a+136>>2]=b;return}function nz(a,b){a=a|0;b=+b;g[a+140>>2]=b;return}function nA(a,b){a=a|0;b=b|0;c[a+148>>2]=b;return}function nB(a){a=a|0;return+(+g[a+72>>2])}function nC(a){a=a|0;return c[a+100>>2]|0}function nD(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,h=0;if((c[a>>2]|0)!=2){return}f=a+4|0;h=b[f>>1]|0;if((h&2)==0){b[f>>1]=h|2;g[a+144>>2]=0.0}h=d|0;f=a+76|0;g[f>>2]=+g[h>>2]+ +g[f>>2];f=d+4|0;d=a+80|0;g[d>>2]=+g[f>>2]+ +g[d>>2];d=a+84|0;g[d>>2]=+g[d>>2]+((+g[e>>2]- +g[a+44>>2])*+g[f>>2]-(+g[e+4>>2]- +g[a+48>>2])*+g[h>>2]);return}function nE(b,c){b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;if(!(a[23088]|0)){a[23088]=1}d=+g[c>>2]- +g[b+12>>2];e=+g[c+4>>2]- +g[b+16>>2];f=+g[b+24>>2];h=+g[b+20>>2];i=+(f*e+d*(-0.0-h));b=192;g[b>>2]=d*f+e*h;g[b+4>>2]=i;return 192}function nF(a,d){a=a|0;d=d|0;var e=0.0,f=0.0,h=0,i=0;if((c[a>>2]|0)==0){return}e=+g[d>>2];f=+g[d+4>>2];do{if(e*e+f*f>0.0){h=a+4|0;i=b[h>>1]|0;if((i&2)!=0){break}b[h>>1]=i|2;g[a+144>>2]=0.0}}while(0);i=d;d=a+64|0;a=c[i+4>>2]|0;c[d>>2]=c[i>>2];c[d+4>>2]=a;return}function nG(a){a=a|0;return c[a+108>>2]|0}function nH(b){b=b|0;var d=0,e=0;if(!(a[22976]|0)){a[22976]=1}d=b+64|0;b=c[d+4>>2]|0;e=184;c[e>>2]=c[d>>2];c[e+4>>2]=b;return 184}function nI(a){a=a|0;return c[a+96>>2]|0}function nJ(a,c){a=a|0;c=c|0;var d=0,e=0;d=a+4|0;e=b[d>>1]|0;if(c){b[d>>1]=e|4;return}c=e&-5;b[d>>1]=c;if((e&2)!=0){return}b[d>>1]=c|2;g[a+144>>2]=0.0;return}function nK(a){a=a|0;return+(+g[a+116>>2])}function nL(a,d){a=a|0;d=+d;var e=0,f=0;if((c[a>>2]|0)==0){return}do{if(d*d>0.0){e=a+4|0;f=b[e>>1]|0;if((f&2)!=0){break}b[e>>1]=f|2;g[a+144>>2]=0.0}}while(0);g[a+72>>2]=d;return}function nM(a,b){a=a|0;b=b|0;var d=0,e=0,f=0.0,h=0.0;d=a+116|0;g[b>>2]=+g[d>>2];e=a+28|0;f=+g[e>>2];h=+g[a+32>>2];g[b+12>>2]=+g[a+124>>2]+ +g[d>>2]*(f*f+h*h);d=e;e=b+4|0;b=c[d+4>>2]|0;c[e>>2]=c[d>>2];c[e+4>>2]=b;return}function nN(b,c){b=b|0;c=c|0;var d=0.0,e=0.0,f=0;if(!(a[22776]|0)){a[22776]=1}d=+g[b+72>>2];e=+(d*(+g[c>>2]- +g[b+44>>2])+ +g[b+68>>2]);f=176;g[f>>2]=+g[b+64>>2]+(+g[c+4>>2]- +g[b+48>>2])*(-0.0-d);g[f+4>>2]=e;return 176}function nO(b,d){b=b|0;d=+d;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;if(!(a[22872]|0)){a[22872]=1}bN[c[(c[b>>2]|0)+8>>2]&127](f,b,d);b=c[f+4>>2]|0;g=200;c[g>>2]=c[f>>2];c[g+4>>2]=b;i=e;return 200}function nP(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+4>>2]&511](a);return}function nQ(a,b,c){a=a|0;b=b|0;c=c|0;dc(a,b,c);return}function nR(a,b,d){a=a|0;b=b|0;d=+d;bN[c[(c[a>>2]|0)+28>>2]&127](a,b,d);return}function nS(a,b){a=a|0;b=b|0;return bF[c[(c[a>>2]|0)+8>>2]&255](a,b)|0}function nT(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;return bI[c[(c[a>>2]|0)+20>>2]&127](a,b,d,e,f)|0}function nU(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;cW(a,b,c,d,e);return}function nV(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bO[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);return}function nW(a){a=a|0;return bq[c[(c[a>>2]|0)+12>>2]&1023](a)|0}function nX(a,b,d){a=a|0;b=b|0;d=d|0;return bv[c[(c[a>>2]|0)+16>>2]&127](a,b,d)|0}function nY(){var a=0;a=vo(152)|0;c[a>>2]=20032;c[a+4>>2]=2;g[a+8>>2]=.009999999776482582;c[a+148>>2]=0;g[a+12>>2]=0.0;g[a+16>>2]=0.0;return a|0}function nZ(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+4>>2]&511](a);return}function n_(a,b,d){a=a|0;b=b|0;d=+d;bN[c[(c[a>>2]|0)+28>>2]&127](a,b,d);return}function n$(a,b){a=a|0;b=b|0;return bF[c[(c[a>>2]|0)+8>>2]&255](a,b)|0}function n0(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;return bI[c[(c[a>>2]|0)+20>>2]&127](a,b,d,e,f)|0}function n1(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bO[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);return}function n2(a){a=a|0;return bq[c[(c[a>>2]|0)+12>>2]&1023](a)|0}function n3(a,b,d){a=a|0;b=b|0;d=d|0;return bv[c[(c[a>>2]|0)+16>>2]&127](a,b,d)|0}function n4(){var a=0;a=vo(48)|0;c[a>>2]=20512;c[a+4>>2]=1;g[a+8>>2]=.009999999776482582;vq(a+28|0,0,18);return a|0}function n5(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[a+48>>2]|0;e=c[a+52>>2]|0;cd(b,a+64|0,(c[d+8>>2]|0)+12|0,+g[(c[d+12>>2]|0)+8>>2],(c[e+8>>2]|0)+12|0,+g[(c[e+12>>2]|0)+8>>2]);return}function n6(a){a=a|0;g[a+136>>2]=+P(+(+g[(c[a+48>>2]|0)+16>>2]*+g[(c[a+52>>2]|0)+16>>2]));return}function n7(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bO[c[c[a>>2]>>2]&127](a,b,d,e);return}function n8(a,b,d){a=a|0;b=b|0;d=+d;bN[c[(c[a>>2]|0)+28>>2]&127](a,b,d);return}function n9(a,b){a=a|0;b=b|0;return bF[c[(c[a>>2]|0)+8>>2]&255](a,b)|0}function oa(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;return bI[c[(c[a>>2]|0)+20>>2]&127](a,b,d,e,f)|0}function ob(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bO[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);return}function oc(a){a=a|0;return bq[c[(c[a>>2]|0)+12>>2]&1023](a)|0}function od(a,b,d){a=a|0;b=b|0;d=d|0;return bv[c[(c[a>>2]|0)+16>>2]&127](a,b,d)|0}function oe(a,b){a=a|0;b=b|0;dt(a,b);return}function of(a,b,c){a=a|0;b=b|0;c=+c;ds(a,b,c);return}function og(a){a=a|0;dj(a);return}function oh(b){b=b|0;var d=0,e=0,f=0,h=0;d=vo(168)|0;e=d;c[e>>2]=19312;f=c[b+8>>2]|0;h=c[b+12>>2]|0;if((f|0)!=(h|0)){c[d+4>>2]=c[b>>2];c[d+8>>2]=0;c[d+12>>2]=0;c[d+48>>2]=f;c[d+52>>2]=h;c[d+56>>2]=0;a[d+61|0]=a[b+16|0]&1;a[d+60|0]=0;c[d+64>>2]=c[b+4>>2];vq(d+16|0,0,32);c[e>>2]=20400;e=b+20|0;h=d+68|0;f=c[e+4>>2]|0;c[h>>2]=c[e>>2];c[h+4>>2]=f;f=b+28|0;h=d+76|0;e=c[f+4>>2]|0;c[h>>2]=c[f>>2];c[h+4>>2]=e;g[d+84>>2]=+g[b+36>>2];g[d+160>>2]=0.0;g[d+92>>2]=0.0;c[d+164>>2]=0;g[d+88>>2]=0.0;return d|0}ba(7272,173,15744,9072);return 0}function oi(a,d){a=a|0;d=d|0;var e=0,f=0;if((c[a>>2]|0)!=2){return}e=a+4|0;f=b[e>>1]|0;if((f&2)==0){b[e>>1]=f|2;g[a+144>>2]=0.0}f=a+76|0;g[f>>2]=+g[d>>2]+ +g[f>>2];f=a+80|0;g[f>>2]=+g[d+4>>2]+ +g[f>>2];return}function oj(a,d){a=a|0;d=+d;var e=0,f=0;if((c[a>>2]|0)!=2){return}e=a+4|0;f=b[e>>1]|0;if((f&2)==0){b[e>>1]=f|2;g[a+144>>2]=0.0}f=a+84|0;g[f>>2]=+g[f>>2]+d;return}function ok(a){a=a|0;return(b[a+4>>1]&2)!=0|0}function ol(a){a=a|0;return a+12|0}function om(a){a=a|0;return a+44|0}function on(a){a=a|0;return+(+g[a+136>>2])}function oo(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,h=0,i=0.0,j=0.0;if((c[a>>2]|0)!=2){return}f=a+4|0;h=b[f>>1]|0;if((h&2)==0){b[f>>1]=h|2;g[a+144>>2]=0.0}i=+g[a+120>>2];h=d|0;f=d+4|0;j=i*+g[f>>2];d=a+64|0;g[d>>2]=i*+g[h>>2]+ +g[d>>2];d=a+68|0;g[d>>2]=j+ +g[d>>2];d=a+72|0;g[d>>2]=+g[d>>2]+ +g[a+128>>2]*((+g[e>>2]- +g[a+44>>2])*+g[f>>2]-(+g[e+4>>2]- +g[a+48>>2])*+g[h>>2]);return}function op(a){a=a|0;return(b[a+4>>1]&16)!=0|0}function oq(a){a=a|0;return a+28|0}function or(b,c){b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;if(!(a[23064]|0)){a[23064]=1}d=+g[b+24>>2];e=+g[c>>2];f=+g[b+20>>2];h=+g[c+4>>2];i=+(e*f+d*h);c=168;g[c>>2]=d*e-f*h;g[c+4>>2]=i;return 168}function os(b,c){b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;if(!(a[22784]|0)){a[22784]=1}d=+g[b+24>>2];e=+g[c>>2];f=+g[b+20>>2];h=+g[c+4>>2];i=+g[b+72>>2];j=+(i*(+g[b+12>>2]+(d*e-f*h)- +g[b+44>>2])+ +g[b+68>>2]);c=160;g[c>>2]=+g[b+64>>2]+(e*f+d*h+ +g[b+16>>2]- +g[b+48>>2])*(-0.0-i);g[c+4>>2]=j;return 160}function ot(a){a=a|0;return c[a+112>>2]|0}function ou(b,c){b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;if(!(a[23080]|0)){a[23080]=1}d=+g[b+24>>2];e=+g[c>>2];f=+g[b+20>>2];h=+g[c+4>>2];i=+(e*f+d*h+ +g[b+16>>2]);c=152;g[c>>2]=+g[b+12>>2]+(d*e-f*h);g[c+4>>2]=i;return 152}function ov(a){a=a|0;return+(+g[a+132>>2])}function ow(a){a=a|0;return(b[a+4>>1]&8)!=0|0}function ox(a){a=a|0;return c[a+88>>2]|0}function oy(b,c){b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;if(!(a[23072]|0)){a[23072]=1}d=+g[b+24>>2];e=+g[c>>2];f=+g[b+20>>2];h=+g[c+4>>2];i=+(e*(-0.0-f)+d*h);c=144;g[c>>2]=d*e+f*h;g[c+4>>2]=i;return 144}function oz(a,b){a=a|0;b=+b;g[a+132>>2]=b;return}function oA(a,c){a=a|0;c=c|0;var d=0;d=a+4|0;a=b[d>>1]|0;b[d>>1]=c?a|8:a&-9;return}function oB(a){a=a|0;return c[a>>2]|0}function oC(a){a=a|0;return+(+g[a+140>>2])}function oD(a){a=a|0;var b=0.0,c=0.0;b=+g[a+28>>2];c=+g[a+32>>2];return+(+g[a+124>>2]+ +g[a+116>>2]*(b*b+c*c))}function oE(a){a=a|0;return(b[a+4>>1]&32)!=0|0}function oF(a,d){a=a|0;d=+d;var e=0,f=0;if((c[a>>2]|0)!=2){return}e=a+4|0;f=b[e>>1]|0;if((f&2)==0){b[e>>1]=f|2;g[a+144>>2]=0.0}f=a+72|0;g[f>>2]=+g[f>>2]+ +g[a+128>>2]*d;return}function oG(a){a=a|0;return a+12|0}function oH(a){a=a|0;return+(+g[a+96>>2])}function oI(b){b=b|0;return(a[b+61|0]&1)!=0|0}function oJ(a){a=a|0;return c[a+64>>2]|0}function oK(a){a=a|0;return c[a+4>>2]|0}function oL(a){a=a|0;return c[a+52>>2]|0}function oM(a){a=a|0;return a+68|0}function oN(a){a=a|0;return a+76|0}function oO(a,b){a=a|0;b=b|0;c[a+64>>2]=b;return}function oP(a){a=a|0;return c[a+48>>2]|0}function oQ(a){a=a|0;return c[a+12>>2]|0}function oR(a){a=a|0;return+(+g[a+100>>2])}function oS(a){a=a|0;var d=0;if((b[(c[a+48>>2]|0)+4>>1]&32)==0){d=0;return d|0}d=(b[(c[a+52>>2]|0)+4>>1]&32)!=0;return d|0}function oT(a){a=a|0;return c[a+102408>>2]|0}function oU(a,c){a=a|0;c=c|0;b[a+2>>1]=c;return}function oV(a,c){a=a|0;c=c|0;b[a>>1]=c;return}function oW(a){a=a|0;return b[a+4>>1]|0}function oX(a,b){a=a|0;b=b|0;di(a,b);return}function oY(a,b){a=a|0;b=b|0;return dk(a,b)|0}function oZ(d,e,f){d=d|0;e=e|0;f=+f;var h=0,j=0;h=i;i=i+32|0;j=h|0;b[j+22>>1]=1;b[j+24>>1]=-1;b[j+26>>1]=0;c[j+4>>2]=0;g[j+8>>2]=.20000000298023224;g[j+12>>2]=0.0;a[j+20|0]=0;c[j>>2]=e;g[j+16>>2]=f;e=dk(d,j)|0;i=h;return e|0}function o_(a,b){a=a|0;b=b|0;dr(a,b);return}function o$(a,c){a=a|0;c=c|0;var d=0,e=0;d=a+4|0;e=b[d>>1]|0;if(!c){b[d>>1]=e&-3;g[a+144>>2]=0.0;vq(a+64|0,0,24);return}if((e&2)!=0){return}b[d>>1]=e|2;g[a+144>>2]=0.0;return}function o0(a){a=a|0;dn(a);return}function o1(a,b){a=a|0;b=b|0;dq(a,b);return}function o2(a,c){a=a|0;c=c|0;var d=0,e=0;d=a+4|0;e=b[d>>1]|0;b[d>>1]=c?e|16:e&-17;dj(a);return}function o3(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[22928]|0)){a[22928]=1}bp[c[c[b>>2]>>2]&511](e,b);b=c[e+4>>2]|0;f=128;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 128}function o4(a,b){a=a|0;b=+b;return+(+bw[c[(c[a>>2]|0)+12>>2]&127](a,b))}function o5(a){a=a|0;bo[c[(c[a>>2]|0)+16>>2]&511](a);return}function o6(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+24>>2]&511](a);return}function o7(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+8|0;e=d|0;if(!(a[22920]|0)){a[22920]=1}bp[c[(c[b>>2]|0)+4>>2]&511](e,b);b=c[e+4>>2]|0;f=120;c[f>>2]=c[e>>2];c[f+4>>2]=b;i=d;return 120}function o8(b,d){b=b|0;d=+d;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;if(!(a[22808]|0)){a[22808]=1}bN[c[(c[b>>2]|0)+8>>2]&127](f,b,d);b=c[f+4>>2]|0;g=112;c[g>>2]=c[f>>2];c[g+4>>2]=b;i=e;return 112}function o9(){var a=0;a=vo(102800)|0;c[a+102400>>2]=0;c[a+102404>>2]=0;c[a+102408>>2]=0;c[a+102796>>2]=0;return a|0}function pa(a,b){a=a|0;b=b|0;dg(a,b);return}function pb(a){a=a|0;if((a|0)==0){return}bo[c[(c[a>>2]|0)+4>>2]&511](a);return}function pc(a,b){a=a|0;b=b|0;bp[c[(c[a>>2]|0)+8>>2]&511](a,b);return}function pd(){var a=0;a=vo(4)|0;c[a>>2]=19576;return a|0}function pe(a){a=a|0;if((a|0)==0){return}vl(a);return}function pf(a,b){a=a|0;b=+b;do{if(b==b&!(C=0.0,C!=C)&b>+-p){if(!(b<+p&b>=0.0)){break}g[a+100>>2]=b;return}}while(0);ba(7624,228,17552,9328)}function pg(a,b){a=a|0;b=+b;do{if(b==b&!(C=0.0,C!=C)&b>+-p){if(!(b<+p&b>=0.0)){break}g[a+96>>2]=b;return}}while(0);ba(7624,217,17600,11752)}function ph(b){b=b|0;var d=0,e=0,f=0,h=0;d=vo(180)|0;e=d;c[e>>2]=19312;f=c[b+8>>2]|0;h=c[b+12>>2]|0;if((f|0)!=(h|0)){c[d+4>>2]=c[b>>2];c[d+8>>2]=0;c[d+12>>2]=0;c[d+48>>2]=f;c[d+52>>2]=h;c[d+56>>2]=0;a[d+61|0]=a[b+16|0]&1;a[d+60|0]=0;c[d+64>>2]=c[b+4>>2];vq(d+16|0,0,32);c[e>>2]=19856;e=b+20|0;h=d+68|0;f=c[e+4>>2]|0;c[h>>2]=c[e>>2];c[h+4>>2]=f;f=b+28|0;h=d+76|0;e=c[f+4>>2]|0;c[h>>2]=c[f>>2];c[h+4>>2]=e;g[d+84>>2]=0.0;g[d+88>>2]=0.0;g[d+92>>2]=0.0;g[d+96>>2]=+g[b+36>>2];g[d+100>>2]=+g[b+40>>2];return d|0}ba(7272,173,15744,9072);return 0}function pi(a){a=a|0;if((a|0)==0){return}if((c[a+102400>>2]|0)!=0){ba(4840,32,17e3,10664)}if((c[a+102796>>2]|0)==0){vl(a|0);return}else{ba(4840,33,17e3,7952)}}function pj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;e=b+102796|0;f=c[e>>2]|0;if((f|0)>=32){ba(4840,38,17040,6448);return 0}g=b+102412+(f*12&-1)|0;c[b+102412+(f*12&-1)+4>>2]=d;h=b+102400|0;i=c[h>>2]|0;if((i+d|0)>102400){c[g>>2]=vh(d)|0;a[b+102412+(f*12&-1)+8|0]=1}else{c[g>>2]=b+i;a[b+102412+(f*12&-1)+8|0]=0;c[h>>2]=(c[h>>2]|0)+d}h=b+102404|0;f=(c[h>>2]|0)+d|0;c[h>>2]=f;h=b+102408|0;b=c[h>>2]|0;c[h>>2]=(b|0)>(f|0)?b:f;c[e>>2]=(c[e>>2]|0)+1;return c[g>>2]|0}function pk(a,c){a=a|0;c=c|0;b[a+4>>1]=c;return}function pl(a){a=a|0;return b[a+2>>1]|0}function pm(a){a=a|0;return b[a>>1]|0}function pn(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+20|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function po(a,b){a=a|0;b=b|0;return c[a+8>>2]|0}function pp(a,b){a=a|0;b=b|0;return c[a+12>>2]|0}function pq(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+28|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function pr(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function ps(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function pt(a){a=a|0;return+(+g[a+36>>2])}function pu(a){a=a|0;return a+20|0}function pv(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function pw(a){a=a|0;return a+28|0}function px(b,c){b=b|0;c=c|0;return(a[b+16|0]&1)!=0|0}function py(a,b){a=a|0;b=+b;g[a+40>>2]=b;return}function pz(b,c){b=b|0;c=c|0;a[b+16|0]=c&1;return}function pA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0,j=0.0,k=0.0,l=0.0,m=0.0;c[a+8>>2]=b;c[a+12>>2]=d;f=e|0;h=+g[f>>2]- +g[b+12>>2];i=e+4|0;j=+g[i>>2]- +g[b+16>>2];k=+g[b+24>>2];l=+g[b+20>>2];b=a+20|0;m=+(k*j+h*(-0.0-l));g[b>>2]=h*k+j*l;g[b+4>>2]=m;m=+g[f>>2]- +g[d+12>>2];l=+g[i>>2]- +g[d+16>>2];j=+g[d+24>>2];k=+g[d+20>>2];d=a+28|0;h=+(j*l+m*(-0.0-k));g[d>>2]=m*j+l*k;g[d+4>>2]=h;return}function pB(a){a=a|0;return+(+g[a+40>>2])}function pC(a){a=a|0;return+(+g[a+28>>2])}function pD(b){b=b|0;return(a[b+37|0]&1)!=0|0}function pE(a){a=a|0;return c[a>>2]|0}function pF(b){b=b|0;return(a[b+36|0]&1)!=0|0}function pG(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+4|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function pH(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+16|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function pI(b){b=b|0;return(a[b+39|0]&1)!=0|0}function pJ(a){a=a|0;return c[a+44>>2]|0}function pK(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function pL(b,c){b=b|0;c=c|0;a[b+38|0]=c&1;return}function pM(b,c){b=b|0;c=c|0;a[b+36|0]=c&1;return}function pN(a){a=a|0;return+(+g[a+48>>2])}function pO(a,b){a=a|0;b=+b;g[a+24>>2]=b;return}function pP(a,b){a=a|0;b=b|0;c[a+44>>2]=b;return}function pQ(a){a=a|0;return a+4|0}function pR(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function pS(a,b){a=a|0;b=+b;g[a+48>>2]=b;return}function pT(a){a=a|0;return+(+g[a+32>>2])}function pU(b,c){b=b|0;c=c|0;a[b+39|0]=c&1;return}function pV(b,c){b=b|0;c=c|0;a[b+40|0]=c&1;return}function pW(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function pX(a){a=a|0;return+(+g[a+12>>2])}function pY(a){a=a|0;return+(+g[a+24>>2])}function pZ(a){a=a|0;return a+16|0}function p_(b){b=b|0;return(a[b+40|0]&1)!=0|0}function p$(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function p0(b){b=b|0;return(a[b+38|0]&1)!=0|0}function p1(b,c){b=b|0;c=c|0;a[b+37|0]=c&1;return}function p2(a,b){a=a|0;b=+b;g[a>>2]=b;return}function p3(a,b,c){a=a|0;b=+b;c=+c;g[a>>2]=b;g[a+4>>2]=c;return}function p4(a){a=a|0;return+(+g[a>>2])}function p5(a){a=a|0;return+(+g[a+4>>2])}function p6(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function p7(a){a=a|0;var b=0.0,c=0;b=+g[a>>2];if(!(b==b&!(C=0.0,C!=C)&b>+-p&b<+p)){c=0;return c|0}b=+g[a+4>>2];if(!(b==b&!(C=0.0,C!=C)&b>+-p)){c=0;return c|0}c=b<+p;return c|0}function p8(b){b=b|0;var c=0.0,d=0;if(!(a[23168]|0)){a[23168]=1}c=+(+g[b>>2]);d=104;g[d>>2]=-0.0- +g[b+4>>2];g[d+4>>2]=c;return 104}function p9(a){a=a|0;var b=0.0,c=0.0;b=+g[a>>2];c=+g[a+4>>2];return+(b*b+c*c)}function qa(a,b){a=a|0;b=b|0;var c=0;c=a|0;g[c>>2]=+g[b>>2]+ +g[c>>2];c=a+4|0;g[c>>2]=+g[b+4>>2]+ +g[c>>2];return}function qb(a){a=a|0;g[a>>2]=0.0;g[a+4>>2]=0.0;return}function qc(a,b){a=a|0;b=+b;var c=0;c=a|0;g[c>>2]=+g[c>>2]*b;c=a+4|0;g[c>>2]=+g[c>>2]*b;return}function qd(b){b=b|0;var c=0.0,d=0;if(!(a[23160]|0)){a[23160]=1}c=+(-0.0- +g[b+4>>2]);d=96;g[d>>2]=-0.0- +g[b>>2];g[d+4>>2]=c;return 96}function qe(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function qf(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;return}function qg(a){a=a|0;return+(+g[a+8>>2])}function qh(a,b){a=a|0;b=b|0;var c=0;c=a|0;g[c>>2]=+g[b>>2]+ +g[c>>2];c=a+4|0;g[c>>2]=+g[b+4>>2]+ +g[c>>2];c=a+8|0;g[c>>2]=+g[b+8>>2]+ +g[c>>2];return}function qi(a){a=a|0;g[a>>2]=0.0;g[a+4>>2]=0.0;g[a+8>>2]=0.0;return}function qj(a,b){a=a|0;b=+b;var c=0;c=a|0;g[c>>2]=+g[c>>2]*b;c=a+4|0;g[c>>2]=+g[c>>2]*b;c=a+8|0;g[c>>2]=+g[c>>2]*b;return}function qk(b){b=b|0;var c=0.0,d=0.0;if(!(a[23152]|0)){a[23152]=1}c=-0.0- +g[b+4>>2];d=-0.0- +g[b+8>>2];g[20]=-0.0- +g[b>>2];g[21]=c;g[22]=d;return 80}function ql(a){a=a|0;return+(+g[a+24>>2])}function qm(a,b){a=a|0;b=+b;g[a+24>>2]=b;return}function qn(a){a=a|0;return c[a+16>>2]|0}function qo(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0;d=c[a+16>>2]|0;e=c[a+20>>2]|0;if((e|0)<=1){f=0;h=d+(f<<3)|0;return h|0}i=+g[b+4>>2];j=+g[b>>2];k=i*+g[d+4>>2]+j*+g[d>>2];b=1;a=0;while(1){l=j*+g[d+(b<<3)>>2]+i*+g[d+(b<<3)+4>>2];m=l>k;n=m?b:a;o=b+1|0;if((o|0)<(e|0)){k=m?l:k;b=o;a=n}else{f=n;break}}h=d+(f<<3)|0;return h|0}function qp(a){a=a|0;return c[a+20>>2]|0}function qq(a){a=a|0;return c[a+20>>2]|0}function qr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0,m=0,n=0;d=c[a+16>>2]|0;e=c[a+20>>2]|0;if((e|0)<=1){f=0;return f|0}h=+g[b+4>>2];i=+g[b>>2];j=h*+g[d+4>>2]+i*+g[d>>2];b=1;a=0;while(1){k=i*+g[d+(b<<3)>>2]+h*+g[d+(b<<3)+4>>2];l=k>j;m=l?b:a;n=b+1|0;if((n|0)<(e|0)){j=l?k:j;b=n;a=m}else{f=m;break}}return f|0}function qs(a,b){a=a|0;b=b|0;c[a+16>>2]=b;return}function qt(a,b){a=a|0;b=b|0;c[a+20>>2]=b;return}function qu(b){b=b|0;return(a[b+20|0]&1)!=0|0}function qv(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function qw(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function qx(a){a=a|0;return+(+g[a+16>>2])}function qy(a){a=a|0;return c[a>>2]|0}function qz(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function qA(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function qB(a){a=a|0;return+(+g[a+12>>2])}function qC(b,c){b=b|0;c=c|0;a[b+20|0]=c&1;return}function qD(a){a=a|0;return a+22|0}function qE(a){a=a|0;return+(+g[a+8>>2])}function qF(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function qG(a){a=a|0;return c[a+4>>2]|0}function qH(){var a=0;a=vo(6)|0;b[a>>1]=1;b[a+2>>1]=-1;b[a+4>>1]=0;return a|0}function qI(a){a=a|0;if((a|0)==0){return}vl(a);return}function qJ(){var a=0;a=vo(44)|0;vq(a|0,0,17);c[a>>2]=9;vq(a+20|0,0,24);return a|0}function qK(){var b=0;b=vo(52)|0;c[b+44>>2]=0;vq(b+4|0,0,32);a[b+36|0]=1;a[b+37|0]=1;a[b+38|0]=0;a[b+39|0]=0;c[b>>2]=0;a[b+40|0]=1;g[b+48>>2]=1.0;return b|0}function qL(a){a=a|0;if((a|0)==0){return}vl(a);return}function qM(a){a=a|0;var b=0,c=0.0,d=0,e=0.0,f=0.0,h=0.0,i=0.0;b=a|0;c=+g[b>>2];d=a+4|0;e=+g[d>>2];f=+P(+(c*c+e*e));if(f<1.1920928955078125e-7){h=0.0;return+h}i=1.0/f;g[b>>2]=c*i;g[d>>2]=e*i;h=f;return+h}function qN(){return vo(8)|0}function qO(a,b){a=+a;b=+b;var c=0;c=vo(8)|0;g[c>>2]=a;g[c+4>>2]=b;return c|0}function qP(a){a=a|0;var b=0.0,c=0.0;b=+g[a>>2];c=+g[a+4>>2];return+(+P(+(b*b+c*c)))}function qQ(a){a=a|0;if((a|0)==0){return}vl(a);return}function qR(a){a=a|0;if((a|0)==0){return}vl(a);return}function qS(){return vo(12)|0}function qT(a,b,c){a=+a;b=+b;c=+c;var d=0;d=vo(12)|0;g[d>>2]=a;g[d+4>>2]=b;g[d+8>>2]=c;return d|0}function qU(a,b,c){a=a|0;b=b|0;c=c|0;cf(a,b,c);return}function qV(){var a=0;a=vo(28)|0;c[a+16>>2]=0;c[a+20>>2]=0;g[a+24>>2]=0.0;return a|0}function qW(a){a=a|0;if((a|0)==0){return}vl(a);return}function qX(a){a=a|0;if((a|0)==0){return}vl(a);return}function qY(){var d=0;d=vo(28)|0;b[d+22>>1]=1;b[d+24>>1]=-1;b[d+26>>1]=0;c[d>>2]=0;c[d+4>>2]=0;g[d+8>>2]=.20000000298023224;g[d+12>>2]=0.0;g[d+16>>2]=0.0;a[d+20|0]=0;return d|0}function qZ(a,c){a=a|0;c=c|0;var d=0;d=a+22|0;a=c;b[d>>1]=b[a>>1]|0;b[d+2>>1]=b[a+2>>1]|0;b[d+4>>1]=b[a+4>>1]|0;return}function q_(a,b){a=a|0;b=b|0;do{if((b|0)>-1){if((c[a+20>>2]|0)<=(b|0)){break}return(c[a+16>>2]|0)+(b<<3)|0}}while(0);ba(7536,103,13816,6368);return 0}function q$(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+20|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function q0(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+28|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function q1(a){a=a|0;return+(+g[a+68>>2])}function q2(b){b=b|0;return(a[b+60|0]&1)!=0|0}function q3(a){a=a|0;return+(+g[a+44>>2])}function q4(b,c){b=b|0;c=c|0;a[b+48|0]=c&1;return}function q5(a,b){a=a|0;b=+b;g[a+68>>2]=b;return}function q6(a){a=a|0;return a+36|0}function q7(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function q8(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function q9(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0.0,j=0,k=0.0,l=0.0,m=0,n=0.0,o=0,p=0.0;c[a+8>>2]=b;c[a+12>>2]=d;h=e|0;i=+g[h>>2]- +g[b+12>>2];j=e+4|0;k=+g[j>>2]- +g[b+16>>2];e=b+24|0;l=+g[e>>2];m=b+20|0;n=+g[m>>2];o=a+20|0;p=+(l*k+i*(-0.0-n));g[o>>2]=i*l+k*n;g[o+4>>2]=p;p=+g[h>>2]- +g[d+12>>2];n=+g[j>>2]- +g[d+16>>2];k=+g[d+24>>2];l=+g[d+20>>2];j=a+28|0;i=+(k*n+p*(-0.0-l));g[j>>2]=p*k+n*l;g[j+4>>2]=i;i=+g[e>>2];l=+g[f>>2];n=+g[m>>2];k=+g[f+4>>2];f=a+36|0;p=+(l*(-0.0-n)+i*k);g[f>>2]=i*l+n*k;g[f+4>>2]=p;g[a+44>>2]=+g[d+56>>2]- +g[b+56>>2];return}function ra(a,b){a=a|0;b=+b;g[a+52>>2]=b;return}function rb(a){a=a|0;return+(+g[a+56>>2])}function rc(b){b=b|0;return(a[b+48|0]&1)!=0|0}function rd(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function re(a){a=a|0;return a+20|0}function rf(a){a=a|0;return a+28|0}function rg(b,c){b=b|0;c=c|0;return(a[b+16|0]&1)!=0|0}function rh(a,b){a=a|0;b=b|0;return c[a+8>>2]|0}function ri(a,b){a=a|0;b=b|0;return c[a+12>>2]|0}function rj(a,b){a=a|0;b=+b;g[a+56>>2]=b;return}function rk(a){a=a|0;return+(+g[a+64>>2])}function rl(a,b){a=a|0;b=+b;g[a+64>>2]=b;return}function rm(b,c){b=b|0;c=c|0;a[b+60|0]=c&1;return}function rn(b,c){b=b|0;c=c|0;a[b+16|0]=c&1;return}function ro(a){a=a|0;return+(+g[a+52>>2])}function rp(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+36|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function rq(b){b=b|0;var c=0.0,d=0;if(!(a[23136]|0)){a[23136]=1}c=+(+g[b+4>>2]);d=72;g[d>>2]=-0.0- +g[b>>2];g[d+4>>2]=c;return 72}function rr(b){b=b|0;var c=0.0,d=0;if(!(a[23144]|0)){a[23144]=1}c=+(+g[b>>2]);d=64;g[d>>2]=+g[b+4>>2];g[d+4>>2]=c;return 64}function rs(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function rt(a){a=a|0;g[a>>2]=0.0;g[a+4>>2]=1.0;return}function ru(a){a=a|0;return+(+g[a+4>>2])}function rv(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+20|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function rw(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+28|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function rx(a){a=a|0;return+(+g[a+52>>2])}function ry(a,b){a=a|0;b=+b;g[a+48>>2]=b;return}function rz(a,b){a=a|0;b=+b;g[a+56>>2]=b;return}function rA(a,b){a=a|0;b=+b;g[a+52>>2]=b;return}function rB(a){a=a|0;return a+36|0}function rC(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function rD(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function rE(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0.0,j=0,k=0.0,l=0.0,m=0,n=0.0,o=0.0;c[a+8>>2]=b;c[a+12>>2]=d;h=e|0;i=+g[h>>2]- +g[b+12>>2];j=e+4|0;k=+g[j>>2]- +g[b+16>>2];e=b+24|0;l=+g[e>>2];m=b+20|0;n=+g[m>>2];b=a+20|0;o=+(l*k+i*(-0.0-n));g[b>>2]=i*l+k*n;g[b+4>>2]=o;o=+g[h>>2]- +g[d+12>>2];n=+g[j>>2]- +g[d+16>>2];k=+g[d+24>>2];l=+g[d+20>>2];d=a+28|0;i=+(k*n+o*(-0.0-l));g[d>>2]=o*k+n*l;g[d+4>>2]=i;i=+g[e>>2];l=+g[f>>2];n=+g[m>>2];k=+g[f+4>>2];f=a+36|0;o=+(l*(-0.0-n)+i*k);g[f>>2]=i*l+n*k;g[f+4>>2]=o;return}function rF(a){a=a|0;return+(+g[a+56>>2])}function rG(a,b){a=a|0;b=+b;g[a+60>>2]=b;return}function rH(a){a=a|0;return a+20|0}function rI(a){a=a|0;return+(+g[a+48>>2])}function rJ(a){a=a|0;return a+28|0}function rK(b,c){b=b|0;c=c|0;return(a[b+16|0]&1)!=0|0}function rL(b){b=b|0;return(a[b+44|0]&1)!=0|0}function rM(a){a=a|0;return+(+g[a+60>>2])}function rN(a,b){a=a|0;b=b|0;return c[a+8>>2]|0}function rO(a,b){a=a|0;b=b|0;return c[a+12>>2]|0}function rP(b,c){b=b|0;c=c|0;a[b+44|0]=c&1;return}function rQ(b,c){b=b|0;c=c|0;a[b+16|0]=c&1;return}function rR(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+36|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function rS(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+20|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function rT(a){a=a|0;return+(+g[a+44>>2])}function rU(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+28|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function rV(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function rW(b){b=b|0;return(a[b+52|0]&1)!=0|0}function rX(a,b){a=a|0;b=+b;g[a+48>>2]=b;return}function rY(a){a=a|0;return+(+g[a+36>>2])}function rZ(b,c){b=b|0;c=c|0;a[b+40|0]=c&1;return}function r_(a){a=a|0;return+(+g[a+56>>2])}function r$(a,b){a=a|0;b=+b;g[a+56>>2]=b;return}function r0(a){a=a|0;return+(+g[a+60>>2])}function r1(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function r2(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function r3(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0,j=0.0,k=0.0,l=0.0,m=0.0;c[a+8>>2]=b;c[a+12>>2]=d;f=e|0;h=+g[f>>2]- +g[b+12>>2];i=e+4|0;j=+g[i>>2]- +g[b+16>>2];k=+g[b+24>>2];l=+g[b+20>>2];e=a+20|0;m=+(k*j+h*(-0.0-l));g[e>>2]=h*k+j*l;g[e+4>>2]=m;m=+g[f>>2]- +g[d+12>>2];l=+g[i>>2]- +g[d+16>>2];j=+g[d+24>>2];k=+g[d+20>>2];i=a+28|0;h=+(j*l+m*(-0.0-k));g[i>>2]=m*j+l*k;g[i+4>>2]=h;g[a+36>>2]=+g[d+56>>2]- +g[b+56>>2];return}function r4(b){b=b|0;return(a[b+40|0]&1)!=0|0}function r5(a){a=a|0;return+(+g[a+48>>2])}function r6(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function r7(a){a=a|0;return a+20|0}function r8(a){a=a|0;return a+28|0}function r9(b,c){b=b|0;c=c|0;return(a[b+16|0]&1)!=0|0}function sa(a,b){a=a|0;b=b|0;return c[a+8>>2]|0}function sb(a,b){a=a|0;b=b|0;return c[a+12>>2]|0}function sc(a,b){a=a|0;b=+b;g[a+60>>2]=b;return}function sd(b,c){b=b|0;c=c|0;a[b+52|0]=c&1;return}function se(b,c){b=b|0;c=c|0;a[b+16|0]=c&1;return}function sf(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+36|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function sg(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+44|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function sh(a,b){a=a|0;b=+b;g[a+60>>2]=b;return}function si(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+28|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function sj(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+20|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function sk(a){a=a|0;return a+28|0}function sl(a){a=a|0;return a+20|0}function sm(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function sn(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function so(a){a=a|0;return+(+g[a+60>>2])}function sp(a){a=a|0;return a+36|0}function sq(a){a=a|0;return a+44|0}function sr(b,c){b=b|0;c=c|0;return(a[b+16|0]&1)!=0|0}function ss(a,b){a=a|0;b=+b;g[a+56>>2]=b;return}function st(a,b){a=a|0;b=+b;g[a+52>>2]=b;return}function su(a,b){a=a|0;b=b|0;return c[a+8>>2]|0}function sv(a,b){a=a|0;b=b|0;return c[a+12>>2]|0}function sw(){var b=0;b=vo(72)|0;vq(b|0,0,17);c[b>>2]=2;vq(b+20|0,0,16);g[b+36>>2]=1.0;g[b+40>>2]=0.0;g[b+44>>2]=0.0;a[b+48|0]=0;g[b+52>>2]=0.0;g[b+56>>2]=0.0;a[b+60|0]=0;g[b+64>>2]=0.0;g[b+68>>2]=0.0;return b|0}function sx(a){a=a|0;if((a|0)==0){return}vl(a);return}function sy(a){a=a|0;if((a|0)==0){return}vl(a);return}function sz(a,b){a=a|0;b=+b;g[a>>2]=+S(+b);g[a+4>>2]=+R(+b);return}function sA(a){a=a|0;return+(+X(+(+g[a>>2]),+(+g[a+4>>2])))}function sB(){return vo(8)|0}function sC(a){a=+a;var b=0;b=vo(8)|0;g[b>>2]=+S(+a);g[b+4>>2]=+R(+a);return b|0}function sD(){var b=0;b=vo(64)|0;vq(b|0,0,17);c[b>>2]=7;vq(b+20|0,0,16);g[b+36>>2]=1.0;g[b+40>>2]=0.0;a[b+44|0]=0;g[b+48>>2]=0.0;g[b+52>>2]=0.0;g[b+56>>2]=2.0;g[b+60>>2]=.699999988079071;return b|0}function sE(a){a=a|0;if((a|0)==0){return}vl(a);return}function sF(){var b=0;b=vo(64)|0;vq(b|0,0,17);c[b>>2]=1;g[b+44>>2]=0.0;g[b+48>>2]=0.0;g[b+60>>2]=0.0;g[b+56>>2]=0.0;a[b+52|0]=0;vq(b+20|0,0,21);return b|0}function sG(a){a=a|0;if((a|0)==0){return}vl(a);return}function sH(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;fI(a,b,c,d,e,f,g,h);return}function sI(a){a=a|0;if((a|0)==0){return}vl(a);return}function sJ(a){a=a|0;return+(+g[a+56>>2])}function sK(a){a=a|0;return+(+g[a+52>>2])}function sL(b,c){b=b|0;c=c|0;a[b+16|0]=c&1;return}function sM(a){a=a|0;return c[a+8>>2]|0}function sN(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function sO(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function sP(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function sQ(a){a=a|0;return c[a+12>>2]|0}function sR(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function sS(b){b=b|0;return(a[b+16|0]&1)!=0|0}function sT(a){a=a|0;return c[a>>2]|0}function sU(b,c){b=b|0;c=c|0;a[b+16|0]=c&1;return}function sV(a){a=a|0;return c[a+4>>2]|0}function sW(a,b){a=a|0;b=b|0;var d=0;d=b;b=a;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function sX(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+8|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function sY(a){a=a|0;return a|0}function sZ(a){a=a|0;return a+8|0}function s_(a){a=a|0;g[a>>2]=0.0;g[a+4>>2]=0.0;g[a+8>>2]=0.0;g[a+12>>2]=1.0;return}function s$(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;return}function s0(a,b){a=a|0;b=+b;g[a>>2]=b;return}function s1(a){a=a|0;return+(+g[a>>2])}function s2(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function s3(a){a=a|0;return+(+g[a+4>>2])}function s4(a){a=a|0;return+(+g[a+8>>2])}function s5(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function s6(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+8|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function s7(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0,f=0;b=+g[a+8>>2];c=+g[a>>2];d=+g[a+12>>2];e=+g[a+4>>2];if(!(b-c>=0.0&d-e>=0.0)){f=0;return f|0}if(!(c==c&!(C=0.0,C!=C)&c>+-p&c<+p)){f=0;return f|0}if(!(e==e&!(C=0.0,C!=C)&e>+-p&e<+p)){f=0;return f|0}if(!(b==b&!(C=0.0,C!=C)&b>+-p&b<+p)){f=0;return f|0}if(!(d==d&!(C=0.0,C!=C)&d>+-p)){f=0;return f|0}f=d<+p;return f|0}function s8(a,b){a=a|0;b=b|0;var c=0;if(+g[a>>2]>+g[b>>2]){c=0;return c|0}if(+g[a+4>>2]>+g[b+4>>2]){c=0;return c|0}if(+g[b+8>>2]>+g[a+8>>2]){c=0;return c|0}c=+g[b+12>>2]<=+g[a+12>>2];return c|0}function s9(b){b=b|0;var c=0.0,d=0;if(!(a[23120]|0)){a[23120]=1}c=+((+g[b+12>>2]- +g[b+4>>2])*.5);d=56;g[d>>2]=(+g[b+8>>2]- +g[b>>2])*.5;g[d+4>>2]=c;return 56}function ta(b){b=b|0;var c=0.0,d=0;if(!(a[23128]|0)){a[23128]=1}c=+((+g[b+4>>2]+ +g[b+12>>2])*.5);d=48;g[d>>2]=(+g[b>>2]+ +g[b+8>>2])*.5;g[d+4>>2]=c;return 48}function tb(a){a=a|0;return a+8|0}function tc(a){a=a|0;return+((+g[a+8>>2]- +g[a>>2]+(+g[a+12>>2]- +g[a+4>>2]))*2.0)}function td(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0,i=0.0;c=+g[a>>2];d=+g[b>>2];e=+g[a+4>>2];f=+g[b+4>>2];h=a;i=+(e<f?e:f);g[h>>2]=c<d?c:d;g[h+4>>2]=i;h=a+8|0;i=+g[h>>2];d=+g[b+8>>2];c=+g[a+12>>2];f=+g[b+12>>2];b=h;e=+(c>f?c:f);g[b>>2]=i>d?i:d;g[b+4>>2]=e;return}function te(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0,j=0.0;d=+g[b>>2];e=+g[c>>2];f=+g[b+4>>2];h=+g[c+4>>2];i=a;j=+(f<h?f:h);g[i>>2]=d<e?d:e;g[i+4>>2]=j;j=+g[b+8>>2];e=+g[c+8>>2];d=+g[b+12>>2];h=+g[c+12>>2];c=a+8|0;f=+(d>h?d:h);g[c>>2]=j>e?j:e;g[c+4>>2]=f;return}function tf(a,b){a=a|0;b=b|0;var d=0;d=b;b=a;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function tg(a){a=a|0;return a|0}function th(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+20|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function ti(a,b){a=a|0;b=b|0;return c[a+8>>2]|0}function tj(a,b){a=a|0;b=b|0;return c[a+12>>2]|0}function tk(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+28|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function tl(a){a=a|0;return+(+g[a+40>>2])}function tm(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function tn(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function to(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function tp(a){a=a|0;return a+20|0}function tq(a){a=a|0;return+(+g[a+36>>2])}function tr(a){a=a|0;return a+28|0}function ts(b,c){b=b|0;c=c|0;return(a[b+16|0]&1)!=0|0}function tt(a){a=a|0;return+(+g[a+44>>2])}function tu(b,c){b=b|0;c=c|0;a[b+16|0]=c&1;return}function tv(a,b){a=a|0;b=+b;g[a+40>>2]=b;return}function tw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0,j=0.0,k=0.0,l=0.0,m=0.0;c[a+8>>2]=b;c[a+12>>2]=d;f=e|0;h=+g[f>>2]- +g[b+12>>2];i=e+4|0;j=+g[i>>2]- +g[b+16>>2];k=+g[b+24>>2];l=+g[b+20>>2];e=a+20|0;m=+(k*j+h*(-0.0-l));g[e>>2]=h*k+j*l;g[e+4>>2]=m;m=+g[f>>2]- +g[d+12>>2];l=+g[i>>2]- +g[d+16>>2];j=+g[d+24>>2];k=+g[d+20>>2];i=a+28|0;h=+(j*l+m*(-0.0-k));g[i>>2]=m*j+l*k;g[i+4>>2]=h;g[a+36>>2]=+g[d+56>>2]- +g[b+56>>2];return}function tx(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function ty(a,b){a=a|0;b=b|0;return c[a+8>>2]|0}function tz(a,b){a=a|0;b=b|0;return c[a+12>>2]|0}function tA(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function tB(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function tC(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function tD(a){a=a|0;return+(+g[a+28>>2])}function tE(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+20|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function tF(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function tG(a){a=a|0;return+(+g[a+32>>2])}function tH(a){a=a|0;return a+20|0}function tI(b,c){b=b|0;c=c|0;return(a[b+16|0]&1)!=0|0}function tJ(b,c){b=b|0;c=c|0;a[b+16|0]=c&1;return}function tK(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function tL(a){a=a|0;return+(+g[a+36>>2])}function tM(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+20|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}
function tN(a,b){a=a|0;b=b|0;return c[a+8>>2]|0}function tO(a,b){a=a|0;b=b|0;return c[a+12>>2]|0}function tP(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+28|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function tQ(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function tR(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function tS(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function tT(a){a=a|0;return+(+g[a+36>>2])}function tU(a){a=a|0;return a+20|0}function tV(a){a=a|0;return+(+g[a+40>>2])}function tW(a){a=a|0;return a+28|0}function tX(b,c){b=b|0;c=c|0;return(a[b+16|0]&1)!=0|0}function tY(a){a=a|0;return+(+g[a+44>>2])}function tZ(b,c){b=b|0;c=c|0;a[b+16|0]=c&1;return}function t_(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function t$(a,b){a=a|0;b=+b;g[a+40>>2]=b;return}function t0(){var b=0;b=vo(64)|0;vq(b|0,0,16);c[b>>2]=4;g[b+20>>2]=-1.0;g[b+24>>2]=1.0;g[b+28>>2]=1.0;g[b+32>>2]=1.0;g[b+36>>2]=-1.0;g[b+40>>2]=0.0;g[b+44>>2]=1.0;g[b+48>>2]=0.0;g[b+52>>2]=0.0;g[b+56>>2]=0.0;g[b+60>>2]=1.0;a[b+16|0]=1;return b|0}function t1(a){a=a|0;if((a|0)==0){return}vl(a);return}function t2(){var a=0;a=vo(20)|0;vq(a|0,0,17);return a|0}function t3(a){a=a|0;if((a|0)==0){return}vl(a);return}function t4(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=b;b=a;f=c[e+4>>2]|0;c[b>>2]=c[e>>2];c[b+4>>2]=f;g[a+8>>2]=+S(+d);g[a+12>>2]=+R(+d);return}function t5(){return vo(16)|0}function t6(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=vo(16)|0;e=a;a=d;f=c[e+4>>2]|0;c[a>>2]=c[e>>2];c[a+4>>2]=f;f=b;b=d+8|0;a=c[f+4>>2]|0;c[b>>2]=c[f>>2];c[b+4>>2]=a;return d|0}function t7(a){a=a|0;if((a|0)==0){return}vl(a);return}function t8(){return vo(12)|0}function t9(a,b,c){a=+a;b=+b;c=+c;var d=0;d=vo(12)|0;g[d>>2]=a;g[d+4>>2]=b;g[d+8>>2]=c;return d|0}function ua(a){a=a|0;if((a|0)==0){return}vl(a);return}function ub(){return vo(16)|0}function uc(a,b,c){a=a|0;b=b|0;c=c|0;return cc(a,b,c)|0}function ud(a){a=a|0;if((a|0)==0){return}vl(a);return}function ue(){var a=0;a=vo(48)|0;vq(a|0,0,17);c[a>>2]=8;vq(a+20|0,0,28);return a|0}function uf(){var a=0;a=vo(40)|0;vq(a|0,0,17);c[a>>2]=5;g[a+20>>2]=0.0;g[a+24>>2]=0.0;g[a+28>>2]=0.0;g[a+32>>2]=5.0;g[a+36>>2]=.699999988079071;return a|0}function ug(a){a=a|0;if((a|0)==0){return}vl(a);return}function uh(){var a=0;a=vo(48)|0;vq(a|0,0,17);c[a>>2]=3;vq(a+20|0,0,16);g[a+36>>2]=1.0;g[a+40>>2]=0.0;g[a+44>>2]=0.0;return a|0}function ui(a){a=a|0;if((a|0)==0){return}vl(a);return}function uj(a){a=a|0;return}function uk(a,b){a=a|0;b=b|0;return}function ul(a,b){a=a|0;b=b|0;return}function um(a){a=a|0;return}function un(a,b){a=a|0;b=b|0;return 0}function uo(a){a=a|0;return}function up(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+0.0}function uq(a){a=a|0;return}function ur(a){a=a|0;return}function us(a){a=a|0;return}function ut(a,b){a=a|0;b=b|0;return c[a+8>>2]|0}function uu(a,b){a=a|0;b=b|0;return c[a+12>>2]|0}function uv(a){a=a|0;return c[a+20>>2]|0}function uw(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function ux(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function uy(a,b){a=a|0;b=b|0;c[a+24>>2]=b;return}function uz(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function uA(b,c){b=b|0;c=c|0;return(a[b+16|0]&1)!=0|0}function uB(a){a=a|0;return c[a+24>>2]|0}function uC(b,c){b=b|0;c=c|0;a[b+16|0]=c&1;return}function uD(a){a=a|0;return+(+g[a+28>>2])}function uE(a,b){a=a|0;b=b|0;c[a+20>>2]=b;return}function uF(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function uG(a){a=a|0;return c[a+8>>2]|0}function uH(a){a=a|0;return c[a>>2]|0}function uI(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function uJ(a){a=a|0;return c[a+12>>2]|0}function uK(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function uL(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function uM(a){a=a|0;return c[a+4>>2]|0}function uN(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+20|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function uO(a,b){a=a|0;b=b|0;return c[a+8>>2]|0}function uP(a,b){a=a|0;b=b|0;return c[a+12>>2]|0}function uQ(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+28|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return}function uR(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function uS(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function uT(a){a=a|0;return a+20|0}function uU(a){a=a|0;return+(+g[a+36>>2])}function uV(a){a=a|0;return a+28|0}function uW(b,c){b=b|0;c=c|0;return(a[b+16|0]&1)!=0|0}function uX(b,c){b=b|0;c=c|0;a[b+16|0]=c&1;return}function uY(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function uZ(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;if((c[d+8>>2]|0)!=(b|0)){return}b=d+16|0;g=c[b>>2]|0;if((g|0)==0){c[b>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;return}if((g|0)!=(e|0)){e=d+36|0;c[e>>2]=(c[e>>2]|0)+1;c[d+24>>2]=2;a[d+54|0]=1;return}e=d+24|0;if((c[e>>2]|0)!=2){return}c[e>>2]=f;return}function u_(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;if((c[d+8>>2]|0)==(b|0)){if((c[d+4>>2]|0)!=(e|0)){return}g=d+28|0;if((c[g>>2]|0)==1){return}c[g>>2]=f;return}if((c[d>>2]|0)!=(b|0)){return}do{if((c[d+16>>2]|0)!=(e|0)){b=d+20|0;if((c[b>>2]|0)==(e|0)){break}c[d+32>>2]=f;c[b>>2]=e;b=d+40|0;c[b>>2]=(c[b>>2]|0)+1;do{if((c[d+36>>2]|0)==1){if((c[d+24>>2]|0)!=2){break}a[d+54|0]=1}}while(0);c[d+44>>2]=4;return}}while(0);if((f|0)!=1){return}c[d+32>>2]=1;return}function u$(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0.0;c[a+8>>2]=b;c[a+12>>2]=d;h=e|0;i=+g[h>>2]- +g[b+12>>2];j=e+4|0;k=+g[j>>2]- +g[b+16>>2];l=+g[b+24>>2];m=+g[b+20>>2];b=a+20|0;n=+(l*k+i*(-0.0-m));g[b>>2]=i*l+k*m;g[b+4>>2]=n;b=f|0;n=+g[b>>2]- +g[d+12>>2];e=f+4|0;m=+g[e>>2]- +g[d+16>>2];k=+g[d+24>>2];l=+g[d+20>>2];d=a+28|0;i=+(k*m+n*(-0.0-l));g[d>>2]=n*k+m*l;g[d+4>>2]=i;i=+g[b>>2]- +g[h>>2];l=+g[e>>2]- +g[j>>2];g[a+36>>2]=+P(+(i*i+l*l));return}function u0(a){a=a|0;if((a|0)==0){return}vl(a);return}function u1(){var a=0;a=vo(32)|0;vq(a|0,0,17);c[a>>2]=6;c[a+20>>2]=0;c[a+24>>2]=0;g[a+28>>2]=1.0;return a|0}function u2(a){a=a|0;if((a|0)==0){return}vl(a);return}function u3(){return vo(16)|0}function u4(a){a=a|0;if((a|0)==0){return}vl(a);return}function u5(){var a=0;a=vo(40)|0;vq(a|0,0,17);c[a>>2]=10;g[a+20>>2]=-1.0;g[a+24>>2]=0.0;g[a+28>>2]=1.0;g[a+32>>2]=0.0;g[a+36>>2]=0.0;return a|0}function u6(a){a=a|0;vl(a);return}function u7(a){a=a|0;vl(a);return}function u8(a){a=a|0;vl(a);return}function u9(a){a=a|0;vl(a);return}function va(a){a=a|0;vl(a);return}function vb(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+56|0;f=e|0;do{if((a|0)==(b|0)){g=1}else{if((b|0)==0){g=0;break}h=vd(b,21432,21416,-1)|0;j=h;if((h|0)==0){g=0;break}vq(f|0,0,56);c[f>>2]=j;c[f+8>>2]=a;c[f+12>>2]=-1;c[f+48>>2]=1;bO[c[(c[h>>2]|0)+28>>2]&127](j,f,c[d>>2]|0,1);if((c[f+24>>2]|0)!=1){g=0;break}c[d>>2]=c[f+16>>2];g=1}}while(0);i=e;return g|0}function vc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;if((b|0)!=(c[d+8>>2]|0)){g=c[b+8>>2]|0;bO[c[(c[g>>2]|0)+28>>2]&127](g,d,e,f);return}g=d+16|0;b=c[g>>2]|0;if((b|0)==0){c[g>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;return}if((b|0)!=(e|0)){e=d+36|0;c[e>>2]=(c[e>>2]|0)+1;c[d+24>>2]=2;a[d+54|0]=1;return}e=d+24|0;if((c[e>>2]|0)!=2){return}c[e>>2]=f;return}function vd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+56|0;g=f|0;h=c[a>>2]|0;j=a+(c[h-8>>2]|0)|0;k=c[h-4>>2]|0;h=k;c[g>>2]=d;c[g+4>>2]=a;c[g+8>>2]=b;c[g+12>>2]=e;e=g+16|0;b=g+20|0;a=g+24|0;l=g+28|0;m=g+32|0;n=g+40|0;vq(e|0,0,39);if((k|0)==(d|0)){c[g+48>>2]=1;bA[c[(c[k>>2]|0)+20>>2]&63](h,g,j,j,1,0);i=f;return((c[a>>2]|0)==1?j:0)|0}bl[c[(c[k>>2]|0)+24>>2]&63](h,g,j,1,0);j=c[g+36>>2]|0;do{if((j|0)==1){if((c[a>>2]|0)!=1){if((c[n>>2]|0)!=0){o=0;break}if((c[l>>2]|0)!=1){o=0;break}if((c[m>>2]|0)!=1){o=0;break}}o=c[e>>2]|0}else if((j|0)==0){if((c[n>>2]|0)!=1){o=0;break}if((c[l>>2]|0)!=1){o=0;break}o=(c[m>>2]|0)==1?c[b>>2]|0:0}else{o=0}}while(0);i=f;return o|0}function ve(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=b|0;if((h|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)!=(e|0)){return}i=d+28|0;if((c[i>>2]|0)==1){return}c[i>>2]=f;return}if((h|0)!=(c[d>>2]|0)){h=c[b+8>>2]|0;bl[c[(c[h>>2]|0)+24>>2]&63](h,d,e,f,g);return}do{if((c[d+16>>2]|0)!=(e|0)){h=d+20|0;if((c[h>>2]|0)==(e|0)){break}c[d+32>>2]=f;i=d+44|0;if((c[i>>2]|0)==4){return}j=d+52|0;a[j]=0;k=d+53|0;a[k]=0;l=c[b+8>>2]|0;bA[c[(c[l>>2]|0)+20>>2]&63](l,d,e,e,1,g);if((a[k]&1)==0){m=0;n=1971}else{if((a[j]&1)==0){m=1;n=1971}}L2185:do{if((n|0)==1971){c[h>>2]=e;j=d+40|0;c[j>>2]=(c[j>>2]|0)+1;do{if((c[d+36>>2]|0)==1){if((c[d+24>>2]|0)!=2){n=1974;break}a[d+54|0]=1;if(m){break L2185}}else{n=1974}}while(0);if((n|0)==1974){if(m){break}}c[i>>2]=4;return}}while(0);c[i>>2]=3;return}}while(0);if((f|0)!=1){return}c[d+32>>2]=1;return}function vf(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0;if((b|0)!=(c[d+8>>2]|0)){i=c[b+8>>2]|0;bA[c[(c[i>>2]|0)+20>>2]&63](i,d,e,f,g,h);return}a[d+53|0]=1;if((c[d+4>>2]|0)!=(f|0)){return}a[d+52|0]=1;f=d+16|0;h=c[f>>2]|0;if((h|0)==0){c[f>>2]=e;c[d+24>>2]=g;c[d+36>>2]=1;if(!((c[d+48>>2]|0)==1&(g|0)==1)){return}a[d+54|0]=1;return}if((h|0)!=(e|0)){e=d+36|0;c[e>>2]=(c[e>>2]|0)+1;a[d+54|0]=1;return}e=d+24|0;h=c[e>>2]|0;if((h|0)==2){c[e>>2]=g;j=g}else{j=h}if(!((c[d+48>>2]|0)==1&(j|0)==1)){return}a[d+54|0]=1;return}function vg(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0;if((c[d+8>>2]|0)!=(b|0)){return}a[d+53|0]=1;if((c[d+4>>2]|0)!=(f|0)){return}a[d+52|0]=1;f=d+16|0;b=c[f>>2]|0;if((b|0)==0){c[f>>2]=e;c[d+24>>2]=g;c[d+36>>2]=1;if(!((c[d+48>>2]|0)==1&(g|0)==1)){return}a[d+54|0]=1;return}if((b|0)!=(e|0)){e=d+36|0;c[e>>2]=(c[e>>2]|0)+1;a[d+54|0]=1;return}e=d+24|0;b=c[e>>2]|0;if((b|0)==2){c[e>>2]=g;i=g}else{i=b}if(!((c[d+48>>2]|0)==1&(i|0)==1)){return}a[d+54|0]=1;return}function vh(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0;do{if(a>>>0<245){if(a>>>0<11){b=16}else{b=a+11&-8}d=b>>>3;e=c[3258]|0;f=e>>>(d>>>0);if((f&3|0)!=0){g=(f&1^1)+d|0;h=g<<1;i=13072+(h<<2)|0;j=13072+(h+2<<2)|0;h=c[j>>2]|0;k=h+8|0;l=c[k>>2]|0;do{if((i|0)==(l|0)){c[3258]=e&(1<<g^-1)}else{if(l>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}m=l+12|0;if((c[m>>2]|0)==(h|0)){c[m>>2]=i;c[j>>2]=l;break}else{aO();return 0;return 0}}}while(0);l=g<<3;c[h+4>>2]=l|3;j=h+(l|4)|0;c[j>>2]=c[j>>2]|1;n=k;return n|0}if(b>>>0<=(c[3260]|0)>>>0){o=b;break}if((f|0)!=0){j=2<<d;l=f<<d&(j|-j);j=(l&-l)-1|0;l=j>>>12&16;i=j>>>(l>>>0);j=i>>>5&8;m=i>>>(j>>>0);i=m>>>2&4;p=m>>>(i>>>0);m=p>>>1&2;q=p>>>(m>>>0);p=q>>>1&1;r=(j|l|i|m|p)+(q>>>(p>>>0))|0;p=r<<1;q=13072+(p<<2)|0;m=13072+(p+2<<2)|0;p=c[m>>2]|0;i=p+8|0;l=c[i>>2]|0;do{if((q|0)==(l|0)){c[3258]=e&(1<<r^-1)}else{if(l>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}j=l+12|0;if((c[j>>2]|0)==(p|0)){c[j>>2]=q;c[m>>2]=l;break}else{aO();return 0;return 0}}}while(0);l=r<<3;m=l-b|0;c[p+4>>2]=b|3;q=p;e=q+b|0;c[q+(b|4)>>2]=m|1;c[q+l>>2]=m;l=c[3260]|0;if((l|0)!=0){q=c[3263]|0;d=l>>>3;l=d<<1;f=13072+(l<<2)|0;k=c[3258]|0;h=1<<d;do{if((k&h|0)==0){c[3258]=k|h;s=f;t=13072+(l+2<<2)|0}else{d=13072+(l+2<<2)|0;g=c[d>>2]|0;if(g>>>0>=(c[3262]|0)>>>0){s=g;t=d;break}aO();return 0;return 0}}while(0);c[t>>2]=q;c[s+12>>2]=q;c[q+8>>2]=s;c[q+12>>2]=f}c[3260]=m;c[3263]=e;n=i;return n|0}l=c[3259]|0;if((l|0)==0){o=b;break}h=(l&-l)-1|0;l=h>>>12&16;k=h>>>(l>>>0);h=k>>>5&8;p=k>>>(h>>>0);k=p>>>2&4;r=p>>>(k>>>0);p=r>>>1&2;d=r>>>(p>>>0);r=d>>>1&1;g=c[13336+((h|l|k|p|r)+(d>>>(r>>>0))<<2)>>2]|0;r=g;d=g;p=(c[g+4>>2]&-8)-b|0;while(1){g=c[r+16>>2]|0;if((g|0)==0){k=c[r+20>>2]|0;if((k|0)==0){break}else{u=k}}else{u=g}g=(c[u+4>>2]&-8)-b|0;k=g>>>0<p>>>0;r=u;d=k?u:d;p=k?g:p}r=d;i=c[3262]|0;if(r>>>0<i>>>0){aO();return 0;return 0}e=r+b|0;m=e;if(r>>>0>=e>>>0){aO();return 0;return 0}e=c[d+24>>2]|0;f=c[d+12>>2]|0;do{if((f|0)==(d|0)){q=d+20|0;g=c[q>>2]|0;if((g|0)==0){k=d+16|0;l=c[k>>2]|0;if((l|0)==0){v=0;break}else{w=l;x=k}}else{w=g;x=q}while(1){q=w+20|0;g=c[q>>2]|0;if((g|0)!=0){w=g;x=q;continue}q=w+16|0;g=c[q>>2]|0;if((g|0)==0){break}else{w=g;x=q}}if(x>>>0<i>>>0){aO();return 0;return 0}else{c[x>>2]=0;v=w;break}}else{q=c[d+8>>2]|0;if(q>>>0<i>>>0){aO();return 0;return 0}g=q+12|0;if((c[g>>2]|0)!=(d|0)){aO();return 0;return 0}k=f+8|0;if((c[k>>2]|0)==(d|0)){c[g>>2]=f;c[k>>2]=q;v=f;break}else{aO();return 0;return 0}}}while(0);L2330:do{if((e|0)!=0){f=d+28|0;i=13336+(c[f>>2]<<2)|0;do{if((d|0)==(c[i>>2]|0)){c[i>>2]=v;if((v|0)!=0){break}c[3259]=c[3259]&(1<<c[f>>2]^-1);break L2330}else{if(e>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}q=e+16|0;if((c[q>>2]|0)==(d|0)){c[q>>2]=v}else{c[e+20>>2]=v}if((v|0)==0){break L2330}}}while(0);if(v>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}c[v+24>>2]=e;f=c[d+16>>2]|0;do{if((f|0)!=0){if(f>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}else{c[v+16>>2]=f;c[f+24>>2]=v;break}}}while(0);f=c[d+20>>2]|0;if((f|0)==0){break}if(f>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}else{c[v+20>>2]=f;c[f+24>>2]=v;break}}}while(0);if(p>>>0<16){e=p+b|0;c[d+4>>2]=e|3;f=r+(e+4)|0;c[f>>2]=c[f>>2]|1}else{c[d+4>>2]=b|3;c[r+(b|4)>>2]=p|1;c[r+(p+b)>>2]=p;f=c[3260]|0;if((f|0)!=0){e=c[3263]|0;i=f>>>3;f=i<<1;q=13072+(f<<2)|0;k=c[3258]|0;g=1<<i;do{if((k&g|0)==0){c[3258]=k|g;y=q;z=13072+(f+2<<2)|0}else{i=13072+(f+2<<2)|0;l=c[i>>2]|0;if(l>>>0>=(c[3262]|0)>>>0){y=l;z=i;break}aO();return 0;return 0}}while(0);c[z>>2]=e;c[y+12>>2]=e;c[e+8>>2]=y;c[e+12>>2]=q}c[3260]=p;c[3263]=m}f=d+8|0;if((f|0)==0){o=b;break}else{n=f}return n|0}else{if(a>>>0>4294967231){o=-1;break}f=a+11|0;g=f&-8;k=c[3259]|0;if((k|0)==0){o=g;break}r=-g|0;i=f>>>8;do{if((i|0)==0){A=0}else{if(g>>>0>16777215){A=31;break}f=(i+1048320|0)>>>16&8;l=i<<f;h=(l+520192|0)>>>16&4;j=l<<h;l=(j+245760|0)>>>16&2;B=14-(h|f|l)+(j<<l>>>15)|0;A=g>>>((B+7|0)>>>0)&1|B<<1}}while(0);i=c[13336+(A<<2)>>2]|0;L2378:do{if((i|0)==0){C=0;D=r;E=0}else{if((A|0)==31){F=0}else{F=25-(A>>>1)|0}d=0;m=r;p=i;q=g<<F;e=0;while(1){B=c[p+4>>2]&-8;l=B-g|0;if(l>>>0<m>>>0){if((B|0)==(g|0)){C=p;D=l;E=p;break L2378}else{G=p;H=l}}else{G=d;H=m}l=c[p+20>>2]|0;B=c[p+16+(q>>>31<<2)>>2]|0;j=(l|0)==0|(l|0)==(B|0)?e:l;if((B|0)==0){C=G;D=H;E=j;break}else{d=G;m=H;p=B;q=q<<1;e=j}}}}while(0);if((E|0)==0&(C|0)==0){i=2<<A;r=k&(i|-i);if((r|0)==0){o=g;break}i=(r&-r)-1|0;r=i>>>12&16;e=i>>>(r>>>0);i=e>>>5&8;q=e>>>(i>>>0);e=q>>>2&4;p=q>>>(e>>>0);q=p>>>1&2;m=p>>>(q>>>0);p=m>>>1&1;I=c[13336+((i|r|e|q|p)+(m>>>(p>>>0))<<2)>>2]|0}else{I=E}if((I|0)==0){J=D;K=C}else{p=I;m=D;q=C;while(1){e=(c[p+4>>2]&-8)-g|0;r=e>>>0<m>>>0;i=r?e:m;e=r?p:q;r=c[p+16>>2]|0;if((r|0)!=0){p=r;m=i;q=e;continue}r=c[p+20>>2]|0;if((r|0)==0){J=i;K=e;break}else{p=r;m=i;q=e}}}if((K|0)==0){o=g;break}if(J>>>0>=((c[3260]|0)-g|0)>>>0){o=g;break}q=K;m=c[3262]|0;if(q>>>0<m>>>0){aO();return 0;return 0}p=q+g|0;k=p;if(q>>>0>=p>>>0){aO();return 0;return 0}e=c[K+24>>2]|0;i=c[K+12>>2]|0;do{if((i|0)==(K|0)){r=K+20|0;d=c[r>>2]|0;if((d|0)==0){j=K+16|0;B=c[j>>2]|0;if((B|0)==0){L=0;break}else{M=B;N=j}}else{M=d;N=r}while(1){r=M+20|0;d=c[r>>2]|0;if((d|0)!=0){M=d;N=r;continue}r=M+16|0;d=c[r>>2]|0;if((d|0)==0){break}else{M=d;N=r}}if(N>>>0<m>>>0){aO();return 0;return 0}else{c[N>>2]=0;L=M;break}}else{r=c[K+8>>2]|0;if(r>>>0<m>>>0){aO();return 0;return 0}d=r+12|0;if((c[d>>2]|0)!=(K|0)){aO();return 0;return 0}j=i+8|0;if((c[j>>2]|0)==(K|0)){c[d>>2]=i;c[j>>2]=r;L=i;break}else{aO();return 0;return 0}}}while(0);L2428:do{if((e|0)!=0){i=K+28|0;m=13336+(c[i>>2]<<2)|0;do{if((K|0)==(c[m>>2]|0)){c[m>>2]=L;if((L|0)!=0){break}c[3259]=c[3259]&(1<<c[i>>2]^-1);break L2428}else{if(e>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}r=e+16|0;if((c[r>>2]|0)==(K|0)){c[r>>2]=L}else{c[e+20>>2]=L}if((L|0)==0){break L2428}}}while(0);if(L>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}c[L+24>>2]=e;i=c[K+16>>2]|0;do{if((i|0)!=0){if(i>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}else{c[L+16>>2]=i;c[i+24>>2]=L;break}}}while(0);i=c[K+20>>2]|0;if((i|0)==0){break}if(i>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}else{c[L+20>>2]=i;c[i+24>>2]=L;break}}}while(0);do{if(J>>>0<16){e=J+g|0;c[K+4>>2]=e|3;i=q+(e+4)|0;c[i>>2]=c[i>>2]|1}else{c[K+4>>2]=g|3;c[q+(g|4)>>2]=J|1;c[q+(J+g)>>2]=J;i=J>>>3;if(J>>>0<256){e=i<<1;m=13072+(e<<2)|0;r=c[3258]|0;j=1<<i;do{if((r&j|0)==0){c[3258]=r|j;O=m;P=13072+(e+2<<2)|0}else{i=13072+(e+2<<2)|0;d=c[i>>2]|0;if(d>>>0>=(c[3262]|0)>>>0){O=d;P=i;break}aO();return 0;return 0}}while(0);c[P>>2]=k;c[O+12>>2]=k;c[q+(g+8)>>2]=O;c[q+(g+12)>>2]=m;break}e=p;j=J>>>8;do{if((j|0)==0){Q=0}else{if(J>>>0>16777215){Q=31;break}r=(j+1048320|0)>>>16&8;i=j<<r;d=(i+520192|0)>>>16&4;B=i<<d;i=(B+245760|0)>>>16&2;l=14-(d|r|i)+(B<<i>>>15)|0;Q=J>>>((l+7|0)>>>0)&1|l<<1}}while(0);j=13336+(Q<<2)|0;c[q+(g+28)>>2]=Q;c[q+(g+20)>>2]=0;c[q+(g+16)>>2]=0;m=c[3259]|0;l=1<<Q;if((m&l|0)==0){c[3259]=m|l;c[j>>2]=e;c[q+(g+24)>>2]=j;c[q+(g+12)>>2]=e;c[q+(g+8)>>2]=e;break}if((Q|0)==31){R=0}else{R=25-(Q>>>1)|0}l=J<<R;m=c[j>>2]|0;while(1){if((c[m+4>>2]&-8|0)==(J|0)){break}S=m+16+(l>>>31<<2)|0;j=c[S>>2]|0;if((j|0)==0){T=2177;break}else{l=l<<1;m=j}}if((T|0)==2177){if(S>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}else{c[S>>2]=e;c[q+(g+24)>>2]=m;c[q+(g+12)>>2]=e;c[q+(g+8)>>2]=e;break}}l=m+8|0;j=c[l>>2]|0;i=c[3262]|0;if(m>>>0<i>>>0){aO();return 0;return 0}if(j>>>0<i>>>0){aO();return 0;return 0}else{c[j+12>>2]=e;c[l>>2]=e;c[q+(g+8)>>2]=j;c[q+(g+12)>>2]=m;c[q+(g+24)>>2]=0;break}}}while(0);q=K+8|0;if((q|0)==0){o=g;break}else{n=q}return n|0}}while(0);K=c[3260]|0;if(o>>>0<=K>>>0){S=K-o|0;J=c[3263]|0;if(S>>>0>15){R=J;c[3263]=R+o;c[3260]=S;c[R+(o+4)>>2]=S|1;c[R+K>>2]=S;c[J+4>>2]=o|3}else{c[3260]=0;c[3263]=0;c[J+4>>2]=K|3;S=J+(K+4)|0;c[S>>2]=c[S>>2]|1}n=J+8|0;return n|0}J=c[3261]|0;if(o>>>0<J>>>0){S=J-o|0;c[3261]=S;J=c[3264]|0;K=J;c[3264]=K+o;c[K+(o+4)>>2]=S|1;c[J+4>>2]=o|3;n=J+8|0;return n|0}do{if((c[104]|0)==0){J=a0(8)|0;if((J-1&J|0)==0){c[106]=J;c[105]=J;c[107]=-1;c[108]=2097152;c[109]=0;c[3369]=0;c[104]=(bj(0)|0)&-16^1431655768;break}else{aO();return 0;return 0}}}while(0);J=o+48|0;S=c[106]|0;K=o+47|0;R=S+K|0;Q=-S|0;S=R&Q;if(S>>>0<=o>>>0){n=0;return n|0}O=c[3368]|0;do{if((O|0)!=0){P=c[3366]|0;L=P+S|0;if(L>>>0<=P>>>0|L>>>0>O>>>0){n=0}else{break}return n|0}}while(0);L2520:do{if((c[3369]&4|0)==0){O=c[3264]|0;L2522:do{if((O|0)==0){T=2207}else{L=O;P=13480;while(1){U=P|0;M=c[U>>2]|0;if(M>>>0<=L>>>0){V=P+4|0;if((M+(c[V>>2]|0)|0)>>>0>L>>>0){break}}M=c[P+8>>2]|0;if((M|0)==0){T=2207;break L2522}else{P=M}}if((P|0)==0){T=2207;break}L=R-(c[3261]|0)&Q;if(L>>>0>=2147483647){W=0;break}m=be(L|0)|0;e=(m|0)==((c[U>>2]|0)+(c[V>>2]|0)|0);X=e?m:-1;Y=e?L:0;Z=m;_=L;T=2216}}while(0);do{if((T|0)==2207){O=be(0)|0;if((O|0)==-1){W=0;break}g=O;L=c[105]|0;m=L-1|0;if((m&g|0)==0){$=S}else{$=S-g+(m+g&-L)|0}L=c[3366]|0;g=L+$|0;if(!($>>>0>o>>>0&$>>>0<2147483647)){W=0;break}m=c[3368]|0;if((m|0)!=0){if(g>>>0<=L>>>0|g>>>0>m>>>0){W=0;break}}m=be($|0)|0;g=(m|0)==(O|0);X=g?O:-1;Y=g?$:0;Z=m;_=$;T=2216}}while(0);L2542:do{if((T|0)==2216){m=-_|0;if((X|0)!=-1){aa=Y;ab=X;T=2227;break L2520}do{if((Z|0)!=-1&_>>>0<2147483647&_>>>0<J>>>0){g=c[106]|0;O=K-_+g&-g;if(O>>>0>=2147483647){ac=_;break}if((be(O|0)|0)==-1){be(m|0)|0;W=Y;break L2542}else{ac=O+_|0;break}}else{ac=_}}while(0);if((Z|0)==-1){W=Y}else{aa=ac;ab=Z;T=2227;break L2520}}}while(0);c[3369]=c[3369]|4;ad=W;T=2224}else{ad=0;T=2224}}while(0);do{if((T|0)==2224){if(S>>>0>=2147483647){break}W=be(S|0)|0;Z=be(0)|0;if(!((Z|0)!=-1&(W|0)!=-1&W>>>0<Z>>>0)){break}ac=Z-W|0;Z=ac>>>0>(o+40|0)>>>0;Y=Z?W:-1;if((Y|0)!=-1){aa=Z?ac:ad;ab=Y;T=2227}}}while(0);do{if((T|0)==2227){ad=(c[3366]|0)+aa|0;c[3366]=ad;if(ad>>>0>(c[3367]|0)>>>0){c[3367]=ad}ad=c[3264]|0;L2562:do{if((ad|0)==0){S=c[3262]|0;if((S|0)==0|ab>>>0<S>>>0){c[3262]=ab}c[3370]=ab;c[3371]=aa;c[3373]=0;c[3267]=c[104];c[3266]=-1;S=0;do{Y=S<<1;ac=13072+(Y<<2)|0;c[13072+(Y+3<<2)>>2]=ac;c[13072+(Y+2<<2)>>2]=ac;S=S+1|0;}while(S>>>0<32);S=ab+8|0;if((S&7|0)==0){ae=0}else{ae=-S&7}S=aa-40-ae|0;c[3264]=ab+ae;c[3261]=S;c[ab+(ae+4)>>2]=S|1;c[ab+(aa-36)>>2]=40;c[3265]=c[108]}else{S=13480;while(1){af=c[S>>2]|0;ag=S+4|0;ah=c[ag>>2]|0;if((ab|0)==(af+ah|0)){T=2239;break}ac=c[S+8>>2]|0;if((ac|0)==0){break}else{S=ac}}do{if((T|0)==2239){if((c[S+12>>2]&8|0)!=0){break}ac=ad;if(!(ac>>>0>=af>>>0&ac>>>0<ab>>>0)){break}c[ag>>2]=ah+aa;ac=c[3264]|0;Y=(c[3261]|0)+aa|0;Z=ac;W=ac+8|0;if((W&7|0)==0){ai=0}else{ai=-W&7}W=Y-ai|0;c[3264]=Z+ai;c[3261]=W;c[Z+(ai+4)>>2]=W|1;c[Z+(Y+4)>>2]=40;c[3265]=c[108];break L2562}}while(0);if(ab>>>0<(c[3262]|0)>>>0){c[3262]=ab}S=ab+aa|0;Y=13480;while(1){aj=Y|0;if((c[aj>>2]|0)==(S|0)){T=2249;break}Z=c[Y+8>>2]|0;if((Z|0)==0){break}else{Y=Z}}do{if((T|0)==2249){if((c[Y+12>>2]&8|0)!=0){break}c[aj>>2]=ab;S=Y+4|0;c[S>>2]=(c[S>>2]|0)+aa;S=ab+8|0;if((S&7|0)==0){ak=0}else{ak=-S&7}S=ab+(aa+8)|0;if((S&7|0)==0){al=0}else{al=-S&7}S=ab+(al+aa)|0;Z=S;W=ak+o|0;ac=ab+W|0;_=ac;K=S-(ab+ak)-o|0;c[ab+(ak+4)>>2]=o|3;do{if((Z|0)==(c[3264]|0)){J=(c[3261]|0)+K|0;c[3261]=J;c[3264]=_;c[ab+(W+4)>>2]=J|1}else{if((Z|0)==(c[3263]|0)){J=(c[3260]|0)+K|0;c[3260]=J;c[3263]=_;c[ab+(W+4)>>2]=J|1;c[ab+(J+W)>>2]=J;break}J=aa+4|0;X=c[ab+(J+al)>>2]|0;if((X&3|0)==1){$=X&-8;V=X>>>3;L2607:do{if(X>>>0<256){U=c[ab+((al|8)+aa)>>2]|0;Q=c[ab+(aa+12+al)>>2]|0;R=13072+(V<<1<<2)|0;do{if((U|0)!=(R|0)){if(U>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}if((c[U+12>>2]|0)==(Z|0)){break}aO();return 0;return 0}}while(0);if((Q|0)==(U|0)){c[3258]=c[3258]&(1<<V^-1);break}do{if((Q|0)==(R|0)){am=Q+8|0}else{if(Q>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}m=Q+8|0;if((c[m>>2]|0)==(Z|0)){am=m;break}aO();return 0;return 0}}while(0);c[U+12>>2]=Q;c[am>>2]=U}else{R=S;m=c[ab+((al|24)+aa)>>2]|0;P=c[ab+(aa+12+al)>>2]|0;do{if((P|0)==(R|0)){O=al|16;g=ab+(J+O)|0;L=c[g>>2]|0;if((L|0)==0){e=ab+(O+aa)|0;O=c[e>>2]|0;if((O|0)==0){an=0;break}else{ao=O;ap=e}}else{ao=L;ap=g}while(1){g=ao+20|0;L=c[g>>2]|0;if((L|0)!=0){ao=L;ap=g;continue}g=ao+16|0;L=c[g>>2]|0;if((L|0)==0){break}else{ao=L;ap=g}}if(ap>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}else{c[ap>>2]=0;an=ao;break}}else{g=c[ab+((al|8)+aa)>>2]|0;if(g>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}L=g+12|0;if((c[L>>2]|0)!=(R|0)){aO();return 0;return 0}e=P+8|0;if((c[e>>2]|0)==(R|0)){c[L>>2]=P;c[e>>2]=g;an=P;break}else{aO();return 0;return 0}}}while(0);if((m|0)==0){break}P=ab+(aa+28+al)|0;U=13336+(c[P>>2]<<2)|0;do{if((R|0)==(c[U>>2]|0)){c[U>>2]=an;if((an|0)!=0){break}c[3259]=c[3259]&(1<<c[P>>2]^-1);break L2607}else{if(m>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}Q=m+16|0;if((c[Q>>2]|0)==(R|0)){c[Q>>2]=an}else{c[m+20>>2]=an}if((an|0)==0){break L2607}}}while(0);if(an>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}c[an+24>>2]=m;R=al|16;P=c[ab+(R+aa)>>2]|0;do{if((P|0)!=0){if(P>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}else{c[an+16>>2]=P;c[P+24>>2]=an;break}}}while(0);P=c[ab+(J+R)>>2]|0;if((P|0)==0){break}if(P>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}else{c[an+20>>2]=P;c[P+24>>2]=an;break}}}while(0);aq=ab+(($|al)+aa)|0;ar=$+K|0}else{aq=Z;ar=K}J=aq+4|0;c[J>>2]=c[J>>2]&-2;c[ab+(W+4)>>2]=ar|1;c[ab+(ar+W)>>2]=ar;J=ar>>>3;if(ar>>>0<256){V=J<<1;X=13072+(V<<2)|0;P=c[3258]|0;m=1<<J;do{if((P&m|0)==0){c[3258]=P|m;as=X;at=13072+(V+2<<2)|0}else{J=13072+(V+2<<2)|0;U=c[J>>2]|0;if(U>>>0>=(c[3262]|0)>>>0){as=U;at=J;break}aO();return 0;return 0}}while(0);c[at>>2]=_;c[as+12>>2]=_;c[ab+(W+8)>>2]=as;c[ab+(W+12)>>2]=X;break}V=ac;m=ar>>>8;do{if((m|0)==0){au=0}else{if(ar>>>0>16777215){au=31;break}P=(m+1048320|0)>>>16&8;$=m<<P;J=($+520192|0)>>>16&4;U=$<<J;$=(U+245760|0)>>>16&2;Q=14-(J|P|$)+(U<<$>>>15)|0;au=ar>>>((Q+7|0)>>>0)&1|Q<<1}}while(0);m=13336+(au<<2)|0;c[ab+(W+28)>>2]=au;c[ab+(W+20)>>2]=0;c[ab+(W+16)>>2]=0;X=c[3259]|0;Q=1<<au;if((X&Q|0)==0){c[3259]=X|Q;c[m>>2]=V;c[ab+(W+24)>>2]=m;c[ab+(W+12)>>2]=V;c[ab+(W+8)>>2]=V;break}if((au|0)==31){av=0}else{av=25-(au>>>1)|0}Q=ar<<av;X=c[m>>2]|0;while(1){if((c[X+4>>2]&-8|0)==(ar|0)){break}aw=X+16+(Q>>>31<<2)|0;m=c[aw>>2]|0;if((m|0)==0){T=2322;break}else{Q=Q<<1;X=m}}if((T|0)==2322){if(aw>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}else{c[aw>>2]=V;c[ab+(W+24)>>2]=X;c[ab+(W+12)>>2]=V;c[ab+(W+8)>>2]=V;break}}Q=X+8|0;m=c[Q>>2]|0;$=c[3262]|0;if(X>>>0<$>>>0){aO();return 0;return 0}if(m>>>0<$>>>0){aO();return 0;return 0}else{c[m+12>>2]=V;c[Q>>2]=V;c[ab+(W+8)>>2]=m;c[ab+(W+12)>>2]=X;c[ab+(W+24)>>2]=0;break}}}while(0);n=ab+(ak|8)|0;return n|0}}while(0);Y=ad;W=13480;while(1){ax=c[W>>2]|0;if(ax>>>0<=Y>>>0){ay=c[W+4>>2]|0;az=ax+ay|0;if(az>>>0>Y>>>0){break}}W=c[W+8>>2]|0}W=ax+(ay-39)|0;if((W&7|0)==0){aA=0}else{aA=-W&7}W=ax+(ay-47+aA)|0;ac=W>>>0<(ad+16|0)>>>0?Y:W;W=ac+8|0;_=ab+8|0;if((_&7|0)==0){aB=0}else{aB=-_&7}_=aa-40-aB|0;c[3264]=ab+aB;c[3261]=_;c[ab+(aB+4)>>2]=_|1;c[ab+(aa-36)>>2]=40;c[3265]=c[108];c[ac+4>>2]=27;c[W>>2]=c[3370];c[W+4>>2]=c[13484>>2];c[W+8>>2]=c[13488>>2];c[W+12>>2]=c[13492>>2];c[3370]=ab;c[3371]=aa;c[3373]=0;c[3372]=W;W=ac+28|0;c[W>>2]=7;if((ac+32|0)>>>0<az>>>0){_=W;while(1){W=_+4|0;c[W>>2]=7;if((_+8|0)>>>0<az>>>0){_=W}else{break}}}if((ac|0)==(Y|0)){break}_=ac-ad|0;W=Y+(_+4)|0;c[W>>2]=c[W>>2]&-2;c[ad+4>>2]=_|1;c[Y+_>>2]=_;W=_>>>3;if(_>>>0<256){K=W<<1;Z=13072+(K<<2)|0;S=c[3258]|0;m=1<<W;do{if((S&m|0)==0){c[3258]=S|m;aC=Z;aD=13072+(K+2<<2)|0}else{W=13072+(K+2<<2)|0;Q=c[W>>2]|0;if(Q>>>0>=(c[3262]|0)>>>0){aC=Q;aD=W;break}aO();return 0;return 0}}while(0);c[aD>>2]=ad;c[aC+12>>2]=ad;c[ad+8>>2]=aC;c[ad+12>>2]=Z;break}K=ad;m=_>>>8;do{if((m|0)==0){aE=0}else{if(_>>>0>16777215){aE=31;break}S=(m+1048320|0)>>>16&8;Y=m<<S;ac=(Y+520192|0)>>>16&4;W=Y<<ac;Y=(W+245760|0)>>>16&2;Q=14-(ac|S|Y)+(W<<Y>>>15)|0;aE=_>>>((Q+7|0)>>>0)&1|Q<<1}}while(0);m=13336+(aE<<2)|0;c[ad+28>>2]=aE;c[ad+20>>2]=0;c[ad+16>>2]=0;Z=c[3259]|0;Q=1<<aE;if((Z&Q|0)==0){c[3259]=Z|Q;c[m>>2]=K;c[ad+24>>2]=m;c[ad+12>>2]=ad;c[ad+8>>2]=ad;break}if((aE|0)==31){aF=0}else{aF=25-(aE>>>1)|0}Q=_<<aF;Z=c[m>>2]|0;while(1){if((c[Z+4>>2]&-8|0)==(_|0)){break}aG=Z+16+(Q>>>31<<2)|0;m=c[aG>>2]|0;if((m|0)==0){T=2357;break}else{Q=Q<<1;Z=m}}if((T|0)==2357){if(aG>>>0<(c[3262]|0)>>>0){aO();return 0;return 0}else{c[aG>>2]=K;c[ad+24>>2]=Z;c[ad+12>>2]=ad;c[ad+8>>2]=ad;break}}Q=Z+8|0;_=c[Q>>2]|0;m=c[3262]|0;if(Z>>>0<m>>>0){aO();return 0;return 0}if(_>>>0<m>>>0){aO();return 0;return 0}else{c[_+12>>2]=K;c[Q>>2]=K;c[ad+8>>2]=_;c[ad+12>>2]=Z;c[ad+24>>2]=0;break}}}while(0);ad=c[3261]|0;if(ad>>>0<=o>>>0){break}_=ad-o|0;c[3261]=_;ad=c[3264]|0;Q=ad;c[3264]=Q+o;c[Q+(o+4)>>2]=_|1;c[ad+4>>2]=o|3;n=ad+8|0;return n|0}}while(0);c[(bg()|0)>>2]=12;n=0;return n|0}function vi(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;if((a|0)==0){return}b=a-8|0;d=b;e=c[3262]|0;if(b>>>0<e>>>0){aO()}f=c[a-4>>2]|0;g=f&3;if((g|0)==1){aO()}h=f&-8;i=a+(h-8)|0;j=i;L2779:do{if((f&1|0)==0){k=c[b>>2]|0;if((g|0)==0){return}l=-8-k|0;m=a+l|0;n=m;o=k+h|0;if(m>>>0<e>>>0){aO()}if((n|0)==(c[3263]|0)){p=a+(h-4)|0;if((c[p>>2]&3|0)!=3){q=n;r=o;break}c[3260]=o;c[p>>2]=c[p>>2]&-2;c[a+(l+4)>>2]=o|1;c[i>>2]=o;return}p=k>>>3;if(k>>>0<256){k=c[a+(l+8)>>2]|0;s=c[a+(l+12)>>2]|0;t=13072+(p<<1<<2)|0;do{if((k|0)!=(t|0)){if(k>>>0<e>>>0){aO()}if((c[k+12>>2]|0)==(n|0)){break}aO()}}while(0);if((s|0)==(k|0)){c[3258]=c[3258]&(1<<p^-1);q=n;r=o;break}do{if((s|0)==(t|0)){u=s+8|0}else{if(s>>>0<e>>>0){aO()}v=s+8|0;if((c[v>>2]|0)==(n|0)){u=v;break}aO()}}while(0);c[k+12>>2]=s;c[u>>2]=k;q=n;r=o;break}t=m;p=c[a+(l+24)>>2]|0;v=c[a+(l+12)>>2]|0;do{if((v|0)==(t|0)){w=a+(l+20)|0;x=c[w>>2]|0;if((x|0)==0){y=a+(l+16)|0;z=c[y>>2]|0;if((z|0)==0){A=0;break}else{B=z;C=y}}else{B=x;C=w}while(1){w=B+20|0;x=c[w>>2]|0;if((x|0)!=0){B=x;C=w;continue}w=B+16|0;x=c[w>>2]|0;if((x|0)==0){break}else{B=x;C=w}}if(C>>>0<e>>>0){aO()}else{c[C>>2]=0;A=B;break}}else{w=c[a+(l+8)>>2]|0;if(w>>>0<e>>>0){aO()}x=w+12|0;if((c[x>>2]|0)!=(t|0)){aO()}y=v+8|0;if((c[y>>2]|0)==(t|0)){c[x>>2]=v;c[y>>2]=w;A=v;break}else{aO()}}}while(0);if((p|0)==0){q=n;r=o;break}v=a+(l+28)|0;m=13336+(c[v>>2]<<2)|0;do{if((t|0)==(c[m>>2]|0)){c[m>>2]=A;if((A|0)!=0){break}c[3259]=c[3259]&(1<<c[v>>2]^-1);q=n;r=o;break L2779}else{if(p>>>0<(c[3262]|0)>>>0){aO()}k=p+16|0;if((c[k>>2]|0)==(t|0)){c[k>>2]=A}else{c[p+20>>2]=A}if((A|0)==0){q=n;r=o;break L2779}}}while(0);if(A>>>0<(c[3262]|0)>>>0){aO()}c[A+24>>2]=p;t=c[a+(l+16)>>2]|0;do{if((t|0)!=0){if(t>>>0<(c[3262]|0)>>>0){aO()}else{c[A+16>>2]=t;c[t+24>>2]=A;break}}}while(0);t=c[a+(l+20)>>2]|0;if((t|0)==0){q=n;r=o;break}if(t>>>0<(c[3262]|0)>>>0){aO()}else{c[A+20>>2]=t;c[t+24>>2]=A;q=n;r=o;break}}else{q=d;r=h}}while(0);d=q;if(d>>>0>=i>>>0){aO()}A=a+(h-4)|0;e=c[A>>2]|0;if((e&1|0)==0){aO()}do{if((e&2|0)==0){if((j|0)==(c[3264]|0)){B=(c[3261]|0)+r|0;c[3261]=B;c[3264]=q;c[q+4>>2]=B|1;if((q|0)==(c[3263]|0)){c[3263]=0;c[3260]=0}if(B>>>0<=(c[3265]|0)>>>0){return}vn(0)|0;return}if((j|0)==(c[3263]|0)){B=(c[3260]|0)+r|0;c[3260]=B;c[3263]=q;c[q+4>>2]=B|1;c[d+B>>2]=B;return}B=(e&-8)+r|0;C=e>>>3;L2884:do{if(e>>>0<256){u=c[a+h>>2]|0;g=c[a+(h|4)>>2]|0;b=13072+(C<<1<<2)|0;do{if((u|0)!=(b|0)){if(u>>>0<(c[3262]|0)>>>0){aO()}if((c[u+12>>2]|0)==(j|0)){break}aO()}}while(0);if((g|0)==(u|0)){c[3258]=c[3258]&(1<<C^-1);break}do{if((g|0)==(b|0)){D=g+8|0}else{if(g>>>0<(c[3262]|0)>>>0){aO()}f=g+8|0;if((c[f>>2]|0)==(j|0)){D=f;break}aO()}}while(0);c[u+12>>2]=g;c[D>>2]=u}else{b=i;f=c[a+(h+16)>>2]|0;t=c[a+(h|4)>>2]|0;do{if((t|0)==(b|0)){p=a+(h+12)|0;v=c[p>>2]|0;if((v|0)==0){m=a+(h+8)|0;k=c[m>>2]|0;if((k|0)==0){E=0;break}else{F=k;G=m}}else{F=v;G=p}while(1){p=F+20|0;v=c[p>>2]|0;if((v|0)!=0){F=v;G=p;continue}p=F+16|0;v=c[p>>2]|0;if((v|0)==0){break}else{F=v;G=p}}if(G>>>0<(c[3262]|0)>>>0){aO()}else{c[G>>2]=0;E=F;break}}else{p=c[a+h>>2]|0;if(p>>>0<(c[3262]|0)>>>0){aO()}v=p+12|0;if((c[v>>2]|0)!=(b|0)){aO()}m=t+8|0;if((c[m>>2]|0)==(b|0)){c[v>>2]=t;c[m>>2]=p;E=t;break}else{aO()}}}while(0);if((f|0)==0){break}t=a+(h+20)|0;u=13336+(c[t>>2]<<2)|0;do{if((b|0)==(c[u>>2]|0)){c[u>>2]=E;if((E|0)!=0){break}c[3259]=c[3259]&(1<<c[t>>2]^-1);break L2884}else{if(f>>>0<(c[3262]|0)>>>0){aO()}g=f+16|0;if((c[g>>2]|0)==(b|0)){c[g>>2]=E}else{c[f+20>>2]=E}if((E|0)==0){break L2884}}}while(0);if(E>>>0<(c[3262]|0)>>>0){aO()}c[E+24>>2]=f;b=c[a+(h+8)>>2]|0;do{if((b|0)!=0){if(b>>>0<(c[3262]|0)>>>0){aO()}else{c[E+16>>2]=b;c[b+24>>2]=E;break}}}while(0);b=c[a+(h+12)>>2]|0;if((b|0)==0){break}if(b>>>0<(c[3262]|0)>>>0){aO()}else{c[E+20>>2]=b;c[b+24>>2]=E;break}}}while(0);c[q+4>>2]=B|1;c[d+B>>2]=B;if((q|0)!=(c[3263]|0)){H=B;break}c[3260]=B;return}else{c[A>>2]=e&-2;c[q+4>>2]=r|1;c[d+r>>2]=r;H=r}}while(0);r=H>>>3;if(H>>>0<256){d=r<<1;e=13072+(d<<2)|0;A=c[3258]|0;E=1<<r;do{if((A&E|0)==0){c[3258]=A|E;I=e;J=13072+(d+2<<2)|0}else{r=13072+(d+2<<2)|0;h=c[r>>2]|0;if(h>>>0>=(c[3262]|0)>>>0){I=h;J=r;break}aO()}}while(0);c[J>>2]=q;c[I+12>>2]=q;c[q+8>>2]=I;c[q+12>>2]=e;return}e=q;I=H>>>8;do{if((I|0)==0){K=0}else{if(H>>>0>16777215){K=31;break}J=(I+1048320|0)>>>16&8;d=I<<J;E=(d+520192|0)>>>16&4;A=d<<E;d=(A+245760|0)>>>16&2;r=14-(E|J|d)+(A<<d>>>15)|0;K=H>>>((r+7|0)>>>0)&1|r<<1}}while(0);I=13336+(K<<2)|0;c[q+28>>2]=K;c[q+20>>2]=0;c[q+16>>2]=0;r=c[3259]|0;d=1<<K;do{if((r&d|0)==0){c[3259]=r|d;c[I>>2]=e;c[q+24>>2]=I;c[q+12>>2]=q;c[q+8>>2]=q}else{if((K|0)==31){L=0}else{L=25-(K>>>1)|0}A=H<<L;J=c[I>>2]|0;while(1){if((c[J+4>>2]&-8|0)==(H|0)){break}M=J+16+(A>>>31<<2)|0;E=c[M>>2]|0;if((E|0)==0){N=2536;break}else{A=A<<1;J=E}}if((N|0)==2536){if(M>>>0<(c[3262]|0)>>>0){aO()}else{c[M>>2]=e;c[q+24>>2]=J;c[q+12>>2]=q;c[q+8>>2]=q;break}}A=J+8|0;B=c[A>>2]|0;E=c[3262]|0;if(J>>>0<E>>>0){aO()}if(B>>>0<E>>>0){aO()}else{c[B+12>>2]=e;c[A>>2]=e;c[q+8>>2]=B;c[q+12>>2]=J;c[q+24>>2]=0;break}}}while(0);q=(c[3266]|0)-1|0;c[3266]=q;if((q|0)==0){O=13488}else{return}while(1){q=c[O>>2]|0;if((q|0)==0){break}else{O=q+8|0}}c[3266]=-1;return}function vj(a){a=a|0;return}function vk(a){a=a|0;return 6752|0}function vl(a){a=a|0;if((a|0)!=0){vi(a)}return}function vm(a){a=a|0;vl(a);return}function vn(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;do{if((c[104]|0)==0){b=a0(8)|0;if((b-1&b|0)==0){c[106]=b;c[105]=b;c[107]=-1;c[108]=2097152;c[109]=0;c[3369]=0;c[104]=(bj(0)|0)&-16^1431655768;break}else{aO();return 0;return 0}}}while(0);if(a>>>0>=4294967232){d=0;return d|0}b=c[3264]|0;if((b|0)==0){d=0;return d|0}e=c[3261]|0;do{if(e>>>0>(a+40|0)>>>0){f=c[106]|0;g=$((((-40-a-1+e+f|0)>>>0)/(f>>>0)>>>0)-1|0,f)|0;h=b;i=13480;while(1){j=c[i>>2]|0;if(j>>>0<=h>>>0){if((j+(c[i+4>>2]|0)|0)>>>0>h>>>0){k=i;break}}j=c[i+8>>2]|0;if((j|0)==0){k=0;break}else{i=j}}if((c[k+12>>2]&8|0)!=0){break}i=be(0)|0;h=k+4|0;if((i|0)!=((c[k>>2]|0)+(c[h>>2]|0)|0)){break}j=be(-(g>>>0>2147483646?-2147483648-f|0:g)|0)|0;l=be(0)|0;if(!((j|0)!=-1&l>>>0<i>>>0)){break}j=i-l|0;if((i|0)==(l|0)){break}c[h>>2]=(c[h>>2]|0)-j;c[3366]=(c[3366]|0)-j;h=c[3264]|0;m=(c[3261]|0)-j|0;j=h;n=h+8|0;if((n&7|0)==0){o=0}else{o=-n&7}n=m-o|0;c[3264]=j+o;c[3261]=n;c[j+(o+4)>>2]=n|1;c[j+(m+4)>>2]=40;c[3265]=c[108];d=(i|0)!=(l|0)&1;return d|0}}while(0);if((c[3261]|0)>>>0<=(c[3265]|0)>>>0){d=0;return d|0}c[3265]=-1;d=0;return d|0}function vo(a){a=a|0;var b=0,d=0,e=0;b=(a|0)==0?1:a;while(1){d=vh(b)|0;if((d|0)!=0){e=2620;break}a=(B=c[5692]|0,c[5692]=B+0,B);if((a|0)==0){break}bM[a&63]()}if((e|0)==2620){return d|0}d=bf(4)|0;c[d>>2]=19248;aN(d|0,21384,78);return 0}function vp(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;f=b|0;if((b&3)==(d&3)){while(b&3){if((e|0)==0)return f|0;a[b]=a[d]|0;b=b+1|0;d=d+1|0;e=e-1|0}while((e|0)>=4){c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0;e=e-4|0}}while((e|0)>0){a[b]=a[d]|0;b=b+1|0;d=d+1|0;e=e-1|0}return f|0}function vq(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=b+e|0;if((e|0)>=20){d=d&255;e=b&3;g=d|d<<8|d<<16|d<<24;h=f&~3;if(e){e=b+4-e|0;while((b|0)<(e|0)){a[b]=d;b=b+1|0}}while((b|0)<(h|0)){c[b>>2]=g;b=b+4|0}}while((b|0)<(f|0)){a[b]=d;b=b+1|0}}function vr(b){b=b|0;var c=0;c=b;while(a[c]|0){c=c+1|0}return c-b|0}function vs(){a1()}function vt(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;bl[a&63](b|0,c|0,d|0,e|0,f|0)}function vu(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(0,a|0,b|0,c|0,d|0,e|0)}function vv(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(1,a|0,b|0,c|0,d|0,e|0)}function vw(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(2,a|0,b|0,c|0,d|0,e|0)}function vx(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(3,a|0,b|0,c|0,d|0,e|0)}function vy(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(4,a|0,b|0,c|0,d|0,e|0)}function vz(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(5,a|0,b|0,c|0,d|0,e|0)}function vA(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(6,a|0,b|0,c|0,d|0,e|0)}function vB(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(7,a|0,b|0,c|0,d|0,e|0)}function vC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(8,a|0,b|0,c|0,d|0,e|0)}function vD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(9,a|0,b|0,c|0,d|0,e|0)}function vE(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(10,a|0,b|0,c|0,d|0,e|0)}function vF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(11,a|0,b|0,c|0,d|0,e|0)}function vG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(12,a|0,b|0,c|0,d|0,e|0)}function vH(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(13,a|0,b|0,c|0,d|0,e|0)}function vI(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(14,a|0,b|0,c|0,d|0,e|0)}function vJ(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(15,a|0,b|0,c|0,d|0,e|0)}function vK(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(16,a|0,b|0,c|0,d|0,e|0)}function vL(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(17,a|0,b|0,c|0,d|0,e|0)}function vM(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(18,a|0,b|0,c|0,d|0,e|0)}function vN(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;af(19,a|0,b|0,c|0,d|0,e|0)}function vO(a,b,c){a=a|0;b=b|0;c=+c;bm[a&255](b|0,+c)}function vP(a,b){a=a|0;b=+b;af(0,a|0,+b)}function vQ(a,b){a=a|0;b=+b;af(1,a|0,+b)}function vR(a,b){a=a|0;b=+b;af(2,a|0,+b)}function vS(a,b){a=a|0;b=+b;af(3,a|0,+b)}function vT(a,b){a=a|0;b=+b;af(4,a|0,+b)}function vU(a,b){a=a|0;b=+b;af(5,a|0,+b)}function vV(a,b){a=a|0;b=+b;af(6,a|0,+b)}function vW(a,b){a=a|0;b=+b;af(7,a|0,+b)}function vX(a,b){a=a|0;b=+b;af(8,a|0,+b)}function vY(a,b){a=a|0;b=+b;af(9,a|0,+b)}function vZ(a,b){a=a|0;b=+b;af(10,a|0,+b)}function v_(a,b){a=a|0;b=+b;af(11,a|0,+b)}function v$(a,b){a=a|0;b=+b;af(12,a|0,+b)}function v0(a,b){a=a|0;b=+b;af(13,a|0,+b)}function v1(a,b){a=a|0;b=+b;af(14,a|0,+b)}function v2(a,b){a=a|0;b=+b;af(15,a|0,+b)}function v3(a,b){a=a|0;b=+b;af(16,a|0,+b)}function v4(a,b){a=a|0;b=+b;af(17,a|0,+b)}function v5(a,b){a=a|0;b=+b;af(18,a|0,+b)}function v6(a,b){a=a|0;b=+b;af(19,a|0,+b)}function v7(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;bn[a&63](b|0,c|0,+d,e|0,f|0)}function v8(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(0,a|0,b|0,+c,d|0,e|0)}function v9(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(1,a|0,b|0,+c,d|0,e|0)}function wa(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(2,a|0,b|0,+c,d|0,e|0)}function wb(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(3,a|0,b|0,+c,d|0,e|0)}function wc(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(4,a|0,b|0,+c,d|0,e|0)}function wd(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(5,a|0,b|0,+c,d|0,e|0)}function we(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(6,a|0,b|0,+c,d|0,e|0)}function wf(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(7,a|0,b|0,+c,d|0,e|0)}function wg(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(8,a|0,b|0,+c,d|0,e|0)}function wh(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(9,a|0,b|0,+c,d|0,e|0)}function wi(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(10,a|0,b|0,+c,d|0,e|0)}function wj(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(11,a|0,b|0,+c,d|0,e|0)}function wk(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(12,a|0,b|0,+c,d|0,e|0)}function wl(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(13,a|0,b|0,+c,d|0,e|0)}function wm(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(14,a|0,b|0,+c,d|0,e|0)}function wn(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(15,a|0,b|0,+c,d|0,e|0)}function wo(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(16,a|0,b|0,+c,d|0,e|0)}function wp(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(17,a|0,b|0,+c,d|0,e|0)}function wq(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(18,a|0,b|0,+c,d|0,e|0)}function wr(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;af(19,a|0,b|0,+c,d|0,e|0)}function ws(a,b){a=a|0;b=b|0;bo[a&511](b|0)}function wt(a){a=a|0;af(0,a|0)}function wu(a){a=a|0;af(1,a|0)}function wv(a){a=a|0;af(2,a|0)}function ww(a){a=a|0;af(3,a|0)}function wx(a){a=a|0;af(4,a|0)}function wy(a){a=a|0;af(5,a|0)}function wz(a){a=a|0;af(6,a|0)}function wA(a){a=a|0;af(7,a|0)}function wB(a){a=a|0;af(8,a|0)}function wC(a){a=a|0;af(9,a|0)}function wD(a){a=a|0;af(10,a|0)}function wE(a){a=a|0;af(11,a|0)}function wF(a){a=a|0;af(12,a|0)}function wG(a){a=a|0;af(13,a|0)}function wH(a){a=a|0;af(14,a|0)}function wI(a){a=a|0;af(15,a|0)}function wJ(a){a=a|0;af(16,a|0)}function wK(a){a=a|0;af(17,a|0)}function wL(a){a=a|0;af(18,a|0)}function wM(a){a=a|0;af(19,a|0)}function wN(a,b,c){a=a|0;b=b|0;c=c|0;bp[a&511](b|0,c|0)}function wO(a,b){a=a|0;b=b|0;af(0,a|0,b|0)}function wP(a,b){a=a|0;b=b|0;af(1,a|0,b|0)}function wQ(a,b){a=a|0;b=b|0;af(2,a|0,b|0)}function wR(a,b){a=a|0;b=b|0;af(3,a|0,b|0)}function wS(a,b){a=a|0;b=b|0;af(4,a|0,b|0)}function wT(a,b){a=a|0;b=b|0;af(5,a|0,b|0)}function wU(a,b){a=a|0;b=b|0;af(6,a|0,b|0)}function wV(a,b){a=a|0;b=b|0;af(7,a|0,b|0)}function wW(a,b){a=a|0;b=b|0;af(8,a|0,b|0)}function wX(a,b){a=a|0;b=b|0;af(9,a|0,b|0)}function wY(a,b){a=a|0;b=b|0;af(10,a|0,b|0)}function wZ(a,b){a=a|0;b=b|0;af(11,a|0,b|0)}function w_(a,b){a=a|0;b=b|0;af(12,a|0,b|0)}function w$(a,b){a=a|0;b=b|0;af(13,a|0,b|0)}function w0(a,b){a=a|0;b=b|0;af(14,a|0,b|0)}function w1(a,b){a=a|0;b=b|0;af(15,a|0,b|0)}function w2(a,b){a=a|0;b=b|0;af(16,a|0,b|0)}function w3(a,b){a=a|0;b=b|0;af(17,a|0,b|0)}function w4(a,b){a=a|0;b=b|0;af(18,a|0,b|0)}function w5(a,b){a=a|0;b=b|0;af(19,a|0,b|0)}function w6(a,b){a=a|0;b=b|0;return bq[a&1023](b|0)|0}function w7(a){a=a|0;return af(0,a|0)|0}function w8(a){a=a|0;return af(1,a|0)|0}function w9(a){a=a|0;return af(2,a|0)|0}function xa(a){a=a|0;return af(3,a|0)|0}function xb(a){a=a|0;return af(4,a|0)|0}function xc(a){a=a|0;return af(5,a|0)|0}function xd(a){a=a|0;return af(6,a|0)|0}function xe(a){a=a|0;return af(7,a|0)|0}function xf(a){a=a|0;return af(8,a|0)|0}function xg(a){a=a|0;return af(9,a|0)|0}function xh(a){a=a|0;return af(10,a|0)|0}function xi(a){a=a|0;return af(11,a|0)|0}function xj(a){a=a|0;return af(12,a|0)|0}function xk(a){a=a|0;return af(13,a|0)|0}function xl(a){a=a|0;return af(14,a|0)|0}function xm(a){a=a|0;return af(15,a|0)|0}function xn(a){a=a|0;return af(16,a|0)|0}function xo(a){a=a|0;return af(17,a|0)|0}function xp(a){a=a|0;return af(18,a|0)|0}function xq(a){a=a|0;return af(19,a|0)|0}function xr(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;br[a&63](b|0,c|0,+d,e|0)}function xs(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(0,a|0,b|0,+c,d|0)}function xt(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(1,a|0,b|0,+c,d|0)}function xu(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(2,a|0,b|0,+c,d|0)}function xv(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(3,a|0,b|0,+c,d|0)}function xw(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(4,a|0,b|0,+c,d|0)}function xx(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(5,a|0,b|0,+c,d|0)}function xy(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(6,a|0,b|0,+c,d|0)}function xz(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(7,a|0,b|0,+c,d|0)}function xA(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(8,a|0,b|0,+c,d|0)}function xB(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(9,a|0,b|0,+c,d|0)}function xC(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(10,a|0,b|0,+c,d|0)}function xD(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(11,a|0,b|0,+c,d|0)}function xE(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(12,a|0,b|0,+c,d|0)}function xF(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(13,a|0,b|0,+c,d|0)}function xG(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(14,a|0,b|0,+c,d|0)}function xH(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(15,a|0,b|0,+c,d|0)}function xI(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(16,a|0,b|0,+c,d|0)}function xJ(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(17,a|0,b|0,+c,d|0)}function xK(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(18,a|0,b|0,+c,d|0)}function xL(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;af(19,a|0,b|0,+c,d|0)}function xM(a,b){a=a|0;b=+b;return bs[a&63](+b)|0}function xN(a){a=+a;return af(0,+a)|0}function xO(a){a=+a;return af(1,+a)|0}function xP(a){a=+a;return af(2,+a)|0}function xQ(a){a=+a;return af(3,+a)|0}function xR(a){a=+a;return af(4,+a)|0}function xS(a){a=+a;return af(5,+a)|0}function xT(a){a=+a;return af(6,+a)|0}function xU(a){a=+a;return af(7,+a)|0}function xV(a){a=+a;return af(8,+a)|0}function xW(a){a=+a;return af(9,+a)|0}function xX(a){a=+a;return af(10,+a)|0}function xY(a){a=+a;return af(11,+a)|0}function xZ(a){a=+a;return af(12,+a)|0}function x_(a){a=+a;return af(13,+a)|0}function x$(a){a=+a;return af(14,+a)|0}function x0(a){a=+a;return af(15,+a)|0}function x1(a){a=+a;return af(16,+a)|0}function x2(a){a=+a;return af(17,+a)|0}function x3(a){a=+a;return af(18,+a)|0}function x4(a){a=+a;return af(19,+a)|0}function x5(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return bt[a&63](b|0,c|0,d|0,e|0)|0}function x6(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(0,a|0,b|0,c|0,d|0)|0}function x7(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(1,a|0,b|0,c|0,d|0)|0}function x8(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(2,a|0,b|0,c|0,d|0)|0}function x9(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(3,a|0,b|0,c|0,d|0)|0}function ya(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(4,a|0,b|0,c|0,d|0)|0}function yb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(5,a|0,b|0,c|0,d|0)|0}function yc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(6,a|0,b|0,c|0,d|0)|0}function yd(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(7,a|0,b|0,c|0,d|0)|0}function ye(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(8,a|0,b|0,c|0,d|0)|0}function yf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(9,a|0,b|0,c|0,d|0)|0}function yg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(10,a|0,b|0,c|0,d|0)|0}function yh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(11,a|0,b|0,c|0,d|0)|0}function yi(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(12,a|0,b|0,c|0,d|0)|0}function yj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(13,a|0,b|0,c|0,d|0)|0}function yk(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(14,a|0,b|0,c|0,d|0)|0}function yl(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(15,a|0,b|0,c|0,d|0)|0}function ym(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(16,a|0,b|0,c|0,d|0)|0}function yn(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(17,a|0,b|0,c|0,d|0)|0}function yo(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(18,a|0,b|0,c|0,d|0)|0}function yp(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return af(19,a|0,b|0,c|0,d|0)|0}function yq(a,b,c,d,e,f){a=a|0;b=b|0;c=+c;d=+d;e=e|0;f=+f;bu[a&63](b|0,+c,+d,e|0,+f)}function yr(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(0,a|0,+b,+c,d|0,+e)}function ys(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(1,a|0,+b,+c,d|0,+e)}function yt(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(2,a|0,+b,+c,d|0,+e)}function yu(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(3,a|0,+b,+c,d|0,+e)}function yv(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(4,a|0,+b,+c,d|0,+e)}function yw(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(5,a|0,+b,+c,d|0,+e)}function yx(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(6,a|0,+b,+c,d|0,+e)}function yy(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(7,a|0,+b,+c,d|0,+e)}function yz(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(8,a|0,+b,+c,d|0,+e)}function yA(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(9,a|0,+b,+c,d|0,+e)}function yB(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(10,a|0,+b,+c,d|0,+e)}function yC(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(11,a|0,+b,+c,d|0,+e)}function yD(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(12,a|0,+b,+c,d|0,+e)}function yE(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(13,a|0,+b,+c,d|0,+e)}function yF(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(14,a|0,+b,+c,d|0,+e)}function yG(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(15,a|0,+b,+c,d|0,+e)}function yH(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(16,a|0,+b,+c,d|0,+e)}function yI(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(17,a|0,+b,+c,d|0,+e)}function yJ(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(18,a|0,+b,+c,d|0,+e)}function yK(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;af(19,a|0,+b,+c,d|0,+e)}function yL(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return bv[a&127](b|0,c|0,d|0)|0}function yM(a,b,c){a=a|0;b=b|0;c=c|0;return af(0,a|0,b|0,c|0)|0}function yN(a,b,c){a=a|0;b=b|0;c=c|0;return af(1,a|0,b|0,c|0)|0}function yO(a,b,c){a=a|0;b=b|0;c=c|0;return af(2,a|0,b|0,c|0)|0}function yP(a,b,c){a=a|0;b=b|0;c=c|0;return af(3,a|0,b|0,c|0)|0}function yQ(a,b,c){a=a|0;b=b|0;c=c|0;return af(4,a|0,b|0,c|0)|0}function yR(a,b,c){a=a|0;b=b|0;c=c|0;return af(5,a|0,b|0,c|0)|0}function yS(a,b,c){a=a|0;b=b|0;c=c|0;return af(6,a|0,b|0,c|0)|0}function yT(a,b,c){a=a|0;b=b|0;c=c|0;return af(7,a|0,b|0,c|0)|0}function yU(a,b,c){a=a|0;b=b|0;c=c|0;return af(8,a|0,b|0,c|0)|0}function yV(a,b,c){a=a|0;b=b|0;c=c|0;return af(9,a|0,b|0,c|0)|0}function yW(a,b,c){a=a|0;b=b|0;c=c|0;return af(10,a|0,b|0,c|0)|0}function yX(a,b,c){a=a|0;b=b|0;c=c|0;return af(11,a|0,b|0,c|0)|0}function yY(a,b,c){a=a|0;b=b|0;c=c|0;return af(12,a|0,b|0,c|0)|0}function yZ(a,b,c){a=a|0;b=b|0;c=c|0;return af(13,a|0,b|0,c|0)|0}function y_(a,b,c){a=a|0;b=b|0;c=c|0;return af(14,a|0,b|0,c|0)|0}function y$(a,b,c){a=a|0;b=b|0;c=c|0;return af(15,a|0,b|0,c|0)|0}function y0(a,b,c){a=a|0;b=b|0;c=c|0;return af(16,a|0,b|0,c|0)|0}function y1(a,b,c){a=a|0;b=b|0;c=c|0;return af(17,a|0,b|0,c|0)|0}function y2(a,b,c){a=a|0;b=b|0;c=c|0;return af(18,a|0,b|0,c|0)|0}function y3(a,b,c){a=a|0;b=b|0;c=c|0;return af(19,a|0,b|0,c|0)|0}function y4(a,b,c){a=a|0;b=b|0;c=+c;return+bw[a&127](b|0,+c)}function y5(a,b){a=a|0;b=+b;return+af(0,a|0,+b)}function y6(a,b){a=a|0;b=+b;return+af(1,a|0,+b)}function y7(a,b){a=a|0;b=+b;return+af(2,a|0,+b)}function y8(a,b){a=a|0;b=+b;return+af(3,a|0,+b)}function y9(a,b){a=a|0;b=+b;return+af(4,a|0,+b)}function za(a,b){a=a|0;b=+b;return+af(5,a|0,+b)}function zb(a,b){a=a|0;b=+b;return+af(6,a|0,+b)}function zc(a,b){a=a|0;b=+b;return+af(7,a|0,+b)}function zd(a,b){a=a|0;b=+b;return+af(8,a|0,+b)}function ze(a,b){a=a|0;b=+b;return+af(9,a|0,+b)}function zf(a,b){a=a|0;b=+b;return+af(10,a|0,+b)}function zg(a,b){a=a|0;b=+b;return+af(11,a|0,+b)}function zh(a,b){a=a|0;b=+b;return+af(12,a|0,+b)}function zi(a,b){a=a|0;b=+b;return+af(13,a|0,+b)}function zj(a,b){a=a|0;b=+b;return+af(14,a|0,+b)}function zk(a,b){a=a|0;b=+b;return+af(15,a|0,+b)}function zl(a,b){a=a|0;b=+b;return+af(16,a|0,+b)}function zm(a,b){a=a|0;b=+b;return+af(17,a|0,+b)}function zn(a,b){a=a|0;b=+b;return+af(18,a|0,+b)}function zo(a,b){a=a|0;b=+b;return+af(19,a|0,+b)}function zp(a,b,c,d){a=a|0;b=b|0;c=+c;d=+d;bx[a&63](b|0,+c,+d)}function zq(a,b,c){a=a|0;b=+b;c=+c;af(0,a|0,+b,+c)}function zr(a,b,c){a=a|0;b=+b;c=+c;af(1,a|0,+b,+c)}function zs(a,b,c){a=a|0;b=+b;c=+c;af(2,a|0,+b,+c)}function zt(a,b,c){a=a|0;b=+b;c=+c;af(3,a|0,+b,+c)}function zu(a,b,c){a=a|0;b=+b;c=+c;af(4,a|0,+b,+c)}function zv(a,b,c){a=a|0;b=+b;c=+c;af(5,a|0,+b,+c)}function zw(a,b,c){a=a|0;b=+b;c=+c;af(6,a|0,+b,+c)}function zx(a,b,c){a=a|0;b=+b;c=+c;af(7,a|0,+b,+c)}function zy(a,b,c){a=a|0;b=+b;c=+c;af(8,a|0,+b,+c)}function zz(a,b,c){a=a|0;b=+b;c=+c;af(9,a|0,+b,+c)}function zA(a,b,c){a=a|0;b=+b;c=+c;af(10,a|0,+b,+c)}function zB(a,b,c){a=a|0;b=+b;c=+c;af(11,a|0,+b,+c)}function zC(a,b,c){a=a|0;b=+b;c=+c;af(12,a|0,+b,+c)}function zD(a,b,c){a=a|0;b=+b;c=+c;af(13,a|0,+b,+c)}function zE(a,b,c){a=a|0;b=+b;c=+c;af(14,a|0,+b,+c)}function zF(a,b,c){a=a|0;b=+b;c=+c;af(15,a|0,+b,+c)}function zG(a,b,c){a=a|0;b=+b;c=+c;af(16,a|0,+b,+c)}function zH(a,b,c){a=a|0;b=+b;c=+c;af(17,a|0,+b,+c)}function zI(a,b,c){a=a|0;b=+b;c=+c;af(18,a|0,+b,+c)}function zJ(a,b,c){a=a|0;b=+b;c=+c;af(19,a|0,+b,+c)}function zK(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=+i;by[a&63](b|0,c|0,d|0,e|0,f|0,g|0,h|0,+i)}function zL(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(0,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function zM(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(1,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function zN(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(2,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function zO(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(3,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function zP(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(4,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function zQ(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(5,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function zR(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(6,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function zS(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(7,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function zT(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(8,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function zU(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(9,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function zV(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(10,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function zW(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(11,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function zX(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(12,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function zY(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(13,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function zZ(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(14,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function z_(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(15,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function z$(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(16,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function z0(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(17,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function z1(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(18,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function z2(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;af(19,a|0,b|0,c|0,d|0,e|0,f|0,g|0,+h)}function z3(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=+d;e=+e;bz[a&63](b|0,+c,+d,+e)}function z4(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(0,a|0,+b,+c,+d)}function z5(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(1,a|0,+b,+c,+d)}function z6(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(2,a|0,+b,+c,+d)}function z7(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(3,a|0,+b,+c,+d)}function z8(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(4,a|0,+b,+c,+d)}function z9(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(5,a|0,+b,+c,+d)}function Aa(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(6,a|0,+b,+c,+d)}function Ab(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(7,a|0,+b,+c,+d)}function Ac(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(8,a|0,+b,+c,+d)}function Ad(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(9,a|0,+b,+c,+d)}function Ae(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(10,a|0,+b,+c,+d)}function Af(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(11,a|0,+b,+c,+d)}function Ag(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(12,a|0,+b,+c,+d)}function Ah(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(13,a|0,+b,+c,+d)}function Ai(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(14,a|0,+b,+c,+d)}function Aj(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(15,a|0,+b,+c,+d)}function Ak(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(16,a|0,+b,+c,+d)}function Al(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(17,a|0,+b,+c,+d)}function Am(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(18,a|0,+b,+c,+d)}function An(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;af(19,a|0,+b,+c,+d)}function Ao(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;bA[a&63](b|0,c|0,d|0,e|0,f|0,g|0)}function Ap(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(0,a|0,b|0,c|0,d|0,e|0,f|0)}function Aq(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(1,a|0,b|0,c|0,d|0,e|0,f|0)}function Ar(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(2,a|0,b|0,c|0,d|0,e|0,f|0)}function As(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(3,a|0,b|0,c|0,d|0,e|0,f|0)}function At(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(4,a|0,b|0,c|0,d|0,e|0,f|0)}function Au(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(5,a|0,b|0,c|0,d|0,e|0,f|0)}function Av(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(6,a|0,b|0,c|0,d|0,e|0,f|0)}function Aw(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(7,a|0,b|0,c|0,d|0,e|0,f|0)}function Ax(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(8,a|0,b|0,c|0,d|0,e|0,f|0)}function Ay(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(9,a|0,b|0,c|0,d|0,e|0,f|0)}function Az(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(10,a|0,b|0,c|0,d|0,e|0,f|0)}function AA(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(11,a|0,b|0,c|0,d|0,e|0,f|0)}function AB(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(12,a|0,b|0,c|0,d|0,e|0,f|0)}function AC(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(13,a|0,b|0,c|0,d|0,e|0,f|0)}function AD(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(14,a|0,b|0,c|0,d|0,e|0,f|0)}function AE(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(15,a|0,b|0,c|0,d|0,e|0,f|0)}function AF(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(16,a|0,b|0,c|0,d|0,e|0,f|0)}function AG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(17,a|0,b|0,c|0,d|0,e|0,f|0)}function AH(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(18,a|0,b|0,c|0,d|0,e|0,f|0)}function AI(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;af(19,a|0,b|0,c|0,d|0,e|0,f|0)}function AJ(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return bB[a&63](b|0,c|0,+d)|0}function AK(a,b,c){a=a|0;b=b|0;c=+c;return af(0,a|0,b|0,+c)|0}function AL(a,b,c){a=a|0;b=b|0;c=+c;return af(1,a|0,b|0,+c)|0}function AM(a,b,c){a=a|0;b=b|0;c=+c;return af(2,a|0,b|0,+c)|0}function AN(a,b,c){a=a|0;b=b|0;c=+c;return af(3,a|0,b|0,+c)|0}function AO(a,b,c){a=a|0;b=b|0;c=+c;return af(4,a|0,b|0,+c)|0}function AP(a,b,c){a=a|0;b=b|0;c=+c;return af(5,a|0,b|0,+c)|0}function AQ(a,b,c){a=a|0;b=b|0;c=+c;return af(6,a|0,b|0,+c)|0}function AR(a,b,c){a=a|0;b=b|0;c=+c;return af(7,a|0,b|0,+c)|0}function AS(a,b,c){a=a|0;b=b|0;c=+c;return af(8,a|0,b|0,+c)|0}function AT(a,b,c){a=a|0;b=b|0;c=+c;return af(9,a|0,b|0,+c)|0}function AU(a,b,c){a=a|0;b=b|0;c=+c;return af(10,a|0,b|0,+c)|0}function AV(a,b,c){a=a|0;b=b|0;c=+c;return af(11,a|0,b|0,+c)|0}function AW(a,b,c){a=a|0;b=b|0;c=+c;return af(12,a|0,b|0,+c)|0}function AX(a,b,c){a=a|0;b=b|0;c=+c;return af(13,a|0,b|0,+c)|0}function AY(a,b,c){a=a|0;b=b|0;c=+c;return af(14,a|0,b|0,+c)|0}function AZ(a,b,c){a=a|0;b=b|0;c=+c;return af(15,a|0,b|0,+c)|0}function A_(a,b,c){a=a|0;b=b|0;c=+c;return af(16,a|0,b|0,+c)|0}function A$(a,b,c){a=a|0;b=b|0;c=+c;return af(17,a|0,b|0,+c)|0}function A0(a,b,c){a=a|0;b=b|0;c=+c;return af(18,a|0,b|0,+c)|0}function A1(a,b,c){a=a|0;b=b|0;c=+c;return af(19,a|0,b|0,+c)|0}function A2(a,b,c){a=a|0;b=b|0;c=+c;return bC[a&63](b|0,+c)|0}function A3(a,b){a=a|0;b=+b;return af(0,a|0,+b)|0}function A4(a,b){a=a|0;b=+b;return af(1,a|0,+b)|0}function A5(a,b){a=a|0;b=+b;return af(2,a|0,+b)|0}function A6(a,b){a=a|0;b=+b;return af(3,a|0,+b)|0}function A7(a,b){a=a|0;b=+b;return af(4,a|0,+b)|0}function A8(a,b){a=a|0;b=+b;return af(5,a|0,+b)|0}function A9(a,b){a=a|0;b=+b;return af(6,a|0,+b)|0}function Ba(a,b){a=a|0;b=+b;return af(7,a|0,+b)|0}function Bb(a,b){a=a|0;b=+b;return af(8,a|0,+b)|0}function Bc(a,b){a=a|0;b=+b;return af(9,a|0,+b)|0}function Bd(a,b){a=a|0;b=+b;return af(10,a|0,+b)|0}function Be(a,b){a=a|0;b=+b;return af(11,a|0,+b)|0}function Bf(a,b){a=a|0;b=+b;return af(12,a|0,+b)|0}function Bg(a,b){a=a|0;b=+b;return af(13,a|0,+b)|0}function Bh(a,b){a=a|0;b=+b;return af(14,a|0,+b)|0}function Bi(a,b){a=a|0;b=+b;return af(15,a|0,+b)|0}function Bj(a,b){a=a|0;b=+b;return af(16,a|0,+b)|0}function Bk(a,b){a=a|0;b=+b;return af(17,a|0,+b)|0}function Bl(a,b){a=a|0;b=+b;return af(18,a|0,+b)|0}function Bm(a,b){a=a|0;b=+b;return af(19,a|0,+b)|0}function Bn(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;bD[a&63](b|0,+c,d|0,e|0)}function Bo(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(0,a|0,+b,c|0,d|0)}function Bp(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(1,a|0,+b,c|0,d|0)}function Bq(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(2,a|0,+b,c|0,d|0)}function Br(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(3,a|0,+b,c|0,d|0)}function Bs(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(4,a|0,+b,c|0,d|0)}function Bt(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(5,a|0,+b,c|0,d|0)}function Bu(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(6,a|0,+b,c|0,d|0)}function Bv(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(7,a|0,+b,c|0,d|0)}function Bw(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(8,a|0,+b,c|0,d|0)}function Bx(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(9,a|0,+b,c|0,d|0)}function By(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(10,a|0,+b,c|0,d|0)}function Bz(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(11,a|0,+b,c|0,d|0)}function BA(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(12,a|0,+b,c|0,d|0)}function BB(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(13,a|0,+b,c|0,d|0)}function BC(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(14,a|0,+b,c|0,d|0)}function BD(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(15,a|0,+b,c|0,d|0)}function BE(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(16,a|0,+b,c|0,d|0)}function BF(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(17,a|0,+b,c|0,d|0)}function BG(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(18,a|0,+b,c|0,d|0)}function BH(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;af(19,a|0,+b,c|0,d|0)}function BI(a,b){a=a|0;b=b|0;return+bE[a&511](b|0)}function BJ(a){a=a|0;return+af(0,a|0)}function BK(a){a=a|0;return+af(1,a|0)}function BL(a){a=a|0;return+af(2,a|0)}function BM(a){a=a|0;return+af(3,a|0)}function BN(a){a=a|0;return+af(4,a|0)}function BO(a){a=a|0;return+af(5,a|0)}function BP(a){a=a|0;return+af(6,a|0)}function BQ(a){a=a|0;return+af(7,a|0)}function BR(a){a=a|0;return+af(8,a|0)}function BS(a){a=a|0;return+af(9,a|0)}function BT(a){a=a|0;return+af(10,a|0)}function BU(a){a=a|0;return+af(11,a|0)}function BV(a){a=a|0;return+af(12,a|0)}function BW(a){a=a|0;return+af(13,a|0)}function BX(a){a=a|0;return+af(14,a|0)}function BY(a){a=a|0;return+af(15,a|0)}function BZ(a){a=a|0;return+af(16,a|0)}function B_(a){a=a|0;return+af(17,a|0)}function B$(a){a=a|0;return+af(18,a|0)}function B0(a){a=a|0;return+af(19,a|0)}function B1(a,b,c){a=a|0;b=b|0;c=c|0;return bF[a&255](b|0,c|0)|0}function B2(a,b){a=a|0;b=b|0;return af(0,a|0,b|0)|0}function B3(a,b){a=a|0;b=b|0;return af(1,a|0,b|0)|0}function B4(a,b){a=a|0;b=b|0;return af(2,a|0,b|0)|0}function B5(a,b){a=a|0;b=b|0;return af(3,a|0,b|0)|0}function B6(a,b){a=a|0;b=b|0;return af(4,a|0,b|0)|0}function B7(a,b){a=a|0;b=b|0;return af(5,a|0,b|0)|0}function B8(a,b){a=a|0;b=b|0;return af(6,a|0,b|0)|0}function B9(a,b){a=a|0;b=b|0;return af(7,a|0,b|0)|0}function Ca(a,b){a=a|0;b=b|0;return af(8,a|0,b|0)|0}function Cb(a,b){a=a|0;b=b|0;return af(9,a|0,b|0)|0}function Cc(a,b){a=a|0;b=b|0;return af(10,a|0,b|0)|0}function Cd(a,b){a=a|0;b=b|0;return af(11,a|0,b|0)|0}function Ce(a,b){a=a|0;b=b|0;return af(12,a|0,b|0)|0}function Cf(a,b){a=a|0;b=b|0;return af(13,a|0,b|0)|0}function Cg(a,b){a=a|0;b=b|0;return af(14,a|0,b|0)|0}function Ch(a,b){a=a|0;b=b|0;return af(15,a|0,b|0)|0}function Ci(a,b){a=a|0;b=b|0;return af(16,a|0,b|0)|0}function Cj(a,b){a=a|0;b=b|0;return af(17,a|0,b|0)|0}function Ck(a,b){a=a|0;b=b|0;return af(18,a|0,b|0)|0}function Cl(a,b){a=a|0;b=b|0;return af(19,a|0,b|0)|0}function Cm(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;return+bG[a&63](b|0,c|0,d|0,e|0,+f)}function Cn(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(0,a|0,b|0,c|0,d|0,+e)}function Co(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(1,a|0,b|0,c|0,d|0,+e)}function Cp(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(2,a|0,b|0,c|0,d|0,+e)}function Cq(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(3,a|0,b|0,c|0,d|0,+e)}function Cr(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(4,a|0,b|0,c|0,d|0,+e)}function Cs(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(5,a|0,b|0,c|0,d|0,+e)}function Ct(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(6,a|0,b|0,c|0,d|0,+e)}function Cu(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(7,a|0,b|0,c|0,d|0,+e)}function Cv(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(8,a|0,b|0,c|0,d|0,+e)}function Cw(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(9,a|0,b|0,c|0,d|0,+e)}function Cx(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(10,a|0,b|0,c|0,d|0,+e)}function Cy(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(11,a|0,b|0,c|0,d|0,+e)}function Cz(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(12,a|0,b|0,c|0,d|0,+e)}function CA(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(13,a|0,b|0,c|0,d|0,+e)}function CB(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(14,a|0,b|0,c|0,d|0,+e)}function CC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(15,a|0,b|0,c|0,d|0,+e)}function CD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(16,a|0,b|0,c|0,d|0,+e)}function CE(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(17,a|0,b|0,c|0,d|0,+e)}function CF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(18,a|0,b|0,c|0,d|0,+e)}function CG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return+af(19,a|0,b|0,c|0,d|0,+e)}function CH(a){a=a|0;return bH[a&127]()|0}function CI(){return af(0)|0}function CJ(){return af(1)|0}function CK(){return af(2)|0}function CL(){return af(3)|0}function CM(){return af(4)|0}function CN(){return af(5)|0}function CO(){return af(6)|0}function CP(){return af(7)|0}function CQ(){return af(8)|0}function CR(){return af(9)|0}function CS(){return af(10)|0}function CT(){return af(11)|0}function CU(){return af(12)|0}function CV(){return af(13)|0}function CW(){return af(14)|0}function CX(){return af(15)|0}function CY(){return af(16)|0}function CZ(){return af(17)|0}function C_(){return af(18)|0}function C$(){return af(19)|0}function C0(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return bI[a&127](b|0,c|0,d|0,e|0,f|0)|0}function C1(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(0,a|0,b|0,c|0,d|0,e|0)|0}function C2(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(1,a|0,b|0,c|0,d|0,e|0)|0}function C3(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(2,a|0,b|0,c|0,d|0,e|0)|0}function C4(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(3,a|0,b|0,c|0,d|0,e|0)|0}function C5(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(4,a|0,b|0,c|0,d|0,e|0)|0}function C6(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(5,a|0,b|0,c|0,d|0,e|0)|0}function C7(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(6,a|0,b|0,c|0,d|0,e|0)|0}function C8(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(7,a|0,b|0,c|0,d|0,e|0)|0}function C9(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(8,a|0,b|0,c|0,d|0,e|0)|0}function Da(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(9,a|0,b|0,c|0,d|0,e|0)|0}function Db(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(10,a|0,b|0,c|0,d|0,e|0)|0}function Dc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(11,a|0,b|0,c|0,d|0,e|0)|0}function Dd(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(12,a|0,b|0,c|0,d|0,e|0)|0}function De(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(13,a|0,b|0,c|0,d|0,e|0)|0}function Df(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(14,a|0,b|0,c|0,d|0,e|0)|0}function Dg(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(15,a|0,b|0,c|0,d|0,e|0)|0}function Dh(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(16,a|0,b|0,c|0,d|0,e|0)|0}function Di(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(17,a|0,b|0,c|0,d|0,e|0)|0}function Dj(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(18,a|0,b|0,c|0,d|0,e|0)|0}function Dk(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return af(19,a|0,b|0,c|0,d|0,e|0)|0}function Dl(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;return bJ[a&63](+b,+c,+d)|0}function Dm(a,b,c){a=+a;b=+b;c=+c;return af(0,+a,+b,+c)|0}function Dn(a,b,c){a=+a;b=+b;c=+c;return af(1,+a,+b,+c)|0}function Do(a,b,c){a=+a;b=+b;c=+c;return af(2,+a,+b,+c)|0}function Dp(a,b,c){a=+a;b=+b;c=+c;return af(3,+a,+b,+c)|0}function Dq(a,b,c){a=+a;b=+b;c=+c;return af(4,+a,+b,+c)|0}function Dr(a,b,c){a=+a;b=+b;c=+c;return af(5,+a,+b,+c)|0}function Ds(a,b,c){a=+a;b=+b;c=+c;return af(6,+a,+b,+c)|0}function Dt(a,b,c){a=+a;b=+b;c=+c;return af(7,+a,+b,+c)|0}function Du(a,b,c){a=+a;b=+b;c=+c;return af(8,+a,+b,+c)|0}function Dv(a,b,c){a=+a;b=+b;c=+c;return af(9,+a,+b,+c)|0}function Dw(a,b,c){a=+a;b=+b;c=+c;return af(10,+a,+b,+c)|0}function Dx(a,b,c){a=+a;b=+b;c=+c;return af(11,+a,+b,+c)|0}function Dy(a,b,c){a=+a;b=+b;c=+c;return af(12,+a,+b,+c)|0}function Dz(a,b,c){a=+a;b=+b;c=+c;return af(13,+a,+b,+c)|0}function DA(a,b,c){a=+a;b=+b;c=+c;return af(14,+a,+b,+c)|0}function DB(a,b,c){a=+a;b=+b;c=+c;return af(15,+a,+b,+c)|0}function DC(a,b,c){a=+a;b=+b;c=+c;return af(16,+a,+b,+c)|0}function DD(a,b,c){a=+a;b=+b;c=+c;return af(17,+a,+b,+c)|0}function DE(a,b,c){a=+a;b=+b;c=+c;return af(18,+a,+b,+c)|0}function DF(a,b,c){a=+a;b=+b;c=+c;return af(19,+a,+b,+c)|0}function DG(a,b,c){a=a|0;b=+b;c=+c;return bK[a&63](+b,+c)|0}function DH(a,b){a=+a;b=+b;return af(0,+a,+b)|0}function DI(a,b){a=+a;b=+b;return af(1,+a,+b)|0}function DJ(a,b){a=+a;b=+b;return af(2,+a,+b)|0}function DK(a,b){a=+a;b=+b;return af(3,+a,+b)|0}function DL(a,b){a=+a;b=+b;return af(4,+a,+b)|0}function DM(a,b){a=+a;b=+b;return af(5,+a,+b)|0}function DN(a,b){a=+a;b=+b;return af(6,+a,+b)|0}function DO(a,b){a=+a;b=+b;return af(7,+a,+b)|0}function DP(a,b){a=+a;b=+b;return af(8,+a,+b)|0}function DQ(a,b){a=+a;b=+b;return af(9,+a,+b)|0}function DR(a,b){a=+a;b=+b;return af(10,+a,+b)|0}function DS(a,b){a=+a;b=+b;return af(11,+a,+b)|0}function DT(a,b){a=+a;b=+b;return af(12,+a,+b)|0}function DU(a,b){a=+a;b=+b;return af(13,+a,+b)|0}function DV(a,b){a=+a;b=+b;return af(14,+a,+b)|0}function DW(a,b){a=+a;b=+b;return af(15,+a,+b)|0}function DX(a,b){a=+a;b=+b;return af(16,+a,+b)|0}function DY(a,b){a=+a;b=+b;return af(17,+a,+b)|0}function DZ(a,b){a=+a;b=+b;return af(18,+a,+b)|0}function D_(a,b){a=+a;b=+b;return af(19,+a,+b)|0}function D$(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;bL[a&127](b|0,c|0,d|0)}function D0(a,b,c){a=a|0;b=b|0;c=c|0;af(0,a|0,b|0,c|0)}function D1(a,b,c){a=a|0;b=b|0;c=c|0;af(1,a|0,b|0,c|0)}function D2(a,b,c){a=a|0;b=b|0;c=c|0;af(2,a|0,b|0,c|0)}function D3(a,b,c){a=a|0;b=b|0;c=c|0;af(3,a|0,b|0,c|0)}function D4(a,b,c){a=a|0;b=b|0;c=c|0;af(4,a|0,b|0,c|0)}function D5(a,b,c){a=a|0;b=b|0;c=c|0;af(5,a|0,b|0,c|0)}function D6(a,b,c){a=a|0;b=b|0;c=c|0;af(6,a|0,b|0,c|0)}function D7(a,b,c){a=a|0;b=b|0;c=c|0;af(7,a|0,b|0,c|0)}function D8(a,b,c){a=a|0;b=b|0;c=c|0;af(8,a|0,b|0,c|0)}function D9(a,b,c){a=a|0;b=b|0;c=c|0;af(9,a|0,b|0,c|0)}function Ea(a,b,c){a=a|0;b=b|0;c=c|0;af(10,a|0,b|0,c|0)}function Eb(a,b,c){a=a|0;b=b|0;c=c|0;af(11,a|0,b|0,c|0)}function Ec(a,b,c){a=a|0;b=b|0;c=c|0;af(12,a|0,b|0,c|0)}function Ed(a,b,c){a=a|0;b=b|0;c=c|0;af(13,a|0,b|0,c|0)}function Ee(a,b,c){a=a|0;b=b|0;c=c|0;af(14,a|0,b|0,c|0)}function Ef(a,b,c){a=a|0;b=b|0;c=c|0;af(15,a|0,b|0,c|0)}function Eg(a,b,c){a=a|0;b=b|0;c=c|0;af(16,a|0,b|0,c|0)}function Eh(a,b,c){a=a|0;b=b|0;c=c|0;af(17,a|0,b|0,c|0)}function Ei(a,b,c){a=a|0;b=b|0;c=c|0;af(18,a|0,b|0,c|0)}function Ej(a,b,c){a=a|0;b=b|0;c=c|0;af(19,a|0,b|0,c|0)}function Ek(a){a=a|0;bM[a&63]()}function El(){af(0)}function Em(){af(1)}function En(){af(2)}function Eo(){af(3)}function Ep(){af(4)}function Eq(){af(5)}function Er(){af(6)}function Es(){af(7)}function Et(){af(8)}function Eu(){af(9)}function Ev(){af(10)}function Ew(){af(11)}function Ex(){af(12)}function Ey(){af(13)}function Ez(){af(14)}function EA(){af(15)}function EB(){af(16)}function EC(){af(17)}function ED(){af(18)}function EE(){af(19)}function EF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;bN[a&127](b|0,c|0,+d)}function EG(a,b,c){a=a|0;b=b|0;c=+c;af(0,a|0,b|0,+c)}function EH(a,b,c){a=a|0;b=b|0;c=+c;af(1,a|0,b|0,+c)}function EI(a,b,c){a=a|0;b=b|0;c=+c;af(2,a|0,b|0,+c)}function EJ(a,b,c){a=a|0;b=b|0;c=+c;af(3,a|0,b|0,+c)}function EK(a,b,c){a=a|0;b=b|0;c=+c;af(4,a|0,b|0,+c)}function EL(a,b,c){a=a|0;b=b|0;c=+c;af(5,a|0,b|0,+c)}function EM(a,b,c){a=a|0;b=b|0;c=+c;af(6,a|0,b|0,+c)}function EN(a,b,c){a=a|0;b=b|0;c=+c;af(7,a|0,b|0,+c)}function EO(a,b,c){a=a|0;b=b|0;c=+c;af(8,a|0,b|0,+c)}function EP(a,b,c){a=a|0;b=b|0;c=+c;af(9,a|0,b|0,+c)}function EQ(a,b,c){a=a|0;b=b|0;c=+c;af(10,a|0,b|0,+c)}function ER(a,b,c){a=a|0;b=b|0;c=+c;af(11,a|0,b|0,+c)}function ES(a,b,c){a=a|0;b=b|0;c=+c;af(12,a|0,b|0,+c)}function ET(a,b,c){a=a|0;b=b|0;c=+c;af(13,a|0,b|0,+c)}function EU(a,b,c){a=a|0;b=b|0;c=+c;af(14,a|0,b|0,+c)}function EV(a,b,c){a=a|0;b=b|0;c=+c;af(15,a|0,b|0,+c)}function EW(a,b,c){a=a|0;b=b|0;c=+c;af(16,a|0,b|0,+c)}function EX(a,b,c){a=a|0;b=b|0;c=+c;af(17,a|0,b|0,+c)}function EY(a,b,c){a=a|0;b=b|0;c=+c;af(18,a|0,b|0,+c)}function EZ(a,b,c){a=a|0;b=b|0;c=+c;af(19,a|0,b|0,+c)}function E_(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;bO[a&127](b|0,c|0,d|0,e|0)}function E$(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(0,a|0,b|0,c|0,d|0)}function E0(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(1,a|0,b|0,c|0,d|0)}function E1(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(2,a|0,b|0,c|0,d|0)}function E2(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(3,a|0,b|0,c|0,d|0)}function E3(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(4,a|0,b|0,c|0,d|0)}function E4(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(5,a|0,b|0,c|0,d|0)}function E5(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(6,a|0,b|0,c|0,d|0)}function E6(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(7,a|0,b|0,c|0,d|0)}function E7(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(8,a|0,b|0,c|0,d|0)}function E8(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(9,a|0,b|0,c|0,d|0)}function E9(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(10,a|0,b|0,c|0,d|0)}function Fa(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(11,a|0,b|0,c|0,d|0)}function Fb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(12,a|0,b|0,c|0,d|0)}function Fc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(13,a|0,b|0,c|0,d|0)}function Fd(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(14,a|0,b|0,c|0,d|0)}function Fe(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(15,a|0,b|0,c|0,d|0)}function Ff(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(16,a|0,b|0,c|0,d|0)}function Fg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(17,a|0,b|0,c|0,d|0)}function Fh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(18,a|0,b|0,c|0,d|0)}function Fi(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;af(19,a|0,b|0,c|0,d|0)}function Fj(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;aa(0)}function Fk(a,b){a=a|0;b=+b;aa(1)}function Fl(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;aa(2)}function Fm(a){a=a|0;aa(3)}function Fn(a,b){a=a|0;b=b|0;aa(4)}function Fo(a){a=a|0;aa(5);return 0}function Fp(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;aa(6)}function Fq(a){a=+a;aa(7);return 0}function Fr(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;aa(8);return 0}function Fs(a,b,c,d,e){a=a|0;b=+b;c=+c;d=d|0;e=+e;aa(9)}function Ft(a,b,c){a=a|0;b=b|0;c=c|0;aa(10);return 0}function Fu(a,b){a=a|0;b=+b;aa(11);return 0.0}function Fv(a,b,c){a=a|0;b=+b;c=+c;aa(12)}function Fw(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;aa(13)}function Fx(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;aa(14)}function Fy(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;aa(15)}function Fz(a,b,c){a=a|0;b=b|0;c=+c;aa(16);return 0}function FA(a,b){a=a|0;b=+b;aa(17);return 0}function FB(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;aa(18)}function FC(a){a=a|0;aa(19);return 0.0}function FD(a,b){a=a|0;b=b|0;aa(20);return 0}function FE(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;aa(21);return 0.0}function FF(){aa(22);return 0}function FG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;aa(23);return 0}function FH(a,b,c){a=+a;b=+b;c=+c;aa(24);return 0}function FI(a,b){a=+a;b=+b;aa(25);return 0}function FJ(a,b,c){a=a|0;b=b|0;c=c|0;aa(26)}function FK(){aa(27)}function FL(a,b,c){a=a|0;b=b|0;c=+c;aa(28)}function FM(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;aa(29)}
var bl=[Fj,Fj,vu,Fj,vv,Fj,vw,Fj,vx,Fj,vy,Fj,vz,Fj,vA,Fj,vB,Fj,vC,Fj,vD,Fj,vE,Fj,vF,Fj,vG,Fj,vH,Fj,vI,Fj,vJ,Fj,vK,Fj,vL,Fj,vM,Fj,vN,Fj,rE,Fj,u$,Fj,ve,Fj,u_,Fj,q9,Fj,Fj,Fj,Fj,Fj,Fj,Fj,Fj,Fj,Fj,Fj,Fj,Fj];var bm=[Fk,Fk,vP,Fk,vQ,Fk,vR,Fk,vS,Fk,vT,Fk,vU,Fk,vV,Fk,vW,Fk,vX,Fk,vY,Fk,vZ,Fk,v_,Fk,v$,Fk,v0,Fk,v1,Fk,v2,Fk,v3,Fk,v4,Fk,v5,Fk,v6,Fk,gY,Fk,t$,Fk,rz,Fk,q5,Fk,i2,Fk,jY,Fk,ny,Fk,gT,Fk,qc,Fk,ra,Fk,s0,Fk,rs,Fk,qj,Fk,hu,Fk,ss,Fk,jM,Fk,nl,Fk,rj,Fk,hG,Fk,oj,Fk,qz,Fk,pv,Fk,np,Fk,hw,Fk,rl,Fk,pg,Fk,qA,Fk,qm,Fk,sh,Fk,m0,Fk,pf,Fk,pS,Fk,nb,Fk,rV,Fk,r6,Fk,sz,Fk,tK,Fk,ry,Fk,sc,Fk,i$,Fk,nz,Fk,rA,Fk,tF,Fk,p6,Fk,t_,Fk,nt,Fk,j2,Fk,pO,Fk,ll,Fk,jC,Fk,rX,Fk,p$,Fk,uz,Fk,tQ,Fk,s2,Fk,nL,Fk,tA,Fk,qe,Fk,tv,Fk,gH,Fk,st,Fk,p2,Fk,gW,Fk,ld,Fk,s5,Fk,oF,Fk,gS,Fk,uY,Fk,rd,Fk,qF,Fk,r$,Fk,ml,Fk,l5,Fk,hk,Fk,oz,Fk,rG,Fk,tx,Fk,jQ,Fk,py,Fk,pW,Fk,pK,Fk,k2,Fk,lX,Fk,to,Fk,lM,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk,Fk];var bn=[Fl,Fl,v8,Fl,v9,Fl,wa,Fl,wb,Fl,wc,Fl,wd,Fl,we,Fl,wf,Fl,wg,Fl,wh,Fl,wi,Fl,wj,Fl,wk,Fl,wl,Fl,wm,Fl,wn,Fl,wo,Fl,wp,Fl,wq,Fl,wr,Fl,c3,Fl,kD,Fl,Fl,Fl,Fl,Fl,Fl,Fl,Fl,Fl,Fl,Fl,Fl,Fl,Fl,Fl,Fl,Fl,Fl,Fl];var bo=[Fm,Fm,wt,Fm,wu,Fm,wv,Fm,ww,Fm,wx,Fm,wy,Fm,wz,Fm,wA,Fm,wB,Fm,wC,Fm,wD,Fm,wE,Fm,wF,Fm,wG,Fm,wH,Fm,wI,Fm,wJ,Fm,wK,Fm,wL,Fm,wM,Fm,go,Fm,nP,Fm,jq,Fm,fj,Fm,mN,Fm,lD,Fm,fW,Fm,cU,Fm,eV,Fm,u0,Fm,ee,Fm,fg,Fm,u6,Fm,f1,Fm,pb,Fm,ih,Fm,eu,Fm,fG,Fm,vj,Fm,cD,Fm,lx,Fm,jm,Fm,sG,Fm,lA,Fm,qR,Fm,o0,Fm,eR,Fm,fL,Fm,fS,Fm,lI,Fm,u8,Fm,e4,Fm,rt,Fm,cy,Fm,dl,Fm,eB,Fm,cR,Fm,g8,Fm,lr,Fm,um,Fm,mv,Fm,hY,Fm,ls,Fm,ge,Fm,ur,Fm,qI,Fm,d5,Fm,fA,Fm,h5,Fm,cF,Fm,mu,Fm,nr,Fm,sE,Fm,iH,Fm,ly,Fm,dG,Fm,t1,Fm,he,Fm,gl,Fm,e5,Fm,nZ,Fm,mO,Fm,fH,Fm,c$,Fm,qb,Fm,sx,Fm,ez,Fm,ua,Fm,hf,Fm,c_,Fm,dm,Fm,ei,Fm,lS,Fm,mL,Fm,et,Fm,pi,Fm,g3,Fm,mB,Fm,kx,Fm,qW,Fm,h_,Fm,qi,Fm,n6,Fm,ff,Fm,fh,Fm,mT,Fm,qQ,Fm,mq,Fm,h4,Fm,c9,Fm,je,Fm,va,Fm,mp,Fm,ex,Fm,u7,Fm,kA,Fm,ed,Fm,d_,Fm,gc,Fm,s_,Fm,t7,Fm,u4,Fm,pe,Fm,ia,Fm,d1,Fm,eg,Fm,da,Fm,d3,Fm,kk,Fm,vm,Fm,fT,Fm,cx,Fm,qL,Fm,t3,Fm,jl,Fm,og,Fm,g7,Fm,fi,Fm,mQ,Fm,ug,Fm,o5,Fm,h7,Fm,f5,Fm,uq,Fm,us,Fm,ft,Fm,kK,Fm,d$,Fm,ud,Fm,eZ,Fm,eJ,Fm,gk,Fm,eU,Fm,uo,Fm,jr,Fm,e9,Fm,lJ,Fm,ky,Fm,sy,Fm,g2,Fm,sI,Fm,qX,Fm,es,Fm,ui,Fm,o6,Fm,fn,Fm,u2,Fm,u9,Fm,eL,Fm,gb,Fm,g6,Fm,f2,Fm,uj,Fm,fu,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm,Fm];var bp=[Fn,Fn,wO,Fn,wP,Fn,wQ,Fn,wR,Fn,wS,Fn,wT,Fn,wU,Fn,wV,Fn,wW,Fn,wX,Fn,wY,Fn,wZ,Fn,w_,Fn,w$,Fn,w0,Fn,w1,Fn,w2,Fn,w3,Fn,w4,Fn,w5,Fn,sf,Fn,lU,Fn,i3,Fn,fy,Fn,oU,Fn,qa,Fn,lE,Fn,r1,Fn,rQ,Fn,h$,Fn,hx,Fn,iz,Fn,r2,Fn,sP,Fn,ij,Fn,qC,Fn,gx,Fn,tS,Fn,k4,Fn,fQ,Fn,fB,Fn,eS,Fn,uL,Fn,f7,Fn,tk,Fn,m4,Fn,sO,Fn,iP,Fn,nf,Fn,th,Fn,pH,Fn,uQ,Fn,eE,Fn,pM,Fn,uN,Fn,jW,Fn,f3,Fn,j4,Fn,i9,Fn,q0,Fn,o1,Fn,oe,Fn,fp,Fn,sm,Fn,e2,Fn,uC,Fn,uX,Fn,uK,Fn,pk,Fn,ek,Fn,o_,Fn,fO,Fn,jf,Fn,c5,Fn,ul,Fn,n5,Fn,pc,Fn,gr,Fn,j$,Fn,ec,Fn,f$,Fn,ji,Fn,ir,Fn,hP,Fn,f6,Fn,sL,Fn,gy,Fn,pa,Fn,rm,Fn,tR,Fn,sN,Fn,gd,Fn,mb,Fn,kd,Fn,si,Fn,fN,Fn,fa,Fn,rD,Fn,oX,Fn,gm,Fn,tu,Fn,j6,Fn,pz,Fn,iJ,Fn,sX,Fn,gJ,Fn,gB,Fn,e$,Fn,nM,Fn,rC,Fn,fC,Fn,gf,Fn,mx,Fn,eG,Fn,rP,Fn,uS,Fn,pL,Fn,pV,Fn,iO,Fn,oA,Fn,q7,Fn,qZ,Fn,hn,Fn,gw,Fn,rS,Fn,sR,Fn,ha,Fn,fY,Fn,pG,Fn,fz,Fn,rv,Fn,fw,Fn,q8,Fn,fb,Fn,qv,Fn,hl,Fn,g9,Fn,sg,Fn,ea,Fn,td,Fn,e7,Fn,mc,Fn,uR,Fn,s6,Fn,rU,Fn,pn,Fn,dC,Fn,eX,Fn,sj,Fn,oi,Fn,i5,Fn,o2,Fn,p1,Fn,ps,Fn,e8,Fn,kV,Fn,uk,Fn,tE,Fn,rw,Fn,pr,Fn,f9,Fn,q$,Fn,qt,Fn,lW,Fn,tf,Fn,j5,Fn,ks,Fn,fq,Fn,o$,Fn,oV,Fn,rR,Fn,iF,Fn,tC,Fn,oO,Fn,iy,Fn,tM,Fn,my,Fn,se,Fn,pR,Fn,ux,Fn,e_,Fn,e3,Fn,ma,Fn,fX,Fn,fU,Fn,l9,Fn,hh,Fn,eO,Fn,tB,Fn,fs,Fn,jc,Fn,uF,Fn,eI,Fn,gp,Fn,m5,Fn,ix,Fn,qw,Fn,mn,Fn,hW,Fn,dB,Fn,uw,Fn,uy,Fn,hE,Fn,uI,Fn,pP,Fn,rn,Fn,pq,Fn,rp,Fn,rZ,Fn,fV,Fn,uE,Fn,jG,Fn,iT,Fn,l_,Fn,tZ,Fn,tP,Fn,sn,Fn,fM,Fn,nA,Fn,gg,Fn,nJ,Fn,nF,Fn,gz,Fn,tn,Fn,sU,Fn,kB,Fn,eM,Fn,pU,Fn,sd,Fn,tJ,Fn,eN,Fn,sW,Fn,iS,Fn,gq,Fn,q4,Fn,qs,Fn,qh,Fn,tm,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn,Fn];var bq=[Fo,Fo,w7,Fo,w8,Fo,w9,Fo,xa,Fo,xb,Fo,xc,Fo,xd,Fo,xe,Fo,xf,Fo,xg,Fo,xh,Fo,xi,Fo,xj,Fo,xk,Fo,xl,Fo,xm,Fo,xn,Fo,xo,Fo,xp,Fo,xq,Fo,qn,Fo,gK,Fo,hF,Fo,sT,Fo,jx,Fo,lk,Fo,kf,Fo,hQ,Fo,r7,Fo,rf,Fo,iG,Fo,k6,Fo,r8,Fo,iE,Fo,hR,Fo,iN,Fo,iZ,Fo,p8,Fo,pZ,Fo,jI,Fo,g_,Fo,mm,Fo,iK,Fo,iI,Fo,gI,Fo,tH,Fo,iU,Fo,nx,Fo,pl,Fo,pI,Fo,ho,Fo,pQ,Fo,oJ,Fo,iL,Fo,lF,Fo,q2,Fo,pF,Fo,id,Fo,iV,Fo,gL,Fo,mk,Fo,oT,Fo,lt,Fo,gu,Fo,gG,Fo,qd,Fo,i0,Fo,uV,Fo,no,Fo,qy,Fo,r4,Fo,op,Fo,j9,Fo,oS,Fo,sV,Fo,ht,Fo,gC,Fo,nq,Fo,lQ,Fo,le,Fo,lG,Fo,m8,Fo,iM,Fo,uG,Fo,qq,Fo,qD,Fo,jK,Fo,tg,Fo,oL,Fo,lq,Fo,rL,Fo,nW,Fo,j8,Fo,lL,Fo,h2,Fo,nG,Fo,p7,Fo,sp,Fo,hs,Fo,kR,Fo,hH,Fo,o3,Fo,nn,Fo,gX,Fo,mi,Fo,iA,Fo,jB,Fo,kY,Fo,j7,Fo,ms,Fo,j3,Fo,mU,Fo,oh,Fo,oP,Fo,kc,Fo,mf,Fo,mR,Fo,k7,Fo,lj,Fo,hy,Fo,m_,Fo,ox,Fo,jN,Fo,kg,Fo,hJ,Fo,nu,Fo,nH,Fo,gE,Fo,hO,Fo,mj,Fo,rr,Fo,gv,Fo,m6,Fo,mh,Fo,kS,Fo,kt,Fo,ph,Fo,i7,Fo,hp,Fo,tU,Fo,rJ,Fo,p_,Fo,lP,Fo,uH,Fo,hq,Fo,m9,Fo,i4,Fo,pu,Fo,k3,Fo,ni,Fo,p0,Fo,o7,Fo,m$,Fo,m7,Fo,iX,Fo,hI,Fo,iQ,Fo,iu,Fo,iW,Fo,jy,Fo,h8,Fo,pE,Fo,ta,Fo,gQ,Fo,pw,Fo,cw,Fo,gD,Fo,ku,Fo,n2,Fo,hj,Fo,l7,Fo,hL,Fo,lV,Fo,ot,Fo,ke,Fo,hA,Fo,ne,Fo,cI,Fo,rH,Fo,lm,Fo,iC,Fo,hD,Fo,lc,Fo,ka,Fo,hv,Fo,sS,Fo,kU,Fo,iB,Fo,nj,Fo,la,Fo,tr,Fo,i_,Fo,gZ,Fo,nm,Fo,k0,Fo,q6,Fo,lR,Fo,lY,Fo,jA,Fo,jJ,Fo,sM,Fo,iR,Fo,vk,Fo,jP,Fo,l1,Fo,tb,Fo,uT,Fo,lf,Fo,hV,Fo,kj,Fo,k1,Fo,kL,Fo,iw,Fo,nk,Fo,rq,Fo,mg,Fo,ip,Fo,s9,Fo,qG,Fo,tp,Fo,k_,Fo,it,Fo,s7,Fo,oq,Fo,jL,Fo,sQ,Fo,l8,Fo,jn,Fo,k5,Fo,rB,Fo,kJ,Fo,kv,Fo,gR,Fo,kb,Fo,l3,Fo,ju,Fo,oG,Fo,hc,Fo,g0,Fo,uM,Fo,rW,Fo,uJ,Fo,lg,Fo,lh,Fo,oB,Fo,md,Fo,kO,Fo,ol,Fo,jo,Fo,hb,Fo,jU,Fo,gF,Fo,gM,Fo,l4,Fo,kW,Fo,jZ,Fo,jH,Fo,pD,Fo,h0,Fo,sq,Fo,om,Fo,sY,Fo,kh,Fo,ow,Fo,oM,Fo,kX,Fo,rc,Fo,nC,Fo,tW,Fo,hK,Fo,sk,Fo,jR,Fo,uB,Fo,ok,Fo,h1,Fo,iv,Fo,oN,Fo,oW,Fo,qu,Fo,pJ,Fo,qp,Fo,gU,Fo,oI,Fo,js,Fo,sl,Fo,nI,Fo,hU,Fo,oE,Fo,hM,Fo,cG,Fo,cE,Fo,hN,Fo,nw,Fo,oK,Fo,kN,Fo,ig,Fo,sZ,Fo,uv,Fo,oQ,Fo,oc,Fo,kT,Fo,mI,Fo,j1,Fo,pm,Fo,iD,Fo,kp,Fo,qk,Fo,gA,Fo,jg,Fo,nd,Fo,re,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo,Fo];var br=[Fp,Fp,xs,Fp,xt,Fp,xu,Fp,xv,Fp,xw,Fp,xx,Fp,xy,Fp,xz,Fp,xA,Fp,xB,Fp,xC,Fp,xD,Fp,xE,Fp,xF,Fp,xG,Fp,xH,Fp,xI,Fp,xJ,Fp,xK,Fp,xL,Fp,kF,Fp,c2,Fp,Fp,Fp,Fp,Fp,Fp,Fp,Fp,Fp,Fp,Fp,Fp,Fp,Fp,Fp,Fp,Fp,Fp,Fp];var bs=[Fq,Fq,xN,Fq,xO,Fq,xP,Fq,xQ,Fq,xR,Fq,xS,Fq,xT,Fq,xU,Fq,xV,Fq,xW,Fq,xX,Fq,xY,Fq,xZ,Fq,x_,Fq,x$,Fq,x0,Fq,x1,Fq,x2,Fq,x3,Fq,x4,Fq,sC,Fq,Fq,Fq,Fq,Fq,Fq,Fq,Fq,Fq,Fq,Fq,Fq,Fq,Fq,Fq,Fq,Fq,Fq,Fq,Fq,Fq];var bt=[Fr,Fr,x6,Fr,x7,Fr,x8,Fr,x9,Fr,ya,Fr,yb,Fr,yc,Fr,yd,Fr,ye,Fr,yf,Fr,yg,Fr,yh,Fr,yi,Fr,yj,Fr,yk,Fr,yl,Fr,ym,Fr,yn,Fr,yo,Fr,yp,Fr,hZ,Fr,lC,Fr,Fr,Fr,Fr,Fr,Fr,Fr,Fr,Fr,Fr,Fr,Fr,Fr,Fr,Fr,Fr,Fr,Fr,Fr];var bu=[Fs,Fs,yr,Fs,ys,Fs,yt,Fs,yu,Fs,yv,Fs,yw,Fs,yx,Fs,yy,Fs,yz,Fs,yA,Fs,yB,Fs,yC,Fs,yD,Fs,yE,Fs,yF,Fs,yG,Fs,yH,Fs,yI,Fs,yJ,Fs,yK,Fs,nU,Fs,Fs,Fs,Fs,Fs,Fs,Fs,Fs,Fs,Fs,Fs,Fs,Fs,Fs,Fs,Fs,Fs,Fs,Fs,Fs,Fs];var bv=[Ft,Ft,yM,Ft,yN,Ft,yO,Ft,yP,Ft,yQ,Ft,yR,Ft,yS,Ft,yT,Ft,yU,Ft,yV,Ft,yW,Ft,yX,Ft,yY,Ft,yZ,Ft,y_,Ft,y$,Ft,y0,Ft,y1,Ft,y2,Ft,y3,Ft,lB,Ft,n3,Ft,ik,Ft,nX,Ft,iq,Ft,vb,Ft,cJ,Ft,kq,Ft,d0,Ft,mJ,Ft,od,Ft,c6,Ft,cH,Ft,cC,Ft,uc,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft,Ft];var bw=[Fu,Fu,y5,Fu,y6,Fu,y7,Fu,y8,Fu,y9,Fu,za,Fu,zb,Fu,zc,Fu,zd,Fu,ze,Fu,zf,Fu,zg,Fu,zh,Fu,zi,Fu,zj,Fu,zk,Fu,zl,Fu,zm,Fu,zn,Fu,zo,Fu,jb,Fu,ki,Fu,mS,Fu,gt,Fu,fo,Fu,fd,Fu,h6,Fu,jT,Fu,gi,Fu,h9,Fu,f4,Fu,o4,Fu,f_,Fu,hg,Fu,lp,Fu,kz,Fu,lK,Fu,mr,Fu,fE,Fu,fK,Fu,kP,Fu,e1,Fu,kI,Fu,eK,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu,Fu];var bx=[Fv,Fv,zq,Fv,zr,Fv,zs,Fv,zt,Fv,zu,Fv,zv,Fv,zw,Fv,zx,Fv,zy,Fv,zz,Fv,zA,Fv,zB,Fv,zC,Fv,zD,Fv,zE,Fv,zF,Fv,zG,Fv,zH,Fv,zI,Fv,zJ,Fv,kQ,Fv,mV,Fv,m3,Fv,p3,Fv,Fv,Fv,Fv,Fv,Fv,Fv,Fv,Fv,Fv,Fv,Fv,Fv,Fv,Fv];var by=[Fw,Fw,zL,Fw,zM,Fw,zN,Fw,zO,Fw,zP,Fw,zQ,Fw,zR,Fw,zS,Fw,zT,Fw,zU,Fw,zV,Fw,zW,Fw,zX,Fw,zY,Fw,zZ,Fw,z_,Fw,z$,Fw,z0,Fw,z1,Fw,z2,Fw,sH,Fw,Fw,Fw,Fw,Fw,Fw,Fw,Fw,Fw,Fw,Fw,Fw,Fw,Fw,Fw,Fw,Fw,Fw,Fw,Fw,Fw];var bz=[Fx,Fx,z4,Fx,z5,Fx,z6,Fx,z7,Fx,z8,Fx,z9,Fx,Aa,Fx,Ab,Fx,Ac,Fx,Ad,Fx,Ae,Fx,Af,Fx,Ag,Fx,Ah,Fx,Ai,Fx,Aj,Fx,Ak,Fx,Al,Fx,Am,Fx,An,Fx,qf,Fx,s$,Fx,Fx,Fx,Fx,Fx,Fx,Fx,Fx,Fx,Fx,Fx,Fx,Fx,Fx,Fx,Fx,Fx,Fx,Fx];var bA=[Fy,Fy,Ap,Fy,Aq,Fy,Ar,Fy,As,Fy,At,Fy,Au,Fy,Av,Fy,Aw,Fy,Ax,Fy,Ay,Fy,Az,Fy,AA,Fy,AB,Fy,AC,Fy,AD,Fy,AE,Fy,AF,Fy,AG,Fy,AH,Fy,AI,Fy,vf,Fy,vg,Fy,Fy,Fy,Fy,Fy,Fy,Fy,Fy,Fy,Fy,Fy,Fy,Fy,Fy,Fy,Fy,Fy,Fy,Fy];var bB=[Fz,Fz,AK,Fz,AL,Fz,AM,Fz,AN,Fz,AO,Fz,AP,Fz,AQ,Fz,AR,Fz,AS,Fz,AT,Fz,AU,Fz,AV,Fz,AW,Fz,AX,Fz,AY,Fz,AZ,Fz,A_,Fz,A$,Fz,A0,Fz,A1,Fz,oZ,Fz,Fz,Fz,Fz,Fz,Fz,Fz,Fz,Fz,Fz,Fz,Fz,Fz,Fz,Fz,Fz,Fz,Fz,Fz,Fz,Fz];var bC=[FA,FA,A3,FA,A4,FA,A5,FA,A6,FA,A7,FA,A8,FA,A9,FA,Ba,FA,Bb,FA,Bc,FA,Bd,FA,Be,FA,Bf,FA,Bg,FA,Bh,FA,Bi,FA,Bj,FA,Bk,FA,Bl,FA,Bm,FA,kw,FA,kM,FA,jp,FA,mo,FA,nO,FA,h3,FA,lH,FA,ie,FA,o8,FA,hd,FA,lu,FA];var bD=[FB,FB,Bo,FB,Bp,FB,Bq,FB,Br,FB,Bs,FB,Bt,FB,Bu,FB,Bv,FB,Bw,FB,Bx,FB,By,FB,Bz,FB,BA,FB,BB,FB,BC,FB,BD,FB,BE,FB,BF,FB,BG,FB,BH,FB,jh,FB,FB,FB,FB,FB,FB,FB,FB,FB,FB,FB,FB,FB,FB,FB,FB,FB,FB,FB,FB,FB];var bE=[FC,FC,BJ,FC,BK,FC,BL,FC,BM,FC,BN,FC,BO,FC,BP,FC,BQ,FC,BR,FC,BS,FC,BT,FC,BU,FC,BV,FC,BW,FC,BX,FC,BY,FC,BZ,FC,B_,FC,B$,FC,B0,FC,jO,FC,l0,FC,k8,FC,ov,FC,gP,FC,p5,FC,nc,FC,oC,FC,tL,FC,lZ,FC,tG,FC,hC,FC,m1,FC,pB,FC,pC,FC,jw,FC,pT,FC,nK,FC,jX,FC,tY,FC,iY,FC,j_,FC,tq,FC,ro,FC,l$,FC,rk,FC,nB,FC,g$,FC,ql,FC,uD,FC,r5,FC,rI,FC,jS,FC,ln,FC,qg,FC,qB,FC,rx,FC,on,FC,oD,FC,gO,FC,l6,FC,tT,FC,tD,FC,qM,FC,oH,FC,hz,FC,rF,FC,nv,FC,tV,FC,sJ,FC,lb,FC,qE,FC,qP,FC,hT,FC,rM,FC,hB,FC,ng,FC,sK,FC,ns,FC,gN,FC,s3,FC,li,FC,pt,FC,sA,FC,gV,FC,s1,FC,jD,FC,r_,FC,p9,FC,qx,FC,k$,FC,ru,FC,q3,FC,nh,FC,hS,FC,lT,FC,tl,FC,me,FC,is,FC,uU,FC,oR,FC,tc,FC,l2,FC,i8,FC,s4,FC,r0,FC,jz,FC,hr,FC,k9,FC,q1,FC,ic,FC,i1,FC,pY,FC,jV,FC,tt,FC,rT,FC,rb,FC,p4,FC,j0,FC,i6,FC,lo,FC,kZ,FC,so,FC,rY,FC,pN,FC,pX,FC,ja,FC,ib,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC,FC];var bF=[FD,FD,B2,FD,B3,FD,B4,FD,B5,FD,B6,FD,B7,FD,B8,FD,B9,FD,Ca,FD,Cb,FD,Cc,FD,Cd,FD,Ce,FD,Cf,FD,Cg,FD,Ch,FD,Ci,FD,Cj,FD,Ck,FD,Cl,FD,io,FD,hm,FD,t6,FD,tj,FD,sr,FD,hX,FD,rO,FD,ts,FD,tN,FD,sb,FD,r9,FD,fR,FD,tO,FD,nE,FD,lO,FD,rN,FD,im,FD,jF,FD,qo,FD,uW,FD,cP,FD,m2,FD,ti,FD,fF,FD,su,FD,nS,FD,po,FD,fm,FD,oy,FD,jv,FD,sa,FD,cV,FD,sv,FD,pp,FD,lN,FD,px,FD,uu,FD,km,FD,ri,FD,pj,FD,du,FD,n9,FD,ga,FD,uP,FD,jj,FD,tI,FD,rg,FD,jt,FD,jE,FD,fe,FD,cS,FD,uO,FD,os,FD,g1,FD,mD,FD,eY,FD,rK,FD,nN,FD,uA,FD,oY,FD,cB,FD,ut,FD,ou,FD,f0,FD,qr,FD,or,FD,un,FD,n$,FD,rh,FD,tz,FD,tX,FD,mK,FD,mP,FD,s8,FD,eT,FD,gj,FD,q_,FD,ty,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD,FD];var bG=[FE,FE,Cn,FE,Co,FE,Cp,FE,Cq,FE,Cr,FE,Cs,FE,Ct,FE,Cu,FE,Cv,FE,Cw,FE,Cx,FE,Cy,FE,Cz,FE,CA,FE,CB,FE,CC,FE,CD,FE,CE,FE,CF,FE,CG,FE,lv,FE,up,FE,FE,FE,FE,FE,FE,FE,FE,FE,FE,FE,FE,FE,FE,FE,FE,FE,FE,FE];var bH=[FF,FF,CI,FF,CJ,FF,CK,FF,CL,FF,CM,FF,CN,FF,CO,FF,CP,FF,CQ,FF,CR,FF,CS,FF,CT,FF,CU,FF,CV,FF,CW,FF,CX,FF,CY,FF,CZ,FF,C_,FF,C$,FF,qH,FF,g4,FF,lw,FF,mF,FF,sB,FF,o9,FF,mZ,FF,t5,FF,lz,FF,qY,FF,qJ,FF,ue,FF,kH,FF,ub,FF,sw,FF,kr,FF,qK,FF,ii,FF,pd,FF,mM,FF,t0,FF,hi,FF,uf,FF,mt,FF,t8,FF,qV,FF,nY,FF,sD,FF,u5,FF,n4,FF,qN,FF,sF,FF,mw,FF,uh,FF,u3,FF,qS,FF,t2,FF,u1,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF];var bI=[FG,FG,C1,FG,C2,FG,C3,FG,C4,FG,C5,FG,C6,FG,C7,FG,C8,FG,C9,FG,Da,FG,Db,FG,Dc,FG,Dd,FG,De,FG,Df,FG,Dg,FG,Dh,FG,Di,FG,Dj,FG,Dk,FG,dd,FG,n0,FG,kn,FG,oa,FG,cY,FG,d9,FG,eH,FG,mH,FG,nT,FG,eD,FG,ej,FG,eF,FG,cQ,FG,cT,FG,eW,FG,eb,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG,FG