var Ball = {

    _advert: null,

    /**
     * List of answers
     */
    _answers: [
        "It is certain",
        "It is decidedly so",
        "Without a doubt",
        "Yes definitely",
        "You may rely on it",
        "As I see it yes",
        "Most likely",
        "Outlook good",
        "Yes",
        "Signs point to yes",

        "Reply hazy try again",
        "Ask again later",
        "Better not tell you now",
        "Cannot predict now",
        "Concentrate and ask again",

        "Don't count on it",
        "My reply is no",
        "My sources say no",
        "Outlook not so good",
        "Very doubtful"
    ],

    /**
     * Current state
     */
    busy: false,

    /**
     * Shake handler interval
     */
    _interval: null,

    // Shake sensitivity (a lower number is more)
    sensitivity: 20,

    // Position variables
    x1: 0, y1: 0, z1: 0, x2: 0, y2: 0, z2: 0,

    /**
     * Result div
     *
     * @returns {HTMLElement}
     */
    get result() {
        return document.getElementById('result');
    },

    /**
     * Text Element
     * @returns {HTMLElement}
     */
    get text() {
        return document.getElementById('text');
    },

    _createAdvert: function() {
        var options = {
            TYPE: "Banner",
            REFRESH_RATE: 18,
            APP_ID: "TengriSoftware_Magic8Ball_other"
        };

        this._advert = Inneractive.createAd(options);
        this._advert.addTo(document.body);
        this._advert.placement("bottom", "center");
    },

    _removeAdvert: function() {
        this._advert.remove();
    },

    /**
     * Initialize ball
     */
    init: function() {
        this.bindEvents();
        this._createAdvert();
    },

    /**
     * Set text to ball
     *
     * @param {string} text
     */
    setText: function(text) {
        this.text.textContent = text;
    },

    /**
     * Bind events to app
     */
    bindEvents: function() {
        this.result.addEventListener('touchstart', this.onclick.bind(this), false);
        // Listen to motion events and update the position
        window.addEventListener('devicemotion', function (e) {
            this.x1 = e.accelerationIncludingGravity.x;
            this.y1 = e.accelerationIncludingGravity.y;
            this.z1 = e.accelerationIncludingGravity.z;
        }.bind(this), false);

        /**
         * Handle motion
         */
        this.handleMotion();
    },

    /**
     * Click handler
     */
    onclick: function(e) {
        e.stopPropagation();
        e.preventDefault();
        this.answer();
    },

    /**
     * Change an answer on the ball
     */
    answer: function() {
        if (this.busy) {
            return;
        }
        this.busy = true;
        this.text.classList.add('animate-start');
        window.setTimeout(function() {
            this.setText(this._answers[this.rand(this._answers.length)]);
            this.text.classList.remove('animate-start');
            this.text.classList.add('animate-end');
        }.bind(this), 500);

        window.setTimeout(function() {
            this.text.classList.remove('animate-end');
            this.busy = false;
        }.bind(this), 1100);
    },

    /**
     * Reset ball state
     */
    reset: function() {
        this.setText('Touch or shake me');
        /**
         * Clear interval
         */
        if (this._interval) {
            window.clearInterval(this._interval);
            this._interval = null;
        }
    },

    /**
     * Get rand number
     *
     * @param {number} max
     * @returns {number}
     */
    rand: function(max) {
        return Math.floor(Math.random() * (max));
    },

    /**
     * Handle motion
     *
     * @param e
     */
    handleMotion: function() {
        // Periodically check the position and fire
        // if the change is greater than the sensitivity
        this._interval = setInterval(function () {
            var change = Math.abs(this.x1-this.x2+this.y1-this.y2+this.z1-this.z2);

            if (change > this.sensitivity) {
                this.answer();
            }

            // Update new position
            this.x2 = this.x1;
            this.y2 = this.y1;
            this.z2 = this.z1;
        }.bind(this), 150);
    }
};

Ball.init();

document.addEventListener('visibilitychange', function(e) {
    if (document.visibilityState == 'visible') {
        Ball.handleMotion();
    } else {
        Ball.reset();
    }
});

window.addEventListener('beforeunload', function() {
    Ball.reset();
});