function hasFeature(feature) {
    var attr = FEATURES[feature];

    if (isUndef(attr) || !attr) {
        console.warn("PLATFORM::*" + feature + "* not available");
        return false;
    }

    console.debug("PLATFORM::*" + feature + " available");

    return true;
}

function afterSavebookmark() {
    console.debug("afterSavebookmark");

    window.location.hash = "#/home/:all";

    DSP.dispatchEvent(new Event("collectionCheck"));
}

var FEATURES = {
        WebActivities: isFunction(navigator.mozSetMessageHandler),
        Activity     : isFunction(window.MozActivity)
    },

    // App is running ?
    ISRUNNING = false,

    unreadContainer    = undefined,
    archivedContainer  = undefined,

    $unreadContainer   = undefined,
    $archivedContainer = undefined,

    $placeholderContainer = $("#view-home .scroll-content"),
    $firstboot = $("#splash-firstboot"),

    $body = $("body"),

    // define the global dispatcher
    DSP = document.body,

    // define global events, to handle basic actions
    // and transitions between views
    EVENTS = {
        global: {
            viewChange: function(e) {
                console.debug("EVT::viewChange");

                var _findInitFunc = function(s) {
                        return s.split("-").pop();
                    },
                    _absName = function(s) {
                        return s.split('-').pop().trim();
                    };

                // OLD = the view we are changing from
                // NEW = the view we are going to
                var oldViewId =  e.detail.oldViewId,   // #view-foo
                    newViewId =  e.detail.newViewId,
                    args = e.detail.args,
                    route = e.detail.route,

                    // view selectors
                    absNewViewId = _absName(newViewId), // #view-foo -> foo
                    absOldViewId = _absName(oldViewId),
                    $oldView = $(oldViewId),
                    $newView = $(newViewId),

                    destructorName = _findInitFunc(oldViewId) + "Destroy", // fooDestroy
                    constructorName = _findInitFunc(newViewId) + "Init",   // barInit
                    destructor = window[destructorName],
                    constructor = window[constructorName],


                    isDialog = $newView.attr("role") == "dialog",
                    // Do transition if
                    // - we are not into home page
                    // - viewChange is not triggered by main()
                    doTransition = ((absOldViewId != "undefined") ||
                                    (absNewViewId != route)) &&
                                   !isDialog;

                if (absOldViewId != "undefined") {
                    // unbind all events on elements of oldView
                    console.debug("EVT::Unbind " + oldViewId);

                    $oldView.add("*").off();
                }

                // dispatching helper
                var dispatch = function(evtType, evtDetails) {
                        var viewDetails = {$newView: $newView, args: args},
                            allDetails  = {detail: $.extend(evtDetails || {}, viewDetails)};

                        DSP.dispatchEvent(new CustomEvent(evtType, allDetails));
                    },

                    init = function() {
                        /*
                        * Constructor invocation
                        */
                        if (isFunction(destructor)) {
                            console.debug("APP::Invoking destructor " + destructorName);
                            destructor($oldView, $newView, dispatch);
                        }

                        if (isFunction(constructor)) {
                            console.debug("APP::Invoking constructor " + constructorName);
                            constructor($oldView, $newView, args, dispatch);
                        }

                        console.debug("VIEW::" + absOldViewId, " ---> ", absNewViewId);

                        // Mark the new view as the current one
                        $body.data("current-view", absNewViewId);

                        /*
                        * DOM Transition
                        */
                        if (doTransition) {
                            transitionFX($oldView, $newView);
                        } else {
                            $newView.addClass("current");

                            if (oldViewId != newViewId) {
                                $oldView.removeClass("current");
                            } else {
                                $("#view-home").removeClass("current");
                            }
                        }
                    };

                // Custom Events handling
                registerEvents(absNewViewId, init);
                unregisterEvents(absOldViewId);
            },

            addLink: function(e) {
                console.debug("EVT::addLink");

                var link = NewLink(e.detail);

                if (isUndef(link.title) || isUndef(link.url)) {
                    console.warn("APP::Cannot add Empty Link");
                    DSP.dispatchEvent(new Event("addLinkComplete"));
                    return;
                }

                if (stringIsEmpty(link.title)) {
                    link.title = "Untitled link";
                }

                DB.Add(link, function(id) {
                    link.id = id;

                    var parserApiEvt = new CustomEvent("parseLink", {'detail': link});

                    DSP.dispatchEvent(parserApiEvt);
                    DSP.dispatchEvent(new Event("addLinkComplete"));
                });
            },

            deleteLink: function(e) {
                console.debug("EVT::deleteLink");

                DB.Delete(e.detail.id, function() {
                    var evtData = {detail: e.detail},
                        evt = new CustomEvent("deleteLinkComplete", evtData);

                    DSP.dispatchEvent(evt);
                });
            },

            deleteLinkComplete: function(e) {
                var linkId = e.detail.id,
                    linkSel = "#tag-id-" + linkId,
                    $link = $(linkSel);

                $link.remove();
                DSP.dispatchEvent(new Event("collectionSizeChange"));
            },

            bulkActionComplete: function(e) {
                window.location.hash = "#/home";
            },

            // invoke API proxy to Readability (or whatever) API
            // put the result into link.text field
            parseLink: function(e) {
                var link = e.detail;

                console.debug("PARSER::Parsing " + link.url);

                var xhr = new XMLHttpRequest({mozSystem: true}),
                    appid  = window.location.host.replace("app://", ""),
                    apiUrl = "http://api.morgenlab.com/manana?url=" + link.url + "&appid=" + appid;

                console.debug("PARSER::API proxy at " + apiUrl);

                getFile(apiUrl,
                    function (text) {
                        if (isUndef(text)) {
                            console.warn("Invalid response from API");
                            DSP.dispatchEvent(new Event("parseError"));
                            return;
                        }

                        DB.Add({
                            id    : link.id,
                            title : link.title,
                            url   : link.url,
                            tags  : link.tags,
                            text  : text
                        }, function() {
                            DSP.dispatchEvent(new Event("parseComplete"));
                        });
                    },

                    function () {
                        DSP.dispatchEvent(new Event("parseError"));
                    });
            },

            markAsRead: function(e) {
                var link = e.detail,

                    updateDom = function(link) {
                        var $el = $("#tag-id-" + link.id);

                        $el.removeClass("status-unread")
                           .addClass("status-archived");

                        $archivedContainer.prepend($el);

                        DSP.dispatchEvent(new Event("markAsReadComplete"));
                    },

                    mark = function(link) {
                        link.readat = Date.now();

                        DB.Add(link, function() {
                            console.debug("APP::Link with id " + link.id, " readed at: " + link.readat);

                            updateDom(link);
                        });
                    };

                if (stringIsEmpty(link.url)) {
                    DB.Get(link.id, function(link) {
                        mark(link);
                    });
                } else {
                    mark(link);
                }
            },

            shareLink: function(e) {
                if (!hasFeature("Activity")) {
                    console.log("APP::Cannot use Activity feature, skipping");
                    return;
                }

                var id = e.detail;

                DB.Get(id, function (rs) {
                    var subject = rs.title,
                        body    = rs.url + "\n\n" + getString("mananaSignature"),
                        shareActivity;

                    shareActivity = new MozActivity({
                        name: "new",
                        data: {
                            type: "mail",
                            body: body,
                            url: "mailto:?body=" + encodeURIComponent(body) +
                                "&subject=" + encodeURIComponent(subject)
                        }
                    });
                });
            },

            bulkShareLink: function(e) {
                if (!hasFeature("Activity")) {
                    console.log("APP::Cannot use Activity feature, skipping");
                    return;
                }

                var ids = isArray(e.detail) ? e.detail : [e.detail];

                DB.Get(ids, function (rs) {
                    var subject = getString(ids.length == 1 ? "linkShare" : "bulkLinkShare"),
                        body = "",
                        shareActivity;

                    for (var key in rs)
                        body += " - " + rs[key].title + "\n   " + rs[key].url + "\n\n";

                    body += "\n" + getString("mananaSignature"),

                    shareActivity = new MozActivity({
                        name: "new",
                        data: {
                            type: "mail",
                            body: body,
                            url: "mailto:?body=" + encodeURIComponent(body) +
                                "&subject=" + encodeURIComponent(subject)
                        }
                    });
                });
            },

            addTagToLink: function(e) {
                var linkId = e.detail.linkId,
                    tagName = e.detail.tagName,
                    localDSP = e.detail.localDSP,

                    save = function(link) {
                        DSP.dispatchEvent(
                            new CustomEvent(
                                "addTagToLinkComplete", 
                                {detail: {tagName: tagName, linkId: linkId}}));
                    };

                DB.Get(linkId, function(link) {
                    if (link.tags.indexOf(tagName) != -1) {
                        return;
                    }

                    link.tags.push(tagName);

                    DB.Add(link, save);
                });
            },

            addTagToLinkComplete: function(e) {
                var tagName = e.detail.tagName,
                    linkId  = e.detail.linkId,

                    clsName = "tag-" + tagName,
                    $rootEl = $("#tag-id-" + linkId),
                    $el     = $("dt.tagitem", $rootEl),

                    rawTags    = $body.data("tags") || "",
                    tags       = rawTags.split(","),
                    exists     = tags.indexOf(tagName) != -1;


                $el.addClass(clsName);

                if (exists) {
                    return;
                }

                tags.push(tagName);
                $body.data("tags", tags)
            },

            removeTagFromLink: function(e) {
                var linkId = e.detail.linkId,
                    tagName = e.detail.tagName,
                    localDSP = e.detail.localDSP,

                    save = function(link) {
                        DSP.dispatchEvent(
                            new CustomEvent(
                                "removeTagFromLinkComplete", 
                                {detail: {tagName: tagName, linkId: linkId}}));
                    };

                DB.Get(linkId, function(link) {
                    var index = link.tags.indexOf(tagName);

                    if (index != -1) {
                        link.tags.splice(index, 1);
                    }

                    DB.Add(link, save);
                });
            },

            removeTagFromLinkComplete: function(e) {
                var tagName = e.detail.tagName,
                    linkId  = e.detail.linkId,

                    clsName = "tag-" + tagName,
                    $rootEl = $("#tag-id-" + linkId),
                    $el     = $("dt.tagitem", $rootEl);

                $el.removeClass(clsName);
            },

            collectionCheck: function(e) {
                console.debug("EVT::collectionCheck");

                var $view       = $("#view-home"),
                    evtDetail   = e.detail || {},
                    filterByTag = evtDetail.filterByTag || "",
                    hasFilter    = filterByTag != "";

                DB.Count(function(dbCount) {
                    var domCount     = $(".eg-link-list li", $view).length,
                        doRefresh    = (dbCount != domCount),
                        doFiltering  = !stringIsEmpty(filterByTag);

                    if (dbCount > 3) {
                        console.debug("SEARCH::ENABLE");
                        $view[0].dispatchEvent(new Event("enableSearch"));
                    } else {
                        console.debug("SEARCH::DISABLE");
                        $view[0].dispatchEvent(new Event("disableSearch"));
                    }

                    console.debug("HOME:: " + domCount + " DOM --- " +
                                  dbCount + " DB @@@ filter: "+ filterByTag +
                                  " => Need refresh ? " + doRefresh);

                    if (doRefresh && !doFiltering) {
                        var evtDetail = {"detail": {dbCount: dbCount, domCount: domCount,
                                                    filterByTag: filterByTag}},
                            evt       = new CustomEvent("collectionChange", evtDetail);

                        DSP.dispatchEvent(evt);
                    } else if (hasFilter) {
                        DSP.dispatchEvent(new CustomEvent("collectionFilter",
                                                         {detail: {filterByTag: filterByTag}}));
                    } else {
                        DSP.dispatchEvent(new Event("collectionSizeChange"));
                    }
                });
            },

            // Redraw links collection and trigger also collectionSizeChange event.
            collectionChange: function(e) {
                console.debug("EVT::collectionChange");

                var detail       = e.detail           || {},
                    dbCount      = detail.dbCount,
                    domCount     = detail.domCount    || 0,
                    filterByTag  = detail.filterByTag || "",
                    hasFilter    = filterByTag        != "",

                    push         = undefined,

                    unreadBuf    = [],
                    archivedBuf  = [],

                    unreadCounter = 0,
                    archivedCounter = 0;

                unreadContainer.innerHTML   = "";
                archivedContainer.innerHTML = "";

                var finished = function() {
                        var len = unreadCounter + archivedCounter;
                        return (len == dbCount);
                    },

                    fetch = function() {
                        DB.All(function(link) {
                            var isArchived  = link.readat > 0;

                            link.url = getDomainName(link.url);
                            link.cls = "";

                            if (isArchived) {
                                $target = $archivedContainer;
                                link.status = "archived";
                                push = function(html) { archivedBuf.push(html); };
                                archivedCounter++;
                            } else {
                                $target = $unreadContainer;
                                link.status = "unread";
                                push = function(html) { unreadBuf.push(html); };
                                unreadCounter++;
                            }

                            var t = $("#js-list-tmpl").html(),
                                html = renderTemplate(t, link);

                            push(html);

                            if (finished()) {
                                console.debug("EVT::COLLECTIONCHANGE -- finished");
                                archivedBuf.reverse();
                                unreadBuf.reverse();

                                archivedContainer.innerHTML = archivedBuf.join(" ");
                                unreadContainer.innerHTML   = unreadBuf.join(" ");

                                if (hasFilter) {
                                    DSP.dispatchEvent(new CustomEvent("collectionFilter",
                                                                    {detail: {filterByTag: filterByTag}}));
                                } else {
                                    DSP.dispatchEvent(new Event("collectionSizeChange"));
                                }
                            }
                        });
                    };

                if (isUndef(dbCount)) {
                    DB.Count(function(count) {
                        console.debug("DBCOUNT::fetch from db:", count);
                        dbCount = count;
                        fetch();
                    });
                } else {
                    console.debug("DBCOUNT::use event data:", dbCount);
                    fetch();
                }
            },

            collectionFilter: function(e) {
                console.debug("COLLECTIONFILTER::start");

                $(".js-tagtitle").text("");
                DSP.dispatchEvent(new Event("hidePlaceholder"));

                var $view        = $("#view-home"),
                    filterByTag  = e.detail.filterByTag || "",
                    hasFilter    = filterByTag != "",
                    onlyUnread   = (hasFilter && filterByTag == "unread")     ? true : false,
                    onlyArchived = (hasFilter && filterByTag == "archived")   ? true : false,
                    showAll      = (hasFilter && filterByTag == "all")        ? true : false,
                    hasTag       = hasFilter  && !onlyUnread && !onlyArchived &&     !showAll,

                    $elems = function() {
                        if (hasTag) {
                            var ids = [];

                            $("dt.tag-"  + filterByTag, $view).each(function() {
                                var $el = $(this),
                                    elid = $el.closest("li")[0].id;

                                ids.push("#" + elid);
                            });

                            var selector = ids.join();

                            return $(selector, $view);
                        }

                        if (onlyUnread)   return $(".status-" + "unread", $view);
                        if (onlyArchived) return $(".status-" + "archived", $view);

                        return "";
                    }();

                var $links = $(".js-link-listview", $view);

                $links.removeClass("hide");

                if ($elems.length > 0) {
                    $links.not($elems).addClass("hide");
                    DSP.dispatchEvent(new Event("hidePlaceholder"));
                } else if (!showAll) {
                    $links.addClass("hide");
                    DSP.dispatchEvent(new Event("showPlaceholder"));
                } 

                if (hasTag) {
                    $(".js-tagtitle").text(filterByTag);
                }

                DSP.dispatchEvent(new Event("collectionSizeChange"));
            },

            // Update unread and archived UI counters
            collectionSizeChange: function(e) {
                console.debug("COLLECTION::Update counters");

                var $glob             = $(".js-glob-all-counter"),
                    $globUnread       = $(".js-glob-unread-counter"),
                    $globArchived     = $(".js-glob-archived-counter"),

                    $unreadElems      = $("li.js-link-listview:not(.hide)", $unreadContainer),
                    $archivedElems    = $("li.js-link-listview:not(.hide)", $archivedContainer),

                    $allUnreadElems   = $(".status-unread"),
                    $allArchivedElems = $(".status-archived"),

                    unreadElemsCount   = $unreadElems.length,
                    archivedElemsCount = $archivedElems.length,

                    allUnreadCount    = $allUnreadElems.length,
                    allArchivedCount  = $allArchivedElems.length,

                    $unreadWrapper    = $("#unread-container"),
                    $archivedWrapper  = $("#archived-container"),

                    allCount          = allUnreadCount + allArchivedCount;

                $unreadWrapper.data("cnt", $unreadElems.length);
                $archivedWrapper.data("cnt", $archivedElems.length);

                $globUnread.text(allUnreadCount);
                $globArchived.text(allArchivedCount);

                $glob.text(allCount);

                if (unreadElemsCount == 0) {
                    $unreadWrapper.hide();
                } else {
                    $unreadWrapper.show();
                }

                if (archivedElemsCount == 0) {
                    $archivedWrapper.hide();
                } else {
                    $archivedWrapper.show();
                }

                DB.Count(function(dbCount) {
                    if (dbCount == 0) {
                        DSP.dispatchEvent(new Event("showFirstboot"));
                    } else {
                        DSP.dispatchEvent(new Event("hideFirstboot"));
                    }
                });
            },

            showPlaceholder: function(e) {
                console.debug("PLACEHOLDER::show");

                var $placeholder     = $(".placeholder"),
                    $placeholderTmpl = $("#placeholder-empty-list"),
                    tmpl = $placeholderTmpl.html(),
                    html = renderTemplate(tmpl);

                    if ($placeholderContainer.find(".placeholder").length == 0) {
                        $("<div class=placeholder>" + html + "</div>").appendTo($placeholderContainer);
                    }
            },

            hidePlaceholder: function(e) {
                console.debug("PLACEHOLDER::hide");

                $(".placeholder").remove();
            },

            showFirstboot: function(e) {
                console.debug("showFirstboot");
                $firstboot.removeClass("hide");
            },

            hideFirstboot: function(e) {
                console.debug("hideFirstboot");
                $firstboot.addClass("hide");
            }
        },

        home: {
            markAsReadComplete: function(e) {
                DSP.dispatchEvent(new Event("collectionSizeChange"));
            }
        },

        add: {
            // Reset add link form
            addLinkComplete: function() {
                console.debug("EVT:addLinkComplete");

                var $form = $("form#add-link");
                $form[0].reset();

                newFeedback("linkAdded");
            }
        },

        read: {
            markAsReadComplete: function(e) {
                newFeedback("linkRead");
                DSP.dispatchEvent(new Event("collectionSizeChange"));
            }
        },

        delete: {
            deleteLinkComplete: function(e) {
                newFeedback("linkRemoved");
            }
        },

        tag: {
            // trigger a save event when a checkbox state change
            renderComplete: function(e) {
                var $newView = e.detail.$newView;

                $("input[type=checkbox]", $newView).on("click", function() {
                    DSP.dispatchEvent(new CustomEvent("save", {detail: e.detail}));
                });
            },

            save: function(e) {
                var $newView  = e.detail.$newView,
                    linkIdStr = e.detail.args[0] || e.detail.linkId,
                    bulkMode  = typeof(linkIdStr) != "number" ? linkIdStr.indexOf(",") != -1 : false,
                    // ensure at least ids has one id entry.
                    // need to support bulk mode, so we have to iterate on ids rather
                    // then using a single id
                    ids      = bulkMode ? linkIdStr.split(",") : [linkIdStr],

                    $xs = $("input[type=checkbox]", $newView),

                    updateCounter = function(tagName, value) {
                        var el     = document.getElementById("tag-count-" + tagName),
                            intval = parseInt(el.innerHTML || "0");

                        el.innerHTML = intval + value;
                    },

                    updateState = function(tagName, newState) {
                        var el = "input#id-" + tagName,
                            $el = $(el, $newView);

                        $el.data("wasselected", newState);
                    },

                    ontagdelete = function(tagName) {
                        updateState(tagName, "false");
                        updateCounter(tagName, -1);
                    },

                    ontagadd = function(tagName ) {
                        updateState(tagName, "true");
                        updateCounter(tagName, 1);
                    };

                //
                // Update DB
                //
                // - iterate through tag entries;
                // - determine status (added / removed / nop)
                // - trigger event
                //
                $xs.each(function() {
                    var el  = this,
                        $el = $(this),

                        tagName     = $el.data("tagname"),

                        wasSelected = JSON.parse($el.attr("data-wasselected")),
                        isSelected  = el.checked,

                        unchanged = [wasSelected  == isSelected , "", undefined],
                        deleteTag = [wasSelected  && !isSelected, "removeTagFromLink",  ontagdelete],
                        saveTag   = [!wasSelected && isSelected, "addTagToLink", ontagadd],

                        evtDetail = function(id) {
                            return {detail: {linkId: parseInt(id),
                                             tagName: tagName,
                                             localDSP: DSP}};
                        },

                        tests    = [unchanged, deleteTag, saveTag],

                        dispatch = function(evtName) {
                            for (var i = 0; i < ids.length; i++) {
                                DSP.dispatchEvent(new CustomEvent(evtName, evtDetail(ids[i])));
                            }
                        };

                    for (var i = 0; i < tests.length; i++) {
                        var test     = tests[i][0],
                            evtName  = tests[i][1],
                            callback = tests[i][2];

                        if (!test) {
                            continue;
                        }

                        if (!callback) {
                            console.debug("TAG::No changes");
                            continue;
                        }

                        if (test) {
                            console.debug("TAG::" + evtName);
                            dispatch(evtName);
                            callback(tagName);

                            break;
                        }
                    }
                });
            }
        }
    };

function renderTemplate(t, c) {
    var expandHandler = function(match, key) {
            if (key == "this") {
                return c;
            }

            return c[key];
        },

        rangeHandler = function(match, collectionName, body) {
            var html = "",
                collection = c[collectionName];

            if (isUndef(collection) || collection.length == 0) {
                return "";
            }

            for (var i = 0; i < collection.length; i++) {
                html += renderTemplate(body, collection[i]);
            }

            return html;
        },

        handlers = [
            [/\{\{\s*range\s(\w+)\s*\}\}([^]+)?\{\{\s*end\s*\}\}/g, rangeHandler],
            [/\{\{\s*(\w+)\s*\}\}/g, expandHandler]
        ],

        regex, handler;

    for (var i = 0; i < handlers.length; i++) {
        regex   = handlers[i][0];
        handler = handlers[i][1];
        t       = t.replace(regex, handler);
    }

    return t;
}

function homeInit($oldView, $newView, args) {
    var $view    = $newView,
        $query   = $(".js-searchfield", $view),
        tag      = args[0],
        localDSP = $view[0],
        $queryContainer = $(".js-searchmode-trigger", $view),
        $contextBar = $(".js-contextbar-toggle", $view),
        domCount = $("li.js-link-listview", $newView).length;

    DB.ksetValue("savebookmark", false);

    // clean Home View states
    $view.removeClass("is--onsearch-mode");
    $view.find(".js-contextbar").removeClass("is--active");
    $view.removeClass("is--onbulk-mode");
    // reset all the links visibility
    $("li", $(".eg-link-list", $view)).show();

    localDSP.addEventListener("enableSearch", function() {
        $queryContainer.show();
    });

    localDSP.addEventListener("disableSearch", function() {
        $queryContainer.hide();
    });

    DSP.dispatchEvent(
        new CustomEvent("collectionCheck", {detail: {filterByTag: tag}})
    );

    // DOM Search
    $query.on("keydown", function(e) {
        var query = $query.val().trim().toLowerCase(),
            $links = $("li", $(".eg-link-list", $view)),
            abort = query.length < 2;

        $links.show();

        if (stringIsEmpty(query) || abort) {
            return;
        }

        var hide = $links.not(function(index) {
            var $el = $($links[index]),
                text = $el.text().toLowerCase().trim();

            return text.indexOf(query) != -1;
        });

        hide.hide();
    });

    $("#search-link", $view).on("submit", function(e) {
        return false;
    });
    $(".js-searchmode-trigger", $view).on("click", function(e) {
        // trigger the search mode
        $view.addClass("is--onsearch-mode");
        // give focus on the query
        $query.focus();

        e.preventDefault();
    });
    $(".js-search-dismiss").on("click", function(e) {
        // reset the query
        $query.val("");
        // dismiss the search mode
        $view.removeClass("is--onsearch-mode");
        // reset all the links visibility
        $("li", $(".eg-link-list", $view)).show();
        return false;
    });

    /*
     * Bulk Mode Handling
     */
    var $getSelected = function() { return $(".js-link-select", $view); },
        getSelectedLinks = function() {
            var ids = [];

            $getSelected().each(function() {
                if (!$(this).prop("checked")) {
                    return;
                }

                ids.push(parseInt(this.id.replace("item-", "")));
            });

            console.debug("BULK::" + ids.length + " elements selected");

            return ids;
        },

        bulkLoop = function(callback) {
            var ids = getSelectedLinks(),
                idn = ids.length,
                opType = "";

            while (ids.length > 0) {
                opType = callback(ids.shift());
            }

            DSP.dispatchEvent(new Event("collectionSizeChange"));
            $contextBar.click();

            if (opType == "marked")
                newFeedback("bulkRead");
            else
                idn == 1 ? newFeedback("linkRemoved") : newFeedback("bulkDelete");
        };

    $contextBar.on("click", function(e) {
        var $inactiveEl = $(".js--onbulk-inactive", $view),
            _inactiveIs  = "is--inactive";

        // Reset counters
        $(".js-cnt-bulk", $view).text("0");

        // Reset controls, if any
        if(! $inactiveEl.hasClass(_inactiveIs)) {
            $inactiveEl.addClass(_inactiveIs);
        }

        // Uncheck every still-checked items
        $view.find("input:checked").each(function () {
            $(this).prop("checked", false);
        });

        // Activate the Bulk Mode in the View
        $view.toggleClass("is--onbulk-mode");

        // Update the counters
        $getSelected().on("click", function() {

            var $cnt = $(".js-cnt-bulk", $view),
                nTot = getSelectedLinks().length;

            // Update the counter
            $cnt.text(nTot);

            // Update the controls, if any
            if (nTot > 0) {
                $inactiveEl.removeClass(_inactiveIs);
            } else {
                $inactiveEl.addClass(_inactiveIs);
            }
        });

        // Activate the contextbar
        $view.find(".js-contextbar").toggleClass("is--active");

        return false;
    });

    $(".js-link-tag", $view).on("click", function(e) {
        $("#view-tag").data("id", getSelectedLinks())
                      .data("bulkmode", "on");
    });

    $(".js-mark-as-read", $view).on("click", function(e) {
        bulkLoop(function(id) {
            DB.Get(id, function(link) {
                DSP.dispatchEvent(
                    new CustomEvent("markAsRead", {detail: link})
                );
            });

            return "marked";
        });

        return false;
    });

    $(".js-link-delete", $view).on("click", function(e) {
        if (!confirm(getString("areYouSure"))) {
            return false;
        }

        bulkLoop(function(id) {
            DSP.dispatchEvent(
                new CustomEvent("deleteLink", {detail: {id: id}})
            );

            return "deleted";
        });

        return false;
    });

    $(".js-link-share", $view).on("click", function(e) {
        DSP.dispatchEvent(new CustomEvent("bulkShareLink", { detail: getSelectedLinks() }));
        return false;
    });
}

function homeDestroy($oldView) {
    $(".js-cnt-bulk", $oldView).text("0");
    $oldView.find(".js-contextbar").removeClass("is--active");
    $oldView.removeClass("is--onbulk-mode");
}

function firstbootInit ($oldView, $newView, args) {
    console.debug("~~~ firstbootInit");
}

function readInit($oldView, $newView, args) {
    var linkId = parseInt(args[0]),
        $view   = $newView,
        $header = $(".toolbar", $view);

    var parseAnchors = function(link) {
        $("a.btn", $view).each(function() {
            var el = this,
                $el = $(el),
                href = unescape($el.data("target") || el.href);

            if (href.indexOf("{{") == -1) {
                return;
            }

            $el.data("href", href);
            el.href = renderTemplate(href, link);
        });
    };

    var linkParsed = function() {
        DB.Get(linkId, renderLink);
    };

    var renderLink = function(link) {
        DSP.removeEventListener("parseComplete", linkParsed);
        DSP.removeEventListener("parseError", linkParsed);

        document.getElementById("link-title").innerHTML = link.title;
        document.getElementById("link-url").innerHTML   = link.url;
        document.getElementById("link-text").innerHTML  = link.text || 'error';

        parseAnchors(link);

        // Open every link in the Read View in the Browser
        $("#link-text a", $newView).attr("target", "_blank");

        $(".js-mark-as-read", $newView).on("click", function(e) {
            DSP.dispatchEvent(
                new CustomEvent("markAsRead", {detail: link})
            );

            return false;
        });

        var $tagView = $("#view-tag");
        $tagView.data("tags", link.tags);
        $tagView.data("id", link.id);

        $(".js-link-delete", $newView).on("click", function(e) {
            return confirm(getString("areYouSure"));
        });

        if (hasFeature("WebActivities")) {
            $(".js-link-share", $newView).on("click", function(e) {
                DSP.dispatchEvent(new CustomEvent("shareLink", { detail: link.id }));
            });

            $(".js-link-openorig", $newView).on("click", function(e) {
                console.log("PLATFORM::Invoking WebActivities API --- view");
                var activity = new MozActivity({
                    name: "view",
                    data: {
                        type: "url",
                        url: link.url
                    }
                });

                activity.onsuccess = function() {
                    console.debug("WebActivities::view --- OK");
                };

                activity.onerror= function() {
                    console.debug("WebActivities::view --- FAIL");
                };

                return false;
            });
        }
    };


    DB.Get(linkId, function(link) {
        if (!link.text) {
            DSP.addEventListener("parseComplete", linkParsed);
            DSP.addEventListener("parseError", linkParsed);
            DSP.dispatchEvent(new CustomEvent("parseLink", {'detail': link}));
        } else {
            renderLink(link);
        }
    });


    DB.kget("readZoomLevel", function (zoomLevel) {
        $newView.data("zoom", zoomLevel === undefined ? 1 : zoomLevel);
    });

    $(".js-foldaway", $newView).foldAway();

    $(".js-contextbar-toggle", $newView).on("click", function(e) {
        $view.find(".js-contextbar").toggleClass("is--active");

        return false;
    });

    $(".js-style-editor", $newView).on("click", function(e) {
        DB.kset('readZoomLevel',
            function (v) { return ((v || 0) + 1) % 4; },
            function (zoomLevel) {
                $newView.data("zoom", zoomLevel);
                DSP.dispatchEvent(new CustomEvent("readZoomLevel", { detail: zoomLevel }));
            });

        e.preventDefault();
    });

}

function readDestroy($oldView) {
    console.debug("READ::DESTROY");
    $("#link-title, #link-url, #link-text", $oldView).empty();

    $(".js-contextbar", $oldView).removeClass("is--active");

    $("a[data-href]", $oldView).each(function(e) {
        this.href = $(this).data("href");
    });
}

function savebookmarkInit($oldView, $newView) {
    if (!hasFeature("WebActivities")) {
        return;
    }

    DB.ksetValue("savebookmark", true);

    navigator.mozSetMessageHandler("activity", function(activity) {
        console.debug("FXFOS::Handling save-bookmark activity");

        DSP.addEventListener("parseComplete", function() {
            activity.postResult("saved");
        });

        var data = activity.source.data;

        var payload = {detail: {title: data.name, url: data.url}},
            addEvt = new CustomEvent("addLink", payload);

            DSP.dispatchEvent(addEvt);
    });
}

function addInit($oldView, $newView) {
    var $form = $("form#add-link", $newView),
        $title = $("[name=title]", $form),
        $url   = $("[name=url]", $form);

    DSP.addEventListener("addLinkComplete", function() {
        window.location.hash = "#/";
    });

    $form.on("submit", function(e) {
        e.preventDefault();

        var title = $title.val(),
            url   = $url.val(),
            payload = {"detail": {title: title, url: url}},
            addEvt = new CustomEvent("addLink", payload);

        DSP.dispatchEvent(addEvt);

    });

    if (hasFeature("WebActivities")) {
        navigator.mozSetMessageHandler("activity", function(activity) {
            console.debug("FXFOS::Handling save-bookmark activity");

            DSP.addEventListener("parseComplete", function() {
                activity.postResult("saved");
            });

            var data = activity.source.data;

            $title.val(data.name);
            $url.val(data.url);

            $form.submit();
        });
    }
}

function settingsInit($oldView, $newView) {
    $("#settings-populate", $newView).on("click", function () {
        __populate();
    });

    $("#settings-clear-database", $newView).on("click", function () {
        indexedDB.deleteDatabase("manana");
        alert("Database cleared");
        window.location.reload();
    });

    $("#settings-revision").text(REVISION || "N/A");
}

function resourceInit($oldView, $newView, args) {
    var resource  = args[0],
        fallback  = "/locales/resources/" + resource + ".en.md",
        localized = "/locales/resources/" + resource + "." + getLanguage() + ".md",
        renderMd  = function (txt) {
            $(".js-subpage", $newView).html(marked(txt));
        },
        renderError  = function (txt) {
            $(".js-subpage", $newView).text("ouch, cannot find: " + resource);
        };

    getFile(localized,
            renderMd,
            function () { getFile(fallback, renderMd, renderError); });
}

function deleteInit($oldView, $newView, args) {
    var linkId = args.shift(),
        evt = new CustomEvent("deleteLink", {detail: {id: linkId}});

    DSP.dispatchEvent(evt);

    DSP.addEventListener("deleteLinkComplete", function() {
        window.location.hash = "#/";
    });
}

function tagInit($oldView, $newView, args, _dispatch) {
    console.debug("TAG::Init");

    var bulkMode    = $newView.data("bulkmode") == "on",
    
        fetchTags = function(linkId, callback) {
            // get tags for the current link object
            var dbfetch = function() {
                    DB.Get(linkId, function(link) {
                        callback(link.tags || []);
                    });
                },

                // get tags for the selected link objects
                domfetch = function() {
                    var ids  = linkId.split(","),
                        tags = [];

                    for (var i = 0; i < ids.length; i++) {
                        var id   = ids[i],
                            $el   = $("#tag-id-" + id),
                            $tags = $("dt.tagitem", $el);

                        $tags.each(function() {
                            var tagName = $(this).text(),
                                isDup   = tags.indexOf(tagName) > -1;

                            if (!isDup) 
                                tags.push(tagName)
                        });
                    }

                    callback(tags);
                };



            if (!bulkMode || typeof(linkId) != "string") {
                dbfetch();
            } else {
                domfetch();
            }
        },

        render = function(selectedTags) {
            console.debug("TAG:Render Start");

            var allTagsStr = $body.data("tags") || "",
                tags       = allTagsStr.split(","),

                buf        = [],

                tmpl       = $("#js-choose-tag").html(),
                tagRender  = function(tag, isSelected) {
                    var status = isSelected ? "checked" : "",
                        count  = $("dt.tag-" + tag).length;

                    return renderTemplate(tmpl, {tag: tag, status: status,
                                                 isselected: isSelected, count: count});
                },

                isSelected = function(tag) {
                    for (var i = 0; i < selectedTags.length; i++) {
                        if (selectedTags[i] == tag) {
                            return true;
                        }
                    }

                    return false;
                };

            console.debug("TAG::Render got ", tags.length, "tags");

            for (var i = 0; i < tags.length; i++) {
                var tag = tags[i];
                
                if (stringIsEmpty(tag)) continue;

                buf.push(tagRender(tag, isSelected(tag)));
            }

            $("#tag-list", $newView).html(buf.join(""));

            _dispatch("renderComplete", {linkId: linkId});
        },

        linkId      = args[0] || $newView.data("id"),

        linkTagsStr = $newView.data("tags") || "",
        linkTags    = linkTagsStr.split(","),
        noTags      = stringIsEmpty(linkTagsStr),
        needFetch   = !isUndef(linkId) && noTags;

        renderer = function() { render(linkTags); },

        setBackRoute = function(route) {
            $(".js-role-anim", $newView).attr("href", route);
        }

    console.debug("TAG::Bulk mode status", bulkMode);

    if (needFetch) {
        renderer = function() { fetchTags(linkId, render) };

        EVENTS["tag"]["tagsListAvailable"] = renderer;
        DSP.addEventListener("tagsListAvailable", renderer);

        loadTags();
    } else {
        renderer();
    }

    // Set a "back/close" route for this view
    if (bulkMode) {
        setBackRoute("#/home");
    } else {
        setBackRoute("#/read/:" + linkId);
    }

    $("form#add-tag-form", $newView).on("submit", function(e) {
        e.preventDefault();

        var el = this,
            $el = $(this),
            $input = $("input[name=new-tag-name]", $el),

            newTagName = $input.val();

        // Reset the input value
        $input.val("");

        if (stringIsEmpty(newTagName)) {
            return false;
        }

        var tmpl = $("#js-choose-tag").html(),
            c = {tag: newTagName, isselected: false, status:"checked", count: 0},
            html = renderTemplate(tmpl, c);

        $("#tag-list", $newView).prepend(html);

        _dispatch("save", {linkId: linkId});
    });
}

function tagDestroy($oldView) {
    $oldView.removeAttr("data-id");
    $oldView.removeAttr("data-tags");

    if ($oldView.data("bulkmode", "on")) {
        $oldView.data("bulkmode", undefined);
    }

    $("input").val(null);

    $oldView.off();

    $("#tag-list", $oldView).empty();

    DSP.dispatchEvent(new Event("collectionChange"));
}

function drawerInit($oldView, $newView) {
    var $target = $(".js-taglist", $newView),
        tmpl    = $("#js-taglist-entry").html(),
        rawData = $body.data("tags") || "",
        tags    = rawData.split(",");

    for (var i = 0; i < tags.length; i++) {
        var tagName = tags[i],
            tagSel  =  "dt.tag-" + tagName,
            $tags   = $(tagSel),
            count   = $tags.length;

        if (stringIsEmpty(tagName) || count <= 0) {
            continue;
        }

        $target.append(renderTemplate(tmpl, {tag: tagName, count: count}));
    }

    // Goes back to the previous View, with fallback `#/`
    $(".js-close-drawer").on("click", function (e) {
        e.preventDefault();
        window.location.hash = "#/home";
    });
}

function drawerDestroy($oldView) {
    setTimeout(function() {
        $("a.tag-entry", $("nav.main")).remove();
    }, 400);
}

function router(hash) {
    if (hash == "" || hash == "#/") {
        hash = "#/home";
    }

    var cleanHash = hash.replace(/\#\/(.*)?\/$/, "$1"),
        parts     = cleanHash.split("/"),
        _         = parts.shift(),
        mainRoute = parts[0].replace(/[\/|#]/g, ""),
        subRoute  = parts[2],
        route     = subRoute || mainRoute,
        hasArgs   = cleanHash.indexOf(":") != -1,
        args      = [];

    if (hasArgs) {
        var m = cleanHash.match(/\:(\w+)/);
        m.shift();

        args = [m[0]];
    }

    console.debug("ROUTER::GET " + route);

    if (route == "") {
        return;
    }

    var evtData = {"detail": {oldViewId : "#view-" + $(document.body).data("current-view"),
                              newViewId : "#view-" + route,
                              args      : args,
                              route     : route}},
        routingEvt  = new CustomEvent("viewChange", evtData);

    DSP.dispatchEvent(routingEvt);
}

function registerEvents(scope, callback) {
    var evtTable = EVENTS[scope];

    if (isUndef(evtTable)) {
        callback();
        return;
    }

    console.debug("APP::Registering events for scope " + scope);

    $(Object.keys(EVENTS[scope])).each(function(i, key) {
        console.debug("APP::Registering " + key + " event");

        DSP.addEventListener(key, EVENTS[scope][key]);
    });

    if (!isUndef(callback)) {
        callback();
    }
}

function unregisterEvents(scope) {
    var evtTable = EVENTS[scope];

    if (isUndef(evtTable)) {
        return;
    }

    console.debug("APP::Unregistering events for scope " + scope);

    $(Object.keys(EVENTS[scope])).each(function(i, key) {
        console.debug("APP::Unregistering " + key + " event");

        DSP.removeEventListener(key, EVENTS[scope][key]);
    });
}

function transitionFX($oldView, $newView) {
    var newViewType = $newView.attr("role") || "",
        oldViewType = $oldView.attr("role") || "",

        elRole  = $oldView.find(".js-role-anim").attr("role"),

        isPopUp = newViewType == "popup",

        goBack  = elRole == "back" && !isPopUp,
        goClose = elRole == "close",
        goNext  = newViewType == oldViewType,

        getDrawer = newViewType == "drawer" && oldViewType !== "drawer",
        delDrawer = oldViewType == "drawer" && newViewType !== "drawer",

        // [test, animationName]
        progAnim = [
            [goBack   , "moveRight"], // :Back
            [goClose  , "pushDown" ], // :Close (dialog)
            [goNext   , "moveLeft" ], // :Page
            [isPopUp  , "pushUp"   ], // :Popup
            [getDrawer, "getDrawer"], // :Drawer
            [delDrawer, "delDrawer"]  // :Drawer
        ],

        getAnim = function() {
            for(var i = 0; i < progAnim.length; i ++) {
                var x = progAnim[i],
                    test = x[0],
                    anim = x[1];

                if (test) {
                    return anim;
                }
            }
        },

        anim = getAnim() || "moveRight"; // default (aka, FXBack animation)

    console.debug("FX::Views      --- ", oldViewType, newViewType);

    var wasAnimCls = "was--current",
        inAnimCls  = anims[anim][0],
        outAnimCls = anims[anim][1],
        vendorAnimationEnd = "animationend webkitAnimationEnd MSAnimationEnd oAnimationEnd",

        afterAnimEnds = function () {
            $oldView.off(vendorAnimationEnd, afterAnimEnds);

            $newView.removeClass(inAnimCls);
            $oldView.removeClass(outAnimCls);

            $oldView.removeClass("current");
            $newView.addClass("current");
        };

    console.debug("FX::Transition --- ", anim);

    // Leave a trace of the last triggered view
    $oldView.siblings().removeClass(wasAnimCls);
    $oldView.addClass(wasAnimCls);

    $newView.addClass(inAnimCls);
    $oldView.addClass(outAnimCls);

    $oldView.on(vendorAnimationEnd, afterAnimEnds);
}

function main() {
    console.debug("APP::START");

    registerEvents("global");
    loadTags();

    router(window.location.hash);

    $(window).on("hashchange", function() {
        router(window.location.hash);
    });
}

function loadTags() {
    DB.AllTags(function(tags) {
        console.debug("TAGS:: ", tags);
        $body.data("tags", tags);

        DSP.dispatchEvent(new Event("tagsListAvailable"));
    });
}

window.onload = function() {
    var hash = window.location.hash;

    //
    // Required --- Do not remove
    //
    unreadContainer    = document.getElementById("unread-links-list");
    archivedContainer  = document.getElementById("archived-links-list");

    $unreadContainer   = $(unreadContainer);
    $archivedContainer = $(archivedContainer);


    console.debug("WINDOW::LOAD");
    if (["", "#/"].indexOf(hash) != -1) {
        splash.start();
        setTimeout(function () {
            splash.stop();
        }, 1500);
    }

    main();

    // On FXOS devices this ensure that data are updates
    // when user click on already-loaded application.
    if (hasFeature("WebActivities")) {
        window.addEventListener("focus", function(e) {
            var hash = window.location.hash;

            console.debug("EVT::WINDOW FOCUS");

            // if (hash == "#/firstboot")
            //     DB.Count(function(dbCount) {
            //         if (dbCount != 0)
            //             window.location.hash = "#/home";
            //     });

            DB.kget("savebookmark", function(savebookmarkFlag) {
                if (savebookmarkFlag) {
                    afterSavebookmark();
                }
            });

            ISRUNNING = true;
        }, false);
    }

    // FastClick.attach(document.body);
    //
    setTimeout(function() {
        if (typeof(REVISION) == "undefined") {
            REVISION = "N/A";
        }
    }, 1000);
};

/*
 * Lazy programmers helpers, BEWARE!
 */

// Add some test links to the DB
function __populate() {
    console.warn("Invoking __install debug method. Please wait...");

    var xs = [
        {title: "Firefox - Wiki",
         url: "http://en.wikipedia.org/wiki/Firefox",
         tags: ["firefox", "web"]},

        {title: "Mozilla Foundation - Wiki",
         url: "http://en.wikipedia.org/wiki/Mozilla_Foundation",
         tags: ["web"]},

        {title: "Netscape - Wiki",
         url: "http://en.wikipedia.org/wiki/Netscape",
         tags: ["web"]},

        {title: "URL - Wiki",
         url: "http://en.wikipedia.org/wiki/URL",
         tags: ["web", "dev"]}
    ];

    while (xs.length > 0) {
        var x = xs.shift();

        DSP.dispatchEvent(
            new CustomEvent("addLink", {detail: x})
        );
    }
}
