// Vendor events
var animationEnd  = "webkitAnimationEnd oanimationend oAnimationEnd msAnimationEnd animationend",
    transitionEnd = "webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend";

    // ANIMEND
    // TRNSEND

// Available animations
var anims = {
    getDrawer : ["getDrawerIn" , "getDrawerOut" ],
    delDrawer : ["delDrawerIn" , "delDrawerOut" ],
    moveLeft  : ["moveLeftIn"  , "moveLeftOut"  ],
    moveRight : ["moveRightIn" , "moveRightOut" ],
    pushUp    : ["pushUpIn"    , "pushUpOut"    ],
    pushDown  : ["pushDownIn"  , "pushDownOut"  ],
    slideDown : ["slideDownIn" , "slideDownOut" ]
};

// Get just the domain name from a URL
function getDomainName (url) {
    try {
        return url.match(/:\/\/(www\.)?(.[^/:]+)/)[2];
    } catch(err) {
        return url.split("://").pop();
    }
}

// Instance a new Feedback message when needed
function newFeedback (id) {
    console.debug("UI::newFeedback");

    var text = $("#notification-" + id).text(),
        tmpl = "<article class='message-feedback'>" + text + "</article>",
        $msg = $(".message-feedback");

    $msg.remove();

    $(tmpl)
        .appendTo("body")
        .on(animationEnd, function() {
            $(this).remove();
        });
}

function getString (id) {
    var text = $("#string-" + id).text();

    // FIXME: awful hack to enable markdown
    text = text.split("\n")[0];
    text = text.substr(0, text.length - 3);
    // sorry about that...
    return text;
}

// Get the current language
function getLanguage () {
    return navigator.language.split("-")[0];
}


function getFile (url, success, error) {
    var xhr = new XMLHttpRequest();

    console.debug("UTILS::Get File " + url);

    xhr.open("get", url, true);
    xhr.setRequestHeader("Content-Type", "text/plain;charset=UTF-8");

    xhr.onreadystatechange = function() {
        if (xhr.readyState == 4) {
            if (xhr.status == 200 || xhr.status === 0)
                success(xhr.responseText);
            else
                error && error();
        }
    };

    xhr.onerror = error;
    xhr.ontimeout = error;

    try {
        xhr.send(null);
    } catch (e) {
        error && error();
    }
}

function isFunction(f) {
    return typeof(f) == "function";
}

function isArray(f) {
    return f instanceof Array;
}

function isUndef(x) {
    return typeof(x) == "undefined";
}

function stringIsEmpty(x) {
    if (typeof(x) != "string") {
        return false;
    }

    return isUndef(x) || x.trim() == "";
}

// Spinner object
var spinner = {

    tmpl: "spinner-block",

    start: function () {
        $($("#" + this.tmpl).html()).appendTo("body");
    },

    stop:  function () {
        $("." + this.tmpl).remove();
    }
};

// Splash screen object
var splash = {

    tmpl: "view-splash",

    start: function () {
        $($("#" + splash.tmpl).html()).appendTo("body");
    },

    stop:  function () {
        $("." + splash.tmpl).remove();
    }
};

