/*
 *  FoldAway 0.1
 *  A nice showing/hiding effect for header
 *  http://github.com/...
 *
 *  Made by Lucifero Von Nachtosphere, using the jQuery Plugin Boilerplate
 *  Under MIT License
 */
;(function ($, window, document, undefined) {

    var pluginName = "foldAway",
        defaults   = {
            isVisible : "is--header-visible",
            isHidden  : "is--header-hidden",
            headerEl  : ".js-foldaway--header",
            bodyEl    : "body"
        };

    function Plugin (element, options) {
        this.element = element;
        this.settings = $.extend( {}, defaults, options );
        this._defaults = defaults;
        this._name = pluginName;

        this.init();
    }

    Plugin.prototype = {
        init: function () {
            var winH = $(this.element).height();
            var docH = $(document).height();
            var topY = $(this.element).scrollTop();

            var that = this;
            var timer;

            this._calculate();

            $(this.element).on("scroll", function () {
                clearTimeout(timer);
                timer = setTimeout(that._calculate.bind(that), 250, winH, docH);
            });
        },
        _calculate: function (winH, docH) {

            var currentTopY = $(this.element).scrollTop();
            var topYMax     = ((currentTopY + winH ) == docH) ? true : false;
            var elH         = $(this.element).find(this.settings.headerEl).height();

            // console.debug("currentTopY", currentTopY, "topYMax", topYMax, "elH", elH);

            if (currentTopY < this.topY && currentTopY > 1) {
                this.show();
            } else if (currentTopY == 0) {
                this.restore();
            } else if (topYMax) {
                this.show();
            } else if (currentTopY > elH) {
                this.hide();
            }
            this.topY = currentTopY;

        },
        restore: function () {
            $(this.settings.bodyEl).removeClass(this.settings.isHidden);
            $(this.settings.bodyEl).removeClass(this.settings.isVisible);
        },
        show: function () {
            $(this.settings.bodyEl).removeClass(this.settings.isHidden);
            $(this.settings.bodyEl).addClass(this.settings.isVisible);
        },
        hide: function () {
            $(this.settings.bodyEl).addClass(this.settings.isHidden);
        }
    };

    $.fn[pluginName] = function (options) {
        return this.each(function () {
            new Plugin(this, options);
        });
    };

})(Zepto, window, document);