






		(function() {
			if ('serviceWorker' in navigator) {
				navigator.serviceWorker.register('/serviceworker.cache.js').then(function(registration) {
					// Registration was successful
					console.log('ServiceWorker registration successful with scope: ', registration.scope);
				}).catch(function(err) {
					// registration failed :(
					console.log('ServiceWorker registration failed: ', err);
				});
			}
		})();


// async after window.onload to improve page speed and good score in google-page-speed
// (will instantly show splash page, before starting to load heavy scripts/css)
(function() {
	var baseW = 320;
	var baseH = 320;
	var scales = {};
	var scalesSizes = [110,120,130,150];

	scalesSizes.forEach(function(scale, i) {
		var lastW = 0;
		var lastH = 0;

		// at least 1px larger then last scale
		if (i > 0) {
			lastW = Math.floor(scalesSizes[ i - 1 ] / 100 * baseW);
			lastH = Math.floor(scalesSizes[ i - 1 ] / 100 * baseH);
		}

		var w = Math.floor(scale / 100 * baseW);
		var h = Math.floor(scale / 100 * baseH);

		var mediaW = 'all and (min-width: ' + (lastW) + 'px) and (max-width: ' + (w - 1) + 'px) and (min-height: ' + (lastH + 1) + 'px)';
		var mediaH = 'all and (min-width: ' + (w - 1) + 'px) and (min-height: ' + lastH + 'px) and (max-height: ' + (h - 1) + 'px)';

		if (i === scalesSizes.length - 1) {
			mediaW = 'all and (min-width: ' + (lastW) + 'px) and (min-height: ' + (lastH) + 'px)';
			mediaH = '';
		}

		var media = mediaW + (mediaH.length > 0 ? ', ' + mediaH : '');
		
		
		scales[ scale + '' ] = {
			media: media,
			href: 'style-' + scale + '.css?v=1.2.1'
		};
	});

	var hideSplash = function() {
		var splash = document.getElementById('splash');
		splash.parentNode.removeChild(splash);
	};

	var bootstrap = function() {
		var head = document.getElementsByTagName('head')[ 0 ];
		var isAndroid = (/Android/g).test(navigator.userAgent) ? true : false;

		
		var loadJs = function() {
			var el = document.createElement("script");
			el.onload = hideSplash;
			el.src = 'bundle.js?v=1.2.1';
			head.appendChild(el);
		};
		
		// load css first
		var setScaleLoaded = function(data) {
			if(data.loaded)
				return;

			data.loaded = true;
			console.log('css loaded ' + data.href);

			var loaded = Object.keys(scales).filter(function(key) {
				return !scales[ key ].loaded;
			}).length === 0;

			if(!loaded)
				return;
			
			loadJs();
		};

		Object.keys(scales).forEach(function(key) {
			var data = scales[ key ];

			var link = document.createElement('link');
			link.rel = 'stylesheet';
			link.type = 'text/css';
			link.media = data.media;
			link.href = data.href;

			// on android 4.0 didnt work
			if (isAndroid || !("onload" in link)) {
				setTimeout(function() {
					setScaleLoaded(data)
				}, 100);
			}

			link.onload = function() {
				setScaleLoaded(data);
			}

			head.appendChild(link);
		});
	};

	
	// boot in rAF/onload event for pagespeed optimization
	var onload = function(callback) {
		if (window.addEventListener) {
			window.addEventListener("load", callback, false);
		} else if (window.attachEvent) {
			window.attachEvent("onload", callback);
		} else {
			// might already have listener
			var _onload = window.onload;

			window.onload = function() {
				callback();
				(_onload || function() {}).call(window);
			};
		}
	};

	var raf = window.requestAnimationFrame ||
		window.mozRequestAnimationFrame ||
		window.webkitRequestAnimationFrame ||
		window.msRequestAnimationFrame ||
		window.oRequestAnimationFrame;
	
	if (raf) {
		raf(bootstrap);
	} else {
		onload(bootstrap);
	}
	
})();