if (!Cache.prototype.add) {
  Cache.prototype.add = function add(request) {
    return this.addAll([request]);
  };
}

if (!Cache.prototype.addAll) {
  Cache.prototype.addAll = function addAll(requests) {
    var cache = this;

    // Since DOMExceptions are not constructable:
    function NetworkError(message) {
      this.name = 'NetworkError';
      this.code = 19;
      this.message = message;
    }
    NetworkError.prototype = Object.create(Error.prototype);

    return Promise.resolve().then(function() {
      if (arguments.length < 1) throw new TypeError();
      
      // Simulate sequence<(Request or USVString)> binding:
      var sequence = [];

      requests = requests.map(function(request) {
        if (request instanceof Request) {
          return request;
        }
        else {
          return String(request); // may throw TypeError
        }
      });

      return Promise.all(
        requests.map(function(request) {
          if (typeof request === 'string') {
            request = new Request(request);
          }

          var scheme = new URL(request.url).protocol;

          if (scheme !== 'http:' && scheme !== 'https:') {
            throw new NetworkError("Invalid scheme");
          }

          console.log('addAll', request.clone().url);

          return fetch(request.clone());
        })
      );
    }).then(function(responses) {
      // TODO: check that requests don't overwrite one another
      // (don't think this is possible to polyfill due to opaque responses)
      return Promise.all(
        responses.map(function(response, i) {
          return cache.put(requests[i], response);
        })
      );
    }).then(function() {
      return undefined;
    });
  };
}

if (!CacheStorage.prototype.match) {
  // This is probably vulnerable to race conditions (removing caches etc)
  CacheStorage.prototype.match = function match(request, opts) {
    var caches = this;

    return this.keys().then(function(cacheNames) {
      var match;

      return cacheNames.reduce(function(chain, cacheName) {
        return chain.then(function() {
          return match || caches.open(cacheName).then(function(cache) {
            return cache.match(request, opts);
          }).then(function(response) {
            match = response;
            return match;
          });
        });
      }, Promise.resolve());
    });
  };
}



// generate new cache name, each emery startup
var cacheName = 'cache-1002001-1428619147067';
var debug = false;

var cacheNames = [
	cacheName
];

var urlsToCache = [
'/',
'bundle.js',
'index.html',
'index-cordova.html',
'index-winjs.html',
'index-chrome.html',
'index.js',
'webmanifest.json',
'manifest.json',
'manifest.webapp',
'chrome.background.js',
'chrome.webview.html',
'config.xml',
'style-110.css',
'style-120.css',
'style-130.css',
'style-150.css',
'res/fonts/museo-sans/MuseoSans_300-webfont.eot',
'res/fonts/museo-sans/MuseoSans_300-webfont.svg',
'res/fonts/museo-sans/MuseoSans_300-webfont.ttf',
'res/fonts/museo-sans/MuseoSans_300-webfont.woff',
'res/fonts/museo-sans/MuseoSans_300-webfont.woff2',
'res/index/background.jpg',
'res/h5client/avatar-default-128.png',
'res/h5client/avatar-default-256.png',
'res/h5client/avatar-default/large/default-0.jpg',
'res/h5client/avatar-default/large/default-1.jpg',
'res/h5client/avatar-default/large/default-10.jpg',
'res/h5client/avatar-default/large/default-11.jpg',
'res/h5client/avatar-default/large/default-12.jpg',
'res/h5client/avatar-default/large/default-13.jpg',
'res/h5client/avatar-default/large/default-14.jpg',
'res/h5client/avatar-default/large/default-15.jpg',
'res/h5client/avatar-default/large/default-16.jpg',
'res/h5client/avatar-default/large/default-17.jpg',
'res/h5client/avatar-default/large/default-18.jpg',
'res/h5client/avatar-default/large/default-19.jpg',
'res/h5client/avatar-default/large/default-2.jpg',
'res/h5client/avatar-default/large/default-20.jpg',
'res/h5client/avatar-default/large/default-3.jpg',
'res/h5client/avatar-default/large/default-4.jpg',
'res/h5client/avatar-default/large/default-5.jpg',
'res/h5client/avatar-default/large/default-6.jpg',
'res/h5client/avatar-default/large/default-7.jpg',
'res/h5client/avatar-default/large/default-8.jpg',
'res/h5client/avatar-default/large/default-9.jpg',
'res/h5client/avatar-default/medium/default-0.jpg',
'res/h5client/avatar-default/medium/default-1.jpg',
'res/h5client/avatar-default/medium/default-10.jpg',
'res/h5client/avatar-default/medium/default-11.jpg',
'res/h5client/avatar-default/medium/default-12.jpg',
'res/h5client/avatar-default/medium/default-13.jpg',
'res/h5client/avatar-default/medium/default-14.jpg',
'res/h5client/avatar-default/medium/default-15.jpg',
'res/h5client/avatar-default/medium/default-16.jpg',
'res/h5client/avatar-default/medium/default-17.jpg',
'res/h5client/avatar-default/medium/default-18.jpg',
'res/h5client/avatar-default/medium/default-19.jpg',
'res/h5client/avatar-default/medium/default-2.jpg',
'res/h5client/avatar-default/medium/default-20.jpg',
'res/h5client/avatar-default/medium/default-3.jpg',
'res/h5client/avatar-default/medium/default-4.jpg',
'res/h5client/avatar-default/medium/default-5.jpg',
'res/h5client/avatar-default/medium/default-6.jpg',
'res/h5client/avatar-default/medium/default-7.jpg',
'res/h5client/avatar-default/medium/default-8.jpg',
'res/h5client/avatar-default/medium/default-9.jpg',
'res/h5client/avatar-default/small/default-0.jpg',
'res/h5client/avatar-default/small/default-1.jpg',
'res/h5client/avatar-default/small/default-10.jpg',
'res/h5client/avatar-default/small/default-11.jpg',
'res/h5client/avatar-default/small/default-12.jpg',
'res/h5client/avatar-default/small/default-13.jpg',
'res/h5client/avatar-default/small/default-14.jpg',
'res/h5client/avatar-default/small/default-15.jpg',
'res/h5client/avatar-default/small/default-16.jpg',
'res/h5client/avatar-default/small/default-17.jpg',
'res/h5client/avatar-default/small/default-18.jpg',
'res/h5client/avatar-default/small/default-19.jpg',
'res/h5client/avatar-default/small/default-2.jpg',
'res/h5client/avatar-default/small/default-20.jpg',
'res/h5client/avatar-default/small/default-3.jpg',
'res/h5client/avatar-default/small/default-4.jpg',
'res/h5client/avatar-default/small/default-5.jpg',
'res/h5client/avatar-default/small/default-6.jpg',
'res/h5client/avatar-default/small/default-7.jpg',
'res/h5client/avatar-default/small/default-8.jpg',
'res/h5client/avatar-default/small/default-9.jpg',
'res/h5client/avatar-no-friends-128.png',
'res/h5client/avatar-no-friends-256.png',
'res/h5client/avatar-no-games-128.png',
'res/h5client/avatar-no-games-256.png',
'res/h5client/banner-gradient-bottom.png',
'res/h5client/banner-gradient-top.png',
'res/h5client/fonts/roboto/Roboto-Light-webfont.eot',
'res/h5client/fonts/roboto/Roboto-Light-webfont.svg',
'res/h5client/fonts/roboto/Roboto-Light-webfont.ttf',
'res/h5client/fonts/roboto/Roboto-Light-webfont.woff',
'res/h5client/header/ic_back_nopad-128.png',
'res/h5client/ic_back-128.png',
'res/h5client/ic_bell-128.png',
'res/h5client/ic_chat-128.png',
'res/h5client/ic_circle_select.png',
'res/h5client/ic_circle_selected.png',
'res/h5client/ic_contact-128.png',
'res/h5client/ic_contact_add.png',
'res/h5client/ic_controller-128.png',
'res/h5client/ic_controller-64.png',
'res/h5client/ic_exit-64.png',
'res/h5client/ic_forward_nopad-128.png',
'res/h5client/ic_group-128.png',
'res/h5client/ic_group-64.png',
'res/h5client/ic_info-64.png',
'res/h5client/ic_person-128.png',
'res/h5client/ic_person-64.png',
'res/h5client/ic_person_outline-128.png',
'res/h5client/ic_plus.png',
'res/h5client/ic_ranking-64.png',
'res/h5client/ic_refresh.png',
'res/h5client/ic_remove-128.png',
'res/h5client/ic_remove-64.png',
'res/h5client/ic_settings-64.png',
'res/h5client/ic_share-128.png',
'res/h5client/ic_star-64.png',
'res/h5client/ic_time-64.png',
'res/h5client/menu/ic_facebook-128.png',
'res/h5client/menu/ic_gplus-128.png',
'res/h5client/menu/ic_speaker_off-128.png',
'res/h5client/menu/ic_speaker_on-128.png',
'res/h5client/menu/ic_world-128.png',
'res/h5client/menu/menu_bg-1024.jpg',
'res/h5client/menu/menu_bg-1800.jpg',
'res/h5client/menu/menu_bg-512.jpg',
'res/h5client/profile/ic_add-64.png',
'res/h5client/profile/ic_remove-64.png',
'res/h5client/profile/ic_remove_outline-128.png',
'res/h5client/profile/ic_remove_outline-64.png',
'res/h5client/share-facebook.png',
'res/icons/ic_launcher_128.png',
'res/icons/ic_launcher_128@2x.png',
'res/icons/ic_launcher_128@4x.png',
'res/icons/ic_launcher_48.png',
'res/icons/ic_launcher_48@2x.png',
'res/icons/ic_launcher_48@3x.png',
'res/icons/ic_launcher_48@4x.png',
'res/mancala/game/bg_pattern.png',
'res/mancala/game/board_hori_1239.png',
'res/mancala/game/board_vert_1239.png',
'res/mancala/game/board_vert_890.png',
'res/mancala/game/dialog_end_goblet.png',
'res/mancala/game/dialog_end_score.png',
'res/mancala/game/hole_hori_186.png',
'res/mancala/game/hole_select_186.png',
'res/mancala/game/hole_shade_186.png',
'res/mancala/game/hole_vert_186.png',
'res/mancala/game/ic_avatar_default.png',
'res/mancala/game/ic_back-128.png',
'res/mancala/game/ic_chat.png',
'res/mancala/game/ic_mancala_noti_left.png',
'res/mancala/game/ic_mancala_turn.png',
'res/mancala/game/overlay_hole_highlight.png',
'res/mancala/game/overlay_hole_select.png',
'res/mancala/game/overlay_store_highlight.png',
'res/mancala/game/shade.png',
'res/mancala/game/shades_hori_1335.png',
'res/mancala/game/sounds.action.mp3',
'res/mancala/game/sounds.action.ogg',
'res/mancala/game/stone_0.png',
'res/mancala/game/stone_1.png',
'res/mancala/game/stone_2.png',
'res/mancala/game/stone_3.png',
'res/mancala/game/stone_4.png',
'res/mancala/game/stone_5.png',
'res/mancala/game/store_hori_396.png',
'res/mancala/game/store_select_vert_396.png',
'res/mancala/game/store_shade_hori_396.png',
'res/mancala/game/store_shade_vert_396.png',
'res/mancala/game/store_vert_396.png',
'res/mancala/icon-114.png',
'res/mancala/icon-120.png',
'res/mancala/icon-16.png',
'res/mancala/icon-32.png',
'res/mancala/icon-36.png',
'res/mancala/icon-57.png',
'res/mancala/icon-60.png',
'res/mancala/icon-72.png',
'res/mancala/icon-90.png',
'res/mancala/icon-android-96-xhdpi.png',
'res/mancala/icon.png',
'res/mancala/icon_chrome_128.png',
'res/mancala/icon_chrome_16.png',
'res/mancala/icon_chrome_48.png',
'res/mancala/tutorial/tut_capture.jpg',
'res/mancala/tutorial/tut_capture_50.jpg',
'res/mancala/tutorial/tut_end.jpg',
'res/mancala/tutorial/tut_end_50.jpg',
'res/mancala/tutorial/tut_free_turn.jpg',
'res/mancala/tutorial/tut_free_turn_50.jpg',
'res/mancala/tutorial/tut_holes_store.jpg',
'res/mancala/tutorial/tut_holes_store_50.jpg',
'res/mancala/tutorial/tut_sow.jpg',
'res/mancala/tutorial/tut_sow_50.jpg',
'res/mancala/tutorial/tut_sow_store.jpg',
'res/mancala/tutorial/tut_sow_store_50.jpg'

];

self.addEventListener('install', function(event) {
  console.log('install');

	// Perform install steps
	event.waitUntil(caches.open(cacheName)
		.then(function(cache) {
			console.log('Opened cache');
			return cache.addAll(urlsToCache);
		}));
});

self.addEventListener('fetch', function(event) {
  // do not serve from cache in debug mode
  if(debug) {
    return event.respondWith(fetch(event.request));
  }

  event.respondWith(caches.match(event.request).then(function(response) {
	   console.log('fetch ' + event.request.url);
      return response || fetch(event.request);
   }));
});

// A new ServiceWorker is now active
// clear up old caches
self.addEventListener("activate", function (event) {
	console.log('activate');

  event.waitUntil(caches.keys()
  	.then(function (allCaches) {
        return Promise.all(allCaches.map(function(cacheName) {
            if (cacheNames.indexOf(cacheName) === -1) {
              return caches.delete(cacheName);
            }
          })
        );
      })
  );
});