//inizializza le variabili
//dimensioni dello schermo
var SCREEN_HEIGHT = 400;
var SCREEN_WIDTH = 320;
//finestra di visualizzazione in coordinate Mandelbrot
var a1 = -2.0;
var b1 = -1.2;
var a2 = 1.0;
var b2 = 1.2;
//numero di cicli
var it = 25;
var delta_x ;
var delta_y; 
// palette di 12 colori
var colori = ["#FFFFFF","#FF0000","#00FF00","#0000FF","#FF00FF","#FFFF00","#00FFFF","#FFaa00","#abcedf","#fedc0a","#ab16dd","#d00fba","#edabcc","#ddacff"];

//function punto(x1,y1,

function disegna(r_mi,i_mi,r_ma,i_ma,ite)
{
//effettua il calcolo dell'insieme date le dimensioni della finestra
var canvas = document.getElementById("mandelbrot");
		if (canvas.getContext) {
		
		  var context = canvas.getContext("2d");
		  //rende il fondo nero
		  context.fillStyle="rgb(0,0,0)";
		  context.fillRect(0, 0, canvas.width, canvas.height);
			var re_min = r_mi;
			var im_min = i_mi;
			var re_max = r_ma;
			var im_max = i_ma;
			var iterazioni = ite;
			var r;
			var a,b;
			var x,y,x_new,y_new;
			var test;
			var k,j,i;
			var re_factor = (re_max-re_min);
			var im_factor = (im_max-im_min);
			for (var i=0;i<SCREEN_HEIGHT;i++)
			 {
			 for (var j=0;j<SCREEN_WIDTH;j++)
			  {
			  a = re_min+(j*re_factor/SCREEN_WIDTH);
			  b = im_min+(i*im_factor/SCREEN_HEIGHT);
			  x = 0;
			  y = 0;
			  test = 0;
			  for (var k=0;k<iterazioni;k++)
			   {
			   x_new = (x*x)-(y*y)+a;
			   y_new = (2*x*y)+b;
			   if (((x_new*x_new)+(y_new*y_new))>4)
				{
				// colora il punto
				r = k%12;
				context.beginPath();
				context.fillRect(j-1,i-1,1,1);
				context.fillStyle=colori[r];
				context.stroke();
				break;
				}
			   x = x_new;
			   y = y_new;
			   }
			  }
			 }
		}
}


function doMouseDown(event)
	{
	canvas_x = event.pageX;
	canvas_y = event.pageY;
	//calcola il punto in coordinate Mandelbrot
	var p1 = (((a2-a1)/SCREEN_WIDTH)*canvas_x) + a1;
	var p2 = (((b2-b1)/SCREEN_HEIGHT)*canvas_y) + b1;
	//calcola la dimensione della finestra (riduzione di 1/4)
	var delta_x = (a2-a1)/4;
	var delta_y = delta_x*(SCREEN_WIDTH/SCREEN_WIDTH);
	//aumenta il numero di iterazioni per ogni ciclo
	it = it + 75;
	//definisce la finestra intorno al punto cliccato
	a1 = p1 - delta_y;
	b1 = p2 - delta_x;
	a2 = p1 + delta_y;
	b2 = p2 + delta_x;
	disegna(a1,b1,a2,b2,it);
	}
	
function res(event)
	{
	a1 = -2.0;
	b1 = -1.2;
	a2 = 1.0;
	b2 = 1.2;
	it = 25;
	disegna(a1,b1,a2,b2,it);
	}
	
	window.onload = function()
	{
	//riscala alla dimensione della finestra
	var canvas = document.getElementById("mandelbrot");
	var button = document.getElementById("reset");

	//aggiunge l'evento click del mouse 
	canvas.addEventListener("mousedown",doMouseDown,false);
	button.addEventListener("click", res,false);
	disegna(a1,b1,a2,b2,it);
	}
