var soundDir = "sounds/";  // Workaround for Android, not compatible with other devices.
var audio = new Audio();
if (audio.canPlayType("audio/ogg")) {
    format = "ogg";
} else {
    format = "mp3";
}

var SoundManager = {
	play: function(soundId) {
		var file = soundDir + soundId + "." + format;
		
	/* -----PhoneGap API-------
	
		this.media = new Media(file, onMediaSuccess, onMediaError);
		this.media.play();
		var mediaTimer = setInterval(function() { 
		// This timer forces media object to update the current position
		// (patch for a bug: media object sometimes not calling success function)
			// Get position
			SoundManager.media.getCurrentPosition(
			    // Success callback function
			    function(position) {
				if (position >= 0) {
				    console.log((position) + " sec");
				} else {
				    clearInterval(mediaTimer);
				}
			    },
			    // Error callback function
			    function(e) {
				console.log("Error getting position=" + e);
			    }
			);
		}, 1000);
	*/
	
	// (Browser & FirefoxOS) HTML5 API
		this.audio = new Audio();
		$(SoundManager.audio).one('ended',function(){
		    onMediaSuccess();
		});
		$(SoundManager.audio).one('error',function(){
		    onMediaError();
		});
        this.audio.src = file;
        this.audio.play();
	},
	
	setSuccessFunc: function(theFunc) {
		this.play_success = theFunc;
	},
	
	clearSuccessFunc: function() {
		this.play_success = function() { return; };
	},
	
	play_success: function() {
		console.log("[W]: (SoundManager) Nothing set for sound success.");
	}
};

function onMediaError(error) {
	console.log('[MediaError] code: '    + error.code    + '\n' + 
                  'message: ' + error.message + '\n');
    SoundManager.play_success();
}

function onMediaSuccess() {
	// --phonegap only--
	// SoundManager.media.release();
	SoundManager.play_success();
}
