$.getScript("js/numbers_" + localStorage.getItem("language") + ".js");

function reset() {
    window.clearTimeout(reactTimer);
    $("#keys .key").css("background-color", "orange");
    $("#blockingdiv").css("z-index", -1);
    $("#dialog").css("visibility", "hidden");
    $("#text").html(applesL + " + " + applesR + " = ");
    $("#text").css("text-decoration", "none");
    $("#text").css("color", "black");
}

function shuffleArray(array) {
  for (var i = array.length - 1; i > 0; i--) {
      var j = Math.floor(Math.random() * (i + 1));
      var temp = array[i];
      array[i] = array[j];
      array[j] = temp;
  }
  return array;
}

var applesL = Math.ceil(Math.random()*6);
var applesR = Math.ceil(Math.random()*6);
var apples = applesL + applesR;

$(document).ready(function() {
    // Display text
        $("#text").html(applesL + " + " + applesR + " = ");

    // Display apple graphics
    for (i=0; i<applesL; i++) {
        $("#left").append('<img alt="Apple" class="apple" src="img/red_apple.svg">');
    }
    for (i=0; i<applesR; i++) {
        $("#right").append('<img alt="Apple" class="apple" src="img/red_apple.svg">');
    }

    // Load random number keys
    var randomnumbers = []
    while(randomnumbers.length < 3){
      var randomnumber=(Math.random()<.5)? (apples + Math.ceil(Math.random()*9) + 1) : (apples - Math.ceil(Math.random()*(apples-2)) - 1);
      if (randomnumber==0) randomnumber=apples+1; // Don't generate zeros
      var found=false;
      for(var i=0;i<randomnumbers.length;i++){
        if(randomnumbers[i]==randomnumber){found=true;break}
      }
      if(!found)randomnumbers[randomnumbers.length]=randomnumber;
    }
    randomnumbers[randomnumbers.length] = apples;

    shuffleArray(randomnumbers);

    for(i=0; i<randomnumbers.length; i++) {
        $("#keys div").append('<button type="button" class="key">' + randomnumbers[i] + '</button>');
    }

    $(".key").on("touchstart", function(){
     var keyN = parseInt($(this).text());
     var key = this;
     $(key).css("background-color", "grey");
     $("#blockingdiv").css("z-index", 99);
     $.getJSON("locales/general." + localStorage.getItem("language") + ".json", function( locale ) {   
       $("#text").html(applesL + " + " + applesR + " = " + keyN);
       if (keyN === apples) {
           var audio = new Audio();
           // 1. Play number
           play(apples, function(){
               // Reformat number text and change key color
                $("#text").css("color", "green");
                $(key).css("background-color", "green");
               // Show dialog
                $("#dialog .message").html(locale.messages.ok);
                $("#dialog").css("background-image", "url('img/bien-hoja.png')");
                $("#dialog").css("visibility", "visible");
              // Play bell
                 SoundManager.clearSuccessFunc();
                 SoundManager.play("bien");
              // Wait for user interaction or reload after 5 seconds
                $("#blockingdiv").on("touchstart", function(){
                    location.reload();
                });
                reactTimer = window.setTimeout('location.reload()', 3000);
           });
       } else {
           // Play number
           play(keyN, function(){
               // Reformat number text and change key color
                $("#text").css("text-decoration", "line-through");
                $("#text").css("color", "red");
                $(key).css("background-color", "red");
               // Show dialog
                $("#dialog .message").html(locale.messages.tryagain);
                $("#dialog").css("background-image", "url('img/mal-hoja.png')");
                $("#dialog").css("visibility", "visible");
                // Play bell
                SoundManager.clearSuccessFunc();
                SoundManager.play("ohoh");
                // Wait for user interaction or reset after 5 sec.
                $("#blockingdiv").on("touchstart", reset);
                reactTimer = window.setTimeout(reset, 3000);
                return false;
           });
       }
      });
    });

});

// Get and display locale strings
$.getJSON("locales/general." + localStorage.getItem("language") + ".json", function( locale ) {
    $("#txt_language").html(locale.nav.language);
    $("#txt_home").html(locale.nav.home);
    $("#question p").html(locale.questions.howmanysum);
    $("#dialog .continue").html(locale.nav.touchtocontinue);
});
