// Versie 1.0
// Speciaal voor Firefox OS

   var aGameField = new Array(10);
   // Hier wordt een multidimensionale Array
   // gemaakt.
   for (var i=0; i< aGameField.length;i++)
     aGameField[i] = new Array(10);
   
   // Dit is een copy van het veld om de
   // laatste zet terug te zetten: undo
   var aUndoField = new Array(10);
   // Hier wordt een multidimensionale Array
   // gemaakt.
   for (var i=0; i< aUndoField.length;i++)
     aUndoField[i] = new Array(10);


   // Copy van het gamefield om hiermee een nieuw
   // veld op te bouwen na het krimpen
   var aCopyGameField = new Array(10);
   // Hier wordt een multidimensionale Array
   // gemaakt.
   for (var i=0; i< aCopyGameField.length;i++)
     aCopyGameField[i] = new Array(10);
   
   // Tabel om de aan een gesloten marbles in op te slaan
   // bij een muisklik.
   var aMarbles = new Array(100);
   for (var i=0; i< aMarbles.length;i++)
     aMarbles[i] = new Array(2);
   
   var iMarbleIndex = 0;
   var bMarble = false;
   var iScore = 0;
   var bGameOver = false;
   var bBoardEmpty = false; 
   var iScenePointer;
   var iUndoPunten = 0;
   var bUndo = false;
   var iScreenRows;
   
   // Alle velden op 0 zetten van de copy field
   function ResetCopyField(){
      for(var y=0; y < iScreenRows; y++){
         for( var x=0; x< 10; x++){
            aCopyGameField[x][y] = 0;
         }
      }
   }   
   // Undo, de tabel wordt terug gezet en het
   // board wordt weer opnieuw opgebouwd.
   // je kan 1 keer terug dus link wordt ook disabled.
   function UnDo(){
      // Alleen als er een set gedaan is anders kan
      // De boolean daarvoor dat ook bij de tweede keer Undo
      // niet nog eens de punten eraf gaan.
      // De laatste zet kan niet worden gereset.
      if(bUndo && !bGameOver){
         for(var y=0; y < iScreenRows; y++){
            for( var x=0; x< 10; x++){
               aGameField[x][y] = aUndoField[x][y];
            }
         }
         iScore-= iUndoPunten;
         document.getElementById("scoreboard").innerHTML = iScore;         
         makeGameBoard();  
         bUndo = false;
		 // Undo button gray-out, disabled
		 // document.getElementById("btn_undo").style.background = "#ccc";
      }
   }   
   // Controleerd na iedere klik of de game over is
   // Indien game over dan bGameOver = true en verdere
   // muisklikken hebben geen invloed meer en voorkomt
   // dat het dialoogvenster blijft opkomen.
   
   function CheckGameOver(){
      bGameOver = true;
      for(var y=0; y < iScreenRows; y++){
         for( var x=0; x< 9; x++){
            if(aGameField[x][y] == aGameField[x + 1][y]  && aGameField[x][y] !=0)
              bGameOver = false;
         }
      }
      if(bGameOver){
         for(var x=0; x < 10; x++){
            for( var y=0; y< iScreenRows -1; y++){
               if(aGameField[x][y] == aGameField[x][y + 1] && aGameField[x][y] !=0)
                 bGameOver = false;
            }
         }
      }
      // Controleren of het hele veld leeg is
      // dan krijg je nog een extra 20 bonus punten
      // en de tekst wordt aangepast in het dialoogvenster
      if(bGameOver){
         var i = 0;
         for(var y=0; y < iScreenRows; y++){
            for( var x=0; x< 10; x++){
               if(aGameField[x][y] != 0)
                  i++;
            }
          }
          if(i==0)
            bBoardEmpty = true;
       }
   } 
   // Controleerd of er aanliggende marbles zijn
   // CheckMarble(x,y) wordt aangeroepen vanuit
   // ChackMarbleIn.
   function CheckMarble(x,y,z){
     // Coordinaten van de steen worden hier
     // opgeslagen. 
     // z geeft aan waarvandaan de functie wordt aangelopen 
     // z undifined = door muisklik anders recusie = 1
     if(typeof(z)=="undefined") // Start door muisklik
     {
       z=0;
       iMarbleIndex = 0;
     }    
     aMarbles[iMarbleIndex][0] = x;
     aMarbles[iMarbleIndex][1] = y;
     
     var iTemp;
     // Check rechts
     if (x<9){
        iTemp = x+1;
        if(aGameField[x][y] == aGameField[iTemp][y]){
          // check of de marble al is opgeslagen
          bMarble = false;
          for(var i = 0; i <= iMarbleIndex; i++){
             if(aMarbles[i][0] == iTemp && aMarbles[i][1] == y)
               bMarble = true;
          }
          if(!bMarble){
             iMarbleIndex++;
             CheckMarble(iTemp,y,1);
          }
        }
     }
     if (y<9){
        iTemp = y+1;
        if(aGameField[x][y] == aGameField[x][iTemp]){
          // check of de marble al is opgeslagen
          bMarble = false;
          for(var i = 0; i <= iMarbleIndex; i++){
             if(aMarbles[i][0] == x && aMarbles[i][1] == iTemp)
               bMarble = true;
          }
          if(!bMarble){
             iMarbleIndex++;          
             CheckMarble(x,iTemp,1);
           }
        }      
     }
     if (x>0){
        iTemp = x-1;
        if(aGameField[x][y] == aGameField[iTemp][y]){
          // check of de marble al is opgeslagen
          bMarble = false;
          for(var i = 0; i <= iMarbleIndex; i++){
             if(aMarbles[i][0] == iTemp && aMarbles[i][1] == y)
               bMarble = true;
          }
          if(!bMarble){
             iMarbleIndex++;        
             CheckMarble(iTemp,y,1);
           }
        }
     }
     if (y>0){
        iTemp = y-1;
        if(aGameField[x][y] == aGameField[x][iTemp]){
          // check of de marble al is opgeslagen
          bMarble = false;
          for(var i = 0; i <= iMarbleIndex; i++){
             if(aMarbles[i][0] == x && aMarbles[i][1] == iTemp)
               bMarble = true;
          }
          if(!bMarble){
             iMarbleIndex++;         
             CheckMarble(x,iTemp,1);
           }
        }
     }
   }

   // Wordt door muisklik aangelopen
   function CheckMarbleIn(x,y){
     var iTmpX, iTmpY,iTmp;
     var bKolomHasMarble;
     CheckMarble(x,y);   
     if(iMarbleIndex > 0 && bGameOver == false) // 0 als er op een eenzame steen geklikt wordt
     {
        // Score vastleggen voor deze set van Marbles
        if(iMarbleIndex == 1){
          iUndoPunten = 2;
          iScore+=2;
        }
        else{
          iUndoPunten = (iMarbleIndex + 1) * (iMarbleIndex + 1);
          iScore+= (iMarbleIndex + 1) * (iMarbleIndex + 1);
        }
        // De score op het scherm zetten
        document.getElementById("scoreboard").innerHTML = iScore;
        // Een kopie van het huidige veld maken
        // zodat er een UNDO mogelijk is.
        for(var y=0; y < iScreenRows; y++){
           for( var x=0; x< 10; x++){
              aUndoField[x][y] = aGameField[x][y];
           }
        } 
        // Nu er een kopie is werkt de Undo Functie 1 x
        bUndo = true;
		// document.getElementById("btn_undo").style.background = "#87A0D5";

          // Plekken die wegvallen op 0 zetten
          for(var i = 0; i <= iMarbleIndex; i++){
            iTmpX =aMarbles[i][0];
            iTmpY =aMarbles[i][1];
            aGameField[iTmpX][iTmpY] = 0; 
          }
          ResetCopyField();
          // Array opnieuw opbouwen van onder naar boven
          // lopen steed kolom voor kolom
          for(var x=0; x < 10; x++){
            iTmpY = iScreenRows - 1;
            for(var y=iScreenRows-1; y >= 0; y--){
               // dan opslaan in de copy
               if(aGameField[x][y] != 0){
                 aCopyGameField[x][iTmpY] = aGameField[x][y];
                 iTmpY--;
               }              
            }            
         }
         // Game field weer opbouwen
         for(var y=0; y < iScreenRows; y++){
            for( var x=0; x< 10; x++){
               aGameField[x][y] = aCopyGameField[x][y];         
            }
         }     
         ResetCopyField();
         // Indien er n hele verticale regel leeg is dan
         // alles naar rechts schuiven. Loop van achter naar
         // voren
         iTmpX = 9;
          for(var x=9; x >= 0; x--){
             bKolomHasMarble = false;
             for(var y=0; y < iScreenRows; y++){
                // Check de complete kolom
                if(aGameField[x][y] != 0){
                  bKolomHasMarble = true;
                }              
             }           
             // Als true dan en copy slag van de complete kolom 
             // naar de copyField. Dus omdat er een getal in zit
             if(bKolomHasMarble){
                for(var y=0; y < iScreenRows; y++){
                  // Check de complete kolom
                  aCopyGameField[iTmpX][y] = aGameField[x][y];                     
                }
                iTmpX--;
             }
           }
            // Als false dan en copy slag
         for(var y=0; y < iScreenRows; y++){
            for( var x=0; x< 10; x++){
               aGameField[x][y] = aCopyGameField[x][y];         
            }
         } 
         // Voor het opnieuw opbouwen van het spelboard
         // checken of de game over is.
         CheckGameOver();
         makeGameBoard();           
         if(bGameOver){
            var pText;
            var iTmpScore
            
            // Bij een lagere resolutie heb je minder
            // aantal rijen en dus een lagere score kans
            // dus de opmerkingen zouden dan niet kloppen
            // het wordt omgerekend
            // iScore = parseInt((iScore / 10) * iScreenRows);
            
            // Versie 0.0.7 wanneer het bord leeg is
            // krijg je een nieuw gevuld bord en kan je
            // verder spelen.
            if(bBoardEmpty){
               iScore+=50;
               iMarbleIndex = 0;
               bMarble = false;
               bGameOver = false;
               bBoardEmpty = false;
               iUndoPunten = 0;
               bUndo = false;
               ResetCopyField();
               for(var y=0; y < 10; y++){
                  for( var x=0; x< 10; x++){
                     aGameField[x][y] = Math.ceil(5*Math.random());         
                  }
               }  
               makeGameBoard();
            }
			// Einde game
            else{
            if(iScore < 180)
               pText = "Mmmm.... that's not a lot<br>Score: " + iScore;
            else if(iScore >= 180 && iScore < 200)
               pText = "Ok..you are a beginner<br>Score: " + iScore;
            else if(iScore >= 200 && iScore < 260)                           
               pText = "It's just above average<br>Score: " + iScore;
            else if(iScore >= 260 && iScore < 300)
               pText = "Nice score but you can do better<br>Score: " + iScore;
            else if(iScore >= 300 && iScore < 360)                                          
               pText = "Now we are talking !!<br>Score: " + iScore;
            else if(iScore >= 360)
               pText = "You have earned your place in the hall of fame !! " + iScore;
  	           document.getElementById("gamestatus").innerHTML = pText;
	           document.querySelector('#confirm').className = 'fade-in';
            }
         }
      }
   }     
   function makeGameBoard(){
      var eventString,iImgSize,htm,start,x,y;
	  // Scherm breedte bepaalt image size
	  // Niet responsive dus vaste waarde
      iImgSize = 30; 
      var el = document.getElementById("gameboard");
      htm = ""    
      for (y = 0; y < iScreenRows; y++){
        for (x = 0; x < 10; x++){
           // Onclick alleen op de marbles en alleen
           // als bGameOver is false
		   // eventString x en y op -1 zodat empty image
		   // kan worden afgevangen en er niks mee wordt
		   // gedaan in het click event
           if(aGameField[x][y] !=0 && bGameOver == false) {
              eventString = " x="+x+" y="+y;
           }
           else
              eventString = " x=-1 y=-1";
           
           htm +="<div class='marble'"+ eventString +">"
           switch(aGameField[x][y]){
              case 0:
                 htm +="<img title=\"Empty\" name=\"empty\" src=\"images/empty"+iImgSize+".png\"" 
              break;          
              case 1:
                 htm +="<img title=\"Purple\" name=\"purple\" src=\"images/purple"+iImgSize+".png\"" 
              break;
              case 2:
                 htm +="<img title=\"Blue\" name=\"blue\" src=\"images/blue"+iImgSize+".png\"" 
              break;
              case 3:
                 htm +="<img title=\"Green\" name=\"green\" src=\"images/green"+iImgSize+".png\"" 
              break;
              case 4:
                 htm +="<img title=\"Red\" name=\"red\" src=\"images/red"+iImgSize+".png\"" 
              break;
              case 5:
                 htm +="<img title=\"Yellow\" name=\"yellow\" src=\"images/yellow"+iImgSize+".png\"" 
              break;
           }
           htm += "/>"
           htm += "</div>"
        }
    }
    el.innerHTML = htm;
	// Nu ervoor zorgen dat de click functie werkt
	// CheckMarbleIn(0,0) de cordinaten worden doorgegeven
	// als attributes van de div 
	$('.marble').on('click', function(e){
       var xTmp,yTmp;
       xTmp = parseInt(this.getAttribute("x"));
       yTmp = parseInt(this.getAttribute("y"));
       if(xTmp != -1 && yTmp !=-1)
	   CheckMarbleIn(xTmp,yTmp);
	});
}   
function setupgame() {
   // iScenePointer = i;
   iRows = 10;
   iMarbleIndex = 0;
   bMarble = false;
   iScore = 0;
   bGameOver = false;
   bBoardEmpty = false;
   iUndoPunten = 0;
   bUndo = false;
   document.getElementById("scoreboard").innerHTML = iScore;
   ResetCopyField()
   // Het gameboard vullen met marbels getallen
   // 1 - paars
   // 2 - blauw
   // 3 - groen
   // 4 - rood
   // 5 - geel
   iScreenRows = 10;    
   for(var y=0; y < iScreenRows; y++){
      for( var x=0; x< 10; x++){
         aGameField[x][y] = Math.ceil(5*Math.random());         
      }
   }
   makeGameBoard();
}
// Button setup
document.querySelector('#btn_newgame').onclick = function() {
  setupgame();
} 
document.querySelector('#btn_undo').onclick = function() {
  UnDo();
}
//confirm alleen voor het sluiten nodig
document.querySelector('#confirm').addEventListener ('click', function () {
  this.className = 'fade-out';
});
// Startup new game
setupgame();
