function Linguas () {

    this.linguaPadrao = "pt-BR";
    this.nomeCookie = "idiomaPadrao";

    this.disponiveis = new Array();
    this.disponiveis.push("pt-BR");
    this.disponiveis.push("en-US");

    this.textos = {
        "pt-BR": {
            "labelJogador1"     : "Nome do Jogador 1",
            "labelJogador2"     : "Nome do Jogador 2",
            "iniciarPartida"    : "Iniciar Partida",
            "voltar"            : "Voltar",
            "jogador1Vazio"     : "Jogador 1",
            "jogador2Vazio"     : "Jogador 2",
            "configuracoes"     : "Configurações",
            "escolhaIdioma"     : "Escolha um idioma:",
            "portugues"         : "Português",
            "ingles"            : "Inglês",
            "pontosDeVida"      : "Pontos de Vida",
            "pontosDeVeneno"    : "Pontos de Veneno",
            "labelTurno"        : "Turno: ",
            "noTurno"           : " no turno ",
            "life"              : " de vida",
            "poison"            : " de veneno",

            /** Texto para o alerta de ataualização **/
            "atualizacao_1"     : "Existe uma atualização para a versão ",
            "atualizacao_2"     : " desde de ",
            "atualizacao_3"     : " com as sequintes alterações: ",
            "atualizacao_4"     : "TOQUE PARA BAIXAR"

        },
        "en-US": {
            "labelJogador1"     : "Player Name 1",
            "labelJogador2"     : "Player Name 2",
            "iniciarPartida"    : "Start Game",
            "voltar"            : "Back",
            "jogador1Vazio"     : "Player 1",
            "jogador2Vazio"     : "Player 2",
            "configuracoes"     : "Settings",
            "escolhaIdioma"     : "Choose a language:",
            "portugues"         : "Portuguese",
            "ingles"            : "English",
            "pontosDeVida"      : "Life Points",
            "pontosDeVeneno"    : "Poison Points",
            "labelTurno"        : "Turn: ",
            "noTurno"           : " in turn ",
            "life"              : " of life",
            "poison"            : " of poison",

            /** Texto para o alerta de ataualização **/
            "atualizacao_1"     : "There is an update to version ",
            "atualizacao_2"     : " since ",
            "atualizacao_3"     : " with the following changes: ",
            "atualizacao_4"     : "TOUCH FOR DOWNLOAD"
        }
    };

    this.verificaLinguaPadrao = function() {

        var lingua              = this.disponiveis.indexOf(navigator.language);
        var linguaConfigurada   = this.cookie(this.nomeCookie);

        if (lingua < 0 && (linguaConfigurada == null || linguaConfigurada == ""))
        {
            lingua = "pt-BR";
        }
        else if (linguaConfigurada != null) {
            lingua = linguaConfigurada;
        }
        else
        {
            lingua = this.disponiveis[lingua];
        }

        this.linguaPadrao = lingua;

    }

    this.alterarIdioma = function (idioma) {
        this.linguaPadrao = idioma;
        document.cookie=this.nomeCookie + "=" + idioma;
        this.cookie(this.nomeCookie);
    }

    this.texto = function (texto){

        return this.textos[this.linguaPadrao][texto];

    }

    this.cookie = function (c_name) {
        var c_value = document.cookie;
        var c_start = c_value.indexOf(" " + c_name + "=");
        if (c_start == -1) {
            c_start = c_value.indexOf(c_name + "=");
        }
        if (c_start == -1) {
            c_value = null;
        }
        else {
            c_start = c_value.indexOf("=", c_start) + 1;
            var c_end = c_value.indexOf(";", c_start);
            if (c_end == -1) {
                c_end = c_value.length;
            }
            c_value = unescape(c_value.substring(c_start,c_end));
        }
        return c_value;
    }

    this.verificaLinguaPadrao()

}