'use strict';

const UI = (function() {
  navigator.mozL10n.ready(function localize() {
    // Do nothing rigth now
  });

  /**
  var settingsView = document.querySelector('#settings-view');

  var settingsOpen = document.querySelector('#settings-open');
  settingsOpen.addEventListener('click', function(e) {
    settingsView.dataset.pagePosition = 'viewport';
  });

  var settingsDone = document.querySelector('#settings-done');
  settingsDone.addEventListener('click', function(e) {
    settingsView.dataset.pagePosition = 'bottom';
  });
  */

  var current_cost = 0;
  var task;
  var running = false;
  var minutes = 0;
  var seconds = 0;

  var resetCounters = function() {
    current_cost = 0;
    minutes = 0;
    seconds = 0;
  }

  var incrementTotal = function() {
    var historic = parseInt(localStorage.getItem('historic'));
    window.localStorage.setItem('historic', historic + 1);
    renderTotal();
  }

  var renderTotal = function() {
    var historic = localStorage.getItem('historic') || "0";
    document.querySelector("#total").innerHTML = historic + " minutes";
  }

  var pad = function(num) {
    return (num < 10) ? '0' + num.toString() : num.toString();
  }

  var startButton = document.querySelector('#start');
  startButton.addEventListener('click', function(e) {
    running = !running;

    if (running) {

      resetCounters();

      startButton.className = 'danger';
      startButton.innerHTML = 'Stop Meeting'

      task = setInterval(function() {
        seconds++;
        if (seconds == 60) {
          seconds = 0;
          minutes++;

          incrementTotal();
        }

        current_cost += 60 / 3600; // 1 min = 1 eur (60 eur/h avg)

        document.querySelector(".current_minutes").innerHTML = pad(minutes) + ":" + pad(seconds);
        document.querySelector(".current_cost").innerHTML = current_cost.toFixed(2) + " EUR / head";
      }, 1000);
    } else {
      clearInterval(task);

      startButton.className = 'recommend';
      startButton.innerHTML = 'Start Meeting';      
    }
  });

  renderTotal();
}());
