// provide our own console if it does not exist, huge dev aid!
if (typeof window.console == "undefined") {
	window.console = {log:function(str){window.external.Notify(str);}};
};

// output any errors to console log, created above.
window.onerror = function(e) {
	console.log("window.onerror ::" + JSON.stringify(e));
};

console.log("Installed console ! ");

function onDeviceReady(e) {
	if (window.device) {
		console.log(device.platform);
	}
	console.log("deviceready event fired!");
	document.addEventListener("resume", onResume, false);
	document.addEventListener("backbutton", onBackButton, false);
	document.addEventListener("menubutton", onMenuButton, false);
	document.addEventListener("keyboard", function() {}, false);
	document.addEventListener("keyboardHidden", function() {}, false);
	document.addEventListener("orientation", function() {}, false);
	document.addEventListener("screenLayout", function() {}, false);
	//window.setTimeout(startApp, 5000);
	startApp();
};
function startApp() {
	console.log("startApp");
	mt = new MathGame().renderInto(document.body);
};
function onResume(e) {
	console.log("resume event fired!");
	mt.resume();
};
function onExit(e) {
	console.log("exit event fired!");
};
function onBackButton(e) {
	console.log("backbutton event fired!");
	mt.backButton();
};
function onMenuButton(e) {
	console.log("menubutton event fired!");
	mt.openAboutBox();
};

Mojo = window.Mojo || {};
// LunaSysMgr calls this when the windows is minimized or closed.
Mojo.stageDeactivated = function() {
	mt.pause();
};

PhoneGap.addConstructor(function() {
	console.log("PhoneGap.addConstructor is working");
});

// call onDeviceReady on desktop browser
window.onload = function () {
//function onLoad() {
	document.addEventListener("deviceready", onDeviceReady, false);
	document.addEventListener("exit", onExit, false);

	var portals = [642, 947, 559, 958, 659, 551, 635, 661];
	innerActive_aid = "MetaViewSoft_MathGame_other";
	innerActive_ad_params.test = false;
	innerActive_ad_params.portal = portals[Math.floor(Math.random() * portals.length)];
	innerActive_ad_params.category = "Game";
	innerActive_ad_params.keywords = "Math,Kids,Learn";

	console.log("window.onload");
	console.log(navigator.userAgent);
	gblAndroid = false;
	gblDesktop = false;
	if (navigator.userAgent.indexOf("Android") > -1) {
		innerActive_aid = "MetaViewSoft_MathGame_Android";
		innerActive_ad_params.portal = (Math.random() > 0.3) ? 559 : 958;
		gblAndroid = true;
	}
	if ((navigator.userAgent.indexOf("Windows") > -1) && (navigator.userAgent.indexOf("Chrome") > -1)) {
		gblDesktop = true;
		// call onDeviceReady on windows desktop (chrome)
		onDeviceReady();
	}
	if (navigator.userAgent.indexOf("Firefox") > -1) {
		if (navigator.userAgent.indexOf("Windows") > -1) {
			gblDesktop = true;
		}
		gblFirefox = true;
		// call onDeviceReady on windows desktop (chrome)
		onDeviceReady();
	}
	if (typeof blackberry != "undefined") {
		innerActive_aid = "MetaViewSoft_MathGame_BB";
		innerActive_ad_params.portal = 635;
		// call onDeviceReady on windows desktop (chrome)
		onDeviceReady();
	}
	if (window.PalmSystem) {
		// call stageReady on webos
		window.PalmSystem.stageReady();
		onDeviceReady();
	}
}
