var App = angular.module('mathHomework', ['ionic', 'ui.router']);
var MAX_EXERCISES = 10;

App.config(function($stateProvider, $urlRouterProvider) {

    $stateProvider
      .state('home', {
        url: '/',
        templateUrl: 'home.html'
      })
      .state('plus', {
        url: '/page-plus',
        templateUrl: 'plus.html',
        controller: 'PlusCtrl'
      })
      .state('minus', {
        url: '/page-minus',
        templateUrl: 'minus.html',
        controller: 'MinusCtrl'
      })
      .state('multiply', {
        url: '/page-multiply',
        templateUrl: 'multiply.html',
        controller: 'MultiplyCtrl'
      })
      .state('divide', {
        url: '/page-divide',
        templateUrl: 'divide.html',
        controller: 'DivideCtrl'
      })
      .state('results', {
        url: '/results',
        templateUrl: 'results.html',
        controller: 'ResultsCtrl'
      });

  // if none of the above routes are met, use this fallback
  // which executes the 'AppCtrl' controller (controllers.js)
  $urlRouterProvider.otherwise('/');

})

.service('common', function() {

  var page = 1;
  this.result = {};

  this.prev = function(pageId, exercise) {
    if(page == MAX_EXERCISES) { 
        $(pageId + ' .finish-btn').addClass('hidden');
        $(pageId + ' .next-btn').removeClass('hidden'); 
    }
    
    if(page > 1) {
      page--;
    }
    
    $(pageId + ' .result-input').val(exercise[ page - 1 ].result);
    
    $(pageId + ' .exercise-page').text(page);
    setNumbers(exercise[ page - 1 ].numberA, exercise[ page - 1 ].numberB);
  }
  
  this.next = function(pageId, exercise, sign) {
    
    this.saveResult(pageId, exercise, sign);
    $(pageId + ' .result-input').val('');
  
    page++;
    
    //fill in result if there is some
    if(typeof exercise[ page - 1 ].result != 'undefined') {
        $(pageId + ' .result-input').val(exercise[ page - 1 ].result);
    }
    
    setTimeout(function() {
        $(pageId + ' .result-input').focus();
    }, 100);
    
    if(page == MAX_EXERCISES) { 
        $(pageId + ' .finish-btn').removeClass('hidden');
        $(pageId + ' .next-btn').addClass('hidden'); 
    }
    $(pageId + ' .exercise-page').text(page);
    setNumbers(exercise[ page - 1 ].numberA, exercise[ page - 1 ].numberB);
  }
  
  this.saveResult = function(pageId, exercise, sign) {
    var numberA = exercise[ page - 1 ].numberA;
    var numberB = exercise[ page - 1 ].numberB;
    
    var correctResult = eval(numberA + sign + numberB);
    var usersResult = '';
    if($(pageId + ' .result-input').val()) {
      usersResult = parseFloat($(pageId + ' .result-input').val());
    }
    
    if(correctResult === usersResult) {
      exercise[ page - 1 ].isCorrect = true;
    } 

    exercise[ page - 1 ].correctResult = correctResult;
    exercise[ page - 1 ].result = usersResult;
  }
  
  this.resultKeyup = function(event) {
    console.log(event.which);
  }
  
  this.finish = function(pageId, exercise, sign) {
    this.saveResult(pageId, exercise, sign);
    
    var grade = 'F';
    var totalCorrect = 0;
    for(var i = 0; i < exercise.length; i++) {
      if(exercise[i].isCorrect) {
        totalCorrect++;
      }
    }
    
    if(totalCorrect >= MAX_EXERCISES - 1) {
      grade = 'A'; 
    } else if(totalCorrect >= MAX_EXERCISES - 3) {
      grade = 'B'; 
    } else if(totalCorrect >= MAX_EXERCISES - 5) {
      grade = 'C'; 
    } else if(totalCorrect >= MAX_EXERCISES - 7) {
      grade = 'D';
    } else if(totalCorrect >= MAX_EXERCISES - 8) {
      grade = 'E'; 
    }
    
    //reset page
    page = 1;
    this.setResult({ pageId: pageId, exercise: exercise, sign: sign, grade: grade });
  }
  
  this.setResult = function(data) {
    this.result = data;
  }
  
  this.getResult = function() {
    return this.result;
  }
})

.controller('PlusCtrl', function($scope, common) {
  
  $scope.exercise = generatePlus(MAX_EXERCISES);
  $scope.pageId = '#page-plus';
  
  console.log('PlusCtrl', $scope.exercise);
  
  setNumbers($scope.exercise[0].numberA, $scope.exercise[0].numberB);
  
  $scope.prev = function(pageId, exercise) {
    common.prev(pageId, exercise);
  }
  
  $scope.next = function(pageId, exercise) {
    common.next(pageId, exercise, '+');
  } 
  
  $scope.finish = function(pageId, exercise, sign, evt) {
    common.finish(pageId, exercise, sign);
  }
})

.controller('MinusCtrl', function($scope, common) {
  $scope.exercise = generateMinus(MAX_EXERCISES);
  $scope.pageId = '#page-minus';
  
  setNumbers($scope.exercise[0].numberA, $scope.exercise[0].numberB);
  
  $scope.prev = function(pageId, exercise) {
    common.prev(pageId, exercise);
  }
  
  $scope.next = function(pageId, exercise) {
    common.next(pageId, exercise, '-');
  } 
  
  $scope.finish = function(pageId, exercise, sign, evt) {
    common.finish(pageId, exercise, sign);
  }
})

.controller('MultiplyCtrl', function($scope, common) {
  $scope.exercise = generateMultiply(MAX_EXERCISES);
  $scope.pageId = '#page-multiply';
  
  setNumbers($scope.exercise[0].numberA, $scope.exercise[0].numberB);
  
  $scope.prev = function(pageId, exercise) {
    common.prev(pageId, exercise);
  }
  
  $scope.next = function(pageId, exercise) {
    common.next(pageId, exercise, '*');
  } 
  
  $scope.finish = function(pageId, exercise, sign, evt) {
    common.finish(pageId, exercise, sign);
  }
})

.controller('DivideCtrl', function($scope, common) {
  $scope.exercise = generateDivide(MAX_EXERCISES);
  $scope.pageId = '#page-divide';
  
  setNumbers($scope.exercise[0].numberA, $scope.exercise[0].numberB);
  
  $scope.prev = function(pageId, exercise) {
    common.prev(pageId, exercise);
  }
  
  $scope.next = function(pageId, exercise) {
    common.next(pageId, exercise, '/');
  } 
  
  $scope.finish = function(pageId, exercise, sign, evt) {
    common.finish(pageId, exercise, sign);
  }
})

.controller('ResultsCtrl', function($scope, common) {
  var results = common.getResult();
  $scope.exercise = results.exercise;
  $scope.sign = results.sign;
  $scope.pageId = results.pageId;
  $scope.grade = results.grade;
});