enyo.kind({
	name: "MathThis",
	kind: enyo.Control,
	style: "width:100%;height:100%;",
	components: [
		// main panel
		{name: "main", kind: enyo.Control, fit: true, style: "background:black;width:100%;height:100%;", components: [
			// space where users of this kind can insert controls.
			{kind: "Canvas", fit: true, name: "playfield", style: "position:absolute;left:0px;top:0px;", attributes: {width: 300, height: 500}, ontap: "clickHandler"},
			{kind: onyx.Icon, src: "images/cheers1.png", name: "Cheers1", style: "width:30px;height:30px;", class: "goal-hidden notarget"},
			{kind: onyx.Icon, src: "images/cheers1.png", name: "Cheers2", style: "width:30px;height:30px;", class: "goal-hidden notarget"},
			{kind: onyx.Icon, src: "images/cheers2.png", name: "Cheers3", style: "width:30px;height:30px;", class: "goal-hidden notarget"},
			{kind: onyx.Icon, src: "images/cheers2.png", name: "Cheers4", style: "width:20px;height:20px;", class: "goal-hidden notarget"},
			{kind: onyx.Icon, src: "images/cheers2.png", name: "Cheers5", style: "width:20px;height:20px;", class: "goal-hidden notarget"},
			{kind: onyx.Icon, src: "images/cheers2.png", name: "Cheers6", style: "width:20px;height:20px;", class: "goal-hidden notarget"},
			{kind: onyx.Icon, src: "images/cheers3.png", name: "Cheers7", style: "width:40px;height:40px;", class: "goal-hidden notarget"},
			{kind: onyx.Icon, src: "images/cheers3.png", name: "Cheers8", style: "width:40px;height:40px;", class: "goal-hidden notarget"},
			{kind: onyx.Icon, src: "images/cheers3.png", name: "Cheers9", style: "width:40px;height:40px;", class: "goal-hidden notarget"},
			{kind: onyx.Icon, src: "images/cow.png", name: "Cow", style: "width:183px;height:320px;", class: "goal-hidden", ontap: "OnCowClick"},
			{kind: onyx.Icon, src: "images/pig.png", name: "Pig", style: "width:320px;height:176px;", class: "goal-hidden", ontap: "OnPigClick"},
			{kind: onyx.Icon, src: "images/golden.png", name: "Golden", style: "width:100px;height:100px;", class: "goal-hidden notarget"},
			{kind: onyx.Icon, src: "images/silver.png", name: "Silver", style: "width:100px;height:100px;", class: "goal-hidden notarget"},
			{kind: onyx.Icon, src: "images/bronce.png", name: "Bronce", style: "width:100px;height:100px;", class: "goal-hidden notarget"},
			{kind: onyx.Icon, src: "images/band.png", name: "Band", style: "width:100px;height:100px;", class: "goal-hidden notarget"}
		]},
		{kind: "onyx.Popup", name: "NewGamePopup", centered: true, modal: true, scrim: true, scrimWhenModal: false, floating: true,
			onHide: "hidePopup", autoDismiss: false,  style: "width:220px;",components: [
			{kind: "onyx.Groupbox", components: [
			    {kind: "onyx.GroupboxHeader", style: "font-size: 18px;", content: "Select your game:"},
				{kind: "onyx.Button", content: "×", style: "font-weight: bold; background-color:#aaf; width:100%; margin:1px;", ontap: "MulClick"},
				{kind: "onyx.Button", content: "/", style: "font-weight: bold; background-color:#afa; width:100%; margin:1px;", ontap: "DivClick"},
				{kind: "onyx.Button", content: "× /", style: "font-weight: bold; background-color:#aff; width:100%; margin:1px;", ontap: "MulDivClick"},
				{kind: "onyx.Button", content: "²", style: "font-weight: bold; background-color:#ffa; width:100%; margin:1px;", ontap: "SquareClick"},
				{kind: "onyx.Button", content: "× / ²", style: "font-weight: bold; background-color:#faf; width:100%; margin:1px;", ontap: "AllClick"}
			]}
		]},
		{kind: "onyx.Popup", name: "GameOverPopup", centered: true, modal: true, scrim: true, scrimWhenModal: false, floating: true,
			onHide: "hidePopup", autoDismiss: false, style: "width:300px;", components: [
			{kind: "onyx.Groupbox", components: [
			    {kind: "onyx.GroupboxHeader", style: "font-size: 18px;", content: "Your results:"},
				{name: "GameOverContent", allowHtml: true, content: ""},
				{kind: "onyx.Button", name: "SameGameButton", content: "Continue", style: "font-weight: bold; background-color:#afa; width:100%; margin:1px;", ontap: "ContinueClick"},
				{kind: "onyx.Button", name: "OtherGameButton", content: "Other Game", style: "font-weight: bold; background-color:#ffa; width:100%; margin:1px;", ontap: "NewGameClick"},
			]}
		]},
		{kind: "onyx.Popup", name: "AboutBox", centered: true, modal: true, scrim: true, scrimWhenModal: false, floating: true,
			onHide: "hidePopup", autoDismiss: false, style: "width:220px;", components: [
			{kind: "onyx.Groupbox", style: "border-style: none;", components: [
			    {kind: "onyx.GroupboxHeader", style: "font-size: 18px;", content: "Math This 2"},
				{content: "", style: "height: 10px;"},
				{content: "(c) 2012, MetaViewSoft", style: "font-size: 18px;"},
				{content: "", style: "height: 10px;"},
				{kind: "onyx.Button", content: "Email", style: "font-weight: bold; background-color:#aaa; width:100%; margin:1px;", ontap: "onEmailClick"},
				//{kind: "onyx.Button", content: "Homepage", style: "font-weight: bold; background-color:#aaa; width:280px; margin:1px;", onclick: "onHomepageClick"},
				{content: "", style: "height: 10px;"},
				{kind: "onyx.Button", content: "Restart", style: "font-weight: bold; background-color:#faa; width:100%; margin:1px;", ontap: "onRestartClick"},
				{content: "", style: "height: 10px;"},
				{kind: "onyx.Button", content: "Close", style: "font-weight: bold; background-color:#afa; width:100%; margin:1px;", ontap: "onAboutClose"}
			]}
		]},
		{kind: "onyx.Popup", name: "AdvertPopup", centered: true, modal: true, scrim: true, scrimWhenModal: false, floating: true,
			onHide: "hidePopup", autoDismiss: false,  style: "width:320px;",components: [
			{name: "advert", style: "width:320px; height:64px;", allowHtml: true, content: ""},
			{kind: "onyx.Button", content: "Continue", style: "font-weight: bold; background-color:#afa; width:100%; margin:1px;", ontap: "AdvertContinueClick"}
		]},
		{kind: "onyx.Menu", name: "appMenu", components: [
			{caption: "About", onclick: "openAboutBox"}
		]},
		{content: "?", style: "font-weight:bold; font-size:24px; text-align:right; text-shadow:2px 2px #000000; position:absolute; top:5px; right:10px; width:50px; height:50px;", ontap: "openAboutBox"},
		{kind: "onyx.Button", name: "InstallButton", content: "Install", style: "position:absolute; top:5px; left:5px;", ontap: "onInstallClick"},
		{kind: "Signals", ondeviceready: "deviceReady", onbackbutton: "backButton"}
	],
	Results: [{name: "* / ²", count: 0, pairs: 0, wrongs: 0, gold: 0, silver: 0, bronce: 0},
			  {name: "*", count: 0, pairs: 0, wrongs: 0, gold: 0, silver: 0, bronce: 0},
			  {name: "/", count: 0, pairs: 0, wrongs: 0, gold: 0, silver: 0, bronce: 0},
			  {name: "* /", count: 0, pairs: 0, wrongs: 0, gold: 0, silver: 0, bronce: 0},
			  {name: "²", count: 0, pairs: 0, wrongs: 0, gold: 0, silver: 0, bronce: 0}],
	LastGameType: 0,
	NO_TURN: 0,
	MY_TURN: 1,
	YOUR_TURN: 2,
	REMOVED: 0,
	HIDDEN: 1,
	OPEN: 2,
	DEBUG: false,
	gblTileHeight: 48,
	gblSquares: 6,
	gblOldOrient: 0,
	gblYourPairs: 0,
	gblYourWrongs: 0,
	gblYourRights: 0,
	gblMyPairs: 0,
	gblMyWrongs: 0,
	gblWhosTurn: 2,
	gblPointsMax: 0,
	gblDynamicDifficulty: 2, // starts somewhere in the middle
	gblTileset: 0,
	gblCardBack: 0,
	gblBackground: null,
	gblTiles: null,
	gblTileBack: null,
	gblRemoveTimeOut: 4,
	gblComputerTimeOut: 2,
	gblEmptySpace: false,
	gblDeactivate: false,
	gblSinglePlayer: false,
	gblEquation: 0,
	MULTIPLICATION: 1,
	DIVISION: 2,
	SQUARENUMBER: 3,
	create: function() {
		this.inherited(arguments);
		this.gblTiles = new Image();
		this.gblTiles.src = "images/toycars.png";
		this.gblTileBack = new Image();
		this.gblTileBack.src = "images/back.png";
		this.gblBackground = new Image();
		this.gblBackgroundIdx = (Math.floor(Math.random() * 8) + 1);
		this.gblBackground.src = "images/back_" + this.gblBackgroundIdx + ".JPG";
		this.gblBackground.onload = enyo.bind(this, "BackgroundLoaded");
		console.error("gblAndroid: " + gblAndroid);
		if (gblAndroid) {
			this.endSound = new Media("sounds/end.wav");
			this.cowSound = new Media("sounds/cow.wav");
			this.pigSound = new Media("sounds/pig.wav");
			this.plingSound = new Media("sounds/pling.wav");
			this.card01Sound = new Media("sounds/card01.wav");
			this.card02Sound = new Media("sounds/card01.wav");
			this.browser01Sound = new Media("sounds/browser01.wav");
			this.mmSound = new Media("sounds/mm.wav");
		} else {
			this.endSound = new Audio("sounds/end.wav");
			this.cowSound = new Audio("sounds/cow.wav");
			this.pigSound = new Audio("sounds/pig.wav");
			this.plingSound = new Audio("sounds/pling.wav");
			this.card01Sound = new Audio("sounds/card01.wav");
			this.card02Sound = new Audio("sounds/card01.wav");
			this.browser01Sound = new Audio("sounds/browser01.wav");
			this.mmSound = new Audio("sounds/mm.wav");
		}
		this.$.Cheers1.addClass("goal-hidden notarget");
		this.$.Cheers2.addClass("goal-hidden notarget");
		this.$.Cheers3.addClass("goal-hidden notarget");
		this.$.Cheers4.addClass("goal-hidden notarget");
		this.$.Cheers5.addClass("goal-hidden notarget");
		this.$.Cheers6.addClass("goal-hidden notarget");
		this.$.Cheers7.addClass("goal-hidden notarget");
		this.$.Cheers8.addClass("goal-hidden notarget");
		this.$.Cheers9.addClass("goal-hidden notarget");
		this.$.Cow.addClass("goal-hidden");
		this.$.Pig.addClass("goal-hidden");
		this.$.Golden.addClass("goal-hidden notarget");
		this.$.Silver.addClass("goal-hidden notarget");
		this.$.Bronce.addClass("goal-hidden notarget");
		this.$.Band.addClass("goal-hidden notarget");
		//Reassign onSwipeDown event - if menuBar is closed, and swipe down occurs, open the menu.
		if ((typeof window.blackberry !== "undefined") && (typeof blackberry.app !== "undefined")) {
			blackberry.app.event.onSwipeDown(enyo.bind(this, "openAboutBox"));
		}
	},
	//* called after this control is rendered
	rendered: function() {
		this.inherited(arguments);
		this.validateLayout();
		if (gblAndroid || gblFirefox) {
			this.showPopup("AdvertPopup");
			getInnerActiveAd(this.$.advert.hasNode(), "");
		} else {
			this.InitialGameStart();
		}
		if (navigator.mozApps) {
			var that = this;
			var checkIfInstalled = navigator.mozApps.getSelf();
			checkIfInstalled.onsuccess = function () {
				console.error("checkIfInstalled.onsuccess");
				if (checkIfInstalled.result) {
					// Already installed
					that.$.InstallButton.hide();
				}
			}
			checkIfInstalled.onerror = function () {
				console.error("checkIfInstalled.onerror");
			}
		} else {
			this.$.InstallButton.hide();
		}
	},
	AdvertContinueClick: function() {
		this.$.AdvertPopup.hide();
		this.InitialGameStart();
	},
	//* called after this control is resized
	resizeHandler: function() {
		this.validateLayout();
		this.DrawPlayfield();
	},
	//* update layout based on size changes
	validateLayout: function() {
		this.$.playfield.node.height = window.innerHeight;//this.getBounds().height;//-7;
		this.$.playfield.node.width = window.innerWidth;//this.getBounds().width;//-10;

		var dist = Math.min(this.$.playfield.node.width, this.$.playfield.node.height);
		this.gblSquares = ((dist < 400) || (this.gblEquation == 5)) ? 4 : 6;
		this.gblTileHeight = Math.min(dist / this.gblSquares - 6, 96);
	},
	resume: function() {
		this.validateLayout();
		this.DrawPlayfield();
		console.error("resume called");
	},
	openAppMenuHandler: function() {
		this.$.appMenu.open();
	},
	closeAppMenuHandler: function() {
		this.$.appMenu.close();
	},
	openAboutBox: function() {
		this.showPopup("AboutBox");
	},
	onAboutClose: function() {
		this.$.AboutBox.hide();
	},
	onEmailClick: function() {
		window.open("mailto:metaview@web.de?subject=MathThis");
	},
	onHomepageClick: function() {
		window.open("http://www.metaviewsoft.de/wordpress", "_blank");
	},
	onInstallClick: function() {
	    var installApp = navigator.mozApps.install("http://78.46.106.20/MathThis2/manifest.webapp");
	    installApp.onsuccess = function(data) {
	    };
	    installApp.onerror = function() {
	        alert("Install failed\n\n:" + installApp.error.name);
	    };
	},
	backButton: function() {
		console.error("backButton");
		if (this.$.AboutBox.getShowing()) {
			this.$.AboutBox.hide();
		} else if (this.$.GameOverPopup.getShowing()) {
			this.gblYourRights = 0;
			this.$.GameOverPopup.hide();
			this.RestartGame();
		} else if (this.$.AdvertPopup.getShowing()) {
			this.$.AdvertPopup.hide();
			this.InitialGameStart();
		} else if (!this.$.NewGamePopup.getShowing()) {
			console.error("backButton: InitialGameStart");
			this.InitialGameStart();
		} else {
			if (navigator) {
				// for android
				navigator.app.exitApp();
			} else {
				// for windows
				this.close();
			}
		}
	},
	InitGameData: function() {
		// click counter
		this.gblClickCounter = 0;

		// who's turn
		this.gblWhosTurn = this.YOUR_TURN;

		// solved counters
		this.gblYourPairs = 0;
		this.gblYourWrongs = 0;
		this.gblYourRights = 0;
		this.gblMyPairs = 0;
		this.gblMyWrongs = 0;

		var x, y;
		// which tile is already visible
		this.gblVisible = new Array(this.gblSquares);
		for (y = 0; y < this.gblSquares; y++) {
			this.gblVisible[y] = new Array(this.gblSquares);
			for (x = 0; x < this.gblSquares; x++) {
				this.gblVisible[y][x] = this.HIDDEN;
			}
		}

		// which tiles do I remember
		this.gblTilesKnown = new Array(this.gblSquares);
		for (y = 0; y < this.gblSquares; y++) {
			this.gblTilesKnown[y] = new Array(this.gblSquares);
			for (x = 0; x < this.gblSquares; x++) {
				this.gblTilesKnown[y][x] = -1;
			}
		}

		// which tiles are placed where
		this.gblTilesPlacedEqu = new Array(this.gblSquares);
		this.gblTilesPlacedIdx = new Array(this.gblSquares);
		for (y = 0; y < (this.gblSquares/2); y++) {
			this.gblTilesPlacedEqu[y] = new Array(this.gblSquares);
			this.gblTilesPlacedEqu[y+(this.gblSquares/2)] = new Array(this.gblSquares);
			this.gblTilesPlacedIdx[y] = new Array(this.gblSquares);
			this.gblTilesPlacedIdx[y+(this.gblSquares/2)] = new Array(this.gblSquares);
			for (x = 0; x < this.gblSquares; x++) {
				this.gblTilesPlacedIdx[y][x] = this.gblTilesPlacedIdx[y+(this.gblSquares/2)][x] = y * this.gblSquares + x;
				var found = true;
				while (found == true) {
					var val1 = Math.floor(Math.random() * 9) + 1;
					var val2 = Math.floor(Math.random() * 19) + 1;
					var equation = this.gblEquation;
					if (equation == 0) {
						// alle
						equation = Math.floor(Math.random() * 4) + 1;
					} else if (equation == 1) {
						// multiplikation
						equation = this.MULTIPLICATION;
					} else if (equation == 2) {
						// division
						equation = this.DIVISION;
					} else if (equation == 3) {
						// multiplikation + division
						equation = Math.floor(Math.random() * 2) + 1;
					} else if (equation == 4) {
						// quadratzahlen
						equation = this.SQUARENUMBER;
					}
					if (equation == this.MULTIPLICATION) {
						found = this.ValueFound(x, y, val1*val2);
						this.gblTilesPlacedEqu[y][x] = val1 + "×" + val2;
						this.gblTilesPlacedEqu[y+(this.gblSquares/2)][x] = val1 * val2;
					} else if (equation == this.DIVISION) {
						found = this.ValueFound(x, y, val2);
						this.gblTilesPlacedEqu[y][x] = (val1 * val2) + "/" + val1;
						this.gblTilesPlacedEqu[y+(this.gblSquares/2)][x] = val2;
					} else if (equation == this.SQUARENUMBER) {
						val1 = val2;
						found = this.ValueFound(x, y, val1*val2);
						this.gblTilesPlacedEqu[y][x] = val1 + "²";
						this.gblTilesPlacedEqu[y+(this.gblSquares/2)][x] = val1 * val2;
					}
				}
			}
		}

		// scramble them
		for (y = 0; y < this.gblSquares; y++) {
			for (x = 0; x < this.gblSquares; x++) {
				var ty = Math.floor(Math.random() * this.gblSquares);
				var tx = Math.floor(Math.random() * this.gblSquares);
				var tmp = this.gblTilesPlacedEqu[ty][tx];
				this.gblTilesPlacedEqu[ty][tx] = this.gblTilesPlacedEqu[y][x];
				this.gblTilesPlacedEqu[y][x] = tmp;
				var tmp = this.gblTilesPlacedIdx[ty][tx];
				this.gblTilesPlacedIdx[ty][tx] = this.gblTilesPlacedIdx[y][x];
				this.gblTilesPlacedIdx[y][x] = tmp;
			}
		}
		this.DrawPlayfield();

		this.gblBackgroundIdx++;
		if (this.gblBackgroundIdx > 8) {
			this.gblBackgroundIdx = 1;
		}
		this.gblBackground.src = "images/back_" + this.gblBackgroundIdx + ".JPG";
	},
	ValueFound: function(x, y, value) {
		var found = false;
		for (i = 0; i < y+1; i++) {
			for (j = 0; j < ((i == y) ? (x+1) : this.gblSquares); j++) {
				if (eval(this.gblTilesPlacedEqu[i+(this.gblSquares/2)][j]) == value) {
					found = true;
					break;
				}
			}
		}
		return found;
	},
	InitialGameStart: function() {
		console.error("InitialGameStart");
		this.showPopup("NewGamePopup");
		this.gblSinglePlayer = true;
		this.gblWhosTurn = this.YOUR_TURN;
		setTimeout(enyo.bind(this, "DrawPlayfield"), 500);
	},
	BackgroundLoaded: function() {
		this.DrawPlayfield();
	},
	SquareClick: function(inSender) {
		this.LastGameType = 4;
		this.gblEquation = 4;
		this.$.NewGamePopup.hide();
		this.InitGameData();
	},
	MulClick: function(inSender) {
		this.LastGameType = 1;
		this.gblEquation = 1;
		this.$.NewGamePopup.hide();
		this.InitGameData();
	},
	DivClick: function(inSender) {
		this.LastGameType = 2;
		this.gblEquation = 2;
		this.$.NewGamePopup.hide();
		this.InitGameData();
	},
	MulDivClick: function(inSender) {
		this.LastGameType = 3;
		this.gblEquation = 3;
		this.$.NewGamePopup.hide();
		this.InitGameData();
	},
	AllClick: function(inSender) {
		this.LastGameType = 0;
		this.gblEquation = 0;
		this.$.NewGamePopup.hide();
		this.InitGameData();
	},
	ContinueClick: function() {
		this.gblYourRights = 0;
		this.$.GameOverPopup.hide();
		this.RestartGame();
	},
	NewGameClick: function() {
		this.gblYourRights = 0;
		this.$.GameOverPopup.hide();
		this.showPopup("NewGamePopup");
	},
	onRestartClick: function() {
		this.gblYourRights = 0;
		this.$.AboutBox.hide();
		this.showPopup("NewGamePopup");
	},
	DrawPlayfield: function() {
		var canvas = this.$.playfield.node;
		var width = canvas.width;
		var height = canvas.height;
		var bGameEnd = true;

		var nTileTop = Math.floor((50 - this.gblTileHeight) / 2);
		//var nTileTop = Math.floor((50 - ((this.gblTileHeight > 48) ? 48 : this.gblTileHeight)) / 2);
		var nTileYOffset = this.gblTileHeight + 6;

		var ctx = canvas.getContext('2d');
		try{
			if (gblDesktop) {
				ctx.clearRect(0, 0, width, height);
			}
			console.error("bkg: " + this.gblBackground + " " + this.gblBackground.complete);
			if ((this.gblBackground != null) && this.gblBackground.complete) {
				console.error(this.gblBackground.src + " " + this.gblBackground.width + " " + this.gblBackground.height);
				if ((width > this.gblBackground.width) || (height - this.gblBackground.height)) {
					ctx.drawImage(this.gblBackground, (width - this.gblBackground.width) / 2, (height - this.gblBackground.height) / 2);
				} else {
					ctx.drawImage(this.gblBackground, 0, 0);//(width - this.gblBackground.width) / 2, (height - this.gblBackground.height) / 2);
				}
			}
		} catch(ex) {
			console.log(ex.message);
		}

		try{
			var left = Math.floor((width - (this.gblSquares * nTileYOffset)) / 2) + 3;
			var top = Math.floor((height - (this.gblSquares * nTileYOffset)) / 2) + 3;
			for (var y = 0; y < this.gblSquares; y++) {
				for (var x = 0; x < this.gblSquares; x++) {
					var ys = Math.floor(this.gblTilesPlacedIdx[y][x] / this.gblSquares); // 0..2
					var xs = Math.floor(this.gblTilesPlacedIdx[y][x] % this.gblSquares); // 0..5
					if (this.gblVisible[y][x] == this.OPEN) {
						if ((this.gblTiles != null) && this.gblTiles.complete) {
							ctx.drawImage(this.gblTiles, xs * 50 + 1, ys * 50 + 1, 48, 48, left + x * nTileYOffset, top + y * nTileYOffset, this.gblTileHeight, this.gblTileHeight);
						} else {
							ctx.fillStyle = "#446";
							ctx.fillRect(left + x * nTileYOffset, top + y * nTileYOffset, this.gblTileHeight, this.gblTileHeight);
						}
						ctx.font = "bold " + Math.floor(this.gblTileHeight / 2 - 8) + "px sans-serif";
						ctx.textBaseline = "middle";
						ctx.textAlign = "center";
						ctx.fillStyle = "rgba(64, 64, 96, 0.65)";
						ctx.fillText(this.gblTilesPlacedEqu[y][x], left + 2 + x * nTileYOffset + this.gblTileHeight / 2, top + 2 + y * nTileYOffset + this.gblTileHeight / 2);
						ctx.fillStyle = "rgba(192, 192, 255, 0.65)";
						ctx.fillText(this.gblTilesPlacedEqu[y][x], left + x * nTileYOffset + this.gblTileHeight / 2, top + y * nTileYOffset + this.gblTileHeight / 2);
						this.RememberTile(x, y);
					} else if (this.gblVisible[y][x] == this.HIDDEN) {
						if ((this.gblTileBack != null) && this.gblTileBack.complete) {
							ctx.drawImage(this.gblTileBack, left + x * nTileYOffset, top + y * nTileYOffset, this.gblTileHeight, this.gblTileHeight);
						} else {
							ctx.fillStyle = "#88c";
							ctx.fillRect(left + x * nTileYOffset, top + y * nTileYOffset, this.gblTileHeight, this.gblTileHeight);
						}
						ctx.font = "bold " + Math.floor(this.gblTileHeight / 2 - 8) + "px sans-serif";
						ctx.textBaseline = "middle";
						ctx.textAlign = "center";
						ctx.fillStyle = "#446";
						ctx.fillText(this.gblTilesPlacedEqu[y][x], left + 2 + x * nTileYOffset + this.gblTileHeight / 2, top + 2 + y * nTileYOffset + this.gblTileHeight / 2);
						ctx.fillStyle = "#ccf";
						ctx.fillText(this.gblTilesPlacedEqu[y][x], left + x * nTileYOffset + this.gblTileHeight / 2, top + y * nTileYOffset + this.gblTileHeight / 2);
						bGameEnd = false;
					} else if (this.gblVisible[y][x] == this.REMOVED) {
						if (this.gblEmptySpace) {
							if ((this.gblTiles != null) && this.gblTiles.complete) {
								ctx.drawImage(this.gblTiles, xs * 50 + 1, ys * 50 + 1, 48, 48, left + x * nTileYOffset, top + y * nTileYOffset, this.gblTileHeight, this.gblTileHeight);
								ctx.fillStyle = "rgba(0, 0, 0, 0.65)";
								ctx.fillRect(left + x * nTileYOffset, top + y * nTileYOffset, this.gblTileHeight, this.gblTileHeight);
							}
						}
					}
					if (this.DEBUG && (this.gblVisible[y][x] != this.REMOVED) && (this.gblTilesKnown[y][x] > -1)) {
						ctx.fillRect(left + x * nTileYOffset, top + y * nTileYOffset, 10, 10);
					}
				}
			}
		} catch(ex) {
			console.log(ex.message);
		}

		if (this.gblWhosTurn != this.NO_TURN) {
			if (!bGameEnd) {
				if (this.gblSinglePlayer) {
					//this.controller.get("title").innerHTML = $L("Your turn") + ": " + (100.0 * this.gblYourPairs / (this.gblSquares * this.gblSquares / 2)).toFixed(0) + " %";
				} else {
					if (this.gblWhosTurn == this.MY_TURN) {
						//this.controller.get("title").innerHTML = $L("My turn");
						if (this.gblClickCounter < 2) {
							setTimeout(enyo.bind(this, "MyTurnHandler"), 250 + this.gblComputerTimeOut * 250);
						}
					} else {
						//this.controller.get("title").innerHTML = $L("Your turn");
					}
				}
			}
			/*
			if (gblSinglePlayer) {
				if ((2 * gblYourPairs) > gblYourWrongs) {
					this.controller.get("appIcon").removeClassName('img_bad');
					this.controller.get("appIcon").removeClassName('img_icon');
					this.controller.get("appIcon").addClassName('img_good');
				} else {
					this.controller.get("appIcon").removeClassName('img_good');
					this.controller.get("appIcon").removeClassName('img_icon');
					this.controller.get("appIcon").addClassName('img_bad');
				}
			} else {
				if (gblYourPairs > gblMyPairs) {
					this.controller.get("appIcon").removeClassName('img_good');
					this.controller.get("appIcon").removeClassName('img_icon');
					this.controller.get("appIcon").addClassName('img_bad');
				} else if (gblYourPairs < gblMyPairs) {
					this.controller.get("appIcon").removeClassName('img_bad');
					this.controller.get("appIcon").removeClassName('img_icon');
					this.controller.get("appIcon").addClassName('img_good');
				} else {
					this.controller.get("appIcon").removeClassName('img_good');
					this.controller.get("appIcon").removeClassName('img_bad');
					this.controller.get("appIcon").addClassName('img_icon');
				}
			}
			*/
		} else {
			/*
			this.controller.get("title").innerHTML = $L("Match This! - No Game");
			this.controller.get("appIcon").removeClassName('img_good');
			this.controller.get("appIcon").removeClassName('img_bad');
			this.controller.get("appIcon").addClassName('img_icon');
			*/
		}
	},
	RememberTile: function(orgx, orgy) {
		var x, y;
		var tmp = 0;

		for (y = 0; y < this.gblSquares; y++) {
			for (x = 0; x < this.gblSquares; x++) {
				if ((this.gblVisible[y][x] != this.REMOVED) && (this.gblTilesKnown[y][x] > -1)) {
					tmp++;
				}
			}
		}
		var difficulty = this.gblDynamicDifficulty;
		for (y = 0; y < this.gblSquares; y++) {
			for (x = 0; x < this.gblSquares; x++) {
				if ((this.gblVisible[y][x] != this.REMOVED) && (this.gblTilesKnown[y][x] > -1)) {
					if (Math.random() < (tmp / (this.gblSquares * this.gblSquares * (difficulty / 2 + 1)))) {
						// forget this tile
						this.gblTilesKnown[y][x] = -1;
						tmp--;
					}
				}
			}
		}
		this.gblTilesKnown[orgy][orgx] = this.gblTilesPlacedIdx[orgy][orgx];
	},
	FindTheOther: function(orgx, orgy) {
		var x, y;
		var what = this.gblTilesPlacedIdx[orgy][orgx];
		for (y = 0; y < this.gblSquares; y++) {
			for (x = 0; x < this.gblSquares; x++) {
				if ((this.gblTilesKnown[y][x] == what) && ((orgx != x) || (orgy != y))) {
					return {x: x, y: y};
				}
			}
		}
		return null;
	},
	MyTurnHandler: function(event) {
		var takeThis = -1;
		var x, y, tmp;
		var res;

		this.gblClickCounter++;
		console.log("this.gblClickCounter: " + this.gblClickCounter);
		if (this.gblClickCounter == 1) {
			tmp = 0;
			for (y = 0; y < this.gblSquares; y++) {
				for (x = 0; x < this.gblSquares; x++) {
					if ((this.gblVisible[y][x] != this.REMOVED) && (this.gblTilesKnown[y][x] > -1)) {
						res = this.FindTheOther(x, y);
						if (res !== null) {
							this.gblFirstTileX = x;
							this.gblFirstTileY = y;
							tmp = 1;
							break;
						}
					}
				}
			}
			if (tmp === 0) {
				for (y = 0; y < this.gblSquares; y++) {
					for (x = 0; x < this.gblSquares; x++) {
						if (this.gblVisible[y][x] == this.HIDDEN) {
							tmp = Math.random() + ((this.gblTilesKnown[y][x] == -1) ? 0.5 : 0);
							if (tmp > takeThis) {
								this.gblFirstTileX = x;
								this.gblFirstTileY = y;
								takeThis = tmp;
							}
						}
					}
				}
			}
			this.gblVisible[this.gblFirstTileY][this.gblFirstTileX] = this.OPEN;
			this.card01Sound.play();
			/*
			this.controller.serviceRequest('palm://com.palm.audio/systemsounds', {
				method: "playFeedback",
				parameters: {name: "card_01"},
				onSuccess: function(response) {},
				onFailure: function(response) {}
			});
			*/
		} else if (this.gblClickCounter == 2) {
			res = this.FindTheOther(this.gblFirstTileX, this.gblFirstTileY);
			if (res !== null) {
				this.gblSecondTileX = res.x;
				this.gblSecondTileY = res.y;
			} else {
				for (y = 0; y < this.gblSquares; y++) {
					for (x = 0; x < this.gblSquares; x++) {
						if (this.gblVisible[y][x] == this.HIDDEN) {
							tmp = Math.random() + ((this.gblTilesKnown[y][x] == -1) ? 1.0 : 0);
							if (tmp > takeThis) {
								this.gblSecondTileX = x;
								this.gblSecondTileY = y;
								takeThis = tmp;
							}
						}
					}
				}
			}
			this.gblVisible[this.gblSecondTileY][this.gblSecondTileX] = this.OPEN;
			this.card02Sound.play();
			/*
			this.controller.serviceRequest('palm://com.palm.audio/systemsounds', {
				method: "playFeedback",
				parameters: {name: "card_01"},
				onSuccess: function(response) {},
				onFailure: function(response) {}
			});
			*/
			//setTimeout(this.SecondTileHandler.bind(this), 250 + gblRemoveTimeOut * 250);
			setTimeout(enyo.bind(this, "SecondTileHandler"), 250 + this.gblRemoveTimeOut * 250);
		}
		this.DrawPlayfield();
	},
	SecondTileHandler: function(event) {
		if (this.gblTilesPlacedIdx[this.gblFirstTileY][this.gblFirstTileX] == this.gblTilesPlacedIdx[this.gblSecondTileY][this.gblSecondTileX]) {
			this.gblVisible[this.gblFirstTileY][this.gblFirstTileX] = this.gblVisible[this.gblSecondTileY][this.gblSecondTileX] = this.REMOVED;
			if (this.gblWhosTurn == this.YOUR_TURN) {
				this.gblYourPairs++;
				this.gblWhosTurn = this.YOUR_TURN;
				this.gblYourRights++;
				setTimeout(enyo.bind(this, "CelebrateRight", 1), 50);
				if (this.gblYourRights > 1) {
					setTimeout(enyo.bind(this, "CelebrateRight", 2), 100);
				}
				if (this.gblYourRights > 2) {
					setTimeout(enyo.bind(this, "CelebrateRight", 3), 150);
				}
				if (this.gblYourRights > 3) {
					setTimeout(enyo.bind(this, "CelebrateRight", 4), 100);
				}
				if (this.gblYourRights > 4) {
					setTimeout(enyo.bind(this, "CelebrateRight", 5), 150);
				}
				if (this.gblYourRights > 5) {
					setTimeout(enyo.bind(this, "CelebrateRight", 6), 200);
				}
				if (this.gblYourRights > 6) {
					setTimeout(enyo.bind(this, "CelebrateRight", 7), 200);
				}
				if (this.gblYourRights > 7) {
					setTimeout(enyo.bind(this, "CelebrateRight", 8), 300);
				}
				if (this.gblYourRights > 8) {
					setTimeout(enyo.bind(this, "CelebrateRight", 9), 250);
				}
			} else if (this.gblWhosTurn == this.MY_TURN) {
				this.gblMyPairs++;
				this.gblWhosTurn = this.MY_TURN;
			}
			this.browser01Sound.play();
			/*
			this.controller.serviceRequest('palm://com.palm.audio/systemsounds', {
				method: "playFeedback",
				parameters: {name: "browser_01"},
				onSuccess: function(response) {},
				onFailure: function(response) {}
			});
			*/
		} else {
			this.mmSound.play();
			this.gblVisible[this.gblFirstTileY][this.gblFirstTileX] = this.gblVisible[this.gblSecondTileY][this.gblSecondTileX] = this.HIDDEN;
			if (this.gblSinglePlayer) {
				this.gblYourWrongs++;
				this.gblYourRights = 0;
			} else {
				if (this.gblWhosTurn == this.YOUR_TURN) {
					this.gblWhosTurn = this.MY_TURN;
				} else if (this.gblWhosTurn == this.MY_TURN) {
					this.gblWhosTurn = this.YOUR_TURN;
				}
			}
			/*
			this.controller.serviceRequest('palm://com.palm.audio/systemsounds', {
				method: "playFeedback",
				parameters: {name: "shuffle_04"},
				onSuccess: function(response) {},
				onFailure: function(response) {}
			});
			*/
		}
		this.gblClickCounter = 0;
		this.DrawPlayfield();

		var bGameOver = true;
		for (var y = 0; y < this.gblSquares; y++) {
			for (var x = 0; x < this.gblSquares; x++) {
				if (this.gblVisible[y][x] != this.REMOVED) {
					bGameOver = false;
				}
			}
		}

		if (bGameOver) {
			// stop the game
			this.gblWhosTurn = this.NO_TURN;
			console.error("Game over!");

			this.Results[this.LastGameType].count++;
			this.Results[this.LastGameType].pairs += this.gblYourPairs;
			this.Results[this.LastGameType].wrongs += this.gblYourWrongs;
			if (this.gblYourWrongs == 0) {
				this.Results[this.LastGameType].gold++;
				this.ShowGolden();
			} else if (this.gblYourWrongs <= 2) {
				this.Results[this.LastGameType].silver++;
				this.ShowSilver();
			} else if (this.gblYourWrongs <= 4) {
				this.Results[this.LastGameType].bronce++;
				this.ShowBronce();
			}

			// dynamic difficulty
			if ((this.gblYourPairs < this.gblMyPairs) && (this.gblDynamicDifficulty > 0)) {
				this.gblDynamicDifficulty--;
			} else if ((this.gblYourPairs > this.gblMyPairs) && (this.gblDynamicDifficulty < 4)) {
				this.gblDynamicDifficulty++;
			}
			/*
			this.controller.showDialog({
				template: 'gameover/gameover-scene',
				assistant: new GameoverAssistant(this, false)
				//preventCancel: true
			});
			*/
			this.endSound.play();
			this.gblYourRights = 5;
			this.CelebrateEnd();
			if (Math.random() < 0.5) {
				this.ShowCow();
			} else {
				this.ShowPig();
			}
		}
	},
	RestartGame: function() {
		// init a new game
		this.InitGameData();
		this.DrawPlayfield();
	},
	CelebrateEnd: function() {
		if (this.gblYourRights > 0) {
			setTimeout(enyo.bind(this, "CelebrateRight", 1), 50);
			setTimeout(enyo.bind(this, "CelebrateRight", 3), 50);
			setTimeout(enyo.bind(this, "CelebrateRight", 2), 100);
			setTimeout(enyo.bind(this, "CelebrateRight", 5), 100);
			setTimeout(enyo.bind(this, "CelebrateRight", 6), 200);
			setTimeout(enyo.bind(this, "CelebrateRight", 4), 200);
			setTimeout(enyo.bind(this, "CelebrateRight", 8), 300);
			setTimeout(enyo.bind(this, "CelebrateRight", 7), 300);
			setTimeout(enyo.bind(this, "CelebrateRight", 9), 300);
			setTimeout(enyo.bind(this, "CelebrateEnd"), 1000);
			this.gblYourRights--;
		}
	},
	CelebrateRight: function(gblYourRights) {
		if (gblYourRights == 1) {
			this.SetVisible(this.$.Cheers1, true);
			setTimeout(enyo.bind(this, "RemoveStars1"), 500);
		} else if (gblYourRights == 2) {
			this.SetVisible(this.$.Cheers2, true);
			setTimeout(enyo.bind(this, "RemoveStars2"), 500);
		} else if (gblYourRights == 3) {
			this.SetVisible(this.$.Cheers3, true);
			setTimeout(enyo.bind(this, "RemoveStars3"), 500);
		} else if (gblYourRights == 4) {
			this.SetVisible(this.$.Cheers4, true);
			setTimeout(enyo.bind(this, "RemoveStars4"), 500);
		} else if (gblYourRights == 5) {
			this.SetVisible(this.$.Cheers5, true);
			setTimeout(enyo.bind(this, "RemoveStars5"), 500);
		} else if (gblYourRights == 6) {
			this.SetVisible(this.$.Cheers6, true);
			setTimeout(enyo.bind(this, "RemoveStars6"), 500);
		} else if (gblYourRights == 7) {
			this.SetVisible(this.$.Cheers7, true);
			setTimeout(enyo.bind(this, "RemoveStars7"), 500);
		} else if (gblYourRights == 8) {
			this.SetVisible(this.$.Cheers8, true);
			setTimeout(enyo.bind(this, "RemoveStars8"), 500);
		} else if (gblYourRights == 9) {
			this.SetVisible(this.$.Cheers9, true);
			setTimeout(enyo.bind(this, "RemoveStars9"), 500);
		}
	},
	ShowCow: function(interactive) {
		var node = this.$.Cow;
		var canvas = this.$.playfield.node;
		var nTileYOffset = this.gblTileHeight + 6;
		var left = Math.floor((canvas.width - (this.gblSquares * nTileYOffset)) / 2) + 3;
		var top = Math.floor((canvas.height - (this.gblSquares * nTileYOffset)) / 2) + 3;
		var width = this.gblSquares * nTileYOffset - 183;
		var height = this.gblSquares * nTileYOffset - 320;
		node.applyStyle('left', Math.floor(0.5 * width + left) + 'px');
		node.applyStyle('top', Math.floor(0.5 * height + top) + 'px');
		node.removeClass('goal-hidden');
		node.addClass('goal-display');
		this.cowSound.play();
	},
	ShowPig: function(interactive) {
		var node = this.$.Pig;
		var canvas = this.$.playfield.node;
		var nTileYOffset = this.gblTileHeight + 6;
		var left = Math.floor((canvas.width - (this.gblSquares * nTileYOffset)) / 2) + 3;
		var top = Math.floor((canvas.height - (this.gblSquares * nTileYOffset)) / 2) + 3;
		var width = this.gblSquares * nTileYOffset - 320;
		var height = this.gblSquares * nTileYOffset - 176;
		node.applyStyle('left', Math.floor(0.5 * width + left) + 'px');
		node.applyStyle('top', Math.floor(0.5 * height + top) + 'px');
		node.removeClass('goal-hidden');
		node.addClass('goal-display');
		this.pigSound.play();
	},
	OnCowClick: function() {
		//this.cowSound.play();
		this.SetVisible(this.$.Cow, false);
		//this.RestartGame();
		this.OnStatistic();
	},
	OnPigClick: function() {
		//this.pigSound.play();
		this.SetVisible(this.$.Pig, false);
		//this.RestartGame();
		this.OnStatistic();
	},
	ShowGolden: function() {
		var node = this.$.Golden;
		node.applyStyle('left', '5px');
		node.applyStyle('top', '65px');
		node.removeClass('goal-hidden');
		node.addClass('goal-display');
		setTimeout(enyo.bind(this, "SetVisible", node, false), 2000);
		var node = this.$.Band;
		node.applyStyle('left', '5px');
		node.applyStyle('top', '5px');
		node.removeClass('goal-hidden');
		node.addClass('goal-display');
		setTimeout(enyo.bind(this, "SetVisible", node, false), 2000);
	},
	ShowSilver: function() {
		var node = this.$.Silver;
		node.applyStyle('left', '5px');
		node.applyStyle('top', '65px');
		node.removeClass('goal-hidden');
		node.addClass('goal-display');
		setTimeout(enyo.bind(this, "SetVisible", node, false), 2000);
		var node = this.$.Band;
		node.applyStyle('left', '5px');
		node.applyStyle('top', '5px');
		node.removeClass('goal-hidden');
		node.addClass('goal-display');
		setTimeout(enyo.bind(this, "SetVisible", node, false), 2000);
	},
	ShowBronce: function() {
		var node = this.$.Bronce;
		node.applyStyle('left', '5px');
		node.applyStyle('top', '65px');
		node.removeClass('goal-hidden');
		node.addClass('goal-display');
		setTimeout(enyo.bind(this, "SetVisible", node, false), 2000);
		var node = this.$.Band;
		node.applyStyle('left', '5px');
		node.applyStyle('top', '5px');
		node.removeClass('goal-hidden');
		node.addClass('goal-display');
		setTimeout(enyo.bind(this, "SetVisible", node, false), 2000);
	},
	OnStatistic: function() {
		var content = "<table width='280px'>";
		content += "<tr><td align='center'>Last</td>" +
			"<td width:'33%' align='center'>" + this.Results[this.LastGameType].name + "</td>" +
			"<td width:'33%' align='right'>" + Math.round(this.gblYourPairs / (this.gblYourPairs + this.gblYourWrongs) * 100) + " %</td>" +
			"<td></td></tr>";
		for (var i=0; i<this.Results.length; i++) {
			content += "<tr><td align='center'>" + this.Results[i].name + "</td>" +
				"<td align='right'>" + this.Results[i].count + "</td>" +
				"<td align='right'>" + ((this.Results[i].pairs > 0) ? Math.round(this.Results[i].pairs / (this.Results[i].pairs + this.Results[i].wrongs) * 100) : "") + " %</td>" +
				"<td>" + ((this.Results[i].gold > 0) ? "<img src='images/golden.png' width=20px height=20px>" : "&nbsp;") + "" + ((this.Results[i].silver > 0) ? "<img src='images/silver.png' width=20px height=20px>" : "&nbsp;") + "" + ((this.Results[i].bronce > 0) ? "<img src='images/bronce.png' width=20px height=20px>" : "&nbsp;") + "</td></tr>";
		}
		content += "</table>";
		this.$.GameOverContent.setContent(content);
		this.$.SameGameButton.setContent(this.Results[this.LastGameType].name);
		this.showPopup("GameOverPopup");

	},
	SetVisible: function(node, visible) {
		if (visible) {
			var canvas = this.$.playfield.node;
			var nTileYOffset = this.gblTileHeight + 6;
			var left = Math.floor((canvas.width - (this.gblSquares * nTileYOffset)) / 2) + 3;
			var top = Math.floor((canvas.height - (this.gblSquares * nTileYOffset)) / 2) + 3;
			var width = this.gblSquares * nTileYOffset - 50;
			var height = this.gblSquares * nTileYOffset - 50;
			node.applyStyle('left', Math.floor(Math.random() * width + left) + 'px');
			node.applyStyle('top', Math.floor(Math.random() * height + top) + 'px');
			node.removeClass('goal-hidden');
			node.addClass('goal-display');
		} else {
			node.removeClass('goal-display');
			node.addClass('goal-hidden');
		}
	},
	RemoveStars1: function() {
		this.SetVisible(this.$.Cheers1, false);
	},
	RemoveStars2: function() {
		this.SetVisible(this.$.Cheers2, false);
	},
	RemoveStars3: function() {
		this.SetVisible(this.$.Cheers3, false);
	},
	RemoveStars4: function() {
		this.SetVisible(this.$.Cheers4, false);
	},
	RemoveStars5: function() {
		this.SetVisible(this.$.Cheers5, false);
	},
	RemoveStars6: function() {
		this.SetVisible(this.$.Cheers6, false);
	},
	RemoveStars7: function() {
		this.SetVisible(this.$.Cheers7, false);
	},
	RemoveStars8: function() {
		this.SetVisible(this.$.Cheers8, false);
	},
	RemoveStars9: function() {
		this.SetVisible(this.$.Cheers9, false);
	},
	clickHandler: function(inSender, inEvent) {
		if ((this.gblWhosTurn == this.YOUR_TURN) && (this.gblClickCounter < 2)) {
			var canvas = this.$.playfield.node;
			var x = inEvent.clientX;
			var y = inEvent.clientY;

			var nTileTop = Math.floor((50 - this.gblTileHeight) / 2);
			var nTileYOffset = this.gblTileHeight + 6;

			x -= canvas.offsetLeft;
			y -= canvas.offsetTop;

			//Event.stop(event);

			var ctx = canvas.getContext('2d');

			var width = canvas.width;
			var height = canvas.height;
			var left = Math.floor((width - (this.gblSquares * nTileYOffset)) / 2) + 8;
			var top = Math.floor((height - (this.gblSquares * nTileYOffset)) / 2) + 6;

			var tx = Math.floor((x - left) / nTileYOffset);
			var ty = Math.floor((y - top) / nTileYOffset);

			if (this.gblVisible[ty][tx] == this.HIDDEN) {
				this.gblVisible[ty][tx] = this.OPEN;
				this.gblClickCounter++;
				if (this.gblClickCounter == 1) {
					this.gblFirstTileX = tx;
					this.gblFirstTileY = ty;
					this.card01Sound.play();
					/*
					this.controller.serviceRequest('palm://com.palm.audio/systemsounds', {
						method: "playFeedback",
						parameters: {name: "card_01"},
						onSuccess: function(response) {},
						onFailure: function(response) {}
					});
					*/
				} else if (this.gblClickCounter == 2) {
					this.gblSecondTileX = tx;
					this.gblSecondTileY = ty;
					this.card02Sound.play();
					/*
					this.controller.serviceRequest('palm://com.palm.audio/systemsounds', {
						method: "playFeedback",
						parameters: {name: "card_01"},
						onSuccess: function(response) {},
						onFailure: function(response) {}
					});
					*/
					setTimeout(enyo.bind(this, "SecondTileHandler"), 250 + this.gblRemoveTimeOut * 250);
				}
			} else if ((this.gblVisible[ty][tx] == this.OPEN) && (this.gblClickCounter == 1)) {
				this.gblClickCounter = 0;
				this.gblVisible[ty][tx] = this.HIDDEN;
			}
			this.DrawPlayfield();
		}
	},
	showPopup: function(popup) {
		var p = this.$[popup];
		if (p) {
			p.show();
		}
		p.applyStyle("opacity", 1);
		p.updatePosition();

		var transitionEvent = this.whichTransitionEvent();

		if (transitionEvent !== undefined) {
			var listener = function( event ) {
				p.node.removeEventListener( transitionEvent, listener );
			}
			p.node.addEventListener( transitionEvent, listener );
		}

	},
	hidePopup: function(inSender) {
		inSender.applyStyle("display", "none");
		inSender.applyStyle("opacity", 0);
	},
	whichTransitionEvent: function(){
		var t;
		var el = document.createElement('el');
		var transitions = {
		  'transition':'transitionEnd',
		  'OTransition':'oTransitionEnd',
		  'MSTransition':'msTransitionEnd',
		  'MozTransition':'transitionend',
		  'WebkitTransition':'webkitTransitionEnd'
		}

		for(t in transitions){
			if( el.style[t] !== undefined ){
				return transitions[t];
			}
		}
		return transitions[0];
	}
});
