var friendCache = {}, scoreSharing = false;

function login(callback) {
	FB.login(callback, {scope: 'user_friends'});
}

function loginCallback(response) {
	//console.log('loginCallback',response);
	if (response.status === 'connected') {
		
		getMe(function(){
			//create user in db if not exist
			$.ajax(phproot+"createuser.php", {
				data:{userfbid:friendCache.me.id},
				type:"POST",
				success:function(result){
					console.log("success: " + result);
				},
				error:function(xhr){
					console.log("error: " + xhr.status + " " + xhr.statusText);
				},
			});
		});
		
	}
	else {
		if(top.location.href.toString().split('/')[2].substr(-12) === 'facebook.com') {
			top.location.href = 'https://www.facebook.com/appcenter/foolishmath';
		}
		else {
			$(".loginbtn").show();
			$(".logoutbtn").hide();
			$(".invitebtn").hide();
		}
	}
}

function logout() {
	FB.logout(function(response){
		if (response.status !== 'connected') {
			if (top.location.href.toString().split('/')[2].substr(-12) === 'facebook.com') {
				top.location.href = 'https://www.facebook.com/appcenter/foolishmath';
			}
			else {
				top.location.href = 'http://54.213.196.141/foolishmath/';
			}
		}
	});
}

function onStatusChange(response) {
	//console.log('onStatusChange', response);
	
	if (response.status === 'connected') {
		getMe(function(){
			//renderWelcome();
			$(".loginbtn").hide();
			$(".logoutbtn").show();
			$(".invitebtn").show();
			if (scoreSharing) {
				onScoreShare();
			} else {
				showPage("#frontpage");
			}
			
			getPermissions(function(){
				if (hasPermission('user_friends')) {
					getFriends(function(){
						// onLeaderboard();
						//showFriendsList();
					});
				}
			});
		});
	}
	else {
		login(loginCallback);
	}
}

function onAuthResponseChange(response) {
  //console.log('onAuthResponseChange', response);
}

function getMe(callback) {
  if (!friendCache.me) {
    console.log("11...");
	FB.api('/me', {fields: 'id,name,first_name,picture.width(120).height(120)'}, function(response){
	if( !response.error ) {
	  friendCache.me = response;
	  callback();
	} else {
	  console.error('/me', response);
	}
	});
  }
  else {
	callback();
  }
}

function getFriends(callback) {
  FB.api('/me/friends', {fields: 'id,name,first_name,picture.width(120).height(120)'}, function(response){
    if( !response.error ) {
      friendCache.friends = response;
      callback();
    } else {
      console.error('/me/friends', response);
    }
  });
}

function getPermissions(callback) {
  FB.api('/me/permissions', function(response){
    if( !response.error ) {
      friendCache.permissions = response;
      callback();
    } else {
      console.error('/me/permissions', response);
    }
  });
}

function hasPermission(permission) {
  for( var i in friendCache.permissions.data ) {
    if( 
      friendCache.permissions.data[i].permission == permission 
      && friendCache.permissions.data[i].status == 'granted' ) 
      return true;
  }
  return false;
}

function sendInvitation(to, message, callback) {
  var options = {
    method: 'apprequests'
  };
  if(to) options.to = to;
  if(message) options.message = message;
  FB.ui(options, function(response) {
    if(callback) callback(response);
  });
}

function shareScore(caption, callback) {
  FB.ui({
  	method: 'feed',
    caption: caption,
    link: 'https://apps.facebook.com/foolishmath/',
    picture: 'http://54.213.196.141/foolishmath/images/logolarge.png',
    name: 'Checkout my Foolish Math greatness!'
  }, callback);
}
