function showPage(pageId) {
	$("#gamepage, #frontpage, #modepage, #settingspage, #helppage, #storespage, #levelspage, #colorspage").hide();
	$(pageId).show();
}

function attachListeners() {
	$(".buttonsound").hammer().on('touch', function(event) {
		event.gesture.preventDefault();
		if(!tapstatus){
			tapstatus=true;
			buttonclicksound.play();
		}
	});
	
	$(".header-div").hammer().on('tap', '.header-power', function(event) {
		event.gesture.preventDefault();
		tapstatus=false;
		$("#gameover").hide();
		$("#gameover2").hide();
		$("#levelinfo").hide();
		confirmQuit();
	});
	
	$(".header-div").hammer().on('tap', '.header-sound', function(event) {
		event.gesture.preventDefault();
		tapstatus=false;
		var type = $(this).attr('data-id');
		
		if(type=="0"){
			store.set("sound", "off");
			$('.header-sound').html('');
			if (store.get("theme") == "images") {
				$('.header-sound').html('<img src="images/soundoff.png" width="50" />');
			} else {
				$('.header-sound').html('<img src="images/soundoff1.png" width="50" />');
			}
			$('.header-sound').attr('data-id', "1");
		}else{
			store.set("sound", "on");
			$('.header-sound').html('');
			if (store.get("theme") == "images") {
				$('.header-sound').html('<img src="images/soundon.png" width="50" />');
			} else {
				$('.header-sound').html('<img src="images/soundon1.png" width="50" />');
			}
			$('.header-sound').attr('data-id', "0");
		}
	});
	
	$("#frontpage").hammer().on('tap', '.fpbut', function(event) {
		tapstatus=false;
		event.gesture.preventDefault();
		var type = $(this).attr('data-id');
		
		if(type=="play"){
			showPage("#modepage");
		}
		if(type=="colors"){
			showPage("#colorspage");
		}
		else if(type=="settings"){
			showPage("#settingspage");
		}
		else if(type=="help"){
			showPage("#helppage");
		}
		else if(type=="appstores"){
			showPage("#storespage");
		}
		else if(type=="themes"){
			if (store.get("theme") == "images") {
				store.set("theme", "colors");
				$("html").removeClass("imagehtml").addClass("colorhtml");
				$("body").removeClass("imagefont").addClass("colorfont");
				$(".heading").removeClass("imageheading").addClass("colorheading");
				$(".imagelayout").hide();
				$(".colorlayout").show();
				
				$('body').css('color',store.get("color"));
				$('body').css('background',store.get("color"));
				$('.scorebtn').css('background',store.get("color"));	
				$('.score').css('color',store.get("color"));
				$('.box').css('color',store.get("color"));
				$('.message').css('color',store.get("color"));
			} else {
				store.set("theme", "images");
				$("html").removeClass("colorhtml").addClass("imagehtml");
				$("body").removeClass("colorfont").addClass("imagefont");
				$(".heading").removeClass("colorheading").addClass("imageheading");
				$(".colorlayout").hide();
				$(".imagelayout").show();
				
				$('body').css('color','none');
				$('body').css('background','none');
				$('.scorebtn').css('background','none');	
				$('.score').css('color','none');
				$('.box').css('color','none');
				$('.message').css('color','none');
			}
		}
	/*	else if(type=="facebook"){
			FB.getLoginStatus(function(response) {
				if (response.status !== 'connected') {
					login(loginCallback);
				}
			});
		}
		else if(type=="fbinvite"){
			FB.getLoginStatus(function(response) {
				if (response.status === 'connected') {
					onInvite();
				}
			});
		}*/
	});
	
	$("#colorspage").hammer().on('tap', '.colorsbut', function(event) {
		tapstatus=false;
		event.gesture.preventDefault();
		var type = $(this).attr('data-id');
		
		if(type=="exit"){
			showPage("#frontpage");
		}
		
	});
	
	$("#colorspage").hammer().on('tap', '.cpbut', function(event) {
		tapstatus=false;
		event.gesture.preventDefault();
		var ctype = $(this).attr('data-value');
		store.set("color", ctype);
		
		$('body').css('color',ctype);
		$('body').css('background',ctype);
		$('.message').css('color',ctype);
		$('.score').css('color',ctype);
		$('.box').css('color',ctype);
		$('.scorebtn').css('background',ctype);
	});
	
	$("#modepage").hammer().on('tap', '.mpbut', function(event) {
		event.gesture.preventDefault();
		tapstatus=false;
		var type = $(this).attr('data-id');
		
		firstoper = "";
		randomoper = false;
		
		if(type=="addition"){
			gamemode = "addition";
			firstoper = calcopers[0];
			lastlevel = 8;
			if (store.get("theme") == "images") {
				$(".imagelayout.threenum").show();
				$(".colorlayout.threenum").hide();
			} else {
				$(".imagelayout.threenum").hide();
				$(".colorlayout.threenum").show();
			}
		}
		else if(type=="subtraction"){
			gamemode = "subtraction";
			firstoper = calcopers[1];
			lastlevel = 8;
			if (store.get("theme") == "images") {
				$(".imagelayout.threenum").show();
				$(".colorlayout.threenum").hide();
			} else {
				$(".imagelayout.threenum").hide();
				$(".colorlayout.threenum").show();
			}
		}
		else if(type=="multiplication"){
			gamemode = "multiplication";
			firstoper = calcopers[2];
			lastlevel = 8;
			if (store.get("theme") == "images") {
				$(".imagelayout.threenum").show();
				$(".colorlayout.threenum").hide();
			} else {
				$(".imagelayout.threenum").hide();
				$(".colorlayout.threenum").show();
			}
		}
		else if(type=="division"){
			gamemode = "division";
			firstoper = calcopers[3];
			lastlevel = 5;
			$(".threenum").hide();
		}
		else if(type=="random"){
			randomoper = true;
			gamemode = "random";
			lastlevel = 5;
			$(".threenum").hide();
		}
		
		if (firstoper || randomoper){
			levelupdate();
			showPage("#levelspage");
		}
		else if(type=="exit"){
			showPage("#frontpage");
			//$(".threenum").show();
		}
		
	});
	
	$("#settingspage").hammer().on('tap', '.stgbut', function(event) {
		event.gesture.preventDefault();
		tapstatus=false;
		var type = $(this).attr('data-id');
		
	/*	if(type=="facebook"){
			FB.getLoginStatus(function(response) {
				if (response.status !== 'connected') {
					login(loginCallback);
				}
			});
		}
		else if(type=="fblogout"){
			FB.getLoginStatus(function(response) {
				if (response.status === 'connected') {
					logout();
				}
			});
		}
		else */if(type=="exit"){
			showPage("#frontpage");
		}
	});
	
	$("#helppage").hammer().on('tap', '.hlpbut', function(event) {
		event.gesture.preventDefault();
		tapstatus=false;
		var type = $(this).attr('data-id');
		
		if(type=="exit"){
			showPage("#frontpage");
		}
	});
	
	$("#storespage").hammer().on('tap', '.strbut', function(event) {
		event.gesture.preventDefault();
		tapstatus=false;
		var type = $(this).attr('data-id');
		
		if(type=="exit"){
			showPage("#frontpage");
		}
	});
	
	$("#levelspage").hammer().on('tap', '.lpbut', function(event) {
		event.gesture.preventDefault();
		tapstatus=false;
		var type = $(this).attr('data-id');
		
		var l1stat= store.get(gamemode + "-lock1");
		var l2stat= store.get(gamemode + "-lock2");
		var l3stat= store.get(gamemode + "-lock3");
		var l4stat= store.get(gamemode + "-lock4");
		var l5stat= store.get(gamemode + "-lock5");
		var l6stat= store.get(gamemode + "-lock6");
		var l7stat= store.get(gamemode + "-lock7");
		var l8stat= store.get(gamemode + "-lock8");
		
		if(type=="level1" && l1stat=="unlocked"){
			level = 1;
		}else if(type=="level2" && l2stat=="unlocked"){
			level = 2;
		}else if(type=="level3" && l3stat=="unlocked"){
			level = 3;
		}else if(type=="level4" && l4stat=="unlocked"){
			level = 4;
		}else if(type=="level5" && l5stat=="unlocked"){
			level = 5;
		}else if(type=="level6" && l6stat=="unlocked"){
			level = 6;
		}else if(type=="level7" && l7stat=="unlocked"){
			level = 7;
		}else if(type=="level8" && l8stat=="unlocked"){
			level = 8;
		}else{
			level = 0;
		}
		
		if (level){
			
		//	showLevelInfo(level);
			startGame();

		}
		else if(type=="exit"){
			showPage("#modepage");
		}
		
	});
	
	$(".cancelbtn").hammer().on('tap hold', '.cancb', function(event) {
		event.gesture.preventDefault();
		tapstatus=false;
		showPage("#levelspage");
		
		$("#lean_overlay").remove();
		$("#gameover").hide();
		$("#gameover2").hide();
		$("#quitgame").hide();
		$("#levelinfo").hide();
		timelimit = maxtimelimit;
		answercount = 0;
		levelscore = 0;
		$(".scoreval").html("0");
		levelupdate();
	});
	
	
	$(".playbtn").hammer().on('tap hold', '.playb', function(event) {
		event.gesture.preventDefault();
		tapstatus=false;
		$("#gameover").hide();
		$("#gameover2").hide();
		$("#quitgame").hide();
		$("#levelinfo").hide();
		$("#lean_overlay").remove();
		
	//	showLevelInfo(level);
		startGame();
	});
	
/*	$(".fbbtn").hammer().on('tap hold', '.fbb', function(event) {
		event.gesture.preventDefault();
		tapstatus=false;
		
		FB.getLoginStatus(function(response) {
			if (response.status === 'connected') {
				onScoreShare();
			} else {
				scoreSharing = true;
				login(loginCallback);
			}
		});
	});	*/
	
	$(".nextbtn").hammer().on('tap hold', '.nextb', function(event) {
		event.gesture.preventDefault();
		tapstatus=false;
		level = level+1;
		$("#gameover").hide();
		$("#gameover2").hide();
		$("#quitgame").hide();
		$("#levelinfo").hide();
		$("#lean_overlay").remove();
		
		showPage("#gamepage");
		clearInterval(mtrtimer);
		
	//	showLevelInfo(level);
		startGame();
	});
	
	$(".yesbtn").hammer().on('tap hold', '.yesb', function(event) {
		event.gesture.preventDefault();
		tapstatus=false;
		showPage("#levelspage");
		
		$("#lean_overlay").remove();
		$("#gameover").hide();
		$("#gameover2").hide();
		$("#quitgame").hide();
		$("#levelinfo").hide();
		timelimit = maxtimelimit;
		answercount = 0;
		levelscore = 0;
		$(".scoreval").html("0");
		levelupdate();
	});
	
	$(".nobtn").hammer().on('tap hold', '.nob', function(event) {
		event.gesture.preventDefault();
		tapstatus=false;
		
		$("#lean_overlay").remove();
		$("#gameover").hide();
		$("#gameover2").hide();
		$("#quitgame").hide();
		$("#levelinfo").hide();
		
		$(".box, .meter, .score-div").show();
		
		mtrtimer = setInterval(countdown, timelimit/80);
	});
	
	$(".playlevelbtn").hammer().on('tap hold', '.playlvlb', function(event) {
		event.gesture.preventDefault();
		tapstatus=false;
		
		$("#gameover").hide();
		$("#gameover2").hide();
		$("#quitgame").hide();
		$("#levelinfo").hide();
		$("#lean_overlay").remove();
		
		startGame();
	});
	
	$("#game").hammer().on('dragup dragdown', '.box', function(event) {
		
		event.gesture.preventDefault();
		tapstatus = false;
		draggingstarted = true;
		
		stopmillis = Date.now();
		
		timeelapsed = stopmillis - startmillis-400;
	
		var position = +$(this).attr('data-id');
		
		if (position !== undefined) {
			//	that.testMove(position, event.type);
			var i = $("#game").find('.box[data-id='+position+']');
			var position2 = position+1;
			
			if (event.type == "dragup") {
				//console.log("drag up");
				position2 = position-1;
			}
			var j = $("#game").find('.box[data-id='+position2+']');
			
			var aTop = i.height();
			var bTop = j.height();
			if(position<position2) {
				aTop=-aTop-5;
				bTop = bTop+5;
			}
			else{
				bTop=-bTop-5;
				aTop=aTop+5;
			}
			i.attr('data-id', position2).animate({
				marginTop: bTop
			}, 250);

			j.attr('data-id', position).animate({
				marginTop: aTop
			}, 250, function() {
			
				var k = parseInt($("#game").find('.box[data-id='+1+']').html());
				
				if (currentoper == "=") {
					if (z == k){
						correct();
					}else{
						wrong();
					}
				} else if (currentoper == "<") {
					if (z < k){
						correct();
					}else{
						wrong();
					}
				} else if (currentoper == ">") {
					if (z > k){
						correct();
					}else{
						wrong();
					}
				}
			});
		
			event.gesture.stopDetect();
			return;
		}
	});
}

function correct(){

	var soundstatus= store.get('sound');
	if(soundstatus == "on"){
		numberclicksound.play();
	}
	showAnimate();
}

function wrong(){
	
	var soundstatus= store.get('sound');
	gamewon = false;
	if(soundstatus == "on"){
		wrongclicksound.play();
	}
	gameOver();
}

function levelupdate(){
	var l1score= store.get(gamemode + "-1");
	var l2score= store.get(gamemode + "-2");
	var l3score= store.get(gamemode + "-3");
	var l4score= store.get(gamemode + "-4");
	var l5score= store.get(gamemode + "-5");
	var l6score= store.get(gamemode + "-6");
	var l7score= store.get(gamemode + "-7");
	var l8score= store.get(gamemode + "-8");
	
	$(".level1score").html(l1score);
	$(".level2score").html(l2score);
	$(".level3score").html(l3score);
	$(".level4score").html(l4score);
	$(".level5score").html(l5score);
	$(".level6score").html(l6score);
	$(".level7score").html(l7score);
	$(".level8score").html(l8score);
	
	var l1stat= store.get(gamemode + "-lock1");
	var l2stat= store.get(gamemode + "-lock2");
	var l3stat= store.get(gamemode + "-lock3");
	var l4stat= store.get(gamemode + "-lock4");
	var l5stat= store.get(gamemode + "-lock5");
	var l6stat= store.get(gamemode + "-lock6");
	var l7stat= store.get(gamemode + "-lock7");
	var l8stat= store.get(gamemode + "-lock8");
	
	if(l1stat == "lock"){
		$('.level1').css('height','74px');
		$('.level8').css('width','233px');
		$('.level1').css('background','url("images/locklevel.png")');
		$('.color-level1').css('background','#a9a9a9');
		$('.levscore1').hide();
	}else{
		$('.level1').css('height','106px');
		$('.level8').css('width','236px');
		$('.level1').css('background','url("images/level.png")');
		$('.color-level1').css('background','#ffffff');
		$('.levscore1').show();
	}
	if(l2stat == "lock"){
		$('.level2').css('height','74px');
		$('.level8').css('width','233px');
		$('.level2').css('background','url("images/locklevel.png")');
		$('.color-level2').css('background','#a9a9a9');
		$('.levscore2').hide();
	}else{
		$('.level2').css('height','106px');
		$('.level8').css('width','236px');
		$('.level2').css('background','url("images/level.png")');
		$('.color-level2').css('background','#ffffff');
		$('.levscore2').show();
	}
	if(l3stat == "lock"){
		$('.level3').css('height','74px');
		$('.level8').css('width','233px');
		$('.level3').css('background','url("images/locklevel.png")');
		$('.color-level3').css('background','#a9a9a9');
		$('.levscore3').hide();
	}else{
		$('.level3').css('height','106px');
		$('.level8').css('width','236px');
		$('.level3').css('background','url("images/level.png")');
		$('.color-level3').css('background','#ffffff');
		$('.levscore3').show();
	}
	if(l4stat == "lock"){
		$('.level4').css('height','74px');
		$('.level8').css('width','233px');
		$('.level4').css('background','url("images/locklevel.png")');
		$('.color-level4').css('background','#a9a9a9');
		$('.levscore4').hide();
	}else{
		$('.level4').css('height','106px');
		$('.level8').css('width','236px');
		$('.level4').css('background','url("images/level.png")');
		$('.color-level4').css('background','#ffffff');
		$('.levscore4').show();
	}
	if(l5stat == "lock"){
		$('.level5').css('height','74px');
		$('.level8').css('width','233px');
		$('.level5').css('background','url("images/locklevel.png")');
		$('.color-level5').css('background','#a9a9a9');
		$('.levscore5').hide();
	}else{
		$('.level5').css('height','106px');
		$('.level8').css('width','236px');
		$('.level5').css('background','url("images/level.png")');
		$('.color-level5').css('background','#ffffff');
		$('.levscore5').show();
	}
	if(l6stat == "lock"){
		$('.level6').css('height','74px');
		$('.level8').css('width','233px');
		$('.level6').css('background','url("images/locklevel.png")');
		$('.color-level6').css('background','#a9a9a9');
		$('.levscore6').hide();
	}else{
		$('.level6').css('height','106px');
		$('.level8').css('width','236px');
		$('.level6').css('background','url("images/level.png")');
		$('.color-level6').css('background','#ffffff');
		$('.levscore6').show();
	}
	if(l7stat == "lock"){
		$('.level7').css('height','74px');
		$('.level8').css('width','233px');
		$('.level7').css('background','url("images/locklevel.png")');
		$('.color-level7').css('background','#a9a9a9');
		$('.levscore7').hide();
	}else{
		$('.level7').css('height','106px');
		$('.level8').css('width','236px');
		$('.level7').css('background','url("images/level.png")');
		$('.color-level7').css('background','#ffffff');
		$('.levscore7').show();
	}
	if(l8stat == "lock"){
		$('.level8').css('height','74px');
		$('.level8').css('width','233px');
		$('.level8').css('background','url("images/locklevel.png")');
		$('.color-level8').css('background','#a9a9a9');
		$('.levscore8').hide();
	}else{
		$('.level8').css('height','106px');
		$('.level8').css('width','236px');
		$('.level8').css('background','url("images/level.png")');
		$('.color-level8').css('background','#ffffff');
		$('.levscore8').show();
	}
}
/*
// sample fb code
function renderWelcome() {
  var welcome = $('#welcome');
  welcome.find('.first_name').html(friendCache.me.first_name);
  welcome.find('.profile').attr('src',friendCache.me.picture.data.url);
}
*/
/*
// sample fb code
function showFriendsList() {
	var str = '', i = 0;
	
	for (i = 0; i < friendCache.friends.data.length; i++) {
		str += '<img src="' + friendCache.friends.data[i].picture.data.url + '" />'+
		' <span>' + friendCache.friends.data[i].first_name + '</span>'+
		' <span>' + friendCache.friends.data[i].name + '</span>'+
		' <span>(' + friendCache.friends.data[i].id + ')</span>';
	}
	
	$("#friendslist").html(str);
}
*/

/*
function onInvite() {
  sendInvitation(null,'Foolish Math is great fun! Come and check it out!', function(response) {
    //console.log('sendInvitation',response);
  });
}

function onScoreShare() {
  scoreSharing = false;
  shareScore('I just scored ' + levelscore + ' on level ' + level + '! Think you can beat me?', function(){
	//callback code
  });
}
*/