Translation.getLang();

function isEmpty(obj) {
    for(var prop in obj) {
        if(obj.hasOwnProperty(prop))
            return false;
    }
    return true;
}

var Matrix = {
	changeOption: false,
	options: {
		'color':'#0F0',
		'speed': '33',
		'alphabet': 'ムタ二コク1234567890シモラキリエスハヌトユABCDEF',
		'audio':true
	},
	load: function() {
		var value = localStorage.getItem('matrix');
		if (!isEmpty(JSON.parse(value))) this.options = value && JSON.parse(value);
		console.dir(this.options);
	},
	save: function() {
		localStorage.setItem('matrix', JSON.stringify(this.options));
	},
	init: function() {
		this.load();
		if (this.options['audio']) $('#music').trigger("play");
		
	}
	
}





$(document).ready(function() {

	Matrix.init();


	var canvas = document.getElementById("c"), context = canvas.getContext("2d");

	//making the canvas full screen
	canvas.height = window.innerHeight;
	canvas.width = window.innerWidth;

	//alphabet characters - taken from the unicode charset
	var alphabet = Matrix.options['alphabet'];//"ムタ二コク1234567890シモラキリエスハヌトユABCDEF"; АБВГДЕЁЖЗИКЛМНОПРСТУФХЦЧШЩЭЮЯ 田由甲申甴电甶男甸甹町画甼甽甾甿畀畁畂畃畄畅畆畇畈畉畊畋界畍畎畏畐畑
	//converting the string into an array of single characters
	alphabet = alphabet.split("");

	var font_size = 10;
	var columns = canvas.width/font_size; //number of columns for the rain
	//an array of drops - one per column
	var drops = [];
	//x below is the x coordinate
	//1 = y co-ordinate of the drop(same for every drop initially)
	for(var x = 0; x < columns; x++)
		drops[x] = 1; 

	//drawing the characters
	function draw()
	{
		//Black BG for the canvas
		//translucent BG to show trail
		context.fillStyle = "rgba(0, 0, 0, 0.05)";
		context.fillRect(0, 0, canvas.width, canvas.height);
		
		
		 color = Matrix.options['color'];
		
		context.fillStyle = color; //green text
		context.font = font_size + "px arial";
		//looping over drops
		for(var i = 0; i < drops.length; i++)
		{
			//a random alphabet character to print
			var text = alphabet[Math.floor(Math.random()*alphabet.length)];
			//x = i*font_size, y = value of drops[i]*font_size
			context.fillText(text, i*font_size, drops[i]*font_size);
			
			//sending the drop back to the top randomly after it has crossed the screen
			//adding a randomness to the reset to make the drops scattered on the Y axis
			if(drops[i]*font_size > canvas.height && Math.random() > 0.975)
				drops[i] = 0;
			
			//incrementing Y coordinate
			drops[i]++;
		}
	}

	var nIntervId = setInterval(draw, Matrix.options['speed']);



	$('.front').click(function(e) { 
		e.preventDefault();
		$('.card').toggleClass('flipped');
		clearInterval(nIntervId);
		//load settings
		
		$("select[name=selColor] option").filter(function() { return $(this).val() == Matrix.options['color'];}).prop('selected', true);
		
		if (Matrix.options['speed'] == '66') $('input[name=selSpeed]:nth(0)').prop("checked", true); else $('input[name=selSpeed]:nth(0)').prop("checked", false);
		if (Matrix.options['speed'] == '33') $('input[name=selSpeed]:nth(1)').prop("checked", true); else $('input[name=selSpeed]:nth(1)').prop("checked", false);
		if (Matrix.options['speed'] == '10') $('input[name=selSpeed]:nth(2)').prop("checked", true); else $('input[name=selSpeed]:nth(2)').prop("checked", false);

		if (Matrix.options['alphabet'] == '') { Matrix.options['alphabet'] ='ムタ二コク1234567890シモラキリエスハヌトユABCDEF'; Matrix.changeOption = true;}
		$('input[name=alphabet]').val(Matrix.options['alphabet']);
		
		if (Matrix.options['audio'] == true) $('input[name=audio]').prop("checked", true); else $('input[name=audio]:').prop("checked", false);	
		
	});

	$('#btnDone').click(function(e) {
		e.preventDefault();
		$('.card').toggleClass('flipped');
		Matrix.save();
		if (Matrix.changeOption) location.reload();
		nIntervId = setInterval(draw, Matrix.options['speed']);
		
	});

	$('select[name=selColor]').change(function(e) { e.preventDefault();	Matrix.options['color'] = $(this).val();Matrix.changeOption = false;} );
	$('input[name=selSpeed]').change(function(e) { e.preventDefault();	Matrix.options['speed'] = $(this).val();Matrix.changeOption = false;});
	$('input[name=alphabet]').change(function(e) { e.preventDefault();	Matrix.options['alphabet'] = $(this).val();Matrix.changeOption = true;});
	$('input[name=audio]').change(function(e) { e.preventDefault();	if($(this).prop('checked')) {Matrix.options['audio'] = true;} else {Matrix.options['audio'] = false;}Matrix.changeOption = true;});
});

jQuery(function($) {
$(document).on("click", "a", function(event){ 
	if ((!this.target) || (this.target =='_self')) {
		//alert('internal link');
		event.preventDefault();
		window.location = this.href;
	} else {
		//alert('external link');
	}
  });
});