/****************************************************************************
 Copyright (c) 2010-2012 cocos2d-x.org
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011      Zynga Inc.

 http://www.cocos2d-x.org


 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var cocos2dApp = cc.Application.extend({
    config:document['ccConfig'],
    ctor:function (scene) {
        this._super();
        this.startScene = scene;
        cc.COCOS2D_DEBUG = this.config['COCOS2D_DEBUG'];
        cc.initDebugSetting();
        cc.setup(this.config['tag']);
        cc.AppController.shareAppController().didFinishLaunchingWithOptions();
    },
    applicationDidFinishLaunching:function () {
        if(cc.RenderDoesnotSupport()){
            // show Information to user
            alert("Browser doesn't support Canvas or WebGL");
            return false;
        }
        // initialize director
        var director = cc.Director.getInstance();
        
        // canvas will always use maximum window size now
        // cc.EGLView.getInstance().setDesignResolutionSize(winSize.width,winSize.height,cc.RESOLUTION_POLICY.SHOW_ALL);
        cc.EGLView.getInstance().setDesignResolutionSize(640,960,cc.RESOLUTION_POLICY.FIXED_HEIGHT);
        cc.EGLView.getInstance().resizeWithBrowserSize(true);

        //********* todo remove ***********
       // director.setDisplayStats(this.config['showFPS']);

        // set FPS. the default value is 1.0/60 if you don't call this
        director.setAnimationInterval(1.0 / this.config['frameRate']);

        winSize = cc.EGLView.getInstance().getVisibleSize();
        // console.log("SIZE: " + winSize.width + " " + winSize.height);

        // load resources
        CustomLoaderScene.preload(getResourcesTable(), function(){
            director.replaceScene(cc.TransitionFade.create(
                gameConfig.TRANSITION_TIME, 
                new this.startScene(), 
                gameConfig.TRANSITION_COLOR));
        }, this);

        return true;
    }
});
 
// 2
var director;
var winSize;
var myApp = new cocos2dApp(MainMenuScene.create);
