var map = L.map('map').setView([0, 0], 5);
var options = {
			key: '3c38d15e76c02545181b07d3f8cfccf0', // REPLACE WITH YOUR API-KEY. This key might go away any time!
			limit: 10
		};
var control = L.Control.openCageSearch(options).addTo(map);
var url='http://{s}.tile.osm.org/{z}/{x}/{y}.png';
L.tileLayer(url, {
    attribution: '&copy; <a href="http://osm.org/copyright">OpenStreetMap</a> contributors',
	minZoom: 4,
	maxZoom: 18
}).addTo(map);
L.control.scale({position:'bottomleft'}).addTo(map);
var marker;
		map.on('click', function(e) {
			var query = e.latlng.lat.toString() + ',' + e.latlng.lng.toString();
			geocoder.geocode(query, function(results) {
				var r = results[0];
				if (r) {
					if (marker) {
						marker.
							setLatLng(r.center).
							setPopupContent(r.name).
							openPopup();
					} else {
						marker = L.marker(r.center).bindPopup(r.name).addTo(map).openPopup();
					}
				}
			})
		})
(function(body) {
	// Only enable for chromeless window
	// Pro tip: Uncomment this line for testing.
	if (locationbar.visible) return;

	// Shim matchesSelector
	var matches = body.matchesSelector || body.mozMatchesSelector;

	// Seelctor matches external links, but allows https/http switching
	var selector = "a[href^='http']:not([href*='://" + location.host + "']):not([target='_blank'])";

	// Click event handler
	var handleClickEvent = function(evt) {
		// All the way up
		var element = evt.target;
		while (element && element != body) {
			// Only external links allowed
			if (matches.call(element, selector)) {
				// Add target when no named target given
				var target = element.getAttribute('target');
				if (!target || target.substr(0, 1) == '_') {
					element.setAttribute('target', '_blank');
				}
				return;
			}
			element = element.parentNode;
		}
	}

	// Delegate all clicks on document body
	body.addEventListener('click', handleClickEvent, false);
})(document.body);

