// JavaScript Document
var display;
var display_signo;
var display_memory;
var memoria;
var memoria_tmp;
var operacion;
var iniciar;

window.addEventListener('load', function() {
    new FastClick(document.body);
}, false);

Zepto(function($){
	console.log("MCalc is ready!!!");
	screen.mozLockOrientation("portrait");
	display = $("#Display");
	display_signo = $("#Signo");
	display_signo.html("");
	display_memory = $("#Memoria");
	display_memory.html("");
	memoria = "";
	iniciar = true;
	operacion = "";
	InitUI();
})

function InitUI(){
	for(var i=0;i<10;i++)
		$("#Bot"+i).on("click",function(ev){ onTapNumber(ev) });
	
	for(var j=0;j<4;j++)
		$("#BotOp"+j).on("click",function(ev){ onTapOperation(ev) });
		
	$("#BotPunto").on("click",function(ev){ onTapNumber(ev) });
	$("#BotC").on("click",function(ev){ Limpiar(); });
	$("#BotIgual").on("click",function(ev){ getResult(); });
	$("#BotMC").on("click",function(ev){ onTapMC(); });
	$("#BotMS").on("click",function(ev){ onTapMS(); });
	$("#BotMR").on("click",function(ev){ onTapMR(); });
}

function onTapNumber(ev){
	var boton = ev.target;
	var digito = boton.innerHTML;
	
	if(iniciar){
		iniciar = false;
		display.html("0");
	}
	
	if(digito=="." && display.html().indexOf(".") >= 0){
		digito = "";	
	}
	
	if(display.html()=="0"){
		if(digito != "0"){
			if(digito==".") digito = "0.";
			display.html(digito);	
		}
	}else{
		display.html(display.html() + digito);
	}
}

function onTapOperation(ev){
	var boton = ev.target;
	
	if(operacion!=""){
		getResult();	
	}
	
	memoria_tmp = Number(display.html());
	iniciar = true;
	
	switch(boton.id){
		// SUMA
		case "BotOp0":
			operacion = "SUMA";
			break;
		// RESTA
		case "BotOp1":
			operacion = "RESTA";
			break;
		// MULTIPLICACION
		case "BotOp2":
			operacion = "MULTIPLICACION";
			break;
		// DIVISION
		case "BotOp3":
			operacion = "DIVISION";
			break;
	}
	display_signo.html(boton.innerHTML);
}

function getResult(){
	var resultado = 0;
	var numero = Number(display.html());
	iniciar = true;	
	switch(operacion){
		case "SUMA":
			resultado = memoria_tmp + numero;
			break;
		case "RESTA":
			resultado = memoria_tmp - numero;
			break;
		case "MULTIPLICACION":
			resultado = memoria_tmp * numero;
			break;
		case "DIVISION":
			if(numero != 0){
				resultado = memoria_tmp / numero;
			}else{
				resultado = "Err";
			}
			break;
	}
	
	operacion = "";
	memoria_tmp = "";
	display_signo.html("");
	display.html(resultado);
}

function Limpiar(){
	display.html("0");
	display_signo.html("");
	operacion = "";
	memoria_tmp = "";
}

function onTapMC(){
	memoria = "";
	display_memory.html("");
}

function onTapMS(){
	memoria = Number(display.html());
	display_memory.html("M");
}

function onTapMR(){
	if(memoria!=""){
		display.html(memoria);
	}
}
