/**
 *  Trip.js
 *
 *  This is a jQuery plugin that can help you customize your tutorial trip
 *  with full flexibilities.
 *
 *  Version: 2.0.1
 *
 *  Author: EragonJ <eragonj@eragonj.me>
 *  Blog: http://eragonj.me
 *
 *  @preserve
 */
!function(a,b){function c(b,c){var d,e,f=c;this.pause=function(){a.clearTimeout(d),f-=new Date-e},this.resume=function(){return e=new Date,d=a.setTimeout(b,f),f},this.stop=function(){a.clearTimeout(d)},this.resume()}var d=["flash","bounce","shake","tada","fadeIn","fadeInUp","fadeInDown","fadeInLeft","fadeInRight","fadeInUpBig","fadeInDownBig","fadeInLeftBig","fadeInRightBig","bounceIn","bounceInDown","bounceInUp","bounceInLeft","bounceInRight","rotateIn","rotateInDownLeft","rotateInDownRight","rotateInUpLeft","rotateInUpRight"],e=function(c,d){this.settings=b.extend({tripIndex:0,tripTheme:"black",backToTopWhenEnded:!1,overlayZindex:99999,delay:1e3,enableKeyBinding:!0,enableAnimation:!0,showCloseBox:!1,showHeader:!1,skipUndefinedTrip:!1,showNavigation:!1,canGoNext:!0,canGoPrev:!0,nextLabel:"Next",prevLabel:"Back",finishLabel:"Dismiss",closeBoxLabel:"&#215;",header:"Step {{tripIndex}}",onStart:b.noop,onEnd:b.noop,onTripStart:b.noop,onTripEnd:b.noop,onTripStop:b.noop,onTripPause:b.noop,onTripResume:b.noop,onTripChange:b.noop,onTripClose:b.noop,animation:"tada",tripBlockHTML:['<div class="trip-block">','<a href="#" class="trip-close"></a>','<div class="trip-header"></div>','<div class="trip-content"></div>','<div class="trip-progress-wrapper">','<div class="trip-progress-bar"></div>','<a href="#" class="trip-prev"></a>','<a href="#" class="trip-next"></a>',"</div>","</div>"]},d),this.tripData=c,this.$tripBlock=null,this.$overlay=null,this.$bar=null,this.$root=b("body, html"),this.tripIndex=this.settings.tripIndex,this.tripDirection="next",this.timer=null,this.progressing=!1,this.hasExpose=!1,this.CONSTANTS={LEFT_ARROW:37,UP_ARROW:38,RIGHT_ARROW:39,DOWN_ARROW:40,ESC:27,SPACE:32,TRIP_BLOCK_OFFSET_VERTICAL:10,TRIP_BLOCK_OFFSET_HORIZONTAL:10},this.console=a.console||{}};e.prototype={preInit:function(){if("undefined"==typeof this.console){var a=this,c=["log","warn","debug","info","error"];b.each(c,function(c,d){a.console[d]=b.noop})}},showExpose:function(a){var b,c;this.hasExpose=!0,b={position:a.css("position"),zIndex:a.css("z-Index")},c={position:"relative",zIndex:this.settings.overlayZindex+1},a.data("trip-old-css",b).css(c).addClass("trip-exposed"),this.$overlay.show()},hideExpose:function(){var a=b(".trip-exposed"),c=a.data("trip-old-css");this.hasExpose=!1,a.css(c).removeClass("trip-exposed"),this.$overlay.hide()},bindResizeEvents:function(){var c=this;b(a).on("resize.Trip",function(){c.run()})},unbindResizeEvents:function(){b(a).off("resize.Trip")},bindKeyEvents:function(){var a=this;b(document).on({"keydown.Trip":function(b){a.keyEvent.call(a,b)}})},unbindKeyEvents:function(){b(document).off("keydown.Trip")},keyEvent:function(a){switch(a.which){case this.CONSTANTS.ESC:this.stop();break;case this.CONSTANTS.SPACE:a.preventDefault(),this.pause();break;case this.CONSTANTS.LEFT_ARROW:case this.CONSTANTS.UP_ARROW:this.prev();break;case this.CONSTANTS.RIGHT_ARROW:case this.CONSTANTS.DOWN_ARROW:this.next()}},stop:function(){this.timer&&this.timer.stop(),this.hasExpose&&this.hideExpose(),this.hideTripBlock(),this.unbindKeyEvents(),this.unbindResizeEvents();var a=this.getCurrentTripObject(),b=a.onTripStop||this.settings.onTripStop;b(this.tripIndex,a),this.settings.onEnd()},pauseAndResume:function(){if(this.progressing)this.timer.pause(),this.pauseProgressBar();else{var a=this.timer.resume();this.resumeProgressBar(a)}this.progressing=!this.progressing},pause:function(){this.pauseAndResume();var a=this.getCurrentTripObject(),b=a.onTripPause||this.settings.onTripPause;b(this.tripIndex,a)},resume:function(){this.pauseAndResume();var a=this.getCurrentTripObject(),b=a.onTripResume||this.settings.onTripResume;b(this.tripIndex,a)},next:function(){return this.tripDirection="next",this.canGoNext()?(this.hasCallback()&&this.callCallback(),void(this.isLast()?this.doLastOperation():(this.increaseIndex(),this.run()))):this.run()},prev:function(){this.tripDirection="prev",!this.isFirst()&&this.canGoPrev()&&this.decreaseIndex(),this.run()},showCurrentTrip:function(a){this.settings.enableAnimation&&this.removeAnimation(),this.timer&&this.timer.stop(),this.hasExpose&&this.hideExpose(),this.progressing&&(this.hideProgressBar(),this.progressing=!1),this.setTripBlock(a),this.showTripBlock(a),this.settings.enableAnimation&&this.addAnimation(a),a.expose&&this.showExpose(b(a.sel))},doLastOperation:function(){return this.timer&&this.timer.stop(),this.settings.enableKeyBinding&&this.unbindKeyEvents(),this.hideTripBlock(),this.unbindResizeEvents(),this.hasExpose&&this.hideExpose(),this.settings.backToTopWhenEnded&&this.$root.animate({scrollTop:0},"slow"),this.tripIndex=this.settings.tripIndex,this.settings.onEnd(),!1},showProgressBar:function(a){var b=this;this.$bar.animate({width:"100%"},a,"linear",function(){b.$bar.width(0)})},hideProgressBar:function(){this.$bar.width(0),this.$bar.stop(!0)},pauseProgressBar:function(){this.$bar.stop(!0)},resumeProgressBar:function(a){this.showProgressBar(a)},run:function(){var a=this,b=this.getCurrentTripObject(),d=b.onTripStart||this.settings.onTripStart,e=b.onTripChange||this.settings.onTripChange,f=b.onTripEnd||this.settings.onTripEnd,g=b.delay||this.settings.delay;return this.isTripDataValid(b)?(this.showCurrentTrip(b),this.showProgressBar(g),this.progressing=!0,e(this.tripIndex,b),d(this.tripIndex,b),void(g>=0&&(this.timer=new c(function(){f(a.tripIndex,b),a.next()},g)))):this.settings.skipUndefinedTrip===!1?(this.console.error("Your tripData is not valid at index: "+this.tripIndex),this.stop(),!1):this[this.tripDirection]()},isFirst:function(){return 0===this.tripIndex?!0:!1},isLast:function(){return this.tripIndex===this.tripData.length-1?!0:!1},isTripDataValid:function(a){var c=["screen-ne","screen-se","screen-sw","screen-nw","screen-center"];return b.inArray(a.position,c)>=0?!0:"undefined"==typeof a.content||"undefined"==typeof a.sel||null===a.sel||0===a.sel.length||0===b(a.sel).length?!1:!0},hasCallback:function(){return"undefined"!=typeof this.tripData[this.tripIndex].callback},callCallback:function(){this.tripData[this.tripIndex].callback(this.tripIndex)},canGoPrev:function(){var a=this.tripData[this.tripIndex],b=a.canGoPrev||this.settings.canGoPrev;return"function"==typeof b&&(b=b.call(a)),b},canGoNext:function(){var a=this.tripData[this.tripIndex],b=a.canGoNext||this.settings.canGoNext;return"function"==typeof b&&(b=b.call(a)),b},increaseIndex:function(){this.tripIndex>=this.tripData.length-1||(this.tripIndex+=1)},decreaseIndex:function(){this.tripIndex<=0||(this.tripIndex-=1)},getCurrentTripObject:function(){return this.tripData[this.tripIndex]},getCurrentHeader:function(a){var b=/\{\{(tripIndex)\}\}/g;return a.replace(b,this.tripIndex+1)},setTripBlock:function(a){var b=this.$tripBlock,c=a.showCloseBox||this.settings.showCloseBox,d=a.showNavigation||this.settings.showNavigation,e=a.showHeader||this.settings.showHeader,f=a.closeBoxLabel||this.settings.closeBoxLabel,g=a.prevLabel||this.settings.prevLabel,h=a.nextLabel||this.settings.nextLabel,i=a.finishLabel||this.settings.finishLabel,j=a.header||this.settings.header;b.find(".trip-header").html(this.getCurrentHeader(j)).toggle(e),b.find(".trip-content").html(a.content),b.find(".trip-prev").html(g).toggle(d&&!this.isFirst()),b.find(".trip-next").html(this.isLast()?i:h).toggle(d),b.find(".trip-close").html(f).toggle(c),b.removeClass("e s w n screen-ne screen-se screen-sw screen-nw screen-center"),b.addClass(a.position),this.setTripBlockPosition(a,"horizontal"),this.setTripBlockPosition(a,"vertical")},setTripBlockPosition:function(a,c){var d,e,f=this.$tripBlock,g=b(a.sel),h=g&&g.outerWidth(),i=g&&g.outerHeight(),j=f.outerWidth(),k=f.outerHeight(),l=10,m=10;switch(a.position){case"screen-center":d="50%",e="50%";break;case"screen-ne":case"screen-se":case"screen-nw":case"screen-sw":d=this.CONSTANTS.TRIP_BLOCK_OFFSET_HORIZONTAL,e=this.CONSTANTS.TRIP_BLOCK_OFFSET_VERTICAL;break;case"e":d=g.offset().left+h+m,e=g.offset().top-(k-i)/2;break;case"s":d=g.offset().left+(h-j)/2,e=g.offset().top+i+l;break;case"w":d=g.offset().left-(m+j),e=g.offset().top-(k-i)/2;break;case"n":default:d=g.offset().left+(h-j)/2,e=g.offset().top-l-k}if("horizontal"===c)switch(f.css({left:"",right:"",marginLeft:""}),a.position){case"screen-center":f.css({left:d,marginLeft:-.5*j});break;case"screen-se":case"screen-ne":f.css({right:d});break;case"screen-sw":case"screen-nw":case"e":case"s":case"w":case"n":default:f.css({left:d})}else if("vertical"===c)switch(f.css({top:"",bottom:"",marginTop:""}),a.position){case"screen-center":f.css({top:e,marginTop:-.5*k});break;case"screen-sw":case"screen-se":f.css({bottom:e});break;case"screen-nw":case"screen-ne":case"e":case"s":case"w":case"n":default:f.css({top:e})}},addAnimation:function(a){var c=a.animation||this.settings.animation;b.inArray(c,d)>=0&&(this.$tripBlock.addClass("animated"),this.$tripBlock.addClass(c))},removeAnimation:function(){this.$tripBlock.removeClass(d.join(" ")),this.$tripBlock.removeClass("animated")},showTripBlock:function(){this.$tripBlock.css({display:"inline-block",zIndex:this.settings.overlayZindex+1});var c=b(a).height(),d=b(a).scrollTop(),e=this.$tripBlock.offset().top,f=100;d+c>e&&e>=d||this.$root.animate({scrollTop:e-f},"slow")},hideTripBlock:function(){this.$tripBlock.fadeOut("slow")},create:function(){this.createTripBlock(),this.createOverlay()},createTripBlock:function(){if("undefined"==typeof b(".trip-block").get(0)){var a=this,c=this.settings.tripBlockHTML.join(""),d=b(c).addClass(this.settings.tripTheme);b("body").append(d),d.find(".trip-close").on("click",function(b){b.preventDefault();var c=a.getCurrentTripObject(),d=c.onTripClose||a.settings.onTripClose;d(a.tripIndex,c),a.stop()}),d.find(".trip-prev").on("click",function(c){c.preventDefault(),b(this).blur(),a.prev()}),d.find(".trip-next").on("click",function(c){c.preventDefault(),b(this).blur(),a.next()})}},createOverlay:function(){if("undefined"==typeof b(".trip-overlay").get(0)){var c=['<div class="trip-overlay">',"</div>"].join(""),d=b(c);d.height(b(a).height()).css({zIndex:this.settings.overlayZindex}),b("body").append(d)}},cleanup:function(){b(".trip-overlay, .trip-block").remove()},init:function(){this.preInit(),this.settings.enableKeyBinding&&this.bindKeyEvents(),this.bindResizeEvents(),this.$tripBlock=b(".trip-block"),this.$bar=b(".trip-progress-bar"),this.$overlay=b(".trip-overlay")},start:function(){this.cleanup(),this.settings.onStart(),this.create(),this.init(),this.run()}},a.Trip=e}(window,jQuery);