$(document).bind("pageinit", function() {

  var _monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];

  var _updateForms = function(container, mapFn) {

    if (!container.length) {
      return;
    }

    var ul = container.find('ul');

    medicMobile.query(mapFn, function(forms) {
      ul.html('');
      container.find('.ui-li-count').text(forms.length);

      if (!forms.length) {
        ul.append('<li><a class="ui-btn ui-btn-icon-right ui-disabled">No forms available</a></li>');
        return;
      }

      forms.forEach(function(form) {
        var label;
        if (form.value && form.value.content && form.value.content.name) {
          label = form.value.content.name;
        } else if (Date.parse(form.id)) {
          date = new Date(Date.parse(form.id));
          label = date.getDate() + "-" + _monthNames[date.getMonth()] + "-" + date.getFullYear();
        } else {
          label = form.id;
        }

        ul.append(
          '<li>' +
            '<a href="form-measles.html?form=' + encodeURIComponent(form.id) +
              '" data-ajax="false" data-transition="slide" class="report ui-btn ui-btn-icon-right ui-icon-carat-r">' +
                label +
            '</a>' +
          '</li>'
        );
      });
    });

  }

  _updateForms(
    $('#mm_saved_forms'),
    function(doc) {
      if (doc.submitted === false) { //we don't want to include the settings doc.
        emit(doc._id, doc);
      }
    }
  );

  _updateForms(
    $('#mm_submitted_forms'),
    function(doc) {
      if (doc.submitted === true) {
        emit(doc._id, doc);
      }
    }
  );

  _urlParam = function(name) {
    // http://www.jquery4u.com/snippets/url-parameters-jquery/
    var results = new RegExp('[\\?&]' + name + '=([^&#]*)').exec(window.location.href);

    if (!results) {
       return undefined;
    }
    return decodeURIComponent(results[1] || 0);
  };


  function syncDB (callback) {
    if (medicMobile.getRemoteDBHost() &&
          medicMobile.getRemoteDBName()) {
      medicMobile.sync(callback);
    } else {
      $("#last_sync_status").html(
        'A sync server is not yet configured. Please visit ' +
          ' the <a href="settings.html">Settings</a> page for more information.'
      );
      //console.log ("Remote CouchDB settings are not set.");
      //window.location.replace("settings.html");
    }
  }

  if ($("#sync-page").length) {

    $('#sync-btn').click(function(e) {
      e.preventDefault();
      e.stopPropagation();

      $("#last_sync_status").text("Synchronization in progress...");

      syncDB(function(err, resp){
        $("#remote_db").text(medicMobile.getRemoteDBHost() + "/" +medicMobile.getRemoteDBName());

        if (err) {
          $("#last_sync_status").text("Failed: " + err);
        }else{
          $("#last_sync_time").text(resp.end_time);
          $("#last_sync_status").text("Successful");
        }
      });
    });
  }

  if ($("#settings-page").length) {
    $("#remote_db_host").val(medicMobile.getRemoteDBHost());
    $("#remote_db_name").val(medicMobile.getRemoteDBName());
  }

  if ($("#view-submitted").length) {
    // syncDB ();
    if ( !(medicMobile.getRemoteDBHost() && medicMobile.getRemoteDBName()) ) {
		$("#settings-prompt").show();		  
	}
	else {
		$("#settings-prompt").hide();
	}
  }

  if ($('#measles').length) {
    var formId = _urlParam('form');
    if (formId) {
      medicMobile.get(formId, function(err, resp) {
        if (err) {
          console.log(JSON.stringify(err));
        } else {
          $('input[name=_id]').val(resp._id);
          $('input[name=_rev]').val(resp._rev);
          $.each(resp.content, function(key, value) {
              $('input[name=' + key + ']').val(value);
          });
          $( ".je-photo" ).imageCapture("update");
          $( "[type='gps']" ).gps("update");
        }
      });
    }
  }
});


$.openSelect = function(name){
    $('#' + name.htmlFor).selectmenu('open');
};

$.onSubmit = function(){
  var data = $.getData();

  medicMobile.add(data, function () {
    //sync the form with remote db
    medicMobile.sync(function(){
      $.sendSms(data);
    });
  }, $('input[name=_id]').val(), $('input[name=_rev]').val());

  return false;
};

$.sendSms = function(data) {
    if (false && typeof MozActivity != 'undefined') {
      var activity = new MozActivity({
        name: "new",
        data: {
          type: "websms/sms",
          number: "5555555",
          body: '{' +
            'content: "{' +
              'name: "' + data.name + '",' +
              'phone: "' + data.phone + '",' +
              'location: "' + data.location + '"' +
            '}"' +
          '}'
        }
      });

      activity.onsuccess = function() {
        window.location.replace("view-submitted.html");
      };

      activity.onerror = function() {
        alert(this.error);
      };
    } else {
      console.warn("Your browser doesn't support SMS submission");
      window.location.replace("view-submitted.html");
    }
}

$.onSave = function(){
    medicMobile.save($.getData(), function (result) {
        //$('input[name=_id]').val(result.id);
        //$('input[name=_rev]').val(result.rev);
        //$('.ui-bar .ui-title').text('Saved');
        window.location.replace("view-saved.html");
    }, $('input[name=_id]').val(), $('input[name=_rev]').val());
    return false;
};

$.getData = function () {
    var data = {};
    $('div.je-field').filter(function(){
        return this.id.match(/je0-/);
    }).each(function (index){
        var re = /(je0-[0-9a-zA-z]+)-(\d+)/;
        var results = re.exec(this.id);
        if (results) {
            var inputId = results[1] + "-input-" + (Number(results[2])+1);
            var input = $("#" + inputId);
            var value = input.val();
            var name = input.attr('name');
            if (name && value){
              data[name] = value;
            }
        }
    });

    return data;
};
