var medicMobile = medicMobile || {};

(function (mm) {

  var dbName = 'medic-form',
    // settings_doc_id = dbName + "-settings";
    db = new PouchDB(dbName);
  // var remoteCouch = 'https://user:pass@medicforms.iriscouch.com:6984/' + dbName;

  db.info(function(err, info) {
    db.changes({
      since: info.update_seq,
      continuous: true,
      onChange: mm.showSubmittedForms
    });
  });

  // Initialise a sync with the remote server
  mm.sync = function(callback) {
    var remoteCouch = mm.getRemoteDBHost() + "/" + mm.getRemoteDBName();

    var sync_to_remote_callback = function(err, resp){
        syncResult (err, resp);
        if (callback) callback.call(this, err, resp);
      };
    db.replicate.to(remoteCouch, sync_to_remote_callback);
    db.replicate.from(remoteCouch, syncResult);
  };

  function syncResult(err, resp) {
    if(err) {
      console.log("sync failed: " + err);
    } else {
      console.log("sync successful: " + JSON.stringify(resp));
    }
  }

  mm.get = function (docId, callback) {
    db.get(docId, callback);
  };

  mm.add = function (obj, callback, id, rev) {
    put(
      {
        _id: id || new Date().toISOString(),
        _rev: rev || undefined,
        submitted: true,
        content: obj
      },
      callback
    );
  };

  mm.save = function (obj, callback, id, rev) {
    put(
      {
        _id: id || new Date().toISOString(),
        _rev: rev || undefined,
        submitted: false,
        content: obj
      },
      callback
    );
  };

  function put (form, callback) {
    db.put(form, function (err, result) {
      if (!err) {
        callback.call(this, err, result);
        console.log("Successfully added form " + result);
      } else {
        console.log("Adding DB content error:" + err);
      }
    });
  }

  mm.query = function(mapFn, callback) {
    db.query(
      mapFn,
      {reduce: false},
      function (err, response) {
        if (!err) {
          callback(response.rows);
        } else {
          console.log("loading error for all the docs or there is no docs available");
        }
      }
    );
  };

  mm.getRemoteDBHost = function () {
    if (typeof (Storage) == "undefined") {
      console.log("localStorage is not supported!");
      return null;
    }
    return localStorage.getItem("remote_db_host");
  };

  mm.setRemoteDBHost = function (dbhost) {
    if (typeof (Storage) == "undefined") {
      console.log("localStorage is not supported!");
      return null;
    }
    localStorage.setItem("remote_db_host", dbhost);
    return true;
  };

  mm.getRemoteDBName = function () {
    if (typeof (Storage) == "undefined") {
      console.log("localStorage is not supported!");
      return null;
    }
    return localStorage.getItem("remote_db_name");
  };

  mm.setRemoteDBName = function (dbname) {
    if (typeof (Storage) == "undefined") {
      console.log("localStorage is not supported!");
      return null;
    }
    localStorage.setItem("remote_db_name", dbname);
    return true;
  };

  mm.saveSettings = function () {
    if (mm.setRemoteDBHost($("#remote_db_host").val()) &&
        mm.setRemoteDBName($("#remote_db_name").val())){
          console.log("settings saved.");
          window.location.replace("sync.html");
          /*
          PouchDB.destroy(dbName, function(err, info){
            if (err) {
              console.log(err);
            }
            window.location.replace("sync.html");
          });*/
    } else {
      console.log("Failed to save settings.");
    }
  };

})(medicMobile);
