
var mm = medicMobile;
$(window).load(function () {
  console.log("Page loaded");
});

$(document).ready(function () {
  console.log("DOM ready");

  $('.je-field').filter(function () {
    return this.id.match(/je0-q[0-9][^a]/);
  }).hide();

  $("select").filter(function () {
    return this.id.match(/je0-q[0-9][a]/);
  }).change(function () {
    var s = this.name.substring(0, 2);
    var re = new RegExp("je0-" + s + "[^a]", "g");

    if (this.value == 1) { // Yes
      $('.je-field').filter(function () {
        return this.id.match(re);
      }).show("slow");
    } else { // No
      $('.je-field').filter(function () {
        return this.id.match(re);
      }).hide("slow");
    }

    return true;
  });

  $(":input").change(function () {

      if (!mm) {
        console.log("medicMobile object is not initialized properly");
        return false;
      }
      var element = this;
      mm.validateElement(element);
      return true;
    });
});

function getSerializedFormItem (element) {
  var serializedItem = {};

  var val = $(element).val();
  var mm_type = $(element).attr("mm-type");
  if (!mm_type) {
    console.log("mm-type is missing on element: " + element.id);
    return false;
  }else if (mm_type === "integer" || mm_type === "year" || mm_type === "month" ||
      mm_type === "day" || mm_type === "week" ) {
    val = Number(val);
  }

  serializedItem.val = val;
  serializedItem.validate_fn = mm.lib.input["validate_" + mm_type];
  serializedItem.field = {
    "type": mm_type,
    "required": ($(element).attr("required") && true) || false
  };

  if (mm_type === "select") {
    var items = [];
    //normalize the select items
    //items: [ [value: text], [value: text] ....]
    var options = $(element).children("option") ;
    var value, option;
    for (var i=0; i<options.length; i++){
      //getAttribute("value") will return null when the value attribute is not present. So we can filter out the "Choose one ..." prompt text option
      option = options.get(i);
      value = option.getAttribute("value");
      if (value) {
        items.push([value, option.text]);
      } else if (option.getAttribute("data-placeholder")) {
        serializedItem.placeholder = option.text;
      }
    }
    serializedItem.field.items = items;
  }

  return serializedItem;
}

mm.validateElement = function (element, callback, args) {
  // take care of the hidden elements
  if (!$(element).is(":visible")) { //ignore the invisible elements
    if (callback) { //assume valid
      callback.call(this, args);
    }
    return true;
  }

  var serializedItem = getSerializedFormItem(element);

  //take care of the default select value (data-placeholder) which essentially shouldn't be validated if not required
  if ((serializedItem.field.type === "select") && (!serializedItem.field.required) && (serializedItem.val === serializedItem.placeholder)){
    if (callback) { //assume valid
      callback.call(this, args);
    }
    return true;
  }

  if (serializedItem && serializedItem.validate_fn) {
    serializedItem.validate_fn(serializedItem.val, serializedItem.field, function (rv) {
      console.log(JSON.stringify(rv));

      var errorElement = $("label[for='" + element.id + "'] .error");
      if (!rv.valid) {
        //append error message after the input label
        if (errorElement.length <= 0) {
          $("label[for='" + element.id + "']").append("<span class='error'>" + rv.error + "</span>");
        } else {
          errorElement.text(rv.error);
        }
      } else {
        if (errorElement.length >= 0) {
          errorElement.remove();
        }

        if (callback) {
          callback.call(this, args);
        }
      }
    });
  } else {
    console.log("No validation function for " + mm_type);
  }
};



mm.onSubmit = function () {
  //validate all the fields
  var allInputs = $(":input");
  var element, i = allInputs.length;

  var validate = function (index) {
    if (index < allInputs.length) {
      element = allInputs.get(index);
      mm.validateElement(element, validate, index+1);
    } else { //all vaid, now submit the form
      console.log("All inputs are valid");
      $.onSubmit ();
    }
  };

  validate(0);
};



