/**
 * Widget for storing the users location
 *
 * Register on document ready with: 
 *  $( "[type='gps']" ).gps();
 *
 * Retrieve the GPS JSON object with:
 *    JSON.parse(document.getElementsByName('location')[0].value)
 */
$.widget( "custom.gps", {
  _create: function() {
    this.element.hide();
    var _widget = this;
    
    // initialize blank map
    _widget._initializeMap();
    
    _widget.element.closest(".je-field").find("#map-refresh a").click(function(e){
      e.preventDefault();
      _widget._updateUsingGps(true);
    });
  },
  update: function() {
    var _widget = this;
    var value = _widget.element.val();
    if (value) {
      var location = JSON.parse(value);
      
      // set up map with saved location
      _widget._setLocation(new google.maps.LatLng(location.latitude, location.longitude));
      _widget._updateUsingGps(false);
    } else {
      _widget._updateUsingGps(true);
    }
  },
  _updateUsingGps: function(setCenter) {
    var _widget = this;
    if ("geolocation" in navigator) {
      navigator.geolocation.getCurrentPosition(
        function(pos) {
          var location = {
            latitude: pos.coords.latitude,
            longitude: pos.coords.longitude,
            elevation: pos.coords.altitude,
            accuracy: pos.coords.accuracy
          };
          _widget.element.val(JSON.stringify(location));
          
          // map with geolocation
          _widget._showGPS(new google.maps.LatLng(location.latitude, location.longitude), location.accuracy, setCenter);
          console.log(location);
        },
        function(err) {
          console.warn('ERROR(' + err.code + '): ' + err.message);
        },
        {timeout: 10000} 
      );
    } else {
      console.warn("Your browser doesn't support geolocation");
    }
  },
  _initializeMap: function() {
    var _widget = this;
    
    _widget._map = new google.maps.Map(document.getElementById('map-canvas'), {
      zoom: 0,
      streetViewControl: false,
      overviewMapControl:false,
      mapTypeControl: false,
      mapTypeId: google.maps.MapTypeId.TERRAIN,
      center: new google.maps.LatLng(0,0)
    });

    _widget._marker = new google.maps.Marker({
      position: new google.maps.LatLng(0,0),
      map: _widget._map,
      icon: { url:"images/marker-tracking.png", anchor: {x:12, y:12}},
      title: 'Current location',
      clickable:false,
      draggable:false,
      visible: false      
    });
    
    _widget._accuracy = new google.maps.Circle({
      center: new google.maps.LatLng(0,0),
      radius: 0,
      map: _widget._map,
      fillColor: "#00F",
      fillOpacity: 0.1,
      strokeColor: "#00F",
      strokeWeight: 1,
      strokeOpacity: 0.2,
      visible: false
    });

    google.maps.event.addListener(_widget._map, 'dragend', function (event) {
      _widget.element.val(JSON.stringify({
        latitude: _widget._map.getCenter().d, 
        longitude: _widget._map.getCenter().e, 
        elevation: 0
      }));
      console.log(_widget.element.val());
    });      
  },  
  _setLocation: function(latLng) {
    var _widget = this;
    _widget.element.val(JSON.stringify({
      latitude: latLng.d, 
      longitude: latLng.e, 
      elevation: 0
    }));

    _widget._map.panTo(latLng);
    _widget._map.setZoom(14);
  },
  _showGPS: function(latLng, accuracy, setCenter) {
    var _widget = this;

    _widget._accuracy.setCenter(latLng);
    _widget._accuracy.setRadius(accuracy);
    _widget._accuracy.setVisible(true);
    
    _widget._marker.setPosition(latLng);
    _widget._marker.setVisible(true);
  
    //set the zoom level to the gps point
    if (setCenter === true) {
      _widget._map.panTo(latLng);
      _widget._map.fitBounds(_widget._accuracy.getBounds());
    }
    else {
      // dont change center, but zoom to include gps as well
      _widget._zoomToInclude(latLng);
    }
  },
  _zoomToInclude: function(latLng) {
    var _widget = this;
    
    if (_widget._map.getBounds().contains(latLng) === false){
      _widget._map.setZoom(_widget._map.getZoom()-1);
      _widget._zoomToInclude(latLng);
    }
    else {
      return;
    }
  }
});

$(document).ready(function(){
  $( "[type='gps']" ).gps();
  $( "[type='gps']" ).gps("update");
});

