/**
 * Widget for storing an image
 */
$.widget( "custom.imageCapture", {

  _create: function() {
    var _widget = this;
    var _input = _widget.element.find('input');
    _input.hide();
    _widget.update();

    _widget.element.find('.ui-btn').click(function(e){

      if (typeof MozActivity != 'undefined') {
        var activity = new MozActivity({
          name: "pick",
          data: {
            type: "image/jpeg"
          }
        });

        activity.onsuccess = function() {
          _widget._blobToBase64(this.result.blob, function(base64) {
            _input.val(base64);
            _widget.update();
          });
        };

        activity.onerror = function() {
          console.log(this.error);
        };
      } else {
        console.warn("Your browser doesn't support image capture");
      }
    });

  },

  update: function() {
    var _widget = this;

    $( ".je-photo" ).each(function(i, elem) {
      var data = $(elem).find('input').val();

      if (data) {
        _widget._base64ToBlob(data, function(blob) {
          var img = document.createElement('img');
          img.style.width = '100%';
          img.style.height = 'auto';
          img.style.marginBottom = '1em';
          img.src = window.URL.createObjectURL(blob);
          $(elem).find('.preview').append(img);
        });
      }
    });
  },

  _blobToBase64: function(blob, cb) {
    var reader = new FileReader();
    reader.onload = function() {
      var dataUrl = reader.result;
      var base64 = dataUrl.split(',')[1];
      cb(base64);
    };
    reader.readAsDataURL(blob);
  },

  _base64ToBlob: function(base64, cb) {
    var binary = atob(base64);
    var len = binary.length;
    var buffer = new ArrayBuffer(len);
    var view = new Uint8Array(buffer);
    for (var i = 0; i < len; i++) {
      view[i] = binary.charCodeAt(i);
    }
    cb(new Blob([view]));
  }

});

$(document).ready(function(){
  $( ".je-photo" ).imageCapture();
});
